<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:38                                      */
/****************************************************************/

class sl_cechy_typ { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $sct_Id=0;
	public $sct_Nazwa='';
	public $Jezyk = 0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert INTO products_options (products_options_id,language_id,products_options_name,products_options_track_stock) VALUES(:sct_Id, :Jezyk, :sct_Nazwa, '1')";
		$sth = $this->Conn->prepare($query);
		
		$this->sct_Id = (int)$this->GetId();

		$sth->bindParam(':sct_Id', $this->sct_Id, PDO::PARAM_INT);
		$sth->bindParam(':Jezyk', $this->Jezyk, PDO::PARAM_INT);
		$sth->bindParam(':sct_Nazwa', $this->sct_Nazwa, PDO::PARAM_STR);
		$sth->execute();
		
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update products_options SET products_options_name=:sct_Nazwa Where sct_Id=:sct_Id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':sct_Nazwa', $this->sct_Nazwa, PDO::PARAM_STR);
		$sth->bindParam(':sct_Id', $this->sct_Id, PDO::PARAM_INT);
		
		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from products_options Where sct_Id=:sct_Id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':sct_Id', $this->sct_Id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from  products_options';
		$sth = $this->Conn->prepare($query);
		
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}	
	public function GetId(){
		$query='SELECT case when MAX(products_options_id) is not null then MAX(products_options_id)+1 else 1 end as Max FROM products_options';
		$sth = $this->Conn->prepare($query);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['Max'];
		}

		return $zwrot;
	}
	public function Sprawdz(){
		$query='SELECT products_options_id as sct_Id  FROM products_options Where language_id=:Jezyk and products_options_name=:sct_Nazwa';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':sct_Nazwa', $this->sct_Nazwa, PDO::PARAM_STR);
		$sth->bindParam(':Jezyk', $this->Jezyk, PDO::PARAM_INT);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['sct_Id'];
		}

		return $zwrot;
	}
	
}
?>
