<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:36                                      */
/****************************************************************/

class produkty_cecha { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $pc_Id=0;
	public $a_Id=0;
	public $s_Id=0;
	public $products_options_id=0;
	public $products_options_values_id=0;
	public $products_id = 0;
	public $options_id = 0;
	public $options_values_id = 0;
	public $ilosc=0;
	public $atrybuty =0;
	public $cena = 0;
	public $plusik = '+';

	public function DodajOptions(){
		$zwrot=true;
		$query="Insert INTO products_options_values_to_products_options (products_options_id, products_options_values_id) VALUES (:products_options_id,:products_options_values_id) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_options_id', $this->products_options_id, PDO::PARAM_INT);
		$sth->bindParam(':products_options_values_id', $this->products_options_values_id, PDO::PARAM_INT);
		$sth->execute();
		
		$this->pc_Id = $this->Conn->lastInsertId();


		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function GetPrice($_id)
	 {		
		$query="Select products_price as cena from products Where  products_id=:products_id";
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':products_id', $_id, PDO::PARAM_INT);
		
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['cena'];
		}

		return $zwrot;
	 }
	 public function DodajAtrybuty(){
		$zwrot=true;
		$query = "Insert INTO products_attributes (products_id, options_id, options_values_id, options_values_price, price_prefix) VALUES(:products_id, :options_id, :options_values_id, :cena, :plusik)";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':options_id', $this->options_id, PDO::PARAM_INT);
		$sth->bindParam(':options_values_id', $this->options_values_id, PDO::PARAM_INT);
		$sth->bindParam(':cena', $this->cena, PDO::PARAM_STR);
		$sth->bindParam(':plusik', $this->plusik, PDO::PARAM_STR);
		$sth->execute();
		
		$this->a_Id = $this->Conn->lastInsertId();


		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 }
	 public function ZmienAtrybuty(){
		$zwrot=true;
		$query = "Update products_attributes set  options_values_price=:cena, price_prefix=:plusik where products_attributes_id=:products_attributes_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_attributes_id', $this->a_Id, PDO::PARAM_INT);
		$sth->bindParam(':cena', $this->cena, PDO::PARAM_STR);
		$sth->bindParam(':plusik', $this->plusik, PDO::PARAM_STR);
		$sth->execute();
		
		$this->a_Id = $this->Conn->lastInsertId();


		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 }
	 public function DodajStock(){
		$zwrot=true;
		$query = "INSERT INTO  `products_stock` ( `products_id` ,  `products_stock_attributes` ,  `products_stock_quantity` ) VALUES ( :products_id,  :atrybuty,  :ilosc)";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':atrybuty', $this->atrybuty, PDO::PARAM_STR);
		$sth->bindParam(':ilosc', $this->ilosc, PDO::PARAM_STR);
		$sth->execute();
		
		$this->a_Id = $this->Conn->lastInsertId();


		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}
		else
		 {
			$this->UpdateStockProduktu();
		 }

		 return $zwrot;
	 }
	 public function UpdateStock(){
		$zwrot=true;
		$query = "Update`products_stock`  set `products_stock_quantity`=:ilosc Where products_stock_id=:products_stock_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_stock_id', $this->s_Id, PDO::PARAM_INT);
		$sth->bindParam(':ilosc', $this->ilosc, PDO::PARAM_STR);
		$sth->execute();
		
		$this->a_Id = $this->Conn->lastInsertId();


		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}
		else
		 {
			$this->UpdateStockProduktu();
		 }

		 return $zwrot;
	 }
	  public function UpdateStockProduktu(){
		$zwrot=true;
		$query = "Update `products` set `products_quantity`=(SELECT SUM(a.`products_stock_quantity`) FROM `products_stock` a WHERE a.`products_id`=:products_id), products_status=CASE WHEN(SELECT SUM(a.`products_stock_quantity`) FROM `products_stock` a WHERE a.`products_id`=:products_id)>0 THEN 1 ELSE 0 END Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_id',  $this->products_id, PDO::PARAM_INT);
		$sth->execute();		
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}
		

		 return $zwrot;
	 }
	public function ResetIlosc(){
		$zwrot=true;
		$query="Update products_stock set products_stock_quantity=0";
		$sth = $this->Conn->prepare($query);		
		$sth->execute();

		if($sth->errorCode() != 0)
		{
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public static function ResetIlosc2($_produkt, $_Conn){
		$zwrot=true;
		$query="Update products_stock set products_stock_quantity=0 Where products_id=:products_id";
		$sth = $_Conn->prepare($query);
		$sth->bindParam(':products_id', $_produkt, PDO::PARAM_INT);
		$sth->execute();

		if($sth->errorCode() != 0)
		{
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	
	
	public function Sprawdz()
	{
		$query="Select products_options_values_to_products_options_id as pc_Id from products_options_values_to_products_options Where  products_options_id=:products_options_id and  products_options_values_id=:products_options_values_id ";
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':products_options_id', $this->products_options_id, PDO::PARAM_INT);
		$sth->bindParam(':products_options_values_id', $this->products_options_values_id, PDO::PARAM_INT);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['pc_Id'];
		}

		return $zwrot;
	}
	public function SprawdzA()
	{
		$query="Select products_attributes_id as a_Id from products_attributes Where products_id=:Id and options_id=:options_id and options_values_id=:options_values_id ";
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':Id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':options_id', $this->options_id, PDO::PARAM_INT);
		$sth->bindParam(':options_values_id', $this->options_values_id, PDO::PARAM_INT);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['a_Id'];
		}

		return $zwrot;
	}
	public function SprawdzS()
	{
		$query="Select products_stock_id as s_Id from products_stock Where products_id=:Id and products_stock_attributes=:atrybuty ";
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':Id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':atrybuty', $this->atrybuty, PDO::PARAM_STR);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['s_Id'];
		}

		return $zwrot;
	}

}
?>
