<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:33                                      */
/****************************************************************/

class products { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $products_id=0;
	public $products_quantity=0;
	public $products_model=0;
	public $products_image='brak_obrazka.jpg';
	public $products_image2='brak_obrazka.jpg';
	public $products_price=0;
	public $products_retail_price=0;
	public $products_date_added=0;
	public $products_last_modified=0;
	public $products_date_available=NULL;
	public $products_weight=0;
	public $products_status=0;
	public $products_tax_class_id=0;
	public $manufacturers_id=0;
	public $products_ordered=0;
	public $emo_paczka = '';
	public $emo_nrdostawcy= '';
	public $emo_dostawca = '';
	public $emo_kreskowy= '';
	public $emo_uwagi= '';
	public $products_jm_id= 0;
	public $products_ebook = 0;
	public $availability_id = NULL;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert products (products_quantity, products_model, products_image, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, manufacturers_id, products_ordered, emo_paczka, emo_dostawca, emo_kreskowy, emo_nrdostawcy, emo_uwagi, products_adminnotes, products_jm_id) VALUES (:products_quantity, :products_model, :products_image, :products_price, :products_retail_price, :products_date_added, :products_last_modified, :products_date_available, :products_weight, :products_status, :products_tax_class_id, :manufacturers_id, :products_ordered, :emo_paczka, :emo_dostawca, :emo_kreskowy, :emo_nrdostawcy, :emo_uwagi, :products_adminnotes, :products_jm_id) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_quantity', $this->products_quantity, PDO::PARAM_INT);
		$sth->bindParam(':products_model', $this->products_model, PDO::PARAM_STR);
		$sth->bindParam(':products_image', $this->products_image, PDO::PARAM_STR);
		$sth->bindParam(':products_price', $this->products_price, PDO::PARAM_STR);
		$sth->bindParam(':products_retail_price', $this->products_retail_price, PDO::PARAM_STR);
		$sth->bindParam(':products_date_added', $this->products_date_added, PDO::PARAM_STR);
		$sth->bindParam(':products_last_modified', $this->products_last_modified, PDO::PARAM_STR);
		$sth->bindParam(':products_date_available', $this->products_date_available, PDO::PARAM_STR);
		$sth->bindParam(':products_weight', $this->products_weight, PDO::PARAM_STR);
		$sth->bindParam(':products_status', $this->products_status, PDO::PARAM_INT);
		$sth->bindParam(':products_tax_class_id', $this->products_tax_class_id, PDO::PARAM_INT);
		$sth->bindParam(':manufacturers_id', $this->manufacturers_id, PDO::PARAM_INT);
		$sth->bindParam(':products_ordered', $this->products_ordered, PDO::PARAM_INT);
		$sth->bindParam(':emo_paczka', $this->emo_paczka, PDO::PARAM_STR);
		$sth->bindParam(':emo_dostawca', $this->emo_dostawca, PDO::PARAM_STR);
		$sth->bindParam(':emo_kreskowy', $this->emo_kreskowy, PDO::PARAM_STR);
		$sth->bindParam(':emo_nrdostawcy', $this->emo_nrdostawcy, PDO::PARAM_STR);
		$sth->bindParam(':emo_uwagi', $this->emo_uwagi, PDO::PARAM_STR);
		$sth->bindParam(':products_adminnotes', $this->emo_uwagi, PDO::PARAM_STR);
		$sth->bindParam(':products_jm_id', $this->products_jm_id, PDO::PARAM_INT);
		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update products SET emo_paczka=:emo_paczka, products_quantity=:products_quantity, products_model=:products_model, products_price=:products_price, products_retail_price=:products_retail_price, products_last_modified=:products_last_modified, products_date_available=:products_date_available, products_weight=:products_weight, products_status=:products_status, products_tax_class_id=:products_tax_class_id, manufacturers_id=:manufacturers_id, emo_dostawca=:emo_dostawca, emo_kreskowy=:emo_kreskowy, emo_nrdostawcy=:emo_nrdostawcy, emo_uwagi=:emo_uwagi, products_adminnotes=:products_adminnotes, products_jm_id=:products_jm_id Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_quantity', $this->products_quantity, PDO::PARAM_INT);
		$sth->bindParam(':products_model', $this->products_model, PDO::PARAM_STR);		
		$sth->bindParam(':products_price', $this->products_price, PDO::PARAM_STR);
		$sth->bindParam(':products_retail_price', $this->products_retail_price, PDO::PARAM_STR);		
		$sth->bindParam(':products_last_modified', $this->products_last_modified, PDO::PARAM_STR);
		$sth->bindParam(':products_date_available', $this->products_date_available, PDO::PARAM_STR);
		$sth->bindParam(':products_weight', $this->products_weight, PDO::PARAM_STR);
		$sth->bindParam(':products_status', $this->products_status, PDO::PARAM_INT);
		$sth->bindParam(':products_tax_class_id', $this->products_tax_class_id, PDO::PARAM_INT);
		$sth->bindParam(':manufacturers_id', $this->manufacturers_id, PDO::PARAM_INT);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':emo_paczka', $this->emo_paczka, PDO::PARAM_STR);
		$sth->bindParam(':emo_dostawca', $this->emo_dostawca, PDO::PARAM_STR);
		$sth->bindParam(':emo_kreskowy', $this->emo_kreskowy, PDO::PARAM_STR);
		$sth->bindParam(':emo_nrdostawcy', $this->emo_nrdostawcy, PDO::PARAM_STR);
		$sth->bindParam(':emo_uwagi', $this->emo_uwagi, PDO::PARAM_STR);
		$sth->bindParam(':products_adminnotes', $this->emo_uwagi, PDO::PARAM_STR);
		$sth->bindParam(':products_jm_id', $this->products_jm_id, PDO::PARAM_INT);
		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function ZmienSzybko(){
		$zwrot=true;
		$query="Update products SET emo_paczka=:emo_paczka, products_quantity=:products_quantity, products_price=:products_price, products_retail_price=:products_retail_price,  products_last_modified=:products_last_modified, products_status=:products_status Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':products_quantity', $this->products_quantity, PDO::PARAM_INT);
		$sth->bindParam(':products_price', $this->products_price, PDO::PARAM_STR);
		$sth->bindParam(':products_retail_price', $this->products_retail_price, PDO::PARAM_STR);
		$sth->bindParam(':products_last_modified', $this->products_last_modified, PDO::PARAM_STR);
		$sth->bindParam(':products_status', $this->products_status, PDO::PARAM_INT);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':emo_paczka', $this->emo_paczka, PDO::PARAM_STR);
		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function ZmienUkryj($_paczka){
		$zwrot=true;
		$query="Update products SET products_status=0, products_quantity=0  Where emo_paczka<>:emo_paczka or emo_paczka is null";
		$sth = $this->Conn->prepare($query);		
		$sth->bindParam(':emo_paczka', $_paczka, PDO::PARAM_STR);
		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function ZmienObrazek(){
		$zwrot=true;
		$query="Update products SET products_image=:products_image Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);
		
		$sth->bindParam(':products_image', $this->products_image, PDO::PARAM_STR);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);

		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	  public function ZmienObrazek2(){
		$zwrot=true;
		$query="INSERT INTO `additional_images` ( `additional_images_id` , `products_id` , `images_description` , `medium_images` , `popup_images` ) VALUES (NULL , :products_id, '', :products_image2, :products_image);";
		$sth = $this->Conn->prepare($query);
		
		$sth->bindParam(':products_image', $this->products_image, PDO::PARAM_STR);
		$sth->bindParam(':products_image2', $this->products_image2, PDO::PARAM_STR);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);

		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function UsunDodatkoweObrazki(){
		$zwrot=true;
		$query="Delete from `additional_images` Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);		
		
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);

		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from products Where products_id=:products_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from products';
		$sth = $this->Conn->prepare($query);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}
	public function ListaXML($_jezyk, $_od){
		
		$query='Select  a.products_id, a.products_model, a.products_image, a.products_price, a.products_weight, a.products_status, b.products_name, b.products_description, c.manufacturers_name, e.tax_rate,  IFNULL((select d.categories_id from products_to_categories d Where d.products_id=a.products_id Limit 1),0) as Kategoria from products a Left JOIN products_description b on (a.products_id=b.products_id and b.language_id=:Jezyk) Left JOIN manufacturers c on (c.manufacturers_id=a.manufacturers_id) Left JOIN tax_rates  e on (e.tax_class_id=a.products_tax_class_id) Limit '.$_od.',200';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':Jezyk', $_jezyk, PDO::PARAM_INT);
		$sth->execute();
		$zwrot = '';
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			
			$zwrot .= '<produkt ';
			foreach ($row as $k => $v)
			{
				$wartosc = empty($v) ? "0" : htmlspecialchars(trim($v), ENT_QUOTES);
				$zwrot .= $k.'="'.$wartosc.'" ';
			}

			$zwrot .=' />';
			
		}

		return $zwrot;
	}
	public function ListaXMLFull($_jezyk, $_od){
		
		$query='Select  a.products_id, a.products_model, a.products_image, a.products_price, a.products_weight, a.products_status, b.products_name, b.products_description, c.manufacturers_name, e.tax_rate,  IFNULL((select d.categories_id from products_to_categories d Where d.products_id=a.products_id Limit 1),0) as Kategoria, jm.products_jm_name as JM from products a Left JOIN products_description b on (a.products_id=b.products_id and b.language_id=:Jezyk) Left JOIN manufacturers c on (c.manufacturers_id=a.manufacturers_id) Left JOIN tax_rates  e on (e.tax_class_id=a.products_tax_class_id) LEFT JOIN products_jm jm ON (jm.products_jm_id=a.products_jm_id AND jm.language_id=:Jezyk) Limit '.$_od.',200';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':Jezyk', $_jezyk, PDO::PARAM_INT);
		$sth->execute();
		$zwrot = '';
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			
			$zwrot .= '<produkt ';
			foreach ($row as $k => $v)
			{
				$wartosc = empty($v) ? "0" : htmlspecialchars(trim($v), ENT_QUOTES);
				$zwrot .= $k.'="'.$wartosc.'" ';
			}

			$zwrot .=' />';
			$zwrot .= '<rozmiary produkt="'.$row['products_id'].'">';
			
			//$query2='SELECT c.sct_Nazwa as cecha, b.c_Nazwa as wartosc, e.sct_Nazwa as cecha2, d.c_Nazwa as wartosc2  FROM produkty_cecha a Inner JOIN sl_cechy b on (b.c_Id=a.pc_Cecha1) Inner JOIN sl_cechy_typ c on (c.sct_Id=b.c_Typ) Inner JOIN sl_cechy d on (d.c_Id=a.pc_Cecha2) Inner JOIN sl_cechy_typ e on (e.sct_Id=d.c_Typ) Where pc_Produkt=:Produkt';
			
			$query3='SELECT options_id FROM  `products_attributes` WHERE  `products_id` =:Produkt GROUP BY options_id';
			$sth3 = $this->Conn->prepare($query3);			
			$sth3->bindParam(':Produkt', $row['products_id'], PDO::PARAM_INT);	
			$sth3->execute();
			$roz = array();
			$iz = 0;

			while ($row3 = $sth3->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
			{
				$roz[$iz] = $row3['options_id'];
				$iz++;
			}
			
			if($iz>0)
			{
				$query2='SELECT a.price_prefix as prefix, b.products_options_name as cecha, c.products_options_values_name as wartosc, a.options_values_price as cena FROM  products_attributes a Inner JOIN  products_options b on (b.products_options_id=a.options_id and b.language_id=:Jezyk) Inner JOIN  products_options_values c on (c.products_options_values_id=a.options_values_id and c.language_id=:Jezyk) Where a.products_id=:Produkt and a.options_id=:Options';
				$sth2 = $this->Conn->prepare($query2);			
				$sth2->bindParam(':Produkt', $row['products_id'], PDO::PARAM_INT);	
				$sth2->bindParam(':Jezyk', $_jezyk, PDO::PARAM_INT);
				$sth2->bindParam(':Options', $roz[0], PDO::PARAM_INT);
				$sth2->execute();
				$z=0;
				while ($row2 = $sth2->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
				{						
					$query4='SELECT a.price_prefix as prefix2, b.products_options_name as cecha2, c.products_options_values_name as wartosc2, a.options_values_price as cena2 FROM  products_attributes a Inner JOIN  products_options b on (b.products_options_id=a.options_id and b.language_id=:Jezyk) Inner JOIN  products_options_values c on (c.products_options_values_id=a.options_values_id and c.language_id=:Jezyk) Where a.products_id=:Produkt and a.options_id=:Options';
					$sth4 = $this->Conn->prepare($query4);			
					$sth4->bindParam(':Produkt', $row['products_id'], PDO::PARAM_INT);	
					$sth4->bindParam(':Jezyk', $_jezyk, PDO::PARAM_INT);
					$sth4->bindParam(':Options', $roz[1], PDO::PARAM_INT);
					$sth4->execute();
					$z=0;
					$drugiR = false;
					while ($row4 = $sth4->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
					{	
						$drugiR = true;
						$zwrot .= '<rozmiar ';	
						foreach ($row2 as $k => $v)
						{
							$zwrot .= $k.'="'.htmlspecialchars(trim($v), ENT_QUOTES).'" ';
						}
						foreach ($row4 as $k2 => $v2)
						{
							$zwrot .= $k2.'="'.htmlspecialchars(trim($v2), ENT_QUOTES).'" ';							
						}	
						$zwrot .=' />';
					}				
					
					if(!$drugiR)
					{
						$zwrot .= '<rozmiar ';	
						foreach ($row2 as $k => $v)
						{
							$zwrot .= $k.'="'.htmlspecialchars(trim($v), ENT_QUOTES).'" ';							
						}	

						$zwrot .=' cecha2="" wartosc2="" cena2="0" prefix2="+"';
						$zwrot .=' />';
					}		
					
				}		
			}
			$zwrot .= '</rozmiary>';
			
		}

		return $zwrot;
	}
	
	public function ListaXML2($_jezyk, $_od ){
		
		$query='Select a.products_model, products_id as id from products a Limit '.$_od.',200';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':Jezyk', $_jezyk, PDO::PARAM_INT);
		$sth->execute();
		$zwrot = '';
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			
			$zwrot .= '<produkt ';
			foreach ($row as $k => $v)
			{
				$zwrot .= $k.'="'.htmlspecialchars(trim($v), ENT_QUOTES).'" ';
			}

			$zwrot .=' />';
			
		}

		return $zwrot;
	}
	public function Sprawdz(){
		$zwrot=0;
		$query='Select products_id from products Where products_model=:products_model';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':products_model', $this->products_model, PDO::PARAM_STR);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['products_id'];			
		}

		return $zwrot;
	}
	public static function Szukaj($_symbol, $_Conn){
		$zwrot=0;
		$query='Select products_id from products Where products_model=:products_model';
		$sth = $_Conn->prepare($query);
		$sth->bindParam(':products_model', $_symbol, PDO::PARAM_STR);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=$row['products_id'];			
		}

		return $zwrot;
	}
	public function ListaXML3($_od){
		
		$query='SELECT a.products_model as products_model, a.products_image as sciezka, \'1\' as domyslne FROM products a WHERE  a.products_image is not null and LENGTH(a.products_image) > 0 UNION SELECT a.products_model as products_model, b.popup_images as sciezka, \'0\' as domyslne FROM additional_images b, products a  WHERE b.products_id=a.products_id Limit '.$_od.',200';
		$sth = $this->Conn->prepare($query);		
		$sth->execute();
		$zwrot = '';
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			
			$zwrot .= '<zdjecie ';
			foreach ($row as $k => $v)
			{
				$zwrot .= $k.'="'.htmlspecialchars(trim($v), ENT_QUOTES).'" ';
			}

			$zwrot .=' />';
			
		}

		return $zwrot;
	}
	public function ListaIle2(){
		
		$query='Select Count(*) as Ile FROM products a WHERE  a.products_image is not null and LENGTH(a.products_image) > 0 UNION SELECT Count(*) as Ile FROM additional_images b, products a  WHERE b.products_id=a.products_id'; 
		
		//from products a Where  a.products_image is not null and  LENGTH(a.products_image) > 0';
		$sth = $this->Conn->prepare($query);		
		$sth->execute();

		$zwrot = 0;	
		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot += (int)ceil($row['Ile']);
		}

		return $zwrot;
	}
	public function ListaIle(){
		
		$query='Select Count(*) as Ile from products';
		$sth = $this->Conn->prepare($query);		
		$sth->execute();

		$zwrot = 0;	
		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$zwrot=ceil($row['Ile']);
		}

		return $zwrot;
	}
	public static function Check($_Conn)
	{
		$zwrot=false;
		$i=0;
		$query="SHOW COLUMNS FROM products like '%ebook%'";
		$sth = $_Conn->prepare($query);
		$sth->execute();
		
		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			$i++;
		}
		
		if($i > 0)
			$zwrot = true;
		
		return $zwrot;
	}
	public function Ebook()
	{
		$zwrot=true;
		$query="Update products SET ebook=:products_ebook Where products_id=:products_id";
		$sth = $this->Conn->prepare($query);
		
		$sth->bindParam(':products_ebook', $this->products_ebook, PDO::PARAM_INT);
		$sth->execute();
		
		if($sth->errorCode() != 0)
		{
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		return $zwrot;
	}
}
?>
