<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:32                                      */
/****************************************************************/


class parametry { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $id=0;
	public $wartoscId=0;
	public $Nazwa='';
	public $Wartosc='';
	public $Jezyk=1;
	public $Produkt=0;
	public $prefiks = 'ps_';
	
	public function Dodaj()
	{
		$zwrot=true;			
		$query='INSERT INTO  products_extra_fields (products_extra_fields_name, products_extra_fields_order, products_extra_fields_status, languages_id ) VALUES (:name, 0, 1, :id_lang)';
		
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':id_lang', $this->Jezyk, PDO::PARAM_INT);
		$sth->bindParam(':name', $this->Nazwa, PDO::PARAM_STR);
		$sth->execute();

		$this->id = $this->Conn->lastInsertId();
		if($sth->errorCode() != 0)
		{
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}
		
		 return $zwrot;
	 } 
	 
	 public function DodajWartosc(){
		$zwrot=true;
		

			$this->wartoscId = $this->Conn->lastInsertId();
			$query='INSERT INTO  products_to_products_extra_fields ( products_id, products_extra_fields_id, products_extra_fields_value ) VALUES (:products_id, :products_extra_fields_id, :value)';
			
			$sth = $this->Conn->prepare($query);
			$sth->bindParam(':products_id', $this->Produkt, PDO::PARAM_INT);
			$sth->bindParam(':products_extra_fields_id', $this->id, PDO::PARAM_INT);
			$sth->bindParam(':value', $this->Wartosc, PDO::PARAM_STR);

			$sth->execute();

			if($sth->errorCode() != 0){
				$zwrot=false;
				$this->errMsg = $sth->errorInfo();
				$this->errNo = $sth->errorCode();
			}
		
		 return $zwrot;
	 } 
	public function UsunWartosc()
	{
		$zwrot = true;
		$query='Delete from products_to_products_extra_fields Where products_extra_fields_id=:id and products_id=:produkt';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':produkt',$this->Produkt, PDO::PARAM_INT);
		$sth->bindParam(':id', $this->id, PDO::PARAM_INT);
		$sth->execute();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}
		
		 return $zwrot;
	}
	public function Szukaj($_nazwa)
	{
		$query='Select products_extra_fields_id from products_extra_fields Where products_extra_fields_name=:name and languages_id=:lang';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':name', $_nazwa, PDO::PARAM_STR);
		$sth->bindParam(':lang', $this->Jezyk, PDO::PARAM_INT);
		$sth->execute();
		$zwrot = 0;		

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=trim($row['products_extra_fields_id']);			
		}

		return $zwrot;
	}
	public function SzukajWartosc($_wartosc)
	{
		$query='Select products_id from products_to_products_extra_fields Where products_id=:products_id  and products_extra_fields_id=:products_extra_fields_id and products_extra_fields_value=:value';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':value', $_wartosc, PDO::PARAM_STR);
		$sth->bindParam(':products_id', $this->Produkt, PDO::PARAM_INT);
		$sth->bindParam(':products_extra_fields_id', $this->id, PDO::PARAM_INT);
		$sth->execute();
		$zwrot = 0;		
	
		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=trim($row['products_id']);			
		}

		return $zwrot;
	}
	
		
		
}

?>
