<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:27                                      */
/****************************************************************/

class manufacturers { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $manufacturers_id=0;
	public $manufacturers_name=0;
	public $manufacturers_image=0;
	public $date_added=0;
	public $last_modified=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert manufacturers (manufacturers_name, manufacturers_image, date_added, last_modified) VALUES (:manufacturers_name, :manufacturers_image, :date_added, :last_modified) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':manufacturers_name', $this->manufacturers_name, PDO::PARAM_STR);
		$sth->bindParam(':manufacturers_image', $this->manufacturers_image, PDO::PARAM_STR);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update manufacturers SET manufacturers_name=:manufacturers_name, manufacturers_image=:manufacturers_image, date_added=:date_added, last_modified=:last_modified Where manufacturers_id=:manufacturers_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':manufacturers_name', $this->manufacturers_name, PDO::PARAM_STR);
		$sth->bindParam(':manufacturers_image', $this->manufacturers_image, PDO::PARAM_STR);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);
		$sth->bindParam(':manufacturers_id', $this->manufacturers_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from manufacturers Where manufacturers_id=:manufacturers_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':manufacturers_id', $this->manufacturers_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from manufacturers';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':manufacturers_name', $this->manufacturers_name, PDO::PARAM_STR);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}
	public static function Szukaj($_name, $_Conn){
		$query='Select manufacturers_id from manufacturers Where manufacturers_name=:manufacturers_name';
		$sth = $_Conn->prepare($query);
		$sth->bindParam(':manufacturers_name', $_name, PDO::PARAM_STR);
		$sth->execute();
		$zwrot = 0;		

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=trim($row['manufacturers_id']);			
		}

		return $zwrot;
	}


}
?>
