<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:21                                      */
/****************************************************************/


class categories { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $categories_id=0;
	public $categories_image='';
	public $parent_id=0;
	public $sort_order=0;
	public $date_added=0;
	public $last_modified=0;
	public $action=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert categories (categories_image, parent_id, sort_order, date_added, last_modified, action) VALUES (:categories_image, :parent_id, :sort_order, :date_added, :last_modified, :action) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':categories_image', $this->categories_image, PDO::PARAM_STR);
		$sth->bindParam(':parent_id', $this->parent_id, PDO::PARAM_INT);
		$sth->bindParam(':sort_order', $this->sort_order, PDO::PARAM_INT);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);
		$sth->bindParam(':action', $this->action, PDO::PARAM_STR);

		$sth->execute();
		$this->categories_id = $this->Conn->lastInsertId();
		
		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update categories SET categories_image=:categories_image, parent_id=:parent_id, sort_order=:sort_order, date_added=:date_added, last_modified=:last_modified Where categories_id=:categories_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':categories_image', $this->categories_image, PDO::PARAM_STR);
		$sth->bindParam(':parent_id', $this->parent_id, PDO::PARAM_INT);
		$sth->bindParam(':sort_order', $this->sort_order, PDO::PARAM_INT);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);
		$sth->bindParam(':categories_id', $this->categories_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	 public function SetMapa()
	 {
		$zwrot=true;
		$query="Update categories SET action=:action Where categories_id=:categories_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':action', $this->action, PDO::PARAM_STR);
		$sth->bindParam(':categories_id', $this->categories_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from categories Where categories_id=:categories_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':categories_id', $this->categories_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista($_lang){
		$query='Select * from categories a Left JOIN categories_description b  on (a.categories_id=b.categories_id) Where language_id=:language_id';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':language_id', $_lang, PDO::PARAM_INT);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]= empty($v) ? "0" : htmlspecialchars(trim($v), ENT_QUOTES);
			}
			$x++;
		}

		return $tablica;
	}
	public function Rekurencja($_id, $_x){
		$query='Select categories_id, parent_id from categories Where categories_id=:parent_id';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':parent_id', $_id, PDO::PARAM_INT);
		$sth->execute();
		

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{	
			//print_r($row);
			if($row['parent_id']!=0)
			{
				$this->Rekurencja($row['parent_id'], $_x);
			}
			$_x++;
			
		}
	
		return $_x;
	}
	public function GetAction(){
		$query='Select categories_id from categories Where action=:action';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':action', $this->action, PDO::PARAM_STR);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{	
			$zwrot = $row['categories_id'];			
		}
	
		return $zwrot;
	}
	


}
?>
