<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

 class pocztex {
   var $code, $title, $description, $enabled, $num_pocztex;

// class constructor
   function pocztex() {
     global $order;
     $this->code = 'pocztex';
     $this->title = MODULE_SHIPPING_POCZTEX_TEXT_TITLE;
     $this->description = MODULE_SHIPPING_POCZTEX_TEXT_DESCRIPTION;
     $this->sort_order = MODULE_SHIPPING_POCZTEX_SORT_ORDER;
     $this->icon = '';
     $this->tax_class = MODULE_SHIPPING_POCZTEX_TAX_CLASS;
     $this->enabled = ((MODULE_SHIPPING_POCZTEX_STATUS == 'True') ? true : false);

     // CUSTOMIZE THIS SETTING FOR THE NUMBER OF ZONES NEEDED
	 
      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_POCZTEX_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_POCZTEX_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }	 
   $this->num_pocztex = 6;
   }


// class methods
   function quote($method = '') {
     global $order, $shipping_weight, $shipping_num_boxes;

     $dest_country = $order->delivery['country']['iso_code_2'];
     $dest_zone = 0;
     $error = false;

     for ($i=1; $i<=$this->num_pocztex; $i++) {
       $countries_table = str_replace(' ','',constant('MODULE_SHIPPING_POCZTEX_COUNTRIES_' . $i));
       $country_pocztex = split("[;]", $countries_table);
       if (in_array($dest_country, $country_pocztex)) {
         $dest_zone = $i;
         break;
       }
     }

     // elari - Added to select default country if not in listing      
     if ($dest_zone == 0) {
       $dest_zone = $this->num_pocztex;    // the zone is the lastest zone avalaible
     }
     // elari - Added to select default country if not in listing
     if ($dest_zone == 0) {
       $error = true;      // this can no more achieve since by default the value is set to the max number of zones
     } else {
       $shipping = -1;
       $pocztex_cost = constant('MODULE_SHIPPING_POCZTEX_COST_' . $dest_zone);
       $pocztex_table = split("[:,]" , $pocztex_cost);
       $size = sizeof($pocztex_table);
       for ($i=0; $i<$size; $i+=2) {
         if ($shipping_weight <= $pocztex_table[$i]) {
           $shipping = $pocztex_table[$i+1];
           $shipping_method = MODULE_SHIPPING_POCZTEX_TEXT_WAY . ' ' . $order->delivery['country']['title'] . ': ';
           if ($shipping_num_boxes > 1) {
             $shipping_method .= $shipping_num_boxes . 'x ';
           }
           $shipping_method .= $shipping_weight . ' ' . MODULE_SHIPPING_POCZTEX_TEXT_UNITS;
           break;
         }
       }

       if ($shipping == -1) {
         $shipping_cost = 0;
         $shipping_method = MODULE_SHIPPING_POCZTEX_UNDEFINED_RATE;
		 $brak_mozliwosci = true;
       } else {
         $shipping_cost = ($shipping * $shipping_num_boxes) + constant('MODULE_SHIPPING_POCZTEX_HANDLING_' . $dest_zone);
		 $brak_mozliwosci = false;
       }
     }

     $this->quotes = array('id' => $this->code,
                           'module' => MODULE_SHIPPING_POCZTEX_TEXT_TITLE,
                           'methods' => array(array('id' => $this->code,
                                                    'title' => $shipping_method,
                                                    'cost' => $shipping_cost)));
     if ($this->tax_class > 0) {
       $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
     }

     if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);
     if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_POCZTEX_INVALID_ZONE;
	 if (MODULE_SHIPPING_POCZTEX_OFF == 'False' && $brak_mozliwosci == true) {
		 return;
	   } else { 
		return $this->quotes;
     }	
   }

   function check() {
     if (!isset($this->_check)) {
       $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_POCZTEX_STATUS'");
       $this->_check = tep_db_num_rows($check_query);
     }
     return $this->_check;
   }

   // elari - Added to select default country if not in listing

   function install() {
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Włączenie modułu', 'MODULE_SHIPPING_POCZTEX_STATUS', 'True', 'Czy włączyć moduł Przesyłka EMS Pocztex ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Grupa VAT', 'MODULE_SHIPPING_POCZTEX_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Strefa dostawy', 'MODULE_SHIPPING_POCZTEX_ZONE', '0', 'Wybierz strefę, dla której ma być stosowany ten sposob dostawy', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");	 
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sortowanie', 'MODULE_SHIPPING_POCZTEX_SORT_ORDER', '0', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', now())");
     //tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Koszt Pobrania', 'MODULE_SHIPPING_POCZTEX_KOSZT_POBRANIA', '6', 'Dodatkowy koszt wysyłki gdy za pobraniem (tylko obszar Polski).', '6', '0', now())");
	 tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Jeżeli nie można określić kosztów wysyłki ?', 'MODULE_SHIPPING_PRZESYLKA_POCZTEX_OFF', 'False', 'Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");		 
     for ($i = 1; $i <= $this->num_pocztex; $i++) {
        $default_countries = '';
       if ($i == 1) {        
         $strefa = '<span style=color:ff0000>Polska</span>';
         $default_countries = 'PL'; ///przesylka PRIORYTETOWA krajowa
         $shipping_table = '0.5:25,1:30,5:35,2:10:40, 15:45,20:55,50:100';
       }
       if ($i == 2) {
         $strefa = '<span style=color:ff0000>A</span>';
         $default_countries = 'AL;AD;AT;BE;BY;BG;HR;CY; CZ;DK;EE;FI;FR;GI;GR;ES;NL;IE;IS; IL;LI;LT;LU;LV;MK;MT;MD;MC;DE;NO;FO; PT;RU;RO;SM;SK;SI;CH;SE;TR;UA;VA;HU;GB;IT'; // strefa A1
         $shipping_table = '0.5:122,1.0:126,2.0:130,3.0:134,4.0:138, 5.0:142,6.0:146,7.0:150,8.0:154,9.0:158, 10.0:164,11.0:170,12.0:180,13.0:190,14.0:200, 15.0:210,16.0:220,17.0:230,18.0:240,19.0:250,20.0:260';
       }
       if ($i == 3) {
         $strefa = '<span style=color:ff0000>B</span>';
         $default_countries = 'DZ;BJ;BM;BF;TD;VI;DJ;EG;ET; GM;GH;GL;GU;GN;GW;CA;KE;CG;CD; LR;MW;ML;MP;MA;MU;MX;NE;NG;ZA; AS;SN;SC;SL;US;CF;TZ;TG;TN;UG;CI;ZM;CV;ZW'; // strefa A2
         $shipping_table = '0.5:124,1.0:134,2.0:144,3.0:156,4.0:174, 5.0:192,6.0:210,7.0:228,8.0:246,9.0:264, 10.0:294,11.0:318,12.0:345,13.0:372,14.0:399, 15.0:426,16.0:453,17.0:480,18.0:507,19.0:534,20.0:561';
       }
       if ($i == 4) {
         $strefa = '<span style=color:ff0000>C</span>';
         $default_countries = 'AI;AN;SA;AR;AM;AW;AZ;BS;BH;BD;BB; BT;BO;BR;BN;CL;CN;EC;PH;GE;GY;HK;IN; ID;IQ;IR;JP;JO;KY;QA;KZ;KG;CO;KP; CU;KW;MO;MV;MY;OM;PK;PA;PE; SG;LK;SY;TJ;TH;TW;TT;TM;UY;VN;AE'; //strefa A3
         $shipping_table = '0.5:126,1.0:150,2.0:174,3.0:198,4.0:222, 5.0:246,6.0:270,7.0:294,8.0:318,9.0:342, 10.0:366,11.0:390,12.0:414,13.0:438,14.0:462, 15.0:486,16.0:510,17.0:534,18.0:558,19.0:582,20.0:606';
       }
       if ($i == 5) {
        $strefa = '<span style=color:ff0000>D</span>';
        $default_countries = 'AU;NZ;SB;VU'; //strefa A4
         $shipping_table = '0.5:150,1.0:192,2.0:240,3.0:288,4.0:300, 5.0:348,6.0:408,7.0:456,8.0:504,9.0:540, 10.0:588,11.0:636,12.0:660,13.0:696,14.0:715, 15.0:770,16.0:800,17.0:820,18.0:845,19.0:880,20.0:915';
       }
       if ($i == 6) {
        $strefa = '<span style=color:ff0000>E</span>';
        $default_countries = 'BW;DM;FJ;GA;GD;GT;GQ;HN;JM;CM;CR; LS;MG;MR;MZ;NA;NI;NC;PG;PY;SV;SD;SR;VE'; //strefa A5
         $shipping_table = '0.5:150,1.0:200,2.0:250,3.0:300,4.0:350, 5.0:400,6.0:450,7.0:500,8.0:550,9.0:600, 10.0:650,11.0:700,12.0:750,13.0:800,14.0:850, 15.0:900,16.0:950,17.0:1000,18.0:1050,19.0:1100,20.0:1150';
       }
	   
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kraje strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_POCZTEX_COUNTRIES_" . $i ."', '" . $default_countries . "', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach strafy " . $strefa . ".', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Tablica kosztów strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_POCZTEX_COST_" . $i ."', '" . $shipping_table . "', 'Koszty przesyłki dla strefy " . $strefa . " bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Dodatkowy stały koszt obsługi wysyłki do strefy " . $strefa ."', 'MODULE_SHIPPING_POCZTEX_HANDLING_" . $i ."', '0', 'Dodatkowy stały koszt obsługi wysyłki dla strefy', '6', '0', now())");
     }
   }

   // elari - Added to select default country if not in listing
   function remove() {
     tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
   }

   function keys() {
     //$keys = array('MODULE_SHIPPING_POCZTEX_STATUS', 'MODULE_SHIPPING_POCZTEX_TAX_CLASS', 'MODULE_SHIPPING_POCZTEX_SORT_ORDER','MODULE_SHIPPING_POCZTEX_KOSZT_POBRANIA');
     $keys = array('MODULE_SHIPPING_POCZTEX_STATUS', 'MODULE_SHIPPING_POCZTEX_TAX_CLASS', 'MODULE_SHIPPING_POCZTEX_SORT_ORDER','MODULE_SHIPPING_POCZTEX_ZONE','MODULE_SHIPPING_PRZESYLKA_POCZTEX_OFF');

     for ($i=1; $i<=$this->num_pocztex; $i++) {
       $keys[] = 'MODULE_SHIPPING_POCZTEX_COUNTRIES_' . $i;
       $keys[] = 'MODULE_SHIPPING_POCZTEX_COST_' . $i;
       $keys[] = 'MODULE_SHIPPING_POCZTEX_HANDLING_' . $i;
     }

     return $keys;
   }
 }

?>