<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

 class pocztapriwpobr {
   var $code, $title, $description, $enabled, $num_pocztapriwpobr;

// class constructor
   function pocztapriwpobr() {
     global $order;     
     $this->code = 'pocztapriwpobr';
     $this->title = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TEXT_TITLE;
     $this->description = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TEXT_DESCRIPTION;
     $this->sort_order = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_SORT_ORDER;
     $this->icon = '';
     $this->tax_class = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TAX_CLASS;
     $this->enabled = ((MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_STATUS == 'True') ? true : false);

     // CUSTOMIZE THIS SETTING FOR THE NUMBER OF ZONES NEEDED
	 
      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }	 
	  
     $this->num_pocztapriwpobr = 1;
   }

// class methods
  function quote($method = '') {
     global $order, $shipping_weight, $shipping_num_boxes, $cart, $currencies;

     $dest_country = $order->delivery['country']['iso_code_2'];
     $dest_zone = 0;
     $error = false;


     for ($i=1; $i<=$this->num_pocztapriwpobr; $i++) {
       $countries_table = str_replace(' ','',constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COUNTRIES_' . $i));
       $country_pocztapriwpobr = split("[;]", $countries_table);
       if (in_array($dest_country, $country_pocztapriwpobr)) {
         $dest_zone = $i;
         break;
       }
     }

     // elari - Added to select default country if not in listing      
     if ($dest_zone == 0) {
       $dest_zone = $this->num_pocztapriwpobr;    // the zone is the lastest zone avalaible
     }
     // elari - Added to select default country if not in listing
     if ($dest_zone == 0) {
       $error = true;      // this can no more achieve since by default the value is set to the max number of zones
     } else {
       $shipping = -1;
       $pocztapriwpobr_cost = constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COST_' . $dest_zone);
       $pocztapriwpobr_table = split("[:,]" , $pocztapriwpobr_cost);
       $size = sizeof($pocztapriwpobr_table);
       for ($i=0; $i<$size; $i+=2) {
         if ($shipping_weight <= $pocztapriwpobr_table[$i]) {
           $shipping = $pocztapriwpobr_table[$i+1];
           $shipping_method = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TEXT_WAY . ' ' . $order->delivery['country']['title'] . ': ';
           if ($shipping_num_boxes > 1) {
             $shipping_method .= $shipping_num_boxes . 'x ';
           }
           $shipping_method .= $shipping_weight . ' ' . MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TEXT_UNITS;
           break;
         }
       }

       if ($shipping == -1) {
         $shipping_cost = 0;
         $shipping_method = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_UNDEFINED_RATE;
		 $brak_mozliwosci = true;
       } else {
         $order_total = $cart->show_total();
		 $wartosc_jedn = constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_JEDN_WARTOSC_' . $dest_zone);
		 $cena_jedn = constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OPLATAWARTOSCI_' . $dest_zone);
		 $wartosc = (ceil(($order_total/$wartosc_jedn)) * $cena_jedn);
         $shipping_method .= '<br>'.MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_WARTOSC. ' : ' .$currencies->format($order_total);
         $shipping_cost = ($shipping * $shipping_num_boxes) + $wartosc + constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_HANDLING_' . $dest_zone);
		 $brak_mozliwosci = false;
       }
     }

     $this->quotes = array('id' => $this->code,
                           'module' => MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TEXT_TITLE,
                           'methods' => array(array('id' => $this->code,
                                                    'title' => $shipping_method,
                                                    'cost' => $shipping_cost)));
     if ($this->tax_class > 0) {
       $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
     }

     if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);
     if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_INVALID_ZONE;
	 if (MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OFF == 'False' && $brak_mozliwosci == true) {
		 return;
	   } else { 
		if ($order_total > (int)MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_MAKSYMALNIE) {
		 return;
		 } else {
		 return $this->quotes;
		}
     }	
     }

   function check() {
     if (!isset($this->_check)) {
       $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_STATUS'");
       $this->_check = tep_db_num_rows($check_query);
     }
     return $this->_check;
   }

   // elari - Added to select default country if not in listing
   function install() {
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Włączenie modułu', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_STATUS', 'True', 'Czy włączyć moduł Przesyłka Priorytetowa ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Grupa VAT', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Strefa dostawy', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_ZONE', '0', 'Wybierz strefę, dla której ma być stosowany ten sposob dostawy', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");	 	 
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sortowanie', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_SORT_ORDER', '0', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', now())");
     for ($i = 1; $i <= $this->num_pocztapriwpobr; $i++) {
        $default_countries = '';
       if ($i == 1) {
         $strefa = '<span style=color:ff0000>Polska</span>';
         $default_countries = 'PL'; ///przesylka ekonomiczna krajowa
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 2) {
         $strefa = '<span style=color:ff0000>10</span>';
         $default_countries = 'AL;AD;AT;BA;BG;HR;CY;DK; EE;FR;FX;DE;GI;GR; IS;IE;IL;LV;LT;LU;MK; MT;MD;MC;NL;RO;SI; ES;SE;TR;UA;VA;RS;XM'; // strefa PP10
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 3) {
         $strefa = '<span style=color:ff0000>11</span>';
         $default_countries = 'BE;FI;HU;IT;NO;PT; RU;SM;CH;GB'; // PP11
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 4) {
         $strefa = '<span style=color:ff0000>12</span>';
         $default_countries = 'CZ;SK'; // PP12
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 5) {
         $strefa = '<span style=color:ff0000>13</span>';
         $default_countries = 'BY'; // PP13
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 6) {
         $strefa = '<span style=color:ff0000>20</span>';
         $default_countries = 'DZ;AO;BJ;BM;BW;BF;BI;CM; CA;TD;KM;CG;DJ;EG;ER;ET; GA;GM;GH;GN;GW;KE;LS;LY; MG;MW;ML;MR;MU;MX;MA; MZ;NA;NE;NG;RW;SN;SC; SL;SO;ZA;SH;SD;SZ; TZ;TG;TN;UG;US;ZR;ZM;ZW'; //strefa P20
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 7) {
         $strefa = '<span style=color:ff0000>30</span>';
        $default_countries = 'AF;AI;AG;AR;AM;AW;AZ; BS;BH;BD;BB;BZ;BT;BO; BR;IO;BN;KH;KY;CL;CN; CO;CR;CU;DM;DO;EC;SV; FK;GF;GE;GD;GP;GT;GY; HT;HN;HK;IN;ID;IR;IQ;JM;JP; JO;KZ;KP;KR;KW;KG;LA; LB;MO;MY;MQ;MN;MM; NP;AN;NI;OM;PK;PA;PY; PE;PH;QA;SA;SG;LK;SR; SY;TW;TJ;TH;TT;TM;AE;UY; UZ;VE;VN;VG;YE'; //strefa PP30
         $shipping_table = '1:40.00,2:50.00';
       }
       if ($i == 8) {
         $strefa = '<span style=color:ff0000>40</span>';
         $default_countries = 'Strefa 40 i inne niezdefiniowane kraje'; // this must be the lastest zone			//strefa D i niezdefiniowane kraje
         $shipping_table = '1:40.00,2:50.00';
       }
	   
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kraje strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COUNTRIES_" . $i ."', '" . $default_countries . "', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach strafy " . $strefa . ".', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Tablica kosztów strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COST_" . $i ."', '" . $shipping_table . "', 'Koszty przesyłki dla strefy " . $strefa . " bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Dodatkowy stały koszt obsługi wysyłki do strefy " . $strefa ."', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_HANDLING_" . $i ."', '0', 'Dodatkowy stały koszt obsługi wysyłki dla strefy', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Jednostkowa kwota deklarowanej wartości dla Obszaru Nr " . $i ."', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_JEDN_WARTOSC_" . $i ."', '50.00', 'Jednostkowa kwota deklarowanej wartości przesyłki dla Obszaru ', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Opłata za zadeklarowaną wartość jednostkową dla Obszaru Nr " . $i ."', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OPLATAWARTOSCI_" . $i ."', '1.00', 'Opłata za zadeklarowaną wartość jednostkową przesyłki dla Obszaru ', '6', '0', now())");	   	 	   
     }
   tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Do jakiej wysokości zamówienia obowiązuje wysyłka ?', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_MAKSYMALNIE', '999999', 'Wartość zamówienia do której obowiązuje przesyłka. Powyżej wpisanej wartości przesyłka będzie wyłączona.', '6', '0', now())");	   	 	 
   tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Jeżeli nie można określić kosztów wysyłki ?', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OFF', 'False', 'Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");	 
   }

   // elari - Added to select default country if not in listing
   function remove() {
     tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
   }

   function keys() {
     $keys = array('MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_STATUS', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_TAX_CLASS', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_SORT_ORDER','MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_ZONE', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_MAKSYMALNIE', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OFF');
     for ($i=1; $i<=$this->num_pocztapriwpobr; $i++) {
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COUNTRIES_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_COST_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_HANDLING_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_JEDN_WARTOSC_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTPOBRW_OPLATAWARTOSCI_' . $i;
     }
     return $keys;
   }
 }

?>