<?php
/*
  $Id: raty_zagiel.php 1253 2009-11-15 15:14:03Z kamelianet $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/
/*
Wykonanie integracji RATY ZAGIEL eRaty
Arkadiusz Krakiewicz
akrakiewicz@zagiel.com.pl

modyfikacje : Jacek Krysiak www.oscgold.com

KODOWANIE ZNAKÓW: UTF-8
*/



  class raty_zagiel {
    var $code, $title, $description, $enabled;

// class constructor
    function raty_zagiel() {
      global $order;

      $this->code = 'raty_zagiel';
      $this->title = MODULE_PAYMENT_RATY_ZAGIEL_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_RATY_ZAGIEL_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_RATY_ZAGIEL_SORT_ORDER;
      $this->enabled = ( (MODULE_PAYMENT_RATY_ZAGIEL_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_RATY_ZAGIEL_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_RATY_ZAGIEL_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_RATY_ZAGIEL_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_RATY_ZAGIEL_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }

// disable the module if the order only contains virtual products
      if ($this->enabled == true) {
        if ($order->content_type == 'virtual') {
          $this->enabled = false;
        }
      }

	  if ($this->enabled == true) {
        if ($order->info['total'] - $order->info['shipping_cost'] < 100) { // Wyłączenie metody płatności raty Zagiel jezeli zamowienie jest < 100zł bez ceny przesyłki
          $this->enabled = false;
        }
      }

    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title,
				   'opis' => $this->description);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }

// START WYSWIETLANIE INFORMACJI PRZED ZLOZENIEM ZAMOWIENIA (checkout_confirmation.php)
function process_button() {
global $order, $cart;

$koszt = $order->info['total'];
//$koszt = $cart->show_total()+$order->info['shipping_cost'];

$tekst = '
  <script language="javascript">
  <!--
  function PoliczRate(koszyk)	{
        	 window.open(\'https://www.eraty.pl/symulator/oblicz.php?numerSklepu=' . MODULE_PAYMENT_RATY_ZAGIEL_NUMER_SKLEPU . '&wariantSklepu=' . MODULE_PAYMENT_RATY_ZAGIEL_WARIANT_SKLEPU . '&typProduktu=0&wartoscTowarow=\'+koszyk, \'Policz_rate\', \'width=630,height=500,directories=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no\');
  }
  function nowe_okno() {
        	 window.open(\'http://www.zagiel.com.pl/kalkulator/jak_kupic.html\', \'nowe_okno\', \'width=600,height=500,directories=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no\');
  }
  //-->
  </script>
<table cellspacing="0" cellpadding="0" border="0">
<tr>
	<td colspan="4">' . tep_draw_separator('pixel_trans.gif', '100%', '10') . '</td>
</tr>
<tr>
	<td class="main" colspan="4" align="center"><b>Zapoznaj się z procedurą Raty Żagiel (przez internet)</b></td>
</tr>
<tr>
	<td colspan="4">
		<table border="0" width="100%" cellspacing="2" cellpadding="2">
			<tr>
				<td align="center" class="main">
          <a OnClick="PoliczRate(' . $koszt . ');" style="cursor: pointer;">' . tep_image_button('zagiel_oblicz_rate.gif', ZAGIEL_OBLICZ_RATE) . '</a>
        </td>
			</tr>
			<tr>
				<td align="center" class="infoboxcontents">
					Zapoznałem się <a OnClick="nowe_okno();" style="cursor: pointer;" title="Zapoznaj się z procedurą udzielenia kredytu ratalnego..."><b>z procedurą udzielenia kredytu ratalnego Raty Żagiel</b></a>&nbsp;' . tep_draw_checkbox_field('raty_zgoda', '', true, '') . '
				</td>
			</tr>
			<tr>
				<td class="main" align="center" colspan="2">
					<b>Po kliknięciu "Potwierdź Zamówienie" zostaniesz przeniesiony na stronę systemu ratalnego Żagiel,<br>po czym wypełnisz krótki wniosek o udzielenie kredytu ratalnego.</b>
				</td>
			</tr>
		</table>
</tr>
<tr>
	<td colspan="4">' . tep_draw_separator('pixel_trans.gif', '100%', '10') . '</td>
</tr>
</table>
';

return $tekst;
}
// KONIEC WYSWIETLANIE INFORMACJI PRZED ZLOZENIEM ZAMOWIENIA (checkout_confirmation.php)


    function before_process() {
      return false;
    }


// START TWORZENIE FORMULARZA WYSYLANEGO DO SYSTEMU eRATY ZAGIEL S.A. (checkout_proccess.php)
function after_process() {
global $order, $currencies, $cart, $insert_id;

function clean_nazwa($data) {
	$data = preg_replace ('/&#34/', '', $data);
	$data = preg_replace ('/"/', '', $data);
	return $data;
	}

function clean_prod($data) {
  $data = preg_replace ('/[^0-9,]/', '', $data);
  $data = preg_replace ('/ /', '', $data);
  $data = preg_replace ('/,/', '.', $data);
  return $data;
}

$tekst = '
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
  <html' . HTML_PARAMS . '>
  <head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>Złóż wniosek o kredyt ratalny - Kontynuuj...</title>
  <style type="text/css">
  body {
  margin-top: 150px;
  background: #fff;
  font-family: Arial, Helvetica, sans-serif;
  font-size: 22px;
  color: #333;
  font-weight: bold;
  }
  </style>
  </head>
  <body>
  <div style="color: #333; width: 100%; text-align: center; position: absolute; top: 150px;">
  Właśnie dokonałeś zakupu.
  <br>Zapraszamy do złożenia wniosku ratalnego
  <br><span style="color: #26aeca;">e</span><span style="color: #003399;">Raty</span> Żagiel S.A.
  <br><br>
<form name="formularz_eRaty" action="https://www.eraty.pl/symulator/krok1.php" method="post">
';

$products = $cart->get_products();

for ($i=0, $nr=1; $i<sizeof($products); $i++, $nr++) {

  $tekst .= '
  <input name="idTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['id'] . '">
  <input name="nazwaTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . clean_nazwa($products[$i]['name']) .'">
  <input name="wartoscTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . number_format(clean_prod($currencies->display_price_nodiscount($products[$i]['id'], $products[$i]['final_price'], tep_get_tax_rate($products[$i]['tax_class_id']), '1')), 2, '.', '') . '">
  <input name="liczbaSztukTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['quantity'] . '">
  <input name="jednostkaTowaru' . $nr . '" readonly="readonly" type="hidden" value="szt.">
  ';

}

$wartoscTowarow = 0;

if ($order->info['shipping_cost'] != '' && $order->info['shipping_cost'] != 0) {

  $tekst .= '
  <input name="idTowaru' . $nr . '" readonly="readonly" type="hidden" value="KosztPrzesylki">
  <input name="nazwaTowaru' . $nr . '" readonly="readonly" type="hidden" value="Koszt Przesyłki">
  <input name="wartoscTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $order->info['shipping_cost'] . '">
  <input name="liczbaSztukTowaru' . $nr . '" readonly="readonly" type="hidden" value="1">
  <input name="jednostkaTowaru' . $nr . '" readonly="readonly" type="hidden" value="szt.">
  ';

  $wartoscTowarow = $order->info['shipping_cost'];

} else {

  $nr -= 1;

}

$wartoscTowarow += $cart->show_total();

$tekst .= '
  <input type="hidden" name="wartoscTowarow" value="' . $wartoscTowarow . '">
  <input type="hidden" name="liczbaSztukTowarow" value="' . $nr . '">
  <input type="hidden" name="numerSklepu" value="' . MODULE_PAYMENT_RATY_ZAGIEL_NUMER_SKLEPU . '">
  <input type="hidden" name="typProduktu" value="0">
  <input type="hidden" name="wariantSklepu" value="' . MODULE_PAYMENT_RATY_ZAGIEL_WARIANT_SKLEPU . '">
  <input type="hidden" name="sposobDostarczeniaTowaru" value="' . preg_replace('#\s\(.*\)#', '', clean_nazwa($order->info['shipping_method'])) . '">
  <input type="hidden" name="nrZamowieniaSklep" value="' . $insert_id . '">
  <input type="hidden" name="pesel" value="">
  <input type="hidden" name="imie" value="' . clean_nazwa($order->billing['firstname']) . '">
  <input type="hidden" name="nazwisko" value="' . clean_nazwa($order->billing['lastname']) . '">
  <input type="hidden" name="email" value="' . clean_nazwa($order->customer['email_address']) . '">
  <input type="hidden" name="telKontakt" value="' . clean_nazwa($order->customer['telephone']) . '">
  <input type="hidden" name="ulica" value="' . clean_nazwa($order->billing['street_address']) . '">
  <input type="hidden" name="nrDomu" value="">
  <input type="hidden" name="nrMieszkania" value="">
  <input type="hidden" name="miasto" value="' . clean_nazwa($order->billing['city']) . '">
  <input type="hidden" name="kodPocz" value="' . clean_nazwa($order->billing['postcode']) . '">
  <input type="hidden" name="char" value="' . CHARSET . '">
  <input type="hidden" name="wniosekZapisany" value="' . HTTP_SERVER . DIR_WS_HTTP_CATALOG . 'raty_zagiel.php?akcja=tak&id_zamowienie=">
  <input type="hidden" name="wniosekAnulowany" value="' . HTTP_SERVER . DIR_WS_HTTP_CATALOG . 'raty_zagiel.php?akcja=nie&id_zamowienie=">
  <input type="image" src="' . DIR_WS_TEMPLATES . 'images/buttons/polish/zagiel_zloz_wniosek.gif" border="0" alt="Kontynuuj - Złóż wniosek o kredyt ratalny eRaty Żagiel S.A." title="Złóż wniosek o kredyt ratalny eRaty Żagiel S.A.">
  </form>
  </div>
  </body>
  </html>
  ';

echo $tekst;

}
// KONIEC TWORZENIE FORMULARZA WYSYLANEGO DO SYSTEMU eRATY ZAGIEL S.A. (checkout_proccess.php)

    function get_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_RATY_ZAGIEL_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Włączony', 'MODULE_PAYMENT_RATY_ZAGIEL_STATUS', 'True', 'Włącza (true) lub nie (false) moduł płatność Raty Żagiel eKredyt', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numer sklepu.', 'MODULE_PAYMENT_RATY_ZAGIEL_NUMER_SKLEPU', '28019999', 'Ośmiocyfrowy numer identyfikacyjny sklepu – numer znajduje sie na umowie własciciela sklepu z Żagiel S.A. dla sprzedaży internetowej (nie dla sprzedaży stacjonarnej).<br>Do czasu wprowadzenia właściwego numeru sklep będzie działał w trybie testowym.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numer sklepu.', 'MODULE_PAYMENT_RATY_ZAGIEL_WARIANT_SKLEPU', '1', 'Wariant sklepu. Sklep definiuje w Panelu Sprzedawcy jego sklepy oraz inne serwisy prowadzenia sprzedaży internetowej, np. sklep nr1, sklep nr2, serwis aukcyjny. Dzęki temu sprzedawca może przypisywać odpowiednie typy umów do wytypowanych przez niego sklepów lub serwisów aukcyjnych.<br>Np. Typ umowy Raty 0% ma sie pojawiac tylko w sklepie nr1, a typ umowy Super Promocja 3% ma sie pojawić tylko w serwisie aukcyjnym.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numer telefonu.', 'MODULE_PAYMENT_RATY_ZAGIEL_SHOPPHONE', '081 469 05 75', 'Numer telefonu do sklepu podawany podczas przekazywania zamówienia do systemu ratalnego Żagiel.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Strefa', 'MODULE_PAYMENT_RATY_ZAGIEL_ZONE', '0', 'Jeżeli wybrano strefę ten rodzaj płatności będzie aktywny tylko dla niej.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kolejność wyświetlania.', 'MODULE_PAYMENT_RATY_ZAGIEL_SORT_ORDER', '0', 'Kolejność wyświetlania. Najniższe wyświetlane są na początku.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Domyślny status zamówienia', 'MODULE_PAYMENT_RATY_ZAGIEL_ORDER_STATUS_ID', '0', 'Ustaw status zamówień realizowanych tą formą płatności', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
   }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_RATY_ZAGIEL_STATUS', 'MODULE_PAYMENT_RATY_ZAGIEL_ZONE', 'MODULE_PAYMENT_RATY_ZAGIEL_ORDER_STATUS_ID', 'MODULE_PAYMENT_RATY_ZAGIEL_SORT_ORDER', 'MODULE_PAYMENT_RATY_ZAGIEL_NUMER_SKLEPU', 'MODULE_PAYMENT_RATY_ZAGIEL_SHOPPHONE', 'MODULE_PAYMENT_RATY_ZAGIEL_WARIANT_SKLEPU');
    }
  }
?>
