<?php

  class ppec {
    var $code, $title, $description, $enabled, $businessid, $apiusername, $apipassword, $apisignature, $purl;

    // class constructor
    function ppec() {
      global $order;

      $this->code = 'ppec';
      $this->title = MODULE_PAYMENT_PPEC_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_PPEC_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_PPEC_SORT_ORDER;
      $this->apiusername = MODULE_PAYMENT_PPEC_USERNAME;
      $this->apipassword = MODULE_PAYMENT_PPEC_PASSWORD;
      $this->apisignature = MODULE_PAYMENT_PPEC_SIGNATURE;
      $this->businessid = MODULE_PAYMENT_PPEC_ID;
      //$this->alertmail = MODULE_PAYMENT_PPEC_MAIL;
      $this->enabled = ((MODULE_PAYMENT_PPEC_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_PPEC_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_PPEC_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      global $purl;
      $doppec = '1';

      $this->form_action_url = tep_href_link('ppeb.php', '&doppec='.$doppec, 'SSL');
    }

    // class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_PPEC_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_PPEC_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_PPEC_TEXT_DESCRIPTION);
      //return false;
    }

    function process_button() {
      global $order, $currencies, $currency;

      if (MODULE_PAYMENT_PPEC_CURRENCY == 'Wybrana waluta') {
        $my_currency = $currency;
      } else {
        $my_currency = substr(MODULE_PAYMENT_PPEC_CURRENCY, 6);
      }
      if (!in_array($my_currency, array('EUR', 'GBP', 'USD', 'PLN'))) {
        $my_currency = 'PLN';
      }

      return false;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PPEC_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
                                                     values ('PayPal Express Checkout', 'MODULE_PAYMENT_PPEC_STATUS', 'True', 'Czy chcesz włączyć płatność za pośrednictwem PayPal Express Checkout?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
                                                     values ('Kolejność wyświetlania', 'MODULE_PAYMENT_PPEC_SORT_ORDER', '0', 'Kolejność w jakiej zostanie wyświetlony moduł:', '6', '2', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
                                                     values ('Adres E-Mail', 'MODULE_PAYMENT_PPEC_ID', '', 'Adres e-mail używany do logowania do serwisu PayPal:', '6', '3', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
                                                     values ('Waluta tranzakcji', 'MODULE_PAYMENT_PPEC_CURRENCY', 'Wybrana waluta', 'Waluta używana podczas tranzakcji w PayPal<br>Wybranie opcji <b>Wybrana waluta</b> pozwala na dokonywanie płatności w walutach dozwolonych w konfiguracji konta w serwisie PayPal.<br>Jeżeli zostanie wybrana konkretna waluta, wszystkie płatności będą przeliczane do tej waluty', '6', '4', 'tep_cfg_select_option(array(\'Wybrana waluta\',\'Tylko USD\',\'Tylko EUR\',\'Tylko GBP\',\'Tylko PLN\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
                                                     values ('Serwer PayPal', 'MODULE_PAYMENT_PPEC_TRANSACTION_SERVER', 'PayPal Live Server', 'Serwer wykorzystywany do dokonywania transakcji:', '6', '5', 'tep_cfg_select_option(array(\'PayPal Live Server\', \'PayPal Sandbox Server (do testowania modułu)\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Użytkownik API', 'MODULE_PAYMENT_PPEC_USERNAME', '', 'Nazwa użytkownika API:', '6', '4', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Hasło API', 'MODULE_PAYMENT_PPEC_PASSWORD', '', 'Hasło użytkownika API:', '6', '4', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Podpis API', 'MODULE_PAYMENT_PPEC_SIGNATURE', '', 'Podpis użytkownika API:', '6', '4', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
                                                     values ('Serwer PayPal', 'MODULE_PAYMENT_PPEC_TRANSACTION_TYPE', 'Sale', 'W jaki sposób chcesz otrzymać płatność:<br>Sale - oznacza, że jest to ostateczna sprzedaż, za którą sprzedający żąda płatności<br>Authorization - oznacza, że płatność podlega rozliczeniu w ramach autoryzacji i pobierania środków w systemie PayPal', '6', '5', 'tep_cfg_select_option(array(\'Sale\', \'Authorization\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Certyfikat SSL (opcja)', 'MODULE_PAYMENT_PPEC_CERT_FILE', '', 'Nazwa pliku zawierającego certyfikat API<br>Plik musi się znajdować w lokalizacji: ppec/ppec_cert/' , '6', '2', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Logo (opcja)', 'MODULE_PAYMENT_PPEC_LOGO', '', 'Adres do pliku logo<br>Adres URL musi mieć postać HTTPS, i maksymalne rozmiary 750 pixeli szerokości i 90 pixeli wysokości' , '6', '2', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");

      tep_db_query("delete from " . TABLE_ORDERS_STATUS . " where orders_status_name LIKE 'PayPal-%'");
    }

    function keys() {
      return array('MODULE_PAYMENT_PPEC_STATUS', 'MODULE_PAYMENT_PPEC_SORT_ORDER', 'MODULE_PAYMENT_PPEC_ID', 'MODULE_PAYMENT_PPEC_CURRENCY', 'MODULE_PAYMENT_PPEC_TRANSACTION_SERVER', 'MODULE_PAYMENT_PPEC_USERNAME', 'MODULE_PAYMENT_PPEC_PASSWORD', 'MODULE_PAYMENT_PPEC_SIGNATURE', 'MODULE_PAYMENT_PPEC_TRANSACTION_TYPE', 'MODULE_PAYMENT_PPEC_CERT_FILE', 'MODULE_PAYMENT_PPEC_LOGO');
    }
  }
?>