<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

  class ot_upust {
    var $title, $output;

    function ot_upust() {
      $this->code = ot_upust;
      $this->description = MODULE_UPUST_DESCRIPTION;
      $this->enabled = MODULE_UPUST_STATUS;
      $this->sort_order = MODULE_UPUST_SORT_ORDER;
      $this->include_shipping = MODULE_UPUST_INC_SHIPPING;
      $this->include_tax = MODULE_UPUST_INC_TAX;
      $this->table = MODULE_UPUST_TABLE;
      $this->rodzaj = MODULE_UPUST_RODZAJ;
      $this->title = (($this->rodzaj=='ilosc') ? MODULE_UPUST_TITLE_ILOSC : MODULE_UPUST_TITLE_WARTOSC);      
      $this->output = array();
    }

function process() {
    global $order, $ot_subtotal, $currencies, $customer_id, $customer_discount,$cart;
	$od_amount = $this->calculate_credit($this->get_order_total(),$cart->count_contents(),$this->rodzaj);

	$od_amount = round($od_amount, 2);
    if ($od_amount>0) {
         $this->deduction = $od_amount;
         $this->output[] = array('title' => $this->title . ':<br>' . MODULE_UPUST_TEXT . $this->od_pc . '%. <br><b>'.MODULE_UPUST_VALUE.'</b>',
                                'text' => '<b>' . $currencies->format($od_amount) .'<b>' ,
                                'value' => $od_amount);
         $order->info['total'] = $order->info['total'] - $od_amount;
         if ($this->sort_order < $ot_subtotal->sort_order) {
            $order->info['subtotal'] = $order->info['subtotal'] - $od_amount;
         }
    }
}
	  
   
function calculate_credit($suma_zam,$ilosc_prod,$rodzaj) {
    global $order;
    
    if ($rodzaj == 'ilosc') {
        $amount_order = $ilosc_prod;
        } else {
        $amount_order = $suma_zam;
    }
    
    $od_amount=0;
    $table_cost = split("[:,]" , MODULE_UPUST_TABLE);
    for ($i = 0; $i < count($table_cost); $i+=2) {
          if ($amount_order >= $table_cost[$i]) {
            $od_pc = $table_cost[$i+1];
			$this->od_pc = $od_pc;
          }
    }
    $od_amount = $suma_zam*$od_pc/100;
    return $od_amount;
  }
  
  function get_order_total() {
    global  $order, $cart;
    $order_total = $order->info['total'];
    $products = $cart->get_products();
    for ($i=0; $i<sizeof($products); $i++) {
      $t_prid = tep_get_prid($products[$i]['id']);
      $gv_query = tep_db_query("select products_price, products_tax_class_id, products_model from " . TABLE_PRODUCTS . " where products_id = '" . $t_prid . "'");
      $gv_result = tep_db_fetch_array($gv_query);
      if (ereg('^GIFT', addslashes($gv_result['products_model']))) { 
        $qty = $cart->get_quantity($t_prid);
        $products_tax = tep_get_tax_rate($gv_result['products_tax_class_id']);
        if ($this->include_tax =='false') {
           $gv_amount = $gv_result['products_price'] * $qty;
        } else {
          $gv_amount = ($gv_result['products_price'] + tep_calculate_tax($gv_result['products_price'],$products_tax)) * $qty;
        }
        $order_total=$order_total - $gv_amount;
      }
    }
    if ($this->include_tax == 'false') $order_total=$order_total-$order->info['tax'];
    if ($this->include_shipping == 'false') $order_total=$order_total-$order->info['shipping_cost'];
    return $order_total;
  }    
  
    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_UPUST_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }

      return $this->check;
    }

    function keys() {
      return array('MODULE_UPUST_STATUS', 'MODULE_UPUST_SORT_ORDER', 'MODULE_UPUST_TABLE', 'MODULE_UPUST_INC_SHIPPING', 'MODULE_UPUST_INC_TAX', 'MODULE_UPUST_RODZAJ');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Zniżka zależna od wartości zakupów', 'MODULE_UPUST_STATUS', 'true', 'Czy włączyć znizki zależne od wielkości zamówienia ?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kolejność wyświetlania', 'MODULE_UPUST_SORT_ORDER', '999', 'Kolejność wyświetlania znizki.', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function ,date_added) values ('Przeliczanie przesyłki', 'MODULE_UPUST_INC_SHIPPING', 'true', 'Włączenie kosztów przesyłki do przeliczania rabatu', '6', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function ,date_added) values ('Wliczaj podatek', 'MODULE_UPUST_INC_TAX', 'true', 'Włączenie podatku do przeliczania rabatu', '6', '4','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Progi zniżek', 'MODULE_UPUST_TABLE', '1000:5,1500:7.5,2000:10,3000:12.5,5000:15', 'Ustaw progi wysokości zakupów, dla których będą naliczane % zniżki.', '6', '7', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function , date_added) values ('Zniżka zależna od', 'MODULE_UPUST_RODZAJ', 'kwota', 'Ustaw jaka wartość ma być brana do naliczania zniżki. Kwota - zniżka zależna od wartości koszyka. Ilość - zniżka zależna od ilości produktów.', '6', '8', 'tep_cfg_select_option(array(\'kwota\', \'ilosc\'), ', now())");
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }
  }
?>