<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

  class ot_discount_coupon {
    var $title, $output, $coupon;

    function ot_discount_coupon() {
      $this->code = 'ot_discount_coupon';
      $this->title = MODULE_ORDER_TOTAL_DISCOUNT_COUPON_TITLE;
      $this->enabled = ((MODULE_ORDER_TOTAL_DISCOUNT_COUPON_STATUS == 'true') ? true : false);
      $this->sort_order = MODULE_ORDER_TOTAL_DISCOUNT_COUPON_SORT_ORDER;
      $this->output = array();
    }

    function process() {
      global $order, $currencies;
      if( is_object( $order->coupon ) ) {

        //if the order total lines for multiple tax groups should be displayed as one, add them all together
        $discount_lines = $order->coupon->applied_discount;

        if( (float)$discount_lines > 0) {
            //add in the tax if needed:
            //determine the display type (with or without the minus sign):
            $display_type = ( MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TYPE == 'true' ? '-' : '' );
			if ((float)$discount_lines < 1.01) {
				$text = $display_type . $currencies->format( $order->info['subtotal']*(float)$discount_lines, true, $order->info['currency'], $order->info['currency_value'] );
				$prec = ' ('.$display_type.($discount_lines*100).'%)';
				$discount_lines = $order->info['subtotal']*(float)$discount_lines;
				} else {
				$text = $display_type . $currencies->format( $discount_lines, true, $order->info['currency'], $order->info['currency_value'] );
				$prec = '';
			}
            //add debug text if debug is on:
            $this->output[] = array( 'title' => $order->coupon->format_display() . $prec. ':',
                                     'text' => $text,
                                     'value' => $display_type . $discount_lines );								 
        }
      } else $this->enabled = false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array( 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_STATUS',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_SORT_ORDER',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TYPE',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_EXCLUDE_SPECIALS',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_RANDOM_CODE_LENGTH',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_USE_LANGUAGE_FILE',
                    'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_CONFIG');
    }

    function install() {

      tep_db_query("insert into " . TABLE_CONFIGURATION . "
                      (configuration_title,
                       configuration_key,
                       configuration_value,
                       configuration_description,
                       configuration_group_id,
                       sort_order,
                       set_function,
                       date_added)
                      values
                      ('Kupony rabatowe',
                       'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_STATUS',
                       'true',
                       'Czy wyświetlać kupony rabatowe ?',
                       '615',
                       '1',
                       'tep_cfg_select_option(array(\'true\', \'false\'), ',
                       now()),
                      ('Kolejność wyświetlania',
                       'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_SORT_ORDER',
                       '2',
                       'Kolejność w jakiej zostanie wyświetlony rabat wynikający z kuponu rabatowego. Wartość jest wyświetlana we wszelkich podsumowaniach zamówienia.',
                       '615',
                       '2',
                       '',
                       now()),
                      ('Wyświetlaj rabat ze znakiem minus (-)',
                       'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TYPE',
                       'false',
                       '<b>włączone</b> - rabat zostanie wyświetlony ze znakiem minus<br><b>wyłączone</b> - rabat zostanie wyświetlony bez znaku minus',
                       '615',
                       '3',
                       'tep_cfg_select_option(array(\'true\', \'false\'), ',
                       now()),
                      ('Wyłączenie produktów w PROMOCJI',
                       'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_EXCLUDE_SPECIALS',
                       'true',
                       '<b>włączone</b> - produkty znajdujące się w promocji nie będą objęte kuponem rabatowym<br><b>wyłączone</b> - produkty znajdujące się w PROMOCJI będą również objęte kuponem rabatowym',
                       '615',
                       '6',
                       'tep_cfg_select_option(array(\'true\', \'false\'), ',
                       now()),
                      ('Długość losowego kodu',
                       'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_RANDOM_CODE_LENGTH',
                       '6',
                       'Długość kodu kuponu rabatowego w przypadku automatycznego generowania.',
                       '615',
                       '7',
                       '',
                       now()),
                       ('Wersje językowe',
                        'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_USE_LANGUAGE_FILE',
                        'false',
                        '<b>wł</b> - informacja o udzielonym rabacie w podsumowaniu zamówienia zostanie wyświetlona zgodnie z wybranym w sklepie językiem<br><b>wył</b> - informacja o rabacie w podsumowaniu zostanie wyświetlona zgodnie z definicjami na samym dole',
                        '615',
                        '10',
                        'tep_cfg_select_option(array(\'true\', \'false\'), ',
                        now()),
                       ('Sposób wyświetlania informacji o rabacie w podsumowaniu zamówienia',
                        'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_CONFIG',
                        'Wartość kuponu rabatowego Numer : [code]',
                        'Informacja o rabacie w podsumowaniu zamówienia.<br><br>Wartości:<br>[code] - kod kuponu<br>[coupon_desc] - opis<br>[discount_amount] - wartość rabatu<br>[min_order] - min.kwota zamówienia<br>[number_available] - dostępna ilość',
                        '615',
                        '11',
                        '',
                        now())");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      coupons_description VARCHAR(64) NOT NULL DEFAULT '',
                      coupons_discount_amount DECIMAL(15,12) NOT NULL DEFAULT '0.0000',
                      coupons_discount_type ENUM ('fixed','percent','shipping') NOT NULL DEFAULT 'percent',
                      coupons_date_start DATETIME DEFAULT NULL,
                      coupons_date_end DATETIME DEFAULT NULL,
                      coupons_max_use INT(3) NOT NULL DEFAULT 0,
                      coupons_min_order DECIMAL(15,4) NOT NULL DEFAULT '0.0000',
                      coupons_min_order_type ENUM('price','quantity') DEFAULT 'price',
                      coupons_number_available INT(3) NOT NULL DEFAULT 0,
                      PRIMARY KEY  (coupons_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_orders (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      orders_id INT(11) DEFAULT '0',
                      PRIMARY KEY  (coupons_id,orders_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_categories (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      categories_id INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY  (coupons_id,categories_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_products (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      products_id INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY  (coupons_id,products_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_manufacturers (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      manufacturers_id INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY  (coupons_id,manufacturers_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_customers (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      customers_id INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY  (coupons_id,customers_id)
                    )");

      tep_db_query("CREATE TABLE IF NOT EXISTS discount_coupons_to_zones (
                      coupons_id VARCHAR(32) NOT NULL DEFAULT '',
                      geo_zone_id INT(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY  (coupons_id,geo_zone_id)
                    )");

    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>