<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

// look in your $PATH_LOCALE/locale directory for available locales
// or type locale -a on the server.
// Examples:
// on RedHat try 'de_DE'
// on FreeBSD try 'de_DE.ISO_8859-1'
// on Windows try 'de' or 'German'
@setlocale(LC_TIME, 'de_DE.UTF-8');

define('DATE_FORMAT_SHORT', '%d.%m.%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A, %d. %B %Y'); // this is used for strftime()
define('DATE_FORMAT', 'd.m.Y');  // this is used for strftime()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
  }
}

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
define('HTML_PARAMS','dir="LTR" lang="de"');

// charset for web pages and emails
define('CHARSET', 'utf-8');

// page title
define('TITLE', 'oscGold');

// header text in includes/header.php
define('HEADER_TITLE_CREATE_ACCOUNT', 'Neues Konto');
define('HEADER_TITLE_MY_ACCOUNT', 'Ihr Konto');
define('HEADER_TITLE_CART_CONTENTS', 'Warenkorb');
define('HEADER_TITLE_CHECKOUT', 'Kasse');
define('HEADER_TITLE_TOP', 'Startseite');
define('HEADER_TITLE_CATALOG', 'Katalog');
define('HEADER_TITLE_LOGOFF', 'Abmelden');
define('HEADER_TITLE_LOGIN', 'Anmelden');

// footer text in includes/footer.php
define('FOOTER_TEXT_REQUESTS_SINCE', 'Zugriffe seit');

// text for gender
define('MALE', 'Herr');
define('FEMALE', 'Frau');
define('MALE_ADDRESS', 'Herr');
define('FEMALE_ADDRESS', 'Frau');

// text for date of birth example
define('DOB_FORMAT_STRING', 'tt.mm.jjjj');

// categories box text in includes/boxes/categories.php
define('BOX_HEADING_CATEGORIES', 'Kategorien');

// manufacturers box text in includes/boxes/manufacturers.php
define('BOX_HEADING_MANUFACTURERS', 'Hersteller');

// whats_new box text in includes/boxes/whats_new.php
define('BOX_HEADING_WHATS_NEW', 'Neue Produkte');

// quick_find box text in includes/boxes/quick_find.php
define('BOX_HEADING_SEARCH', 'Schnellsuche');
define('BOX_SEARCH_TEXT', 'Verwenden Sie Stichworte, um ein Produkt zu finden.');
define('BOX_SEARCH_ADVANCED_SEARCH', 'Erweiterte Suche');

// specials box text in includes/boxes/specials.php
define('BOX_HEADING_SPECIALS', 'Angebote');

// reviews box text in includes/boxes/reviews.php
define('BOX_HEADING_REVIEWS', 'Bewertungen');
define('BOX_REVIEWS_WRITE_REVIEW', 'Bewerten Sie dieses Produkt!');
define('BOX_REVIEWS_NO_REVIEWS', 'Es liegen noch keine Bewertungen vor');
define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s von 5 Sternen!');

// shopping_cart box text in includes/boxes/shopping_cart.php
define('BOX_HEADING_SHOPPING_CART', 'Warenkorb');
define('BOX_SHOPPING_CART_EMPTY', '0 Produkte');

// order_history box text in includes/boxes/order_history.php
define('BOX_HEADING_CUSTOMER_ORDERS', 'Bestellübersicht');

// best_sellers box text in includes/boxes/best_sellers.php
define('BOX_HEADING_BESTSELLERS', 'Bestseller');
define('BOX_HEADING_BESTSELLERS_IN', 'Bestseller<br>&nbsp;&nbsp;');

// notifications box text in includes/boxes/products_notifications.php
define('BOX_HEADING_NOTIFICATIONS', 'Benachrichtigungen');
define('BOX_NOTIFICATIONS_NOTIFY', 'Benachrichtigen Sie mich über Aktuelles zu diesem Artikel <b>%s</b>');
define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'Benachrichtigen Sie mich nicht mehr zu diesem Artikel <b>%s</b>');

// manufacturer box text
define('BOX_HEADING_MANUFACTURER_INFO', 'Hersteller Info');
define('BOX_MANUFACTURER_INFO_HOMEPAGE', '%s Homepage');
define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Mehr Produkte');

// languages box test in includes/boxes/languages.php
define('BOX_HEADING_LANGUAGES', 'Sprachen');

// currencies box text in includes/boxes/currencies.php
define('BOX_HEADING_CURRENCIES', 'Währungen');

// information box text in includes/boxes/information.php
define('BOX_HEADING_INFORMATION', 'Informationen');
define('BOX_INFORMATION_PRIVACY', 'Privatsphäre und Datenschutz');
define('BOX_INFORMATION_CONDITIONS', 'Unsere AGB\'s');
define('BOX_INFORMATION_SHIPPING', 'Liefer - und Versandkosten');
define('BOX_INFORMATION_CONTACT', 'Kontakt');

// tell a friend box text in includes/boxes/tell_a_friend.php
define('BOX_HEADING_TELL_A_FRIEND', 'Weiterempfehlen');
define('BOX_TELL_A_FRIEND_TEXT', 'Empfehlen Sie diesen Artikel einfach per Email weiter.');

// checkout procedure text
define('CHECKOUT_BAR_DELIVERY', 'Versandinformationen');
define('CHECKOUT_BAR_PAYMENT', 'Zahlungsweise');
define('CHECKOUT_BAR_CONFIRMATION', 'Bestätigung');
define('CHECKOUT_BAR_FINISHED', 'Fertig!');
define('CHECKOUT_BAR_SHIPPEY', 'Versand-und Zahlungsbedingungen');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Bitte wählen');
define('TYPE_BELOW', 'bitte unten eingeben');

// javascript messages
define('JS_ERROR', 'Notwendige Angaben fehlen!\nBitte richtig ausf¨llen.\n\n');

define('JS_REVIEW_TEXT', '* Der Text muss mindestens aus ' . REVIEW_TEXT_MIN_LENGTH . ' Buchstaben bestehen.\n');
define('JS_REVIEW_RATING', '* Geben Sie Ihre Bewertung ein.\n');

define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Bitte wählen Sie eine Zahlungsweise für Ihre Bestellung.\n');

define('JS_ERROR_SUBMITTED', 'Diese Seite wurde bereits bestätigt. Betätigen Sie bitte OK und warten bis der Prozess durchgeführt wurde.');

define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Bitte wählen Sie eine Zahlungsweise für Ihre Bestellung.');

define('CATEGORY_COMPANY', 'Firmendaten');
define('CATEGORY_PERSONAL', 'Angaben zu Ihrer Person');
define('CATEGORY_ADDRESS', 'Ihre Adresse');
define('CATEGORY_CONTACT', 'Ihre Kontaktinformationen');
define('CATEGORY_OPTIONS', 'Optionen');
define('CATEGORY_PASSWORD', 'Ihr Passwort');

define('ENTRY_COMPANY', 'Firmenname:');
define('ENTRY_COMPANY_ERROR', '');
define('ENTRY_COMPANY_TEXT', '');

define('ENTRY_NIP', 'Steuer-/ Ust.-Id. Nummer:');
define('ENTRY_NIP_ERROR', '');
define('ENTRY_NIP_TEXT', '');

define('ENTRY_GENDER', 'Anrede:');
define('ENTRY_GENDER_ERROR', 'Bitte das Geschlecht angeben.');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'Vorname:');
define('ENTRY_FIRST_NAME_ERROR', 'Der Vorname sollte mindestens ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Nachname:');
define('ENTRY_LAST_NAME_ERROR', 'Der Nachname sollte mindestens ' . ENTRY_LAST_NAME_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Geburtsdatum:');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'Bitte geben Sie Ihr Geburtsdatum in folgendem Format ein: TT.MM.JJJJ (z.B. 21.05.1970)');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (z.B. 21.05.1970)');
define('ENTRY_EMAIL_ADDRESS', 'Email-Adresse:');
define('ENTRY_EMAIL_ADDRESS_CONFIRM', 'Bestätigen Sie Email:');
define('ENTRY_EMAIL_ADDRESS_CONFIRM_NOT_MATCHING', 'Das Bestätigung email muß Ihr email address zusammenbringen.');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'Die Email Adresse sollte mindestens ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Die Email Adresse scheint nicht gültig zu sein - bitte korrigieren.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Die Email Adresse ist bereits gespeichert - bitte melden Sie sich mit dieser Adresse an oder eröffnen Sie ein neues Konto mit einer anderen Adresse.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Strasse:');
define('ENTRY_STREET_ADDRESS_DOM', 'Hausnummer:');
define('ENTRY_STREET_ADDRESS_DOM_ERROR', 'Es wurde keine Homepage Feld darf nicht leer sein');
define('ENTRY_STREET_ADDRESS_MIESZKANIE', 'Appartement Nr.:');
define('ENTRY_STREET_ADDRESS_ERROR', 'Die Strassenadresse sollte mindestens ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Stadtteil:');
define('ENTRY_SUBURB_ERROR', '');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Postleitzahl:');
define('ENTRY_POST_CODE_ERROR', 'Die Postleitzahl sollte mindestens ' . ENTRY_POSTCODE_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'Ort:');
define('ENTRY_CITY_ERROR', 'Die Stadt sollte mindestens ' . ENTRY_CITY_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'Bundesland:');
define('ENTRY_STATE_ERROR', 'Das Bundesland sollte mindestens ' . ENTRY_STATE_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_STATE_ERROR_SELECT', 'Bitte wählen Sie ein Bundesland aus der Liste.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Land:');
define('ENTRY_COUNTRY_ERROR', 'Bitte wählen Sie ein Land aus der Liste.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Telefonnummer:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Die Telefonnummer sollte mindestens ' . ENTRY_TELEPHONE_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Telefaxnummer:');
define('ENTRY_FAX_NUMBER_ERROR', '');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Newsletter');
define('ENTRY_NEWSLETTER_OPIS', '(Eine Abmeldung ist jederzeit möglich.)');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'abonniert');
define('ENTRY_NEWSLETTER_NO', 'nicht abonniert');
define('ENTRY_NEWSLETTER_ERROR', '');
define('ENTRY_PASSWORD', 'Passwort:');
define('ENTRY_PASSWORD_ERROR', 'Das Passwort sollte mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'Beide eingegebenen Passwörter müssen identisch sein.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Bestätigung:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Current Password:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Das Passwort sollte mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_PASSWORD_NEW', 'New Password:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Das neue Passwort sollte mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'Die Passwort-Bestätigung muss mit Ihrem neuen Passwort übereinstimmen.');
define('PASSWORD_HIDDEN', '--VERSTECKT--');

// BOC added for Account Agreement
define('ENTRY_AGREEMENT', ' Ich akzeptiere die Allgemeinen Geschäfts- und Lieferbedingungen.');
//Modify your account agreement here
define('ENTRY_AGREEMENT_ERROR', 'Sie müssen den Kontovereinbarung Kasten überprüfen, um ein accout aufzustellen.');
define('ENTRY_AGREEMENT_TEXT', '*');
define('TEXT_ACCOUNT_AGREEMENT','Zustimmung der AGB’s und Lieferbedingungen');
// EOC added for Account Agreement

define('FORM_REQUIRED_INFORMATION', '* Notwendige Eingabe');

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Seiten:');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'angezeigte Produkte: <b>%d</b> bis <b>%d</b> (von <b>%d</b> insgesamt)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'angezeigte Bestellungen: <b>%d</b> bis <b>%d</b> (von <b>%d</b> insgesamt)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'angezeigte Meinungen: <b>%d</b> bis <b>%d</b> (von <b>%d</b> insgesamt)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'angezeigte neue Produkte: <b>%d</b> bis <b>%d</b> (von <b>%d</b> insgesamt)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'angezeigte Angebote <b>%d</b> bis <b>%d</b> (von <b>%d</b> insgesamt)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'erste Seite');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'vorherige Seite');
define('PREVNEXT_TITLE_NEXT_PAGE', 'nächste Seite');
define('PREVNEXT_TITLE_LAST_PAGE', 'letzte Seite');
define('PREVNEXT_TITLE_PAGE_NO', 'Seite %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Vorhergehende %d Seiten');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Nächste %d Seiten');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;ERSTE');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;vorherige]');
define('PREVNEXT_BUTTON_NEXT', '[nächste&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'LETZTE&gt;&gt;');

define('IMAGE_BUTTON_ADD_ADDRESS', 'Neue Adresse');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Adressbuch');
define('IMAGE_BUTTON_BACK', 'Zurück');
define('IMAGE_BUTTON_BUY_NOW', 'Buy Now');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Adresse ändern');
define('IMAGE_BUTTON_CHECKOUT', 'Kasse');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Bestellung bestätigen');
define('IMAGE_BUTTON_CONTINUE', 'Weiter');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Einkauf fortsetzen');
define('IMAGE_BUTTON_DELETE', 'Löschen');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'Daten ändern');
define('IMAGE_BUTTON_HISTORY', 'Bestellübersicht');
define('IMAGE_BUTTON_LOGIN', 'Anmelden');
define('IMAGE_BUTTON_IN_CART', 'In den Warenkorb');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Benachrichtigungen');
define('IMAGE_BUTTON_QUICK_FIND', 'Schnellsuche');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Benachrichtigungen löschen');
define('IMAGE_BUTTON_REVIEWS', 'Bewertungen');
define('IMAGE_BUTTON_SEARCH', 'Suchen');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Versandoptionen');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Weiterempfehlen');
define('IMAGE_BUTTON_UPDATE', 'Aktualisieren');
define('IMAGE_BUTTON_UPDATE_CART', 'Warenkorb aktualisieren');
define('IMAGE_BUTTON_WRITE_REVIEW', 'Bewertung schreiben');

define('SMALL_IMAGE_BUTTON_DELETE', 'Delete');
define('SMALL_IMAGE_BUTTON_EDIT', 'Edit');
define('SMALL_IMAGE_BUTTON_VIEW', 'View');

define('ICON_ARROW_RIGHT', 'Zeige mehr');
define('ICON_CART', 'In den Warenkorb');
define('ICON_ERROR', 'Fehler');
define('ICON_SUCCESS', 'Success');
define('ICON_WARNING', '');

define('TEXT_GREETING_PERSONAL', 'Schön das Sie wieder da sind <span class="greetUser">%s!</span> Möchten Sie die <a href="%s"><u>neue Produkte</u></a> ansehen?');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>Wenn Sie nicht %s sind, melden Sie sich bitte <a href="%s"><u>hier</u></a> mit Ihrem Kundenkonto an.</small>');
define('TEXT_GREETING_GUEST', 'Herzlich Willkommen <span class="greetUser">Gast!</span> Möchten Sie sich <a href="%s"><u>anmelden</u></a>? Oder wollen Sie ein <a href="%s"><u>Kundenkonto</u></a> eröffnen?');

define('TEXT_SORT_PRODUCTS', 'Sortierung der Artikel ist ');
define('TEXT_DESCENDINGLY', 'absteigend');
define('TEXT_ASCENDINGLY', 'aufsteigend');
define('TEXT_BY', ' nach ');

define('TEXT_REVIEW_BY', 'von %s');
define('TEXT_REVIEW_WORD_COUNT', '%s Worte');
define('TEXT_REVIEW_RATING', 'Bewertung: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Datum hinzugefügt: %s');
define('TEXT_NO_REVIEWS', 'Es liegen noch keine Bewertungen vor.');

define('TEXT_NO_NEW_PRODUCTS', 'Zur Zeit gibt es keine neuen Produkte.');

define('TEXT_UNKNOWN_TAX_RATE', 'Unbekannter Steuersatz');

define('TEXT_REQUIRED', '<span class="errorText">erforderlich</span>');

define('ERROR_TEP_MAIL', '<font face="Verdana, Arial" size="2" color="#ff0000"><b><small>Fehler:</small> Die Email kann nicht über den angegebenen SMTP-Server verschickt werden. Bitte kontrollieren Sie die Einstellungen in der php.ini Datei und führen Sie notwendige Korrekturen durch!</b></font>');
define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Warnung: Das Installationverzeichnis ist noch vorhanden auf: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/install. Bitte löschen Sie das Verzeichnis aus Gründen der Sicherheit!');
define('WARNING_CONFIG_FILE_WRITEABLE', 'Warnung: osC kann in die Konfigurationsdatei schreiben: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/includes/configure.php. Das stellt ein mögliches Sicherheitsrisiko dar - bitte korrigieren Sie die Benutzerberechtigungen zu dieser Datei!');
define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Warnung: Das Verzeichnis für die Sessions existiert nicht: ' . tep_session_save_path() . '. Die Sessions werden nicht funktionieren bis das Verzeichnis erstellt wurde!');
define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Warnung: osC kann nicht in das Sessions Verzeichnis schreiben: ' . tep_session_save_path() . '. Die Sessions werden nicht funktionieren bis die richtigen Benutzerberechtigungen gesetzt wurden!');
define('WARNING_SESSION_AUTO_START', 'Warnung: session.auto_start ist enabled - Bitte disablen Sie dieses PHP Feature in der php.ini und starten Sie den WEB-Server neu!');
define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Warnung: Das Verzeichnis für den Artikel Download existiert nicht: ' . DIR_FS_DOWNLOAD . '. Diese Funktion wird nicht funktionieren bis das Verzeichnis erstellt wurde!');

define('TEXT_CCVAL_ERROR_INVALID_DATE', 'Das "Gültig bis" Datum ist ungültig.<br>Bitte korrigieren Sie Ihre Angaben.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'Die "KreditkarteNummer", die Sie angegeben haben, ist ungültig.<br>Bitte korrigieren Sie Ihre Angaben.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'Die ersten 4 Ziffern Ihrer Kreditkarte sind: %s<br>Wenn diese Angaben stimmen, wird dieser Kartentyp leider nicht akzeptiert.<br>Bitte korrigieren Sie Ihre Angaben gegebenfalls.');

/*
  Poniższa informacja o prawie autorskim może być
  modyfikowana lub usunięta jedynie gdy wygląd serwisu
  został zmieniony i różni się od domyślnego zastrzeżonego
  prawem wyglądu osCommerce.

  Więcej informacji znajdziesz w FAQ na stronie wsparcia
  osCommerce:

        http://www.oscommerce.com/about/copyright

  Pozostaw ten komentarz nienaruszony wraz z następującą
  informacją o prawach autorskich.
*/
define('FOOTER_TEXT_BODY', 'Powered &copy; <a class="boxLink" href="http://www.oscgold.com" target="_blank">oscGold</a>');
define('NAVBAR_TITLE', 'Konto erstellen');
define('ITEMS_IN_CART', 'Warenkorb');
define('NEW_PRODUCTS', 'Neue Produkte');
define('TABLE_HEADING_PRICE', 'Preis');
define('HEADING_PRODUCT_INFO','Produkte');
define('ITEM_PRICE','Produkt-Preis:');
define('HEADING_PRODUCT_REVIEWS','Meinungen');
define('HEADING_CHOOS_LANG','Bitte wählen');
define('PRODUCT_INFO_DESCRIPTION','Beschreibung');

//Star product Start
define('STAR_TITLE', 'Star Produkt'); // star product
define('STAR_READ_MORE', ' ... mehr Info.'); // ... read more.
//Star product End

// Begin EZier new fields
define('TABLE_HEADING_RETAIL_PRICE', 'Einzelverkauf');
define('TABLE_HEADING_SAVE', 'Sparungen');
define('TEXT_PRODUCTS_RETAIL_PRICE_INFO', 'Listenpreis: ');
define('TEXT_PRODUCTS_PRICE_INFO', 'Unser Preis: ');
define('TEXT_PRODUCTS_PRICE_INFO_REGULAR', 'Einzelverkauf: ');
define('TEXT_PRODUCTS_SAVE_INFO', '<font color=red>Sie sparen: ');
define('TEXT_PRODUCTS_RETAIL_PRICE', 'Einzelhandelspreis:');
define('TEXT_PRODUCTS_PRICE_SPECIAL_INFO', '<font color=red>Sonderpreis: ');
define('TEXT_PRODUCTS_PRICE_SPECIAL_CUST', '<font color=red>Händlerpreis: ');
// End EZier new fields

define('WHATS_NEW_ALL','Ales');

//themes
define('BOX_HEADING_THEMES', 'Themen');

// START: Extra Infopages Manager
define('BOX_HEADING_PAGES', 'Information');
// END: Extra Infopages Manager

//BEGIN allprods modification
define('BOX_INFORMATION_ALLPRODS', 'Alle Produkte');
//END allprods modification

define('ENTRY_NIP_NULL_ERROR', 'Sie müssen NIP schreiben');
define('ENTRY_NIP_ERROR', 'Falsche NIP');
define('ENTRY_NIP', 'NIP:');
define('ENTRY_NIP_TEXT', '');

define('IMAGE_BUTTON_PRINT_ORDER', 'Auftrag bedruckbar');

//TotalB2B start
define('PRICES_LOGGED_IN_TEXT','Mußß für Preise<br>innen geloggt werden');
//TotalB2B end

//Kontakt Start
define('BOX_HEADING_KONTAKT','Kontakt');
//Kontakt End

//Linki Start
define('BOX_HEADING_LINKI','Verbindungen');
//Linki End

// previous next product
define('PREV_NEXT_PRODUCT', 'Produkte');
define('PREV_NEXT_FROM', '/');
define('PREV_NEXT_IN_CATEGORY', 'in der Kategorie');

// box text in includes/boxes/advsearch.php
define('BOX_HEADING_ADVSEARCH', 'Suche');
define('BOX_ADVSEARCH_KW', 'Schlüsselwort:');
define('BOX_ADVSEARCH_PRICERANGE', 'Preis:');
define('BOX_ADVSEARCH_PRICESEP', ' bis ');
define('BOX_ADVSEARCH_CAT', 'Kategorie:');
define('BOX_ADVSEARCH_ALLCAT', 'Bitte wählen');

//Related Products
define('TABLE_HEADING_RELATED_PRODUCTS', 'In Verbindung stehende Produkte');
define('TEXT_PRICE', 'Preis');

// newsdesk box text in includes/boxes/newsdesk.php
define('TABLE_HEADING_NEWSDESK', 'Nachrichten und Informationen');
define('TEXT_NO_NEWSDESK_NEWS', 'Traurig aber es gibt keine Nachrichten');
define('TEXT_NEWSDESK_READMORE', 'Lesen Sie Mehr');
define('TEXT_NEWSDESK_VIEWED', 'Angesehen:');

define('BOX_HEADING_NEWSDESK_CATEGORIES', 'Nachrichten Kategorien');
define('BOX_HEADING_NEWSDESK_LATEST', 'Neueste Nachrichten');

define('TEXT_DISPLAY_NUMBER_OF_ARTICLES', 'Anzeigen <b>%d</b> zu <b>%d</b> (von <b>%d</b> Artikel)');
define('TABLE_HEADING_NEWSDESK_SUBCAT', 'Nachrichten - Unterkategorien');
//END -- newsdesk

//START - GiftWrap
define('TEXT_ENTER_GIFTWRAP_INFORMATION', 'Wählen Sie Verpackung Wahl Vor');
//END - GiftWrap

//START - Additional Images
define('TEXT_ADDITIONAL_IMAGES', 'Zusätzliche Bilder');
//END - Additional Images

// Wer ist online
define('BOX_HEADING_WHOS_ONLINE', 'Wer ist online?');
define('BOX_WHOS_ONLINE_THEREIS', 'Zur Zeit ist');
define('BOX_WHOS_ONLINE_THEREARE', 'Zur Zeit sind');
define('BOX_WHOS_ONLINE_GUEST', 'Gast');
define('BOX_WHOS_ONLINE_GUESTS', 'Gäste');
define('BOX_WHOS_ONLINE_AND', 'und');
define('BOX_WHOS_ONLINE_MEMBER', 'Mitglied');
define('BOX_WHOS_ONLINE_MEMBERS', 'Mitglieder');

// +Country-State Selector
define ('DEFAULT_COUNTRY', '170');
// -Country-State Selector

//recently viewed box
define('BOX_HEADING_RECENTLY_VIEWED','Vor kurzem Angesehen');
define('NO_RECENTLY_VIEWED','Nicht angesehen irgendwelchen Produkten');

// subscribers box text in includes/boxes/subscribers.php
define('BOX_HEADING_SUBSCRIBERS', 'Newsletter');
define('BOX_TEXT_SUBSCRIBE', 'Unterzeichnen Sie');
define('BOX_TEXT_UNSUBSCRIBE', 'Entfernen Sie');
define('TEXT_EMAIL_HTML','HTML');
define('TEXT_EMAIL_TXT','TXT');
define('TEXT_EMAIL','Email Adresse:');
define('TEXT_EMAIL_FORMAT','Format');
define('TEXT_EMAIL','Courriel');

define('TEXT_NAME', 'Ihr Name:');
// Unsubscribe
define('UNSUBSCRIBE_TEXT','Entfernen Sie : ');
define('TEXT_BOX1Z','Möchten Sie informiert werden über neue Produkte in den Geschäften? Geben Sie uns Ihre E-Mail-Newsletter zu erhalten speichert.');
define('TEXT_BOX1',' Eingetragene Kunden gehen zu: ');
define('TEXT_BOX2','Ihr Konto: ');

// Sorter for product_info.php
define('PRODUCTS_OPTIONS_SORT_BY_PRICE','1'); // 1= sort by products_options_sort_order + name; 0= sort by products_options_sort_order + price

// Categories Image and Name on product_info.php
define('SHOW_CATEGORIES','0'); // 0= off  1=on
define('TABLE_HEADING_MANUFACTURER', 'Hersteller');

define('BOX_INFORMATION_SITEMAP', 'Sitemap');

define('TEMPORARY_NO_PRICE', 'Kein Preis');
define('PRODUCT_SOLD', 'Verkauft');

//kgt - discount coupons
define('ENTRY_DISCOUNT_COUPON_ERROR', 'Der eigegebene Gutscheincode ist ungültiig.');
define('ENTRY_DISCOUNT_COUPON_AVAILABLE_ERROR', 'Der eingegebene Gutscheincode ist leider bereits verfallen.');
define('ENTRY_DISCOUNT_COUPON_USE_ERROR', 'Sie haben diesen Gutschein bereits %s mal eingelöst.  Sie dürfen; den Gutschein maximal %s mal einlösen.');
define('ENTRY_DISCOUNT_COUPON_MIN_PRICE_ERROR', 'Der Mindestbestellwert für diesen Coupon beträgt %s');
define('ENTRY_DISCOUNT_COUPON', 'Gutschein Code:');
define('ENTRY_DISCOUNT_COUPON_FREE_SHIPPING_ERROR', 'Der Gesamtbetrag unterschreitet nun den Mindestbetrag für kostenfreie Lieferung.');
define('ENTRY_DISCOUNT_COUPON_MIN_QUANTITY_ERROR', 'Die Mindestzahl der Produkte, die für diesen Kupon erfordert werden, ist %s');
define('ENTRY_DISCOUNT_COUPON_EXCLUSION_ERROR', 'Einige oder alle Produkte in Ihrer Karre werden ausgeschlossen.' );
define('ENTRY_DISCOUNT_COUPON_SHIPPING_CALC_ERROR', 'Ihre errechneten Verschiffenaufladungen haben geändert.');
//end kgt - discount coupons


define('SHOPPING_CART_QUANTITY', 'produkte');
define('BOX_HEADING_ADVERTISE', 'Werbung');


define('TABLE_HEADING_IMAGE', '');
define('TABLE_HEADING_MODEL', 'Artikel-Nr.');
define('TABLE_HEADING_PRODUCTS', 'Produkte');
define('TABLE_HEADING_MANUFACTURER', 'Hersteller');
define('TABLE_HEADING_QUANTITY', 'Anzahl');
define('TABLE_HEADING_PRICE', 'Preis');
define('TABLE_HEADING_WEIGHT', 'Gewicht');
define('TABLE_HEADING_BUY_NOW', 'Bestellen');
define('TEXT_NO_PRODUCTS', 'Es gibt keine Produkte.');
define('TABLE_HEADING_PRODUCTS_AVAILABILITY', 'Verwendbarkeit');

define('TEXT_BUY', '1 x \'');
define('TEXT_NOW', '\' bestellen!');

define('BOX_SHOPPING_CART_QUANTITY', 'Produktquantität');
define('BOX_SHOPPING_CART_TOTAL', 'Gesamtmenge');

define('BOX_HEADING_PLATNOSCI', 'Zahlung Online');

// Modlu promocji Polecony-Nagrodzony
define('BOX_HEADING_POLECONY', 'Erzählen Sie uns');
define('BOX_CONTENT_POLECONY', 'Bieten Sie an? Erzählen Sie Ihren Freunden von unserem Online-Shop mit einem Klick und nutzen Sie unsere Angebote!');
define('BOX_DESC_POLECONY', 'Beratung - gewinnen');
define('BOX_LINK_POLECONY', 'Sagen Sie uns!');

define('TITLE_PROMOCJA_POLECONY', 'Promotion-Beratung zu gewinnen');
define('ENTRY_EMIAL_POLECAJACY', 'E-Mail an die Person Empfehlung:');
define('ENTRY_POLECAJACY_ORDERS_ERROR', 'Anweisung der Person, deren E-Mail-Adresse erhalten hat, nicht erfüllt sind noch in unserem Shop, kein Vertrag');

define('RECENTLY_VIEWED_BOX_HEADING','Vor kurzem Anzeige');   // box heading

define('TEXT_KOMUNIKAT','Informationen');   // box heading
define('TEXT_ZAMKNIJ','Ende');
define('TEXT_UWAGA','ACHTUNG');

// nowe
define('POLA_OBOWIAZKOWE','Gekennzeichnet * nicht löschen Aufgaben bis Fülle');
define('CATEGORY_OSOBA','Wahl von der Rechtspersönlichkeit');
define('OSOBA_TEXT','Wählen Sie die Art des zugelassenen Wesens des neuen Benutzers bitte:');
define('FORM_OSOBA_FIZYCZNA','Körperliche Person');
define('FORM_OSOBA_PRAWNA',"Korporation");
define('ZGODA_DANE_OSOBOWE','Ich möchte Informationen über neue Produkte und Angebote auf dem Markt angeboten bekommen
         das Geschäft mit einer Verlegung des Blattes auf meine angegebene E-Mail-Adresse.');
define('PRZETWARZANIE_DANYCH','Ich stimme zu, meine persönlichen Daten und Kommunikation per E-Mail für die Zwecke der Durchführung von Verträgen.');
define('TABLE_HEADING_DOKUMENT_SPRZEDAZY','Dokument des Verkaufes');
define('TEXT_SELECT_DOKUMENT_SPRZEDAZY','Wählt Zeuge vend vor.');
define('TEXT_PARAGON','');
define('TEXT_FAKTURA','');
define('FAKTURA_NIP','(Defektabzeichen KLEMMSTELLE an im Frage Käufer.)');

//definicje zwiazane z wyswietlaniem netto/brutto
define('TEXT_NETTO',' Preis (exkl.)');
define('TEXT_BRUTTO',' Preis (inkl.)');

//pozycje menu
define('HEADER_TITLE_HOME','Anfang');
define('HEADER_TITLE_SPECIALS','Specials');
define('HEADER_TITLE_SEARCH','Suche');
define('HEADER_TITLE_NEWS','Nachrichten');
define('HEADER_TITLE_CONTACTS','Kontakte');
// nowe
define('HEADER_TITLE_LOGINS','Logging');
define('HEADER_TITLE_KOSZ','Warenkorb');
define('HEADER_TITLE_ZAM','Kasse');
define('HEADER_TITLE_HOME2','Heim');
define('HEADER_TITLE_ONAS','Über');
define('HEADER_TITLE_PRODUKTY','Produkte');
define('HEADER_TITLE_USLUGI','Services');
define('HEADER_TITLE_ZASADY','Terms of Käufe');
define('HEADER_TITLE_REGULAMIN','Verordnungen');

define('HEADING_NEWSDESK_STICKY' , 'Wichtige Informationen');

define('BOX_INFORMATION_FAQ' , 'FAQ');

//definicje tekstu do nowej karty o produkcie
define('NONE_REVIEWS','Mangel an Bericht');
define('TEXT_PRODUCT_INFO_REVIEWS','Schätzung');
define('TEXT_MAGAZYN','Bedingung');
define('ZAKLADKA_OPIS','Beschreibung');
define('ZAKLADKA_ZDJECIA','Zusätzliche Fotos');
define('ZAKLADKA_LINKI','Verbindungen');
define('ZAKLADKA_RECENZJE','Berichte');
define('NONE_FOTO','Mangel an zusätzlichem Foto.');
define('TEXT_NONE_REVIEWS','Mangel an Bericht.');

define('OPEN_SHOP','Öffnen Sie Stunden');

//potrzebne jezeli wlaczone jest pole zamawiana ilosc
define('ENTRY_CANTIDAD', 'Quantität:');
//pozycje do przewijanych nowych produktow
define('W_LEWO','<< link');
define('W_PRAWO','recht >>');

define('MY_DISCOUNTS_TITLE','Ermäßigungen für Stammkunden');

// wishlist box text in includes/boxes/wishlist.php
define('BOX_HEADING_CUSTOMER_WISHLIST', 'Mein Wunschzettel');
define('TEXT_WISHLIST_COUNT', 'Elemente werden auf Ihrer Wunschliste: % s');
define('ADD_TO_WISHLIST','Auf den Wunschzettel');
define('TEXT_WISHLIST_TOTAL', 'Wert der: ');
define('ADD_TO_WISHLIST','Dieses Produkt in die Zwischenablage');

define('REDEEM_SYSTEM_ERROR_POINTS_NOT', 'Punkte Werte sind nicht ausreichend zur Deckung der Kosten des Kaufs. Bitte wählen Sie eine andere Zahlungsmethode.');
define('REDEEM_SYSTEM_ERROR_POINTS_OVER', 'Die Anzahl der Punkte können nicht höher sein als der maximale Wert der Kredite für Anschaffungen. <br> Bitte Wiederholen Sie die Punkte.');
define('REFERRAL_ERROR_SELF', '<br>Sie können nicht geben, seine eigene Adresse.');
define('REFERRAL_ERROR_NOT_VALID', '<br>E-Mail-Adresse ist nicht korrekt.');
define('REFERRAL_ERROR_NOT_FOUND', '<br>Da Ihre E-Mail-Adresse nicht gefunden wurde.');
define('TEXT_POINTS_BALANCE', 'Staatliche Kredite');
define('TEXT_POINTS', 'Punkte:');
define('PAYMENT_POINTS','Der Betrag für die gesammelten Punkte');
define('TEXT_VALUE', 'Wert:');
define('REVIEW_HELP_LINK', 'Schreib eine Überprüfung des Produkts, und Sie erhalten von uns <b>%s </b> in die Punkte im Einklang mit dem Punkte-System. Siehe %s, wenn Sie möchten, erhalten weitere Informationen zu erhalten.');
define('REVIEW_HELP_LINK', 'Eine Rezension schreiben, und wir <b>%s </ b> in die Punkte im Einklang mit dem Punkte-System. Siehe %s für weitere Informationen.');
define('BOX_INFORMATION_MY_POINTS_HELP', 'Hilfe');

define('ICON_PDF_PROFORMA_INVOICE', 'Pro-forma-Rechnung');
define('ICON_PDF_DUPLIKAT_INVOICE', 'Doppel der Rechnung');
define('PDF_PROFORMA_INVOICE', 'Wenn Sie wollen, drucken Sie die Proforma-Rechnung im PDF-Format, klicken Sie auf das Symbol');

define('MODULE_SHIPPING_FREEAMOUNT_TEXT', 'Um die Belastung auf Kosten des Verkäufers müssen Sie weitere Einkäufe bei einem Mindestbetrag von : ');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_1', 'Freies Verschiffen nur für einen Auftrag von ');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_2', ' und mehr mit einem maximalen Paketgewicht von ' .MODULE_SHIPPING_FREEAMOUNT_WEIGHT_MAX. ' kg.');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_21', '');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_3', 'Erfüllt die Bedingungen für die Bestellung haben wir die Sendung auf unsere Kosten');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_4', 'Das Gewicht der Sendung von mehr als der Grenzwert für die Kosten der Shop');
define('BOX_HEADING_FREE_SHIPPING', 'Kostenloser Versand');

// Poll Box Text
define('_RESULTS', 'Ergebnisse');
define('_POLLS','Umfragen');
define('_VOTE', 'Abstimmen');
define('_VOTES', 'Trend');
define('_COMMENTS', 'Kommentare');
define('_NOPOLLS','Umfragen');
define('_INNE_ANKIETY','Andere Umfragen');
define('_NOPOLLSCONTENT','Es gibt keine Umfragen für diese Produktkategorie. Sie können jedoch die Ergebnisse der anderen Umfragen<br><br><a href="pollbooth.php"><b>'._INNE_ANKIETY.'</b></a>');

// klub przyjaciol
define('KLUB_TITLE','Club Freunde');
define('KLUB_WITAJ','Willkommen im <b>Club der Freunde</b>');
define('KLUB_TEXT_1','Sehr geehrter Kunde. Da die Summe Ihrer Bestellungen in den letzten ');
define('KLUB_TEXT_2',' Tage in ');
define('KLUB_TEXT_3',' erhalten wir die folgenden Privilegien: ');
define('KLUB_TEKST_RABAT',' discount shopping ');
define('KLUB_TEKST_RABAT_1',' wenn der Vertrag über ');
define('KLUB_PRZESYLKA',' kostenlose Lieferung');

// nowe - logowanie na NICK
define('NN_NICK','Nick');
define('ENTRY_NICK_ERROR', 'Nick Feld muss mindestens ' . ENTRY_NICK_MIN_LENGTH . ' Zeichen enthalten.');
define('ENTRY_NICK_CHECK_ERROR', 'NICK vorhanden in unserem Shop! Benutzername muss eindeutig sein.');
define('ENTRY_EMAIL_NICK', 'E-mail'.((NICK_VALUE=='true')?'/Nick:':''));

// haslo dla klienta
define('ENTRY_HASLO_NOT_MATCHING', 'Passwort eingegeben werden muss die gleiche');
define('ENTRY_HASLO_ERROR', 'Ihr Passwort muss aus mindestens '. ENTRY_PASSWORD_MIN_LENGTH. ' Zeichen');
define('ENTRY_ZLE_HASLO', 'Passwort darf nur aus Buchstaben und Zahlen enthalten.');
define('HASLO_TITLE', 'Passwort für das Konto');
define('HASLO_TEXT_1', 'Geben Sie das Passwort ein:');
define('HASLO_TEXT_2', 'Passwort wiederholen:');
define('HASLO_TEXT_3', 'Ihr Passwort muss mindestens '. ENTRY_PASSWORD_MIN_LENGTH. ' Zeichen und kann nur Buchstaben und Zahlen enthalten. Keine anderen Zeichen sind zulässig.');

define('EMAIL_TEXT_PZDR','Grüße,');
define('JEDNOSTKA_MIARY', 'Maßeinheit');
define('TOP_KOSZYK','den Inhalt Ihres Warenkorb');
define('TOP_SUMA',' wert');

define('TEXT_SHOW_PRZED_CEN','Preis-Strecke:');
define('TEXT_SHOW_PRZED_CEN_OPTION','Umfassendes Angebot');
define('TEXT_SHOW_DOD_POLA','Jeder Wert');
define('TEXT_SHOW_SORT_DOM','Vorgabe');
define('TEXT_SHOW_ILE_NA_STR','Anzahl der Ergebnisse pro Seite:');
define('TEXT_SHOW_DISPLAY','Anzeige:');
define('TEXT_SHOW_DISPLAY_LIST','Running Linien');
define('TEXT_SHOW_DISPLAY_BOX','Anzeigen von Fenstern in');
// inne produkty z kategorii i producenta na karcie produktu
define('TABLE_HEADING_OTHER_PRODUCTS_KAT','Weitere Produkte in der Kategorie');
define('TABLE_HEADING_OTHER_PRODUCTS_MAN','Andere Produkte Hersteller');

define('CENNIK_NAGLOWEK','Preise');

define('TABLE_PAYPAL_EC_HEADING','Mit PayPal');
define('TABLE_PAYPAL_EC_INTRODUCTION','Wenn Sie ein PayPal-Konto können Sie sofort gehen, um die Zahlung.<br>Wenn Sie nicht bereits ein Konto bei uns, dann nach der Zahlung automatisch in das Geschäft des Kunden-Konto erstellt.');
define('BOX_HEADING_PAYPAL', 'Zahlung Online');

// reklamacje
define ('BOX_HEADING_TICKET','Support');
define ('BOX_TICKET_GENERATE','Support Anfrage');
define ('BOX_TICKET_VIEW','Ticket einsehen');
define ('ENTRY_SUBJECT','Überschrift: ');
define ('ENTRY_DEPARTMENT','Abteilung: ');
define ('ENTRY_PRIORITY','Priorit&auml;t: ');

define('ENTRY_EXTRA_FIELDS_ERROR','Feld %s muss mindestens %d Zeichen enthalten');
define('CATEGORY_EXTRA_FIELDS', 'Extra Felder');

//Modul Video
define('VIDEO_1','Film-Clips');
define('VIDEO_2','Video-Clip-Produkt');
define('TEXT_GRATIS_HEADER_1','<b>Sehr geehrter Kunde!</b><br><br>Ihr Antrag die einschlägigen Bedingungen erfuellen, ');
define('TEXT_GRATIS_HEADER_2','damit wir Ihnen ein Geschenk.<br>');
define('TEXT_GRATIS_KWOTA','- wert des Auftrags übersteigt den Betrag von: ');
define('TEXT_GRATIS_PRODUCENT','- wurden hinzugefügt, um den Wagen Produkte des Herstellers: ');
define('TEXT_GRATIS_KATEGORIA','- wurden hinzugefügt, um die Einkaufs-Produkte Kategorie: ');
define('TEXT_GRATIS_SHOP','<br>Wenn Sie eine Bestellung aufgeben, müssen Sie ein a / m Produkten wählen.');
define('TEXT_GRATIS_CHECKOUT','<br>Bitte wählen Sie aus der obigen Liste kostenlos, und es wird in die Sendung aufgenommen werden.');
define('TEXT_GRATIS_HEADING','<b>Geschenke für Einkäufe</b>');
define('TEXT_GRATIS_CONFIRM','Versandkosten werden von Ihnen gewählten Geschenk in Form angefügt:<br>');
define('TEXT_GRATIS_COMMENT','Gratis');

define('TEXT_BUTTON_POROWNAJ','Produkte vergleichen');
define('TEXT_POROWNAJ','Vergleichen');
define('TEXT_POROWNAJ_BLAD','Zum Vergleich können, fügen Sie bis zu 10 Produkte.');
define('TEXT_POROWNAJ_BLAD_2','Kein Produkt ausgewählt ist.');

define('ZAGIEL_OBLICZ_RATE', 'Oblicz Ratę Żagiel');
define('ZAGIEL_RATY_ONSUBMIT', 'onsubmit="if (this.raty_zgoda.checked == false) { alert(\'Zanim złożysz zamówienie, zapoznaj się z procedurą udzielenia kredytu ratalnego Raty Żagiel.\'); return false }"');
define('ZAGIEL_KUPUJ_NA_RATY', 'Kupuj na raty !');
define('ZAGIEL_MIN_ZAKUP', 'Powyżej 100zł kupisz na raty!');
define('BOX_HEADING_ZAGIEL', 'Zakupy na raty');

define('MODULE_SHIPPING_FREECOUNT_QTY', 'Stück');
define('MODULE_SHIPPING_FREECOUNT_TEXT_1', 'Kostenlose Lieferung bei einem Bestellwert über');
define('MODULE_SHIPPING_FREECOUNT_TEXT_2', 'Ihr Antrag erfüllt die Voraussetzungen, die auf unsere Kosten geschickt worden');
define('MODULE_SHIPPING_FREECOUNT_TEXT_3', 'Ihre Bestellung erfüllt nicht die Bedingungen, die auf unsere Kosten gesendet wurde');
define('MODULE_SHIPPING_FREECOUNT_TEXT_4', 'Diejenigen, die noch fehlenden');

define ('IMAGE_BUTTON_MAKE_AN_OFFER', 'Machen Sie ein Angebot');

// naglowek do boxu Ostatnio dodane
define('BOX_HEADING_WHATS_NEW_LAST_10', 'Kürzlich hinzugefügt');
?>