<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

// look in your $PATH_LOCALE/locale directory for available locales
// or type locale -a on the server.
// Examples:
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
@setlocale(LC_TIME, 'en_US.UTF-8');

define('DATE_FORMAT_SHORT', '%m/%d/%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for strftime()
define('DATE_FORMAT', 'm/d/Y'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 3, 2) . substr($date, 0, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 0, 2) . substr($date, 3, 2);
  }
}

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
define('HTML_PARAMS','dir="LTR" lang="en"');

// charset for web pages and emails
define('CHARSET', 'utf-8');

// page title
define('TITLE', 'AmberStore');

// header text in includes/header.php
define('HEADER_TITLE_CREATE_ACCOUNT', 'Create an Account');
define('HEADER_TITLE_MY_ACCOUNT', 'My Account');
define('HEADER_TITLE_CART_CONTENTS', 'Shopping Cart');
define('HEADER_TITLE_CHECKOUT', 'Checkout');
define('HEADER_TITLE_TOP', 'Top');
define('HEADER_TITLE_CATALOG', 'Catalog');
define('HEADER_TITLE_LOGOFF', 'Log Off');
define('HEADER_TITLE_LOGIN', 'Log In');

// footer text in includes/footer.php
define('FOOTER_TEXT_REQUESTS_SINCE', 'requests since');

// text for gender
define('MALE', 'Male');
define('FEMALE', 'Female');
define('MALE_ADDRESS', 'Mr.');
define('FEMALE_ADDRESS', 'Ms.');

// text for date of birth example
define('DOB_FORMAT_STRING', 'mm/dd/yyyy');

// categories box text in includes/boxes/categories.php
define('BOX_HEADING_CATEGORIES', 'Categories');

// manufacturers box text in includes/boxes/manufacturers.php
define('BOX_HEADING_MANUFACTURERS', 'Manufacturers');

// whats_new box text in includes/boxes/whats_new.php
define('BOX_HEADING_WHATS_NEW', 'What\'s New?');

// quick_find box text in includes/boxes/quick_find.php
define('BOX_HEADING_SEARCH', 'Quick Find');
define('BOX_SEARCH_TEXT', 'Use keywords to find the product you are looking for.');
define('BOX_SEARCH_ADVANCED_SEARCH', 'Advanced Search');

// specials box text in includes/boxes/specials.php
define('BOX_HEADING_SPECIALS', 'Specials');

// reviews box text in includes/boxes/reviews.php
define('BOX_HEADING_REVIEWS', 'Reviews');
define('BOX_REVIEWS_WRITE_REVIEW', 'Write a review on this product!');
define('BOX_REVIEWS_NO_REVIEWS', 'There are currently no product reviews');
define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s of 5 Stars!');

// shopping_cart box text in includes/boxes/shopping_cart.php
define('BOX_HEADING_SHOPPING_CART', 'Shopping Cart');
define('BOX_SHOPPING_CART_EMPTY', '0 items');

// order_history box text in includes/boxes/order_history.php
define('BOX_HEADING_CUSTOMER_ORDERS', 'Order History');

// best_sellers box text in includes/boxes/best_sellers.php
define('BOX_HEADING_BESTSELLERS', 'Bestseller');
define('BOX_HEADING_BESTSELLERS_IN', 'Bestseller in<br>&nbsp;&nbsp;');

// notifications box text in includes/boxes/products_notifications.php
define('BOX_HEADING_NOTIFICATIONS', 'Notifications');
define('BOX_NOTIFICATIONS_NOTIFY', 'Notify me of updates to <b>%s</b>');
define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'Do not notify me of updates to <b>%s</b>');

// manufacturer box text
define('BOX_HEADING_MANUFACTURER_INFO', 'Manufacturer Info');
define('BOX_MANUFACTURER_INFO_HOMEPAGE', '%s Homepage');
define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Other products');

// languages box text in includes/boxes/languages.php
define('BOX_HEADING_LANGUAGES', 'Language');

// currencies box text in includes/boxes/currencies.php
define('BOX_HEADING_CURRENCIES', 'Currencies');

// information box text in includes/boxes/information.php
define('BOX_HEADING_INFORMATION', 'Information');
define('BOX_INFORMATION_PRIVACY', 'Privacy Notice');
define('BOX_INFORMATION_CONDITIONS', 'Conditions of Use');
define('BOX_INFORMATION_SHIPPING', 'Shipping & Returns');
define('BOX_INFORMATION_CONTACT', 'Contact Us');

// tell a friend box text in includes/boxes/tell_a_friend.php
define('BOX_HEADING_TELL_A_FRIEND', 'Tell A Friend');
define('BOX_TELL_A_FRIEND_TEXT', 'Tell someone you know about this product.');

// checkout procedure text
define('CHECKOUT_BAR_DELIVERY', 'Delivery Information');
define('CHECKOUT_BAR_PAYMENT', 'Payment Information');
define('CHECKOUT_BAR_CONFIRMATION', 'Confirmation');
define('CHECKOUT_BAR_FINISHED', 'Finished!');
define('CHECKOUT_BAR_SHIPPEY', 'Shipping & Payment');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Please Select');
define('TYPE_BELOW', 'Type Below');

// javascript messages
define('JS_ERROR', 'Errors have occured during the process of your form.\n\nPlease make the following corrections:\n\n');

define('JS_REVIEW_TEXT', '* The \'Review Text\' must have at least ' . REVIEW_TEXT_MIN_LENGTH . ' characters.\n');
define('JS_REVIEW_RATING', '* You must rate the product for your review.\n');

define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Please select a payment method for your order.\n');

define('JS_ERROR_SUBMITTED', 'This form has already been submitted. Please press Ok and wait for this process to be completed.');

define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Please select a payment method for your order.');

define('CATEGORY_COMPANY', 'Company Details');
define('CATEGORY_PERSONAL', 'Your Personal Details');
define('CATEGORY_ADDRESS', 'Your Address');
define('CATEGORY_CONTACT', 'Your Contact Information');
define('CATEGORY_OPTIONS', 'Options');
define('CATEGORY_PASSWORD', 'Your Password');

define('ENTRY_COMPANY', 'Company Name:');
define('ENTRY_COMPANY_ERROR', '');
define('ENTRY_COMPANY_TEXT', '');

define('ENTRY_NIP', 'Registration Number (VAT):');
define('ENTRY_NIP_ERROR', '');
define('ENTRY_NIP_TEXT', '');

define('ENTRY_GENDER', 'Gender:');
define('ENTRY_GENDER_ERROR', 'Please select your Gender.');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'First Name:');
define('ENTRY_FIRST_NAME_ERROR', 'Your First Name must contain a minimum of ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' characters.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Last Name:');
define('ENTRY_LAST_NAME_ERROR', 'Your Last Name must contain a minimum of ' . ENTRY_LAST_NAME_MIN_LENGTH . ' characters.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Date of Birth:');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'Date of Birth error');
define('ENTRY_EMAIL_ADDRESS', 'Email:');
define('ENTRY_EMAIL_ADDRESS_CONFIRM', 'Confirm Email:');
define('ENTRY_EMAIL_ADDRESS_CONFIRM_NOT_MATCHING', 'The Confirmation Email must match your Email Address.');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'Your E-Mail Address must contain a minimum of ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' characters.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Your E-Mail Address does not appear to be valid - please make any necessary corrections.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Your E-Mail Address already exists in our records - please log in with the e-mail address or create an account with a different address.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Street Address:');
define('ENTRY_STREET_ADDRESS_DOM', 'House number:');
define('ENTRY_STREET_ADDRESS_DOM_ERROR', 'No home field can not be empty');
define('ENTRY_STREET_ADDRESS_MIESZKANIE', 'No premises:');
define('ENTRY_STREET_ADDRESS_ERROR', 'Your Street Address must contain a minimum of ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' characters.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Suburb:');
define('ENTRY_SUBURB_ERROR', '');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Post Code:');
define('ENTRY_POST_CODE_ERROR', 'Your Post Code must contain a minimum of ' . ENTRY_POSTCODE_MIN_LENGTH . ' characters.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'City:');
define('ENTRY_CITY_ERROR', 'Your City must contain a minimum of ' . ENTRY_CITY_MIN_LENGTH . ' characters.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'State/Province:');
define('ENTRY_STATE_ERROR', 'Your State must contain a minimum of ' . ENTRY_STATE_MIN_LENGTH . ' characters.');
define('ENTRY_STATE_ERROR_SELECT', 'Please select a state from the States pull down menu.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Country:');
define('ENTRY_COUNTRY_ERROR', 'You must select a country from the Countries pull down menu.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Telephone Number:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Your Telephone Number must contain a minimum of ' . ENTRY_TELEPHONE_MIN_LENGTH . ' characters.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Fax Number:');
define('ENTRY_FAX_NUMBER_ERROR', '');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Newsletter');
define('ENTRY_NEWSLETTER_OPIS', '(A notice of departure is at any time possible)');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'Subscribed');
define('ENTRY_NEWSLETTER_NO', 'Unsubscribed');
define('ENTRY_NEWSLETTER_ERROR', '');
define('ENTRY_PASSWORD', 'Password:');
define('ENTRY_PASSWORD_ERROR', 'Your Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'The Password Confirmation must match your Password.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Password Confirmation:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Current Password:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Your Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW', 'New Password:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Your new Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'The Password Confirmation must match your new Password.');
define('PASSWORD_HIDDEN', '--HIDDEN--');
// BOC added for Account Agreement
define('ENTRY_AGREEMENT', ' By clicking this box you are agreeing that you have read and agree to all terms and conditions of this website.');
//Modify your account agreement here
define('ENTRY_AGREEMENT_ERROR', 'You must check the account agreement box to set up an accout.');
define('ENTRY_AGREEMENT_TEXT', '*');
define('TEXT_ACCOUNT_AGREEMENT','Account Agreement');
// EOC added for Account Agreement

define('FORM_REQUIRED_INFORMATION', '* Required information');

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Result Pages:');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> products)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> orders)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> reviews)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> new products)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> specials)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'First Page');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Previous Page');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Next Page');
define('PREVNEXT_TITLE_LAST_PAGE', 'Last Page');
define('PREVNEXT_TITLE_PAGE_NO', 'Page %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Previous Set of %d Pages');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Next Set of %d Pages');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;FIRST');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;Prev]');
define('PREVNEXT_BUTTON_NEXT', '[Next&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'LAST&gt;&gt;');

define('IMAGE_BUTTON_ADD_ADDRESS', 'Add Address');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Address Book');
define('IMAGE_BUTTON_BACK', 'Back');
define('IMAGE_BUTTON_BUY_NOW', 'Buy Now');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Change Address');
define('IMAGE_BUTTON_CHECKOUT', 'Checkout');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Confirm Order');
define('IMAGE_BUTTON_CONTINUE', 'Continue');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Continue Shopping');
define('IMAGE_BUTTON_DELETE', 'Delete');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'Edit Account');
define('IMAGE_BUTTON_HISTORY', 'Order History');
define('IMAGE_BUTTON_LOGIN', 'Sign In');
define('IMAGE_BUTTON_IN_CART', 'Add to Cart');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Notifications');
define('IMAGE_BUTTON_QUICK_FIND', 'Quick Find');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Remove Notifications');
define('IMAGE_BUTTON_REVIEWS', 'Reviews');
define('IMAGE_BUTTON_SEARCH', 'Search');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Shipping Options');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Tell a Friend');
define('IMAGE_BUTTON_UPDATE', 'Update');
define('IMAGE_BUTTON_UPDATE_CART', 'Update Cart');
define('IMAGE_BUTTON_WRITE_REVIEW', 'Write Review');

define('SMALL_IMAGE_BUTTON_DELETE', 'Delete');
define('SMALL_IMAGE_BUTTON_EDIT', 'Edit');
define('SMALL_IMAGE_BUTTON_VIEW', 'View');

define('ICON_ARROW_RIGHT', 'more');
define('ICON_CART', 'In Cart');
define('ICON_ERROR', 'Error');
define('ICON_SUCCESS', 'Success');
define('ICON_WARNING', 'Warning');

define('TEXT_GREETING_PERSONAL', 'Welcome back <span class="greetUser">%s!</span> Would you like to see which <a href="%s"><u>new products</u></a> are available to purchase?');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>If you are not %s, please <a href="%s"><u>log yourself in</u></a> with your account information.</small>');
define('TEXT_GREETING_GUEST', 'Welcome <span class="greetUser">Guest!</span> Would you like to <a href="%s"><u>log yourself in</u></a>? Or would you prefer to <a href="%s"><u>create an account</u></a>?');

define('TEXT_SORT_PRODUCTS', 'Sort products ');
define('TEXT_DESCENDINGLY', 'descendingly');
define('TEXT_ASCENDINGLY', 'ascendingly');
define('TEXT_BY', ' by ');

define('TEXT_REVIEW_BY', 'by %s');
define('TEXT_REVIEW_WORD_COUNT', '%s words');
define('TEXT_REVIEW_RATING', 'Rating: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Date Added: %s');
define('TEXT_NO_REVIEWS', 'There are currently no product reviews.');

define('TEXT_NO_NEW_PRODUCTS', 'There are currently no products.');

define('TEXT_UNKNOWN_TAX_RATE', 'Unknown tax rate');

define('TEXT_REQUIRED', '<span class="errorText">Required</span>');

define('ERROR_TEP_MAIL', '<font face="Verdana, Arial" size="2" color="#ff0000"><b><small>TEP ERROR:</small> Cannot send the email through the specified SMTP server. Please check your php.ini setting and correct the SMTP server if necessary.</b></font>');
define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Warning: Installation directory exists at: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/install. Please remove this directory for security reasons.');
define('WARNING_CONFIG_FILE_WRITEABLE', 'Warning: I am able to write to the configuration file: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/includes/configure.php. This is a potential security risk - please set the right user permissions on this file.');
define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Warning: The sessions directory does not exist: ' . tep_session_save_path() . '. Sessions will not work until this directory is created.');
define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Warning: I am not able to write to the sessions directory: ' . tep_session_save_path() . '. Sessions will not work until the right user permissions are set.');
define('WARNING_SESSION_AUTO_START', 'Warning: session.auto_start is enabled - please disable this php feature in php.ini and restart the web server.');
define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Warning: The downloadable products directory does not exist: ' . DIR_FS_DOWNLOAD . '. Downloadable products will not work until this directory is valid.');

define('TEXT_CCVAL_ERROR_INVALID_DATE', 'The expiry date entered for the credit card is invalid.<br>Please check the date and try again.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'The credit card number entered is invalid.<br>Please check the number and try again.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'The first four digits of the number entered are: %s<br>If that number is correct, we do not accept that type of credit card.<br>If it is wrong, please try again.');

/*
  Poniższa informacja o prawie autorskim może być
  modyfikowana lub usunięta jedynie gdy wygląd serwisu
  został zmieniony i różni się od domyślnego zastrzeżonego
  prawem wyglądu osCommerce.

  Więcej informacji znajdziesz w FAQ na stronie wsparcia
  osCommerce:

        http://www.oscommerce.com/about/copyright

  Pozostaw ten komentarz nienaruszony wraz z następującą
  informacją o prawach autorskich.
*/

define('FOOTER_TEXT_BODY', 'Powered &copy; <a class="boxLink" href="http://www.oscgold.com" target="_blank">oscGold</a>');
define('NAVBAR_TITLE', 'Reviews');
define('ITEMS_IN_CART', 'now in your cart');
define('NEW_PRODUCTS', 'New Products');
define('TABLE_HEADING_PRICE', 'Price');
define('HEADING_PRODUCT_INFO','Product Info');
define('ITEM_PRICE','Item price:');
define('HEADING_PRODUCT_REVIEWS','Reviews');
define('HEADING_CHOOS_LANG','Choose');
define('PRODUCT_INFO_DESCRIPTION','Description');

//Star product Start
define('STAR_TITLE', 'Star Product'); // star product
define('STAR_READ_MORE', ' ... read more.'); // ... read more.
//Star product End

// Begin EZier new fields
define('TABLE_HEADING_RETAIL_PRICE', 'Retail');
define('TABLE_HEADING_SAVE', 'Savings');
define('TEXT_PRODUCTS_RETAIL_PRICE_INFO', 'Retail Price: ');
define('TEXT_PRODUCTS_PRICE_INFO', 'Your Price: ');
define('TEXT_PRODUCTS_PRICE_INFO_REGULAR', 'Regular Price: ');
define('TEXT_PRODUCTS_SAVE_INFO', '<font color=red>You Save: ');
define('TEXT_PRODUCTS_RETAIL_PRICE', 'Products Retail Price: ');
define('TEXT_PRODUCTS_PRICE_SPECIAL_INFO', '<font color=red>Special Price: ');
define('TEXT_PRODUCTS_PRICE_SPECIAL_CUST', '<font color=red>Your Discounted Price: ');
// EZier new fields end

define('WHATS_NEW_ALL','View all');

//themes
define('BOX_HEADING_THEMES', 'Themes');

// START: Extra Infopages Manager
define('BOX_HEADING_PAGES', 'Information');
// END: Extra Infopages Manager

//BEGIN allprods modification
define('BOX_INFORMATION_ALLPRODS', 'View all products');
//END allprods modification

define('ENTRY_NIP_NULL_ERROR', 'Insert Registration Number (VAT)');
define('ENTRY_NIP_ERROR', 'Wrong Registration Number (VAT)');
define('ENTRY_NIP', 'Registration Number (VAT):');
define('ENTRY_NIP_TEXT', '');

define('IMAGE_BUTTON_PRINT_ORDER', 'Order printable');

//TotalB2B start
define('PRICES_LOGGED_IN_TEXT','Must be logged<br>in for prices');
//TotalB2B end

//Kontakt Start
define('BOX_HEADING_KONTAKT','Contact');
//Kontakt End

//Linki Start
define('BOX_HEADING_LINKI','Links');
//Linki End


// previous next product
define('PREV_NEXT_PRODUCT', 'Product');
define('PREV_NEXT_FROM', 'of');
define('PREV_NEXT_IN_CATEGORY', 'in category');

// box text in includes/boxes/advsearch.php
define('BOX_HEADING_ADVSEARCH', 'Search');
define('BOX_ADVSEARCH_KW', 'Keyword(s):');
define('BOX_ADVSEARCH_PRICERANGE', 'Price Range:');
define('BOX_ADVSEARCH_PRICESEP', ' to ');
define('BOX_ADVSEARCH_CAT', 'Category:');
define('BOX_ADVSEARCH_ALLCAT', 'Any');

//Related Products
define('TABLE_HEADING_RELATED_PRODUCTS', 'Related Products');
define('TEXT_PRICE', 'Price');

// newsdesk box text in includes/boxes/newsdesk.php
define('TABLE_HEADING_NEWSDESK', 'News and Information');
define('TEXT_NO_NEWSDESK_NEWS', 'Sorry but there is no News');
define('TEXT_NEWSDESK_READMORE', 'Read More');
define('TEXT_NEWSDESK_VIEWED', 'Viewed:');

define('BOX_HEADING_NEWSDESK_CATEGORIES', 'News Categories');
define('BOX_HEADING_NEWSDESK_LATEST', 'Latest News');

define('TEXT_DISPLAY_NUMBER_OF_ARTICLES', 'Displaying <b>%d</b> to <b>%d</b> (of <b>%d</b> articles)');
define('TABLE_HEADING_NEWSDESK_SUBCAT', 'News - Subcategories');
//END -- newsdesk

//START - GiftWrap
define('TEXT_ENTER_GIFTWRAP_INFORMATION', 'Select Packing Option');
//END - GiftWrap

//START - Additional Images
define('TEXT_ADDITIONAL_IMAGES', 'Additional Images');
//END - Additional Images

// Who's online
define('BOX_HEADING_WHOS_ONLINE', 'Who\'s online?');
define('BOX_WHOS_ONLINE_THEREIS', 'There currently is');
define('BOX_WHOS_ONLINE_THEREARE', 'There currently are');
define('BOX_WHOS_ONLINE_GUEST', 'guest');
define('BOX_WHOS_ONLINE_GUESTS', 'guests');
define('BOX_WHOS_ONLINE_AND', 'and');
define('BOX_WHOS_ONLINE_MEMBER', 'member');
define('BOX_WHOS_ONLINE_MEMBERS', 'members');

// +Country-State Selector
define ('DEFAULT_COUNTRY', '223');
// -Country-State Selector

//recently viewed box
define('BOX_HEADING_RECENTLY_VIEWED','Recently Viewed');
define('NO_RECENTLY_VIEWED','Not viewed any products');

// subscribers box text in includes/boxes/subscribers.php
define('BOX_HEADING_SUBSCRIBERS', 'Newsletter');
define('BOX_TEXT_SUBSCRIBE', 'Subscribe');
define('BOX_TEXT_UNSUBSCRIBE', 'Unsubscribe');
define('TEXT_EMAIL_HTML','HTML');
define('TEXT_EMAIL_TXT','TXT');
define('TEXT_EMAIL','E-Mail Address:');
define('TEXT_EMAIL_FORMAT','Format');
define('TEXT_EMAIL','Courriel');

define('TEXT_NAME', 'Your Name:');
// Unsubscribe
define('UNSUBSCRIBE_TEXT','Unsubscribe : ');
define('TEXT_BOX1Z','Do you want to be kept informed about new products in stores ? Give us your e-mail newsletter to receive stores.');
define('TEXT_BOX1',' Registered customers go to: ');
define('TEXT_BOX2','Your Account: ');

// Sorter for product_info.php
define('PRODUCTS_OPTIONS_SORT_BY_PRICE','0'); // 1= sort by products_options_sort_order + name; 0= sort by products_options_sort_order + price

// Categories Image and Name on product_info.php
define('SHOW_CATEGORIES','0'); // 0= off  1=on
define('TABLE_HEADING_MANUFACTURER', 'Manufacturer');

define('BOX_INFORMATION_SITEMAP', 'Site Map');

define('TEMPORARY_NO_PRICE', 'No Price');
define('PRODUCT_SOLD', 'Sold');

define('TABLE_HEADING_IMAGE', '');
define('TABLE_HEADING_MODEL', 'Catalog No.');
define('TABLE_HEADING_PRODUCTS', 'Product Name');
define('TABLE_HEADING_MANUFACTURER', 'Manufacturer');
define('TABLE_HEADING_QUANTITY', 'Quantity');
define('TABLE_HEADING_PRICE', 'Price');
define('TABLE_HEADING_WEIGHT', 'Weight');
define('TABLE_HEADING_BUY_NOW', 'Buy Now');
define('TEXT_NO_PRODUCTS', 'There are no products.');
define('TABLE_HEADING_PRODUCTS_AVAILABILITY', 'Availability');

define('TEXT_BUY', 'Buy 1 \'');
define('TEXT_NOW', '\' now');

define('SHOPPING_CART_QUANTITY', 'items');
define('BOX_HEADING_ADVERTISE', 'Advertise');

//kgt - discount coupons
define('ENTRY_DISCOUNT_COUPON_ERROR', 'The coupon code you have entered is not valid.');
define('ENTRY_DISCOUNT_COUPON_AVAILABLE_ERROR', 'The coupon code you have entered is no longer valid.');
define('ENTRY_DISCOUNT_COUPON_USE_ERROR', 'Our records show that you have used this coupon %s time(s).  You may not use this code more than %s time(s).');
define('ENTRY_DISCOUNT_COUPON_MIN_PRICE_ERROR', 'The minimum order total for this coupon is %s');
define('ENTRY_DISCOUNT_COUPON_MIN_QUANTITY_ERROR', 'The minimum number of products required for this coupon is %s');
define('ENTRY_DISCOUNT_COUPON_EXCLUSION_ERROR', 'Some or all of the products in your cart are excluded.' );
define('ENTRY_DISCOUNT_COUPON', 'Coupon Code:');
define('ENTRY_DISCOUNT_COUPON_FREE_SHIPPING_ERROR', 'Your order total is now below the free shipping minimum.');
define('ENTRY_DISCOUNT_COUPON_SHIPPING_CALC_ERROR', 'Your calculated shipping charges have changed.');
//end kgt - discount coupons

define('BOX_SHOPPING_CART_QUANTITY', 'Products quantity');
define('BOX_SHOPPING_CART_TOTAL', 'Total');

define('BOX_HEADING_PLATNOSCI', 'Payment Online');

// Modlu promocji Polecony-Nagrodzony
define('BOX_HEADING_POLECONY', 'Tell our shop');
define('BOX_CONTENT_POLECONY', 'Do you offer? Tell your friends about our store with one click and take advantage of our promotions');
define('BOX_DESC_POLECONY', 'Advice - winning');
define('BOX_LINK_POLECONY', 'Tell our shop !');

define('TITLE_PROMOCJA_POLECONY', 'Promotion-winning advice');
define('ENTRY_EMIAL_POLECAJACY', 'E-mail the person recommendation:');
define('ENTRY_POLECAJACY_ORDERS_ERROR', 'Instructing the person whose e-mail address given has not met yet in our shop, no contract');

define('RECENTLY_VIEWED_BOX_HEADING','Recently Viewed');   // box heading

define('TEXT_KOMUNIKAT','Information');   // box heading
define('TEXT_ZAMKNIJ','Close');
define('TEXT_UWAGA','WARNING');

// nowe
define('POLA_OBOWIAZKOWE','Of Pol marked * are required for filling up');
define('CATEGORY_OSOBA','Trade-off personalities businesses');
define('OSOBA_TEXT','Please, choose kind of personality of legal new user');
define('FORM_OSOBA_FIZYCZNA','Personal');
define('FORM_OSOBA_PRAWNA',"Company");
define('ZGODA_DANE_OSOBOWE','I would like to receive information about new products and promotions offered to the market
        the shop with a transfer of the Bulletin on my given e-mail address.');
define('PRZETWARZANIE_DANYCH','I agree to my personal data and communication
        via e-mail for purposes related to the implementation of contracts.');
define('TABLE_HEADING_DOKUMENT_SPRZEDAZY','Document of sale');
define('TEXT_SELECT_DOKUMENT_SPRZEDAZY','Selects voucher vend.');
define('TEXT_PARAGON','');
define('TEXT_FAKTURA','');
define('FAKTURA_NIP','(Paragon badge NIP on in question shopper.)');

//definicje zwiazane z wyswietlaniem netto/brutto
define('TEXT_NETTO',' (excl. TAX)');
define('TEXT_BRUTTO',' (incl. TAX)');

//pozycje menu
define('HEADER_TITLE_HOME','Home');
define('HEADER_TITLE_SPECIALS','Specials');
define('HEADER_TITLE_SEARCH','Search');
define('HEADER_TITLE_NEWS','News');
define('HEADER_TITLE_CONTACTS','Contacts');
// nowe
define('HEADER_TITLE_LOGINS','Logging');
define('HEADER_TITLE_KOSZ','Shopping Cart');
define('HEADER_TITLE_ZAM','Checkout');
define('HEADER_TITLE_HOME2','Home');
define('HEADER_TITLE_ONAS','About');
define('HEADER_TITLE_PRODUKTY','Products');
define('HEADER_TITLE_USLUGI','Services');
define('HEADER_TITLE_ZASADY','Terms of purchases');
define('HEADER_TITLE_REGULAMIN','Regulations');

define('HEADING_NEWSDESK_STICKY' , 'Important Informations');

define('BOX_INFORMATION_FAQ' , 'FAQ');

//definicje tekstu do nowej karty o produkcie
define('NONE_REVIEWS','Lack of review');
define('TEXT_PRODUCT_INFO_REVIEWS','Estimate');
define('TEXT_MAGAZYN','Quantity');
define('ZAKLADKA_OPIS','Description');
define('ZAKLADKA_ZDJECIA','Additional photos');
define('ZAKLADKA_LINKI','Links');
define('ZAKLADKA_RECENZJE','Reviews');
define('NONE_FOTO','Lack of additional photo.');
define('TEXT_NONE_REVIEWS','Lack of review.');

define('OPEN_SHOP','Open Hours');

//potrzebne jezeli wlaczone jest pole zamawiana ilosc
define('ENTRY_CANTIDAD', 'Quantity:');
//pozycje do przewijanych nowych produktow
define('W_LEWO','<< left');
define('W_PRAWO','right >>');

define('MY_DISCOUNTS_TITLE','Discounts for regular customers');

// wishlist box text in includes/boxes/wishlist.php
define('BOX_HEADING_CUSTOMER_WISHLIST', 'My Wishlist');
define('TEXT_WISHLIST_COUNT', 'Currently %s items are on your Wish List.');
define('ADD_TO_WISHLIST','Add to Wishlist');
define('TEXT_WISHLIST_TOTAL', 'Value of the: ');

define('REDEEM_SYSTEM_ERROR_POINTS_NOT', 'Points values are not sufficient to cover the cost of purchase. Please select another payment method.');
define('REDEEM_SYSTEM_ERROR_POINTS_OVER', 'The number of points can not be higher than the maximum value of credits on purchases. <br> Please re-enter the points.');
define('REFERRAL_ERROR_SELF', '<br>You can not give his own address.');
define('REFERRAL_ERROR_NOT_VALID', '<br>E-mail address is not correct.');
define('REFERRAL_ERROR_NOT_FOUND', '<br>Given your e-mail address has not been found.');
define('TEXT_POINTS_BALANCE', 'State credits');
define('TEXT_POINTS', 'Points:');
define('PAYMENT_POINTS','The amount collected for points');
define('TEXT_VALUE', 'Value:');
define('REVIEW_HELP_LINK', 'Write a review of the product, and you will get from us <b>%s</b> in the points in accordance with the points system. See %s if you want to get more information.');
define('REVIEW_HELP_LINK', 'Write a review, and we\'ll <b>%s </b> in the points in accordance with the points system. See %s for more information.');
define('BOX_INFORMATION_MY_POINTS_HELP', 'Helpc');

define('ICON_PDF_PROFORMA_INVOICE', 'Invoice PRO FORMA');
define('ICON_PDF_DUPLIKAT_INVOICE', 'Duplicate invoice');
define('PDF_PROFORMA_INVOICE', 'If you want to print the Proforma invoice in PDF format, click on the icon');

define('MODULE_SHIPPING_FREEAMOUNT_TEXT', 'To obtain the load at the expense of the seller you need to make further purchases at a minimum amount of : ');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_1', 'Free shipping only for an order of ');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_2', ' and more with a maximum package weight of ' .MODULE_SHIPPING_FREEAMOUNT_WEIGHT_MAX. ' kg.');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_21', '');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_3', 'Satisfies the conditions of your order, we sent the shipment at our expense');
define('MODULE_SHIPPING_FREEAMOUNT_TEXT_4', 'The weight of the consignment exceeds the limit value fixed for the cost of shop');
define('BOX_HEADING_FREE_SHIPPING', 'Free Shipping');

// Poll Box Text
define('_RESULTS', 'Results');
define('_POLLS','Polls');
define('_VOTE', 'Vote');
define('_VOTES', 'Total Votes');
define('_COMMENTS', 'Comments');
define('_NOPOLLS','Polls');
define('_INNE_ANKIETY','Other polls');
define('_NOPOLLSCONTENT','There are no polls for this product category. However, you can view the results of other polls<br><br><a href="pollbooth.php"><b>'._INNE_ANKIETY.'</b></a>');

// klub przyjaciol
define('KLUB_TITLE','Club amigos');
define('KLUB_WITAJ','Welcome to the<b>Club of Friends</b>');
define('KLUB_TEXT_1','Dear Customer. Since the sum of your orders over the past ');
define('KLUB_TEXT_2',' days over ');
define('KLUB_TEXT_3',' we get the following privileges: ');
define('KLUB_TEKST_RABAT',' discount shopping ');
define('KLUB_TEKST_RABAT_1',' if the contract exceeds ');
define('KLUB_PRZESYLKA',' free shipment');

define('NN_NICK','Nick');
define('ENTRY_NICK_ERROR', 'Nick Field must contain a minimum of ' . ENTRY_NICK_MIN_LENGTH . ' characters.');
define('ENTRY_NICK_CHECK_ERROR', 'NICK specified already exists in our shop! Nickname must be unique.');
define('ENTRY_EMAIL_NICK', 'E-mail'.((NICK_VALUE=='true')?'/Nick:':''));

// haslo dla klienta
define('ENTRY_HASLO_NOT_MATCHING', 'Password entered must be the same');
define('ENTRY_HASLO_ERROR', 'Your password must consist of a minimum '.ENTRY_PASSWORD_MIN_LENGTH.' characters');
define('ENTRY_ZLE_HASLO', 'Password can only consist of letters and numbers.');
define('HASLO_TITLE', 'Account Password');
define('HASLO_TEXT_1', 'Enter password:');
define('HASLO_TEXT_2', 'Retype password:');
define('HASLO_TEXT_3', 'Your password must contain a minimum of '. ENTRY_PASSWORD_MIN_LENGTH. ' characters and can only contain letters and numbers. No other characters are permitted. ');

define('EMAIL_TEXT_PZDR','Regards,');
define('JEDNOSTKI_MIARY', 'Unit of measurement');
define('TOP_KOSZYK','the contents of your shopping cart');
define('TOP_SUMA',' value');

define('TEXT_SHOW_PRZED_CEN','Price Range:');
define('TEXT_SHOW_PRZED_CEN_OPTION','Full range');
define('TEXT_SHOW_DOD_POLA','Any value');
define('TEXT_SHOW_SORT_DOM','Default');
define('TEXT_SHOW_ILE_NA_STR','Number of results per page:');
define('TEXT_SHOW_DISPLAY','Display:');
define('TEXT_SHOW_DISPLAY_LIST','Running lines');
define('TEXT_SHOW_DISPLAY_BOX','Viewing windows in');
// inne produkty z kategorii i producenta na karcie produktu
define('TABLE_HEADING_OTHER_PRODUCTS_KAT','Other products in category');
define('TABLE_HEADING_OTHER_PRODUCTS_MAN','Other products manufacturer');

define('CENNIK_NAGLOWEK','Price-list');

define('TABLE_PAYPAL_EC_HEADING','Use PayPal');
define('TABLE_PAYPAL_EC_INTRODUCTION','If you have a PayPal account you can immediately proceed to the payment.<br>If you do not already have an account with us, then after payment is automatically created in the store the client account.');
define('BOX_HEADING_PAYPAL','Payment Online');

// reklamacje
define ('BOX_HEADING_TICKET','Support Ticket');
define ('BOX_TICKET_GENERATE','Open Support Ticket');
define ('BOX_TICKET_VIEW','View Ticket');
define ('ENTRY_SUBJECT','Subject: ');
define ('ENTRY_DEPARTMENT','Department: ');
define ('ENTRY_PRIORITY','Priority: ');

define('ENTRY_EXTRA_FIELDS_ERROR','Field %s must contain a minimum of %d characters');
define('CATEGORY_EXTRA_FIELDS', 'Extra Fields');

//Modul Video
define('VIDEO_1','Film Clips');
define('VIDEO_2','Video Clip product');
define('TEXT_GRATIS_HEADER_1','<b>Dear Customer, </b><br><br> your order meets the relevant conditions');
define('TEXT_GRATIS_HEADER_2','therefore, you will receive a gift from us.<br>');
define('TEXT_GRATIS_KWOTA','- the value of the contract exceeded the amount of: ');
define('TEXT_GRATIS_PRODUCENT','- have been added to your shopping cart products manufacturer: ');
define('TEXT_GRATIS_KATEGORIA','- have been added to your shopping cart products from the category: ');
define('TEXT_GRATIS_SHOP','<br>You can choose that to receive at folding of order want.');
define('TEXT_GRATIS_CHECKOUT','<br>Please, choose gift from list, it will be affixed to package.');
define('TEXT_GRATIS_HEADING','<b>Gift</b>');
define('TEXT_GRATIS_CONFIRM','Chosen will be added for package by you gift in the form.<br>');
define('TEXT_GRATIS_COMMENT','Free');

define('TEXT_BUTTON_POROWNAJ','Compare Products');
define('TEXT_POROWNAJ','Compare');
define('TEXT_POROWNAJ_BLAD','For comparison, you can add up to 10 products.');
define('TEXT_POROWNAJ_BLAD_2','No product is selected.');

define('ZAGIEL_OBLICZ_RATE', 'Oblicz Ratę Żagiel');
define('ZAGIEL_RATY_ONSUBMIT', 'onsubmit="if (this.raty_zgoda.checked == false) { alert(\'Zanim złożysz zamówienie, zapoznaj się z procedurą udzielenia kredytu ratalnego Raty Żagiel.\'); return false }"');
define('ZAGIEL_KUPUJ_NA_RATY', 'Kupuj na raty !');
define('ZAGIEL_MIN_ZAKUP', 'Powyżej 100zł kupisz na raty!');
define('BOX_HEADING_ZAGIEL', 'Zakupy na raty');

define('MODULE_SHIPPING_FREECOUNT_QTY', 'pieces');
define('MODULE_SHIPPING_FREECOUNT_TEXT_1', 'Free shipment for orders above');
define('MODULE_SHIPPING_FREECOUNT_TEXT_2', 'Your request meets the conditions that have been sent at our expense');
define('MODULE_SHIPPING_FREECOUNT_TEXT_3', 'Your order does not meet the conditions, that was sent at our expense');
define('MODULE_SHIPPING_FREECOUNT_TEXT_4', 'Those still missing');

define ('IMAGE_BUTTON_MAKE_AN_OFFER', 'Make an offer');

// naglowek do boxu Ostatnio dodane
define('BOX_HEADING_WHATS_NEW_LAST_10', 'Recently added');
?>