<?php
/*
  $Id: make_an_offer_to_cart.php,v 1.00 2005/07/26

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2005 osCommerce

  Released under the GNU General Public License
*/

function mao_check_offer($newpriceoffered, $productid) {

	global $language, $languages_id, $currency, $currencies;

	require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_MAKE_AN_OFFER);

	// Get the product info
	$product_info_query = tep_db_query("select p.products_id, pd.products_name, pd.products_description, p.products_price, p.products_tax_class_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . (int)$productid . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");

	$product_info = tep_db_fetch_array($product_info_query);
	$rate = $currencies->currencies[$currency]['value'];

	if ($new_price = tep_get_products_special_price($product_info['products_id'])) {

		$products_price = $currencies->display_price($product_info['products_id'], $new_price, tep_get_tax_rate($product_info['products_tax_class_id']));

		// Price without currency symbols
		$products_price_clean = tep_round(tep_add_tax($new_price * $rate,tep_get_tax_rate($product_info['products_tax_class_id'])),$currencies->currencies[$currency]['decimal_places']);

	} else {
		$products_price = $currencies->display_price($product_info['products_id'], $product_info['products_price'], tep_get_tax_rate($product_info['products_tax_class_id']));

		// Price without currency symbols
		$products_price_clean = tep_round(tep_add_tax($product_info['products_price'] * $rate,tep_get_tax_rate($product_info['products_tax_class_id'])),$currencies->currencies[$currency]['decimal_places']);

	}

	// Calculate the lowest offer accepted depending on the percentage setting
	$maxlowoffer = tep_round(($products_price_clean - ($products_price_clean * (MAO_MAX_OFFER_PERCENTAGE_ALLOWED/100))),$currencies->currencies[$currency]['decimal_places']);

	// Get the new price in comparable format
	$newprice = mao_priceoffer($newpriceoffered);

	if ($maxlowoffer <= $newprice) {
		// do nothing, offer is acceptable and add to cart will be performed
		return true;
	} else {
		return false;
	}
}

function mao_priceoffer($newpriceoffered) {

	global $currencies, $currency;

	$newprice = '';
	// Manipulate the offer price so it always is in US notation before compare
	// This must be done because the INPUT field looses the decimal values
	// when using a comma for decimal seperator
	// Underneath also strips all points and commas from the value typed by
	// the customer to prevent all kind of problems with the calculation

	// First make sure there is more then one number behind the point or comma
	if (substr($newpriceoffered,strlen($newpriceoffered)-2,1) == '.' || substr($newpriceoffered,strlen($newpriceoffered)-2,1) == ',') {
		$newpriceoffered = $newpriceoffered . '0';
	}

	// Second split the $newpriceoffered in a part without and with decimal places
	// Check if a decimal point or comma is used at all
	if (substr($newpriceoffered,strlen($newpriceoffered)-3,1) == '.' || substr($newpriceoffered,strlen($newpriceoffered)-3,1) == ',') {
		$newprice_before = substr($newpriceoffered,0,strlen($newpriceoffered)-3);
		$newprice_after = substr($newpriceoffered,strlen($newpriceoffered)-2);
	} else {
		$newprice_before = $newpriceoffered;
		$newprice_after = '00';
	}

	// Remove all commas and points for the non-decimal value given
	$newprice_before = str_replace('.','',$newprice_before);
	$newprice_before = str_replace(',','',$newprice_before);

	// Put all back together again
//	$newprice = $newprice_before . '.' . $newprice_after;

	$newprice = tep_round($newprice_before . '.' . $newprice_after,$currencies->currencies[$currency]['decimal_places']);

	return($newprice);
}
?>
