<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

// ******************************************************************************************
// UTWORZENIE KONTA KLIENTA
//******************************************************************************************
function mail_create_account($nazwa,$new_password,$email_address,$lastname,$firstname,$customer_id,$gender) {
  global $currencies;
  //
  $email_text = sprintf(EMAIL_GREET_NONE, $nazwa);
  $temat = MakeUTF(EMAIL_SUBJECT);
  $owner = MakeUTF(STORE_NAME);
  $nazwa = MakeUTF($nazwa);

  $text_points = '';
  if ((USE_POINTS_SYSTEM == 'true') && (NEW_SIGNUP_POINT_AMOUNT > 0)) {
      tep_add_welcome_points($customer_id);
      $points_account = '<a href="' . tep_href_link(FILENAME_MY_POINTS, '', 'SSL') . '"><b><u>' . EMAIL_POINTS_ACCOUNT . '</u></b></a>';
      $points_faq = '<a href="' . tep_href_link(FILENAME_MY_POINTS_HELP, '', 'NONSSL') . '"><b><u>' . EMAIL_POINTS_FAQ . '</u></b></a>';
      $text_points = sprintf(EMAIL_WELCOME_POINTS , $points_account, number_format(NEW_SIGNUP_POINT_AMOUNT,POINTS_DECIMAL_PLACES), $currencies->format(tep_calc_shopping_pvalue(NEW_SIGNUP_POINT_AMOUNT)), $points_faq) ."\n\n";
  }

  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.$email_text.'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.EMAIL_WELCOME.'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.EMAIL_USERNAME.'</td></tr>
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.EMAIL_PASSWORD . '<b>'.stripslashes($new_password).'</b></td></tr>
                </table>
            </td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="5" width="100%" style="background-color:#ecf5e9;border:1px;border-style:solid;border-color:#868785">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.str_replace("\n","<br>",EMAIL_TEXT.$text_points).'</td></tr>
            </table>
        </td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#cc3434">'.EMAIL_CONTACT.'</td></tr>
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:10px;color:#6e6e6e">'.EMAIL_WARNING.'</td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e"><br>'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = EMAIL_WELCOME . EMAIL_USERNAME . EMAIL_PASSWORD . stripslashes($new_password) . "\n\n" . EMAIL_TEXT . $text_points . EMAIL_CONTACT . EMAIL_WARNING;
  }

  tep_mail($nazwa, $email_address, $temat, $email_text, $owner, STORE_OWNER_EMAIL_ADDRESS);

  if (NEW_CUSTOMERS_ENABLED == 'false') {
    $temat_validate = MakeUTF(EMAIL_VALIDATE_SUBJECT);
    // GENEROWANIE TRESCI MAILA do administratora sklepu jezeli jest wylaczona aktywacja klientow
    if (EMAIL_USE_HTML == 'true') {
        $email_validate_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.EMAIL_VALIDATE.'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.EMAIL_VALIDATE_PROFILE . ' <a href="' . tep_href_link('administracja/customers.php','cID='.$customer_id.'&action=edit', 'SSL') . '">'. tep_href_link('administracja/customers.php','cID='.$customer_id.'&action=edit', 'SSL').'</a></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.EMAIL_VALIDATE_ACTIVATE . ' <a href="' . tep_href_link('administracja/customers.php','action=setflag&flag=1&cID='.$customer_id, 'SSL').'">'. tep_href_link('administracja/customers.php','action=setflag&flag=1&cID='.$customer_id, 'SSL') . '</a></td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_validate_text = str_replace($ArrayLNTargets, '', $email_validate_text);
       } else {
        $email_validate_text = EMAIL_VALIDATE . " \n\n" . EMAIL_VALIDATE_PROFILE . " " . tep_href_link('administracja/customers.php','cID='.$customer_id.'&action=edit', 'SSL') . " \n" . EMAIL_VALIDATE_ACTIVATE . " " . tep_href_link('administracja/customers.php','action=setflag&flag=1&cID='.$customer_id, 'SSL');
    }
    tep_mail($owner, STORE_OWNER_EMAIL_ADDRESS, $temat_validate, $email_validate_text, $owner, STORE_OWNER_EMAIL_ADDRESS);
  }
}


// ******************************************************************************************
// PRZYPOMNIENIE HASLA
//******************************************************************************************
function mail_password_forgotten($new_password,$adresat,$email_address) {
  $temat = MakeUTF(EMAIL_PASSWORD_REMINDER_SUBJECT);
  $owner = MakeUTF(STORE_NAME);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.EMAIL_PASSWORD_REMINDER_SUBJECT.'</b></td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",sprintf(EMAIL_PASSWORD_REMINDER_BODY, $new_password)).'</td></tr>
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747"><a href="'.HTTP_SERVER.DIR_WS_HTTP_CATALOG.'">'.STORE_NAME .' - '. HTTP_SERVER.DIR_WS_HTTP_CATALOG.'</a></td></tr>
                </table>
            </td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = sprintf(EMAIL_PASSWORD_REMINDER_BODY, $new_password);
  }
  tep_mail($adresat, $email_address, $temat, $email_text , $owner, STORE_OWNER_EMAIL_ADDRESS);
}


// ******************************************************************************************
// ZAPISANIE SIE DO BIULETYNU PRZEZ KLIENTA W BOXIE
//******************************************************************************************
function mail_newsletter_subscribe($newsletter_email) {
  $temat = MakeUTF(EMAIL_PASSWORD_REMINDER_SUBJECT);
  $owner = MakeUTF(STORE_NAME);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.EMAIL_WELCOME.'</b></td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.CLOSING_BLOCK1.'</td></tr>
                </table>
            </td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="8" width="100%">
            <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.CLOSING_BLOCK2.CLOSING_BLOCK3.'</td></tr>
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:10px;color:#6e6e6e">'.UNSUBSCRIBE.$newsletter_email. '</td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e"><br>'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br>'. HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
        $email_text = ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\">\\0</a>", $email_text);
     } else {
        $email_text .= EMAIL_WELCOME . CLOSING_BLOCK1 . CLOSING_BLOCK2 . CLOSING_BLOCK3 . UNSUBSCRIBE . $newsletter_email ;
  }
  tep_mail('', strtolower($newsletter_email), MakeUTF(EMAIL_WELCOME_SUBJECT), $email_text, MakeUTF(STORE_NAME), EMAIL_FROM);
}


// ******************************************************************************************
// POWIADOM ZNAJOMEGO O PRODUKCIE
//******************************************************************************************
function mail_tell_a_friend($email_subject,$message,$to_name, $to_email_address,$from_name,$from_email_address, $tell_products_id,$nazwa_produktu) {
  $witaj = sprintf(TEXT_EMAIL_INTRO_1, $to_name);
  $produkt = sprintf(TEXT_EMAIL_INTRO_2, $from_name, $nazwa_produktu, STORE_NAME);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.str_replace("\n","<br>",$witaj).'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.str_replace("\n","<br>",$produkt).'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.TEXT_EMAIL_LINK_TEXT . '<a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG . FILENAME_PRODUCT_INFO . '?products_id='.$tell_products_id .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . FILENAME_PRODUCT_INFO . '?products_id='. $tell_products_id . '</a></td></tr>
                </table>
            </td></tr>
        </table>';
        if ($message != '') {
            $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.TEXT_EMAIL_KOMENTARZ.'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$message).'</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = $witaj . "\n\n".$produkt. "\n\n";
        if (tep_not_null($message)) {
            $email_text .= $message;
        }
        $email_text .= "\n\n";
        $email_text .= TEXT_EMAIL_LINK_TEXT . '<a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG . FILENAME_PRODUCT_INFO . '?products_id='.$tell_products_id .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . FILENAME_PRODUCT_INFO . '?products_id='. $tell_products_id . '</a>' . "\n\n";
        $email_text .= EMAIL_TEXT_PZDR. "\n". STORE_NAME . "\n" . '<a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>';
  }
  tep_mail(MakeUTF($to_name),$to_email_address, $email_subject, $email_text, MakeUTF($from_name), $from_email_address);
}


// ******************************************************************************************
// ZADAJ NAM PYTANIE
//******************************************************************************************
function mail_ask_a_question($nazwa_produktu,$model_produktu,$from_name,$message,$from_name,$nadawca, $from_email_address,$owner,$id_produktu) {
  $email_subject = MakeUTF(sprintf(TEXT_EMAIL_SUBJECT, $from_name));
  $owner = MakeUTF(STORE_NAME);
  $nadawca = MakeUTF($from_name);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.sprintf(TEXT_EMAIL_SUBJECT, $from_name).'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.sprintf(TEXT_EMAIL_INTRO, $from_name, $nazwa_produktu, $model_produktu, STORE_NAME).'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" width="100%" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.sprintf(TEXT_EMAIL_LINK, tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' .$id_produktu )) . '</a></td></tr>
                </table>
            </td></tr>
        </table>';
        if ($message != '') {
            $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.TEXT_EMAIL_PYTANIE.'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$message).'</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $email_text = ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\">\\0</a>", $email_text);
        $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = sprintf(TEXT_EMAIL_INTRO, $from_name, $nazwa_produktu, $model_produktu, STORE_NAME) . "\n\n";
        if (tep_not_null($message)) {
        	$email_text .= $message . "\n\n";
        }
        $email_text .= sprintf(TEXT_EMAIL_LINK, tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' .$id_produktu )) . "\n\n" .
                       sprintf(TEXT_EMAIL_SIGNATURE, STORE_NAME . "\n" . HTTP_SERVER . DIR_WS_HTTP_CATALOG . "\n");
  }
  tep_mail($owner, STORE_OWNER_EMAIL_ADDRESS, $email_subject, $email_text, $nadawca, $from_email_address);
}


// ******************************************************************************************
// KONTAKT
//******************************************************************************************
function mail_contact($do_kogo,$enquiry,$name,$email_address,$kopia) {
  $owner = MakeUTF(STORE_NAME);
  $temat = MakeUTF(EMAIL_SUBJECT);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:16px;color:#4f7d13"><b>'.sprintf(CONTACT_EMAIL_TEXT, $name).'</b></td></tr>
        </table>';
        if ($enquiry != '') {
            $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.CONTACT_EMAIL_TEXT_1.'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" width="100%" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$enquiry).'</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = $enquiry;
  }
  $name = MakeUTF($name);
  tep_mail($owner, $do_kogo, $temat, $email_text, $name, $email_address);
  // wysylanie kopii dla klienta
  if ( $kopia == true) {
    $kopia_wiad = ENTRY_TEKST_MAIL.STORE_NAME . "\n\n";
    tep_mail($owner, $email_address, ENTRY_KOPIA.$temat, $email_text, $name, $email_address);
  }
}



// ******************************************************************************************
// SCHOWEK
//******************************************************************************************
function mail_wishlist($friendx,$emails,$subject,$message,$prods,$replace,$from_name,$from_email) {
  $witaj = sprintf(WISHLIST_EMAIL_INTRO, $friendx);
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        if(tep_session_is_registered('customer_id')) {
            $email_text = '
            <table border="0" cellspacing="0" cellpadding="10" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.str_replace("\n","",$witaj).'</b></td></tr>
            </table>
            <table border="0" cellspacing="0" cellpadding="10" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.$from_name. ' '.WISHLIST_EMAIL_SUBJECT.'</td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747"><b>'.ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\">\\0</a>", $replace).'</b></td></tr>
            </table>';
            if ($message != '') {
                $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.sprintf(WISHLIST_EMAIL_KOMENTARZ, $from_name).'</td></tr>
                <tr><td align="left">
                    <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                        <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$message).'</td></tr>
                    </table>
                </td></tr>
                </table>';
            }
            $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
             <tr><td align="left">
                <table cellspacing="0" cellpadding="2" border="0" width="100%">
                    <tr><td align="left"><hr></td></tr>
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
                </table>
            </td></tr>
            </table>';
        } else {
            $email_text = '
            <table border="0" cellspacing="0" cellpadding="10" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.str_replace("\n","",$witaj).'</b></td></tr>
            </table>
            <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.$from_name. ' '.WISHLIST_EMAIL_SUBJECT.'</td></tr>
                <tr><td align="left">
                    <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                        <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.HEADING_TITLE_WISHLIST.'</td></tr>
                        <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747"><b>'.str_replace("\n","<br>",ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\">\\0</a>", $prods)).'</b></td></tr>
                    </table>
                </td></tr>
            </table>';
            if ($message != '') {
                $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.sprintf(WISHLIST_EMAIL_KOMENTARZ, $from_name).'</td></tr>
                <tr><td align="left">
                    <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                        <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$message).'</td></tr>
                    </table>
                </td></tr>
                </table>';
            }
            $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
             <tr><td align="left">
                <table cellspacing="0" cellpadding="2" border="0" width="100%">
                    <tr><td align="left"><hr></td></tr>
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $komentarz = '';
        if ($message != '') {
            $komentarz = sprintf(WISHLIST_EMAIL_KOMENTARZ, $from_name) . "\n". $message;
        }
        if(tep_session_is_registered('customer_id')) {
           $email_text = $witaj .$from_name. ' '. WISHLIST_EMAIL_SUBJECT. "\n\n" .$replace ."\n\n" .$komentarz. "\n\n" . EMAIL_TEXT_PZDR;
           } else {
           $email_text = $witaj .$from_name. ' '. WISHLIST_EMAIL_SUBJECT. "\n\n" .HEADING_TITLE_WISHLIST. "\n\n" .$prods ."\n\n" .$komentarz. "\n\n" . EMAIL_TEXT_PZDR;
        }
     }
  tep_mail(MakeUTF($friendx), $emails, MakeUTF($subject), $email_text, MakeUTF($from_name), $from_email);
}


// ******************************************************************************************
// POLECONY - NAGRODZONY
//******************************************************************************************
function mail_polecony($to_email_address, $temat, $name, $from_email_address, $enquiry) {
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.POLEC_EMAIL_WELCOME.'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.sprintf(POLEC_EMAIL_TEXT_1,'<b>'.$name.'</b>').'<br>'.ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\">\\0</a>", POLEC_EMAIL_TEXT_2).'</td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747"><b>'.POLEC_EMAIL_TEXT_3.'</b></td></tr>
        </table>';
        if ($enquiry != '') {
            $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.sprintf(POLEC_EMAIL_TEXT_4,$name).'</td></tr>
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$enquiry).'</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = POLEC_EMAIL_WELCOME . "\n\n".sprintf(POLEC_EMAIL_TEXT_1,$name).' '.POLEC_EMAIL_TEXT_2. "\n\n" . POLEC_EMAIL_TEXT_3. "\n\n";
        if (tep_not_null($enquiry)) {
            $email_text .= sprintf(POLEC_EMAIL_TEXT_4,$name) ."\n";
            $email_text .= $enquiry."\n\n";
        }
        $email_text .= EMAIL_TEXT_PZDR . "\n". STORE_NAME . "\n" . '<a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>';
  }
  tep_mail(MakeUTF(STORE_OWNER),$to_email_address, $temat, $email_text, MakeUTF($name), $from_email_address);
}


// ******************************************************************************************
// PRZELEWY24 - plik w glownym katalogu sklepu
//******************************************************************************************
function mail_przelewy24($temat,$owner,$orders_id,$komunikat,$customer_name,$customer_mail) {
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.EMAIL_TEXT_ORDER_NUMBER . ' ' . $orders_id.'</b></td></tr>
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:12px;color:#474747">'.EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $orders_id, 'SSL').'</td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left">
            <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.$komunikat.'</td></tr>
            </table>
            </td></tr>
        </table>
        <table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = EMAIL_SEPARATOR . "\n" . EMAIL_TEXT_ORDER_NUMBER . ' ' . $orders_id . "\n" . EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $orders_id, 'SSL') . "\n\n" .''.$komunikat;

  }
  tep_mail($customer_name,$customer_mail, $temat, $email, $owner, STORE_OWNER_EMAIL_ADDRESS);
  tep_mail(STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS, $temat, $email, $owner, STORE_OWNER_EMAIL_ADDRESS);
}

// ******************************************************************************************
// ZGLOSZENIE REKLAMACYJNE
//******************************************************************************************
function mail_ticket_create($to_email_address, $temat, $name, $from_email_address, $enquiry) {
  // GENEROWANIE TRESCI MAILA
  if (EMAIL_USE_HTML == 'true') {
        $email_text = '
        <table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#4f7d13"><b>'.HEADING_TITLE.'</b></td></tr>
        </table>';
        if ($enquiry != '') {
            $email_text .= '<table border="0" cellspacing="0" cellpadding="10" width="100%">
            <tr><td align="left">
                <table cellspacing="0" cellpadding="5" style="background-color:#f0f0f0;border:1px;border-style:solid;border-color:#868785">
                    <tr><td align="left" style="font-family:Tahoma,Arial;font-size:14px;color:#474747">'.str_replace("\n","<br>",$enquiry).'</td></tr>
                </table>
            </td></tr>
            </table>';
        }
        $email_text .= '<table border="0" cellspacing="0" cellpadding="8" width="100%">
         <tr><td align="left">
            <table cellspacing="0" cellpadding="2" border="0" width="100%">
                <tr><td align="left"><hr></td></tr>
                <tr><td align="left" style="font-family:Tahoma,Arial;font-size:11px;color:#6e6e6e">'.EMAIL_TEXT_PZDR.'<br>'.STORE_NAME . '<br><a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>' . '</td></tr>
            </table>
        </td></tr>
        </table>';
        $ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
        $email_text = str_replace($ArrayLNTargets, '', $email_text);
     } else {
        $email_text = HEADING_TITLE . "\n\n";
        if (tep_not_null($enquiry)) {
            $email_text .= $enquiry."\n\n";
        }
        $email_text .= EMAIL_TEXT_PZDR . "\n". STORE_NAME . "\n" . '<a href="' . HTTP_SERVER  . DIR_WS_HTTP_CATALOG .'">' .  HTTP_SERVER  . DIR_WS_HTTP_CATALOG . '</a>';
  }
  tep_mail('',$to_email_address, MakeUTF($temat), $email_text, MakeUTF($name), $from_email_address);
}



?>