<?php
/* --------------------------------------------------------------
   $Id: pdf.php 603 2008-12-31 18:40:19Z kamelianet $

   A base class for the PDF documents

   Copyright (c) 2007 Jerzy Skalski
	 email: info@done.homelinux.org
	 gg   : 1202405
	 tel  : 603 250 877

   Released under the GNU General Public License

   Modified by : Jacek Krysiak oscGold
   email: info@oscgold.com
   --------------------------------------------------------------
*/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 *
 *
 *   46: class PDF extends FPDF
 *   59:     function init($x, $y)
 *   73:     function acceptPageBreak()
 *   87:     function Rotate($angle,$x=-1,$y=-1)
 *  112:     function _endpage()
 *  131:     function RotatedText($x,$y,$txt,$angle)
 *  150:     function Ellipse($x,$y,$rx,$ry,$style='D')
 *  192:     function Circle($x,$y,$r,$style='')
 *  205:     function SetDash($black=false,$white=false)
 *  221:     function parse($liczba, $type = 1)
 *  278:     function d2s($number, $unit, $nast)
 *  309:     function unhtmlentities($string)
 *
 * TOTAL FUNCTIONS: 11
 * 
 *
 */
define('FPDF_FONTPATH','pdf/font/');
//define('FPDF_FONTPATH','font/');
require('ufpdf.php');


/**
 * The extended class for the PDF documents
 *
 */
class PDF extends UFPDF {
	var $x0;
	var $y0;
	var $typ;
	var $angle;

	/**
	 * Init internal variables
	 *
	 * @param	float		$x: begin to draw from this point
	 * @param	float		$y: begin to draw from this point
	 * @return	void
	 */
	function init($x, $y) {
		$this->x0                  = $x;
		$this->y0                  = $y;
		$this->typ                 = 0;
		$this->accept_page_break   = TRUE;
		$this->angle               = 0;
	}

	/**
	 * Accept a page break and return true
	 * Don't accept a page break and return false
	 *
	 * @return	boolean		default value is true
	 */
	function acceptPageBreak() {
		return $this->accept_page_break;
	}


	/**
	 * This function allows to perform rotation around given center
	 * Code is borrowed from the web site: www.fpdf.org - script "Rotations"
	 *
	 * @param	float		$angle: in degrees
	 * @param	float		$x:     abscissa of the rotation center
	 * @param	float		$y:     ordinate of the rotation center
	 * @return	void
	 */
	function Rotate($angle,$x=-1,$y=-1) {
		if($x==-1)
			$x=$this->x;
		if($y==-1)
			$y=$this->y;
		if($this->angle!=0)
			$this->_out('Q');
		$this->angle=$angle;
		if($angle!=0) {
			$angle*=M_PI/180;
			$c=cos($angle);
			$s=sin($angle);
			$cx=$x*$this->k;
			$cy=($this->h-$y)*$this->k;
			$this->_out(sprintf('q %.5f %.5f %.5f %.5f %.2f %.2f cm 1 0 0 1 %.2f %.2f cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
    }
	}


	/**
	 * This internal function allows to perform rotation around given center
	 * Code is borrowed from the web site: www.fpdf.org - script "Rotations"
	 *
	 * @return	void
	 */
	function _endpage() {
		if($this->angle!=0) {
			$this->angle=0;
			$this->_out('Q');
		}
		parent::_endpage();
	}


	/**
	 * This function allows to perform a text rotation around given center
	 * Code is borrowed from the web site: www.fpdf.org - script "Rotations"
	 *
	 * @param	float		$x:     abscissa of the rotation center
	 * @param	float		$y:     ordinate of the rotation center
	 * @param	string		$text:  a text that will rotate around given center
	 * @param	float		$angle: in degrees
	 * @return	void
	 */
	function RotatedText($x,$y,$txt,$angle) {
		//Text rotated around its origin
		$this->Rotate($angle,$x,$y);
		$this->Text($x,$y,$txt);
		$this->Rotate(0);
	}


	/**
	 * This function allows to draw circles and ellipses
	 * Code is borrowed from the web site: www.fpdf.org - script "Circle and ellipses"
	 *
	 * @param	float		$x:     abscissa of the rotation center
	 * @param	float		$y:     ordinate of the rotation center
	 * @param	string		$text:  a text that will rotate around given center
	 * @param	float		$angle: in degrees
	 * @param	char		$style:
	 * @return	void
	 */
	function Ellipse($x,$y,$rx,$ry,$style='D') {
    if($style=='F')
        $op='f';
    elseif($style=='FD' or $style=='DF')
        $op='B';
    else
        $op='S';
    $lx=4/3*(M_SQRT2-1)*$rx;
    $ly=4/3*(M_SQRT2-1)*$ry;
    $k=$this->k;
    $h=$this->h;
    $this->_out(sprintf('%.2f %.2f m %.2f %.2f %.2f %.2f %.2f %.2f c',
        ($x+$rx)*$k,($h-$y)*$k,
        ($x+$rx)*$k,($h-($y-$ly))*$k,
        ($x+$lx)*$k,($h-($y-$ry))*$k,
        $x*$k,($h-($y-$ry))*$k));
    $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c',
        ($x-$lx)*$k,($h-($y-$ry))*$k,
        ($x-$rx)*$k,($h-($y-$ly))*$k,
        ($x-$rx)*$k,($h-$y)*$k));
    $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c',
        ($x-$rx)*$k,($h-($y+$ly))*$k,
        ($x-$lx)*$k,($h-($y+$ry))*$k,
        $x*$k,($h-($y+$ry))*$k));
    $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c %s',
        ($x+$lx)*$k,($h-($y+$ry))*$k,
        ($x+$rx)*$k,($h-($y+$ly))*$k,
        ($x+$rx)*$k,($h-$y)*$k,
        $op));
	}


	/**
	 * This function allows to draw circles
	 * Code is borrowed from the web site: www.fpdf.org - script "Circle and ellipses"
	 *
	 * @param	float		$x:     abscissa of the center
	 * @param	float		$y:     ordinate of the center
	 * @param	float		$r:     radius
	 * @param	string		$style: style of rendering, like for rectangles, default value D
	 * @return	void
	 */
	function Circle($x,$y,$r,$style='') {
    $this->Ellipse($x,$y,$r,$r,$style);
	}


	/**
	 * This function allows to set a dash pattern and draw dashes lines or rectangles
	 * Code is borrowed from the web site: www.fpdf.org - script "Dashes"
	 *
	 * @param	float		$black:     length of dashes
	 * @param	float		$white:     length of gaps
	 * @return	void
	 */
	function SetDash($black=false,$white=false) {
        if($black and $white)
            $s=sprintf('[%.3f %.3f] 0 d',$black*$this->k,$white*$this->k);
        else
            $s='[] 0 d';
        $this->_out($s);
	}


	/**
	 * This two functions (parse and d2s) are borowed from code writtten by Ludwik DelÄ…g
	 *
	 * @param	float		$liczba: a float value
	 * @param	float		$type:   a type of the displayed value (PLN or zl)
	 * @return	string		a float value in the words
	 */
	function parse($liczba, $type = 1) {
		$liczba=sprintf('%.2f', $liczba);
		if ($type) {
			$symbol = 'PLN';
		} else {
			$symbol = 'zł‚';
		}
		$jednostki_zl=array($symbol, 'tyś.', 'mln.');
		$jednostki_gr=array('gr');
		list($zlote,$grosze)=split('\.', $liczba);
		$reszta=strlen($zlote) % 3;
		$dopelnienie=((3-$reszta) == 3) ? 0 : 3-$reszta;
		for($i=0;$i<$dopelnienie;$i++){
			$zlote='0'.$zlote;
		}
		$reszta=strlen($grosze) % 3;
		$dopelnienie=((3-$reszta) == 3) ? 0 : 3-$reszta;
		for($i=0;$i<$dopelnienie;$i++){
			$grosze='0'.$grosze;
		}
		$ret_val_zlote='';
		$ret_val_grosze='';
		$counter=0;
		while(strlen($zlote) > 0){
			$part=substr($zlote, -3, 3);
			#$zlote=mb_strcut($zlote, 0, strlen($zlote)-3);
			$zlote=str_replace($part, '', $zlote);
			$nast=(strlen($zlote) > 0) ? 1 : 0;
			$ret_val_zlote=$this->d2s($part, $jednostki_zl[$counter++], $nast).$ret_val_zlote;
		}
		$counter=0;
		if ($type == 0) { // Kwota w przelewie
			while(strlen($grosze) > 0){
			$part=substr($grosze, -3, 3);
			#$grosze=mb_strcut($grosze, 0, strlen($grosze)-3);
			$grosze=str_replace($part, '', $grosze);
			$nast=(strlen($grosze) > 0) ? 1 : 0;
			$ret_val_grosze=$this->d2s($part, $jednostki_gr[$counter++], $nast).$ret_val_grosze;
			}
			return $ret_val_zlote.$ret_val_grosze;
		} elseif ($type == 1) { // Kwota w fakturze
			if ($grosze[0] == '0') {
				$grosze = substr($grosze, 1);
			}
			return $ret_val_zlote.$grosze.'/100';
		}
	}


	/**
	 * Replace digits to the words in Polish
	 *
	 * @param	array		$number: ...
	 * @param	[type]		$unit: ...
	 * @param	[type]		$nast: ...
	 * @return	string		the number in the words
	 */
	function d2s($number, $unit, $nast) {
		$a1=array('', 'jeden','dwa','trzy','cztery','pięć','sześć','siedem','osiem','dziewięć',
		'dziesięć', 'jedenaście','dwanaście','trzynaście','czternaście','piętnaście','szesnaście','siedemnaście',
		'osiemnaście','dziewiętnaście');
		$a2=array('', 'dziesięć','dwadzieścia','trzydzieści','czterdzieści','piędziesiąt','sześćdziesiąt','siedemdziesiąt','osiemdziesiąt','dziewięćdziesiąt');
		$a3=array('','sto','dwieście','trzysta','czterysta','pięćset','sześćset','siedemset','osiemset','dziewięćset');
		$setki=$number[0];
		$dziesiatki=$number[1].$number[2];
		//if($dziesiatki[0] == 0 and $dziesiatki[1] == 0){
		if($dziesiatki == 0 AND $setki == 0 and $nast == 0) {
			$dziesiatki = 'zero';
		} elseif($dziesiatki < 20) {
			if($dziesiatki < 10) {
				$dziesiatki=$a1[$dziesiatki[1]];
			} else {
				$dziesiatki=$a1[$dziesiatki];
			}
		} else {
			$dziesiatki=$a2[$dziesiatki[0]].' '.$a1[$dziesiatki[1]];
		}
		$setki=$a3[$setki];
		return $setki.' '.$dziesiatki.' '.$unit.' ';
	}


	/**
	 * Decode the enity to the normal char
	 * This function replaces html_entity_decode
	 *
	 * @param   string  the entity in the form ŕ¤©
	 * @return	string  a char
	 */
	function unhtmlentities($string) {
		// replace numeric entities
		$string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
		$string = preg_replace('~&#([0-9]+);~e', 'chr(\\1)', $string);
		// replace literal entities
		$trans_tbl = get_html_translation_table(HTML_ENTITIES);
		$trans_tbl = array_flip($trans_tbl);
		return strtr($string, $trans_tbl);
	}

  function convertToCharset($string, $charset_in='ISO-8859-2', $charset_out='ISO-8859-2') {
    if ($charset_in == $charset_out) return $string;

    return iconv($charset_in, $charset_out, $string);
  }

}
?>
