/* utf-8 marker: 
======================================================== 
Shutter Mobile v1.2
======================================================== 

based on:     Shutter Reloaded Version 2.0.1
http://www.laptoptips.ca/javascripts/shutter-reloaded/

Modified by:  Gert Ebersbach http://www.ge-webdesign.de/
Released:     2012/07 

Many thanks to Andrew Ozz for providing Shutter Reloaded
under GPL conditions.
======================================================== 

Acknowledgement: some ideas are from: 

Shutter by Andrew Sutherland - http://code.jalenack.com, 
WordPress - http://wordpress.org, 
Lightbox by Lokesh Dhakar - http://www.huddletogether.com, 
the icons are from Crystal Project Icons, Everaldo Coelho, http://www.everaldo.com

Released under the GPL, http://www.gnu.org/copyleft/gpl.html

    Copyright (C) 2007  Andrew Ozz

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

======================================================== 
*/

// CONFIGURATION and LANGUAGE AREA
// The following variables you can provide from outside (CMS, plugin etc.)
// In that case outcomment or delete configuration area and language area
// ====================================================

/*
// CONFIGURATION AREA

// Slideshow Loop - true or false (1 or 0)
var shutterMobileLoop = true;

// Text navigation - true or false (1 or 0)
var shutterMobileTextBtns = false;

// Image counter - true or false (1 or 0)
var shutterMobileImageCount = true;

// The pat to the navigation icons of Shutter Mobile
var shutterMobileImgDir = '/shuttertest01/images/';

// LANGUAGE AREA
var shutterMobilePrev = '&laquo; Previous';
var shutterMobileNext = 'Next &raquo;';
var shutterMobileClose = 'Close';
var shutterMobileFull = 'Full Size';
var shutterMobileFit = 'Fit to Screen';
var shutterMobileImage = 'Image';
var shutterMobileOf = 'of';
var shutterMobileLoading = 'Loading ...';

// ====================================================
// END of CONFIGURATION and LANGUAGE AREA
*/

shutterMobile = 
{
    shutterMobile_imageCount : shutterMobileImageCount,
    shutterMobile_textBtns : shutterMobileTextBtns,
    shutterMobile_loop : shutterMobileLoop,
    shutterMobile_imgDir : shutterMobileImgDir,
    shutterMobile_L10n : [
    shutterMobilePrev,
    shutterMobileNext,
    shutterMobileClose,
    shutterMobileFull,
    shutterMobileFit,
    shutterMobileImage,
    shutterMobileOf,
    shutterMobileLoading],
    
  I : function (a) {
    return document.getElementById(a);
  },

  Init : function (a) {
    var L, T, ext, i, setid, inset, shfile, shMenuPre, k, img;
    for ( i = 0; i < document.links.length; i++ ) {
      L = document.links[i];
      ext = ( L.href.indexOf('?') == -1 ) ? L.href.slice(-4).toLowerCase() : L.href.substring( 0, L.href.indexOf('?') ).slice(-4).toLowerCase();
      if ( ext != '.jpg' && ext != '.png' && ext != '.gif' && ext != 'jpeg' ) continue;
      if ( a == 'sh' && L.className.toLowerCase().indexOf('shutter') == -1 ) continue;
      if ( a == 'lb' && L.rel.toLowerCase().indexOf('lightbox') == -1 ) continue;

      if ( L.className.toLowerCase().indexOf('shutterset') != -1 ) 
        setid = ( L.className.indexOf(' ') != -1 ) ? L.className.slice(0,L.className.indexOf(' ')) : L.className;
      else if ( L.rel.toLowerCase().indexOf('lightbox[') != -1 ) 
        setid = L.rel;
      else setid = 0, inset = -1;
      
      if( setid ) {
        if ( ! shutterSets[setid] ) shutterSets[setid] = []; 
        inset = shutterSets[setid].push(i);
      }
      
      shfile = L.href.slice(L.href.lastIndexOf('/')+1);
      T = ( L.title && L.title != shfile ) ? L.title : '';
      
      shutterLinks[i] = {link:L.href,num:inset,set:setid,title:T}
      L.onclick = new Function('shutterMobile.Make("'+i+'");return false;');
    }
    
    if ( ! this.shutterMobile_textBtns ) {
      shMenuPre = ['close.gif','prev.gif','next.gif','resize1.gif','resize2.gif','loading.gif'];
      for ( k = 0; k < shMenuPre.length; k++ ) {
        img = new Image();
        img.src = this.shutterMobile_imgDir+shMenuPre[k];
      }
    }
  },

  Make : function(ln,fs) {
    var prev, next, prevlink = '', nextlink = '', previmg, nextimg, prevbtn, nextbtn, D, S, W, NB, fsarg = '', imgNum, closebtn, fsbtn, fsLink;

    if ( ! this.Top ) {
      if ( typeof window.pageYOffset != 'undefined' ) this.Top = window.pageYOffset;
      else this.Top = (document.documentElement.scrollTop > 0) ? document.documentElement.scrollTop : document.body.scrollTop;
    }
    
    if ( typeof this.pgHeight == 'undefined' ) 
      this.pgHeight = Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);
    
    if ( fs ) this.FS = true;
    else this.FS = null;
    
	if (!navigator.userAgent.match(/iPhone|iPad|iPod/i))
	{
		if ( this.resizing ) this.resizing = null;
		window.onresize = new Function('shutterMobile.Resize("'+ln+'");return false');
	}
    
    document.documentElement.style.overflowX = 'hidden';
    if ( ! this.VP ) {
      this._viewPort();
      this.VP = true;
    }
    
    if ( ! (S = this.I('shShutter')) ) {
      S = document.createElement('div');
      S.setAttribute('id','shShutter');
      document.getElementsByTagName('body')[0].appendChild(S);
      this.hideTags();
    }

    if ( ! (D = this.I('shDisplay')) ) {
      D = document.createElement('div');
      D.setAttribute('id','shDisplay');
      D.style.top = this.Top + 'px';
      document.getElementsByTagName('body')[0].appendChild(D);
    }

    S.style.height = this.pgHeight + 'px';    
    
    var dv = this.shutterMobile_textBtns ? ' | ' : '';
    if ( shutterLinks[ln].num > 1 ) {
      prev = shutterSets[shutterLinks[ln].set][shutterLinks[ln].num - 2];
      prevbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[0] : '<img src="'+this.shutterMobile_imgDir+'prev.gif" title="'+this.shutterMobile_L10n[0]+'" />';
      prevlink = '<a href="#" onclick="shutterMobile.Make('+prev+');return false">'+prevbtn+'</a>'+dv;
      previmg = new Image();
      previmg.src = shutterLinks[prev].link;
    }

// Loop for prev (if configured)

    if ( shutterLinks[ln].num == 1 && this.shutterMobile_loop ) {
      prev = shutterSets[shutterLinks[ln].set][shutterLinks[ln].num + ((shutterSets[shutterLinks[ln].set].length) - 2)];
      prevbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[0] : '<img src="'+this.shutterMobile_imgDir+'prev.gif" title="'+this.shutterMobile_L10n[0]+'" />';
      prevlink = '<a href="#" onclick="shutterMobile.Make('+prev+');return false">'+prevbtn+'</a>'+dv;
      previmg = new Image();
      previmg.src = shutterLinks[prev].link;
    }

    if ( shutterLinks[ln].num != -1 && shutterLinks[ln].num < (shutterSets[shutterLinks[ln].set].length) ) {
      next = shutterSets[shutterLinks[ln].set][shutterLinks[ln].num];
      nextbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[1] : '<img src="'+this.shutterMobile_imgDir+'next.gif" title="'+this.shutterMobile_L10n[1]+'" />';
      nextlink = '<a href="#" onclick="shutterMobile.Make('+next+');return false">'+nextbtn+'</a>';
      nextimg = new Image();
      nextimg.src = shutterLinks[next].link;
    }

// Loop for next (if configured)

    if ( shutterLinks[ln].num != -1 && shutterLinks[ln].num == (shutterSets[shutterLinks[ln].set].length) && this.shutterMobile_loop ) {
      next = shutterSets[shutterLinks[ln].set][shutterLinks[ln].num - (shutterSets[shutterLinks[ln].set].length)];
      nextbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[1] : '<img src="'+this.shutterMobile_imgDir+'next.gif" title="'+this.shutterMobile_L10n[1]+'" />';
      nextlink = '<a href="#" onclick="shutterMobile.Make('+next+');return false">'+nextbtn+'</a>'+dv;
      nextimg = new Image();
      nextimg.src = shutterLinks[next].link;
    }
    
    closebtn = this.shutterMobile_textBtns ? '<span onclick="shutterMobile.hideShutter();return false">'+this.shutterMobile_L10n[2]+'</span>' : '<img src="'+this.shutterMobile_imgDir+'close.gif" onclick="shutterMobile.hideShutter();return false" title="'+this.shutterMobile_L10n[2]+'" />';

// Keyboard Controls

if (navigator.userAgent.match(/MSIE/i))
{
    document.onkeydown = function(event) 
    {
        if (window.event.keyCode == 37) 
        {
            shutterMobile.Make(prev);return false;
        }
        if (window.event.keyCode == 39) 
        {
            shutterMobile.Make(next);return false;
        }
        if (window.event.keyCode == 38 || window.event.keyCode == 27 || window.event.keyCode == 40) 
        {
            window.event.cancelBubble = true;
            window.event.returnValue = false;
            shutterMobile.hideShutter();return false;
        }
        return window.event.returnValue;
    }
}
else
{
    document.onkeydown = function(event)
    {
        if (event.keyCode == 37) 
        {
            shutterMobile.Make(prev);return false;
        }
        if (event.keyCode == 39) 
        {
            shutterMobile.Make(next);return false;
        }
        if (event.keyCode == 38 || event.keyCode == 27 || event.keyCode == 40) 
        {
            event.cancelBubble = true;
            event.returnValue = false;
            shutterMobile.hideShutter();return false;
        }
        return event.returnValue;
    }
}

    imgNum = ( (shutterLinks[ln].num > 0) && this.shutterMobile_imageCount ) ? '( '+this.shutterMobile_L10n[5]+'&nbsp;'+shutterLinks[ln].num+'&nbsp;'+this.shutterMobile_L10n[6]+'&nbsp;'+shutterSets[shutterLinks[ln].set].length+' )' : '';
//    if ( imgNum && this.shutterMobile_textBtns ) imgNum += ' |';

    if ( this.FS ) {
      fsbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[4] : '<img src="'+this.shutterMobile_imgDir+'resize2.gif" title="'+this.shutterMobile_L10n[4]+'" />';
    } else {
      fsbtn = this.shutterMobile_textBtns ? this.shutterMobile_L10n[3] : '<img src="'+this.shutterMobile_imgDir+'resize1.gif" title="'+this.shutterMobile_L10n[3]+'" />';
      fsarg = ',1';
    }
    
    fsLink = '<span id="fullSize"><a href="#" onclick="shutterMobile.Make('+ln+fsarg+');return false">'+fsbtn+'</a>'+dv+'</span>';
    
    D.innerHTML = '<div id="shWrap"><div id="shNavBar">'+prevlink+closebtn+dv+fsLink+nextlink+'</div><div id="shTitle">'+shutterLinks[ln].title+' &nbsp; '+imgNum+' </div><img src="'+shutterLinks[ln].link+'" id="shTopImg" onload="shutterMobile.ShowImg();" onclick="shutterMobile.hideShutter();return false" /></div>';
    
    window.setTimeout(function(){shutterMobile.loading();},2000);
  },
  
  loading : function() {
    var S, WB, W;
    if ( (W = this.I('shWrap')) && W.style.visibility == 'visible' ) return;
    if ( ! (S = this.I('shShutter')) ) return;
    if ( this.I('shWaitBar') ) return;
    WB = document.createElement('div');
    WB.setAttribute('id','shWaitBar');
    WB.style.top = this.Top + 'px';
    WB.innerHTML = '<img src="'+this.shutterMobile_imgDir+'loading.gif" title="'+this.shutterMobile_L10n[7]+'" />';
    S.appendChild(WB);
  },
  
  hideShutter : function() {
    var D, S, NB;
    if ( D = this.I('shDisplay') ) D.parentNode.removeChild(D);
    if ( S = this.I('shShutter') ) S.parentNode.removeChild(S);
    if ( NB = this.I('shNavBar') ) NB.parentNode.removeChild(NB);
	this.reloadTags();
  },

  Resize : function(ln) {
    if ( this.resizing ) return;
    if ( ! this.I('shShutter') ) return;
    var W = this.I('shWrap');
    if ( W ) W.style.visibility = 'hidden';
    
    window.setTimeout(function(){shutterMobile.resizing = null},500);
    window.setTimeout(new Function('shutterMobile.VP = null;shutterMobile.Make("'+ln+'");return false;'),100);
    this.resizing = true;
  },
  
  _viewPort : function() {
    var wiH = window.innerHeight ? window.innerHeight : 0;
    var dbH = document.body.clientHeight ? document.body.clientHeight : 0;
    var deH = document.documentElement ? document.documentElement.clientHeight : 0;
      
    if( wiH > 0 ) {
      this.wHeight = ( (wiH - dbH) > 1 && (wiH - dbH) < 30 ) ? dbH : wiH;
      this.wHeight = ( (this.wHeight - deH) > 1 && (this.wHeight - deH) < 30 ) ? deH : this.wHeight;
    } else this.wHeight = ( deH > 0 ) ? deH : dbH;

    var deW = document.documentElement ? document.documentElement.clientWidth : 0;
    var dbW = window.innerWidth ? window.innerWidth : document.body.clientWidth;
    this.wWidth = ( deW > 1 ) ? deW : dbW;
  },
  
  ShowImg : function() {
    var S, W, WB, D, T, TI, NB, wHeight, wWidth, capH, shHeight, maxHeight, itop, mtop, resized = 0;
    if ( ! (S = this.I('shShutter')) ) return;
    if ( (W = this.I('shWrap')) && W.style.visibility == 'visible' ) return;
    if ( WB = this.I('shWaitBar') ) WB.parentNode.removeChild(WB);
    
    D = this.I('shDisplay');
    TI = this.I('shTopImg');
    T = this.I('shTitle');
    NB = this.I('shNavBar');
    S.style.width = D.style.width = '';
    
    capH = NB.offsetHeight ? T.offsetHeight + NB.offsetHeight : 30;
    shHeight = this.wHeight - 16 - capH;

    if ( this.FS ) {
      if ( TI.width > (this.wWidth - 10) ) 
        S.style.width = D.style.width = TI.width + 10 + 'px';
        document.documentElement.style.overflowX = '';
    } else {
      window.scrollTo(0,this.Top);
      if ( TI.height > shHeight ) {
        TI.width = TI.width * (shHeight / TI.height);
        TI.height = shHeight;
        resized = 1;
      }
      if ( TI.width > (this.wWidth - 16) ) {
        TI.height = TI.height * ((this.wWidth - 16) / TI.width);
        TI.width = this.wWidth - 16;
        resized = 1;
      }
    }

    maxHeight = this.Top + TI.height + capH + 10;
    if ( maxHeight > this.pgHeight ) S.style.height = maxHeight + 'px'; 
    window.scrollTo(0,this.Top);
    if ( (this.FS && (TI.height > shHeight || TI.width > this.wWidth)) || resized ) this.I('fullSize').style.display = 'inline';
    
    itop = (shHeight - TI.height) * 0.45;
    mtop = (itop > 3) ? Math.floor(itop) : 3;
    D.style.top = this.Top + mtop + 'px';
    NB.style.bottom = '0';
    W.style.visibility = 'visible';
  },

  hideTags : function(arg) {
	var sel = document.getElementsByTagName('select');
	var obj = document.getElementsByTagName('object');
	var emb = document.getElementsByTagName('embed');
	var ifr = document.getElementsByTagName('iframe');
    
    if ( arg ) var vis = 'visible';
    else var vis = 'hidden';
    
    for (i = 0; i < sel.length; i++) sel[i].style.visibility = vis;
    for (i = 0; i < obj.length; i++) obj[i].style.visibility = vis;
    for (i = 0; i < emb.length; i++) emb[i].style.visibility = vis;
	for (i = 0; i < ifr.length; i++) ifr[i].style.visibility = vis;
  },
  
  reloadTags : function() {
	var sel = document.getElementsByTagName('select');
	var obj = document.getElementsByTagName('object');
	var emb = document.getElementsByTagName('embed');
	var ifr = document.getElementsByTagName('iframe');
    
	var vis = 'visible';
    
    for (i = 0; i < sel.length; i++) sel[i].style.visibility = vis;
    for (i = 0; i < obj.length; i++) obj[i].style.visibility = vis;
    for (i = 0; i < emb.length; i++) emb[i].style.visibility = vis;
	for (i = 0; i < ifr.length; i++) ifr[i].style.visibility = vis;
  }
}

if (window.addEventListener)
{
	window.addEventListener('load', shutterOnload, false);
} 

if (window.attachEvent) 
{
	window.attachEvent('onload', shutterOnload);
}

var shutterLinks = {}, shutterSets = {};
