<?php
/* utf-8 marker: äöü
************************************
FotoGalerie_XH plugin for CMSimple
Developed by: ge-webdesign.de
Version: FotoGalerie_XH v6.6
Released: 11/2012

Based on:  
- kissGallery: 			Claus Højberg (alias Softly)
- Shutter Reloaded:		digitalia.be
- TableSort:			javascript.jstruebig.de
************************************
License:  
Linkware License (private websites)
Remove Link License (private websites)
Commercial License (commercial websites)

For Licenses see: http://www.ge-webdesign.de/cmsimpleplugins/
************************************
*/

// FUNCTIONS

include_once('fogafuncs.php');

function fogagetSizes($src_w, $src_h, $dst_w, $dst_h ) 
{
	$mlt_w = $dst_w / $src_w;
	$mlt_h = $dst_h / $src_h;
	$mlt = $mlt_w < $mlt_h ? $mlt_w:$mlt_h;
	if ($dst_w == "*") $mlt = $mlt_h;
	if ($dst_h == "*") $mlt = $mlt_w;
	if ($dst_w == "*" && $dst_h == "*") $mlt=1;
//  Calculate new dimensions
	$img_new_w =  round($src_w * $mlt);
	$img_new_h =  round($src_h * $mlt);
	return array("w" => $img_new_w, "h" => $img_new_h, "mlt_w"=>$mlt_w, "mlt_h"=>$mlt_h,  "mlt"=>$mlt);
}  

function fogaimgGetResized($img_original,$img_w,$img_h,$img_new_w,$img_new_h) 
{
	$img_resized = imagecreatetruecolor($img_new_w,$img_new_h);
	imagecopyresampled($img_resized, $img_original, 0, 0, 0, 0,$img_new_w, $img_new_h, $img_w, $img_h);
	return $img_resized;
} 

function fogasaveImage($arr_img,$filename,$w,$h,$qty) 
{
	if ($arr_img["w"] > $w || $arr_img["h"] > $h) 
	{
		$wh = fogagetSizes($arr_img["w"], $arr_img["h"], $w, $h);
		$img_res = fogaimgGetResized($arr_img["img"],$arr_img["w"],$arr_img["h"],$wh["w"],$wh["h"]);
		ImageJPEG($img_res,$filename,$qty);
	} 
	else 
	{
		ImageJPEG($arr_img["img"],$filename,$qty);
	}
}

function fogaimageFromUpload($uploaded_file)
{
	$img_sz =  getimagesize($uploaded_file );     
	switch($img_sz[2] )
	{
		case 1:
		$img_type = "GIF";
		$img = ImageCreateFromGif($uploaded_file);
		break;
		
		case 2:
		$img = ImageCreateFromJpeg($uploaded_file);
		$img_type = "JPG";
		break;
		
		case 3:
		$img = ImageCreateFromPng($uploaded_file);
		$img_type = "PNG";
		break;
		
		case 4:
		$img = ImageCreateFromSwf($uploaded_file);
		$img_type = "SWF";
		break;
		
		default: return array(false);
	}
	return array("img"=>$img, "w"=>$img_sz[0], "h"=>$img_sz[1], "type"=>$img_sz[2], "html"=>$img_sz[3]);
} 

function fogagetImage($img,$id,$filepath)
{
	global $plugin_cf;
	$arr_img = fogaimageFromUpload($img);
	if ($arr_img['img']) 
	{
		fogasaveImage($arr_img,$filepath.$id.'.jpg',$plugin_cf['fotogalerie']['image_max_size'],$plugin_cf['fotogalerie']['image_max_size'],$plugin_cf['fotogalerie']['image_jpg_quality']);
		fogasaveImage($arr_img,$filepath.'thumbs/'.$id.'t.jpg',$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['image_jpg_quality']);
		imagedestroy($arr_img["img"]);
		return true;
	} 
	else 
	{
		return false;
	}
} 

function saveThumb($arr_img, $thumbnail, $dst_width, $dst_height, $quality) 
{
	global $plugin_cf;
	$src_width = $arr_img["w"];
	$src_height = $arr_img["h"];
	$srcImage=$arr_img["img"];
	
	if ($src_width>$src_height) 
	{
		$dst_w=$dst_width;
		$dst_h=($src_height/$src_width)*$dst_width;
	}
	else 
	{
		$dst_h=$dst_height;
		$dst_w=($src_width/$src_height)*$dst_height;
	} 
	
	$dstImage = imagecreatetruecolor($dst_w, $dst_h);
	imageantialias($dstImage, true);
	$white = imagecolorallocate($dstImage, 255, 255, 255);
	imagefill($dstImage, 0, 0, $white);

	imagecopyresampled($dstImage, $srcImage, 0, 0 , 0, 0, $dst_w, $dst_h, $src_width, $src_height);
	imagejpeg($dstImage, $thumbnail, $plugin_cf['fotogalerie']['image_jpg_quality']);
	imagedestroy($dstImage);
}

//echo $_REQUEST['gid'];
//print_r($files);

function rebuild_thumbs($files) 
{
	global $plugin_cf, $filepath;
	$rebuild_filter=$_REQUEST['gid'];
	foreach ($files as $num => $rec) 
	{
		$gid_rebuild=$rec[2];
		$id=$rec[0];
		
		if($gid_rebuild==$rebuild_filter)
		{
		$arr_img = fogaimageFromUpload($filepath.'/'.$id.'.jpg');
		$rc=unlink($filepath.'/thumbs/'.$id.'t.jpg');
		saveThumb($arr_img,$filepath.'/thumbs/'.$id.'t.jpg',$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['image_jpg_quality']);
		}
	}
}

function rebuild_all_thumbs($files) 
{
	global $plugin_cf, $filepath;
	$rebuild_filter=$_REQUEST['gid'];
	foreach ($files as $num => $rec) 
	{
		$id=$rec[0];
		$arr_img = fogaimageFromUpload($filepath.'/'.$id.'.jpg');
		$rc=unlink($filepath.'/thumbs/'.$id.'t.jpg');
		saveThumb($arr_img,$filepath.'/thumbs/'.$id.'t.jpg',$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['thumb_max_size'],$plugin_cf['fotogalerie']['image_jpg_quality']);
	}
}


// MAIN CODE

if(isset($fotogalerie)) 
{
	$admin=fogaGetVar('admin');
	$action=fogaGetVar('action');
	$plugin=basename(dirname(__FILE__),"/");
	$fngroup='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_data'].'album.txt';
	$fnfile='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_data'].'photo.txt';
    $imgpath=$pth['folder']['plugins'].@$co_author_folder.$plugin."/images";
    $filepath='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_images'];
	$filepath_uploads='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_uploads'];
	$datapath='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_data'];
	
	fogaWriteAccess($fngroup);
	fogaWriteAccess($fnfile);
	fogaWriteAccess($pth['folder']['plugins']."$plugin/config/config.php");
	fogaWriteAccess($pth['folder']['plugins']."$plugin/css/stylesheet.css");
	fogaWriteAccess($pth['folder']['plugins']."$plugin/languages/$sl.php");
	fogaWriteAccess($filepath);
		
	$o.=print_plugin_admin('on');
	
	if($admin<>'plugin_main')
	{
		$o.=plugin_admin_common($action,$admin,$plugin);
	}
	
	if($admin=='')
	{
		$o.='<h4>FotoGalerie_XH</h4>
		<hr />
		<p><b>Version: </b>v6.6</p>
		<p><b>Released: </b>11/2012</p>
		<p><b>Developed by: </b><a href="http://www.ge-webdesign.de/cmsimpleplugins/">ge-webdesign.de</a></p>
		<hr />
		<p><b>based on:</b></p>
		<ul>
		<li>kissGallery from Claus Højberg (alias Softly)</li>
		<li>Shutter Reloaded: <a href="http://www.laptoptips.ca/javascripts/shutter-reloaded/">laptoptips.ca</a></li>
		<li>TableSort script: <a href="http://javascript.jstruebig.de/">Joachim Strübig</a></li>
		</ul>
		<hr />
		<p><b>Licenses:</b></p>
		<ul>
		<li>Linkware License (private websites)</li>
		<li>Remove Link License (private websites - small fee)</li>
		<li>Commercial License (commercial websites - for costs)</li>
		</ul>
		<p><b>For License Prices see: </b><a href="http://www.ge-webdesign.de/cmsimpleplugins/">ge-webdesign.de</a><br />
		<hr />
		<p><b>Please consider: </b></p>
		<p>No guarantee or warranty - use FotoGalerie_XH on your own risk!</p>';
	}

	if ($admin == 'plugin_main') 
	{
		$o.='<p style="font-family: arial, sans-serif"><b>Fotogalerie</b></p>';
		$id=fogaGetVar('id');
		$gid=fogaGetVar('gid');
		$groups=fogaRFile($fngroup);
		
		if ($action=='save_group') 
		{
			$order=fogaGetNumber(fogaGetVar('order'));
			$name=strtr(fogaGetVar('name'),'§§§','_');
			$fogashowname=strtr(fogaGetVar('fogashowname'),'§§§','_');
			$desc=strtr(fogaGetVar('desc'),'§§§','_');
			$fogashowdesc=strtr(fogaGetVar('fogashowdesc'),'§§§','_');
			$fogalayout=strtr(fogaGetVar('fogalayout'),'§§§','_');
			$fogathumbsalign=strtr(fogaGetVar('fogathumbsalign'),'§§§','_');
			$fogathumbcols=strtr(fogaGetVar('fogathumbcols'),'§§§','_');
			$fogathumbheight=strtr(fogaGetVar('fogathumbheight'),'§§§','_');
			$fogathumbclick=strtr(fogaGetVar('fogathumbclick'),'§§§','_');
			$fogaslide_align=strtr(fogaGetVar('fogaslide_align'),'§§§','_');
			$fogaslide_imgheight=strtr(fogaGetVar('fogaslide_imgheight'),'§§§','_');
			$fogaslide_thumbheight=strtr(fogaGetVar('fogaslide_thumbheight'),'§§§','_');
			$fogaslide_showthumbs=strtr(fogaGetVar('fogaslide_showthumbs'),'§§§','_');
			$fogaslide_showdesc=strtr(fogaGetVar('fogaslide_showdesc'),'§§§','_');
			$foga_bigpic_padding=strtr(fogaGetVar('foga_bigpic_padding'),'§§§','_');
			$foga_thumbs_padding=strtr(fogaGetVar('foga_thumbs_padding'),'§§§','_');
			$foga_pics_background=strtr(fogaGetVar('foga_pics_background'),'§§§','_');
			$foga_pics_border=strtr(fogaGetVar('foga_pics_border'),'§§§','_');
			
			if ($gid==0) 
			{
				$gid=fogaNextID($groups);
				$groups[]=array($gid,$order,$name,$fogashowname,$desc,$fogashowdesc,$fogalayout,$fogathumbsalign,$fogathumbcols,$fogathumbheight,$fogathumbclick,$fogaslide_align,$fogaslide_imgheight,$fogaslide_thumbheight,$fogaslide_showthumbs,$fogaslide_showdesc,$foga_bigpic_padding,$foga_thumbs_padding,$foga_pics_background,$foga_pics_border);
			} 
			else 
			{
				foreach ($groups as $num => $rec) 
				{
					if ($rec[0]==$gid) 
					{
						$groups[$num][1]=$order;
						$groups[$num][2]=$name;
						$groups[$num][3]=$fogashowname;
						$groups[$num][4]=$desc;
						$groups[$num][5]=$fogashowdesc;
						$groups[$num][6]=$fogalayout;
						$groups[$num][7]=$fogathumbsalign;
						$groups[$num][8]=$fogathumbcols;
						$groups[$num][9]=$fogathumbheight;
						$groups[$num][10]=$fogathumbclick;
						$groups[$num][11]=$fogaslide_align;
						$groups[$num][12]=$fogaslide_imgheight;
						$groups[$num][13]=$fogaslide_thumbheight;
						$groups[$num][14]=$fogaslide_showthumbs;
						$groups[$num][15]=$fogaslide_showdesc;
						$groups[$num][16]=$foga_bigpic_padding;
						$groups[$num][17]=$foga_thumbs_padding;
						$groups[$num][18]=$foga_pics_background;
						$groups[$num][19]=$foga_pics_border;
					}
				}
			}
			fogaWFile($fngroup,$groups);
			$groups=fogaRFile($fngroup);
		}
		
		
// FORM EDIT GALLERY PROPERTIES / ADD GALLERY
		
		if ($action=='edit_group') 
		{
			foreach ($groups as $num => $rec) 
			{
				if ($rec[0]==$gid) 
				{
					$order=$rec[1];
					$name=$rec[2];
					$fogashowname=$rec[3];
					$desc=$rec[4];
					$fogashowdesc=$rec[5];
					$fogalayout=$rec[6];
					$fogathumbsalign=$rec[7];
					$fogathumbcols=$rec[8];
					$fogathumbheight=$rec[9];
					$fogathumbclick=$rec[10];
					$fogaslide_align=$rec[11];
					$fogaslide_imgheight=$rec[12];
					$fogaslide_thumbheight=$rec[13];
					$fogaslide_showthumbs=$rec[14];
					$fogaslide_showdesc=$rec[15];
					$foga_bigpic_padding=$rec[16];
					$foga_thumbs_padding=$rec[17];
					$foga_pics_background=$rec[18];
					$foga_pics_border=$rec[19];
				}
			}
			
			if(!isset($fogalayout)){$fogalayout=$plugin_cf['fotogalerie']['default_gallery_layout'];}
			if(!isset($fogathumbsalign)){$fogathumbsalign=$plugin_cf['fotogalerie']['default_gallery_thumbs_align'];}
			if(!isset($fogathumbcols)){$fogathumbcols=$plugin_cf['fotogalerie']['default_gallery_thumbs_numberoff'];}
			if(!isset($fogathumbheight)){$fogathumbheight=$plugin_cf['fotogalerie']['default_gallery_thumbs_height'];}
			if(!isset($fogathumbclick)){$fogathumbclick=$plugin_cf['fotogalerie']['default_gallery_thumbs_click'];}
			if(!isset($fogaslide_align)){$fogaslide_align=$plugin_cf['fotogalerie']['default_slideshow_align'];}
			if(!isset($fogaslide_imgheight)){$fogaslide_imgheight=$plugin_cf['fotogalerie']['default_slideshow_imgheight'];}
			if(!isset($fogaslide_thumbheight)){$fogaslide_thumbheight=$plugin_cf['fotogalerie']['default_slideshow_thumbs_height'];}
			if(!isset($fogashowname)){$fogashowname=$plugin_cf['fotogalerie']['default_gallery_show_name'];}
			if(!isset($fogashowdesc)){$fogashowdesc=$plugin_cf['fotogalerie']['default_gallery_show_desc'];}
			if(!isset($fogaslide_showthumbs)){$fogaslide_showthumbs=$plugin_cf['fotogalerie']['default_slideshow_show_thumbs'];}
			if(!isset($fogaslide_showdesc)){$fogaslide_showdesc=$plugin_cf['fotogalerie']['default_slideshow_show_desc'];}
			if(!isset($foga_bigpic_padding)){$foga_bigpic_padding=$plugin_cf['fotogalerie']['default_slideshow_bigpic_padding'];}
			if(!isset($foga_thumbs_padding)){$foga_thumbs_padding=$plugin_cf['fotogalerie']['default_slideshow_thumbs_padding'];}
			if(!isset($foga_pics_background)){$foga_pics_background=$plugin_cf['fotogalerie']['default_pics_background'];}
			if(!isset($foga_pics_border)){$foga_pics_border=$plugin_cf['fotogalerie']['default_pics_border'];}
			
			if($gid=='0')
			{
				$o.='<h4>'.$plugin_tx['fotogalerie']['form_gallery_create'].'</h4>';
			}
			else
			{
				$o.='<h4>'.$plugin_tx['fotogalerie']['form_gallery_edit'].'</h4>';
			}
			
			$o .='<form method="post" action="'.$sn.'?'.amp().$plugin.'">';
			$o .='<div class="fotogalerie_edit">';
			$o .="\n" . '<p style="text-align: right;"><a href="' . $sn . '?' . amp() . $plugin . '&admin=' . $admin . '&action=rebuild_thumbs&gid=' . $gid . '" onClick="return confirm(\'' . $plugin_tx['fotogalerie']['message_rebuild_thumbs_confirm'] . '\')"' . '>' . $plugin_tx['fotogalerie']['thumbs_rebuild'] . '</a></p>' . "\n";
			$o .='
			<table cellspacing="0">
			';
			
			$o .='
			<tr>
			<td valign="top"><input type="submit" value="' . ucfirst(strtolower($tx['action']['save'])) . '" name="save" id="save" /></td>
			<td> </td>
			</tr>
			';
			
			// selected gallery ID
			
			if($gid > 0)
			{
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['group_selected'] . '</td>
			<td valign="top"><span style="background: #060; color: #fff; line-height: 1em; border: 1px solid #333; padding: 3px 6px;"><b>id' . $gid . '</b> - ' . $name . '</span></td>
			</tr>
			';
			}
			
			// gallery order number
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['order_id'] . '</td>
			<td><input type="text" class="text" size="64" value="' . @$order . '" name="order" width="64" /></td>
			</tr>
			';
			
			// gallery name
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_name'] . '</td>
			<td><input type="text" class="text" size="64" value="' . @$name . '" name="name" width="64" /></td>
			</tr>
			';
			
			// gallery infotext
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_infotext'] . '</td>
			<td><input type="text" class="text" size="64" value="' . @$desc . '" name="desc" /></td>
			</tr>
			';
			
			
			
			
			
			// headline gallery global
			
			$o .='
			<tr>
			<td colspan="2"><h4>' . $plugin_tx['fotogalerie']['headline_gallery_header'] . '</h4></td>
			</tr>
			';
			
			
			
			
			// show gallery name?
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_show_name'] . '</td>
			<td><input type="radio" name="fogashowname" value="true" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogashowname == 'true')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_yes'] . '<br />
			<input type="radio" name="fogashowname" value="false" style="width: 16px; margin: 2px 0 6px 0;" ';
			
			if($fogashowname == 'false')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_no'] . '</td>
			</tr>
			';
			
			// show gallery infotext?
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_show_infotext'] . '</td>
			<td><input type="radio" name="fogashowdesc" value="true" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogashowdesc == 'true')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_yes'] . '<br />
			<input type="radio" name="fogashowdesc" value="false" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogashowdesc == 'false')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_no'] . '</td>
			</tr>
			';
			
			// headline gallery preview
			
			$o .='
			<tr>
			<td colspan="2"><h4>' . $plugin_tx['fotogalerie']['headline_gallery_thumbs'] . '</h4></td>
			</tr>
			';
			
			// preview layout
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_layout'] . '</td>
			<td><input type="radio" name="fogalayout" value="table" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogalayout == 'table')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_table'] . '<br />
			<input type="radio" name="fogalayout" value="float" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogalayout == 'float')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_float'] . '</td>
			</tr>
			';
			
			// number of pics in 1 line
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_thumbs_number_of'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $fogathumbcols . '" name="fogathumbcols" width="64" /><br />' . $plugin_tx['fotogalerie']['form_gallery_thumbs_number_hint'] . '</td>
			</tr>
			';
			
			// preview align
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_align'] .'</td>
			<td><input type="radio" name="fogathumbsalign" value="left" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogathumbsalign == 'left')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_left'] . '<br />
			<input type="radio" name="fogathumbsalign" value="center" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogathumbsalign == 'center')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_center'] . '<br />
			<input type="radio" name="fogathumbsalign" value="right" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogathumbsalign == 'right')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_right'] . '</td>
			</tr>
			';
			
			// preview thumbs height
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_thumbs_height'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $fogathumbheight . '" name="fogathumbheight" width="64" /><br/>' . $plugin_tx['fotogalerie']['form_gallery_thumbs_height_hint'] . '</td>
			</tr>
			';
			
			// Lightbox or Slideshow?
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_gallery_thumbs_click'] . '</td>
			<td><input type="radio" name="fogathumbclick" value="lightbox" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogathumbclick == 'lightbox')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_lightbox'] . '<br /> 
			<input type="radio" name="fogathumbclick" value="slideshow" style="width: 16px; margin: 2px 0 6px 0;" ';
			
			if($fogathumbclick == 'slideshow')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_slideshow'] . '</td>
			</tr>
			';
			
			$o .='
			<tr>
			<td colspan="2"><h4>' . $plugin_tx['fotogalerie']['headline_gallery_slideshow'] . '</h4></td>
			</tr>
			';
			
			// slideshow align
			
			$o .='
			<tr><td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_align'] . '</td>
			<td><input type="radio" name="fogaslide_align" value="left" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogaslide_align == 'left')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_left'] . '<br />
			<input type="radio" name="fogaslide_align" value="center" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogaslide_align == 'center')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_center'] . '<br />
			<input type="radio" name="fogaslide_align" value="right" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogaslide_align == 'right')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_right'] . '</td>
			</tr>
			';
			
			// slideshow image height
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_image_height'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $fogaslide_imgheight . '" name="fogaslide_imgheight" width="64" />			</td>
			</tr>
			';
			
			// slideshow thumbs height
			
			$o .='
			<tr>
			<td valign="top">' .$plugin_tx['fotogalerie']['form_slideshow_thumbs_height'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $fogaslide_thumbheight . '" name="fogaslide_thumbheight" width="64" /></td>
			</tr>
			';
			
			// show slideshow thumbs?
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_thumbs_show'] . '</td>
			<td><input type="radio" name="fogaslide_showthumbs" value="true" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogaslide_showthumbs == 'true')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_yes'] . '<br />
			<input type="radio" name="fogaslide_showthumbs" value="false" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogaslide_showthumbs == 'false')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_no'] . '</td>
			</tr>
			';
			
			// show slideshow infotext?
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_desc_show'] . '</td>
			<td><input type="radio" name="fogaslide_showdesc" value="true" style="width: 16px; margin: 2px 0 6px 0;"';
			if($fogaslide_showdesc == 'true')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_yes'] . '<br />
			<input type="radio" name="fogaslide_showdesc" value="false" style="width: 16px; margin: 2px 0 6px 0;" ';
			if($fogaslide_showdesc == 'false')
			{
				$o.='checked="checked"';
			}
			$o.='> ' . $plugin_tx['fotogalerie']['radiobutton_no'] . '</td>
			</tr>
			';
						
			$o .='
			<tr>
			<td colspan="2"><h4>' . $plugin_tx['fotogalerie']['headline_gallery_imgdesign'] . '</h4></td>
			</tr>
			';
			
			// slideshow bigpic padding
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_bigpic_padding'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $foga_bigpic_padding . '" name="foga_bigpic_padding" width="64" /></td>
			</tr>
			';
			
			// slideshow thumbs padding
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_slideshow_thumbs_padding'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $foga_thumbs_padding . '" name="foga_thumbs_padding" width="64" /></td>
			</tr>
			';
			
			// images background color
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_pics_background'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $foga_pics_background . '" name="foga_pics_background" width="64" /><br />' . $plugin_tx['fotogalerie']['cf_default_pics_background'] . '</td>
			</tr>
			';
			
			// images border
			
			$o .='
			<tr>
			<td valign="top">' . $plugin_tx['fotogalerie']['form_pics_border'] . '</td>
			<td><input type="text" class="text" size="64" value="' . $foga_pics_border . '" name="foga_pics_border" width="64" /><br />' . $plugin_tx['fotogalerie']['cf_default_pics_border'] . '</td>
			</tr>
			';
			
			$o .='
			<tr>
			<td valign="top"><input type="submit" value="' . ucfirst(strtolower($tx['action']['save'])) . '" name="save" id="save" /></td>
			<td> </td>
			</tr>
			';

			$o .='</table>
			</div>
			<input type="hidden" value="' . $admin . '" name="admin" />
			<input type="hidden" value="save_group" name="action" />
			<input type="hidden" value="' . $gid . '" name="gid" />
			</form>
			';
		}
		
		
// SAVE ROUTINE

		$files=fogaRFile($fnfile);
		if ($action=='save_file') 
		{
			$order=fogaGetNumber(fogaGetVar('order'));
			$file_name=fogaGetVar('file_name');
			$desc=strtr(fogaGetVar('desc'),'§§§','_');           
			if ($id==0) 
			{
				$file_name = strtolower($_FILES['file_name']['name']);
				if ($desc=='') $desc=$file_name;
				if ($order=='') $order='0';
				$file_size = $_FILES['file_name']['size'];
				$file_tmp = $_FILES['file_name']['tmp_name'];
				$file_type = $_FILES['file_name']['type'];
				$ext='/\\'.str_replace(',','|\\',$plugin_cf['fotogalerie']['file_extension']).'/i';
				if (!(preg_match($ext, $file_name))) $e.='<li>'.$tx['error']['wrongext'].' '.$file_name.'</li>';
				if ($file_size > $plugin_cf['fotogalerie']['image_max_filesize']) $e .= '<li>'.$file_name.' '.$tx['error']['tolarge'].' '.$plugin_cf['fotogalerie']['image_max_filesize'].' '.$tx['files']['bytes'].'</li>';
				if (!$e) 
				{
					$id=fogaNextID($files);
					if (fogagetImage($file_tmp,$id,$filepath)) 
					{
						$o .= '<p class="cmsimplecore_warning" style="text-align: center;">'.ucfirst($tx['filetype']['file']).' '.$file_name.' '.$tx['result']['uploaded'].'</p>';
						$file_datetime=time();
						$files[]=array($id,$order,$gid,$file_name,$file_datetime,$file_type,$desc);
					}
					else e('cntsave', 'file', $file_name);
				}
			} 
			else 
			{
				foreach ($files as $num => $rec) 
				{
					if ($rec[0]==$id) 
					{
						$files[$num][1]=$order;
						$files[$num][2]=$gid;
						$files[$num][6]=$desc;  
                    }
				}
			}
			fogaWFile($fnfile,$files);
  			$files=fogaRFile($fnfile);
		}
		
		
// DELETE SINGLE IMAGE
		
		if ($action=='delete_file') 
		{
			$tarr=array();
			foreach ($files as $num => $rec) 
			{
				if ($rec[0]!=$id) 
				{
					$tarr[]=$rec;
					if(file_exists($filepath.$id.'.jpg'))
					{
						$rrr=unlink($filepath.$id.'.jpg');
					}
					if(file_exists($filepath.'thumbs/'.$id.'t.jpg'))
					{
						$rrr=unlink($filepath.'thumbs/'.$id.'t.jpg');
					}
				}
			}
			fogaWFile($fnfile,$tarr);
  			$files=fogaRFile($fnfile);
			$o.='<p class="cmsimplecore_warning" style="text-align: center;">' . $plugin_tx['fotogalerie']['message_deleted_image'] . '</p>';
		}	
	
		
// DELETE ALL IMAGES OF A GALLERY

		if (sizeof($groups)>0 && $action=='delete_all_images') 
		{
			$gid=$_REQUEST['gid'];
			foreach ($files as $num => $rec) 
			{
				$id=$rec[0];
				if ($rec[2] == $_REQUEST['gid']) 
				{
					$tarr=array();
					foreach ($files as $num => $rec) 
					{
						if ($rec[0]!=$id) 
						{
							$tarr[]=$rec;
							if(file_exists($filepath.$id.'.jpg'))
							{
								$rrr=unlink($filepath.$id.'.jpg');
							}
							if(file_exists($filepath.'thumbs/'.$id.'t.jpg'))
							{
								$rrr=unlink($filepath.'thumbs/'.$id.'t.jpg');
							}
						}
					}
					fogaWFile($fnfile,$tarr);
					$files=fogaRFile($fnfile);
				}
			}
			$o.='<p class="cmsimplecore_warning" style="text-align: center;">' . $plugin_tx['fotogalerie']['message_deleted_images'] . '</p>';
		}


// UPLOAD SINGLE IMAGE
		
		if ($action=='edit_file' || fogaGetVar('more')) 
		{
			if (fogaGetVar('more')) {$id=0;}
			$order='';
			$file_name='';
			$file_datetime=0;
			$desc='';
			foreach ($files as $num => $rec) 
			{
				if ($rec[0]==$id) 
				{
					$order=$rec[1];
					$gid=$rec[2];
					$file_name=$rec[3];
					$file_datetime=date($plugin_cf['fotogalerie']['datetime_format'],$rec[4]);
					$desc=$rec[6];
				}
			}
			
			
// UPLOAD FORM
			
			$o .='<form method="post" action="'.$sn.'?'.amp().$plugin.'" enctype="multipart/form-data">';
			$o .='<div class="fotogalerie_edit">';
			if($id=='0')
			{
				$o.='<h4>' .$plugin_tx['fotogalerie']['icon_add_image']. '</h4>';
			}
			if($id!='0')
			{
				$o.='<h4>' .$plugin_tx['fotogalerie']['icon_edit_image']. '</h4>';
			}
			$o .='<table cellspacing="0">';
			if (!$id==0) $o .='<tr><td><label></label></td><td><img src="'.$filepath.'thumbs/'.$id.'t.jpg" border="0" style="float: right; border: 1px solid; padding: 0;" alt="" /></td></tr>';
			$o .='<tr><td style="width: 33%;"><label>'.$plugin_tx['fotogalerie']['file_id']."</label></td><td>$id</td></tr>";
			$o .="<tr><td><label>".$plugin_tx['fotogalerie']['file_name']."</label></td><td>";
			if ($id==0) $o .="<input type='file' class='text' size='24' value=\" \" name='file_name' width='64' /></td></tr>";
			else $o .="$file_name</td></tr>";
			if ($id>0) $o .="<tr><td><label>".$plugin_tx['fotogalerie']['file_datetime']."</label></td><td>$file_datetime</td></tr>";
			$o .="<tr><td><label>".$plugin_tx['fotogalerie']['order_id']."</label></td><td><input type='text' class='text' size='64' value=\"$order\" name='order' style=\"width: 96%\" /></td></tr>";
            $o .="<tr><td><label>".$plugin_tx['fotogalerie']['description']."</label></td><td><input type='text' class=\"text\" size='64' value=\"$desc\" name='desc' style=\"width: 96%\" /></td></tr>";
			$o .="<tr><td><label>".$plugin_tx['fotogalerie']['group_selected']."</label></td><td><select name='gid'  style=\"background: #060; color: #fff; border: 1px solid #333;\">";
			foreach ($groups as $num => $rec) 
			{
				$o .="<option value=\"$rec[0]\"";
				if ($rec[0]==$gid) 
				{
					$o .=' SELECTED';
				}
				$o .= ">id$rec[0] - $rec[2]&nbsp;&nbsp;</option>";
			}
			$o .="</select></td></tr>";
			if ($id==0)	$o .="<tr><td></td><td><input type='checkbox' name='more' style='width: 20px; text-align: left;' />&nbsp;".$plugin_tx['fotogalerie']['more_uploads']."</td></tr>";
			$o .="<tr><td><input type='submit' value=".ucfirst(strtolower($tx['action']['save']))." name='save' id='save' /></td><td></td></tr>";
			$o .="</table>";
			$o .="</div>";
			$o .="<input type='hidden' value='$admin' name='admin' />";
			$o .="<input type='hidden' value='save_file' name='action' />";
			$o .="<input type='hidden' value=\"$id\" name='id' />";
			$o .="</form>";
		}
		
		
// MASS UPLOAD (add images from upload folder to selected gallery)	
		
		if ($action=='add_uploads')
		{
			$o.="\n".'<h4>' .$plugin_tx['fotogalerie']['icon_add_images']. '</h4>'."\n";

			$uploads_array = Array();
			if(is_dir($filepath_uploads))
			{
				$handle = opendir($filepath_uploads);
				if(is_resource($handle))
				{
					while($file = readdir($handle))
					{
						if($file != "." && $file != "..")
						{		
							array_push($uploads_array, $file);
						}
					}
				}
				else
				{
					echo "Could not open directory";
				}
			}
			else
			{
				echo "Directory not exists";
			}
			
			natcasesort($uploads_array);

			$foga_nextid = fogaNextID($files)-1;
			
			if(count($uploads_array)!=0)
			{
				$o.='<p><b>' .$plugin_tx['fotogalerie']['imgadd_folder_actions']. '</b></p>'."\n";
			}
			
			$fogacount_uploads=count($uploads_array);
			
			$o.='<ul>'."\n";

			foreach($uploads_array as $bild)
			{
				$foga_name_old   = $filepath_uploads.$bild;
				$foga_name_array = explode('.', $foga_name_old);
				end($foga_name_array);
				$i = key($foga_name_array);
				$suffix = $foga_name_array[$i];
				
				$foga_pixel=getimagesize($foga_name_old);
				$foga_pixel2=$foga_pixel[0]*$foga_pixel[1];
				$foga_nextid=$foga_nextid+1;
				
				if(filesize($foga_name_old) >= $plugin_cf['fotogalerie']['image_max_filesize'] || $foga_pixel2 >= $plugin_cf['fotogalerie']['image_max_px'])
				{
					$o.='<li><b>'.$bild.' </b>' .$plugin_tx['fotogalerie']['message_filesize']. '</li>'."\n";
				}
				else
				{

					if($suffix=='jpg' || $suffix=='jpeg' || $suffix=='JPG' || $suffix=='JPEG' )
					{
						$im = ImageCreateFromJPEG($foga_name_old);
						$width = ImageSX($im);
						$height = ImageSY($im);
	
						if($width>$height)
						{							
							if($plugin_cf['fotogalerie']['image_jpg_resize'] != 'true')
							{
								rename($foga_name_old, $filepath.$foga_nextid.'.jpg');
							}
							else
							{
								if($width>$plugin_cf['fotogalerie']['image_max_size'])
								{
									$bwidth = $plugin_cf['fotogalerie']['image_max_size'];
								}
								else
								{
									$bwidth = $width;
								}
								$bheight = ($height/$width)*$bwidth;
								$imb = imagecreatetruecolor($bwidth,$bheight);
								imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);
								imagejpeg($imb, $filepath.$foga_nextid.'.jpg', $plugin_cf['fotogalerie']['image_jpg_quality']);
							}
							$twidth = $plugin_cf['fotogalerie']['thumb_max_size'];
							$theight = ($height/$width)*$twidth;							
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);			
							imagejpeg($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg', $plugin_cf['fotogalerie']['image_jpg_quality']);
							
							if($plugin_cf['fotogalerie']['image_jpg_resize'] == 'true')
							{
								unlink($foga_name_old);
							}
						}
						else
						{
							if($plugin_cf['fotogalerie']['image_jpg_resize'] != 'true')
							{
								rename($foga_name_old, $filepath.$foga_nextid.'.jpg');
							}
							else
							{
							if($height>$plugin_cf['fotogalerie']['image_max_size'])
								{
									$bheight = $plugin_cf['fotogalerie']['image_max_size'];
								}
								else
								{
									$bheight = $height;
								}
								$bwidth = ($width/$height)*$bheight;
								$imb = imagecreatetruecolor($bwidth,$bheight);
								imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);
								imagejpeg($imb, $filepath.$foga_nextid.'.jpg', $plugin_cf['fotogalerie']['image_jpg_quality']);
							}
							
							$theight = $plugin_cf['fotogalerie']['thumb_max_size'];
							$twidth = ($width/$height)*$theight;
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);	
							imagejpeg($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg', $plugin_cf['fotogalerie']['image_jpg_quality']);
							
							if($plugin_cf['fotogalerie']['image_jpg_resize'] == 'true')
							{
								unlink($foga_name_old);
							}
						}
						$o.='<li>' .$plugin_tx['fotogalerie']['imgadd_file']. '<b> '.$bild.'</b> ' .$plugin_tx['fotogalerie']['imgadd_added']. '<br>' .$plugin_tx['fotogalerie']['imgadd_deleted']. '<br>' .$plugin_tx['fotogalerie']['imgadd_database']. '<br>' .$plugin_tx['fotogalerie']['imgadd_id']. ' ' .$foga_nextid.'</li>';
					}

					if($suffix=='gif' || $suffix=='GIF')
					{
						$im = imagecreatefromgif($foga_name_old);
						$width = imagesx($im);
						$height = imagesy($im);
		

						if($width>$height)
						{
							if($width>$plugin_cf['fotogalerie']['image_max_size'])
							{
								$bwidth = $plugin_cf['fotogalerie']['image_max_size'];
							}
							else
							{
								$bwidth = $width;
							}
							$bheight = ($height/$width)*$bwidth;
							$imb = imagecreatetruecolor($bwidth,$bheight);
							imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);
							imagegif($imb, $filepath.$foga_nextid.'.jpg');
							
							$twidth = $plugin_cf['fotogalerie']['thumb_max_size'];
							$theight = ($height/$width)*$twidth;
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);
							imagegif($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg');
							
							unlink($foga_name_old);
						}
						else
						{
							if($height>$plugin_cf['fotogalerie']['image_max_size'])
							{
								$bheight = $plugin_cf['fotogalerie']['image_max_size'];
							}
							else
							{
								$bheight = $height;
							}
							$bwidth = ($width/$height)*$bheight;
							$imb = imagecreatetruecolor($bwidth,$bheight);
							imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);
							imagegif($imb, $filepath.$foga_nextid.'.jpg');
							
							$theight = $plugin_cf['fotogalerie']['thumb_max_size'];
							$twidth = ($width/$height)*$theight;
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);	
							imagegif($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg');
							
							unlink($foga_name_old);
						}
						$o.='<li>' .$plugin_tx['fotogalerie']['imgadd_file']. '<b> '.$bild.'</b> ' .$plugin_tx['fotogalerie']['imgadd_added']. '<br>' .$plugin_tx['fotogalerie']['imgadd_deleted']. '<br>' .$plugin_tx['fotogalerie']['imgadd_database']. '<br>' .$plugin_tx['fotogalerie']['imgadd_id']. ' ' .$foga_nextid.'</li>'."\n";
					}

					if($suffix=='png' || $suffix=='PNG')
					{
						$im = imagecreatefrompng($foga_name_old);
						$width = imagesx($im);
						$height = imagesy($im);

						if($width>$height)
						{
							if($width>$plugin_cf['fotogalerie']['image_max_size'])
							{
								$bwidth = $plugin_cf['fotogalerie']['image_max_size'];
							}
							else
							{
								$bwidth = $width;
							}
							$bheight = ($height/$width)*$bwidth;
							$imb = imagecreatetruecolor($bwidth,$bheight);
							imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);
							imagepng($imb, $filepath.$foga_nextid.'.jpg');
							
							$twidth = $plugin_cf['fotogalerie']['thumb_max_size'];
							$theight = ($height/$width)*$twidth;
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);
							imagepng($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg');
							
							unlink($foga_name_old);
						}
						else
						{
							if($height>$plugin_cf['fotogalerie']['image_max_size'])
							{
								$bheight = $plugin_cf['fotogalerie']['image_max_size'];
							}
							else
							{
								$bheight = $height;
							}
							$bwidth = ($width/$height)*$bheight;
							$imb = imagecreatetruecolor($bwidth,$bheight);
							imagecopyresampled($imb,$im,0,0,0,0,$bwidth,$bheight,$width,$height);	
							imagepng($imb, $filepath.$foga_nextid.'.jpg');
							
							$theight = $plugin_cf['fotogalerie']['thumb_max_size'];
							$twidth = ($width/$height)*$theight;
							$imt = imagecreatetruecolor($twidth,$theight);
							imagecopyresampled($imt,$im,0,0,0,0,$twidth,$theight,$width,$height);	
							imagepng($imt, $filepath.'thumbs/'.$foga_nextid.'t.jpg');
							
							unlink($foga_name_old);
						}
						$o.='<li>' .$plugin_tx['fotogalerie']['imgadd_file']. '<b> '.$bild.'</b> ' .$plugin_tx['fotogalerie']['imgadd_added']. '<br>' .$plugin_tx['fotogalerie']['imgadd_deleted']. '<br>' .$plugin_tx['fotogalerie']['imgadd_database']. '<br>' .$plugin_tx['fotogalerie']['imgadd_id']. ' ' .$foga_nextid.'</li>';
					}

					if(is_dir($datapath))
					{
						$handle = fopen($datapath.'photo.txt', 'a');
						fwrite($handle,$foga_nextid.'§§§0§§§'.$gid.'§§§'.$bild.'§§§'.date('U').'§§§image/jpeg§§§'.$bild."\n");
						fclose($handle);
					}
					else
					{
						echo "Could not open directory";
					}

				$fogacount_uploads=$fogacount_uploads-1;
				
				} // end else
			} // end foreach
			
			$o.='</ul>'."\n";
			
			if($fogacount_uploads == 0)
			{
				$o.='<p class="cmsimplecore_warning" style="text-align: center; margin: 24px 0;"><b>' .$plugin_tx['fotogalerie']['message_folder_empty']. '</b></p>'."\n";
			}
			else
			{
				$o.='<p class="cmsimplecore_warning" style="text-align: center; margin: 24px 0;"><b>' .$plugin_tx['fotogalerie']['message_folder_not_empty']. '</b></p>'."\n";
			}
		}

		
// SELECT AND EDIT GALLERY (main edit screen)
		
		if ($action!='edit_file' && $action!='add_uploads' && $action!='edit_group' && !fogaGetVar('more')) 
		{
			if ($action=='rebuild_all_thumbs') rebuild_all_thumbs($files);
			$o.="\n<p style=\"text-align: right;\"><a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=rebuild_all_thumbs\"" . 'onClick="return confirm(\'' . $plugin_tx['fotogalerie']['message_rebuild_thumbs_all_confirm'] . '\')"'.">" . $plugin_tx['fotogalerie']['thumbs_rebuild_all'] . "</a></p>\n";
			$o.='<div class="fotogalerie_edit">'."\n".'<h4>'.$plugin_tx['fotogalerie']['headline_select_gallery'].'</h4>'."\n";
			$o.="<form style=\"padding: 0; margin: 0;\">\n<b>".$plugin_tx['fotogalerie']['group'].": </b>\n<select name=\"gid\" onchange=\"location.href=this.options[this.selectedIndex].value\" style=\"background: #060; color: #fff; border: 1px solid #333;\">\n";
			if ($gid=='') 
			{
				$gid=$groups[0][0];
			}
			foreach ($groups as $num => $rec) 
			{
				$o .="<option value=\"$sn?&$plugin&admin=$admin&action=list_files&gid=$rec[0]\"".(($rec[0] == $gid)?' selected="selected"':$gid).">id $rec[0] - $rec[2]&nbsp;&nbsp;</option>\n";
			}
			$o.="</select>\n";
			$o.="</form>\n</div>\n<br /><hr />\n";
			if (sizeof($groups)>0) 
			{
				$o.="\n<p><a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=edit_group&gid=$gid\"><img src=\"$imgpath/edit.gif\" style=\"border: 0; margin: 0 6px 0 0;\" title=\"".$plugin_tx['fotogalerie']['icon_edit_gallery']."\" alt=\"".$plugin_tx['fotogalerie']['icon_edit_gallery']."\" />" .$plugin_tx['fotogalerie']['icon_edit_gallery']. "</a></p>";
				
				$o.="\n<p><a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=edit_group&gid=0\"><img src=\"$imgpath/add.gif\" style=\"border: 0; margin: 0 6px 0 0;\" title=\"".$plugin_tx['fotogalerie']['icon_add_gallery']."\" alt=\"".$plugin_tx['fotogalerie']['icon_add_gallery']."\" />" .$plugin_tx['fotogalerie']['icon_add_gallery']. "</a></p>";
				
				
				$o.="\n<p><a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=edit_file&id=0&gid=$gid\"><img src=\"$imgpath/add.gif\" style=\"border: 0; margin: 0 6px 0 0;\" title=\"".$plugin_tx['fotogalerie']['icon_add_image']."\" alt=\"".$plugin_tx['fotogalerie']['icon_add_image']."\" />".$plugin_tx['fotogalerie']['headline_upload_image'].'</a></p>';
				
				$o.="\n<p><a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=add_uploads&id=0&gid=$gid\"><img src=\"$imgpath/add.gif\" style=\"border: 0; margin: 0 6px 0 0;\" title=\"" .$plugin_tx['fotogalerie']['icon_add_images']. "\" alt=\"" .$plugin_tx['fotogalerie']['icon_add_images']. "\" />" .$plugin_tx['fotogalerie']['icon_add_images']. "</a></p><p style=\"padding: 0 0 0 22px; margin: -4px 0 0 0;\">" .$plugin_tx['fotogalerie']['imgadd_wait']. "</p>";
			}
			
			if (sizeof($groups)>0) 
			{
				$o.='<h4><a name="table">'.$plugin_tx['fotogalerie']['headline_select_image'].'</a></h4><p><a href="' . $sn . '?&amp;' . $plugin . '&amp;admin=plugin_main&amp;action=delete_all_images&amp;gid='.$gid.'" onClick="return confirm(\'' . $plugin_tx['fotogalerie']['message_delete_all_confirm'] . '\')">'."<img src=\"$imgpath/delete.gif\" title=\"".$plugin_tx['fotogalerie']['icon_delete_all_images']."\"" . ' style="float: left; border: 0; margin: 0 6px 0 5px;"' . " alt=\"".$plugin_tx['fotogalerie']['icon_delete_all_images']."\" /> " . $plugin_tx['fotogalerie']['icon_delete_all_images'] . '</a></p>'."\n".'<table class="kg_sortable fotogalerie_edit">'."\n".'<thead>'."\n".'<tr>'."\n".'<th valign="top"'." ".'></th>
<th valign="top" style="width: 30px; font-weight: 700; text-align: right; padding-right: 10px;">'.$plugin_tx['fotogalerie']['file_id'].'</th>
<th valign="top" style="width: 40px; text-align: right; padding-right: 8px; font-weight: 700;">Nr.</th>'."\n".'<th valign="top" style="font-weight: 700;">'.$plugin_tx['fotogalerie']['description'].'<br /><img src="'.$imgpath.'/transparent.gif" style="width: 260px; height: 1px;" alt="" /></th>'."\n".'</tr>'."\n".'</thead>'."\n".'<tbody>'."\n".'';
				foreach ($files as $num => $rec) 
				{
					if ($gid==$rec[2]) 
					{
                            $desc=$rec[6];
						    $o.="\n".'<tr>
<td valign="top" style="height: 30px;">'."<a href=\"".$sn.'?'.amp().$plugin."&admin=$admin&action=delete_file&id=$rec[0]&gid=$gid#table\"" . 'onClick="return confirm(\'' . $plugin_tx['fotogalerie']['message_delete_confirm'] . '\')"' . "><img src=\"$imgpath/delete.gif\" title=\"".$plugin_tx['fotogalerie']['icon_delete_image']."\" alt=\"".$plugin_tx['fotogalerie']['icon_delete_image']."\" /></a>".'</td>' . "\n" . '<td valign="top" style="text-align: right; padding-right: 12px;">'.$rec[0].'</td>'."\n".'<td valign="top" style="text-align: right; padding-right: 12px;">'.$rec[1].'</td>'."\n" . '<td valign="top" class="description"><a class="fotogalerie_popup" href="'.$sn.'?'.amp().$plugin.'&admin=plugin_main&amp;action=edit_file&amp;id='.$rec[0].'"><img src="'.$imgpath.'/edit.gif" style="float: left; margin: 0 6px 0 -30px;" title="'.$plugin_tx['fotogalerie']['icon_edit_image'].'" alt="'.$plugin_tx['fotogalerie']['icon_edit_image'].'"> '.$desc.'<span><img src="'.$filepath.'thumbs/'.$rec[0].'t.jpg'.'" style="max-width: 120px; max-height: 120px; float: right; border: 1px solid #999; padding: 0; margin: -66px -120px -66px 0; z-index: 100;" alt="Bild" /></span></a></td>
</tr>'."\n";
					}
				}
			}
			$o.='</tbody>'."\n".'</table>';
			
			
//#####################
//     TABLE SORT
//#####################
			
function table_sort($ge_ts_presort,$ge_ts_presort_col,$ge_ts_presort_dir)
{
	global $plugin_cf, $plugin_tx, $cf, $sl, $sn, $pth;
	
	$ots= '
<script type="text/javascript" src="'.$pth['folder']['base'].'plugins/fotogalerie/js/sort_table.js"></script>
<script type="text/javascript" src="'.$pth['folder']['base'].'plugins/fotogalerie/js/ltrim.js"></script>
<script type="text/javascript">
if (!Array.prototype.forEach)
{
Array.prototype.forEach = function(fun /*, thisp*/)
{
var len = this.length >>> 0;
if (typeof fun != "function")
throw new TypeError();
var thisp = arguments[1];
for (var i = 0; i < len; i++)
{
if (i in this)
fun.call(thisp, this[i], i, this);
}
};
}

// Das Element das angezeigt wird, wenn die Spalte abwärts sortiert ist
SortTable.up = "'.tag('br').'" + String.fromCharCode(9650);
SortTable.alt_up = "' . $plugin_tx['fotogalerie']['tablesort_tooltip_sort'] . '";

// Das Element das angezeigt wird, wenn die Spalte aufwärts sortiert ist
SortTable.down = "'.tag('br').'" + String.fromCharCode(9660);
SortTable.alt_down = "' . $plugin_tx['fotogalerie']['tablesort_tooltip_sort'] . '";

// Farbe des Zeichens in der Spaltenüberschrift
SortTable.pointer_color = "' . $plugin_cf['fotogalerie']['tablesort_arrow_color'] . '";

// Die Bezeichnung der Klasse der Tabellen, die sortiert werden sollen
SortTable.className = "kg_sortable";

/*
	Zebratabelle (c) 2008 J. Strübig
	http://javascript.jstruebig.de/js/zebratabelle.html
*/

function ZebraTabelle(t) {
	var obj = t;
	var rows = [];
	var self = this;
	var hasBody = !!t.getElementsByTagName("tbody").length;
	var body = t.getElementsByTagName("tbody").length ? t.getElementsByTagName("tbody")[0] : t;
	var rows = body.getElementsByTagName("tr");

	for(var i = 1; i < rows.length; i += 2) rows[i].className += " odd";
}

ZebraTabelle.init = function() {

	// Alle Tabellen des Dokuments

	var t = document.getElementsByTagName("table");
	var r = /\bkg_zebra\b/i;

	for(var i = 0; i < t.length; i++) {
		if(t[i].className && r.test(t[i].className) ) {
			var tmp = new ZebraTabelle(t[i]);
		}
	}
};
ZebraTabelle.init();
';
	if($ge_ts_presort=='presort')
	{
		$ots.='SortTable.init().forEach(function(el) {el.sort(' . $ge_ts_presort_col . ', ' . $ge_ts_presort_dir . ');})';
	}
	else
	{
		$ots.='SortTable.init();';
	}
$ots.='
</script>
';

	return ($ots);
}

//#####################
//   END TABLE SORT
//#####################

			$o.=table_sort('presort',$plugin_cf['fotogalerie']['tablesort_presort_col'],'1');

		}
	}
	
	if ($action=='rebuild_thumbs') rebuild_thumbs($files);
	
}
?>