# osCommerce, Open Source E-Commerce Solutions
# http://www.oscommerce.com
#
# Database Backup For Sklep oscGold wersja FREE
# Copyright (c) 2009 Sklep oscGold wersja FREE
#
# Database: testowa
# Database Server: localhost
#
# Backup Date: 08/04/2009 00:20:46

SET NAMES 'utf8';

drop table if exists additional_images;
create table additional_images (
  additional_images_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  images_description varchar(64) ,
  medium_images varchar(64) ,
  popup_images varchar(64) ,
  PRIMARY KEY (additional_images_id),
  KEY products_id (products_id)
);

insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('1', '4', 'C330 1', NULL, 'aparaty_cyfrowe/g_11120547.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('2', '4', 'C330 2', NULL, 'aparaty_cyfrowe/g_11120547_001.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('43', '7', 'Eos 350 1', NULL, 'aparaty_cyfrowe/eos_350D/g_11000041_002.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('9', '1', 'A540_1', NULL, 'aparaty_cyfrowe/g_11120785_001.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('10', '1', 'A540_2', NULL, 'aparaty_cyfrowe/g_11120785_004.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('11', '1', 'A540_3', NULL, 'aparaty_cyfrowe/g_11120785_012.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('29', '12', 'DVD 505E 1', NULL, 'kamery_cyfrowe/g_13100242_002.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('30', '12', 'DVD 505E 2', NULL, 'kamery_cyfrowe/g_13100242_003.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('31', '12', 'DVD 505E 3', NULL, 'kamery_cyfrowe/g_13100242_007.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('32', '12', 'DVD 505E 4', NULL, 'kamery_cyfrowe/g_13100242_009.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('33', '12', 'DVD 505E 5', NULL, 'kamery_cyfrowe/g_13100242_010.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('34', '13', 'mv800 1', NULL, 'kamery_cyfrowe/g_13110104_001.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('35', '14', 'mvx300 1', NULL, 'kamery_cyfrowe/g_13100165_001.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('36', '14', 'mvx300 2', NULL, 'kamery_cyfrowe/g_13100165_002.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('42', '6', 'Z740', NULL, 'aparaty_cyfrowe/z740b.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('44', '7', 'Eos 350 2', NULL, 'aparaty_cyfrowe/eos_350D/g_11000041_003.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('45', '7', 'Eos 350 3', NULL, 'aparaty_cyfrowe/eos_350D/g_11000041_004.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('46', '7', 'Eos 350 4', NULL, 'aparaty_cyfrowe/eos_350D/g_11000041_008.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('47', '8', 'Eos 5D 1', NULL, 'aparaty_cyfrowe/eos_5d/g_11000066_001.jpg');
insert into additional_images (additional_images_id, products_id, images_description, medium_images, popup_images) values ('48', '8', 'Eos 5D 2', NULL, 'aparaty_cyfrowe/eos_5d/g_11000066_002.jpg');
drop table if exists address_book;
create table address_book (
  address_book_id int(11) not null auto_increment,
  customers_id int(11) not null ,
  entry_gender char(1) not null ,
  entry_company varchar(64) ,
  entry_nip varchar(32) ,
  entry_firstname varchar(32) not null ,
  entry_lastname varchar(32) not null ,
  entry_street_address varchar(64) not null ,
  entry_suburb varchar(32) ,
  entry_postcode varchar(10) not null ,
  entry_city varchar(32) not null ,
  entry_state varchar(32) ,
  entry_country_id int(11) default '0' not null ,
  entry_zone_id int(11) default '0' not null ,
  PRIMARY KEY (address_book_id, customers_id),
  KEY customers_id (customers_id)
);

insert into address_book (address_book_id, customers_id, entry_gender, entry_company, entry_nip, entry_firstname, entry_lastname, entry_street_address, entry_suburb, entry_postcode, entry_city, entry_state, entry_country_id, entry_zone_id) values ('14', '12', 'm', '', '', 'Test', 'Test', 'Testowa', NULL, '87800', 'Testowe', '', '170', '1');
drop table if exists address_format;
create table address_format (
  address_format_id int(11) not null auto_increment,
  address_format varchar(128) not null ,
  address_summary varchar(48) not null ,
  PRIMARY KEY (address_format_id)
);

insert into address_format (address_format_id, address_format, address_summary) values ('1', '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country', '$city / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('2', '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country', '$city, $state / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('3', '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('4', '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
insert into address_format (address_format_id, address_format, address_summary) values ('5', '$firstname $lastname$cr$streets$cr$postcode $city$cr$country', '$city / $country');
drop table if exists admin;
create table admin (
  admin_id int(11) not null auto_increment,
  admin_groups_id int(11) ,
  admin_firstname varchar(32) not null ,
  admin_lastname varchar(32) ,
  admin_email_address varchar(96) not null ,
  admin_password varchar(40) not null ,
  admin_created datetime ,
  admin_modified datetime not null ,
  admin_logdate datetime ,
  admin_lognum int(11) default '0' not null ,
  PRIMARY KEY (admin_id),
  UNIQUE admin_email_address (admin_email_address)
);

insert into admin (admin_id, admin_groups_id, admin_firstname, admin_lastname, admin_email_address, admin_password, admin_created, admin_modified, admin_logdate, admin_lognum) values ('1', '1', 'Admin', 'Admin', 'admin@localhost.pl', 'a465f1302fecc0a85adb443d5d20b781:c1', '2005-10-16 10:09:19', '2006-08-31 08:25:56', '2009-08-04 00:03:56', '951');
drop table if exists admin_access_files;
create table admin_access_files (
  file_access_id int(11) not null auto_increment,
  admin_files_id int(11) default '0' not null ,
  admin_id int(11) default '1' not null ,
  admin_access_values int(11) default '1' not null ,
  PRIMARY KEY (file_access_id)
);

insert into admin_access_files (file_access_id, admin_files_id, admin_id, admin_access_values) values ('1', '11', '3', '3');
drop table if exists admin_files;
create table admin_files (
  admin_files_id int(11) not null auto_increment,
  admin_files_name varchar(64) not null ,
  admin_files_is_boxes tinyint(5) default '0' not null ,
  admin_files_to_boxes int(11) default '0' not null ,
  admin_groups_id set('1','2','3','4','5') default '1' not null ,
  admin_id set('1','2','3') default '1' not null ,
  PRIMARY KEY (admin_files_id),
  KEY admin_files_is_boxes (admin_files_is_boxes),
  KEY admin_files_name (admin_files_name)
);

insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('1', 'administrator.php', '1', '0', '1', '1,3');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('11', 'admin_files.php', '0', '1', '1', '1,3');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('10', 'admin_members.php', '0', '1', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('43', 'admin_members_edit.php', '0', '1', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('123', 'all_customers.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('110', 'attributeManager.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('33', 'backup.php', '0', '9', '1,2,5', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('34', 'banner_manager.php', '0', '9', '1,2,5', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('42', 'banner_statistics.php', '0', '9', '1,2,5', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('35', 'cache.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('3', 'catalog.php', '1', '0', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('13', 'categories.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('66', 'catimagessetup.php', '0', '46', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('102', 'change_password.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('65', 'column_controller.php', '0', '52', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('47', 'configuration.php', '0', '46', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('46', 'configuration.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('22', 'countries.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('112', 'coupons.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('119', 'coupons_exclusions.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('27', 'currencies.php', '0', '7', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('5', 'customers.php', '1', '0', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('20', 'customers.php', '0', '5', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('71', 'customers_groups.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('109', 'default_tax_class.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('36', 'define_language.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('53', 'define_mainpage.php', '0', '52', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('113', 'easypopulate.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('73', 'edit_orders.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('124', 'exportorders.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('94', 'featured.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('37', 'file_manager.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('24', 'geo_zones.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('118', 'googlesitemap.php', '0', '9', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('90', 'header_tags_controller.php', '0', '89', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('89', 'header_tags_controller.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('91', 'header_tags_english.php', '0', '89', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('92', 'header_tags_fill_tags.php', '0', '89', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('52', 'information.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('28', 'languages.php', '0', '7', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('7', 'localization.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('38', 'mail.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('72', 'manudiscount.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('15', 'manufacturers.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('4', 'modules.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('19', 'modules.php', '0', '4', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('81', 'newsdesk.php', '0', '80', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('80', 'newsdesk.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('82', 'newsdesk_configuration.php', '0', '80', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('83', 'newsdesk_reviews.php', '0', '80', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('39', 'newsletters.php', '0', '9', '1,2,5', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('95', 'newsletters.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('96', 'newsletters_extra_default.php', '0', '95', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('97', 'newsletters_extra_infos.php', '0', '95', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('98', 'newsletters_subscribers_view.php', '0', '95', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('122', 'newsletters_update.php', '0', '95', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('101', 'optimize_db.php', '0', '1', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('126', 'options_images.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('21', 'orders.php', '0', '5', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('29', 'orders_status.php', '0', '7', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('127', 'oscommerce_xml.php', '0', '9', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('68', 'page_manager.php', '0', '52', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('14', 'products_attributes.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('59', 'products_availability.php', '0', '7', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('18', 'products_expected.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('111', 'products_multi.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('75', 'products_options.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('61', 'product_extra_fields.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('74', 'protection.php', '0', '9', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('99', 'quick_attributes_popup.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('100', 'quick_products_popup.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('62', 'quick_updates.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('8', 'reports.php', '1', '0', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('16', 'reviews.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('40', 'server_info.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('67', 'ship2pay.php', '0', '4', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('114', 'sitemonitor.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('115', 'sitemonitor.php', '0', '114', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('116', 'sitemonitor_admin.php', '0', '114', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('117', 'sitemonitor_configure_setup.php', '0', '114', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('17', 'specials.php', '0', '3', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('128', 'specials_enhanced.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('58', 'star_product.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('32', 'stats_customers.php', '0', '8', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('120', 'stats_discount_coupons.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('57', 'stats_low_stock.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('135', 'stats_low_stock_attrib.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('31', 'stats_products_purchased.php', '0', '8', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('30', 'stats_products_viewed.php', '0', '8', '1,2', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('133', 'stats_sales.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('56', 'stats_sales_csv.php', '0', '8', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('121', 'stock.php', '0', '3', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('6', 'taxes.php', '1', '0', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('25', 'tax_classes.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('26', 'tax_rates.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('9', 'tools.php', '1', '0', '1,2,5', '1,2');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('41', 'whos_online.php', '0', '9', '1,5', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('23', 'zones.php', '0', '6', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('136', 'batch_print.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('137', 'print_batch_invoice.php', '0', '5', '1', '1');
insert into admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id, admin_id) values ('138', 'print_batch_process.php', '0', '5', '1', '1');
drop table if exists admin_groups;
create table admin_groups (
  admin_groups_id int(11) not null auto_increment,
  admin_groups_name varchar(64) ,
  PRIMARY KEY (admin_groups_id),
  UNIQUE admin_groups_name (admin_groups_name)
);

insert into admin_groups (admin_groups_id, admin_groups_name) values ('1', 'Administrator');
insert into admin_groups (admin_groups_id, admin_groups_name) values ('2', 'Marketing');
insert into admin_groups (admin_groups_id, admin_groups_name) values ('3', 'Właściciel');
drop table if exists am_attributes_to_templates;
create table am_attributes_to_templates (
  template_id int(5) unsigned not null ,
  options_id int(5) unsigned not null ,
  option_values_id int(5) unsigned not null ,
  products_options_sort_order int(6) not null ,
  KEY template_id (template_id)
);

insert into am_attributes_to_templates (template_id, options_id, option_values_id, products_options_sort_order) values ('2', '1', '1', '0');
insert into am_attributes_to_templates (template_id, options_id, option_values_id, products_options_sort_order) values ('2', '1', '3', '1');
insert into am_attributes_to_templates (template_id, options_id, option_values_id, products_options_sort_order) values ('2', '1', '4', '2');
drop table if exists am_templates;
create table am_templates (
  template_id int(5) unsigned not null auto_increment,
  template_name varchar(255) not null ,
  PRIMARY KEY (template_id)
);

insert into am_templates (template_id, template_name) values ('1', 'test');
insert into am_templates (template_id, template_name) values ('2', 'Test');
drop table if exists anti_robotreg;
create table anti_robotreg (
  session_id char(32) not null ,
  reg_key char(10) not null ,
  timestamp int(11) unsigned not null ,
  PRIMARY KEY (session_id)
);

insert into anti_robotreg (session_id, reg_key, timestamp) values ('436522aadf973730dedf18dddde12dec', '8FYWH', '1195639685');
drop table if exists banners;
create table banners (
  banners_id int(11) not null auto_increment,
  banners_title varchar(64) not null ,
  banners_url varchar(255) not null ,
  banners_image varchar(64) not null ,
  banners_group varchar(10) not null ,
  banners_html_text text ,
  expires_impressions int(7) default '0' ,
  expires_date datetime ,
  date_scheduled datetime ,
  date_added datetime not null ,
  date_status_change datetime ,
  status int(1) default '1' not null ,
  PRIMARY KEY (banners_id),
  KEY date_scheduled (date_scheduled),
  KEY status (status)
);

drop table if exists banners_history;
create table banners_history (
  banners_history_id int(11) not null auto_increment,
  banners_id int(11) not null ,
  banners_shown int(5) default '0' not null ,
  banners_clicked int(5) default '0' not null ,
  banners_history_date datetime not null ,
  PRIMARY KEY (banners_history_id),
  KEY banners_id (banners_id)
);

drop table if exists cache;
create table cache (
  cache_id varchar(32) not null ,
  cache_language_id tinyint(1) default '0' not null ,
  cache_name varchar(255) not null ,
  cache_data mediumtext not null ,
  cache_global tinyint(1) default '1' not null ,
  cache_gzip tinyint(1) default '1' not null ,
  cache_method varchar(20) default 'RETURN' not null ,
  cache_date datetime default '0000-00-00 00:00:00' not null ,
  cache_expires datetime default '0000-00-00 00:00:00' not null ,
  PRIMARY KEY (cache_id, cache_language_id),
  KEY cache_id (cache_id),
  KEY cache_language_id (cache_language_id),
  KEY cache_global (cache_global)
);

insert into cache (cache_id, cache_language_id, cache_name, cache_data, cache_global, cache_gzip, cache_method, cache_date, cache_expires) values ('4404c1df54fdb1291c8dd9bb259f32a9', '1', 'seo_urls_v2_manufacturers', 'S0lNy8xL1VD3dfQLdXN0DgkNcg2K93P0dY03VNdRUM/OT0nMVte05krBqc4IpC45MS8/D786Y5C6/JzK3ILSYvwqTUAq8zKzCZloClJXkJiXWJyfl5mM30wzkFqgukqQMgA=', '1', '1', 'EVAL', '2009-08-04 00:14:22', '2009-09-03 00:14:22');
insert into cache (cache_id, cache_language_id, cache_name, cache_data, cache_global, cache_gzip, cache_method, cache_date, cache_expires) values ('92ad15f7ce8e6f57860eca2222c23db8', '1', 'seo_urls_v2_pages', 'S0lNy8xL1VAPcHR3DY73c/R1jTdU11FQL0pNL81JzM3MU9e05krBVGQEUpSdn1eSmF2CQ4kxSElKfnFJYnkiSAkA', '1', '1', 'EVAL', '2009-08-04 00:14:22', '2009-09-03 00:14:22');
insert into cache (cache_id, cache_language_id, cache_name, cache_data, cache_global, cache_gzip, cache_method, cache_date, cache_expires) values ('a93b9170a03ff54d81e95917742ea01b', '1', 'seo_urls_v2_categories', 'S0lNy8xL1VB3dgxxdfcPioz3c/R1jTdU11FQTyxILEosqdRNrkwryi9PVde05krBrjreCFl9dn5uQWJ2CQEtxiAtOaXFJUVViXnZmYRtMQFpyE7MTS0iwkkm8aZIylPKUnC73iTeDElpbmZeZkoZSDUA', '1', '1', 'EVAL', '2009-08-04 00:14:22', '2009-09-03 00:14:22');
insert into cache (cache_id, cache_language_id, cache_name, cache_data, cache_global, cache_gzip, cache_method, cache_date, cache_expires) values ('ca34fbe5f9a075091ad59abf02c259a7', '1', 'seo_urls_v2_products', 'fdFND4IgGMDxe5+im7XFBiJa69SqYy9rdXYktJwJTsvUT59QzeaC+2/Pw8Of8Uss+MjZH3ar0/IYbhebdYicydDJ5JPnxVXeASUedMbzAftn3Z4NoNniniXYbD1lI2wRRIlEMpqAwLc4v3NNYLkk0BupkAJgApnx4mnnzpLVRjdTTt7qNHsURoSgUiJO2q1RQ3NRA+tQpNsUsnUsylnJXEi4ebqu86OJVes+kf6BtJxaQqJ3nY+ssI3qTN+hFSaxeu0L', '1', '1', 'EVAL', '2009-08-04 00:14:22', '2009-09-03 00:14:22');
drop table if exists categories;
create table categories (
  categories_id int(11) not null auto_increment,
  categories_image varchar(120) ,
  parent_id int(11) default '0' not null ,
  sort_order int(3) ,
  date_added datetime ,
  last_modified datetime ,
  categories_status tinyint(1) unsigned default '1' not null ,
  PRIMARY KEY (categories_id, parent_id),
  KEY parent_id (parent_id),
  KEY sort_order (sort_order)
);

insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('1', 'aparaty_cyfrowe/a540.jpg', '0', '1', '2006-05-27 19:03:38', '2007-10-28 17:58:23', '1');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('2', 'aparaty_cyfrowe/c330.jpg', '1', '1', '2006-05-27 19:04:15', '2007-07-02 10:01:46', '1');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('3', 'aparaty_cyfrowe/d50.jpg', '1', '2', '2006-05-27 19:20:55', '2007-07-02 10:02:18', '1');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('4', 'kamery_cyfrowe/DVD505_cw2_IM.jpg', '0', '2', '2006-05-27 21:45:45', '2007-02-27 10:36:08', '1');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('5', 'kamery_cyfrowe/DVD505_cw2_IM.jpg', '4', '1', '2006-05-27 21:46:15', '2007-02-27 10:36:08', '1');
insert into categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, categories_status) values ('6', 'kamery_cyfrowe/mv800_big.jpg', '4', '2', '2006-05-27 21:50:10', '2007-02-27 10:36:08', '1');
drop table if exists categories_description;
create table categories_description (
  categories_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  categories_name varchar(32) not null ,
  categories_heading_title varchar(64) ,
  categories_description text ,
  categories_htc_title_tag varchar(80) ,
  categories_htc_desc_tag longtext ,
  categories_htc_keywords_tag longtext ,
  categories_htc_description longtext ,
  categories_seo_url varchar(100) not null ,
  PRIMARY KEY (categories_id, language_id),
  KEY categories_name (categories_name),
  KEY language_id (language_id)
);

insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('1', '1', 'Aparaty cyfrowe', NULL, NULL, 'Aparaty cyfrowe', 'Aparaty cyfrowe', 'Aparaty, cyfrowe, cyfrówki', 'Aparaty cyfrowe stają się coraz bardziej popularne i powszechne. Główną zaletą fotografii cyfrowej jest możliwość robienia dużo większej ilości zdjęć niż w przypadku fotografii tradycyjnej. Nie trzeba już liczyć się z kosztami wywołania tradycyjnego filmu i nikogo nie dziwi rodzina wracająca z wakacji z wykonanym tysiącem zdjęć. Jedynym co nas ogranicza to wielkość posiadanych kart pamięci.', '');
insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('2', '1', 'Aparaty kompaktowe', NULL, NULL, 'Aparaty kompaktowe', 'Aparaty kompaktowe', 'Aparaty kompaktowe', '<strong>Tradycyjny kompakt</strong> to typowy aparat fotograficzny. Jest on wystarczająco duży aby zapewnić pewne trzymanie, a nie zajmuje tyle miejsca co lustrzanka. Zdjęcie może być zrobione z ustawieniami ręcznymi, ale równie dobrze można pozostawić wszystko automatowi. Takiego aparatu szuka większość użytkowników, są one najbardziej uniwersalne.', '');
insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('3', '1', 'Lustrzanki cyfrowe', NULL, NULL, 'Lustrzanki cyfrowe', 'Lustrzanki cyfrowe', 'Lustrzanki cyfrowe', '<strong>Lustrzanki</strong> to najbardziej zaawansowane modele. Mają one profesjonalny, masywny wygląd i są skierowane do najbardziej wymagających użytkowników. Pozwalają na robienie zdjęć o bardzo wysokiej jakości oraz posiadają dużą ilość opcji konfiguracyjnych. Kupując lustrzankę musimy dobrać odpowiedni obiektyw lub kilka obiektywów do naszych potrzeb.', '');
insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('4', '1', 'Kamery cyfrowe', NULL, NULL, 'Kamery cyfrowe', 'Kamery cyfrowe', 'Kamery cyfrowe', '', '');
insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('5', '1', 'Kamery DVD', NULL, NULL, 'Kamery DVD', 'Kamery DVD', 'Kamery DVD', 'Nagrywasz - wyjmujesz - 
oglądasz. Dzięki kamerom 
DVD Handycam od razu 
możesz oglądać swoje 
nagrania w odtwarzaczu DVD.', '');
insert into categories_description (categories_id, language_id, categories_name, categories_heading_title, categories_description, categories_htc_title_tag, categories_htc_desc_tag, categories_htc_keywords_tag, categories_htc_description, categories_seo_url) values ('6', '1', 'Kamery miniDV', NULL, NULL, 'Kamery miniDV', 'Kamery miniDV', 'Kamery miniDV', '', '');
drop table if exists compare_basket;
create table compare_basket (
  compare_basket_id int(11) not null auto_increment,
  customers_id int(11) not null ,
  products_id tinytext not null ,
  compare_basket_quantity int(2) not null ,
  final_price decimal(15,4) not null ,
  compare_basket_date_added char(8) ,
  PRIMARY KEY (compare_basket_id),
  KEY customers_id (customers_id)
);

drop table if exists configuration;
create table configuration (
  configuration_id int(11) not null auto_increment,
  configuration_title varchar(64) not null ,
  configuration_key varchar(64) not null ,
  configuration_value varchar(255) not null ,
  configuration_description varchar(255) not null ,
  configuration_group_id int(11) not null ,
  sort_order int(5) ,
  last_modified datetime ,
  date_added datetime not null ,
  use_function varchar(255) ,
  set_function varchar(255) ,
  PRIMARY KEY (configuration_id),
  KEY configuration_key (configuration_key),
  KEY configuration_value (configuration_value),
  KEY sort_order (sort_order),
  KEY date_added (date_added)
);

insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1', 'Nazwa sklepu', 'STORE_NAME', 'Sklep oscGold wersja FREE', 'Nazwa sklepu', '1', '1', '2009-07-29 22:28:59', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('2', 'Właściciel sklepu', 'STORE_OWNER', 'Sklep oscGold wersja FREE', 'Nazwisko właściciela sklepu', '1', '2', '2009-07-29 22:29:09', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3', 'Adres e-mail', 'STORE_OWNER_EMAIL_ADDRESS', 'email@demo.pl', 'Adres e-mail właściciela sklepu', '1', '5', '2009-07-29 22:28:30', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('4', 'Adres wychodących e-maili', 'EMAIL_FROM', 'email@demo.pl', 'Adres e-mail dla poczty wysyłanej przez sklep', '1', '6', '2009-07-29 22:28:35', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('5', 'Kraj', 'STORE_COUNTRY', '170', 'Kraj, w którym znajduje się sklep <br><br><b>Uwaga: Trzeba pamiętać o uktualnieniu strefy sklepu.</b>', '1', '8', '2006-08-11 14:44:00', '2003-07-29 13:05:38', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('6', 'Strefa', 'STORE_ZONE', '2', 'Strefa, w której znajduje się sklep', '1', '9', '2005-11-13 07:20:03', '2003-07-29 13:05:38', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('7', 'Porządek sortowania oczekiwanych', 'EXPECTED_PRODUCTS_SORT', 'desc', 'Sposób sortowania produktów oczekiwanych.', '101', '0', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'asc\', \'desc\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('8', 'Pola sortowania oczekiwanych', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'Pole wyznaczające porządek sortowania produktów oczekiwanych.', '101', '0', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'products_name\', \'date_expected\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('9', 'Przełączenie na walutę danego języka', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Automatyczne przełączanie na domyślną walutę wybranego języka przy jego zmiane.', '101', '0', '2006-08-07 22:26:07', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('10', 'Wyślij dodatkowe e-mail z zamówieniami', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Wysłanie dodatkowym e-maili z zamówieniami na adres o następujących formacie: Nazwa1 &lt;email@adres1&gt;, Nazwa2 &lt;email@adres2&gt;', '1', '7', '2006-10-21 11:13:35', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('12', 'Wyświetl koszyk po dodaniu produktu', 'DISPLAY_CART', 'false', 'Wyświetlanie koszyka po dodaniu do niego produktu (lub powrót do wybieranego produktu).', '101', '0', '2006-12-17 23:15:11', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('13', 'Pozwól gościowi powiadomić znajomego', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'true', 'Umożliwienie gościowi powiadomienia znajomego o produkcie.', '101', '0', '2005-11-13 22:02:02', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('14', 'Domyślny operator logiczny wyszukiwania', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Domyślny operator logiczny wyszukiwania słów kluczowych.', '101', '0', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'and\', \'or\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('15', 'Adres i telefon sklepu', 'STORE_NAME_ADDRESS', 'Ulica 
Miejscowość 
Telefon', 'Nazwa, adres i telefon do sklepu, używane na wyświetlanych i drukowanych dokumentach', '1', '3', '2007-10-22 14:08:40', '2003-07-29 13:05:38', NULL, 'tep_cfg_textarea(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('16', 'Pokaż ilość produktów w kategorii', 'SHOW_COUNTS', 'false', 'Rekurencyjne obliczanie liczby produktów w każdej kategorii.', '101', '2', '2006-06-22 23:02:45', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('17', 'Licza miejsc dziesiętnych podatku', 'TAX_DECIMAL_PLACES', '2', 'Uzupełnienie wartości podatku do określonej liczby miejsc dziesiętnych.', '101', '3', '2006-04-05 09:15:16', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('18', 'Wyświetlaj ceny z podatkiem', 'DISPLAY_PRICE_WITH_TAX', 'true', 'Wyświetlanie cen z podatkiem (true) lub dodanie podatku na końcu (false).', '101', '4', '2006-08-11 14:42:27', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('19', 'Imię', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', 'Minimalna długość imienia.', '2', '1', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('20', 'Nazwisko', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'Minimalna długość nazwiska.', '2', '2', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('21', 'Data urodzenia', 'ENTRY_DOB_MIN_LENGTH', '10', 'Minimalna długość daty urodzenia.', '2', '3', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('22', 'Adres e-mail', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Minimalna długość adresu e-mail.', '2', '4', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('23', 'Nazwa ulicy', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'Minimalna długość nazwy ulicy.', '2', '5', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('24', 'Firma', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'Minimalna długość nazwy firmy.', '2', '6', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('25', 'Kod pocztowy', 'ENTRY_POSTCODE_MIN_LENGTH', '5', 'Minimalna długość kodu pocztowego.', '2', '8', '2005-10-18 13:54:43', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('26', 'Miasto', 'ENTRY_CITY_MIN_LENGTH', '3', 'Minimalna długość nazwy miasta.', '2', '9', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('27', 'Województwo', 'ENTRY_STATE_MIN_LENGTH', '2', 'Minimalna długość nazwy województwa/stanu.', '2', '10', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('28', 'Numer telefonu', 'ENTRY_TELEPHONE_MIN_LENGTH', '3', 'Minimalna długość numeru telefonu.', '2', '11', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('29', 'Hasło', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'Minimalna długość hasła.', '2', '12', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('30', 'Nazwisko właściciela karty kredytowej', 'CC_OWNER_MIN_LENGTH', '3', 'Minimalna długość nazwiska właściciela karty kredytowej.', '2', '13', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('31', 'Numer karty kredytowej', 'CC_NUMBER_MIN_LENGTH', '10', 'Minimalna długość numeru karty kredytowej.', '2', '14', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('32', 'Recenzja', 'REVIEW_TEXT_MIN_LENGTH', '50', 'Minimalna długość recenzji produktu.', '2', '15', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('33', 'Bestsellery', 'MIN_DISPLAY_BESTSELLERS', '1', 'Minimalna liczby wyświetlanych bestsellerów.', '2', '16', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('34', 'Także kupiono', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'Minimalna liczba produktów do wyświetlenia w okienku \'Klient kupił także\'', '2', '17', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('35', 'Pozycje książki adresowej', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Maksymalna liczby pozycji książki adresowej klienta.', '3', '1', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('36', 'Wyniki wyszukiwania', 'MAX_DISPLAY_SEARCH_RESULTS', '10', 'Liczba produktów na liście wyników wyszukiwania.', '3', '2', '2007-02-26 11:36:02', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('37', 'Łącza', 'MAX_DISPLAY_PAGE_LINKS', '5', 'Liczbą łączy z numerami dla list podzielonych na strony.', '3', '3', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('38', 'Produkty w promocji', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '20', 'Maksymalna liczby wyświetlanych produktów w promocji.', '3', '5', '2006-08-07 20:35:43', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('39', 'Nowe produkty', 'MAX_DISPLAY_NEW_PRODUCTS', '4', 'Maksymalna liczba wyświetlanych nowych produktów w module na stronie głównej.', '3', '6', '2007-05-29 12:20:14', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('40', 'Produkty oczekiwane', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '2', 'Maksymalna liczba wyświetlanych produktów oczekiwanych.', '3', '7', '2007-05-29 12:20:23', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('41', 'Lista producentów', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'Używane w okienku producentówx; gdy liczba producentów przekracza ten próg, wyświetlone zostanie rozwijane menu zamiast listy.', '3', '8', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('42', 'Rozmiar pola wyboru producenta', 'MAX_MANUFACTURERS_LIST', '1', 'Używane w okienku producentówx; gdy wartość ta wynosi \'1\', wyświetlane jest zwykłe menu rozwijane. W przeciwnym wypadku wyświetlana jest lista o podanej liczbie wierszy.', '3', '9', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('43', 'Długość nazwy producenta', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'Używane w okienku producentów; maksymalna długość wyświetlanej nazwy producenta.', '3', '10', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('44', 'Nowe recenzje', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Maksymalna liczby wyświetlanych nowych recenzji.', '3', '11', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('45', 'Wybór losowych recenzji', 'MAX_RANDOM_SELECT_REVIEWS', '10', 'Z ilu rekordów wybierać jedną losową recenzję produktu.', '3', '12', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('46', 'Wybór losowych nowych produktów', 'MAX_RANDOM_SELECT_NEW', '10', 'Z ilu rekordów wybierać jeden losowy nowy produkt.', '3', '13', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('47', 'Wybór losowych produktów w promocji', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'Z ilu rekordów wybierać jeden losowy produkt w promocji.', '3', '14', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('48', 'Ilość kolumn kategorii w wierszu', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'Maskymalna liczba wyświetlanych kolumn w module kategorie na stronie głównej', '8', '20', '2006-08-07 18:30:06', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('49', 'Wyświetlanie nowych produktów', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'Maksymalna liczba nowych produktów wyświetlanych na stronie prezentującej nowe produkty.', '3', '15', '2006-06-24 16:35:33', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('50', 'Bestsellery', 'MAX_DISPLAY_BESTSELLERS', '10', 'Maksymalna liczba wyświetlanych bestsellerów.', '3', '16', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('51', 'Także kupiono', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'Maksymalna liczba produktów wyświetlanych w okienku \'Klienci, którzy kupili ten produkt ....\'.', '3', '17', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('52', 'Okienko historii zamówień', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'Maksymalna liczba produktów wyświetlanych okienku historii zamówień.', '3', '18', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('53', 'Historia zamówień', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Maksymalna liczba zamówień wyświetalana na stronie historii zamówień.', '3', '19', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('54', 'Szerokość małego obrazka', 'SMALL_IMAGE_WIDTH', '100', 'Szerokość (w pikselach) małych obrazków', '4', '1', '2005-12-20 22:40:07', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('55', 'Wysokość małego obrazka', 'SMALL_IMAGE_HEIGHT', '80', 'Wysokość (w pikselach) małych obrazków', '4', '2', '2005-12-20 21:51:40', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('56', 'Szerokość obrazka w nagłówku', 'HEADING_IMAGE_WIDTH', '80', 'Szerokość (w pikselach) obrazków nagłówkowych', '4', '3', '2006-02-05 12:41:05', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('57', 'Wysokość obrazka w nagłówku', 'HEADING_IMAGE_HEIGHT', '80', 'Wysokość (w pikselach) obrazków nagłowkowych', '4', '4', '2006-02-05 12:41:11', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('58', 'Szerokość obrazka podkategorii', 'SUBCATEGORY_IMAGE_WIDTH', '80', 'Szerokość (w pikselach) obrazków podkategorii', '4', '5', '2007-02-08 14:47:04', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('59', 'Wysokość obrazka podkategorii', 'SUBCATEGORY_IMAGE_HEIGHT', '80', 'Wysokość (w pikselach) obrazków podkategorii', '4', '6', '2007-02-08 14:47:10', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('60', 'Obliczanie rozmiaru obrazków', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'Czy obliczać rozmiar obrazków?', '4', '13', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('61', 'Wymagane obrazki', 'IMAGE_REQUIRED', 'false', 'Włączenie powoduje próbę wyświetlenia także nieistniejących obrazków. Przydatne przy konfigurowaniu sklepu.', '4', '14', '2005-10-02 15:14:31', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('62', 'Płeć', 'ACCOUNT_GENDER', 'false', 'Czy wyświetlać płeć na koncie klienta?', '5', '1', '2007-04-26 11:00:30', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('63', 'Data urodzenia', 'ACCOUNT_DOB', 'false', 'Czy wyświetlać datę urodzenia na koncie klienta?', '5', '2', '2005-10-16 09:30:03', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('64', 'Firma', 'ACCOUNT_COMPANY', 'true', 'Czy wyświetlać firmę na koncie klienta?', '5', '3', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('65', 'Dzielnica', 'ACCOUNT_SUBURB', 'false', 'Czy wyświetlać dzielnicę na koncie klienta?', '5', '4', '2005-10-16 09:29:48', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('66', 'Stan/województwo', 'ACCOUNT_STATE', 'true', 'Czy wyświetlać stan/województwo na koncie klienta?', '5', '6', '2006-08-11 14:33:57', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('67', 'Zainstalowane moduły', 'MODULE_PAYMENT_INSTALLED', 'pobraniepocztapolska.php;plbanktransfer.php;gotowkaprzyodbiorzeosobistym.php', 'Lista nazw plików modułów płacenia, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.', '6', '0', '2009-07-29 22:31:34', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('68', 'Zainstalowane moduły', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_discount_coupon.php;ot_subtotal.php;ot_tax.php;ot_giftwrap.php;ot_shipping.php;ot_total.php', 'Lista nazw plików modułów order_total, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.', '6', '0', '2007-09-11 11:01:19', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('69', 'Zainstalowane moduły', 'MODULE_SHIPPING_INSTALLED', 'pocztapripobraniowa.php;pocztapriorytetowa.php;kosztsprzedawcy.php;odbiorosobisty.php', 'Lista nazw plików modułów przesyłek, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.', '6', '0', '2007-07-13 13:04:55', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('84', 'Domyślna waluta', 'DEFAULT_CURRENCY', 'PLN', 'Domyślna waluta', '6', '0', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('85', 'Domyślny język', 'DEFAULT_LANGUAGE', 'pl', 'Domyślny język', '6', '0', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('86', 'Domyślny status nowego zamówienia', 'DEFAULT_ORDERS_STATUS_ID', '1', 'Nowo utworzonemu zamówieniu zostanie przypisany ten status.', '6', '0', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('98', 'Kraj pochodzenia', 'SHIPPING_ORIGIN_COUNTRY', '170', 'Wprowadź kod kraju w którym znajduje się sklep (używane przy wysyłkach).', '7', '1', '2005-10-16 09:31:08', '2003-07-29 13:05:38', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('99', 'Kod pocztowy', 'SHIPPING_ORIGIN_ZIP', 'NONE', 'Wprowadź kod pocztowy (ZIP) sklepu, używany przy wysyłkach.', '7', '2', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('100', 'Maksymalna ciężar wysyłanej paczki', 'SHIPPING_MAX_WEIGHT', '50', 'Wspólny maksymalny ciężar wysyłanej paczki.', '7', '3', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('101', 'Waga opakowania', 'SHIPPING_BOX_WEIGHT', '0.5', 'Wprowadź masę typowego opakowania małej do średniej paczki.', '7', '4', '2005-10-22 09:14:07', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('102', 'Procentowe zwiększenie dla dużych pakietów', 'SHIPPING_BOX_PADDING', '10', 'Chcąc wpisać 10% wpisz 10', '7', '5', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('103', 'Wyświetlaj obrazek produktu', 'PRODUCT_LIST_IMAGE', '1', 'Czy wyświetlać obrazek produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '1', '2006-01-01 19:36:44', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('104', 'Wyświetlaj nazwę producenta', 'PRODUCT_LIST_MANUFACTURER', '0', 'Czy wyświetlać nazwę producenta?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '2', '2006-06-24 10:56:59', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('105', 'Wyświetlaj model produktu', 'PRODUCT_LIST_MODEL', '0', 'Czy wyświetlać model produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '3', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('106', 'Wyświetlaj nazwę produktu', 'PRODUCT_LIST_NAME', '2', 'Czy wyświetlać nazwę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '4', '2005-10-30 23:33:00', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('107', 'Wyświetlaj cenę produktu', 'PRODUCT_LIST_PRICE', '4', 'Czy wyświetlać cenę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '5', '2007-02-27 11:41:54', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('108', 'Wyświetlaj liczbę produktów', 'PRODUCT_LIST_QUANTITY', '0', 'Czy wyświetlać ilość produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '7', '2006-03-09 11:16:46', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('109', 'Wyświetlaj wagę produktu', 'PRODUCT_LIST_WEIGHT', '0', 'Czy wyświetlać masę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '8', '2005-10-30 21:17:04', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('110', 'Wyświetlaj kolumnę Kup Teraz', 'PRODUCT_LIST_BUY_NOW', '6', 'Czy wyświetlać kolumnę Kup Teraz?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '10', '2005-12-12 21:43:15', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('111', 'Wyświetlaj filtr kategorii/producenta', 'PRODUCT_LIST_FILTER', '1', 'Czy wyświetlać filtr kategorii/producentów na stronie z listowanymi towarami? (0=nie; 1=tak)?', '8', '15', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('112', 'Położenia paska nawigacja Poprzedni/Następny', 'PREV_NEXT_BAR_LOCATION', '3', 'Położenie paska nawigacji Poprzedni/Następny (1-góra, 2-dół, 3-góra i dół).', '8', '16', '2006-06-23 22:59:37', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('113', 'Sprawdzanie zasobów magazynu', 'STOCK_CHECK', 'true', 'Czy sprawdzać ilość produktów w magazynie (na stanie)?', '9', '1', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('114', 'Pomniejszanie stanu w magazynie', 'STOCK_LIMITED', 'true', 'Czy po zamówieniu odejmować liczbę produktów ze stanu?', '9', '2', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('115', 'Pozwól na zamówienie mimo braków', 'STOCK_ALLOW_CHECKOUT', 'false', 'Pozwól klientowi zamówić nawet wtedy, jeżeli produktów nie ma na stanie', '9', '3', '2006-06-24 22:31:55', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('116', 'Oznacz produkty niedostępne', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '*Aktualnie Brak*', 'Oznaczenie produktów, których nie ma w wystarczającej ilości.', '9', '4', '2005-11-05 16:30:26', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('117', 'Poziom konieczności uzupełnienia magazynu', 'STOCK_REORDER_LEVEL', '5', 'Kiedy należy uzupełnić magazyn?', '9', '5', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('118', 'Zapisywanie czasu przetworzenia strony', 'STORE_PAGE_PARSE_TIME', 'false', 'Zachowaj czas przetwarzania stron.', '10', '1', '2007-08-24 22:14:36', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('119', 'Cel logowania', 'STORE_PAGE_PARSE_TIME_LOG', 'tmp/page_parse_time.log', 'Katalog i nazwa pliku z czasem przetwarzania stron.', '10', '2', '2007-02-28 11:54:24', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('120', 'Format daty logu', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'Format daty.', '10', '3', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('121', 'Wyświetlanie czasu przetwarzania strony', 'DISPLAY_PAGE_PARSE_TIME', 'false', 'Wyświelaj czas przetworzenia strony (zapisywanie czasu przetworzenia strony musi być włączone)', '10', '4', '2007-08-29 09:29:33', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('122', 'Zapisywanie zapytań SQL', 'STORE_DB_TRANSACTIONS', 'false', 'Zapisz zapytania SQL w pliku z czasami przetwarzania stron (tylko PHP4)', '10', '5', '2007-08-24 21:52:02', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('123', 'Używaj pamięci podręcznej do boxów', 'USE_CACHE', 'false', 'Czy używać pamięci podręcznej dla przetrzymywania boxów ?', '26229', '7', '2007-08-24 22:21:44', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('124', 'Katalog pamięci podręcznej', 'DIR_FS_CACHE', 'tmp/cache/', 'Katalog, w którym mają być przechowywane pliki podręczne.', '26229', '8', '2007-08-24 21:14:28', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('125', 'Sposób wysyłania e-maili', 'EMAIL_TRANSPORT', 'sendmail', 'Czy serwer używa lokalnego programu sendmail, czy połączenia SMTP. Użytkownicy serwerów Windows i MacOS powinni zmienić to ustawienie na SMTP.', '12', '1', '2007-04-19 11:34:53', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('126', 'Końce linii w e-mailu', 'EMAIL_LINEFEED', 'LF', 'Sekwencja znaków używana do oddzielania nagłówków poczty.', '12', '2', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'LF\', \'CRLF\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('127', 'Używaj MIME HTML przy wysyłaniu e-maili', 'EMAIL_USE_HTML', 'false', 'Czy wysyłać pocztę w formacie HTML?', '12', '3', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('128', 'Weryfikuj adresy e-mail przez DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Czy sprawdzać adresy e-mail za pośrednictwem serwera DNS', '12', '4', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('129', 'Wysyłaj e-maile', 'SEND_EMAILS', 'true', 'Czy wysyłać e-maile?', '12', '5', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('130', 'Włącz pobieranie', 'DOWNLOAD_ENABLED', 'false', 'Czy umożliwić pobieranie produktów?', '13', '1', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('131', 'Pobieranie poprzez przekierowanie', 'DOWNLOAD_BY_REDIRECT', 'false', 'Czy używać przekierowania do pobierania. Należy to wyłączyć w serwerach nie Uniksowych.', '13', '2', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('132', 'Czas wygaśnięcia (dni)', 'DOWNLOAD_MAX_DAYS', '7', 'Liczba dni, po której wygasa łącze do ściągnięcia pliku. 0 oznacza brak ograniczeń.', '13', '3', NULL, '2003-07-29 13:05:38', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('133', 'Maksymalna liczba pobrań', 'DOWNLOAD_MAX_COUNT', '5', 'Ustaw maksymalną liczbę pobrań. 0 oznacza brak dozwolonych pobrań.', '13', '4', NULL, '2003-07-29 13:05:38', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('134', 'Włącz kompresję GZip', 'GZIP_COMPRESSION', 'false', 'Włącz kompresję HTTP GZip.', '14', '1', '2006-09-21 19:17:11', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('135', 'Poziom kompresji', 'GZIP_LEVEL', '5', 'Ustaw poziom kompresji 0-9 (0 = minimum, 9 = maksimum).', '14', '2', NULL, '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('136', 'Katalog sesji', 'SESSION_WRITE_DIRECTORY', 'tmp', 'Jeżeli sesja wykorzystuje pliki, w tym katalogu będą one przechowywane.', '15', '1', '2007-04-26 13:53:12', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('137', 'Wymuszaj użycie ciasteczek', 'SESSION_FORCE_COOKIE_USE', 'True', 'Włącz użycie sesji, jeżeli ciasteczka są włączone.', '15', '2', '2007-07-31 19:55:04', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('138', 'Sprawdź ID sesji SSL', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Sprawdź SSL_SESSION_ID przy każdym pobieraniu strony przez HTTPS.', '15', '3', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('139', 'Sprawdź rodzaj przeglądarki', 'SESSION_CHECK_USER_AGENT', 'False', 'Sprawdź rodzaj przeglądarki klienta przy kazdym pobieraniu strony.', '15', '4', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('140', 'Sprawdź adres IP', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Sprawdź adres IP klienta przy każdym pobieraniu strony.', '15', '5', NULL, '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('141', 'Zabroń robotom dostępu', 'SESSION_BLOCK_SPIDERS', 'True', 'Zabronienie znanym robotom rozpoczęcia sesji.', '15', '6', '2007-07-31 19:55:11', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('142', 'Ponowne utworzenie sesji', 'SESSION_RECREATE', 'False', 'Ponowne utworzenie sesji i nowego identyfikatora przy logowaniu klienta lub tworzeniu konta (wymagane PHP >=4.1).', '15', '7', '2006-03-20 23:21:00', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('153', 'Domyślny szablon sklepu', 'DIR_WS_TEMPLATES_DEFAULT', 'standard', 'Katalog (w templates/) gdzie znajdują się pliki szablonu sklepu', '99', '18', '2007-05-04 08:51:00', '2005-10-09 11:58:50', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('154', 'Zmiana szablonów', 'TEMPLATE_SWITCHING_ALLOWED', 'false', 'Czy zezwalać użytkonikom na przełączanie szablonów sklepu ?', '99', '19', '2007-09-19 09:40:43', '2005-10-09 11:58:50', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('155', 'Menu szablonów', 'TEMPLATE_SWITCHING_MENU', 'false', 'Czy pokazywać menu przełączania szablonów (głównie używane do testowania nowych szablonów, wymaga włączenia możliwości zmiany szablonów).', '99', '20', '2005-12-06 22:21:25', '2005-10-09 11:58:50', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('164', 'Numer NIP', 'ACCOUNT_NIP', 'true', 'Wyświetlaj pole NIP w danych użytkownika', '5', '5', NULL, '2003-12-02 10:34:04', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('165', 'Numer NIP', 'ENTRY_NIP_MIN_LENGTH', '10', 'Minimalna długość pola NIP', '2', '7', '2005-12-26 22:20:43', '2003-12-02 10:34:04', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('182', 'Box Waluty', 'BOX_CURRENCIES_IS_ON', 'true', 'Czy wyświetlać box Waluty ?', '400', '34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('183', 'W której kolumnie box Waluty ?', 'BOX_CURRENCIES_COLUMN', 'left', 'W której kolumnie wyświetlać box Waluty ?', '400', '35', '2006-09-12 14:39:21', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('184', 'Box Banner Prawy', 'BOX_BANNER_RIGHT_IS_ON', 'false', 'Czy wyświetlać box Banner Prawy?', '400', '36', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('185', 'Kategoria bannerów', 'BANNER_RIGHT_GROUP_IS', '100X100', 'Którą grupę bannerów wyświetlać w boxie Banner Prawy?', '400', '37', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('186', 'W której kolumnie box Banner Prawy ?', 'BOX_BANNER_RIGHT_COLUMN', 'right', 'W której kolumnie wyświetlać box Banner Prawy?', '400', '38', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('187', 'Box Kontakt', 'KONTAKT_IS_ON', 'true', 'Czy wyświetlać box Kontakt ?', '400', '39', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('188', 'W której kolumnie box Kontakt ?', 'BOX_KONTAKT_COLUMN', 'left', 'W której kolumnie wyświetlać box Kontakt ?', '400', '40', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('189', 'Box Ostatnio Publikowane Aktualności', 'BOX_NEWSDESK_LATEST_IS_ON', 'true', 'Czy wyświetlać box Ostatnio Publikowane Aktualności ?', '400', '41', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('190', 'W której kolumnie box Ostatnio Publikowane Aktualności ?', 'BOX_NEWSDESK_LATEST_COLUMN', 'left', 'W której kolumnie wyświetlać box Ostatnio Publikowane Aktualności ?', '400', '42', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('191', 'Box Kategorie Aktualności', 'BOX_NEWSDESK_CATEGORIES_IS_ON', 'false', 'Czy pokazywać box Kategorie Aktualności ?', '400', '42', '2006-02-21 10:36:42', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('192', 'W której kolumnie box Kategorie Aktualności ?', 'BOX_NEWSDESK_CATEGORIES_COLUMN', 'left', 'W której kolumnie wyświetlać box Kategorie Aktualności ?', '400', '44', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('200', 'Centrowanie sklepu', 'CENTER_SHOP_ON', 'on', 'Centrowanie sklepu Włącz/Wyłącz', '99', '1', '2004-02-25 14:34:58', '2004-02-25 14:34:58', NULL, 'tep_cfg_select_option(array(\'on\', \'off\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('201', 'Szerokość sklepu', 'CENTER_SHOP_WIDTH', '880', 'Podaj w pixelach (np. 760) lub w procentach (np. 100%) jaką szerokość mają mieć strony WWW sklepu.', '99', '2', '2006-09-12 14:36:05', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('202', 'Odstęp od krawędzi', 'CENTER_SHOP_PADDING', '0', 'Odstęp sklepu od krawędzi przeglądarki', '99', '9', '2006-08-07 19:08:21', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('203', 'Kolor tła', 'CENTER_SHOP_BACKGROUND_COLOR_OUT', 'FFFFFF', 'Kolor tła na zewnątrz sklepu', '99', '10', '2007-07-13 12:56:56', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('204', 'Grubość ramki', 'CENTER_SHOP_BORDER', '0', 'Grubość obramowania sklepu', '99', '11', '2005-11-30 22:52:48', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('205', 'Kolor ramki', 'CENTER_SHOP_BORDERCOLOR', 'b6b7cb', 'Kolor obranowania sklepu', '99', '12', '2005-11-28 13:42:05', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('206', 'Odstęp modułów', 'CENTER_SHOP_CELLSPACING', '0', 'Odstęp pomiędzy komórkami modułów sklepu', '99', '13', '2004-02-25 14:34:58', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('207', 'Odstęp tekstu', 'CENTER_SHOP_CELLPADDING', '0', 'Odstęp tekstu wewnątrz modułów', '99', '14', '2007-07-02 10:32:15', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('208', 'Kolor tła włączony/wyłączony', 'CENTER_SHOP_BACKGROUND_ON', 'on', 'Czy używać kolorów tła ?', '99', '15', '2004-02-25 14:34:58', '2004-02-25 14:34:58', NULL, 'tep_cfg_select_option(array(\'on\', \'off\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('209', 'Kolor pomiędzy obramowaniem', 'CENTER_SHOP_BACKGROUND_COLOR', 'FFFFFF', 'Kolor pomiędzy oobramowaniem i zawartością sklepu', '99', '16', '2006-08-08 13:30:06', '2004-02-25 14:34:58', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('230', 'Kontakt e-mail', 'KONTAKT_EMAIL_1', 'email@demo.pl', 'Adres email prezentowany w boxie :Kontakt:', '1', '11', '2007-07-02 10:29:43', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('231', 'Box Kategorie w bocznej kolumnie', 'DISPLAY_DHTML_MENU', 'Default', 'Wybierz jak ma być wyświetlany box zawierający kategorie produktów', '99', '21', '2007-04-23 09:35:39', '2003-03-07 20:37:02', NULL, 'tep_cfg_select_option(array(\'Default\', \'XC\',\'jscMenu\',\'Full\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('232', 'Kontakt telefon', 'KONTAKT_TELEFON_1', 'xxx xxx xxx', 'Numer telefonu prezentowany w boxie :Kontakt:', '1', '13', '2006-08-31 08:27:08', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('233', 'Kontakt GSM', 'KONTAKT_GSM_1', 'yyy yyy yyy', 'Numer telefonu komórkowego prezentowany w boxie :Kontakt:', '1', '14', '2007-07-02 10:29:28', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('234', 'Kontakt nr GG', 'KONTAKT_NR_GG_1', '', 'Numer GG prezentowany w boxie :Kontakt:', '1', '15', '2006-03-21 13:47:13', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('235', 'Kontakt nr Tlen', 'KONTAKT_NR_TLEN_1', '', 'Login TLEN prezentowany w boxie :Kontakt:', '1', '16', '2006-01-05 22:20:51', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('236', 'Kontakt nr WP', 'KONTAKT_NR_WP_1', '', 'Login WP prezentowany w boxie :Kontakt:', '1', '17', '2005-04-02 07:07:39', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('241', 'Kontakt nr SKYPE', 'KONTAKT_SKYPE_1', '', 'Login SKYPE prezentowany w boxie :Kontakt:', '1', '18', '2006-08-31 08:26:12', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('242', 'Kontakt godziny działania', 'KONTAKT_GODZINY_1', '', 'Godziny otwarcia/działania prezentowane w boxie :Kontakt:', '1', '19', '2006-08-31 08:26:16', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('243', 'Kontakt fax', 'KONTAKT_FAX_1', '', 'Numer FAXu prezentowany w boxie :Kontakt:', '1', '12', '2006-01-05 22:28:22', '2005-04-02 07:07:39', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('251', 'Ilość kolumn w module Nowe produkty', 'MAX_DISPLAY_COLUMN_NEW_PRODUCTS', '2', 'Wprowadź liczbę kolumn w module nowych produktów.', '8', '22', '2006-06-22 14:12:05', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('252', 'Moduł Aktualności na stronie głównej', 'SHOW_NEWSDESK', 'true', 'Czy pokazywać moduł Aktualności na stronie głównej ?', '99', '25', '2006-03-06 21:48:37', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('255', 'Moduł kontroli zawartości Meta Tagów', 'ALLOW_HEADER_TAGS_CONTROLLER', 'true', 'Moduł umozliwiający samodzielne zdefiniowanie znaczników meta (tytuł, opis, słowa kluczowe) dla poszczególnych stron sklepu lub poszczególnych produktów. Jeżeli moduł jest wyłączony Meta Tagi są generowane automatycznie na podstawie zawartoś', '101', '7', '2007-03-24 09:11:53', '2005-12-04 08:21:31', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('256', 'Moduł Kategorie na stronie głównej', 'SHOW_MAINCATEGORIES', 'false', 'Czy pokazywać moduł Główne Kategorie na stronie głównej ?', '99', '26', '2006-08-07 18:29:00', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('257', 'Discount Percentage', 'MODULE_FIXED_PAYMENT_CHG_AMOUNT', '2', 'Amount of Discount.', '6', '7', NULL, '2005-10-18 13:59:28', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('258', 'Ilość kolumn w listingu produktów', 'MAX_DISPLAY_COLUMN_PRODUCTS_LISTING', '2', 'Wprowadź liczbę kolumn w listingu produktów.', '8', '21', '2006-06-24 11:54:26', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('259', 'Listing produktów: sposób wyświetlania', 'PRODUCTS_LISTING_DISPLAY_MODE', 'true', 'Format wyświetlania listy produktów:<br>true=każdy produkt w jednym wierszu<br>false=tabela wiersze x kolumny', '8', '18', '2007-05-29 14:18:16', '2005-12-14 21:42:36', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('260', 'Czas wyświetlania Nowych produktów', 'MAX_DISPLAY_TIME_NEW_PRODUCTS', '365', 'Maksymalny czas wyświetlania nowych produktów od momentu dodania ich do sklepu podany w dniach.', '3', '22', '2006-08-07 18:30:20', '2003-07-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('261', 'Box Kategorie Kto jest online', 'BOX_WHOSONLINE_IS_ON', 'true', 'Czy pokazywać box Kto jest online ?', '400', '45', '2006-03-20 21:16:17', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('262', 'W której kolumnie box Kto jest online ?', 'BOX_WHOSONLINE_COLUMN', 'left', 'W której kolumnie wyświetlać box Kto jest online ?', '400', '46', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('279', 'Moduł Nasz HIT na stronie głównej', 'SHOW_STARPRODUCT', 'true', 'Czy pokazywać Nasz HIT na stronie głównej ?', '99', '27', '2007-01-22 13:12:43', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('502', 'Discount Percentage', 'MODULE_FIXED_PAYMENT_CHG_AMOUNT', '2', 'Amount of Discount.', '6', '7', NULL, '2005-10-22 21:38:53', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('507', 'Discount Percentage', 'MODULE_FIXED_PAYMENT_CHG_AMOUNT', '2', 'Amount of Discount.', '6', '7', NULL, '2005-10-22 21:43:18', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('517', 'Discount Percentage', 'MODULE_FIXED_PAYMENT_CHG_AMOUNT', '2', 'Amount of Discount.', '6', '7', NULL, '2005-10-22 21:56:33', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('553', 'Menu DHTML w panelu Admina', 'MENU_DHTML', 'true', 'Użyj menu DHTML w panelu administratora', '101', '1', '2007-08-02 12:27:11', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('554', 'Lista dostępności produktów', 'MAX_DISPLAY_PRODUCTS_AVAILABILITY_IN_A_LIST', '1', 'Gdy ilość opcji dostępności produktów przekracza podaną liczbę wyświetlana jest rozwijana lista wyboru', '7', '6', NULL, '2005-11-06 10:20:09', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('555', 'Wielkość pola wyboru dostępności produktów', 'MAX_PRODUCTS_AVAILABILITY_LIST', '1', 'Gdy wartość ustawiona na \'1\' - używana jest rozwijana lista dostępności produktów. W przeciwnym wypadku jest okno wyboru z ilością wierszy taką jak podana liczba', '7', '7', NULL, '2005-11-06 10:20:09', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('556', 'Wyświetlaj dostępność produktów', 'PRODUCT_LIST_PRODUCTS_AVAILABILITY', '0', 'Czy chcesz wyświetlać dostępność produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '13', '2007-02-27 12:10:19', '2005-11-06 10:20:09', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('880', 'Szerokość obrazka w Liście wszystkich produktów', 'ALLPROD_IMAGE_WIDTH', '80', 'Szerokość (w pikselach) obrazków', '4', '7', '2007-02-26 10:27:26', '2003-07-24 17:45:15', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('881', 'Wysokość obrazka w Liście wszystkich produktów', 'ALLPROD_IMAGE_HEIGHT', '80', 'Wysokość (w pikselach) obrazków', '4', '8', '2003-07-31 19:34:01', '2003-07-24 17:45:15', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1001', 'Pokaż model', 'DISPLAY_MODEL', 'true', 'Włącz/Wyłącz wyświetlanie modelu', '300', '1', '2003-06-04 05:04:11', '2003-06-04 04:18:06', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1002', 'Edycja pola model', 'MODIFY_MODEL', 'true', 'Pozwól/Zabroń modyfikować pole model', '300', '2', '2007-02-14 13:15:36', '2003-06-04 04:25:57', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1003', 'Edycja nazwy produktu', 'MODIFY_NAME', 'false', 'Pozwól/Zabroń modyfikować nazwę produktu?', '300', '3', '2003-06-04 05:04:01', '2003-06-04 04:30:31', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1004', 'Edycja statusu wyświetlania produktu.', 'DISPLAY_STATUT', 'true', 'Pozwól/Zabroń modyfikować status wyświetlania produktu', '300', '4', '2003-06-04 05:07:11', '2003-06-04 05:00:58', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1005', 'Edycja wagi produktu', 'DISPLAY_WEIGHT', 'true', 'Pozwól/Zabroń modyfikować wagę produktu?', '300', '5', '2003-06-04 05:06:44', '2003-06-04 04:33:16', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1006', 'Edycja ilości produktu', 'DISPLAY_QUANTITY', 'true', 'Pozwól/Zabroń modyfikować ilość produktu', '300', '6', '2003-06-04 05:06:48', '2003-06-04 04:34:34', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1007', 'Edycja zdjęcia produktu', 'DISPLAY_IMAGE', 'true', 'Pozwól/Zabroń modyfikować obrazek produktu', '300', '7', '2006-09-22 15:04:39', '2003-06-04 04:36:57', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1008', 'Edycja pola producenta produktu', 'MODIFY_MANUFACTURER', 'true', 'Pozwól/Zabroń modyfikować producenta produktu', '300', '9', '2005-11-11 09:39:41', '2003-06-04 04:37:40', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1009', 'Edycja pola podatek', 'MODIFY_TAX', 'true', 'Pozwól/Zabroń modyfikować podatek', '300', '11', '2005-11-09 21:26:54', '2003-06-04 04:31:53', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1010', 'Pokaż cenę z podatkiem po najechaniu myszką na produkt', 'DISPLAY_TVA_OVER', 'true', 'Włącz/Wyłącz pokazywanie ceny z podatkiem po najechaniu myszką na produkt', '300', '12', '2005-11-09 21:27:07', '2003-06-04 04:38:45', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1011', 'Pokaż cenę z podatkiem podczas edycji produktu', 'DISPLAY_TVA_UP', 'true', 'Włącz/Wyłącz pokazywanie ceny z podatkiem podczas wprowadzania ceny', '300', '13', '2005-11-11 09:39:49', '2003-06-04 04:40:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1012', 'Pokaż link do strony podglądu produktu', 'DISPLAY_PREVIEW', 'false', 'Włącz/Wyłącz pokazywanie linku do strony podglądu produktu', '300', '14', '2007-02-14 13:15:59', '2003-06-04 05:15:50', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1013', 'Pokaż link do strony edycji produktu', 'DISPLAY_EDIT', 'true', 'Włącz/Wyłącz pokazywanie linku do strony, na której można edytować produkt w pełnym zakresie', '300', '15', '2007-02-14 13:16:03', '2003-06-04 05:17:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1014', 'Pokaż pole producent produktu', 'DISPLAY_MANUFACTURER', 'true', 'Pokazywać producenta produktu ?', '300', '8', '2005-11-11 09:39:36', '2003-06-04 05:17:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1015', 'Pokaż podatek', 'DISPLAY_TAX', 'true', 'Pokazywać podatek VAT ?', '300', '10', '2005-11-09 21:26:47', '2003-06-04 05:17:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1016', 'Margines zmian cen', 'ACTIVATE_COMMERCIAL_MARGIN', 'true', 'Możliwośćstosowania marginesu zmiany cen ?', '300', '16', '2005-11-11 09:39:11', '2003-06-04 05:17:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1017', 'Cena detaliczna', 'DISPLAY_RETAIL_PRICE', 'true', 'Włącz/Wyłącz pokazywanie ceny detalicznej?', '300', '17', '2005-11-12 07:50:42', '2003-06-04 05:19:08', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1018', 'Display the cost.', 'DISPLAY_COST', 'false', 'Enable/Disable the display of the cost?', '300', '18', '2007-04-04 20:27:22', '2003-06-04 05:19:08', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1019', 'Liczba miejsc dziesiętnych w module Nasza cena', 'NEW_FIELDS_DECIMAL', '2', 'Podaj liczbę miejsc dziesiętnych w module Nasza cena - oszczędzasz ...', '101', '5', '2006-01-05 20:11:36', '2005-11-11 10:28:21', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1046', 'Szerokość lewej kolumny', 'BOX_WIDTH_LEFT', '190', 'Jaka ma być szerokość prawej kolumny (w pixelach) ?', '99', '6', '2006-09-12 14:36:16', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1047', 'Szerokość prawej kolumny', 'BOX_WIDTH_RIGHT', '174', 'Jaka ma być szerokość lewej kolumny (w pixelach) ?', '99', '5', '2006-08-07 18:28:24', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1048', 'Lewa kolumna', 'COLUMN_LEFT_IS_ON', 'true', 'Czy chcesz wyświetlać lewą kolumnę ?', '99', '4', '2005-12-25 08:21:42', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1049', 'Prawa kolumna', 'COLUMN_RIGHT_IS_ON', 'true', 'Czy chcesz wyświetlać prawą kolumnę ?', '99', '3', '2006-02-19 20:12:57', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1050', 'Lewa kolumna -> prawa', 'COLUMN_LEFT_IS_ON_RIGHT', 'false', 'Czy chcesz, aby zawartość lewej kolumny była wyświetlana z prawej strony ?', '99', '7', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1051', 'Prawa kolumna -> lewa', 'COLUMN_RIGHT_IS_ON_LEFT', 'false', 'Czy chcesz, aby zawartość prawej kolumny była wyświetlana z lewej strony ?', '99', '8', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1052', 'Box Banner Lewy', 'BOX_BANNER_LEFT_IS_ON', 'false', 'Czy chcesz wyświetlać banner w lewej kolumnie ?', '400', '1', '2007-07-06 10:06:38', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1053', 'Kategoria bannerów', 'BANNER_LEFT_GROUP_IS', 'test', 'Która kategoria bannerów ma być wyświetlana ?', '400', '2', '2007-07-06 09:51:20', '0000-00-00 00:00:00', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1054', 'W której kolumnie box Banner Lewy ?', 'BOX_BANNER_LEFT_COLUMN', 'left', 'W której kolumnie ma być wyświetlany box z Bannerami ?', '400', '3', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1055', 'Box Kategorie', 'BOX_CATAGORIES_IS_ON', 'true', 'Czy wyświetlać box Kategorie ?', '400', '4', '2006-02-25 08:40:31', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1056', 'W której kolumnie box Kategorie ?', 'BOX_CATAGORIES_COLUMN', 'left', 'W której kolumnie wyświetlać box Kategorie ?', '400', '5', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1057', 'Box Producenci', 'BOX_MANUFACTURERS_IS_ON', 'true', 'Czy wyświetlać box Producenci ?', '400', '6', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1058', 'W której kolumnie box Producenci?', 'BOX_MANUFACTURERS_COLUMN', 'left', 'W której kolumnie wyświetlać box Producenci ?', '400', '7', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1059', 'Box Co nowego ?', 'BOX_WHATS_NEW_IS_ON', 'true', 'Czy wyświetlać box Co nowego ?', '400', '8', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1060', 'W której kolumnie box Co nowego ?', 'BOX_WHATS_NEW_COLUMN', 'right', 'W której kolumnie wyświetlać box Co nowego ?', '400', '9', '2005-11-13 12:23:07', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1061', 'Box Szukaj', 'BOX_SEARCH_IS_ON', 'true', 'Czy wyświetlać box Szukaj ?', '400', '10', '2006-03-22 21:34:58', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1062', 'W której kolumnie box Szukaj ?', 'BOX_SEARCH_COLUMN', 'left', 'W której kolumnie wyświetlać box Szukaj?', '400', '11', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1063', 'Box Informacje', 'BOX_INFORMATION_IS_ON', 'true', 'Czy wyświetlać box Informacje ?', '400', '12', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1064', 'W której kolumnie box Informacje', 'BOX_INFORMATION_COLUMN', 'left', 'W której kolumnie wyświetlać box Informacje ?', '400', '13', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1065', 'Box Koszyk', 'BOX_SHOPPING_CART_IS_ON', 'true', 'Czy wyświetlać box Koszyk ?', '400', '14', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1066', 'W której kolumnie box Koszyk ?', 'BOX_SHOPPING_CART_COLUMN', 'right', 'W której kolumnie wyświetlać box Koszyk ?', '400', '15', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1067', 'Box Login', 'BOX_LOGINBOX_IS_ON', 'true', 'Czy wyświetlać box Login ?', '400', '16', '2005-12-03 23:25:19', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1068', 'W której kolumnie box Login ?', 'BOX_LOGINBOX_COLUMN', 'right', 'W której kolumnie wyświetlać box Login ?', '400', '17', '2005-12-03 23:25:25', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1069', 'Box O Producencie', 'BOX_MANUFACTURER_INFO_IS_ON', 'true', 'Czy wyświetlać box O Producencie ?', '400', '18', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1070', 'W której kolumnie box O Producencie ?', 'BOX_MANUFACTURER_INFO_COLUMN', 'right', 'W której kolumnie wyświetlać box O Producencie?', '400', '19', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1071', 'Box Historia zamówień', 'BOX_ORDER_HISTORY_IS_ON', 'true', 'Czy wyświetlać box Historia zamówień ?', '400', '20', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1072', 'W której kolumnie box Historia zamówień ?', 'BOX_ORDER_HISTORY_COLUMN', 'right', 'W której kolumnie wyświetlać box Historia zamówień?', '400', '21', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1073', 'Box Bestsellery', 'BOX_BEST_SELLERS_IS_ON', 'true', 'Czy wyświetlać box Bestsellery ?', '400', '22', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1074', 'W której kolumnie box Bestsellery', 'BOX_BEST_SELLERS_COLUMN', 'right', 'W której kolumnie wyświetlać box Bestsellery ?', '400', '23', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1075', 'Box Powiadomienia o produktach', 'BOX_PRODUCT_NOTIFICATIONS_IS_ON', 'true', 'Czy wyświetlać box Powiadomienia o produkcie?', '400', '24', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1076', 'W której kolumnie box Powiadomienia o produktach ?', 'BOX_PRODUCT_NOTIFICATIONS_COLUMN', 'right', 'W której kolumnie wyświetlać box Powiadomienia o produktach ?', '400', '25', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1077', 'Box Promocje', 'BOX_SPECIALS_IS_ON', 'true', 'Czy wyświetlać box Promocje ?', '400', '26', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1078', 'W której kolumnie box Promocje ?', 'BOX_SPECIALS_COLUMN', 'right', 'W której kolumnie wyświetlać box Promocje ?', '400', '27', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1079', 'Box Opinie', 'BOX_REVIEWS_IS_ON', 'true', 'Czy wyświetlać box Opinie o produkcie ?', '400', '28', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1080', 'W której kolumnie box Opinie ?', 'BOX_REVIEWS_COLUMN', 'right', 'W której kolumnie wyświetlać box Opinie o produktach ?', '400', '29', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1081', 'Box Powiadom znajomych', 'BOX_TELL_A_FRIEND_IS_ON', 'true', 'Czy wyświetlać box Powiadom znajomych ?', '400', '30', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1082', 'W której kolumnie box Powiadom znajomych', 'BOX_TELL_A_FRIEND_COLUMN', 'right', 'W której kolumnie wyświetlać box Powiadom znajomych ?', '400', '31', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1083', 'Box Języki', 'BOX_LANGUAGES_IS_ON', 'true', 'Czy wyświetlać box Języki?', '400', '32', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1084', 'W której kolumnie box Języki ?', 'BOX_LANGUAGES_COLUMN', 'left', 'W której kolumnie wyświetlać box Języki?', '400', '33', '2006-09-12 14:39:14', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1085', 'Wyświetlaj opis produktu', 'PRODUCT_LIST_DESCRIPTION', '99', '0 - wyłączone, 99 - włączone.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '11', '2006-02-26 22:44:14', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1086', 'Długość tekstu w listach produktów', 'PRODUCT_LIST_DESCRIPTION_LENGTH', '250', 'Ile znaków ma być wyświetlane w opisach produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '12', '2005-11-29 23:37:54', '2002-03-16 18:51:26', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1096', 'Discount Percentage', 'MODULE_FIXED_PAYMENT_CHG_AMOUNT', '2', 'Amount of Discount.', '6', '7', NULL, '2005-12-04 22:57:33', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1294', 'Wyświetlaj sugerowaną cenę', 'PRODUCT_LIST_RETAIL_PRICE', '0', 'Czy wyświetlać cenę sugerowaną ?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '6', '2007-02-27 11:55:23', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1295', 'Wyświetlaj pole oszczędzasz', 'PRODUCT_LIST_SAVE', '0', 'Czy wyświetlać pole oszczędzasz ? Wartość wyświetlana jest w procentach.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)', '8', '9', '2007-02-27 11:55:44', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1296', 'Czy wyświetlać cenę sugerowaną producenta', 'NEW_FIELDS_WHATS_NEW', 'true', 'Czy pokazywać sugerowaną cenę w boxach Nowe Produkty, Promocje, Oczekiwane Produkty ?', '8', '17', '2005-12-12 23:14:11', '2005-12-12 22:14:57', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1297', 'Lista wszystkich produktów', 'ALL_PRODUCTS', 'true', 'Czy włączyć katalog wszystkich produktów ?<br>(true=włącz false=wyłącz)', '29', '1', '2005-12-15 20:17:23', '2005-12-14 21:42:36', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1298', 'Lista produktów: nazwa pliku', 'ALL_PRODUCTS_FILENAME', 'allprods.php', 'Lista wszystkich produktów domyslan nazwa pliku=allprods.php', '29', '2', NULL, '2005-12-14 21:42:36', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1307', 'Moduł Nowości na stronie głównej', 'SHOW_NEWPRODUCTS', 'true', 'Czy pokazywać moduł Nowości na stronie głównej i w podkategoriach ?', '99', '22', '2005-12-25 11:41:07', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1308', 'Logo sklepu', 'STORE_LOGO', 'oscgold.gif', 'Nazwa pliku zawierającego logo sklepu<br>Plik należy umieści w katalogu /imagesć', '1', '5', '2006-08-14 09:23:27', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1309', 'Ilość cen dla produktu', 'XPRICES_NUM', '1', 'Ilość cen dla produktu<br><br><b>UWAGA: Zmiejszenie ilości cen powoduje ich usunięcie z tabeli produktów!</b><br><br><b>Każdej grupie używającej skasowanych cen przypisana zostanie cena domyślna.</b>', '401', '1', '2006-08-07 18:24:12', '0000-00-00 00:00:00', 'tep_update_prices', 'tep_cfg_pull_down_prices(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1310', 'Pokazuj ceny wszystkim', 'ALLOW_GUEST_TO_SEE_PRICES', 'true', 'Wyświetlanie cen osobom niezalogowanym', '401', '2', '2007-02-08 11:39:20', '2004-03-15 14:59:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1311', 'Rabat dla klientów niezalogowanych', 'GUEST_DISCOUNT', '0', 'Rabat dla klientów niezalogowanych', '401', '3', '2006-10-21 20:30:34', '2004-03-15 14:59:05', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1312', 'Cena promocyjna (ukrywanie ceny produktu)', 'SPECIAL_PRICES_HIDE', 'false', 'Cena promocyjna (ukrywanie ceny produktu)', '401', '4', '2007-08-02 20:22:47', '2004-03-15 14:59:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1313', 'Aktywacja nowych klientów', 'NEW_CUSTOMERS_ENABLED', 'true', 'Czy konto klienta ma być aktywane od razu po rejestracji ?', '401', '5', '2006-10-21 18:22:31', '2004-03-15 14:59:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1314', 'Długość sesji klienta', 'SESSION_LENGHT', '600', 'Długość sesji klienta (w sekundach)', '15', '8', '2006-03-09 12:55:35', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1315', 'Długość sesji administratora', 'SESSION_LENGHT_ADM', '1800', 'Długość sesji administratora (w sekundach)', '15', '9', '2006-01-02 15:02:53', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1318', 'Szerokość wyświetlanego obrazka w opisie produktu', 'DISPLAY_IMAGE_WIDTH', '150', 'Szerokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>', '4', '9', '2007-04-25 14:23:20', '2006-01-03 11:34:11', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1319', 'Wysokość wyświetlanego obrazka w opisie produktu', 'DISPLAY_IMAGE_HEIGHT', '150', 'Wysokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>', '4', '10', '2007-04-25 14:23:26', '2006-01-03 11:34:11', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1320', 'Szerokość obrazka w oknie PopUp', 'POPUP_IMAGE_WIDTH', '', 'Szerokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!', '4', '11', '2006-06-25 21:58:46', '2006-01-03 11:34:11', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1321', 'Wysokość obrazka w oknie PopUp', 'POPUP_IMAGE_HEIGHT', '', 'Wysokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!', '4', '12', '2006-06-25 21:58:50', '2006-01-03 11:34:11', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1465', 'Installed Modules', 'MODULE_GIFTWRAP_INSTALLED', 'giftwrap.php;nogiftwrap.php', 'This is automatically updated. No need to edit.', '6', '0', '2006-05-09 13:52:15', '2006-02-19 10:32:56', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1480', 'Moduł Polecane produkty na stronie głównej', 'FEATURED_PRODUCTS_DISPLAY', 'true', 'Ustaw wartość false lub true, aby wyłączyć lub włączyć wyświetlanie polecanych produktów.', '99', '24', '2006-04-10 10:33:39', '2006-03-01 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1481', 'Polecane produkty', 'MAX_DISPLAY_FEATURED_PRODUCTS', '2', 'Wprowadź maksymalną ilość polecanych produktów do wyświetlenia na stronie głównej.', '3', '4', '2006-06-22 21:40:28', '2006-03-01 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1482', 'Ilość kolumn w module Polecane produkty', 'MAX_DISPLAY_COLUMN_FEATURED_PRODUCTS', '2', 'Wprowadź liczbę kolumn w module polecanych produktów do wyświetlenia na stronie głównej.', '8', '23', '2006-06-22 21:40:34', '2006-03-01 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1506', 'Kto jest online, czas', 'WHOS_ONLINE_AGO', '900', 'Jaki ma być czas odświeżania sesji od ostatniego kliknięcia klienta w sklepie - w sekundach?<br>(time in secondes)', '99', '27', '2004-03-17 04:04:04', '2004-03-17 04:04:04', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1507', 'Kto jest online, nazwy', 'WHOS_ONLINE_LIST', 'true', 'Czy ma być pokazywana lista zalogowanych w sklepie klientów ?', '99', '28', '2006-03-20 20:16:50', '2004-03-17 04:04:04', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1518', 'Zamawianie bez zakładania konta', 'PURCHASE_WITHOUT_ACCOUNT', 'true', 'Czy zezwalać klientom sklepu na dokonywanie zamówień bez zakładania konta ?', '101', '14', '2006-04-19 15:29:28', '2006-04-18 22:25:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1519', 'Adres dostawy podczas zamawiania bez rejestracji', 'PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING', 'true', 'Czy zezwalać klientom sklepu na podawanie odobnego adresu dostawy podczas zamawiania bez zakładania konta ?', '101', '15', '2006-04-19 15:30:44', '2006-04-18 22:25:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1522', 'Maksymalne zamówienie', 'MAXIMUM_ORDERS', 'false', 'Czy chcesz włączyć ograniecznie ilości kupowanych towarów jednego rodzaju ?', '9', '6', '2006-08-07 22:27:17', '2006-05-03 10:17:10', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1523', 'Wyświetlaj maksymalną ilość produktów do kupienia', 'PRODUCT_LIST_MAXORDER', '0', 'Czy chcesz włączyć wyświetlanie max. ilości kupowanych towarów z danego asortymentu ?', '8', '14', '2007-02-27 11:32:45', '2006-05-09 11:54:18', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1526', 'Box Newsletter', 'BOX_NEWSLETTER_IS_ON', 'true', 'Czy wyświetlać box Newsletter ?', '400', '49', '2006-02-25 08:40:31', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1527', 'W której kolumnie box Newsletter ?', 'BOX_NEWSLETTER_COLUMN', 'left', 'W której kolumnie wyświetlać box Newsletter ?', '400', '50', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1578', 'Podsumowanie', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Czy chcesz wyświetlić podsumowanie zamówienia ?', '6', '1', NULL, '2006-05-09 13:46:04', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1579', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '7', 'Na którym miejscu pokazać?', '6', '2', NULL, '2006-05-09 13:46:04', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1580', 'Podatek', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'Czy chcesz wyświetlić podatek w zamówieniu ?', '6', '1', NULL, '2006-05-09 13:46:17', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1581', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '3', 'Na którym miejscu pokazać?', '6', '2', NULL, '2006-05-09 13:46:17', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1582', 'Pokazuj podsumę', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Pokazuje podsumę na stronie z zamówieniem', '6', '1', NULL, '2006-05-09 13:46:29', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1583', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '2', 'Na którym miejscu pokazać?', '6', '2', NULL, '2006-05-09 13:46:29', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3940', 'Koszt przesyłki', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Czy chcesz wyświetlać koszt przesyłki ?', '6', '1', NULL, '2007-09-11 11:01:10', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3941', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '5', 'Na którym miejscu pokazać ?', '6', '2', NULL, '2007-09-11 11:01:10', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1586', 'Bezpłatna przesyłka', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Czy włączyć możliwość przesyłki na koszt sprzedawcy ?', '6', '3', NULL, '2006-05-09 13:46:41', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1588', 'Bezpłatna przesyłka do zamówień', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Zastosuj przesyłkę na koszt sprzedawcy do zamówień', '6', '5', NULL, '2006-05-09 13:46:41', NULL, 'tep_cfg_select_option(array(\'national\', \'international\', \'both\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1598', 'Włącz prezent', 'MODULE_GIFT_STATUS', 'True', 'Czy chcesz włączyć moduł pakowania przesyłki jako prezent ?', '6', '0', NULL, '2006-05-09 13:52:07', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1599', 'Koszt pakowania prezentu', 'MODULE_GIFT_COST', '5.00', 'Koszt doliczany do zamówienia za zapakowanie przesyłki jako prezent.', '6', '0', NULL, '2006-05-09 13:52:07', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1600', 'Strefa', 'MODULE_GIFT_ZONE', '0', 'Jeżeli zostanie określona strefa - opcja Prezentu będzie dotyczyła tylko tej strefy.', '6', '0', NULL, '2006-05-09 13:52:07', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1601', 'Kolejność wyświetlania.', 'MODULE_GIFT_SORT_ORDER', '0', 'Kolejność wyświetlania opcji Prezent', '6', '0', NULL, '2006-05-09 13:52:07', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1602', 'Zwykłe opakowanie', 'MODULE_NOGIFT_STATUS', 'True', 'Czy chcesz włączyć opcję zwykłego pakowania przesyłki ?', '6', '0', NULL, '2006-05-09 13:52:15', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1603', 'Koszt pakowania', 'MODULE_NOGIFT_COST', '0.00', 'Koszt pakowania przesyłki', '6', '0', NULL, '2006-05-09 13:52:15', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1604', 'Strefa', 'MODULE_NOGIFT_ZONE', '0', 'Jeżeli zostanie określona strefa - opcja będzie dotyczyła tylko tej strefy.', '6', '0', NULL, '2006-05-09 13:52:15', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1605', 'Kolejność wyświetlania.', 'MODULE_NOGIFT_SORT_ORDER', '1', 'Kolejność wyświetlania opcji Prezent.', '6', '0', NULL, '2006-05-09 13:52:15', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1606', 'SEO Adresy URL przyjazne dla wyszukiwarek', 'SEO_ENABLED', 'true', 'Adresy URL przyjazne dla wyszukiwarek. Czy włączyć globalne ustawienia wyświetlania adresów URL przyjaznych dla wyszukiwarek ?', '403', '0', '2006-11-14 11:47:09', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1607', 'Dodanie cPath do adresu URL produktu', 'SEO_ADD_CPATH_TO_PRODUCT_URLS', 'false', 'Włączenie tej opcji powoduje dodanie cPath na końcu adresu URL produktu (np. - jakis-product-p-1.html?cPath=xx).', '403', '1', '2006-07-16 11:37:46', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1608', 'Dodanie kategorii nadrzędnej na początku adresu produktu', 'SEO_ADD_CAT_PARENT', 'false', 'Włączenie tej opcji powoduje wyświetlenie nazwy kategorii nadrzędnej na początku adresu URL produktu (np. - nadrzedna-category-c-1.html).', '403', '2', '2007-09-17 09:29:40', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1609', 'Filtrowanie krótkich wyrazów', 'SEO_URLS_FILTER_SHORT_WORDS', '3', 'Opcja umożliwia filtrowanie w adresie wyrazów krótszych niż podana wartość.', '403', '3', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1610', 'Pamięć cache', 'USE_SEO_CACHE_GLOBAL', 'true', 'Ustawienie globalne umożliwiające całkowite wyłączenie pamięci cache.', '403', '5', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1611', 'Pamięć cache dla produktów', 'USE_SEO_CACHE_PRODUCTS', 'true', 'Włączenie/Wyłączenie pamięci cache dla produktów.', '403', '6', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1612', 'Pamięć cache dla kategorii', 'USE_SEO_CACHE_CATEGORIES', 'true', 'Włączenie/Wyłączenie pamięci cache dla kategorii', '403', '7', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1613', 'Pamięć cache dla producentów', 'USE_SEO_CACHE_MANUFACTURERS', 'true', 'Włączenie/Wyłączenie pamięci cache dla producentów', '403', '8', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1614', 'Pamięć cache dla artykułów', 'USE_SEO_CACHE_ARTICLES', 'true', 'Włączenie/Wyłączenie pamięci cache dla artykułów', '403', '9', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1615', 'Pamięć cache dla tematów', 'USE_SEO_CACHE_TOPICS', 'true', 'Włączenie/Wyłączenie pamięci cache dla tematów', '403', '10', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1616', 'Pamięć cache dla stron informacyjnych', 'USE_SEO_CACHE_INFO_PAGES', 'true', 'Włączenie/Wyłączenie pamięci cache dla stron informacyjnych', '403', '11', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1617', 'Pamięć cache dla linków', 'USE_SEO_CACHE_LINKS', 'true', 'Włączenie/Wyłączenie pamięci cache dla stron categorii', '403', '12', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1618', 'Automatyczne przekierowania', 'USE_SEO_REDIRECT', 'true', 'Opcja właczania automatycznego przekierowania nagłówków ze starych adresów do nowych', '403', '13', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1619', 'Sposób przepisywania adresów', 'SEO_REWRITE_TYPE', 'Rewrite', 'Wybór formatu SEO URL', '403', '14', '2006-05-11 12:24:43', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'Rewrite\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1620', 'Tablica konwersji znaków specjalnych', 'SEO_CHAR_CONVERT_SET', 'ą=>a,ę=>e,ć=>c,ś=>s,ł=>l, ń=>n,ó=>o,ż=>z,ź=>z, Ą=>A,Ę=>E,Ć=>C,Ś=>S,Ł=>L, Ń=>N,Ó=>O,Ż=>Z,Ź=>Z', 'Konwersja znaków specjalnych w adresach<br><br>Należy wprowadzić w nastepującycm formacie :: <br><b>char=>conv,char2=>conv2</b>', '403', '15', '2006-05-11 13:04:11', '2006-05-11 12:24:43', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1621', 'Usuwanie znaków specjalnych', 'SEO_REMOVE_ALL_SPEC_CHARS', 'false', 'Usuwanie wszystkich znaków specjalnych z adresów URL.', '403', '17', '2006-07-16 12:20:59', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1622', 'Czyszczenie Cache', 'SEO_URLS_CACHE_RESET', 'false', 'Wyczyszczenie pamięci cache dla przyjaznych adresów SEO URL', '403', '16', '2007-09-17 09:29:47', '2006-05-11 12:24:43', 'tep_reset_cache_data_seo_urls', 'tep_cfg_select_option(array(\'reset\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1623', 'Zgodność z zaleceniami W3C', 'SEO_URLS_USE_W3C_VALID', 'true', 'Włączenie tej opcji umożliwia generowanie adresów URL zgodnie z zaleceniami W3C', '403', '4', '2006-07-10 09:35:28', '2006-05-11 12:24:43', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1624', 'Edytor zamówień - wyświetlanie sposobu płatności?', 'DISPLAY_PAYMENT_METHOD_DROPDOWN', 'true', 'Sposób wybierania metody płatności w Edytorze zamówień: rozwiajana lista (true) lub pole tekstowe (false)', '101', '15', NULL, '2006-04-02 11:51:01', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('2999', 'Włącz cache stron', 'ENABLE_PAGE_CACHE', 'false', 'Umożliwia włączenie cache w celu przyspieszenia ładowania stron', '26229', '1', '2007-08-24 21:17:55', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3000', 'Czas przetrzymywania stron', 'PAGE_CACHE_LIFETIME', '5', 'Jak długo mają być przetrzymywane strony (w minutach) ?', '26229', '2', NULL, '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3001', 'Debug Mode', 'PAGE_CACHE_DEBUG_MODE', 'false', 'Włączenie opcji debuggowania ? Należy korzystać tylko w celu testowania sklepu!  Można również włączyć tę opcje wpisując \"?debug=1\" w adresie strony', '26229', '3', '2007-08-24 21:16:50', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3002', 'Wyłączenie parametrów URL', 'PAGE_CACHE_DISABLE_PARAMETERS', 'false', 'W niektórych przypadkach (np. używania przyjaznych adresów URL) mogą występować błędy przy zapisie stron.', '26229', '4', '2007-08-24 21:09:00', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3003', 'Kasowanie plików', 'PAGE_CACHE_DELETE_FILES', 'false', 'Ustawienie wartości true spowoduje usunięcie plików cache i ustawi ponownie wartość na false.', '26229', '5', '2006-08-14 09:43:49', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3004', 'Config Cache Update File', 'PAGE_CACHE_UPDATE_CONFIG_FILES', 'none', 'Jeżeli jest używana kontrybucja Config Cache Update File należy podać pełną ścieżkę do plików.', '26229', '6', NULL, '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3188', 'Włącz opcję Odbiór osobisty', 'MODULE_SHIPPING_ODBIOR_OSOBISTY_STATUS', 'True', 'Czy chcesz oferować możliwość odbioru osobistego?', '6', '0', NULL, '2006-08-11 13:27:08', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3189', 'Koszt dostawy', 'MODULE_SHIPPING_ODBIOR_OSOBISTY_COST', '0.00', 'Koszt dostawy dla wszystkich zamówień', '6', '0', NULL, '2006-08-11 13:27:08', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3190', 'Podatek', 'MODULE_SHIPPING_ODBIOR_OSOBISTY_TAX_CLASS', '0', 'Wybierz podatek stosowany przy wyliaczniu kosztów dostawy', '6', '0', NULL, '2006-08-11 13:27:08', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3191', 'Strefa dostawy', 'MODULE_SHIPPING_ODBIOR_OSOBISTY_ZONE', '0', 'Wybierz strefę, dla której ma być stosowany ten sposob dostawy', '6', '0', NULL, '2006-08-11 13:27:08', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3192', 'Kolejność wyświetlania', 'MODULE_SHIPPING_ODBIOR_OSOBISTY_SORT_ORDER', '4', 'Kolejność wyświetlania', '6', '0', NULL, '2006-08-11 13:27:08', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3205', 'Optymalizacja bazy danych', 'OPTIMIZE_PERIOD', '30', 'Okres pomi', '3', '21', '2006-08-12 12:04:29', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3206', 'Włącz płatność przy odbiorze osobistym', 'MODULE_PAYMENT_COP_STATUS', 'True', 'Czy chcesz włączyć płatność gotówką przy odbiorze osobistym ?', '6', '1', NULL, '2006-08-14 08:58:19', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3207', 'Strefa płatności', 'MODULE_PAYMENT_COP_ZONE', '0', 'Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności', '6', '2', NULL, '2006-08-14 08:58:19', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3208', 'Kolejność wyświetlania', 'MODULE_PAYMENT_COP_SORT_ORDER', '6', 'Kolejność wyświetlania', '6', '0', NULL, '2006-08-14 08:58:19', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3209', 'Status zamówienia', 'MODULE_PAYMENT_COP_ORDER_STATUS_ID', '0', 'Ustaw status zamówienia dla tej metody płatności', '6', '0', NULL, '2006-08-14 08:58:19', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3210', 'Wyłączenie sklepu', 'DOWN_FOR_MAINTENANCE', 'false', 'Włączenie tej opcji powoduje zamknięcie sklepu dla klientów i wyświetlenie informacji o niedostępności sklepu.', '0', '0', '2006-11-05 10:34:19', '2006-08-14 09:22:04', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3211', 'Strona informacyjna', 'DOWN_FOR_MAINTENANCE_PAGE', 'index-maint.php', 'Strona do której będą przekierowani klienci podczas zamknięcia sklepu.', '0', '0', NULL, '2006-08-14 09:22:04', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3212', 'Włączyć ostrzeżenie ?', 'DOWN_FOR_MAINTENANCE_WARNING', 'false', 'Włączenie tej opcji powoduje wyświetlenie na stronach sklepu informacji, że sklep zostanie niebawem wyłączony z powodów administracyjnych.', '0', '0', '2006-11-05 10:34:24', '2006-08-14 09:22:04', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3213', 'Informacja', 'DOWN_FOR_MAINTENANCE_MESSAGE', 'Sklep zostanie wkrótce wyłączony w celach administracyjnych. Przepraszamy za utrudnienia.', 'Informacja wyświetlona po włączeniu ostrzeżenia', '0', '0', '2006-08-17 13:45:18', '2006-08-14 09:22:04', NULL, 'tep_cfg_textarea(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3214', 'Aministracyjny adres IP', 'DOWN_FOR_MAINTENANCE_IP_ADDRESS', '', 'Adres, z którego jest dostęp do sklepu podczas jego wyłączenia.', '0', '0', '2006-08-22 21:54:43', '2006-08-14 09:22:04', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3229', 'Włącz płatność za pobraniem', 'MODULE_PAYMENT_POBRANIE_STATUS', 'True', 'Czy chcesz włączyć płatność przy odbiorze za przesyłkę Pocztą Polską ?', '6', '1', NULL, '2006-08-23 12:30:10', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3230', 'Strefa płatności', 'MODULE_PAYMENT_POBRANIE_ZONE', '0', 'Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności', '6', '2', NULL, '2006-08-23 12:30:10', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3231', 'Kolejność wyświetlania', 'MODULE_PAYMENT_POBRANIE_SORT_ORDER', '1', 'Kolejność wyświetlania', '6', '0', NULL, '2006-08-23 12:30:10', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3232', 'Status zamówienia', 'MODULE_PAYMENT_POBRANIE_ORDER_STATUS_ID', '0', 'Ustaw status zamówienia dla tej metody płatności', '6', '0', NULL, '2006-08-23 12:30:10', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3266', 'Włączenie modułu', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_STATUS', 'True', 'Czy włączyć moduł Przesyłka Priorytetowa ?', '6', '0', NULL, '2006-08-23 12:31:30', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3267', 'Grupa VAT', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', NULL, '2006-08-23 12:31:30', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3268', 'Sortowanie', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_SORT_ORDER', '2', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3269', 'Kraje Obszaru Nr 1 (strefa Polska wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_1', 'PL', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 1.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3270', 'Tablica kosztów Nr 1 (strefa Polska wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_1', '0.35:4.7,0.5:5.1,1:6.50,2:8,5:9.5, 10:16.00,15:21,20:30,30:33', 'Koszty przesyłki dla Obszaru Nr 1 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 1.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3271', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 1', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_1', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3272', 'Kraje Obszaru Nr 2 (strefa A1 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_2', 'AT;BG;HR;DK;EE;NL;LT; LU;LV;SI;CH;UA;VA;HU', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 2.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3273', 'Tablica kosztów Nr 2 (strefa A1 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_2', '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:80.00,4:92.00,5:102.00, 6:105.00,7:110.00,8:117.00, 9:125.00,10:133.00, 11:139.00,12:145.00,13:155.00,14:162.00,15:171.00, 16:179.00,17:187.00,18:196.00,19:202.00,20:211.00,30:344.0', 'Koszty przesyłki dla Obszaru Nr 2 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 2.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3274', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 2', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_2', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3275', 'Kraje Obszaru Nr 3 (strefa A2 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_3', 'BE;CY;FR;FI;GI;GR;ES;IE;IL;MK;MT;MD;DE;NO;RO;SE;TR;IT;RS;XM', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 3.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3276', 'Tablica kosztów Nr 3 (strefa A2 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_3', '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:98.00,4:102.00,5:114.00, 6:117.00,7:124.00,8:131.00,9:139.00,10:145.00, 11:151.00,12:160.00,13:166.00,14:172.00,15:179.00, 16:187.00,17:196.00,18:204.00,19:211.00,20:221.00,30:366.0', 'Koszty przesyłki dla Obszaru Nr 3 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 3.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3277', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 3', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_3', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3278', 'Kraje Obszaru Nr 4 (strefa A3 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_4', 'PT;RU;GB', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 4.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3279', 'Tablica kosztów Nr 4 (strefa A3 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_4', '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:98.00,4:102.00,5:114.00, 6:117.00,7:124.00,8:131.00,9:139.00,10:145.00, 11:158.00,12:167.00,13:176.00,14:185.00,15:194.00, 16:212.00,17:221.00,18:230.00,19:239.00,20:249.00,30:394.0', 'Koszty przesyłki dla Obszaru Nr 4 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 4.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3280', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 4', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_4', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3281', 'Kraje Obszaru Nr 5 (strefa A4 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_5', 'CZ;SK', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 5.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3282', 'Tablica kosztów Nr 5 (strefa A4 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_5', '0.35:15.30,0.5:20.60, 1:24.00,2:27.00,3:29.00,4:31.00,5:32.00, 6:40.00,7:42.00, 8:43.00,9:44.00,10:45.00, 11:52.00,12:53.00,13:54.00,14:56.00,15:57.00, 16:67.00,17:69.00,18:70.00,19:71.00,20:73.00,30:118', 'Koszty przesyłki dla Obszaru Nr 5 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 5.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3283', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 5', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_5', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3284', 'Kraje Obszaru Nr 6 (strefa A5 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_6', 'BY', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 6.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3285', 'Tablica kosztów Nr 6 (strefa A5 wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_6', '0.35:15.30,0.5:20.60, 1:28.00,2:36.00,3:43.00,4:49.00,5:55.00, 6:68.00,7:74.00,8:80.00,9:86.00,10:92.00, 11:103.00,12:109.00,13:105.00,14:121.00,15:126.00, 16:141.00,17:147.00,18:153.00,19:159.00,20:165.00,30:257.0', 'Koszty przesyłki dla Obszaru Nr 6 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 6.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3286', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 6', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_6', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3287', 'Kraje Obszaru Nr 7 (strefa B wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_7', 'DZ;AO;BJ;BM;BW;BF;BI; CM;CA;TD;KM;CG;DJ;EG; ER;ET;GA;GM;GH;GN;GW; KE;LS;LY;MG;MW;ML;MR; MU;MX;MA;MZ;NA;NE;NG; RW;SN;S.C.;SL;SO;ZA;SH; SD;SZ;TZ;TG;TN;UG;US;ZR;ZM;ZW', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 7.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3288', 'Tablica kosztów Nr 7 (strefa B wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_7', '0.35:18.80,0.5:24.60, 1:43.30,2:82.30,3:126.00,4:146.00,5:172.00, 6:184.00,7:203.00,8:222.00,9:240.00,10:258.00, 11:276.00,12:297.00,13:318.00,14:339.00,15:360.00, 16:390.00,17:411.00,18:433.00,19:454.00,20:475.00,30:703.0', 'Koszty przesyłki dla Obszaru Nr 7 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 7.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3289', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 7', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_7', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3290', 'Kraje Obszaru Nr 8 (strefa C wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_8', 'AF;AI;AG;AR;AM;AW;AZ;BS; BH;BD;BB;BZ;BT;BO;BR;IO; BN;KH;KY;CL;CN;CO;CR;CU; DM;DO;EC;SV;FK;GF;GE;GD; GP;GT;GY;HT;HN;HK;IN;ID;IR; IQ;JM;JP;JO;KZ;KP;KR;KW; KG;LA;LB;MO;MY;MQ;MN; MM;NP;AN;NI;OM;PK;PA; PY;PE;PH;QA;SA;SG;LK; SR;SY;TW;TJ;TH;TT;TM; AE;UY;UZ;VE;VN', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 8.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3291', 'Tablica kosztów Nr 8 (strefa C wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_8', '0.35:21.30,0.5:29.30, 1:50.30,2:100.30,3:140.00,4:170.00,5:205.00, 6:225.00,7:254.00,8:283.00,9:311.00,10:336.00, 11:363.00,12:386.00,13:416.00,14:448.00,15:466.00, 16:500.00,17:514.00,18:538.00,19:561.00,20:586.00,30:922.0', 'Koszty przesyłki dla Obszaru Nr 8 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 8.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3292', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 8', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_8', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3293', 'Kraje Obszaru Nr 9 (strefa D wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_9', 'Strefa D i inne niezdefiniowane kraje', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 9.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3294', 'Tablica kosztów Nr 9 (strefa D wg cennika Poczty Polskiej)', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_9', '0.35:28.30,0.5:39.80, 1:73.30,2:152.30,3:188.00,4:231.00,5:272.00, 6:312.00,7:354.00,8:398.00,9:439.00,10:481.00, 11:524.00,12:566.00,13:608.00,14:650.00,15:692.00, 16:723.00,17:755.00,18:772.00,19:807.00,20:840.00,30:1321.0', 'Koszty przesyłki dla Obszaru Nr 9 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 9.', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3295', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 9', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_9', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:30', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3296', 'Włączenie modułu', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_STATUS', 'True', 'Czy włączyć moduł Przesyłka Priorytetowa Pobraniowa ?', '6', '0', NULL, '2006-08-23 12:31:44', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3297', 'Grupa VAT', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', NULL, '2006-08-23 12:31:44', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3298', 'Sortowanie', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_SORT_ORDER', '1', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', NULL, '2006-08-23 12:31:44', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3299', 'Kraje Obszaru Nr 1', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_COUNTRIES_1', 'PL', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach obszaru Nr 1.', '6', '0', NULL, '2006-08-23 12:31:44', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3300', 'Tablica kosztów Obszaru Nr 1', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_COST_1', '0.5:9,1:11,2:12.5,5:14,10:21,15:27,20:35,30:40', 'Koszty przesyłki dla Obszaru Nr 1 bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50 w obszarze Nr 1.', '6', '0', NULL, '2006-08-23 12:31:44', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3301', 'Dodatkowy stały koszt obsługi wysyłki do Obszaru Nr 1', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_POB_HANDLING_1', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', NULL, '2006-08-23 12:31:44', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3302', 'Przelew bankowy', 'MODULE_PAYMENT_PL_BANKTRANSFER', 'True', 'Czy chcesz akceptować zapłatę przelewem bankowym ?', '6', '3', NULL, '2006-08-29 14:25:01', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3303', 'Nazwa Banku', 'MODULE_PAYMENT_PL_BANKNAME', 'Tutaj wpisz nazwę banku', 'Nazwa Banku', '6', '1', NULL, '2006-08-29 14:25:01', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3304', 'Nazwa konta', 'MODULE_PAYMENT_PL_ACCOUNT_HOLDER', 'Wpisz nazwę właściciela konta', 'Nazwa właściciela konta', '6', '1', NULL, '2006-08-29 14:25:01', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3305', 'Numer konta', 'MODULE_PAYMENT_PL_IBAN', 'PL00 0000 0000 0000 0000 0000 000', 'Numer Twojego konta', '6', '1', NULL, '2006-08-29 14:25:01', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3306', 'Strefa płatności', 'MODULE_PAYMENT_PL_BANKTRANSFER_ZONE', '0', 'Jeżeli jest wybrana strefa - płatność będzie stosowana tylko do wybranej strefy.', '6', '2', NULL, '2006-08-29 14:25:01', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3307', 'Status zamówienia', 'MODULE_PAYMENT_PL_BANKTRANSFER_ORDER_STATUS_ID', '0', 'Ustaw Status Zamówienia', '6', '0', NULL, '2006-08-29 14:25:01', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3308', 'Kolejność wyświetlania', 'MODULE_PAYMENT_PL_BANKTRANSFER_SORT_ORDER', '2', 'Kolejność wyświetlania.', '6', '0', NULL, '2006-08-29 14:25:01', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3309', 'Znak wodny', 'IMAGE_WATERMARK', 'false', 'Włączenie powoduje wyświetlanie znaku wodnego na obrazkach po ich powiększeniu.<br>Aby funkcja ta działała poprawnie w katalogu /images/ należy umieścić obrazkek w formacie PNG, który będzie tworzył znak wodny.', '4', '15', '2006-08-29 23:34:34', '2003-07-29 13:05:38', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3324', 'Długość kodu weryfikacyjnego.', 'ENTRY_VALIDATION_LENGTH', '5', 'Domyślna długość= 5', '741', '50', '2007-06-23 21:36:44', '2006-07-30 09:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3325', 'Aktywacja zabezpieczeń antyspamowych', 'ACCOUNT_VALIDATION', 'true', 'Włączenie tej opcji powoduje generowanie kodu, który użytkonik musi wprowadzić podczas wypełniania formularzy. Zabezpiecza to przed automatycznym wypełnianiem przez roboty.', '741', '1', '2006-09-10 11:10:30', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3326', 'Formularz rejestracji użytkownika ', 'ACCOUNT_CREATE_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zakładania nowego konta. (OPTIONAL)', '741', '20', '2007-05-18 13:34:43', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3327', 'Formularz edycji konta ', 'ACCOUNT_EDIT_VALIDATION', 'false', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza edycji konta (OPCJONALNY)', '741', '21', '2007-06-23 21:56:48', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3328', 'Formularz zmiany hasła ', 'ACCOUNT_EDIT_PASSWORD_VALIDATION', 'false', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zmiany hasła (OPCJONALNY)', '741', '23', '2007-06-24 19:57:16', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3330', 'Formularz kontakt z nami', 'CONTACT_US_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza kontaktowego (OPCJONALNY)', '741', '24', '2004-08-08 17:00:00', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3331', 'Dane konta bankowego', 'STORE_NAME_BANKACCOUNT', 'Nazwa Twojego Banku
XX-XXXX-XXXX-XXXX-XXXX-XXXX-XXXX

Nazwa właściciela
ul. Ulica Nr domu
Kod, Miejscowość', 'Dane konta bankowego właściciela sklepu, używane na wyświetlanych i drukowanych dokumentach', '1', '4', '2006-09-02 10:45:39', '2003-07-29 13:05:38', NULL, 'tep_cfg_textarea(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3332', 'Formularz pisania recenzji', 'ACCOUNT_REVIEWS_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza wpisywania recenzji o produktach (OPCJONALNY)', '741', '26', '2007-08-07 10:35:44', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3935', 'Formularz zapytania o przedmiot', 'ASKAQUESTION_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zapytania o produkt (OPCJONALNY)', '741', '27', '2007-08-07 10:35:23', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3333', 'Edytor HTML WYSIWYG', 'HTML_WYSIWYG_DISABLE', 'Enable', 'Czy używać edytora HTML podczas wypełniania pól opisowych w formularzach ? Włącz (Enable) lub wyłącz (Disable) edytor HTML', '101', '16', '2006-09-12 11:19:41', '2003-07-24 00:27:47', NULL, 'tep_cfg_select_option(array(\'Enable\', \'Disable\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3351', 'Wyświetlanie zapytań', 'DISPLAY_QUERIES', 'false', 'Wyświetlanie informacji do celów testowych - COOKIE, SESSION, POST, GET w stopce sklepu', '10', '6', '2007-08-29 09:29:37', '2006-09-13 08:40:48', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3406', 'Domyslna klasa podatku', 'DEFAULT_PRODUCT_TAX_CLASS', '3', 'Ustawienie domyslnej klasy podatku podczas dopisywania produktow.', '6', '0', NULL, '2006-11-14 11:43:03', '', 'tep_cfg_pull_down_tax_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3408', 'Moduł Oczekiwane produkty na stronie głównej', 'SHOW_UPCOMINGPRODUCTS', 'true', 'Czy pokazywać moduł Oczekiwane produkty na stronie głównej ?', '99', '23', '2005-12-25 11:41:07', '2004-10-01 12:28:32', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3448', 'Box Porównanie produktów', 'BOX_COMPARE_CART_IS_ON', 'true', 'Czy wyświetlać box Porównanie produktów ?', '400', '51', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3449', 'W której kolumnie box Koszyk ?', 'BOX_COMPARE_CART_COLUMN', 'right', 'W której kolumnie wyświetlać box Porównanie produktów ?', '400', '52', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3450', 'Pokaż pole dostępnosć produktu', 'DISPLAY_AVAILABILITY', 'true', 'Pokazywać pole dostęnosci produktu ?', '300', '19', '2005-11-11 09:39:36', '2003-06-04 05:17:05', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3980', 'Last Database Restore', 'DB_LAST_RESTORE', 'db_test-20090729223722.sql', 'Last database restore file', '6', '0', '0000-00-00 00:00:00', '2009-07-29 22:48:01', '', '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3571', 'Ilość kolumn w module Oczekiwane produkty', 'MAX_DISPLAY_COLUMN_UPCOMING_PRODUCTS', '2', 'Wprowadź maksymalną kolumn w module oczekiwanych produktów do wyświetlenia na stronie głównej.', '8', '24', '2006-06-22 21:40:34', '2006-03-01 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3572', 'Formularz powiadamiania znajomych', 'TELL_FRIEND_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza powiadamiania znajomych o produktach (OPCJONALNY)', '741', '25', '2004-08-08 17:00:00', '2004-08-08 17:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3573', 'Szerokość obrazka', 'ANTI_ROBOT_IMAGE_WIDTH', '100', 'Szerokość obrazka z kodem do wprowadzenia w pixelach.<br><em>O powoduje autoamtyczne dopasowanie.</em>', '741', '51', '2007-06-23 21:00:45', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3574', 'Wysokość obrazka', 'ANTI_ROBOT_IMAGE_HEIGHT', '20', 'Wysokość generowanego obrazka w pixelach.<br><em>Ustawienie wartości 0 spooduje automatyczne dopasowanie.</em>', '741', '52', '2007-06-23 21:00:25', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3575', 'Odstęp pomiędzy literami', 'ANTI_ROBOT_IMAGE_WHITESPACE', '10', 'Odstęp w poziomie pomiędzy generowanymi znakami na obrazku.', '741', '55', '2007-06-23 20:59:24', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3576', 'Margines pionowy', 'ANTI_ROBOT_IMAGE_TOP_MARGIN', '5', 'Margines pionowy pomiędzy generowanymi znakami, a brzegiem obrazka.', '741', '56', '2007-06-23 20:59:33', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3579', 'Wilkość czcionki', 'ANTI_ROBOT_IMAGE_FONT_SIZE', '10', 'Wielkość czcionki ', '741', '59', '2007-06-23 19:09:29', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3580', 'Kolor tła', 'ANTI_ROBOT_IMAGE_BACKGROUND_COLOR', 'FFFFFF', 'Kolor tła generowanego obrazka.', '741', '60', '2007-06-23 19:51:15', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3581', 'Kolor tekstu', 'ANTI_ROBOT_IMAGE_TEXT_COLOR', '000000', 'Kolor generowanego tekstu.', '741', '61', '2007-06-23 20:53:42', '2007-03-15 23:24:48', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3582', 'Filtr - szum', 'ANTI_ROBOT_IMAGE_FILTER_NOISE', 'true', 'Filtr dodający szum na obrazku', '741', '62', '2007-06-23 20:59:48', '2007-03-15 23:24:48', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3583', 'Filtr - rozmazanie', 'ANTI_ROBOT_IMAGE_FILTER_SCATTER', 'false', 'Filtr powdujący rozmazanie czcionek', '741', '63', '2007-03-15 23:24:48', '2007-03-15 23:24:48', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3584', 'Filtr - przeplot', 'ANTI_ROBOT_IMAGE_FILTER_INTERLACE', 'false', 'Filtr dodający przeplot na generowanym obrazku.</em>', '741', '64', '2007-03-15 23:24:48', '2007-03-15 23:24:48', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3585', 'Filtr - szarość', 'ANTI_ROBOT_IMAGE_FILTER_GREYSCALE', 'false', 'Filtr powodujący generowanie obrazka w odcieniach szarości', '741', '65', '2007-03-15 23:24:48', '2007-03-15 23:24:48', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3764', 'Dostawa na koszt sprzedawcy', 'MODULE_SHIPPING_FREEAMOUNT_STATUS', 'True', 'Możesz oferować przesyłkę na koszt dostawcy przy zamówieniu powyżej określoej kwoty', '6', '7', NULL, '2007-04-08 08:47:35', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3753', 'Płatność testowa', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_TEST', 'aktywny', 'Realizacja płatności poprzez bramkę testową', '6', '10', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3754', 'Płacę z PKO BP', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_PKO', 'aktywny', 'Szybkie przelewy PKO BP', '6', '11', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3755', 'mTransfer', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_MTRANSFER', 'aktywny', 'Szybkie przelewy mBank', '6', '12', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3756', 'MultiTransfer', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_MULTITRANSFER', 'aktywny', 'Szybkie przelewy MultiBank', '6', '13', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3757', 'Przelew24', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_PRZELEW24', 'aktywny', 'Szybkie przelewy BZWBK', '6', '14', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3758', 'Karta kredytowa', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_CC', 'aktywny', 'Płatności kartą kredytową poprzez centra autoryzacyjne PolCard, eCard', '6', '15', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3759', 'Płacę z Inteligo', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_INTELIGO', 'aktywny', 'Szybkie przelewy Inteligo', '6', '16', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3760', 'Przelew bankowy', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_TRANSFER', 'aktywny', 'Przelewy bankowe realizowane z innych banków', '6', '17', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3761', 'Płać z Nordea', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_NORDEA', 'aktywny', 'Szybkie przelewy Nordea', '6', '18', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3762', 'Płać z BPH', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_BPH', 'aktywny', 'Szybkie przelewy BPH', '6', '19', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3763', 'Płać z ING', 'MODULE_PAYMENT_PLATNOSCI_PAY_TYPE_ING', 'aktywny', 'Szybkie przelewy ING', '6', '20', NULL, '2007-04-07 09:03:20', NULL, 'tep_cfg_select_option(array(\'aktywny\', \'nieaktywny\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3765', 'Maksymalna waga przesyłki', 'MODULE_SHIPPING_FREEAMOUNT_WEIGHT_MAX', '10', 'Podaj maksymalną wagę przesyłki na koszt sprzedawcy', '6', '8', NULL, '2007-04-08 08:47:35', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3766', 'Włącz wyświetlanie', 'MODULE_SHIPPING_FREEAMOUNT_DISPLAY', 'False', 'Czy chcesz wyświetlać informację, jeżeli zamówenie nie osiągnęło wymaganej kwoty?', '6', '7', NULL, '2007-04-08 08:47:35', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3767', 'Minimalny koszt', 'MODULE_SHIPPING_FREEAMOUNT_AMOUNT', '1000.00', 'Minimalny koszt zamówienia od którego przesyłka jest na koszt sprzedawcy', '6', '8', NULL, '2007-04-08 08:47:35', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3768', 'Wyłącz dla promocji', 'MODULE_SHIPPING_FREEAMOUNT_HIDE_SPECIALS', 'True', 'Czy dostawa na koszt sprzedawcy ma być wyłączona dla produktów objętych promocjami?', '6', '7', NULL, '2007-04-08 08:47:35', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3769', 'Kolejność wyświetlania', 'MODULE_SHIPPING_FREEAMOUNT_SORT_ORDER', '3', 'Kolejność wyświetlania', '6', '0', NULL, '2007-04-08 08:47:35', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3770', 'Strefa dostawy', 'MODULE_SHIPPING_FREEAMOUNT_ZONE', '0', 'Możesz wybrać strefę dla której będzie obowiązywał ten sposób dostawy', '6', '0', NULL, '2007-04-08 08:47:35', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3772', 'Szerokość obrazka', 'PDF_MAX_IMAGE_WIDTH', '100', 'Maksymalna szerokość obrazka w px.', '200', '1', '2005-06-08 20:50:20', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3773', 'Wysokość obrazka', 'PDF_MAX_IMAGE_HEIGHT', '100', 'Maksymalna wysokośćobrazka w px.', '200', '2', '2005-06-09 15:35:12', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3774', 'Proporcje zdjęcia', 'PDF_IMAGE_KEEP_PROPORTIONS', 'true', 'Czy zachować proporcje zdjęcia. 0 = Nie, 1=Tak.', '200', '3', '2005-06-08 20:47:38', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3776', 'Logo sklepu', 'PDF_SHOW_LOGO', 'true', 'Czy wyświetlać logo sklepu na arkuszu PDF ? 0 = Nie, 1 = Tak', '200', '6', '2005-06-08 21:01:41', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3777', 'Ścieżka do pliku logo', 'PDF_STORE_LOGO', 'images/oscgold.gif', 'Podaj ścieżkę do pliku zawierającego logo sklepu.', '200', '7', '2007-09-05 10:29:14', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3778', 'Lokaliacja dokumentów PDF', 'PDF_DOC_PATH', 'pdfdocs/', 'Ścieżka do katalogu w którym będą zapisywane dokumenty PDF: \"pdfdocs/\". Bez początkowego slasha. Upewnij się, że wskazany katalog istnieje i ma ustawione odpowiednie prawa o zapisu!', '200', '7', '2005-06-09 15:37:42', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3779', 'Wyświetlanie czy pobieranie', 'PDF_FILE_REDIRECT', '1', 'Pozwala na ustawienie czy dokument będzie otwierany w przeglądarce czy zapisywany na dysku klienta? 0 = pobieranie, 1 = otwieranie', '200', '7', '2007-09-17 12:49:50', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3780', 'Zapis dokumentu', 'PDF_SAVE_DOCUMENT', '0', 'Czy zapisywać utworzony dokument na serwerze ? Wartości: 0 = Nie, 1 = Tak', '200', '8', '2005-06-16 12:56:32', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3781', 'Tło', 'PDF_SHOW_BACKGROUND', '0', 'Cy arkusz PDF ma posiadać tło? 1 = Tak, 0 = Nie', '200', '9', '2005-06-10 14:52:52', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3782', 'Kolor tła', 'PDF_PAGE_BG_COLOR', '250,250,250', 'Kolor tła akusza PDF. Podaj wartości RGB (Czerwony,Żółty,Niebieski).', '200', '10', '2005-06-10 14:52:30', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3783', 'Kolor nagłówka', 'PDF_HEADER_COLOR_TEXT', '200,0,0', 'Kolor tekstu nagłówka. Podaj wartości RGB (Czerwony,Żółty,Niebieski).', '200', '11', '2005-06-10 14:45:05', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3784', 'Kolor tekstu opisu przedmiotu', 'PDF_BODY_COLOR_TEXT', '0,0,0', 'Kolor tekstu opisu przedmiotu. Podaj wartości RGB (Czerwony,Żółty,Niebieski).', '200', '12', '2005-06-10 14:54:36', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3785', 'Kolor tła nagłówka', 'PDF_HEADER_COLOR_TABLE', '200,200,200', 'TPodaj kolor tła naglówka arkusza PDF. Podaj wartości RGB (Czerwony,Żółty,Niebieski).', '200', '13', '2005-06-10 15:28:11', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3788', 'Produkty w promocji na stronie głównej', 'MAX_DISPLAY_SPECIALS_PRODUCTS_MODULE', '2', 'Maksymalna liczba wyświetlanych produktów w promocji na stronie głównej.', '3', '7', '2007-05-04 09:35:41', '2007-05-04 09:08:03', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3789', 'Moduł PROMOCJE na stronie głównej', 'SHOW_DEFAULTSPECIALS', 'true', 'Czy pokazywać moduł PROMOCJE na stronie głównej ?', '99', '28', '2007-05-29 14:56:47', '2007-05-04 09:08:03', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3790', 'Moduł PROMOCJE na stronie kategorii', 'SHOW_DEFAULTSPECIALS_CATEGORY', 'false', 'Czy pokazywać moduł PROMOCJE na stronie kategorii ?', '99', '28', '2007-05-04 10:32:33', '2007-05-04 09:08:03', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3791', 'Ilość kolumn w module Promocje', 'MAX_DISPLAY_COLUMN_DEFAULT_SPECIALS', '2', 'Wprowadź maksymalną kolumn w module Promocje do wyświetlenia na stronie głównej.', '8', '25', NULL, '2007-05-04 09:08:03', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3920', 'Sposób wyświetlania rabatu i podatku VAT', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TAX', 'Brutto', 'W jaki sposób ma być wyświetlany rabat w podsumowaniu zamówienia', '615', '5', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'Netto\',\'Brutto\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3921', 'Wyłączenie produktów w PROMOCJI', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_EXCLUDE_SPECIALS', 'true', '<b>true</b> - produkty znajdujące się w promocji nie będą objęte kuponem rabatowym<br><b>false</b> - produkty znajdujące się w PROMOCJI będą również objęte kuponem rabatowym', '615', '6', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3922', 'Długość losowego kodu', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_RANDOM_CODE_LENGTH', '6', 'Długość kodu kuponu rabatowego w przypadku automatycznego generowania.', '615', '7', NULL, '2007-06-06 09:40:22', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3923', 'Wyświetlanie rabatu dla każdej grupy podatku', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_LINES', 'false', '<b>true</b> - rabat będzie wyświetlany w osobnej linii dla każdej stawki podatku VATr<br><b>false</b> - rabat będzie wyświetlony łącznie dla wszystkich stawek podatku VAT', '615', '8', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3924', 'Wyświetlanie wartości ujemnej ?', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_ALLOW_NEGATIVE', 'false', 'Ustawienie opcji true powoduje wyświetlenie ujemnej wartości sumy zamówienia jeżeli ktowa rabatu przekracza wartość zamówienia.', '615', '9', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3925', 'Wersje językowe', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_USE_LANGUAGE_FILE', 'true', '<b>true</b> - informacja o udzielonym rabacie w podsumowaniu zamówienia zostanie wyświetlona zgodnie z wybranym w sklepie językiem<br><b>false</b> - informacja o udzielonym rabacie w podsumowaniu zamówienia zostanie wyświetlona zgodnie z poniższą definicj', '615', '10', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3926', 'Display Format for Order Total Line', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_CONFIG', 'Discount Coupon [code] applied', 'Display format for the discount coupon code order total line.<br><br>Variables:<br>[code]<br>[coupon_desc]<br>[discount_amount]<br>[min_order]<br>[number_available]<br>[tax_desc]', '615', '11', NULL, '2007-06-06 09:40:22', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3927', 'Tryb testowy', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DEBUG', 'false', 'Sposób użycia: na stronie potwierdzenia zamówienia, użyj w przeglądarce opcji podgląd źródła. <b>Opcja musi być wyłączona w działającym sklepie.</b>', '615', '12', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3919', 'Pokaż podsumę z rabatem', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_SUBTOTAL', 'true', '<b>true</b> - podsuma w zamówieniu będzie uwzględniała udzielony rabat<br><b>false</b> - podsuma zamówienia nie będzie uwzględniała udzielonego rabatu', '615', '4', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3837', 'Moduł wyświetlania dodatkowych cech', 'PRODINFO_ATTRIBUTE_PLUGIN', 'base', 'Moduł używany do wyświetlania cech produktów na karcie informacyjnej produktu', '888001', '1', '2009-08-04 00:14:19', '2007-05-08 13:51:17', NULL, 'tep_cfg_pull_down_class_files(\'pad_\',');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3838', 'Stan magazynowy', 'PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK', 'True', 'Czy wyświetlać informacje o braku danej opcji produktu w magazynie ?', '888001', '10', NULL, '2007-05-08 13:51:17', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3839', 'Oznaczenie stanów magazynowych', 'PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK', 'Right', 'W którym miejscu wyświetlać informacje o braku danej opcji w magazynie ?', '888001', '20', NULL, '2007-05-08 13:51:17', NULL, 'tep_cfg_select_option(array(\'None\', \'Right\', \'Left\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3840', 'Komunikat o braku opcji', 'PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE', 'True', 'Czy wyświetlać dodatkową informację o braku wybranej opcji w magazynie ?.', '888001', '30', NULL, '2007-05-08 13:51:17', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3841', 'Dodawanie do koszyka', 'PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK', 'True', 'Czy uniemozliwić dodawanie do koszyka towarów, których w wybranej opcji nie ma w magazynie ?', '888001', '40', NULL, '2007-05-08 13:51:17', NULL, 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3843', 'Resampling', 'THUMBNAIL_USE_RESAMPLING', 'true', 'Ustawienie tej wartości na true powoduje użycie resamplingu (transformacja bitmapy polegająca na zmianie liczby jej pikseli) w wyniku czego miniaturki mają lepszą jakośćS. (funkcja ta jest niedostepna w biblitece GD < 2.0.1)', '100', '0', NULL, '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3844', 'True Color', 'THUMBNAIL_TRUE_COLOUR', 'true', 'Tworzenie miniaturek w trybie true colour. Zapewnia lepszą jakość tworzonych miniaturek. Ustaw false, jeżeli posiadasz bibliotekę GD < 2.0.1 lub jeżeli mają być tworzone przeźroczyste obrazki.', '100', '1', NULL, '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3845', 'Tworzenie GIF jako JPG', 'THUMBNAIL_OUTPUT_JPEG', 'false', 'Tworzenie miniaturek w formacie JPG z plików GIF lub PNG. UWAGA ! Przeźroczystość plików źrodłowych zostanie utracona. Wymagana  biblioteka GD > 1.6. Ustaw \'Kolor tła\' w nastepnej opcji jeżeli ta opcja jest ustawiona na true.', '100', '2', NULL, '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3846', 'Kolor tła (GIF jako JPEG)', 'THUMBNAIL_BACKGROUND_MATTE', '255,255,255', 'Ustawienie kolorów tła w formacie RGB podczas tworzenia miniaturek JPG z plików GIF w formacie 255,255,255 (oddzielane przecinkami).', '100', '3', NULL, '2007-05-17 10:54:12', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3847', 'Zapisywanie obrazków na serwerze', 'THUMBNAIL_CACHE_SERVER', 'true', 'Zapisywanie obrazków na serwerze. Zalecana wartość \'true\'. Tworzone miniaturki są zapisywane na dysku powodując mniejsze obciążenie procesora.', '100', '4', '2007-05-17 11:32:04', '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3848', 'Ścieżka do miniaturek', 'THUMBNAIL_PATH', '/thumbnails/', 'Ścieżka do katalogu, w którym mają być zapisywane miniaturki. Jeżeli miniaturki mają być tworzone bezpośrednio w katalogu /images/ należy pozostawić to pole puste. Wprowadź nazwę katalogu, np. \'thumbnails/\' jeżeli miniaturki mają być zapisywane w podkatal', '100', '5', '2007-05-17 10:54:36', '2007-05-17 10:54:12', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3849', 'Cache obrazków w przeglądarce', 'THUMBNAIL_CACHE_BROWSER', 'true', 'Umożliwia zapisywanie obrazków lokalnie w cache przeglądarki. Zapewnia zmniejszenie transferu podczas przeglądania stron. Zalecane ustawienie \'true\'.', '100', '6', '2007-05-17 11:31:57', '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3850', 'Komprecja JPEG', 'THUMBNAIL_JPEG_COMPRESSION', '100', 'Ustawienie jakości generowanych miniaturek w formacie JPEG. Domyślna wartość 100. Wartość zalecana 70.', '100', '7', '2007-05-17 11:32:56', '2007-05-17 10:54:12', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3851', 'Powiększanie obrazków', 'THUMBNAIL_ALLOW_LARGER', 'false', 'Tworzenie miniaturek wówczas, gdy obrazek źródłowy jest mniejszy niż docelowa wielkość miniaturki. Utworzona w ten sposób miniaturka może mieć gorszą jakość.', '100', '8', NULL, '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3852', 'Pokaż oryginał', 'THUMBNAIL_SHOW_ORIGINAL', 'true', 'Jeżeli  \'Powiększanie obrazków\' jest ustawione na false, umożliwia wyświetlanie oryginalnych obrazków.', '100', '9', NULL, '2007-05-17 10:54:12', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3853', 'Pokazuj koszt pakowania', 'MODULE_ORDER_TOTAL_GIFTWRAP_STATUS', 'true', 'Czy chcesz w podsumowaniu wyświetlać koszt pakowania (prezent) ?', '6', '1', NULL, '2007-05-18 11:11:18', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3854', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_GIFTWRAP_SORT_ORDER', '4', 'Kolejność wyświetlania', '6', '2', NULL, '2007-05-18 11:11:18', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3855', 'Podatek', 'MODULE_ORDER_TOTAL_GIFTWRAP_TAX_CLASS', '0', 'Stawka podatku doliczana do kosztów pakowania', '6', '6', NULL, '2007-05-18 11:11:18', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3916', 'Kupony rabatowe', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_STATUS', 'true', 'Czy wyświetlać kupony rabatowe ?', '615', '1', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3917', 'Kolejność wyświetlania', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_SORT_ORDER', '1', 'Kolejność w jakiej zostanie wyświetlony rabat wynikający z kuponu rabatowego. Wartość jest wyświetlana we wszelkich podsumowaniach zamówienia.', '615', '2', NULL, '2007-06-06 09:40:22', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3918', 'Wyświetlaj rabat ze znakiem minus (-)', 'MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TYPE', 'false', '<b>true</b> - rabat zostanie wyświetlony ze znakiem minus (-)<br><b>false</b> - rabat zostanie wyświetlony bez znaku minus (-)', '615', '3', NULL, '2007-06-06 09:40:22', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'), ');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3930', 'Użyj obrazków jako cechy', 'OPTIONS_AS_IMAGES_ENABLED', 'false', 'Włączenie opcji umożliwia wykorzystanie obrazków jako cechy dodatkowe produktów', '888001', '50', '2007-10-10 15:05:39', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3931', 'Ilość obrazków w wierszu', 'OPTIONS_IMAGES_NUMBER_PER_ROW', '3', 'Maksymalna ilość obrazków wyswietlanych w jednym wierszu', '888001', '51', '2007-10-10 14:57:50', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3932', 'Szerokość obrazka', 'OPTIONS_IMAGES_WIDTH', '50', 'Szerokość obrazka wyświetlanego jako cecha produktu', '888001', '52', '2007-07-03 12:11:10', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3933', 'Wysokość obrazka', 'OPTIONS_IMAGES_HEIGHT', '50', 'Wysokość obrazka wyświetlanego jako cecha produktu', '888001', '53', '2007-07-03 12:11:16', '0000-00-00 00:00:00', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3934', 'Powiększanie obrazka', 'OPTIONS_IMAGES_CLICK_ENLARGE', 'true', 'Czy włączyć możliwość powiększania obrazka cechy produktu ?', '888001', '54', '2007-10-10 15:02:22', '0000-00-00 00:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3775', 'Znak wodny', 'PDF_SHOW_WATERMARK', 'true', 'Czy drukowac znak wodny na arkuszu PDF ? 0 = Nie, 1 = Tak', '200', '5', '2007-09-17 12:00:40', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3943', 'Czcionka używana na wydrukach', 'PDF_INV_CORE_FONT', 'arial', 'Jaka czcionka ma być używana na arkuszach PDF.<br />Arial<br />Times<br />Courier<br />Helvetica', '200', '15', '2007-07-25 20:00:00', '2007-07-25 20:00:00', NULL, 'tep_cfg_select_option(array(\'arial\', \'times\',\'courier\',\'helvetica\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3944', 'Kolor znaku wodnego', 'PAGE_WATERMARK_COLOR', '236,245,255', 'Kolor w jakim ma byc drukowany znak wodny', '200', '14', '2007-07-25 20:00:00', '2007-07-25 20:00:00', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3945', 'Data drukowana na zamówieniu', 'PDF_INV_DATE_TODAY', 'order', 'Jaka data ma być drukowana na zamówieniu?<br>Mozna wybrać datę bieżącą wydruku lub datę złożenia zamówienia [ Domyślnie = bieżąca ]', '200', '17', '2007-09-17 12:28:41', '2007-07-25 20:00:00', '', 'tep_cfg_select_option(array(\'today\', \'order\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3946', 'Współczynnik korekcji', 'PDF_INV_IMG_CORRECTION', '0.3526', 'Wspolczynnik poprawiajacy jakosc drukowanych obrazkow', '200', '4', '2007-07-26 16:08:34', '0000-00-00 00:00:00', NULL, '');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3970', 'Box Płatności.pl', 'BOX_PLATNOSCI_IS_ON', 'false', 'Czy wyświetlać box Płatności.pl ?', '400', '53', '2007-10-26 14:07:36', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3971', 'W której kolumnie box Płatności.pl ?', 'BOX_PLATNOSCI_COLUMN', 'right', 'W której kolumnie wyświetlać box Płatności.pl?', '400', '54', '2007-10-26 14:06:34', '0000-00-00 00:00:00', '', 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3974', 'Moduł promocji Polecony-Nagrodzony', 'PROMO_POLECONY_STATUS', 'false', 'Czy włączyć moduł promocji Polecony-Nagrodzony - UWAGA !!! do poprawnego działania modułu musi być również włączony moduł Kuponów rabatowch (w menu Moduły/Podsumowanie zamówienia)', '150', '1', '2007-11-21 11:08:47', '2007-10-31 08:51:01', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3975', 'Okres ważności kuponu rabatowego', 'PROMO_POLECONY_OKRES', '60', 'Okres ważności kuponu rabatowego przyznanego w promocji Polecony-Nagrodzony', '150', '2', '2006-04-05 09:15:16', '2007-10-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3976', 'Kwota rabatu', 'PROMO_POLECONY_RABAT', '10.00', 'Kwota rabatu przyznawanego w ramach promocji Polecony-Nagrodzony', '150', '3', '2006-04-05 09:15:16', '2007-10-29 13:05:38', NULL, NULL);
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3977', 'Wyświetlanie boxu promocji Polecony-Nagrodzony', 'BOX_POLECONY_COLUMN', 'left', 'W której kolumnie ma być wyświetlany box informacyjny promocji Polecony-Nagrodzony', '150', '4', '2007-10-31 09:15:16', '2007-10-31 09:05:38', NULL, 'tep_cfg_select_option(array(\'left\', \'right\'),');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3978', 'Status zamówienia do promocji Polecony-Nagrodzony', 'PROMO_POLECONY_ORDER_STATUS_ID', '4', 'Ustaw status zamówienia, który upoważnia do polecenia sklepu w promocji Polecony-Nagrodzony', '150', '5', '2007-10-31 12:53:52', '2007-10-31 09:05:38', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses(');
insert into configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3979', 'Formularz promocji Polecony-Nagrodzony', 'POLECONY_VALIDATION', 'true', 'Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza polecającego sklep w promocji Polecony-Nagrodzony (OPCJONALNY)', '741', '26', '2007-10-31 09:00:00', '2007-10-31 09:00:00', NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
drop table if exists configuration_group;
create table configuration_group (
  configuration_group_id int(11) not null ,
  configuration_group_title varchar(64) not null ,
  configuration_group_description varchar(255) not null ,
  sort_order int(5) ,
  visible int(1) default '1' ,
  PRIMARY KEY (configuration_group_id)
);

insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('101', 'Ustawienia sklepu', 'Globalne ustawienia parametrów sklepu', '1', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('1', 'Twój sklep', 'Ogólne informacje o sklepie', '1', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('401', 'Ustawienia dla hurtowni', 'Konfiguracja sklepu do obsługi hurtowni', '2', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('2', 'Wartości minimalne', 'Minimalne wartości funkcji i danych', '3', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('3', 'Wartości maksymalne', 'Maksymalne wartości fukcji i danych', '4', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('4', 'Obrazki', 'Parametry obrazków', '5', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('5', 'Klienci', 'Konfiguracja kont klientów', '6', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('6', 'Opcje modułów', 'Niewidoczne', '7', '0');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('7', 'Dostawa/Pakowanie', 'Opcje przesyłek sklepu', '8', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('8', 'Wyświetlanie produktów', 'Konfiguracja wyświetlania produktów', '9', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('9', 'Magazyn', 'Konfiguracja dostępnośc produktów', '10', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('10', 'Logi', 'Konfigruacja logowania', '12', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('12', 'Opcje E-mail', 'Ogólne ustawienia wysyłania poczty oraz listów w formacie HTML', '14', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('13', 'Pobieranie', 'Konfiguracja produktów, które można pobrać', '15', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('14', 'Kompresja GZip', 'Konfiguracja kompresji GZip', '16', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('15', 'Sesje', 'Konfiguracja sesji', '17', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('300', 'Wyświetlanie pól w szybkich zmianach danych o produktach', 'Ustawienia modułu wprowadzania szybkich zmian w produktach', '3', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('99', 'Ustawienia wyglądu sklepu', 'Moduł definiowania ustawień wyglądu sklepu', '1', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('400', 'Zarządzanie boxami', 'Konfiguracja kolumn i zarządzanie wyświetlaniem boxów', '2', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('29', 'Katalog wszystkich produktów', 'Wyświetlanie listy wszystkich produktów', '29', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('26229', 'Ustawienia Cache', 'Konfiguracja pamięci podręcznej', '13', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('0', 'Wyłączenie sklepu', 'Wyłączenie dostępu do sklepu dla klientów ze względów administracyjnych', '901', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('741', 'Anti Spambot ', 'Zabezpieczenie formularzy przed wysyłaniem maili przez roboty', '300', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('403', 'SEO Przyjazne adresy URL', 'Konfiguracja wyświetlania adresów poprawiających pozycję sklepu w wyszukiwarkach', '11', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('200', 'Konfiguracja wydruków PDF', 'Konfiguracja ustawień arkusza PDF', '200', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('888001', 'Cechy produktów', 'Ustawienia parametrów wyświetlania i zakupów produktów z dodatkoymi cechami', '8', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('100', 'Miniaturki zdjęć', 'Ustawienia tworzenia miniaturek obrazków', '5', '1');
insert into configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('150', 'Promocja Polecony-Nagrodzony', 'Ustawienia dla promocji Polecony_Nagrodzony', '1', '1');
drop table if exists counter;
create table counter (
  startdate char(8) ,
  counter int(12) default '0' not null ,
  PRIMARY KEY (counter),
  KEY startdate (startdate)
);

insert into counter (startdate, counter) values ('20060527', '3892');
drop table if exists counter_history;
create table counter_history (
  month char(8) ,
  counter int(12) 
);

drop table if exists countries;
create table countries (
  countries_id int(11) not null auto_increment,
  countries_name varchar(64) not null ,
  countries_iso_code_2 char(2) not null ,
  countries_iso_code_3 char(3) not null ,
  address_format_id int(11) not null ,
  PRIMARY KEY (countries_id),
  KEY countries_name (countries_name)
);

insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('1', 'Afghanistan', 'AF', 'AFG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('2', 'Albania', 'AL', 'ALB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('3', 'Algeria', 'DZ', 'DZA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('4', 'American Samoa', 'AS', 'ASM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('5', 'Andorra', 'AD', 'AND', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('6', 'Angola', 'AO', 'AGO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('7', 'Anguilla', 'AI', 'AIA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('8', 'Antarctica', 'AQ', 'ATA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('9', 'Antigua and Barbuda', 'AG', 'ATG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('10', 'Argentina', 'AR', 'ARG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('11', 'Armenia', 'AM', 'ARM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('12', 'Aruba', 'AW', 'ABW', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('13', 'Australia', 'AU', 'AUS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('14', 'Austria', 'AT', 'AUT', '5');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('15', 'Azerbaijan', 'AZ', 'AZE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('16', 'Bahamas', 'BS', 'BHS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('17', 'Bahrain', 'BH', 'BHR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('18', 'Bangladesh', 'BD', 'BGD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('19', 'Barbados', 'BB', 'BRB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('20', 'Belarus', 'BY', 'BLR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('21', 'Belgium', 'BE', 'BEL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('22', 'Belize', 'BZ', 'BLZ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('23', 'Benin', 'BJ', 'BEN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('24', 'Bermuda', 'BM', 'BMU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('25', 'Bhutan', 'BT', 'BTN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('26', 'Bolivia', 'BO', 'BOL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('27', 'Bosnia and Herzegowina', 'BA', 'BIH', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('28', 'Botswana', 'BW', 'BWA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('29', 'Bouvet Island', 'BV', 'BVT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('30', 'Brazil', 'BR', 'BRA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('31', 'British Indian Ocean Territory', 'IO', 'IOT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('32', 'Brunei Darussalam', 'BN', 'BRN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('33', 'Bulgaria', 'BG', 'BGR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('34', 'Burkina Faso', 'BF', 'BFA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('35', 'Burundi', 'BI', 'BDI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('36', 'Cambodia', 'KH', 'KHM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('37', 'Cameroon', 'CM', 'CMR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('38', 'Canada', 'CA', 'CAN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('39', 'Cape Verde', 'CV', 'CPV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('40', 'Cayman Islands', 'KY', 'CYM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('41', 'Central African Republic', 'CF', 'CAF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('42', 'Chad', 'TD', 'TCD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('43', 'Chile', 'CL', 'CHL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('44', 'China', 'CN', 'CHN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('45', 'Christmas Island', 'CX', 'CXR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('46', 'Cocos (Keeling) Islands', 'CC', 'CCK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('47', 'Colombia', 'CO', 'COL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('48', 'Comoros', 'KM', 'COM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('49', 'Congo', 'CG', 'COG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('50', 'Cook Islands', 'CK', 'COK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('51', 'Costa Rica', 'CR', 'CRI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('52', 'Cote D\'Ivoire', 'CI', 'CIV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('53', 'Croatia', 'HR', 'HRV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('54', 'Cuba', 'CU', 'CUB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('55', 'Cyprus', 'CY', 'CYP', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('56', 'Czech Republic', 'CZ', 'CZE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('57', 'Denmark', 'DK', 'DNK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('58', 'Djibouti', 'DJ', 'DJI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('59', 'Dominica', 'DM', 'DMA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('60', 'Dominican Republic', 'DO', 'DOM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('61', 'East Timor', 'TP', 'TMP', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('62', 'Ecuador', 'EC', 'ECU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('63', 'Egypt', 'EG', 'EGY', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('64', 'El Salvador', 'SV', 'SLV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('65', 'Equatorial Guinea', 'GQ', 'GNQ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('66', 'Eritrea', 'ER', 'ERI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('67', 'Estonia', 'EE', 'EST', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('68', 'Ethiopia', 'ET', 'ETH', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('69', 'Falkland Islands (Malvinas)', 'FK', 'FLK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('70', 'Faroe Islands', 'FO', 'FRO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('71', 'Fiji', 'FJ', 'FJI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('72', 'Finland', 'FI', 'FIN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('73', 'France', 'FR', 'FRA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('74', 'France, Metropolitan', 'FX', 'FXX', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('75', 'French Guiana', 'GF', 'GUF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('76', 'French Polynesia', 'PF', 'PYF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('77', 'French Southern Territories', 'TF', 'ATF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('78', 'Gabon', 'GA', 'GAB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('79', 'Gambia', 'GM', 'GMB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('80', 'Georgia', 'GE', 'GEO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('81', 'Germany', 'DE', 'DEU', '5');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('82', 'Ghana', 'GH', 'GHA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('83', 'Gibraltar', 'GI', 'GIB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('84', 'Greece', 'GR', 'GRC', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('85', 'Greenland', 'GL', 'GRL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('86', 'Grenada', 'GD', 'GRD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('87', 'Guadeloupe', 'GP', 'GLP', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('88', 'Guam', 'GU', 'GUM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('89', 'Guatemala', 'GT', 'GTM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('90', 'Guinea', 'GN', 'GIN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('91', 'Guinea-bissau', 'GW', 'GNB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('92', 'Guyana', 'GY', 'GUY', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('93', 'Haiti', 'HT', 'HTI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('94', 'Heard and Mc Donald Islands', 'HM', 'HMD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('95', 'Honduras', 'HN', 'HND', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('96', 'Hong Kong', 'HK', 'HKG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('97', 'Hungary', 'HU', 'HUN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('98', 'Iceland', 'IS', 'ISL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('99', 'India', 'IN', 'IND', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('100', 'Indonesia', 'ID', 'IDN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('101', 'Iran (Islamic Republic of)', 'IR', 'IRN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('102', 'Iraq', 'IQ', 'IRQ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('103', 'Ireland', 'IE', 'IRL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('104', 'Israel', 'IL', 'ISR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('105', 'Italy', 'IT', 'ITA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('106', 'Jamaica', 'JM', 'JAM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('107', 'Japan', 'JP', 'JPN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('108', 'Jordan', 'JO', 'JOR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('109', 'Kazakhstan', 'KZ', 'KAZ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('110', 'Kenya', 'KE', 'KEN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('111', 'Kiribati', 'KI', 'KIR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('112', 'Korea, Democratic People\'s Republic of', 'KP', 'PRK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('113', 'Korea, Republic of', 'KR', 'KOR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('114', 'Kuwait', 'KW', 'KWT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('115', 'Kyrgyzstan', 'KG', 'KGZ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('116', 'Lao People\'s Democratic Republic', 'LA', 'LAO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('117', 'Latvia', 'LV', 'LVA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('118', 'Lebanon', 'LB', 'LBN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('119', 'Lesotho', 'LS', 'LSO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('120', 'Liberia', 'LR', 'LBR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('121', 'Libyan Arab Jamahiriya', 'LY', 'LBY', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('122', 'Liechtenstein', 'LI', 'LIE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('123', 'Lithuania', 'LT', 'LTU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('124', 'Luxembourg', 'LU', 'LUX', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('125', 'Macau', 'MO', 'MAC', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('126', 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('127', 'Madagascar', 'MG', 'MDG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('128', 'Malawi', 'MW', 'MWI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('129', 'Malaysia', 'MY', 'MYS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('130', 'Maldives', 'MV', 'MDV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('131', 'Mali', 'ML', 'MLI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('132', 'Malta', 'MT', 'MLT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('133', 'Marshall Islands', 'MH', 'MHL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('134', 'Martinique', 'MQ', 'MTQ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('135', 'Mauritania', 'MR', 'MRT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('136', 'Mauritius', 'MU', 'MUS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('137', 'Mayotte', 'YT', 'MYT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('138', 'Mexico', 'MX', 'MEX', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('139', 'Micronesia, Federated States of', 'FM', 'FSM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('140', 'Moldova, Republic of', 'MD', 'MDA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('141', 'Monaco', 'MC', 'MCO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('142', 'Mongolia', 'MN', 'MNG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('143', 'Montserrat', 'MS', 'MSR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('144', 'Morocco', 'MA', 'MAR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('145', 'Mozambique', 'MZ', 'MOZ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('146', 'Myanmar', 'MM', 'MMR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('147', 'Namibia', 'NA', 'NAM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('148', 'Nauru', 'NR', 'NRU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('149', 'Nepal', 'NP', 'NPL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('150', 'Netherlands', 'NL', 'NLD', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('151', 'Netherlands Antilles', 'AN', 'ANT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('152', 'New Caledonia', 'NC', 'NCL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('153', 'New Zealand', 'NZ', 'NZL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('154', 'Nicaragua', 'NI', 'NIC', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('155', 'Niger', 'NE', 'NER', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('156', 'Nigeria', 'NG', 'NGA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('157', 'Niue', 'NU', 'NIU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('158', 'Norfolk Island', 'NF', 'NFK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('159', 'Northern Mariana Islands', 'MP', 'MNP', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('160', 'Norway', 'NO', 'NOR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('161', 'Oman', 'OM', 'OMN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('162', 'Pakistan', 'PK', 'PAK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('163', 'Palau', 'PW', 'PLW', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('164', 'Panama', 'PA', 'PAN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('165', 'Papua New Guinea', 'PG', 'PNG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('166', 'Paraguay', 'PY', 'PRY', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('167', 'Peru', 'PE', 'PER', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('168', 'Philippines', 'PH', 'PHL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('169', 'Pitcairn', 'PN', 'PCN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('170', 'Poland', 'PL', 'POL', '5');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('171', 'Portugal', 'PT', 'PRT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('172', 'Puerto Rico', 'PR', 'PRI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('173', 'Qatar', 'QA', 'QAT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('174', 'Reunion', 'RE', 'REU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('175', 'Romania', 'RO', 'ROM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('176', 'Russian Federation', 'RU', 'RUS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('177', 'Rwanda', 'RW', 'RWA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('178', 'Saint Kitts and Nevis', 'KN', 'KNA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('179', 'Saint Lucia', 'LC', 'LCA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('180', 'Saint Vincent and the Grenadines', 'VC', 'VCT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('181', 'Samoa', 'WS', 'WSM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('182', 'San Marino', 'SM', 'SMR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('183', 'Sao Tome and Principe', 'ST', 'STP', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('184', 'Saudi Arabia', 'SA', 'SAU', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('185', 'Senegal', 'SN', 'SEN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('186', 'Seychelles', 'SC', 'SYC', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('187', 'Sierra Leone', 'SL', 'SLE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('188', 'Singapore', 'SG', 'SGP', '4');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('189', 'Slovakia (Slovak Republic)', 'SK', 'SVK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('190', 'Slovenia', 'SI', 'SVN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('191', 'Solomon Islands', 'SB', 'SLB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('192', 'Somalia', 'SO', 'SOM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('193', 'South Africa', 'ZA', 'ZAF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('194', 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('195', 'Spain', 'ES', 'ESP', '3');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('196', 'Sri Lanka', 'LK', 'LKA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('197', 'St. Helena', 'SH', 'SHN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('198', 'St. Pierre and Miquelon', 'PM', 'SPM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('199', 'Sudan', 'SD', 'SDN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('200', 'Suriname', 'SR', 'SUR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('201', 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('202', 'Swaziland', 'SZ', 'SWZ', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('203', 'Sweden', 'SE', 'SWE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('204', 'Switzerland', 'CH', 'CHE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('205', 'Syrian Arab Republic', 'SY', 'SYR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('206', 'Taiwan', 'TW', 'TWN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('207', 'Tajikistan', 'TJ', 'TJK', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('208', 'Tanzania, United Republic of', 'TZ', 'TZA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('209', 'Thailand', 'TH', 'THA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('210', 'Togo', 'TG', 'TGO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('211', 'Tokelau', 'TK', 'TKL', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('212', 'Tonga', 'TO', 'TON', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('213', 'Trinidad and Tobago', 'TT', 'TTO', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('214', 'Tunisia', 'TN', 'TUN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('215', 'Turkey', 'TR', 'TUR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('216', 'Turkmenistan', 'TM', 'TKM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('217', 'Turks and Caicos Islands', 'TC', 'TCA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('218', 'Tuvalu', 'TV', 'TUV', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('219', 'Uganda', 'UG', 'UGA', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('220', 'Ukraine', 'UA', 'UKR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('221', 'United Arab Emirates', 'AE', 'ARE', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('222', 'United Kingdom', 'GB', 'GBR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('223', 'United States', 'US', 'USA', '2');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('224', 'United States Minor Outlying Islands', 'UM', 'UMI', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('225', 'Uruguay', 'UY', 'URY', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('226', 'Uzbekistan', 'UZ', 'UZB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('227', 'Vanuatu', 'VU', 'VUT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('228', 'Vatican City State (Holy See)', 'VA', 'VAT', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('229', 'Venezuela', 'VE', 'VEN', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('230', 'Viet Nam', 'VN', 'VNM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('231', 'Virgin Islands (British)', 'VG', 'VGB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('232', 'Virgin Islands (U.S.)', 'VI', 'VIR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('233', 'Wallis and Futuna Islands', 'WF', 'WLF', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('234', 'Western Sahara', 'EH', 'ESH', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('235', 'Yemen', 'YE', 'YEM', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('236', 'Yugoslavia', 'YU', 'YUG', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('237', 'Zaire', 'ZR', 'ZAR', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('238', 'Zambia', 'ZM', 'ZMB', '1');
insert into countries (countries_id, countries_name, countries_iso_code_2, countries_iso_code_3, address_format_id) values ('239', 'Zimbabwe', 'ZW', 'ZWE', '1');
drop table if exists currencies;
create table currencies (
  currencies_id int(11) not null auto_increment,
  title varchar(32) not null ,
  code char(3) not null ,
  symbol_left varchar(12) ,
  symbol_right varchar(12) ,
  decimal_point char(1) ,
  thousands_point char(1) ,
  decimal_places char(1) ,
  value float(13,8) ,
  last_updated datetime ,
  PRIMARY KEY (currencies_id)
);

insert into currencies (currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value, last_updated) values ('1', 'Polski Złoty', 'PLN', '', 'zł', ',', '.', '2', '1.00000000', '2006-05-27 18:45:46');
insert into currencies (currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value, last_updated) values ('2', 'Euro', 'EUR', '', 'Euro', '.', ',', '2', '0.25474101', '2006-05-27 18:45:46');
drop table if exists customers;
create table customers (
  customers_id int(11) not null auto_increment,
  customers_gender char(1) not null ,
  customers_firstname varchar(32) not null ,
  customers_lastname varchar(32) not null ,
  customers_dob datetime default '0000-00-00 00:00:00' not null ,
  customers_email_address varchar(96) not null ,
  customers_default_address_id int(11) ,
  customers_telephone varchar(32) not null ,
  customers_fax varchar(32) ,
  customers_password varchar(40) not null ,
  customers_newsletter char(1) ,
  customer_discount decimal(5,2) default '0.00' not null ,
  customers_discount decimal(8,2) default '0.00' not null ,
  customers_groups_id int(11) default '1' not null ,
  customers_status int(11) default '0' not null ,
  customers_agreement char(1) not null ,
  customers_polecony int(11) default '0' not null ,
  customers_polecajacy_id int(11) not null ,
  PRIMARY KEY (customers_id),
  KEY customers_email_address (customers_email_address),
  KEY customers_password (customers_password),
  KEY customers_firstname (customers_firstname),
  KEY customers_lastname (customers_lastname)
);

insert into customers (customers_id, customers_gender, customers_firstname, customers_lastname, customers_dob, customers_email_address, customers_default_address_id, customers_telephone, customers_fax, customers_password, customers_newsletter, customer_discount, customers_discount, customers_groups_id, customers_status, customers_agreement, customers_polecony, customers_polecajacy_id) values ('12', 'm', 'Test', 'Test', '0000-00-00 00:00:00', 'user@demo.pl', '14', 'xxx xxx xxx', '', 'e55fb33ea33ef7d722b717be1d203227:6d', '0', '0.00', '0.00', '1', '1', '1', '0', '0');
drop table if exists customers_basket;
create table customers_basket (
  customers_basket_id int(11) not null auto_increment,
  customers_id int(11) not null ,
  products_id tinytext not null ,
  customers_basket_quantity int(2) not null ,
  final_price decimal(15,4) not null ,
  customers_basket_date_added char(8) ,
  PRIMARY KEY (customers_basket_id),
  KEY customers_id (customers_id)
);

drop table if exists customers_basket_attributes;
create table customers_basket_attributes (
  customers_basket_attributes_id int(11) not null auto_increment,
  customers_id int(11) not null ,
  products_id tinytext not null ,
  products_options_id int(11) not null ,
  products_options_value_id int(11) not null ,
  PRIMARY KEY (customers_basket_attributes_id)
);

drop table if exists customers_groups;
create table customers_groups (
  customers_groups_id int(11) not null auto_increment,
  customers_groups_name varchar(32) not null ,
  customers_groups_discount decimal(8,2) default '0.00' not null ,
  customers_groups_price int(11) default '1' not null ,
  customers_groups_min_amount decimal(8,2) default '0.00' not null ,
  PRIMARY KEY (customers_groups_id)
);

insert into customers_groups (customers_groups_id, customers_groups_name, customers_groups_discount, customers_groups_price, customers_groups_min_amount) values ('1', 'Domyślnie', '0.00', '1', '40.00');
insert into customers_groups (customers_groups_id, customers_groups_name, customers_groups_discount, customers_groups_price, customers_groups_min_amount) values ('2', 'Sprzedaż hurtowa', '-10.00', '1', '0.00');
drop table if exists customers_info;
create table customers_info (
  customers_info_id int(11) not null ,
  customers_info_date_of_last_logon datetime ,
  customers_info_number_of_logons int(5) ,
  customers_info_date_account_created datetime ,
  customers_info_date_account_last_modified datetime ,
  global_product_notifications int(1) default '0' ,
  PRIMARY KEY (customers_info_id),
  KEY customers_info_number_of_logons (customers_info_number_of_logons)
);

insert into customers_info (customers_info_id, customers_info_date_of_last_logon, customers_info_number_of_logons, customers_info_date_account_created, customers_info_date_account_last_modified, global_product_notifications) values ('12', '2007-07-04 14:21:15', '3', '2006-11-21 19:24:26', '2009-07-29 22:48:23', '0');
drop table if exists discount_coupons;
create table discount_coupons (
  coupons_id varchar(32) not null ,
  coupons_description varchar(64) not null ,
  coupons_discount_amount decimal(15,12) default '0.000000000000' not null ,
  coupons_discount_type enum('fixed','percent','shipping') default 'percent' not null ,
  coupons_date_start datetime ,
  coupons_date_end datetime ,
  coupons_max_use int(3) default '0' not null ,
  coupons_min_order decimal(15,4) default '0.0000' not null ,
  coupons_min_order_type enum('price','quantity') default 'price' not null ,
  coupons_number_available int(3) default '0' not null ,
  PRIMARY KEY (coupons_id)
);

insert into discount_coupons (coupons_id, coupons_description, coupons_discount_amount, coupons_discount_type, coupons_date_start, coupons_date_end, coupons_max_use, coupons_min_order, coupons_min_order_type, coupons_number_available) values ('NYLHXW', 'Drugi testowy kupon', '50.000000000000', 'fixed', NULL, NULL, '0', '200.0000', 'price', '5');
insert into discount_coupons (coupons_id, coupons_description, coupons_discount_amount, coupons_discount_type, coupons_date_start, coupons_date_end, coupons_max_use, coupons_min_order, coupons_min_order_type, coupons_number_available) values ('XYXTB4', 'Trzeci testowy kupon', '0.100000000000', 'percent', NULL, NULL, '0', '0.0000', 'price', '0');
insert into discount_coupons (coupons_id, coupons_description, coupons_discount_amount, coupons_discount_type, coupons_date_start, coupons_date_end, coupons_max_use, coupons_min_order, coupons_min_order_type, coupons_number_available) values ('W87JB7', 'Testowy kupon', '81.967213000000', 'fixed', NULL, NULL, '0', '100.0000', 'price', '1000');
drop table if exists discount_coupons_to_categories;
create table discount_coupons_to_categories (
  coupons_id varchar(32) not null ,
  categories_id int(11) default '0' not null ,
  PRIMARY KEY (coupons_id, categories_id)
);

drop table if exists discount_coupons_to_customers;
create table discount_coupons_to_customers (
  coupons_id varchar(32) not null ,
  customers_id int(11) default '0' not null ,
  PRIMARY KEY (coupons_id, customers_id)
);

drop table if exists discount_coupons_to_manufacturers;
create table discount_coupons_to_manufacturers (
  coupons_id varchar(32) not null ,
  manufacturers_id int(11) default '0' not null ,
  PRIMARY KEY (coupons_id, manufacturers_id)
);

insert into discount_coupons_to_manufacturers (coupons_id, manufacturers_id) values ('NYLHXW', '1');
insert into discount_coupons_to_manufacturers (coupons_id, manufacturers_id) values ('NYLHXW', '2');
drop table if exists discount_coupons_to_orders;
create table discount_coupons_to_orders (
  discount_coupons_to_orders_id int(11) not null auto_increment,
  coupons_id varchar(32) ,
  orders_id int(11) default '0' ,
  PRIMARY KEY (discount_coupons_to_orders_id),
  KEY coupons_id (coupons_id)
);

insert into discount_coupons_to_orders (discount_coupons_to_orders_id, coupons_id, orders_id) values ('1', 'W87JB7', '33');
drop table if exists discount_coupons_to_products;
create table discount_coupons_to_products (
  coupons_id varchar(32) not null ,
  products_id int(11) default '0' not null ,
  PRIMARY KEY (coupons_id, products_id)
);

drop table if exists discount_coupons_to_zones;
create table discount_coupons_to_zones (
  coupons_id varchar(32) not null ,
  geo_zone_id int(11) default '0' not null ,
  PRIMARY KEY (coupons_id, geo_zone_id)
);

drop table if exists featured;
create table featured (
  featured_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  featured_date_added datetime ,
  featured_last_modified datetime ,
  expires_date datetime ,
  date_status_change datetime ,
  status int(11) default '1' ,
  PRIMARY KEY (featured_id),
  KEY products_id (products_id),
  KEY status (status)
);

insert into featured (featured_id, products_id, featured_date_added, featured_last_modified, expires_date, date_status_change, status) values ('2', '3', '2006-05-27 22:20:10', NULL, NULL, NULL, '1');
insert into featured (featured_id, products_id, featured_date_added, featured_last_modified, expires_date, date_status_change, status) values ('3', '5', '2007-05-29 12:44:27', NULL, NULL, NULL, '1');
drop table if exists geo_zones;
create table geo_zones (
  geo_zone_id int(11) not null auto_increment,
  geo_zone_name varchar(32) not null ,
  geo_zone_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime not null ,
  PRIMARY KEY (geo_zone_id)
);

insert into geo_zones (geo_zone_id, geo_zone_name, geo_zone_description, last_modified, date_added) values ('1', 'Polska i kraje EU', 'Obowiązujący podatek VAT', '2007-07-13 13:08:28', '2006-05-27 18:49:12');
insert into geo_zones (geo_zone_id, geo_zone_name, geo_zone_description, last_modified, date_added) values ('3', 'Polska', 'Polska', NULL, '2007-07-13 13:08:57');
drop table if exists languages;
create table languages (
  languages_id int(11) not null auto_increment,
  name varchar(32) not null ,
  code char(2) not null ,
  image varchar(64) ,
  directory varchar(32) ,
  sort_order int(3) ,
  PRIMARY KEY (languages_id),
  KEY sort_order (sort_order)
);

insert into languages (languages_id, name, code, image, directory, sort_order) values ('1', 'Polski', 'pl', 'icon.gif', 'polish', '1');
drop table if exists manudiscount;
create table manudiscount (
  manudiscount_id int(11) not null auto_increment,
  manudiscount_name varchar(128) not null ,
  manudiscount_groups_id int(11) default '0' not null ,
  manudiscount_customers_id int(11) default '0' not null ,
  manudiscount_manufacturers_id int(11) default '0' not null ,
  manudiscount_discount decimal(8,2) default '0.00' not null ,
  PRIMARY KEY (manudiscount_id),
  KEY manudiscount_groups_id (manudiscount_groups_id)
);

drop table if exists manufacturers;
create table manufacturers (
  manufacturers_id int(11) not null auto_increment,
  manufacturers_name varchar(32) not null ,
  manufacturers_image varchar(64) ,
  date_added datetime ,
  last_modified datetime ,
  PRIMARY KEY (manufacturers_id),
  KEY manufacturers_name (manufacturers_name)
);

insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('1', 'Kodak', '', '2006-05-27 19:06:02', '2006-05-27 19:13:51');
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('2', 'Canon', 'default.gif', '2006-05-27 19:06:02', '2007-11-20 14:09:36');
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('3', 'Olympus', '', '2006-05-27 19:26:36', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('4', 'Nikon', '', '2006-05-27 19:27:07', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('5', 'Panasonic', '', '2006-05-27 19:27:35', NULL);
insert into manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) values ('6', 'Sony', '', '2006-05-27 19:28:01', NULL);
drop table if exists manufacturers_info;
create table manufacturers_info (
  manufacturers_id int(11) not null ,
  languages_id int(11) not null ,
  manufacturers_url varchar(255) not null ,
  url_clicked int(5) default '0' not null ,
  date_last_click datetime ,
  manufacturers_htc_title_tag varchar(80) ,
  manufacturers_htc_desc_tag longtext ,
  manufacturers_htc_keywords_tag longtext ,
  manufacturers_htc_description longtext ,
  PRIMARY KEY (manufacturers_id, languages_id),
  KEY languages_id (languages_id),
  KEY date_last_click (date_last_click)
);

insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('1', '1', 'http://www.kodak.pl', '0', NULL, 'Kodak', 'Kodak', 'Kodak', '');
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('2', '1', 'http://www.canon.pl', '1', '2006-09-12 23:17:07', 'Canon', 'Canon', 'Canon', '');
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('3', '1', 'http://www.olympus.pl', '0', NULL, 'Olympus', 'Olympus', 'Olympus', '');
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('4', '1', 'http://www.nikon.com', '0', NULL, 'Nikon', 'Nikon', 'Nikon', '');
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('5', '1', 'http://www.panasonic.com', '0', NULL, 'Panasonic', 'Panasonic', 'Panasonic', '');
insert into manufacturers_info (manufacturers_id, languages_id, manufacturers_url, url_clicked, date_last_click, manufacturers_htc_title_tag, manufacturers_htc_desc_tag, manufacturers_htc_keywords_tag, manufacturers_htc_description) values ('6', '1', 'http://www.sony.pl', '0', NULL, 'Sony', 'Sony', 'Sony', '');
drop table if exists newsdesk;
create table newsdesk (
  newsdesk_id int(11) not null auto_increment,
  newsdesk_image varchar(64) ,
  newsdesk_image_two varchar(64) ,
  newsdesk_image_three varchar(64) ,
  newsdesk_date_added datetime not null ,
  newsdesk_last_modified datetime ,
  newsdesk_date_available datetime ,
  newsdesk_status tinyint(1) default '0' not null ,
  newsdesk_sticky tinyint(1) default '1' not null ,
  PRIMARY KEY (newsdesk_id),
  KEY newsdesk_date_added (newsdesk_date_added),
  KEY newsdesk_status (newsdesk_status)
);

insert into newsdesk (newsdesk_id, newsdesk_image, newsdesk_image_two, newsdesk_image_three, newsdesk_date_added, newsdesk_last_modified, newsdesk_date_available, newsdesk_status, newsdesk_sticky) values ('1', '', '', '', '2005-12-08 22:24:39', NULL, NULL, '1', '0');
insert into newsdesk (newsdesk_id, newsdesk_image, newsdesk_image_two, newsdesk_image_three, newsdesk_date_added, newsdesk_last_modified, newsdesk_date_available, newsdesk_status, newsdesk_sticky) values ('2', '', '', '', '2006-01-15 22:26:12', NULL, NULL, '1', '0');
insert into newsdesk (newsdesk_id, newsdesk_image, newsdesk_image_two, newsdesk_image_three, newsdesk_date_added, newsdesk_last_modified, newsdesk_date_available, newsdesk_status, newsdesk_sticky) values ('3', '', '', '', '2006-03-06 22:27:03', '2007-02-08 14:23:14', NULL, '1', '0');
insert into newsdesk (newsdesk_id, newsdesk_image, newsdesk_image_two, newsdesk_image_three, newsdesk_date_added, newsdesk_last_modified, newsdesk_date_available, newsdesk_status, newsdesk_sticky) values ('4', 'abel.jpg', '', '', '2006-07-10 14:26:53', '2007-02-08 14:20:34', NULL, '1', '0');
drop table if exists newsdesk_categories;
create table newsdesk_categories (
  categories_id int(11) not null auto_increment,
  categories_image varchar(64) ,
  parent_id int(11) not null ,
  sort_order int(3) ,
  date_added datetime ,
  last_modified datetime ,
  catagory_status tinyint(1) default '1' not null ,
  PRIMARY KEY (categories_id),
  KEY idx_categories_parent_id (parent_id)
);

insert into newsdesk_categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified, catagory_status) values ('1', NULL, '0', '1', '2006-05-27 22:23:17', NULL, '1');
drop table if exists newsdesk_categories_description;
create table newsdesk_categories_description (
  categories_id int(11) not null ,
  language_id int(11) not null ,
  categories_name varchar(32) not null ,
  PRIMARY KEY (categories_id, language_id),
  KEY idx_categories_name (categories_name)
);

insert into newsdesk_categories_description (categories_id, language_id, categories_name) values ('1', '1', 'Nowości oscGold');
insert into newsdesk_categories_description (categories_id, language_id, categories_name) values ('1', '2', 'oscGold News');
insert into newsdesk_categories_description (categories_id, language_id, categories_name) values ('1', '3', 'oscGold Nachrichten');
insert into newsdesk_categories_description (categories_id, language_id, categories_name) values ('1', '4', '???????? oscGold');
drop table if exists newsdesk_configuration;
create table newsdesk_configuration (
  configuration_id int(11) not null auto_increment,
  configuration_title varchar(64) not null ,
  configuration_key varchar(64) not null ,
  configuration_value varchar(255) not null ,
  configuration_description varchar(255) not null ,
  configuration_group_id int(11) not null ,
  sort_order int(5) ,
  last_modified datetime ,
  date_added datetime not null ,
  use_function varchar(255) ,
  set_function varchar(255) ,
  PRIMARY KEY (configuration_id),
  KEY configuration_key (configuration_key)
);

insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('1', 'Wyniki wyszukiwania', 'MAX_DISPLAY_NEWSDESK_SEARCH_RESULTS', '20', 'Ilość wyszukiwanych artykułów', '1', '1', NULL, '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('2', 'Ilość artykułów na stronie', 'MAX_DISPLAY_NEWSDESK_PAGE_LINKS', '1', 'Ile pokazać artykułów na pojedyńczej stronie?', '1', '2', '2006-02-04 16:00:32', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('3', 'Pokazuj tytuł artykułu', 'NEWSDESK_ARTICLE_NAME', '2', 'Czy pokazać tytuł artykułu? (0=nie lub nr do sortowania na liście)', '1', '3', '2007-02-08 14:06:49', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('4', 'Pokazuj wstęp artykułu', 'NEWSDESK_ARTICLE_SHORTTEXT', '3', 'Czy pokazać wstęp artykułu? (0=nie lub nr do sortowania na liście)', '1', '4', '2006-02-04 16:30:53', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('5', 'Pokazuj treść artykułu', 'NEWSDESK_ARTICLE_DESCRIPTION', '0', 'Czy pokazać treść artykułu? (0=nie lub nr do sortowania na liście)', '1', '5', '2004-05-10 13:28:43', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('6', 'Pokazuj datę', 'NEWSDESK_DATE_AVAILABLE', '0', 'Czy pokazać datę utworzenia artykułu? (0=nie lub nr do sortowania na liście)', '1', '6', '2007-02-08 14:06:25', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('7', 'Pokazuj URL artykułu', 'NEWSDESK_ARTICLE_URL', '0', 'Czy pokazać odnośnik do zewnętrznej strony WWW? (0=nie lub nr do sortowania na liście)', '1', '7', '2004-11-11 12:44:38', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('8', 'Pokazuj nazwę URL', 'NEWSDESK_ARTICLE_URL_NAME', '0', 'Czy pokazać nazwę odnośnika do zewnętrznej strony WWW? (0=nie lub nr do sortowania na liście)', '1', '8', '2004-11-11 12:44:44', '2004-05-26 17:07:00', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('9', 'Pokazuj status artykułu', 'NEWSDESK_STATUS', '0', 'Czy pokazać status artykułu? (0=nie lub nr do sortowania na liście)', '1', '9', '2004-11-11 12:43:32', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('10', 'Pokazuj Zdjęcie nr 1', 'NEWSDESK_IMAGE', '1', 'Czy pokazać Zdjęcie nr 1? (0=nie lub nr do sortowania na liście)', '1', '10', '2007-02-08 14:06:40', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('11', 'Pokazuj Zdjęcie nr 2', 'NEWSDESK_IMAGE_TWO', '0', 'Czy pokazać Zdjęcie nr 2? (0=nie lub nr do sortowania na liście)', '1', '11', '2004-05-10 13:29:01', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('12', 'Pokazuj Zdjęcie nr 3', 'NEWSDESK_IMAGE_THREE', '0', 'Czy pokazać Zdjęcie nr 3? (0=nie lub nr do sortowania na liście)', '1', '12', '2004-05-10 13:29:06', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('14', 'Pasek nawigacyjny Poprzedni/Następny', 'NEWSDESK_PREV_NEXT_BAR_LOCATION', '1', 'Czy pokazać pasek nawigacyjny Poprzedni/Następny? (0=nie, 1=tak)', '1', '14', '2004-11-11 12:54:36', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('15', 'Ilość artykułów na stronie głównej', 'MAX_DISPLAY_NEWSDESK_NEWS', '3', 'Ile artykułów pokazać na stronie głównej sklepu?', '2', '1', '2006-02-04 16:01:52', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('16', 'Ilość artykułów w boxie Aktualności', 'LATEST_DISPLAY_NEWSDESK_NEWS', '5', 'Ile artykułów pokazać w boxie Aktualności?', '2', '2', NULL, '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('19', 'Pokazuj ilość odsłon artykułu', 'DISPLAY_NEWSDESK_VIEWCOUNT', '0', 'Czy pokazać ilość odsłon artykułu? (0=nie; 1=tak)', '2', '3', '2006-03-08 12:07:49', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('20', 'Pokazuj odnośnik \"więcej\"', 'DISPLAY_NEWSDESK_READMORE', '1', 'Czy pokazać odnośnik \"więcej\"? (0=nie; 1=tak)', '2', '4', '2006-07-10 14:28:03', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('21', 'Pokazuj wstęp artukułu', 'DISPLAY_NEWSDESK_SUMMARY', '1', 'Czy pokazać wstęp artykułu? (0=nie; 1=tak)', '2', '5', '2004-11-11 13:01:14', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('22', 'Pokazuj tytuł artykułu', 'DISPLAY_NEWSDESK_HEADLINE', '1', 'Czy pokazać tytuł artykułu? (0=nie; 1=tak)', '2', '6', NULL, '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('23', 'Pokazuj datę', 'DISPLAY_NEWSDESK_DATE', '1', 'Czy pokazać datę utworzenia artykułu? (0=nie; 1=tak)', '2', '7', NULL, '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('24', 'Pokazuj Zdjęcie nr 1', 'DISPLAY_NEWSDESK_IMAGE', '1', 'Czy pokazać Zdjęcie nr 1? (0=disable; 1=enable)', '2', '8', NULL, '2003-03-03 11:59:47', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('25', 'Pokazuj Zdjęcie nr 2', 'DISPLAY_NEWSDESK_IMAGE_TWO', '1', 'Czy pokazać Zdjęcie nr 2? (0=nie; 1=tak)', '2', '9', '2004-11-11 13:27:03', '2003-03-03 11:59:47', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('26', 'Pokazuj Zdjęcie nr 3', 'DISPLAY_NEWSDESK_IMAGE_THREE', '1', 'Czy pokazać Zdjęcie nr 3? (0=nie; 1=tak)', '2', '10', '2004-11-11 13:27:08', '2003-03-03 11:59:47', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('27', 'Pokazuj komentarze', 'DISPLAY_NEWSDESK_REVIEWS', '1', 'Czy pokazywać komentarze do artykułów? (0=nie; 1=tak)', '3', '1', '2004-05-18 15:39:09', '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('28', 'Ilość nowych komentarzy', 'MAX_DISPLAY_NEW_REVIEWS', '10', 'Maksymalna ilość nowych komentarzy do wyświetlenia', '3', '2', NULL, '2003-02-16 02:08:36', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('29', 'Pokazuj tytuł artykułu', 'STICKY_ARTICLE_NAME', '1', 'Czy pokazać tytuł artykułu? (0=nie; 1=tak)', '4', '1', NULL, '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('30', 'Pokazuj wstęp do artykułu', 'STICKY_ARTICLE_SHORTTEXT', '1', 'Czy pokazać wstęp do artykułu? (0=nie; 1=tak)', '4', '2', NULL, '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('31', 'Pokazuj treść artukułu', 'STICKY_ARTICLE_DESCRIPTION', '0', 'Czy pokazać treść artykułu? (0=nie; 1=tak)', '4', '3', '2004-11-11 13:08:52', '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('32', 'Pokazuj ilość odsłon artykułu', 'STICKY_NEWSDESK_VIEWCOUNT', '1', 'Czy pokazać ilość odsłon artykułu? (0=nie; 1=tak)', '4', '4', NULL, '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('33', 'Pokazuj odnośnik \"więcej\"', 'STICKY_NEWSDESK_READMORE', '1', 'Czy pokazać odnośnik \"więcej\"? (0=nie; 1=tak)', '4', '5', NULL, '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('34', 'Pokazuj datę', 'STICKY_DATE_ADDED', '1', 'Czy pokazać datę utworzenia artykułu? (0=nie; 1=tak)', '4', '6', '2003-03-02 00:49:54', '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('35', 'Pokazuj URL artykułu', 'STICKY_ARTICLE_URL', '0', 'Czy pokazać URL do zewnętrznej strony WWW? (0=nie; 1=tak)', '4', '7', '2004-05-26 17:13:50', '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('36', 'Pokazuj nazwę URL', 'STICKY_ARTICLE_URL_NAME', '1', 'Czy pokazać nazwę URL do zewnętrznej strony WWW? (0=nie; 1=tak)', '4', '8', '2003-03-02 00:51:00', '2003-03-02 00:50:00', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('37', 'Pokazuj Zdjęcie nr 1', 'STICKY_IMAGE', '1', 'Czy pokazać Zdjęcie nr 1? (0=nie; 1=tak)', '4', '9', '2003-03-02 00:50:14', '2003-03-02 00:47:21', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('38', 'Pokazuj Zdjęcie nr 2', 'STICKY_IMAGE_TWO', '1', 'Czy pokazać Zdjęcie nr 2? (0=nie; 1=tak)', '4', '10', NULL, '2003-03-03 23:10:34', NULL, NULL);
insert into newsdesk_configuration (configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('39', 'Pokazuj Zdjęcie nr 3', 'STICKY_IMAGE_THREE', '1', 'Czy pokazać Zdjęcie nr 3? (0=nie; 1=tak)', '4', '11', NULL, '2003-03-03 23:10:34', NULL, NULL);
drop table if exists newsdesk_configuration_group;
create table newsdesk_configuration_group (
  configuration_group_id int(11) not null auto_increment,
  configuration_group_title varchar(64) not null ,
  configuration_group_description varchar(255) not null ,
  sort_order int(5) ,
  visible int(1) default '1' ,
  PRIMARY KEY (configuration_group_id)
);

insert into newsdesk_configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('1', 'Wygląd listy artykułów', '', '2', '1');
insert into newsdesk_configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('2', 'Opcje artykułów', '', '1', '1');
insert into newsdesk_configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('3', 'Opcje komentarzy', '', '3', '1');
insert into newsdesk_configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) values ('4', 'Opcje Sticky', '', '4', '1');
drop table if exists newsdesk_description;
create table newsdesk_description (
  newsdesk_id int(11) not null auto_increment,
  language_id int(11) default '1' not null ,
  newsdesk_article_name varchar(64) not null ,
  newsdesk_article_description text ,
  newsdesk_article_shorttext text ,
  newsdesk_article_url varchar(255) ,
  newsdesk_article_url_name varchar(255) ,
  newsdesk_article_viewed int(5) default '0' ,
  newsdesk_image_text text ,
  newsdesk_image_text_two text ,
  newsdesk_image_text_three text ,
  PRIMARY KEY (newsdesk_id, language_id),
  KEY newsdesk_article_name (newsdesk_article_name)
);

insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('1', '1', 'Uruchomienie wersji DEMO', '', 'Uruchomiona została wersja DEMO sklepu opartego na oprogramowaniu oscGold.<br><br>Można r&oacute;wnież skorzystać z <a href=\"http://demo.oscgold.com/administracja\">panelu administracyjnego</a>. Dostęp do panelu mozliwy jest po podaniu loginu : <a href=\"mailto:admin@localhost.pl\">admin@localhost.pl</a> oraz hasła : admin.<br><br>Jednocześnie informuję, ze sklep jest cały czas rozwijany, zgodnie z życzeniami i potrzebami użytkownik&oacute;w.', '', '', '12', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('1', '2', 'Uruchomienie wersji DEMO', '', 'Uruchomiona została wersja DEMO sklepu opartego na oprogramowaniu oscGold.<br><br>Można r&oacute;wnież skorzystać z <a href=\"http://demo.oscgold.com/administracja\">panelu administracyjnego</a>. Dostęp do panelu mozliwy jest po podaniu loginu : <a href=\"mailto:admin@localhost.pl\">admin@localhost.pl</a> oraz hasła : admin.<br><br>Jednocześnie informuję, ze sklep jest cały czas rozwijany, zgodnie z życzeniami i potrzebami użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('1', '3', 'Uruchomienie wersji DEMO', '', 'Uruchomiona została wersja DEMO sklepu opartego na oprogramowaniu oscGold.<br><br>Można r&oacute;wnież skorzystać z <a href=\"http://demo.oscgold.com/administracja\">panelu administracyjnego</a>. Dostęp do panelu mozliwy jest po podaniu loginu : <a href=\"mailto:admin@localhost.pl\">admin@localhost.pl</a> oraz hasła : admin.<br><br>Jednocześnie informuję, ze sklep jest cały czas rozwijany, zgodnie z życzeniami i potrzebami użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('1', '4', 'Uruchomienie wersji DEMO', '', 'Uruchomiona została wersja DEMO sklepu opartego na oprogramowaniu oscGold.<br><br>Można r&oacute;wnież skorzystać z <a href=\"http://demo.oscgold.com/administracja\">panelu administracyjnego</a>. Dostęp do panelu mozliwy jest po podaniu loginu : <a href=\"mailto:admin@localhost.pl\">admin@localhost.pl</a> oraz hasła : admin.<br><br>Jednocześnie informuję, ze sklep jest cały czas rozwijany, zgodnie z życzeniami i potrzebami użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('2', '1', 'Moduł B2B', '', 'W programie oscGold został dodany moduł <strong>B2B</strong>, kt&oacute;ry umożliwia użytkowanie sklepu m.in. jako hurtowni. W module tym rozbudowany jest system rabatowy, a wszystkim produktom można przydzielić r&oacute;żne ceny, kt&oacute;re będą widzoczne tylko dla wybranych grup użytkownik&oacute;w.', '', '', '3', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('2', '2', 'Moduł B2B', '', 'W programie oscGold został dodany moduł <strong>B2B</strong>, kt&oacute;ry umożliwia użytkowanie sklepu m.in. jako hurtowni. W module tym rozbudowany jest system rabatowy, a wszystkim produktom można przydzielić r&oacute;żne ceny, kt&oacute;re będą widzoczne tylko dla wybranych grup użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('2', '3', 'Moduł B2B', '', 'W programie oscGold został dodany moduł <strong>B2B</strong>, kt&oacute;ry umożliwia użytkowanie sklepu m.in. jako hurtowni. W module tym rozbudowany jest system rabatowy, a wszystkim produktom można przydzielić r&oacute;żne ceny, kt&oacute;re będą widzoczne tylko dla wybranych grup użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('2', '4', 'Moduł B2B', '', 'W programie oscGold został dodany moduł <strong>B2B</strong>, kt&oacute;ry umożliwia użytkowanie sklepu m.in. jako hurtowni. W module tym rozbudowany jest system rabatowy, a wszystkim produktom można przydzielić r&oacute;żne ceny, kt&oacute;re będą widzoczne tylko dla wybranych grup użytkownik&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('3', '1', 'Moduł publikacji newsów', '', 'Program oscGold zostałwyposażony w moduł publikacji news&oacute;w.<br />
<br />
Umożliwia on właścicielowi sklepu zamieszczanie zar&oacute;wno kr&oacute;tkich informacji o wydarzeniach w sklepie, nowościach w dziedzinie związanej z prowadzoną działalnością jak r&oacute;wnież publikację dłuższych artykuł&oacute;w.', '', '', '30', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('3', '2', 'Moduł publikacji newsów', '', 'Program oscGold zostałwyposażony w moduł publikacji news&oacute;w.<br />
<br />
Umożliwia on właścicielowi sklepu zamieszczanie zar&oacute;wno kr&oacute;tkich informacji o wydarzeniach w sklepie, nowościach w dziedzinie związanej z prowadzoną działalnością jak r&oacute;wnież publikację dłuższych artykuł&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('3', '3', 'Moduł publikacji newsów', '', 'Program oscGold zostałwyposażony w moduł publikacji news&oacute;w.<br />
<br />
Umożliwia on właścicielowi sklepu zamieszczanie zar&oacute;wno kr&oacute;tkich informacji o wydarzeniach w sklepie, nowościach w dziedzinie związanej z prowadzoną działalnością jak r&oacute;wnież publikację dłuższych artykuł&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('3', '4', 'Moduł publikacji newsów', '', 'Program oscGold zostałwyposażony w moduł publikacji news&oacute;w.<br />
<br />
Umożliwia on właścicielowi sklepu zamieszczanie zar&oacute;wno kr&oacute;tkich informacji o wydarzeniach w sklepie, nowościach w dziedzinie związanej z prowadzoną działalnością jak r&oacute;wnież publikację dłuższych artykuł&oacute;w.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('4', '1', 'Nowa wersja oscGold 2.00', 'Wykaz ważniejszych zmian w wersji 2.00:<br />
<br />
<strong>Po stronie Administratora:</strong><br />
<br />
<ol>
    <li>Przystosowanie do pracy na serwerach z zainstalowanym oprogramowaniem php 5.x i mySQL 5.x. </li>
    <li>Zmiana kodowania opis&oacute;w i danych przechowywanych w bazie na utf-8 ułatawiająca wykonywanie opis&oacute;w w r&oacute;żnych językach. </li>
    <li>Mozliwość kopiowania dodatkowych cech produktow na pozostale produkty i kategorie. </li>
    <li>Możliwość pracy sklepu przy wyłączonej opcji serwera register_globals. </li>
</ol>
<p><strong>Po stronie klienta:</strong></p>
<ol>
    <li>Możliwość dokonywania zakup&oacute;w bez konieczności zakładania konta. </li>
    <li>Subsrypcja biuletynu bez konieczności zakładania konta. </li>
    <li>Zmieniony spos&oacute;b wyświetlania obrazk&oacute;w. Obecnie bardziej przejrzysty dla klientow sklepu. </li>
    <li>Zmodyfikowany moduł wyświetlający dostępne opcje produktu. Obecnie po wybraniu dodatkowych opcji automatycznie wyliczana jest i wyświetlana cena jaką należy zapłacić. </li>
    <li>Zmieniony spos&oacute;b prezentacji &quot;Nowych produktow&quot; i &quot;Polecanych produktow&quot;. </li>
    <li>Wiele innych drobnych modyfikacji związanych z wyglądem i obsługą sklepu. </li>
</ol>', 'Pojawiła się nowa wersja programu oscGold oznaczona numerem 2.00.<br />
<br />
W stosunku do poprzedniej wersji zmienione zostało kodowanie znak&oacute;w narodowych na system utf-8. Obecnie nie ma już r&oacute;żnicy czy opisy są wykonywane w wersji polskiej, angielskiej czy innej. Znaki diakrytyczne są zawsze wyświetlane prawidłowo. Sklep został r&oacute;wnież przystosowany do pracy na serwerach z zainstalowanym php we wersji 5.x i mySQL w wersji 5.x.', 'garbolandia.com', 'test', '35', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('4', '2', 'Nowa wersja oscGold 2.00', 'Wykaz ważniejszych zmian w wersji 2.00:<br />
<br />
<strong>Po stronie Administratora:</strong>
<ol>
    <li>Przystosowanie do pracy na serwerach z zainstalowanym oprogramowaniem php 5.x i mySQL 5.x. </li>
    <li>Zmiana kodowania opis&oacute;w i danych przechowywanych w bazie na utf-8 ułatawiająca wykonywanie opis&oacute;w w r&oacute;żnych językach. </li>
    <li>Mozliwość kopiowania dodatkowych cech produktow na pozostale produkty i kategorie. </li>
    <li>Możliwość pracy sklepu przy wyłączonej opcji serwera register_globals. </li>
</ol>
<p><strong>Po stronie klienta:</strong><br />
</p>
<ol>
    <li>Możliwość dokonywania zakup&oacute;w bez konieczności zakładania konta. </li>
    <li>Subsrypcja biuletynu bez konieczności zakładania konta. </li>
    <li>Zmieniony spos&oacute;b wyświetlania obrazk&oacute;w. Obecnie bardziej przejrzysty dla klientow sklepu. </li>
    <li>Zmodyfikowany moduł wyświetlający dostępne opcje produktu. Obecnie po wybraniu dodatkowych opcji automatycznie wyliczana jest i wyświetlana cena jaką należy zapłacić. </li>
    <li>Zmieniony spos&oacute;b prezentacji &quot;Nowych produktow&quot; i &quot;Polecanych produktow&quot;. </li>
    <li>Wiele innych drobnych modyfikacji związanych z wyglądem i obsługą sklepu. </li>
</ol>', 'Pojawiła się nowa wersja programu oscGold oznaczona numerem 2.00.<br />
<br />
W stosunku do poprzedniej wersji zmienione zostało kodowanie znak&oacute;w narodowych na system utf-8. Obecnie nie ma już r&oacute;żnicy czy opisy są wykonywane w wersji polskiej, angielskiej czy innej. Znaki diakrytyczne są zawsze wyświetlane prawidłowo. Sklep został r&oacute;wnież przystosowany do pracy na serwerach z zainstalowanym php we wersji 5.x i mySQL w wersji 5.x.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('4', '3', 'Nowa wersja oscGold 2.00', 'Wykaz ważniejszych zmian w wersji 2.00:<br />
<br />
<strong>Po stronie Administratora:</strong>
<ol>
    <li>Przystosowanie do pracy na serwerach z zainstalowanym oprogramowaniem php 5.x i mySQL 5.x. </li>
    <li>Zmiana kodowania opis&oacute;w i danych przechowywanych w bazie na utf-8 ułatawiająca wykonywanie opis&oacute;w w r&oacute;żnych językach. </li>
    <li>Mozliwość kopiowania dodatkowych cech produktow na pozostale produkty i kategorie. </li>
    <li>Możliwość pracy sklepu przy wyłączonej opcji serwera register_globals. </li>
</ol>
<p><strong>Po stronie klienta:</strong></p>
<ol>
    <li>Możliwość dokonywania zakup&oacute;w bez konieczności zakładania konta. </li>
    <li>Subsrypcja biuletynu bez konieczności zakładania konta. </li>
    <li>Zmieniony spos&oacute;b wyświetlania obrazk&oacute;w. Obecnie bardziej przejrzysty dla klientow sklepu. </li>
    <li>Zmodyfikowany moduł wyświetlający dostępne opcje produktu. Obecnie po wybraniu dodatkowych opcji automatycznie wyliczana jest i wyświetlana cena jaką należy zapłacić. </li>
    <li>Zmieniony spos&oacute;b prezentacji &quot;Nowych produktow&quot; i &quot;Polecanych produktow&quot;. </li>
    <li>Wiele innych drobnych modyfikacji związanych z wyglądem i obsługą sklepu. </li>
</ol>', 'Pojawiła się nowa wersja programu oscGold oznaczona numerem 2.00.<br />
<br />
W stosunku do poprzedniej wersji zmienione zostało kodowanie znak&oacute;w narodowych na system utf-8. Obecnie nie ma już r&oacute;żnicy czy opisy są wykonywane w wersji polskiej, angielskiej czy innej. Znaki diakrytyczne są zawsze wyświetlane prawidłowo. Sklep został r&oacute;wnież przystosowany do pracy na serwerach z zainstalowanym php we wersji 5.x i mySQL w wersji 5.x.', '', '', '0', '', '', '');
insert into newsdesk_description (newsdesk_id, language_id, newsdesk_article_name, newsdesk_article_description, newsdesk_article_shorttext, newsdesk_article_url, newsdesk_article_url_name, newsdesk_article_viewed, newsdesk_image_text, newsdesk_image_text_two, newsdesk_image_text_three) values ('4', '4', 'Nowa wersja oscGold 2.00', 'Wykaz ważniejszych zmian w wersji 2.00:<br />
<br />
<strong>Po stronie Administratora:</strong>
<ol>
    <li>Przystosowanie do pracy na serwerach z zainstalowanym oprogramowaniem php 5.x i mySQL 5.x. </li>
    <li>Zmiana kodowania opis&oacute;w i danych przechowywanych w bazie na utf-8 ułatawiająca wykonywanie opis&oacute;w w r&oacute;żnych językach. </li>
    <li>Mozliwość kopiowania dodatkowych cech produktow na pozostale produkty i kategorie. </li>
    <li>Możliwość pracy sklepu przy wyłączonej opcji serwera register_globals. </li>
</ol>
<p><strong>Po stronie klienta:</strong></p>
<ol>
    <li>Możliwość dokonywania zakup&oacute;w bez konieczności zakładania konta. </li>
    <li>Subsrypcja biuletynu bez konieczności zakładania konta. </li>
    <li>Zmieniony spos&oacute;b wyświetlania obrazk&oacute;w. Obecnie bardziej przejrzysty dla klientow sklepu. </li>
    <li>Zmodyfikowany moduł wyświetlający dostępne opcje produktu. Obecnie po wybraniu dodatkowych opcji automatycznie wyliczana jest i wyświetlana cena jaką należy zapłacić. </li>
    <li>Zmieniony spos&oacute;b prezentacji &quot;Nowych produktow&quot; i &quot;Polecanych produktow&quot;. </li>
    <li>Wiele innych drobnych modyfikacji związanych z wyglądem i obsługą sklepu. </li>
</ol>', 'Pojawiła się nowa wersja programu oscGold oznaczona numerem 2.00.<br />
<br />
W stosunku do poprzedniej wersji zmienione zostało kodowanie znak&oacute;w narodowych na system utf-8. Obecnie nie ma już r&oacute;żnicy czy opisy są wykonywane w wersji polskiej, angielskiej czy innej. Znaki diakrytyczne są zawsze wyświetlane prawidłowo. Sklep został r&oacute;wnież przystosowany do pracy na serwerach z zainstalowanym php we wersji 5.x i mySQL w wersji 5.x.', '', '', '0', '', '', '');
drop table if exists newsdesk_reviews;
create table newsdesk_reviews (
  reviews_id int(11) not null auto_increment,
  newsdesk_id int(11) not null ,
  customers_id int(11) ,
  customers_name varchar(64) not null ,
  reviews_rating int(1) ,
  date_added datetime ,
  last_modified datetime ,
  reviews_read int(5) default '0' not null ,
  approved tinyint(3) unsigned default '0' ,
  PRIMARY KEY (reviews_id)
);

insert into newsdesk_reviews (reviews_id, newsdesk_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('1', '1', '1', 'Jacek Krysiak', '3', '2006-06-18 22:23:22', NULL, '11', '1');
drop table if exists newsdesk_reviews_description;
create table newsdesk_reviews_description (
  reviews_id int(11) not null ,
  languages_id int(11) not null ,
  reviews_text text not null ,
  PRIMARY KEY (reviews_id, languages_id)
);

insert into newsdesk_reviews_description (reviews_id, languages_id, reviews_text) values ('1', '1', 'Krótki komentarz do artykułu !!!!!!!!!!!!!!!!!!!!');
drop table if exists newsdesk_to_categories;
create table newsdesk_to_categories (
  newsdesk_id int(11) not null ,
  categories_id int(11) not null ,
  PRIMARY KEY (newsdesk_id, categories_id)
);

insert into newsdesk_to_categories (newsdesk_id, categories_id) values ('1', '1');
insert into newsdesk_to_categories (newsdesk_id, categories_id) values ('2', '1');
insert into newsdesk_to_categories (newsdesk_id, categories_id) values ('3', '1');
insert into newsdesk_to_categories (newsdesk_id, categories_id) values ('4', '1');
drop table if exists newsletters;
create table newsletters (
  newsletters_id int(11) not null auto_increment,
  title varchar(255) not null ,
  content text not null ,
  module varchar(255) not null ,
  date_added datetime not null ,
  date_sent datetime ,
  status int(1) ,
  locked int(1) default '0' ,
  PRIMARY KEY (newsletters_id)
);

insert into newsletters (newsletters_id, title, content, module, date_added, date_sent, status, locked) values ('3', 'Testowy biuletyn', '<p>Testowy biuletyn na potrzeby testowania</p>
<p>asasasa saks aaslalkmlk mlkm lkml</p>
<p>adaddd dasl dadls nasl llmklkmlmlmlkmlkmlk</p>', 'product_notification', '2006-09-12 11:15:39', '2006-09-12 21:17:17', '1', '1');
drop table if exists optimize_check;
create table optimize_check (
  counter int(11) not null auto_increment,
  start_date date not null ,
  PRIMARY KEY (counter)
);

insert into optimize_check (counter, start_date) values ('1', '2007-07-06');
drop table if exists orders;
create table orders (
  orders_id int(11) not null auto_increment,
  customers_id int(11) not null ,
  customers_name varchar(64) not null ,
  customers_company varchar(96) ,
  customers_nip varchar(32) ,
  customers_street_address varchar(64) not null ,
  customers_suburb varchar(32) ,
  customers_city varchar(32) not null ,
  customers_postcode varchar(10) not null ,
  customers_state varchar(32) ,
  customers_country varchar(32) not null ,
  customers_telephone varchar(32) not null ,
  customers_email_address varchar(96) not null ,
  customers_address_format_id int(5) not null ,
  delivery_name varchar(64) not null ,
  delivery_company varchar(96) ,
  delivery_nip varchar(32) ,
  delivery_street_address varchar(64) not null ,
  delivery_suburb varchar(32) ,
  delivery_city varchar(32) not null ,
  delivery_postcode varchar(10) not null ,
  delivery_state varchar(32) ,
  delivery_country varchar(32) not null ,
  delivery_address_format_id int(5) not null ,
  billing_name varchar(64) not null ,
  billing_company varchar(96) ,
  billing_nip varchar(32) ,
  billing_street_address varchar(64) not null ,
  billing_suburb varchar(32) ,
  billing_city varchar(32) not null ,
  billing_postcode varchar(10) not null ,
  billing_state varchar(32) ,
  billing_country varchar(32) not null ,
  billing_address_format_id int(5) not null ,
  payment_method varchar(64) not null ,
  payment_info text ,
  cc_type varchar(20) ,
  cc_owner varchar(64) ,
  cc_number varchar(32) ,
  cc_expires varchar(4) ,
  giftwrap varchar(20) not null ,
  last_modified datetime ,
  date_purchased datetime ,
  orders_status int(5) not null ,
  orders_date_finished datetime ,
  currency varchar(3) ,
  currency_value decimal(14,6) ,
  shipping_tax decimal(7,4) default '0.0000' not null ,
  PRIMARY KEY (orders_id),
  KEY customers_id (customers_id),
  KEY orders_status (orders_status)
);

insert into orders (orders_id, customers_id, customers_name, customers_company, customers_nip, customers_street_address, customers_suburb, customers_city, customers_postcode, customers_state, customers_country, customers_telephone, customers_email_address, customers_address_format_id, delivery_name, delivery_company, delivery_nip, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, delivery_state, delivery_country, delivery_address_format_id, billing_name, billing_company, billing_nip, billing_street_address, billing_suburb, billing_city, billing_postcode, billing_state, billing_country, billing_address_format_id, payment_method, payment_info, cc_type, cc_owner, cc_number, cc_expires, giftwrap, last_modified, date_purchased, orders_status, orders_date_finished, currency, currency_value, shipping_tax) values ('36', '12', 'Test Test', '', '', 'Testowa', '', 'Testowe', '87800', 'Dolonośląskie', 'Poland', 'xxx xxx xxx', 'user@demo.pl', '1', 'Test Test', '', '', 'Testowa', '', 'Testowe', '87800', 'Dolonośląskie', 'Poland', '1', 'Test Test', '', '', 'Testowa', '', 'Testowe', '87800', 'Dolonośląskie', 'Poland', '1', 'Przelew Bankowy', 'Po otrzymaniu potwierdzenia dostępności towaru prosimy o przelanie sumy zamówienia na podany niżej nr konta: <br><br>Nazwa konta: Wpisz nazwę właściciela konta<br>Numer konta: PL00 0000 0000 0000 0000 0000 000<br>Nazwa banku: Tutaj wpisz nazwę banku<br><br>Potwierdzenie zostanie przesłane do Ciebie w ciągu kilku dni.<br>Twoje zamówienie zostanie wysłane niezwłocznie po wpłynięciu pieniędzy na konto.<br>', '', '', '', '', '', '2007-10-31 15:14:56', '2007-07-04 14:22:24', '1', NULL, 'PLN', '1.000000', '0.0000');
drop table if exists orders_products;
create table orders_products (
  orders_products_id int(11) not null auto_increment,
  orders_id int(11) not null ,
  products_id int(11) not null ,
  products_model varchar(32) ,
  products_name varchar(64) not null ,
  products_price decimal(15,4) not null ,
  final_price decimal(15,4) default '0.0000' not null ,
  products_tax decimal(7,4) not null ,
  products_quantity int(2) not null ,
  products_stock_attributes varchar(255) ,
  PRIMARY KEY (orders_products_id),
  KEY orders_id (orders_id),
  KEY products_id (products_id)
);

insert into orders_products (orders_products_id, orders_id, products_id, products_model, products_name, products_price, final_price, products_tax, products_quantity, products_stock_attributes) values ('13', '36', '6', '000006', 'Kodak Z740', '802.4590', '802.4590', '22.0000', '1', NULL);
drop table if exists orders_products_attributes;
create table orders_products_attributes (
  orders_products_attributes_id int(11) not null auto_increment,
  orders_id int(11) not null ,
  orders_products_id int(11) not null ,
  products_options varchar(32) not null ,
  products_options_values varchar(32) not null ,
  options_values_price decimal(15,4) not null ,
  price_prefix char(1) not null ,
  PRIMARY KEY (orders_products_attributes_id)
);

drop table if exists orders_products_download;
create table orders_products_download (
  orders_products_download_id int(11) not null auto_increment,
  orders_id int(11) not null ,
  orders_products_id int(11) not null ,
  orders_products_filename varchar(255) not null ,
  download_maxdays int(2) not null ,
  download_count int(2) not null ,
  PRIMARY KEY (orders_products_download_id)
);

drop table if exists orders_status;
create table orders_status (
  orders_status_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  orders_status_name varchar(128) not null ,
  PRIMARY KEY (orders_status_id, language_id),
  KEY language_id (language_id),
  KEY orders_status_name (orders_status_name)
);

insert into orders_status (orders_status_id, language_id, orders_status_name) values ('1', '1', 'Zamówienie otrzymane');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('2', '1', 'Zamówienie przyjęte');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('3', '1', 'Zamówienie realizowane');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('4', '1', 'Zamówione towary wysłane');
insert into orders_status (orders_status_id, language_id, orders_status_name) values ('5', '1', 'Przygotowane [PayPal]');
drop table if exists orders_status_history;
create table orders_status_history (
  orders_status_history_id int(11) not null auto_increment,
  orders_id int(11) not null ,
  orders_status_id int(11) not null ,
  date_added datetime not null ,
  customer_notified int(1) default '0' ,
  comments text ,
  PRIMARY KEY (orders_status_history_id),
  KEY orders_id (orders_id),
  KEY date_added (date_added)
);

insert into orders_status_history (orders_status_history_id, orders_id, orders_status_id, date_added, customer_notified, comments) values ('14', '36', '1', '2006-09-01 20:57:08', '1', 'kd ksdkf kfn sdkjfn dkfjs kfkjds fnsdkjfn skdfjnsdkfn sdkfjnsd kfnskfjnsdfkjsdnf kdsjf nkjn kj nkjn k');
drop table if exists orders_total;
create table orders_total (
  orders_total_id int(10) unsigned not null auto_increment,
  orders_id int(11) not null ,
  title varchar(255) not null ,
  text varchar(255) not null ,
  value decimal(15,4) not null ,
  class varchar(32) not null ,
  sort_order int(11) not null ,
  PRIMARY KEY (orders_total_id),
  KEY orders_id (orders_id),
  KEY class (class)
);

insert into orders_total (orders_total_id, orders_id, title, text, value, class, sort_order) values ('55', '36', 'Zniżki dla stałych klientów:<br>Suma Twoich dotychczasowych zamówień wynosi 13.283,64zł w okresie: rocznie. Od tej chwili wszystkie Twoje zamówienia będą objęte zniżką w wysokości 15%. <br><b>Od tego zamówienia została odjęta kwota:</b>', '147,48zł', '147.4800', 'ot_loyalty_discount', '1');
insert into orders_total (orders_total_id, orders_id, title, text, value, class, sort_order) values ('56', '36', 'Podsuma:', '979,00zł', '979.0000', 'ot_subtotal', '2');
insert into orders_total (orders_total_id, orders_id, title, text, value, class, sort_order) values ('57', '36', 'VAT-22:', '176,54zł', '176.5410', 'ot_tax', '3');
insert into orders_total (orders_total_id, orders_id, title, text, value, class, sort_order) values ('58', '36', 'Przesyłka Ekonomiczna (płatność przelewem na konto lub kartą kredytową) (Kraj dostawy i Waga zamówienia -> Poland: 0.5 kg):', '4,20zł', '4.2000', 'ot_shipping', '4');
insert into orders_total (orders_total_id, orders_id, title, text, value, class, sort_order) values ('59', '36', 'Razem:', '<b>1.130,68zł</b>', '1130.6800', 'ot_total', '5');
drop table if exists pages;
create table pages (
  pages_id int(11) not null auto_increment,
  sort_order int(11) ,
  status int(11) default '1' not null ,
  page_type char(1) ,
  PRIMARY KEY (pages_id),
  KEY status (status)
);

insert into pages (pages_id, sort_order, status, page_type) values ('1', '1', '1', '1');
insert into pages (pages_id, sort_order, status, page_type) values ('2', '2', '1', '2');
insert into pages (pages_id, sort_order, status, page_type) values ('3', '3', '1', '4');
drop table if exists pages_description;
create table pages_description (
  id int(11) not null auto_increment,
  pages_id int(11) ,
  pages_title varchar(128) not null ,
  pages_html_text text ,
  intorext char(1) ,
  externallink varchar(255) ,
  link_target char(1) ,
  language_id int(3) ,
  PRIMARY KEY (id),
  KEY language_id (language_id),
  KEY pages_id (pages_id)
);

insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('1', '1', 'Regulamin', '<ol>
    <li>Sklep internetowy prowadzi sprzedaż towar&oacute;w za pośrednictwem sieci Internet. </li>
    <li>Zam&oacute;wienia są przyjmowane przez strony <font color=\"#0000c0\"><a href=\"http://www.xxxxxx.pl/\">www.xxxxxx.pl</a> </font>, w wyjątkowych przypadkach<br />
    telefonicznie (0XX) XXX XXX XXX. Po złożeniu zam&oacute;wienia klient dostaje e-mailem informację o jego przyjęciu z prośbą o potwierdzenie. Realizacja zam&oacute;wienia rozpoczyna siś:<br />
    a) w przypadku zam&oacute;wień płatnych przy odbiorze - po tym, jak do sklepu dotrze od klienta e-mail z potwierdzeniem złożonego zam&oacute;wienia<br />
    b) w przypadku zam&oacute;wień płatnych przelewem - w chwili dotarcia przelewu opłacającego zam&oacute;wienie na konto sklepu. </li>
    <li>Do każdego zam&oacute;wienia dołączany jest paragon. </li>
    <li>Faktura VAT jest wystawiana na wyraźne życzenie klienta. </li>
    <li>Klient może wprowadzić zmiany w zam&oacute;wieniu do momentu otrzymania e-maila potwierdzającego wysyłkę zam&oacute;wionych towar&oacute;w. </li>
</ol>', '0', '', '0', '1');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('2', '1', 'Conditions of use', '<strong><font size=\"1\">We are sorry, but this information is still not translated</font></strong>', '0', '', '0', '2');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('3', '1', 'Zustände des Gebrauches', '<strong>Es tut uns leid, aber diese Informationen werden noch nicht &uuml;bersetzt</strong>', '0', '', '0', '3');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('4', '1', 'Условия пользы', '<strongПереведенный текст</strong>', '0', '', '0', '4');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('5', '2', 'Kontakt', '<p><strong>Dzialanie przy register_globals off</strong></p>', '0', '', '0', '1');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('6', '2', 'Contact Us', '<strong><font size=\"1\">We are sorry, but this information is still not translated</font></strong>', '0', '', '0', '2');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('7', '2', 'Kontakt', '<strong>Es tut uns leid, aber diese Informationen werden noch nicht &uuml;bersetzt</strong>', '0', '', '0', '3');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('8', '2', 'Свяжитесь Мы', '<strong>Переведенный текст</strong>', '0', '', '0', '4');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('9', '3', 'Dostawa', '<strong>Wysyłka <br /></strong>jest realizowana w dw&oacute;ch wariantach:<br />1. Poczta Polska - przedmioty o standardowych wymiarach, paczka do 25 kg.<br />2. Dowolnym kurierem -przedmioty nadwymiarowe i bardzo ciężkie.<br />Koszty wysyłki pokrywa kupujący. Przy zakupach powyżej 600 zł koszty przesyłki pokrywa sprzedający. (UWAGA dla przesyłek nadwymiarowych wysyłanych kurierem max. kwota rabatu za przesyłkę to 30zł- reszte pokrywa kupujący) <br /><br /><strong>Zwroty</strong><br />zakupionych towar&oacute;w są przyjmowane tylko pod warunkiem, że nie były używane, posiadają orginalne opakowanie, są dostarczone w komplecie (wraz z dołączonym osprzętem). Pieniądze za zwr&oacute;cony towar zostaną wysłane na podane konto lub adres w ciągu 7 dni roboczych. Koszty zwrot&oacute;w ponosi kupujący<br />. Reklamacje dotyczšce uszkodzeń mechanicznych powstałych podczas transportu będš rozpatrywane tylko na podstawie protokołu reklamacyjnego spisanego w obecności doręczyciela. Pokrywamy koszty przesyłek wynikłych z błędnej realizacji zam&oacute;wienia przez nasz sklep. UWAGA: sprawdź zawartość przesyłki w obecności dostarczajšcej jš osoby! Zwroty i reklamacje powinny być adresowane na adres podany w danych kontaktowych sklepu.', '0', '', '0', '1');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('10', '3', 'Shipping', '<strong><font size=\"1\">We are sorry, but this information is still not translated</font></strong>', '0', '', '0', '2');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('11', '3', 'Verschiffen', '<strong>Es tut uns leid, aber diese Informationen werden noch nicht &uuml;bersetzt</strong>', '0', '', '0', '3');
insert into pages_description (id, pages_id, pages_title, pages_html_text, intorext, externallink, link_target, language_id) values ('12', '3', 'Перевозка груза', '<strong>Переведенный текст</strong>', '0', '', '0', '4');
drop table if exists products;
create table products (
  products_id int(11) not null auto_increment,
  products_quantity int(4) not null ,
  products_model varchar(32) ,
  products_image varchar(120) ,
  products_image_pop varchar(64) ,
  products_price decimal(15,4) not null ,
  products_retail_price decimal(15,4) ,
  products_date_added datetime not null ,
  products_last_modified datetime ,
  products_date_available datetime ,
  products_weight decimal(5,2) not null ,
  products_status tinyint(1) not null ,
  products_tax_class_id int(11) not null ,
  products_maxorder int(4) default '1' ,
  manufacturers_id int(11) ,
  products_ordered int(11) default '0' not null ,
  products_availability_id varchar(255) ,
  products_adminnotes varchar(255) ,
  PRIMARY KEY (products_id),
  KEY products_model (products_model),
  KEY products_status (products_status),
  KEY manufacturers_id (manufacturers_id),
  KEY products_ordered (products_ordered),
  KEY products_date_available (products_date_available),
  KEY products_date_added (products_date_added),
  KEY products_image_pop (products_image_pop)
);

insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('1', '100', '000001', 'aparaty_cyfrowe/a540.jpg', NULL, '22.1311', '0.0000', '2007-04-19 11:16:59', '2007-09-07 14:21:46', '0000-00-00 00:00:00', '1.00', '1', '3', '0', '2', '3', '2', NULL);
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('2', '5', '000002', 'aparaty_cyfrowe/A700_big.jpg', NULL, '1023.7705', '1113.9344', '2007-04-19 11:16:59', '2007-09-07 14:21:46', NULL, '1.00', '1', '3', '0', '2', '0', '1', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('3', '5', '000003', 'aparaty_cyfrowe/a530_1.jpg', NULL, '663.1148', '778.6885', '2007-04-19 11:16:59', '2007-09-07 14:21:46', NULL, '0.00', '1', '3', '0', '2', '2', '1', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('4', '100', '000004', 'aparaty_cyfrowe/c330.jpg', NULL, '0.0000', '0.0000', '2007-04-19 11:16:59', '2007-09-07 14:21:46', NULL, '0.00', '1', '3', '10', '1', '4', '0', 'Poczatkowa cena byla 2000 a teraz jest 1500');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('5', '9', '000005', 'aparaty_cyfrowe/kodakdx7630.jpg', NULL, '818.8525', '0.0000', '2007-04-19 11:16:59', '2009-08-04 00:13:13', NULL, '0.00', '1', '3', '0', '1', '2', '3', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('6', '2', '000006', 'aparaty_cyfrowe/z740.jpg', NULL, '802.4590', '0.0000', '2007-04-19 11:16:59', '2007-09-07 14:21:46', '0000-00-00 00:00:00', '0.00', '1', '3', '0', '1', '2', '1', NULL);
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('7', '23', '000007', 'aparaty_cyfrowe/l_11000041.jpg', NULL, '1966.3934', '2049.1803', '2007-04-19 11:16:59', '2007-09-07 14:21:46', NULL, '0.00', '1', '3', '0', '2', '3', '0', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('8', '10', '000008', 'aparaty_cyfrowe/eos_5d/g_11000066_001.jpg', NULL, '9507.3770', '10000.0000', '2007-04-19 11:16:59', '2009-07-29 22:33:37', NULL, '0.00', '1', '3', '0', '2', '1', '3', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('9', '9', '000009', 'aparaty_cyfrowe/dslr_e500_front_rdax_225x210.jpg', NULL, '2113.9344', '0.0000', '2007-04-19 11:16:59', '2007-09-07 14:21:46', '2007-08-01 00:00:00', '0.00', '1', '3', '0', '3', '4', '3', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('10', '3', '000010', 'aparaty_cyfrowe/d50.jpg', NULL, '4097.5410', '4425.4098', '2007-04-19 11:16:59', '2007-09-07 14:21:46', '0000-00-00 00:00:00', '0.00', '1', '3', '0', '4', '0', '2', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('11', '0', '000011', 'kamery_cyfrowe/DVD205_cw2_IM.jpg', NULL, '1679.5082', '0.0000', '2007-04-19 11:16:59', '2007-09-21 13:41:31', NULL, '0.00', '1', '3', '0', '6', '4', '1', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('12', '5', '000012', 'kamery_cyfrowe/DVD505_cw2_IM.jpg', NULL, '3048.3607', '0.0000', '2007-04-19 11:16:59', '2007-04-19 11:16:59', '0000-00-00 00:00:00', '0.00', '1', '3', '0', '6', '3', '1', NULL);
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('13', '8', '000013', 'kamery_cyfrowe/mv800_big.jpg', NULL, '950.0000', '0.0000', '2007-04-19 11:16:59', '2007-11-20 11:04:58', NULL, '0.00', '1', '3', '0', '2', '2', '1', '');
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('14', '2', '000014', 'kamery_cyfrowe/mvx300_big.jpg', NULL, '1958.1967', '0.0000', '2007-04-19 11:16:59', '2007-04-19 11:16:59', '0000-00-00 00:00:00', '1.20', '1', '3', '0', '2', '5', '2', NULL);
insert into products (products_id, products_quantity, products_model, products_image, products_image_pop, products_price, products_retail_price, products_date_added, products_last_modified, products_date_available, products_weight, products_status, products_tax_class_id, products_maxorder, manufacturers_id, products_ordered, products_availability_id, products_adminnotes) values ('15', '0', '000015', 'kamery_cyfrowe/mvx30i_frt_slt_opn.jpg', NULL, '4000.0000', '4917.2131', '2007-04-19 11:16:59', '2007-05-29 12:21:12', '2007-08-01 00:00:00', '0.00', '1', '3', '0', '2', '1', '3', '');
drop table if exists products_attributes;
create table products_attributes (
  products_attributes_id int(11) not null auto_increment,
  products_id int(11) not null ,
  options_id int(11) not null ,
  options_values_id int(11) not null ,
  options_values_price decimal(15,4) not null ,
  price_prefix char(1) not null ,
  products_options_sort_order int(6) default '0' not null ,
  PRIMARY KEY (products_attributes_id),
  KEY products_id (products_id),
  KEY options_id (options_id)
);

insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('180', '3', '1', '1', '0.0000', '', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('179', '3', '1', '3', '50.0000', '+', '1');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('157', '1', '1', '3', '59.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('156', '1', '1', '2', '39.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('155', '1', '1', '1', '0.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('160', '2', '1', '3', '59.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('159', '2', '1', '2', '39.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('158', '2', '1', '1', '0.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('147', '7', '1', '4', '99.0000', '+', '3');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('146', '7', '1', '3', '49.0000', '+', '2');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('152', '9', '1', '4', '99.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('151', '9', '1', '3', '0.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('150', '8', '1', '4', '99.0000', '+', '2');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('149', '8', '1', '3', '55.0000', '+', '1');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('148', '8', '1', '1', '0.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('164', '7', '1', '2', '0.0000', '+', '1');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('165', '4', '1', '4', '99.0000', '+', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('171', '7', '2', '5', '0.0000', '+', '1');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('172', '7', '2', '6', '200.0000', '+', '2');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('173', '13', '1', '1', '0.0000', '', '0');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('174', '13', '1', '3', '50.0000', '+', '1');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('175', '13', '1', '4', '100.0000', '', '2');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('178', '3', '1', '4', '100.0000', '', '2');
insert into products_attributes (products_attributes_id, products_id, options_id, options_values_id, options_values_price, price_prefix, products_options_sort_order) values ('187', '10', '1', '4', '99.0000', '+', '0');
drop table if exists products_attributes_download;
create table products_attributes_download (
  products_attributes_id int(11) not null ,
  products_attributes_filename varchar(255) not null ,
  products_attributes_maxdays int(2) default '0' ,
  products_attributes_maxcount int(2) default '0' ,
  PRIMARY KEY (products_attributes_id)
);

drop table if exists products_availability;
create table products_availability (
  products_availability_id int(11) not null auto_increment,
  language_id int(11) default '1' not null ,
  products_availability_name varchar(255) not null ,
  date_added datetime ,
  last_modified datetime ,
  PRIMARY KEY (products_availability_id, language_id),
  KEY IDX_PRODUCTS_AVAILABILITY_NAME (products_availability_name)
);

insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('1', '1', 'Dostępny', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('1', '2', 'Available', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('1', '3', 'Vorhanden', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('1', '4', 'Имеющеся', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('2', '1', 'Dostępność - 3 dni', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('2', '2', 'Availability - 3 days', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('2', '3', 'Verwendbarkeit - 3 Tage', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('2', '4', 'Наличие - 3 дня', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('3', '1', 'Na zamówienie', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('3', '2', 'On order', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('3', '3', 'Auf Auftrag', NULL, NULL);
insert into products_availability (products_availability_id, language_id, products_availability_name, date_added, last_modified) values ('3', '4', 'На заказе', NULL, NULL);
drop table if exists products_description;
create table products_description (
  products_id int(11) not null auto_increment,
  language_id int(11) default '1' not null ,
  products_name varchar(150) not null ,
  products_description text ,
  products_url varchar(255) ,
  products_viewed int(5) default '0' ,
  products_head_title_tag varchar(80) ,
  products_head_desc_tag longtext ,
  products_head_keywords_tag longtext ,
  products_seo_url varchar(100) not null ,
  PRIMARY KEY (products_id, language_id),
  KEY language_id (language_id),
  KEY products_name (products_name)
);

insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('1', '1', 'PowerShot A540', '<p>Canon wzbogaca swoją gamę serii PowerShot A modelami <strong>PowerShot A540</strong> i A530. <strong>Power Shot A540</strong> posiada czujnik CCD o&nbsp;6 milionach piskeli oraz optyczny zoom 4x o znakomitych możliwosciach. <strong>Power Shot A540</strong> to ekran LCD o 2.5&quot; po przekątnej. Procesor DIGIC II zapewni niwelowanie hałasu.<br><br><strong>PowerShot A540</strong> pozwoli na artystyczne i kreatywne korzystanie z aparatu. To&nbsp;21 trybow robienia zdjęć. To tryby takie jak &quot;Nocny&quot;, &quot;Snieg&quot;, &quot;Zaostrzenie kolor&oacute;w&quot; i &quot;zamiana kolorow&quot;&nbsp;<strong>PowerShot A540</strong> to Duzy Ekran o 2816 x 1584 pikseli, do druku na drukarce Compact SELPHY. To czułość 800 ISO</p>', '', '139', 'PowerShot A540', 'PowerShot A540', 'PowerShot A540', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('2', '1', 'PowerShot A700', 'Nowy aparat z serii PowerShot, które łączy w sobie łatwość obsługi z kreatywną elastycznością - PowerShot A700. Wyposażony w matrycę 6,0 mln pikseli definiuje nowy poziom jakości w klasie A, wyposażono go bowiem w sześciokrotny zoom optyczny i celownik optyczny. Aparat wyposażono w szeroki wachlarz trybów fotografowania, jest również kompatybilny z opcjonalnymi konwerterami zwiększającymi jego wszechstronność. Mały korpus aparatów PowerShot A700 zawieraja szeroki wybór najnowocześniejszych technologii:<br />
<br />
- Procesor DIGIC II, iSAPS i prowadzące do ostrych i wyraźnych zdjęć<br />
- Dokładne ustawianie ostrości z Flexizone AF/AE1 [PowerShot A700] i 9-polowy AiAF1<br />
- wysoka czułość matrycy ISO800<br />
- zapis zdjęć w formacie panoramicznym 16:9<br />
- klipy video VGA [30 kl/sek]<br />
- monitor LCD 2,5&rdquo; z trybem Night Display i wyświetlaniem siatki', '', '179', 'PowerShot A700', 'PowerShot A700', 'PowerShot A700', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('3', '1', 'PowerShot A530', '<p>Canon wzbogaca swoją gamę serii PowerShot A modelami <strong>PowerShot A530</strong> i A540. <strong>Power Shot A530</strong> posiada czujnik CCD o 5 milionach piskeli oraz optyczny zoom 4x o znakomitych możliwosciach. <strong>Power Shot A530</strong> to ekran LCD o 1,8&quot; po przekątnej. Procesor DIGIC II zapewni niwelowanie hałasu.<br />
<br />
<strong>PowerShot A530</strong> pozwoli na artystyczne i kreatywne korzystanie z aparatu. To 18 trybow robienia zdjęć. To tryby takie jak &quot;Nocny&quot;, &quot;Snieg&quot;, &quot;Zaostrzenie kolor&oacute;w&quot; <strong>PowerShot A530</strong> to Duzy Ekran o 2816 x 1584 pikseli, do druku na drukarce Compact SELPHY. To czułość 800 ISO</p>', '', '688', 'PowerShot A530', 'PowerShot A530', 'PowerShot A530', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('4', '1', 'Kodak C330', 'Aparat C330 posiada matrycę wielkości 4MP pozwala uzyskać zdjęcia w maksymalnym formacie 50X75 cm. 13 program&oacute;w tematycznych, w jaki jest wyposażony aparat ułatwiają rejestrowanie zar&oacute;wno najczęściej spotykanych sytuacji, jak i takich mniej typowych np.: zdjęcia na śniegu, plaży czy też sztuczne ognie.<br />
<br />
Dzięki możliwości nagrywania sekwencji video można utrwalić wybrane momenty w ruchu. Obraz video może zostać utrwalony z maksymalną rozdzielczością 320X240 pikseli. Podczas przeglądania zdjęć w aparacie możemy je powiększyć do 8X, aby zobaczyć każdy szczeg&oacute;ł zdjęcia. Aparat daje możliwość użytkownikowi kadrowania zdjęć zapisanych w aparacie po ich wykonaniu. Unikalny przycisk Share pozwala podzielić się zdjęciami, zorganizować je w komputerze niemalże natychmiast po ich wykonaniu. 16MB wewnętrznej pamięci może być poszerzone przez zastosowanie kart pamięci MMC lub SD.', 'www.kodak.com', '328', 'Kodak C330', 'Kodak C330', 'Kodak C330', 'c330');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('5', '1', 'Kodak DX 7630', '<p>Aparat cyfrowy DX7630 jest pierwszym aparatem cyfrowym z matrycą 6MP. Wielkość matrycy gwarantuje uzyskanie odbitek w maksymalnym formacie 76X102 cm. Trzykrotny zoom optyczny firmy Schneider-Kreuznach zapewnia bardzo wysoką jakość zdjęć. Oba te elementy gwarantują uzyskanie żywych, nasyconych i wiernych kolorów. <br />
Szybki i precyzyjny system ustawiania ostrości gwarantuje bardzo szybkie wykonanie zdjęcia - już po 0,3 sekundy od naciśnięcia spustu migawki. 15 programów tematycznych lub jeden z 5 trybów kolorystycznych daje ogromne możliwości kreacji obrazu. Użytkownik w dowolny sposób może zmieniać ustawienia ekspozycji, przesłony, migawki, ISO i lampy błyskowej. Można skorzystać z programów priorytetu przesłony lub migawki albo wybrać regulację parametrów naświetlania całkowicie manualną. Wybrane ustawienia można zapisać i w szybki sposób powrócić do nich w dowolnej chwili. Dodatkowo użytkownik ma możliwość ingerencji w ustawienia dodatkowe, takie jak stopień kompresji JPEG, rozdzielczość, kolorystyka, ostrość czy balans bieli. Aparat umożliwia zapis video wraz z dźwiękiem. 32MB wewnętrznej pamięci może być rozszerzone o karty pamięci MMC lub SD.</p>', '', '94', 'Kodak DX 7630', 'Kodak DX 7630', 'Kodak DX 7630', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('6', '1', 'Kodak Z740', 'Cyfrowy aparat fotograficzny Kodak EasyShare Z740 z obiektywem o 10 krotnym przybliżeniu zapewnia niezwykłą możliwość wiernego uchwycenia detali fotografowanych motyw&oacute;w. Aparat Z740 wyposażyliśmy w rozwiązania techniczne, kt&oacute;re pomagają w wykonywaniu wspaniałych zdjęć. Matryca o rozdzielczości 5 mln pikseli, kt&oacute;ra zapewnia uzyskanie odbitek o maksymalnych wymiarach 50 x 75 cm.<br /><br />Automatyczne i ręczne ustawienia oraz łatwo dostępne programy tematyczne, ustawienia kolorystyczne, dają bardzo duże możliwości kreacji fotografującemu. Aparat Z740 posiada niezr&oacute;wnaną łatwość obsługi, jest elementem systemu EasyShare. Aparat ten posiada pamięć wewnętrzną o pojemności 32MB, kt&oacute;ra może być rozszerzona przez karty pamięci SD lub MMC.', '', '69', 'Kodak Z740', 'Kodak Z740', 'Kodak Z740', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('7', '1', 'Canon EOS 350D', 'Canon EOS 350D to następca modelu EOS 300D. Jest mniejszy, ale szybszy od poprzednika, oferuje zdecydowanie ciekawszy zestaw funkcji i wyposażony jest w sensor CMOS o rozdzielczości 8 megapikseli <br />
<br />
Canon EOS 350D Digital został wyposażony w dopiero co opracowany, mający bardzo niski poziom szumów, czujnik CMOS drugiej generacji o rozmiarach APS-C i rozdzielczości 8 mln pikseli. Jest to czwarty nowy czujnik obrazowy CMOS Canona w ciągu zaledwie dwunastu miesięcy. Jest on sterowany tym samym procesorem obrazu DIGIC II, który można spotkać w canonowskiej serii profesjonalnych cyfrowych lustrzanek jednoobiektywowych i umożliwia fotografowanie z szybkością 3 zdjęć na sekundę, z możliwością zrobienia 14 zdjęć w jednej serii. Aparat ma złącze USB 2.0 Hi-Speed, możliwość równoczesnego zapisu pliku RAW i dużego pliku JPEG i osiąga gotowość do zdjęć w ciągu 0,2 s od włączenia. Jest on o ponad 10% lżejszy i 25% mniejszy niż EOS 300D.', '', '1131', 'Canon EOS 350D', 'Canon EOS 350D', 'Canon EOS 350D', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('8', '1', 'Canon EOS 5D body', '<p>Canon EOS 5D to pierwsza, profesjonalna lustrzanka cyfrowa o niewielkiej budowie korpusu (porównywalnej do Canona 20D) z matrycą o rozmiarach 36x24mm (sensor CMOS), która odpowida dokładnie wymiarom klatki filmu 35mm. Taką konstrukcją z wieloma zaawansowanymi funkcjami może zainteresować się każdy fotograf, który szuka alternatywy dla ciężkich i dużych lustrzanek typu EOS-1Ds Mark II.</p>', '', '267', 'Canon EOS 5D body', 'Canon EOS 5D body', 'Canon EOS 5D body', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('9', '1', 'Olympus E-500', 'Cyfrowa lustrzanka Olympus E-500 to bez wątpienia czysta przyjemność fotografowania Hamburg, 26 września 2005 &ndash; W fotografii rzadko pojawia się powtórna szansa na wykonanie zdjęcia. Chwila, na którą spóźnimy się przepada bezpowrotnie. Wraz z aparatem Olympus E-500 gama cyfrowych lustrzanek Olympus E-System powiększa się o model adresowany do pół-profesjonalistów i ambitnych miłośników fotografii, aparat, na którym naprawdę można polegać &ndash; nawet pracując w wymagających warunkach i kurzu. Dzięki stanowiącemu wyłączne rozwiązanie firmy Olympus filtrowi ultradźwiękowemu, na zdjęcia nie mają wpływu drobinki i zabrudzenia stale obecne w powietrzu, a obraz jest wiernie rejestrowany z jakością 8.0 milionów pikseli na doskonałej matrycy CCD z pełnoklatkowym transferem danych (ang. Full Frame Transfer CCD). Natomiast dzięki niemal telecentrycznej optyce skonstruowanej specjalnie dla fotografowania cyfrowymi lustrzankami uzyskiwane zdjęcia mogą szczycić się wyjątkową jednorodnością obrazu, właściwą jasnością i wyraźnym oddaniem szczegółów na całej powierzchni kadru. Poza ergonomicznym, spełniającym profesjonalne wymogi rozmieszczeniem elementów sterujących walory użytkowe wzbogaca również wysokiej rozdzielczości ekran HyperCrystal LCD 6.4cm/2.5&rdquo; pozwalający na przeglądanie bezpośrednio w aparacie rezultatów zdjęć w odpowiednio dużym formacie. Ponadto, Olympus E-500 oferuje dwa gniazda kart pamięci - obsługując zarówno nośniki CompactFlash jak i xD-Picture Card. Zadziwiająco kompaktowy i lekki, prezentowany model jest idealnym towarzyszem podróży i nieocenioną pomocą na polu działań fotoreportera.', '', '160', 'Olympus E-500', 'Olympus E-500', 'Olympus E-500', 'olympus');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('10', '1', 'Nikon D50 czarny (Body)', 'Aparat D50 stanowi doskonałe wprowadzenie do fotografowania przy użyciu lustrzanek cyfrowych. Jego atutem jest szeroka gama automatycznych funkcji, kt&oacute;re ułatwiają robienie świetnych zdjęć. W każdej sytuacji zdjęciowej można wybrać cyfrowy program tematyczny, kt&oacute;ry dobierze ustawienia aparatu zapewniające optymalną ekspozycję. Wystarczy wybrać pokrętłem odpowiedni tryb, a D50 zadba o całą resztę. Aparat jest mały, lekki, doskonale leży w rękach i robi ostre, wyraźne zdjęcia, oferując jednocześnie dodatkowe możliwości w zakresie kontroli i kreatywności.', '', '164', 'Nikon D50 czarny (Body)', 'Nikon D50 czarny (Body)', 'Nikon D50 czarny (Body)', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('11', '1', 'Sony DCR-DVD205E', '<!-- TW_OPIS_START -->
<div class=\"opis_z_subiekta\">F-Secure Anti-Virus 2007 na 3 komputery (PC)</div>
<!-- TW_OPIS_END --><!-- TW_CHAR_START -->
<div class=\"charakterystyka_z_subiekta\">
<p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\"><strong>Producent: F-Secure</strong><span style=\"display: none; mso-hide: all\"><br />
</span></span></p>
<div align=\"center\">
<table class=\"MsoNormalTable\" style=\"width: 100%; mso-cellspacing: 0cm; mso-padding-alt: 1.5pt 1.5pt 1.5pt 1.5pt\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\">
    <tbody>
        <tr style=\"mso-yfti-irow: 0\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" colspan=\"2\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Opis Techniczny: </span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 1\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Kod producenta</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">FCA7BR1N003PL</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 2\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Zastosowanie</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Pakiet do użytku komercyjnego</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 3\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Wersja</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Pełny pakiet, wersja pudełkowa produktu (BOX) z licencja na 3 komputery z 12 miesięczna aktualizacja</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 4\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Pakiet zawiera</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Nośnik, licencje na 3 PC z aktualizacja na 12 miesięcy, instrukcja</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 5\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Opis</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Oprogramowanie F-Secure Anti-Virus to pewność, że Twoje dane są bezpieczne, kiedy korzystasz z sieci. Możesz otwierać załączniki poczty elektronicznej, bez obaw używać konta bankowego on-line, robić zakupy w wirtualnych sklepach, licytować na aukcja</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 6\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">&nbsp;</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">F-Secure Anti-Virus zapewnia skuteczną ochronę dzięki integracji mechanizmów zabezpieczających przed oprogramowaniem szpiegującym, wyświetlającym niechciane reklamy, a także atakami hakerów, wirusów, robaków oraz dotychczas nieznanych typów zagrożeń. , F-Secure Anti-Virus to: Bezpieczne korzystanie z Internetu kiedy chcesz i jak chcesz, Pełna ochrona przed cyberoszustami, Zero niechcianych wiadomości, Zero natrętnie wyświetlanych reklam, Zero programów szpiegujących</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 7\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Liczba użytkowników</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Nie dotyczy</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 8\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Liczba stanowisk</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">3 szt</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 9\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Wersja językowa</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">polska</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 10\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Wymagania systemowe</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Microsoft&reg; Windows&reg; 2000/XP, Internet Explorer 5.0 lub późniejszy oraz polaczenie do Internetu</span></p>
            </td>
        </tr>
        <tr style=\"mso-yfti-irow: 11; mso-yfti-lastrow: yes\">
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 23.98%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" valign=\"top\" width=\"23%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Wymagania sprzętowe</span></p>
            </td>
            <td style=\"border-right: #d4d0c8; padding-right: 1.5pt; border-top: #d4d0c8; padding-left: 1.5pt; padding-bottom: 1.5pt; border-left: #d4d0c8; width: 76.02%; padding-top: 1.5pt; border-bottom: #d4d0c8; background-color: transparent\" width=\"76%\">
            <p class=\"MsoNormal\" style=\"margin: 0cm 0cm 0pt\"><span style=\"font-size: 10pt; font-family: Arial\">Minimum Intel Pentium II 600 Mhz, 256 MB pamięci, Disk Space: Max. 500 MB podczas instalacji</span></p>
            </td>
        </tr>
    </tbody>
</table>
</div>
</div>
<!-- TW_CHAR_END --><!-- TW_UWAGI_START -->
<div class=\"uwagi_z_subiekta\">&nbsp;</div>
<!-- TW_UWAGI_END -->', '', '324', 'Sony DCR-DVD205E', 'Sony DCR-DVD205E', 'Sony DCR-DVD205E', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('12', '1', 'Sony DCR-DVD505E', 'W kamerze DCR-DVD505E wykorzystano najnowocześniejsze rozwiązania technologiczne: poprawiający obraz przetwornik ClearVid CMOS, czytelny ekran LCD 3,5&quot; czy system nagrywania 5.1-kanałowego dźwięku przestrzennego', '', '166', 'Sony DCR-DVD505E', 'Sony DCR-DVD505E', 'Sony DCR-DVD505E', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('13', '1', 'Canon MV800', '<p>MV800 z 20x optycznym zoomem, procesorem DiGIC DV i trybem Easy, łączy w sobie wysoką jakość z canonowską prostotą obsługi. Jej cechy to kolorowy ekran 2.4&quot; ekran LCD, tryb szerokiego ekranu 16:9 i stabilizator obrazu.</p>', '', '108', 'Canon MV800', 'Canon MV800', 'Canon MV800', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('14', '1', 'Canon MVX300', 'Dzięki doskonałej ergonomii, procesorowi DiGIC DV, rozdzielczośći 1.33 mln pikseli, 18x optycznym zoomie, elektronicznej stabilizacji obrazu i dużemu 2.5&quot; wyświetlaczowi LCD kamera MV300 z pewnością spodoba się tym kt&oacute;rzy oczekują produkt&oacute;w z dużą ilością funkcji, znakomicie zaprojektowanych i elegancko wykończonych.', '', '300', 'Canon MVX300', 'Canon MVX300', 'Canon MVX300', '');
insert into products_description (products_id, language_id, products_name, products_description, products_url, products_viewed, products_head_title_tag, products_head_desc_tag, products_head_keywords_tag, products_seo_url) values ('15', '1', 'Canon MVX35i', 'Wyjątkowy, działający niezależnie w trybie filmowania i robienia zdjęc procesor DIGIC DV, powoduje że kamery MVX35i pozwalaja uzyskać doskonałe zdjęcia i filmy.', '', '111', 'Canon MVX35i', 'Canon MVX35i', 'Canon MVX35i', '');
drop table if exists products_extra_fields;
create table products_extra_fields (
  products_extra_fields_id int(11) not null auto_increment,
  products_extra_fields_name varchar(64) not null ,
  products_extra_fields_order int(3) not null ,
  products_extra_fields_status tinyint(1) not null ,
  languages_id int(11) not null ,
  PRIMARY KEY (products_extra_fields_id)
);

insert into products_extra_fields (products_extra_fields_id, products_extra_fields_name, products_extra_fields_order, products_extra_fields_status, languages_id) values ('1', 'test', '1', '1', '0');
insert into products_extra_fields (products_extra_fields_id, products_extra_fields_name, products_extra_fields_order, products_extra_fields_status, languages_id) values ('2', 'kolumna', '2', '1', '0');
drop table if exists products_notifications;
create table products_notifications (
  products_id int(11) not null ,
  customers_id int(11) not null ,
  date_added datetime not null ,
  PRIMARY KEY (products_id, customers_id),
  KEY customers_id (customers_id),
  KEY date_added (date_added)
);

insert into products_notifications (products_id, customers_id, date_added) values ('3', '1', '2006-07-09 23:27:15');
insert into products_notifications (products_id, customers_id, date_added) values ('1', '11', '2007-08-07 10:39:34');
drop table if exists products_options;
create table products_options (
  products_options_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  products_options_name varchar(32) not null ,
  products_options_track_stock tinyint(4) default '0' not null ,
  products_options_sort_order int(6) not null ,
  products_options_images_enabled varchar(5) default 'false' not null ,
  PRIMARY KEY (products_options_id, language_id)
);

insert into products_options (products_options_id, language_id, products_options_name, products_options_track_stock, products_options_sort_order, products_options_images_enabled) values ('1', '1', 'Karta pamięci', '1', '0', 'true');
insert into products_options (products_options_id, language_id, products_options_name, products_options_track_stock, products_options_sort_order, products_options_images_enabled) values ('2', '1', 'Kolor', '0', '0', 'false');
drop table if exists products_options_products;
create table products_options_products (
  pop_id int(11) not null auto_increment,
  pop_products_id_master int(11) default '0' not null ,
  pop_products_id_slave int(11) default '0' not null ,
  pop_order_id smallint(6) default '0' not null ,
  PRIMARY KEY (pop_id)
);

insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('1', '4', '3', '1');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('2', '4', '1', '2');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('5', '3', '4', '1');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('4', '3', '1', '0');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('6', '3', '2', '2');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('7', '2', '1', '0');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('8', '2', '4', '0');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('10', '2', '3', '0');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('11', '14', '7', '0');
insert into products_options_products (pop_id, pop_products_id_master, pop_products_id_slave, pop_order_id) values ('12', '14', '15', '1');
drop table if exists products_options_values;
create table products_options_values (
  products_options_values_id int(11) default '0' not null ,
  language_id int(11) default '1' not null ,
  products_options_values_name varchar(64) not null ,
  products_options_values_thumbnail varchar(60) not null ,
  PRIMARY KEY (products_options_values_id, language_id)
);

insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('1', '1', '128MB', 'default.gif');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('2', '1', '256MB', 'default.gif');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('3', '1', '512MB', 'default.gif');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('4', '1', '1024MB', 'default.gif');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('5', '1', 'Srebrny', '');
insert into products_options_values (products_options_values_id, language_id, products_options_values_name, products_options_values_thumbnail) values ('6', '1', 'Czarny', '');
drop table if exists products_options_values_to_products_options;
create table products_options_values_to_products_options (
  products_options_values_to_products_options_id int(11) not null auto_increment,
  products_options_id int(11) not null ,
  products_options_values_id int(11) not null ,
  products_options_values_sort_order int(6) default '0' not null ,
  PRIMARY KEY (products_options_values_to_products_options_id)
);

insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('1', '1', '1', '1');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('2', '1', '2', '2');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('3', '1', '3', '3');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('4', '1', '4', '4');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('5', '2', '5', '1');
insert into products_options_values_to_products_options (products_options_values_to_products_options_id, products_options_id, products_options_values_id, products_options_values_sort_order) values ('6', '2', '6', '2');
drop table if exists products_stock;
create table products_stock (
  products_stock_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  products_stock_attributes varchar(255) not null ,
  products_stock_quantity int(11) default '0' not null ,
  PRIMARY KEY (products_stock_id),
  UNIQUE idx_products_stock_attributes (products_id, products_stock_attributes)
);

insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('1', '7', '1-2,2-5', '5');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('2', '7', '1-2,2-6', '1');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('3', '7', '1-3,2-5', '1');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('4', '7', '1-3,2-6', '1');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('5', '7', '1-4,2-5', '0');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('6', '7', '1-4,2-6', '5');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('7', '7', '2-5', '5');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('8', '7', '2-6', '5');
insert into products_stock (products_stock_id, products_id, products_stock_attributes, products_stock_quantity) values ('9', '4', '1-4', '100');
drop table if exists products_to_categories;
create table products_to_categories (
  products_id int(11) not null ,
  categories_id int(11) not null ,
  PRIMARY KEY (products_id, categories_id),
  KEY categories_id (categories_id),
  KEY products_id (products_id)
);

insert into products_to_categories (products_id, categories_id) values ('1', '2');
insert into products_to_categories (products_id, categories_id) values ('2', '2');
insert into products_to_categories (products_id, categories_id) values ('3', '2');
insert into products_to_categories (products_id, categories_id) values ('4', '1');
insert into products_to_categories (products_id, categories_id) values ('5', '1');
insert into products_to_categories (products_id, categories_id) values ('6', '1');
insert into products_to_categories (products_id, categories_id) values ('7', '3');
insert into products_to_categories (products_id, categories_id) values ('8', '3');
insert into products_to_categories (products_id, categories_id) values ('9', '3');
insert into products_to_categories (products_id, categories_id) values ('10', '3');
insert into products_to_categories (products_id, categories_id) values ('11', '5');
insert into products_to_categories (products_id, categories_id) values ('12', '5');
insert into products_to_categories (products_id, categories_id) values ('13', '2');
insert into products_to_categories (products_id, categories_id) values ('13', '6');
insert into products_to_categories (products_id, categories_id) values ('14', '6');
insert into products_to_categories (products_id, categories_id) values ('15', '6');
drop table if exists products_to_products_extra_fields;
create table products_to_products_extra_fields (
  products_id int(11) not null ,
  products_extra_fields_id int(11) not null ,
  products_extra_fields_value varchar(64) ,
  PRIMARY KEY (products_id, products_extra_fields_id),
  KEY products_id (products_id)
);

insert into products_to_products_extra_fields (products_id, products_extra_fields_id, products_extra_fields_value) values ('11', '1', 'opis 1');
insert into products_to_products_extra_fields (products_id, products_extra_fields_id, products_extra_fields_value) values ('11', '2', 'opis 2');
drop table if exists reviews;
create table reviews (
  reviews_id int(11) not null auto_increment,
  products_id int(11) not null ,
  customers_id int(11) ,
  customers_name varchar(64) not null ,
  reviews_rating int(1) ,
  date_added datetime ,
  last_modified datetime ,
  reviews_read int(5) default '0' not null ,
  approved tinyint(3) unsigned default '0' ,
  PRIMARY KEY (reviews_id),
  KEY customers_id (customers_id),
  KEY products_id (products_id)
);

insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('1', '9', NULL, 'Jacek Krysiak', '3', '2006-06-19 13:18:06', NULL, '19', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('2', '7', NULL, 'Jacek Krysiak', '3', '2006-06-19 13:42:56', NULL, '36', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('3', '7', NULL, 'Jacek Krysiak', '5', '2006-09-10 20:31:54', NULL, '0', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('4', '7', NULL, 'Jacek Krysiak', '3', '2006-09-10 20:32:10', NULL, '2', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('5', '7', NULL, 'Jacek Krysiak', '3', '2006-09-10 20:37:03', NULL, '1', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('6', '7', NULL, 'Jacek Krysiak', '3', '2006-09-10 20:44:09', NULL, '2', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('7', '7', NULL, 'Jacek Krysiak', '4', '2006-09-10 20:47:27', NULL, '1', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('8', '7', NULL, 'Jacek Krysiak', '4', '2006-09-10 20:47:53', NULL, '3', '1');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('9', '7', NULL, 'Jacek Krysiak', '3', '2006-09-10 20:49:34', NULL, '2', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('10', '7', NULL, 'Jacek Krysiak', '5', '2006-09-10 20:51:26', NULL, '3', '1');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('11', '7', NULL, 'Jacek Krysiak', '4', '2006-09-10 20:53:26', NULL, '3', '1');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('12', '7', NULL, 'Jacek Krysiak', '4', '2006-09-10 20:54:36', NULL, '3', '1');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('13', '7', NULL, 'Jacek Krysiak', '5', '2006-09-10 20:55:10', NULL, '3', '1');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('14', '12', NULL, 'Jacek Krysiak', '3', '2007-02-09 14:37:08', NULL, '0', '0');
insert into reviews (reviews_id, products_id, customers_id, customers_name, reviews_rating, date_added, last_modified, reviews_read, approved) values ('15', '1', NULL, 'Jacek Krysiak', '4', '2007-08-07 10:37:35', NULL, '0', '1');
drop table if exists reviews_description;
create table reviews_description (
  reviews_id int(11) not null ,
  languages_id int(11) not null ,
  reviews_text text not null ,
  PRIMARY KEY (reviews_id, languages_id),
  KEY languages_id (languages_id)
);

insert into reviews_description (reviews_id, languages_id, reviews_text) values ('1', '1', 'Bardzo dobry produkt, spelniający wysokie wymagania użytkownika');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('2', '1', 'Testowa recenzja produktu napisana do celów kontrolnych');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('3', '1', 'dfsfnlkfdslkfm dslkfsmd flkmdsf ldsmfkdsl fsdlkfm dslkf m sdlfkmsd flkdsmf lsdkfm sdlkfmds lkfm dsflksdm flksdmflkm lkm lkmlkmlk');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('4', '1', 'jhkjh kkjhkhkjn kjn kjn kjn kjn kjnknj kjnkn kjn kn kjn kjn kjnknknj knkj kjnkjn kn');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('5', '1', 'kjhj kjnk xnkdjfnskdfn dsfndskfj snfkdsfjn sdkfnskdfj nsdkfjns fkjsdfn kjsdfn ksjfn dskfjn kjn kjn kjn k');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('6', '1', 'dsfkjsd fsdfnskfnsdkf sdkfjndsf kjdsnfksdj nfkdsj nfksdjfn kjn kjn kjn kjn kjnkjnkjn');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('7', '1', 'sdfnsdfsd fnlsdkf lsdfksdl fkf kdsfm lfkmds fldmkf ldskfmlsdkf sldkfms dlfksdmflds mflkm lkm');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('8', '1', 'dsfsjf lsflkdsfj sdlfkj lkj lkj lkj lkj lkj lkjlk lklkmlkm lkmlkm lmlkm lmklkmlfm slfkmslfms lfmsfls kmflskfmlfkmflskmf lkmlk');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('9', '1', 'sdfsfn fjns fksjnfksdjnfs dkfnjsf kjnfk sjfskfjsnfkjsnf kjnkjn kj nkjnkjnkjnkj jkkjnkj nkjn');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('10', '1', 'jk kjhk hfk sdhfkdfjh sfkjshfkashfkjsfkasdnfksjf ndskfjnd kfjns fkjsd nfjkdsfndksjf ndsjkfndsjkfdsnfkjfdnkjn kjnlknkkjn');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('11', '1', 'k lsmflksmflsfkmlkfm lfkmsf lkdsm lkm lkm lkmlkmlkm lmlkmlmlkm lkml');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('12', '1', 'jkhn kjnknkjnk n kn kj nkjnjkbf jsdfbsdj bdj bbgkjbhdsgf kfksdjf nknksdjfn dskfjndsfkj nkjn kjnkjnkj kjn');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('13', '1', 'sdfnsl kfsdlfkmsdlkfmsd lfkmsdlfkm sdflkmsdflksdmf lkdsmfdlskfmsdlfkmsdlkfmsdlfkmsdlfmsflmdsflksdmf ldkfdslfmdsflkdm fdlsmf dsl fkmsdfldksmfslkfj weopr\'we
fok\'pjio wfjpojipojij');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('14', '1', 'sdadadad jdasjdjd skjdaskjdnas djnkjdn kjd nasjnkjn kjnkjnkjnkjnkj nj');
insert into reviews_description (reviews_id, languages_id, reviews_text) values ('15', '1', 'Taki sobie produkcik. sdasdasd askjdnkjdn sdkjnsdkasdnksjdn kj nkjn jn');
drop table if exists sessions;
create table sessions (
  sesskey varchar(32) not null ,
  expiry int(11) unsigned not null ,
  value text not null ,
  PRIMARY KEY (sesskey)
);

drop table if exists ship2pay;
create table ship2pay (
  s2p_id int(11) not null auto_increment,
  shipment varchar(100) not null ,
  payments_allowed varchar(250) not null ,
  status tinyint(4) default '0' not null ,
  PRIMARY KEY (s2p_id)
);

insert into ship2pay (s2p_id, shipment, payments_allowed, status) values ('16', 'pocztapripobraniowa', 'pobraniepocztapolska.php', '1');
insert into ship2pay (s2p_id, shipment, payments_allowed, status) values ('12', 'odbiorosobisty', 'plbanktransfer.php;gotowkaprzyodbiorzeosobistym.php', '1');
insert into ship2pay (s2p_id, shipment, payments_allowed, status) values ('13', 'pocztapriorytetowa', 'plbanktransfer.php', '1');
insert into ship2pay (s2p_id, shipment, payments_allowed, status) values ('15', 'kosztsprzedawcy', 'plbanktransfer.php', '1');
drop table if exists specials;
create table specials (
  specials_id int(11) not null auto_increment,
  products_id int(11) not null ,
  specials_new_products_price decimal(15,4) not null ,
  specials_date_added datetime ,
  specials_last_modified datetime ,
  expires_date datetime ,
  date_status_change datetime ,
  status int(1) default '1' not null ,
  customers_groups_id int(11) default '0' not null ,
  customers_id int(11) default '0' not null ,
  PRIMARY KEY (specials_id),
  KEY products_id (products_id),
  KEY specials_date_added (specials_date_added),
  KEY status (status),
  KEY expires_date (expires_date)
);

insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('2', '14', '1638.5246', '2006-06-22 14:40:00', NULL, '0000-00-00 00:00:00', NULL, '1', '0', '0');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('10', '11', '1638.5246', '2007-09-11 08:43:21', NULL, NULL, NULL, '1', '0', '0');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('7', '8', '8196.7213', '2006-07-04 13:35:41', NULL, '0000-00-00 00:00:00', NULL, '1', '0', '0');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('6', '7', '1639.3443', '2006-07-03 19:30:45', NULL, '0000-00-00 00:00:00', NULL, '1', '0', '0');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('8', '13', '818.8525', '2007-09-06 08:31:23', NULL, NULL, NULL, '1', '0', '0');
insert into specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, expires_date, date_status_change, status, customers_groups_id, customers_id) values ('9', '5', '736.8852', '2007-09-11 08:38:03', NULL, NULL, NULL, '1', '0', '0');
drop table if exists star_product;
create table star_product (
  star_product_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  star_product_date_added datetime ,
  star_product_last_modified datetime ,
  expires_date datetime ,
  date_status_change datetime ,
  status int(11) default '1' ,
  PRIMARY KEY (star_product_id),
  KEY products_id (products_id),
  KEY status (status)
);

insert into star_product (star_product_id, products_id, star_product_date_added, star_product_last_modified, expires_date, date_status_change, status) values ('4', '7', '2007-08-20 09:50:26', '2007-08-20 10:14:07', NULL, NULL, '1');
insert into star_product (star_product_id, products_id, star_product_date_added, star_product_last_modified, expires_date, date_status_change, status) values ('5', '5', '2007-08-20 10:00:42', NULL, NULL, NULL, '1');
drop table if exists subscribers;
create table subscribers (
  subscribers_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  subscribers_email_address varchar(80) not null ,
  subscribers_firstname varchar(40) ,
  subscribers_lastname varchar(40) ,
  language varchar(30) ,
  subscribers_gender char(1) ,
  subscribers_email_type varchar(5) ,
  entry_date date ,
  undeliverable_count mediumint(11) default '0' ,
  mail_details_customers_id int(5) default '0' ,
  list_number int(5) default '0' ,
  source_import varchar(70) ,
  date_account_created datetime ,
  date_account_last_modified datetime ,
  customers_newsletter int(4) ,
  subscribers_blacklist int(2) default '0' ,
  subscription_date datetime ,
  status_sent1 int(2) default '0' ,
  host_name varchar(25) ,
  hardiness_zone char(3) ,
  PRIMARY KEY (subscribers_id),
  KEY list_number (list_number)
);

insert into subscribers (subscribers_id, customers_id, subscribers_email_address, subscribers_firstname, subscribers_lastname, language, subscribers_gender, subscribers_email_type, entry_date, undeliverable_count, mail_details_customers_id, list_number, source_import, date_account_created, date_account_last_modified, customers_newsletter, subscribers_blacklist, subscription_date, status_sent1, host_name, hardiness_zone) values ('1', '0', 'jacek@admin.pl', NULL, '', 'English', NULL, '', NULL, '0', '0', '0', 'subscribe_newsletter', '2006-10-30 20:26:31', NULL, '1', '0', NULL, '1', NULL, '');
insert into subscribers (subscribers_id, customers_id, subscribers_email_address, subscribers_firstname, subscribers_lastname, language, subscribers_gender, subscribers_email_type, entry_date, undeliverable_count, mail_details_customers_id, list_number, source_import, date_account_created, date_account_last_modified, customers_newsletter, subscribers_blacklist, subscription_date, status_sent1, host_name, hardiness_zone) values ('2', '0', 'admin@garbolandia.com', 'Jacek', 'Krysiak', 'English', NULL, '', NULL, '0', '0', '0', 'subscribe_newsletter', '2006-12-11 13:52:03', '2007-05-17 12:45:30', '0', '0', NULL, '1', NULL, '');
insert into subscribers (subscribers_id, customers_id, subscribers_email_address, subscribers_firstname, subscribers_lastname, language, subscribers_gender, subscribers_email_type, entry_date, undeliverable_count, mail_details_customers_id, list_number, source_import, date_account_created, date_account_last_modified, customers_newsletter, subscribers_blacklist, subscription_date, status_sent1, host_name, hardiness_zone) values ('3', '11', 'info@oscgold.com', 'Jacek', 'Krysiak', 'English', 'f', 'Text', '2007-05-17', '0', '0', '0', 'CUSTOMERS', '2007-05-17 12:44:50', '2007-05-17 12:45:30', '1', '0', NULL, '0', NULL, NULL);
drop table if exists subscribers_default;
create table subscribers_default (
  news_id int(11) not null auto_increment,
  module_subscribers varchar(255) not null ,
  header text not null ,
  date_added datetime not null ,
  status tinyint(1) default '0' not null ,
  news_order int(2) default '0' not null ,
  unsubscribea longtext not null ,
  unsubscribeb longtext not null ,
  PRIMARY KEY (news_id)
);

insert into subscribers_default (news_id, module_subscribers, header, date_added, status, news_order, unsubscribea, unsubscribeb) values ('1', 'Moduł newsletter_subscribers', '<p>Otrzymujesz tego maila ponieważ zarejestrowałeś się w sklepie oscGold.</p>', '2002-11-28 09:31:06', '1', '0', 'Możesz zrezygnować z subskrypcji biuletynu tutaj :', 'Dziękujemy za zainteresowanie.');
insert into subscribers_default (news_id, module_subscribers, header, date_added, status, news_order, unsubscribea, unsubscribeb) values ('2', 'Moduł newsletter', '', '2005-01-04 03:51:20', '1', '0', '<div>Aby zrezygnować z subskrypcji kliknij tutaj :</div>', '<div>Dziękujemy</div>');
insert into subscribers_default (news_id, module_subscribers, header, date_added, status, news_order, unsubscribea, unsubscribeb) values ('3', 'Moduł product_notification', '', '2005-01-04 03:53:10', '1', '0', '<div>Aby zrezygnować</div>', '<div>Dziękujemy</div>');
drop table if exists subscribers_infos;
create table subscribers_infos (
  news_id int(11) not null auto_increment,
  newsletters_id int(11) default '0' not null ,
  module_subscribers varchar(255) not null ,
  header text not null ,
  date_added datetime not null ,
  status tinyint(1) default '0' not null ,
  news_order int(2) default '0' not null ,
  unsubscribea longtext not null ,
  unsubscribeb longtext not null ,
  PRIMARY KEY (news_id)
);

insert into subscribers_infos (news_id, newsletters_id, module_subscribers, header, date_added, status, news_order, unsubscribea, unsubscribeb) values ('3', '3', 'Moduł newsletter', '', '2006-09-12 11:15:39', '1', '0', '<div>Aby zrezygnować z subskrypcji kliknij tutaj :</div>', '<div>Dziękujemy za subskrypcje</div>');
drop table if exists subscribers_update;
create table subscribers_update (
  newsletters_id int(11) not null auto_increment,
  title varchar(255) not null ,
  content text not null ,
  module varchar(255) not null ,
  date_added datetime not null ,
  date_sent datetime ,
  status int(1) ,
  locked int(1) default '0' ,
  action text not null ,
  set_order int(2) default '0' not null ,
  PRIMARY KEY (newsletters_id)
);

insert into subscribers_update (newsletters_id, title, content, module, date_added, date_sent, status, locked, action, set_order) values ('1', 'Aktualizacja tebeli Subskrybenci', 'Porównanie tabeli zarejestrowanych klientów sklepu z tabelą subskrybentów biuletynu.', 'newsletter', '2002-11-27 15:13:25', '2002-11-27 15:13:25', '1', '1', 'update', '1');
insert into subscribers_update (newsletters_id, title, content, module, date_added, date_sent, status, locked, action, set_order) values ('2', 'Aktualizacja nazw', 'Aktualizacja pól imię i nazwisko z tablicy zarejestrowanych klientów sklepu.', '', '2002-11-29 14:42:20', '2002-11-29 14:42:20', '1', '1', 'update', '2');
drop table if exists tax_class;
create table tax_class (
  tax_class_id int(11) not null auto_increment,
  tax_class_title varchar(32) not null ,
  tax_class_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime not null ,
  PRIMARY KEY (tax_class_id)
);

insert into tax_class (tax_class_id, tax_class_title, tax_class_description, last_modified, date_added) values ('1', 'Vat_0', '0% podatek VAT', NULL, '2006-05-27 18:50:09');
insert into tax_class (tax_class_id, tax_class_title, tax_class_description, last_modified, date_added) values ('2', 'Vat_7', '7% podatek VAT', NULL, '2006-05-27 18:50:24');
insert into tax_class (tax_class_id, tax_class_title, tax_class_description, last_modified, date_added) values ('3', 'Vat_22', '22% podatek VAT', NULL, '2006-05-27 18:50:36');
drop table if exists tax_rates;
create table tax_rates (
  tax_rates_id int(11) not null auto_increment,
  tax_zone_id int(11) not null ,
  tax_class_id int(11) not null ,
  tax_priority int(5) default '1' ,
  tax_rate decimal(7,4) not null ,
  tax_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime not null ,
  PRIMARY KEY (tax_rates_id),
  KEY tax_class_id (tax_class_id)
);

insert into tax_rates (tax_rates_id, tax_zone_id, tax_class_id, tax_priority, tax_rate, tax_description, last_modified, date_added) values ('1', '1', '3', '0', '22.0000', 'VAT-22', '2007-07-13 13:09:51', '2006-05-27 18:51:13');
insert into tax_rates (tax_rates_id, tax_zone_id, tax_class_id, tax_priority, tax_rate, tax_description, last_modified, date_added) values ('2', '1', '2', '1', '7.0000', 'VAT-7', NULL, '2006-05-27 18:51:46');
insert into tax_rates (tax_rates_id, tax_zone_id, tax_class_id, tax_priority, tax_rate, tax_description, last_modified, date_added) values ('3', '1', '1', '2', '0.0000', 'VAT-0', NULL, '2006-05-27 18:51:59');
drop table if exists whos_online;
create table whos_online (
  customer_id int(11) not null ,
  full_name varchar(64) not null ,
  session_id varchar(128) not null ,
  ip_address varchar(15) not null ,
  time_entry varchar(14) not null ,
  time_last_click varchar(14) not null ,
  last_page_url varchar(255) not null ,
  http_referer varchar(255) not null ,
  user_agent varchar(255) not null ,
  PRIMARY KEY (session_id)
);

drop table if exists zones;
create table zones (
  zone_id int(11) not null auto_increment,
  zone_country_id int(11) not null ,
  zone_code varchar(32) not null ,
  zone_name varchar(32) not null ,
  PRIMARY KEY (zone_id),
  KEY zone_country_id (zone_country_id),
  KEY zone_name (zone_name),
  KEY zone_code (zone_code)
);

insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1', '170', 'DOL', 'Dolonośląskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2', '170', 'KPO', 'Kujawsko-Pomorskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3', '170', 'LUB', 'Lubelskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4', '170', 'LBU', 'Lubuskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('5', '170', 'LOD', 'Łódzkie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('6', '170', 'MAL', 'Małopolskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('7', '170', 'MAZ', 'Mazowieckie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('8', '170', 'OPO', 'Opolskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('9', '170', 'KAR', 'Karpackie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('10', '170', 'POD', 'Podkarpackie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('11', '170', 'PDL', 'Podlaskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('12', '170', 'POM', 'Pomorskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('13', '170', 'SLA', 'Śląskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('14', '170', 'SWI', 'Świętokrzyskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('15', '170', 'WAM', 'Warmińsko-Mazurskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('16', '170', 'WIE', 'Wielkopolskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('17', '170', 'ZAC', 'Zachodniopomorskie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('809', '1', 'BDS', 'Badakhshan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('810', '1', 'BDG', 'Badghis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('811', '1', 'BGL', 'Baghlan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('812', '1', 'BAL', 'Balkh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('813', '1', 'BAM', 'Bamian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('814', '1', 'FRA', 'Farah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('815', '1', 'FYB', 'Faryab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('816', '1', 'GHA', 'Ghazni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('817', '1', 'GHO', 'Ghowr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('818', '1', 'HEL', 'Helmand');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('819', '1', 'HER', 'Herat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('820', '1', 'JOW', 'Jowzjan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('821', '1', 'KAB', 'Kabul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('822', '1', 'KAN', 'Kandahar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('823', '1', 'KAP', 'Kapisa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('824', '1', 'KHO', 'Khost');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('825', '1', 'KNR', 'Konar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('826', '1', 'KDZ', 'Kondoz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('827', '1', 'LAG', 'Laghman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('828', '1', 'LOW', 'Lowgar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('829', '1', 'NAN', 'Nangrahar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('830', '1', 'NIM', 'Nimruz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('831', '1', 'NUR', 'Nurestan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('832', '1', 'ORU', 'Oruzgan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('833', '1', 'PIA', 'Paktia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('834', '1', 'PKA', 'Paktika');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('835', '1', 'PAR', 'Parwan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('836', '1', 'SAM', 'Samangan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('837', '1', 'SAR', 'Sar-e Pol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('838', '1', 'TAK', 'Takhar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('839', '1', 'WAR', 'Wardak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('840', '1', 'ZAB', 'Zabol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('841', '2', 'BR', 'Berat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('842', '2', 'BU', 'Bulqize');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('843', '2', 'DL', 'Delvine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('844', '2', 'DV', 'Devoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('845', '2', 'DI', 'Diber');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('846', '2', 'DR', 'Durres');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('847', '2', 'EL', 'Elbasan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('848', '2', 'ER', 'Kolonje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('849', '2', 'FR', 'Fier');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('850', '2', 'GJ', 'Gjirokaster');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('851', '2', 'GR', 'Gramsh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('852', '2', 'HA', 'Has');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('853', '2', 'KA', 'Kavaje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('854', '2', 'KB', 'Kurbin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('855', '2', 'KC', 'Kucove');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('856', '2', 'KO', 'Korce');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('857', '2', 'KR', 'Kruje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('858', '2', 'KU', 'Kukes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('859', '2', 'LB', 'Librazhd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('860', '2', 'LE', 'Lezhe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('861', '2', 'LU', 'Lushnje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('862', '2', 'MM', 'Malesi e Madhe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('863', '2', 'MK', 'Mallakaster');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('864', '2', 'MT', 'Mat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('865', '2', 'MR', 'Mirdite');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('866', '2', 'PQ', 'Peqin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('867', '2', 'PR', 'Permet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('868', '2', 'PG', 'Pogradec');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('869', '2', 'PU', 'Puke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('870', '2', 'SH', 'Shkoder');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('871', '2', 'SK', 'Skrapar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('872', '2', 'SR', 'Sarande');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('873', '2', 'TE', 'Tepelene');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('874', '2', 'TP', 'Tropoje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('875', '2', 'TR', 'Tirane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('876', '2', 'VL', 'Vlore');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('877', '3', 'ADR', 'Adrar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('878', '3', 'ADE', 'Ain Defla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('879', '3', 'ATE', 'Ain Temouchent');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('880', '3', 'ALG', 'Alger');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('881', '3', 'ANN', 'Annaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('882', '3', 'BAT', 'Batna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('883', '3', 'BEC', 'Bechar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('884', '3', 'BEJ', 'Bejaia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('885', '3', 'BIS', 'Biskra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('886', '3', 'BLI', 'Blida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('887', '3', 'BBA', 'Bordj Bou Arreridj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('888', '3', 'BOA', 'Bouira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('889', '3', 'BMD', 'Boumerdes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('890', '3', 'CHL', 'Chlef');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('891', '3', 'CON', 'Constantine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('892', '3', 'DJE', 'Djelfa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('893', '3', 'EBA', 'El Bayadh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('894', '3', 'EOU', 'El Oued');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('895', '3', 'ETA', 'El Tarf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('896', '3', 'GHA', 'Ghardaia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('897', '3', 'GUE', 'Guelma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('898', '3', 'ILL', 'Illizi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('899', '3', 'JIJ', 'Jijel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('900', '3', 'KHE', 'Khenchela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('901', '3', 'LAG', 'Laghouat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('902', '3', 'MUA', 'Muaskar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('903', '3', 'MED', 'Medea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('904', '3', 'MIL', 'Mila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('905', '3', 'MOS', 'Mostaganem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('906', '3', 'MSI', 'M\'Sila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('907', '3', 'NAA', 'Naama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('908', '3', 'ORA', 'Oran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('909', '3', 'OUA', 'Ouargla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('910', '3', 'OEB', 'Oum el-Bouaghi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('911', '3', 'REL', 'Relizane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('912', '3', 'SAI', 'Saida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('913', '3', 'SET', 'Setif');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('914', '3', 'SBA', 'Sidi Bel Abbes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('915', '3', 'SKI', 'Skikda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('916', '3', 'SAH', 'Souk Ahras');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('917', '3', 'TAM', 'Tamanghasset');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('918', '3', 'TEB', 'Tebessa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('919', '3', 'TIA', 'Tiaret');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('920', '3', 'TIN', 'Tindouf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('921', '3', 'TIP', 'Tipaza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('922', '3', 'TIS', 'Tissemsilt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('923', '3', 'TOU', 'Tizi Ouzou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('924', '3', 'TLE', 'Tlemcen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('925', '4', 'E', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('926', '4', 'M', 'Manu\'a');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('927', '4', 'R', 'Rose Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('928', '4', 'S', 'Swains Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('929', '4', 'W', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('930', '5', 'ALV', 'Andorra la Vella');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('931', '5', 'CAN', 'Canillo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('932', '5', 'ENC', 'Encamp');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('933', '5', 'ESE', 'Escaldes-Engordany');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('934', '5', 'LMA', 'La Massana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('935', '5', 'ORD', 'Ordino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('936', '5', 'SJL', 'Sant Julia de L?ria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('937', '6', 'BGO', 'Bengo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('938', '6', 'BGU', 'Benguela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('939', '6', 'BIE', 'Bie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('940', '6', 'CAB', 'Cabinda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('941', '6', 'CCU', 'Cuando-Cubango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('942', '6', 'CNO', 'Cuanza Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('943', '6', 'CUS', 'Cuanza Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('944', '6', 'CNN', 'Cunene');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('945', '6', 'HUA', 'Huambo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('946', '6', 'HUI', 'Huila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('947', '6', 'LUA', 'Luanda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('948', '6', 'LNO', 'Lunda Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('949', '6', 'LSU', 'Lunda Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('950', '6', 'MAL', 'Malange');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('951', '6', 'MOX', 'Moxico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('952', '6', 'NAM', 'Namibe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('953', '6', 'UIG', 'Uige');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('954', '6', 'ZAI', 'Zaire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('955', '9', 'ASG', 'Saint George');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('956', '9', 'ASJ', 'Saint John');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('957', '9', 'ASM', 'Saint Mary');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('958', '9', 'ASL', 'Saint Paul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('959', '9', 'ASR', 'Saint Peter');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('960', '9', 'ASH', 'Saint Philip');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('961', '9', 'BAR', 'Barbuda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('962', '9', 'RED', 'Redonda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('963', '10', 'AN', 'Antartida e Islas del Atlantico ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('964', '10', 'BA', 'Buenos Aires');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('965', '10', 'CA', 'Catamarca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('966', '10', 'CH', 'Chaco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('967', '10', 'CU', 'Chubut');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('968', '10', 'CO', 'Cordoba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('969', '10', 'CR', 'Corrientes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('970', '10', 'DF', 'Distrito Federal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('971', '10', 'ER', 'Entre Rios');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('972', '10', 'FO', 'Formosa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('973', '10', 'JU', 'Jujuy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('974', '10', 'LP', 'La Pampa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('975', '10', 'LR', 'La Rioja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('976', '10', 'ME', 'Mendoza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('977', '10', 'MI', 'Misiones');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('978', '10', 'NE', 'Neuquen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('979', '10', 'RN', 'Rio Negro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('980', '10', 'SA', 'Salta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('981', '10', 'SJ', 'San Juan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('982', '10', 'SL', 'San Luis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('983', '10', 'SC', 'Santa Cruz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('984', '10', 'SF', 'Santa Fe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('985', '10', 'SD', 'Santiago del Estero');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('986', '10', 'TF', 'Tierra del Fuego');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('987', '10', 'TU', 'Tucuman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('988', '11', 'AGT', 'Aragatsotn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('989', '11', 'ARR', 'Ararat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('990', '11', 'ARM', 'Armavir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('991', '11', 'GEG', 'Geghark\'unik\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('992', '11', 'KOT', 'Kotayk\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('993', '11', 'LOR', 'Lorri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('994', '11', 'SHI', 'Shirak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('995', '11', 'SYU', 'Syunik\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('996', '11', 'TAV', 'Tavush');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('997', '11', 'VAY', 'Vayots\' Dzor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('998', '11', 'YER', 'Yerevan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('999', '13', 'ACT', 'Australian Capitol Territory');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1000', '13', 'NSW', 'New South Wales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1001', '13', 'NT', 'Northern Territory');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1002', '13', 'QLD', 'Queensland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1003', '13', 'SA', 'South Australia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1004', '13', 'TAS', 'Tasmania');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1005', '13', 'VIC', 'Victoria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1006', '13', 'WA', 'Western Australia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1007', '14', 'BUR', 'Burgenland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1008', '14', 'KAR', 'K&auml;rnten');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1009', '14', 'NOS', 'Nieder&ouml;esterreich');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1010', '14', 'OOS', 'Ober&ouml;esterreich');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1011', '14', 'SAL', 'Salzburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1012', '14', 'STE', 'Steiermark');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1013', '14', 'TIR', 'Tirol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1014', '14', 'VOR', 'Vorarlberg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1015', '14', 'WIE', 'Wien');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1016', '15', 'AB', 'Ali Bayramli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1017', '15', 'ABS', 'Abseron');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1018', '15', 'AGC', 'AgcabAdi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1019', '15', 'AGM', 'Agdam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1020', '15', 'AGS', 'Agdas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1021', '15', 'AGA', 'Agstafa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1022', '15', 'AGU', 'Agsu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1023', '15', 'AST', 'Astara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1024', '15', 'BA', 'Baki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1025', '15', 'BAB', 'BabAk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1026', '15', 'BAL', 'BalakAn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1027', '15', 'BAR', 'BArdA');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1028', '15', 'BEY', 'Beylaqan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1029', '15', 'BIL', 'Bilasuvar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1030', '15', 'CAB', 'Cabrayil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1031', '15', 'CAL', 'Calilabab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1032', '15', 'CUL', 'Culfa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1033', '15', 'DAS', 'Daskasan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1034', '15', 'DAV', 'Davaci');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1035', '15', 'FUZ', 'Fuzuli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1036', '15', 'GA', 'Ganca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1037', '15', 'GAD', 'Gadabay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1038', '15', 'GOR', 'Goranboy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1039', '15', 'GOY', 'Goycay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1040', '15', 'HAC', 'Haciqabul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1041', '15', 'IMI', 'Imisli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1042', '15', 'ISM', 'Ismayilli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1043', '15', 'KAL', 'Kalbacar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1044', '15', 'KUR', 'Kurdamir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1045', '15', 'LA', 'Lankaran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1046', '15', 'LAC', 'Lacin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1047', '15', 'LAN', 'Lankaran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1048', '15', 'LER', 'Lerik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1049', '15', 'MAS', 'Masalli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1050', '15', 'MI', 'Mingacevir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1051', '15', 'NA', 'Naftalan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1052', '15', 'NEF', 'Neftcala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1053', '15', 'OGU', 'Oguz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1054', '15', 'ORD', 'Ordubad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1055', '15', 'QAB', 'Qabala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1056', '15', 'QAX', 'Qax');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1057', '15', 'QAZ', 'Qazax');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1058', '15', 'QOB', 'Qobustan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1059', '15', 'QBA', 'Quba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1060', '15', 'QBI', 'Qubadli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1061', '15', 'QUS', 'Qusar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1062', '15', 'SA', 'Saki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1063', '15', 'SAT', 'Saatli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1064', '15', 'SAB', 'Sabirabad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1065', '15', 'SAD', 'Sadarak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1066', '15', 'SAH', 'Sahbuz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1067', '15', 'SAK', 'Saki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1068', '15', 'SAL', 'Salyan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1069', '15', 'SM', 'Sumqayit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1070', '15', 'SMI', 'Samaxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1071', '15', 'SKR', 'Samkir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1072', '15', 'SMX', 'Samux');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1073', '15', 'SAR', 'Sarur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1074', '15', 'SIY', 'Siyazan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1075', '15', 'SS', 'Susa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1076', '15', 'SUS', 'Susa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1077', '15', 'TAR', 'Tartar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1078', '15', 'TOV', 'Tovuz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1079', '15', 'UCA', 'Ucar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1080', '15', 'XA', 'Xankandi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1081', '15', 'XAC', 'Xacmaz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1082', '15', 'XAN', 'Xanlar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1083', '15', 'XIZ', 'Xizi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1084', '15', 'XCI', 'Xocali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1085', '15', 'XVD', 'Xocavand');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1086', '15', 'YAR', 'Yardimli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1087', '15', 'YEV', 'Yevlax');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1088', '15', 'ZAN', 'Zangilan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1089', '15', 'ZAQ', 'Zaqatala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1090', '15', 'ZAR', 'Zardab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1091', '15', 'NX', 'Naxcivan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1092', '16', 'ACK', 'Acklins');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1093', '16', 'BER', 'Berry Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1094', '16', 'BIM', 'Bimini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1095', '16', 'BLK', 'Black Point');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1096', '16', 'CAT', 'Cat Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1097', '16', 'CAB', 'Central Abaco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1098', '16', 'CAN', 'Central Andros');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1099', '16', 'CEL', 'Central Eleuthera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1100', '16', 'FRE', 'City of Freeport');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1101', '16', 'CRO', 'Crooked Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1102', '16', 'EGB', 'East Grand Bahama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1103', '16', 'EXU', 'Exuma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1104', '16', 'GRD', 'Grand Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1105', '16', 'HAR', 'Harbour Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1106', '16', 'HOP', 'Hope Town');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1107', '16', 'INA', 'Inagua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1108', '16', 'LNG', 'Long Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1109', '16', 'MAN', 'Mangrove Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1110', '16', 'MAY', 'Mayaguana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1111', '16', 'MOO', 'Moore\'s Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1112', '16', 'NAB', 'North Abaco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1113', '16', 'NAN', 'North Andros');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1114', '16', 'NEL', 'North Eleuthera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1115', '16', 'RAG', 'Ragged Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1116', '16', 'RUM', 'Rum Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1117', '16', 'SAL', 'San Salvador');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1118', '16', 'SAB', 'South Abaco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1119', '16', 'SAN', 'South Andros');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1120', '16', 'SEL', 'South Eleuthera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1121', '16', 'SWE', 'Spanish Wells');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1122', '16', 'WGB', 'West Grand Bahama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1123', '17', 'CAP', 'Capital');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1124', '17', 'CEN', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1125', '17', 'MUH', 'Muharraq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1126', '17', 'NOR', 'Northern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1127', '17', 'SOU', 'Southern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1128', '18', 'BAR', 'Barisal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1129', '18', 'CHI', 'Chittagong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1130', '18', 'DHA', 'Dhaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1131', '18', 'KHU', 'Khulna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1132', '18', 'RAJ', 'Rajshahi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1133', '18', 'SYL', 'Sylhet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1134', '19', 'CC', 'Christ Church');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1135', '19', 'AND', 'Saint Andrew');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1136', '19', 'GEO', 'Saint George');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1137', '19', 'JAM', 'Saint James');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1138', '19', 'JOH', 'Saint John');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1139', '19', 'JOS', 'Saint Joseph');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1140', '19', 'LUC', 'Saint Lucy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1141', '19', 'MIC', 'Saint Michael');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1142', '19', 'PET', 'Saint Peter');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1143', '19', 'PHI', 'Saint Philip');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1144', '19', 'THO', 'Saint Thomas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1145', '20', 'BR', 'Brestskaya (Brest)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1146', '20', 'HO', 'Homyel\'skaya (Homyel\')');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1147', '20', 'HM', 'Horad Minsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1148', '20', 'HR', 'Hrodzyenskaya (Hrodna)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1149', '20', 'MA', 'Mahilyowskaya (Mahilyow)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1150', '20', 'MI', 'Minskaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1151', '20', 'VI', 'Vitsyebskaya (Vitsyebsk)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1152', '21', 'VAN', 'Antwerpen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1153', '21', 'WBR', 'Brabant Wallon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1154', '21', 'WHT', 'Hainaut');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1155', '21', 'WLG', 'Liege');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1156', '21', 'VLI', 'Limburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1157', '21', 'WLX', 'Luxembourg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1158', '21', 'WNA', 'Namur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1159', '21', 'VOV', 'Oost-Vlaanderen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1160', '21', 'VBR', 'Vlaams Brabant');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1161', '21', 'VWV', 'West-Vlaanderen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1162', '22', 'BZ', 'Belize');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1163', '22', 'CY', 'Cayo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1164', '22', 'CR', 'Corozal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1165', '22', 'OW', 'Orange Walk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1166', '22', 'SC', 'Stann Creek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1167', '22', 'TO', 'Toledo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1168', '23', 'AL', 'Alibori');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1169', '23', 'AK', 'Atakora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1170', '23', 'AQ', 'Atlantique');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1171', '23', 'BO', 'Borgou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1172', '23', 'CO', 'Collines');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1173', '23', 'DO', 'Donga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1174', '23', 'KO', 'Kouffo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1175', '23', 'LI', 'Littoral');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1176', '23', 'MO', 'Mono');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1177', '23', 'OU', 'Oueme');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1178', '23', 'PL', 'Plateau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1179', '23', 'ZO', 'Zou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1180', '24', 'DS', 'Devonshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1181', '24', 'HC', 'Hamilton City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1182', '24', 'HA', 'Hamilton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1183', '24', 'PG', 'Paget');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1184', '24', 'PB', 'Pembroke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1185', '24', 'GC', 'Saint George City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1186', '24', 'SG', 'Saint George\'s');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1187', '24', 'SA', 'Sandys');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1188', '24', 'SM', 'Smith\'s');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1189', '24', 'SH', 'Southampton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1190', '24', 'WA', 'Warwick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1191', '25', 'BUM', 'Bumthang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1192', '25', 'CHU', 'Chukha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1193', '25', 'DAG', 'Dagana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1194', '25', 'GAS', 'Gasa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1195', '25', 'HAA', 'Haa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1196', '25', 'LHU', 'Lhuntse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1197', '25', 'MON', 'Mongar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1198', '25', 'PAR', 'Paro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1199', '25', 'PEM', 'Pemagatshel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1200', '25', 'PUN', 'Punakha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1201', '25', 'SJO', 'Samdrup Jongkhar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1202', '25', 'SAT', 'Samtse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1203', '25', 'SAR', 'Sarpang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1204', '25', 'THI', 'Thimphu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1205', '25', 'TRG', 'Trashigang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1206', '25', 'TRY', 'Trashiyangste');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1207', '25', 'TRO', 'Trongsa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1208', '25', 'TSI', 'Tsirang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1209', '25', 'WPH', 'Wangdue Phodrang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1210', '25', 'ZHE', 'Zhemgang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1211', '26', 'BEN', 'Beni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1212', '26', 'CHU', 'Chuquisaca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1213', '26', 'COC', 'Cochabamba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1214', '26', 'LPZ', 'La Paz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1215', '26', 'ORU', 'Oruro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1216', '26', 'PAN', 'Pando');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1217', '26', 'POT', 'Potosi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1218', '26', 'SCZ', 'Santa Cruz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1219', '26', 'TAR', 'Tarija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1220', '27', 'BRO', 'Brcko district');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1221', '27', 'FUS', 'Unsko-Sanski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1222', '27', 'FPO', 'Posavski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1223', '27', 'FTU', 'Tuzlanski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1224', '27', 'FZE', 'Zenicko-Dobojski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1225', '27', 'FBP', 'Bosanskopodrinjski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1226', '27', 'FSB', 'Srednjebosanski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1227', '27', 'FHN', 'Hercegovacko-neretvanski Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1228', '27', 'FZH', 'Zapadnohercegovacka Zupanija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1229', '27', 'FSA', 'Kanton Sarajevo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1230', '27', 'FZA', 'Zapadnobosanska');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1231', '27', 'SBL', 'Banja Luka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1232', '27', 'SDO', 'Doboj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1233', '27', 'SBI', 'Bijeljina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1234', '27', 'SVL', 'Vlasenica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1235', '27', 'SSR', 'Sarajevo-Romanija or Sokolac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1236', '27', 'SFO', 'Foca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1237', '27', 'STR', 'Trebinje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1238', '28', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1239', '28', 'GH', 'Ghanzi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1240', '28', 'KD', 'Kgalagadi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1241', '28', 'KT', 'Kgatleng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1242', '28', 'KW', 'Kweneng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1243', '28', 'NG', 'Ngamiland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1244', '28', 'NE', 'North East');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1245', '28', 'NW', 'North West');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1246', '28', 'SE', 'South East');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1247', '28', 'SO', 'Southern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1248', '30', 'AC', 'Acre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1249', '30', 'AL', 'Alagoas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1250', '30', 'AP', 'Amapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1251', '30', 'AM', 'Amazonas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1252', '30', 'BA', 'Bahia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1253', '30', 'CE', 'Ceara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1254', '30', 'DF', 'Distrito Federal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1255', '30', 'ES', 'Espirito Santo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1256', '30', 'GO', 'Goias');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1257', '30', 'MA', 'Maranhao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1258', '30', 'MT', 'Mato Grosso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1259', '30', 'MS', 'Mato Grosso do Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1260', '30', 'MG', 'Minas Gerais');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1261', '30', 'PA', 'Para');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1262', '30', 'PB', 'Paraiba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1263', '30', 'PR', 'Parana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1264', '30', 'PE', 'Pernambuco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1265', '30', 'PI', 'Piaui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1266', '30', 'RJ', 'Rio de Janeiro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1267', '30', 'RN', 'Rio Grande do Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1268', '30', 'RS', 'Rio Grande do Sul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1269', '30', 'RO', 'Rondonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1270', '30', 'RR', 'Roraima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1271', '30', 'SC', 'Santa Catarina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1272', '30', 'SP', 'Sao Paulo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1273', '30', 'SE', 'Sergipe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1274', '30', 'TO', 'Tocantins');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1275', '31', 'PB', 'Peros Banhos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1276', '31', 'SI', 'Salomon Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1277', '31', 'NI', 'Nelsons Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1278', '31', 'TB', 'Three Brothers');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1279', '31', 'EA', 'Eagle Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1280', '31', 'DI', 'Danger Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1281', '31', 'EG', 'Egmont Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1282', '31', 'DG', 'Diego Garcia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1283', '32', 'BEL', 'Belait');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1284', '32', 'BRM', 'Brunei and Muara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1285', '32', 'TEM', 'Temburong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1286', '32', 'TUT', 'Tutong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1287', '33', '', 'Blagoevgrad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1288', '33', '', 'Burgas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1289', '33', '', 'Dobrich');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1290', '33', '', 'Gabrovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1291', '33', '', 'Haskovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1292', '33', '', 'Kardjali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1293', '33', '', 'Kyustendil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1294', '33', '', 'Lovech');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1295', '33', '', 'Montana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1296', '33', '', 'Pazardjik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1297', '33', '', 'Pernik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1298', '33', '', 'Pleven');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1299', '33', '', 'Plovdiv');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1300', '33', '', 'Razgrad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1301', '33', '', 'Shumen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1302', '33', '', 'Silistra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1303', '33', '', 'Sliven');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1304', '33', '', 'Smolyan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1305', '33', '', 'Sofia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1306', '33', '', 'Sofia - town');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1307', '33', '', 'Stara Zagora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1308', '33', '', 'Targovishte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1309', '33', '', 'Varna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1310', '33', '', 'Veliko Tarnovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1311', '33', '', 'Vidin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1312', '33', '', 'Vratza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1313', '33', '', 'Yambol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1314', '34', 'BAL', 'Bale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1315', '34', 'BAM', 'Bam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1316', '34', 'BAN', 'Banwa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1317', '34', 'BAZ', 'Bazega');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1318', '34', 'BOR', 'Bougouriba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1319', '34', 'BLG', 'Boulgou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1320', '34', 'BOK', 'Boulkiemde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1321', '34', 'COM', 'Comoe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1322', '34', 'GAN', 'Ganzourgou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1323', '34', 'GNA', 'Gnagna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1324', '34', 'GOU', 'Gourma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1325', '34', 'HOU', 'Houet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1326', '34', 'IOA', 'Ioba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1327', '34', 'KAD', 'Kadiogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1328', '34', 'KEN', 'Kenedougou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1329', '34', 'KOD', 'Komondjari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1330', '34', 'KOP', 'Kompienga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1331', '34', 'KOS', 'Kossi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1332', '34', 'KOL', 'Koulpelogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1333', '34', 'KOT', 'Kouritenga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1334', '34', 'KOW', 'Kourweogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1335', '34', 'LER', 'Leraba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1336', '34', 'LOR', 'Loroum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1337', '34', 'MOU', 'Mouhoun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1338', '34', 'NAH', 'Nahouri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1339', '34', 'NAM', 'Namentenga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1340', '34', 'NAY', 'Nayala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1341', '34', 'NOU', 'Noumbiel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1342', '34', 'OUB', 'Oubritenga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1343', '34', 'OUD', 'Oudalan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1344', '34', 'PAS', 'Passore');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1345', '34', 'PON', 'Poni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1346', '34', 'SAG', 'Sanguie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1347', '34', 'SAM', 'Sanmatenga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1348', '34', 'SEN', 'Seno');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1349', '34', 'SIS', 'Sissili');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1350', '34', 'SOM', 'Soum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1351', '34', 'SOR', 'Sourou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1352', '34', 'TAP', 'Tapoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1353', '34', 'TUY', 'Tuy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1354', '34', 'YAG', 'Yagha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1355', '34', 'YAT', 'Yatenga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1356', '34', 'ZIR', 'Ziro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1357', '34', 'ZOD', 'Zondoma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1358', '34', 'ZOW', 'Zoundweogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1359', '35', 'BB', 'Bubanza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1360', '35', 'BJ', 'Bujumbura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1361', '35', 'BR', 'Bururi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1362', '35', 'CA', 'Cankuzo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1363', '35', 'CI', 'Cibitoke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1364', '35', 'GI', 'Gitega');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1365', '35', 'KR', 'Karuzi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1366', '35', 'KY', 'Kayanza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1367', '35', 'KI', 'Kirundo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1368', '35', 'MA', 'Makamba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1369', '35', 'MU', 'Muramvya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1370', '35', 'MY', 'Muyinga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1371', '35', 'MW', 'Mwaro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1372', '35', 'NG', 'Ngozi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1373', '35', 'RT', 'Rutana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1374', '35', 'RY', 'Ruyigi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1375', '36', 'PP', 'Phnom Penh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1376', '36', 'PS', 'Preah Seihanu (Kompong Som or Si');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1377', '36', 'PA', 'Pailin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1378', '36', 'KB', 'Keb');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1379', '36', 'BM', 'Banteay Meanchey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1380', '36', 'BA', 'Battambang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1381', '36', 'KM', 'Kampong Cham');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1382', '36', 'KN', 'Kampong Chhnang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1383', '36', 'KU', 'Kampong Speu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1384', '36', 'KO', 'Kampong Som');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1385', '36', 'KT', 'Kampong Thom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1386', '36', 'KP', 'Kampot');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1387', '36', 'KL', 'Kandal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1388', '36', 'KK', 'Kaoh Kong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1389', '36', 'KR', 'Kratie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1390', '36', 'MK', 'Mondul Kiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1391', '36', 'OM', 'Oddar Meancheay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1392', '36', 'PU', 'Pursat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1393', '36', 'PR', 'Preah Vihear');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1394', '36', 'PG', 'Prey Veng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1395', '36', 'RK', 'Ratanak Kiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1396', '36', 'SI', 'Siemreap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1397', '36', 'ST', 'Stung Treng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1398', '36', 'SR', 'Svay Rieng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1399', '36', 'TK', 'Takeo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1400', '37', 'ADA', 'Adamawa (Adamaoua)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1401', '37', 'CEN', 'Centre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1402', '37', 'EST', 'East (Est)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1403', '37', 'EXN', 'Extreme North (Extr?me-Nord)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1404', '37', 'LIT', 'Littoral');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1405', '37', 'NOR', 'North (Nord)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1406', '37', 'NOT', 'Northwest (Nord-Ouest)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1407', '37', 'OUE', 'West (Ouest)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1408', '37', 'SUD', 'South (Sud)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1409', '37', 'SOU', 'Southwest (Sud-Ouest).');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1410', '38', 'AB', 'Alberta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1411', '38', 'BC', 'British Columbia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1412', '38', 'MB', 'Manitoba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1413', '38', 'NB', 'New Brunswick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1414', '38', 'NL', 'Newfoundland and Labrador');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1415', '38', 'NT', 'Northwest Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1416', '38', 'NS', 'Nova Scotia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1417', '38', 'NU', 'Nunavut');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1418', '38', 'ON', 'Ontario');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1419', '38', 'PE', 'Prince Edward Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1420', '38', 'QC', 'Qu&eacute;bec');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1421', '38', 'SK', 'Saskatchewan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1422', '38', 'YT', 'Yukon Territory');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1423', '39', 'BV', 'Boa Vista');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1424', '39', 'BR', 'Brava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1425', '39', 'CS', 'Calheta de Sao Miguel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1426', '39', 'MA', 'Maio');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1427', '39', 'MO', 'Mosteiros');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1428', '39', 'PA', 'Paul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1429', '39', 'PN', 'Porto Novo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1430', '39', 'PR', 'Praia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1431', '39', 'RG', 'Ribeira Grande');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1432', '39', 'SL', 'Sal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1433', '39', 'CA', 'Santa Catarina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1434', '39', 'CR', 'Santa Cruz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1435', '39', 'SD', 'Sao Domingos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1436', '39', 'SF', 'Sao Filipe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1437', '39', 'SN', 'Sao Nicolau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1438', '39', 'SV', 'Sao Vicente');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1439', '39', 'TA', 'Tarrafal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1440', '40', 'CR', 'Creek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1441', '40', 'EA', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1442', '40', 'ML', 'Midland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1443', '40', 'ST', 'South Town');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1444', '40', 'SP', 'Spot Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1445', '40', 'SK', 'Stake Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1446', '40', 'WD', 'West End ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1447', '40', 'WN', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1448', '41', 'BBA', 'Bamingui-Bangoran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1449', '41', 'BKO', 'Basse-Kotto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1450', '41', 'HKO', 'Haute-Kotto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1451', '41', 'HMB', 'Haut-Mbomou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1452', '41', 'KEM', 'Kemo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1453', '41', 'LOB', 'Lobaye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1454', '41', 'MKD', 'Mambere-Kade?');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1455', '41', 'MBO', 'Mbomou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1456', '41', 'NMM', 'Nana-Mambere');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1457', '41', 'OMP', 'Ombella-M\'Poko');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1458', '41', 'OUK', 'Ouaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1459', '41', 'OUH', 'Ouham');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1460', '41', 'OPE', 'Ouham-Pende');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1461', '41', 'VAK', 'Vakaga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1462', '41', 'NGR', 'Nana-Grebizi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1463', '41', 'SMB', 'Sangha-Mbaere');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1464', '41', 'BAN', 'Bangui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1465', '42', 'BA', 'Batha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1466', '42', 'BI', 'Biltine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1467', '42', 'BE', 'Borkou-Ennedi-Tibesti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1468', '42', 'CB', 'Chari-Baguirmi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1469', '42', 'GU', 'Guera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1470', '42', 'KA', 'Kanem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1471', '42', 'LA', 'Lac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1472', '42', 'LC', 'Logone Occidental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1473', '42', 'LR', 'Logone Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1474', '42', 'MK', 'Mayo-Kebbi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1475', '42', 'MC', 'Moyen-Chari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1476', '42', 'OU', 'Ouaddai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1477', '42', 'SA', 'Salamat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1478', '42', 'TA', 'Tandjile');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1479', '43', 'AI', 'Aisen del General Carlos Ibanez ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1480', '43', 'AN', 'Antofagasta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1481', '43', 'AR', 'Araucania');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1482', '43', 'AT', 'Atacama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1483', '43', 'BI', 'Bio-Bio');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1484', '43', 'CO', 'Coquimbo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1485', '43', 'LI', 'Libertador General Bernardo O\'Hi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1486', '43', 'LL', 'Los Lagos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1487', '43', 'MA', 'Magallanes y de la Antartica Chi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1488', '43', 'ML', 'Maule');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1489', '43', 'RM', 'Region Metropolitana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1490', '43', 'TA', 'Tarapaca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1491', '43', 'VS', 'Valparaiso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1492', '44', 'AN', 'Anhui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1493', '44', 'BE', 'Beijing');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1494', '44', 'CH', 'Chongqing');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1495', '44', 'FU', 'Fujian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1496', '44', 'GA', 'Gansu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1497', '44', 'GU', 'Guangdong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1498', '44', 'GX', 'Guangxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1499', '44', 'GZ', 'Guizhou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1500', '44', 'HA', 'Hainan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1501', '44', 'HB', 'Hebei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1502', '44', 'HL', 'Heilongjiang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1503', '44', 'HE', 'Henan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1504', '44', 'HK', 'Hong Kong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1505', '44', 'HU', 'Hubei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1506', '44', 'HN', 'Hunan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1507', '44', 'IM', 'Inner Mongolia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1508', '44', 'JI', 'Jiangsu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1509', '44', 'JX', 'Jiangxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1510', '44', 'JL', 'Jilin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1511', '44', 'LI', 'Liaoning');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1512', '44', 'MA', 'Macau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1513', '44', 'NI', 'Ningxia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1514', '44', 'SH', 'Shaanxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1515', '44', 'SA', 'Shandong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1516', '44', 'SG', 'Shanghai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1517', '44', 'SX', 'Shanxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1518', '44', 'SI', 'Sichuan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1519', '44', 'TI', 'Tianjin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1520', '44', 'XI', 'Xinjiang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1521', '44', 'YU', 'Yunnan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1522', '44', 'ZH', 'Zhejiang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1523', '46', 'D', 'Direction Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1524', '46', 'H', 'Home Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1525', '46', 'O', 'Horsburgh Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1526', '46', 'S', 'South Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1527', '46', 'W', 'West Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1528', '47', 'AMZ', 'Amazonas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1529', '47', 'ANT', 'Antioquia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1530', '47', 'ARA', 'Arauca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1531', '47', 'ATL', 'Atlantico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1532', '47', 'BDC', 'Bogota D.C.');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1533', '47', 'BOL', 'Bolivar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1534', '47', 'BOY', 'Boyaca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1535', '47', 'CAL', 'Caldas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1536', '47', 'CAQ', 'Caqueta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1537', '47', 'CAS', 'Casanare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1538', '47', 'CAU', 'Cauca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1539', '47', 'CES', 'Cesar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1540', '47', 'CHO', 'Choco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1541', '47', 'COR', 'Cordoba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1542', '47', 'CAM', 'Cundinamarca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1543', '47', 'GNA', 'Guainia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1544', '47', 'GJR', 'Guajira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1545', '47', 'GVR', 'Guaviare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1546', '47', 'HUI', 'Huila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1547', '47', 'MAG', 'Magdalena');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1548', '47', 'MET', 'Meta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1549', '47', 'NAR', 'Narino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1550', '47', 'NDS', 'Norte de Santander');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1551', '47', 'PUT', 'Putumayo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1552', '47', 'QUI', 'Quindio');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1553', '47', 'RIS', 'Risaralda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1554', '47', 'SAP', 'San Andres y Providencia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1555', '47', 'SAN', 'Santander');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1556', '47', 'SUC', 'Sucre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1557', '47', 'TOL', 'Tolima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1558', '47', 'VDC', 'Valle del Cauca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1559', '47', 'VAU', 'Vaupes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1560', '47', 'VIC', 'Vichada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1561', '48', 'G', 'Grande Comore');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1562', '48', 'A', 'Anjouan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1563', '48', 'M', 'Moheli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1564', '49', 'BO', 'Bouenza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1565', '49', 'BR', 'Brazzaville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1566', '49', 'CU', 'Cuvette');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1567', '49', 'CO', 'Cuvette-Ouest');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1568', '49', 'KO', 'Kouilou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1569', '49', 'LE', 'Lekoumou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1570', '49', 'LI', 'Likouala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1571', '49', 'NI', 'Niari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1572', '49', 'PL', 'Plateaux');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1573', '49', 'PO', 'Pool ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1574', '49', 'SA', 'Sangha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1575', '50', 'PU', 'Pukapuka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1576', '50', 'RK', 'Rakahanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1577', '50', 'MK', 'Manihiki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1578', '50', 'PE', 'Penrhyn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1579', '50', 'NI', 'Nassau Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1580', '50', 'SU', 'Surwarrow');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1581', '50', 'PA', 'Palmerston');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1582', '50', 'AI', 'Aitutaki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1583', '50', 'MA', 'Manuae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1584', '50', 'TA', 'Takutea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1585', '50', 'MT', 'Mitiaro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1586', '50', 'AT', 'Atiu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1587', '50', 'MU', 'Mauke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1588', '50', 'RR', 'Rarotonga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1589', '50', 'MG', 'Mangaia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1590', '51', 'AL', 'Alajuela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1591', '51', 'CA', 'Cartago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1592', '51', 'GU', 'Guanacaste');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1593', '51', 'HE', 'Heredia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1594', '51', 'LI', 'Limon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1595', '51', 'PU', 'Puntarenas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1596', '51', 'SJ', 'San Jose');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1597', '52', 'ABE', 'Abengourou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1598', '52', 'ABI', 'Abidjan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1599', '52', 'ABO', 'Aboisso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1600', '52', 'ADI', 'Adiake');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1601', '52', 'ADZ', 'Adzope');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1602', '52', 'AGB', 'Agboville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1603', '52', 'AGN', 'Agnibilekrou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1604', '52', 'ALE', 'Alepe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1605', '52', 'BOC', 'Bocanda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1606', '52', 'BAN', 'Bangolo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1607', '52', 'BEO', 'Beoumi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1608', '52', 'BIA', 'Biankouma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1609', '52', 'BDK', 'Bondoukou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1610', '52', 'BGN', 'Bongouanou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1611', '52', 'BFL', 'Bouafle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1612', '52', 'BKE', 'Bouake');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1613', '52', 'BNA', 'Bouna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1614', '52', 'BDL', 'Boundiali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1615', '52', 'DKL', 'Dabakala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1616', '52', 'DBU', 'Dabou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1617', '52', 'DAL', 'Daloa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1618', '52', 'DAN', 'Danane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1619', '52', 'DAO', 'Daoukro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1620', '52', 'DIM', 'Dimbokro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1621', '52', 'DIV', 'Divo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1622', '52', 'DUE', 'Duekoue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1623', '52', 'FER', 'Ferkessedougou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1624', '52', 'GAG', 'Gagnoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1625', '52', 'GBA', 'Grand-Bassam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1626', '52', 'GLA', 'Grand-Lahou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1627', '52', 'GUI', 'Guiglo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1628', '52', 'ISS', 'Issia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1629', '52', 'JAC', 'Jacqueville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1630', '52', 'KAT', 'Katiola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1631', '52', 'KOR', 'Korhogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1632', '52', 'LAK', 'Lakota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1633', '52', 'MAN', 'Man');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1634', '52', 'MKN', 'Mankono');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1635', '52', 'MBA', 'Mbahiakro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1636', '52', 'ODI', 'Odienne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1637', '52', 'OUM', 'Oume');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1638', '52', 'SAK', 'Sakassou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1639', '52', 'SPE', 'San-Pedro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1640', '52', 'SAS', 'Sassandra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1641', '52', 'SEG', 'Seguela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1642', '52', 'SIN', 'Sinfra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1643', '52', 'SOU', 'Soubre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1644', '52', 'TAB', 'Tabou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1645', '52', 'TAN', 'Tanda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1646', '52', 'TIE', 'Tiebissou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1647', '52', 'TIN', 'Tingrela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1648', '52', 'TIA', 'Tiassale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1649', '52', 'TBA', 'Touba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1650', '52', 'TLP', 'Toulepleu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1651', '52', 'TMD', 'Toumodi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1652', '52', 'VAV', 'Vavoua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1653', '52', 'YAM', 'Yamoussoukro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1654', '52', 'ZUE', 'Zuenoula');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1655', '53', 'BB', 'Bjelovar-Bilogora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1656', '53', 'CZ', 'City of Zagreb');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1657', '53', 'DN', 'Dubrovnik-Neretva');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1658', '53', 'IS', 'Istra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1659', '53', 'KA', 'Karlovac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1660', '53', 'KK', 'Koprivnica-Krizevci');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1661', '53', 'KZ', 'Krapina-Zagorje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1662', '53', 'LS', 'Lika-Senj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1663', '53', 'ME', 'Medimurje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1664', '53', 'OB', 'Osijek-Baranja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1665', '53', 'PS', 'Pozega-Slavonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1666', '53', 'PG', 'Primorje-Gorski Kotar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1667', '53', 'SI', 'Sibenik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1668', '53', 'SM', 'Sisak-Moslavina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1669', '53', 'SB', 'Slavonski Brod-Posavina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1670', '53', 'SD', 'Split-Dalmatia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1671', '53', 'VA', 'Varazdin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1672', '53', 'VP', 'Virovitica-Podravina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1673', '53', 'VS', 'Vukovar-Srijem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1674', '53', 'ZK', 'Zadar-Knin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1675', '53', 'ZA', 'Zagreb');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1676', '54', 'CA', 'Camaguey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1677', '54', 'CD', 'Ciego de Avila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1678', '54', 'CI', 'Cienfuegos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1679', '54', 'CH', 'Ciudad de La Habana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1680', '54', 'GR', 'Granma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1681', '54', 'GU', 'Guantanamo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1682', '54', 'HO', 'Holguin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1683', '54', 'IJ', 'Isla de la Juventud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1684', '54', 'LH', 'La Habana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1685', '54', 'LT', 'Las Tunas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1686', '54', 'MA', 'Matanzas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1687', '54', 'PR', 'Pinar del Rio');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1688', '54', 'SS', 'Sancti Spiritus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1689', '54', 'SC', 'Santiago de Cuba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1690', '54', 'VC', 'Villa Clara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1691', '55', 'F', 'Famagusta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1692', '55', 'K', 'Kyrenia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1693', '55', 'A', 'Larnaca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1694', '55', 'I', 'Limassol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1695', '55', 'N', 'Nicosia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1696', '55', 'P', 'Paphos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1697', '56', 'U', 'Ustecky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1698', '56', 'C', 'Jihocesky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1699', '56', 'B', 'Jihomoravsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1700', '56', 'K', 'Karlovarsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1701', '56', 'H', 'Kralovehradecky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1702', '56', 'L', 'Liberecky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1703', '56', 'T', 'Moravskoslezsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1704', '56', 'M', 'Olomoucky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1705', '56', 'E', 'Pardubicky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1706', '56', 'P', 'Plzensky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1707', '56', 'A', 'Praha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1708', '56', 'S', 'Stredocesky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1709', '56', 'J', 'Vysocina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1710', '56', 'Z', 'Zlinsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1711', '57', 'AR', 'Arhus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1712', '57', 'BH', 'Bornholm');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1713', '57', 'CO', 'Copenhagen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1714', '57', 'FO', 'Faroe Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1715', '57', 'FR', 'Frederiksborg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1716', '57', 'FY', 'Fyn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1717', '57', 'KO', 'Kobenhavn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1718', '57', 'NO', 'Nordjylland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1719', '57', 'RI', 'Ribe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1720', '57', 'RK', 'Ringkobing');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1721', '57', 'RO', 'Roskilde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1722', '57', 'SO', 'Sonderjylland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1723', '57', 'ST', 'Storstrom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1724', '57', 'VK', 'Vejle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1725', '57', 'VJ', 'Vestj&aelig;lland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1726', '57', 'VB', 'Viborg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1727', '58', 'S', '\'Ali Sabih');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1728', '58', 'K', 'Dikhil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1729', '58', 'J', 'Djibouti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1730', '58', 'O', 'Obock');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1731', '58', 'T', 'Tadjoura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1732', '59', 'AND', 'Saint Andrew Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1733', '59', 'DAV', 'Saint David Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1734', '59', 'GEO', 'Saint George Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1735', '59', 'JOH', 'Saint John Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1736', '59', 'JOS', 'Saint Joseph Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1737', '59', 'LUK', 'Saint Luke Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1738', '59', 'MAR', 'Saint Mark Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1739', '59', 'PAT', 'Saint Patrick Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1740', '59', 'PAU', 'Saint Paul Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1741', '59', 'PET', 'Saint Peter Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1742', '60', 'DN', 'Distrito Nacional');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1743', '60', 'AZ', 'Azua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1744', '60', 'BC', 'Baoruco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1745', '60', 'BH', 'Barahona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1746', '60', 'DJ', 'Dajabon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1747', '60', 'DU', 'Duarte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1748', '60', 'EL', 'Elias Pina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1749', '60', 'SY', 'El Seybo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1750', '60', 'ET', 'Espaillat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1751', '60', 'HM', 'Hato Mayor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1752', '60', 'IN', 'Independencia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1753', '60', 'AL', 'La Altagracia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1754', '60', 'RO', 'La Romana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1755', '60', 'VE', 'La Vega');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1756', '60', 'MT', 'Maria Trinidad Sanchez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1757', '60', 'MN', 'Monsenor Nouel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1758', '60', 'MC', 'Monte Cristi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1759', '60', 'MP', 'Monte Plata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1760', '60', 'PD', 'Pedernales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1761', '60', 'PR', 'Peravia (Bani)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1762', '60', 'PP', 'Puerto Plata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1763', '60', 'SL', 'Salcedo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1764', '60', 'SM', 'Samana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1765', '60', 'SH', 'Sanchez Ramirez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1766', '60', 'SC', 'San Cristobal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1767', '60', 'JO', 'San Jose de Ocoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1768', '60', 'SJ', 'San Juan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1769', '60', 'PM', 'San Pedro de Macoris');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1770', '60', 'SA', 'Santiago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1771', '60', 'ST', 'Santiago Rodriguez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1772', '60', 'SD', 'Santo Domingo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1773', '60', 'VA', 'Valverde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1774', '61', 'AL', 'Aileu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1775', '61', 'AN', 'Ainaro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1776', '61', 'BA', 'Baucau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1777', '61', 'BO', 'Bobonaro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1778', '61', 'CO', 'Cova Lima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1779', '61', 'DI', 'Dili');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1780', '61', 'ER', 'Ermera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1781', '61', 'LA', 'Lautem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1782', '61', 'LI', 'Liquica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1783', '61', 'MT', 'Manatuto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1784', '61', 'MF', 'Manufahi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1785', '61', 'OE', 'Oecussi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1786', '61', 'VI', 'Viqueque');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1787', '62', 'AZU', 'Azuay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1788', '62', 'BOL', 'Bolivar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1789', '62', 'CAN', 'Ca&ntilde;ar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1790', '62', 'CAR', 'Carchi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1791', '62', 'CHI', 'Chimborazo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1792', '62', 'COT', 'Cotopaxi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1793', '62', 'EOR', 'El Oro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1794', '62', 'ESM', 'Esmeraldas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1795', '62', 'GPS', 'Gal&aacute;pagos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1796', '62', 'GUA', 'Guayas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1797', '62', 'IMB', 'Imbabura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1798', '62', 'LOJ', 'Loja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1799', '62', 'LRO', 'Los Ríos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1800', '62', 'MAN', 'Manab&iacute;');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1801', '62', 'MSA', 'Morona Santiago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1802', '62', 'NAP', 'Napo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1803', '62', 'ORE', 'Orellana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1804', '62', 'PAS', 'Pastaza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1805', '62', 'PIC', 'Pichincha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1806', '62', 'SUC', 'Sucumb&iacute;os');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1807', '62', 'TUN', 'Tungurahua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1808', '62', 'ZCH', 'Zamora Chinchipe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1809', '63', 'DHY', 'Ad Daqahliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1810', '63', 'BAM', 'Al Bahr al Ahmar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1811', '63', 'BHY', 'Al Buhayrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1812', '63', 'FYM', 'Al Fayyum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1813', '63', 'GBY', 'Al Gharbiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1814', '63', 'IDR', 'Al Iskandariyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1815', '63', 'IML', 'Al Isma\'iliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1816', '63', 'JZH', 'Al Jizah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1817', '63', 'MFY', 'Al Minufiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1818', '63', 'MNY', 'Al Minya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1819', '63', 'QHR', 'Al Qahirah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1820', '63', 'QLY', 'Al Qalyubiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1821', '63', 'WJD', 'Al Wadi al Jadid');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1822', '63', 'SHQ', 'Ash Sharqiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1823', '63', 'SWY', 'As Suways');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1824', '63', 'ASW', 'Aswan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1825', '63', 'ASY', 'Asyut');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1826', '63', 'BSW', 'Bani Suwayf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1827', '63', 'BSD', 'Bur Sa\'id');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1828', '63', 'DMY', 'Dumyat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1829', '63', 'JNS', 'Janub Sina\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1830', '63', 'KSH', 'Kafr ash Shaykh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1831', '63', 'MAT', 'Matruh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1832', '63', 'QIN', 'Qina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1833', '63', 'SHS', 'Shamal Sina\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1834', '63', 'SUH', 'Suhaj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1835', '64', 'AH', 'Ahuachapan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1836', '64', 'CA', 'Cabanas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1837', '64', 'CH', 'Chalatenango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1838', '64', 'CU', 'Cuscatlan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1839', '64', 'LB', 'La Libertad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1840', '64', 'PZ', 'La Paz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1841', '64', 'UN', 'La Union');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1842', '64', 'MO', 'Morazan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1843', '64', 'SM', 'San Miguel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1844', '64', 'SS', 'San Salvador');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1845', '64', 'SV', 'San Vicente');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1846', '64', 'SA', 'Santa Ana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1847', '64', 'SO', 'Sonsonate');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1848', '64', 'US', 'Usulutan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1849', '65', 'AN', 'Provincia Annobon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1850', '65', 'BN', 'Provincia Bioko Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1851', '65', 'BS', 'Provincia Bioko Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1852', '65', 'CS', 'Provincia Centro Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1853', '65', 'KN', 'Provincia Kie-Ntem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1854', '65', 'LI', 'Provincia Litoral');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1855', '65', 'WN', 'Provincia Wele-Nzas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1856', '66', 'MA', 'Central (Maekel)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1857', '66', 'KE', 'Anseba (Keren)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1858', '66', 'DK', 'Southern Red Sea (Debub-Keih-Bah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1859', '66', 'SK', 'Northern Red Sea (Semien-Keih-Ba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1860', '66', 'DE', 'Southern (Debub)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1861', '66', 'BR', 'Gash-Barka (Barentu)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1862', '67', 'HA', 'Harjumaa (Tallinn)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1863', '67', 'HI', 'Hiiumaa (Kardla)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1864', '67', 'IV', 'Ida-Virumaa (Johvi)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1865', '67', 'JA', 'Jarvamaa (Paide)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1866', '67', 'JO', 'Jogevamaa (Jogeva)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1867', '67', 'LV', 'Laane-Virumaa (Rakvere)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1868', '67', 'LA', 'Laanemaa (Haapsalu)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1869', '67', 'PA', 'Parnumaa (Parnu)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1870', '67', 'PO', 'Polvamaa (Polva)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1871', '67', 'RA', 'Raplamaa (Rapla)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1872', '67', 'SA', 'Saaremaa (Kuessaare)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1873', '67', 'TA', 'Tartumaa (Tartu)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1874', '67', 'VA', 'Valgamaa (Valga)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1875', '67', 'VI', 'Viljandimaa (Viljandi)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1876', '67', 'VO', 'Vorumaa (Voru)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1877', '68', 'AF', 'Afar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1878', '68', 'AH', 'Amhara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1879', '68', 'BG', 'Benishangul-Gumaz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1880', '68', 'GB', 'Gambela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1881', '68', 'HR', 'Hariai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1882', '68', 'OR', 'Oromia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1883', '68', 'SM', 'Somali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1884', '68', 'SN', 'Southern Nations - Nationalities');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1885', '68', 'TG', 'Tigray');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1886', '68', 'AA', 'Addis Ababa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1887', '68', 'DD', 'Dire Dawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1888', '71', 'C', 'Central Division');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1889', '71', 'N', 'Northern Division');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1890', '71', 'E', 'Eastern Division');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1891', '71', 'W', 'Western Division');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1892', '71', 'R', 'Rotuma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1893', '72', 'AL', 'Ahvenanmaan Laani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1894', '72', 'ES', 'Etela-Suomen Laani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1895', '72', 'IS', 'Ita-Suomen Laani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1896', '72', 'LS', 'Lansi-Suomen Laani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1897', '72', 'LA', 'Lapin Lanani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1898', '72', 'OU', 'Oulun Laani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1899', '73', 'AL', 'Alsace');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1900', '73', 'AQ', 'Aquitaine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1901', '73', 'AU', 'Auvergne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1902', '73', 'BR', 'Brittany');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1903', '73', 'BU', 'Burgundy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1904', '73', 'CE', 'Center Loire Valley');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1905', '73', 'CH', 'Champagne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1906', '73', 'CO', 'Corse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1907', '73', 'FR', 'France Comte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1908', '73', 'LA', 'Languedoc Roussillon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1909', '73', 'LI', 'Limousin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1910', '73', 'LO', 'Lorraine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1911', '73', 'MI', 'Midi Pyrenees');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1912', '73', 'NO', 'Nord Pas de Calais');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1913', '73', 'NR', 'Normandy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1914', '73', 'PA', 'Paris / Ill de France');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1915', '73', 'PI', 'Picardie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1916', '73', 'PO', 'Poitou Charente');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1917', '73', 'PR', 'Provence');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1918', '73', 'RH', 'Rhone Alps');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1919', '73', 'RI', 'Riviera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1920', '73', 'WE', 'Western Loire Valley');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1921', '74', 'Et', 'Etranger');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1922', '74', '01', 'Ain');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1923', '74', '02', 'Aisne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1924', '74', '03', 'Allier');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1925', '74', '04', 'Alpes de Haute Provence');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1926', '74', '05', 'Hautes-Alpes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1927', '74', '06', 'Alpes Maritimes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1928', '74', '07', 'Ard&egrave;che');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1929', '74', '08', 'Ardennes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1930', '74', '09', 'Ari&egrave;ge');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1931', '74', '10', 'Aube');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1932', '74', '11', 'Aude');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1933', '74', '12', 'Aveyron');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1934', '74', '13', 'Bouches du Rh&ocirc;ne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1935', '74', '14', 'Calvados');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1936', '74', '15', 'Cantal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1937', '74', '16', 'Charente');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1938', '74', '17', 'Charente Maritime');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1939', '74', '18', 'Cher');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1940', '74', '19', 'Corr&egrave;ze');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1941', '74', '2A', 'Corse du Sud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1942', '74', '2B', 'Haute Corse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1943', '74', '21', 'C&ocirc;te d\'or');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1944', '74', '22', 'C&ocirc;tes d\'Armor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1945', '74', '23', 'Creuse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1946', '74', '24', 'Dordogne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1947', '74', '25', 'Doubs');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1948', '74', '26', 'Dr&ocirc;me');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1949', '74', '27', 'Eure');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1950', '74', '28', 'Eure et Loir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1951', '74', '29', 'Finist&egrave;re');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1952', '74', '30', 'Gard');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1953', '74', '31', 'Haute Garonne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1954', '74', '32', 'Gers');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1955', '74', '33', 'Gironde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1956', '74', '34', 'H&eacute;rault');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1957', '74', '35', 'Ille et Vilaine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1958', '74', '36', 'Indre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1959', '74', '37', 'Indre et Loire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1960', '74', '38', 'Is&eacute;re');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1961', '74', '39', 'Jura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1962', '74', '40', 'Landes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1963', '74', '41', 'Loir et Cher');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1964', '74', '42', 'Loire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1965', '74', '43', 'Haute Loire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1966', '74', '44', 'Loire Atlantique');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1967', '74', '45', 'Loiret');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1968', '74', '46', 'Lot');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1969', '74', '47', 'Lot et Garonne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1970', '74', '48', 'Loz&egrave;re');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1971', '74', '49', 'Maine et Loire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1972', '74', '50', 'Manche');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1973', '74', '51', 'Marne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1974', '74', '52', 'Haute Marne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1975', '74', '53', 'Mayenne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1976', '74', '54', 'Meurthe et Moselle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1977', '74', '55', 'Meuse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1978', '74', '56', 'Morbihan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1979', '74', '57', 'Moselle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1980', '74', '58', 'Ni&egrave;vre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1981', '74', '59', 'Nord');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1982', '74', '60', 'Oise');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1983', '74', '61', 'Orne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1984', '74', '62', 'Pas de Calais');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1985', '74', '63', 'Puy de D&ocirc;me');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1986', '74', '64', 'Pyr&eacute;n&eacute;es Atlantiqu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1987', '74', '65', 'Hautes Pyr&eacute;n&eacute;es');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1988', '74', '66', 'Pyr&eacute;n&eacute;es Orientale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1989', '74', '67', 'Bas Rhin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1990', '74', '68', 'Haut Rhin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1991', '74', '69', 'Rh&ocirc;ne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1992', '74', '70', 'Haute Sa&ocirc;ne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1993', '74', '71', 'Sa&ocirc;ne et Loire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1994', '74', '72', 'Sarthe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1995', '74', '73', 'Savoie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1996', '74', '74', 'Haute Savoie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1997', '74', '75', 'Paris');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1998', '74', '76', 'Seine Maritime');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('1999', '74', '77', 'Seine et Marne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2000', '74', '78', 'Yvelines');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2001', '74', '79', 'Deux S&egrave;vres');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2002', '74', '80', 'Somme');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2003', '74', '81', 'Tarn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2004', '74', '82', 'Tarn et Garonne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2005', '74', '83', 'Var');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2006', '74', '84', 'Vaucluse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2007', '74', '85', 'Vend&eacute;e');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2008', '74', '86', 'Vienne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2009', '74', '87', 'Haute Vienne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2010', '74', '88', 'Vosges');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2011', '74', '89', 'Yonne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2012', '74', '90', 'Territoire de Belfort');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2013', '74', '91', 'Essonne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2014', '74', '92', 'Hauts de Seine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2015', '74', '93', 'Seine St-Denis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2016', '74', '94', 'Val de Marne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2017', '74', '95', 'Val d\'Oise');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2018', '76', 'M', 'Archipel des Marquises');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2019', '76', 'T', 'Archipel des Tuamotu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2020', '76', 'I', 'Archipel des Tubuai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2021', '76', 'V', 'Iles du Vent');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2022', '76', 'S', 'Iles Sous-le-Vent ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2023', '77', 'C', 'Iles Crozet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2024', '77', 'K', 'Iles Kerguelen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2025', '77', 'A', 'Ile Amsterdam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2026', '77', 'P', 'Ile Saint-Paul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2027', '77', 'D', 'Adelie Land');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2028', '78', 'ES', 'Estuaire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2029', '78', 'HO', 'Haut-Ogooue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2030', '78', 'MO', 'Moyen-Ogooue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2031', '78', 'NG', 'Ngounie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2032', '78', 'NY', 'Nyanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2033', '78', 'OI', 'Ogooue-Ivindo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2034', '78', 'OL', 'Ogooue-Lolo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2035', '78', 'OM', 'Ogooue-Maritime');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2036', '78', 'WN', 'Woleu-Ntem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2037', '79', 'BJ', 'Banjul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2038', '79', 'BS', 'Basse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2039', '79', 'BR', 'Brikama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2040', '79', 'JA', 'Janjangbure');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2041', '79', 'KA', 'Kanifeng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2042', '79', 'KE', 'Kerewan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2043', '79', 'KU', 'Kuntaur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2044', '79', 'MA', 'Mansakonko');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2045', '79', 'LR', 'Lower River');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2046', '79', 'CR', 'Central River');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2047', '79', 'NB', 'North Bank');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2048', '79', 'UR', 'Upper River');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2049', '79', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2050', '80', 'AB', 'Abkhazia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2051', '80', 'AJ', 'Ajaria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2052', '80', 'TB', 'Tbilisi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2053', '80', 'GU', 'Guria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2054', '80', 'IM', 'Imereti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2055', '80', 'KA', 'Kakheti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2056', '80', 'KK', 'Kvemo Kartli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2057', '80', 'MM', 'Mtskheta-Mtianeti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2058', '80', 'RL', 'Racha Lechkhumi and Kvemo Svanet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2059', '80', 'SZ', 'Samegrelo-Zemo Svaneti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2060', '80', 'SJ', 'Samtskhe-Javakheti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2061', '80', 'SK', 'Shida Kartli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2062', '81', 'BAW', 'Baden-W&uuml;rttemberg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2063', '81', 'BAY', 'Bayern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2064', '81', 'BER', 'Berlin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2065', '81', 'BRG', 'Brandenburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2066', '81', 'BRE', 'Bremen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2067', '81', 'HAM', 'Hamburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2068', '81', 'HES', 'Hessen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2069', '81', 'MEC', 'Mecklenburg-Vorpommern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2070', '81', 'NDS', 'Niedersachsen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2071', '81', 'NRW', 'Nordrhein-Westfalen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2072', '81', 'RHE', 'Rheinland-Pfalz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2073', '81', 'SAR', 'Saarland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2074', '81', 'SAS', 'Sachsen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2075', '81', 'SAC', 'Sachsen-Anhalt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2076', '81', 'SCN', 'Schleswig-Holstein');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2077', '81', 'THE', 'Th&uuml;ringen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2078', '82', 'AS', 'Ashanti Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2079', '82', 'BA', 'Brong-Ahafo Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2080', '82', 'CE', 'Central Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2081', '82', 'EA', 'Eastern Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2082', '82', 'GA', 'Greater Accra Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2083', '82', 'NO', 'Northern Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2084', '82', 'UE', 'Upper East Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2085', '82', 'UW', 'Upper West Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2086', '82', 'VO', 'Volta Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2087', '82', 'WE', 'Western Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2088', '84', 'AT', 'Attica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2089', '84', 'CN', 'Central Greece');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2090', '84', 'CM', 'Central Macedonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2091', '84', 'CR', 'Crete');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2092', '84', 'EM', 'East Macedonia and Thrace');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2093', '84', 'EP', 'Epirus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2094', '84', 'II', 'Ionian Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2095', '84', 'NA', 'North Aegean');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2096', '84', 'PP', 'Peloponnesos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2097', '84', 'SA', 'South Aegean');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2098', '84', 'TH', 'Thessaly');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2099', '84', 'WG', 'West Greece');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2100', '84', 'WM', 'West Macedonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2101', '85', 'A', 'Avannaa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2102', '85', 'T', 'Tunu ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2103', '85', 'K', 'Kitaa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2104', '86', 'A', 'Saint Andrew');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2105', '86', 'D', 'Saint David');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2106', '86', 'G', 'Saint George');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2107', '86', 'J', 'Saint John');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2108', '86', 'M', 'Saint Mark');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2109', '86', 'P', 'Saint Patrick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2110', '86', 'C', 'Carriacou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2111', '86', 'Q', 'Petit Martinique');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2112', '89', 'AV', 'Alta Verapaz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2113', '89', 'BV', 'Baja Verapaz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2114', '89', 'CM', 'Chimaltenango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2115', '89', 'CQ', 'Chiquimula');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2116', '89', 'PE', 'El Peten');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2117', '89', 'PR', 'El Progreso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2118', '89', 'QC', 'El Quiche');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2119', '89', 'ES', 'Escuintla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2120', '89', 'GU', 'Guatemala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2121', '89', 'HU', 'Huehuetenango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2122', '89', 'IZ', 'Izabal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2123', '89', 'JA', 'Jalapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2124', '89', 'JU', 'Jutiapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2125', '89', 'QZ', 'Quetzaltenango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2126', '89', 'RE', 'Retalhuleu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2127', '89', 'ST', 'Sacatepequez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2128', '89', 'SM', 'San Marcos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2129', '89', 'SR', 'Santa Rosa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2130', '89', 'SO', 'Solola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2131', '89', 'SU', 'Suchitepequez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2132', '89', 'TO', 'Totonicapan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2133', '89', 'ZA', 'Zacapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2134', '90', 'CNK', 'Conakry');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2135', '90', 'BYL', 'Beyla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2136', '90', 'BFA', 'Boffa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2137', '90', 'BOK', 'Boke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2138', '90', 'COY', 'Coyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2139', '90', 'DBL', 'Dabola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2140', '90', 'DLB', 'Dalaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2141', '90', 'DGR', 'Dinguiraye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2142', '90', 'DBR', 'Dubreka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2143', '90', 'FRN', 'Faranah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2144', '90', 'FRC', 'Forecariah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2145', '90', 'FRI', 'Fria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2146', '90', 'GAO', 'Gaoual');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2147', '90', 'GCD', 'Gueckedou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2148', '90', 'KNK', 'Kankan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2149', '90', 'KRN', 'Kerouane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2150', '90', 'KND', 'Kindia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2151', '90', 'KSD', 'Kissidougou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2152', '90', 'KBA', 'Koubia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2153', '90', 'KDA', 'Koundara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2154', '90', 'KRA', 'Kouroussa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2155', '90', 'LAB', 'Labe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2156', '90', 'LLM', 'Lelouma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2157', '90', 'LOL', 'Lola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2158', '90', 'MCT', 'Macenta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2159', '90', 'MAL', 'Mali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2160', '90', 'MAM', 'Mamou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2161', '90', 'MAN', 'Mandiana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2162', '90', 'NZR', 'Nzerekore');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2163', '90', 'PIT', 'Pita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2164', '90', 'SIG', 'Siguiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2165', '90', 'TLM', 'Telimele');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2166', '90', 'TOG', 'Tougue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2167', '90', 'YOM', 'Yomou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2168', '91', 'BF', 'Bafata Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2169', '91', 'BB', 'Biombo Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2170', '91', 'BS', 'Bissau Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2171', '91', 'BL', 'Bolama Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2172', '91', 'CA', 'Cacheu Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2173', '91', 'GA', 'Gabu Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2174', '91', 'OI', 'Oio Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2175', '91', 'QU', 'Quinara Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2176', '91', 'TO', 'Tombali Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2177', '92', 'BW', 'Barima-Waini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2178', '92', 'CM', 'Cuyuni-Mazaruni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2179', '92', 'DM', 'Demerara-Mahaica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2180', '92', 'EC', 'East Berbice-Corentyne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2181', '92', 'EW', 'Essequibo Islands-West Demerara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2182', '92', 'MB', 'Mahaica-Berbice');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2183', '92', 'PM', 'Pomeroon-Supenaam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2184', '92', 'PI', 'Potaro-Siparuni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2185', '92', 'UD', 'Upper Demerara-Berbice');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2186', '92', 'UT', 'Upper Takutu-Upper Essequibo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2187', '93', 'AR', 'Artibonite');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2188', '93', 'CE', 'Centre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2189', '93', 'GA', 'Grand\'Anse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2190', '93', 'ND', 'Nord');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2191', '93', 'NE', 'Nord-Est');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2192', '93', 'NO', 'Nord-Ouest');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2193', '93', 'OU', 'Ouest');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2194', '93', 'SD', 'Sud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2195', '93', 'SE', 'Sud-Est');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2196', '94', 'F', 'Flat Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2197', '94', 'M', 'McDonald Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2198', '94', 'S', 'Shag Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2199', '94', 'H', 'Heard Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2200', '95', 'AT', 'Atlantida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2201', '95', 'CH', 'Choluteca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2202', '95', 'CL', 'Colon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2203', '95', 'CM', 'Comayagua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2204', '95', 'CP', 'Copan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2205', '95', 'CR', 'Cortes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2206', '95', 'PA', 'El Paraiso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2207', '95', 'FM', 'Francisco Morazan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2208', '95', 'GD', 'Gracias a Dios');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2209', '95', 'IN', 'Intibuca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2210', '95', 'IB', 'Islas de la Bahia (Bay Islands)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2211', '95', 'PZ', 'La Paz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2212', '95', 'LE', 'Lempira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2213', '95', 'OC', 'Ocotepeque');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2214', '95', 'OL', 'Olancho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2215', '95', 'SB', 'Santa Barbara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2216', '95', 'VA', 'Valle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2217', '95', 'YO', 'Yoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2218', '96', 'HCW', 'Central and Western Hong Kong Is');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2219', '96', 'HEA', 'Eastern Hong Kong Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2220', '96', 'HSO', 'Southern Hong Kong Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2221', '96', 'HWC', 'Wan Chai Hong Kong Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2222', '96', 'KKC', 'Kowloon City Kowloon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2223', '96', 'KKT', 'Kwun Tong Kowloon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2224', '96', 'KSS', 'Sham Shui Po Kowloon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2225', '96', 'KWT', 'Wong Tai Sin Kowloon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2226', '96', 'KYT', 'Yau Tsim Mong Kowloon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2227', '96', 'NIS', 'Islands New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2228', '96', 'NKT', 'Kwai Tsing New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2229', '96', 'NNO', 'North New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2230', '96', 'NSK', 'Sai Kung New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2231', '96', 'NST', 'Sha Tin New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2232', '96', 'NTP', 'Tai Po New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2233', '96', 'NTW', 'Tsuen Wan New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2234', '96', 'NTM', 'Tuen Mun New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2235', '96', 'NYL', 'Yuen Long New Territories');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2236', '97', 'BK', 'Bacs-Kiskun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2237', '97', 'BA', 'Baranya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2238', '97', 'BE', 'Bekes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2239', '97', 'BS', 'Bekescsaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2240', '97', 'BZ', 'Borsod-Abauj-Zemplen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2241', '97', 'BU', 'Budapest');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2242', '97', 'CS', 'Csongrad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2243', '97', 'DE', 'Debrecen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2244', '97', 'DU', 'Dunaujvaros');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2245', '97', 'EG', 'Eger');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2246', '97', 'FE', 'Fejer');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2247', '97', 'GY', 'Gyor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2248', '97', 'GM', 'Gyor-Moson-Sopron');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2249', '97', 'HB', 'Hajdu-Bihar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2250', '97', 'HE', 'Heves');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2251', '97', 'HO', 'Hodmezovasarhely');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2252', '97', 'JN', 'Jasz-Nagykun-Szolnok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2253', '97', 'KA', 'Kaposvar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2254', '97', 'KE', 'Kecskemet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2255', '97', 'KO', 'Komarom-Esztergom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2256', '97', 'MI', 'Miskolc');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2257', '97', 'NA', 'Nagykanizsa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2258', '97', 'NO', 'Nograd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2259', '97', 'NY', 'Nyiregyhaza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2260', '97', 'PE', 'Pecs');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2261', '97', 'PS', 'Pest');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2262', '97', 'SO', 'Somogy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2263', '97', 'SP', 'Sopron');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2264', '97', 'SS', 'Szabolcs-Szatmar-Bereg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2265', '97', 'SZ', 'Szeged');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2266', '97', 'SE', 'Szekesfehervar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2267', '97', 'SL', 'Szolnok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2268', '97', 'SM', 'Szombathely');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2269', '97', 'TA', 'Tatabanya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2270', '97', 'TO', 'Tolna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2271', '97', 'VA', 'Vas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2272', '97', 'VE', 'Veszprem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2273', '97', 'ZA', 'Zala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2274', '97', 'ZZ', 'Zalaegerszeg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2275', '98', 'AL', 'Austurland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2276', '98', 'HF', 'Hofuoborgarsvaeoi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2277', '98', 'NE', 'Norourland eystra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2278', '98', 'NV', 'Norourland vestra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2279', '98', 'SL', 'Suourland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2280', '98', 'SN', 'Suournes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2281', '98', 'VF', 'Vestfiroir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2282', '98', 'VL', 'Vesturland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2283', '99', 'AN', 'Andaman and Nicobar Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2284', '99', 'AP', 'Andhra Pradesh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2285', '99', 'AR', 'Arunachal Pradesh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2286', '99', 'AS', 'Assam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2287', '99', 'BI', 'Bihar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2288', '99', 'CH', 'Chandigarh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2289', '99', 'DA', 'Dadra and Nagar Haveli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2290', '99', 'DM', 'Daman and Diu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2291', '99', 'DE', 'Delhi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2292', '99', 'GO', 'Goa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2293', '99', 'GU', 'Gujarat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2294', '99', 'HA', 'Haryana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2295', '99', 'HP', 'Himachal Pradesh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2296', '99', 'JA', 'Jammu and Kashmir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2297', '99', 'KA', 'Karnataka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2298', '99', 'KE', 'Kerala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2299', '99', 'LI', 'Lakshadweep Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2300', '99', 'MP', 'Madhya Pradesh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2301', '99', 'MA', 'Maharashtra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2302', '99', 'MN', 'Manipur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2303', '99', 'ME', 'Meghalaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2304', '99', 'MI', 'Mizoram');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2305', '99', 'NA', 'Nagaland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2306', '99', 'OR', 'Orissa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2307', '99', 'PO', 'Pondicherry');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2308', '99', 'PU', 'Punjab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2309', '99', 'RA', 'Rajasthan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2310', '99', 'SI', 'Sikkim');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2311', '99', 'TN', 'Tamil Nadu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2312', '99', 'TR', 'Tripura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2313', '99', 'UP', 'Uttar Pradesh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2314', '99', 'WB', 'West Bengal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2315', '100', 'AC', 'Aceh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2316', '100', 'BA', 'Bali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2317', '100', 'BT', 'Banten');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2318', '100', 'BE', 'Bengkulu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2319', '100', 'BD', 'BoDeTaBek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2320', '100', 'GO', 'Gorontalo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2321', '100', 'JK', 'Jakarta Raya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2322', '100', 'JA', 'Jambi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2323', '100', 'JB', 'Jawa Barat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2324', '100', 'JT', 'Jawa Tengah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2325', '100', 'JI', 'Jawa Timur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2326', '100', 'KB', 'Kalimantan Barat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2327', '100', 'KS', 'Kalimantan Selatan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2328', '100', 'KT', 'Kalimantan Tengah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2329', '100', 'KI', 'Kalimantan Timur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2330', '100', 'BB', 'Kepulauan Bangka Belitung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2331', '100', 'LA', 'Lampung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2332', '100', 'MA', 'Maluku');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2333', '100', 'MU', 'Maluku Utara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2334', '100', 'NB', 'Nusa Tenggara Barat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2335', '100', 'NT', 'Nusa Tenggara Timur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2336', '100', 'PA', 'Papua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2337', '100', 'RI', 'Riau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2338', '100', 'SN', 'Sulawesi Selatan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2339', '100', 'ST', 'Sulawesi Tengah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2340', '100', 'SG', 'Sulawesi Tenggara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2341', '100', 'SA', 'Sulawesi Utara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2342', '100', 'SB', 'Sumatera Barat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2343', '100', 'SS', 'Sumatera Selatan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2344', '100', 'SU', 'Sumatera Utara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2345', '100', 'YO', 'Yogyakarta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2346', '101', 'TEH', 'Tehran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2347', '101', 'QOM', 'Qom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2348', '101', 'MKZ', 'Markazi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2349', '101', 'QAZ', 'Qazvin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2350', '101', 'GIL', 'Gilan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2351', '101', 'ARD', 'Ardabil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2352', '101', 'ZAN', 'Zanjan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2353', '101', 'EAZ', 'East Azarbaijan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2354', '101', 'WEZ', 'West Azarbaijan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2355', '101', 'KRD', 'Kurdistan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2356', '101', 'HMD', 'Hamadan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2357', '101', 'KRM', 'Kermanshah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2358', '101', 'ILM', 'Ilam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2359', '101', 'LRS', 'Lorestan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2360', '101', 'KZT', 'Khuzestan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2361', '101', 'CMB', 'Chahar Mahaal and Bakhtiari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2362', '101', 'KBA', 'Kohkiluyeh and Buyer Ahmad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2363', '101', 'BSH', 'Bushehr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2364', '101', 'FAR', 'Fars');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2365', '101', 'HRM', 'Hormozgan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2366', '101', 'SBL', 'Sistan and Baluchistan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2367', '101', 'KRB', 'Kerman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2368', '101', 'YZD', 'Yazd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2369', '101', 'EFH', 'Esfahan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2370', '101', 'SMN', 'Semnan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2371', '101', 'MZD', 'Mazandaran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2372', '101', 'GLS', 'Golestan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2373', '101', 'NKH', 'North Khorasan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2374', '101', 'RKH', 'Razavi Khorasan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2375', '101', 'SKH', 'South Khorasan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2376', '102', 'BD', 'Baghdad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2377', '102', 'SD', 'Salah ad Din');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2378', '102', 'DY', 'Diyala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2379', '102', 'WS', 'Wasit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2380', '102', 'MY', 'Maysan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2381', '102', 'BA', 'Al Basrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2382', '102', 'DQ', 'Dhi Qar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2383', '102', 'MU', 'Al Muthanna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2384', '102', 'QA', 'Al Qadisyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2385', '102', 'BB', 'Babil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2386', '102', 'KB', 'Al Karbala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2387', '102', 'NJ', 'An Najaf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2388', '102', 'AB', 'Al Anbar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2389', '102', 'NN', 'Ninawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2390', '102', 'DH', 'Dahuk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2391', '102', 'AL', 'Arbil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2392', '102', 'TM', 'At Ta\'mim');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2393', '102', 'SL', 'As Sulaymaniyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2394', '103', 'CA', 'Carlow');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2395', '103', 'CV', 'Cavan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2396', '103', 'CL', 'Clare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2397', '103', 'CO', 'Cork');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2398', '103', 'DO', 'Donegal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2399', '103', 'DU', 'Dublin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2400', '103', 'GA', 'Galway');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2401', '103', 'KE', 'Kerry');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2402', '103', 'KI', 'Kildare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2403', '103', 'KL', 'Kilkenny');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2404', '103', 'LA', 'Laois');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2405', '103', 'LE', 'Leitrim');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2406', '103', 'LI', 'Limerick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2407', '103', 'LO', 'Longford');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2408', '103', 'LU', 'Louth');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2409', '103', 'MA', 'Mayo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2410', '103', 'ME', 'Meath');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2411', '103', 'MO', 'Monaghan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2412', '103', 'OF', 'Offaly');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2413', '103', 'RO', 'Roscommon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2414', '103', 'SL', 'Sligo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2415', '103', 'TI', 'Tipperary');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2416', '103', 'WA', 'Waterford');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2417', '103', 'WE', 'Westmeath');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2418', '103', 'WX', 'Wexford');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2419', '103', 'WI', 'Wicklow');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2420', '104', 'BS', 'Be\'er Sheva');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2421', '104', 'BH', 'Bika\'at Hayarden');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2422', '104', 'EA', 'Eilat and Arava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2423', '104', 'GA', 'Galil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2424', '104', 'HA', 'Haifa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2425', '104', 'JM', 'Jehuda Mountains');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2426', '104', 'JE', 'Jerusalem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2427', '104', 'NE', 'Negev');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2428', '104', 'SE', 'Semaria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2429', '104', 'SH', 'Sharon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2430', '104', 'TA', 'Tel Aviv (Gosh Dan)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2431', '105', 'AB', 'Abruzzo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2432', '105', 'BA', 'Basilicata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2433', '105', 'CA', 'Calabria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2434', '105', 'CP', 'Campania');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2435', '105', 'ER', 'Emilia Romagna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2436', '105', 'FV', 'Friuli-Venezia Giulia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2437', '105', 'LA', 'Lazio (Latium & Rome)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2438', '105', 'TM', 'Le Marche (The Marches)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2439', '105', 'LI', 'Liguria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2440', '105', 'LO', 'Lombardia (Lombardy)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2441', '105', 'MO', 'Molise');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2442', '105', 'PI', 'Piemonte (Piedmont)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2443', '105', 'AP', 'Puglia (Apulia)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2444', '105', 'SA', 'Sardegna (Sardinia)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2445', '105', 'SI', 'Sicilia (Sicily)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2446', '105', 'TU', 'Toscana (Tuscany)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2447', '105', 'TR', 'Trentino Alto Adige');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2448', '105', 'UM', 'Umbria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2449', '105', 'VA', 'Val d\'Aosta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2450', '105', 'VE', 'Veneto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2451', '106', 'CLA', 'Clarendon Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2452', '106', 'HAN', 'Hanover Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2453', '106', 'KIN', 'Kingston Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2454', '106', 'MAN', 'Manchester Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2455', '106', 'POR', 'Portland Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2456', '106', 'AND', 'Saint Andrew Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2457', '106', 'ANN', 'Saint Ann Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2458', '106', 'CAT', 'Saint Catherine Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2459', '106', 'ELI', 'Saint Elizabeth Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2460', '106', 'JAM', 'Saint James Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2461', '106', 'MAR', 'Saint Mary Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2462', '106', 'THO', 'Saint Thomas Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2463', '106', 'TRL', 'Trelawny Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2464', '106', 'WML', 'Westmoreland Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2465', '107', 'AI', 'Aichi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2466', '107', 'AK', 'Akita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2467', '107', 'AO', 'Aomori');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2468', '107', 'CH', 'Chiba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2469', '107', 'EH', 'Ehime');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2470', '107', 'FK', 'Fukui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2471', '107', 'FU', 'Fukuoka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2472', '107', 'FS', 'Fukushima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2473', '107', 'GI', 'Gifu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2474', '107', 'GU', 'Gumma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2475', '107', 'HI', 'Hiroshima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2476', '107', 'HO', 'Hokkaido');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2477', '107', 'HY', 'Hyogo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2478', '107', 'IB', 'Ibaraki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2479', '107', 'IS', 'Ishikawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2480', '107', 'IW', 'Iwate');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2481', '107', 'KA', 'Kagawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2482', '107', 'KG', 'Kagoshima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2483', '107', 'KN', 'Kanagawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2484', '107', 'KO', 'Kochi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2485', '107', 'KU', 'Kumamoto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2486', '107', 'KY', 'Kyoto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2487', '107', 'MI', 'Mie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2488', '107', 'MY', 'Miyagi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2489', '107', 'MZ', 'Miyazaki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2490', '107', 'NA', 'Nagano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2491', '107', 'NG', 'Nagasaki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2492', '107', 'NR', 'Nara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2493', '107', 'NI', 'Niigata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2494', '107', 'OI', 'Oita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2495', '107', 'OK', 'Okayama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2496', '107', 'ON', 'Okinawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2497', '107', 'OS', 'Osaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2498', '107', 'SA', 'Saga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2499', '107', 'SI', 'Saitama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2500', '107', 'SH', 'Shiga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2501', '107', 'SM', 'Shimane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2502', '107', 'SZ', 'Shizuoka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2503', '107', 'TO', 'Tochigi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2504', '107', 'TS', 'Tokushima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2505', '107', 'TK', 'Tokyo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2506', '107', 'TT', 'Tottori');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2507', '107', 'TY', 'Toyama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2508', '107', 'WA', 'Wakayama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2509', '107', 'YA', 'Yamagata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2510', '107', 'YM', 'Yamaguchi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2511', '107', 'YN', 'Yamanashi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2512', '108', 'AM', '\'Amman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2513', '108', 'AJ', 'Ajlun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2514', '108', 'AA', 'Al \'Aqabah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2515', '108', 'AB', 'Al Balqa\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2516', '108', 'AK', 'Al Karak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2517', '108', 'AL', 'Al Mafraq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2518', '108', 'AT', 'At Tafilah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2519', '108', 'AZ', 'Az Zarqa\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2520', '108', 'IR', 'Irbid');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2521', '108', 'JA', 'Jarash');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2522', '108', 'MA', 'Ma\'an');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2523', '108', 'MD', 'Madaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2524', '109', 'AL', 'Almaty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2525', '109', 'AC', 'Almaty City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2526', '109', 'AM', 'Aqmola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2527', '109', 'AQ', 'Aqtobe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2528', '109', 'AS', 'Astana City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2529', '109', 'AT', 'Atyrau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2530', '109', 'BA', 'Batys Qazaqstan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2531', '109', 'BY', 'Bayqongyr City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2532', '109', 'MA', 'Mangghystau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2533', '109', 'ON', 'Ongtustik Qazaqstan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2534', '109', 'PA', 'Pavlodar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2535', '109', 'QA', 'Qaraghandy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2536', '109', 'QO', 'Qostanay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2537', '109', 'QY', 'Qyzylorda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2538', '109', 'SH', 'Shyghys Qazaqstan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2539', '109', 'SO', 'Soltustik Qazaqstan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2540', '109', 'ZH', 'Zhambyl');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2541', '110', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2542', '110', 'CO', 'Coast');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2543', '110', 'EA', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2544', '110', 'NA', 'Nairobi Area');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2545', '110', 'NE', 'North Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2546', '110', 'NY', 'Nyanza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2547', '110', 'RV', 'Rift Valley');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2548', '110', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2549', '111', 'AG', 'Abaiang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2550', '111', 'AM', 'Abemama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2551', '111', 'AK', 'Aranuka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2552', '111', 'AO', 'Arorae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2553', '111', 'BA', 'Banaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2554', '111', 'BE', 'Beru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2555', '111', 'bT', 'Butaritari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2556', '111', 'KA', 'Kanton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2557', '111', 'KR', 'Kiritimati');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2558', '111', 'KU', 'Kuria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2559', '111', 'MI', 'Maiana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2560', '111', 'MN', 'Makin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2561', '111', 'ME', 'Marakei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2562', '111', 'NI', 'Nikunau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2563', '111', 'NO', 'Nonouti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2564', '111', 'ON', 'Onotoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2565', '111', 'TT', 'Tabiteuea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2566', '111', 'TR', 'Tabuaeran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2567', '111', 'TM', 'Tamana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2568', '111', 'TW', 'Tarawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2569', '111', 'TE', 'Teraina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2570', '112', 'CHA', 'Chagang-do');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2571', '112', 'HAB', 'Hamgyong-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2572', '112', 'HAN', 'Hamgyong-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2573', '112', 'HWB', 'Hwanghae-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2574', '112', 'HWN', 'Hwanghae-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2575', '112', 'KAN', 'Kangwon-do');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2576', '112', 'PYB', 'P\'yongan-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2577', '112', 'PYN', 'P\'yongan-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2578', '112', 'YAN', 'Ryanggang-do (Yanggang-do)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2579', '112', 'NAJ', 'Rason Directly Governed City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2580', '112', 'PYO', 'P\'yongyang Special City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2581', '113', 'CO', 'Ch\'ungch\'ong-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2582', '113', 'CH', 'Ch\'ungch\'ong-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2583', '113', 'CD', 'Cheju-do');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2584', '113', 'CB', 'Cholla-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2585', '113', 'CN', 'Cholla-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2586', '113', 'IG', 'Inch\'on-gwangyoksi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2587', '113', 'KA', 'Kangwon-do');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2588', '113', 'KG', 'Kwangju-gwangyoksi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2589', '113', 'KD', 'Kyonggi-do');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2590', '113', 'KB', 'Kyongsang-bukto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2591', '113', 'KN', 'Kyongsang-namdo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2592', '113', 'PG', 'Pusan-gwangyoksi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2593', '113', 'SO', 'Soul-t\'ukpyolsi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2594', '113', 'TA', 'Taegu-gwangyoksi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2595', '113', 'TG', 'Taejon-gwangyoksi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2596', '114', 'AL', 'Al \'Asimah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2597', '114', 'AA', 'Al Ahmadi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2598', '114', 'AF', 'Al Farwaniyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2599', '114', 'AJ', 'Al Jahra\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2600', '114', 'HA', 'Hawalli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2601', '115', 'GB', 'Bishkek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2602', '115', 'B', 'Batken');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2603', '115', 'C', 'Chu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2604', '115', 'J', 'Jalal-Abad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2605', '115', 'N', 'Naryn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2606', '115', 'O', 'Osh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2607', '115', 'T', 'Talas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2608', '115', 'Y', 'Ysyk-Kol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2609', '116', 'VT', 'Vientiane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2610', '116', 'AT', 'Attapu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2611', '116', 'BK', 'Bokeo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2612', '116', 'BL', 'Bolikhamxai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2613', '116', 'CH', 'Champasak ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2614', '116', 'HO', 'Houaphan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2615', '116', 'KH', 'Khammouan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2616', '116', 'LM', 'Louang Namtha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2617', '116', 'LP', 'Louangphabang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2618', '116', 'OU', 'Oudomxai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2619', '116', 'PH', 'Phongsali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2620', '116', 'SL', 'Salavan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2621', '116', 'SV', 'Savannakhet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2622', '116', 'VI', 'Vientiane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2623', '116', 'XA', 'Xaignabouli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2624', '116', 'XE', 'Xekong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2625', '116', 'XI', 'Xiangkhoang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2626', '116', 'XN', 'Xaisomboun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2627', '117', 'AIZ', 'Aizkraukles Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2628', '117', 'ALU', 'Aluksnes Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2629', '117', 'BAL', 'Balvu Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2630', '117', 'BAU', 'Bauskas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2631', '117', 'CES', 'Cesu Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2632', '117', 'DGR', 'Daugavpils Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2633', '117', 'DOB', 'Dobeles Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2634', '117', 'GUL', 'Gulbenes Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2635', '117', 'JEK', 'Jekabpils Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2636', '117', 'JGR', 'Jelgavas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2637', '117', 'KRA', 'Kraslavas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2638', '117', 'KUL', 'Kuldigas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2639', '117', 'LPR', 'Liepajas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2640', '117', 'LIM', 'Limbazu Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2641', '117', 'LUD', 'Ludzas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2642', '117', 'MAD', 'Madonas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2643', '117', 'OGR', 'Ogres Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2644', '117', 'PRE', 'Preilu Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2645', '117', 'RZR', 'Rezeknes Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2646', '117', 'RGR', 'Rigas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2647', '117', 'SAL', 'Saldus Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2648', '117', 'TAL', 'Talsu Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2649', '117', 'TUK', 'Tukuma Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2650', '117', 'VLK', 'Valkas Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2651', '117', 'VLM', 'Valmieras Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2652', '117', 'VSR', 'Ventspils Rajons');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2653', '117', 'DGV', 'Daugavpils');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2654', '117', 'JGV', 'Jelgava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2655', '117', 'JUR', 'Jurmala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2656', '117', 'LPK', 'Liepaja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2657', '117', 'RZK', 'Rezekne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2658', '117', 'RGA', 'Riga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2659', '117', 'VSL', 'Ventspils');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2660', '119', 'BE', 'Berea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2661', '119', 'BB', 'Butha-Buthe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2662', '119', 'LE', 'Leribe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2663', '119', 'MF', 'Mafeteng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2664', '119', 'MS', 'Maseru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2665', '119', 'MH', 'Mohale\'s Hoek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2666', '119', 'MK', 'Mokhotlong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2667', '119', 'QN', 'Qacha\'s Nek');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2668', '119', 'QT', 'Quthing');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2669', '119', 'TT', 'Thaba-Tseka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2670', '120', 'BI', 'Bomi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2671', '120', 'BG', 'Bong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2672', '120', 'GB', 'Grand Bassa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2673', '120', 'CM', 'Grand Cape Mount');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2674', '120', 'GG', 'Grand Gedeh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2675', '120', 'GK', 'Grand Kru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2676', '120', 'LO', 'Lofa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2677', '120', 'MG', 'Margibi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2678', '120', 'ML', 'Maryland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2679', '120', 'MS', 'Montserrado');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2680', '120', 'NB', 'Nimba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2681', '120', 'RC', 'River Cess');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2682', '120', 'SN', 'Sinoe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2683', '121', 'AJ', 'Ajdabiya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2684', '121', 'AZ', 'Al \'Aziziyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2685', '121', 'FA', 'Al Fatih');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2686', '121', 'JA', 'Al Jabal al Akhdar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2687', '121', 'JU', 'Al Jufrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2688', '121', 'KH', 'Al Khums');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2689', '121', 'KU', 'Al Kufrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2690', '121', 'NK', 'An Nuqat al Khams');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2691', '121', 'AS', 'Ash Shati\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2692', '121', 'AW', 'Awbari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2693', '121', 'ZA', 'Az Zawiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2694', '121', 'BA', 'Banghazi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2695', '121', 'DA', 'Darnah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2696', '121', 'GD', 'Ghadamis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2697', '121', 'GY', 'Gharyan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2698', '121', 'MI', 'Misratah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2699', '121', 'MZ', 'Murzuq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2700', '121', 'SB', 'Sabha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2701', '121', 'SW', 'Sawfajjin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2702', '121', 'SU', 'Surt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2703', '121', 'TL', 'Tarabulus (Tripoli)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2704', '121', 'TH', 'Tarhunah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2705', '121', 'TU', 'Tubruq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2706', '121', 'YA', 'Yafran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2707', '121', 'ZL', 'Zlitan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2708', '122', 'V', 'Vaduz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2709', '122', 'A', 'Schaan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2710', '122', 'B', 'Balzers');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2711', '122', 'N', 'Triesen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2712', '122', 'E', 'Eschen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2713', '122', 'M', 'Mauren');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2714', '122', 'T', 'Triesenberg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2715', '122', 'R', 'Ruggell');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2716', '122', 'G', 'Gamprin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2717', '122', 'L', 'Schellenberg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2718', '122', 'P', 'Planken');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2719', '123', 'AL', 'Alytus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2720', '123', 'KA', 'Kaunas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2721', '123', 'KL', 'Klaipeda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2722', '123', 'MA', 'Marijampole');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2723', '123', 'PA', 'Panevezys');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2724', '123', 'SI', 'Siauliai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2725', '123', 'TA', 'Taurage');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2726', '123', 'TE', 'Telsiai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2727', '123', 'UT', 'Utena');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2728', '123', 'VI', 'Vilnius');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2729', '124', 'DD', 'Diekirch');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2730', '124', 'DC', 'Clervaux');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2731', '124', 'DR', 'Redange');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2732', '124', 'DV', 'Vianden');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2733', '124', 'DW', 'Wiltz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2734', '124', 'GG', 'Grevenmacher');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2735', '124', 'GE', 'Echternach');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2736', '124', 'GR', 'Remich');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2737', '124', 'LL', 'Luxembourg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2738', '124', 'LC', 'Capellen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2739', '124', 'LE', 'Esch-sur-Alzette');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2740', '124', 'LM', 'Mersch');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2741', '125', 'OLF', 'Our Lady Fatima Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2742', '125', 'ANT', 'St. Anthony Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2743', '125', 'LAZ', 'St. Lazarus Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2744', '125', 'CAT', 'Cathedral Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2745', '125', 'LAW', 'St. Lawrence Parish');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2746', '127', 'AN', 'Antananarivo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2747', '127', 'AS', 'Antsiranana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2748', '127', 'FN', 'Fianarantsoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2749', '127', 'MJ', 'Mahajanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2750', '127', 'TM', 'Toamasina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2751', '127', 'TL', 'Toliara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2752', '128', 'BLK', 'Balaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2753', '128', 'BLT', 'Blantyre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2754', '128', 'CKW', 'Chikwawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2755', '128', 'CRD', 'Chiradzulu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2756', '128', 'CTP', 'Chitipa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2757', '128', 'DDZ', 'Dedza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2758', '128', 'DWA', 'Dowa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2759', '128', 'KRG', 'Karonga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2760', '128', 'KSG', 'Kasungu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2761', '128', 'LKM', 'Likoma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2762', '128', 'LLG', 'Lilongwe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2763', '128', 'MCG', 'Machinga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2764', '128', 'MGC', 'Mangochi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2765', '128', 'MCH', 'Mchinji');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2766', '128', 'MLJ', 'Mulanje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2767', '128', 'MWZ', 'Mwanza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2768', '128', 'MZM', 'Mzimba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2769', '128', 'NTU', 'Ntcheu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2770', '128', 'NKB', 'Nkhata Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2771', '128', 'NKH', 'Nkhotakota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2772', '128', 'NSJ', 'Nsanje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2773', '128', 'NTI', 'Ntchisi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2774', '128', 'PHL', 'Phalombe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2775', '128', 'RMP', 'Rumphi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2776', '128', 'SLM', 'Salima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2777', '128', 'THY', 'Thyolo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2778', '128', 'ZBA', 'Zomba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2779', '129', 'JO', 'Johor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2780', '129', 'KE', 'Kedah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2781', '129', 'KL', 'Kelantan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2782', '129', 'LA', 'Labuan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2783', '129', 'ME', 'Melaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2784', '129', 'NS', 'Negeri Sembilan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2785', '129', 'PA', 'Pahang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2786', '129', 'PE', 'Perak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2787', '129', 'PR', 'Perlis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2788', '129', 'PP', 'Pulau Pinang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2789', '129', 'SA', 'Sabah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2790', '129', 'SR', 'Sarawak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2791', '129', 'SE', 'Selangor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2792', '129', 'TE', 'Terengganu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2793', '129', 'WP', 'Wilayah Persekutuan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2794', '130', 'THU', 'Thiladhunmathi Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2795', '130', 'THD', 'Thiladhunmathi Dhekunu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2796', '130', 'MLU', 'Miladhunmadulu Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2797', '130', 'MLD', 'Miladhunmadulu Dhekunu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2798', '130', 'MAU', 'Maalhosmadulu Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2799', '130', 'MAD', 'Maalhosmadulu Dhekunu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2800', '130', 'FAA', 'Faadhippolhu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2801', '130', 'MAA', 'Male Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2802', '130', 'AAU', 'Ari Atoll Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2803', '130', 'AAD', 'Ari Atoll Dheknu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2804', '130', 'FEA', 'Felidhe Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2805', '130', 'MUA', 'Mulaku Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2806', '130', 'NAU', 'Nilandhe Atoll Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2807', '130', 'NAD', 'Nilandhe Atoll Dhekunu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2808', '130', 'KLH', 'Kolhumadulu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2809', '130', 'HDH', 'Hadhdhunmathi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2810', '130', 'HAU', 'Huvadhu Atoll Uthuru');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2811', '130', 'HAD', 'Huvadhu Atoll Dhekunu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2812', '130', 'FMU', 'Fua Mulaku');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2813', '130', 'ADD', 'Addu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2814', '131', 'GA', 'Gao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2815', '131', 'KY', 'Kayes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2816', '131', 'KD', 'Kidal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2817', '131', 'KL', 'Koulikoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2818', '131', 'MP', 'Mopti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2819', '131', 'SG', 'Segou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2820', '131', 'SK', 'Sikasso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2821', '131', 'TB', 'Tombouctou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2822', '131', 'CD', 'Bamako Capital District');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2823', '132', 'ATT', 'Attard');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2824', '132', 'BAL', 'Balzan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2825', '132', 'BGU', 'Birgu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2826', '132', 'BKK', 'Birkirkara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2827', '132', 'BRZ', 'Birzebbuga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2828', '132', 'BOR', 'Bormla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2829', '132', 'DIN', 'Dingli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2830', '132', 'FGU', 'Fgura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2831', '132', 'FLO', 'Floriana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2832', '132', 'GDJ', 'Gudja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2833', '132', 'GZR', 'Gzira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2834', '132', 'GRG', 'Gargur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2835', '132', 'GXQ', 'Gaxaq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2836', '132', 'HMR', 'Hamrun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2837', '132', 'IKL', 'Iklin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2838', '132', 'ISL', 'Isla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2839', '132', 'KLK', 'Kalkara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2840', '132', 'KRK', 'Kirkop');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2841', '132', 'LIJ', 'Lija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2842', '132', 'LUQ', 'Luqa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2843', '132', 'MRS', 'Marsa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2844', '132', 'MKL', 'Marsaskala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2845', '132', 'MXL', 'Marsaxlokk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2846', '132', 'MDN', 'Mdina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2847', '132', 'MEL', 'Melliea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2848', '132', 'MGR', 'Mgarr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2849', '132', 'MST', 'Mosta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2850', '132', 'MQA', 'Mqabba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2851', '132', 'MSI', 'Msida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2852', '132', 'MTF', 'Mtarfa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2853', '132', 'NAX', 'Naxxar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2854', '132', 'PAO', 'Paola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2855', '132', 'PEM', 'Pembroke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2856', '132', 'PIE', 'Pieta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2857', '132', 'QOR', 'Qormi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2858', '132', 'QRE', 'Qrendi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2859', '132', 'RAB', 'Rabat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2860', '132', 'SAF', 'Safi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2861', '132', 'SGI', 'San Giljan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2862', '132', 'SLU', 'Santa Lucija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2863', '132', 'SPB', 'San Pawl il-Bahar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2864', '132', 'SGW', 'San Gwann');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2865', '132', 'SVE', 'Santa Venera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2866', '132', 'SIG', 'Siggiewi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2867', '132', 'SLM', 'Sliema');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2868', '132', 'SWQ', 'Swieqi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2869', '132', 'TXB', 'Ta Xbiex');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2870', '132', 'TRX', 'Tarxien');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2871', '132', 'VLT', 'Valletta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2872', '132', 'XGJ', 'Xgajra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2873', '132', 'ZBR', 'Zabbar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2874', '132', 'ZBG', 'Zebbug');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2875', '132', 'ZJT', 'Zejtun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2876', '132', 'ZRQ', 'Zurrieq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2877', '132', 'FNT', 'Fontana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2878', '132', 'GHJ', 'Ghajnsielem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2879', '132', 'GHR', 'Gharb');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2880', '132', 'GHS', 'Ghasri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2881', '132', 'KRC', 'Kercem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2882', '132', 'MUN', 'Munxar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2883', '132', 'NAD', 'Nadur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2884', '132', 'QAL', 'Qala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2885', '132', 'VIC', 'Victoria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2886', '132', 'SLA', 'San Lawrenz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2887', '132', 'SNT', 'Sannat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2888', '132', 'ZAG', 'Xagra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2889', '132', 'XEW', 'Xewkija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2890', '132', 'ZEB', 'Zebbug');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2891', '133', 'ALG', 'Ailinginae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2892', '133', 'ALL', 'Ailinglaplap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2893', '133', 'ALK', 'Ailuk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2894', '133', 'ARN', 'Arno');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2895', '133', 'AUR', 'Aur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2896', '133', 'BKR', 'Bikar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2897', '133', 'BKN', 'Bikini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2898', '133', 'BKK', 'Bokak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2899', '133', 'EBN', 'Ebon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2900', '133', 'ENT', 'Enewetak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2901', '133', 'EKB', 'Erikub');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2902', '133', 'JBT', 'Jabat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2903', '133', 'JLT', 'Jaluit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2904', '133', 'JEM', 'Jemo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2905', '133', 'KIL', 'Kili');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2906', '133', 'KWJ', 'Kwajalein');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2907', '133', 'LAE', 'Lae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2908', '133', 'LIB', 'Lib');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2909', '133', 'LKP', 'Likiep');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2910', '133', 'MJR', 'Majuro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2911', '133', 'MLP', 'Maloelap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2912', '133', 'MJT', 'Mejit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2913', '133', 'MIL', 'Mili');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2914', '133', 'NMK', 'Namorik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2915', '133', 'NAM', 'Namu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2916', '133', 'RGL', 'Rongelap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2917', '133', 'RGK', 'Rongrik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2918', '133', 'TOK', 'Toke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2919', '133', 'UJA', 'Ujae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2920', '133', 'UJL', 'Ujelang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2921', '133', 'UTK', 'Utirik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2922', '133', 'WTH', 'Wotho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2923', '133', 'WTJ', 'Wotje');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2924', '135', 'AD', 'Adrar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2925', '135', 'AS', 'Assaba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2926', '135', 'BR', 'Brakna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2927', '135', 'DN', 'Dakhlet Nouadhibou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2928', '135', 'GO', 'Gorgol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2929', '135', 'GM', 'Guidimaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2930', '135', 'HC', 'Hodh Ech Chargui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2931', '135', 'HG', 'Hodh El Gharbi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2932', '135', 'IN', 'Inchiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2933', '135', 'TA', 'Tagant');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2934', '135', 'TZ', 'Tiris Zemmour');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2935', '135', 'TR', 'Trarza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2936', '135', 'NO', 'Nouakchott');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2937', '136', 'BR', 'Beau Bassin-Rose Hill');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2938', '136', 'CU', 'Curepipe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2939', '136', 'PU', 'Port Louis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2940', '136', 'QB', 'Quatre Bornes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2941', '136', 'VP', 'Vacoas-Phoenix');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2942', '136', 'AG', 'Agalega Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2943', '136', 'CC', 'Cargados Carajos Shoals (Saint B');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2944', '136', 'RO', 'Rodrigues');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2945', '136', 'BL', 'Black River');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2946', '136', 'FL', 'Flacq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2947', '136', 'GP', 'Grand Port');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2948', '136', 'MO', 'Moka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2949', '136', 'PA', 'Pamplemousses');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2950', '136', 'PW', 'Plaines Wilhems');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2951', '136', 'PL', 'Port Louis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2952', '136', 'RR', 'Riviere du Rempart');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2953', '136', 'SA', 'Savanne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2954', '138', 'BN', 'Baja California Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2955', '138', 'BS', 'Baja California Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2956', '138', 'CA', 'Campeche');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2957', '138', 'CI', 'Chiapas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2958', '138', 'CH', 'Chihuahua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2959', '138', 'CZ', 'Coahuila de Zaragoza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2960', '138', 'CL', 'Colima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2961', '138', 'DF', 'Distrito Federal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2962', '138', 'DU', 'Durango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2963', '138', 'GA', 'Guanajuato');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2964', '138', 'GE', 'Guerrero');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2965', '138', 'HI', 'Hidalgo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2966', '138', 'JA', 'Jalisco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2967', '138', 'ME', 'Mexico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2968', '138', 'MI', 'Michoacan de Ocampo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2969', '138', 'MO', 'Morelos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2970', '138', 'NA', 'Nayarit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2971', '138', 'NL', 'Nuevo Leon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2972', '138', 'OA', 'Oaxaca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2973', '138', 'PU', 'Puebla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2974', '138', 'QA', 'Queretaro de Arteaga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2975', '138', 'QR', 'Quintana Roo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2976', '138', 'SA', 'San Luis Potosi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2977', '138', 'SI', 'Sinaloa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2978', '138', 'SO', 'Sonora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2979', '138', 'TB', 'Tabasco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2980', '138', 'TM', 'Tamaulipas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2981', '138', 'TL', 'Tlaxcala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2982', '138', 'VE', 'Veracruz-Llave');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2983', '138', 'YU', 'Yucatan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2984', '138', 'ZA', 'Zacatecas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2985', '139', 'C', 'Chuuk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2986', '139', 'K', 'Kosrae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2987', '139', 'P', 'Pohnpei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2988', '139', 'Y', 'Yap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2989', '140', 'GA', 'Gagauzia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2990', '140', 'CU', 'Chisinau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2991', '140', 'BA', 'Balti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2992', '140', 'CA', 'Cahul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2993', '140', 'ED', 'Edinet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2994', '140', 'LA', 'Lapusna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2995', '140', 'OR', 'Orhei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2996', '140', 'SO', 'Soroca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2997', '140', 'TI', 'Tighina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2998', '140', 'UN', 'Ungheni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('2999', '140', 'SN', 'Stânga Nistrului');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3000', '141', 'FV', 'Fontvieille');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3001', '141', 'LC', 'La Condamine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3002', '141', 'MV', 'Monaco-Ville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3003', '141', 'MC', 'Monte-Carlo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3004', '142', '1', 'Ulanbaatar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3005', '142', '035', 'Orhon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3006', '142', '037', 'Darhan uul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3007', '142', '039', 'Hentiy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3008', '142', '041', 'Hovsgol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3009', '142', '043', 'Hovd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3010', '142', '046', 'Uvs');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3011', '142', '047', 'Tov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3012', '142', '049', 'Selenge');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3013', '142', '051', 'Suhbaatar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3014', '142', '053', 'Omnogovi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3015', '142', '055', 'Ovorhangay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3016', '142', '057', 'Dzavhan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3017', '142', '059', 'DundgovL');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3018', '142', '061', 'Dornod');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3019', '142', '063', 'Dornogov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3020', '142', '064', 'Govi-Sumber');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3021', '142', '065', 'Govi-Altay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3022', '142', '067', 'Bulgan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3023', '142', '069', 'Bayanhongor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3024', '142', '071', 'Bayan-Olgiy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3025', '142', '073', 'Arhangay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3026', '143', 'A', 'Saint Anthony');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3027', '143', 'G', 'Saint Georges');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3028', '143', 'P', 'Saint Peter');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3029', '144', 'AGD', 'Agadir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3030', '144', 'HOC', 'Al Hoceima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3031', '144', 'AZI', 'Azilal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3032', '144', 'BME', 'Beni Mellal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3033', '144', 'BSL', 'Ben Slimane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3034', '144', 'BLM', 'Boulemane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3035', '144', 'CBL', 'Casablanca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3036', '144', 'CHA', 'Chaouen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3037', '144', 'EJA', 'El Jadida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3038', '144', 'EKS', 'El Kelaa des Sraghna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3039', '144', 'ERA', 'Er Rachidia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3040', '144', 'ESS', 'Essaouira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3041', '144', 'FES', 'Fes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3042', '144', 'FIG', 'Figuig');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3043', '144', 'GLM', 'Guelmim');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3044', '144', 'IFR', 'Ifrane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3045', '144', 'KEN', 'Kenitra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3046', '144', 'KHM', 'Khemisset');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3047', '144', 'KHN', 'Khenifra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3048', '144', 'KHO', 'Khouribga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3049', '144', 'LYN', 'Laayoune');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3050', '144', 'LAR', 'Larache');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3051', '144', 'MRK', 'Marrakech');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3052', '144', 'MKN', 'Meknes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3053', '144', 'NAD', 'Nador');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3054', '144', 'ORZ', 'Ouarzazate');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3055', '144', 'OUJ', 'Oujda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3056', '144', 'RSA', 'Rabat-Sale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3057', '144', 'SAF', 'Safi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3058', '144', 'SET', 'Settat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3059', '144', 'SKA', 'Sidi Kacem');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3060', '144', 'TGR', 'Tangier');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3061', '144', 'TAN', 'Tan-Tan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3062', '144', 'TAO', 'Taounate');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3063', '144', 'TRD', 'Taroudannt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3064', '144', 'TAT', 'Tata');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3065', '144', 'TAZ', 'Taza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3066', '144', 'TET', 'Tetouan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3067', '144', 'TIZ', 'Tiznit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3068', '144', 'ADK', 'Ad Dakhla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3069', '144', 'BJD', 'Boujdour');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3070', '144', 'ESM', 'Es Smara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3071', '145', 'CD', 'Cabo Delgado');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3072', '145', 'GZ', 'Gaza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3073', '145', 'IN', 'Inhambane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3074', '145', 'MN', 'Manica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3075', '145', 'MC', 'Maputo (city)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3076', '145', 'MP', 'Maputo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3077', '145', 'NA', 'Nampula');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3078', '145', 'NI', 'Niassa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3079', '145', 'SO', 'Sofala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3080', '145', 'TE', 'Tete');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3081', '145', 'ZA', 'Zambezia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3082', '146', 'AY', 'Ayeyarwady');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3083', '146', 'BG', 'Bago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3084', '146', 'MG', 'Magway');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3085', '146', 'MD', 'Mandalay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3086', '146', 'SG', 'Sagaing');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3087', '146', 'TN', 'Tanintharyi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3088', '146', 'YG', 'Yangon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3089', '146', 'CH', 'Chin State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3090', '146', 'KC', 'Kachin State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3091', '146', 'KH', 'Kayah State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3092', '146', 'KN', 'Kayin State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3093', '146', 'MN', 'Mon State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3094', '146', 'RK', 'Rakhine State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3095', '146', 'SH', 'Shan State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3096', '147', 'CA', 'Caprivi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3097', '147', 'ER', 'Erongo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3098', '147', 'HA', 'Hardap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3099', '147', 'KR', 'Karas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3100', '147', 'KV', 'Kavango');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3101', '147', 'KH', 'Khomas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3102', '147', 'KU', 'Kunene');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3103', '147', 'OW', 'Ohangwena');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3104', '147', 'OK', 'Omaheke');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3105', '147', 'OT', 'Omusati');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3106', '147', 'ON', 'Oshana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3107', '147', 'OO', 'Oshikoto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3108', '147', 'OJ', 'Otjozondjupa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3109', '148', 'AO', 'Aiwo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3110', '148', 'AA', 'Anabar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3111', '148', 'AT', 'Anetan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3112', '148', 'AI', 'Anibare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3113', '148', 'BA', 'Baiti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3114', '148', 'BO', 'Boe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3115', '148', 'BU', 'Buada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3116', '148', 'DE', 'Denigomodu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3117', '148', 'EW', 'Ewa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3118', '148', 'IJ', 'Ijuw');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3119', '148', 'ME', 'Meneng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3120', '148', 'NI', 'Nibok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3121', '148', 'UA', 'Uaboe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3122', '148', 'YA', 'Yaren');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3123', '149', 'BA', 'Bagmati');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3124', '149', 'BH', 'Bheri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3125', '149', 'DH', 'Dhawalagiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3126', '149', 'GA', 'Gandaki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3127', '149', 'JA', 'Janakpur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3128', '149', 'KA', 'Karnali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3129', '149', 'KO', 'Kosi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3130', '149', 'LU', 'Lumbini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3131', '149', 'MA', 'Mahakali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3132', '149', 'ME', 'Mechi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3133', '149', 'NA', 'Narayani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3134', '149', 'RA', 'Rapti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3135', '149', 'SA', 'Sagarmatha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3136', '149', 'SE', 'Seti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3137', '150', 'DR', 'Drenthe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3138', '150', 'FL', 'Flevoland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3139', '150', 'FR', 'Friesland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3140', '150', 'GE', 'Gelderland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3141', '150', 'GR', 'Groningen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3142', '150', 'LI', 'Limburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3143', '150', 'NB', 'Noord Brabant');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3144', '150', 'NH', 'Noord Holland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3145', '150', 'OV', 'Overijssel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3146', '150', 'UT', 'Utrecht');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3147', '150', 'ZE', 'Zeeland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3148', '150', 'ZH', 'Zuid Holland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3149', '152', 'L', 'Iles Loyaute');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3150', '152', 'N', 'Nord');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3151', '152', 'S', 'Sud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3152', '153', 'AUK', 'Auckland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3153', '153', 'BOP', 'Bay of Plenty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3154', '153', 'CAN', 'Canterbury');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3155', '153', 'GIS', 'Gisborne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3156', '153', 'HKB', 'Hawke\'s Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3157', '153', 'MBH', 'Marlborough');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3158', '153', 'MWT', 'Manawatu-Wanganui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3159', '153', 'NSN', 'Nelson');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3160', '153', 'NTL', 'Northland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3161', '153', 'OTA', 'Otago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3162', '153', 'STL', 'Southland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3163', '153', 'TAS', 'Tasman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3164', '153', 'TKI', 'Taranaki');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3165', '153', 'WGN', 'Wellington');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3166', '153', 'WKO', 'Waikato');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3167', '153', 'WTC', 'West Coast');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3168', '154', 'AN', 'Atlantico Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3169', '154', 'AS', 'Atlantico Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3170', '154', 'BO', 'Boaco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3171', '154', 'CA', 'Carazo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3172', '154', 'CI', 'Chinandega');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3173', '154', 'CO', 'Chontales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3174', '154', 'ES', 'Esteli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3175', '154', 'GR', 'Granada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3176', '154', 'JI', 'Jinotega');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3177', '154', 'LE', 'Leon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3178', '154', 'MD', 'Madriz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3179', '154', 'MN', 'Managua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3180', '154', 'MS', 'Masaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3181', '154', 'MT', 'Matagalpa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3182', '154', 'NS', 'Nuevo Segovia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3183', '154', 'RS', 'Rio San Juan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3184', '154', 'RI', 'Rivas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3185', '155', 'AG', 'Agadez');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3186', '155', 'DF', 'Diffa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3187', '155', 'DS', 'Dosso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3188', '155', 'MA', 'Maradi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3189', '155', 'NM', 'Niamey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3190', '155', 'TH', 'Tahoua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3191', '155', 'TL', 'Tillaberi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3192', '155', 'ZD', 'Zinder');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3193', '156', 'AB', 'Abia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3194', '156', 'CT', 'Abuja Federal Capital Territory');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3195', '156', 'AD', 'Adamawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3196', '156', 'AK', 'Akwa Ibom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3197', '156', 'AN', 'Anambra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3198', '156', 'BC', 'Bauchi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3199', '156', 'BY', 'Bayelsa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3200', '156', 'BN', 'Benue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3201', '156', 'BO', 'Borno');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3202', '156', 'CR', 'Cross River');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3203', '156', 'DE', 'Delta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3204', '156', 'EB', 'Ebonyi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3205', '156', 'ED', 'Edo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3206', '156', 'EK', 'Ekiti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3207', '156', 'EN', 'Enugu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3208', '156', 'GO', 'Gombe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3209', '156', 'IM', 'Imo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3210', '156', 'JI', 'Jigawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3211', '156', 'KD', 'Kaduna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3212', '156', 'KN', 'Kano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3213', '156', 'KT', 'Katsina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3214', '156', 'KE', 'Kebbi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3215', '156', 'KO', 'Kogi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3216', '156', 'KW', 'Kwara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3217', '156', 'LA', 'Lagos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3218', '156', 'NA', 'Nassarawa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3219', '156', 'NI', 'Niger');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3220', '156', 'OG', 'Ogun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3221', '156', 'ONG', 'Ondo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3222', '156', 'OS', 'Osun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3223', '156', 'OY', 'Oyo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3224', '156', 'PL', 'Plateau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3225', '156', 'RI', 'Rivers');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3226', '156', 'SO', 'Sokoto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3227', '156', 'TA', 'Taraba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3228', '156', 'YO', 'Yobe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3229', '156', 'ZA', 'Zamfara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3230', '159', 'N', 'Northern Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3231', '159', 'R', 'Rota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3232', '159', 'S', 'Saipan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3233', '159', 'T', 'Tinian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3234', '160', 'AK', 'Akershus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3235', '160', 'AA', 'Aust-Agder');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3236', '160', 'BU', 'Buskerud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3237', '160', 'FM', 'Finnmark');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3238', '160', 'HM', 'Hedmark');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3239', '160', 'HL', 'Hordaland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3240', '160', 'MR', 'More og Romdal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3241', '160', 'NT', 'Nord-Trondelag');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3242', '160', 'NL', 'Nordland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3243', '160', 'OF', 'Ostfold');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3244', '160', 'OP', 'Oppland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3245', '160', 'OL', 'Oslo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3246', '160', 'RL', 'Rogaland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3247', '160', 'ST', 'Sor-Trondelag');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3248', '160', 'SJ', 'Sogn og Fjordane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3249', '160', 'SV', 'Svalbard');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3250', '160', 'TM', 'Telemark');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3251', '160', 'TR', 'Troms');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3252', '160', 'VA', 'Vest-Agder');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3253', '160', 'VF', 'Vestfold');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3254', '161', 'DA', 'Ad Dakhiliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3255', '161', 'BA', 'Al Batinah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3256', '161', 'WU', 'Al Wusta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3257', '161', 'SH', 'Ash Sharqiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3258', '161', 'ZA', 'Az Zahirah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3259', '161', 'MA', 'Masqat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3260', '161', 'MU', 'Musandam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3261', '161', 'ZU', 'Zufar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3262', '162', 'B', 'Balochistan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3263', '162', 'T', 'Federally Administered Tribal Ar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3264', '162', 'I', 'Islamabad Capital Territory');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3265', '162', 'N', 'North-West Frontier');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3266', '162', 'P', 'Punjab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3267', '162', 'S', 'Sindh ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3268', '163', 'AM', 'Aimeliik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3269', '163', 'AR', 'Airai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3270', '163', 'AN', 'Angaur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3271', '163', 'HA', 'Hatohobei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3272', '163', 'KA', 'Kayangel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3273', '163', 'KO', 'Koror');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3274', '163', 'ME', 'Melekeok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3275', '163', 'NA', 'Ngaraard');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3276', '163', 'NG', 'Ngarchelong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3277', '163', 'ND', 'Ngardmau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3278', '163', 'NT', 'Ngatpang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3279', '163', 'NC', 'Ngchesar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3280', '163', 'NR', 'Ngeremlengui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3281', '163', 'NW', 'Ngiwal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3282', '163', 'PE', 'Peleliu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3283', '163', 'SO', 'Sonsorol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3284', '164', 'BT', 'Bocas del Toro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3285', '164', 'CH', 'Chiriqui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3286', '164', 'CC', 'Cocle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3287', '164', 'CL', 'Colon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3288', '164', 'DA', 'Darien');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3289', '164', 'HE', 'Herrera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3290', '164', 'LS', 'Los Santos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3291', '164', 'PA', 'Panama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3292', '164', 'SB', 'San Blas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3293', '164', 'VG', 'Veraguas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3294', '165', 'BV', 'Bougainville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3295', '165', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3296', '165', 'CH', 'Chimbu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3297', '165', 'EH', 'Eastern Highlands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3298', '165', 'EB', 'East New Britain');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3299', '165', 'ES', 'East Sepik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3300', '165', 'EN', 'Enga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3301', '165', 'GU', 'Gulf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3302', '165', 'MD', 'Madang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3303', '165', 'MN', 'Manus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3304', '165', 'MB', 'Milne Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3305', '165', 'MR', 'Morobe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3306', '165', 'NC', 'National Capital');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3307', '165', 'NI', 'New Ireland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3308', '165', 'NO', 'Northern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3309', '165', 'SA', 'Sandaun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3310', '165', 'SH', 'Southern Highlands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3311', '165', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3312', '165', 'WH', 'Western Highlands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3313', '165', 'WB', 'West New Britain');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3314', '166', 'AG', 'Alto Paraguay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3315', '166', 'AN', 'Alto Parana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3316', '166', 'AM', 'Amambay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3317', '166', 'AS', 'Asuncion');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3318', '166', 'BO', 'Boqueron');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3319', '166', 'CG', 'Caaguazu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3320', '166', 'CZ', 'Caazapa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3321', '166', 'CN', 'Canindeyu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3322', '166', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3323', '166', 'CC', 'Concepcion');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3324', '166', 'CD', 'Cordillera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3325', '166', 'GU', 'Guaira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3326', '166', 'IT', 'Itapua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3327', '166', 'MI', 'Misiones');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3328', '166', 'NE', 'Neembucu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3329', '166', 'PA', 'Paraguari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3330', '166', 'PH', 'Presidente Hayes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3331', '166', 'SP', 'San Pedro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3332', '167', 'AM', 'Amazonas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3333', '167', 'AN', 'Ancash');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3334', '167', 'AP', 'Apurimac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3335', '167', 'AR', 'Arequipa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3336', '167', 'AY', 'Ayacucho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3337', '167', 'CJ', 'Cajamarca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3338', '167', 'CL', 'Callao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3339', '167', 'CU', 'Cusco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3340', '167', 'HV', 'Huancavelica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3341', '167', 'HO', 'Huanuco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3342', '167', 'IC', 'Ica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3343', '167', 'JU', 'Junin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3344', '167', 'LD', 'La Libertad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3345', '167', 'LY', 'Lambayeque');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3346', '167', 'LI', 'Lima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3347', '167', 'LO', 'Loreto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3348', '167', 'MD', 'Madre de Dios');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3349', '167', 'MO', 'Moquegua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3350', '167', 'PA', 'Pasco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3351', '167', 'PI', 'Piura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3352', '167', 'PU', 'Puno');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3353', '167', 'SM', 'San Martin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3354', '167', 'TA', 'Tacna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3355', '167', 'TU', 'Tumbes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3356', '167', 'UC', 'Ucayali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3357', '168', 'ABR', 'Abra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3358', '168', 'ANO', 'Agusan del Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3359', '168', 'ASU', 'Agusan del Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3360', '168', 'AKL', 'Aklan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3361', '168', 'ALB', 'Albay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3362', '168', 'ANT', 'Antique');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3363', '168', 'APY', 'Apayao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3364', '168', 'AUR', 'Aurora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3365', '168', 'BAS', 'Basilan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3366', '168', 'BTA', 'Bataan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3367', '168', 'BTE', 'Batanes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3368', '168', 'BTG', 'Batangas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3369', '168', 'BLR', 'Biliran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3370', '168', 'BEN', 'Benguet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3371', '168', 'BOL', 'Bohol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3372', '168', 'BUK', 'Bukidnon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3373', '168', 'BUL', 'Bulacan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3374', '168', 'CAG', 'Cagayan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3375', '168', 'CNO', 'Camarines Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3376', '168', 'CSU', 'Camarines Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3377', '168', 'CAM', 'Camiguin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3378', '168', 'CAP', 'Capiz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3379', '168', 'CAT', 'Catanduanes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3380', '168', 'CAV', 'Cavite');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3381', '168', 'CEB', 'Cebu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3382', '168', 'CMP', 'Compostela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3383', '168', 'DNO', 'Davao del Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3384', '168', 'DSU', 'Davao del Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3385', '168', 'DOR', 'Davao Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3386', '168', 'ESA', 'Eastern Samar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3387', '168', 'GUI', 'Guimaras');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3388', '168', 'IFU', 'Ifugao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3389', '168', 'INO', 'Ilocos Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3390', '168', 'ISU', 'Ilocos Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3391', '168', 'ILO', 'Iloilo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3392', '168', 'ISA', 'Isabela');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3393', '168', 'KAL', 'Kalinga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3394', '168', 'LAG', 'Laguna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3395', '168', 'LNO', 'Lanao del Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3396', '168', 'LSU', 'Lanao del Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3397', '168', 'UNI', 'La Union');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3398', '168', 'LEY', 'Leyte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3399', '168', 'MAG', 'Maguindanao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3400', '168', 'MRN', 'Marinduque');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3401', '168', 'MSB', 'Masbate');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3402', '168', 'MIC', 'Mindoro Occidental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3403', '168', 'MIR', 'Mindoro Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3404', '168', 'MSC', 'Misamis Occidental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3405', '168', 'MOR', 'Misamis Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3406', '168', 'MOP', 'Mountain');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3407', '168', 'NOC', 'Negros Occidental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3408', '168', 'NOR', 'Negros Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3409', '168', 'NCT', 'North Cotabato');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3410', '168', 'NSM', 'Northern Samar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3411', '168', 'NEC', 'Nueva Ecija');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3412', '168', 'NVZ', 'Nueva Vizcaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3413', '168', 'PLW', 'Palawan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3414', '168', 'PMP', 'Pampanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3415', '168', 'PNG', 'Pangasinan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3416', '168', 'QZN', 'Quezon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3417', '168', 'QRN', 'Quirino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3418', '168', 'RIZ', 'Rizal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3419', '168', 'ROM', 'Romblon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3420', '168', 'SMR', 'Samar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3421', '168', 'SRG', 'Sarangani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3422', '168', 'SQJ', 'Siquijor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3423', '168', 'SRS', 'Sorsogon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3424', '168', 'SCO', 'South Cotabato');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3425', '168', 'SLE', 'Southern Leyte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3426', '168', 'SKU', 'Sultan Kudarat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3427', '168', 'SLU', 'Sulu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3428', '168', 'SNO', 'Surigao del Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3429', '168', 'SSU', 'Surigao del Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3430', '168', 'TAR', 'Tarlac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3431', '168', 'TAW', 'Tawi-Tawi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3432', '168', 'ZBL', 'Zambales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3433', '168', 'ZNO', 'Zamboanga del Norte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3434', '168', 'ZSU', 'Zamboanga del Sur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3435', '168', 'ZSI', 'Zamboanga Sibugay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3436', '198', 'P', 'Saint Pierre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3437', '198', 'M', 'Miquelon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3438', '171', 'AC', 'A&ccedil;ores');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3439', '171', 'AV', 'Aveiro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3440', '171', 'BE', 'Beja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3441', '171', 'BR', 'Braga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3442', '171', 'BA', 'Bragan&ccedil;a');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3443', '171', 'CB', 'Castelo Branco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3444', '171', 'CO', 'Coimbra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3445', '171', 'EV', '&Eacute;vora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3446', '171', 'FA', 'Faro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3447', '171', 'GU', 'Guarda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3448', '171', 'LE', 'Leiria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3449', '171', 'LI', 'Lisboa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3450', '171', 'ME', 'Madeira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3451', '171', 'PO', 'Portalegre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3452', '171', 'PR', 'Porto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3453', '171', 'SA', 'Santar&eacute;m');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3454', '171', 'SE', 'Set&uacute;bal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3455', '171', 'VC', 'Viana do Castelo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3456', '171', 'VR', 'Vila Real');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3457', '171', 'VI', 'Viseu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3458', '173', 'DW', 'Ad Dawhah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3459', '173', 'GW', 'Al Ghuwayriyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3460', '173', 'JM', 'Al Jumayliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3461', '173', 'KR', 'Al Khawr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3462', '173', 'WK', 'Al Wakrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3463', '173', 'RN', 'Ar Rayyan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3464', '173', 'JB', 'Jarayan al Batinah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3465', '173', 'MS', 'Madinat ash Shamal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3466', '173', 'UD', 'Umm Sa\'id');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3467', '173', 'UL', 'Umm Salal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3468', '175', 'AB', 'Alba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3469', '175', 'AR', 'Arad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3470', '175', 'AG', 'Arges');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3471', '175', 'BC', 'Bacau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3472', '175', 'BH', 'Bihor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3473', '175', 'BN', 'Bistrita-Nasaud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3474', '175', 'BT', 'Botosani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3475', '175', 'BV', 'Brasov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3476', '175', 'BR', 'Braila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3477', '175', 'B', 'Bucuresti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3478', '175', 'BZ', 'Buzau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3479', '175', 'CS', 'Caras-Severin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3480', '175', 'CL', 'Calarasi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3481', '175', 'CJ', 'Cluj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3482', '175', 'CT', 'Constanta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3483', '175', 'CV', 'Covasna');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3484', '175', 'DB', 'Dimbovita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3485', '175', 'DJ', 'Dolj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3486', '175', 'GL', 'Galati');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3487', '175', 'GR', 'Giurgiu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3488', '175', 'GJ', 'Gorj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3489', '175', 'HR', 'Harghita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3490', '175', 'HD', 'Hunedoara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3491', '175', 'IL', 'Ialomita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3492', '175', 'IS', 'Iasi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3493', '175', 'IF', 'Ilfov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3494', '175', 'MM', 'Maramures');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3495', '175', 'MH', 'Mehedinti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3496', '175', 'MS', 'Mures');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3497', '175', 'NT', 'Neamt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3498', '175', 'OT', 'Olt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3499', '175', 'PH', 'Prahova');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3500', '175', 'SM', 'Satu-Mare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3501', '175', 'SJ', 'Salaj');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3502', '175', 'SB', 'Sibiu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3503', '175', 'SV', 'Suceava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3504', '175', 'TR', 'Teleorman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3505', '175', 'TM', 'Timis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3506', '175', 'TL', 'Tulcea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3507', '175', 'VS', 'Vaslui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3508', '175', 'VL', 'Valcea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3509', '175', 'VN', 'Vrancea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3510', '176', 'AB', 'Abakan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3511', '176', 'AG', 'Aginskoye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3512', '176', 'AN', 'Anadyr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3513', '176', 'AR', 'Arkahangelsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3514', '176', 'AS', 'Astrakhan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3515', '176', 'BA', 'Barnaul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3516', '176', 'BE', 'Belgorod');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3517', '176', 'BI', 'Birobidzhan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3518', '176', 'BL', 'Blagoveshchensk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3519', '176', 'BR', 'Bryansk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3520', '176', 'CH', 'Cheboksary');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3521', '176', 'CL', 'Chelyabinsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3522', '176', 'CR', 'Cherkessk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3523', '176', 'CI', 'Chita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3524', '176', 'DU', 'Dudinka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3525', '176', 'EL', 'Elista');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3526', '176', 'GO', 'Gomo-Altaysk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3527', '176', 'GA', 'Gorno-Altaysk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3528', '176', 'GR', 'Groznyy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3529', '176', 'IR', 'Irkutsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3530', '176', 'IV', 'Ivanovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3531', '176', 'IZ', 'Izhevsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3532', '176', 'KA', 'Kalinigrad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3533', '176', 'KL', 'Kaluga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3534', '176', 'KS', 'Kasnodar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3535', '176', 'KZ', 'Kazan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3536', '176', 'KE', 'Kemerovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3537', '176', 'KH', 'Khabarovsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3538', '176', 'KM', 'Khanty-Mansiysk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3539', '176', 'KO', 'Kostroma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3540', '176', 'KR', 'Krasnodar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3541', '176', 'KN', 'Krasnoyarsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3542', '176', 'KU', 'Kudymkar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3543', '176', 'KG', 'Kurgan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3544', '176', 'KK', 'Kursk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3545', '176', 'KY', 'Kyzyl');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3546', '176', 'LI', 'Lipetsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3547', '176', 'MA', 'Magadan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3548', '176', 'MK', 'Makhachkala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3549', '176', 'MY', 'Maykop');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3550', '176', 'MO', 'Moscow');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3551', '176', 'MU', 'Murmansk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3552', '176', 'NA', 'Nalchik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3553', '176', 'NR', 'Naryan Mar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3554', '176', 'NZ', 'Nazran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3555', '176', 'NI', 'Nizhniy Novgorod');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3556', '176', 'NO', 'Novgorod');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3557', '176', 'NV', 'Novosibirsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3558', '176', 'OM', 'Omsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3559', '176', 'OR', 'Orel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3560', '176', 'OE', 'Orenburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3561', '176', 'PA', 'Palana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3562', '176', 'PE', 'Penza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3563', '176', 'PR', 'Perm');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3564', '176', 'PK', 'Petropavlovsk-Kamchatskiy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3565', '176', 'PT', 'Petrozavodsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3566', '176', 'PS', 'Pskov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3567', '176', 'RO', 'Rostov-na-Donu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3568', '176', 'RY', 'Ryazan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3569', '176', 'SL', 'Salekhard');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3570', '176', 'SA', 'Samara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3571', '176', 'SR', 'Saransk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3572', '176', 'SV', 'Saratov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3573', '176', 'SM', 'Smolensk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3574', '176', 'SP', 'St. Petersburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3575', '176', 'ST', 'Stavropol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3576', '176', 'SY', 'Syktyvkar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3577', '176', 'TA', 'Tambov');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3578', '176', 'TO', 'Tomsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3579', '176', 'TU', 'Tula');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3580', '176', 'TR', 'Tura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3581', '176', 'TV', 'Tver');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3582', '176', 'TY', 'Tyumen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3583', '176', 'UF', 'Ufa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3584', '176', 'UL', 'Ul\'yanovsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3585', '176', 'UU', 'Ulan-Ude');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3586', '176', 'US', 'Ust\'-Ordynskiy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3587', '176', 'VL', 'Vladikavkaz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3588', '176', 'VA', 'Vladimir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3589', '176', 'VV', 'Vladivostok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3590', '176', 'VG', 'Volgograd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3591', '176', 'VD', 'Vologda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3592', '176', 'VO', 'Voronezh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3593', '176', 'VY', 'Vyatka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3594', '176', 'YA', 'Yakutsk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3595', '176', 'YR', 'Yaroslavl');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3596', '176', 'YE', 'Yekaterinburg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3597', '176', 'YO', 'Yoshkar-Ola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3598', '177', 'BU', 'Butare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3599', '177', 'BY', 'Byumba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3600', '177', 'CY', 'Cyangugu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3601', '177', 'GK', 'Gikongoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3602', '177', 'GS', 'Gisenyi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3603', '177', 'GT', 'Gitarama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3604', '177', 'KG', 'Kibungo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3605', '177', 'KY', 'Kibuye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3606', '177', 'KR', 'Kigali Rurale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3607', '177', 'KV', 'Kigali-ville');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3608', '177', 'RU', 'Ruhengeri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3609', '177', 'UM', 'Umutara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3610', '178', 'CCN', 'Christ Church Nichola Town');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3611', '178', 'SAS', 'Saint Anne Sandy Point');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3612', '178', 'SGB', 'Saint George Basseterre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3613', '178', 'SGG', 'Saint George Gingerland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3614', '178', 'SJW', 'Saint James Windward');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3615', '178', 'SJC', 'Saint John Capesterre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3616', '178', 'SJF', 'Saint John Figtree');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3617', '178', 'SMC', 'Saint Mary Cayon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3618', '178', 'CAP', 'Saint Paul Capesterre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3619', '178', 'CHA', 'Saint Paul Charlestown');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3620', '178', 'SPB', 'Saint Peter Basseterre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3621', '178', 'STL', 'Saint Thomas Lowland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3622', '178', 'STM', 'Saint Thomas Middle Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3623', '178', 'TPP', 'Trinity Palmetto Point');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3624', '179', 'AR', 'Anse-la-Raye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3625', '179', 'CA', 'Castries');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3626', '179', 'CH', 'Choiseul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3627', '179', 'DA', 'Dauphin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3628', '179', 'DE', 'Dennery');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3629', '179', 'GI', 'Gros-Islet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3630', '179', 'LA', 'Laborie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3631', '179', 'MI', 'Micoud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3632', '179', 'PR', 'Praslin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3633', '179', 'SO', 'Soufriere');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3634', '179', 'VF', 'Vieux-Fort');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3635', '180', 'C', 'Charlotte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3636', '180', 'R', 'Grenadines');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3637', '180', 'A', 'Saint Andrew');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3638', '180', 'D', 'Saint David');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3639', '180', 'G', 'Saint George');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3640', '180', 'P', 'Saint Patrick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3641', '181', 'AN', 'A\'ana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3642', '181', 'AI', 'Aiga-i-le-Tai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3643', '181', 'AT', 'Atua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3644', '181', 'FA', 'Fa\'asaleleaga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3645', '181', 'GE', 'Gaga\'emauga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3646', '181', 'GF', 'Gagaifomauga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3647', '181', 'PA', 'Palauli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3648', '181', 'SA', 'Satupa\'itea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3649', '181', 'TU', 'Tuamasaga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3650', '181', 'VF', 'Va\'a-o-Fonoti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3651', '181', 'VS', 'Vaisigano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3652', '182', 'AC', 'Acquaviva');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3653', '182', 'BM', 'Borgo Maggiore');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3654', '182', 'CH', 'Chiesanuova');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3655', '182', 'DO', 'Domagnano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3656', '182', 'FA', 'Faetano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3657', '182', 'FI', 'Fiorentino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3658', '182', 'MO', 'Montegiardino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3659', '182', 'SM', 'Citta di San Marino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3660', '182', 'SE', 'Serravalle');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3661', '183', 'S', 'Sao Tome');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3662', '183', 'P', 'Principe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3663', '184', 'BH', 'Al Bahah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3664', '184', 'HS', 'Al Hudud ash Shamaliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3665', '184', 'JF', 'Al Jawf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3666', '184', 'MD', 'Al Madinah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3667', '184', 'QS', 'Al Qasim');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3668', '184', 'RD', 'Ar Riyad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3669', '184', 'AQ', 'Ash Sharqiyah (Eastern)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3670', '184', 'AS', '\'Asir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3671', '184', 'HL', 'Ha\'il');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3672', '184', 'JZ', 'Jizan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3673', '184', 'ML', 'Makkah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3674', '184', 'NR', 'Najran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3675', '184', 'TB', 'Tabuk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3676', '185', 'DA', 'Dakar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3677', '185', 'DI', 'Diourbel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3678', '185', 'FA', 'Fatick');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3679', '185', 'KA', 'Kaolack');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3680', '185', 'KO', 'Kolda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3681', '185', 'LO', 'Louga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3682', '185', 'MA', 'Matam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3683', '185', 'SL', 'Saint-Louis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3684', '185', 'TA', 'Tambacounda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3685', '185', 'TH', 'Thies ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3686', '185', 'ZI', 'Ziguinchor');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3687', '186', 'AP', 'Anse aux Pins');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3688', '186', 'AB', 'Anse Boileau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3689', '186', 'AE', 'Anse Etoile');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3690', '186', 'AL', 'Anse Louis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3691', '186', 'AR', 'Anse Royale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3692', '186', 'BL', 'Baie Lazare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3693', '186', 'BS', 'Baie Sainte Anne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3694', '186', 'BV', 'Beau Vallon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3695', '186', 'BA', 'Bel Air');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3696', '186', 'BO', 'Bel Ombre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3697', '186', 'CA', 'Cascade');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3698', '186', 'GL', 'Glacis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3699', '186', 'GM', 'Grand\' Anse (on Mahe)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3700', '186', 'GP', 'Grand\' Anse (on Praslin)');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3701', '186', 'DG', 'La Digue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3702', '186', 'RA', 'La Riviere Anglaise');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3703', '186', 'MB', 'Mont Buxton');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3704', '186', 'MF', 'Mont Fleuri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3705', '186', 'PL', 'Plaisance');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3706', '186', 'PR', 'Pointe La Rue');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3707', '186', 'PG', 'Port Glaud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3708', '186', 'SL', 'Saint Louis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3709', '186', 'TA', 'Takamaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3710', '187', 'E', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3711', '187', 'N', 'Northern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3712', '187', 'S', 'Southern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3713', '187', 'W', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3714', '189', 'BA', 'Banskobystricky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3715', '189', 'BR', 'Bratislavsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3716', '189', 'KO', 'Kosicky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3717', '189', 'NI', 'Nitriansky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3718', '189', 'PR', 'Presovsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3719', '189', 'TC', 'Trenciansky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3720', '189', 'TV', 'Trnavsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3721', '189', 'ZI', 'Zilinsky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3722', '191', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3723', '191', 'CH', 'Choiseul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3724', '191', 'GC', 'Guadalcanal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3725', '191', 'HO', 'Honiara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3726', '191', 'IS', 'Isabel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3727', '191', 'MK', 'Makira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3728', '191', 'ML', 'Malaita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3729', '191', 'RB', 'Rennell and Bellona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3730', '191', 'TM', 'Temotu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3731', '191', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3732', '192', 'AW', 'Awdal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3733', '192', 'BK', 'Bakool');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3734', '192', 'BN', 'Banaadir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3735', '192', 'BR', 'Bari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3736', '192', 'BY', 'Bay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3737', '192', 'GA', 'Galguduud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3738', '192', 'GE', 'Gedo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3739', '192', 'HI', 'Hiiraan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3740', '192', 'JD', 'Jubbada Dhexe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3741', '192', 'JH', 'Jubbada Hoose');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3742', '192', 'MU', 'Mudug');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3743', '192', 'NU', 'Nugaal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3744', '192', 'SA', 'Sanaag');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3745', '192', 'SD', 'Shabeellaha Dhexe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3746', '192', 'SH', 'Shabeellaha Hoose');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3747', '192', 'SL', 'Sool');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3748', '192', 'TO', 'Togdheer');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3749', '192', 'WG', 'Woqooyi Galbeed');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3750', '193', 'EC', 'Eastern Cape');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3751', '193', 'FS', 'Free State');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3752', '193', 'GT', 'Gauteng');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3753', '193', 'KN', 'KwaZulu-Natal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3754', '193', 'LP', 'Limpopo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3755', '193', 'MP', 'Mpumalanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3756', '193', 'NW', 'North West');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3757', '193', 'NC', 'Northern Cape');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3758', '193', 'WC', 'Western Cape');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3759', '195', 'CA', 'A Coru&ntilde;a');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3760', '195', 'AL', '&Aacute;lava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3761', '195', 'AB', 'Albacete');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3762', '195', 'AC', 'Alicante');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3763', '195', 'AM', 'Almeria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3764', '195', 'AS', 'Asturias');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3765', '195', 'AV', '&Aacute;vila');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3766', '195', 'BJ', 'Badajoz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3767', '195', 'IB', 'Baleares');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3768', '195', 'BA', 'Barcelona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3769', '195', 'BU', 'Burgos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3770', '195', 'CC', 'C&aacute;ceres');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3771', '195', 'CZ', 'C&aacute;diz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3772', '195', 'CT', 'Cantabria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3773', '195', 'CL', 'Castell&oacute;n');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3774', '195', 'CE', 'Ceuta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3775', '195', 'CR', 'Ciudad Real');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3776', '195', 'CD', 'C&oacute;rdoba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3777', '195', 'CU', 'Cuenca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3778', '195', 'GI', 'Girona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3779', '195', 'GD', 'Granada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3780', '195', 'GJ', 'Guadalajara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3781', '195', 'GP', 'Guip&uacute;zcoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3782', '195', 'HL', 'Huelva');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3783', '195', 'HS', 'Huesca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3784', '195', 'JN', 'Ja&eacute;n');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3785', '195', 'RJ', 'La Rioja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3786', '195', 'PM', 'Las Palmas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3787', '195', 'LE', 'Leon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3788', '195', 'LL', 'Lleida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3789', '195', 'LG', 'Lugo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3790', '195', 'MD', 'Madrid');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3791', '195', 'MA', 'Malaga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3792', '195', 'ML', 'Melilla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3793', '195', 'MU', 'Murcia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3794', '195', 'NV', 'Navarra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3795', '195', 'OU', 'Ourense');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3796', '195', 'PL', 'Palencia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3797', '195', 'PO', 'Pontevedra');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3798', '195', 'SL', 'Salamanca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3799', '195', 'SC', 'Santa Cruz de Tenerife');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3800', '195', 'SG', 'Segovia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3801', '195', 'SV', 'Sevilla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3802', '195', 'SO', 'Soria');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3803', '195', 'TA', 'Tarragona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3804', '195', 'TE', 'Teruel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3805', '195', 'TO', 'Toledo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3806', '195', 'VC', 'Valencia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3807', '195', 'VD', 'Valladolid');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3808', '195', 'VZ', 'Vizcaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3809', '195', 'ZM', 'Zamora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3810', '195', 'ZR', 'Zaragoza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3811', '196', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3812', '196', 'EA', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3813', '196', 'NC', 'North Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3814', '196', 'NO', 'Northern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3815', '196', 'NW', 'North Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3816', '196', 'SA', 'Sabaragamuwa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3817', '196', 'SO', 'Southern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3818', '196', 'UV', 'Uva');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3819', '196', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3820', '197', 'A', 'Ascension');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3821', '197', 'S', 'Saint Helena');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3822', '197', 'T', 'Tristan da Cunha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3823', '199', 'ANL', 'A\'ali an Nil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3824', '199', 'BAM', 'Al Bahr al Ahmar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3825', '199', 'BRT', 'Al Buhayrat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3826', '199', 'JZR', 'Al Jazirah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3827', '199', 'KRT', 'Al Khartum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3828', '199', 'QDR', 'Al Qadarif');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3829', '199', 'WDH', 'Al Wahdah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3830', '199', 'ANB', 'An Nil al Abyad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3831', '199', 'ANZ', 'An Nil al Azraq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3832', '199', 'ASH', 'Ash Shamaliyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3833', '199', 'BJA', 'Bahr al Jabal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3834', '199', 'GIS', 'Gharb al Istiwa\'iyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3835', '199', 'GBG', 'Gharb Bahr al Ghazal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3836', '199', 'GDA', 'Gharb Darfur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3837', '199', 'GKU', 'Gharb Kurdufan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3838', '199', 'JDA', 'Janub Darfur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3839', '199', 'JKU', 'Janub Kurdufan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3840', '199', 'JQL', 'Junqali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3841', '199', 'KSL', 'Kassala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3842', '199', 'NNL', 'Nahr an Nil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3843', '199', 'SBG', 'Shamal Bahr al Ghazal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3844', '199', 'SDA', 'Shamal Darfur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3845', '199', 'SKU', 'Shamal Kurdufan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3846', '199', 'SIS', 'Sharq al Istiwa\'iyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3847', '199', 'SNR', 'Sinnar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3848', '199', 'WRB', 'Warab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3849', '200', 'BR', 'Brokopondo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3850', '200', 'CM', 'Commewijne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3851', '200', 'CR', 'Coronie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3852', '200', 'MA', 'Marowijne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3853', '200', 'NI', 'Nickerie');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3854', '200', 'PA', 'Para');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3855', '200', 'PM', 'Paramaribo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3856', '200', 'SA', 'Saramacca');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3857', '200', 'SI', 'Sipaliwini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3858', '200', 'WA', 'Wanica');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3859', '202', 'H', 'Hhohho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3860', '202', 'L', 'Lubombo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3861', '202', 'M', 'Manzini');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3862', '202', 'S', 'Shishelweni');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3863', '203', 'BL', 'Blekinge');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3864', '203', 'DA', 'Dalama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3865', '203', 'GA', 'Gavleborg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3866', '203', 'GO', 'Gotland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3867', '203', 'HA', 'Halland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3868', '203', 'JA', 'Jamtland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3869', '203', 'JO', 'Jonkping');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3870', '203', 'KA', 'Kalmar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3871', '203', 'KR', 'Kronoberg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3872', '203', 'NO', 'Norrbotten');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3873', '203', 'OR', 'Orebro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3874', '203', 'OG', 'Ostergotland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3875', '203', 'SK', 'Skane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3876', '203', 'SO', 'Sodermanland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3877', '203', 'ST', 'Stockholm');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3878', '203', 'UP', 'Uppdala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3879', '203', 'VL', 'Varmland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3880', '203', 'VB', 'Vasterbotten');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3881', '203', 'VN', 'Vasternorrland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3882', '203', 'VM', 'Vastmanland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3883', '203', 'VG', 'Vastra Gotaland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3884', '204', 'AG', 'Aargau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3885', '204', 'AR', 'Appenzell Ausserrhoden');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3886', '204', 'AI', 'Appenzell Innerrhoden');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3887', '204', 'BS', 'Basel-Stadt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3888', '204', 'BL', 'Basel-Landschaft');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3889', '204', 'BE', 'Bern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3890', '204', 'FR', 'Fribourg');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3891', '204', 'GE', 'Gen&egrave;ve');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3892', '204', 'GL', 'Glarus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3893', '204', 'GR', 'Graubünden');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3894', '204', 'JU', 'Jura');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3895', '204', 'LU', 'Luzern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3896', '204', 'NE', 'Neuchâtel');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3897', '204', 'NW', 'Nidwald');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3898', '204', 'OW', 'Obwald');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3899', '204', 'SG', 'St. Gallen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3900', '204', 'SH', 'Schaffhausen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3901', '204', 'SZ', 'Schwyz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3902', '204', 'SO', 'Solothurn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3903', '204', 'TG', 'Thurgau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3904', '204', 'TI', 'Ticino');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3905', '204', 'UR', 'Uri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3906', '204', 'VS', 'Valais');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3907', '204', 'VD', 'Vaud');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3908', '204', 'ZG', 'Zug');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3909', '204', 'ZH', 'Z&uuml;rich');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3910', '205', 'HA', 'Al Hasakah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3911', '205', 'LA', 'Al Ladhiqiyah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3912', '205', 'QU', 'Al Qunaytirah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3913', '205', 'RQ', 'Ar Raqqah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3914', '205', 'SU', 'As Suwayda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3915', '205', 'DA', 'Dara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3916', '205', 'DZ', 'Dayr az Zawr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3917', '205', 'DI', 'Dimashq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3918', '205', 'HL', 'Halab');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3919', '205', 'HM', 'Hamah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3920', '205', 'HI', 'Hims');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3921', '205', 'ID', 'Idlib');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3922', '205', 'RD', 'Rif Dimashq');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3923', '205', 'TA', 'Tartus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3924', '206', 'CH', 'Chang-hua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3925', '206', 'CI', 'Chia-i');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3926', '206', 'HS', 'Hsin-chu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3927', '206', 'HL', 'Hua-lien');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3928', '206', 'IL', 'I-lan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3929', '206', 'KH', 'Kao-hsiung county');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3930', '206', 'KM', 'Kin-men');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3931', '206', 'LC', 'Lien-chiang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3932', '206', 'ML', 'Miao-li');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3933', '206', 'NT', 'Nan-t\'ou');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3934', '206', 'PH', 'P\'eng-hu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3935', '206', 'PT', 'P\'ing-tung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3936', '206', 'TG', 'T\'ai-chung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3937', '206', 'TA', 'T\'ai-nan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3938', '206', 'TP', 'T\'ai-pei county');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3939', '206', 'TT', 'T\'ai-tung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3940', '206', 'TY', 'T\'ao-yuan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3941', '206', 'YL', 'Yun-lin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3942', '206', 'CC', 'Chia-i city');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3943', '206', 'CL', 'Chi-lung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3944', '206', 'HC', 'Hsin-chu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3945', '206', 'TH', 'T\'ai-chung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3946', '206', 'TN', 'T\'ai-nan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3947', '206', 'KC', 'Kao-hsiung city ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3948', '206', 'TC', 'T\'ai-pei city ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3949', '207', 'GB', 'Gorno-Badakhstan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3950', '207', 'KT', 'Khatlon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3951', '207', 'SU', 'Sughd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3952', '208', 'AR', 'Arusha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3953', '208', 'DS', 'Dar es Salaam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3954', '208', 'DO', 'Dodoma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3955', '208', 'IR', 'Iringa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3956', '208', 'KA', 'Kagera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3957', '208', 'KI', 'Kigoma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3958', '208', 'KJ', 'Kilimanjaro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3959', '208', 'LN', 'Lindi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3960', '208', 'MY', 'Manyara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3961', '208', 'MR', 'Mara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3962', '208', 'MB', 'Mbeya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3963', '208', 'MO', 'Morogoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3964', '208', 'MT', 'Mtwara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3965', '208', 'MW', 'Mwanza');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3966', '208', 'PN', 'Pemba North');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3967', '208', 'PS', 'Pemba South');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3968', '208', 'PW', 'Pwani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3969', '208', 'RK', 'Rukwa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3970', '208', 'RV', 'Ruvuma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3971', '208', 'SH', 'Shinyanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3972', '208', 'SI', 'Singida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3973', '208', 'TB', 'Tabora');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3974', '208', 'TN', 'Tanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3975', '208', 'ZC', 'Zanzibar Central/South');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3976', '208', 'ZN', 'Zanzibar North');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3977', '208', 'ZU', 'Zanzibar Urban/West');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3978', '209', 'Amnat Charoen', 'Amnat Charoen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3979', '209', 'Ang Thong', 'Ang Thong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3980', '209', 'Ayutthaya', 'Ayutthaya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3981', '209', 'Bangkok', 'Bangkok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3982', '209', 'Buriram', 'Buriram');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3983', '209', 'Chachoengsao', 'Chachoengsao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3984', '209', 'Chai Nat', 'Chai Nat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3985', '209', 'Chaiyaphum', 'Chaiyaphum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3986', '209', 'Chanthaburi', 'Chanthaburi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3987', '209', 'Chiang Mai', 'Chiang Mai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3988', '209', 'Chiang Rai', 'Chiang Rai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3989', '209', 'Chon Buri', 'Chon Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3990', '209', 'Chumphon', 'Chumphon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3991', '209', 'Kalasin', 'Kalasin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3992', '209', 'Kamphaeng Phet', 'Kamphaeng Phet');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3993', '209', 'Kanchanaburi', 'Kanchanaburi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3994', '209', 'Khon Kaen', 'Khon Kaen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3995', '209', 'Krabi', 'Krabi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3996', '209', 'Lampang', 'Lampang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3997', '209', 'Lamphun', 'Lamphun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3998', '209', 'Loei', 'Loei');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('3999', '209', 'Lop Buri', 'Lop Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4000', '209', 'Mae Hong Son', 'Mae Hong Son');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4001', '209', 'Maha Sarakham', 'Maha Sarakham');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4002', '209', 'Mukdahan', 'Mukdahan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4003', '209', 'Nakhon Nayok', 'Nakhon Nayok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4004', '209', 'Nakhon Pathom', 'Nakhon Pathom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4005', '209', 'Nakhon Phanom', 'Nakhon Phanom');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4006', '209', 'Nakhon Ratchasima', 'Nakhon Ratchasima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4007', '209', 'Nakhon Sawan', 'Nakhon Sawan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4008', '209', 'Nakhon Si Thammarat', 'Nakhon Si Thammarat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4009', '209', 'Nan', 'Nan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4010', '209', 'Narathiwat', 'Narathiwat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4011', '209', 'Nong Bua Lamphu', 'Nong Bua Lamphu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4012', '209', 'Nong Khai', 'Nong Khai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4013', '209', 'Nonthaburi', 'Nonthaburi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4014', '209', 'Pathum Thani', 'Pathum Thani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4015', '209', 'Pattani', 'Pattani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4016', '209', 'Phangnga', 'Phangnga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4017', '209', 'Phatthalung', 'Phatthalung');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4018', '209', 'Phayao', 'Phayao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4019', '209', 'Phetchabun', 'Phetchabun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4020', '209', 'Phetchaburi', 'Phetchaburi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4021', '209', 'Phichit', 'Phichit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4022', '209', 'Phitsanulok', 'Phitsanulok');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4023', '209', 'Phrae', 'Phrae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4024', '209', 'Phuket', 'Phuket');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4025', '209', 'Prachin Buri', 'Prachin Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4026', '209', 'Prachuap Khiri Khan', 'Prachuap Khiri Khan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4027', '209', 'Ranong', 'Ranong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4028', '209', 'Ratchaburi', 'Ratchaburi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4029', '209', 'Rayong', 'Rayong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4030', '209', 'Roi Et', 'Roi Et');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4031', '209', 'Sa Kaeo', 'Sa Kaeo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4032', '209', 'Sakon Nakhon', 'Sakon Nakhon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4033', '209', 'Samut Prakan', 'Samut Prakan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4034', '209', 'Samut Sakhon', 'Samut Sakhon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4035', '209', 'Samut Songkhram', 'Samut Songkhram');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4036', '209', 'Sara Buri', 'Sara Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4037', '209', 'Satun', 'Satun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4038', '209', 'Sing Buri', 'Sing Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4039', '209', 'Sisaket', 'Sisaket');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4040', '209', 'Songkhla', 'Songkhla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4041', '209', 'Sukhothai', 'Sukhothai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4042', '209', 'Suphan Buri', 'Suphan Buri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4043', '209', 'Surat Thani', 'Surat Thani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4044', '209', 'Surin', 'Surin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4045', '209', 'Tak', 'Tak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4046', '209', 'Trang', 'Trang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4047', '209', 'Trat', 'Trat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4048', '209', 'Ubon Ratchathani', 'Ubon Ratchathani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4049', '209', 'Udon Thani', 'Udon Thani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4050', '209', 'Uthai Thani', 'Uthai Thani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4051', '209', 'Uttaradit', 'Uttaradit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4052', '209', 'Yala', 'Yala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4053', '209', 'Yasothon', 'Yasothon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4054', '210', 'K', 'Kara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4055', '210', 'P', 'Plateaux');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4056', '210', 'S', 'Savanes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4057', '210', 'C', 'Centrale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4058', '210', 'M', 'Maritime');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4059', '211', 'A', 'Atafu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4060', '211', 'F', 'Fakaofo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4061', '211', 'N', 'Nukunonu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4062', '212', 'H', 'Ha\'apai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4063', '212', 'T', 'Tongatapu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4064', '212', 'V', 'Vava\'u');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4065', '213', 'CT', 'Couva/Tabaquite/Talparo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4066', '213', 'DM', 'Diego Martin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4067', '213', 'MR', 'Mayaro/Rio Claro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4068', '213', 'PD', 'Penal/Debe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4069', '213', 'PT', 'Princes Town');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4070', '213', 'SG', 'Sangre Grande');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4071', '213', 'SL', 'San Juan/Laventille');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4072', '213', 'SI', 'Siparia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4073', '213', 'TP', 'Tunapuna/Piarco');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4074', '213', 'PS', 'Port of Spain');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4075', '213', 'SF', 'San Fernando');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4076', '213', 'AR', 'Arima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4077', '213', 'PF', 'Point Fortin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4078', '213', 'CH', 'Chaguanas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4079', '213', 'TO', 'Tobago');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4080', '214', 'AR', 'Ariana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4081', '214', 'BJ', 'Beja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4082', '214', 'BA', 'Ben Arous');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4083', '214', 'BI', 'Bizerte');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4084', '214', 'GB', 'Gabes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4085', '214', 'GF', 'Gafsa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4086', '214', 'JE', 'Jendouba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4087', '214', 'KR', 'Kairouan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4088', '214', 'KS', 'Kasserine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4089', '214', 'KB', 'Kebili');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4090', '214', 'KF', 'Kef');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4091', '214', 'MH', 'Mahdia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4092', '214', 'MN', 'Manouba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4093', '214', 'ME', 'Medenine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4094', '214', 'MO', 'Monastir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4095', '214', 'NA', 'Nabeul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4096', '214', 'SF', 'Sfax');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4097', '214', 'SD', 'Sidi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4098', '214', 'SL', 'Siliana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4099', '214', 'SO', 'Sousse');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4100', '214', 'TA', 'Tataouine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4101', '214', 'TO', 'Tozeur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4102', '214', 'TU', 'Tunis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4103', '214', 'ZA', 'Zaghouan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4104', '215', 'ADA', 'Adana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4105', '215', 'ADI', 'Adiyaman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4106', '215', 'AFY', 'Afyonkarahisar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4107', '215', 'AGR', 'Agri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4108', '215', 'AKS', 'Aksaray');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4109', '215', 'AMA', 'Amasya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4110', '215', 'ANK', 'Ankara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4111', '215', 'ANT', 'Antalya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4112', '215', 'ARD', 'Ardahan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4113', '215', 'ART', 'Artvin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4114', '215', 'AYI', 'Aydin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4115', '215', 'BAL', 'Balikesir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4116', '215', 'BAR', 'Bartin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4117', '215', 'BAT', 'Batman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4118', '215', 'BAY', 'Bayburt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4119', '215', 'BIL', 'Bilecik');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4120', '215', 'BIN', 'Bingol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4121', '215', 'BIT', 'Bitlis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4122', '215', 'BOL', 'Bolu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4123', '215', 'BRD', 'Burdur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4124', '215', 'BRS', 'Bursa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4125', '215', 'CKL', 'Canakkale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4126', '215', 'CKR', 'Cankiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4127', '215', 'COR', 'Corum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4128', '215', 'DEN', 'Denizli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4129', '215', 'DIY', 'Diyarbakir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4130', '215', 'DUZ', 'Duzce');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4131', '215', 'EDI', 'Edirne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4132', '215', 'ELA', 'Elazig');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4133', '215', 'EZC', 'Erzincan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4134', '215', 'EZR', 'Erzurum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4135', '215', 'ESK', 'Eskisehir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4136', '215', 'GAZ', 'Gaziantep');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4137', '215', 'GIR', 'Giresun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4138', '215', 'GMS', 'Gumushane');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4139', '215', 'HKR', 'Hakkari');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4140', '215', 'HTY', 'Hatay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4141', '215', 'IGD', 'Igdir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4142', '215', 'ISP', 'Isparta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4143', '215', 'IST', 'Istanbul');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4144', '215', 'IZM', 'Izmir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4145', '215', 'KAH', 'Kahramanmaras');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4146', '215', 'KRB', 'Karabuk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4147', '215', 'KRM', 'Karaman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4148', '215', 'KRS', 'Kars');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4149', '215', 'KAS', 'Kastamonu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4150', '215', 'KAY', 'Kayseri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4151', '215', 'KLS', 'Kilis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4152', '215', 'KRK', 'Kirikkale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4153', '215', 'KLR', 'Kirklareli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4154', '215', 'KRH', 'Kirsehir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4155', '215', 'KOC', 'Kocaeli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4156', '215', 'KON', 'Konya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4157', '215', 'KUT', 'Kutahya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4158', '215', 'MAL', 'Malatya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4159', '215', 'MAN', 'Manisa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4160', '215', 'MAR', 'Mardin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4161', '215', 'MER', 'Mersin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4162', '215', 'MUG', 'Mugla');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4163', '215', 'MUS', 'Mus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4164', '215', 'NEV', 'Nevsehir');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4165', '215', 'NIG', 'Nigde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4166', '215', 'ORD', 'Ordu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4167', '215', 'OSM', 'Osmaniye');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4168', '215', 'RIZ', 'Rize');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4169', '215', 'SAK', 'Sakarya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4170', '215', 'SAM', 'Samsun');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4171', '215', 'SAN', 'Sanliurfa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4172', '215', 'SII', 'Siirt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4173', '215', 'SIN', 'Sinop');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4174', '215', 'SIR', 'Sirnak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4175', '215', 'SIV', 'Sivas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4176', '215', 'TEL', 'Tekirdag');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4177', '215', 'TOK', 'Tokat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4178', '215', 'TRA', 'Trabzon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4179', '215', 'TUN', 'Tunceli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4180', '215', 'USK', 'Usak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4181', '215', 'VAN', 'Van');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4182', '215', 'YAL', 'Yalova');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4183', '215', 'YOZ', 'Yozgat');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4184', '215', 'ZON', 'Zonguldak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4185', '216', 'A', 'Ahal Welayaty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4186', '216', 'B', 'Balkan Welayaty ');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4187', '216', 'D', 'Dashhowuz Welayaty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4188', '216', 'L', 'Lebap Welayaty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4189', '216', 'M', 'Mary Welayaty');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4190', '217', 'AC', 'Ambergris Cays');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4191', '217', 'DC', 'Dellis Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4192', '217', 'FC', 'French Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4193', '217', 'LW', 'Little Water Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4194', '217', 'RC', 'Parrot Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4195', '217', 'PN', 'Pine Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4196', '217', 'SL', 'Salt Cay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4197', '217', 'GT', 'Grand Turk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4198', '217', 'SC', 'South Caicos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4199', '217', 'EC', 'East Caicos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4200', '217', 'MC', 'Middle Caicos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4201', '217', 'NC', 'North Caicos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4202', '217', 'PR', 'Providenciales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4203', '217', 'WC', 'West Caicos');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4204', '218', 'NMG', 'Nanumanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4205', '218', 'NLK', 'Niulakita');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4206', '218', 'NTO', 'Niutao');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4207', '218', 'FUN', 'Funafuti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4208', '218', 'NME', 'Nanumea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4209', '218', 'NUI', 'Nui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4210', '218', 'NFT', 'Nukufetau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4211', '218', 'NLL', 'Nukulaelae');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4212', '218', 'VAI', 'Vaitupu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4213', '219', 'KAL', 'Kalangala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4214', '219', 'KMP', 'Kampala');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4215', '219', 'KAY', 'Kayunga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4216', '219', 'KIB', 'Kiboga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4217', '219', 'LUW', 'Luwero');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4218', '219', 'MAS', 'Masaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4219', '219', 'MPI', 'Mpigi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4220', '219', 'MUB', 'Mubende');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4221', '219', 'MUK', 'Mukono');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4222', '219', 'NKS', 'Nakasongola');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4223', '219', 'RAK', 'Rakai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4224', '219', 'SEM', 'Sembabule');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4225', '219', 'WAK', 'Wakiso');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4226', '219', 'BUG', 'Bugiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4227', '219', 'BUS', 'Busia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4228', '219', 'IGA', 'Iganga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4229', '219', 'JIN', 'Jinja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4230', '219', 'KAB', 'Kaberamaido');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4231', '219', 'KML', 'Kamuli');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4232', '219', 'KPC', 'Kapchorwa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4233', '219', 'KTK', 'Katakwi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4234', '219', 'KUM', 'Kumi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4235', '219', 'MAY', 'Mayuge');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4236', '219', 'MBA', 'Mbale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4237', '219', 'PAL', 'Pallisa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4238', '219', 'SIR', 'Sironko');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4239', '219', 'SOR', 'Soroti');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4240', '219', 'TOR', 'Tororo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4241', '219', 'ADJ', 'Adjumani');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4242', '219', 'APC', 'Apac');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4243', '219', 'ARU', 'Arua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4244', '219', 'GUL', 'Gulu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4245', '219', 'KIT', 'Kitgum');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4246', '219', 'KOT', 'Kotido');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4247', '219', 'LIR', 'Lira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4248', '219', 'MRT', 'Moroto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4249', '219', 'MOY', 'Moyo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4250', '219', 'NAK', 'Nakapiripirit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4251', '219', 'NEB', 'Nebbi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4252', '219', 'PAD', 'Pader');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4253', '219', 'YUM', 'Yumbe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4254', '219', 'BUN', 'Bundibugyo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4255', '219', 'BSH', 'Bushenyi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4256', '219', 'HOI', 'Hoima');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4257', '219', 'KBL', 'Kabale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4258', '219', 'KAR', 'Kabarole');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4259', '219', 'KAM', 'Kamwenge');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4260', '219', 'KAN', 'Kanungu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4261', '219', 'KAS', 'Kasese');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4262', '219', 'KBA', 'Kibaale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4263', '219', 'KIS', 'Kisoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4264', '219', 'KYE', 'Kyenjojo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4265', '219', 'MSN', 'Masindi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4266', '219', 'MBR', 'Mbarara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4267', '219', 'NTU', 'Ntungamo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4268', '219', 'RUK', 'Rukungiri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4269', '220', 'CK', 'Cherkasy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4270', '220', 'CH', 'Chernihiv');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4271', '220', 'CV', 'Chernivtsi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4272', '220', 'CR', 'Crimea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4273', '220', 'DN', 'Dnipropetrovs\'k');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4274', '220', 'DO', 'Donets\'k');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4275', '220', 'IV', 'Ivano-Frankivs\'k');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4276', '220', 'KL', 'Kharkiv Kherson');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4277', '220', 'KM', 'Khmel\'nyts\'kyy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4278', '220', 'KR', 'Kirovohrad');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4279', '220', 'KV', 'Kiev');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4280', '220', 'KY', 'Kyyiv');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4281', '220', 'LU', 'Luhans\'k');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4282', '220', 'LV', 'L\'viv');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4283', '220', 'MY', 'Mykolayiv');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4284', '220', 'OD', 'Odesa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4285', '220', 'PO', 'Poltava');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4286', '220', 'RI', 'Rivne');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4287', '220', 'SE', 'Sevastopol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4288', '220', 'SU', 'Sumy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4289', '220', 'TE', 'Ternopil\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4290', '220', 'VI', 'Vinnytsya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4291', '220', 'VO', 'Volyn\'');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4292', '220', 'ZK', 'Zakarpattya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4293', '220', 'ZA', 'Zaporizhzhya');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4294', '220', 'ZH', 'Zhytomyr');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4295', '221', 'AZ', 'Abu Zaby');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4296', '221', 'AJ', '\'Ajman');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4297', '221', 'FU', 'Al Fujayrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4298', '221', 'SH', 'Ash Shariqah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4299', '221', 'DU', 'Dubayy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4300', '221', 'RK', 'R\'as al Khaymah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4301', '221', 'UQ', 'Umm al Qaywayn');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4302', '222', 'ABN', 'Aberdeen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4303', '222', 'ABNS', 'Aberdeenshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4304', '222', 'ANG', 'Anglesey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4305', '222', 'AGS', 'Angus');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4306', '222', 'ARY', 'Argyll and Bute');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4307', '222', 'BEDS', 'Bedfordshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4308', '222', 'BERKS', 'Berkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4309', '222', 'BLA', 'Blaenau Gwent');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4310', '222', 'BRI', 'Bridgend');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4311', '222', 'BSTL', 'Bristol');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4312', '222', 'BUCKS', 'Buckinghamshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4313', '222', 'CAE', 'Caerphilly');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4314', '222', 'CAMBS', 'Cambridgeshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4315', '222', 'CDF', 'Cardiff');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4316', '222', 'CARM', 'Carmarthenshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4317', '222', 'CDGN', 'Ceredigion');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4318', '222', 'CHES', 'Cheshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4319', '222', 'CLACK', 'Clackmannanshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4320', '222', 'CON', 'Conwy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4321', '222', 'CORN', 'Cornwall');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4322', '222', 'DNBG', 'Denbighshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4323', '222', 'DERBY', 'Derbyshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4324', '222', 'DVN', 'Devon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4325', '222', 'DOR', 'Dorset');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4326', '222', 'DGL', 'Dumfries and Galloway');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4327', '222', 'DUND', 'Dundee');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4328', '222', 'DHM', 'Durham');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4329', '222', 'ARYE', 'East Ayrshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4330', '222', 'DUNBE', 'East Dunbartonshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4331', '222', 'LOTE', 'East Lothian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4332', '222', 'RENE', 'East Renfrewshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4333', '222', 'ERYS', 'East Riding of Yorkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4334', '222', 'SXE', 'East Sussex');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4335', '222', 'EDIN', 'Edinburgh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4336', '222', 'ESX', 'Essex');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4337', '222', 'FALK', 'Falkirk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4338', '222', 'FFE', 'Fife');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4339', '222', 'FLINT', 'Flintshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4340', '222', 'GLAS', 'Glasgow');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4341', '222', 'GLOS', 'Gloucestershire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4342', '222', 'LDN', 'Greater London');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4343', '222', 'MCH', 'Greater Manchester');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4344', '222', 'GDD', 'Gwynedd');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4345', '222', 'HANTS', 'Hampshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4346', '222', 'HWR', 'Herefordshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4347', '222', 'HERTS', 'Hertfordshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4348', '222', 'HLD', 'Highlands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4349', '222', 'IVER', 'Inverclyde');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4350', '222', 'IOW', 'Isle of Wight');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4351', '222', 'KNT', 'Kent');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4352', '222', 'LANCS', 'Lancashire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4353', '222', 'LEICS', 'Leicestershire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4354', '222', 'LINCS', 'Lincolnshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4355', '222', 'MSY', 'Merseyside');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4356', '222', 'MERT', 'Merthyr Tydfil');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4357', '222', 'MLOT', 'Midlothian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4358', '222', 'MMOUTH', 'Monmouthshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4359', '222', 'MORAY', 'Moray');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4360', '222', 'NPRTAL', 'Neath Port Talbot');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4361', '222', 'NEWPT', 'Newport');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4362', '222', 'NOR', 'Norfolk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4363', '222', 'ARYN', 'North Ayrshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4364', '222', 'LANN', 'North Lanarkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4365', '222', 'YSN', 'North Yorkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4366', '222', 'NHM', 'Northamptonshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4367', '222', 'NLD', 'Northumberland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4368', '222', 'NOT', 'Nottinghamshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4369', '222', 'ORK', 'Orkney Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4370', '222', 'OFE', 'Oxfordshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4371', '222', 'PEM', 'Pembrokeshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4372', '222', 'PERTH', 'Perth and Kinross');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4373', '222', 'PWS', 'Powys');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4374', '222', 'REN', 'Renfrewshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4375', '222', 'RHON', 'Rhondda Cynon Taff');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4376', '222', 'RUT', 'Rutland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4377', '222', 'BOR', 'Scottish Borders');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4378', '222', 'SHET', 'Shetland Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4379', '222', 'SPE', 'Shropshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4380', '222', 'SOM', 'Somerset');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4381', '222', 'ARYS', 'South Ayrshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4382', '222', 'LANS', 'South Lanarkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4383', '222', 'YSS', 'South Yorkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4384', '222', 'SFD', 'Staffordshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4385', '222', 'STIR', 'Stirling');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4386', '222', 'SFK', 'Suffolk');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4387', '222', 'SRY', 'Surrey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4388', '222', 'SWAN', 'Swansea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4389', '222', 'TORF', 'Torfaen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4390', '222', 'TWR', 'Tyne and Wear');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4391', '222', 'VGLAM', 'Vale of Glamorgan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4392', '222', 'WARKS', 'Warwickshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4393', '222', 'WDUN', 'West Dunbartonshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4394', '222', 'WLOT', 'West Lothian');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4395', '222', 'WMD', 'West Midlands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4396', '222', 'SXW', 'West Sussex');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4397', '222', 'YSW', 'West Yorkshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4398', '222', 'WIL', 'Western Isles');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4399', '222', 'WLT', 'Wiltshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4400', '222', 'WORCS', 'Worcestershire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4401', '222', 'WRX', 'Wrexham');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4402', '223', 'AL', 'Alabama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4403', '223', 'AK', 'Alaska');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4404', '223', 'AS', 'American Samoa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4405', '223', 'AZ', 'Arizona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4406', '223', 'AR', 'Arkansas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4407', '223', 'AF', 'Armed Forces Africa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4408', '223', 'AA', 'Armed Forces Americas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4409', '223', 'AC', 'Armed Forces Canada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4410', '223', 'AE', 'Armed Forces Europe');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4411', '223', 'AM', 'Armed Forces Middle East');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4412', '223', 'AP', 'Armed Forces Pacific');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4413', '223', 'CA', 'California');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4414', '223', 'CO', 'Colorado');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4415', '223', 'CT', 'Connecticut');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4416', '223', 'DE', 'Delaware');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4417', '223', 'DC', 'District of Columbia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4418', '223', 'FM', 'Federated States Of Micronesia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4419', '223', 'FL', 'Florida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4420', '223', 'GA', 'Georgia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4421', '223', 'GU', 'Guam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4422', '223', 'HI', 'Hawaii');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4423', '223', 'ID', 'Idaho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4424', '223', 'IL', 'Illinois');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4425', '223', 'IN', 'Indiana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4426', '223', 'IA', 'Iowa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4427', '223', 'KS', 'Kansas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4428', '223', 'KY', 'Kentucky');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4429', '223', 'LA', 'Louisiana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4430', '223', 'ME', 'Maine');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4431', '223', 'MH', 'Marshall Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4432', '223', 'MD', 'Maryland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4433', '223', 'MA', 'Massachusetts');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4434', '223', 'MI', 'Michigan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4435', '223', 'MN', 'Minnesota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4436', '223', 'MS', 'Mississippi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4437', '223', 'MO', 'Missouri');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4438', '223', 'MT', 'Montana');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4439', '223', 'NE', 'Nebraska');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4440', '223', 'NV', 'Nevada');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4441', '223', 'NH', 'New Hampshire');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4442', '223', 'NJ', 'New Jersey');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4443', '223', 'NM', 'New Mexico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4444', '223', 'NY', 'New York');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4445', '223', 'NC', 'North Carolina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4446', '223', 'ND', 'North Dakota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4447', '223', 'MP', 'Northern Mariana Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4448', '223', 'OH', 'Ohio');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4449', '223', 'OK', 'Oklahoma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4450', '223', 'OR', 'Oregon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4451', '223', 'PW', 'Palau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4452', '223', 'PA', 'Pennsylvania');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4453', '223', 'PR', 'Puerto Rico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4454', '223', 'RI', 'Rhode Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4455', '223', 'SC', 'South Carolina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4456', '223', 'SD', 'South Dakota');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4457', '223', 'TN', 'Tennessee');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4458', '223', 'TX', 'Texas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4459', '223', 'UT', 'Utah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4460', '223', 'VT', 'Vermont');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4461', '223', 'VI', 'Virgin Islands');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4462', '223', 'VA', 'Virginia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4463', '223', 'WA', 'Washington');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4464', '223', 'WV', 'West Virginia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4465', '223', 'WI', 'Wisconsin');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4466', '223', 'WY', 'Wyoming');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4467', '224', 'BI', 'Baker Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4468', '224', 'HI', 'Howland Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4469', '224', 'JI', 'Jarvis Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4470', '224', 'JA', 'Johnston Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4471', '224', 'KR', 'Kingman Reef');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4472', '224', 'MA', 'Midway Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4473', '224', 'NI', 'Navassa Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4474', '224', 'PA', 'Palmyra Atoll');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4475', '224', 'WI', 'Wake Island');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4476', '225', 'AR', 'Artigas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4477', '225', 'CA', 'Canelones');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4478', '225', 'CL', 'Cerro Largo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4479', '225', 'CO', 'Colonia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4480', '225', 'DU', 'Durazno');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4481', '225', 'FS', 'Flores');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4482', '225', 'FA', 'Florida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4483', '225', 'LA', 'Lavalleja');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4484', '225', 'MA', 'Maldonado');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4485', '225', 'MO', 'Montevideo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4486', '225', 'PA', 'Paysandu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4487', '225', 'RN', 'Rio Negro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4488', '225', 'RV', 'Rivera');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4489', '225', 'RO', 'Rocha');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4490', '225', 'SL', 'Salto');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4491', '225', 'SJ', 'San Jose');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4492', '225', 'SO', 'Soriano');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4493', '225', 'TA', 'Tacuarembo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4494', '225', 'TT', 'Treinta y Tres');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4495', '226', 'AN', 'Andijon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4496', '226', 'BU', 'Buxoro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4497', '226', 'FA', 'Farg\'ona');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4498', '226', 'JI', 'Jizzax');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4499', '226', 'NG', 'Namangan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4500', '226', 'NW', 'Navoiy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4501', '226', 'QA', 'Qashqadaryo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4502', '226', 'QR', 'Qoraqalpog\'iston Republikasi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4503', '226', 'SA', 'Samarqand');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4504', '226', 'SI', 'Sirdaryo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4505', '226', 'SU', 'Surxondaryo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4506', '226', 'TK', 'Toshkent City');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4507', '226', 'TO', 'Toshkent Region');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4508', '226', 'XO', 'Xorazm');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4509', '227', 'MA', 'Malampa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4510', '227', 'PE', 'Penama');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4511', '227', 'SA', 'Sanma');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4512', '227', 'SH', 'Shefa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4513', '227', 'TA', 'Tafea');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4514', '227', 'TO', 'Torba');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4515', '229', 'AM', 'Amazonas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4516', '229', 'AN', 'Anzoategui');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4517', '229', 'AP', 'Apure');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4518', '229', 'AR', 'Aragua');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4519', '229', 'BA', 'Barinas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4520', '229', 'BO', 'Bolivar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4521', '229', 'CA', 'Carabobo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4522', '229', 'CO', 'Cojedes');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4523', '229', 'DA', 'Delta Amacuro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4524', '229', 'DF', 'Dependencias Federales');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4525', '229', 'DI', 'Distrito Federal');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4526', '229', 'FA', 'Falcon');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4527', '229', 'GU', 'Guarico');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4528', '229', 'LA', 'Lara');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4529', '229', 'ME', 'Merida');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4530', '229', 'MI', 'Miranda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4531', '229', 'MO', 'Monagas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4532', '229', 'NE', 'Nueva Esparta');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4533', '229', 'PO', 'Portuguesa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4534', '229', 'SU', 'Sucre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4535', '229', 'TA', 'Tachira');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4536', '229', 'TR', 'Trujillo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4537', '229', 'VA', 'Vargas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4538', '229', 'YA', 'Yaracuy');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4539', '229', 'ZU', 'Zulia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4540', '230', 'AG', 'An Giang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4541', '230', 'BG', 'Bac Giang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4542', '230', 'BK', 'Bac Kan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4543', '230', 'BL', 'Bac Lieu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4544', '230', 'BC', 'Bac Ninh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4545', '230', 'BR', 'Ba Ria-Vung Tau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4546', '230', 'BN', 'Ben Tre');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4547', '230', 'BH', 'Binh Dinh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4548', '230', 'BU', 'Binh Duong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4549', '230', 'BP', 'Binh Phuoc');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4550', '230', 'BT', 'Binh Thuan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4551', '230', 'CM', 'Ca Mau');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4552', '230', 'CT', 'Can Tho');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4553', '230', 'CB', 'Cao Bang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4554', '230', 'DL', 'Dak Lak');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4555', '230', 'DG', 'Dak Nong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4556', '230', 'DN', 'Da Nang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4557', '230', 'DB', 'Dien Bien');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4558', '230', 'DI', 'Dong Nai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4559', '230', 'DT', 'Dong Thap');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4560', '230', 'GL', 'Gia Lai');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4561', '230', 'HG', 'Ha Giang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4562', '230', 'HD', 'Hai Duong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4563', '230', 'HP', 'Hai Phong');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4564', '230', 'HM', 'Ha Nam');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4565', '230', 'HI', 'Ha Noi');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4566', '230', 'HT', 'Ha Tay');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4567', '230', 'HH', 'Ha Tinh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4568', '230', 'HB', 'Hoa Binh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4569', '230', 'HC', 'Ho Chin Minh');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4570', '230', 'HU', 'Hau Giang');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4571', '230', 'HY', 'Hung Yen');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4572', '232', 'C', 'Saint Croix');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4573', '232', 'J', 'Saint John');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4574', '232', 'T', 'Saint Thomas');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4575', '233', 'A', 'Alo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4576', '233', 'S', 'Sigave');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4577', '233', 'W', 'Wallis');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4578', '235', 'AB', 'Abyan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4579', '235', 'AD', 'Adan');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4580', '235', 'AM', 'Amran');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4581', '235', 'BA', 'Al Bayda');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4582', '235', 'DA', 'Ad Dali');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4583', '235', 'DH', 'Dhamar');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4584', '235', 'HD', 'Hadramawt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4585', '235', 'HJ', 'Hajjah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4586', '235', 'HU', 'Al Hudaydah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4587', '235', 'IB', 'Ibb');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4588', '235', 'JA', 'Al Jawf');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4589', '235', 'LA', 'Lahij');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4590', '235', 'MA', 'Ma\'rib');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4591', '235', 'MR', 'Al Mahrah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4592', '235', 'MW', 'Al Mahwit');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4593', '235', 'SD', 'Sa\'dah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4594', '235', 'SN', 'San\'a');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4595', '235', 'SH', 'Shabwah');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4596', '235', 'TA', 'Ta\'izz');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4597', '236', 'KOS', 'Kosovo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4598', '236', 'MON', 'Montenegro');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4599', '236', 'SER', 'Serbia');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4600', '236', 'VOJ', 'Vojvodina');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4601', '237', 'BC', 'Bas-Congo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4602', '237', 'BN', 'Bandundu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4603', '237', 'EQ', 'Equateur');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4604', '237', 'KA', 'Katanga');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4605', '237', 'KE', 'Kasai-Oriental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4606', '237', 'KN', 'Kinshasa');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4607', '237', 'KW', 'Kasai-Occidental');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4608', '237', 'MA', 'Maniema');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4609', '237', 'NK', 'Nord-Kivu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4610', '237', 'OR', 'Orientale');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4611', '237', 'SK', 'Sud-Kivu');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4612', '238', 'CE', 'Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4613', '238', 'CB', 'Copperbelt');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4614', '238', 'EA', 'Eastern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4615', '238', 'LP', 'Luapula');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4616', '238', 'LK', 'Lusaka');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4617', '238', 'NO', 'Northern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4618', '238', 'NW', 'North-Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4619', '238', 'SO', 'Southern');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4620', '238', 'WE', 'Western');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4621', '239', 'BU', 'Bulawayo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4622', '239', 'HA', 'Harare');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4623', '239', 'ML', 'Manicaland');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4624', '239', 'MC', 'Mashonaland Central');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4625', '239', 'ME', 'Mashonaland East');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4626', '239', 'MW', 'Mashonaland West');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4627', '239', 'MV', 'Masvingo');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4628', '239', 'MN', 'Matabeleland North');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4629', '239', 'MS', 'Matabeleland South');
insert into zones (zone_id, zone_country_id, zone_code, zone_name) values ('4630', '239', 'MD', 'Midlands');
drop table if exists zones_to_geo_zones;
create table zones_to_geo_zones (
  association_id int(11) not null auto_increment,
  zone_country_id int(11) not null ,
  zone_id int(11) ,
  geo_zone_id int(11) ,
  last_modified datetime ,
  date_added datetime not null ,
  PRIMARY KEY (association_id),
  KEY geo_zone_id (geo_zone_id),
  KEY zone_country_id (zone_country_id),
  KEY zone_id (zone_id)
);

insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('1', '170', NULL, '1', '2006-08-11 15:23:09', '2006-05-27 18:49:35');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('2', '81', '0', '1', NULL, '2006-08-12 09:21:54');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('3', '14', '0', '1', NULL, '2006-08-13 20:26:18');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('4', '21', '0', '1', NULL, '2006-08-13 20:26:29');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('5', '55', '0', '1', NULL, '2006-08-13 20:26:38');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('6', '56', '0', '1', NULL, '2006-08-13 20:26:52');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('7', '57', '0', '1', NULL, '2006-08-13 20:26:56');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('8', '67', '0', '1', NULL, '2006-08-13 20:27:08');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('9', '72', '0', '1', NULL, '2006-08-13 20:27:15');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('10', '73', '0', '1', NULL, '2006-08-13 20:27:24');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('11', '84', '0', '1', NULL, '2006-08-13 20:27:31');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('12', '195', '0', '1', NULL, '2006-08-13 20:27:46');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('13', '150', '0', '1', NULL, '2006-08-13 20:27:52');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('14', '103', '0', '1', NULL, '2006-08-13 20:28:02');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('15', '123', '0', '1', NULL, '2006-08-13 20:28:08');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('16', '124', '0', '1', NULL, '2006-08-13 20:28:21');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('17', '117', '0', '1', NULL, '2006-08-13 20:28:28');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('18', '132', '0', '1', NULL, '2006-08-13 20:28:41');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('19', '171', '0', '1', NULL, '2006-08-13 20:28:57');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('20', '189', '0', '1', NULL, '2006-08-13 20:29:06');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('21', '190', '0', '1', NULL, '2006-08-13 20:29:15');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('22', '203', '0', '1', NULL, '2006-08-13 20:29:35');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('23', '97', '0', '1', NULL, '2006-08-13 20:29:42');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('24', '222', '0', '1', NULL, '2006-08-13 20:29:54');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('25', '105', '0', '1', NULL, '2006-08-13 20:30:01');
insert into zones_to_geo_zones (association_id, zone_country_id, zone_id, geo_zone_id, last_modified, date_added) values ('27', '170', '0', '3', NULL, '2007-07-13 13:09:12');
