<?php
/*
  $Id: compare_cart.php,v 1.00 2006/12/26 21:14:33 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  oscGold 2.0 by Jacek Krysiak http://www.oscgold.com
*/

class compareCart {
	var $comp_contents, $cartID, $content_type;

	function compareCart() {
		$this->reset();
	}

	function restore_comp_contents() {
		global $customer_id;

		if (!tep_session_is_registered('customer_id')) return false;

		// insert current cart contents in database
		if (is_array($this->comp_contents)) {
			reset($this->comp_contents);
			while (list($products_id, ) = each($this->comp_contents)) {
				$qty = $this->comp_contents[$products_id]['qty'];
				$product_query = tep_db_query("select products_id from " . TABLE_COMPARE_BASKET . " where customers_id = '" . (int)$customer_id . "' and products_id = '" . tep_db_input($products_id) . "'");
				if (!tep_db_num_rows($product_query)) {
					tep_db_query("insert into " . TABLE_COMPARE_BASKET . " (customers_id, products_id, compare_basket_quantity, compare_basket_date_added) values ('" . (int)$customer_id . "', '" . tep_db_input($products_id) . "', '" . $qty . "', '" . date('Ymd') . "')");
				} else {
					tep_db_query("update " . TABLE_COMPARE_BASKET . " set compare_basket_quantity = '" . $qty . "' where customers_id = '" . (int)$customer_id . "' and products_id = '" . tep_db_input($products_id) . "'");
				}
			}
		}

		// reset per-session cart contents, but not the database contents
		$this->reset(false);

		$products_query = tep_db_query("select products_id, compare_basket_quantity from " . TABLE_COMPARE_BASKET . " where customers_id = '" . (int)$customer_id . "'");
		while ($products = tep_db_fetch_array($products_query)) {
			$this->comp_contents[$products['products_id']] = array('qty' => $products['compare_basket_quantity']);
		}

		$this->cleanup();
	}

	function reset($reset_database = false) {
		global $customer_id;

		$this->comp_contents = array();

		if (tep_session_is_registered('customer_id') && ($reset_database == true)) {
			tep_db_query("delete from " . TABLE_COMPARE_BASKET . " where customers_id = '" . (int)$customer_id . "'");
		}

		unset($this->cartID);
		if (tep_session_is_registered('cartID')) tep_session_unregister('cartID');
	}

	function add_comp_cart($products_id, $qty = '1', $attributes = '', $notify = true) {
		global $new_products_id_in_cart, $customer_id;
 
		$products_id_string = tep_get_uprid($products_id, $attributes);
		$products_id = tep_get_prid($products_id_string);
 
		if (is_numeric($products_id) && is_numeric($qty)) {
			$check_product_query = tep_db_query("select products_status from " . TABLE_PRODUCTS . " where products_id = '" . (int)$products_id . "'");
			$check_product = tep_db_fetch_array($check_product_query);
 
			if (($check_product !== false) && ($check_product['products_status'] == '1')) {
				if ($notify == true) {
					$new_products_id_in_cart = $products_id;
					tep_session_register('new_products_id_in_cart');
				}
 
				if ($this->in_cart($products_id_string)) {
					//jezeli produkt juz jest w koszyku - nic nie robi
				} else {
					$this->comp_contents[$products_id_string] = array('qty' => $qty);
					// insert into database
					if (tep_session_is_registered('customer_id')) tep_db_query("insert into " . TABLE_COMPARE_BASKET . " (customers_id, products_id, compare_basket_quantity, compare_basket_date_added) values ('" . (int)$customer_id . "', '" . tep_db_input($products_id_string) . "', '" . (int)$qty . "', '" . date('Ymd') . "')");
				}
 
				$this->cleanup();
 
				// assign a temporary unique ID to the order contents to prevent hack attempts during the checkout procedure
				$this->cartID = $this->generate_cart_id();
			}
		}
	}

	function cleanup() {
		global $customer_id;

		reset($this->comp_contents);
		while (list($key,) = each($this->comp_contents)) {
			if ($this->comp_contents[$key]['qty'] < 1) {
				unset($this->comp_contents[$key]);
				// remove from database
				if (tep_session_is_registered('customer_id')) {
					tep_db_query("delete from " . TABLE_COMPARE_BASKET . " where customers_id = '" . (int)$customer_id . "' and products_id = '" . tep_db_input($key) . "'");
				}
			}
		}
	}

	function count_comp_contents() {  // get total number of items in cart 
		$total_items = 0;
		if (is_array($this->comp_contents)) {
			reset($this->comp_contents);
			while (list($products_id, ) = each($this->comp_contents)) {
				$total_items += $this->get_comp_quantity($products_id);
			}
		}
		return $total_items;
	}

	function get_comp_quantity($products_id) {
		if (isset($this->comp_contents[$products_id])) {
			return $this->comp_contents[$products_id]['qty'];
		} else {
			return 0;
		}
	}

	function in_cart($products_id) {
		if (isset($this->comp_contents[$products_id])) {
			return true;
		} else {
			return false;
		}
	}

	function remove($products_id) {
		global $customer_id;

		unset($this->comp_contents[$products_id]);
		// remove from database
		if (tep_session_is_registered('customer_id')) {
			tep_db_query("delete from " . TABLE_COMPARE_BASKET . " where customers_id = '" . (int)$customer_id . "' and products_id = '" . tep_db_input($products_id) . "'");
		}

		// assign a temporary unique ID to the order contents to prevent hack attempts during the checkout procedure
		$this->cartID = $this->generate_cart_id();
	}

	function remove_all() {
		$this->reset();
	}

	function get_product_id_list() {
		$product_id_list = '';
		if (is_array($this->comp_contents)) {
			reset($this->comp_contents);
			while (list($products_id, ) = each($this->comp_contents)) {
				$product_id_list .= ', ' . $products_id;
			}
		}
		return substr($product_id_list, 2);
	}


	function get_comp_products() {
		global $languages_id;

		if (!is_array($this->comp_contents)) return false;

		$products_array = array();
		reset($this->comp_contents);
		while (list($products_id, ) = each($this->comp_contents)) {
			$products_query = tep_db_query("select p.products_id, pd.products_name, pd.products_description, p.products_model, p.products_image, p.products_price, p.products_tax_class_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = '" . (int)$products_id . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");
			if ($products = tep_db_fetch_array($products_query)) {
				$prid = $products['products_id'];

				//TotalB2B start
				$products_price = tep_xppp_getproductprice($products['products_id']);
				//TotalB2B end

				//TotalB2B start
				global $customer_id;
				$query_price_to_guest_result = ALLOW_GUEST_TO_SEE_PRICES; 
				if (($query_price_to_guest_result=='true') && !(tep_session_is_registered('customer_id'))) {
					$query_guest_discount_result = GUEST_DISCOUNT;
					$customer_discount = $query_guest_discount_result;
				} elseif (tep_session_is_registered('customer_id')) {
					$query_A = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
					$query_B = tep_db_query("select m.manudiscount_discount from " . TABLE_CUSTOMERS  . " c, " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = c.customers_groups_id  and m.manudiscount_customers_id = 0 and c.customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
					$query_C = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = 0 and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
					if ($query_result = tep_db_fetch_array($query_A)) {
						$customer_discount = $query_result['manudiscount_discount'];
					} else if ($query_result = tep_db_fetch_array($query_B)) {
						$customer_discount = $query_result['manudiscount_discount'];
					} else if ($query_result = tep_db_fetch_array($query_C)) {
						$customer_discount = $query_result['manudiscount_discount'];
					} else {
						$query = tep_db_query("select g.customers_groups_discount from " . TABLE_CUSTOMERS_GROUPS . " g inner join  " . TABLE_CUSTOMERS  . " c on g.customers_groups_id = c.customers_groups_id and c.customers_id = '" . $customer_id . "'");
						$query_result = tep_db_fetch_array($query);
						$customers_groups_discount = $query_result['customers_groups_discount'];
						$query = tep_db_query("select customers_discount from " . TABLE_CUSTOMERS . " where customers_id =  '" . $customer_id . "'");
						$query_result = tep_db_fetch_array($query);
						$customer_discount = $query_result['customers_discount'];
						$customer_discount = $customer_discount + $customers_groups_discount;
					}
				}
				if ($customer_discount >= 0) {
					$products_price = $products_price + $products_price * abs($customer_discount) / 100;
				} else {
					$products_price = $products_price - $products_price * abs($customer_discount) / 100;
				}
				if ($special_price = tep_get_products_special_price($prid)) $products_price = $special_price;
				//TotalB2B end

				$products_array[] = array('id' => $products_id,
                                    'name' => $products['products_name'],
                                    'description' => $products['products_description'],
                                    'model' => $products['products_model'],
                                    'image' => $products['products_image'],
                                    'price' => $products_price,
                                    'quantity' => $this->comp_contents[$products_id]['qty'],
                                    'final_price' => ($products_price),
                                    'tax_class_id' => $products['products_tax_class_id'],
                                    'attributes' => (isset($this->comp_contents[$products_id]['attributes']) ? $this->comp_contents[$products_id]['attributes'] : ''));
			}
		}
		return $products_array;
	}

	function generate_cart_id($length = 5) {
		return tep_create_random_value($length, 'digits');
	}

	function unserialize($broken) {
		for(reset($broken);$kv=each($broken);) {
			$key=$kv['key'];
			if (gettype($this->$key)!="user function")
			$this->$key=$kv['value'];
		}
	}
}
?>