# shopGold
# http://www.shopgold.pl
# Wersja sklepu: 1.4040
#
# Copyright (c) 2017 shopGold
#
# Data archiwum: 05-10-2017

DROP TABLE IF EXISTS `additional_images`;
CREATE TABLE `additional_images` (
  `additional_images_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `images_description` varchar(255) DEFAULT NULL,
  `popup_images` varchar(255) DEFAULT NULL,
  `sort_order` int(5) NOT NULL,
  PRIMARY KEY (`additional_images_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `address_book`;
CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_company` varchar(256) DEFAULT NULL,
  `entry_nip` varchar(32) DEFAULT NULL,
  `entry_regon` varchar(9) NOT NULL,
  `entry_pesel` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  `entry_telephone` varchar(32) NOT NULL,
  PRIMARY KEY (`address_book_id`,`customers_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `address_book` (`address_book_id`, `customers_id`, `entry_company`, `entry_nip`, `entry_regon`, `entry_pesel`, `entry_firstname`, `entry_lastname`, `entry_street_address`, `entry_postcode`, `entry_city`, `entry_country_id`, `entry_zone_id`, `entry_telephone`) VALUES ("1","1","","","","","Jarosław","Bednarski","1 Maja 5","46-053","Chrząstowice","170","8","");

DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_firstname` varchar(32) NOT NULL,
  `admin_lastname` varchar(32) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL,
  `admin_password` varchar(40) NOT NULL,
  `admin_created` datetime DEFAULT NULL,
  `admin_modified` datetime NOT NULL,
  `admin_logdate` datetime DEFAULT NULL,
  `admin_lastlogdate` datetime DEFAULT NULL,
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  `admin_adres_ip` varchar(32) DEFAULT '*.*.*.*',
  `admin_sessionid` char(50) DEFAULT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `idx_admin_email_address` (`admin_email_address`),
  KEY `idx_admin_lastname` (`admin_lastname`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `admin` (`admin_id`, `admin_groups_id`, `admin_firstname`, `admin_lastname`, `admin_email_address`, `admin_password`, `admin_created`, `admin_modified`, `admin_logdate`, `admin_lastlogdate`, `admin_lognum`, `admin_adres_ip`, `admin_sessionid`) VALUES ("1","1","Jarosław","Bednarski","sklep@okdrive.pl","d0e1ee6c97d123e2de159f85195c3ee9:c9","2017-09-14 16:33:22","2017-09-14 16:33:22","2017-10-05 16:19:01","2017-10-05 16:13:34","39","*.*.*.*","vlre6hgc5qq3it3j67s97439q5");

DROP TABLE IF EXISTS `admin_acces`;
CREATE TABLE `admin_acces` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_nazwa` varchar(100) NOT NULL,
  `plik` varchar(100) NOT NULL,
  `nadrzedna` int(3) NOT NULL,
  `sortowanie` int(3) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `ikona` int(1) NOT NULL DEFAULT '0',
  `grupa_id_upraw_1` tinyint(1) NOT NULL DEFAULT '1',
  `grupa_id_upraw_2` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`menu_id`),
  KEY `idx_sortowanie` (`sortowanie`),
  KEY `idx_status` (`status`),
  KEY `idx_plik` (`plik`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8;

INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("1","Konfiguracja","","0","10","1","0","1","0"),
("2","Wygląd","","0","9","1","0","1","0"),
("3","Asortyment","","0","1","1","0","1","0"),
("4","Dane firmy","konfiguracja/konfiguracja.php?typ=firma","160","5","1","0","1","0"),
("5","Ustawienia sklepu","konfiguracja/konfiguracja.php?typ=sklep","1","2","1","0","0","0"),
("6","Ustawienia dla hurtowni","konfiguracja/konfiguracja.php?typ=hurtownia","163","4","1","0","1","0"),
("7","Obrazki - ustawienia ogólne","konfiguracja/konfiguracja.php?typ=obrazki","164","1","1","0","1","0"),
("8","Ustawienia wyglądu","wyglad/wyglad.php","2","1","1","0","1","0"),
("9","Boxy","wyglad/boxy.php","2","2","1","0","1","0"),
("10","Moduły środkowe","wyglad/srodek.php","2","3","1","0","1","0"),
("12","Kategorie","kategorie/kategorie.php","3","1","1","0","1","1"),
("13","Produkty","produkty/produkty.php","3","2","1","0","1","1"),
("14","Cechy produktów","cechy/cechy.php","3","4","1","0","1","1"),
("15","Producenci","producenci/producenci.php","3","5","1","0","1","1"),
("16","Słowniki","","1","4","1","0","1","0"),
("17","Stawki VAT","slowniki/podatek_vat.php","16","1","1","0","1","0"),
("18","Kraje i regiony","slowniki/kraje.php","16","2","1","0","1","0"),
("19","Terminy wysyłek","slowniki/terminy_wysylek.php","16","5","1","0","1","0"),
("20","Dostępności produktów","slowniki/dostepnosci.php","16","6","1","0","1","0"),
("22","Grupy użytkowników","system/grupy.php","78","1","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("24","Dodatkowe pola do produktów","slowniki/dodatkowe_pola.php","171","1","1","0","1","0"),
("25","Języki","slowniki/jezyki.php","16","4","1","0","1","0"),
("26","Waluty","slowniki/waluty.php","16","3","1","0","1","1"),
("27","Grupy klientów","klienci/grupy_klienci.php","91","2","1","0","1","1"),
("28","Dodatkowe pola do klientów","slowniki/dodatkowe_pola_klienci.php","171","3","1","0","1","0"),
("29","Sprzedaż","","0","2","1","0","1","0"),
("30","Klienci","klienci/klienci.php","91","1","1","0","1","1"),
("31","Ustawienia SMS","konfiguracja/konfiguracja.php?typ=sms","162","5","1","0","1","0"),
("32","Ustawienia pól klientów","konfiguracja/konfiguracja.php?typ=klienci","163","7","1","0","1","0"),
("33","Ustawienia magazynu","konfiguracja/konfiguracja.php?typ=magazyn","163","8","1","0","1","0"),
("34","Ustawienia e-mail","konfiguracja/konfiguracja.php?typ=email","162","1","1","0","1","0"),
("35","Statusy zamówień","sprzedaz/zamowienia_statusy.php","90","5","1","0","1","1"),
("36","Tłumaczenia","slowniki/tlumaczenia.php","1","11","1","0","1","1"),
("37","Szablony emaili","slowniki/emaile_szablony.php","16","11","1","0","1","0"),
("38","Jednostki miary","slowniki/jednostki_miary.php","16","10","1","0","1","0"),
("40","Wyłączenie sklepu","konfiguracja/konfiguracja.php?typ=wylaczenie","78","49","1","0","1","0"),
("41","Treści wiadomości email","slowniki/emaile_tresci.php","16","12","1","0","1","0"),
("42","Magazyn produktów","produkty_magazyn/produkty_magazyn.php","3","3","1","0","1","1"),
("43","Zarządzanie zamówieniami","sprzedaz/zamowienia.php","90","1","1","0","1","1"),
("44","Promocje","promocje/promocje.php","3","6","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("46","Nasz hit","nasz_hit/nasz_hit.php","3","7","1","0","1","1"),
("47","Produkty polecane","polecane/polecane.php","3","8","1","0","1","1"),
("49","Produkty podobne","podobne/podobne.php","3","10","1","0","1","1"),
("50","Moduły","","0","12","1","0","1","0"),
("51","Podsumowanie zamówienia","moduly/podsumowanie.php","50","3","1","0","1","1"),
("53","Gratisy","gratisy/gratisy.php","3","12","1","0","1","1"),
("55","Rabaty indywidualne klientów","klienci/rabaty_klientow.php","201","3","1","0","1","0"),
("56","Wysyłki","moduly/wysylka.php","50","1","1","0","1","1"),
("58","Konfiguracja ankiet","konfiguracja/konfiguracja.php?typ=ankiety","240","2","1","0","1","0"),
("59","Formularze","formularze/formularze.php","2","6","1","0","1","0"),
("60","Galerie","galerie/galerie.php","2","7","1","0","1","0"),
("69","Strony informacyjne","","2","8","1","0","1","0"),
("70","Dokumenty PDF","konfiguracja/konfiguracja.php?typ=pdf","164","12","1","0","1","0"),
("72","Zarządzanie aktualnościami","aktualnosci/aktualnosci.php","185","1","1","0","1","0"),
("73","Newsletter","newsletter/newsletter.php","92","1","1","0","1","0"),
("74","Newsletter - subskrybenci","newsletter/newsletter_subskrybenci.php","92","2","1","0","1","0"),
("75","Newsletter - mailing","newsletter/newsletter_mailing.php","92","3","1","0","1","0"),
("76","Ustawienia faktur VAT i paragonów","konfiguracja/konfiguracja.php?typ=faktura","163","13","1","0","1","0"),
("77","Obsługa plików CSV","import_danych/obsluga_csv.php","96","1","1","0","1","1"),
("78","Narzędzia","","0","17","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("79","Allegro","","93","1","1","0","1","1"),
("80","Konfiguracja połączenia z Allegro","allegro/konfiguracja_polaczenia.php","79","1","1","0","1","0"),
("81","Kupony rabatowe","kupony/kupony.php","3","14","1","0","1","1"),
("82","Konfiguracja wystawiania aukcji","allegro/konfiguracja_wystawiania.php","79","2","1","0","1","0"),
("83","Archiwizacja danych","narzedzia/archiwizacja.php","78","12","1","0","1","0"),
("84","Obsługa plików XML","import_danych/obsluga_xml.php","96","2","1","0","1","1"),
("85","Konfiguracja szablonów aukcji","allegro/szablony.php","79","3","1","0","1","0"),
("86","Szablony importu XML","narzedzia/szablony_importu_xml.php","96","3","1","0","1","1"),
("87","Import zewnętrzny XML","import_danych/xml_import_zewnetrzny.php","96","4","1","0","1","1"),
("88","Zarządzanie aukcjami","allegro/allegro_aukcje.php","79","5","1","0","1","0"),
("90","Zamówienia","","29","1","1","0","1","1"),
("91","Klienci","","29","2","1","0","1","1"),
("92","Newsletter","","29","6","1","0","1","0"),
("93","Integracje","","0","14","1","0","1","1"),
("94","Statystyki","","0","15","1","0","1","1"),
("96","Import i eksport danych","","78","2","1","0","1","1"),
("97","Rabaty dla producentów","klienci/rabaty_producentow.php","201","4","1","0","1","0"),
("98","Rabaty dla kategorii","klienci/rabaty_kategorii.php","201","5","1","0","1","0"),
("99","Rabaty dla produktów","klienci/rabaty_produktow.php","201","6","1","0","1","0"),
("101","Ustawienia rabatów i zniżek","konfiguracja/konfiguracja.php?typ=rabaty","163","10","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("102","Reklamacje","","29","4","1","0","1","1"),
("103","Zarządzanie reklamacjami","reklamacje/reklamacje.php","102","1","1","0","1","1"),
("104","Statusy reklamacji","reklamacje/reklamacje_statusy.php","102","2","1","0","1","1"),
("105","Sprzedaż","allegro/allegro_sprzedaz.php","79","6","1","0","1","0"),
("116","Porównywarki","porownywarki/porownywarki.php","93","3","1","0","1","0"),
("118","Import i eksport klientów","import_danych/obsluga_klientow.php","96","6","1","0","1","1"),
("121","Systemy śledzące","integracje/konfiguracja_sledzenie.php","93","5","1","0","1","0"),
("123","Sprzedaż","","94","1","1","0","1","1"),
("124","Klienci","","94","2","1","0","1","1"),
("125","Asortyment","","94","3","1","0","1","1"),
("126","Systemy afiliacyjne","integracje/konfiguracja_afiliacja.php","93","6","1","0","1","0"),
("127","Formy płatności","statystyki/formy_platnosci.php","123","1","1","0","1","1"),
("128","Formy dostawy","statystyki/formy_dostawy.php","123","2","1","0","1","1"),
("129","Wykres sprzedaży","statystyki/wykres_sprzedazy.php","123","3","1","0","1","1"),
("130","Raport sprzedaży produktów dla kategorii","statystyki/raport_kategorii.php","123","4","1","0","1","1"),
("131","Raport sprzedaży produktów w przedziale czasowym","statystyki/raport_okresowy.php","123","5","1","0","1","1"),
("132","Raport sprzedaży produktów wg cech","statystyki/raport_produktow_cechy.php","123","6","1","0","1","1"),
("133","Zamówienia wg typu","statystyki/zamowienia_wg_typu.php","123","7","1","0","1","1"),
("134","Rejestracje klientów","statystyki/rejestracje_klientow.php","124","1","1","0","1","1"),
("135","Klienci wg zamówień","statystyki/klienci_zamowienia.php","124","2","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("136","Wyświetlenia produktów","statystyki/wyswietlenia_produktow.php","125","1","1","0","1","1"),
("137","Najczęściej kupowane produkty","statystyki/najczesciej_kupowane.php","125","2","1","0","1","1"),
("138","Wyszukiwane frazy","statystyki/wyszukiwane_frazy.php","125","5","1","0","1","1"),
("139","Kończące się produkty","statystyki/niskie_stany.php","125","3","1","0","1","1"),
("140","Kończące się cechy produktów","statystyki/niskie_stany_cechy.php","125","4","1","0","1","1"),
("141","Firmy wysyłkowe","","93","9","1","0","1","0"),
("142","Statusy punktów klientów","klienci/punkty_statusy.php","16","8","1","0","1","1"),
("143","Program partnerski","","29","5","1","0","1","0"),
("144","Konfiguracja PP","konfiguracja/konfiguracja.php?typ=program_partnerski","143","3","1","0","1","0"),
("145","Partnerzy","program_partnerski/partnerzy.php","143","1","1","0","1","0"),
("146","Bannery reklamowe","program_partnerski/bannery.php","143","2","1","0","1","0"),
("148","Bannery","","2","10","1","0","1","0"),
("149","Grupy bannerów","wyglad/bannery_grupy.php","148","1","1","0","1","0"),
("150","Zarządzenie bannerami","wyglad/bannery_zarzadzanie.php","148","2","1","0","1","0"),
("151","KurJerzy.pl","integracje/konfiguracja_wysylki_kurjerzy.php","141","4","1","0","1","0"),
("152","Paczkomaty InPost","integracje/konfiguracja_wysylki_inpost.php","141","2","1","0","1","0"),
("153","Przeglądarka plików","narzedzia/przegladarka.php","78","4","1","0","1","0"),
("154","Kurier Siódemka","integracje/konfiguracja_wysylki_siodemka.php","141","3","1","0","1","0"),
("155","Masowa zmiana parametrów produktów","","78","1","1","0","1","1"),
("156","Zmiana cen produktów","narzedzia/masowa_zmiana_cen.php","155","1","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("157","Zmiana statusu produktów","narzedzia/masowa_zmiana_statusu.php","155","2","1","0","1","1"),
("158","Pozycjonowanie","","0","18","1","0","1","1"),
("159","Mapa XML dla Google","pozycjonowanie/mapa_strony.php","158","1","1","0","1","0"),
("160","Dane teleadresowe","","1","1","1","0","1","0"),
("161","Dane kontaktowe","konfiguracja/konfiguracja.php?typ=kontakt","160","6","1","0","1","0"),
("162","Komunikacja","","1","6","1","0","1","0"),
("163","Konfiguracja sklepu","","1","2","1","0","1","0"),
("164","Obrazki i dokumenty","","1","10","1","0","1","0"),
("165","Meta Tagi / Open Graph","","158","2","1","0","1","1"),
("166","Wartości domyślne","pozycjonowanie/meta_tagi_domyslne.php","165","1","1","0","1","1"),
("167","Wartości dla podstron","pozycjonowanie/meta_tagi_podstrony.php","165","1","1","0","1","1"),
("168","Punkty do zatwierdzenia","klienci/punkty_do_zatwierdzenia.php","91","8","1","0","1","1"),
("169","Automatyczne wypełnianie META","pozycjonowanie/meta_tagi_automat.php","165","5","1","0","1","1"),
("171","Dodatkowe pola","","1","5","1","0","1","0"),
("172","Książka nadawcza PP","sprzedaz/zamowienia_ksiazka_nadawcza.php","243","2","1","0","1","1"),
("173","Inwentaryzacja","statystyki/inwentaryzacja.php","125","6","1","0","1","1"),
("174","Etykiety adresowe","sprzedaz/zamowienia_etykiety_adresowe.php","90","4","1","0","1","1"),
("175","Definicje etykiet adresowych","slowniki/etykiety.php","16","9","1","0","1","0"),
("176","DHL - ustawienia do exportu XML","integracje/konfiguracja_wysylki_dhl.php","141","5","1","0","1","0"),
("177","Ustawienia cen","konfiguracja/konfiguracja.php?typ=ceny","163","6","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("178","Obrazki - znak wodny","konfiguracja/konfiguracja.php?typ=watermark","164","2","1","0","1","0"),
("179","Grupy stron informacyjnych","strony_informacyjne/strony_informacyjne_grupy.php","69","1","1","0","1","0"),
("180","Zarządzanie stronami","strony_informacyjne/strony_informacyjne.php","69","2","1","0","1","0"),
("181","Obrazki - ikony na zdjęciach","konfiguracja/konfiguracja.php?typ=ikony","164","2","1","0","1","0"),
("184","Konfiguracja stron","konfiguracja/konfiguracja.php?typ=strony_info","69","3","1","0","1","0"),
("185","Aktualności","","2","9","1","0","1","0"),
("186","Konfiguracja aktualności","konfiguracja/konfiguracja.php?typ=aktualnosci","185","2","1","0","1","0"),
("187","Ustawienia systemu punktów","konfiguracja/konfiguracja.php?typ=punkty","163","9","1","0","1","0"),
("188","Konfiguracja recenzji","konfiguracja/konfiguracja.php?typ=recenzje","238","2","1","0","1","0"),
("189","Ustawienia SSL","konfiguracja/konfiguracja.php?typ=ssl","163","14","1","0","1","0"),
("190","Ustawienia listingu produktów, kategorii i producentów","konfiguracja/konfiguracja.php?typ=listing","163","15","1","0","1","0"),
("191","Ustawienia produktów","konfiguracja/konfiguracja.php?typ=produkt","163","16","1","0","1","0"),
("192","Konfiguracja newslettera","konfiguracja/konfiguracja.php?typ=newsletter","92","5","1","0","1","0"),
("193","Ustawienia bannerów PopUp","konfiguracja/konfiguracja.php?typ=popup","148","3","1","0","1","0"),
("194","Płatności","moduly/platnosc.php","50","2","1","0","1","1"),
("195","Wysuwane zakładki","integracje/konfiguracja_zakladki.php","93","7","1","0","1","1"),
("196","Ustawienia cache i kompresji","konfiguracja/konfiguracja.php?typ=cache","163","17","1","0","1","0"),
("197","Harmonogram zadań","narzedzia/harmonogram.php","78","13","1","0","1","0"),
("198","Moduły stałe","wyglad/srodek_stale.php","2","4","1","0","1","0"),
("199","Grupy klientów newslettera","newsletter/newsletter_grupy.php","92","5","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("200","Przekierowania URL","narzedzia/przekierowania.php","78","14","1","0","1","0"),
("201","Rabaty","","29","3","1","0","1","0"),
("202","Faktury VAT","sprzedaz/zamowienia_faktury.php","29","10","1","0","1","1"),
("203","Kto jest w sklepie ?","narzedzia/klienci_online.php","78","15","1","0","1","1"),
("204","Elektroniczny nadawca PP","integracje/konfiguracja_wysylki_en.php","141","1","1","0","1","0"),
("205","Zestawienie wysyłek EN","sprzedaz/zamowienia_wysylki_zestawienie.php","243","3","1","0","1","1"),
("206","Eksport zamówień do CSV","import_danych/obsluga_zamowien.php","96","7","1","0","1","1"),
("207","SendIt","integracje/konfiguracja_wysylki_sendit.php","141","6","1","0","1","0"),
("208","Dodatkowe pola tekstowe do produktów","slowniki/dodatkowe_pola_tekstowe.php","171","2","1","0","1","1"),
("209","Menadżer produktów","narzedzia/menadzer_produktow.php","155","3","1","0","1","0"),
("210","Ustawienia panelu zarządzania","konfiguracja/konfiguracja.php?typ=panel","163","18","1","0","1","1"),
("211","Raport sprzedaży wybranego produktu w przedziale czasowym","statystyki/raport_okresowy_produktu.php","123","5","1","0","1","1"),
("212","Eksport CSV dla DPD","sprzedaz/zamowienia_eksport_dpd.php","243","6","1","0","1","1"),
("213","Ustawienia sprzedaży elektronicznej","konfiguracja/konfiguracja.php?typ=online","163","17","1","0","1","1"),
("214","Kurier K-EX","integracje/konfiguracja_wysylki_kex.php","141","7","1","0","1","0"),
("215","Konfiguracja eksportu CSV i XML","import_danych/konfiguracja_exportu.php","96","3","1","0","1","1"),
("216","Koszty wysyłek","statystyki/koszty_wysylek.php","123","2","1","0","1","1"),
("217","Stan produktów","slowniki/stan_produktu.php","16","5","1","0","1","0"),
("218","Gwarancje produktów","slowniki/gwarancje.php","16","5","1","0","1","0"),
("219","Dodatkowe pola do zamówień","slowniki/dodatkowe_pola_zamowienia.php","171","4","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("220","Serwis Furgonetka.pl","integracje/konfiguracja_wysylki_furgonetka.php","141","8","1","0","1","1"),
("221","Paragony","sprzedaz/zamowienia_paragony.php","29","11","1","0","1","1"),
("222","Kurier InPost","integracje/konfiguracja_wysylki_kurier_inpost.php","141","9","1","0","1","0"),
("223","Indywidualne ceny produktów dla klientów","klienci/indywidualne_ceny_produktow.php","201","7","1","0","1","1"),
("224","Logowania klientów","statystyki/logowania_klientow.php","124","3","1","0","1","1"),
("229","Opinie o sklepie","","29","5","1","0","1","1"),
("230","Zarządzanie opiniami o sklepie","opinie/opinie.php","229","1","1","0","1","1"),
("231","Konfiguracja opinii o sklepie","konfiguracja/konfiguracja.php?typ=opinie","229","2","1","0","1","1"),
("232","Zarządzanie zamówieniami do kontaktu","sprzedaz/zamowienia_kontakt.php","90","2","1","0","1","1"),
("233","Oferty PDF","oferty/oferty.php","29","12","1","0","1","0"),
("234","Ustawienia podstron sklepu","konfiguracja/konfiguracja.php?typ=podstrony","163","17","1","0","1","1"),
("235","Kurier DPD","integracje/konfiguracja_wysylki_dpd.php","141","10","1","0","1","0"),
("236","Zestawienie wysyłek DPD","sprzedaz/zamowienia_wysylki_dpd.php","243","3","1","0","1","1"),
("237","Konfiguracja wysyłek / płatności","konfiguracja/konfiguracja.php?typ=wysylkiplatnosci","50","5","1","0","1","1"),
("238","Recenzje","","3","5","1","0","1","0"),
("239","Zarządzanie recenzjami","recenzje/recenzje.php","238","1","1","0","1","1"),
("240","Ankiety","","2","5","1","0","1","0"),
("241","Zarządzanie ankietami","ankiety/ankiety.php","240","1","1","0","1","1"),
("242","Paczka w RUCHU","integracje/konfiguracja_wysylki_paczka_w_ruchu.php","141","11","1","0","1","0"),
("243","Zestawienia wysyłek","","29","7","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("244","Zestawienie wysyłek Paczka w RUCHU","sprzedaz/zamowienia_wysylki_ruch.php","243","3","1","0","1","1"),
("245","Powiadomienia o produktach","klienci/klienci_powiadomienia.php","29","6","1","0","1","1"),
("246","Integracje własne","integracje/integracje_wlasne.php","93","8","1","0","1","0"),
("247","Rabaty dla kategorii oraz producenta","klienci/rabaty_kategorii_producenta.php","201","6","1","0","1","1"),
("248","Zestawienie protokołów GLS","sprzedaz/zamowienia_wysylki_gls_protocol.php","243","5","1","0","1","1"),
("249","Kurier GLS","integracje/konfiguracja_wysylki_gls.php","141","12","1","0","1","0"),
("250","Akcesoria dodatkowe","","3","11","1","0","1","1"),
("251","Akcesoria dodatkowe dla produktów","akcesoria_dodatkowe/akcesoria_dodatkowe.php","250","1","1","0","1","1"),
("252","Akcesoria dodatkowe dla kategorii","akcesoria_dodatkowe/akcesoria_dodatkowe_kategorie.php","250","2","1","0","1","1"),
("253","Zestawy produktów","produkty/zestawy_produktow.php","3","3","1","0","1","1"),
("254","Konfiguracja warunków ofert","allegro/konfiguracja_pozakupowa.php","79","3","1","0","1","1");

DROP TABLE IF EXISTS `admin_groups`;
CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(64) DEFAULT NULL,
  `admin_groups_description` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `idx_admin_groups_name` (`admin_groups_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `admin_groups` (`admin_groups_id`, `admin_groups_name`, `admin_groups_description`) VALUES ("1","Administratorzy","Wbudowana grupa administratorów systemu."),
("2","Obsługa sprzedaży","");

DROP TABLE IF EXISTS `allegro_after_sales`;
CREATE TABLE `allegro_after_sales` (
  `document_id` int(10) NOT NULL AUTO_INCREMENT,
  `document_name` varchar(128) DEFAULT NULL,
  `document_uid` varchar(128) DEFAULT NULL,
  `document_type` char(1) NOT NULL DEFAULT '',
  `login` varchar(32) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`document_id`),
  KEY `idx_login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_auctions`;
CREATE TABLE `allegro_auctions` (
  `allegro_id` int(11) NOT NULL AUTO_INCREMENT,
  `auction_id` varchar(24) NOT NULL DEFAULT '',
  `products_id` int(11) NOT NULL,
  `products_name` varchar(64) NOT NULL,
  `products_image` varchar(255) NOT NULL,
  `allegro_category` int(11) DEFAULT NULL,
  `allegro_category_shop` int(11) DEFAULT NULL,
  `allegro_options` varchar(50) DEFAULT NULL,
  `products_quantity` decimal(4,0) NOT NULL DEFAULT '0',
  `products_stock_attributes` varchar(255) DEFAULT NULL,
  `products_date_start` datetime DEFAULT NULL,
  `products_date_end` datetime DEFAULT NULL,
  `allegro_server` varchar(3) NOT NULL,
  `allegro_sandbox` int(1) NOT NULL DEFAULT '1',
  `auction_source` tinyint(1) NOT NULL DEFAULT '1',
  `auction_type` tinyint(1) NOT NULL DEFAULT '0',
  `auction_date_start` datetime DEFAULT NULL,
  `auction_date_end` datetime DEFAULT NULL,
  `auction_price` decimal(15,2) NOT NULL,
  `auction_seller` varchar(64) NOT NULL,
  `auction_quantity` int(4) NOT NULL DEFAULT '1',
  `auction_status` tinyint(4) NOT NULL DEFAULT '1',
  `auction_buy_now` tinyint(4) NOT NULL DEFAULT '1',
  `products_start_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_now_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_min_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_buy_now_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `auction_bids` int(4) NOT NULL DEFAULT '0',
  `auction_hits` int(6) NOT NULL DEFAULT '0',
  `auction_watching` int(6) NOT NULL DEFAULT '0',
  `products_sold` int(4) NOT NULL DEFAULT '0',
  `synchronization` int(1) NOT NULL DEFAULT '1',
  `variants` tinyint(1) NOT NULL DEFAULT '0',
  `archiwum_allegro` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`allegro_id`),
  KEY `idx_auction_id_prod_id` (`auction_id`,`products_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_auctions_sold`;
CREATE TABLE `allegro_auctions_sold` (
  `allegro_auction_id` int(11) NOT NULL AUTO_INCREMENT,
  `auction_id` varchar(24) NOT NULL DEFAULT '',
  `orders_id` int(11) NOT NULL,
  `buyer_id` varchar(24) NOT NULL,
  `buyer_name` varchar(32) NOT NULL,
  `buyer_email_address` varchar(64) DEFAULT NULL,
  `buyer_first_name` varchar(32) NOT NULL,
  `buyer_last_name` varchar(32) NOT NULL,
  `buyer_company` varchar(32) NOT NULL,
  `buyer_street` varchar(32) NOT NULL,
  `buyer_postcode` varchar(32) NOT NULL,
  `buyer_city` varchar(32) NOT NULL,
  `buyer_phone` varchar(32) NOT NULL,
  `buyer_state_id` int(11) NOT NULL,
  `buyer_country` varchar(32) DEFAULT NULL,
  `buyer_shipping_first_name` varchar(32) NOT NULL,
  `buyer_shipping_last_name` varchar(32) NOT NULL,
  `buyer_shipping_company` varchar(32) NOT NULL,
  `buyer_shipping_street` varchar(32) NOT NULL,
  `buyer_shipping_postcode` varchar(32) NOT NULL,
  `buyer_shipping_city` varchar(32) NOT NULL,
  `buyer_shipping_country` varchar(32) DEFAULT NULL,
  `buyer_status` tinyint(1) NOT NULL DEFAULT '0',
  `auction_quantity` tinyint(4) NOT NULL DEFAULT '1',
  `auction_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `auction_buy_date` varchar(32) NOT NULL,
  `auction_status` tinyint(1) NOT NULL DEFAULT '1',
  `auction_lost_date` varchar(32) NOT NULL,
  `auction_lost_status` tinyint(1) NOT NULL DEFAULT '0',
  `auction_lost_text` text,
  `auction_postbuy_forms` tinyint(1) NOT NULL DEFAULT '0',
  `auction_comments` tinyint(1) NOT NULL DEFAULT '0',
  `date_last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`allegro_auction_id`),
  KEY `idx_auction_orders_id` (`auction_id`,`orders_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_buyer_id` (`buyer_id`),
  KEY `idx_auction_id` (`auction_id`),
  KEY `idx_date_end` (`auction_buy_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_categories`;
CREATE TABLE `allegro_categories` (
  `cat_id` int(11) NOT NULL,
  `cat_name` text NOT NULL,
  `cat_parent` int(11) NOT NULL DEFAULT '0',
  `cat_position` int(11) NOT NULL,
  `cat_is_product_catalogue_enabled` int(11) NOT NULL,
  `cat_is_leaf` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `idex_parent_id` (`cat_parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1","Muzyka","0","17","0","0"),
("2","Komputery","0","13","0","0"),
("3","Motoryzacja","0","16","0","0"),
("4","Telefony i Akcesoria","0","25","0","0"),
("5","Dom i Ogród","0","5","0","0"),
("6","Kolekcje","0","12","0","0"),
("7","Książki i Komiksy","0","15","0","0"),
("9","Gry","0","10","0","0"),
("10","RTV i AGD","0","22","0","0"),
("11","Sprzęt audio dla domu","10","9","0","0"),
("12","Pozostałe","709","15","0","1"),
("13","Odtwarzacze CD i MD","11","11","0","0"),
("14","Wzmacniacze i pokrewne","11","16","0","0"),
("15","Magnetofony i nośniki","11","9","0","0"),
("16","Tunery radiowe","11","14","0","0"),
("19","Pozostałe","11","20","0","1"),
("21","Magnetowidy i taśmy","717","3","0","0"),
("24","Kalkulatory","1328","2","0","0"),
("68","Oprogramowanie","2","12","0","0"),
("69","Biurowe","68","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("70","Grafika i edycja video","68","3","0","0"),
("71","Narzędzia","68","7","0","1"),
("72","Internet","68","4","0","1"),
("73","Multimedia","68","5","0","1"),
("74","Edukacyjne","68","2","0","0"),
("75","Pozostałe","68","12","0","0"),
("76","Filatelistyka","6","1","0","0"),
("79","Ameryka Pn i Pd.","76","1","0","0"),
("81","Afryka","76","0","0","1"),
("82","Azja","76","3","0","1"),
("83","Australia i Oceania","76","2","0","1"),
("84","Pozostałe","76","11","0","0"),
("85","Numizmatyka","6","6","0","0"),
("87","Europa","85","5","0","0"),
("89","Ameryka Pn. i Pd.","85","1","0","0"),
("91","Azja","85","4","0","0"),
("92","Afryka","85","0","0","0"),
("93","Australia i Oceania","85","3","0","0"),
("94","Pozostałe","85","18","0","0"),
("118","Czasopisma","7","8","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120","Hobbystyczne","118","9","0","1"),
("121","Muzyka, instrumenty","118","13","0","1"),
("122","Pozostałe","118","24","0","1"),
("123","Wyposażenie","5","5","0","0"),
("126","Pozostałe","1520","17","0","1"),
("128","Pozostałe","123","23","0","1"),
("135","Perfumy i wody","1429","2","0","0"),
("149","Samochody","3","12","0","0"),
("156","Części i akcesoria motocyklowe","3","4","0","0"),
("158","Części motocyklowe","156","3","0","0"),
("159","Odzież","156","5","0","0"),
("165","Telefony komórkowe","4","7","0","0"),
("170","Inne marki","165","37","0","1"),
("175","Płyty kompaktowe","1","0","0","0"),
("181","Soul, Funk","175","26","0","1"),
("182","Reggae, Ska","175","21","0","1"),
("184","Techno, Trance","175","27","0","0"),
("186","Rap, Hip-Hop","175","20","0","0"),
("189","Muzyka filmowa","175","14","0","0"),
("191","Pozostałe","175","30","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("193","Dance","175","4","0","0"),
("194","Kasety audio","1","2","0","0"),
("201","Reggae, Ska","194","13","0","1"),
("205","Rap, Hip-Hop","194","12","0","1"),
("208","Muzyka filmowa","194","10","0","1"),
("209","Klasyka, Opera","194","6","0","1"),
("210","Pozostałe","194","17","0","1"),
("212","Dance","194","2","0","1"),
("234","Pozostałe","135","3","0","1"),
("240","Urządzenia stacjonarne","4","8","0","0"),
("241","Telefony przewodowe","240","5","0","0"),
("242","Faxy","240","2","0","0"),
("245","Pozostałe","240","8","0","1"),
("260","Jazz, Swing","175","9","0","0"),
("261","Jazz, Swing","194","5","0","1"),
("262","Kultura, sztuka","118","12","0","1"),
("263","Podróżnicze","118","15","0","1"),
("269","Pozostałe","1536","45","0","1"),
("279","Płyty winylowe","1","1","0","0"),
("280","Drum\'n\'Bass","279","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("281","Rap, Hip-Hop","279","16","0","0"),
("284","Ambient, Nowe brzmienia","279","0","0","1"),
("286","Klasyka, Opera","279","10","0","1"),
("288","Techno","279","23","0","1"),
("289","Jazz, Swing","279","9","0","1"),
("292","Muzyka filmowa","279","14","0","1"),
("293","Pozostałe","279","25","0","1"),
("315","Pozostałe","1532","21","0","1"),
("316","Pozostałe","6","12","0","0"),
("318","Pozostałe","953","9","0","1"),
("320","Pozostałe","316","19","0","1"),
("325","Składanki","175","25","0","0"),
("332","Wieże","11","15","0","0"),
("337","Odtwarzacze DVD","717","8","0","0"),
("339","Antyczne","85","2","0","0"),
("348","Akcesoria GSM","4","1","0","0"),
("349","Obudowy, panele","348","12","0","0"),
("351","Kable","348","5","0","0"),
("352","Baterie, akumulatory","348","3","0","1"),
("353","Pokrowce, futerały, kabury","348","14","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("354","Zestawy głośnomówiące","348","19","0","1"),
("358","Amplitunery","11","0","0","0"),
("359","Polska do 1864","85","8","0","0"),
("362","Wolne Miasto Gdańsk","85","15","0","1"),
("380","Pieniądz papierowy","6","9","0","0"),
("381","Polska","380","4","0","0"),
("382","Europa","380","3","0","0"),
("383","Bony i notgeldy","380","6","0","0"),
("385","Pozostałe","380","7","0","0"),
("386","Reszta Świata","380","5","0","1"),
("387","Karty telefoniczne","6","2","0","0"),
("392","Pozostałe","387","2","0","1"),
("406","Polska","76","5","0","0"),
("409","Całości i całostki","76","6","0","0"),
("412","Europa","76","4","0","0"),
("414","Tematyczne","76","7","0","0"),
("435","Samsung","165","29","0","0"),
("439","Pozostałe","348","22","0","1"),
("440","Centrale telefoniczne","240","1","0","1"),
("441","Pre-paid","4","4","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("446","Radiokomunikacja","4","5","0","0"),
("451","Akcesoria","76","10","0","0"),
("455","Zestawy słuchawkowe","348","20","0","0"),
("456","Telefony bezprzewodowe","240","4","0","0"),
("457","ISDN","240","3","0","1"),
("486","Komputery stacjonarne","2","6","0","1"),
("491","Laptopy","2","8","0","0"),
("497","Akcesoria (Laptop, PC)","2","0","0","0"),
("505","Inne akcesoria","497","13","0","0"),
("507","Literatura","85","17","0","0"),
("519","Pozostałe","1430","7","0","1"),
("522","Meble","5","1","0","0"),
("527","Pozostałe","522","10","0","1"),
("531","Damskie","1469","1","0","0"),
("532","Męskie","1469","2","0","0"),
("535","Pozostałe","1455","16","0","1"),
("541","Zegary","123","19","0","1"),
("568","Sypialnia","522","5","0","0"),
("589","Ciężarowe (pow. 3.5 t)","149","1","0","0"),
("590","Dostawcze (do 3.5 t)","149","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("594","Zabytkowe","149","4","0","0"),
("620","Części samochodowe","3","5","0","0"),
("622","Wyposażenie wnętrza","620","16","0","0"),
("623","Oświetlenie","620","5","0","0"),
("629","Pozostałe","620","18","0","1"),
("691","Militaria","6","4","0","0"),
("694","Pozostałe","691","12","0","1"),
("698","Korektory graficzne","11","8","0","1"),
("709","Sprzęt car audio","10","11","0","0"),
("712","Radioodtwarzacze","709","9","0","0"),
("714","Wzmacniacze","709","11","0","0"),
("715","Zmieniarki CD","709","12","0","0"),
("717","TV i Video","10","13","0","0"),
("724","Pozostałe","717","18","0","1"),
("727","Zestawy kina domowego","717","15","0","0"),
("745","Biznes, ekonomia","118","0","0","1"),
("746","Plotki, moda, uroda","118","14","0","1"),
("748","Film, telewizja","118","7","0","1"),
("753","Fotografia","118","8","0","1"),
("754","Elektronika, technika","118","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("755","Samochody, motocykle","118","17","0","1"),
("776","Rośliny","1532","18","0","0"),
("778","Gramofony","11","6","0","0"),
("798","Sport, zdrowie, kondycja","118","19","0","1"),
("808","Fantastyka","118","6","0","1"),
("885","Azja","380","2","0","0"),
("886","Ameryka Pn. i Pd.","380","1","0","0"),
("889","Kinder-niespodzianki","316","9","0","1"),
("940","Dokumenty","691","1","0","1"),
("953","Birofilistyka","6","0","0","0"),
("954","Podstawki","953","6","0","0"),
("955","Etykiety","953","1","0","0"),
("956","Kapsle i porcelanki","953","3","0","0"),
("957","Butelki","953","0","0","1"),
("968","Średniowieczne","85","12","0","1"),
("972","Pozostałe","1528","13","0","1"),
("1003","Akcesoria alkoholowe","316","0","0","0"),
("1004","Talary","85","13","0","1"),
("1052","Papiery wartościowe","6","8","0","0"),
("1054","Polska","1052","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1055","Europa","1052","1","0","1"),
("1056","Ameryka Pn.","1052","0","0","1"),
("1057","Weksle, czeki","1052","3","0","1"),
("1058","Pozostałe","1052","7","0","1"),
("1059","Afryka","380","0","0","0"),
("1061","Modelarstwo","6","5","0","0"),
("1062","Szkutnictwo","1061","8","0","0"),
("1063","Kolej, dioramy, makiety","1061","1","0","0"),
("1064","Lotnictwo","1061","2","0","0"),
("1065","Pojazdy wojskowe","1061","6","0","0"),
("1066","Samochody","1061","7","0","0"),
("1067","Literatura","1061","10","0","0"),
("1068","Pozostałe","1061","13","0","1"),
("1082","Akcesoria","85","16","0","0"),
("1084","Zdjęcia","691","10","0","0"),
("1114","Zabytkowe","620","17","0","0"),
("1115","Monety zastępcze","85","7","0","0"),
("1116","Guziki wojskowe","691","2","0","0"),
("1118","Akwarystyka","1528","0","0","0"),
("1120","Anteny i wzmacniacze","348","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1143","Country","175","3","0","1"),
("1144","Ambient, Relaksacja","175","0","0","1"),
("1145","Country","279","3","0","1"),
("1149","Skamieliny, minerały i muszle","316","15","0","0"),
("1272","Modele kartonowe","1061","3","0","0"),
("1273","Plany modelarskie","1061","5","0","0"),
("1291","Zestawy akcesoriów","348","21","0","1"),
("1303","Nagrywarki DVD/HDD","717","6","0","0"),
("1306","Panele i etui","709","5","0","0"),
("1320","Kolumny głośnikowe","11","7","0","0"),
("1322","Głośniki","709","3","0","0"),
("1328","Pozostałe","10","15","0","0"),
("1329","Pozostałe","1328","6","0","1"),
("1333","Akcesoria i części serwisowe","348","0","0","0"),
("1361","Ballada, Poezja śpiewana","175","1","0","1"),
("1362","Blues, Rhythm\'n\'Blues","175","2","0","0"),
("1364","Ethno, Folk, World music","175","7","0","0"),
("1370","Ballada, Poezja śpiewana","194","0","0","1"),
("1371","Blues, Rhythm\'n\'Blues","194","1","0","1"),
("1373","Ethno, Folk, World music","194","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1378","Składanki","194","16","0","1"),
("1410","Ballada, Poezja śpiewana","279","1","0","1"),
("1411","Blues, Rhythm\'n\'Blues","279","2","0","1"),
("1413","Reggae, Ska","279","17","0","1"),
("1419","Składanki","279","21","0","1"),
("1420","Soul, Funk","279","22","0","1"),
("1429","Uroda","0","26","0","0"),
("1430","Pielęgnacja","1429","3","0","0"),
("1431","Golenie i depilacja","1430","2","0","0"),
("1433","Ciało","1430","0","0","0"),
("1434","Dłonie i stopy","1430","1","0","0"),
("1435","Twarz","1430","4","0","0"),
("1436","Włosy","1430","5","0","0"),
("1437","Zestawy kosmetyków","1430","6","0","1"),
("1454","Odzież, Obuwie, Dodatki","0","19","0","0"),
("1455","Odzież męska","1454","3","0","0"),
("1459","Okrycia wierzchnie","1455","9","0","0"),
("1469","Obuwie","1454","4","0","0"),
("1471","Pozostałe","1469","3","0","1"),
("1487","Galanteria i dodatki","1454","5","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1488","Nesesery i aktówki","1487","7","0","1"),
("1489","Paski","1487","12","0","1"),
("1490","Portfele","1487","14","0","1"),
("1491","Torby","1487","20","0","1"),
("1492","Torebki","1487","21","0","0"),
("1493","Rękawiczki","1487","16","0","1"),
("1494","Okulary przeciwsłoneczne","1487","9","0","1"),
("1495","Szaliki i szale","1487","18","0","1"),
("1496","Nakrycia głowy","1487","5","0","0"),
("1497","Pozostałe","1487","24","0","1"),
("1510","Kuchnia","522","1","0","0"),
("1511","Łazienka i toaleta","522","6","0","0"),
("1513","Pracownia","522","2","0","0"),
("1514","Przedpokój","522","3","0","0"),
("1515","Salon","522","4","0","0"),
("1520","Budownictwo i Akcesoria","5","0","0","0"),
("1521","Dachy","1520","0","0","0"),
("1523","Elektryka i akcesoria","1520","3","0","0"),
("1524","Hydraulika i armatura","1520","5","0","0"),
("1525","Kominki i akcesoria","1520","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("1527","Ściany i elewacje","1520","15","0","0"),
("1528","Zwierzęta","5","6","0","0"),
("1530","Żywe zwierzęta","1528","10","0","0"),
("1532","Ogród","5","3","0","0"),
("1534","Narzędzia ogrodnicze","1532","9","0","0"),
("1536","Narzędzia","5","2","0","0"),
("1562","Zestawy","135","2","0","0"),
("1586","Uszkodzone","240","7","0","1"),
("1591","Ozdoby świąteczne i okolicznościowe","123","21","0","0"),
("3504","Polskie","387","0","0","0"),
("3506","Magnetyczne","3504","3","0","1"),
("3508","Chipowe","3504","0","0","1"),
("3510","GSM","3504","1","0","1"),
("3512","Pre paid","3504","4","0","1"),
("3514","Komercyjne","3504","2","0","1"),
("3516","Zagraniczne","387","1","0","0"),
("3518","Magnetyczne","3516","2","0","1"),
("3520","Chipowe","3516","0","0","1"),
("3522","Pre paid","3516","3","0","1"),
("3524","GSM","3516","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3563","Etykiety zapałczane","316","5","0","1"),
("3565","Pozostałe","382","19","0","1"),
("3566","Rosja","382","11","0","1"),
("3567","Niemcy","382","10","0","1"),
("3568","1919 - 1939 złote","381","2","0","1"),
("3569","1966 - 1993","381","5","0","1"),
("3571","Otwieracze do butelek","953","5","0","1"),
("3572","Akcesoria","1066","9","0","1"),
("3580","skala 1:48","1064","3","0","0"),
("3581","skala 1:72","1064","4","0","0"),
("3582","Inne skale","1065","3","0","0"),
("3584","skala 1:35","1065","0","0","0"),
("3585","skala 1:72 i 1:76","1065","2","0","0"),
("3586","Pozostałe","1062","2","0","1"),
("3587","Akcesoria","1062","3","0","1"),
("3588","skala 1:700","1062","1","0","1"),
("3589","skala 1:350 i 1:400","1062","0","0","1"),
("3590","Figurki","1061","0","0","0"),
("3591","Akcesoria","3590","5","0","1"),
("3592","Pozostałe","3590","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3593","skala 1:16","3590","0","0","1"),
("3594","skala 1:32 i 1:35","3590","1","0","1"),
("3595","skala 1:48","3590","2","0","1"),
("3596","skala 1:72 i 1:76","3590","3","0","1"),
("3597","Akcesoria","1063","4","0","0"),
("3599","Budownictwo","1063","5","0","0"),
("3601","H0 - 1:87","1063","0","0","0"),
("3602","TT - 1:120","1063","2","0","0"),
("3603","N - 1:160","1063","1","0","0"),
("3604","Pozostałe","1272","6","0","1"),
("3605","Lotnictwo","1272","2","0","1"),
("3606","Szkutnictwo","1272","5","0","1"),
("3607","Pojazdy wojskowe","1272","3","0","1"),
("3608","Budownictwo","1272","0","0","1"),
("3609","Pozostałe","1273","4","0","1"),
("3610","Lotnictwo","1273","2","0","1"),
("3611","Szkutnictwo","1273","3","0","1"),
("3612","Broń pancerna","1273","0","0","1"),
("3613","Koleje","1273","1","0","1"),
("3614","Literatura ogólna","1067","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3615","Lotnictwo","1067","1","0","1"),
("3616","Szkutnictwo","1067","4","0","1"),
("3617","Pojazdy wojskowe","1067","3","0","1"),
("3618","Motoryzacja","1067","2","0","1"),
("3620","Ameryka Łacińska","79","0","0","1"),
("3621","USA i Kanada","79","2","0","1"),
("3622","Europa Wschodnia","412","0","0","0"),
("3623","Europa Zachodnia","412","1","0","0"),
("3624","Rosja i ZSRR","412","3","0","0"),
("3625","Niemcy","412","2","0","0"),
("3626","Prusy","3625","3","0","1"),
("3627","po 1945","3625","2","0","0"),
("3628","1918 - 1945","3625","1","0","1"),
("3629","do 1918","3625","0","0","1"),
("3630","1918 - 1939","406","1","0","0"),
("3631","do 1918","406","0","0","1"),
("3632","1939 - 1945 Emigracja","406","2","0","1"),
("3633","1944 - 1950","406","5","0","1"),
("3634","1951 - 1960","406","6","0","1"),
("3635","1991 - 2000","406","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3636","WM Gdańsk","406","13","0","1"),
("3639","Fauna","414","0","0","0"),
("3640","Flora","414","1","0","1"),
("3641","Malarstwo","414","6","0","1"),
("3642","Lotnictwo","414","5","0","1"),
("3643","Sport","414","12","0","1"),
("3644","Religia i Papież","414","10","0","0"),
("3645","Polonica","414","9","0","1"),
("3646","Solidarność","414","11","0","1"),
("3647","Pozostałe","414","13","0","1"),
("3648","Klasery","451","0","0","1"),
("3649","Pozostałe","451","1","0","1"),
("3650","Literatura","76","9","0","0"),
("3651","Katalogi","3650","0","0","1"),
("3652","Pozostałe","3650","1","0","1"),
("3653","Zestawy i zbiory","76","8","0","0"),
("3654","Ameryka Łacińska","89","0","0","1"),
("3655","Karaiby","89","2","0","1"),
("3656","USA","89","3","0","0"),
("3657","Pozostałe","89","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3658","Pozostałe","339","3","0","1"),
("3659","Grecja","339","0","0","1"),
("3660","Rzym","339","1","0","1"),
("3661","Pozostałe","87","19","0","1"),
("3662","Austro-Węgry i Austria","87","0","0","0"),
("3663","Niemcy","87","8","0","0"),
("3664","Rosja","87","9","0","0"),
("3665","Ukraina","87","14","0","1"),
("3666","Kraje bałtyckie","87","7","0","1"),
("3667","Euro","87","4","0","0"),
("3668","1933 - 1945","3663","3","0","1"),
("3669","od 1945","3663","4","0","1"),
("3670","do 1917","3664","0","0","1"),
("3671","od 1918","3664","1","0","1"),
("3675","960 - 1506","359","0","0","1"),
("3676","1669 - 1795","359","3","0","1"),
("3677","1796 - 1864","359","4","0","1"),
("3685","Pozostałe","507","5","0","1"),
("3686","Katalogi","507","1","0","1"),
("3687","Katalogi aukcyjne","507","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3688","Książki","507","3","0","1"),
("3689","Czasopisma","507","0","0","1"),
("3690","Broń","691","0","0","0"),
("3691","Broń biała","3690","0","0","0"),
("3700","Pozostałe","3690","6","0","1"),
("3703","Polska","1116","0","0","1"),
("3704","Pozostałe","1116","1","0","1"),
("3705","Odznaki","691","5","0","0"),
("3706","Polska","3705","4","0","0"),
("3707","do 1939","3706","0","0","1"),
("3709","po 1990","3706","4","0","1"),
("3710","Niemcy","3705","2","0","0"),
("3711","1918 - 1945","3710","1","0","1"),
("3712","po 1945","3710","2","0","1"),
("3713","Orły","3705","3","0","0"),
("3714","Rosja i ZSRR","3705","5","0","0"),
("3715","Kopie","3705","9","0","0"),
("3716","Pozostałe","3705","10","0","0"),
("3717","Paramilitarne","691","6","0","0"),
("3718","Harcerstwo i Sokół","3717","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3720","Straż pożarna","3717","5","0","1"),
("3723","Policja","3717","2","0","0"),
("3724","Literatura","691","11","0","0"),
("3725","Książki","3724","1","0","0"),
("3726","wydanie do 1945","3725","0","0","1"),
("3727","wydanie po 1945","3725","1","0","0"),
("3729","Czasopisma i gazety","3724","0","0","0"),
("3730","wydanie do 1945","3729","0","0","1"),
("3731","wydanie po 1945","3729","1","0","1"),
("3732","Pozostałe","3724","4","0","1"),
("3733","Odznaczenia","691","4","0","0"),
("3734","Polska","3733","3","0","0"),
("3735","do 1939","3734","0","0","1"),
("3737","Niemcy","3733","2","0","0"),
("3738","Rosja i ZSRR","3733","4","0","0"),
("3739","Kopie","3733","6","0","1"),
("3740","Pozostałe","3733","7","0","0"),
("3741","Naszywki","691","3","0","0"),
("3742","Polska","3741","1","0","1"),
("3743","Pozostałe","3741","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("3768","Polska","1084","2","0","0"),
("3769","Niemcy","1084","1","0","0"),
("3770","do 1918","3769","0","0","1"),
("3771","1918 - 1945","3769","1","0","1"),
("3772","Austro-Węgry","1084","0","0","1"),
("3773","Rosja i ZSRR","1084","3","0","1"),
("3774","Pozostałe","1084","4","0","1"),
("3780","Zestawy","3504","5","0","1"),
("3781","Zestawy","3516","4","0","1"),
("3919","Sport i Turystyka","0","23","0","0"),
("3922","Turystyka","3919","14","0","0"),
("3923","Kolekcje","3919","15","0","0"),
("3964","Pozostałe","3922","14","0","1"),
("3965","Pozostałe","3923","15","0","1"),
("3966","Autografy","3923","3","0","1"),
("3968","Gadżety kolekcjonerskie","3923","5","0","0"),
("3969","Karty sportowe","3923","6","0","1"),
("3970","Odznaki","3923","9","0","0"),
("3971","Proporczyki","3923","11","0","0"),
("3972","Zdjęcia i plakaty","3923","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4029","Osobowe","149","3","0","0"),
("4030","Alfa Romeo","4029","2","0","0"),
("4031","Audi","4029","5","0","0"),
("4032","BMW","4029","7","0","0"),
("4033","Citroen","4029","14","0","0"),
("4034","Daewoo","4029","16","0","0"),
("4035","Fiat","4029","20","0","0"),
("4036","Ford","4029","21","0","0"),
("4037","Honda","4029","22","0","0"),
("4038","Hyundai","4029","24","0","0"),
("4039","Lancia","4029","31","0","0"),
("4040","Mazda","4029","38","0","0"),
("4041","Mercedes-Benz","4029","39","0","0"),
("4042","Mitsubishi","4029","44","0","0"),
("4043","Nissan","4029","45","0","0"),
("4044","Opel","4029","47","0","0"),
("4045","Peugeot","4029","48","0","0"),
("4046","Polonez","4029","50","0","0"),
("4047","Renault","4029","54","0","0"),
("4048","Rover","4029","56","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4049","Saab","4029","57","0","0"),
("4050","Seat","4029","58","0","0"),
("4051","Skoda","4029","59","0","0"),
("4052","Subaru","4029","62","0","0"),
("4053","Suzuki","4029","63","0","0"),
("4054","Toyota","4029","67","0","0"),
("4055","Volkswagen","4029","70","0","0"),
("4056","Volvo","4029","71","0","0"),
("4057","Trabant","4029","68","0","1"),
("4058","Pozostałe","4029","73","0","1"),
("4059","126","4035","2","0","1"),
("4060","Cinquecento","4035","10","0","1"),
("4061","Pozostałe","4035","40","0","1"),
("4068","Pozostałe","158","13","0","1"),
("4069","Koła, felgi","158","2","0","0"),
("4070","Oświetlenie","158","3","0","0"),
("4071","Silniki i osprzęt","158","4","0","0"),
("4073","Układ wydechowy","158","10","0","0"),
("4074","Pozostałe","159","13","0","1"),
("4076","Kombinezony","159","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4077","Kurtki","159","7","0","1"),
("4078","Obuwie","159","8","0","1"),
("4079","Inne pojazdy i łodzie","3","6","0","0"),
("4080","Łodzie","4079","2","0","0"),
("4082","Samoloty i szybowce","4079","7","0","1"),
("4083","Pozostałe","4079","10","0","1"),
("4084","Motorówki","4080","2","0","1"),
("4086","Pozostałe","4080","4","0","1"),
("4094","Części karoserii","620","1","0","0"),
("4095","Pozostałe","4094","19","0","1"),
("4099","Lusterka zewnętrzne","4094","7","0","0"),
("4101","Szyby","4094","15","0","0"),
("4132","Pozostałe","622","33","0","1"),
("4133","Kierownice","622","6","0","1"),
("4134","Liczniki, zegary","622","10","0","1"),
("4135","Pozostałe","623","11","0","1"),
("4136","Kierunkowskazy","623","2","0","1"),
("4140","Żarówki","623","8","0","1"),
("4141","Układ elektryczny, zapłon","620","8","0","0"),
("4142","Akumulatory","4141","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4144","Centralne zamki","4141","1","0","0"),
("4145","Sterowniki silnika","4141","8","0","1"),
("4147","Pozostałe","4141","12","0","1"),
("4180","Uszkodzone","491","16","0","0"),
("4181","Pozostałe","491","17","0","1"),
("4226","Podzespoły bazowe","2","13","0","0"),
("4228","Płyty główne","4226","1","0","1"),
("4230","Sprzęt serwisowy","4226","4","0","0"),
("4308","Karty diagnostyczne","4230","0","0","1"),
("4309","Kości BIOS i Cache","4230","2","0","1"),
("4310","Testery monitorów","4230","3","0","1"),
("4311","Pozostałe","4230","4","0","1"),
("4312","Obraz i grafika","2","10","0","0"),
("4314","Kamery internetowe","4312","1","0","0"),
("4315","Tunery TV i SAT","4312","2","0","0"),
("4316","Karty Video, DV","4312","3","0","0"),
("4317","Monitory","4312","4","0","0"),
("4318","Pozostałe","4312","8","0","1"),
("4363","Kamery USB","4314","0","0","0"),
("4364","Urządzenia wielofunkcyjne","4314","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4368","Karty analogowe","4316","0","0","1"),
("4369","Profesjonalne karty DV/AV","4316","1","0","1"),
("4370","inne","4317","0","0","1"),
("4371","LCD","4317","1","0","1"),
("4395","Dźwięk","2","4","0","0"),
("4396","Głośniki","4395","0","0","1"),
("4397","Karty muzyczne","4395","1","0","0"),
("4398","Mikrofony i słuchawki","4395","2","0","0"),
("4399","Pozostałe","4395","3","0","1"),
("4405","Sound Blaster Audigy","4397","2","0","1"),
("4406","Sound Blaster Live","4397","3","0","1"),
("4407","Sound Blaster inne","4397","5","0","1"),
("4408","Inne 6-kanałowe","4397","7","0","1"),
("4409","Inne 4-kanałowe","4397","8","0","1"),
("4410","Inne stereo","4397","10","0","1"),
("4411","Karty ISA","4397","11","0","1"),
("4412","Pozostałe","4397","13","0","1"),
("4413","Komunikacja i łączność","2","7","0","0"),
("4414","Karty sieciowe","4413","3","0","0"),
("4415","Sprzęt sieciowy","4413","11","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4416","Akcesoria sieciowe","4413","0","0","0"),
("4421","USB huby","4413","12","0","0"),
("4422","Kontrolery","4413","5","0","0"),
("4425","Pozostałe","4413","14","0","1"),
("4426","PCI","4414","0","0","0"),
("4427","USB","4414","2","0","1"),
("4429","ISA","4414","3","0","1"),
("4430","Pozostałe","4414","4","0","1"),
("4431","Gigabit Ethernet 1000","4426","0","0","1"),
("4432","FastEthernet 100","4426","1","0","1"),
("4433","Ethernet 10","4426","2","0","1"),
("4434","Pozostałe","4426","3","0","1"),
("4436","Switche i huby","4415","0","0","0"),
("4438","Printserwer","4415","1","0","1"),
("4439","Transceiver i konwertery","4415","2","0","1"),
("4440","Pozostałe","4415","4","0","1"),
("4441","Kable","4416","0","0","0"),
("4442","Światłowody","4416","2","0","1"),
("4443","Testery sieci","4416","3","0","1"),
("4444","Wtyki, trójniki, końcówki","4416","4","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4445","Zaciskarki","4416","5","0","1"),
("4446","Pozostałe","4416","6","0","1"),
("4459","Kontrolery ATA/SATA","4422","0","0","1"),
("4461","Kontrolery USB","4422","1","0","1"),
("4463","Kontrolery LPT/RS (PCI)","4422","3","0","1"),
("4464","Kontrolery LPT/RS (ISA)","4422","2","0","1"),
("4465","Pozostałe","4422","4","0","1"),
("4475","Dyski i napędy","2","3","0","0"),
("4476","Dyski twarde","4475","1","0","0"),
("4477","Napędy CD","4475","3","0","0"),
("4478","Nagrywarki CD-R/CD-RW","4475","4","0","0"),
("4479","Napędy dyskietek","4475","5","0","1"),
("4480","Napędy DVD","4475","6","0","0"),
("4481","Nagrywarki DVD","4475","7","0","0"),
("4483","Obudowy i kieszenie","4475","11","0","0"),
("4484","Nośniki","4475","10","0","0"),
("4485","Pozostałe","4475","12","0","1"),
("4495","Uszkodzone","4476","3","0","0"),
("4496","40GB - 79GB","4495","3","0","1"),
("4497","15GB - 39GB","4495","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4498","1GB - 14GB","4495","5","0","1"),
("4499","mniejsze od 1GB","4495","6","0","1"),
("4501","49x i szybsze","4477","0","0","1"),
("4502","48x - 25x","4477","1","0","1"),
("4503","24x - 1x","4477","2","0","1"),
("4507","Uszkodzone","4477","3","0","1"),
("4508","50x i szybsze","4478","0","0","1"),
("4509","49x - 36x","4478","1","0","1"),
("4510","do 35x","4478","2","0","1"),
("4514","Uszkodzone","4478","4","0","1"),
("4515","13x i szybsze","4480","0","0","1"),
("4516","12x - 1x","4480","1","0","1"),
("4517","Uszkodzone","4480","2","0","1"),
("4524","Nośniki CD-R","4484","0","0","0"),
("4525","Płyty CD-RW","4484","1","0","1"),
("4526","Nośniki DVD-R/RW","4484","2","0","0"),
("4527","Dyskietki","4484","6","0","1"),
("4531","Pojedyncze płyty CD-R","4524","0","0","1"),
("4532","Komplet 2-10 szt.","4524","1","0","1"),
("4533","Komplet 11-29 szt.","4524","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4534","Komplet 30-50 szt.","4524","3","0","1"),
("4535","Komplet ponad 51 szt.","4524","4","0","1"),
("4541","Kieszenie","4483","1","0","1"),
("4543","Ramki i sanki","4483","5","0","1"),
("4545","Pozostałe","4483","7","0","1"),
("4546","Pojedyncze DVD-R/RW","4526","0","0","1"),
("4547","2-10 szt. DVD-R/RW","4526","1","0","1"),
("4548","11-29 szt. DVD-R/RW","4526","2","0","1"),
("4549","30-50 szt. DVD-R/RW","4526","3","0","1"),
("4550","ponad 51 szt. DVD-R/RW","4526","4","0","1"),
("4551","Obudowy i zasilanie","2","11","0","0"),
("4552","Obudowy","4551","1","0","0"),
("4553","Listwy, filtry sieciowe","4551","0","0","1"),
("4554","UPS","4551","2","0","0"),
("4555","Zasilacze","4551","3","0","0"),
("4556","Pozostałe","4551","4","0","1"),
("4557","Typu AT","4552","3","0","1"),
("4558","ATX z zasilaczem","4552","1","0","1"),
("4560","Typu AT","4555","0","0","1"),
("4561","Typu ATX","4555","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4563","Uszkodzone","4555","2","0","1"),
("4564","Urządzenia wskazujące","2","16","0","0"),
("4565","Joysticki","4564","0","0","1"),
("4566","Klawiatury","4564","2","0","0"),
("4567","Kierownice","4564","1","0","1"),
("4568","Myszki","4564","3","0","0"),
("4569","Pady, wolanty","4564","5","0","1"),
("4570","Tablety graficzne","4564","7","0","1"),
("4571","Trackball","4564","9","0","1"),
("4572","Pozostałe","4564","11","0","1"),
("4573","Bezprzewodowe","4566","0","0","1"),
("4574","Przewodowe","4566","1","0","1"),
("4575","Bezprzewodowe","4568","0","0","1"),
("4576","Przewodowe","4568","1","0","1"),
("4577","Podkładki","4568","2","0","1"),
("4578","Drukarki i skanery","2","2","0","0"),
("4582","Drukarki igłowe","4578","4","0","1"),
("4583","Taśmy barwiące","4578","9","0","0"),
("4584","Drukarki atramentowe i laserowe","4578","3","0","1"),
("4586","Plotery","4578","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4587","Skanery","4578","8","0","0"),
("4588","Części i akcesoria","4578","1","0","0"),
("4589","Uszkodzone","4578","13","0","0"),
("4607","Oryginalne","4583","0","0","1"),
("4608","Zamienniki","4583","1","0","1"),
("4623","Płaskie USB","4587","0","0","0"),
("4624","Profesjonalne","4587","3","0","1"),
("4625","Pozostałe","4587","4","0","1"),
("4626","Części","4588","1","0","0"),
("4630","Pozostałe","4588","2","0","1"),
("4631","Pozostałe","69","2","0","1"),
("4632","Programy Microsoft","69","0","0","1"),
("4633","Zarządzanie firmą","69","1","0","1"),
("4634","Pozostałe","74","4","0","1"),
("4635","Dla dzieci","74","0","0","1"),
("4636","Encyklopedie","74","1","0","1"),
("4637","Kursy językowe","74","2","0","1"),
("4638","Kursy inne","74","3","0","1"),
("4639","Pozostałe","70","4","0","1"),
("4640","Graficzne","70","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4641","Cliparty i czcionki","70","3","0","1"),
("4642","Pozostałe","4640","4","0","1"),
("4643","Adobe","4640","0","0","1"),
("4644","CAD/CAM","4640","1","0","1"),
("4645","Corel","4640","2","0","1"),
("4646","Macromedia","4640","3","0","1"),
("4650","Programowanie","68","8","0","0"),
("4651","Borland","4650","0","0","1"),
("4652","Microsoft","4650","1","0","1"),
("4653","Pozostałe","4650","2","0","1"),
("4654","Systemy Microsoft","68","9","0","0"),
("4655","Systemy Linux","68","10","0","0"),
("4656","Systemy inne","68","11","0","1"),
("4657","Pozostałe","75","2","0","1"),
("4658","Płyty z czasopismami","75","0","0","1"),
("4659","Sterowniki","75","1","0","1"),
("4660","Windows XP Home","4654","7","0","1"),
("4661","Windows 2000","4654","12","0","1"),
("4664","Windows 98","4654","9","0","1"),
("4665","Windows 95","4654","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4666","Windows Server","4654","11","0","1"),
("4667","Windows XP Prof.","4654","8","0","1"),
("4671","Pozostałe","4654","13","0","1"),
("4675","Mandrake, Mandriva","4655","0","0","1"),
("4680","Pozostałe","4655","2","0","1"),
("4687","Chłodzenie i tuning","497","0","0","0"),
("4689","Kable, taśmy, przedłużacze","497","4","0","0"),
("4690","Dodatki do płyt CD/DVD","497","1","0","0"),
("4691","Przejściówki, śledzie","497","8","0","0"),
("4693","Chłodzenie wodne","4687","5","0","0"),
("4694","Elementy oświetleniowe","4687","6","0","1"),
("4695","Ogniwa peltiera","4687","10","0","1"),
("4696","Naklejki","4687","9","0","1"),
("4697","Pasty termoprzewodzące","4687","12","0","1"),
("4699","Regulatory obrotów, alarmy","4687","14","0","1"),
("4702","Pozostałe","4687","16","0","1"),
("4717","Kable i przedłużacze","4689","0","0","0"),
("4718","Kable zasilające","4689","1","0","1"),
("4719","Taśmy","4689","3","0","0"),
("4720","Pozostałe","4689","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4721","Audio","4717","0","0","1"),
("4722","FireWire","4717","4","0","1"),
("4723","LPT","4717","6","0","1"),
("4725","Szeregowe RS","4717","9","0","1"),
("4726","USB","4717","10","0","0"),
("4727","Video","4717","11","0","1"),
("4728","Pozostałe","4717","12","0","1"),
("4729","Taśmy FDD","4719","0","0","1"),
("4730","Taśmy HDD","4719","1","0","1"),
("4732","Pozostałe","4719","2","0","1"),
("4733","Koperty","4690","1","0","1"),
("4734","Pudełka","4690","3","0","0"),
("4735","Etui, albumy","4690","0","0","1"),
("4736","Segregatory","4690","4","0","1"),
("4737","Stojaki i półki","4690","5","0","1"),
("4738","Przejściówki","4691","0","0","0"),
("4739","Śledzie","4691","1","0","0"),
("4740","Pozostałe","4691","2","0","1"),
("4741","Audio","4738","0","0","1"),
("4742","Klawiatura","4738","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4743","Mysz","4738","4","0","1"),
("4744","Procesor","4738","6","0","1"),
("4746","Szeregowe RS","4738","7","0","1"),
("4747","USB, FireWire","4738","8","0","1"),
("4748","Video","4738","9","0","1"),
("4749","Pozostałe","4738","10","0","1"),
("4750","Audio","4739","0","0","1"),
("4751","RS, LPT, PS2","4739","1","0","1"),
("4752","USB, FireWire","4739","2","0","1"),
("4753","Pozostałe","4739","3","0","1"),
("4764","Muzyczne","68","6","0","1"),
("4766","Powiązane z Polską","85","11","0","0"),
("4767","Pomorze","4766","0","0","1"),
("4768","Śląsk","4766","2","0","1"),
("4769","Prusy Książęce","4766","1","0","1"),
("4770","Pozostałe","4766","4","0","1"),
("4771","Pozostałe","94","6","0","1"),
("4772","Kopie i reprodukcje","94","1","0","1"),
("4773","Zestawy","94","4","0","1"),
("4776","Tematyczne","85","14","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4778","Zwierzęta","4776","4","0","1"),
("4779","Sport","4776","3","0","1"),
("4793","Pozostałe","351","11","0","1"),
("4795","Do Motorola","351","3","0","1"),
("4796","Do Nokia","351","4","0","1"),
("4797","Do Siemens","351","6","0","1"),
("4799","Do Sony Ericsson","351","7","0","1"),
("4800","Zestawy kabli","351","8","0","1"),
("4801","Klawiatury","348","7","0","1"),
("4802","Multimedia","348","11","0","0"),
("4803","Aparaty cyfrowe","4802","0","0","1"),
("4806","Pozostałe","349","10","0","1"),
("4807","Nokia","349","5","0","1"),
("4808","Siemens","349","7","0","1"),
("4809","Sony Ericsson","349","9","0","1"),
("4861","Pozostałe","455","2","0","1"),
("4862","Przewodowe","455","1","0","1"),
("4863","Bluetooth","455","0","0","1"),
("4927","Pozostałe","4802","5","0","1"),
("4937","Alcatel","165","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("4978","Nokia","165","25","0","0"),
("4980","3310","4978","39","0","1"),
("5006","Inne modele","4978","109","0","1"),
("5015","Inne modele","435","18","0","0"),
("5044","Sony Ericsson","165","31","0","0"),
("5045","Inne modele","5044","39","0","1"),
("5054","Sprzęt CB","446","1","0","0"),
("5055","Pozostałe","5054","4","0","1"),
("5057","Radiotelefony przenośne","5054","3","0","1"),
("5058","CB Radia","5054","2","0","1"),
("5060","Akcesoria i części","5054","0","0","0"),
("5061","Sprzęt krótkofalarski","446","2","0","0"),
("5062","Pozostałe","5061","3","0","1"),
("5063","Akcesoria i części","5061","0","0","0"),
("5065","Literatura i instrukcje","5061","1","0","1"),
("5111","Projektory","717","10","0","0"),
("5119","Telewizja przemysłowa","717","13","0","0"),
("5120","Telewizory","717","14","0","0"),
("5123","Plazmowe","5120","3","0","0"),
("5124","Pozostałe","5120","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5125","Uszkodzone","717","16","0","1"),
("5126","Literatura i instrukcje","717","17","0","1"),
("5166","100 mm","1322","1","0","1"),
("5167","130 i 135 mm","1322","3","0","1"),
("5168","160 i 165 mm","1322","4","0","1"),
("5169","200 mm","1322","5","0","1"),
("5170","Skrzynie basowe i tuby","1322","12","0","1"),
("5171","Wysokotonowe","1322","13","0","1"),
("5172","Zestawy głośnikowe","1322","14","0","1"),
("5173","Pozostałe","1322","17","0","1"),
("5174","6x9\'\'","1322","11","0","1"),
("5185","CD","712","0","0","0"),
("5186","CD/MP3","712","1","0","0"),
("5187","MiniDisc","712","3","0","1"),
("5188","Kasetowe","712","2","0","0"),
("5189","Pozostałe","712","7","0","1"),
("5191","Piloty i joysticki","709","7","0","1"),
("5192","Literatura i instrukcje","709","14","0","1"),
("5193","Inni producenci","5185","10","0","1"),
("5194","Alpine","5185","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5195","Clarion","5185","2","0","1"),
("5196","Blaupunkt","5185","1","0","1"),
("5197","JVC","5185","3","0","1"),
("5198","Kenwood","5185","4","0","1"),
("5199","Panasonic","5185","5","0","1"),
("5200","Pioneer","5185","7","0","1"),
("5201","Sony","5185","8","0","1"),
("5202","Inni producenci","5188","11","0","1"),
("5203","Alpine","5188","0","0","1"),
("5204","Clarion","5188","2","0","1"),
("5205","Blaupunkt","5188","1","0","1"),
("5206","JVC","5188","4","0","1"),
("5207","Kenwood","5188","5","0","1"),
("5208","Panasonic","5188","6","0","1"),
("5209","Pioneer","5188","8","0","1"),
("5210","Sony","5188","9","0","1"),
("5211","Pozostałe","1320","3","0","1"),
("5220","Literatura i instrukcje","11","19","0","1"),
("5232","Stereo","358","0","0","0"),
("5233","Kino domowe (5.1 6.1)","358","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5315","Oświetlenie","1532","15","0","0"),
("5317","Oświetlenie","123","7","0","0"),
("5318","Lampy","5317","1","0","1"),
("5321","Pozostałe","5317","6","0","1"),
("5328","Przybory kuchenne","123","9","0","0"),
("5336","Zwierzęta akwariowe","1118","15","0","0"),
("5337","Rośliny akwariowe","1118","11","0","0"),
("5338","Akwaria i zestawy","1118","1","0","0"),
("5341","Pozostałe","1118","16","0","1"),
("5344","Psy","1530","5","0","1"),
("5345","Fretki","1530","0","0","1"),
("5346","Pozostałe","1530","7","0","1"),
("5351","Balsamy, masła, kremy","1433","1","0","1"),
("5352","Kąpiel i prysznic","1433","3","0","0"),
("5354","Pozostałe","1433","9","0","1"),
("5355","Kremy do rąk","1434","1","0","1"),
("5356","Kremy do stóp","1434","2","0","1"),
("5357","Pozostałe","1434","5","0","1"),
("5358","Kremy na dzień","1435","1","0","1"),
("5359","Kremy pod oczy","1435","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5360","Maseczki","1435","4","0","1"),
("5361","Oczyszczanie i demakijaż","1435","5","0","1"),
("5362","Pozostałe","1435","11","0","1"),
("5363","Szampony","1436","5","0","1"),
("5364","Odżywki do włosów","1436","3","0","1"),
("5365","Pozostałe","1436","6","0","1"),
("5366","Opalanie","1430","3","0","0"),
("5537","Kurtki","1459","0","0","1"),
("5538","Płaszcze","1459","1","0","1"),
("5539","Pozostałe","1459","2","0","1"),
("5540","Sandały","531","12","0","1"),
("5541","Kozaki","531","9","0","1"),
("5542","Półbuty","531","11","0","1"),
("5543","Czółenka","531","3","0","1"),
("5544","Pozostałe","531","17","0","1"),
("5545","Sportowe","531","13","0","0"),
("5546","Sportowe","532","9","0","0"),
("5547","Półbuty","532","7","0","1"),
("5549","Pozostałe","532","14","0","1"),
("5553","Bejsbolówki","1496","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5554","Kapelusze","1496","3","0","1"),
("5555","Pozostałe","1496","8","0","1"),
("5556","Plecaki","1487","13","0","1"),
("5557","Motocykle i quady","3","8","0","0"),
("5560","Motorowery","5557","2","0","0"),
("5562","Pozostałe","5557","7","0","0"),
("5584","Rock","194","14","0","0"),
("5585","Pop","194","11","0","0"),
("5587","Rock\'n\'roll","194","15","0","1"),
("5588","Muzyka elektroniczna","194","9","0","1"),
("5589","Kolędy","194","7","0","1"),
("5590","Dla dzieci","194","3","0","1"),
("5594","Polski","5585","0","0","1"),
("5595","Zagraniczny","5585","1","0","1"),
("5596","Hard","5584","0","0","1"),
("5597","Soft, Klasyczny","5584","4","0","1"),
("5598","Punk","5584","3","0","1"),
("5599","Metal","5584","1","0","1"),
("5601","Pozostałe","5584","5","0","1"),
("5602","Rock","175","22","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5603","Pop","175","19","0","0"),
("5604","House","175","8","0","1"),
("5605","Rock\'n\'roll","175","23","0","1"),
("5606","Muzyka elektroniczna","175","13","0","1"),
("5607","Kolędy","175","10","0","1"),
("5608","Dla dzieci","175","6","0","0"),
("5609","Single","175","24","0","0"),
("5610","Polskie","5609","0","0","1"),
("5611","Zagraniczne","5609","1","0","0"),
("5612","Polski","5603","0","0","1"),
("5613","Zagraniczny","5603","1","0","0"),
("5620","Rock","279","18","0","0"),
("5621","Pop","279","15","0","0"),
("5622","House","279","8","0","1"),
("5623","Rock\'n\'roll","279","19","0","1"),
("5624","Muzyka elektroniczna","279","13","0","1"),
("5625","Kolędy","279","11","0","1"),
("5626","Dla dzieci","279","5","0","1"),
("5627","Single","279","20","0","0"),
("5628","Polskie","5627","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("5629","Zagraniczne","5627","1","0","1"),
("5630","Polski","5621","0","0","1"),
("5631","Zagraniczny","5621","1","0","1"),
("5632","Hard","5620","0","0","1"),
("5633","Soft, Klasyczny","5620","4","0","1"),
("5634","Punk","5620","3","0","1"),
("5635","Metal","5620","1","0","1"),
("5637","Pozostałe","5620","5","0","1"),
("5638","Dance","279","4","0","1"),
("5639","Ethno, Folk, World music","279","7","0","1"),
("5884","Popularnonaukowe","118","16","0","1"),
("5893","Ebooki","7","12","0","0"),
("5916","Towarzyskie","9","5","0","0"),
("6047","Pozostałe","5916","5","0","1"),
("6048","Bitewne","5916","0","0","0"),
("6049","Karciane","5916","2","0","0"),
("6050","Fabularne (RPG)","5916","1","0","0"),
("6051","Planszowe","5916","3","0","0"),
("6052","Pozostałe","6048","7","0","1"),
("6053","Akcesoria i makiety","6048","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("6056","Warzone","6048","3","0","1"),
("6057","WH 40000","6048","4","0","0"),
("6058","WH Fantasy Battle","6048","5","0","0"),
("6059","Inne systemy","6048","6","0","1"),
("6060","Akcesoria i pisma","6049","0","0","1"),
("6061","Doom Trooper","6049","1","0","1"),
("6062","Dragon Ball","6049","2","0","1"),
("6065","Lord of the Rings","6049","4","0","1"),
("6066","Magic: The Gathering","6049","5","0","0"),
("6067","Pokemon","6049","6","0","1"),
("6068","Star Wars","6049","7","0","0"),
("6070","Pozostałe","6049","12","0","1"),
("6087","Pozostałe","6066","9","0","1"),
("6089","Artefakty","6066","0","0","1"),
("6090","Białe","6066","1","0","1"),
("6091","Czarne","6066","2","0","1"),
("6092","Czerwone","6066","3","0","1"),
("6093","Lądy","6066","4","0","1"),
("6094","Multikolor","6066","5","0","1"),
("6095","Niebieskie","6066","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("6096","Zielone","6066","7","0","1"),
("6097","Zestawy kart","6066","8","0","0"),
("6098","Pozostałe","6050","3","0","1"),
("6099","Akcesoria i pisma","6050","0","0","1"),
("6100","Systemy (inne języki)","6050","1","0","1"),
("6101","Systemy (język polski)","6050","2","0","0"),
("6102","Pozostałe","6051","16","0","1"),
("6103","Strategie","6051","10","0","1"),
("6104","Fantasy","6051","2","0","1"),
("6105","Rodzinne","6051","7","0","1"),
("6106","Logiczne i edukacyjne","6051","5","0","1"),
("6107","Szachy","6051","13","0","0"),
("6108","Warcaby","6051","14","0","1"),
("6109","Pozostałe","6107","5","0","1"),
("6110","Akcesoria i pisma","6107","0","0","1"),
("6111","Drewniane","6107","1","0","1"),
("6112","Elektroniczne","6107","2","0","1"),
("6113","Magnetyczne","6107","3","0","1"),
("6121","Płyty z procesorem","4226","2","0","1"),
("6133","Obudowy CD, CD-R, DVD","4483","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("6134","Obudowy dysków 3,5\"","4483","4","0","1"),
("6135","Pozostałe","4552","4","0","1"),
("6136","Pozostałe","4555","3","0","1"),
("8538","Literatura","380","8","0","1"),
("8539","Atrapy i telefony demonstracyjne","348","2","0","1"),
("8633","Combo (z DVD)","4478","3","0","1"),
("8634","Drukarki inne","4578","5","0","1"),
("8641","Jaguar","4029","27","0","0"),
("8642","Kia","4029","29","0","0"),
("8643","Łada","4029","36","0","0"),
("8644","Porsche","4029","52","0","0"),
("8645","Wartburg","4029","72","0","1"),
("8646","Pozostałe","590","27","0","1"),
("8647","Avia","590","0","0","1"),
("8648","Citroen","590","1","0","1"),
("8649","Fiat","590","5","0","1"),
("8650","Ford","590","6","0","1"),
("8651","Iveco","590","10","0","1"),
("8652","Mercedes-Benz","590","14","0","1"),
("8653","Nysa","590","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8654","Peugeot","590","19","0","1"),
("8655","Polonez","590","20","0","1"),
("8656","Renault","590","21","0","1"),
("8657","Volkswagen","590","25","0","1"),
("8658","Żuk","590","26","0","1"),
("8659","Chopper, Cruiser","5557","0","0","0"),
("8660","Cross, Enduro","5557","1","0","0"),
("8661","Sportowe","5557","5","0","0"),
("8662","Szosowo-Turystyczne","5557","6","0","0"),
("8663","Skutery","5557","4","0","0"),
("8682","Fotele, kanapy","622","4","0","1"),
("8683","Układ zawieszenia","620","14","0","0"),
("8684","Amortyzatory i elementy","8683","0","0","0"),
("8687","Pozostałe","8683","10","0","1"),
("8695","Tuning mechaniczny","620","7","0","0"),
("8721","Akcesoria motocyklowe","156","1","0","0"),
("8727","Jachty motorowe","4080","0","0","1"),
("8751","Polska po 1945","85","10","0","0"),
("8752","PRL 1945 - 1990","8751","0","0","0"),
("8753","III RP 1990 -","8751","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8754","obiegowe","8752","0","0","1"),
("8755","kolekcjonerskie","8752","2","0","1"),
("8756","próbne","8752","3","0","1"),
("8757","obiegowe","8753","2","0","1"),
("8758","kolekcjonerskie","8753","4","0","1"),
("8759","próbne","8753","5","0","1"),
("8760","Zdalnie sterowane","1061","9","0","0"),
("8761","Lotnicze","8760","0","0","0"),
("8762","Samochody","8760","2","0","1"),
("8763","Szkutnicze","8760","3","0","1"),
("8764","Części i Akcesoria","8760","5","0","1"),
("8765","Narzędzia modelarskie","1061","12","0","1"),
("8768","Inni producenci","5186","10","0","1"),
("8769","Alpine","5186","0","0","1"),
("8770","Blaupunkt","5186","1","0","1"),
("8771","Clarion","5186","2","0","1"),
("8772","JVC","5186","3","0","1"),
("8773","Kenwood","5186","4","0","1"),
("8774","Panasonic","5186","6","0","1"),
("8775","Pioneer","5186","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8776","Sony","5186","8","0","1"),
("8777","Inni producenci","715","9","0","1"),
("8778","Alpine","715","0","0","1"),
("8779","Blaupunkt","715","1","0","1"),
("8780","JVC","715","3","0","1"),
("8781","Kenwood","715","4","0","1"),
("8782","Pioneer","715","6","0","1"),
("8783","Sony","715","7","0","1"),
("8784","Panasonic","715","5","0","1"),
("8785","Kamery","10","6","0","0"),
("8786","Analogowe","8785","0","0","0"),
("8788","Akcesoria","8785","9","0","1"),
("8789","Nośniki","8785","10","0","1"),
("8790","Zasilanie","8785","12","0","0"),
("8791","Pozostałe","8785","15","0","1"),
("8792","8mm","8786","0","0","1"),
("8793","Hi8","8786","1","0","1"),
("8794","VHS","8786","2","0","1"),
("8795","Pozostałe","8786","3","0","1"),
("8804","Akumulatory","8790","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8805","Ładowarki","8790","1","0","1"),
("8806","Zasilacze","8790","2","0","1"),
("8807","Inni producenci","337","18","0","1"),
("8808","Denon","337","1","0","1"),
("8809","Panasonic","337","9","0","1"),
("8810","Pioneer","337","11","0","1"),
("8811","Sony","337","13","0","1"),
("8812","Yamaha","337","16","0","1"),
("8813","Przenośne","337","17","0","1"),
("8845","Fotografia","0","9","0","0"),
("8847","Akcesoria fotograficzne","8845","0","0","0"),
("8848","Karty pamięci","8845","3","0","0"),
("8849","Pozostałe","8845","11","0","0"),
("8850","Albumy, fotoksiążki, ramki na zdjęcia","8847","2","0","0"),
("8851","Drukarki fotograficzne","8847","4","0","1"),
("8852","Filmy i klisze","8847","5","0","0"),
("8853","Filtry","8847","6","0","0"),
("8854","Futerały i paski","8847","8","0","0"),
("8855","Kable, przewody i stacje dokujące","8847","9","0","0"),
("8857","Makro","8847","12","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8859","Osłony na obiektywy","8847","18","0","0"),
("8860","Rzutniki","8847","23","0","0"),
("8861","Statywy","8847","27","0","0"),
("8862","Torby i plecaki","8847","29","0","0"),
("8864","Wyposażenie ciemni","8847","31","0","0"),
("8866","Zestawy akcesoriów","8847","32","0","1"),
("8867","Pozostałe","8847","33","0","1"),
("8868","Skylight","8853","6","0","1"),
("8869","UV","8853","7","0","1"),
("8870","Efektowe","8853","0","0","1"),
("8871","Polaryzacyjne","8853","3","0","1"),
("8872","Pozostałe","8853","9","0","1"),
("8873","Mieszki","8857","1","0","1"),
("8874","Pierścienie","8857","2","0","1"),
("8875","Soczewki","8857","3","0","1"),
("8903","Czytniki i adaptery","8848","1","0","0"),
("8904","CompactFlash","8848","3","0","0"),
("8905","Memory Stick","8848","4","0","0"),
("8906","RS/MMC","8848","6","0","0"),
("8907","Smart Media","8848","8","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("8908","xD-Picture Card","8848","10","0","0"),
("8909","Pozostałe","8848","11","0","1"),
("8910","CompactFlash","8903","0","0","1"),
("8911","Memory Stick","8903","1","0","1"),
("8912","MMC/SD","8903","2","0","1"),
("8914","Uniwersalne","8903","3","0","1"),
("8915","Pozostałe","8903","4","0","1"),
("8929","do 16MB","8907","0","0","1"),
("8930","32MB","8907","1","0","1"),
("8931","64MB","8907","2","0","1"),
("8932","128MB","8907","3","0","1"),
("8937","Gadżety","1328","1","0","0"),
("8938","Świetlne","8937","1","0","1"),
("8939","Elektroniczne","8937","0","0","1"),
("8990","Kolumny głośnikowe","1320","0","0","0"),
("8992","Centralne","8990","0","0","1"),
("8993","Kino domowe","8990","1","0","0"),
("8994","Subwoofery","8990","3","0","0"),
("8995","Stereo","8990","2","0","0"),
("9001","2 zł okolicznościowe","8753","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9016","Wystrój okien","123","16","0","0"),
("9017","Pościel i koce","123","8","0","0"),
("9018","Dywany i dywaniki","123","2","0","0"),
("9023","80GB - 159GB","4495","2","0","1"),
("9024","zestawy","8752","1","0","1"),
("9025","zestawy","8753","3","0","1"),
("9026","Pozostałe","3504","6","0","1"),
("9029","Żetony","94","5","0","1"),
("9056","Akcesoria","380","9","0","1"),
("9059","1944 - 1965","381","4","0","1"),
("9060","Serwery i SCSI","2","14","0","0"),
("9061","Serwery","9060","0","0","0"),
("9062","Serwery - osprzęt","9060","1","0","0"),
("9063","Urządzenia SCSI i SAS","9060","2","0","0"),
("9064","Akcesoria SCSI","9060","3","0","0"),
("9065","Procesory","9062","4","0","1"),
("9066","Płyty główne","9062","2","0","1"),
("9068","Obudowy","9062","0","0","1"),
("9069","Streamery","9062","5","0","1"),
("9070","Uszkodzone","9062","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9071","Pozostałe","9062","7","0","1"),
("9072","Dyski SCSI","9063","1","0","0"),
("9073","Napędy SCSI","9063","3","0","1"),
("9075","Uszkodzone","9063","4","0","1"),
("9076","Pozostałe","9063","5","0","1"),
("9077","40GB i większe","9072","0","0","1"),
("9078","5GB - 40GB","9072","1","0","1"),
("9079","mniejsze od 5GB","9072","2","0","1"),
("9080","Uszkodzone","9072","3","0","1"),
("9082","Kable, taśmy","9064","0","0","1"),
("9083","Przejściówki SCSI","9064","1","0","1"),
("9084","Terminatory","9064","2","0","1"),
("9085","Pozostałe","9064","3","0","1"),
("9090","Karty DV, FireWire","4316","2","0","1"),
("9108","Tusze","4578","11","0","0"),
("9109","Oryginalne","9108","0","0","0"),
("9110","Zamienniki","9108","1","0","0"),
("9111","Zestawy regeneracyjne","9108","2","0","0"),
("9112","Akcesoria do regeneracji","9108","3","0","1"),
("9113","Puste cartridge","9108","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9114","Tusze w butlach","9108","5","0","1"),
("9115","Pozostałe","9108","6","0","1"),
("9118","Do Canon - czarny","9111","0","0","1"),
("9121","Do Canon - kolor","9111","1","0","1"),
("9124","Do Epson - czarny","9111","2","0","1"),
("9127","Do Epson - kolor","9111","3","0","1"),
("9130","Do HP - czarny","9111","4","0","1"),
("9133","Do HP - kolor","9111","5","0","1"),
("9136","Do Lexmark - czarny","9111","6","0","1"),
("9139","Do Lexmark - kolor","9111","7","0","1"),
("9140","inny","9109","5","0","1"),
("9141","inne","9110","5","0","1"),
("9142","Do Pozostałe","9111","8","0","1"),
("9143","Kontrolery SCSI i SAS","9063","2","0","1"),
("9145","Nośniki inne","4484","7","0","1"),
("9176","Edycja video","70","1","0","1"),
("9178","Płyty z procesorem","9062","3","0","1"),
("9189","Zestaw klawiatura i mysz","4564","4","0","0"),
("9191","Lord of the Rings","6048","1","0","1"),
("9200","Części broni","3690","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9238","Programy sportowe","3923","10","0","0"),
("9241","Szklane","6107","4","0","1"),
("9242","PS/2, DIN","4717","7","0","1"),
("9245","Uszkodzone","4397","12","0","1"),
("9260","Motorola","349","4","0","1"),
("9314","Wyszczuplające","1433","8","0","1"),
("9315","Modelowanie","1436","2","0","0"),
("9317","Dekoracje i ozdoby","123","1","0","0"),
("9318","Pozostałe","6097","2","0","1"),
("9319","Decki i boostery (nowe)","6097","0","0","1"),
("9320","Talie i repacki","6097","1","0","1"),
("9321","SW:CCG (Decipher)","6068","0","0","1"),
("9323","Pozostałe","6068","1","0","1"),
("9324","Yu-Gi-Oh!","6049","10","0","1"),
("9332","1506 - 1586","359","1","0","1"),
("9333","1587 - 1668","359","2","0","1"),
("9335","Fantazyjne","94","0","0","1"),
("9493","Płaskie inne","4587","1","0","1"),
("9494","Do filmów","4587","2","0","1"),
("9525","Pop","5611","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9526","Rock","5611","6","0","1"),
("9527","Pozostałe","5611","8","0","1"),
("9528","Zestawy","5611","9","0","1"),
("9529","Zestawy, pakiety","194","18","0","1"),
("9530","Zestawy, pakiety","175","31","0","1"),
("9531","Zestawy, pakiety","279","27","0","1"),
("9532","Klasyczny","260","0","0","1"),
("9533","Współczesny","260","1","0","1"),
("9534","Zagraniczny","186","1","0","1"),
("9535","Polski","186","0","0","1"),
("9536","Muzyka klasyczna","175","15","0","1"),
("9537","Opera","175","18","0","1"),
("9538","Polski","5602","0","0","0"),
("9539","Zagraniczny","5602","1","0","0"),
("9541","Pozostałe","9539","4","0","1"),
("9542","Hard","9539","0","0","1"),
("9544","Punk","9539","2","0","1"),
("9545","Soft, Klasyczny","9539","3","0","0"),
("9578","Pamięci przenośne","4475","9","0","0"),
("9580","1939 - 1945 GG","406","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9581","1961 - 1970","406","7","0","1"),
("9582","1971 - 1980","406","8","0","1"),
("9583","1981 - 1990","406","9","0","1"),
("9584","Plebiscyty","406","15","0","1"),
("9585","Kolejnictwo","414","3","0","1"),
("9586","Marynistyka","414","7","0","1"),
("9587","Karaiby i Kuba","79","1","0","1"),
("9588","Europa","409","0","0","0"),
("9589","Polska","409","1","0","0"),
("9590","Świat","409","2","0","0"),
("9591","Całości do 1900","9588","0","0","1"),
("9592","Całości 1901-1945","9588","1","0","1"),
("9593","Całości po 1945","9588","2","0","1"),
("9594","FDC i inne","9588","3","0","1"),
("9595","Całostki","9588","4","0","1"),
("9596","Całości do 1900","9590","0","0","1"),
("9597","Całości 1901 - 1945","9590","1","0","1"),
("9598","Całości po 1945","9590","2","0","1"),
("9599","FDC i inne","9590","3","0","1"),
("9600","Całostki","9590","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("9601","Całości do 1918","9589","0","0","1"),
("9603","Całości 1918 - 1939","9589","1","0","1"),
("9605","Koperty FDC","9589","10","0","1"),
("9606","Całostki do 1945","9589","6","0","1"),
("9608","Pozostałe","409","3","0","1"),
("9609","po 1945","3622","2","0","1"),
("9610","1901 - 1945","3622","1","0","1"),
("9611","do 1900","3622","0","0","1"),
("9612","po 1945","3623","2","0","0"),
("9613","1901 - 1945","3623","1","0","1"),
("9614","do 1900","3623","0","0","1"),
("10131","1939 - 1945 Pozostałe","406","4","0","1"),
("10133","Harcerstwo i Skauting","414","2","0","1"),
("10134","Litwa Środkowa","406","14","0","1"),
("10234","Pocztówki","6","10","0","0"),
("10235","Centralna Polska","10234","0","0","0"),
("10236","Łódź i okolice","10235","3","0","1"),
("10237","Kalisz i okolice","10235","1","0","1"),
("10238","Częstochowa i okolice","10235","0","0","1"),
("10239","Kielce i okolice","10235","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10240","Radom i okolice","10235","4","0","1"),
("10241","Dolny Śląsk (Niederschlesien)","10234","10","0","0"),
("10242","Jeleniogórskie (Riesengebirge)","10241","0","0","1"),
("10243","Wrocławskie (Breslau)","10241","4","0","1"),
("10244","Legnickie (Liegnitz)","10241","2","0","1"),
("10245","Wałbrzyskie (Waldenburg)","10241","3","0","1"),
("10246","Kotlina Kłodzka (Glatz)","10241","1","0","1"),
("10267","Kresy wschodnie","10234","1","0","0"),
("10268","Lwów","10267","0","0","1"),
("10269","Wilno","10267","1","0","1"),
("10270","Pozostałe","10267","2","0","1"),
("10271","Lublin i Podlasie","10234","2","0","1"),
("10274","Małopolska","10234","3","0","0"),
("10275","Karpaty i Podkarpacie","10274","0","0","1"),
("10276","Kraków i okolice","10274","1","0","1"),
("10277","Rzeszów i okolice","10274","2","0","1"),
("10284","Mazowsze","10234","4","0","0"),
("10285","Białostockie","10284","0","0","1"),
("10286","Mazowieckie","10284","1","0","1"),
("10287","Warszawa","10284","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10294","Pomorze (Pommern)","10234","5","0","0"),
("10295","Kujawy i Pomorze Pd","10294","0","0","1"),
("10296","Pomorze Środkowe","10294","1","0","1"),
("10297","Pomorze Wschodnie","10294","2","0","1"),
("10298","Pomorze Zachodnie","10294","3","0","1"),
("10299","Szczecin","10294","5","0","1"),
("10300","Gdańsk i okolice","10294","4","0","1"),
("10313","Śląsk (Schlesien)","10234","6","0","0"),
("10314","Górny Śląsk (Oberschlesien)","10313","0","0","1"),
("10315","Śląsk Cieszyński","10313","1","0","1"),
("10316","Śląsk Opolski (Oppeln)","10313","2","0","1"),
("10317","Zagłębie","10313","3","0","1"),
("10326","Warmia i Mazury (Ostpreussen)","10234","7","0","0"),
("10327","Mazury","10326","0","0","1"),
("10328","Warmia","10326","1","0","1"),
("10329","Pozostałe","10326","2","0","1"),
("10334","Wielkopolska (Grosspolen)","10234","8","0","0"),
("10335","Leszczyńskie","10334","0","0","1"),
("10336","Poznańskie","10334","1","0","1"),
("10341","Zielonogórskie i Lubuskie","10234","9","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10342","Zielonogórskie (Grünberg)","10341","1","0","1"),
("10343","Lubuskie (Ostbrandenburg)","10341","0","0","1"),
("10348","Pozostałe miasta i regiony","10234","11","0","1"),
("10349","Zagraniczne","10234","12","0","0"),
("10350","Afryka","10349","0","0","1"),
("10351","Ameryka Pn i Pd","10349","1","0","1"),
("10352","Australia i Oceania","10349","2","0","1"),
("10353","Azja","10349","3","0","1"),
("10354","Europa","10349","4","0","0"),
("10355","Niemcy","10354","0","0","1"),
("10356","Rosja","10354","1","0","1"),
("10357","Pozostałe","10354","2","0","1"),
("10358","Tematyczne","10234","13","0","0"),
("10359","Malarstwo","10358","9","0","1"),
("10360","Sztuka","10358","18","0","1"),
("10361","Etnografia","10358","3","0","1"),
("10362","Erotyka i Akt","10358","2","0","1"),
("10363","Humor","10358","5","0","1"),
("10364","Judaica","10358","6","0","1"),
("10365","Kino, teatr i reklama","10358","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10366","Sławni ludzie","10358","15","0","1"),
("10367","Mapki","10358","10","0","1"),
("10368","Kolejnictwo","10358","8","0","1"),
("10369","Flora i Fauna","10358","4","0","1"),
("10370","Samoloty i samochody","10358","14","0","1"),
("10371","Sport","10358","16","0","1"),
("10372","Statki i okręty","10358","17","0","1"),
("10374","Tramwaje i trolejbusy","10358","19","0","1"),
("10375","Twierdze, zamki, pałace","10358","21","0","1"),
("10376","Trójwymiarowe i muzyczne","10358","20","0","1"),
("10377","Wojskowe i patriotyczne","10358","23","0","1"),
("10381","Pozostałe","10234","17","0","1"),
("10382","Artystyczne","10358","0","0","1"),
("10385","Zestawy i kolekcje","10234","14","0","1"),
("10472","Pozostałe","3970","5","0","1"),
("10473","Federacje i organizacje","3970","0","0","1"),
("10474","Imprezy sportowe","3970","1","0","1"),
("10475","Kluby polskie","3970","2","0","1"),
("10476","Kluby zagraniczne","3970","3","0","1"),
("10477","Pozostałe","9238","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10478","Piłka nożna","9238","0","0","1"),
("10479","Żużel","9238","1","0","1"),
("10532","Folie ochronne na LCD","348","4","0","1"),
("10535","Samsung","349","6","0","1"),
("10539","LG","165","18","0","0"),
("10768","Terrarystyka","1528","8","0","0"),
("10769","Terraria i wyposażenie","10768","1","0","0"),
("10770","Zwierzęta terrariowe","10768","2","0","0"),
("10772","Pozostałe","10768","3","0","1"),
("10774","Źródła światła","5317","4","0","1"),
("10782","Klapki","531","8","0","0"),
("10783","Domowe","531","4","0","1"),
("10784","Kremy na noc","1435","2","0","1"),
("10785","Peeling","1435","7","0","1"),
("10790","Do biustu","1433","2","0","1"),
("10793","Kanada","89","1","0","1"),
("10794","obiegowe","3656","0","0","0"),
("10795","pozostałe","3656","1","0","1"),
("10818","Progresywny","9539","1","0","1"),
("10819","Hard","9538","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10821","Punk","9538","2","0","1"),
("10822","Soft, Klasyczny","9538","3","0","1"),
("10823","Progresywny","9538","1","0","1"),
("10824","Pozostałe","9538","4","0","1"),
("10825","Progresywny","5620","2","0","1"),
("10826","Progresywny","5584","2","0","1"),
("10829","Muzyka alternatywna","175","12","0","0"),
("10830","Muzyka alternatywna","279","12","0","1"),
("10831","Muzyka alternatywna","194","8","0","1"),
("10839","Płyty DVD+R/RW","4484","3","0","0"),
("10840","Pojedyncze płyty","10839","0","0","1"),
("10841","Zestaw 2-10 szt.","10839","1","0","1"),
("10842","Zestaw 11-29 szt.","10839","2","0","1"),
("10843","Zestaw 30-50 szt.","10839","3","0","1"),
("10844","Zestaw ponad 51 szt.","10839","4","0","1"),
("10845","Dwuwarstwowe DVD+R DL","10839","5","0","1"),
("10847","Etykiety na płyty","4690","6","0","1"),
("10848","Markery do płyt","4690","7","0","1"),
("10849","Pozostałe","4690","8","0","1"),
("10855","Bluetooth","4413","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("10870","8 - 15 portów","4436","1","0","1"),
("10871","Do 7 portów","4436","0","0","1"),
("10872","16 - 23 porty","4436","2","0","1"),
("10882","Urządzenia wielofunkcyjne","4578","12","0","0"),
("10903","Do Samsung","351","5","0","1"),
("11068","Parasole","1487","11","0","1"),
("11665","ATX bez zasilacza","4552","2","0","1"),
("11667","Medale i plakiety","3923","7","0","1"),
("11670","Boże Narodzenie","1591","0","0","0"),
("11694","do 512MB","8906","0","0","1"),
("11695","do 512MB","8908","0","0","1"),
("11696","Pozostałe","8850","4","0","1"),
("11697","Albumy","8850","0","0","0"),
("11699","Małoobrazkowe","8852","2","0","0"),
("11700","Pozostałe","11699","3","0","1"),
("11701","Negatywy kolorowe","11699","0","0","1"),
("11702","Negatywy czarno-białe","11699","1","0","1"),
("11703","Slajdy kolorowe","11699","2","0","1"),
("11704","Inne formaty","8852","3","0","1"),
("11705","Folie ochronne i osłony LCD","8847","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("11706","USB","8855","3","0","1"),
("11707","Wężyki spustowe","8855","4","0","1"),
("11708","Futerały","8854","0","0","1"),
("11709","Paski i smycze","8854","1","0","1"),
("11715","Wysokie","8861","1","0","0"),
("11716","Stołowe","8861","2","0","1"),
("11717","Głowice do statywów","8861","3","0","1"),
("11718","Światłomierze","8847","28","0","1"),
("11720","Pozostałe","8864","6","0","1"),
("11721","Akcesoria ciemniowe","8864","0","0","1"),
("11722","Papier i chemikalia","8864","2","0","1"),
("11723","Powiększalniki","8864","3","0","1"),
("11724","Suszarki","8864","4","0","1"),
("11725","Zestawy","8864","5","0","1"),
("11730","Kompensacyjne","8853","1","0","1"),
("11731","skale do 1:18","1066","0","0","1"),
("11732","skale 1:19 do 1:25","1066","1","0","1"),
("11733","skale 1:26 do 1:42","1066","2","0","1"),
("11734","skala 1:43","1066","3","0","1"),
("11736","skale 1:67 do 1:72","1066","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("11741","Pozostałe","8855","5","0","1"),
("11742","Zakon Krzyżacki","4766","3","0","1"),
("11743","Flora","4776","0","0","1"),
("11744","Marynistyka","4776","1","0","1"),
("11745","do 1871","3663","0","0","1"),
("11746","1871 - 1918","3663","1","0","1"),
("11747","Czechy i Słowacja","87","3","0","1"),
("11748","Francja","87","5","0","1"),
("11749","Włochy","87","18","0","1"),
("11750","Szwajcaria","87","12","0","1"),
("11751","Wielka Brytania","87","17","0","1"),
("11752","Benelux","87","1","0","1"),
("11753","Skandynawia","87","11","0","1"),
("11754","po 1918","3662","2","0","1"),
("11755","1848 - 1918","3662","1","0","1"),
("11756","do 1848","3662","0","0","1"),
("11757","1918 - 1933","3663","2","0","1"),
("11763","Dziecko","0","6","0","0"),
("11764","Odzież","11763","5","0","0"),
("11818","Zabawki","11763","10","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("11819","Plastyczne","11818","13","0","0"),
("11820","Dla niemowląt","11818","2","0","0"),
("11821","Edukacyjne","11818","4","0","0"),
("11822","Figurki","11818","5","0","1"),
("11823","Klocki","11818","7","0","0"),
("11824","Kolejki i tory","11818","8","0","0"),
("11825","Lalki i akcesoria","11818","9","0","0"),
("11826","Chou chou","11825","8","0","1"),
("11827","Baby born","11825","4","0","1"),
("11828","Barbie","11825","5","0","1"),
("11829","Porcelanowe","11825","20","0","1"),
("11830","Pozostałe","11825","34","0","1"),
("11837","Maskotki","11818","11","0","0"),
("11840","Puzzle","11818","14","0","1"),
("11841","Zdalnie sterowane","11818","17","0","0"),
("11842","Pozostałe","11818","18","0","1"),
("11889","Akcesoria","4588","0","0","0"),
("11890","Moduły sieciowe","11889","0","0","1"),
("11891","Pamięć","11889","1","0","1"),
("11892","Postscript i czcionki","11889","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("11893","Przełączniki","11889","4","0","1"),
("11894","Zasilacze","11889","6","0","1"),
("11895","Pozostałe","11889","7","0","1"),
("11896","Pozostałe","4626","6","0","1"),
("11897","Elementy grzewcze","4626","0","0","1"),
("11898","Elementy obudowy, podajniki","4626","1","0","1"),
("11899","Lasery, głowice, karetki","4626","2","0","1"),
("11900","Rolki, prowadnice, zębatki","4626","3","0","1"),
("11901","Separatory","4626","4","0","1"),
("11902","Silniki, płyty","4626","5","0","1"),
("11904","Flash do 512MB","9578","7","0","1"),
("11916","minerały","1149","0","0","1"),
("11917","skamieliny","1149","1","0","1"),
("11918","muszle","1149","2","0","1"),
("11919","literatura i akcesoria","1149","4","0","1"),
("11930","meteoryty","1149","3","0","1"),
("11981","Choinki","11670","0","0","1"),
("11982","Figurki","11670","1","0","1"),
("11983","Kartki świąteczne","11670","2","0","1"),
("11984","Ozdoby choinkowe","11670","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("11985","Oświetlenie choinkowe","11670","4","0","1"),
("11986","Szopki i stroiki","11670","6","0","1"),
("11987","Witrażyki","11670","8","0","1"),
("11988","Świeczniki i lampiony","11670","7","0","1"),
("11989","Pozostałe","11670","9","0","1"),
("11990","Walentynki","1591","1","0","0"),
("11991","Figurki","11990","0","0","1"),
("11992","Obrazki i witrażyki","11990","2","0","1"),
("11993","Kartki okazyjne","11990","1","0","1"),
("11994","Pozostałe","11990","3","0","1"),
("11995","Wielkanoc","1591","2","0","0"),
("11996","Pozostałe","1591","7","0","1"),
("11997","Ręczniki","123","11","0","0"),
("12041","Części amunicji","3690","2","0","1"),
("12047","USA","3741","3","0","1"),
("12048","Rosja i ZSRR","3741","2","0","1"),
("12050","po 1990","3734","4","0","1"),
("12051","do 1918","3737","0","0","1"),
("12052","1918 - 1945","3737","1","0","1"),
("12053","po 1945","3737","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12054","Austro- Węgry","3733","0","0","1"),
("12055","Europa","3740","0","0","1"),
("12056","Reszta świata","3740","1","0","1"),
("12057","do 1918","3710","0","0","1"),
("12058","PSZ na Zachodzie","3706","1","0","1"),
("12059","USA","3705","6","0","1"),
("12060","Francja","3705","1","0","1"),
("12061","Austro-Węgry","3705","0","0","1"),
("12062","Polska","3715","1","0","1"),
("12063","Niemcy","3715","0","0","1"),
("12064","Europa","3716","0","0","1"),
("12065","Reszta świata","3716","1","0","1"),
("12066","Pozostałe","3715","2","0","1"),
("12067","Pozostałe","3717","6","0","1"),
("12068","Rycerstwo","691","7","0","0"),
("12070","Seria TBiU","3724","3","0","1"),
("12071","Pozostałe","3727","15","0","1"),
("12073","Broń palna","3727","1","0","1"),
("12074","Broń pancerna","3727","2","0","1"),
("12075","Marynarka Wojenna","3727","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12076","Artyleria","3727","0","0","1"),
("12077","Kawaleria","3727","6","0","1"),
("12078","Lotnictwo","3727","7","0","1"),
("12079","Piechota","3727","10","0","1"),
("12080","Fortyfikacje","3727","3","0","1"),
("12081","Odznaki i odznaczenia","3727","9","0","1"),
("12082","Umundurowanie","3727","12","0","1"),
("12083","Umundurowanie i Wyposażenie","691","8","0","0"),
("12086","Niemcy","12083","3","0","0"),
("12087","do 1918","12086","0","0","1"),
("12088","1918 - 1945","12086","1","0","0"),
("12089","po 1945","12086","2","0","0"),
("12091","Polska","12083","4","0","0"),
("12092","do 1939","12091","0","0","0"),
("12093","PSZ na Zachodzie i Ruch Oporu","12091","4","0","1"),
("12095","po 1990","12091","3","0","0"),
("12097","Rosja i ZSRR","12083","5","0","0"),
("12098","USA","12083","6","0","0"),
("12099","Umundurowanie","12098","0","0","0"),
("12100","Wyposażenie","12098","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12104","Austro-Węgry","12083","0","0","1"),
("12105","Pozostałe","12083","9","0","0"),
("12106","do 1945","12105","0","0","1"),
("12107","po 1945","12105","1","0","0"),
("12172","Umundurowanie i insygnia","12088","0","0","1"),
("12173","Wyposażenie","12088","1","0","1"),
("12174","Umundurowanie i insygnia","12089","0","0","1"),
("12175","Wyposażenie","12089","1","0","1"),
("12176","Umundurowanie","12107","0","0","1"),
("12177","Wyposażenie","12107","1","0","1"),
("12180","Umundurowanie","12095","0","0","1"),
("12181","Wyposażenie","12095","1","0","1"),
("12197","Islam","85","6","0","0"),
("12198","XVIII wiek i starsze","12197","0","0","1"),
("12199","XIX wiek","12197","1","0","1"),
("12200","XX wiek","12197","2","0","1"),
("12201","Kapsle","956","0","0","0"),
("12202","Porcelanki","956","1","0","1"),
("12233","Do LG","351","2","0","1"),
("12363","Pisanki","11995","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12364","Koszyczki i stroiki","11995","2","0","1"),
("12365","Figurki","11995","0","0","1"),
("12366","Kartki świąteczne","11995","1","0","1"),
("12367","Pozostałe","11995","5","0","1"),
("12393","Polskie","955","0","0","1"),
("12394","Zagraniczne","955","1","0","1"),
("12395","Polskie","954","0","0","1"),
("12396","Zagraniczne","954","1","0","1"),
("12399","Chevrolet","4029","12","0","0"),
("12400","Chrysler","4029","13","0","0"),
("12401","Daihatsu","4029","17","0","0"),
("12402","Dodge","4029","18","0","0"),
("12403","Isuzu","4029","26","0","0"),
("12404","Jeep","4029","28","0","0"),
("12405","Land Rover","4029","32","0","0"),
("12406","Lexus","4029","33","0","0"),
("12407","Plymouth","4029","49","0","1"),
("12408","Pontiac","4029","51","0","0"),
("12409","Smart","4029","60","0","0"),
("12410","UAZ","4029","69","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12413","Pozostałe","4030","21","0","1"),
("12414","33","4030","0","0","1"),
("12415","75","4030","1","0","1"),
("12416","145","4030","2","0","1"),
("12417","146","4030","3","0","1"),
("12418","147","4030","4","0","1"),
("12419","155","4030","5","0","1"),
("12420","156","4030","6","0","1"),
("12421","164","4030","8","0","1"),
("12422","166","4030","9","0","1"),
("12423","GTV","4030","16","0","1"),
("12424","Pozostałe","4031","38","0","1"),
("12425","80","4031","0","0","0"),
("12426","100","4031","2","0","0"),
("12427","A2","4031","4","0","1"),
("12428","A3","4031","5","0","0"),
("12429","A4","4031","6","0","0"),
("12430","A6","4031","9","0","0"),
("12431","A8","4031","12","0","0"),
("12432","TT","4031","33","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12433","V8","4031","36","0","1"),
("12434","Pozostałe","4032","25","0","1"),
("12435","Seria 1","4032","0","0","0"),
("12436","Seria 3","4032","2","0","0"),
("12437","Seria 5","4032","4","0","0"),
("12438","Seria 7","4032","6","0","0"),
("12440","X3","4032","15","0","0"),
("12441","Z3","4032","21","0","1"),
("12442","Pozostałe","12399","34","0","1"),
("12443","Aveo","12399","3","0","1"),
("12444","Lacetti","12399","18","0","1"),
("12445","Evanda","12399","13","0","1"),
("12446","Astro","12399","1","0","1"),
("12447","Blazer","12399","4","0","1"),
("12448","Venture","12399","32","0","1"),
("12449","Pozostałe","12400","17","0","1"),
("12450","300M","12400","1","0","1"),
("12451","Neon","12400","7","0","1"),
("12452","PT Cruiser","12400","10","0","1"),
("12453","Sebring","12400","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12454","Stratus","12400","13","0","1"),
("12455","Voyager","12400","16","0","0"),
("12456","Pozostałe","4033","36","0","1"),
("12457","AX","4033","1","0","1"),
("12458","BX","4033","3","0","1"),
("12459","CX","4033","20","0","1"),
("12460","XM","4033","32","0","1"),
("12461","ZX","4033","35","0","1"),
("12462","C2","4033","5","0","1"),
("12463","C3","4033","6","0","0"),
("12464","C4","4033","10","0","0"),
("12465","C5","4033","15","0","0"),
("12466","Berlingo","4033","2","0","0"),
("12467","Saxo","4033","29","0","1"),
("12468","Xantia","4033","31","0","0"),
("12469","Xsara","4033","33","0","0"),
("12470","Xsara Picasso","4033","34","0","1"),
("12471","Pozostałe","4034","13","0","1"),
("12472","Espero","4034","0","0","1"),
("12473","Lanos","4034","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12474","Leganza","4034","5","0","1"),
("12475","Matiz","4034","6","0","1"),
("12476","Musso","4034","7","0","1"),
("12477","Nexia","4034","8","0","1"),
("12478","Nubira","4034","9","0","1"),
("12479","Tico","4034","12","0","1"),
("12480","Pozostałe","12402","18","0","1"),
("12481","RAM","12402","14","0","1"),
("12482","Caravan","12402","2","0","0"),
("12483","Pozostałe","12401","12","0","1"),
("12484","Feroza","12401","3","0","1"),
("12485","Charade","12401","1","0","1"),
("12486","Applause","12401","0","0","1"),
("12488","Barchetta","4035","7","0","1"),
("12489","Brava","4035","8","0","1"),
("12490","Bravo","4035","9","0","0"),
("12491","Croma","4035","12","0","0"),
("12492","Doblo","4035","13","0","0"),
("12493","Marea","4035","21","0","1"),
("12494","Multipla","4035","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12496","Panda","4035","24","0","0"),
("12498","Scudo","4035","29","0","1"),
("12499","Seicento","4035","31","0","1"),
("12500","Siena","4035","32","0","1"),
("12501","Stilo","4035","33","0","1"),
("12502","Tempra","4035","36","0","1"),
("12503","Tipo","4035","37","0","0"),
("12504","Ulysse","4035","38","0","1"),
("12505","Uno","4035","39","0","0"),
("12506","Pozostałe","4036","44","0","1"),
("12507","Escort","4036","8","0","0"),
("12508","Explorer","4036","10","0","1"),
("12509","Fiesta","4036","14","0","0"),
("12510","Focus","4036","15","0","0"),
("12511","Fusion","4036","17","0","1"),
("12512","Galaxy","4036","18","0","0"),
("12514","Mondeo","4036","24","0","0"),
("12515","Orion","4036","26","0","1"),
("12516","Probe","4036","27","0","0"),
("12517","Puma","4036","28","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12518","Scorpio","4036","30","0","0"),
("12519","Sierra","4036","31","0","0"),
("12520","Taunus","4036","34","0","1"),
("12521","Taurus","4036","35","0","1"),
("12523","Windstar","4036","43","0","1"),
("12524","Pozostałe","4037","22","0","1"),
("12525","Accord","4037","0","0","0"),
("12526","Civic","4037","2","0","0"),
("12527","Concerto","4037","3","0","1"),
("12528","CR-V","4037","4","0","0"),
("12529","CRX","4037","5","0","1"),
("12530","Legend","4037","13","0","1"),
("12531","Prelude","4037","17","0","1"),
("12532","Pozostałe","4038","30","0","1"),
("12533","Accent","4038","0","0","1"),
("12534","Atos","4038","1","0","1"),
("12535","Coupe","4038","2","0","1"),
("12536","Elantra","4038","3","0","0"),
("12537","Galloper","4038","4","0","1"),
("12538","Getz","4038","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12539","Lantra","4038","20","0","1"),
("12540","Pony","4038","22","0","1"),
("12541","Sonata","4038","24","0","1"),
("12542","Pozostałe","12403","3","0","1"),
("12543","Trooper","12403","2","0","1"),
("12544","Pozostałe","8641","8","0","1"),
("12545","XJ","8641","6","0","0"),
("12547","X-Type","8641","3","0","1"),
("12548","S-Type","8641","2","0","1"),
("12549","Pozostałe","12404","8","0","1"),
("12550","Cherokee","12404","0","0","0"),
("12551","Wrangler","12404","7","0","0"),
("12552","Pozostałe","8642","21","0","1"),
("12553","Carnival","8642","1","0","1"),
("12554","Clarus","8642","4","0","1"),
("12555","Pride","8642","11","0","1"),
("12556","Rio","8642","14","0","0"),
("12557","Sephia","8642","15","0","1"),
("12558","Shuma","8642","16","0","1"),
("12559","Sportage","8642","19","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12560","Pozostałe","4039","11","0","1"),
("12561","Dedra","4039","0","0","1"),
("12562","Delta","4039","1","0","1"),
("12563","Kappa","4039","2","0","1"),
("12564","Lybra","4039","3","0","1"),
("12565","Thema","4039","6","0","1"),
("12566","Ypsilon","4039","9","0","1"),
("12567","Pozostałe","12405","8","0","1"),
("12568","Freelander","12405","3","0","0"),
("12569","Discovery","12405","1","0","0"),
("12570","Range Rover","12405","4","0","0"),
("12571","Pozostałe","4040","26","0","1"),
("12572","121","4040","4","0","1"),
("12573","323","4040","5","0","0"),
("12574","626","4040","7","0","0"),
("12575","MX-3","4040","17","0","1"),
("12577","Pozostałe","4042","20","0","1"),
("12578","Carisma","4042","2","0","0"),
("12579","Colt","4042","3","0","0"),
("12580","Eclipse","4042","4","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12581","Galant","4042","5","0","0"),
("12582","Lancer","4042","9","0","0"),
("12583","Pajero","4042","13","0","0"),
("12584","Sigma","4042","15","0","1"),
("12585","Space Star","4042","18","0","0"),
("12586","Space Wagon","4042","19","0","1"),
("12587","Pozostałe","4043","40","0","1"),
("12588","100 NX","4043","0","0","1"),
("12589","200 SX","4043","1","0","1"),
("12590","Almera","4043","4","0","0"),
("12591","Maxima","4043","14","0","1"),
("12592","Micra","4043","15","0","0"),
("12593","Patrol","4043","21","0","0"),
("12594","Primera","4043","25","0","0"),
("12595","Serena","4043","32","0","1"),
("12596","Sunny","4043","33","0","0"),
("12597","Terrano","4043","34","0","0"),
("12598","Vanette","4043","37","0","1"),
("12599","Pozostałe","4044","32","0","1"),
("12600","Agila","4044","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12601","Ascona","4044","4","0","1"),
("12602","Astra","4044","5","0","0"),
("12603","Calibra","4044","6","0","1"),
("12604","Corsa","4044","10","0","0"),
("12605","Frontera","4044","12","0","0"),
("12606","Kadett","4044","16","0","0"),
("12607","Manta","4044","18","0","1"),
("12608","Meriva","4044","19","0","0"),
("12609","Monterey","4044","21","0","1"),
("12610","Omega","4044","23","0","0"),
("12611","Senator","4044","25","0","1"),
("12612","Signum","4044","26","0","1"),
("12613","Sintra","4044","27","0","1"),
("12614","Tigra","4044","28","0","0"),
("12615","Vectra","4044","29","0","0"),
("12616","Zafira","4044","31","0","0"),
("12617","Pozostałe","4045","37","0","1"),
("12618","106","4045","0","0","0"),
("12619","205","4045","3","0","1"),
("12620","206","4045","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12621","306","4045","11","0","1"),
("12622","307","4045","12","0","0"),
("12623","309","4045","16","0","1"),
("12624","405","4045","17","0","1"),
("12625","406","4045","18","0","1"),
("12626","407","4045","19","0","1"),
("12627","605","4045","21","0","1"),
("12628","607","4045","22","0","1"),
("12629","806","4045","23","0","1"),
("12630","807","4045","24","0","1"),
("12631","Partner","4045","34","0","0"),
("12633","Atu","4046","2","0","1"),
("12634","Caro","4046","4","0","1"),
("12635","Pozostałe","12408","8","0","1"),
("12636","Firebird","12408","1","0","1"),
("12637","Trans Sport","12408","6","0","1"),
("12638","Pozostałe","4047","30","0","1"),
("12639","5","4047","0","0","1"),
("12640","19","4047","1","0","0"),
("12641","21","4047","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12642","25","4047","3","0","1"),
("12643","Clio","4047","7","0","0"),
("12644","Espace","4047","8","0","0"),
("12645","Kangoo","4047","13","0","0"),
("12646","Laguna","4047","15","0","0"),
("12647","Megane","4047","18","0","0"),
("12648","Safrane","4047","20","0","1"),
("12649","Scenic","4047","21","0","0"),
("12650","Thalia","4047","24","0","1"),
("12651","Twingo","4047","26","0","0"),
("12652","Pozostałe","4048","26","0","1"),
("12653","25","4048","0","0","1"),
("12654","75","4048","2","0","1"),
("12660","Pozostałe","4049","4","0","1"),
("12661","900","4049","2","0","1"),
("12662","9000","4049","3","0","1"),
("12663","9-3","4049","0","0","0"),
("12664","9-5","4049","1","0","1"),
("12665","Pozostałe","4050","14","0","1"),
("12666","Alhambra","4050","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12667","Arosa","4050","3","0","1"),
("12668","Cordoba","4050","5","0","0"),
("12669","Ibiza","4050","7","0","0"),
("12670","Inca","4050","8","0","1"),
("12671","Leon","4050","9","0","0"),
("12672","Toledo","4050","13","0","0"),
("12673","Pozostałe","4051","12","0","1"),
("12674","Fabia","4051","1","0","0"),
("12675","Favorit","4051","2","0","1"),
("12676","Felicia","4051","3","0","1"),
("12677","Octavia","4051","6","0","0"),
("12678","Superb","4051","10","0","0"),
("12679","Pozostałe","4052","11","0","1"),
("12680","Impreza","4052","3","0","0"),
("12681","Legacy","4052","5","0","0"),
("12682","Forester","4052","2","0","0"),
("12683","Pozostałe","4053","16","0","1"),
("12684","Alto","4053","0","0","1"),
("12685","Baleno","4053","1","0","1"),
("12686","Samurai","4053","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12687","Swift","4053","10","0","0"),
("12688","Vitara","4053","13","0","0"),
("12689","Wagon R+","4053","14","0","1"),
("12690","Pozostałe","4054","37","0","1"),
("12691","Avensis","4054","3","0","0"),
("12692","Camry","4054","6","0","1"),
("12693","Carina","4054","7","0","0"),
("12694","Celica","4054","8","0","1"),
("12695","Corolla","4054","10","0","0"),
("12696","Land Cruiser","4054","17","0","0"),
("12697","Previa","4054","22","0","1"),
("12698","RAV4","4054","25","0","0"),
("12699","Starlet","4054","28","0","1"),
("12700","Supra","4054","29","0","1"),
("12701","Yaris","4054","35","0","0"),
("12702","Pozostałe","4055","32","0","1"),
("12703","Bora","4055","3","0","1"),
("12704","Corrado","4055","8","0","1"),
("12705","Garbus","4055","12","0","1"),
("12706","Golf","4055","13","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12707","Jetta","4055","16","0","0"),
("12708","Lupo","4055","17","0","1"),
("12709","New Beetle","4055","19","0","1"),
("12710","Passat","4055","20","0","0"),
("12711","Polo","4055","23","0","0"),
("12712","Scirocco","4055","24","0","1"),
("12713","Sharan","4055","25","0","0"),
("12714","Touareg","4055","27","0","0"),
("12715","Touran","4055","28","0","0"),
("12716","Vento","4055","31","0","1"),
("12718","Pozostałe","4056","21","0","1"),
("12719","V40","4056","7","0","0"),
("12720","S60","4056","3","0","0"),
("12721","V70","4056","10","0","0"),
("12722","S80","4056","5","0","0"),
("12723","Seria 200","4056","15","0","1"),
("12724","Seria 400","4056","17","0","1"),
("12725","Seria 700","4056","18","0","1"),
("12726","850","4056","20","0","1"),
("12727","Seria 900","4056","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12728","Pozostałe","4041","32","0","1"),
("12733","Klasa A","4041","0","0","0"),
("12734","Klasa C","4041","2","0","0"),
("12735","Klasa E","4041","3","0","0"),
("12736","ML","4041","19","0","0"),
("12737","Klasa S","4041","6","0","0"),
("12738","Klasa V","4041","7","0","0"),
("12739","CL","4041","8","0","0"),
("12740","CLK","4041","11","0","0"),
("12741","SL","4041","20","0","0"),
("12742","SLK","4041","22","0","0"),
("12743","F (1991-2002)","12602","0","0","1"),
("12744","G (1998-2009)","12602","1","0","1"),
("12745","H (2004-2014)","12602","2","0","1"),
("12746","A (1982-1993)","12604","0","0","1"),
("12747","B (1993-2000)","12604","1","0","1"),
("12748","C (2000-2006)","12604","2","0","1"),
("12749","A (1988-1995)","12615","0","0","1"),
("12750","B (1995-2002)","12615","1","0","1"),
("12751","C (2002-2008)","12615","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12752","A (1986-1994)","12610","0","0","1"),
("12753","B (1994-1999)","12610","1","0","1"),
("12754","B FL (1999-2003)","12610","2","0","1"),
("12755","I (1974-1983)","12706","0","0","1"),
("12756","II (1983-1992)","12706","1","0","1"),
("12757","III (1991-1998)","12706","2","0","1"),
("12758","IV (1997-2006)","12706","3","0","1"),
("12759","V (2003-2009)","12706","4","0","1"),
("12760","B2 (1981-1987)","12710","1","0","1"),
("12761","B3 (1988-1993)","12710","2","0","1"),
("12762","B4 (1993-1997)","12710","3","0","1"),
("12763","B5 (1996-2000)","12710","4","0","1"),
("12764","B6 (2005-2010)","12710","6","0","1"),
("12825","Akcesoria","1","4","0","0"),
("12837","Pozostałe","12825","4","0","1"),
("12838","Doskonalenie umysłu","175","28","0","1"),
("12844","Zestawy","5609","2","0","1"),
("12845","Płyty z gazety","175","29","0","1"),
("12919","Pozostałe","776","15","0","1"),
("12920","Nasiona","776","4","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("12922","Bulwy, cebulki, kłącza","776","1","0","1"),
("12953","Pozostałe","6058","15","0","1"),
("12954","Zestawy","6058","14","0","1"),
("12955","Chaos","6058","1","0","1"),
("12956","Bretonnia","6058","0","0","1"),
("12957","Dark Elves","6058","3","0","1"),
("12959","Dwarfs","6058","4","0","1"),
("12960","Empire","6058","5","0","1"),
("12961","High Elves","6058","6","0","1"),
("12962","Lizardmen","6058","7","0","1"),
("12963","Ogre Kingdoms","6058","8","0","1"),
("12964","Orcs and Goblins","6058","9","0","1"),
("12965","Skaven","6058","10","0","1"),
("12967","Wood Elves","6058","13","0","1"),
("13317","1930-1939","3630","2","0","1"),
("13318","1920-1929","3630","1","0","1"),
("13319","1918-1919 i lokalne","3630","0","0","1"),
("13348","Polisy i ubezpieczenia","1052","6","0","1"),
("13367","Czarnoprochowce","3690","1","0","0"),
("13368","Sporty drużynowe","3919","6","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13369","Pozostałe","13368","9","0","1"),
("13370","Baseball","13368","0","0","0"),
("13371","Koszykówka","13368","3","0","0"),
("13372","Piłka nożna","13368","4","0","0"),
("13373","Piłka ręczna","13368","5","0","0"),
("13374","Rugby","13368","6","0","0"),
("13375","Siatkówka","13368","7","0","0"),
("13376","Pozostałe","13370","3","0","1"),
("13377","Kije","13370","0","0","1"),
("13378","Rękawice","13370","2","0","1"),
("13379","Pozostałe","13371","4","0","1"),
("13380","Obuwie","13371","0","0","1"),
("13381","Odzież","13371","1","0","0"),
("13382","Piłki","13371","2","0","1"),
("13383","Pozostałe","13381","3","0","1"),
("13384","Komplety","13381","0","0","1"),
("13385","Koszulki","13381","1","0","1"),
("13386","Spodenki","13381","2","0","1"),
("13387","Pozostałe","13372","9","0","1"),
("13388","Akcesoria sędziowskie","13372","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13389","Literatura","13372","3","0","1"),
("13390","Obuwie","13372","4","0","0"),
("13391","Odzież","13372","5","0","0"),
("13392","Opaski i ochraniacze","13372","6","0","1"),
("13393","Piłki","13372","7","0","1"),
("13394","Pozostałe","13391","7","0","1"),
("13395","Getry","13391","2","0","1"),
("13396","Komplety","13391","3","0","1"),
("13397","Koszulki","13391","4","0","0"),
("13399","Spodenki","13391","6","0","1"),
("13400","Pozostałe","13373","4","0","1"),
("13401","Piłki","13373","3","0","1"),
("13402","Pozostałe","13374","3","0","1"),
("13403","Piłki","13374","2","0","1"),
("13404","Pozostałe","13375","4","0","1"),
("13405","Odzież","13375","1","0","0"),
("13406","Opaski i nakolanniki","13375","2","0","1"),
("13407","Piłki","13375","3","0","1"),
("13408","Sporty towarzyskie i rekreacja","3919","8","0","0"),
("13409","Pozostałe","13408","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13410","Bilard","13408","0","0","0"),
("13411","Pozostałe","13410","8","0","1"),
("13412","Bile","13410","1","0","1"),
("13413","Kije","13410","2","0","1"),
("13414","Stoły","13410","4","0","1"),
("13415","Bowling i kręgle","13408","1","0","0"),
("13416","Pozostałe","13415","1","0","1"),
("13417","Kule","13415","0","0","1"),
("13418","Dart","13408","3","0","0"),
("13419","Pozostałe","13418","2","0","1"),
("13420","Rzutki, groty, piórka","13418","0","0","1"),
("13421","Tablice","13418","1","0","1"),
("13422","Golf","13408","4","0","0"),
("13423","Pozostałe","13422","6","0","1"),
("13424","Kije","13422","0","0","0"),
("13425","Piłki","13422","3","0","1"),
("13522","Sporty walki","3919","9","0","0"),
("13523","Pozostałe","13522","5","0","1"),
("13524","Boks","13522","0","0","0"),
("13525","Szermierka","13522","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13526","Walki wschodu","13522","3","0","0"),
("13527","Pozostałe","13524","6","0","1"),
("13528","Kaski","13524","0","0","1"),
("13529","Rękawice","13524","4","0","1"),
("13530","Worki i gruszki treningowe","13524","5","0","1"),
("13531","Pozostałe","13526","5","0","1"),
("13533","Literatura i multimedia","13526","1","0","0"),
("13534","Odzież","13526","4","0","0"),
("13535","Sporty wodne","3919","10","0","0"),
("13536","Pozostałe","13535","10","0","1"),
("13537","Kajakarstwo","13535","0","0","0"),
("13538","Kitesurfing","13535","1","0","0"),
("13539","Nurkowanie","13535","2","0","0"),
("13540","Pływanie","13535","3","0","0"),
("13541","Windsurfing","13535","7","0","0"),
("13542","Żeglarstwo","13535","8","0","0"),
("13543","Pozostałe","13537","3","0","1"),
("13544","Kajaki","13537","0","0","1"),
("13545","Pozostałe","13538","15","0","1"),
("13546","Deski","13538","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13547","Latawce","13538","7","0","1"),
("13548","Trapezy","13538","13","0","1"),
("13549","Pozostałe","13539","17","0","1"),
("13550","Automaty oddechowe","13539","1","0","1"),
("13552","Buty","13539","5","0","1"),
("13553","Fajki, maski, płetwy","13539","6","0","0"),
("13554","Jackety","13539","7","0","1"),
("13555","Literatura","13539","9","0","1"),
("13556","Noże","13539","10","0","1"),
("13557","Oświetlenie","13539","11","0","1"),
("13558","Rękawice","13539","12","0","0"),
("13559","Skafandry","13539","13","0","1"),
("13560","Sprzęt pomiarowy","13539","14","0","0"),
("13561","Torby","13539","15","0","1"),
("13562","Pozostałe","13560","4","0","1"),
("13563","Komputery","13560","2","0","1"),
("13564","Pozostałe","13540","12","0","1"),
("13565","Czepki","13540","1","0","1"),
("13566","Okulary pływackie","13540","4","0","1"),
("13567","Rękawki, deski i koła dmuchane","13540","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13568","Stroje pływackie","13540","7","0","0"),
("13571","Pozostałe","13541","12","0","1"),
("13572","Bomy","13541","0","0","1"),
("13573","Deski","13541","1","0","1"),
("13574","Literatura","13541","3","0","1"),
("13575","Maszty","13541","4","0","1"),
("13576","Odzież","13541","6","0","0"),
("13577","Stateczniki","13541","8","0","1"),
("13578","Trapezy","13541","10","0","1"),
("13579","Żagle","13541","11","0","1"),
("13580","Pozostałe","13576","4","0","1"),
("13581","Koszulki","13576","1","0","1"),
("13583","Pianki","13576","2","0","1"),
("13584","Spodenki","13576","3","0","1"),
("13585","Pozostałe","13542","11","0","1"),
("13587","Literatura","13542","3","0","0"),
("13588","Liny","13542","2","0","0"),
("13589","Odzież","13542","6","0","0"),
("13590","Osprzęt jachtowy","13542","7","0","0"),
("13591","Pozostałe","13587","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13592","Książki","13587","0","0","1"),
("13593","Mapy","13587","1","0","1"),
("13599","Sporty zimowe","3919","11","0","0"),
("13600","Pozostałe","13599","15","0","1"),
("13602","Łyżwiarstwo","13599","7","0","0"),
("13638","Tenis i pokrewne","3919","12","0","0"),
("13639","Pozostałe","13638","4","0","1"),
("13640","Badminton","13638","0","0","1"),
("13641","Squash","13638","1","0","0"),
("13642","Tenis stołowy","13638","2","0","0"),
("13643","Tenis ziemny","13638","3","0","0"),
("13644","Pozostałe","13641","9","0","1"),
("13645","Rakiety","13641","6","0","1"),
("13646","Pozostałe","13642","5","0","1"),
("13647","Piłeczki","13642","2","0","1"),
("13648","Rakietki","13642","3","0","1"),
("13649","Stoły","13642","4","0","1"),
("13650","Pozostałe","13643","8","0","1"),
("13651","Naciągi","13643","0","0","1"),
("13652","Odzież","13643","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13653","Owijki","13643","3","0","1"),
("13654","Piłki","13643","4","0","1"),
("13655","Rakiety","13643","5","0","1"),
("13656","Pozostałe","13652","3","0","1"),
("13657","Koszulki","13652","0","0","1"),
("13659","Spodenki","13652","1","0","1"),
("13660","Spódniczki","13652","2","0","1"),
("13712","Szaliki","3923","13","0","0"),
("13713","Pozostałe","13712","3","0","1"),
("13714","Kluby polskie","13712","0","0","1"),
("13715","Kluby zagraniczne","13712","1","0","1"),
("13716","Reprezentacje","13712","2","0","1"),
("13836","Pozostałe","383","2","0","1"),
("13837","Niemcy","383","1","0","1"),
("13838","Polska i powiązane","383","0","0","0"),
("13839","Pozostałe","385","3","0","1"),
("13840","Fantazyjne","385","1","0","1"),
("13841","Kopie i faksymile","385","0","0","1"),
("13842","1939 - 1941","381","3","0","1"),
("13843","od 1994","381","6","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("13844","do 1915","381","0","0","1"),
("13845","1916 - 1924 marki i ruble","381","1","0","1"),
("13846","Pewex i Baltona","381","7","0","1"),
("13919","Rosja carska","12097","0","0","1"),
("13920","ZSRR i Rosja od 1991","12097","1","0","1"),
("14053","Odzież","13374","1","0","0"),
("14054","Pozostałe","14053","2","0","1"),
("14055","Koszulki","14053","1","0","1"),
("14056","Bluzy","14053","0","0","1"),
("14057","Pozostałe","13405","1","0","1"),
("14058","Koszulki","13405","0","0","1"),
("14067","Pozostałe","13589","5","0","1"),
("14068","Czapki","13589","0","0","1"),
("14069","Koszulki i koszule","13589","1","0","1"),
("14070","Kurtki i spodnie","13589","2","0","1"),
("14071","Rękawice","13589","3","0","1"),
("14074","Pozostałe","13602","1","0","1"),
("14075","Łyżwy","13602","0","0","0"),
("14080","Siatki","13643","6","0","1"),
("14081","Torby i pokrowce","13643","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14087","Pozostałe","91","13","0","1"),
("14088","Monety keszowe Cash","91","0","0","1"),
("14089","Chiny","91","2","0","0"),
("14090","Japonia","91","8","0","1"),
("14091","Indie","91","3","0","0"),
("14092","do 1949","14089","0","0","1"),
("14093","po 1949","14089","1","0","1"),
("14167","Anteny","709","1","0","1"),
("14168","300 mm ","1322","7","0","1"),
("14172","Transmitery","709","10","0","1"),
("14174","Procesory dźwięku","709","8","0","1"),
("14175","Fabryczne","5185","9","0","0"),
("14176","Fabryczne","5186","9","0","1"),
("14177","Fabryczne","5188","10","0","1"),
("14178","Grundig","5188","3","0","1"),
("14182","Fabryczne","715","8","0","1"),
("14183","Clarion","715","2","0","1"),
("14184","Uszkodzone","709","13","0","1"),
("14201","Stacje pogody","1328","3","0","1"),
("14202","Translatory","1328","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14204","Termometry","1328","4","0","1"),
("14206","Torby, futerały","8785","11","0","1"),
("14207","Uszkodzone","8785","14","0","1"),
("14208","Literatura i instrukcje","8785","13","0","1"),
("14213","Nadajniki TV","717","5","0","1"),
("14215","Stoliki, uchwyty, półki","717","12","0","0"),
("14216","Sprzęt naziemny","717","11","0","0"),
("14217","Grundig","337","3","0","1"),
("14218","LG","337","5","0","1"),
("14219","Manta","337","6","0","1"),
("14220","Onkyo","337","8","0","1"),
("14221","Philips","337","10","0","1"),
("14222","Samsung","337","12","0","1"),
("14223","Wiwa, Bellwood","337","15","0","1"),
("14226","Urządzenia","5111","0","0","0"),
("14227","Akcesoria","5111","1","0","0"),
("14237","Kamery","5119","2","0","1"),
("14238","Akcesoria","5119","0","0","1"),
("14239","Rejestratory","5119","5","0","1"),
("14240","Monitory","5119","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14241","LCD","5120","1","0","0"),
("14270","Inni producenci","5232","13","0","1"),
("14271","Onkyo","5232","6","0","1"),
("14272","Pioneer","5232","7","0","1"),
("14273","Sony","5232","10","0","1"),
("14274","Technics","5232","11","0","1"),
("14275","Yamaha","5232","12","0","1"),
("14276","Polskie","5232","8","0","1"),
("14277","Inni producenci","5233","12","0","1"),
("14278","Denon","5233","2","0","1"),
("14279","Harman Kardon","5233","3","0","1"),
("14280","Onkyo","5233","6","0","1"),
("14281","Pioneer","5233","8","0","1"),
("14282","Sony","5233","9","0","1"),
("14283","Technics","5233","10","0","1"),
("14284","Yamaha","5233","11","0","1"),
("14285","Podstawy, stojaki","1320","1","0","1"),
("14286","Uszkodzone","1320","2","0","1"),
("14310","Radia","11","12","0","1"),
("14316","Analogowe","16","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14317","Cyfrowe","16","1","0","0"),
("14328","Uszkodzone","11","18","0","1"),
("14432","Inne modele","10539","54","0","1"),
("14455","8800","4978","69","0","1"),
("14473","K750i","5044","6","0","1"),
("14508","Smycze, flash stickery, breloki","348","17","0","0"),
("14569","Bezpieczeństwo","68","0","0","0"),
("14570","Inni producenci","4481","4","0","1"),
("14572","LiteOn","4481","1","0","1"),
("14573","LG","4481","0","0","1"),
("14574","NEC","4481","2","0","1"),
("14577","Toshiba, Samsung","4481","3","0","1"),
("14592","WP do 1939","3768","3","0","1"),
("14593","PSZ na Zachodzie i Ruch Oporu","3768","2","0","1"),
("14594","LWP","3768","0","0","1"),
("14595","USA","3733","5","0","1"),
("14596","Obozy jenieckie","3768","1","0","1"),
("14604","Niemcy","3741","0","0","1"),
("14605","Francja","3733","1","0","1"),
("14635","Camaro","12399","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14636","Corvette","12399","9","0","1"),
("14637","Lumina","12399","19","0","1"),
("14638","300C","12400","0","0","1"),
("14639","Pacifica","12400","9","0","1"),
("14640","Evasion","4033","25","0","1"),
("14641","Stratus","12402","16","0","1"),
("14642","Albea","4035","6","0","1"),
("14643","Aerostar","4036","0","0","1"),
("14644","Mustang","4036","25","0","1"),
("14645","Cougar","4036","3","0","1"),
("14647","FR-V","4037","8","0","1"),
("14648","HR-V","4037","9","0","0"),
("14649","Jazz","4037","12","0","0"),
("14651","Santa Fe","4038","23","0","0"),
("14652","Liberty","12404","4","0","1"),
("14653","Picanto","8642","10","0","0"),
("14654","Sorento","8642","17","0","0"),
("14655","Pozostałe","12406","11","0","1"),
("14656","GS","12406","2","0","0"),
("14657","SC","12406","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14658","RX","12406","9","0","0"),
("14659","MX-5","4040","18","0","1"),
("14660","MX-6","4040","19","0","1"),
("14661","MPV","4040","16","0","1"),
("14662","Outlander","4042","12","0","0"),
("14663","Space Runner","4042","17","0","1"),
("14664","Altima","4043","6","0","1"),
("14665","Murano","4043","16","0","0"),
("14666","Pozostałe","8644","11","0","1"),
("14667","911","8644","2","0","0"),
("14668","924","8644","3","0","1"),
("14669","944","8644","5","0","1"),
("14670","Cayenne","8644","7","0","0"),
("14671","Modus","4047","19","0","1"),
("14672","Altea","4050","1","0","1"),
("14673","Phaeton","4055","22","0","1"),
("14674","XC 90","4056","14","0","0"),
("14675","Hyundai","590","8","0","1"),
("14676","Opel","590","18","0","1"),
("14677","Nissan","590","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14678","Seat","590","22","0","1"),
("14679","Mitsubishi","590","15","0","1"),
("14680","Kia","590","11","0","1"),
("14681","Daewoo/Lublin","590","3","0","1"),
("14682","Toyota","590","24","0","1"),
("14683","Skoda","590","23","0","1"),
("14684","Mazda","590","13","0","1"),
("14685","Autobusy","149","0","0","1"),
("14686","Pozostałe","589","12","0","1"),
("14735","Okładziny","13642","1","0","1"),
("14736","Deski","13642","0","0","1"),
("14737","Bluzy","13391","0","0","1"),
("14742","Torby i wózki","13422","5","0","1"),
("14818","ZSRR 1923 - 1991","3624","1","0","1"),
("14819","Rosja do 1923","3624","0","0","1"),
("14820","Rosja po 1992","3624","2","0","1"),
("14821","Powiązane z Rosją","3624","3","0","1"),
("14892","Pozostałe","3639","6","0","1"),
("14893","Ssaki","3639","0","0","1"),
("14894","Ptaki","3639","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("14895","Ryby","3639","2","0","1"),
("14896","Owady","3639","3","0","1"),
("14897","Gady i Płazy","3639","4","0","1"),
("14898","Zwierzęta wymarłe","3639","5","0","1"),
("14899","Motoryzacja","414","8","0","1"),
("14900","Pozostałe","84","3","0","1"),
("14901","Revenue","84","0","0","1"),
("14902","Fałszerstwa","84","1","0","1"),
("14903","Zbiory i kolekcje","3653","0","0","1"),
("14904","Zestawy i serie","3653","1","0","1"),
("14919","Losy loteryjne","1052","5","0","1"),
("14954","3510i","4978","40","0","1"),
("14958","N70","4978","96","0","1"),
("15051","Polska","3723","0","0","1"),
("15052","Pozostałe","3723","1","0","1"),
("15550","Chusty i apaszki","1487","1","0","1"),
("15557","Breloki","1487","0","0","1"),
("15561","Pozostałe","1492","3","0","1"),
("15575","adidas","5545","1","0","1"),
("15576","Converse","5545","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("15577","Puma","5545","20","0","1"),
("15578","Nike","5545","19","0","1"),
("15579","Reebok","5545","21","0","1"),
("15580","Pozostałe","5545","27","0","1"),
("15581","adidas","5546","1","0","1"),
("15582","Converse","5546","6","0","1"),
("15583","Nike","5546","21","0","1"),
("15584","Puma","5546","22","0","1"),
("15585","Reebok","5546","23","0","1"),
("15586","Pozostałe","5546","30","0","1"),
("15587","Domowe","532","0","0","1"),
("15597","Sound Blaster X-Fi","4397","1","0","1"),
("15674","Urządzenia VOIP","240","6","0","0"),
("15675","Telefony","15674","1","0","1"),
("15676","Bramki","15674","0","0","1"),
("15677","Pozostałe","15674","2","0","1"),
("15688","6230i","4978","53","0","1"),
("15689","6310i","4978","58","0","1"),
("15703","Polskie","12201","0","0","1"),
("15704","Zagraniczne","12201","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("15778","Pieczęcie","94","2","0","1"),
("15779","Plomby","94","3","0","1"),
("15821","Internet","2","5","0","0"),
("15822","Bannery, buttony, billboardy","15821","0","0","1"),
("15823","Domeny","15821","1","0","0"),
("15825","Serwisy internetowe","15821","5","0","1"),
("15827","Pozostałe","15821","8","0","1"),
("15828","400 - 490W","4561","2","0","1"),
("15829","500 - 590W","4561","1","0","1"),
("15830","Do 390W","4561","3","0","1"),
("15941","Pozostałe","242","2","0","1"),
("15946","Inne marki","456","8","0","1"),
("15947","Siemens","456","5","0","1"),
("15948","Panasonic","456","2","0","1"),
("15949","Sagem","456","4","0","1"),
("15950","Motorola","456","1","0","1"),
("15951","Philips","456","3","0","1"),
("15952","Uszkodzone","456","9","0","1"),
("15957","Ogrodzenia i bramy","1520","9","0","0"),
("15958","Drzwi","1520","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("15959","Okna i parapety","1520","11","0","0"),
("15960","Podłogi","1520","12","0","0"),
("15961","Pozostałe","1523","10","0","1"),
("15962","Kable i przewody","1523","4","0","1"),
("15963","Dzwonki","1523","2","0","1"),
("15964","Alarmy","1523","0","0","0"),
("15971","Pozostałe","1524","3","0","1"),
("15973","Lustra","123","5","0","1"),
("15974","Pozostałe","5328","24","0","1"),
("15977","Noże  i nożyce kuchenne","5328","12","0","0"),
("15978","Garnki i patelnie","5328","6","0","0"),
("15979","Pojemniki kuchenne","5328","13","0","1"),
("15981","Firanki","9016","1","0","0"),
("15982","Zasłony","9016","6","0","0"),
("15983","Karnisze","9016","3","0","1"),
("15984","Rolety","9016","5","0","1"),
("15985","Pozostałe","9016","8","0","1"),
("15986","Komplety pościeli","9017","2","0","1"),
("15987","Kołdry","9017","1","0","1"),
("15988","Poduszki","9017","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("15989","Prześcieradła","9017","6","0","1"),
("15990","Koce i narzuty","9017","0","0","1"),
("15995","Pozostałe","9017","7","0","1"),
("15996","Poszewki","9017","5","0","1"),
("15997","Pozostałe","9317","15","0","1"),
("15998","Koty","1530","3","0","1"),
("15999","Konie i kuce","1530","2","0","1"),
("16000","Ptaki","1530","6","0","0"),
("16002","Figurki i rzeźby","9317","0","0","1"),
("16005","Witraże","9317","14","0","1"),
("16008","Sztuczne kwiaty i owoce","9317","11","0","1"),
("16011","Pokarmy","1118","10","0","0"),
("16022","Rośliny pokojowe","776","9","0","1"),
("16024","Żonglerka","13408","10","0","0"),
("16025","Pozostałe","16024","7","0","1"),
("16026","Diabola","16024","0","0","1"),
("16027","Kije, Sticki","16024","2","0","1"),
("16028","Poi","16024","5","0","1"),
("16029","Maczugi","16024","3","0","1"),
("16030","YoYo","16024","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16031","Piłeczki, footbagi, zośki","16024","4","0","1"),
("16032","Dyski, frisbee, bumerangi","16024","1","0","1"),
("16168","Nowe brzmienia","175","17","0","0"),
("16169","Downtempo, Trip-hop, D\'n\'B, Breaks","16168","0","0","1"),
("16170","IDM, Experimental, Post-techno","16168","1","0","1"),
("16171","Pozostałe","16168","2","0","1"),
("16172","Minimal, Detroit, Niekomercyjne","184","0","0","1"),
("16173","Trance","184","1","0","1"),
("16174","Pozostałe","184","2","0","1"),
("16175","Rock","10829","3","0","1"),
("16176","Pop","10829","2","0","1"),
("16177","Awangarda","10829","0","0","1"),
("16178","Dark, Industrial, Gotyk","10829","1","0","1"),
("16179","Pozostałe","10829","4","0","1"),
("16180","1970 i starsze","9545","0","0","1"),
("16181","1971-1980","9545","1","0","1"),
("16182","1981-1990","9545","2","0","1"),
("16183","1991-2000","9545","3","0","1"),
("16184","2001 i młodsze","9545","4","0","1"),
("16185","1970 i starsze","5613","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16186","1971-1980","5613","1","0","1"),
("16187","1981-1990","5613","2","0","1"),
("16188","1991-2000","5613","3","0","1"),
("16189","2001 i młodsze","5613","4","0","1"),
("16190","Polski","1362","0","0","1"),
("16191","Zagraniczny","1362","1","0","1"),
("16197","Polski","281","0","0","1"),
("16198","Zagraniczny","281","1","0","1"),
("16203","Rap, Hip-Hop","5611","4","0","1"),
("16204","Techno, Trance","5611","7","0","1"),
("16205","Muzyka alternatywna","5611","2","0","1"),
("16216","Pozostałe","8760","6","0","1"),
("16217","Aparatury","8760","4","0","1"),
("16218","Motocykle","1061","4","0","1"),
("16222","Artefakty","339","2","0","1"),
("16223","Białoruś","87","2","0","1"),
("16224","Watykan","87","15","0","1"),
("16225","Hiszpania i Portugalia","87","6","0","1"),
("16226","Węgry","87","16","0","1"),
("16227","Rumunia i Bułgaria","87","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16228","Albumy i klasery","1082","0","0","1"),
("16229","Holdery","1082","1","0","1"),
("16230","Kuferki i kasety","1082","3","0","1"),
("16231","Wagi","1082","5","0","1"),
("16232","Konserwacja","1082","6","0","1"),
("16233","Kapsle i pudełka","1082","2","0","1"),
("16234","Lupy","1082","4","0","1"),
("16235","Pozostałe","1082","7","0","1"),
("16236","2GB","8904","1","0","1"),
("16239","2GB","8905","1","0","1"),
("16240","1GB","8906","1","0","1"),
("16241","2GB","8906","2","0","1"),
("16242","SD/miniSD/SDHC","8848","7","0","0"),
("16249","2GB","16242","1","0","1"),
("16250","1GB","8908","1","0","1"),
("16251","TransFlash/microSD","8848","9","0","0"),
("16274","Zestawy","8853","8","0","1"),
("16278","Konwertery","8847","11","0","0"),
("16284","Minilaby","8847","14","0","0"),
("16300","Stoliki","14215","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16301","Uchwyty","14215","3","0","1"),
("16302","Półki","14215","1","0","1"),
("16307","Karty DVR","5119","3","0","1"),
("16319","Inny producent","4363","3","0","1"),
("16320","Labtec","4363","1","0","1"),
("16321","Logitech","4363","2","0","1"),
("16322","Creative","4363","0","0","1"),
("16330","Mikrofony","4398","0","0","1"),
("16331","Telefony USB i VoIP","4398","3","0","1"),
("16344","Duel Masters","6049","3","0","1"),
("16414","Rowery i akcesoria","3919","3","0","0"),
("16415","Akcesoria","16414","1","0","0"),
("16416","Części","16414","2","0","0"),
("16418","Literatura, instrukcje","16414","9","0","1"),
("16419","Narzędzia i smary","16414","4","0","0"),
("16420","Rowery","16414","0","0","0"),
("16421","Pozostałe","16414","10","0","1"),
("16424","Błotniki","16415","2","0","1"),
("16425","Foteliki","16415","4","0","1"),
("16426","Liczniki","16415","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16427","Oświetlenie","16415","10","0","1"),
("16428","Pompki","16415","13","0","1"),
("16430","Zabezpieczenia","16415","20","0","1"),
("16431","Pozostałe","16415","21","0","1"),
("16433","Chwyty","16416","1","0","1"),
("16434","Hamulce","16416","2","0","0"),
("16436","Koła","16416","5","0","0"),
("16437","Obręcze","16416","12","0","1"),
("16438","Szprychy","16416","20","0","1"),
("16440","Suporty","16416","19","0","1"),
("16442","Mostki","16416","11","0","0"),
("16445","Piasty","16416","13","0","1"),
("16446","Przerzutki","16416","14","0","0"),
("16447","Ramy","16416","15","0","1"),
("16448","Siodełka","16416","17","0","1"),
("16449","Stery","16416","18","0","1"),
("16450","Sztyce","16416","21","0","0"),
("16451","Zabytkowe","16416","23","0","1"),
("16452","Pozostałe","16416","24","0","1"),
("16453","Kierownice","16416","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16462","Rogi","16416","16","0","1"),
("16465","Pozostałe","16434","11","0","1"),
("16479","Pozostałe","16420","19","0","1"),
("16480","BMX","16420","0","0","1"),
("16481","Dziecięce","16420","4","0","1"),
("16482","Miejskie","16420","8","0","1"),
("16483","MTB (górskie)","16420","9","0","1"),
("16484","Szosowe","16420","14","0","1"),
("16485","Trekkingowe","16420","16","0","1"),
("16486","Zabytkowe","16420","18","0","1"),
("16513","Snowkiting","13599","14","0","0"),
("16514","Pozostałe","16513","6","0","1"),
("16515","Buty","16513","0","0","1"),
("16516","Deski","16513","1","0","1"),
("16517","Latawce","16513","2","0","1"),
("16518","Odzież","16513","3","0","1"),
("16519","Trapezy","16513","4","0","1"),
("16520","Wiązania","16513","5","0","1"),
("16527","Nordic Walking","13408","6","0","0"),
("16528","Kije","16527","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16529","Pozostałe","16527","4","0","1"),
("16532","Akcesoria","13367","0","0","1"),
("16533","Broń","13367","1","0","1"),
("16535","PSZ na Zachodzie","3734","1","0","1"),
("16536","Rosja carska","3738","0","0","1"),
("16537","ZSRR i Rosja po 1991","3738","1","0","1"),
("16538","Rosja carska","3714","0","0","1"),
("16539","ZSRR i Rosja po 1991","3714","1","0","1"),
("16540","Straż miejska","3717","4","0","1"),
("16541","Służby graniczne","3717","3","0","1"),
("16542","Bractwa Kurkowe","3717","0","0","1"),
("16543","Rycerze","12068","0","0","0"),
("16544","Słowianie","12068","1","0","0"),
("16545","Wikingowie","12068","2","0","0"),
("16546","Pozostałe","12068","3","0","0"),
("16549","Nakrycia głowy","12083","2","0","0"),
("16550","Czapki","16549","0","0","1"),
("16551","Hełmy","16549","1","0","1"),
("16552","Wielka Brytania","12083","7","0","0"),
("16553","Francja","12083","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16554","do 1945","16553","0","0","1"),
("16555","po 1945","16553","1","0","1"),
("16556","do 1960","16552","0","0","1"),
("16557","po 1960","16552","1","0","0"),
("16558","WP na Wschodzie 1943 - 1945","12091","5","0","1"),
("16561","Dysk","4738","1","0","1"),
("16588","LG","349","3","0","1"),
("16618","HTC","165","13","0","0"),
("16619","Inne modele","16618","40","0","1"),
("16625","Uszkodzone","5054","5","0","1"),
("16626","Pozostałe","5060","8","0","1"),
("16627","Mikrofony","5060","4","0","1"),
("16628","Uchwyty i podstawy","5060","5","0","1"),
("16629","Wzmacniacze","5060","6","0","1"),
("16630","Filtry","5060","0","0","1"),
("16631","Zasilacze","5060","7","0","1"),
("16634","Pozostałe","5063","8","0","1"),
("16635","Anteny","5063","0","0","1"),
("16636","Kondensatory","5063","2","0","1"),
("16637","Kwarce i filtry","5063","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16638","Gniazda i złącza","5063","1","0","1"),
("16641","Piloty","4564","6","0","1"),
("16644","Rośliny wodne","776","11","0","1"),
("16645","Uszkodzone","4481","6","0","1"),
("16652","Hokej","13368","2","0","0"),
("16653","Kije","16652","0","0","1"),
("16654","Łyżwy","16652","1","0","1"),
("16655","Odzież","16652","3","0","0"),
("16656","Ochraniacze","16652","2","0","0"),
("16657","Pozostałe","16652","4","0","1"),
("16658","Bluzy","16655","0","0","1"),
("16660","Pozostałe","16655","2","0","1"),
("16661","Bilety kolekcjonerskie","3923","4","0","0"),
("16662","Pozostałe","16661","2","0","1"),
("16663","Piłka nożna","16661","0","0","0"),
("16664","Pozostałe","16663","4","0","1"),
("16665","Liga polska","16663","0","0","1"),
("16666","Ligi zagraniczne","16663","1","0","1"),
("16667","Spotkania pucharowe","16663","2","0","1"),
("16668","Spotkania reprezentacji","16663","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("16672","Naklejki (vlepki)","3923","8","0","1"),
("16684","Linki i pancerze","16416","10","0","1"),
("16686","Amortyzatory","16416","0","0","0"),
("16691","Pulsometry","16415","15","0","1"),
("16693","Widelce sztywne","16416","22","0","1"),
("16694","Tylne","16686","1","0","1"),
("16695","Przednie","16686","0","0","0"),
("16696","Przemysł","0","20","0","0"),
("16705","Pozostałe","16696","5","0","0"),
("17098","Pozostałe","16705","5","0","1"),
("17102","Recykling i wywóz śmieci","16705","2","0","0"),
("17103","Pozostałe","17102","5","0","1"),
("17104","Kontenery","17102","0","0","1"),
("17105","Maszyny do przerobu surow. wtórnych","17102","1","0","1"),
("17106","Pojemniki na surowce wtórne","17102","3","0","1"),
("17107","Pojemniki na odpady","17102","2","0","1"),
("17108","Zgniatarki do puszek","17102","4","0","1"),
("17109","Urządzenia i maszyny sprzątające","16705","4","0","0"),
("17110","Powierzchnie wewnętrzne","17109","0","0","0"),
("17111","Pozostałe","17110","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17112","Chemia","17110","1","0","1"),
("17113","Automaty szorujące","17110","0","0","1"),
("17114","Odkurzacze przemysłowe","17110","2","0","1"),
("17115","Polerki i szorowarki","17110","3","0","1"),
("17116","Powierzchnie zewnętrzne","17109","1","0","0"),
("17117","Pozostałe","17116","3","0","1"),
("17118","Myjki ciśnieniowe","17116","0","0","1"),
("17119","Odśnieżarki i pługi","17116","1","0","1"),
("17120","Zamiatarki","17116","2","0","1"),
("17121","Pielęgnacja zieleni miejskiej","16705","1","0","0"),
("17122","Pozostałe","17121","4","0","1"),
("17123","Kosiarki","17121","0","0","1"),
("17124","Rozsiewacze","17121","1","0","1"),
("17125","Sekatory mechaniczne","17121","2","0","1"),
("17126","Wykaszarki","17121","3","0","1"),
("17127","Służby bezpieczeństwa publicznego","16705","3","0","0"),
("17128","Pozostałe","17127","1","0","1"),
("17129","Sprzęt ratowniczy","17127","0","0","1"),
("17216","Broń","13526","0","0","1"),
("17217","Ochraniacze","13526","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17218","Pozostałe","13534","2","0","1"),
("17220","Kimona","13534","0","0","1"),
("17221","Pasy","13534","1","0","1"),
("17222","Multimedia","13533","2","0","1"),
("17223","Czasopisma","13533","0","0","1"),
("17224","Książki","13533","1","0","1"),
("17230","Akcesoria","13410","0","0","1"),
("17231","Lampy bilardowe","13410","3","0","1"),
("17234","Sukno","13410","5","0","1"),
("17235","Wieszaki i stojaki","13410","6","0","1"),
("17236","Gadżety","13410","7","0","1"),
("17244","Linki","15821","2","0","1"),
("17246","Szablony","15821","7","0","1"),
("17247","Reklamy pop-up i pop-under","15821","3","0","1"),
("17248","Krajowe","15823","1","0","1"),
("17249","Globalne","15823","0","0","1"),
("17250","Zagraniczne","15823","2","0","1"),
("17251","Subdomeny","15823","3","0","1"),
("17252","Papiery, folie","4578","6","0","0"),
("17253","Papiery Foto","17252","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17254","Folie, termotransfery","17252","1","0","1"),
("17255","Etykiety, naklejki","17252","0","0","1"),
("17256","Papier składany i w rolach","17252","2","0","1"),
("17257","Pozostałe","17252","4","0","1"),
("17271","Kufry","4690","2","0","1"),
("17272","Pokój dziecięcy","11763","7","0","0"),
("17273","Meble","17272","4","0","0"),
("17275","Krzesła i stoliki","17273","5","0","1"),
("17277","Pozostałe","17273","9","0","1"),
("17278","Dekoracje i ozdoby","17272","0","0","0"),
("17279","Dywany i firanki","17272","1","0","0"),
("17280","Pościel i kocyki","17272","6","0","0"),
("17283","Oświetlenie","17272","5","0","0"),
("17284","Pozostałe","17272","7","0","1"),
("17285","Zdrowie i higiena","11763","12","0","0"),
("17293","Termometry","17285","7","0","0"),
("17294","Kosmetyki","17285","2","0","0"),
("17295","Pieluszki i chusteczki","17285","4","0","0"),
("17298","Urządzenia medyczne","17285","8","0","0"),
("17299","Pozostałe","17285","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17305","Grzechotki i gryzaki","11820","4","0","1"),
("17307","Karuzele","11820","6","0","1"),
("17309","Do wózka","11820","2","0","1"),
("17310","Pozostałe","11820","14","0","1"),
("17524","HP","4623","2","0","1"),
("17525","Plustek","4623","4","0","1"),
("17526","Canon","4623","0","0","1"),
("17527","Epson","4623","1","0","1"),
("17528","Inni producenci","4623","5","0","1"),
("17529","Drukarki atramentowe","4589","0","0","1"),
("17530","Drukarki laserowe","4589","1","0","1"),
("17531","Skanery","4589","2","0","1"),
("17532","Pozostałe","4589","4","0","1"),
("17681","Mustek","4623","3","0","1"),
("17686","Części zamienne","8847","3","0","0"),
("17748","Zapachy dla kobiet","135","0","0","0"),
("17749","Zapachy dla mężczyzn","135","1","0","0"),
("17750","Pozostałe","17748","3","0","1"),
("17751","Dezodoranty","17748","0","0","1"),
("17752","Perfumy i wody perfumowane","17748","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17753","Wody toaletowe","17748","2","0","1"),
("17754","Pozostałe","17749","5","0","1"),
("17755","Dezodoranty","17749","0","0","1"),
("17756","Wody perfumowane","17749","1","0","1"),
("17757","Wody toaletowe","17749","2","0","1"),
("17758","Wody kolońskie","17749","3","0","1"),
("17759","Wody po goleniu","17749","4","0","1"),
("17863","Pozostałe","11823","15","0","1"),
("17865","LEGO","11823","8","0","0"),
("17867","Mega Bloks","11823","10","0","1"),
("17868","Playmobil","11823","11","0","1"),
("17870","Mieszane","17865","41","0","1"),
("17871","Bionicle","17865","4","0","1"),
("17872","Duplo","17865","13","0","1"),
("17873","Technic","17865","37","0","1"),
("17886","2001 - 2010","406","11","0","1"),
("17887","Pozostałe","3644","2","0","0"),
("17888","Obiekty i miejsca","3644","0","0","0"),
("17889","Osobowości","3644","1","0","0"),
("17890","Jan Paweł II","17889","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("17891","Pozostałe","17889","1","0","0"),
("17918","Karty maximum","9588","5","0","1"),
("17919","Karty maximum","9589","11","0","1"),
("17920","Karty maximum","9590","5","0","1"),
("17999","Kufle","953","4","0","0"),
("18000","Pokale","953","7","0","1"),
("18001","Ceramiczne","17999","0","0","1"),
("18002","Szklane","17999","1","0","1"),
("18003","Metalowe i inne","17999","2","0","1"),
("18004","Taniec","13408","9","0","0"),
("18005","Pozostałe","18004","3","0","1"),
("18006","Filmy i książki","18004","0","0","1"),
("18007","Obuwie","18004","1","0","1"),
("18008","Stroje","18004","2","0","1"),
("18009","Futbol amerykański","13368","1","0","0"),
("18010","Pozostałe","18009","4","0","1"),
("18011","Kaski i ochraniacze","18009","0","0","1"),
("18012","Piłki","18009","3","0","1"),
("18013","Odzież","18009","2","0","1"),
("18014","Korki","13390","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18015","Halowe","13390","0","0","1"),
("18026","Betonomieszarki","589","0","0","1"),
("18027","Ciągniki siodłowe","589","2","0","0"),
("18028","Chłodnie","589","1","0","1"),
("18029","Cysterny","589","3","0","1"),
("18030","Dźwigi samochodowe","589","5","0","1"),
("18031","Izotermy","589","6","0","1"),
("18032","Podnośniki koszowe","589","7","0","1"),
("18033","Skrzynie","589","8","0","1"),
("18034","Skrzynie z plandeką","589","9","0","1"),
("18035","Wymienne nadwozia","589","10","0","1"),
("18036","Wywrotki","589","11","0","1"),
("18037","Ciągniki","18027","0","0","0"),
("18038","Ciągniki z naczepą","18027","1","0","1"),
("18039","DAF","590","4","0","1"),
("18040","Gaz","590","7","0","1"),
("18050","159","4030","7","0","1"),
("18051","B4 (1991-1995)","12425","3","0","1"),
("18052","B3 (1986-1991)","12425","2","0","1"),
("18053","B2 (1978-1986)","12425","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18054","B1 (1972-1978)","12425","0","0","1"),
("18055","90","4031","1","0","0"),
("18056","B2 (1984-1986)","18055","0","0","1"),
("18057","B3 (1986-1991)","18055","1","0","1"),
("18058","C4 (1991-1994)","12426","3","0","1"),
("18059","C3 (1982-1991)","12426","2","0","1"),
("18060","C2 (1976-1982)","12426","1","0","1"),
("18061","C1 (1968-1976)","12426","0","0","1"),
("18062","8L (1996-2003)","12428","0","0","1"),
("18063","8P (2003-2012)","12428","1","0","1"),
("18064","B5 (1995-2001)","12429","0","0","1"),
("18065","B6 (2000-2004)","12429","1","0","1"),
("18066","B7 (2004-2007)","12429","2","0","1"),
("18067","C5 (1997-2004)","12430","1","0","1"),
("18068","C4 (1994-1997)","12430","0","0","1"),
("18069","C6 (2004-2011)","12430","2","0","1"),
("18070","D2 (1994-2002)","12431","0","0","1"),
("18071","D3 (2002-2010)","12431","1","0","1"),
("18073","Q7","4031","16","0","0"),
("18074","E36 (1990-1999)","12436","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18075","E21 (1975-1982)","12436","0","0","1"),
("18076","E30 (1982-1994)","12436","1","0","1"),
("18077","E46 (1998-2007)","12436","3","0","1"),
("18078","E90 (2005-2012)","12436","4","0","1"),
("18079","E34 (1988-1996)","12437","2","0","1"),
("18080","E12 (1972-1981)","12437","0","0","1"),
("18081","E28 (1981-1987)","12437","1","0","1"),
("18082","E39 (1996-2003)","12437","3","0","1"),
("18083","E60 (2003-2010)","12437","4","0","1"),
("18084","Seria 6","4032","5","0","0"),
("18085","E38 (1994-2001)","12438","2","0","1"),
("18086","E23 (1977-1986)","12438","0","0","1"),
("18087","E32 (1986-1994)","12438","1","0","1"),
("18088","E65/66 (2001-2008)","12438","3","0","1"),
("18089","X5","4032","17","0","0"),
("18090","Z4","4032","22","0","1"),
("18091","Aston Martin","4029","4","0","0"),
("18092","Buick","4029","9","0","1"),
("18093","Cadillac","4029","10","0","0"),
("18094","Avalanche","12399","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18095","Corsica","12399","8","0","1"),
("18096","Impala","12399","16","0","1"),
("18097","Silverado","12399","25","0","1"),
("18098","Concorde","12400","3","0","1"),
("18099","Crossfire","12400","4","0","1"),
("18100","Grand Voyager","12400","5","0","0"),
("18101","I (1990-1995)","18100","0","0","1"),
("18102","II (1995-2000)","18100","1","0","1"),
("18103","III (2001-2006)","18100","2","0","1"),
("18104","Saratoga","12400","11","0","1"),
("18105","Town & Country","12400","14","0","0"),
("18106","I (1995-2005)","18105","0","0","1"),
("18107","II (2001-)","18105","1","0","1"),
("18108","Vision","12400","15","0","1"),
("18109","I (1984-1995)","12455","0","0","1"),
("18110","II (1995-2000)","12455","1","0","1"),
("18111","III (2001-)","12455","2","0","1"),
("18112","C1","4033","4","0","0"),
("18113","C8","4033","17","0","1"),
("18114","I (1993-1998)","12468","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18115","II (1998-2001)","12468","1","0","1"),
("18116","I (1997-2001)","12469","0","0","1"),
("18117","II (2001-2004)","12469","1","0","1"),
("18118","Dacia","4029","15","0","0"),
("18119","Logan","18118","4","0","0"),
("18120","Pozostałe","18118","8","0","1"),
("18121","Korando","4034","2","0","1"),
("18122","Tacuma","4034","11","0","1"),
("18123","Cuore","12401","2","0","1"),
("18124","II (1995-2001)","12482","1","0","1"),
("18125","I (1990-1995)","12482","0","0","1"),
("18126","III (2001-)","12482","2","0","1"),
("18127","Dakota","12402","5","0","1"),
("18128","Durango","12402","7","0","1"),
("18129","Grand Caravan","12402","8","0","1"),
("18130","Intrepid","12402","9","0","1"),
("18131","Magnum","12402","11","0","1"),
("18132","Neon","12402","12","0","1"),
("18133","Stealth","12402","15","0","1"),
("18134","Ferrari","4029","19","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18135","Coupe","4035","11","0","1"),
("18136","Idea","4035","19","0","1"),
("18137","I (1985-1994)","12491","0","0","1"),
("18138","II (2005-)","12491","1","0","1"),
("18139","II (2003-2012)","12496","1","0","1"),
("18140","I (1980-2003)","12496","0","0","1"),
("18145","II (1989-)","12505","1","0","1"),
("18146","I (1983-1989)","12505","0","0","1"),
("18147","Mk7 (1995-1999)","12507","6","0","1"),
("18148","Mk6 (1992-1995)","12507","5","0","1"),
("18149","Mk5 (1990-1992)","12507","4","0","1"),
("18150","Mk4 (1986-1990)","12507","3","0","1"),
("18151","Mk3 (1980-1986)","12507","2","0","1"),
("18152","Mk2  (1975-1980)","12507","1","0","1"),
("18153","Mk1 (1968-1975)","12507","0","0","1"),
("18154","Expedition","4036","9","0","1"),
("18155","Mk4 (1996-1999)","12509","3","0","1"),
("18156","Mk6 (2002-2008)","12509","5","0","1"),
("18157","Mk3 (1989-1996)","12509","2","0","1"),
("18158","Mk2 (1983-1989)","12509","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18159","Mk1 (1977-1983)","12509","0","0","1"),
("18160","Mk1 (1998-2004)","12510","0","0","1"),
("18161","Mk2 (2004-2011)","12510","1","0","1"),
("18162","Focus C-Max","4036","16","0","1"),
("18163","Granada","4036","19","0","1"),
("18164","Mk1 (1995-2005)","12512","0","0","1"),
("18166","Mk2 (1996-2000)","12514","1","0","1"),
("18167","Mk1 (1993-1996)","12514","0","0","1"),
("18168","Mk3 (2000-2006)","12514","2","0","1"),
("18169","Mk1 (1985-1994)","12518","0","0","1"),
("18170","Mk2 (1994-1998)","12518","1","0","1"),
("18172","Mk2 (1987-1993)","12519","1","0","1"),
("18173","Mk1 (1982-1986)","12519","0","0","1"),
("18177","V (1993-1998)","12525","3","0","1"),
("18178","VI (1998-2002)","12525","4","0","1"),
("18179","VII (2002-2008)","12525","5","0","1"),
("18180","IV (1990-1993)","12525","2","0","1"),
("18181","III (1985-1989)","12525","1","0","1"),
("18182","II (1983-1985)","12525","0","0","1"),
("18183","City","4037","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18184","VI (1995-2001)","12526","4","0","1"),
("18185","VII (2001-2006)","12526","5","0","1"),
("18186","VIII (2006-2011)","12526","6","0","1"),
("18187","V (1991-1996)","12526","3","0","1"),
("18188","IV (1987-1991)","12526","2","0","1"),
("18189","III (1983-1987)","12526","1","0","1"),
("18190","II (1979-1983)","12526","0","0","1"),
("18191","Odyssey","4037","15","0","1"),
("18192","S2000","4037","19","0","1"),
("18193","Hummer","4029","23","0","0"),
("18195","Matrix","4038","21","0","1"),
("18196","Terracan","4038","25","0","1"),
("18197","Infiniti","4029","25","0","0"),
("18198","Campo","12403","0","0","1"),
("18200","II (1987-2001)","12550","0","0","1"),
("18201","III (2001-2008)","12550","1","0","1"),
("18202","Grand Cherokee","12404","3","0","0"),
("18203","I (1991-1999)","18202","0","0","1"),
("18204","II (1999-2004)","18202","1","0","1"),
("18205","III (2005-2010)","18202","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18206","Joice","8642","5","0","1"),
("18207","Musa","4039","4","0","1"),
("18208","Thesis","4039","7","0","1"),
("18209","Zeta","4039","10","0","1"),
("18210","Defender","12405","0","0","1"),
("18211","ES","12406","1","0","1"),
("18212","IS","12406","4","0","0"),
("18213","LS","12406","5","0","0"),
("18214","Lincoln","4029","35","0","0"),
("18215","Continental","18214","0","0","1"),
("18216","Mark","18214","1","0","1"),
("18217","Navigator","18214","2","0","1"),
("18218","Town Car","18214","3","0","1"),
("18219","Pozostałe","18214","4","0","1"),
("18220","Pozostałe","8643","4","0","1"),
("18221","2107","8643","1","0","1"),
("18222","Niva","8643","2","0","1"),
("18223","Samara","8643","3","0","1"),
("18224","Maserati","4029","37","0","0"),
("18225","2","4040","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18226","3","4040","1","0","0"),
("18227","VI (1998-2003)","12573","4","0","1"),
("18228","V (1994-1998)","12573","3","0","1"),
("18229","IV (1989-1994)","12573","2","0","1"),
("18230","III (1986-1989)","12573","1","0","1"),
("18231","II (1980-1986)","12573","0","0","1"),
("18232","323F","4040","6","0","0"),
("18233","I (1989-1994)","18232","0","0","1"),
("18234","II (1994-1998)","18232","1","0","1"),
("18235","III (1998-2003)","18232","2","0","1"),
("18236","5","4040","2","0","0"),
("18237","6","4040","3","0","0"),
("18238","929","4040","8","0","1"),
("18239","IV (1992-1997)","12574","3","0","1"),
("18240","V (1997-2001)","12574","4","0","1"),
("18241","III (1987-1992)","12574","2","0","1"),
("18242","II (1983-1987)","12574","1","0","1"),
("18243","I (1979-1982)","12574","0","0","1"),
("18244","Premacy","4040","20","0","1"),
("18245","RX-7","4040","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18246","RX-8","4040","22","0","1"),
("18247","Tribute","4040","24","0","1"),
("18248","W168 (1997-2004)","12733","0","0","1"),
("18249","W169 (2004-2012)","12733","1","0","1"),
("18250","Klasa B","4041","1","0","0"),
("18251","W202 (1993-2001)","12734","0","0","1"),
("18252","W203 (2000-2007)","12734","1","0","1"),
("18253","W210 (1995-2002)","12735","1","0","1"),
("18254","W211 (2002-2009)","12735","2","0","1"),
("18255","W163 (1998-2005)","12736","0","0","1"),
("18256","W164 (2005-2011)","12736","1","0","1"),
("18257","Klasa G","4041","4","0","0"),
("18258","W460 (1979-1992)","18257","0","0","1"),
("18259","W463 (1992-)","18257","1","0","1"),
("18260","Klasa R","4041","5","0","1"),
("18265","W140 (1992-1998)","12737","2","0","1"),
("18266","W220 (1998-2005)","12737","3","0","1"),
("18267","W221 (2005-2013)","12737","4","0","1"),
("18268","W116 (1972-1980)","12737","0","0","1"),
("18269","W126 (1980-1993)","12737","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18271","C140 (1992-1998)","12739","0","0","1"),
("18272","C215 (1999-2006)","12739","1","0","1"),
("18273","W208 (1997-2002)","12740","0","0","1"),
("18274","W209 (2002-)","12740","1","0","1"),
("18275","CLS","4041","12","0","0"),
("18276","R170 (1996-2004)","12742","0","0","1"),
("18277","R171 (2004-2011)","12742","1","0","1"),
("18278","R107 (1972-1989)","12741","0","0","1"),
("18279","R129 (1989-2000)","12741","1","0","1"),
("18280","R230 (2001-2012) ","12741","2","0","1"),
("18281","Mini","4029","43","0","0"),
("18282","3000GT","4042","0","0","1"),
("18283","CJ0 (1995-2003)","12579","4","0","1"),
("18284","Z30 (2004-2012)","12579","5","0","1"),
("18285","CA0 (1992-1995)","12579","3","0","1"),
("18286","C10 (1984-1988)","12579","1","0","1"),
("18287","A150 (1978-1983)","12579","0","0","1"),
("18288","II (1995-1999)","12580","1","0","1"),
("18289","I (1990-1995)","12580","0","0","1"),
("18290","III (1999-2006)","12580","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18291","VII (1992-1997)","12581","3","0","1"),
("18292","VIII (1996-2006)","12581","4","0","1"),
("18293","VI (1987-1992)","12581","2","0","1"),
("18294","V (1984-1988)","12581","1","0","1"),
("18295","IV (1980-1984)","12581","0","0","1"),
("18296","Grandis","4042","6","0","1"),
("18297","L200","4042","8","0","1"),
("18298","Space Gear","4042","16","0","1"),
("18299","V (1991-1996)","12582","3","0","1"),
("18300","II (1983-1984)","12582","0","0","1"),
("18301","III (1984-1988)","12582","1","0","1"),
("18302","IV (1988-1992)","12582","2","0","1"),
("18304","VI (1996-2003)","12582","4","0","1"),
("18306","VII (2003-2008)","12582","5","0","1"),
("18307","II (1990-2000)","12583","1","0","1"),
("18308","I (1982-1990)","12583","0","0","1"),
("18309","III (2000-2006)","12583","2","0","1"),
("18310","350 Z","4043","2","0","1"),
("18311","N15 (1995-2000)","12590","0","0","1"),
("18312","N16 (2000-2006)","12590","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18313","Almera Tino","4043","5","0","1"),
("18314","K11 (1992-2003)","12592","1","0","1"),
("18315","K10 (1982-1992)","12592","0","0","1"),
("18316","K12 (2003-2010)","12592","2","0","1"),
("18317","Navara","4043","17","0","1"),
("18318","Note","4043","18","0","0"),
("18319","GR I Y60 (1987-1997)","12593","0","0","1"),
("18320","Pozostałe","12593","2","0","1"),
("18321","GR II Y61 (1997-)","12593","1","0","1"),
("18322","Quest","4043","29","0","1"),
("18323","B13/N14 (1990-1995)","12596","2","0","1"),
("18325","B11 (1982-1987)","12596","0","0","1"),
("18326","B12/N13 (1986-1991)","12596","1","0","1"),
("18328","I (1987-1995)","12597","0","0","1"),
("18329","II (1995-)","12597","1","0","1"),
("18330","X-Trail","4043","39","0","0"),
("18331","Oldsmobile","4029","46","0","1"),
("18332","Campo","4044","7","0","1"),
("18333","Combo","4044","9","0","0"),
("18334","A (1992-1998)","12605","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18335","B (1998-2004)","12605","1","0","1"),
("18336","E (1984-1994)","12606","2","0","1"),
("18337","C (1973-1979)","12606","0","0","1"),
("18338","D (1979-1984)","12606","1","0","1"),
("18339","Rekord","4044","24","0","1"),
("18340","I (1994-2001)","12614","0","0","1"),
("18341","II (2004-2009)","12614","1","0","1"),
("18342","A (1999-2005)","12616","0","0","1"),
("18343","B (2005-2011)","12616","1","0","1"),
("18344","II (1996-2006)","12618","1","0","1"),
("18345","I (1991-1996)","12618","0","0","1"),
("18346","107","4045","1","0","1"),
("18347","1007","4045","25","0","1"),
("18348","I (2001-2005)","12622","0","0","1"),
("18349","II (2005-)","12622","1","0","1"),
("18350","Atu Plus","4046","3","0","1"),
("18351","Caro Plus","4046","5","0","1"),
("18352","Grand Am","12408","3","0","1"),
("18353","Grand Prix","12408","4","0","1"),
("18354","Sunfire","12408","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18355","Vibe","12408","7","0","1"),
("18356","928","8644","4","0","1"),
("18357","Boxster","8644","6","0","1"),
("18358","II (1992-1997)","12640","1","0","1"),
("18359","I (1988-1992)","12640","0","0","1"),
("18360","II (1998-2012)","12643","1","0","1"),
("18361","I (1990-1998)","12643","0","0","1"),
("18362","III (2005-2012)","12643","2","0","1"),
("18363","II (1991-1996)","12644","1","0","1"),
("18364","III (1997-2003)","12644","2","0","1"),
("18365","IV (2003-2014)","12644","3","0","1"),
("18366","I (1984-1991)","12644","0","0","1"),
("18367","I (1998-2008)","12645","0","0","1"),
("18369","I (1993-2001)","12646","0","0","1"),
("18370","II (2001-2007)","12646","1","0","1"),
("18372","I (1996-2002)","12647","0","0","1"),
("18373","II (2002-2008)","12647","1","0","1"),
("18374","I (1997-2003)","12649","0","0","1"),
("18375","II (2003-2009)","12649","1","0","1"),
("18376","Vel Satis","4047","28","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18377","45","4048","1","0","1"),
("18378","I (1993-1999)","12668","0","0","1"),
("18379","I FL (1999-2002)","12668","1","0","1"),
("18380","II (2002-2010)","12668","2","0","1"),
("18381","II (1993-1999)","12669","1","0","1"),
("18382","I (1985-1993)","12669","0","0","1"),
("18383","III (2002-2008)","12669","3","0","1"),
("18384","I (1999-2005)","12671","0","0","1"),
("18385","II (2005-2012)","12671","1","0","1"),
("18386","Marbella","4050","11","0","1"),
("18387","I (1991-1999)","12672","0","0","1"),
("18388","II (1999-2004)","12672","1","0","1"),
("18389","III (2004-2009)","12672","2","0","1"),
("18390","I (1996-2011)","12677","0","0","1"),
("18391","II (2004-2013)","12677","1","0","1"),
("18392","Pozostałe","12409","3","0","1"),
("18393","Forfour","12409","0","0","0"),
("18394","Fortwo","12409","1","0","0"),
("18395","Roadster","12409","2","0","1"),
("18396","SsangYong","4029","61","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18397","Pozostałe","18396","8","0","1"),
("18398","Korando","18396","1","0","1"),
("18399","Musso","18396","3","0","1"),
("18400","Rexton","18396","4","0","1"),
("18401","Ignis","4053","4","0","1"),
("18402","Liana","4053","7","0","1"),
("18403","II (1989-1996)","12687","1","0","1"),
("18405","I (1983-1989)","12687","0","0","1"),
("18406","IV (2004-2010)","12687","3","0","1"),
("18407","Tavria","4029","65","0","1"),
("18408","I (1997-2002)","12691","0","0","1"),
("18409","II (2003-2009)","12691","1","0","1"),
("18410","Avalon","4054","2","0","1"),
("18411","Avensis Verso","4054","4","0","1"),
("18412","Aygo","4054","5","0","0"),
("18413","E (1992-1997)","12693","1","0","1"),
("18414","II (1984-1992)","12693","0","0","1"),
("18415","Corolla Verso","4054","11","0","1"),
("18416","Hilux","4054","15","0","1"),
("18417","Paseo","4054","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18418","Picnic","4054","21","0","1"),
("18419","Prius","4054","23","0","0"),
("18420","Sienna","4054","27","0","1"),
("18421","Yaris Verso","4054","36","0","1"),
("18422","I (1994-2000)","12698","0","0","1"),
("18423","II (2000-2005)","12698","1","0","1"),
("18424","III (2006-2012)","12698","2","0","1"),
("18425","I (1999-2005)","12701","0","0","1"),
("18426","II (2005-2011)","12701","1","0","1"),
("18427","C70","4056","1","0","1"),
("18428","V50","4056","8","0","1"),
("18429","XC 70","4056","13","0","1"),
("18430","Pozostałe","594","9","0","1"),
("18500","Buggy","4079","0","0","1"),
("18501","Gokarty","4079","1","0","1"),
("18502","Wózki golfowe","4079","6","0","1"),
("18503","Poduszkowce","4079","3","0","1"),
("18505","Skutery śnieżne","4079","8","0","1"),
("18506","Skutery wodne","4079","9","0","1"),
("18508","Wiosłowe","4080","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18513","Kombi","4046","6","0","1"),
("18514","GC (1992-2001)","12680","0","0","1"),
("18515","GD (2001-2007)","12680","1","0","1"),
("18516","Fox","4055","11","0","1"),
("18517","Golf Plus","4055","14","0","1"),
("18518","A2 (1984-1992)","12707","1","0","1"),
("18519","A1 (1980-1984)","12707","0","0","1"),
("18520","A5 (2005-2010)","12707","2","0","1"),
("18521","B1 (1973-1981)","12710","0","0","1"),
("18522","III (1994-2001)","12711","2","0","1"),
("18523","II (1981-1994)","12711","1","0","1"),
("18524","I (1975-1981)","12711","0","0","1"),
("18525","IV (2001-2009)","12711","3","0","1"),
("18528","Przyczepy, naczepy","3","11","0","0"),
("18529","Naczepy","18528","0","0","0"),
("18530","Przyczepy","18528","1","0","0"),
("18531","Burtowe","18529","0","0","1"),
("18532","Chłodnie","18529","1","0","1"),
("18533","Cysterny","18529","2","0","1"),
("18534","Izotermy","18529","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18535","Niskopodłogowe","18529","4","0","1"),
("18536","Pod kontener","18529","5","0","1"),
("18537","Wywrotki","18529","6","0","1"),
("18538","Pozostałe","18529","7","0","1"),
("18539","Gastronomiczne","18530","0","0","1"),
("18540","Kempingowe","18530","1","0","1"),
("18541","Lawety","18530","2","0","0"),
("18542","Towarowe","18530","3","0","0"),
("18543","Pozostałe","18530","4","0","1"),
("18544","Motocyklowe i do quadów","18541","0","0","1"),
("18545","Podłodziowe","18541","1","0","1"),
("18546","Samochodowe","18541","2","0","1"),
("18547","Pozostałe","18541","3","0","1"),
("18548","Do przewozu zwierząt","18542","0","0","1"),
("18549","Kontenery","18542","1","0","1"),
("18550","Skrzynie otwarte","18542","2","0","1"),
("18551","Skrzynie z plandeką","18542","3","0","1"),
("18552","Pozostałe","18542","4","0","1"),
("18553","Części do innych pojazdów","3","2","0","0"),
("18554","Narzędzia i sprzęt warsztatowy","3","9","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18558","Do gokartów","18553","0","0","1"),
("18559","Do łodzi","18553","1","0","1"),
("18560","Do przyczep i naczep","18553","2","0","0"),
("18562","Do samolotów","18553","3","0","0"),
("18563","Pozostałe","18553","4","0","1"),
("18564","Kempingowe","18560","0","0","0"),
("18565","Towarowe","18560","1","0","0"),
("18566","Pozostałe","18560","2","0","1"),
("18567","Akcesoria","18564","0","0","1"),
("18568","Części","18564","1","0","1"),
("18569","Pozostałe","18564","2","0","1"),
("18570","Akcesoria","18565","0","0","1"),
("18571","Części","18565","1","0","1"),
("18572","Pozostałe","18565","2","0","1"),
("18577","Akcesoria","18562","0","0","1"),
("18578","Części","18562","1","0","1"),
("18579","Pozostałe","18562","2","0","1"),
("18689","Chłodzenie silnika","620","0","0","0"),
("18690","Chłodnice","18689","0","0","0"),
("18692","Pompy wody","18689","5","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18693","Termostaty","18689","7","0","0"),
("18695","Wentylatory chłodnicy","18689","9","0","0"),
("18696","Przewody układów chłodzenia","18689","6","0","0"),
("18697","Zbiorniki wyrównawcze","18689","10","0","1"),
("18698","Pozostałe","18689","11","0","1"),
("18708","Nadkola","4094","9","0","1"),
("18710","Pozostałe","4099","3","0","1"),
("18711","Kompletne","4099","0","0","1"),
("18712","Obudowy","4099","1","0","1"),
("18713","Wkłady","4099","2","0","1"),
("18716","Pozostałe","4101","7","0","1"),
("18717","Tylne","4101","3","0","1"),
("18718","Szyberdachy","4101","5","0","1"),
("18719","Przednie","4101","2","0","1"),
("18720","Boczne (drzwi)","4101","0","0","1"),
("18730","Koła, felgi","620","3","0","0"),
("18731","Felgi","18730","3","0","0"),
("18733","Koła dojazdowe","18730","5","0","1"),
("18735","Pierścienie centrujące","18730","8","0","1"),
("18736","Śruby","18730","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18737","Pozostałe","18730","12","0","1"),
("18798","Lampy obrysowe","623","4","0","1"),
("18800","Lampki tablicy rejestracyjnej","623","3","0","1"),
("18821","Pozostałe","4144","4","0","1"),
("18822","Zestawy","4144","3","0","1"),
("18823","Siłowniki","4144","1","0","1"),
("18824","Sterowniki","4144","2","0","1"),
("18833","Świece","4141","9","0","0"),
("18834","Układ hamulcowy","620","9","0","0"),
("18838","Linki hamulca ręcznego","18834","6","0","1"),
("18839","Pompy hamulcowe","18834","7","0","1"),
("18842","Zestawy montażowe i naprawcze","18834","12","0","1"),
("18843","Pozostałe","18834","13","0","1"),
("18844","Układ paliwowy","620","12","0","0"),
("18846","LPG","18844","5","0","0"),
("18855","Pozostałe","18846","13","0","1"),
("18856","Adaptery, przejściówki","18846","0","0","1"),
("18857","Zbiorniki","18846","11","0","1"),
("18858","Filtry","18846","3","0","1"),
("18859","Instalacje kompletne","18846","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18860","Reduktory","18846","7","0","1"),
("18861","Zestawy naprawcze","18846","12","0","1"),
("18862","Układ wydechowy","620","13","0","0"),
("18863","Pozostałe","18862","12","0","1"),
("18864","Katalizatory","18862","1","0","1"),
("18865","Kolektory wydechowe","18862","2","0","1"),
("18866","Sondy lambda","18862","8","0","1"),
("18867","Tłumiki","18862","9","0","0"),
("18886","Deski rozdzielcze, konsole","622","2","0","1"),
("18888","Lusterka wewnętrzne","622","11","0","1"),
("18891","Oświetlenie kabiny","622","15","0","1"),
("18892","Panele sterowania, przełączniki","622","16","0","1"),
("18893","Podłokietniki","622","19","0","1"),
("18894","Pasy bezpieczeństwa","622","17","0","1"),
("18895","Podsufitki","622","20","0","1"),
("18896","Poduszki powietrzne","622","21","0","1"),
("18897","Półki tylne","622","24","0","1"),
("18898","Rolety bagażnika","622","25","0","1"),
("18900","Zagłówki","622","31","0","1"),
("18901","Zapalniczki samochodowe","622","32","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18902","Pozostałe","1114","10","0","1"),
("18903","Chemia","3","1","0","0"),
("18904","Pozostałe","18903","5","0","1"),
("18908","Chemia blacharsko-lakiernicza","18903","0","0","0"),
("18909","Pozostałe","18908","12","0","1"),
("18910","Lakiery","18908","0","0","0"),
("18911","Podkłady i grunty","18908","4","0","0"),
("18912","Rozpuszczalniki","18908","6","0","1"),
("18913","Mycie i pielęgnacja","18903","1","0","0"),
("18914","Pozostałe","18913","5","0","1"),
("18924","Płyny eksploatacyjne","18903","3","0","0"),
("18925","Pozostałe","18924","14","0","1"),
("18926","Dodatki do olejów i paliw","18924","1","0","0"),
("18927","Płyny chłodnicze","18924","9","0","1"),
("18928","Płyny do wspomagania","18924","11","0","1"),
("18929","Oleje przekładniowe","18924","7","0","1"),
("18934","Płyny hamulcowe","18924","12","0","1"),
("18936","Płyny do spryskiwaczy","18924","10","0","1"),
("18962","Łożyska i piasty kół","8683","2","0","1"),
("18965","Sprężyny zawieszenia","8683","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18968","E24 (1976-1989)","18084","0","0","1"),
("18969","E63/E64 (2002-2010)","18084","1","0","1"),
("18970","Opirus","8642","8","0","1"),
("18971","Cerato","8642","3","0","1"),
("18972","P11 (1996-2002)","12594","1","0","1"),
("18973","P10/W10 (1990-1998)","12594","0","0","1"),
("18974","P12 (2001-2007)","12594","2","0","1"),
("18975","206 CC","4045","5","0","1"),
("18976","307 CC","4045","13","0","1"),
("18977","Malaga","4050","10","0","1"),
("18978","Justy","4052","4","0","1"),
("18979","Seria E11 (1997-2002)","12695","3","0","1"),
("18980","Seria E12 (2001-2007)","12695","4","0","1"),
("18981","Seria E10 (1992-1997)","12695","2","0","1"),
("18982","Seria E9 (1987-1992)","12695","1","0","1"),
("18983","E8 i starsze (-1987)","12695","0","0","1"),
("18984","Amerykańskie","594","0","0","1"),
("18985","Angielskie","594","1","0","1"),
("18986","Czechosłowackie","594","2","0","1"),
("18987","Francuskie","594","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("18988","Niemieckie","594","4","0","1"),
("18989","Polskie","594","5","0","1"),
("18990","Radzieckie","594","6","0","1"),
("18991","Szwedzkie","594","7","0","1"),
("18992","C3 Pluriel","4033","9","0","1"),
("18998","Pozostałe","8721","18","0","1"),
("18999","Alarmy","8721","0","0","1"),
("19000","Blokady","8721","2","0","1"),
("19001","Interkomy","8721","6","0","1"),
("19002","Kufry","8721","7","0","1"),
("19003","Pokrowce","8721","11","0","1"),
("19004","Sakwy i torby","8721","13","0","1"),
("19005","Siatki bagażowe","8721","14","0","1"),
("19006","Elementy nadwozia","158","0","0","0"),
("19007","Pozostałe","19006","13","0","1"),
("19008","Lusterka","19006","5","0","1"),
("19009","Manetki","19006","6","0","1"),
("19010","Linki i cięgna","19006","4","0","0"),
("19011","Owiewki","19006","7","0","1"),
("19012","Podnóżki","19006","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19013","Ramy","19006","9","0","1"),
("19014","Szyby","19006","12","0","1"),
("19015","Filtry","158","1","0","0"),
("19016","Pozostałe","19015","3","0","1"),
("19017","Oleju","19015","0","0","1"),
("19018","Paliwa","19015","1","0","1"),
("19019","Powietrza","19015","2","0","1"),
("19020","Pozostałe","4069","3","0","1"),
("19021","Felgi","4069","1","0","1"),
("19022","Felgi z oponami","4069","2","0","1"),
("19024","Pozostałe","4070","4","0","1"),
("19025","Kierunkowskazy","4070","0","0","1"),
("19026","Lampy tylne","4070","1","0","1"),
("19027","Reflektory","4070","2","0","1"),
("19028","Żarówki","4070","3","0","1"),
("19029","Układ elektryczny, zapłon","158","6","0","0"),
("19030","Pozostałe","19029","13","0","1"),
("19031","Akumulatory","19029","0","0","1"),
("19032","Moduły zapłonowe","19029","4","0","1"),
("19033","Stacyjki","19029","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19034","Pozostałe","4071","8","0","1"),
("19035","Chłodnice","4071","0","0","1"),
("19036","Łańcuchy i napinacze rozrządu","4071","1","0","1"),
("19037","Skrzynie biegów","4071","4","0","1"),
("19038","Silniki","4071","3","0","1"),
("19039","Tłoki, pierścienie, cylindry","4071","5","0","1"),
("19040","Uszczelki","4071","6","0","1"),
("19041","Układ hamulcowy","158","7","0","0"),
("19042","Pozostałe","19041","6","0","1"),
("19043","Klocki","19041","0","0","1"),
("19044","Pompy hamulcowe","19041","1","0","1"),
("19045","Szczęki","19041","3","0","1"),
("19046","Tarcze","19041","4","0","1"),
("19047","Zaciski","19041","5","0","1"),
("19048","Układ napędowy","158","8","0","0"),
("19049","Pozostałe","19048","3","0","1"),
("19050","Sprzęgła","19048","2","0","1"),
("19051","Paski napędowe","19048","1","0","1"),
("19052","Łańcuchy i zębatki","19048","0","0","1"),
("19053","Układ paliwowy","158","9","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19054","Pozostałe","19053","5","0","1"),
("19055","Gaźniki","19053","0","0","1"),
("19056","Korki wlewu","19053","1","0","1"),
("19057","Zbiorniki paliwa","19053","4","0","1"),
("19058","Układ zawieszenia","158","11","0","0"),
("19059","Pozostałe","19058","5","0","1"),
("19060","Amortyzatory","19058","0","0","1"),
("19061","Łożyska kół","19058","2","0","1"),
("19063","Amortyzatory","8684","0","0","1"),
("19066","Chusty","159","0","0","1"),
("19067","Czapki","159","1","0","1"),
("19068","Gogle","159","2","0","1"),
("19069","Kominiarki","159","5","0","1"),
("19070","Koszulki i bluzy","159","6","0","1"),
("19072","Spodnie","159","12","0","1"),
("19073","Rękawice","159","10","0","1"),
("19074","Ochraniacze","159","9","0","1"),
("19096","C50 (1988-1992)","12579","2","0","1"),
("19099","Akcesoria","1114","0","0","1"),
("19100","Chłodzenie silnika","1114","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19101","Części karoserii","1114","2","0","1"),
("19102","Wyposażenie wnętrza","1114","8","0","1"),
("19103","Oświetlenie","1114","3","0","1"),
("19104","Silniki i układ napędowy","1114","4","0","1"),
("19105","Układ hamulcowy","1114","6","0","1"),
("19106","Układ elektryczny, zapłon","1114","5","0","1"),
("19107","Układ wydechowy","1114","7","0","1"),
("19108","Zawieszenie i układ kierowniczy","1114","9","0","1"),
("19122","Błędy, usterki, odmiany","406","16","0","1"),
("19124","Postacie","4776","2","0","0"),
("19125","Jan Paweł II","19124","1","0","1"),
("19126","Benedykt XVI","19124","0","0","1"),
("19127","Pozostałe","19124","2","0","1"),
("19135","K510i","5044","4","0","1"),
("19140","Całości 1939 - 1945","9589","2","0","1"),
("19162","Kamery IP","4314","1","0","1"),
("19166","Zasilacze awaryjne","4554","1","0","1"),
("19167","Akumulatory","4554","0","0","1"),
("19174","Kineskopowe","5120","0","0","0"),
("19189","Solidarność","316","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19266","III (1996-2004)","12687","2","0","1"),
("19285","Części zamienne","1333","1","0","0"),
("19286","Akcesoria serwisowe","1333","0","0","0"),
("19287","Wkrętaki","19286","7","0","1"),
("19288","Pincety","19286","4","0","1"),
("19289","Pozostałe","19286","8","0","1"),
("19291","Gumki","19285","4","0","1"),
("19292","Głośniczki","19285","3","0","0"),
("19293","Joysticki","19285","5","0","1"),
("19294","Membrany","19285","6","0","1"),
("19295","Mikrofony","19285","7","0","1"),
("19296","Plomby","19285","8","0","1"),
("19297","Silniczki wibracyjne","19285","12","0","1"),
("19298","Taśmy LCD","19285","15","0","1"),
("19299","Uchwyty karty SIM","19285","16","0","1"),
("19300","Układy scalone","19285","17","0","1"),
("19301","Włączniki","19285","18","0","1"),
("19302","Wyświetlacze","19285","19","0","1"),
("19303","Złącza","19285","21","0","1"),
("19304","Śrubki","19285","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19305","Pozostałe","19285","23","0","1"),
("19315","Samochodowe","1120","1","0","1"),
("19316","Stacjonarne","1120","2","0","1"),
("19317","Konektory antenowe","1120","0","0","1"),
("19318","Wzmacniacze antenowe","1120","3","0","1"),
("19319","Pozostałe","1120","4","0","1"),
("19320","Pokrowce silikonowe","353","3","0","0"),
("19321","Futerały","353","1","0","0"),
("19322","Kabury","353","2","0","1"),
("19323","Pozostałe","353","5","0","1"),
("19325","LG","19321","3","0","1"),
("19326","Motorola","19321","4","0","1"),
("19327","Nokia","19321","5","0","1"),
("19333","Sony Ericsson","19321","8","0","1"),
("19334","Samsung","19321","6","0","1"),
("19335","Uniwersalne","19321","9","0","1"),
("19336","Pozostałe","19321","10","0","1"),
("19338","LG","19320","2","0","1"),
("19339","Motorola","19320","3","0","1"),
("19341","Nokia","19320","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19345","Samsung","19320","5","0","1"),
("19347","Sony Ericsson","19320","7","0","1"),
("19348","Pozostałe","19320","8","0","1"),
("19349","Breloki","14508","0","0","1"),
("19350","Smycze","14508","2","0","1"),
("19351","Flash stickery","14508","1","0","1"),
("19352","Rysiki","348","16","0","1"),
("19353","Pudełka","348","15","0","1"),
("19354","Ładowarki","348","8","0","0"),
("19355","Biurkowe/Stacje dokujące","19354","1","0","1"),
("19356","Samochodowe","19354","2","0","1"),
("19357","Sieciowe","19354","3","0","1"),
("19366","Pozostałe","19354","4","0","1"),
("19408","Włoskie","594","8","0","1"),
("19411","Interaktywne","11820","5","0","0"),
("19412","Pozytywki","11820","9","0","1"),
("19413","Pozostałe","19411","6","0","1"),
("19416","Do kąpieli","11818","3","0","1"),
("19417","Pozostałe","11821","7","0","1"),
("19421","Instrumenty","11821","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19422","Komputerki","11821","1","0","1"),
("19423","Układanki","11821","6","0","0"),
("19470","Polly Pocket","11825","19","0","1"),
("19472","Wózki dla lalek","11825","32","0","1"),
("19473","Pozostałe","11837","3","0","1"),
("19474","Interaktywne","11837","0","0","0"),
("19475","Postacie z bajek","11837","1","0","0"),
("19476","Zwierzątka","11837","2","0","0"),
("19477","Bujaki, skoczki","11818","1","0","0"),
("19497","Pozostałe","11841","3","0","1"),
("19498","Jeżdżące","11841","0","0","1"),
("19499","Latające","11841","1","0","1"),
("19500","Pływające","11841","2","0","1"),
("19501","do 1975 roku","12099","0","0","1"),
("19502","od 1976 roku","12099","1","0","1"),
("19503","do 1975 roku","12100","0","0","1"),
("19504","od 1976 roku","12100","1","0","1"),
("19513","od 1946 roku","10794","1","0","1"),
("19514","do 1945 roku","10794","0","0","1"),
("19527","Star Wars Miniatures","6048","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19528","Tomb Kings","6058","11","0","1"),
("19529","Vampire Counts","6058","12","0","1"),
("19535","Magnetyczne","11823","9","0","1"),
("19537","Pojemniki na zabawki","17273","6","0","1"),
("19625","Pathfinder","4043","20","0","1"),
("19626","Siłownia i fitness","3919","4","0","0"),
("19628","Pozostałe","19626","8","0","1"),
("19629","Literatura i filmy","19626","7","0","0"),
("19630","Książki","19629","2","0","1"),
("19631","Czasopisma","19629","0","0","1"),
("19632","Filmy","19629","1","0","1"),
("19633","Odzież","19626","2","0","0"),
("19634","Pozostałe","19633","9","0","1"),
("19635","Bielizna","19633","0","0","0"),
("19636","Bluzy","19633","1","0","1"),
("19638","Koszulki","19633","4","0","1"),
("19640","Rękawice","19633","5","0","1"),
("19641","Spodnie","19633","8","0","1"),
("19655","Suplementy i odżywki","19626","4","0","0"),
("19656","Pozostałe","19655","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19657","Aminokwasy","19655","0","0","1"),
("19658","Glutaminy","19655","2","0","1"),
("19659","HMB","19655","3","0","1"),
("19660","Kreatyny","19655","4","0","1"),
("19661","Ochrona stawów","19655","5","0","1"),
("19662","Odżywki białkowe","19655","6","0","1"),
("19664","Reduktory tłuszczu","19655","9","0","1"),
("19665","Węglowodany","19655","10","0","1"),
("19666","Witaminy","19655","11","0","1"),
("19667","ZMA i Tribulus","19655","12","0","1"),
("19668","Pozostałe","13397","3","0","1"),
("19669","Reprezentacji","13397","1","0","1"),
("19670","Klubowe","13397","0","0","1"),
("19692","Wakeboard i narty wodne","13535","6","0","0"),
("19695","Pokrowce i osłony","13541","7","0","1"),
("19696","Fały i linki trapezowe","13541","2","0","1"),
("19697","Stopy, palety, przedłużki","13541","9","0","1"),
("19725","K800i","5044","8","0","1"),
("19732","Biżuteria i Zegarki","0","3","0","0"),
("19733","Pozostałe","19732","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19738","Dewocjonalia","19732","5","0","0"),
("19739","Ozdoby do włosów","19732","6","0","0"),
("19742","Zegarki","19732","4","0","0"),
("19803","Pozostałe","19738","2","0","1"),
("19804","Srebrne","19738","0","0","1"),
("19805","Złote","19738","1","0","1"),
("19806","Pozostałe","19739","5","0","1"),
("19807","Gumki","19739","2","0","1"),
("19808","Spinki, klamry, wsuwki","19739","4","0","1"),
("19864","Damskie","19742","0","0","0"),
("19865","Męskie","19742","1","0","0"),
("19866","Dziecięce","19742","2","0","1"),
("19868","Pozostałe","19864","2","0","1"),
("19869","Na łańcuszku","19864","0","0","1"),
("19870","Naręczne","19864","1","0","1"),
("19871","Pozostałe","19865","2","0","1"),
("19872","Kieszonkowe","19865","0","0","1"),
("19873","Naręczne","19865","1","0","1"),
("19912","Sandały","532","8","0","1"),
("19913","Klapki","532","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19915","Pozostałe","10782","4","0","1"),
("19916","Drewniaki","10782","0","0","1"),
("19917","Eleganckie","10782","1","0","1"),
("19918","Japonki","10782","2","0","1"),
("19919","Sportowe","10782","3","0","1"),
("19956","Prostokątne","8853","5","0","1"),
("19960","Pozostałe","8859","3","0","1"),
("19961","Przeciwsłoneczne","8859","1","0","1"),
("19962","Dekielki i zaślepki","8859","0","0","1"),
("19963","Zestawy ochronne","8859","2","0","1"),
("19976","Akcesoria i środki czyszczące","8847","0","0","0"),
("19977","Pozostałe","19976","3","0","1"),
("19978","Ściereczki","19976","1","0","1"),
("19979","Pędzelki","19976","0","0","1"),
("19980","Zestawy","19976","2","0","1"),
("19981","Stacje dokujące","8855","2","0","1"),
("19982","Papiery i folie fotograficzne","8847","19","0","1"),
("19983","Piloty","8847","20","0","0"),
("19985","Obiektywy powiększalnikowe","8864","1","0","1"),
("19987","Torby","8862","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("19988","Plecaki","8862","0","0","1"),
("19998","Pudełka i futerały","8848","12","0","1"),
("19999","4GB","16242","2","0","1"),
("20007","Folie ochronne","11705","0","0","1"),
("20008","Osłony LCD","11705","1","0","1"),
("20013","N73","4978","97","0","1"),
("20014","5140i","4978","46","0","1"),
("20027","1-10 sztuk","4734","0","0","1"),
("20028","11-50 sztuk","4734","1","0","1"),
("20029","51 i więcej sztuk","4734","2","0","1"),
("20030","Dwuwarstwowe DVD-R DL","4526","5","0","1"),
("20031","Nośniki DVD-RAM","4484","5","0","1"),
("20047","Canon","8804","0","0","1"),
("20048","JVC","8804","1","0","1"),
("20049","Panasonic","8804","2","0","1"),
("20050","Samsung","8804","3","0","1"),
("20051","Sony","8804","4","0","1"),
("20052","Uniwersalne","8804","5","0","1"),
("20053","Inni producenci","8804","6","0","1"),
("20066","2.1","8993","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20067","4.1","8993","1","0","1"),
("20068","5.1","8993","2","0","1"),
("20069","6.1","8993","3","0","1"),
("20070","7.1","8993","4","0","1"),
("20071","Inne","8993","5","0","1"),
("20072","Kolumny podłogowe","8995","0","0","1"),
("20073","Kolumny podstawkowe","8995","1","0","1"),
("20074","Pozostałe","8995","2","0","1"),
("20075","Uszkodzone","8990","5","0","1"),
("20076","Aktywne","8994","0","0","1"),
("20077","Pasywne","8994","1","0","1"),
("20078","Gramofony","778","0","0","1"),
("20079","Maty","778","1","0","1"),
("20080","Wkładki i igły","778","3","0","1"),
("20081","Części zamienne","778","5","0","1"),
("20103","Aiwa","332","0","0","1"),
("20104","JVC","332","4","0","1"),
("20105","LG","332","5","0","1"),
("20106","Marantz","332","6","0","1"),
("20107","Onkyo","332","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20108","Panasonic","332","8","0","1"),
("20109","Philips","332","9","0","1"),
("20110","Pioneer","332","10","0","1"),
("20111","Polskie","332","11","0","1"),
("20112","Samsung","332","12","0","1"),
("20113","Sony","332","14","0","1"),
("20114","Technics","332","15","0","1"),
("20115","Thomson","332","16","0","1"),
("20116","Inni producenci","332","18","0","1"),
("20117","Uszkodzone","332","19","0","1"),
("20118","Końcówki mocy","14","0","0","1"),
("20119","Przedwzmacniacze","14","1","0","1"),
("20121","Wzmacniacze lampowe","14","3","0","1"),
("20134","Sprzęt audio przenośny","10","10","0","0"),
("20135","Odtwarzacze CD, MD i kasetowe","20134","4","0","0"),
("20137","Dyktafony","20134","0","0","1"),
("20140","Miniradio","20134","1","0","1"),
("20141","MP3","20134","2","0","0"),
("20142","MP4","20134","3","0","0"),
("20143","Pokrowce i etui","20134","8","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20144","Uszkodzone","20134","9","0","1"),
("20145","Pozostałe","20134","10","0","1"),
("20148","Apple","20141","0","0","1"),
("20149","Creative","20141","1","0","1"),
("20150","iAudio","20141","2","0","1"),
("20151","iRiver","20141","3","0","1"),
("20153","Philips","20141","5","0","1"),
("20154","Samsung","20141","6","0","1"),
("20155","Sony","20141","8","0","1"),
("20156","Sandisk","20141","7","0","1"),
("20157","Inni producenci","20141","10","0","1"),
("20162","Elementy zabudowy","1322","15","0","1"),
("20163","Panele","1306","1","0","0"),
("20164","Etui","1306","0","0","1"),
("20165","Alpine","20163","0","0","1"),
("20166","Blaupunkt","20163","1","0","1"),
("20167","Clarion","20163","2","0","1"),
("20168","JVC","20163","3","0","1"),
("20169","Kenwood","20163","4","0","1"),
("20170","Panasonic","20163","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20171","Pioneer","20163","6","0","1"),
("20172","Sony","20163","7","0","1"),
("20173","Fabryczne","20163","8","0","1"),
("20174","Inni producenci","20163","9","0","1"),
("20175","Panele LCD/TV","709","6","0","1"),
("20176","Philips","5188","7","0","1"),
("20177","Philips","5185","6","0","1"),
("20178","Video/DVD","712","4","0","0"),
("20179","Alpine","20178","0","0","1"),
("20180","Blaupunkt","20178","1","0","1"),
("20181","Clarion","20178","2","0","1"),
("20182","JVC","20178","3","0","1"),
("20183","Kenwood","20178","4","0","1"),
("20184","Panasonic","20178","5","0","1"),
("20185","Pioneer","20178","6","0","1"),
("20186","Sony","20178","7","0","1"),
("20187","Fabryczne","20178","8","0","1"),
("20188","Inni producenci","20178","9","0","1"),
("20189","Uszkodzone","712","6","0","1"),
("20203","Inni producenci","714","24","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20204","Alpine","714","0","0","1"),
("20205","Boschmann","714","3","0","1"),
("20206","Blaupunkt","714","2","0","1"),
("20207","Infinity","714","13","0","1"),
("20208","JBL","714","14","0","1"),
("20209","Kenwood","714","15","0","1"),
("20210","Magnat","714","17","0","1"),
("20211","Pioneer","714","18","0","1"),
("20212","Rockford","714","19","0","1"),
("20213","Sony","714","21","0","1"),
("20215","Uszkodzone","714","25","0","1"),
("20221","Jednopłytowe","13","0","0","0"),
("20222","Wielopłytowe","13","1","0","0"),
("20223","Uszkodzone","13","4","0","1"),
("20224","Denon","20221","3","0","1"),
("20225","Denon","20222","0","0","1"),
("20226","Kenwood","20221","5","0","1"),
("20227","Kenwood","20222","1","0","1"),
("20228","Onkyo","20221","8","0","1"),
("20229","Onkyo","20222","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20230","Philips","20222","3","0","1"),
("20231","Philips","20221","9","0","1"),
("20232","Pioneer","20221","10","0","1"),
("20233","Pioneer","20222","4","0","1"),
("20234","Sony","20221","12","0","1"),
("20235","Sony","20222","5","0","1"),
("20236","Technics","20222","6","0","1"),
("20237","Technics","20221","13","0","1"),
("20238","Yamaha","20221","15","0","1"),
("20239","Yamaha","20222","7","0","1"),
("20240","Inni producenci","20221","16","0","1"),
("20241","Inni producenci","20222","8","0","1"),
("20242","Yamaha","332","17","0","1"),
("20253","Pozostałe","9018","9","0","1"),
("20254","Skóry","9018","4","0","1"),
("20255","Dywaniki łazienkowe","9018","1","0","1"),
("20256","Chodniki","9018","0","0","1"),
("20257","Dywany pokojowe","9018","2","0","1"),
("20265","Pozostałe","1510","9","0","1"),
("20266","Szafki kuchenne","1510","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20271","Pozostałe","1513","4","0","1"),
("20272","Regały","1513","3","0","1"),
("20273","Biurka","1513","0","0","1"),
("20274","Fotele i krzesła","1513","1","0","1"),
("20275","Pozostałe","1514","8","0","1"),
("20276","Garderoby i szafy","1514","0","0","1"),
("20277","Szafki na buty","1514","5","0","1"),
("20279","Pozostałe","1515","16","0","1"),
("20280","Zestawy mebli","1515","14","0","1"),
("20281","Witryny","1515","13","0","1"),
("20283","Kanapy","1515","1","0","1"),
("20284","Regały","1515","7","0","1"),
("20285","Fotele","1515","0","0","1"),
("20286","Narożniki","1515","5","0","1"),
("20287","Stoły i krzesła","1515","10","0","1"),
("20288","Komplety wypoczynkowe","1515","3","0","1"),
("20289","Pozostałe","568","10","0","1"),
("20290","Łóżka","568","2","0","1"),
("20291","Komody i toaletki","568","0","0","1"),
("20292","Materace","568","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20293","Szafy","568","8","0","1"),
("20294","Szafki nocne","568","7","0","1"),
("20585","Filmy","0","8","0","0"),
("20602","Kasety wideo","20585","4","0","0"),
("20603","Bez polskiej wersji","20602","0","0","1"),
("20604","Dla dzieci","20602","1","0","1"),
("20605","Dokumentalne","20602","2","0","1"),
("20606","Dramaty","20602","3","0","1"),
("20607","Fantasy","20602","4","0","1"),
("20608","Horrory","20602","5","0","1"),
("20609","Komedie","20602","6","0","1"),
("20610","Kostiumowe","20602","8","0","1"),
("20611","Kryminały","20602","9","0","1"),
("20612","Przygodowe","20602","10","0","1"),
("20613","Science Fiction","20602","11","0","1"),
("20614","Sensacyjne","20602","12","0","1"),
("20615","Seriale","20602","13","0","1"),
("20616","Thrillery","20602","14","0","1"),
("20617","Wojenne","20602","15","0","1"),
("20618","Pozostałe","20602","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20619","Zestawy, pakiety","20602","17","0","1"),
("20664","Płyty VCD","20585","3","0","0"),
("20665","Dla dzieci","20664","0","0","1"),
("20666","Dokumentalne","20664","1","0","1"),
("20667","Dramaty","20664","2","0","1"),
("20668","Horrory","20664","3","0","1"),
("20669","Komedie","20664","4","0","1"),
("20670","Kryminały","20664","6","0","1"),
("20671","Przygodowe","20664","7","0","1"),
("20672","Science Fiction","20664","8","0","1"),
("20673","Sensacyjne","20664","9","0","1"),
("20674","Seriale","20664","10","0","1"),
("20675","Thrillery","20664","11","0","1"),
("20676","Filmy z gazety","20664","12","0","1"),
("20677","Pozostałe","20664","13","0","1"),
("20678","Zestawy, pakiety","20664","14","0","1"),
("20760","Gadżety muzyczne","1","3","0","0"),
("20761","Autografy","20760","0","0","1"),
("20762","Kalendarze","20760","3","0","1"),
("20763","Kubki","20760","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("20764","Naszywki, znaczki, przypinki","20760","5","0","1"),
("20765","Plakaty i zdjęcia","20760","6","0","1"),
("20766","T-shirty, bluzy, czapki","20760","9","0","1"),
("20767","Pozostałe","20760","11","0","1"),
("20768","Koncerty, teledyski","20602","7","0","1"),
("20780","Koncerty, teledyski","20664","5","0","1"),
("20782","Nieruchomości","0","18","0","0"),
("25952","Obuwie","11763","4","0","0"),
("25953","Pozostałe","25952","15","0","1"),
("25954","Dla niemowląt","25952","3","0","1"),
("25955","Domowe","25952","4","0","1"),
("25956","Klapki","25952","6","0","1"),
("25957","Kozaczki","25952","7","0","1"),
("25958","Sandałki","25952","9","0","1"),
("25959","Sportowe","25952","10","0","1"),
("25960","Trzewiki i półbuty","25952","13","0","1"),
("25986","E50","4978","86","0","1"),
("26012","Stare zabawki","316","17","0","1"),
("26013","Antyki i Sztuka","0","0","0","0"),
("26014","Antyki","26013","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26015","Ceramika","26014","1","0","0"),
("26016","Figurki","26015","0","0","1"),
("26017","Naczynia do kawy i herbaty","26015","1","0","1"),
("26018","Piece, kafle i płytki","26015","2","0","1"),
("26019","Przedmioty kuchenne","26015","3","0","1"),
("26020","Talerze, patery, półmiski","26015","4","0","1"),
("26021","Wazony i dzbanki","26015","5","0","1"),
("26022","Wyroby gliniane","26015","6","0","1"),
("26023","Stylizowane i repliki","26015","7","0","1"),
("26024","Pozostałe","26015","8","0","1"),
("26025","Oświetlenie","26014","2","0","0"),
("26027","Lampki","26025","1","0","1"),
("26028","Świeczniki","26025","4","0","1"),
("26029","Żyrandole","26025","5","0","1"),
("26030","Platery, posrebrzane i inne","26014","3","0","0"),
("26031","Bibeloty","26030","0","0","1"),
("26032","Cukiernice","26030","1","0","1"),
("26033","Dzbanki i mleczniki","26030","2","0","1"),
("26034","Galanteria stołowa","26030","3","0","1"),
("26035","Patery","26030","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26036","Puchary i kielichy","26030","5","0","1"),
("26037","Sztućce","26030","6","0","1"),
("26038","Talerze i półmiski","26030","7","0","1"),
("26039","Pozostałe","26030","8","0","1"),
("26040","Rzeźba","26014","4","0","1"),
("26047","Srebra","26014","5","0","0"),
("26048","Bibeloty","26047","0","0","1"),
("26049","Cukiernice","26047","1","0","1"),
("26050","Dzbanki i mleczniki","26047","2","0","1"),
("26051","Galanteria stołowa","26047","3","0","1"),
("26052","Patery","26047","4","0","1"),
("26053","Puchary i kielichy","26047","5","0","1"),
("26054","Sztućce","26047","6","0","1"),
("26055","Pozostałe","26047","7","0","1"),
("26056","Szkło","26014","6","0","0"),
("26057","Szkło do 1900","26056","0","0","1"),
("26058","Szkło dekoracyjne","26056","1","0","0"),
("26059","Szkło użytkowe","26056","2","0","0"),
("26060","Szkło apteczne","26056","3","0","1"),
("26061","Szkło kryształowe","26056","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26062","Figurki","26058","0","0","1"),
("26063","Witraże","26058","1","0","1"),
("26064","Pozostałe","26058","2","0","1"),
("26065","Butelki","26059","0","0","1"),
("26066","Cukiernice i bomboniery","26059","1","0","1"),
("26067","Karafki","26059","2","0","1"),
("26068","Kieliszki","26059","3","0","1"),
("26069","Talerze i patery","26059","4","0","1"),
("26070","Wazony","26059","5","0","1"),
("26071","Pozostałe","26059","6","0","1"),
("26072","Zegary, zegarki","26014","8","0","0"),
("26073","Kieszonkowe","26072","0","0","1"),
("26074","Kominkowe","26072","1","0","1"),
("26075","Naręczne","26072","2","0","1"),
("26076","Stojące","26072","3","0","1"),
("26077","Wiszące","26072","4","0","1"),
("26078","Mechanizmy i części","26072","5","0","1"),
("26079","Repliki","26072","6","0","1"),
("26080","Pozostałe","26072","7","0","1"),
("26081","Literatura tematu","26014","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26085","Pozostałe","26014","10","0","0"),
("26086","Cyna","26085","0","0","1"),
("26087","Dewocjonalia","26085","1","0","0"),
("26088","Dzwonki","26085","2","0","1"),
("26089","Instrumenty muzyczne","26085","3","0","1"),
("26097","Pozostałe","26085","6","0","1"),
("26098","Antykwariat","26013","1","0","0"),
("26099","Autografy i rękopisy","26098","0","0","1"),
("26100","Czasopisma do 1950","26098","1","0","1"),
("26101","Książki do 1950","26098","2","0","0"),
("26102","Stara fotografia","26098","3","0","1"),
("26103","Stara reklama","26098","4","0","1"),
("26104","Stare dokumenty","26098","5","0","0"),
("26105","Stare grafiki","26098","6","0","1"),
("26106","Stare mapy","26098","7","0","0"),
("26107","Stare plakaty","26098","8","0","1"),
("26108","Stare ulotki","26098","9","0","1"),
("26109","Literatura tematu","26098","10","0","0"),
("26110","Pozostałe","26098","11","0","1"),
("26113","Bibliofilskie","26101","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26114","Dla dzieci","26101","1","0","1"),
("26115","Ekonomia","26101","2","0","1"),
("26116","Etnografia","26101","3","0","1"),
("26117","Exlibrisy","26101","4","0","1"),
("26118","Geografia","26101","5","0","1"),
("26119","Gospodarstwo domowe","26101","6","0","1"),
("26120","Heraldyka i genealogia","26101","7","0","1"),
("26121","Historia","26101","8","0","0"),
("26122","Językoznawstwo","26101","9","0","1"),
("26123","Literatura","26101","10","0","0"),
("26124","Muzyka","26101","12","0","1"),
("26125","Nauki humanistyczne","26101","13","0","1"),
("26126","Nauki przyrodnicze","26101","14","0","1"),
("26127","Nauki ścisłe","26101","15","0","1"),
("26128","Polityka","26101","16","0","1"),
("26129","Prawo","26101","17","0","1"),
("26130","Religia","26101","18","0","1"),
("26131","Starodruki do 1800","26101","20","0","1"),
("26132","Sztuka i Kultura","26101","21","0","1"),
("26133","Słowniki i encyklopedie","26101","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26134","Technika","26101","22","0","1"),
("26135","Reprinty","26101","23","0","1"),
("26136","Pozostałe","26101","24","0","1"),
("26137","Medycyna","26101","11","0","1"),
("26138","Historia Polski","26121","0","0","1"),
("26139","Historia powszechna","26121","1","0","1"),
("26140","Polska","26123","0","0","1"),
("26141","Zagraniczna","26123","1","0","1"),
("26142","Historia Literatury","26123","2","0","1"),
("26143","Dokumenty do 1800","26104","0","0","1"),
("26144","Identyfikacyjne","26104","1","0","1"),
("26145","Akty i umowy","26104","2","0","1"),
("26146","Faktury i rachunki","26104","3","0","1"),
("26147","Listy i pisma","26104","4","0","1"),
("26149","Pozostałe","26104","5","0","1"),
("26155","Afryka","26106","0","0","1"),
("26156","Ameryki","26106","1","0","1"),
("26157","Azja","26106","2","0","1"),
("26158","Europa","26106","3","0","1"),
("26159","Polska","26106","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26160","Pozostałe","26106","6","0","1"),
("26161","Księgoznawstwo","26109","0","0","1"),
("26162","Pozostałe","26109","1","0","1"),
("26163","Porcelana","26013","4","0","0"),
("26164","Antyki do 1850","26163","0","0","1"),
("26165","Miśnia","26163","1","0","1"),
("26171","Rosenthal","26163","2","0","1"),
("26176","Sorau - Żary","26163","3","0","1"),
("26179","Cukiernice i bomboniery","26163","4","0","1"),
("26180","Dzbanki i czajniki","26163","5","0","1"),
("26181","Mleczniki","26163","6","0","1"),
("26182","Filiżanki","26163","7","0","1"),
("26183","Zestawy śniadaniowe","26163","8","0","1"),
("26184","Patery i duże talerze","26163","9","0","1"),
("26185","Talerzyki i podstawki","26163","10","0","1"),
("26186","Kabarety, koszyki, misy, żardiniery","26163","11","0","1"),
("26187","Serwisy - części","26163","12","0","1"),
("26188","Serwisy kompletne","26163","13","0","1"),
("26189","Wazony","26163","14","0","1"),
("26190","Szkatułki i puzdra","26163","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26191","Figurki","26163","16","0","1"),
("26192","Inne przedmioty","26163","17","0","0"),
("26193","Literatura tematu","26163","18","0","1"),
("26227","Meble","26013","3","0","0"),
("26228","Meble do 1820 roku","26227","0","0","1"),
("26229","Biurka","26227","1","0","1"),
("26230","Biblioteki","26227","2","0","1"),
("26231","Fotele","26227","3","0","1"),
("26232","Krzesła","26227","4","0","1"),
("26233","Komody","26227","5","0","1"),
("26234","Kredensy","26227","6","0","1"),
("26235","Serwantki","26227","7","0","1"),
("26236","Kanapy i sofy","26227","8","0","1"),
("26237","Łóżka","26227","9","0","1"),
("26238","Stoły","26227","10","0","1"),
("26239","Stoliki","26227","11","0","1"),
("26240","Szafy","26227","12","0","1"),
("26241","Szafki","26227","13","0","1"),
("26242","Witryny","26227","14","0","1"),
("26243","Wieszaki","26227","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26244","Lustra","26227","16","0","1"),
("26245","Skrzynie i kufry","26227","17","0","1"),
("26249","Komplety mebli","26227","19","0","1"),
("26250","Elementy i akcesoria","26227","20","0","1"),
("26251","Literatura tematu","26227","21","0","1"),
("26252","Pozostałe","26227","22","0","1"),
("26261","Skrzynki i szkatułki","26227","18","0","1"),
("26271","Malarstwo","26013","2","0","0"),
("26272","Olej","26271","0","0","1"),
("26273","Ikony","26271","1","0","1"),
("26274","Akwarele","26271","2","0","1"),
("26275","Akryl","26271","3","0","1"),
("26277","Reprodukcje","26271","4","0","1"),
("26279","Literatura tematu","26271","5","0","1"),
("26280","Pozostałe","26271","6","0","1"),
("26281","Sztuka współczesna","26013","6","0","0"),
("26282","Fotografia","26281","0","0","1"),
("26283","Grafika","26281","1","0","1"),
("26284","Plakat","26281","2","0","1"),
("26286","Rzeźba","26281","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26287","Szkło i ceramika","26281","4","0","1"),
("26289","Pozostałe","26281","6","0","1"),
("26312","Galanteria stołowa","26192","0","0","1"),
("26313","Przybory kuchenne","26192","1","0","1"),
("26314","Salaterki","26192","2","0","1"),
("26315","Sosjerki","26192","3","0","1"),
("26316","Tace i półmiski","26192","5","0","1"),
("26317","Wazy","26192","6","0","1"),
("26318","Świeczniki","26192","4","0","1"),
("26319","Pozostałe","26192","7","0","1"),
("26789","Przyrządy miernicze","1536","25","0","0"),
("26847","Miary i taśmy","26789","2","0","1"),
("26848","Poziomice","26789","3","0","1"),
("26849","Pozostałe","26789","6","0","1"),
("26911","Czapki","13391","1","0","1"),
("26917","Tabor kolejowy","3601","0","0","1"),
("26918","Torowiska","3601","1","0","1"),
("26919","Tabor kolejowy","3603","0","0","1"),
("26920","Torowiska","3603","1","0","1"),
("26921","Tabor kolejowy","3602","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26922","Torowiska","3602","1","0","1"),
("26923","Inne skale","1063","3","0","1"),
("26924","HO - 1:87","3597","0","0","1"),
("26925","N - 1:160","3597","1","0","1"),
("26926","TT - 1:120","3597","2","0","1"),
("26927","Elementy elektryczne i elektrotechniczne","3597","3","0","1"),
("26928","Pozostałe","3597","4","0","1"),
("26929","HO - 1:87","3599","0","0","1"),
("26930","N - 1:160","3599","1","0","1"),
("26931","TT - 1:120","3599","2","0","1"),
("26932","Pozostałe","3599","3","0","1"),
("26933","Koleje","1067","0","0","1"),
("26943","Statki powietrzne","3580","0","0","1"),
("26944","Akcesoria","3580","1","0","1"),
("26945","Statki powietrzne","3581","0","0","1"),
("26946","Akcesoria","3581","1","0","1"),
("26947","inne skale","1064","5","0","0"),
("26948","Pojazdy wojskowe","3584","0","0","1"),
("26949","Akcesoria","3584","1","0","1"),
("26950","Pojazdy wojskowe","3585","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("26951","Akcesoria","3585","1","0","1"),
("26952","skale 1:44 do 1:59","1066","4","0","1"),
("26953","skale 1:60 do 1:66","1066","5","0","1"),
("26954","skala 1:87","1066","7","0","1"),
("26955","Inne skale","1066","8","0","1"),
("26956","Samochody","1272","4","0","1"),
("26957","Pojazdy wojskowe","8760","1","0","1"),
("26958","Materiały modelarskie","1061","11","0","1"),
("26959","Rysunek","26013","5","0","1"),
("26991","Opaski do włosów","19739","3","0","1"),
("27000","Balerinki","531","0","0","1"),
("27424","LG","727","3","0","1"),
("27425","Samsung","727","9","0","1"),
("27426","Pioneer","727","8","0","1"),
("27427","Onkyo","727","5","0","1"),
("27428","Panasonic","727","6","0","1"),
("27429","Philips","727","7","0","1"),
("27430","Yamaha","727","11","0","1"),
("27431","Marantz","727","4","0","1"),
("27432","Denon","727","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("27433","Sony","727","10","0","1"),
("27434","JVC","727","2","0","1"),
("27435","Inni producenci","727","12","0","1"),
("27693","Odzież","13422","2","0","1"),
("27694","Puttery","13424","0","0","1"),
("27695","Woody","13424","1","0","1"),
("27696","Żelaza","13424","2","0","1"),
("27697","Zestawy","13424","3","0","1"),
("27698","Pozostałe","13424","4","0","1"),
("27699","Pokrowce","13422","4","0","1"),
("27700","SATA","4717","8","0","1"),
("27701","3,5\" Serial ATA (SATA)","4476","1","0","1"),
("27702","3,5\" PATA (IDE/ATA)","4476","0","0","1"),
("27718","Flash 4GB","9578","4","0","1"),
("27719","Flash 2GB","9578","5","0","1"),
("27720","Flash 1GB","9578","6","0","1"),
("27722","Inne 8-kanałowe","4397","6","0","1"),
("27746","Kondensatory do płyt głównych","4230","1","0","1"),
("27747","Ubuntu","4655","1","0","1"),
("27748","Przełączniki KVM","4689","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("27837","Ręczniki i okrycia","17285","6","0","0"),
("27838","Saszetki i nerki","1487","17","0","1"),
("27851","HP, Compaq","9061","1","0","1"),
("27852","IBM","9061","2","0","1"),
("27853","Sun","9061","4","0","1"),
("27854","Dell","9061","0","0","1"),
("27855","Inni producenci","9061","6","0","1"),
("27856","Serwery RISC","9061","5","0","1"),
("27862","Obozy jenieckie","12083","8","0","1"),
("27863","Ruch oporu","3727","11","0","1"),
("27864","Wojska powietrzno - desantowe","3727","13","0","1"),
("27865","Jednostki specjalne","3727","4","0","1"),
("27878","GT","4030","15","0","1"),
("27879","Spider","4030","18","0","1"),
("27880","Caliber","12402","1","0","1"),
("27881","Viper","12402","17","0","1"),
("27882","Tucson","4038","27","0","0"),
("27883","D (2006-2014)","12604","3","0","1"),
("27884","207","4045","7","0","1"),
("27885","Roomster","4051","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("27886","Jimny","4053","5","0","1"),
("27887","MR2","4054","19","0","1"),
("27890","Inne marki","18037","7","0","1"),
("27891","DAF","18037","0","0","1"),
("27892","Iveco","18037","1","0","1"),
("27893","MAN","18037","2","0","1"),
("27894","Mercedes-Benz","18037","3","0","1"),
("27895","Renault","18037","4","0","1"),
("27896","Scania","18037","5","0","1"),
("27897","Volvo","18037","6","0","1"),
("27898","Memory Stick Micro M2","8848","5","0","0"),
("27903","2GB","27898","1","0","1"),
("27940","Akcesoria plastyczne","26013","8","0","0"),
("27941","Grafika","27940","0","0","0"),
("27945","Rysunek","27940","4","0","0"),
("27946","Ramy i oprawy","27940","3","0","0"),
("27947","Sztalugi","27940","6","0","1"),
("27948","Konserwacja","27940","7","0","0"),
("27949","Pozostałe","27940","9","0","1"),
("27950","Rzeźbiarstwo","27940","5","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("27958","Pozostałe","1525","9","0","1"),
("27960","Dystrybucja gorącego powietrza","1525","3","0","0"),
("27961","Akcesoria do płaszcza wodnego","1525","0","0","0"),
("27962","Akcesoria kominkowe","1525","1","0","0"),
("27963","Systemy kominowe","1525","7","0","1"),
("27964","Inne akcesoria","27961","1","0","1"),
("27965","Wymienniki i pompy","27961","0","0","1"),
("27966","Pozostałe","27960","3","0","1"),
("27967","Przewody i kanały","27960","1","0","1"),
("27968","Kratki i anemostaty","27960","0","0","1"),
("27969","Turbiny i filtry","27960","2","0","1"),
("27970","Inne akcesoria","27962","3","0","1"),
("27971","Zestawy kominkowe","27962","2","0","1"),
("27973","Kosze na drewno","27962","1","0","1"),
("27974","Elementy kominków i pieców","27962","0","0","0"),
("27975","Inne elementy","27974","1","0","1"),
("27976","Obudowy kominkowe","27974","0","0","1"),
("28047","Akwaria","5338","0","0","1"),
("28048","Zestawy","5338","2","0","1"),
("28049","Chemia i nawozy","1118","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28050","Leki","28049","0","0","1"),
("28051","Nawozy","28049","1","0","1"),
("28052","Testy","28049","2","0","1"),
("28053","Inne preparaty","28049","4","0","1"),
("28054","Inne pokarmy","16011","2","0","1"),
("28057","Żywe","5337","1","0","1"),
("28058","Sztuczne","5337","0","0","1"),
("28059","Szafki, stoliki i regały","1118","12","0","1"),
("28082","Pozostałe","10769","6","0","1"),
("28083","Terraria","10769","5","0","1"),
("28084","Rośliny","10769","4","0","0"),
("28085","Przyrządy pomiarowe","10769","3","0","1"),
("28086","Podłoża, tła i ozdoby","10769","2","0","1"),
("28087","Oświetlenie","10769","1","0","1"),
("28088","Ogrzewanie i temperatura","10769","0","0","1"),
("28089","Sztuczne","28084","0","0","1"),
("28090","Żywe","28084","1","0","1"),
("28091","Pajęczaki","10770","2","0","0"),
("28092","Pająki","28091","0","0","1"),
("28093","Pozostałe","28091","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28094","Gady","10770","0","0","0"),
("28095","Owady","10770","1","0","1"),
("28096","Zwierzęta karmowe","10770","3","0","1"),
("28097","Pozostałe","10770","4","0","1"),
("28098","Jaszczurki","28094","0","0","1"),
("28099","Węże","28094","1","0","1"),
("28100","Pozostałe","28094","2","0","1"),
("28101","Gołębie","16000","1","0","0"),
("28102","Drób ozdobny","16000","0","0","0"),
("28103","Ptaki egzotyczne","16000","2","0","1"),
("28104","Inne ptaki","16000","3","0","1"),
("28110","Pokarmy","10768","0","0","1"),
("28116","Pozostałe","17280","10","0","1"),
("28117","Baldachimy i stelaże","17280","0","0","1"),
("28118","Kocyki","17280","1","0","1"),
("28119","Ochraniacze","17280","4","0","1"),
("28120","Komplety pościeli","17280","3","0","1"),
("28121","Poszwy i poszewki","17280","5","0","0"),
("28122","Prześcieradła","17280","6","0","0"),
("28123","Przyborniki i dodatki","17280","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28124","Rożki i beciki","17280","8","0","1"),
("28125","Kołdry i poduszki","17280","2","0","0"),
("28126","Komplety","28121","2","0","1"),
("28127","Poszewki na poduszki","28121","0","0","1"),
("28128","Poszwy na kołdry","28121","1","0","1"),
("28129","Bez gumki","28122","0","0","1"),
("28130","Z gumką","28122","1","0","1"),
("28131","Kołdry","28125","0","0","1"),
("28132","Poduszki","28125","1","0","1"),
("28133","Komplety","28125","2","0","1"),
("28135","Pozostałe","11697","5","0","1"),
("28136","Do 100 zdjęć","11697","0","0","1"),
("28137","Do 200 zdjęć","11697","1","0","1"),
("28138","Do 300 zdjęć","11697","2","0","1"),
("28139","Powyżej 300 zdjęć","11697","3","0","1"),
("28140","Zestawy","11697","4","0","1"),
("28147","Urządzenia","16284","1","0","1"),
("28148","Akcesoria","16284","0","0","1"),
("28149","Urządzenia","8860","1","0","1"),
("28150","Akcesoria","8860","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28151","Pozostałe","28150","4","0","1"),
("28152","Magazynki","28150","1","0","1"),
("28153","Ramki","28150","2","0","1"),
("28154","Slajdy","28150","3","0","1"),
("28155","Akcesoria wodoszczelne","8847","1","0","0"),
("28156","Pudełka","8847","22","0","1"),
("28158","4GB","8904","2","0","1"),
("28260","Pozostałe","4","10","0","0"),
("28262","Literatura i instrukcje","28260","0","0","1"),
("28263","Oprogramowanie","28260","1","0","1"),
("28265","Pozostałe","28260","2","0","1"),
("28267","Półprzewodniki","5063","6","0","1"),
("28268","Przewody","5063","7","0","1"),
("28269","Lampy","5063","4","0","1"),
("28270","Moduły i płytki","5063","5","0","1"),
("28271","Radiostacje","5061","2","0","0"),
("28272","Przenośne","28271","0","0","1"),
("28273","Stacjonarne","28271","1","0","1"),
("28274","Uszkodzone","28271","2","0","1"),
("28275","Sprzęt profesjonalny","446","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28276","Akcesoria i części","28275","0","0","1"),
("28277","Radiostacje","28275","1","0","0"),
("28278","Pozostałe","28275","2","0","1"),
("28279","Służby","28277","0","0","1"),
("28280","Wojsko","28277","2","0","1"),
("28281","Taxi","28277","1","0","1"),
("28282","Krótkofalówki i Walkie-talkie","446","0","0","0"),
("28283","Pozostałe","446","4","0","1"),
("28298","USA","886","3","0","1"),
("28299","Karaiby","886","2","0","1"),
("28300","Kanada","886","1","0","1"),
("28301","Ameryka Łacińska","886","0","0","0"),
("28302","Zestawy","886","4","0","1"),
("28303","Pozostałe","886","5","0","1"),
("28304","Argentyna","28301","0","0","1"),
("28305","Brazylia","28301","1","0","1"),
("28306","Chile","28301","2","0","1"),
("28307","Kolumbia","28301","3","0","1"),
("28308","Kuba","28301","4","0","1"),
("28309","Meksyk","28301","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28310","Nikaragua","28301","6","0","1"),
("28311","Peru","28301","7","0","1"),
("28312","Wenezuela","28301","8","0","1"),
("28313","Pozostałe","28301","9","0","1"),
("28314","Chiny","885","4","0","1"),
("28315","Afganistan","885","0","0","1"),
("28316","Indie","885","6","0","1"),
("28318","Indonezja","885","7","0","1"),
("28319","Irak","885","8","0","1"),
("28320","Iran","885","9","0","1"),
("28321","Korea","885","14","0","1"),
("28322","Mongolia","885","20","0","1"),
("28323","Nepal","885","21","0","1"),
("28324","Pakistan","885","22","0","1"),
("28325","Republiki/Kraje byłego ZSRR","885","23","0","1"),
("28326","Tajlandia","885","25","0","1"),
("28327","Zestawy","885","27","0","1"),
("28328","Pozostałe","885","28","0","1"),
("28331","Kraje byłej Jugosławii","382","8","0","1"),
("28332","Austro-Węgry i Austria","382","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28333","Benelux","382","1","0","1"),
("28334","Białoruś","382","2","0","1"),
("28335","Czechy i Słowacja","382","3","0","1"),
("28336","Francja","382","4","0","1"),
("28337","Hiszpania i Portugalia","382","6","0","1"),
("28338","Kraje bałtyckie","382","7","0","1"),
("28339","Rumunia i Bułgaria","382","12","0","1"),
("28340","Turcja","382","13","0","1"),
("28341","Ukraina","382","14","0","1"),
("28342","Węgry","382","15","0","1"),
("28343","Wielka Brytania","382","16","0","1"),
("28344","Zestawy","382","18","0","1"),
("28345","Egipt","1059","1","0","1"),
("28346","Libia","1059","8","0","1"),
("28347","Madagaskar","1059","9","0","1"),
("28348","Mozambik","1059","12","0","1"),
("28349","Nigeria","1059","13","0","1"),
("28350","Sudan","1059","15","0","1"),
("28351","Zair","1059","17","0","1"),
("28352","Zambia","1059","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28353","Zestawy","1059","20","0","1"),
("28354","Pozostałe","1059","21","0","1"),
("28355","Zestawy","385","2","0","1"),
("28356","Zestawy","381","8","0","1"),
("28357","Kongo","1059","7","0","1"),
("28358","Kraje skandynawskie","382","9","0","1"),
("28390","World of Warcraft","6049","9","0","1"),
("28392","Sprzęt warsztatowy","18554","8","0","0"),
("28393","Pozostałe","28392","10","0","1"),
("28394","Meble warsztatowe","28392","0","0","0"),
("28396","Oświetlenie","28392","3","0","0"),
("28400","Pokrowce","28392","6","0","0"),
("28410","Diagnostyka silnika i elektroniki","18554","0","0","0"),
("28411","Pozostałe","28410","2","0","1"),
("28413","Interfejsy diagnostyczne","28410","0","0","1"),
("28415","Testery i diagnoskopy","28410","1","0","1"),
("28417","Normalia","18554","6","0","0"),
("28418","Pozostałe","28417","7","0","1"),
("28419","Uszczelki, oringi","28417","5","0","1"),
("28420","Śruby","28417","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("28463","Pozostałe","18554","9","0","1"),
("28464","Guziki","316","7","0","1"),
("28471","Budownictwo, wnętrza, ogród","118","1","0","1"),
("28472","Wychowanie, rodzina","118","21","0","1"),
("28496","Kalendarze, gadżety i akcesoria","7","13","0","0"),
("28524","Dla dzieci","118","2","0","1"),
("28573","Trenażery","16415","18","0","1"),
("45417","Śląsk","13838","3","0","1"),
("45418","Były zabór rosyjski","13838","0","0","1"),
("45419","Galicja","13838","1","0","1"),
("45420","Pomorze","13838","2","0","1"),
("45421","Warmia i Mazury","13838","4","0","1"),
("45422","Wielkopolska","13838","5","0","1"),
("45423","Zestawy","13838","6","0","1"),
("45424","Pozostałe","13838","7","0","1"),
("45571","bez dysku","1303","0","0","0"),
("45572","z dyskiem","1303","1","0","0"),
("45580","Podstawy","14215","0","0","1"),
("45581","Inni producenci","19174","7","0","1"),
("45582","Philips","19174","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45583","LG","19174","1","0","1"),
("45584","Samsung","19174","4","0","1"),
("45585","Panasonic","19174","2","0","1"),
("45586","Sony","19174","5","0","1"),
("45587","Grundig","19174","0","0","1"),
("45588","Inni producenci","14241","14","0","1"),
("45589","Philips","14241","6","0","1"),
("45590","LG","14241","3","0","1"),
("45591","Samsung","14241","8","0","1"),
("45592","Panasonic","14241","5","0","1"),
("45593","Sony","14241","10","0","1"),
("45594","250 mm","1322","6","0","1"),
("45626","Gainery","19655","1","0","1"),
("45627","Narzędzia","16419","0","0","1"),
("45628","Oleje i smary","16419","1","0","1"),
("45629","Pozostałe","16419","2","0","1"),
("45646","Inne nominały","3667","4","0","1"),
("45647","Zestawy","3667","5","0","1"),
("45648","1 – 5 centów","3667","0","0","1"),
("45649","10 – 50 centów","3667","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45650","1 euro","3667","2","0","1"),
("45651","2 euro","3667","3","0","0"),
("45657","Makijaż","1429","0","0","0"),
("45658","Manicure i pedicure","1429","1","0","0"),
("45660","Oczy","45657","0","0","0"),
("45661","Twarz","45657","1","0","0"),
("45662","Usta","45657","2","0","0"),
("45663","Pozostałe","45657","5","0","1"),
("45664","Cienie","45660","1","0","1"),
("45665","Kredki do oczu","45660","4","0","1"),
("45666","Tusze do rzęs","45660","8","0","1"),
("45667","Pozostałe","45660","10","0","1"),
("45668","Podkłady","45661","4","0","1"),
("45669","Pudry","45661","5","0","1"),
("45670","Róże do policzków","45661","7","0","1"),
("45671","Pozostałe","45661","9","0","1"),
("45672","Pielęgnacja ust","45662","3","0","1"),
("45673","Błyszczyki","45662","0","0","1"),
("45674","Konturówki","45662","1","0","1"),
("45675","Pomadki","45662","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45676","Pozostałe","45662","4","0","1"),
("45677","Pozostałe","45658","13","0","1"),
("45678","Akcesoria i przybory","45658","0","0","0"),
("45679","Akryle i żele","45658","1","0","0"),
("45680","Lakiery do paznokci","45658","2","0","1"),
("45681","Odżywki do paznokci i skórek","45658","6","0","0"),
("45682","Ozdoby","45658","7","0","1"),
("45683","Podkłady, bazy","45658","8","0","1"),
("45684","Sztuczne paznokcie, tipsy","45658","9","0","1"),
("45685","Urządzenia","45658","10","0","0"),
("45686","Zmywacze, odtłuszczacze, kleje","45658","12","0","0"),
("45687","Nożyczki, cążki, gilotyny","45678","0","0","1"),
("45688","Patyczki i pędzelki","45678","1","0","1"),
("45689","Pilniki i polerki","45678","2","0","1"),
("45690","Waciki","45678","6","0","1"),
("45691","Zestawy akcesoriów","45678","7","0","1"),
("45692","Pozostałe","45678","8","0","1"),
("45693","Akryle","45679","0","0","1"),
("45694","Żele","45679","1","0","0"),
("45695","Zestawy akrylowe","45679","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45696","Zestawy żelowe","45679","3","0","1"),
("45697","Frezarki do paznokci","45685","0","0","1"),
("45698","Lampy UV i LED","45685","1","0","1"),
("45699","Parafiniarki","45685","2","0","1"),
("45700","Suszarki do paznokci","45685","5","0","1"),
("45701","Pozostałe","45685","6","0","1"),
("45712","Pędzle i akcesoria","45657","4","0","0"),
("45713","Komputerowe PC","9","4","0","0"),
("45714","Komputerowe inne","9","3","0","0"),
("45715","Gry online (MMO)","9","2","0","0"),
("45716","Czasopisma z grami","45713","0","0","1"),
("45717","Dla dzieci","45713","1","0","0"),
("45718","Gry akcji","45713","2","0","1"),
("45719","Logiczne","45713","3","0","1"),
("45720","Przygodowe","45713","5","0","1"),
("45721","Role Playing (RPG)","45713","6","0","0"),
("45722","Sportowe","45713","7","0","1"),
("45723","Strategie","45713","8","0","0"),
("45724","Symulacje","45713","10","0","0"),
("45725","Wyścigi","45713","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45727","Pozostałe","45713","13","0","1"),
("45728","Edukacyjne","45717","0","0","1"),
("45729","Przygodowe","45717","1","0","1"),
("45730","Pozostałe","45717","2","0","1"),
("45734","Action RPG","45721","0","0","1"),
("45735","Pozostałe","45721","2","0","1"),
("45736","RPG","45721","1","0","1"),
("45737","Real Time (RTS)","45723","0","0","1"),
("45738","Turowe","45723","1","0","1"),
("45739","Pozostałe","45723","2","0","1"),
("45742","Commodore&Amiga","45714","0","0","1"),
("45744","Pozostałe","45714","2","0","1"),
("45745","Diablo","45715","1","0","0"),
("45752","Tibia","45715","2","0","0"),
("45753","World of Warcraft","45715","3","0","0"),
("45754","Pozostałe","45715","5","0","1"),
("45755","Konta","45745","0","0","1"),
("45756","Przedmioty","45745","1","0","0"),
("45757","Pozostałe","45745","2","0","1"),
("45760","Ladder (rankingowe)","45756","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45761","Non Ladder (nierankingowe)","45756","1","0","1"),
("45764","PACC","45752","0","0","1"),
("45765","Postacie","45752","1","0","1"),
("45766","Przedmioty","45752","2","0","1"),
("45767","Pozostałe","45752","4","0","1"),
("45768","Konta i postacie","45753","1","0","1"),
("45769","Pre-paidy/Raf","45753","2","0","1"),
("45770","Złoto","45753","3","0","1"),
("45771","Pozostałe","45753","4","0","1"),
("45834","Pozostałe","6057","13","0","1"),
("45835","Zestawy","6057","12","0","1"),
("45836","Chaos Space Marines","6057","2","0","1"),
("45837","Dark Eldar/Drukhari","6057","3","0","1"),
("45838","Eldar/Craftworlds","6057","4","0","1"),
("45839","Astra Militarum","6057","0","0","1"),
("45840","Imperial Inquisition/Inquisition","6057","6","0","1"),
("45841","Necrons","6057","7","0","1"),
("45842","Orks","6057","8","0","1"),
("45843","Space Marines","6057","9","0","1"),
("45844","Tau Empire","6057","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45845","Tyranids","6057","11","0","1"),
("45846","Pozostałe","6101","2","0","1"),
("45847","Dungeons & Dragons","6101","0","0","1"),
("45848","Warhammer","6101","1","0","1"),
("45849","Kości","6051","4","0","1"),
("45850","Scrabble i podobne","6051","8","0","0"),
("45851","Scrabble","45850","0","0","1"),
("45852","Pozostałe","45850","1","0","1"),
("45873","Turystyczne","3970","4","0","1"),
("45901","Chłodzenie procesorów","4687","4","0","1"),
("45902","Chłodzenie kart graficznych","4687","1","0","1"),
("45903","Radiatory","4687","13","0","0"),
("45904","Chłodzenie pamięci","4687","2","0","1"),
("45905","Chłodzenie dysku i napędów","4687","0","0","1"),
("45906","Wentylatory","4687","15","0","0"),
("45907","40x40 mm","45906","0","0","1"),
("45908","50x50 mm","45906","1","0","1"),
("45909","60x60 mm","45906","2","0","1"),
("45910","70x70 mm","45906","3","0","1"),
("45911","80x80 mm","45906","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("45912","92x92 mm","45906","5","0","1"),
("45913","120x120 mm","45906","6","0","1"),
("45914","inne wentylatory","45906","7","0","1"),
("45915","40x40 mm","45903","0","0","1"),
("45916","inne radiatory","45903","1","0","1"),
("45917","Chłodzenie płyt głównych","4687","3","0","1"),
("45918","Grile i maskownice","4687","7","0","1"),
("45919","Panele, czytniki","4687","11","0","1"),
("45920","Maty, tłumiki, kołki","4687","8","0","1"),
("45939","Windows Vista Home","4654","5","0","1"),
("45940","Adaptery IDE/SATA","4483","0","0","1"),
("45945","Uzdatnianie wody","28049","3","0","1"),
("46000","Zestawy","3601","2","0","1"),
("46001","Zestawy","3603","2","0","1"),
("46002","Zestawy","3602","2","0","1"),
("46003","skala 1:32","1064","2","0","0"),
("46025","N95","4978","100","0","1"),
("46083","XG 30","4038","29","0","1"),
("46084","Spark","12399","26","0","1"),
("46085","Captiva","12399","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46086","Cee\'d","8642","2","0","0"),
("46087","Grand Vitara","4053","3","0","0"),
("46088","I (1996-2007)","12631","0","0","1"),
("46089","II (2008-)","12631","1","0","1"),
("46090","I (1996-2010)","12466","0","0","1"),
("46091","II (2008- )","12466","1","0","1"),
("46092","Mk5 (1999-2002)","12509","4","0","1"),
("46093","B5 FL (2000-2005)","12710","5","0","1"),
("46094","II FL (1999-2002)","12669","2","0","1"),
("46096","Cobi","11823","2","0","1"),
("46097","Drewniane","11823","3","0","1"),
("46098","Schody","1520","13","0","0"),
("46099","Klimatyzacja i wentylacja","1520","6","0","0"),
("46100","Drzwi wewnętrzne","15958","1","0","1"),
("46101","Drzwi zewnętrzne","15958","2","0","1"),
("46106","Domofony i videodomofony","1523","1","0","1"),
("46107","Zabezpieczenia i rozdzielnice","1523","9","0","1"),
("46109","Wyłączniki i ściemniacze","1523","8","0","1"),
("46112","Pozostałe","15964","4","0","1"),
("46113","Centrale alarmowe","15964","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46114","Detektory","15964","1","0","1"),
("46115","Sygnalizatory","15964","2","0","1"),
("46116","Zestawy alarmowe","15964","3","0","1"),
("46117","Pozostałe","1521","7","0","1"),
("46119","Pokrycia dachowe","1521","4","0","1"),
("46120","Folie i izolacja","1521","3","0","1"),
("46121","Kuchnia","1524","1","0","0"),
("46122","Łazienka i toaleta","1524","2","0","0"),
("46124","Akcesoria i narzędzia","1524","0","0","0"),
("46125","Baterie kuchenne","46121","0","0","1"),
("46126","Zlewy","46121","1","0","1"),
("46127","Pozostałe","46121","3","0","1"),
("46128","Baterie łazienkowe","46122","0","0","1"),
("46129","Kabiny, brodziki i akcesoria","46122","3","0","0"),
("46130","Umywalki","46122","10","0","1"),
("46132","Wanny","46122","11","0","1"),
("46133","Pozostałe","46122","14","0","1"),
("46139","Narzędzia","46124","0","0","1"),
("46140","Rury i kształtki","46124","1","0","1"),
("46141","Wodomierze i liczniki","46124","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46143","Pozostałe","46124","6","0","1"),
("46144","Bramy","15957","1","0","1"),
("46146","Napędy","15957","3","0","1"),
("46147","Skrzynki na listy","15957","6","0","1"),
("46148","Pozostałe","15957","7","0","1"),
("46156","Okna ścienne","15959","6","0","1"),
("46157","Okna dachowe","15959","4","0","1"),
("46158","Pozostałe","15960","7","0","1"),
("46159","Deski podłogowe","15960","1","0","1"),
("46160","Płytki podłogowe","15960","5","0","1"),
("46161","Panele i akcesoria","15960","3","0","1"),
("46162","Parkiety","15960","4","0","1"),
("46163","Pozostałe","1527","16","0","1"),
("46164","Cegły i kamienie","1527","0","0","1"),
("46165","Płytki ścienne","1527","10","0","1"),
("46166","Tapety","1527","13","0","0"),
("46168","Pozostałe","15959","11","0","1"),
("46174","I (1989-1992)","12516","0","0","1"),
("46175","II (1993-1997)","12516","1","0","1"),
("46176","I (1995-1999)","12578","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46177","II (1999-2004)","12578","1","0","1"),
("46659","Ekrany projekcyjne","28150","0","0","1"),
("46660","Akcesoria archiwizacyjne","8852","0","0","0"),
("46661","Folie i pergaminy","46660","0","0","1"),
("46662","Segregatory","46660","1","0","1"),
("46663","Pozostałe","46660","2","0","1"),
("46666","2GB","16251","1","0","1"),
("46745","Trance","279","24","0","1"),
("46778","Aparaty wewnętrzne","19285","0","0","1"),
("46779","Płyty główne","19285","9","0","1"),
("46780","Głośniki zewnętrzne","4802","1","0","1"),
("46781","Moduły GPS","348","10","0","1"),
("46785","6300","4978","56","0","1"),
("46786","E65","4978","90","0","1"),
("46790","K550i","5044","5","0","1"),
("46792","Akcesoria","242","0","0","0"),
("46793","Folie","46792","0","0","1"),
("46795","Pozostałe","46792","1","0","1"),
("46796","Urządzenia","242","1","0","1"),
("46802","Maxcom","456","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46805","Castel","241","1","0","1"),
("46806","Siemens","241","4","0","1"),
("46807","Maxcom","241","2","0","1"),
("46808","Panasonic","241","3","0","1"),
("46809","Alcatel","241","0","0","1"),
("46810","Inne marki","241","5","0","1"),
("46811","Uszkodzone","241","6","0","1"),
("46812","Akcesoria","240","0","0","0"),
("46813","Baterie i akumulatory","46812","0","0","1"),
("46814","Kable i przewody","46812","2","0","1"),
("46815","Zasilacze i ładowarki","46812","3","0","1"),
("46816","Gniazda i wtyki","46812","1","0","1"),
("46817","Pozostałe","46812","4","0","1"),
("46818","Kable i wtyki","5060","2","0","1"),
("46819","Mierniki","5060","3","0","1"),
("46820","Głośniki","5060","1","0","1"),
("46848","Lampy naftowe","26025","2","0","1"),
("46849","Lampy podłogowe","26025","3","0","1"),
("46850","Części i akcesoria","26025","6","0","1"),
("46851","Pozostałe","26025","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("46853","Kinkiety","26025","0","0","1"),
("47003","Puchary i statuetki","3923","12","0","1"),
("47009","KE970","10539","19","0","1"),
("47017","W200i","5044","12","0","1"),
("47020","Boxy","19286","0","0","0"),
("47022","Komplety","47020","1","0","1"),
("47023","Kable","47020","0","0","1"),
("47024","Urządzenia","47020","2","0","1"),
("47025","Pozostałe","47020","3","0","1"),
("47445","Windows Vista Business/Ultimate","4654","6","0","1"),
("47476","Pozostałe","5315","4","0","1"),
("47477","Lampy","5315","1","0","0"),
("47478","Kinkiety","5315","0","0","1"),
("47479","Żarówki i oprawy","5315","2","0","1"),
("47480","Pozostałe","47477","3","0","1"),
("47481","Stojące","47477","1","0","1"),
("47482","Wiszące","47477","2","0","1"),
("47483","Najazdowe","47477","0","0","1"),
("47492","Nawadnianie","1532","10","0","0"),
("47493","Grillowanie","1532","5","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("47501","Bonsai","776","0","0","0"),
("47502","Akcesoria i narzędzia","47501","0","0","1"),
("47503","Drzewka","47501","1","0","1"),
("47532","Pozostałe","28101","2","0","1"),
("47533","Ozdobne","28101","0","0","1"),
("47534","Pocztowe","28101","1","0","1"),
("47625","Pozostałe","5366","4","0","1"),
("47627","Kosmetyki po opalaniu","5366","0","0","1"),
("47628","Opalanie na słońcu","5366","1","0","1"),
("47629","Opalanie w solarium","5366","2","0","1"),
("47630","Samoopalacze","5366","3","0","1"),
("47631","Koloryzacja","1436","0","0","1"),
("47792","3110 Classic","4978","38","0","1"),
("47811","Crystal case","353","0","0","0"),
("47812","Pozostałe","47811","7","0","1"),
("47814","LG","47811","1","0","1"),
("47815","Motorola","47811","2","0","1"),
("47817","Nokia","47811","3","0","1"),
("47820","Samsung","47811","4","0","1"),
("47822","SonyEricsson","47811","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("47910","Zabytki techniki","26014","7","0","0"),
("47911","Maszyny do pisania","47910","3","0","1"),
("47912","Maszyny do szycia","47910","4","0","1"),
("47913","Młynki","47910","6","0","1"),
("47914","Wagi","47910","18","0","1"),
("47915","Żelazka","47910","19","0","1"),
("47916","Patefony i gramofony","47910","8","0","0"),
("47917","Rzutniki, projektory, kamery","47910","11","0","1"),
("47918","Barometry","47910","1","0","1"),
("47919","Klucze, kłódki, zamki","47910","2","0","1"),
("47920","Stare radia","47910","13","0","1"),
("47921","Stare telefony","47910","14","0","1"),
("47922","Stare telewizory","47910","15","0","1"),
("47923","Urządzenia optyczne","47910","16","0","1"),
("47924","Urządzenia pomiarowe","47910","17","0","1"),
("47925","Maszyny liczące","47910","5","0","1"),
("47926","Narzędzia","47910","7","0","1"),
("47927","Podzespoły RTV","47910","9","0","1"),
("47928","Pozostałe","47910","20","0","1"),
("47929","Gramofony","47916","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("47930","Patefony","47916","1","0","1"),
("47931","Płyty","47916","3","0","1"),
("47932","Kartki zaopatrzeniowe","1052","4","0","1"),
("47933","Kalendarze listkowe","316","8","0","1"),
("47934","Breloki","316","2","0","1"),
("47935","Długopisy i pióra","316","3","0","1"),
("47936","Pamiątki PRL-u","6","7","0","0"),
("47937","Trafika","6","11","0","0"),
("47938","Artykuły drogeryjne","47936","0","0","1"),
("47939","Bibeloty","47936","1","0","1"),
("47940","Czasopisma i książki","47936","2","0","1"),
("47941","Dokumenty","47936","3","0","1"),
("47942","Medale i odznaczenia","47936","4","0","1"),
("47943","Naczynia i sztućce","47936","5","0","1"),
("47944","Odzież, obuwie, dodatki","47936","6","0","1"),
("47945","Opakowania","47936","7","0","1"),
("47946","Postacie PRL-u","47936","8","0","1"),
("47947","Reklama i propaganda","47936","10","0","1"),
("47948","Sztandary, godła, proporczyki","47936","11","0","1"),
("47949","Tablice informacyjno – ostrzegawcze","47936","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("47950","Urządzenia","47936","13","0","1"),
("47951","Zabawki","47936","14","0","1"),
("47952","Pozostałe","47936","15","0","1"),
("47953","Cygara i cygaretki","47937","1","0","0"),
("47955","Tabaka","47937","4","0","1"),
("47956","Zapalniczki","47937","5","0","1"),
("47957","Pozostałe","47937","6","0","1"),
("47958","Cygara","47953","0","0","1"),
("47959","Akcesoria","47953","2","0","1"),
("47971","Naparstki","26085","5","0","1"),
("48879","Skrypty","15821","6","0","1"),
("48890","Flash 8GB","9578","3","0","1"),
("48891","Pokrowce i etui","9578","8","0","1"),
("48892","Nośniki Blu-Ray/HD-DVD","4484","4","0","1"),
("48897","Napędy Blu-Ray/HD-DVD","4475","8","0","1"),
("48905","Części","4693","0","0","1"),
("48906","Zestawy","4693","1","0","1"),
("48940","PCMCIA na PCI","4738","5","0","1"),
("48941","Pozostałe","4726","2","0","1"),
("48942","Przedłużacze","4726","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("48943","A - B","4726","0","0","1"),
("48947","160GB - 299GB","4495","1","0","1"),
("48978","Apple","165","3","0","0"),
("49053","Pochłaniacze pyłu","45685","3","0","1"),
("49054","Palety do makijażu i zestawy","45657","3","0","1"),
("49122","Części i podzespoły","11","1","0","1"),
("49124","Denon","332","1","0","1"),
("49125","Grundig","332","2","0","1"),
("49126","Sharp","332","13","0","1"),
("49128","Głośniki przenośne","20134","6","0","1"),
("49129","Ładowarki","20134","7","0","1"),
("49130","Pentagram","20141","4","0","1"),
("49142","Akcesoria","712","5","0","1"),
("49143","Części i podzespoły","717","2","0","1"),
("49144","Pozostałe","14216","3","0","1"),
("49145","Anteny","14216","0","0","1"),
("49146","Wzmacniacze","14216","2","0","1"),
("49147","Harman Kardon","337","4","0","1"),
("49148","Thomson","337","14","0","1"),
("49149","Pozostałe","14227","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49150","Ekrany","14227","0","0","1"),
("49151","Lampy","14227","1","0","1"),
("49152","Uchwyty","14227","2","0","1"),
("49153","Pozostali producenci","14226","14","0","1"),
("49154","Acer","14226","0","0","1"),
("49155","BenQ","14226","1","0","1"),
("49156","Epson","14226","3","0","1"),
("49157","Samsung","14226","9","0","1"),
("49158","Thomson","19174","6","0","1"),
("49159","Sharp","14241","9","0","1"),
("49160","Inni producenci","5123","4","0","1"),
("49161","LG","5123","0","0","1"),
("49162","Panasonic","5123","1","0","1"),
("49163","Pioneer","5123","2","0","1"),
("49164","Samsung","5123","3","0","1"),
("49165","Harman Kardon","727","1","0","1"),
("49166","Pozostałe","24","1","0","1"),
("49167","Naukowe","24","0","0","1"),
("49183","Ogrzewanie, wentylacja, klimatyzacja","620","4","0","0"),
("49184","Klimatyzacja","49183","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49185","Pozostałe","49184","10","0","1"),
("49186","Chłodnice klimatyzacji (skraplacze)","49184","0","0","1"),
("49187","Kompletne instalacje","49184","2","0","1"),
("49188","Parowniki","49184","5","0","1"),
("49189","Osuszacze","49184","4","0","1"),
("49190","Przewody klimatyzacji","49184","6","0","1"),
("49192","Kompresory klimatyzacji","49184","3","0","0"),
("49193","Ogrzewanie, wentylacja","49183","2","0","0"),
("49194","Ogrzewanie postojowe","49183","1","0","0"),
("49195","Dmuchawy","49193","0","0","1"),
("49196","Pozostałe","49193","7","0","1"),
("49197","Nagrzewnice","49193","1","0","1"),
("49198","Części","49194","0","0","1"),
("49199","Kompletne instalacje","49194","1","0","1"),
("49200","Dekielki","18730","1","0","1"),
("49201","Dystanse","18730","2","0","1"),
("49202","Sterowniki i elementy elektryczne","49184","7","0","1"),
("49217","Brera","4030","11","0","1"),
("49218","A5","4031","8","0","0"),
("49219","R8","4031","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49220","Pozostałe","18093","9","0","1"),
("49221","CTS","18093","1","0","1"),
("49222","DeVille","18093","2","0","1"),
("49223","Eldorado","18093","4","0","1"),
("49224","Escalade","18093","5","0","1"),
("49225","Tahoe","12399","28","0","1"),
("49226","Suburban","12399","27","0","1"),
("49227","TrailBlazer","12399","29","0","1"),
("49228","Epica","12399","11","0","1"),
("49229","Cavalier","12399","7","0","1"),
("49230","Express","12399","14","0","1"),
("49231","Equinox","12399","12","0","1"),
("49232","Le Baron","12400","6","0","1"),
("49233","New Yorker","12400","8","0","1"),
("49235","C6","4033","16","0","1"),
("49236","Filtry","620","2","0","0"),
("49237","Kabinowe","49236","0","0","1"),
("49239","Oleju","49236","2","0","1"),
("49240","Paliwa","49236","3","0","1"),
("49241","Powietrza","49236","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49242","Zestawy filtrów","49236","7","0","1"),
("49243","Sirion","12401","8","0","1"),
("49244","Rocky","12401","7","0","1"),
("49246","Avenger","12402","0","0","1"),
("49247","Charger","12402","4","0","1"),
("49248","Nitro","12402","13","0","1"),
("49249","Linea","4035","20","0","1"),
("49250","Sedici","4035","30","0","1"),
("49251","Strada","4035","34","0","1"),
("49252","500","4035","3","0","1"),
("49253","I (1995-2001)","12490","0","0","1"),
("49254","II (2007-)","12490","1","0","1"),
("49255","Lampy ostrzegawcze, koguty","623","5","0","1"),
("49256","S-MAX","4036","32","0","0"),
("49257","C-MAX","4036","2","0","0"),
("49258","Eos","4055","10","0","1"),
("49259","Mk4 (2007-2014)","12514","3","0","1"),
("49260","Caddy","4055","4","0","0"),
("49261","Mk2 (2006-2015)","12512","1","0","1"),
("49262","Tundra","4054","31","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49263","Element","4037","7","0","1"),
("49264","Integra","4037","11","0","1"),
("49265","Pilot","4037","16","0","1"),
("49266","Shuttle","4037","20","0","1"),
("49267","i30","4038","14","0","0"),
("49268","Trajet","4038","26","0","1"),
("49269","XK","8641","7","0","0"),
("49271","Commander","12404","1","0","1"),
("49272","Compass","12404","2","0","1"),
("49273","Tacoma","4054","30","0","1"),
("49274","Carens","8642","0","0","0"),
("49275","Matrix","4054","18","0","1"),
("49276","Magentis","8642","6","0","1"),
("49277","Retona","8642","13","0","1"),
("49278","Auris","4054","1","0","0"),
("49279","Tribeca","4052","8","0","1"),
("49280","Avantime","4047","5","0","1"),
("49281","Montero","4042","11","0","1"),
("49282","Antara","4044","3","0","1"),
("49283","IV (2007-)","12583","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("49284","Tiida","4043","35","0","1"),
("49285","Qashqai","4043","27","0","0"),
("49286","Prairie","4043","23","0","1"),
("49356","Pojemniki, pudełka","45678","4","0","1"),
("49484","K850i","5044","9","0","1"),
("49844","Baseny","1532","3","0","0"),
("49845","Akcesoria basenowe","49844","0","0","1"),
("49846","Baseny","49844","1","0","1"),
("49855","Abażury i klosze","5317","0","0","1"),
("49862","Firany gotowe","15981","1","0","1"),
("49863","Firany na metry","15981","2","0","1"),
("49864","Akcesoria do firan","15981","0","0","1"),
("49865","Zasłony gotowe","15982","1","0","1"),
("49866","Zasłony na metry","15982","2","0","1"),
("49867","Akcesoria do zasłon","15982","0","0","1"),
("49870","Zestawy garnków","15978","9","0","1"),
("49871","Chlebaki","5328","3","0","1"),
("49890","Brytfanny","15978","0","0","1"),
("50311","Denon","5232","0","0","1"),
("50312","Kenwood","5232","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50367","KU990","10539","22","0","1"),
("50374","5310","4978","50","0","1"),
("50376","6500 Classic","4978","60","0","1"),
("50377","6500 Slide","4978","61","0","1"),
("50386","W910i","5044","16","0","1"),
("50438","do 1999","1115","0","0","1"),
("50439","od 2000","1115","1","0","1"),
("50440","po 1947","14091","1","0","1"),
("50441","do 1947","14091","0","0","1"),
("50442","Medale i odznaczenia","6","3","0","0"),
("50443","Medale","50442","0","0","0"),
("50444","Odznaczenia","50442","1","0","0"),
("50445","Odznaki","50442","2","0","0"),
("50446","Plakiety","50442","3","0","1"),
("50447","Kopie","50442","5","0","1"),
("50448","Francja","50443","1","0","1"),
("50449","Niemcy","50443","2","0","1"),
("50450","Polska","50443","3","0","0"),
("50451","Rosja i ZSRR","50443","4","0","1"),
("50452","Pozostałe","50443","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50453","do 1945","50450","0","0","1"),
("50454","po 1945","50450","1","0","1"),
("50455","Polska","50444","1","0","1"),
("50456","Pozostałe","50444","3","0","1"),
("50457","Niemcy","50445","0","0","1"),
("50458","Polska","50445","1","0","0"),
("50459","Rosja i ZSRR","50445","2","0","1"),
("50460","Pozostałe","50445","3","0","1"),
("50461","do 1939","50458","0","0","1"),
("50590","Obiektywy","8845","5","0","0"),
("50591","Canon","50590","0","0","1"),
("50593","Nikon","50590","3","0","1"),
("50595","Pentax","50590","4","0","1"),
("50596","System 4/3","50590","8","0","1"),
("50597","M42","50590","2","0","1"),
("50598","Średnio i wielkoformatowe","50590","10","0","1"),
("50599","Pozostałe","50590","11","0","1"),
("50610","Banki danych","8848","0","0","1"),
("50614","4GB i większe","8906","3","0","1"),
("50616","2GB i większe","8908","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50670","Agatki","11825","0","0","1"),
("50671","Baby Annabell","11825","3","0","1"),
("50672","Bratz","11825","7","0","1"),
("50673","Artykuły szkolne","11763","1","0","0"),
("50674","Pozostałe","50673","10","0","1"),
("50675","Artykuły papiernicze","50673","0","0","0"),
("50676","Artykuły plastyczne","50673","1","0","0"),
("50677","Przybory do pisania","50673","5","0","0"),
("50678","Tornistry i plecaki","50673","9","0","1"),
("50679","Torby i worki","50673","7","0","0"),
("50680","Pozostałe","50675","10","0","1"),
("50681","Bloki","50675","0","0","1"),
("50682","Notesy, pamiętniki","50675","4","0","1"),
("50683","Segregatory","50675","7","0","1"),
("50684","Teczki","50675","8","0","1"),
("50685","Zeszyty","50675","9","0","1"),
("50686","Pozostałe","50676","8","0","1"),
("50687","Farbki","50676","0","0","1"),
("50688","Kleje","50676","1","0","1"),
("50689","Kredki","50676","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50690","Nożyczki","50676","4","0","1"),
("50691","Pisaki, mazaki, flamastry","50676","5","0","1"),
("50692","Plasteliny","50676","6","0","1"),
("50693","Pozostałe","50677","5","0","1"),
("50694","Akcesoria","50677","0","0","0"),
("50695","Długopisy","50677","1","0","1"),
("50696","Ołówki","50677","2","0","1"),
("50697","Pióra","50677","3","0","1"),
("50698","Zestawy","50677","4","0","1"),
("50699","Pozostałe","50694","2","0","1"),
("50700","Gumki","50694","0","0","1"),
("50702","Temperówki","50694","1","0","1"),
("50744","Czujniki","4141","2","0","0"),
("50745","Pozostałe","50744","5","0","1"),
("50751","Materiały instalacyjne","4141","3","0","0"),
("50752","Pozostałe","50751","4","0","1"),
("50753","Kostki, złączki","50751","2","0","1"),
("50754","Wiązki przewodów","50751","3","0","1"),
("50755","Przekaźniki","4141","5","0","1"),
("50756","Stacyjki i kluczyki","4141","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50759","Zapłonowe","18833","0","0","1"),
("50760","Żarowe","18833","1","0","1"),
("50761","Układ elektryczny silnika","4141","10","0","0"),
("50762","Pozostałe","50761","6","0","1"),
("50763","Moduły zapłonowe","50761","3","0","1"),
("50764","Wyposażenie elektryczne","4141","11","0","0"),
("50765","Pozostałe","50764","10","0","1"),
("50766","Klaksony","50764","1","0","1"),
("50768","Bezpieczniki","50751","0","0","1"),
("50769","Alternatory","50761","0","0","1"),
("50770","Aparaty zapłonowe","50761","1","0","1"),
("50771","Cewki zapłonowe","50761","2","0","1"),
("50772","Przewody zapłonowe","50761","4","0","1"),
("50773","Rozruszniki","50761","5","0","1"),
("50775","Silniczki regulacji fotela","50764","7","0","1"),
("50776","Silniczki szyb","50764","8","0","1"),
("50777","Silniczki szyberdachu","50764","9","0","1"),
("50779","Gniazda zapalniczki","50764","0","0","1"),
("50821","Silniki i osprzęt","620","6","0","0"),
("50822","Pozostałe","50821","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50823","Blok silnika","50821","0","0","0"),
("50824","Pozostałe","50823","10","0","1"),
("50825","Bloki","50823","0","0","1"),
("50827","Koła zamachowe","50823","2","0","1"),
("50828","Panewki","50823","5","0","1"),
("50829","Pierścienie tłokowe","50823","6","0","1"),
("50830","Tłoki","50823","7","0","1"),
("50831","Wały korbowe","50823","9","0","1"),
("50832","Elementy napędu","50821","3","0","0"),
("50833","Pozostałe","50832","4","0","1"),
("50834","Napinacze paska klinowego","50832","1","0","1"),
("50835","Paski klinowe","50832","2","0","1"),
("50836","Głowice cylindrów","50821","4","0","0"),
("50837","Pozostałe","50836","11","0","1"),
("50838","Głowice","50836","1","0","1"),
("50839","Pokrywy zaworów","50836","2","0","1"),
("50840","Uszczelki głowicy","50836","6","0","1"),
("50841","Kolektory ssące","50821","5","0","1"),
("50842","Rozrząd","50821","14","0","0"),
("50843","Pozostałe","50842","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50844","Kompletne rozrządy","50842","2","0","1"),
("50845","Napinacze paska","50842","5","0","1"),
("50846","Paski rozrządu","50842","7","0","1"),
("50847","Obudowy","50842","6","0","1"),
("50848","Wałki rozrządu","50842","10","0","1"),
("50849","Silniki kompletne","50821","15","0","0"),
("50850","Benzynowe","50849","0","0","1"),
("50851","Diesel","50849","1","0","1"),
("50852","Smarowanie silnika","50821","17","0","0"),
("50853","Pozostałe","50852","10","0","1"),
("50854","Czujniki ciśnienia oleju","50852","1","0","1"),
("50855","Miski olejowe","50852","5","0","1"),
("50856","Uszczelki miski","50852","9","0","1"),
("50857","Turbosprężarki","50821","18","0","0"),
("50858","Zawieszenie silnika","50821","19","0","0"),
("50859","Pozostałe","50858","3","0","1"),
("50860","Poduszki silnika","50858","0","0","1"),
("50861","Wsporniki i łapy","50858","2","0","1"),
("50862","Silniki krokowe","50821","16","0","1"),
("50863","Układ napędowy","620","11","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50864","Pozostałe","50863","5","0","1"),
("50865","Dyferencjały","50863","0","0","1"),
("50866","Mosty","50863","1","0","0"),
("50867","Przednie","50866","0","0","1"),
("50868","Tylne","50866","1","0","1"),
("50871","Skrzynie biegów","50863","3","0","0"),
("50872","Pozostałe","50871","10","0","1"),
("50873","Kompletne skrzynie","50871","0","0","1"),
("50880","Sprzęgła","50863","4","0","0"),
("50881","Pozostałe","50880","12","0","1"),
("50882","Dociski sprzęgła","50880","0","0","1"),
("50883","Koła dwumasowe","50880","1","0","1"),
("50884","Kompletne sprzęgła","50880","3","0","1"),
("50885","Łożyska oporowe","50880","7","0","1"),
("50886","Pompy sprzęgła","50880","8","0","1"),
("50887","Tarcze","50880","10","0","1"),
("50894","C-Crosser","4033","18","0","1"),
("50895","110","8643","0","0","1"),
("50896","Seria B","4040","23","0","1"),
("50897","BT-50","4040","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("50898","Demio","4040","14","0","1"),
("50899","CX-7","4040","12","0","1"),
("50900","CX-9","4040","13","0","1"),
("50901","W204 (2007-2014)","12734","2","0","1"),
("50902","Sentra","4043","31","0","1"),
("50903","III (2007-)","12646","2","0","1"),
("50904","SX4","4053","11","0","0"),
("50905","Tiguan","4055","26","0","0"),
("50906","C30","4056","0","0","1"),
("50907","Seria 300","4056","16","0","1"),
("50970","Zestawy","19285","22","0","1"),
("50971","BlackBerry","165","5","0","0"),
("50977","E51","4978","87","0","1"),
("50995","K770i","5044","7","0","1"),
("50999","Uszkodzone","165","39","0","0"),
("51000","LG","50999","4","0","1"),
("51001","Motorola","50999","5","0","1"),
("51002","Nokia","50999","6","0","1"),
("51003","Sagem","50999","7","0","1"),
("51004","Samsung","50999","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("51005","Siemens","50999","10","0","1"),
("51006","Sony Ericsson","50999","12","0","1"),
("51007","Inne marki","50999","13","0","1"),
("51139","Pojazdy wojskowe","3582","0","0","1"),
("51140","Akcesoria","3582","1","0","1"),
("51141","Skala 1:48","1065","1","0","0"),
("51142","Pojazdy wojskowe","51141","0","0","1"),
("51143","Akcesoria","51141","1","0","1"),
("51144","Samoloty i szybowce","8761","1","0","1"),
("51145","Śmigłowce","8761","2","0","1"),
("51146","Statki powietrzne","46003","0","0","1"),
("51147","Akcesoria","46003","1","0","1"),
("51148","Statki powietrzne","26947","0","0","1"),
("51149","Akcesoria","26947","1","0","1"),
("51710","Harman Kardon","5232","1","0","1"),
("51711","Marantz","5232","4","0","1"),
("51712","Harman Kardon","20221","4","0","1"),
("51713","Marantz","20221","6","0","1"),
("51759","Carpower","714","4","0","1"),
("51760","Lanzar","714","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("51761","Odtwarzacze Blu-ray","717","7","0","0"),
("51829","Zestawy","5119","6","0","1"),
("51830","Toshiba","14241","13","0","1"),
("52173","Flash 16GB","9578","2","0","1"),
("52175","Uszkodzone","4415","5","0","1"),
("52176","Uszkodzone","4564","10","0","1"),
("52177","Elektronika","4495","7","0","1"),
("52180","Szablony i kursy","70","2","0","1"),
("52329","Stare magnetofony","47910","12","0","1"),
("52331","Krzyżyki","26087","0","0","1"),
("52332","Medaliki","26087","1","0","1"),
("52333","Modlitewniki","26087","2","0","1"),
("52334","Obrazki","26087","3","0","1"),
("52335","Obrazy i figurki","26087","4","0","1"),
("52336","Różańce","26087","5","0","1"),
("52337","Pozostałe","26087","7","0","1"),
("52338","Reprodukcje","26106","5","0","1"),
("52410","Adaptery do telefonów","351","9","0","1"),
("52411","Przejściówki","351","10","0","1"),
("52412","Apple","19321","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("52426","Benq-Siemens","50999","1","0","1"),
("52550","4x6\'\'","1322","9","0","1"),
("52553","Audison","714","1","0","1"),
("52554","Crunch","714","6","0","1"),
("52555","Helix","714","10","0","1"),
("52556","Hifonics","714","12","0","1"),
("52557","Steg","714","22","0","1"),
("52558","Tunery","14216","1","0","1"),
("52734","Dance","5611","0","0","1"),
("52735","House","5611","1","0","1"),
("52736","R\'n\'B, Soul","5611","5","0","1"),
("52737","Metal","175","11","0","0"),
("52738","Polski","52737","0","0","1"),
("52739","Zagraniczny","52737","1","0","0"),
("52740","Pozostałe","52739","7","0","1"),
("52741","Black","52739","0","0","1"),
("52742","Death","52739","1","0","1"),
("52743","Gothic","52739","2","0","1"),
("52744","Heavy","52739","3","0","1"),
("52745","Power","52739","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("52746","Stoner, Doom","52739","5","0","1"),
("52747","Thrash","52739","6","0","1"),
("52748","Zagraniczna","1364","1","0","0"),
("52749","Polska","1364","0","0","1"),
("52750","Zagraniczny","193","1","0","1"),
("52751","Polski","193","0","0","1"),
("52752","Zagraniczne","325","1","0","1"),
("52753","Polskie","325","0","0","1"),
("52754","Pudełka, okładki, case\'y","12825","0","0","1"),
("52755","Konserwacja nośników","12825","3","0","1"),
("52890","Lupy","19286","2","0","1"),
("52892","Wanny ultradźwiękowe","19286","6","0","1"),
("52893","Płyty klawiatury","19285","10","0","1"),
("52894","Płyty wyświetlacza","19285","11","0","1"),
("52895","Szybki","19285","13","0","1"),
("52896","Zawiasy","19285","20","0","1"),
("52919","W890i","5044","15","0","1"),
("52970","Piłkarzyki","13408","7","0","0"),
("52971","Mistrzostwa Europy 2012","3923","0","0","1"),
("53201","Akcesoria","1469","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("53450","Gadżety","9","0","0","0"),
("53451","Figurki","53450","0","0","1"),
("53452","Koszulki","53450","1","0","1"),
("53453","Pozostałe","53450","4","0","1"),
("53454","Mac","45714","1","0","1"),
("53612","Kosmos","414","4","0","1"),
("53615","Pozostałe","9589","12","0","1"),
("53619","Polska","17888","0","0","1"),
("53620","Pozostałe","17888","1","0","1"),
("53621","Polska","17890","0","0","1"),
("53622","Pozostałe","17890","1","0","1"),
("53623","Polska","17891","0","0","1"),
("53624","Pozostałe","17891","1","0","1"),
("53625","Polska","17887","0","0","1"),
("53626","Pozostałe","17887","1","0","1"),
("53627","Austria","9612","0","0","1"),
("53628","Szwajcaria","9612","3","0","1"),
("53629","Liechtenstein","9612","1","0","1"),
("53630","San Marino","9612","2","0","1"),
("53631","Watykan","9612","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("53632","Włochy","9612","5","0","1"),
("53633","Pozostałe","9612","6","0","1"),
("53634","Strefy okupacyjne i Saarland","3627","0","0","1"),
("53635","NRD i Berlin Zachodni","3627","1","0","1"),
("53636","RFN","3627","2","0","1"),
("53637","Transport","316","18","0","0"),
("53638","Kolejnictwo","53637","0","0","0"),
("53639","Komunikacja miejska i PKS","53637","1","0","0"),
("53640","Lotnictwo","53637","2","0","0"),
("53641","Akcesoria","53638","0","0","1"),
("53642","Bilety","53638","1","0","1"),
("53643","Rozkłady jazdy","53638","3","0","1"),
("53644","Literatura","53638","4","0","1"),
("53645","Pozostałe","53638","5","0","1"),
("53646","Bilety","53639","0","0","0"),
("53647","Literatura","53639","1","0","1"),
("53648","Pozostałe","53639","2","0","1"),
("53649","Komunikacja miejska","53646","0","0","1"),
("53650","PKS","53646","1","0","1"),
("53651","Zestawy","53646","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("53652","Bilety","53640","0","0","1"),
("53653","Filmy i zdjęcia","53640","1","0","1"),
("53654","Plakiety, emblematy, naklejki","53640","2","0","1"),
("53655","Rozkłady lotów","53640","3","0","1"),
("53656","Literatura","53640","4","0","1"),
("53657","Pozostałe","53640","5","0","1"),
("53658","Kolekcje dziecięce","316","10","0","0"),
("53659","Figurki","53658","0","0","1"),
("53660","Karteczki","53658","1","0","1"),
("53661","Obrazki i żetony","53658","2","0","1"),
("53662","Segregatory","53658","3","0","1"),
("53663","Pozostałe","53658","4","0","1"),
("53670","Puszki","316","14","0","1"),
("53671","Etykiety butelkowe","316","4","0","1"),
("53672","Kubki","316","11","0","1"),
("53676","Puszki","953","8","0","1"),
("53677","Literatura","50442","6","0","1"),
("53678","Elementy i akcesoria","50442","4","0","1"),
("53679","polskie","3713","0","0","1"),
("53680","obce","3713","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("53790","Całości 1944 - 1960","9589","3","0","1"),
("53791","Całości 1961 - 1994","9589","4","0","1"),
("53792","Całości od 1995","9589","5","0","1"),
("53793","Całostki 1944 - 1960","9589","7","0","1"),
("53794","Całostki 1961 - 1994","9589","8","0","1"),
("53795","Całostki od 1995","9589","9","0","1"),
("53970","Karty X-SIM/Turbosim","348","6","0","1"),
("53980","E71","4978","93","0","1"),
("53993","C702","5044","1","0","1"),
("53994","C902","5044","2","0","1"),
("54002","iPhone","48978","0","0","1"),
("54003","iPhone 3G","48978","1","0","1"),
("54045","Pudełka","123","10","0","1"),
("54049","Opakowania","11670","3","0","1"),
("54050","Opakowania","11995","3","0","1"),
("54051","Akcesoria łazienkowe","123","0","0","0"),
("54052","Pochłaniacze wilgoci","54051","10","0","1"),
("54054","Wieszaki","54051","15","0","1"),
("54055","Zasłony prysznicowe","54051","16","0","1"),
("54056","Zestawy akcesoriów","54051","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("54057","Pozostałe","54051","18","0","1"),
("54067","Izolacja i ocieplenie","1527","4","0","1"),
("54068","Naklejki i szablony","1527","8","0","1"),
("54089","Stoliki i ławy","1515","8","0","1"),
("54090","Pufy","1515","6","0","1"),
("54746","E66","4978","91","0","1"),
("54926","Uszkodzone","9578","9","0","1"),
("54927","300GB i większe","4495","0","0","1"),
("55067","Wakacje","0","27","0","0"),
("55196","Foldery i ulotki","507","4","0","1"),
("55202","Botki","531","1","0","1"),
("55203","Glany","531","6","0","1"),
("55204","Kalosze","531","7","0","1"),
("55205","Trekkingowe","531","16","0","1"),
("55206","Glany","532","2","0","1"),
("55207","Trekkingowe","532","13","0","1"),
("55208","Asics","5545","2","0","1"),
("55209","DC","5545","6","0","1"),
("55210","Diverse","5545","7","0","1"),
("55211","Ecco","5545","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("55212","Etnies","5545","9","0","1"),
("55213","Expander","5545","10","0","1"),
("55214","Fila","5545","11","0","1"),
("55215","Kappa","5545","13","0","1"),
("55216","Lacoste","5545","14","0","1"),
("55217","Lonsdale","5545","15","0","1"),
("55218","McArthur","5545","16","0","1"),
("55219","New Balance","5545","18","0","1"),
("55220","Salomon","5545","22","0","1"),
("55221","Vans","5545","26","0","1"),
("55222","And1","5546","2","0","1"),
("55223","Asics","5546","3","0","1"),
("55224","Caterpillar","5546","5","0","1"),
("55225","DC","5546","8","0","1"),
("55226","Diverse","5546","9","0","1"),
("55227","Ecco","5546","10","0","1"),
("55228","Everlast","5546","11","0","1"),
("55229","Expander","5546","12","0","1"),
("55230","Fila","5546","13","0","1"),
("55231","Kappa","5546","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("55232","Lacoste","5546","16","0","1"),
("55233","Lonsdale","5546","17","0","1"),
("55234","McArthur","5546","18","0","1"),
("55235","New Balance","5546","20","0","1"),
("55236","Salomon","5546","24","0","1"),
("55237","Skechers","5546","25","0","1"),
("55238","Tommy Hilfiger","5546","27","0","1"),
("55239","Umbro","5546","28","0","1"),
("55240","Vans","5546","29","0","1"),
("55253","Komplety z czapkami","1496","5","0","1"),
("55263","Tonner","11825","24","0","1"),
("55737","LWP 1943 - 1989","3734","3","0","1"),
("55738","Ruch oporu","3734","2","0","1"),
("55739","Ruch oporu","3706","2","0","1"),
("55740","LWP 1943 - 1989","3706","3","0","1"),
("55741","Wielka Brytania","3705","7","0","1"),
("55742","Biżuteria patriotyczna","3705","8","0","1"),
("55743","Wybitne postaci","3727","14","0","1"),
("55744","Kampanie i bitwy","3727","5","0","1"),
("55745","Instrukcje i regulaminy","3724","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("55756","New Age","5545","17","0","1"),
("55757","New Age","5546","19","0","1"),
("55819","Do Apple","351","0","0","1"),
("55831","C905","5044","3","0","1"),
("55833","Sharp","50999","9","0","1"),
("55834","Urządzenia","28282","0","0","1"),
("55835","Akcesoria","28282","1","0","1"),
("57347","HTC","19321","2","0","1"),
("57348","Apple","19320","0","0","1"),
("57356","KP500","10539","20","0","1"),
("57361","W595","5044","14","0","1"),
("57959","LDV","590","12","0","1"),
("57960","MiTo","4030","17","0","1"),
("57961","Q5","4031","15","0","0"),
("57962","B8 (2007-2015)","12429","3","0","1"),
("57965","8N (1998-2006)","12432","0","0","1"),
("57966","8J (2006-2013)","12432","1","0","1"),
("57967","Acura","4029","0","0","0"),
("57968","E53 (1999-2006)","18089","0","0","1"),
("57969","E70 (2006-2013)","18089","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("57970","X6","4032","19","0","0"),
("57971","STS","18093","8","0","1"),
("57972","SRX","18093","7","0","1"),
("57973","BLS","18093","0","0","1"),
("57974","Nubira","12399","22","0","1"),
("57975","HHR","12399","15","0","1"),
("57976","Kalos","12399","17","0","1"),
("57977","Rezzo","12399","24","0","1"),
("57978","Aspen","12400","2","0","1"),
("57979","Journey","12402","10","0","1"),
("57980","Challenger","12402","3","0","1"),
("57981","Diplomat","12402","6","0","1"),
("57982","Lamborghini","4029","30","0","0"),
("57983","Kyron","18396","2","0","1"),
("57984","Actyon","18396","0","0","1"),
("57986","Rodius","18396","5","0","1"),
("57987","Phedra","4039","5","0","1"),
("57988","308","4045","14","0","0"),
("57989","Expert","4045","33","0","1"),
("57990","FJ Cruiser","4054","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("57991","Seria E15 (2007-2013)","12695","5","0","1"),
("57992","Fiero","12408","0","0","1"),
("57993","Mercury","4029","40","0","1"),
("57994","GH (2007-)","12680","2","0","1"),
("57995","Outback","4052","7","0","0"),
("57996","Cayman","8644","8","0","1"),
("57997","Bentley","4029","6","0","0"),
("57998","IV (2008-2017)","12669","4","0","1"),
("57999","MG","4029","41","0","0"),
("58000","Proton","4029","53","0","1"),
("58001","Rolls-Royce","4029","55","0","1"),
("58002","C4 Picasso","4033","14","0","0"),
("58003","I (1998-2002)","12663","0","0","1"),
("58004","II (2003-2011)","12663","1","0","1"),
("58005","VIII (2007-)","12582","6","0","1"),
("58006","Tata","4029","64","0","0"),
("58007","Kuga","4036","22","0","0"),
("58008","Ranger","4036","29","0","1"),
("58009","VI (2008-2013)","12706","5","0","1"),
("59277","Zagraniczne na sprzedaż","20782","14","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("59278","Zagraniczne do wynajęcia","20782","13","0","0"),
("59279","Mieszkania i apartamenty","59277","0","0","0"),
("59280","Domy","59277","1","0","0"),
("59281","Grunty i działki","59277","2","0","0"),
("59282","Lokale użytkowe","59277","3","0","0"),
("59283","Pozostałe","59277","4","0","0"),
("61104","Piercing","19732","7","0","0"),
("61110","Akcesoria","61104","3","0","1"),
("61111","Pozostałe","61104","4","0","1"),
("62218","Biżuteria","26014","0","0","0"),
("62219","Bransoletki ","62218","0","0","1"),
("62220","Broszki","62218","1","0","1"),
("62221","Kolczyki i klipsy","62218","2","0","1"),
("62222","Naszyjniki","62218","3","0","1"),
("62223","Pierścionki","62218","4","0","1"),
("62224","Wisiorki","62218","5","0","1"),
("62225","Pozostałe","62218","6","0","1"),
("62497","Pozostałe","59279","25","0","1"),
("62498","Austria","59279","0","0","1"),
("62500","Brazylia","59279","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62501","Bułgaria","59279","2","0","1"),
("62502","Chorwacja","59279","3","0","1"),
("62503","Cypr","59279","4","0","1"),
("62504","Czarnogóra","59279","5","0","1"),
("62505","Czechy","59279","6","0","1"),
("62507","Egipt","59279","7","0","1"),
("62508","Francja","59279","8","0","1"),
("62509","Hiszpania","59279","10","0","1"),
("62510","Holandia","59279","11","0","1"),
("62511","Irlandia","59279","12","0","1"),
("62515","Niemcy","59279","13","0","1"),
("62516","Portugalia","59279","14","0","1"),
("62517","Rosja","59279","15","0","1"),
("62518","Rumunia","59279","16","0","1"),
("62519","Stany Zjednoczone","59279","18","0","1"),
("62520","Słowacja","59279","17","0","1"),
("62521","Turcja","59279","19","0","1"),
("62522","Ukraina","59279","20","0","1"),
("62523","Wielka Brytania","59279","22","0","1"),
("62524","Węgry","59279","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62525","Włochy","59279","23","0","1"),
("62526","Zjednoczone Emiraty Arabskie","59279","24","0","1"),
("62527","Pozostałe","59280","26","0","1"),
("62528","Austria","59280","0","0","1"),
("62530","Brazylia","59280","1","0","1"),
("62531","Bułgaria","59280","2","0","1"),
("62532","Chorwacja","59280","3","0","1"),
("62533","Cypr","59280","4","0","1"),
("62534","Czarnogóra","59280","5","0","1"),
("62535","Czechy","59280","6","0","1"),
("62537","Egipt","59280","7","0","1"),
("62538","Francja","59280","8","0","1"),
("62539","Hiszpania","59280","10","0","1"),
("62540","Holandia","59280","11","0","1"),
("62541","Irlandia","59280","12","0","1"),
("62545","Niemcy","59280","13","0","1"),
("62547","Rosja","59280","15","0","1"),
("62548","Rumunia","59280","16","0","1"),
("62549","Stany Zjednoczone","59280","18","0","1"),
("62550","Słowacja","59280","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62551","Turcja","59280","20","0","1"),
("62552","Ukraina","59280","21","0","1"),
("62553","Wielka Brytania","59280","23","0","1"),
("62554","Węgry","59280","22","0","1"),
("62555","Włochy","59280","24","0","1"),
("62556","Zjednoczone Emiraty Arabskie","59280","25","0","1"),
("62557","Pozostałe","59281","23","0","1"),
("62558","Austria","59281","0","0","1"),
("62560","Brazylia","59281","1","0","1"),
("62561","Bułgaria","59281","2","0","1"),
("62562","Chorwacja","59281","3","0","1"),
("62563","Cypr","59281","4","0","1"),
("62564","Czarnogóra","59281","5","0","1"),
("62565","Czechy","59281","6","0","1"),
("62567","Egipt","59281","7","0","1"),
("62568","Francja","59281","8","0","1"),
("62569","Hiszpania","59281","9","0","1"),
("62570","Irlandia","59281","10","0","1"),
("62574","Niemcy","59281","11","0","1"),
("62576","Rosja","59281","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62577","Rumunia","59281","14","0","1"),
("62578","Stany Zjednoczone","59281","16","0","1"),
("62579","Słowacja","59281","15","0","1"),
("62580","Turcja","59281","17","0","1"),
("62581","Ukraina","59281","18","0","1"),
("62582","Wielka Brytania","59281","20","0","1"),
("62583","Węgry","59281","19","0","1"),
("62584","Włochy","59281","21","0","1"),
("62585","Zjednoczone Emiraty Arabskie","59281","22","0","1"),
("62586","Pozostałe","59282","24","0","1"),
("62587","Austria","59282","0","0","1"),
("62589","Brazylia","59282","1","0","1"),
("62590","Bułgaria","59282","2","0","1"),
("62591","Chorwacja","59282","3","0","1"),
("62592","Cypr","59282","4","0","1"),
("62593","Czarnogóra","59282","5","0","1"),
("62594","Czechy","59282","6","0","1"),
("62596","Egipt","59282","7","0","1"),
("62597","Francja","59282","8","0","1"),
("62598","Hiszpania","59282","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62599","Holandia","59282","10","0","1"),
("62600","Irlandia","59282","11","0","1"),
("62604","Niemcy","59282","12","0","1"),
("62606","Rosja","59282","14","0","1"),
("62607","Rumunia","59282","15","0","1"),
("62608","Stany Zjednoczone","59282","17","0","1"),
("62609","Słowacja","59282","16","0","1"),
("62610","Turcja","59282","18","0","1"),
("62611","Ukraina","59282","19","0","1"),
("62612","Wielka Brytania","59282","21","0","1"),
("62613","Węgry","59282","20","0","1"),
("62614","Włochy","59282","22","0","1"),
("62615","Zjednoczone Emiraty Arabskie","59282","23","0","1"),
("62616","Pozostałe","59283","28","0","1"),
("62617","Austria","59283","0","0","1"),
("62618","Belgia","59283","1","0","1"),
("62619","Brazylia","59283","2","0","1"),
("62620","Bułgaria","59283","3","0","1"),
("62621","Chorwacja","59283","4","0","1"),
("62622","Cypr","59283","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62623","Czarnogóra","59283","6","0","1"),
("62624","Czechy","59283","7","0","1"),
("62625","Dania","59283","8","0","1"),
("62626","Egipt","59283","9","0","1"),
("62627","Francja","59283","10","0","1"),
("62628","Hiszpania","59283","11","0","1"),
("62629","Holandia","59283","12","0","1"),
("62630","Irlandia","59283","13","0","1"),
("62631","Kanada","59283","14","0","1"),
("62632","Litwa","59283","15","0","1"),
("62633","Luksemburg","59283","16","0","1"),
("62634","Niemcy","59283","17","0","1"),
("62636","Rosja","59283","19","0","1"),
("62637","Rumunia","59283","20","0","1"),
("62638","Stany Zjednoczone","59283","22","0","1"),
("62639","Słowacja","59283","21","0","1"),
("62640","Turcja","59283","23","0","1"),
("62641","Ukraina","59283","24","0","1"),
("62642","Wielka Brytania","59283","26","0","1"),
("62643","Węgry","59283","25","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("62645","Zjednoczone Emiraty Arabskie","59283","27","0","1"),
("63016","600W i większe","4561","0","0","1"),
("63021","Flash 32GB","9578","1","0","1"),
("63022","Flash 64GB i większe","9578","0","0","1"),
("63023","Dyski SAS","9063","0","0","1"),
("63034","Maty do tańczenia","4564","8","0","1"),
("63035","Arcabit","14569","0","0","1"),
("63036","Eset","14569","4","0","1"),
("63037","Kaspersky","14569","7","0","1"),
("63039","Panda","14569","9","0","1"),
("63040","Symantec","14569","10","0","1"),
("63043","Podajniki/Szuflady/Duplexy","11889","2","0","1"),
("63044","Sortery i odbiorniki papieru","11889","5","0","1"),
("63045","Urządzenia Wielofunkcyjne","4589","3","0","1"),
("63046","Sound Blaster Zewnętrzne","4397","4","0","1"),
("63047","Inne zewnętrzne","4397","9","0","1"),
("63048","24 Porty i więcej","4436","3","0","1"),
("63049","Zasilacze","4415","3","0","1"),
("63051","UTP","4441","0","0","1"),
("63052","Patchcord","4441","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63053","UTP (nieekranowane)","4441","2","0","1"),
("63054","FTP (ekranowane)","4441","3","0","1"),
("63055","Inne Kable","4441","5","0","1"),
("63068","Przewodowe","9189","0","0","1"),
("63069","Bezprzewodowe","9189","1","0","1"),
("63099","Inny producent","4180","12","0","1"),
("63100","Acer","4180","0","0","1"),
("63101","Asus","4180","2","0","1"),
("63102","Dell","4180","3","0","1"),
("63103","HP, Compaq","4180","5","0","1"),
("63104","Fujitsu","4180","4","0","1"),
("63105","IBM, Lenovo","4180","6","0","1"),
("63106","Sony","4180","10","0","1"),
("63107","Toshiba","4180","11","0","1"),
("63257","Obiektywy","4802","2","0","1"),
("63269","5130","4978","45","0","1"),
("63275","Topcom","456","7","0","1"),
("63276","Swissvoice","456","6","0","1"),
("63397","Inny producent","14569","11","0","1"),
("63466","JVC","5232","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63467","Marantz","5233","4","0","1"),
("63470","Miniwieże","11","10","0","0"),
("63471","Cambridge Audio","20221","2","0","1"),
("63472","NAD","20221","7","0","1"),
("63475","Hitachi","332","3","0","1"),
("63476","Elementy wygłuszające","11","4","0","1"),
("63483","Ferguson","337","2","0","1"),
("63484","Optoma","14226","7","0","1"),
("63485","Panasonic","14226","8","0","1"),
("63486","Sanyo","14226","10","0","1"),
("63487","Sony","14226","11","0","1"),
("63489","Piloty","10","7","0","0"),
("63490","Oryginalne","63489","0","0","1"),
("63491","Uniwersalne","63489","2","0","1"),
("63538","Noclegi","55067","0","0","0"),
("63539","Obozy, kolonie, zimowiska","55067","1","0","0"),
("63540","Wycieczki","55067","2","0","0"),
("63541","Zdrowie i uroda","55067","3","0","0"),
("63542","Sport i rekreacja","55067","4","0","0"),
("63585","Agroturystyka","63538","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63598","Apartamenty","63538","4","0","1"),
("63600","Ośrodki wypoczynkowe, domy wczasowe","63538","7","0","1"),
("63601","Pola namiotowe, kempingi","63538","9","0","1"),
("63602","Pozostałe","63538","13","0","1"),
("63603","Językowe","63539","0","0","1"),
("63604","Rekreacyjne","63539","1","0","1"),
("63605","Sportowe","63539","2","0","1"),
("63606","Pozostałe","63539","3","0","1"),
("63608","Objazdowe","63540","0","0","1"),
("63611","Zwiedzanie z przewodnikiem","63540","1","0","1"),
("63612","Pozostałe","63540","4","0","1"),
("63613","Spa","63541","0","0","1"),
("63614","Sanatoria","63541","1","0","1"),
("63615","Pozostałe","63541","2","0","1"),
("63617","Narty, snowboard","63542","1","0","1"),
("63621","Pozostałe","63542","3","0","1"),
("63638","Zamienniki","63489","1","0","1"),
("63757","Erotyka","0","7","0","0"),
("63758","BDSM","63757","1","0","0"),
("63759","Akcesoria i gadżety erotyczne","63757","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63760","Bielizna i odzież erotyczna","63757","2","0","0"),
("63761","Biżuteria erotyczna","63757","3","0","1"),
("63762","Domeny i serwisy internetowe","63757","4","0","1"),
("63763","Drogeria erotyczna","63757","5","0","0"),
("63764","Filmy erotyczne","63757","8","0","1"),
("63765","Gry erotyczne","63757","9","0","1"),
("63766","Karty telewizyjne","63757","10","0","1"),
("63767","Literatura erotyczna","63757","11","0","0"),
("63768","Obuwie erotyczne","63757","12","0","1"),
("63769","Feromony i afrodyzjaki","63757","7","0","1"),
("63770","Pozostałe","63757","14","0","1"),
("63771","Prezerwatywy","63757","13","0","1"),
("63772","Czasopisma","63767","0","0","1"),
("63773","Kajdanki","63758","0","0","1"),
("63774","Klatki erekcyjne","63758","2","0","1"),
("63775","Klamry i klipsy","63758","1","0","1"),
("63777","Kneble","63758","3","0","1"),
("63778","Lewatywy","63758","4","0","1"),
("63779","Linki","63758","5","0","1"),
("63780","Maski","63758","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63781","Meble i urządzenia","63758","7","0","1"),
("63782","Pasy cnoty","63758","8","0","1"),
("63783","Pejcze i baty","63758","9","0","1"),
("63784","Pościele","63758","10","0","1"),
("63785","Smycze i obroże","63758","11","0","1"),
("63786","Uprzęże","63758","12","0","1"),
("63787","Wzierniki","63758","13","0","1"),
("63788","Pozostałe","63758","14","0","1"),
("63789","Bielizna i akcesoria jadalne","63759","0","0","1"),
("63790","Depilacja i higiena intymna","63759","1","0","1"),
("63791","Ekspandery","63759","2","0","1"),
("63792","Gadżety i zabawki","63759","3","0","1"),
("63793","Huśtawki miłosne","63759","4","0","1"),
("63794","Korki i sondy analne","63759","5","0","1"),
("63795","Kulki i jajka stymulujące","63759","6","0","1"),
("63796","Lalki miłości","63759","7","0","1"),
("63797","Penisy i dilda","63759","9","0","1"),
("63801","Pierścienie i nasadki","63759","10","0","0"),
("63802","Nasadki i nakładki","63801","0","0","1"),
("63803","Pierścienie i zaciski","63801","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63804","Przedłużki","63801","2","0","1"),
("63805","Pochwy i masturbatory","63759","11","0","1"),
("63806","Pompki","63759","12","0","1"),
("63807","Wibratory","63759","14","0","0"),
("63808","Klasyczne","63807","0","0","1"),
("63809","Naturalne","63807","1","0","1"),
("63810","Stymulujące punkt G","63807","2","0","1"),
("63811","Wielofunkcyjne","63807","3","0","1"),
("63812","Zestawy","63807","4","0","1"),
("63813","Pozostałe","63807","5","0","1"),
("63814","Biustonosze","63760","0","0","1"),
("63815","Body","63760","1","0","1"),
("63816","Bodystocking","63760","2","0","1"),
("63817","Figi i stringi","63760","4","0","1"),
("63818","Gorsety","63760","5","0","1"),
("63819","Halki i koszulki","63760","6","0","1"),
("63820","Komplety","63760","7","0","1"),
("63821","Kostiumy i przebrania","63760","8","0","1"),
("63823","Latex, lack, vinyl","63760","9","0","1"),
("63824","Dla mężczyzn","63760","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("63825","Pończochy i rajstopy","63760","10","0","1"),
("63826","Skóra","63760","11","0","1"),
("63827","Dodatki","63760","14","0","1"),
("63828","Pozostałe","63760","15","0","1"),
("63833","Dłuższy seks","63763","0","0","1"),
("63834","Lubrykanty (żele i kremy)","63763","1","0","1"),
("63835","Potencja i libido","63763","3","0","1"),
("63836","Środki powiększające","63763","5","0","1"),
("63837","Pozostałe","63763","6","0","1"),
("63857","Komiksy","63767","1","0","1"),
("63858","Poradniki","63767","2","0","1"),
("63859","Powieści","63767","3","0","1"),
("63860","Publikacje elektroniczne","63767","4","0","1"),
("63861","Pozostałe","63767","5","0","1"),
("63862","Pozostałe","63759","15","0","1"),
("64290","C510","5044","0","0","1"),
("64294","6303 Classic","4978","57","0","1"),
("64295","E75","4978","95","0","1"),
("64296","N95 8GB","4978","101","0","1"),
("64477","Biuro i Reklama","0","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64478","Akcesoria biurowe","64477","0","0","0"),
("64479","Artykuły piśmiennicze","64477","1","0","0"),
("64480","Meble biurowe","64477","2","0","0"),
("64481","Organizacja dokumentów","64477","3","0","0"),
("64482","Pakowanie i wysyłka","64477","4","0","0"),
("64483","Papier","64477","5","0","0"),
("64484","Przybory kreślarskie","64477","6","0","0"),
("64485","Reklama","64477","7","0","0"),
("64486","Sprzęt biurowy","64477","8","0","0"),
("64488","Pozostałe","64478","12","0","1"),
("64489","Identyfikatory","64478","1","0","1"),
("64490","Kosze na śmieci","64478","3","0","1"),
("64491","Nożyczki","64478","5","0","1"),
("64492","Pieczątki i akcesoria","64478","6","0","0"),
("64493","Przyborniki","64478","7","0","1"),
("64494","Spinacze, klipsy i pinezki","64478","8","0","1"),
("64495","Taśmy klejące i kleje","64478","9","0","1"),
("64496","Wizytowniki i skorowidze","64478","10","0","1"),
("64497","Zszywacze i rozszywacze","64478","11","0","1"),
("64498","Pozostałe","64492","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64499","Datowniki","64492","0","0","1"),
("64500","Drukarenki","64492","1","0","1"),
("64501","Gumki do pieczątek","64492","2","0","1"),
("64502","Numeratory","64492","3","0","1"),
("64503","Pieczątki","64492","4","0","1"),
("64504","Poduszki i tuszownice","64492","5","0","1"),
("64505","Tusze","64492","6","0","1"),
("64506","Pozostałe","64479","10","0","1"),
("64507","Akcesoria","64479","0","0","0"),
("64508","Cienkopisy","64479","1","0","1"),
("64509","Długopisy","64479","2","0","1"),
("64510","Gumki i korektory","64479","3","0","1"),
("64511","Markery i pisaki","64479","4","0","1"),
("64512","Ołówki","64479","5","0","0"),
("64513","Pióra","64479","6","0","1"),
("64514","Pióra kulkowe","64479","7","0","1"),
("64515","Zakreślacze","64479","8","0","1"),
("64516","Zestawy","64479","9","0","1"),
("64517","Pozostałe","64480","11","0","1"),
("64519","Fotele","64480","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64520","Kontenery","64480","3","0","1"),
("64521","Krzesła","64480","4","0","1"),
("64522","Półki i regały","64480","6","0","1"),
("64523","Sejfy i kasy pancerne","64480","7","0","1"),
("64524","Stoły i ławy","64480","8","0","1"),
("64525","Szafy","64480","9","0","1"),
("64526","Zestawy mebli","64480","10","0","1"),
("64527","Pozostałe","64481","7","0","1"),
("64528","Kartony archiwizacyjne","64481","0","0","1"),
("64529","Koszulki i obwoluty","64481","1","0","1"),
("64530","Ofertówki","64481","2","0","1"),
("64531","Przekładki i zakładki","64481","3","0","1"),
("64532","Segregatory","64481","4","0","1"),
("64533","Skoroszyty","64481","5","0","1"),
("64534","Teczki","64481","6","0","1"),
("64535","Pozostałe","64482","13","0","1"),
("64536","Etykiety samoprzylepne","64482","1","0","1"),
("64537","Folia","64482","2","0","0"),
("64538","Koperty","64482","4","0","0"),
("64539","Papier pakowy","64482","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64540","Pudełka i kartony","64482","6","0","1"),
("64541","Taśmy pakowe","64482","7","0","1"),
("64542","Torby papierowe","64482","9","0","1"),
("64543","Tuby","64482","10","0","1"),
("64544","Woreczki i torby foliowe","64482","11","0","1"),
("64545","Wypełniacze","64482","12","0","1"),
("64546","Pozostałe","64537","2","0","1"),
("64547","Bąbelkowa","64537","0","0","1"),
("64548","Stretch","64537","1","0","1"),
("64549","Pozostałe","64538","3","0","1"),
("64550","Biurowe","64538","0","0","1"),
("64551","Ochronne","64538","1","0","1"),
("64552","Ozdobne","64538","2","0","1"),
("64553","Pozostałe","64483","6","0","1"),
("64554","Bloki","64483","0","0","1"),
("64555","Bruliony","64483","1","0","1"),
("64556","Druki","64483","2","0","1"),
("64557","Kostki, bloczki samoprzylepne","64483","3","0","1"),
("64558","Papier biurowy","64483","4","0","1"),
("64559","Sprzęt do prezentacji","64477","9","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64560","Pozostałe","64484","7","0","1"),
("64561","Cyrkle","64484","0","0","1"),
("64562","Deski kreślarskie","64484","1","0","1"),
("64563","Linijki i ekierki","64484","2","0","1"),
("64564","Rapidografy","64484","3","0","1"),
("64565","Skalówki","64484","4","0","1"),
("64566","Szablony","64484","5","0","1"),
("64567","Tusze kreślarskie","64484","6","0","1"),
("64568","Pozostałe","64486","10","0","1"),
("64569","Bindownice i akcesoria","64486","0","0","0"),
("64570","Falcerki","64486","2","0","1"),
("64571","Gilotyny i trymery","64486","3","0","1"),
("64572","Kalkulatory","64486","4","0","1"),
("64573","Kserokopiarki i akcesoria","64486","5","0","0"),
("64574","Laminatory i akcesoria","64486","6","0","0"),
("64576","Maszyny do pisania","64486","8","0","1"),
("64577","Niszczarki","64486","9","0","1"),
("64578","Pozostałe","64569","2","0","1"),
("64579","Bindownice","64569","0","0","1"),
("64580","Grzbiety i okładki","64569","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64581","Pozostałe","64573","3","0","1"),
("64583","Kserokopiarki","64573","1","0","1"),
("64584","Części zamienne","64573","0","0","1"),
("64585","Materiały eksploatacyjne","64573","2","0","1"),
("64586","Pozostałe","64574","2","0","1"),
("64587","Folia","64574","0","0","1"),
("64588","Laminatory","64574","1","0","1"),
("64589","Pozostałe","64559","4","0","1"),
("64590","Ekrany","64559","0","0","1"),
("64591","Flipcharty","64559","1","0","1"),
("64592","Tablice","64559","2","0","0"),
("64593","Wskaźniki","64559","3","0","1"),
("64594","Pozostałe","64592","2","0","1"),
("64595","Korkowe","64592","0","0","1"),
("64596","Magnetyczno-suchościeralne","64592","1","0","1"),
("64597","Pozostałe","64485","4","0","1"),
("64598","Gadżety","64485","1","0","0"),
("64600","Reklama zewnętrzna","64485","2","0","0"),
("64601","Systemy wystawiennicze","64485","3","0","0"),
("64602","Akcydensy (poligrafia)","64485","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64603","Pozostałe","64598","8","0","1"),
("64604","Breloki, otwieracze","64598","0","0","1"),
("64605","Odzież","64598","3","0","1"),
("64606","Długopisy","64598","1","0","1"),
("64607","Kubki, szklanki, kufle","64598","2","0","1"),
("64608","Przypinki, znaczki","64598","4","0","1"),
("64609","Smycze","64598","5","0","1"),
("64610","Torby i plecaki","64598","6","0","1"),
("64611","Zapałki i zapalniczki","64598","7","0","1"),
("64617","Pozostałe","64600","10","0","1"),
("64618","Banery","64600","0","0","1"),
("64619","Flagi i maszty","64600","1","0","1"),
("64620","Kasetony","64600","2","0","1"),
("64621","Litery","64600","3","0","1"),
("64622","Neony","64600","4","0","1"),
("64623","Panele LED","64600","5","0","1"),
("64624","Potykacze","64600","7","0","1"),
("64625","Pylony","64600","8","0","1"),
("64626","Tablice i szyldy","64600","9","0","1"),
("64627","Pozostałe","64601","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("64628","Kieszenie na ulotki","64601","0","0","1"),
("64629","Roll-upy, standy","64601","1","0","1"),
("64630","Stojaki","64601","2","0","1"),
("64631","Pozostałe","64602","11","0","1"),
("64632","Bloczki, notesy","64602","0","0","1"),
("64633","Etykiety samoprzylepne","64602","1","0","1"),
("64634","Kalendarzyki","64602","2","0","1"),
("64635","Koperty","64602","3","0","1"),
("64636","Papier firmowy","64602","5","0","1"),
("64637","Plakaty","64602","6","0","1"),
("64638","Teczki","64602","8","0","1"),
("64639","Ulotki","64602","9","0","1"),
("64640","Wizytówki","64602","10","0","1"),
("64641","Dziurkacze","64478","0","0","1"),
("64957","Masaż ciała (olejki i żele)","63763","2","0","1"),
("64958","Seks oralny (krople, kremy i żele)","63763","4","0","1"),
("64959","Masażery i motylki","63759","8","0","1"),
("66373","iPhone 3GS","48978","2","0","1"),
("66384","6700 Classic","4978","62","0","1"),
("66386","E52","4978","88","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("66398","W995","5044","17","0","1"),
("66773","Dla nastolatek","118","3","0","1"),
("66774","Ezoteryka, magia, ufo","118","5","0","1"),
("66775","Kryminalno-detektywistyczne","118","11","0","1"),
("66776","Społeczno-polityczne","118","18","0","1"),
("66777","Wojsko, militaria","118","20","0","1"),
("66778","Zbiory opowiadań","118","22","0","1"),
("66779","Zwierzęta, przyroda","118","23","0","1"),
("66780","Internet, komputery","118","10","0","1"),
("66781","Książki dla dzieci i młodzieży","7","3","0","0"),
("66782","Bohaterowie telewizyjni","66781","4","0","0"),
("66783","Książki z dodatkami","66781","14","0","0"),
("66784","Bajki i wierszyki","66781","0","0","0"),
("66785","Kolorowanki, malowanki i wycinanki","66781","8","0","1"),
("66786","Historie biblijne","66781","6","0","1"),
("66787","Historyjki obrazkowe","66781","7","0","1"),
("66788","Nauka czytania i liczenia","66781","10","0","1"),
("66789","Encyklopedie, słowniki i atlasy","66781","5","0","1"),
("66790","Popularnonaukowe","66781","12","0","1"),
("66791","Beletrystyka, powieści","66781","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("66792","Piosenki, śpiewniki","66781","11","0","1"),
("66793","Pozostałe","66781","15","0","1"),
("66794","Książki do nauki języka obcego","7","4","0","0"),
("66795","Języki skandynawskie","66794","10","0","0"),
("66796","Języki klasyczne","66794","8","0","1"),
("66797","Portugalski","66794","5","0","1"),
("66798","Polski dla obcokrajowców","66794","4","0","1"),
("66799","Rosyjski","66794","6","0","0"),
("66800","Włoski","66794","7","0","0"),
("66801","Francuski","66794","2","0","0"),
("66802","Hiszpański","66794","3","0","0"),
("66803","Angielski","66794","0","0","0"),
("66804","Niemiecki","66794","1","0","0"),
("66805","Języki orientalne","66794","9","0","0"),
("66806","Pozostałe","66794","11","0","0"),
("66807","Adresowniki, pamiętniki","28496","0","0","1"),
("66808","Lampki, lupy, stojaki","28496","3","0","1"),
("66809","Kalendarze książkowe","28496","1","0","1"),
("66810","Kalendarze ścienne","28496","2","0","1"),
("66811","Okładki, zakładki, ekslibrisy","28496","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("66812","Pozostałe","28496","5","0","1"),
("66813","Audiobooki - CD","7","11","0","0"),
("66814","Dla dzieci i młodzieży","66813","0","0","0"),
("66815","Literatura piękna polska","66813","4","0","1"),
("66817","Nauka języków","66813","2","0","1"),
("66818","Edukacja i lektury szkolne","66813","1","0","1"),
("66819","Pozostałe","66813","17","0","1"),
("66820","Podręczniki do szkół podst. i średnich","7","10","0","0"),
("66885","NAD","5232","5","0","1"),
("66886","Rotel","5232","9","0","1"),
("66887","Słuchawki","10","8","0","0"),
("66925","Głośniki","11","5","0","0"),
("66926","Wysokotonowe","66925","0","0","1"),
("66927","Średniotonowe","66925","1","0","1"),
("66928","Niskotonowe","66925","2","0","1"),
("66929","Szerokopasmowe","66925","3","0","1"),
("66930","Części zamienne","66925","5","0","1"),
("66931","Zwrotnice","66925","6","0","1"),
("66932","Uszkodzone","66925","7","0","1"),
("66933","Pozostałe","66925","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("66934","Szpulowe","15","1","0","1"),
("66935","Nośniki","15","2","0","1"),
("66936","Odtwarzacze MD","13","3","0","1"),
("66937","Nagrywarki","13","2","0","1"),
("66938","Inni producenci","14317","8","0","1"),
("66939","Denon","14317","0","0","1"),
("66940","Harman Kardon","14317","1","0","1"),
("66941","Marantz","14317","2","0","1"),
("66942","Onkyo","14317","3","0","1"),
("66943","Pioneer","14317","4","0","1"),
("66944","Sony","14317","5","0","1"),
("66945","Technics","14317","6","0","1"),
("66946","Yamaha","14317","7","0","1"),
("66951","Odtwarzacze CD","20135","0","0","1"),
("66952","Odtwarzacze CD/MP3","20135","1","0","1"),
("66953","Odtwarzacze MD","20135","2","0","1"),
("66954","Odtwarzacze kasetowe","20135","3","0","1"),
("66955","Vedia","20141","9","0","1"),
("66956","Apple","20142","0","0","1"),
("66957","Creative","20142","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("66958","Pentagram","20142","4","0","1"),
("66959","Philips","20142","5","0","1"),
("66960","Samsung","20142","6","0","1"),
("66961","Sony","20142","8","0","1"),
("66962","Vedia","20142","9","0","1"),
("66963","iAudio","20142","2","0","1"),
("66964","iRiver","20142","3","0","1"),
("66965","Inni producenci","20142","10","0","1"),
("66966","Sandisk","20142","7","0","1"),
("66968","Dedykowane","20143","0","0","1"),
("66969","Uniwersalne","20143","1","0","1"),
("67046","Kasetowe","15","0","0","0"),
("67047","Jednokasetowe","67046","0","0","0"),
("67048","Dwukasetowe","67046","1","0","1"),
("67049","AKAI","67047","0","0","1"),
("67050","Denon","67047","1","0","1"),
("67051","Onkyo","67047","2","0","1"),
("67052","Pioneer","67047","3","0","1"),
("67053","Polskie","67047","4","0","1"),
("67054","Sony","67047","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67055","Technics","67047","6","0","1"),
("67056","Yamaha","67047","7","0","1"),
("67057","Inni producenci","67047","8","0","1"),
("67058","Radioodtwarzacze","20134","5","0","0"),
("67059","Z CD","67058","0","0","1"),
("67060","Z CD/MP3","67058","1","0","1"),
("67061","Bez CD","67058","2","0","1"),
("67093","GPS i akcesoria","10","5","0","0"),
("67094","Urządzenia","67093","5","0","0"),
("67095","Akcesoria","67093","0","0","0"),
("67096","Anteny GPS","67093","1","0","1"),
("67097","Oprogramowanie","67093","4","0","1"),
("67099","Uszkodzone","67093","6","0","1"),
("67100","Pozostałe","67093","7","0","1"),
("67101","Pokrowce","67095","2","0","1"),
("67102","Uchwyty","67095","3","0","1"),
("67103","Ładowarki, zasilacze","67095","1","0","1"),
("67104","Pozostałe","67095","4","0","1"),
("67107","Becker","67094","0","0","1"),
("67108","Blaupunkt","67094","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67109","Garmin","67094","5","0","1"),
("67110","GoClever","67094","6","0","1"),
("67111","Lark","67094","7","0","1"),
("67112","Manta","67094","8","0","1"),
("67114","Mio","67094","9","0","1"),
("67115","NavRoad","67094","13","0","1"),
("67116","Navigon","67094","11","0","1"),
("67118","Sony","67094","16","0","1"),
("67119","TomTom","67094","17","0","1"),
("67121","Inni producenci","67094","20","0","1"),
("67128","Sprzęt satelitarny","10","12","0","0"),
("67129","Tunery","67128","6","0","0"),
("67130","Anteny","67128","1","0","1"),
("67131","Konwertery","67128","4","0","1"),
("67132","Akcesoria","67128","0","0","0"),
("67134","Uszkodzone","67128","8","0","1"),
("67135","Pozostałe","67128","9","0","1"),
("67136","Kable Null Modem","67132","0","0","1"),
("67137","Karty, moduły CA","67132","1","0","1"),
("67138","Mierniki, wzmacniacze sygnału","67132","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67139","Splittery","67132","4","0","1"),
("67141","Analogowe","67129","0","0","1"),
("67142","Cyfrowe","67129","1","0","0"),
("67143","Dreambox","67142","0","0","1"),
("67144","Echostar","67142","1","0","1"),
("67145","Ferguson","67142","2","0","1"),
("67146","Opticum/Globo","67142","7","0","1"),
("67147","Humax","67142","3","0","1"),
("67148","LinBOX","67142","4","0","1"),
("67149","Mediasat","67142","5","0","1"),
("67150","Nokia","67142","6","0","1"),
("67151","Philips","67142","8","0","1"),
("67152","Sagem","67142","9","0","1"),
("67153","Technisat","67142","10","0","1"),
("67154","Inni producenci","67142","11","0","1"),
("67155","LG","5186","5","0","1"),
("67156","Akcesoria montażowe","709","0","0","0"),
("67157","Kieszenie, ramki","67156","0","0","0"),
("67158","Kostki ISO, złączki","67156","1","0","0"),
("67159","Ramki radiowe","67157","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67160","Kieszenie i półkieszenie","67157","0","0","1"),
("67161","Ramki do paneli radioodtwarzaczy","67157","2","0","1"),
("67162","Klucze","67157","1","0","1"),
("67163","Pozostałe","67157","4","0","1"),
("67164","Adaptery do instalacji samochodowej - ISO","67158","0","0","1"),
("67165","Złącza do radioodbiorników fabrycznych - ISO","67158","1","0","1"),
("67166","Złącza ISO do radia","67158","2","0","1"),
("67167","Pozostałe","67158","3","0","1"),
("67168","87 mm","1322","0","0","1"),
("67169","120 mm","1322","2","0","1"),
("67170","380 mm i większe","1322","8","0","1"),
("67171","5x7\"","1322","10","0","1"),
("67172","Dystanse","1322","16","0","1"),
("67173","Magnetowidy","21","0","0","1"),
("67174","Nośniki","21","1","0","1"),
("67175","LG","45571","0","0","1"),
("67176","Panasonic","45571","1","0","1"),
("67177","Pioneer","45571","3","0","1"),
("67178","Philips","45571","2","0","1"),
("67179","Samsung","45571","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67180","Sony","45571","5","0","1"),
("67181","Inni producenci","45571","6","0","1"),
("67182","LG","45572","0","0","1"),
("67183","Panasonic","45572","1","0","1"),
("67184","Pioneer","45572","3","0","1"),
("67185","Philips","45572","2","0","1"),
("67186","Samsung","45572","4","0","1"),
("67187","Sony","45572","5","0","1"),
("67188","Inni producenci","45572","6","0","1"),
("67189","Cambridge Audio","337","0","0","1"),
("67190","Marantz","337","7","0","1"),
("67191","Odtwarzacze HDD i multimedialne","717","9","0","0"),
("67192","Atrapy","5119","1","0","1"),
("67193","Elektronika","10","4","0","0"),
("67194","Elektronika","67193","0","0","0"),
("67195","Kable, przewody","67193","1","0","0"),
("67196","Wtyki, gniazda, przejściówki","67193","2","0","0"),
("67197","Pozostałe","67194","12","0","1"),
("67198","Aparatura pomiarowa","67194","0","0","0"),
("67199","Aparatura sterująca","67194","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67200","Chemia dla elektroniki","67194","2","0","0"),
("67201","Części elektroniczne","67194","3","0","0"),
("67202","Części mechaniczne","67194","4","0","0"),
("67203","Części stykowe","67194","5","0","0"),
("67204","Literatura","67194","6","0","1"),
("67205","Narzędzia","67194","7","0","0"),
("67206","Płytki drukowane, moduły","67194","8","0","0"),
("67207","Zasilanie","67194","11","0","0"),
("67208","Pozostałe","67198","7","0","1"),
("67209","Amperomierze","67198","0","0","1"),
("67210","Generatory","67198","1","0","1"),
("67211","Multimetry","67198","2","0","1"),
("67212","Oscyloskopy","67198","3","0","1"),
("67213","Pirometry","67198","4","0","1"),
("67214","Wagi elektroniczne","67198","5","0","1"),
("67215","Woltomierze","67198","6","0","1"),
("67216","Pozostałe","67200","5","0","1"),
("67217","Czyszczenie","67200","0","0","1"),
("67218","Izolacja","67200","1","0","0"),
("67219","Konserwacja, smarowanie","67200","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67220","Lutowanie","67200","3","0","0"),
("67221","Trawienie płytek","67200","4","0","0"),
("67222","Koszulki","67218","0","0","1"),
("67223","Taśmy","67218","1","0","1"),
("67224","Zalewy, lakiery","67218","2","0","1"),
("67225","Pozostałe","67220","3","0","1"),
("67226","Cyna","67220","0","0","1"),
("67227","Kalafonia","67220","1","0","1"),
("67228","Pasty, topniki","67220","2","0","1"),
("67229","Pozostałe","67221","3","0","1"),
("67230","Laminat","67221","0","0","1"),
("67231","Pisaki","67221","1","0","1"),
("67232","Wytrawiacze","67221","2","0","1"),
("67234","Pozostałe","67201","8","0","1"),
("67235","Cewki, filtry, generatory","67201","0","0","0"),
("67236","Diody","67201","1","0","0"),
("67237","Kondensatory","67201","2","0","0"),
("67238","Lampy","67201","3","0","1"),
("67239","Tranzystory","67201","5","0","1"),
("67240","Układy scalone","67201","6","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67241","Oporniki","67201","4","0","0"),
("67242","Wyświetlacze","67201","7","0","0"),
("67243","Pozostałe","67235","3","0","1"),
("67244","Cewki, dławiki","67235","0","0","1"),
("67245","Filtry","67235","1","0","0"),
("67246","Kwarce","67235","2","0","0"),
("67247","Ceramiczne","67245","0","0","1"),
("67248","LC","67245","1","0","1"),
("67249","Generatory","67246","0","0","1"),
("67250","Rezonatory","67246","1","0","1"),
("67251","Pozostałe","67236","4","0","1"),
("67252","LED","67236","1","0","1"),
("67253","Fotodiody","67236","0","0","1"),
("67254","Prostownicze","67236","2","0","0"),
("67255","Zenera","67236","3","0","1"),
("67256","Pozostałe","67237","4","0","1"),
("67257","Ceramiczne","67237","0","0","1"),
("67258","Elektrolityczne","67237","1","0","1"),
("67259","Foliowe","67237","2","0","1"),
("67260","Wysokonapięciowe (>200V)","67237","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67261","Pozostałe","67241","3","0","1"),
("67262","Małej mocy (do 2W)","67241","1","0","1"),
("67263","Dużej mocy (powyżej 2W)","67241","0","0","1"),
("67264","Potencjometry","67241","2","0","1"),
("67265","Pozostałe","67240","7","0","1"),
("67266","Analogowe","67240","0","0","1"),
("67267","Cyfrowe","67240","1","0","1"),
("67268","Przetworniki AC i CA","67240","5","0","1"),
("67269","Końcówki mocy","67240","2","0","1"),
("67270","Mikroprocesory","67240","3","0","0"),
("67271","Pamięci","67240","4","0","1"),
("67272","Stabilizatory","67240","6","0","0"),
("67273","Pozostałe","67270","3","0","1"),
("67274","Atmel","67270","1","0","0"),
("67275","Microchip","67270","2","0","1"),
("67276","ARM","67270","0","0","1"),
("67277","Pozostałe","67274","2","0","1"),
("67278","ATMega","67274","0","0","1"),
("67279","ATTiny","67274","1","0","1"),
("67280","Regulowane","67272","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67281","Nieregulowane","67272","1","0","1"),
("67282","Alfanumeryczne","67242","0","0","1"),
("67283","Graficzne","67242","1","0","1"),
("67284","Gniazda i wtyki","67196","0","0","0"),
("67285","Przejściówki","67196","1","0","1"),
("67286","Splittery antenowe","67196","2","0","1"),
("67287","Pozostałe","67196","3","0","1"),
("67288","Antenowe","67284","0","0","1"),
("67289","Cinch","67284","2","0","1"),
("67290","Euro","67284","3","0","1"),
("67291","Głośnikowe","67284","4","0","1"),
("67292","Jack","67284","6","0","1"),
("67293","SVHS","67284","7","0","1"),
("67294","Pozostałe","67284","8","0","1"),
("67295","Antenowe","67195","0","0","1"),
("67296","Jack i Cinch","67195","9","0","0"),
("67297","Coaxial","67195","1","0","1"),
("67298","Component video","67195","2","0","1"),
("67299","D-Sub (VGA)","67195","5","0","1"),
("67300","DVI i HDMI","67195","6","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67301","Dedykowane dla car audio","67195","3","0","0"),
("67302","Euro","67195","7","0","0"),
("67303","Głośnikowe","67195","8","0","1"),
("67304","Optyczne","67195","10","0","1"),
("67305","SVHS (S-video)","67195","11","0","0"),
("67306","Zasilające","67195","12","0","1"),
("67307","Pozostałe","67195","13","0","1"),
("67308","Cinch-Cinch","67296","0","0","0"),
("67309","Jack-Cinch","67296","1","0","0"),
("67310","Jack-Jack","67296","2","0","1"),
("67311","Pozostałe","67296","3","0","1"),
("67312","DVI-DVI","67300","0","0","1"),
("67313","HDMI-DVI","67300","2","0","1"),
("67314","HDMI-HDMI","67300","3","0","1"),
("67315","Pozostałe","67300","4","0","1"),
("67316","Do wzmacniacza","67301","0","0","1"),
("67317","Do zmieniarki","67301","1","0","1"),
("67318","Zasilające","67301","2","0","1"),
("67319","Zestawy","67301","3","0","1"),
("67320","Pozostałe","67301","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67321","Euro-Cinch","67302","0","0","0"),
("67322","Euro-Euro","67302","1","0","1"),
("67323","Pozostałe","67302","4","0","1"),
("67324","Pozostałe","67202","5","0","1"),
("67325","Obudowy","67202","0","0","1"),
("67326","Pokrętła","67202","1","0","1"),
("67327","Przyciski","67202","2","0","1"),
("67328","Silniki","67202","4","0","0"),
("67329","Radiatory","67202","3","0","1"),
("67330","AC","67328","0","0","1"),
("67331","DC","67328","1","0","1"),
("67332","Krokowe","67328","2","0","1"),
("67333","SVHS-Cinch","67305","0","0","1"),
("67334","SVHS-Euro","67305","1","0","1"),
("67335","SVHS-SVHS","67305","2","0","1"),
("67336","Pozostałe","67305","3","0","1"),
("67340","Pozostałe","67203","4","0","1"),
("67341","Przekaźniki","67203","1","0","0"),
("67342","Przełączniki","67203","2","0","1"),
("67343","Podstawki","67203","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67344","Mechaniczne","67341","0","0","1"),
("67345","Półprzewodnikowe (Opto)","67341","1","0","1"),
("67346","Pozostałe","67205","11","0","1"),
("67347","Akcesoria lutownicze","67205","0","0","0"),
("67348","Groty do lutownic","67205","1","0","1"),
("67349","Lutownice","67205","2","0","1"),
("67350","Nożyce do kabli","67205","3","0","1"),
("67351","Odsysacze","67205","4","0","1"),
("67352","Pęsety","67205","5","0","1"),
("67353","Stacje lutownicze","67205","6","0","1"),
("67354","Szczypce","67205","7","0","1"),
("67355","Ściągacze izolacji","67205","8","0","1"),
("67356","Wkrętaki","67205","9","0","1"),
("67357","Zaciskarki","67205","10","0","1"),
("67358","Pozostałe","67347","3","0","1"),
("67359","Gąbki, czyściki do grotów","67347","0","0","1"),
("67360","Plecionki do cyny","67347","1","0","1"),
("67361","Srebrzanki","67347","2","0","1"),
("67362","Pozostałe","67206","5","0","1"),
("67363","Moduły","67206","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67364","Listwy LED","67206","0","0","1"),
("67365","Płytki uniwersalne","67206","2","0","1"),
("67366","Przejściówki","67206","3","0","1"),
("67367","Zestawy do montażu","67206","4","0","1"),
("67368","Pozostałe","67207","6","0","1"),
("67369","Akumulatory","67207","0","0","1"),
("67370","Baterie","67207","1","0","1"),
("67371","Bezpieczniki","67207","2","0","1"),
("67372","Koszyki na baterie","67207","3","0","1"),
("67373","Transformatory","67207","4","0","1"),
("67374","Zasilacze","67207","5","0","0"),
("67375","Pozostałe","67374","4","0","1"),
("67376","Laboratoryjne","67374","0","0","1"),
("67377","Ładowarki","67374","1","0","1"),
("67378","Standardowe","67374","2","0","1"),
("67379","Uniwersalne","67374","3","0","1"),
("67380","1xCinch-1xCinch","67308","0","0","1"),
("67381","2xCinch-2xCinch","67308","1","0","1"),
("67382","Pozostałe","67308","2","0","1"),
("67383","Jack-2xCinch","67309","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67384","Jack-3xCinch","67309","1","0","1"),
("67385","Pozostałe","67309","2","0","1"),
("67413","AGD wolnostojące","10","2","0","0"),
("67414","AGD drobne","10","1","0","0"),
("67415","Do kuchni","67414","0","0","0"),
("67416","Do domu","67414","1","0","0"),
("67417","Kuchenki mikrofalowe","67413","3","0","1"),
("67418","Higiena i pielęgnacja","67414","2","0","0"),
("67419","Kuchenki","67413","2","0","0"),
("67420","Uszkodzone","67414","3","0","1"),
("67421","Elektryczne","67419","0","0","1"),
("67422","Części zamienne","67414","4","0","1"),
("67423","Gazowe","67419","1","0","1"),
("67424","Pozostałe","67414","5","0","1"),
("67425","Gazowo-Elektryczne","67419","2","0","1"),
("67427","Automaty do chleba","67415","0","0","1"),
("67428","Czajniki elektryczne","67415","1","0","1"),
("67430","Lodówko - zamrażarki","67413","5","0","1"),
("67431","Ekspresy ciśnieniowe","67415","2","0","1"),
("67432","Ekspresy przelewowe","67415","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67433","Zamrażarki","67413","12","0","1"),
("67434","Ekspresy ciśnieniowo-przelewowe","67415","3","0","1"),
("67435","Części i akcesoria","67413","1","0","1"),
("67436","Okapy","67413","6","0","1"),
("67437","Filtry do wody","67415","6","0","0"),
("67438","Piekarniki","67413","7","0","1"),
("67439","Frytownice","67415","8","0","1"),
("67440","Gofrownice","67415","9","0","1"),
("67441","Pralki","67413","8","0","1"),
("67442","Grille elektryczne","67415","10","0","1"),
("67443","Zmywarki","67413","14","0","1"),
("67444","Jajowary","67415","11","0","1"),
("67445","Uszkodzone","67413","15","0","1"),
("67446","Krajalnice","67415","14","0","1"),
("67447","Maszynki do mielenia mięsa","67415","15","0","1"),
("67448","Miksery i blendery","67415","17","0","1"),
("67449","Mini piekarniki","67415","18","0","1"),
("67450","Młynki do kawy","67415","19","0","1"),
("67451","Parowary","67415","21","0","1"),
("67452","Roboty kuchenne","67415","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67453","Sokowirówki","67415","23","0","1"),
("67454","Suszarki do grzybów i owoców","67415","24","0","1"),
("67455","Tostery","67415","25","0","1"),
("67456","Urządzenia do waty cukrowej","67415","26","0","1"),
("67457","Wagi kuchenne","67415","27","0","1"),
("67458","Części i akcesoria","67415","31","0","1"),
("67459","Uszkodzone","67415","32","0","1"),
("67460","Pozostałe","67415","33","0","1"),
("67461","Golarki do ubrań","67416","0","0","1"),
("67462","Grzejniki","67416","1","0","1"),
("67463","Klimatyzacja","67416","2","0","1"),
("67464","Maszyny do szycia","67416","3","0","1"),
("67465","Nawilżacze","67416","4","0","1"),
("67466","Odkurzacze","67416","6","0","0"),
("67467","Odkurzacze tradycyjne","67466","2","0","1"),
("67468","Filtry","67466","5","0","1"),
("67469","Worki","67466","8","0","1"),
("67470","Pozostałe","67466","9","0","1"),
("67471","Osuszacze powietrza","67416","7","0","1"),
("67472","Termowentylatory","67416","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67473","Żelazka","67416","11","0","1"),
("67474","Części i akcesoria","67416","12","0","1"),
("67475","Akcesoria fryzjerskie","67418","0","0","1"),
("67476","Depilatory","67418","1","0","1"),
("67477","Golarki","67418","2","0","1"),
("67478","Lokówki","67418","3","0","1"),
("67479","Prostownice i karbownice","67418","5","0","1"),
("67480","Maszynki do strzyżenia","67418","4","0","1"),
("67481","Suszarki do włosów","67418","6","0","1"),
("67482","Szczoteczki elektryczne","67418","8","0","1"),
("67483","Wagi łazienkowe","67418","10","0","1"),
("67484","Suszarki do ubrań","67413","11","0","1"),
("67485","Pozostałe","67413","16","0","1"),
("67520","Mostki","67254","0","0","1"),
("67521","Pojedyncze","67254","1","0","1"),
("67522","Pozostałe","67418","11","0","1"),
("67523","Pozostałe","67416","13","0","1"),
("67524","AGD do zabudowy","10","0","0","0"),
("67525","Ekspresy do kawy","67524","1","0","1"),
("67526","Kuchenki mikrofalowe","67524","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("67528","Lodówko-zamrażarki","67524","3","0","1"),
("67529","Okapy","67524","4","0","1"),
("67530","Piekarniki","67524","5","0","1"),
("67531","Płyty grzewcze","67524","6","0","0"),
("67532","Zmywarki","67524","11","0","1"),
("67533","Uszkodzone","67524","14","0","1"),
("67534","Pozostałe","67524","15","0","1"),
("67535","Płyty indukcyjne","67531","3","0","1"),
("67536","Płyty elektryczne","67531","1","0","1"),
("67537","Płyty gazowe","67531","2","0","1"),
("67538","Płyty kombinowane","67531","4","0","1"),
("68366","Programatory","67194","9","0","1"),
("68367","RFID i SmartCard","67194","10","0","1"),
("68368","Złącza","67203","3","0","1"),
("68619","Pozostałe","46099","8","0","1"),
("68620","Anemostaty","46099","0","0","1"),
("68621","Kanały, kształtki, przewody","46099","7","0","1"),
("68622","Regulatory obrotów","46099","4","0","1"),
("68623","Rekuperatory","46099","5","0","1"),
("68626","Odkurzacze centralne","1520","8","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("68627","Drabiny","1520","1","0","1"),
("68628","Parapety","15959","7","0","1"),
("68629","Garaże","1520","4","0","1"),
("68630","Tapety w rolce","46166","1","0","1"),
("68631","Fototapety","46166","0","0","1"),
("68632","Akcesoria meblowe","522","0","0","0"),
("68645","Komplety mebli","568","1","0","1"),
("68646","Szuflady pod łóżko","568","3","0","1"),
("68665","Pozostałe","1511","7","0","1"),
("68667","Komody i regały","1511","0","0","1"),
("68668","Kosze na pranie","1511","1","0","1"),
("68669","Lustra","1511","2","0","1"),
("68670","Półki","1511","3","0","1"),
("68671","Szafki","1511","4","0","1"),
("68672","Zestawy mebli łazienkowych","1511","5","0","1"),
("68679","Koszyki","123","3","0","1"),
("68685","Żaluzje","9016","7","0","1"),
("68686","Obrusy, serwetki, podkładki","123","6","0","0"),
("68687","Pozostałe","68686","5","0","1"),
("68688","Bieżniki","68686","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("68689","Obrusy","68686","1","0","1"),
("68690","Serwety","68686","4","0","1"),
("68691","Serwetki","68686","3","0","1"),
("68692","Pozostałe","15977","5","0","1"),
("68693","Komplety noży","15977","2","0","1"),
("68694","Nożyce","15977","0","0","1"),
("68695","Pojedyncze noże","15977","1","0","1"),
("68705","Młynki i moździerze","5328","10","0","1"),
("68710","Pokrywki","15978","10","0","1"),
("68711","Zestawy do fondue","15978","8","0","1"),
("68712","Pozostałe","15978","11","0","1"),
("68714","Akcesoria barmańskie","5328","0","0","1"),
("68719","Tasaki","15977","4","0","1"),
("68721","Sitka i cedzaki","5328","15","0","1"),
("68722","Deski do krojenia","5328","5","0","1"),
("68724","Maselniczki","5328","7","0","1"),
("68733","Pozostałe","11997","2","0","1"),
("68734","Ręczniki plażowe i kąpielowe","11997","0","0","1"),
("68735","Zestawy ręczników","11997","1","0","1"),
("68736","Dla ryb","16011","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("68737","Dla krewetek","16011","0","0","0"),
("68738","Opakowania oryginalne","68737","0","0","1"),
("68739","Uzupełnienia","68737","1","0","1"),
("68740","Opakowania oryginalne","68736","0","0","1"),
("68741","Uzupełnienia","68736","1","0","1"),
("68773","Króliki","1530","4","0","1"),
("68774","Drób","28102","0","0","1"),
("68775","Jaja lęgowe","28102","1","0","1"),
("68776","Gryzonie","1530","1","0","1"),
("68950","Krawaty","1487","3","0","1"),
("68951","Etui i pokrowce","1487","2","0","1"),
("69221","Cormax","5546","7","0","1"),
("70085","Kalosze","532","3","0","1"),
("70504","Zamki, pałace, obiekty zabytkowe","63538","11","0","1"),
("70505","Wczasy, wakacje rodzinne","63540","2","0","1"),
("70506","Wyprawy","63540","3","0","1"),
("70507","Sporty wodne, czartery","63542","0","0","1"),
("70508","Sporty ekstremalne","63542","2","0","1"),
("70543","KP501","10539","21","0","1"),
("70546","W205","5044","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("70549","2330 Classic","4978","22","0","1"),
("70550","2700 Classic","4978","23","0","1"),
("70568","myPhone","165","23","0","0"),
("70569","HTC/SPV","50999","3","0","1"),
("70581","Inne modele","70568","16","0","1"),
("71692","Obudowy ITX","4552","0","0","1"),
("71693","Windows 7 Home","4654","3","0","1"),
("71694","Windows 7 Pro/Ultimate","4654","4","0","1"),
("71708","Szafy","4416","1","0","1"),
("73133","Zestawy","67524","10","0","1"),
("73134","Filtry","67437","0","0","1"),
("73135","Wkłady","67437","1","0","1"),
("73139","Wzmacniacze słuchawkowe","66887","2","0","1"),
("73140","Stoliki","11","13","0","1"),
("73141","Arcam","20221","1","0","1"),
("73143","Clarion","714","5","0","1"),
("73144","DLS","714","7","0","1"),
("73145","Ground Zero","714","8","0","1"),
("73146","Harman Kardon","714","9","0","1"),
("73147","Hertz","714","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("73148","Sinuslive","714","20","0","1"),
("73149","u-Dimension","714","23","0","1"),
("73150","Kondensatory, filtry","709","4","0","1"),
("73151","Zestawy","67128","7","0","1"),
("73152","Denon","51761","0","0","1"),
("73153","Harman Kardon","51761","1","0","1"),
("73154","LG","51761","2","0","1"),
("73155","Marantz","51761","3","0","1"),
("73156","Onkyo","51761","4","0","1"),
("73157","Panasonic","51761","5","0","1"),
("73158","Pioneer","51761","7","0","1"),
("73159","Samsung","51761","8","0","1"),
("73160","Sharp","51761","9","0","1"),
("73161","Sony","51761","10","0","1"),
("73162","Yamaha","51761","11","0","1"),
("73163","Inni producenci","51761","12","0","1"),
("73164","Mitsubishi","14226","6","0","1"),
("73165","Toshiba","14226","12","0","1"),
("73166","Pioneer","14241","7","0","1"),
("73873","Sukienki","63760","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("73874","Clubwear - Dancewear","63760","3","0","1"),
("73973","Delikatesy","0","4","0","0"),
("73976","Miód i pyłek pszczeli","73973","7","0","1"),
("73977","Grzyby","73973","3","0","0"),
("73978","Marynowane","73977","0","0","1"),
("73979","Suszone","73977","2","0","1"),
("73980","Solone","73977","1","0","1"),
("73985","Pozostałe","73977","4","0","1"),
("73997","Przetwory mięsne","73973","13","0","0"),
("73998","Pasty i pasztety","73997","0","0","1"),
("73999","Szynki i polędwice","73997","1","0","1"),
("74000","Wędliny","73997","2","0","1"),
("74001","Pozostałe","73997","4","0","1"),
("74002","Ryby i owoce morza","73973","15","0","0"),
("74003","Kawior","74002","0","0","1"),
("74004","Mięczaki","74002","1","0","1"),
("74005","Ryby","74002","2","0","0"),
("74006","Skorupiaki","74002","3","0","1"),
("74007","Pozostałe","74002","4","0","1"),
("74016","Słodycze i przekąski","73973","16","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("74017","Ciastka i chałwa","74016","1","0","1"),
("74018","Cukierki i lizaki","74016","2","0","1"),
("74019","Gumy do żucia","74016","4","0","1"),
("74020","Czekolady","74016","3","0","1"),
("74021","Batoniki","74016","0","0","1"),
("74023","Żelki","74016","7","0","1"),
("74024","Pikantne przekąski","74016","6","0","1"),
("74025","Pozostałe","74016","8","0","1"),
("74030","Kawy","73973","5","0","0"),
("74032","Cappuccino","74030","0","0","1"),
("74033","Kawy mielone","74030","2","0","1"),
("74034","Kawy rozpuszczalne","74030","3","0","1"),
("74035","Kawy ziarniste","74030","4","0","1"),
("74037","Pozostałe","74030","9","0","1"),
("74038","Herbaty","73973","4","0","0"),
("74039","Białe","74038","0","0","1"),
("74040","Czarne","74038","1","0","1"),
("74041","Czerwone","74038","2","0","1"),
("74042","Mieszane","74038","3","0","1"),
("74043","Owocowe","74038","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("74044","Zielone","74038","7","0","1"),
("74045","Ziołowe","74038","8","0","1"),
("74046","Pozostałe","74038","11","0","1"),
("74048","Przyprawy i zioła","73973","14","0","0"),
("74056","Dania gotowe","73973","1","0","0"),
("74062","Zdrowa żywność","73973","21","0","0"),
("74068","Pozostałe","74062","6","0","1"),
("74069","Produkty wegetariańskie","73973","12","0","0"),
("74070","Dania gotowe","74069","0","0","1"),
("74071","Pasty","74069","1","0","1"),
("74072","Pozostałe","74069","2","0","1"),
("74113","BlackBerry","349","1","0","1"),
("74114","HTC","349","2","0","1"),
("74151","2720 Fold","4978","24","0","1"),
("74165","Aino","5044","28","0","1"),
("74167","Satio","5044","33","0","1"),
("74168","Yari","5044","36","0","1"),
("74169","Ślub i wesele","1454","8","0","0"),
("74170","Przebrania, kostiumy, maski","1454","6","0","0"),
("74171","Pozostałe","74170","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("74172","Akcesoria i gadżety","74170","0","0","1"),
("74173","Kostiumy damskie","74170","1","0","1"),
("74174","Kostiumy męskie","74170","2","0","1"),
("74175","Maski","74170","3","0","1"),
("74176","Dekoracje ślubne","74169","1","0","0"),
("74177","Galanteria papiernicza","74169","4","0","0"),
("74179","Pozostałe","74176","8","0","1"),
("74180","Balony i akcesoria","74176","0","0","1"),
("74181","Dekoracja samochodu","74176","1","0","1"),
("74182","Dekoracja stołu","74176","2","0","1"),
("74183","Kotyliony","74176","3","0","1"),
("74184","Poduszki na obrączki","74176","5","0","1"),
("74185","Stroiki","74176","6","0","1"),
("74186","Tasiemki, wstążki, sznurki","74176","7","0","1"),
("74187","Pozostałe","74177","5","0","1"),
("74188","Etykiety, zawieszki","74177","0","0","1"),
("74189","Księgi gości","74177","1","0","1"),
("74190","Podziękowania","74177","2","0","1"),
("74191","Winietki","74177","3","0","1"),
("74192","Zaproszenia ślubne, zawiadomienia","74177","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("74230","Szelki","1487","19","0","1"),
("74231","Wieszaki na torebki","1487","23","0","1"),
("74253","Wykrywacze metali","691","9","0","0"),
("74254","Detektory","74253","1","0","1"),
("74255","Cewki","74253","0","0","1"),
("74256","Słuchawki","74253","4","0","1"),
("74257","Osłony i torby","74253","3","0","1"),
("74258","Zasilanie","74253","5","0","1"),
("74259","Książki i poradniki","74253","2","0","1"),
("74260","Pozostałe","74253","6","0","1"),
("74297","Sanki","13599","13","0","1"),
("74299","Kaski","16656","0","0","1"),
("74300","Nagolenniki","16656","1","0","1"),
("74301","Nałokietniki","16656","2","0","1"),
("74302","Naramienniki","16656","3","0","1"),
("74303","Rękawice","16656","4","0","1"),
("74304","Spodnie","16656","5","0","1"),
("74305","Suspensory","16656","6","0","1"),
("74333","Pozostałe","16656","7","0","1"),
("74824","Kapsułki do ekspresów","74030","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("74833","Kremy i desery","74016","5","0","1"),
("74834","Akcesoria i zestawy","74038","10","0","1"),
("75513","Karty testowe","19286","1","0","1"),
("75514","Stacje lutownicze","19286","5","0","1"),
("75515","Buzzery","19285","1","0","1"),
("75520","Apple","349","0","0","1"),
("75530","BlackBerry","19321","1","0","1"),
("75532","Bold 9000","50971","0","0","1"),
("75533","Bold 9700","50971","1","0","1"),
("75534","Curve 8520","50971","5","0","1"),
("75535","Curve 8900","50971","6","0","1"),
("75536","Pearl","50971","10","0","1"),
("75537","Storm","50971","13","0","1"),
("75538","Pozostałe","50971","17","0","1"),
("75539","HTC HD2","16618","24","0","1"),
("75544","5230","4978","49","0","1"),
("75546","E72","4978","94","0","1"),
("75547","N97 mini","4978","102","0","1"),
("75549","X3","4978","105","0","1"),
("75557","Apple","50999","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("75757","Gumki recepturki","64482","3","0","1"),
("75758","Czytniki i rejestratory","64486","1","0","1"),
("75759","Kasetki","64478","2","0","1"),
("75819","Żużel","16661","1","0","1"),
("75821","Kluby polskie","3968","0","0","1"),
("75822","Kluby zagraniczne","3968","1","0","1"),
("75824","Reprezentacja Polski","3968","2","0","1"),
("75825","Reprezentacje zagraniczne","3968","3","0","1"),
("75826","Pozostałe","3968","4","0","1"),
("75834","Polska","3971","0","0","1"),
("75835","Zagranica","3971","1","0","1"),
("75993","Bielizna damska","1454","0","0","0"),
("75994","Biustonosze","75993","1","0","1"),
("75995","Biustonosze - dodatki","75993","2","0","1"),
("75996","Body","75993","3","0","1"),
("75998","Gorsety","75993","4","0","1"),
("76001","Pasy do pończoch","75993","10","0","1"),
("76003","Pończochy","75993","14","0","1"),
("76004","Rajstopy","75993","15","0","1"),
("76005","Skarpetki i kolanówki","75993","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76008","Stroje kąpielowe","75993","17","0","0"),
("76010","Topy","75993","19","0","1"),
("76012","Komplety","75993","20","0","1"),
("76013","Pozostałe","75993","21","0","1"),
("76024","Dwuczęściowe","76008","0","0","1"),
("76025","Jednoczęściowe","76008","1","0","1"),
("76026","Parea i tuniki plażowe","76008","2","0","1"),
("76027","Piżamy","75993","11","0","1"),
("76028","Szlafroki","75993","18","0","1"),
("76033","Odzież damska","1454","2","0","0"),
("76034","Bluzki","76033","0","0","1"),
("76035","Bluzy","76033","1","0","1"),
("76036","Body","76033","2","0","1"),
("76037","Bolerka","76033","3","0","1"),
("76039","Dresy kompletne","76033","4","0","1"),
("76040","Garsonki i kostiumy","76033","5","0","1"),
("76041","Golfy","76033","6","0","1"),
("76042","Kamizelki","76033","8","0","1"),
("76043","Koszule","76033","10","0","1"),
("76044","Marynarki i żakiety","76033","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76045","Okrycia wierzchnie","76033","14","0","0"),
("76075","Futra  i kożuchy","76045","0","0","1"),
("76076","Kurtki","76045","1","0","1"),
("76077","Płaszcze","76045","2","0","1"),
("76078","Poncza","76045","3","0","1"),
("76079","Pozostałe","76045","4","0","1"),
("76083","Spodenki","76033","15","0","1"),
("76084","Spódnice i spódniczki","76033","18","0","1"),
("76085","Pozostałe","76033","27","0","1"),
("76093","Spodnie","76033","17","0","0"),
("76095","Dresowe","76093","0","0","1"),
("76096","Eleganckie","76093","1","0","1"),
("76102","Swetry","76033","21","0","1"),
("76103","Topy","76033","22","0","1"),
("76104","T-shirty","76033","23","0","1"),
("76105","Tuniki","76033","24","0","1"),
("76110","Komplety","76033","25","0","1"),
("76111","Zestawy","76033","26","0","1"),
("76253","Czytniki ebooków","10","3","0","0"),
("76254","Zasilanie","10","14","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76255","Pralki","67524","7","0","1"),
("76256","Fontanny czekoladowe","67415","7","0","1"),
("76257","Kombiwary","67415","13","0","1"),
("76263","Listwy zasilające","67193","3","0","0"),
("76264","Listwy","76263","0","0","1"),
("76265","Pozostałe","76263","1","0","1"),
("76266","Do subwooferów","67195","4","0","1"),
("76267","HDMI - mini HDMI","67300","1","0","1"),
("76268","Euro-SVHS+Jack","67302","3","0","1"),
("76269","Euro-SVHS+2xCinch","67302","2","0","1"),
("76270","Pozostałe","67321","2","0","1"),
("76271","Euro-2xCinch","67321","0","0","1"),
("76272","Euro-3xCinch","67321","1","0","1"),
("76273","BNC","67284","1","0","1"),
("76274","HDMI i DVI","67284","5","0","1"),
("76275","Folie ochronne","67095","0","0","1"),
("76276","BLOW","67094","2","0","1"),
("76277","Clarion","67094","3","0","1"),
("76278","Cruser","67094","4","0","1"),
("76279","Peiying","67094","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76281","Kamery DVD","8785","2","0","1"),
("76282","Kamery Digital8","8785","1","0","1"),
("76283","Kamery MiniDV","8785","3","0","1"),
("76284","Kamery na karty pamięci","8785","4","0","1"),
("76285","Kamery z HDD","8785","6","0","1"),
("76286","Kamery cyfrowe pozostałe","8785","8","0","1"),
("76328","DAC","11","2","0","1"),
("76329","Zestawy stereo","11","17","0","1"),
("76330","Arcam","5233","0","0","1"),
("76331","Cambridge Audio","5233","1","0","1"),
("76332","NAD","5233","5","0","1"),
("76333","Panasonic","5233","7","0","1"),
("76334","Akcesoria","778","4","0","1"),
("76335","Przedwzmacniacze gramofonowe","778","2","0","1"),
("76336","Sufitowe","66925","4","0","1"),
("76337","Do zabudowy","8990","4","0","1"),
("76338","Pozostałe","63470","9","0","1"),
("76339","Denon","63470","1","0","1"),
("76340","JVC","63470","2","0","1"),
("76341","Panasonic","63470","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76342","Philips","63470","4","0","1"),
("76343","Samsung","63470","5","0","1"),
("76344","Sharp","63470","6","0","1"),
("76345","Sony","63470","7","0","1"),
("76346","Yamaha","63470","8","0","1"),
("76347","Advance Acoustic","20221","0","0","1"),
("76348","Rotel","20221","11","0","1"),
("76349","Xindak","20221","14","0","1"),
("76352","Pozostałe","14175","7","0","1"),
("76353","Audi","14175","0","0","1"),
("76354","BMW","14175","1","0","1"),
("76355","Mercedes","14175","2","0","1"),
("76356","Opel","14175","3","0","1"),
("76357","Renault","14175","4","0","1"),
("76358","Toyota","14175","5","0","1"),
("76359","VW","14175","6","0","1"),
("76360","Multiswitche","67128","5","0","1"),
("76361","Modulatory","67132","3","0","1"),
("76362","Stojaki antenowe","67132","5","0","1"),
("76363","Philips","51761","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76364","InFocus","14226","4","0","1"),
("76365","LG","14226","5","0","1"),
("76366","Vivitek","14226","13","0","1"),
("76367","Akumulatorki","76254","0","0","0"),
("76368","Baterie","76254","1","0","0"),
("76369","Adaptery","76254","3","0","1"),
("76370","Ładowarki","76254","4","0","1"),
("76371","Zasilacze","76254","5","0","1"),
("76372","Zestawy","76254","6","0","1"),
("76373","AA (R6)","76368","0","0","1"),
("76374","AAA (R3)","76368","1","0","1"),
("76375","C (R14)","76368","2","0","1"),
("76376","D (R20)","76368","3","0","1"),
("76377","Pozostałe","76368","5","0","1"),
("76378","9V (6F22)","76368","4","0","1"),
("76379","AA (R6)","76367","0","0","1"),
("76380","AAA (R3)","76367","1","0","1"),
("76381","C (R14)","76367","2","0","1"),
("76382","D (R20)","76367","3","0","1"),
("76383","9V (6F22)","76367","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76384","Pozostałe","76367","5","0","1"),
("76385","Alkomaty","1328","0","0","1"),
("76455","MDX","57967","3","0","1"),
("76456","NSX","57967","4","0","1"),
("76457","RDX","57967","5","0","1"),
("76458","RL","57967","6","0","1"),
("76459","RSX","57967","7","0","1"),
("76460","TL","57967","8","0","1"),
("76461","TSX","57967","9","0","1"),
("76462","Pozostałe","57967","10","0","1"),
("76463","Aixam","4029","1","0","0"),
("76464","A721","76463","0","0","1"),
("76466","A741","76463","1","0","1"),
("76468","A751","76463","2","0","1"),
("76470","City","76463","3","0","1"),
("76472","Crossline","76463","4","0","1"),
("76475","Roadline","76463","5","0","1"),
("76477","Scouty","76463","6","0","1"),
("76480","Scouty R","76463","7","0","1"),
("76481","Pozostałe","76463","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76593","Rękodzieło","0","21","0","0"),
("76619","Aro","4029","3","0","0"),
("76620","Muscel","76619","0","0","1"),
("76621","Seria 10","76619","1","0","1"),
("76622","Seria 240","76619","2","0","1"),
("76623","Pozostałe","76619","3","0","1"),
("76630","Bugatti","4029","8","0","0"),
("76631","EB 110","76630","0","0","1"),
("76632","Veyron","76630","1","0","1"),
("76633","Pozostałe","76630","2","0","1"),
("76652","Pozostałe","76593","8","0","1"),
("76653","Biżuteria - półprodukty","76593","0","0","0"),
("76654","Bursztyn","76653","0","0","1"),
("76655","Kamienie syntetyczne","76653","2","0","1"),
("76656","Kamienie szlachetne","76653","3","0","0"),
("76657","Koral","76653","4","0","1"),
("76658","Koraliki","76653","5","0","0"),
("76659","Crackle","76658","2","0","1"),
("76660","Fimo","76658","4","0","1"),
("76661","Szklane zwykłe","76658","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76662","Szkło weneckie","76658","10","0","1"),
("76663","Drewniane","76658","3","0","1"),
("76664","Lampwork","76658","6","0","1"),
("76665","Cloisonne","76658","1","0","1"),
("76666","Millefiori","76658","7","0","1"),
("76667","Akrylowe","76658","0","0","1"),
("76668","Pozostałe","76658","11","0","1"),
("76669","Perły i masa perłowa","76653","6","0","1"),
("76670","Półfabrykaty","76653","7","0","0"),
("76671","Bazy kolczyków ","76670","0","0","0"),
("76672","Bigle i sztyfty ","76670","1","0","0"),
("76673","Linki i żyłki","76670","4","0","1"),
("76674","Rzemyki i sznurek jubilerski","76670","9","0","1"),
("76675","Łańcuszki i ogniwa","76670","5","0","0"),
("76676","Łapaczki i końcówki","76670","6","0","0"),
("76678","Szpilki i haczyki","76670","10","0","0"),
("76679","Zaciski i stopery","76670","11","0","0"),
("76680","Zapięcia i karabińczyki","76670","12","0","0"),
("76681","Pozostałe","76670","14","0","1"),
("76682","Swarovski","76658","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76683","Narzędzia","76653","8","0","1"),
("76684","Pozostałe","76653","9","0","1"),
("76685","Decoupage","76593","1","0","0"),
("76686","Farby i lakiery","76685","0","0","1"),
("76687","Kleje i media","76685","1","0","1"),
("76688","Narzędzia i pędzle","76685","2","0","1"),
("76689","Papiery","76685","3","0","1"),
("76690","Serwetki","76685","4","0","1"),
("76691","Przedmioty do ozdabiania","76685","5","0","1"),
("76692","Pozostałe","76685","6","0","1"),
("76693","Filcowanie","76593","2","0","0"),
("76694","Czesanka i filc","76693","0","0","1"),
("76695","Igły i narzędzia","76693","1","0","1"),
("76696","Pozostałe","76693","2","0","1"),
("76697","Masy do modelowania","76593","3","0","1"),
("76698","Scrapbooking","76593","4","0","0"),
("76699","Bazy, albumy i bindowanie","76698","0","0","1"),
("76700","Dodatki i ozdoby","76698","1","0","1"),
("76701","Dziurkacze","76698","2","0","1"),
("76702","Kleje, farby i preparaty","76698","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76703","Naklejki i kalkomanie","76698","6","0","1"),
("76704","Narzędzia","76698","7","0","1"),
("76705","Nity i ćwieki","76698","8","0","1"),
("76706","Papiery","76698","9","0","1"),
("76708","Stemple","76698","11","0","1"),
("76709","Scrapki","76698","10","0","1"),
("76710","Szablony i maski","76698","12","0","1"),
("76711","Tusze i pudry","76698","13","0","1"),
("76712","Pozostałe","76698","15","0","1"),
("76713","Szycie i dziewiarstwo","76593","5","0","0"),
("76714","Akcesoria hafciarskie","76713","1","0","1"),
("76715","Akcesoria  krawieckie ","76713","0","0","1"),
("76716","Aplikacje ","76713","2","0","1"),
("76717","Druty, szydełka i czółenka ","76713","3","0","1"),
("76718","Guziki","76713","4","0","1"),
("76719","Igły, szpilki i agrafki ","76713","5","0","1"),
("76720","Nożyczki i noże","76713","9","0","1"),
("76721","Koraliki i cekiny","76713","6","0","1"),
("76722","Koronki i hafty","76713","7","0","1"),
("76723","Nici","76713","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76724","Taśmy i tasiemki","76713","10","0","1"),
("76725","Tkaniny","76713","11","0","0"),
("76726","Bawełna","76725","0","0","1"),
("76727","Len","76725","3","0","1"),
("76728","Futra i skóry","76725","1","0","1"),
("76729","Jedwab naturalny","76725","2","0","1"),
("76730","Obiciowe","76725","4","0","1"),
("76731","Satyna i atłas","76725","5","0","1"),
("76732","Szyfon, tiul i organza","76725","6","0","1"),
("76733","Tafta","76725","7","0","1"),
("76734","Wiskoza i poliester","76725","8","0","1"),
("76735","Żakard","76725","9","0","1"),
("76736","Pozostałe","76725","10","0","1"),
("76737","Włóczki","76713","12","0","1"),
("76738","Zamki i zapięcia","76713","13","0","1"),
("76739","Pozostałe","76713","14","0","1"),
("76740","Literatura","76593","6","0","1"),
("76741","Przedmioty ręcznie wykonane","76593","7","0","0"),
("76749","Pozostałe","76741","19","0","1"),
("76751","Kamienie ozdobne","76653","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("76752","Aleksandryty","76656","0","0","1"),
("76753","Diamenty","76656","1","0","1"),
("76754","Opale ","76656","2","0","1"),
("76755","Rubiny","76656","3","0","1"),
("76756","Szafiry","76656","4","0","1"),
("76757","Szmaragdy","76656","5","0","1"),
("76758","Tanzanity","76656","6","0","1"),
("76759","Topazy","76656","7","0","1"),
("76760","Turmaliny","76656","8","0","1"),
("76761","Pozostałe","76656","9","0","1"),
("76762","Drut jubilerski","76670","2","0","1"),
("76763","Elementy ozdobne","76670","3","0","0"),
("76773","Tektura","64482","8","0","1"),
("77058","Crosswagon","4030","12","0","1"),
("77059","Sportwagon","4030","19","0","1"),
("77157","M3","4032","10","0","1"),
("77167","M5","4032","12","0","1"),
("77171","M6","4032","13","0","1"),
("77175","X1","4032","14","0","0"),
("77198","Alero","12399","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77216","Cruze","12399","10","0","1"),
("77222","Matiz","12399","21","0","1"),
("77733","Architektura ogrodowa","1532","2","0","0"),
("77734","Akcesoria do biżuterii","19732","9","0","0"),
("77735","Szkatułki i pudełeczka","77734","2","0","1"),
("77736","Woreczki","77734","3","0","1"),
("77737","Środki czyszczące","77734","4","0","1"),
("77738","Pozostałe","77734","5","0","1"),
("77739","Akcesoria","73997","3","0","1"),
("77741","Wędzone","74005","0","0","1"),
("77742","Przetwory","74005","1","0","1"),
("77743","Pozostałe","74005","2","0","1"),
("77744","Pozostałe","74048","4","0","1"),
("77745","Sól i pieprz","74048","0","0","1"),
("77746","Przyprawy jednoskładnikowe","74048","2","0","1"),
("77747","Mieszanki przyprawowe","74048","1","0","1"),
("77748","Panierki","74048","3","0","1"),
("77749","Kwiaty","76698","5","0","1"),
("77750","Guziki i aplikacje","76698","3","0","1"),
("77751","Wstążki","76698","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77753","Pozostałe","2","18","0","0"),
("77754","Środki czyszczące","77753","3","0","0"),
("77755","Plomby i stickery","77753","1","0","1"),
("77766","GSM","497","3","0","0"),
("77767","Anteny i konektory","77766","0","0","1"),
("77768","Modemy GSM","77766","1","0","0"),
("77769","Pozostałe","77766","2","0","1"),
("77770","Karty miniPCI, miniPCIe","497","5","0","1"),
("77771","Karty PCMCIA i ExpressCard","497","6","0","0"),
("77772","Ethernet i modem","77771","0","0","1"),
("77773","Ethernet","77771","1","0","1"),
("77774","Modem","77771","2","0","1"),
("77775","Multimedia","77771","3","0","1"),
("77776","Nośniki danych","77771","4","0","1"),
("77777","USB, Firewire, RS232","77771","5","0","1"),
("77778","Wireless LAN","77771","6","0","1"),
("77779","Pozostałe","77771","7","0","1"),
("77780","Podstawki chłodzące","497","7","0","1"),
("77781","Stacje dokujące","497","10","0","1"),
("77782","Torby, pokrowce","497","12","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77783","Plecaki","77782","0","0","1"),
("77784","Pokrowce i etui","77782","1","0","1"),
("77785","Torby","77782","2","0","1"),
("77786","Pozostałe","77782","3","0","1"),
("77798","USB","77768","0","0","1"),
("77799","PCMCIA","77768","1","0","1"),
("77800","ExpressCard","77768","2","0","1"),
("77801","Części do laptopów","2","1","0","0"),
("77802","Dyski","77801","1","0","0"),
("77803","Klawiatury","77801","2","0","1"),
("77804","Matryce","77801","3","0","0"),
("77805","Napędy","77801","4","0","1"),
("77806","Obudowy i kadłubki","77801","5","0","0"),
("77807","Procesory","77801","8","0","0"),
("77808","Płyty główne","77801","7","0","0"),
("77809","Pamięć","77801","6","0","1"),
("77810","Wentylatory i radiatory","77801","9","0","1"),
("77811","Uszkodzone","77801","11","0","1"),
("77812","Pozostałe części","77801","12","0","0"),
("77813","Dyski SSD","77802","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77814","2,5\" Serial ATA (SATA)","77802","1","0","1"),
("77822","Uszkodzone","77802","2","0","1"),
("77823","Pozostałe","77802","3","0","1"),
("77836","17\" i większe","77804","0","0","1"),
("77837","16\" - 16.9\"","77804","1","0","1"),
("77838","15.4\" - 15.9\"","77804","2","0","1"),
("77839","15\" - 15.3\"","77804","3","0","1"),
("77840","14\" - 14.9\"","77804","4","0","1"),
("77841","13\" - 13.9\"","77804","5","0","1"),
("77842","12\" i mniejsze","77804","6","0","1"),
("77843","Taśmy i inwertery","77804","7","0","1"),
("77854","Kadłubki","77806","0","0","1"),
("77855","Kieszenie i zaślepki","77806","1","0","1"),
("77856","Klapy i ramki","77806","2","0","1"),
("77857","Obudowy ","77806","3","0","1"),
("77858","Zawiasy","77806","4","0","1"),
("77859","Pozostałe","77806","5","0","1"),
("77860","Intel","77807","0","0","1"),
("77861","AMD","77807","1","0","1"),
("77862","Acer","77808","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77863","Asus","77808","1","0","1"),
("77864","Dell","77808","2","0","1"),
("77865","HP","77808","4","0","1"),
("77866","IBM, Lenovo","77808","5","0","1"),
("77867","Sony","77808","6","0","1"),
("77868","Fujitsu-Siemens","77808","3","0","1"),
("77869","Toshiba","77808","7","0","1"),
("77870","Pozostali producenci","77808","8","0","1"),
("77877","Chipy BGA","77812","0","0","1"),
("77878","Moduły Bluetooth","77812","4","0","1"),
("77879","Karty graficzne","77812","3","0","1"),
("77880","Głośniki","77812","1","0","1"),
("77881","Gniazda zasilania","77812","2","0","1"),
("77882","Taśmy","77812","5","0","1"),
("77883","Pozostałe","77812","6","0","1"),
("77885","Stoliki pod laptopa","497","11","0","1"),
("77886","Pozostałe","505","3","0","1"),
("77887","Akcesoria GPS","505","0","0","1"),
("77888","Skórki na laptopa","505","2","0","1"),
("77889","Lampki USB","505","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77890","Pianki","77754","0","0","1"),
("77891","Płyny","77754","1","0","1"),
("77892","Ściereczki","77754","2","0","1"),
("77893","Sprężone powietrze","77754","3","0","1"),
("77894","Zestawy","77754","4","0","1"),
("77895","Pozostałe","77754","5","0","1"),
("77913","Apple","4180","1","0","1"),
("77914","Acer","491","0","0","1"),
("77915","Apple","491","1","0","1"),
("77916","Asus","491","2","0","1"),
("77917","Dell","491","3","0","1"),
("77918","Fujitsu","491","5","0","1"),
("77919","HP, Compaq","491","6","0","1"),
("77920","IBM, Lenovo","491","9","0","1"),
("77921","MSI","491","11","0","1"),
("77922","Samsung","491","13","0","1"),
("77923","Sony","491","14","0","1"),
("77924","Toshiba","491","15","0","1"),
("77925","Pozostałe","77753","4","0","1"),
("77926","Stare komputery","77753","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77927","Pozostałe","77926","5","0","1"),
("77928","Amiga","77926","0","0","0"),
("77929","Atari","77926","2","0","1"),
("77930","Commodore","77926","3","0","1"),
("77931","Spectrum","77926","4","0","1"),
("77932","Komputery","77928","0","0","1"),
("77933","Oprogramowanie","77928","1","0","1"),
("77934","Osprzęt","77928","2","0","1"),
("77935","Literatura","77928","3","0","1"),
("77937","Obudowy dysków 2,5\"","4483","3","0","1"),
("77938","Dyski i obudowy sieciowe","4475","0","0","1"),
("77939","Dyski zewnętrzne","4475","2","0","1"),
("77948","Zewnętrzne","4481","5","0","1"),
("77949","Serwisy hostingowe","15821","4","0","1"),
("77950","Konektory, kable antenowe","4441","4","0","1"),
("77951","Pozostałe","4444","4","0","1"),
("77952","Adaptery PoE","4444","0","0","1"),
("77953","Wtyki WLAN","4444","3","0","1"),
("77954","Wtyki RJ11","4444","1","0","1"),
("77955","Wtyki RJ45","4444","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77956","Anteny","4413","1","0","0"),
("77957","Pozostałe","77956","6","0","1"),
("77958","Dookólne","77956","0","0","1"),
("77959","Helikalne i Yagi","77956","1","0","1"),
("77960","Panelowe","77956","2","0","1"),
("77961","Paraboliczne","77956","3","0","1"),
("77962","Szczelinowe","77956","4","0","1"),
("77963","Uchwyty i obejmy","77956","5","0","1"),
("77964","Karty WLAN","4413","4","0","0"),
("77965","Karty PCI","77964","0","0","1"),
("77966","Karty USB","77964","1","0","1"),
("77967","Pozostałe","77964","2","0","1"),
("77968","Routery WiFi, Access Pointy","4413","10","0","0"),
("77969","3com","77968","0","0","1"),
("77970","Asmax","77968","1","0","1"),
("77971","Asus","77968","2","0","1"),
("77972","Cisco","77968","4","0","1"),
("77973","D-Link","77968","5","0","1"),
("77974","Edimax","77968","6","0","1"),
("77975","Linksys","77968","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("77976","Netgear","77968","8","0","1"),
("77977","Ovislink","77968","9","0","1"),
("77978","Planet","77968","11","0","1"),
("77979","Pentagram","77968","10","0","1"),
("77980","Tp-Link","77968","12","0","1"),
("77981","Inni producenci","77968","13","0","1"),
("77982","Routery przewodowe","4413","9","0","1"),
("77984","4 porty i mniejsze","4421","0","0","1"),
("77985","5 portów i większe","4421","1","0","1"),
("77989","Okulary i hełmy 3D","4312","6","0","1"),
("77990","Avermedia","4315","0","0","1"),
("77991","Leadtek","4315","1","0","1"),
("77992","LifeView","4315","2","0","1"),
("77993","PixelView","4315","4","0","1"),
("77994","Philips","4315","3","0","1"),
("77995","Inny producent","4315","5","0","1"),
("77997","G-Data","14569","6","0","1"),
("78013","Ciąża i macierzyństwo","1454","7","0","0"),
("78014","Pozostałe","78013","16","0","1"),
("78015","Biustonosze","78013","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("78016","Bluzki","78013","1","0","1"),
("78017","Koszule nocne","78013","3","0","1"),
("78018","Legginsy","78013","4","0","1"),
("78019","Majtki","78013","5","0","1"),
("78020","Pasy ciążowe","78013","6","0","1"),
("78021","Piżamy","78013","7","0","1"),
("78022","Płaszcze","78013","8","0","1"),
("78023","Rajstopy","78013","9","0","1"),
("78024","Spodnie","78013","10","0","0"),
("78025","Spódnice","78013","11","0","1"),
("78026","Sukienki","78013","12","0","1"),
("78027","Swetry","78013","13","0","1"),
("78028","Tuniki","78013","14","0","1"),
("78029","Zestawy","78013","15","0","1"),
("78036","Pozostałe","78024","4","0","1"),
("78037","Dresowe","78024","0","0","1"),
("78038","Jeansy","78024","1","0","1"),
("78039","Wizytowe","78024","3","0","1"),
("78044","Ogrodniczki","78024","2","0","1"),
("78055","Vivaz","5044","35","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("78060","Pozostałe","19292","4","0","1"),
("78061","Motorola","19292","0","0","1"),
("78062","Nokia","19292","1","0","1"),
("78063","Samsung","19292","2","0","1"),
("78064","Sony Ericsson","19292","3","0","1"),
("78075","Karty pamięci","4","2","0","0"),
("78078","MicroSD (TransFlash)","78075","0","0","1"),
("78079","Pozostałe","78075","1","0","1"),
("78123","MiniDVI","4738","3","0","1"),
("78134","Podwiązki","75993","13","0","1"),
("78137","Kombinezony","76033","9","0","1"),
("78138","Gorsety","76033","7","0","1"),
("78139","Kaszkiety","1496","4","0","1"),
("78140","Opaski","1496","6","0","1"),
("78147","Czapki zimowe","1496","2","0","1"),
("78588","S3","4031","25","0","0"),
("78589","S4","4031","26","0","0"),
("78590","S5","4031","27","0","1"),
("78591","S6","4031","28","0","0"),
("78592","S8","4031","30","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("78593","8L (1996-2003)","78588","0","0","1"),
("78598","8P (2003-2012)","78588","1","0","1"),
("78604","B5 (1995-2001)","78589","0","0","1"),
("78605","B6 (2000-2004)","78589","1","0","1"),
("78606","B7 (2004-2007)","78589","2","0","1"),
("78607","B8 (2007-2015)","78589","3","0","1"),
("78608","C4 (1994-1997)","78591","0","0","1"),
("78609","C6 (2004-2011)","78591","2","0","1"),
("78612","C5 (1997-2004)","78591","1","0","1"),
("78613","D2 (1994-2002)","78592","0","0","1"),
("78614","D3 (2002-2010)","78592","1","0","1"),
("78615","S70","4056","4","0","1"),
("78673","Wyposażenie","12092","1","0","1"),
("78674","Umundurowanie","12092","0","0","1"),
("78713","Torebki miejskie","1492","0","0","1"),
("78714","Torebki sportowe","1492","1","0","1"),
("78715","Torebki wizytowe","1492","2","0","1"),
("78716","Patrolówki","1496","7","0","1"),
("78717","Bielizna wyszczuplająca","75993","0","0","0"),
("78718","Pozostałe","78717","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("78719","Gorsety","78717","0","0","1"),
("78720","Majtki","78717","1","0","1"),
("78721","Pasy","78717","2","0","1"),
("78993","Cygaretki","47953","1","0","1"),
("78995","Akcesoria papierosowe","47937","0","0","0"),
("78996","Nabijarki","78995","2","0","1"),
("78997","Gilzy","78995","0","0","1"),
("78998","Popielniczki","78995","4","0","1"),
("78999","Papierośnice","78995","3","0","1"),
("79000","Lufki","78995","1","0","1"),
("79153","Literatura piękna, popularna i faktu","7","1","0","0"),
("79154","Biografie, wspomnienia","79153","0","0","0"),
("79155","Dramaty, utwory sceniczne","79153","1","0","0"),
("79156","Fantasy","79153","2","0","0"),
("79157","Historyczne","79153","3","0","1"),
("79158","Horrory","79153","4","0","1"),
("79159","Humor, parodia, satyra","79153","5","0","1"),
("79160","Kryminały","79153","6","0","0"),
("79161","Poezja","79153","11","0","0"),
("79162","Przygodowe","79153","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("79163","Romanse","79153","14","0","1"),
("79164","Science fiction","79153","15","0","0"),
("79165","Literatura obyczajowa","79153","8","0","0"),
("79166","Thrillery, sensacyjne","79153","16","0","0"),
("79167","Zestawy, kolekcje","79153","17","0","1"),
("79168","Pozostałe","79153","18","0","1"),
("79193","Poradniki i albumy","7","7","0","0"),
("79194","Pozostałe","79193","23","0","1"),
("79195","Biznes, praca, prawo, finanse","79193","0","0","0"),
("79197","Dom i ogród","79193","1","0","0"),
("79199","Fotografia, edycja zdjęć","79193","3","0","0"),
("79201","Hobby, kolekcjonerstwo","79193","5","0","0"),
("79202","Internet, komputery","79193","6","0","0"),
("79205","Kuchnia, potrawy","79193","7","0","0"),
("79206","Ezoteryka, magia, UFO","79193","2","0","0"),
("79207","Sztuka i architektura","79193","18","0","0"),
("79208","Moda, uroda","79193","9","0","0"),
("79209","Motoryzacja, transport","79193","10","0","0"),
("79210","Motywacja, rozwój osobisty","79193","11","0","0"),
("79211","Muzyka, taniec, śpiew","79193","12","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("79212","Rodzina, ciąża, wychowanie","79193","15","0","0"),
("79213","Seks, relacje partnerskie","79193","16","0","1"),
("79216","Sport, forma fizyczna","79193","17","0","0"),
("79218","Wiara, duchowość","79193","19","0","0"),
("79219","Zdrowie, pierwsza pomoc","79193","20","0","0"),
("79220","Zwierzęta domowe i hodowlane","79193","21","0","0"),
("79413","Komiksy","7","9","0","0"),
("79414","Amerykańskie","79413","0","0","0"),
("79415","Europejskie","79413","1","0","0"),
("79416","Japońskie","79413","2","0","0"),
("79417","Polskie","79413","3","0","0"),
("79418","Czasopisma","79413","4","0","1"),
("79419","Pozostałe","79413","7","0","1"),
("79420","Mapy, przewodniki, książki podróżnicze","7","6","0","0"),
("79432","Literatura piękna - proza polska","79153","9","0","1"),
("79433","Literatura piękna - proza zagraniczna","79153","10","0","0"),
("79455","Książki naukowe i popularnonaukowe","7","2","0","0"),
("79456","Pozostałe","79455","23","0","1"),
("79458","Technika, nauki techniczne","79455","22","0","0"),
("79459","Biologia, ekologia","79455","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("79460","Chemia, biochemia","79455","5","0","0"),
("79462","Filologie, językoznawstwo","79455","6","0","0"),
("79463","Filozofia, historia filozofii","79455","7","0","0"),
("79464","Fizyka, astronomia","79455","8","0","0"),
("79465","Geografia, geologia, turystyka","79455","9","0","0"),
("79466","Historia, archeologia","79455","10","0","0"),
("79467","Literaturoznawstwo","79455","12","0","0"),
("79468","Informatyka, internet","79455","11","0","0"),
("79469","Medycyna, nauki medyczne","79455","14","0","0"),
("79470","Pedagogika, resocjalizacja","79455","15","0","0"),
("79471","Politologia, stos. międzynarodowe","79455","16","0","0"),
("79472","Prawo, administracja","79455","17","0","0"),
("79473","Psychologia, socjologia","79455","18","0","0"),
("79475","Religioznawstwo, nauki teologiczne","79455","19","0","0"),
("79477","Sztuka, kultura i etnologia","79455","21","0","0"),
("79478","Rolnictwo, nauki rolnicze","79455","20","0","0"),
("79495","HTC Desire","16618","4","0","1"),
("79499","6700 Slide","4978","63","0","1"),
("79500","7230","4978","66","0","1"),
("79501","C5","4978","82","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("79505","Elm","5044","30","0","1"),
("79506","XPERIA X10","5044","24","0","1"),
("79847","Marynistyka, żeglarstwo","79193","8","0","0"),
("79848","Życie codzienne, obyczaje","79193","22","0","0"),
("82255","Akcesoria pszczelarskie","1532","1","0","1"),
("82256","Meble ogrodowe","1532","8","0","0"),
("82257","Hamaki","82256","0","0","1"),
("82258","Huśtawki","82256","1","0","1"),
("82259","Leżaki i leżanki","82256","2","0","1"),
("82260","Ławy i ławki","82256","3","0","1"),
("82261","Parasole ogrodowe","82256","4","0","1"),
("82262","Stoły i krzesła","82256","5","0","1"),
("82263","Pozostałe","82256","7","0","1"),
("82269","Grille","47493","0","0","1"),
("82270","Kociołki","47493","1","0","1"),
("82271","Akcesoria","47493","3","0","1"),
("82272","Pozostałe","47493","5","0","1"),
("82277","Pozostałe","77733","15","0","1"),
("82278","Obrzeża","77733","4","0","1"),
("82279","Szklarnie","77733","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82280","Tunele foliowe","77733","12","0","1"),
("82281","Pergole i trejaże","77733","7","0","1"),
("82282","Altany","77733","0","0","1"),
("82283","Domki","77733","1","0","1"),
("82284","Place zabaw","77733","8","0","1"),
("82285","Pozostałe","47492","6","0","1"),
("82286","Konewki","47492","0","0","1"),
("82287","Węże i zraszacze","47492","4","0","1"),
("82288","Złączki i końcówki","47492","5","0","1"),
("82289","Przewody kroplujące","47492","2","0","1"),
("82290","Systemy nawadniające","47492","3","0","1"),
("82295","S40","4056","2","0","0"),
("82326","Gry na konsole","9","1","0","0"),
("82327","Pozostałe","82326","24","0","1"),
("82328","Game Boy Advance","82326","1","0","0"),
("82329","Game Boy Classic","82326","2","0","1"),
("82330","Game Boy Color","82326","3","0","0"),
("82331","Microsoft Xbox","82326","4","0","0"),
("82332","Microsoft Xbox 360","82326","5","0","0"),
("82333","Nintendo 64","82326","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82334","Nintendo DS","82326","9","0","0"),
("82335","Bijatyki","82328","0","0","1"),
("82336","Platformówki","82328","1","0","1"),
("82337","Przygodowe","82328","2","0","1"),
("82338","Role Playing (RPG)","82328","3","0","1"),
("82339","Sportowe","82328","4","0","1"),
("82340","Strzelanki","82328","5","0","1"),
("82341","Wyścigi","82328","6","0","1"),
("82342","Pozostałe","82328","7","0","1"),
("82344","Platformówki","82330","0","0","1"),
("82345","Przygodowe","82330","1","0","1"),
("82346","Pozostałe","82330","2","0","1"),
("82347","Bijatyki","82331","0","0","1"),
("82348","Gry akcji","82331","1","0","1"),
("82349","Role Playing (RPG)","82331","3","0","1"),
("82350","Pozostałe","82331","7","0","1"),
("82351","Strzelaniny","82331","5","0","1"),
("82352","Wyścigi","82331","6","0","1"),
("82353","Sportowe","82331","4","0","1"),
("82354","Przygodowe","82331","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82355","Bijatyki","82332","0","0","1"),
("82356","Gry akcji","82332","1","0","1"),
("82357","Role Playing (RPG)","82332","5","0","1"),
("82358","Przygodowe","82332","4","0","1"),
("82359","Muzyczne","82332","2","0","1"),
("82360","Sportowe","82332","6","0","1"),
("82361","Strzelaniny","82332","7","0","1"),
("82362","Pozostałe","82332","9","0","1"),
("82363","Platformówki","82332","3","0","1"),
("82364","Wyścigi","82332","8","0","1"),
("82368","Gry akcji","82334","0","0","1"),
("82369","Logiczne","82334","1","0","1"),
("82370","Platformówki","82334","2","0","1"),
("82371","Przygodowe","82334","3","0","1"),
("82372","Sportowe","82334","4","0","1"),
("82373","Pozostałe","82334","5","0","1"),
("82374","Nintendo GameCube","82326","10","0","1"),
("82375","Nintendo (SNES i NES)","82326","11","0","0"),
("82376","Nintendo Wii","82326","13","0","0"),
("82379","SNES","82375","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82380","NES","82375","0","0","1"),
("82381","Gry akcji","82376","0","0","1"),
("82382","Przygodowe","82376","2","0","1"),
("82383","Platformówki","82376","1","0","1"),
("82384","Sportowe","82376","3","0","1"),
("82385","Pozostałe","82376","4","0","1"),
("82391","Sega Dreamcast","82326","15","0","1"),
("82392","Sega (inne)","82326","16","0","0"),
("82393","Sega Saturn","82392","1","0","1"),
("82394","Sega Megadrive","82392","0","0","1"),
("82395","Pozostałe ","82392","2","0","1"),
("82396","Sony Playstation 2","82326","17","0","0"),
("82397","Sony Playstation 3","82326","18","0","0"),
("82398","Sony Playstation (PSX)","82326","20","0","0"),
("82399","Bijatyki","82396","0","0","1"),
("82400","Gry akcji","82396","1","0","1"),
("82401","Wyścigi","82396","10","0","1"),
("82402","Przygodowe","82396","4","0","1"),
("82403","Platformówki","82396","3","0","1"),
("82404","Pozostałe","82396","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82405","Role Playing (RPG)","82396","5","0","1"),
("82406","Strzelaniny","82396","7","0","1"),
("82407","Survival Horror","82396","8","0","1"),
("82408","Sportowe","82396","6","0","1"),
("82409","Symulacje","82396","9","0","1"),
("82410","Muzyczne","82396","2","0","1"),
("82411","Zestawy gier","82396","11","0","1"),
("82421","Bijatyki","82397","0","0","1"),
("82422","Gry akcji","82397","1","0","1"),
("82423","Przygodowe","82397","3","0","1"),
("82424","Role Playing (RPG)","82397","4","0","1"),
("82425","Muzyczne","82397","2","0","1"),
("82426","Wyścigi","82397","7","0","1"),
("82427","Strzelaniny","82397","6","0","1"),
("82428","Pozostałe","82397","8","0","1"),
("82429","Sportowe","82397","5","0","1"),
("82435","Bijatyki","82398","0","0","1"),
("82436","Przygodowe","82398","3","0","1"),
("82437","Gry akcji","82398","1","0","1"),
("82438","Sportowe","82398","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82439","Wyścigi","82398","7","0","1"),
("82440","Role Playing (RPG)","82398","4","0","1"),
("82441","Pozostałe","82398","8","0","1"),
("82442","Platformówki","82398","2","0","1"),
("82443","Symulacje","82398","6","0","1"),
("82451","Sony PSP","82326","22","0","0"),
("82452","Filmy UMD","82451","0","0","1"),
("82453","Gry akcji","82451","2","0","1"),
("82454","Bijatyki","82451","1","0","1"),
("82455","Przygodowe","82451","4","0","1"),
("82456","Sportowe","82451","6","0","1"),
("82457","Wyścigi","82451","7","0","1"),
("82458","Role Playing (RPG)","82451","5","0","1"),
("82459","Platformówki","82451","3","0","1"),
("82460","Pozostałe","82451","8","0","1"),
("82480","Złoto","45752","3","0","1"),
("82481","Klucze i edycje pudełkowe","45753","0","0","1"),
("82482","Gry przeglądarkowe","45715","4","0","1"),
("82483","Daemons of Chaos","6058","2","0","1"),
("82484","Strzelaniny","45713","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82485","Muzyczne","45713","4","0","1"),
("82486","Pozostałe","45724","3","0","1"),
("82487","Lotnicze","45724","0","0","1"),
("82488","Samochodowe","45724","1","0","1"),
("82489","The Sims","45724","2","0","1"),
("82542","Fantazyjne","84","2","0","1"),
("82578","Pegasus","82326","23","0","1"),
("82593","Wózki","11763","9","0","0"),
("82594","Foteliki samochodowe","11763","2","0","0"),
("82595","Akcesoria dla dzieci","11763","0","0","0"),
("82596","Leżaczki i huśtawki","82595","2","0","1"),
("82597","Chodziki","82595","0","0","1"),
("82598","Nosidełka i chusty","82595","4","0","0"),
("82599","Krzesełka do karmienia","82595","1","0","1"),
("82600","Nianie elektroniczne i monitory oddechu","82595","3","0","1"),
("82601","Zabezpieczenia","82595","5","0","0"),
("82602","Pozostałe","82595","6","0","1"),
("82610","Wielofunkcyjne","82593","0","0","1"),
("82611","Spacerowe","82593","1","0","1"),
("82612","Bliźniacze","82593","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82613","Głębokie","82593","3","0","1"),
("82614","Akcesoria","82593","4","0","0"),
("82615","Pozostałe","82593","5","0","1"),
("82657","Pozostałe","82614","11","0","1"),
("82658","Gondole","82614","3","0","1"),
("82659","Śpiworki","82614","9","0","1"),
("82660","Parasolki do wózków","82614","7","0","1"),
("82661","Torby do wózków","82614","10","0","1"),
("82662","Folie, okrycia na nóżki","82614","2","0","1"),
("82663","Adaptery do wózków","82614","0","0","1"),
("82664","Dostawki, platformy","82614","1","0","1"),
("82698","Bramki na schody","82601","0","0","1"),
("82699","Do szafek, szuflad","82601","6","0","1"),
("82700","Do narożników","82601","5","0","1"),
("82701","Do kontaktów","82601","2","0","1"),
("82702","Do łóżeczek","82601","4","0","1"),
("82703","Kaski ochronne","82601","7","0","1"),
("82704","Do kuchni","82601","3","0","1"),
("82705","Szelki zabezpieczające","82601","9","0","1"),
("82706","Pozostałe","82601","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("82714","Podstawki","82594","1","0","1"),
("82715","Akcesoria","82594","2","0","0"),
("82716","Pozostałe","82594","3","0","1"),
("82763","Bazy isofix","82715","1","0","1"),
("82764","Pokrowce","82715","3","0","1"),
("82765","Organizery, ochraniacze","82715","2","0","1"),
("82766","Adaptery do fotelików","82715","0","0","1"),
("82767","Rolety samochodowe","82715","4","0","1"),
("82768","Zagłówki","82715","5","0","1"),
("82769","Pozostałe","82715","6","0","1"),
("82774","Konie na biegunach","19477","1","0","1"),
("82775","Skoczki","19477","2","0","1"),
("82776","Bujaki","19477","0","0","1"),
("82777","Pozostałe","19477","3","0","1"),
("82889","Przyczepki","82614","8","0","1"),
("82900","Koła, opony","82614","4","0","1"),
("83013","Materace, wkładki","82614","5","0","1"),
("83014","Moskitiery","82614","6","0","1"),
("83633","214","4048","8","0","1"),
("83659","Kalosze","25952","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("83664","Profilaktyczne","25952","8","0","1"),
("83674","Balerinki","25952","0","0","1"),
("83684","Nosidełka","82598","0","0","1"),
("83685","Chusty","82598","1","0","1"),
("83699","Do drzwi","82601","1","0","1"),
("83700","Maty antypoślizgowe","82601","8","0","1"),
("83701","Wiosła","13537","2","0","1"),
("83702","Opakowania wodoszczelne","13537","1","0","1"),
("83703","Pokrowce, torby","13538","10","0","1"),
("83704","Węże","13539","16","0","0"),
("83705","Balast","13539","2","0","1"),
("83706","Kusze i groty","13539","8","0","1"),
("83708","Buty i klapki","13540","0","0","1"),
("83709","Obuwie","13541","5","0","1"),
("83710","Kaptury, opaski, rękawice","13576","0","0","1"),
("83711","Obuwie","13542","5","0","1"),
("83712","Sztormiaki","13589","4","0","1"),
("83713","Sprzęt ratunkowy i asekuracyjny","13535","9","0","0"),
("83714","Pozostałe","83713","4","0","1"),
("83715","Bojki i rzutki","83713","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("83716","Kamizelki","83713","1","0","1"),
("83717","Kapoki","83713","2","0","1"),
("83718","Koła ratunkowe","83713","3","0","1"),
("83720","IV (2006-)","12580","3","0","1"),
("83721","125p","4035","1","0","1"),
("83722","Palio","4035","23","0","1"),
("83723","Punto","4035","25","0","0"),
("83724","I (1994-1999)","83723","0","0","1"),
("83725","II (1999-2003)","83723","1","0","1"),
("83726","II FL (2003-)","83723","2","0","1"),
("83728","Xedos","4040","25","0","1"),
("83729","Millenia","4040","15","0","1"),
("83730","111","4048","3","0","1"),
("83731","114","4048","4","0","1"),
("83732","115","4048","5","0","1"),
("83733","200","4048","6","0","1"),
("83734","213","4048","7","0","1"),
("83735","216","4048","9","0","1"),
("83736","218","4048","10","0","1"),
("83737","220","4048","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("83738","400","4048","12","0","1"),
("83739","414","4048","13","0","1"),
("83740","416","4048","14","0","1"),
("83741","418","4048","15","0","1"),
("83742","420","4048","16","0","1"),
("83743","600","4048","17","0","1"),
("83744","618","4048","18","0","1"),
("83745","620","4048","19","0","1"),
("83746","623","4048","20","0","1"),
("83747","800","4048","21","0","1"),
("83748","820","4048","22","0","1"),
("83749","823","4048","23","0","1"),
("83750","825","4048","24","0","1"),
("83751","827","4048","25","0","1"),
("83752","1000","18281","0","0","1"),
("83753","1300","18281","1","0","1"),
("83754","Cooper","18281","3","0","1"),
("83755","Cooper S","18281","4","0","1"),
("83756","ONE","18281","6","0","1"),
("83757","Pozostałe","18281","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("83758","KA","4036","21","0","0"),
("83759","Transporter","4055","29","0","0"),
("83760","T1","83759","0","0","1"),
("83761","T2","83759","1","0","1"),
("83762","T3","83759","2","0","1"),
("83763","T4","83759","3","0","1"),
("83764","T5","83759","4","0","1"),
("83765","Multivan","4055","18","0","1"),
("83771","W201 (190)","4041","31","0","1"),
("83801","Sprinter","4041","25","0","0"),
("83802","Vito","4041","28","0","0"),
("83918","Transit","4036","39","0","0"),
("83919","II (1978-1986)","83918","0","0","1"),
("83920","III (1986-1994)","83918","1","0","1"),
("83921","V (2000-2006)","83918","3","0","1"),
("83922","Maverick","4036","23","0","1"),
("83923","Escape","4036","7","0","1"),
("83924","1.5","4046","0","0","1"),
("83925","1.6","4046","1","0","1"),
("83927","Grand Scenic","4047","11","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("83928","Grand Espace","4047","10","0","1"),
("84735","Piórniki","50673","2","0","1"),
("84736","Pomoce naukowe","50673","3","0","0"),
("84737","Śniadaniówki i bidony","50673","6","0","1"),
("84738","Globusy","84736","0","0","1"),
("84739","Mapy","84736","2","0","1"),
("84740","Tablice","84736","4","0","1"),
("84741","Inne","84736","5","0","1"),
("84742","Naklejki","50675","3","0","1"),
("84743","Kolorowanki","50675","2","0","1"),
("84744","Karteczki","50675","1","0","1"),
("84745","Zestawy","50676","7","0","1"),
("84819","Kredy","50676","3","0","1"),
("84906","Reborn","11825","21","0","1"),
("84948","Lalki z bajek","11825","13","0","1"),
("84949","Steffi","11825","22","0","1"),
("84950","Łóżeczka i kołyski","11825","30","0","1"),
("84953","Domki dla lalek","11825","27","0","1"),
("84971","Grande Punto","4035","18","0","1"),
("84972","W124 (1993-1997)","12735","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("85033","J (2009-2015)","12602","3","0","1"),
("85035","Klimatyzatory","46099","2","0","1"),
("85102","Przybory geometryczne","84736","3","0","1"),
("85110","Q45","18197","5","0","1"),
("85111","QX","18197","9","0","1"),
("85112","Pozostałe","18197","12","0","1"),
("85153","Kalkulatory","84736","1","0","1"),
("85154","Podkłady","50675","6","0","1"),
("85155","Plany lekcji","50675","5","0","1"),
("85159","Kawiarki","67415","12","0","1"),
("85160","Zestawy","67413","13","0","1"),
("85166","Bezprzewodowe","66887","0","0","1"),
("85172","Elementy wygłuszające","709","2","0","1"),
("85173","Urządzenia","67191","0","0","1"),
("85174","Akcesoria","67191","1","0","1"),
("85193","Pozostałe","1534","21","0","1"),
("85194","Glebogryzarki","1534","0","0","1"),
("85195","Grabie","1534","1","0","1"),
("85196","Kosiarki","1534","2","0","0"),
("85197","Kosy i podkaszarki","1534","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("85198","Łopaty i widły","1534","8","0","1"),
("85199","Motyki i kultywatory","1534","10","0","1"),
("85202","Odkurzacze i dmuchawy ","1534","11","0","1"),
("85203","Odśnieżarki  ","1534","12","0","1"),
("85204","Opryskiwacze ","1534","13","0","1"),
("85206","Rozdrabniacze ","1534","14","0","1"),
("85207","Siekiery ","1534","15","0","1"),
("85208","Siewniki  ","1534","16","0","1"),
("85210","Wertykulatory i aeratory   ","1534","18","0","1"),
("85211","Zestawy narzędzi ","1534","19","0","1"),
("85212","Kosiarki elektryczne","85196","1","0","1"),
("85213","Kosiarki spalinowe","85196","2","0","1"),
("85214","Pompy i hydrofory","47492","1","0","1"),
("85260","Evi","11825","10","0","1"),
("85261","Baby Alive","11825","2","0","1"),
("85262","Foteliki i krzesełka","11825","28","0","1"),
("85263","Zestawy do pielęgnacji","11825","33","0","1"),
("85264","Szmacianki","11825","23","0","1"),
("85265","Mebelki dla lalek","11825","31","0","1"),
("85266","Anne Geddes","11825","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("85267","Winx","11825","26","0","1"),
("85269","High School Musical","11825","11","0","1"),
("85270","Bobasy","11825","6","0","1"),
("85271","Głowy do stylizacji","11825","29","0","1"),
("85272","W212 (2009-2016)","12735","3","0","1"),
("85852","iPhone 4","48978","3","0","1"),
("85880","GT540","10539","16","0","1"),
("85889","Zestawy","165","38","0","1"),
("86073","Tkaniny","26013","7","0","0"),
("86074","Pozostałe","86073","8","0","1"),
("86075","Firany","86073","1","0","1"),
("86076","Zasłony","86073","6","0","1"),
("86077","Gobeliny","86073","2","0","1"),
("86078","Dywany","86073","0","0","1"),
("86079","Kilimy","86073","3","0","1"),
("86080","Obrusy","86073","4","0","1"),
("86081","Serwety","86073","5","0","1"),
("86082","Aparaty fotograficzne","47910","0","0","1"),
("86134","XC 60","4056","12","0","0"),
("86135","Portugalia","59280","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("86136","Grecja","59280","9","0","1"),
("86137","Szwecja","59280","19","0","1"),
("86138","Grecja","59279","9","0","1"),
("86273","Zabawki ogrodowe","11763","11","0","0"),
("86274","Pozostałe","86273","13","0","1"),
("86275","Baseny","86273","1","0","1"),
("86276","Do pływania","86273","3","0","1"),
("86277","Do piaskownicy","86273","2","0","1"),
("86278","Domki, namioty","86273","4","0","0"),
("86279","Meble ogrodowe","86273","7","0","1"),
("86280","Huśtawki","86273","6","0","1"),
("86281","Piaskownice","86273","8","0","1"),
("86282","Trampoliny","86273","11","0","0"),
("86283","Zjeżdżalnie","86273","12","0","0"),
("86284","Akcesoria ogrodnicze","86273","0","0","0"),
("86285","Gry i zabawy","86273","5","0","0"),
("86286","Piłki","86273","9","0","1"),
("86287","Pozostałe","86284","3","0","1"),
("86288","Kosiarki","86284","0","0","1"),
("86289","Taczki","86284","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("86290","Wózki","86284","2","0","1"),
("86306","Domki z tworzywa, drewna","86278","0","0","1"),
("86307","Namioty","86278","1","0","1"),
("86318","Pozostałe","86285","7","0","1"),
("86319","Piłka nożna","86285","5","0","1"),
("86320","Koszykówka","86285","2","0","1"),
("86321","Mini golf","86285","4","0","1"),
("86322","Skakanki","86285","6","0","1"),
("86323","Hokej","86285","0","0","1"),
("86324","Jojo","86285","1","0","1"),
("86325","Latawce","86285","3","0","1"),
("86342","Place zabaw","86273","10","0","1"),
("86348","Smoby","86283","1","0","1"),
("86349","Little Tikes","86283","0","0","1"),
("86350","Tobi Toys","86283","2","0","1"),
("86351","Inne","86283","3","0","1"),
("86352","Samochody i pojazdy","11818","15","0","0"),
("86353","Pozostałe","86352","18","0","1"),
("86354","Autobusy","86352","1","0","1"),
("86355","Osobowe","86352","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("86356","Traktory","86352","11","0","1"),
("86357","Dźwigi","86352","4","0","1"),
("86358","Koparki","86352","5","0","1"),
("86359","Ciężarówki","86352","3","0","1"),
("86360","Śmieciarki","86352","10","0","1"),
("86361","Straż","86352","9","0","1"),
("86362","Ambulanse","86352","0","0","1"),
("86363","Policja","86352","8","0","1"),
("86364","Betoniarki","86352","2","0","1"),
("86365","Motory","86352","6","0","1"),
("86366","Wywrotki","86352","12","0","1"),
("86367","Garaże","86352","13","0","1"),
("86368","Zestawy","86352","17","0","1"),
("86369","Serie","86352","15","0","1"),
("86370","Pojazdy z bajek","86352","14","0","1"),
("86380","Samoloty i pokrewne","11818","16","0","0"),
("86381","Samoloty","86380","3","0","1"),
("86382","Helikoptery","86380","0","0","1"),
("86383","Rakiety, promy","86380","2","0","1"),
("86384","Łodzie, statki","86380","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("86385","Pozostałe","86380","4","0","1"),
("86386","Rowery i pojazdy","11763","8","0","0"),
("86387","Pozostałe","86386","16","0","1"),
("86389","Rowery trójkołowe","86386","2","0","1"),
("86390","Traktorki","86386","13","0","1"),
("86392","Pojazdy elektryczne","86386","4","0","0"),
("86393","Jeździki","86386","8","0","1"),
("86394","Hulajnogi","86386","7","0","1"),
("86395","Rolki","86386","11","0","1"),
("86396","Deskorolki","86386","5","0","1"),
("86397","Akcesoria","86386","15","0","0"),
("86398","Pozostałe","86392","5","0","1"),
("86399","Samochody","86392","3","0","1"),
("86400","Quady","86392","2","0","1"),
("86401","Motory","86392","1","0","1"),
("86413","Gokarty","86386","6","0","1"),
("86414","Rowery biegowe","86386","0","0","1"),
("86415","Rowery tradycyjne","86386","1","0","1"),
("86443","Samochody na pedały","86386","12","0","1"),
("86444","Quady na pedały","86386","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("86445","Akcesoria","86392","4","0","1"),
("86446","Hulajnogi, segwaye","86392","0","0","1"),
("87833","Garnitury","1455","2","0","1"),
("87834","Kamizelki","1455","3","0","0"),
("87835","Kamizelki eleganckie","87834","1","0","1"),
("87836","Koszule","1455","4","0","0"),
("87837","Koszule eleganckie","87836","1","0","1"),
("87839","Marynarki","1455","8","0","1"),
("87840","Spodnie","1455","12","0","0"),
("87842","Eleganckie","87840","1","0","1"),
("87843","Bluzy","1455","0","0","1"),
("87844","Dresy kompletne","1455","1","0","1"),
("87846","Kamizelki casual (na co dzień)","87834","0","0","1"),
("87848","HTC Wildfire","16618","38","0","1"),
("87851","C3","4978","80","0","1"),
("87855","XPERIA X10 mini","5044","25","0","1"),
("87856","XPERIA X10 mini pro","5044","26","0","1"),
("87873","Koszule casual (na co dzień)","87836","0","0","1"),
("87874","Koszulki bez rękawów","1455","5","0","1"),
("87875","Koszulki polo","1455","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("87876","Koszulki z długim rękawem","1455","7","0","1"),
("87878","Komplety","1455","15","0","1"),
("87893","Spodenki","1455","10","0","1"),
("87894","Dresowe","87840","0","0","1"),
("87897","Swetry","1455","13","0","1"),
("87913","T-shirty","1455","14","0","1"),
("87914","III (2008-2016)","12647","2","0","1"),
("87981","Tenisówki","531","15","0","1"),
("87982","Atmosphere","5545","3","0","1"),
("87983","Tommy Hilfiger","5545","25","0","1"),
("87994","F01 (2008-2015)","12438","4","0","1"),
("87995","F10 (2009-2017)","12437","5","0","1"),
("88293","Okazje, przyjęcia","11763","6","0","0"),
("88294","Zaproszenia","88293","7","0","0"),
("88295","Dekoracje i gadżety","88293","1","0","0"),
("88296","Naczynia","88293","3","0","0"),
("88297","Dodatki","88293","2","0","0"),
("88298","Odzież, obuwie","88293","4","0","0"),
("88299","Pamiątki","88293","6","0","0"),
("88300","Pozostałe","88293","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("88301","Pozostałe","88298","3","0","1"),
("88302","Komunia","88298","1","0","0"),
("88303","Chrzest","88298","0","0","0"),
("88304","Kostiumy, przebrania","88298","2","0","0"),
("88305","Pozostałe","88303","5","0","1"),
("88306","Garnitury i ubranka","88303","2","0","1"),
("88307","Sukieneczki i stroje","88303","3","0","1"),
("88308","Czapeczki","88303","1","0","1"),
("88309","Buciki","88303","0","0","1"),
("88310","Sweterki, pelerynki","88303","4","0","1"),
("88311","Pozostałe","88302","6","0","1"),
("88312","Alby","88302","0","0","1"),
("88313","Sukienki","88302","4","0","1"),
("88314","Garnitury","88302","1","0","1"),
("88315","Koszule","88302","2","0","1"),
("88316","Obuwie","88302","3","0","1"),
("88317","Sweterki, pelerynki","88302","5","0","1"),
("88318","Kostiumy dla chłopców","88304","0","0","1"),
("88319","Kostiumy dla dziewczynek","88304","1","0","1"),
("88320","Kostiumy uniseks","88304","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("88321","Pozostałe","88297","6","0","1"),
("88322","Komunia","88297","1","0","0"),
("88323","Chrzest","88297","0","0","0"),
("88324","Kostiumy, przebrania","88297","2","0","0"),
("88325","Pozostałe","88323","2","0","1"),
("88326","Rożki, beciki","88323","0","0","1"),
("88327","Szatki, świece, okapniki","88323","1","0","1"),
("88328","Pozostałe","88322","5","0","1"),
("88329","Chusteczki","88322","0","0","1"),
("88330","Torebki","88322","3","0","1"),
("88331","Wianki, stroiki","88322","4","0","1"),
("88332","Świece i okapniki","88322","2","0","1"),
("88333","Krawaty i muszniki","88322","1","0","1"),
("88334","Pozostałe","88324","5","0","1"),
("88335","Kapelusze","88324","0","0","1"),
("88336","Szable i miecze","88324","4","0","1"),
("88337","Maski","88324","1","0","1"),
("88338","Skrzydła","88324","3","0","1"),
("88339","Peruki","88324","2","0","1"),
("88340","Pozostałe","88294","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("88341","Chrzest","88294","0","0","1"),
("88342","Komunia","88294","1","0","1"),
("88343","Urodziny","88294","2","0","1"),
("88344","Pozostałe","88295","6","0","1"),
("88345","Świeczki","88295","5","0","1"),
("88346","Obrusy","88295","2","0","1"),
("88347","Serwetki","88295","4","0","1"),
("88348","Serpentyny, konfetti","88295","3","0","1"),
("88349","Girlandy","88295","1","0","1"),
("88350","Balony","88295","0","0","1"),
("88351","Pozostałe","88296","3","0","1"),
("88352","Słomki","88296","1","0","1"),
("88353","Talerzyki","88296","2","0","1"),
("88354","Kubeczki","88296","0","0","1"),
("88355","Pozostałe","88299","6","0","1"),
("88356","Figurki, statuetki","88299","1","0","1"),
("88357","Podziękowania","88299","5","0","1"),
("88358","Obrazki, ramki, odciski","88299","4","0","1"),
("88359","Albumy","88299","0","0","1"),
("88360","Łyżeczki, grzechotki","88299","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("88361","Księgi pamiątkowe","88299","2","0","1"),
("88854","A1","4031","3","0","1"),
("88999","Dla mężczyzn","1435","0","0","1"),
("89000","Serum","1435","8","0","1"),
("89001","Maski do włosów","1436","1","0","1"),
("89002","Pozostałe","9315","8","0","1"),
("89003","Lakiery","9315","0","0","1"),
("89004","Pianki","9315","1","0","1"),
("89005","Prostowanie","9315","4","0","1"),
("89006","Żele, gumy, woski","9315","2","0","1"),
("89007","Pozostałe","45712","3","0","1"),
("89008","Lusterka","45712","2","0","1"),
("89009","Pędzle do makijażu","45712","1","0","1"),
("89010","Bazy pod makijaż","45661","0","0","1"),
("89011","Korektory","45661","2","0","1"),
("89012","Bazy pod cienie","45660","0","0","1"),
("89013","Korektory pod oczy","45660","3","0","1"),
("89054","Płyty Blu-ray","20585","2","0","0"),
("89055","Pozostałe","89054","20","0","1"),
("89056","Dla dzieci","89054","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89057","Dokumentalne","89054","2","0","1"),
("89058","Dramaty","89054","3","0","1"),
("89059","Horrory","89054","5","0","1"),
("89060","Komedie","89054","7","0","1"),
("89061","Koncerty","89054","8","0","1"),
("89062","Kryminały","89054","9","0","1"),
("89063","Przygodowe","89054","12","0","1"),
("89064","Science Fiction","89054","13","0","1"),
("89065","Sensacyjne","89054","14","0","1"),
("89066","Thrillery","89054","16","0","1"),
("89067","Wojenne","89054","18","0","1"),
("89068","Zestawy","89054","19","0","1"),
("89070","Seriale","89054","15","0","1"),
("89072","Encyklopedie, słowniki, leksykony","79455","0","0","0"),
("89073","Architektura, budownictwo","79455","2","0","0"),
("89074","Architektura - pozostałe","89073","6","0","1"),
("89075","Opracowania ogólne","89073","0","0","1"),
("89076","Historia architektury","89073","1","0","1"),
("89077","Architektura budowli przemysłowych","89073","2","0","1"),
("89078","Architektura krajobrazu","89073","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89079","Architektura wnętrz","89073","4","0","1"),
("89080","Konstrukcje betonowe i żelbetowe","89073","7","0","1"),
("89081","Konstrukcje drewniane","89073","8","0","1"),
("89082","Konstrukcje metalowe i stalowe","89073","9","0","1"),
("89083","Konstrukcje murowane i kamienne","89073","10","0","1"),
("89084","Pozostałe","79459","8","0","1"),
("89085","Biologia ogólna","79459","0","0","1"),
("89086","Antropologia ogólna","79459","1","0","1"),
("89087","Biologia komórki","79459","2","0","1"),
("89088","Botanika","79459","3","0","1"),
("89089","Ekologia","79459","4","0","1"),
("89090","Genetyka","79459","5","0","1"),
("89091","Mikrobiologia","79459","6","0","1"),
("89092","Zoologia","79459","7","0","1"),
("89093","Pozostałe","79460","6","0","1"),
("89094","Biochemia","79460","0","0","1"),
("89095","Chemia ogólna","79460","1","0","1"),
("89096","Chemia analityczna","79460","2","0","1"),
("89097","Chemia fizyczna","79460","3","0","1"),
("89098","Chemia organiczna","79460","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89099","Chemia nieorganiczna","79460","5","0","1"),
("89100","Pozostałe","79463","8","0","1"),
("89101","Filozofia - opracowania ogólne","79463","0","0","1"),
("89102","Filozofia starożytna","79463","1","0","1"),
("89103","Filozofia średniowieczna","79463","2","0","1"),
("89104","Filozofia nowożytna, współczesna","79463","3","0","1"),
("89105","Antropologia filozoficzna","79463","4","0","1"),
("89106","Etyka, estetyka","79463","5","0","1"),
("89107","Logika","79463","6","0","1"),
("89108","Metafizyka","79463","7","0","1"),
("89109","Pozostałe","79465","7","0","1"),
("89110","Geografia ogólna","79465","0","0","1"),
("89111","Geografia fizyczna","79465","1","0","1"),
("89112","Geografia społeczno-ekonomiczna","79465","2","0","1"),
("89113","Geografia regionalna","79465","3","0","1"),
("89114","Geodezja, kartografia","79465","4","0","1"),
("89115","Geologia","79465","5","0","1"),
("89116","Turystyka, rekreacja","79465","6","0","1"),
("89117","Pozostałe","79475","11","0","1"),
("89118","Religie - opracowania ogólne","79475","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89119","Teologia","79475","1","0","1"),
("89120","Buddyzm","79475","2","0","1"),
("89121","Hinduizm","79475","3","0","1"),
("89122","Islam","79475","4","0","1"),
("89123","Judaizm","79475","5","0","1"),
("89124","Katolicyzm","79475","6","0","1"),
("89125","Prawosławie","79475","7","0","1"),
("89126","Protestantyzm","79475","8","0","1"),
("89127","Religie, wierzenia świata starożytnego","79475","9","0","1"),
("89128","Mitologie","79475","10","0","1"),
("89129","Pozostałe","79478","5","0","1"),
("89130","Uprawa roślin, sadownictwo","79478","1","0","1"),
("89131","Hodowla zwierząt, zootechnika","79478","0","0","1"),
("89132","Weterynaria","79478","2","0","1"),
("89133","Rybołówstwo","79478","4","0","1"),
("89134","Leśnictwo","79478","3","0","1"),
("89135","Sztuka - opracowania ogólne","79477","0","0","1"),
("89136","Antropologia kulturowa, etnologia","79477","2","0","1"),
("89137","Film, kino","79477","3","0","1"),
("89138","Historia sztuki","79477","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89139","Teatr, opera","79477","4","0","1"),
("89140","Fotografia","79477","5","0","1"),
("89141","Media, dziennikarstwo","79477","6","0","1"),
("89142","Muzyka","79477","7","0","1"),
("89143","Rzemiosło artystyczne, wzornictwo, design","79477","8","0","1"),
("89144","Rzeźba, malarstwo","79477","9","0","1"),
("89145","Sztuki plastyczne - pozostałe","79477","10","0","1"),
("89146","Pozostałe","79477","11","0","1"),
("89147","Pozostałe","79458","12","0","1"),
("89148","Automatyka, robotyka","79458","1","0","1"),
("89149","Biotechnologia, technologia żywności","79458","2","0","1"),
("89150","Elektronika","79458","3","0","1"),
("89151","Elektrotechnika, energetyka","79458","4","0","1"),
("89152","Inżynieria chemiczna","79458","5","0","1"),
("89153","Inżynieria materiałowa, materiałoznawstwo","79458","6","0","1"),
("89154","Inżynieria środowiska","79458","7","0","1"),
("89155","Mechanika, budowa maszyn","79458","8","0","1"),
("89156","Telekomunikacja, akustyka","79458","10","0","1"),
("89157","Transport, spedycja","79458","11","0","1"),
("89253","Tablety","2","15","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89266","LED","4317","2","0","1"),
("89274","Pozostałe","79466","4","0","1"),
("89275","Archeologia","79466","0","0","1"),
("89276","Historia Polski","79466","1","0","0"),
("89277","Historia powszechna","79466","2","0","0"),
("89278","Nauki pomocnicze","79466","3","0","1"),
("89279","Opracowania ogólne","89276","0","0","1"),
("89280","Polska Piastów (ok. 960-1370)","89276","1","0","1"),
("89281","Polska Jagiellonów (1386-1572)","89276","2","0","1"),
("89282","Rzeczpospolita Obojga Narodów (1569-1795)","89276","3","0","1"),
("89283","Polska pod zaborami (1795-1918)","89276","4","0","1"),
("89284","II Rzeczpospolita (1918-1939)","89276","5","0","1"),
("89285","II wojna światowa (1939-1945)","89276","6","0","1"),
("89286","PRL (1945-1989)","89276","7","0","1"),
("89287","III Rzeczpospolita (od 1989)","89276","8","0","1"),
("89288","Opracowania ogólne","89277","0","0","1"),
("89289","Starożytność (do 476)","89277","1","0","1"),
("89290","Średniowiecze (476-1492)","89277","2","0","1"),
("89291","Czasy nowożytne (1492-1815)","89277","3","0","1"),
("89292","Historia XIX w. do 1914","89277","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89293","I wojna światowa (1914-1918)","89277","5","0","1"),
("89294","Okres międzywojenny (1918-1939)","89277","6","0","1"),
("89295","II wojna światowa (1939-1945)","89277","7","0","1"),
("89296","Dzieje najnowsze (od 1945)","89277","8","0","1"),
("89313","Bielizna","11764","0","0","0"),
("89314","Komplety bielizny","89313","15","0","1"),
("89315","Koszulki, kaftaniki","89313","4","0","1"),
("89316","Pajacyki","89313","6","0","1"),
("89317","Body","89313","1","0","1"),
("89318","Majteczki","89313","5","0","1"),
("89319","Getry","89313","2","0","1"),
("89320","Rampersy","89313","10","0","1"),
("89321","Półśpiochy","89313","8","0","1"),
("89322","Śpiworki do spania","89313","14","0","1"),
("89323","Rajstopy","89313","9","0","1"),
("89324","Śpiochy","89313","13","0","1"),
("89452","Skarpetki, podkolanówki","89313","11","0","1"),
("89482","Piżamy","89313","7","0","1"),
("89483","Szlafroki","89313","12","0","1"),
("89508","Bluzki","11764","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89509","Bolerka","11764","3","0","1"),
("89510","Bluzy","11764","2","0","1"),
("89511","Dresy kompletne","11764","4","0","1"),
("89512","Kamizelki, bezrękawniki","11764","7","0","1"),
("89513","Koszule","11764","10","0","1"),
("89514","Krótkie spodenki","11764","11","0","1"),
("89515","Kurtki, płaszcze","11764","12","0","1"),
("89516","Kombinezony, śpiworki","11764","9","0","1"),
("89517","Nakrycia głowy","11764","15","0","1"),
("89518","Marynarki","11764","14","0","1"),
("89519","Garnitury","11764","5","0","1"),
("89520","Golfy","11764","6","0","1"),
("89521","Sukienki","11764","20","0","1"),
("89522","Spódniczki","11764","18","0","1"),
("89523","Stroje kąpielowe","11764","19","0","1"),
("89524","Kąpielówki","11764","8","0","1"),
("89525","Sweterki","11764","21","0","1"),
("89526","Rękawiczki","11764","16","0","1"),
("89527","Tuniki","11764","25","0","1"),
("89528","T-shirty","11764","24","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89529","Topy, koszulki","11764","23","0","1"),
("89530","Komplety","11764","26","0","1"),
("89531","Zestawy ubrań","11764","27","0","1"),
("89532","Pozostała odzież","11764","28","0","1"),
("89681","Spodnie","11764","17","0","1"),
("89743","Polska","189","0","0","1"),
("89744","Zagraniczna","189","1","0","1"),
("89745","Afryka","52748","0","0","1"),
("89746","Azja","52748","4","0","1"),
("89747","Ameryka Północna","52748","2","0","1"),
("89748","Ameryka Południowa","52748","1","0","1"),
("89749","Australia i Oceania","52748","3","0","1"),
("89750","Europa","52748","5","0","1"),
("89751","Muzyka religijna, oazowa","175","16","0","1"),
("89752","Bajki","5608","0","0","1"),
("89753","Edukacyjne, lektury","5608","3","0","1"),
("89754","Dla niemowląt","5608","2","0","1"),
("89755","Dla dzieci i młodzieży","5608","1","0","1"),
("89756","Pozostałe","5608","4","0","1"),
("89757","Disco polo, biesiadna, karaoke","175","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("89770","Regały, półki, stojaki","12825","1","0","1"),
("89867","Pozostałe","89313","16","0","1"),
("89875","Portugalia","59281","12","0","1"),
("89876","Portugalia","59283","18","0","1"),
("89881","Portugalia","59282","13","0","1"),
("89919","LX","12406","6","0","1"),
("89957","System Micro 4/3","50590","9","0","1"),
("89958","Sony E","50590","6","0","1"),
("89959","Samsung NX","50590","5","0","1"),
("90013","Dla gołębi","1528","3","0","0"),
("90014","Dla psów","1528","6","0","0"),
("90015","Dla kotów","1528","5","0","0"),
("90016","Dla ptaków egzotycznych","1528","7","0","0"),
("90017","Dla gryzoni i królików","1528","4","0","0"),
("90018","Dla fretek","1528","2","0","0"),
("90019","Gadżety zoologiczne","1528","9","0","1"),
("90020","Literatura i filmy","1528","11","0","0"),
("90021","Pozostałe","90018","3","0","1"),
("90022","Klatki","90018","1","0","1"),
("90023","Karmy","90018","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90024","Legowiska i zabawki","90018","2","0","1"),
("90025","Pozostałe","90017","7","0","1"),
("90026","Domki i legowiska","90017","0","0","1"),
("90027","Karmy i smakołyki","90017","1","0","1"),
("90028","Klatki i akwaria","90017","2","0","1"),
("90029","Miski i poidła","90017","3","0","1"),
("90030","Podłoża, ściółka","90017","4","0","1"),
("90031","Transportery","90017","5","0","1"),
("90032","Zabawki","90017","6","0","1"),
("90033","Pozostałe","90013","3","0","1"),
("90034","Gołębniki i wyposażenie","90013","0","0","1"),
("90035","Karmy i preparaty","90013","1","0","1"),
("90036","Obrączki","90013","2","0","1"),
("90037","Pozostałe","90015","14","0","1"),
("90038","Drapaki","90015","0","0","1"),
("90039","Karmy","90015","1","0","0"),
("90040","Sucha karma","90039","1","0","1"),
("90041","Puszki i saszetki","90039","0","0","1"),
("90042","Smakołyki","90015","2","0","1"),
("90043","Zabawki","90015","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90044","Torby i transportery","90015","6","0","1"),
("90045","Legowiska i budki","90015","7","0","1"),
("90046","Miski","90015","4","0","1"),
("90047","Grzebienie i szczotki","90015","9","0","1"),
("90048","Szampony i odżywki","90015","10","0","1"),
("90049","Preparaty","90015","11","0","1"),
("90050","Szelki, smycze i obroże","90015","8","0","1"),
("90051","Żwirki","90015","13","0","1"),
("90052","Kuwety","90015","12","0","1"),
("90053","Pozostałe","90014","23","0","1"),
("90054","Ubranka","90014","22","0","1"),
("90055","Spinki i kokardy","90014","21","0","1"),
("90056","Akcesoria szkoleniowe","90014","0","0","1"),
("90057","Identyfikatory i adresówki","90014","11","0","1"),
("90058","Budy","90014","6","0","1"),
("90059","Kagańce","90014","12","0","1"),
("90060","Karmy","90014","1","0","0"),
("90061","Sucha karma","90060","1","0","1"),
("90062","Puszki i saszetki","90060","0","0","1"),
("90063","Smakołyki","90014","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90064","Legowiska ","90014","8","0","1"),
("90065","Miski","90014","4","0","1"),
("90066","Torby","90014","9","0","1"),
("90067","Transportery","90014","10","0","1"),
("90068","Klatki i kojce","90014","7","0","1"),
("90069","Zabawki","90014","5","0","1"),
("90070","Obroże","90014","13","0","1"),
("90071","Smycze","90014","14","0","0"),
("90072","Automatyczne","90071","0","0","1"),
("90073","Tradycyjne","90071","1","0","1"),
("90074","Szelki","90014","15","0","1"),
("90075","Szampony i odżywki","90014","18","0","1"),
("90076","Maszynki i trymery","90014","17","0","1"),
("90077","Grzebienie i szczotki","90014","16","0","1"),
("90078","Preparaty","90014","19","0","1"),
("90079","Środki na pasożyty","90014","20","0","1"),
("90080","Pozostałe","90016","7","0","1"),
("90081","Budki lęgowe","90016","0","0","1"),
("90082","Obrączki","90016","4","0","1"),
("90083","Klatki i woliery","90016","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90084","Podłoża","90016","5","0","1"),
("90085","Miski i poidła","90016","3","0","1"),
("90086","Karmy i smakołyki","90016","1","0","1"),
("90087","Zabawki i baseny","90016","6","0","1"),
("90088","Pozostałe","90020","7","0","1"),
("90089","Akwarystyka","90020","0","0","1"),
("90090","Terrarystyka","90020","1","0","1"),
("90091","Pies","90020","2","0","1"),
("90092","Kot","90020","3","0","1"),
("90093","Gryzonie i króliki","90020","4","0","1"),
("90094","Gołębie","90020","5","0","1"),
("90095","Ptaki egzotyczne","90020","6","0","1"),
("90096","Maty i podstawki","5338","1","0","1"),
("90097","Oświetlenie i pokrywy","1118","8","0","1"),
("90098","Filtry","1118","3","0","0"),
("90099","Wewnętrzne","90098","0","0","1"),
("90100","Zewnętrzne","90098","1","0","1"),
("90101","Części i wkłady","90098","2","0","1"),
("90102","Napowietrzanie","1118","5","0","1"),
("90103","Odmulacze i czyściki","1118","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90104","Ogrzewanie i temperatura","1118","7","0","1"),
("90105","Tła","1118","14","0","1"),
("90106","Korzenie i ozdoby","1118","4","0","1"),
("90107","Podłoża","1118","9","0","1"),
("90108","Technika CO2","1118","13","0","1"),
("90173","Akcesoria do akwarium morskiego","1118","0","0","1"),
("90174","Krewetki i raki","5336","0","0","1"),
("90175","Ryby","5336","1","0","1"),
("90176","Ślimaki","5336","2","0","1"),
("90177","Inne zwierzęta","5336","3","0","1"),
("90193","Witaminy","90014","3","0","1"),
("90194","Witaminy","90015","3","0","1"),
("90214","Obudowy","28155","0","0","1"),
("90215","Pozostałe","17686","7","0","1"),
("90216","Klapki","17686","0","0","1"),
("90217","Matówki","17686","1","0","1"),
("90218","Matryce","17686","2","0","1"),
("90219","Obiektywy","17686","3","0","1"),
("90220","Obudowy","17686","4","0","1"),
("90221","Płyty główne","17686","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90222","Wyświetlacze LCD","17686","6","0","1"),
("90223","Podczerwone","8853","2","0","1"),
("90224","Połówkowe","8853","4","0","1"),
("90225","HDMI","8855","1","0","1"),
("90226","AV","8855","0","0","1"),
("90227","Pozostałe","16278","4","0","1"),
("90228","Szerokokątne","16278","2","0","1"),
("90229","Telekonwertery","16278","3","0","1"),
("90230","Makro","16278","1","0","1"),
("90231","Fisheye","16278","0","0","1"),
("90232","Tripody","11715","0","0","1"),
("90233","Monopody","11715","1","0","1"),
("90234","Do 1GB","8904","0","0","1"),
("90235","8GB","8904","3","0","1"),
("90236","16GB","8904","4","0","1"),
("90237","32GB","8904","5","0","1"),
("90238","Do 1GB","8905","0","0","1"),
("90239","4GB","8905","2","0","1"),
("90240","8GB","8905","3","0","1"),
("90241","16GB i większe","8905","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90242","Do 1GB","27898","0","0","1"),
("90243","4GB","27898","2","0","1"),
("90244","8GB","27898","3","0","1"),
("90245","16GB i większe","27898","4","0","1"),
("90246","Do 1GB","16242","0","0","1"),
("90247","8GB","16242","3","0","1"),
("90248","12GB","16242","4","0","1"),
("90249","16GB","16242","5","0","1"),
("90250","32GB","16242","6","0","1"),
("90251","Do 1GB","16251","0","0","1"),
("90252","4GB","16251","2","0","1"),
("90253","8GB","16251","3","0","1"),
("90254","16GB","16251","4","0","1"),
("90274","Medycyna ogólna","79469","0","0","1"),
("90275","Medycyna naturalna i niekonwencjonalna","79469","1","0","1"),
("90276","Medycyna sportowa","79469","2","0","1"),
("90277","Analityka, diagnostyka laboratoryjna","79469","4","0","1"),
("90278","Anatomia, fizjologia","79469","5","0","1"),
("90279","Anestezjologia i intensywna terapia","79469","6","0","1"),
("90280","Alergologia","79469","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90281","Chirurgia, ortopedia","79469","7","0","1"),
("90282","Dermatologia, kosmetologia","79469","8","0","1"),
("90283","Dietetyka","79469","9","0","1"),
("90284","Farmacja, farmakologia","79469","10","0","1"),
("90285","Fizjoterapia, rehabilitacja","79469","11","0","1"),
("90286","Ginekologia, położnictwo","79469","12","0","1"),
("90287","Interna, choroby wewnętrzne","79469","13","0","1"),
("90288","Kardiologia","79469","14","0","1"),
("90289","Okulistyka","79469","15","0","1"),
("90290","Onkologia","79469","16","0","1"),
("90291","Pediatria","79469","17","0","1"),
("90292","Pielęgniarstwo","79469","18","0","1"),
("90293","Psychiatria, neurologia","79469","19","0","1"),
("90294","Ratownictwo","79469","20","0","1"),
("90295","Seksuologia","79469","21","0","1"),
("90296","Stomatologia, dentystyka","79469","22","0","1"),
("90297","Pozostałe","79469","23","0","1"),
("90298","Psychologia - pozostałe","79473","13","0","1"),
("90299","Psychologia ogólna","79473","0","0","1"),
("90300","Historia psychologii","79473","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90301","Psychoanaliza","79473","2","0","1"),
("90302","Psychoterapia","79473","3","0","1"),
("90303","Psychologia ewolucyjna","79473","4","0","1"),
("90304","Psychologia kliniczna","79473","6","0","1"),
("90305","Psychologia języka i komunikacji","79473","5","0","1"),
("90306","Psychologia osobowości","79473","7","0","1"),
("90307","Psychologia poznawcza","79473","8","0","1"),
("90308","Psychologia pracy i organizacji","79473","9","0","1"),
("90309","Psychologia rozwojowa","79473","10","0","1"),
("90310","Psychologia społeczna","79473","11","0","1"),
("90311","Psychologia wychowania i rodziny","79473","12","0","1"),
("90312","Socjologia ogólna","79473","14","0","1"),
("90313","Antropologia społeczna","79473","15","0","1"),
("90314","Socjologia miasta","79473","16","0","1"),
("90315","Socjologia pracy","79473","17","0","1"),
("90316","Socjologia prawa","79473","18","0","1"),
("90317","Socjologia religii","79473","19","0","1"),
("90318","Socjologia - pozostałe","79473","20","0","1"),
("90319","Matematyka, statystyka","79455","13","0","0"),
("90320","Pozostałe","79468","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90321","Aplikacje biurowe","79468","0","0","1"),
("90322","Bazy danych","79468","1","0","1"),
("90323","Bezpieczeństwo","79468","2","0","1"),
("90324","CAD/CAM","79468","3","0","1"),
("90325","E-biznes","79468","4","0","1"),
("90326","Grafika komputerowa","79468","5","0","1"),
("90327","Hardware","79468","6","0","1"),
("90328","Programowanie","79468","7","0","1"),
("90329","Sieci komputerowe","79468","8","0","1"),
("90330","Systemy operacyjne","79468","9","0","1"),
("90331","Webmastering","79468","10","0","1"),
("90332","Biznes, nauki ekonomiczne","79455","4","0","0"),
("90333","Matematyka ogólna","90319","0","0","1"),
("90334","Algebra","90319","1","0","1"),
("90335","Analiza matematyczna","90319","2","0","1"),
("90336","Geometria","90319","3","0","1"),
("90337","Logika","90319","4","0","1"),
("90338","Statystyka, rachunek prawdopodobieństwa","90319","5","0","1"),
("90339","Pozostałe","90319","6","0","1"),
("90340","Biznes - opracowania ogólne","90332","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90341","Ekonomia","90332","1","0","1"),
("90342","Finanse, rachunkowość","90332","2","0","1"),
("90343","Marketing","90332","3","0","1"),
("90344","Zarządzanie","90332","4","0","1"),
("90345","Pozostałe","90332","5","0","1"),
("90346","Militaria, broń, wojskowość","79455","1","0","0"),
("90353","Pozostałe","79467","4","0","1"),
("90354","Literatura - opracowania ogólne","79467","0","0","1"),
("90355","Historia literatury","79467","1","0","1"),
("90356","Krytyka literacka","79467","2","0","1"),
("90357","Teoria literatury","79467","3","0","1"),
("90358","Pozostałe","79470","9","0","1"),
("90359","Logopedia","79470","0","0","1"),
("90360","Pedagogika ogólna","79470","1","0","1"),
("90361","Pedagogika przedszkolna","79470","2","0","1"),
("90362","Pedagogika wczesnoszkolna","79470","3","0","1"),
("90363","Pedagogika szkół podstawowych","79470","4","0","1"),
("90364","Pedagogika gimnazjum","79470","5","0","1"),
("90365","Pedagogika szkół średnich","79470","6","0","1"),
("90366","Pedagogika specjalna","79470","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90367","Resocjalizacja","79470","8","0","1"),
("90368","Pozostałe","79462","5","0","1"),
("90369","Polonistyka","79462","0","0","1"),
("90370","Anglistyka","79462","1","0","1"),
("90371","Germanistyka","79462","2","0","1"),
("90372","Iberystyka","79462","3","0","1"),
("90373","Romanistyka","79462","4","0","1"),
("90374","Pozostałe","79464","6","0","1"),
("90375","Fizyka ogólna","79464","0","0","1"),
("90376","Astronomia","79464","1","0","1"),
("90377","Elektrodynamika klasyczna","79464","2","0","1"),
("90378","Mechanika klasyczna","79464","3","0","1"),
("90379","Mechanika kwantowa","79464","4","0","1"),
("90380","Termodynamika i mechanika statystyczna","79464","5","0","1"),
("90381","Pozostałe","79472","11","0","1"),
("90382","Historia prawa","79472","0","0","1"),
("90383","Teoria prawa","79472","1","0","1"),
("90384","Prawo administracyjne, samorząd terytorialny","79472","2","0","1"),
("90385","Prawo cywilne","79472","3","0","1"),
("90386","Prawo finansowe","79472","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90387","Prawo gospodarcze, handlowe","79472","5","0","1"),
("90388","Prawo karne","79472","6","0","1"),
("90389","Prawo konstytucyjne","79472","7","0","1"),
("90390","Prawo międzynarodowe, prawo UE","79472","8","0","1"),
("90391","Prawo pracy","79472","9","0","1"),
("90392","Prawo rodzinne i opiekuńcze","79472","10","0","1"),
("90393","Pozostałe","79471","7","0","1"),
("90394","Instytucje i systemy polityczne","79471","0","0","1"),
("90395","Myśl polityczna, teoria polityki","79471","1","0","1"),
("90396","Polityka ekologiczna","79471","2","0","1"),
("90397","Polityka gospodarcza","79471","3","0","1"),
("90398","Polityka społeczna","79471","4","0","1"),
("90399","Ruchy i doktryny polityczne","79471","5","0","1"),
("90400","Stosunki międzynarodowe","79471","6","0","1"),
("90401","Encyklopedie powszechne, leksykony","89072","0","0","1"),
("90402","Słowniki języka polskiego","89072","1","0","1"),
("90403","Pozostałe","89072","2","0","1"),
("90404","Na rozstępy","1433","5","0","1"),
("90405","Peelingi","1433","7","0","1"),
("90412","Pozostałe","45694","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90413","Jednofazowe","45694","0","0","1"),
("90414","Podkładowe, budujące","45694","3","0","1"),
("90415","Nabłyszczające","45694","2","0","1"),
("90416","Kamuflujące","45694","1","0","1"),
("90424","Do paznokci","45681","0","0","1"),
("90425","Do skórek","45681","1","0","1"),
("90426","Nabłyszczacze, utrwalacze","45658","5","0","1"),
("90427","Kleje","45686","0","0","1"),
("90428","Odtłuszczacze, primery","45686","1","0","1"),
("90429","Zmywacze","45686","3","0","0"),
("90430","Acetonowe","90429","0","0","1"),
("90431","Bezacetonowe","90429","1","0","1"),
("90432","Sterylizatory","45685","4","0","1"),
("90536","Technika, przemysł - opracowania ogólne","79458","0","0","1"),
("90537","Metalurgia, hutnictwo, górnictwo","79458","9","0","1"),
("90539","Architektura zabytkowa","89073","5","0","1"),
("90540","Budownictwo - pozostałe","89073","11","0","1"),
("90833","Pozostałe","79195","7","0","1"),
("90834","Własna działalność","79195","6","0","1"),
("90835","Poradniki branżowe i zawodowe","79195","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90836","Podatki, prawo pracy","79195","4","0","1"),
("90837","Kredyty, oszczędzanie","79195","3","0","1"),
("90838","Kariera zawodowa","79195","2","0","1"),
("90839","Inwestowanie","79195","1","0","1"),
("90840","Fundusze unijne","79195","0","0","1"),
("90841","Pozostałe","79197","7","0","1"),
("90842","Dom - opracowania ogólne","79197","0","0","1"),
("90843","Ogród - opracowania ogólne","79197","1","0","1"),
("90844","Naprawy, remonty, majsterkowanie","79197","2","0","1"),
("90845","Prace domowe, prowadzenie domu","79197","3","0","1"),
("90846","Projektowanie i planowanie ogrodu","79197","4","0","1"),
("90847","Rośliny domowe i ogrodowe","79197","5","0","1"),
("90848","Urządzanie i dekorowanie","79197","6","0","1"),
("90849","Pozostałe","79206","15","0","1"),
("90850","Życie po śmierci","79206","14","0","1"),
("90851","Uzdrawianie","79206","12","0","1"),
("90852","Wyrocznie, przepowiednie","79206","13","0","1"),
("90853","UFO","79206","11","0","1"),
("90854","Runy","79206","7","0","1"),
("90855","Tarot","79206","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90856","Szamanizm","79206","9","0","1"),
("90857","Sny, senniki","79206","8","0","1"),
("90858","Radiestezja, różdżkarstwo","79206","6","0","1"),
("90859","Okultyzm, zjawiska paranormalne","79206","5","0","1"),
("90860","Numerologia, symbolika","79206","4","0","1"),
("90861","Medytacja, joga","79206","3","0","1"),
("90862","Magia","79206","2","0","1"),
("90863","Feng shui","79206","1","0","1"),
("90864","Astrologia, horoskopy","79206","0","0","1"),
("90865","Pozostałe","79199","5","0","1"),
("90866","Fotografowanie krajobrazów, przyrody","79199","3","0","1"),
("90867","Fotografowanie ludzi, akt i portrety","79199","4","0","1"),
("90868","Edycja zdjęć","79199","2","0","1"),
("90869","Aparaty i akcesoria","79199","1","0","1"),
("90870","Poradniki ogólne","79199","0","0","1"),
("90871","Pozostałe","79202","7","0","1"),
("90872","Systemy operacyjne","79202","5","0","1"),
("90873","Marketing internetowy","79202","2","0","1"),
("90874","Tworzenie stron internetowych","79202","6","0","1"),
("90875","Korzystanie z internetu","79202","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90876","Podstawy obsługi komputera","79202","4","0","1"),
("90877","Bezpieczeństwo","79202","0","0","1"),
("90878","Oprogramowanie biurowe","79202","3","0","1"),
("90879","Pozostałe","79205","7","0","1"),
("90880","Kuchnie świata i regionalne","79205","6","0","1"),
("90881","Kuchnia wegetariańska","79205","5","0","1"),
("90882","Potrawy dietetyczne","79205","4","0","1"),
("90883","Przekąski, sałatki i surówki","79205","3","0","1"),
("90884","Napoje, drinki","79205","2","0","1"),
("90885","Dania główne","79205","1","0","1"),
("90886","Ciasta, desery","79205","0","0","1"),
("90887","Pozostałe","79208","3","0","1"),
("90888","Moda i uroda - poradniki","79208","2","0","1"),
("90889","Kosmetyka, pielęgnacja ciała","79208","1","0","1"),
("90890","Albumy o modzie","79208","0","0","1"),
("90891","Pozostałe","79209","6","0","1"),
("90892","Samoloty","79209","5","0","1"),
("90893","Samochody","79209","4","0","1"),
("90894","Motocykle","79209","3","0","1"),
("90895","Łodzie, statki","79209","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90896","Kolej, pojazdy szynowe","79209","1","0","1"),
("90897","Opracowania ogólne","79209","0","0","1"),
("90898","Pozostałe","79210","5","0","1"),
("90899","Zarządzanie czasem","79210","4","0","1"),
("90900","Trening umysłu, efektywna nauka","79210","3","0","1"),
("90901","Motywacja","79210","2","0","1"),
("90902","Kondycja psychofizyczna, relaks","79210","1","0","1"),
("90903","Komunikacja, kontakty międzyludzkie","79210","0","0","1"),
("90904","Pozostałe","79211","4","0","1"),
("90905","Nauka gry na instrumentach","79211","1","0","1"),
("90906","Śpiew i taniec","79211","3","0","1"),
("90907","Nuty","79211","2","0","1"),
("90908","Muzyka, muzycy - albumy","79211","0","0","1"),
("90909","Przyroda, krajobrazy","79193","13","0","0"),
("90910","Wszechświat, kosmos","90909","2","0","1"),
("90911","Świat roślin i zwierząt","90909","1","0","1"),
("90912","Krajobrazy","90909","0","0","1"),
("90913","Pozostałe","90909","3","0","1"),
("90914","Rękodzieło, biżuteria, szycie","79193","14","0","0"),
("90915","Pozostałe","90914","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("90916","Szydełkowanie i robótki na drutach","90914","3","0","1"),
("90917","Szycie, krawiectwo","90914","2","0","1"),
("90918","Decoupage","90914","1","0","1"),
("90919","Biżuteria","90914","0","0","1"),
("90920","Pozostałe","79212","6","0","1"),
("90921","Nastolatki","79212","4","0","1"),
("90922","Starsze dzieci","79212","3","0","1"),
("90923","Przedszkolaki","79212","2","0","1"),
("90924","Niemowlęta, małe dzieci","79212","1","0","1"),
("90925","Ciąża i poród","79212","0","0","1"),
("90926","Pozostałe","79220","7","0","1"),
("90927","Zwierzęta egzotyczne","79220","6","0","1"),
("90928","Ptaki","79220","4","0","1"),
("90929","Konie","79220","3","0","1"),
("90930","Ryby","79220","5","0","1"),
("90931","Gryzonie","79220","2","0","1"),
("90932","Koty","79220","1","0","1"),
("90933","Psy","79220","0","0","1"),
("91053","Pozostałe","79848","2","0","1"),
("91054","Tradycje i obrzędy świąteczne","79848","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91055","Savoir-vivre, etykieta","79848","0","0","1"),
("91056","Pozostałe","79219","8","0","1"),
("91057","Zioła, rośliny lecznicze","79219","6","0","1"),
("91058","Zdrowie psychiczne","79219","5","0","1"),
("91059","Zdrowie dzieci","79219","4","0","1"),
("91060","Pierwsza pomoc","79219","3","0","1"),
("91061","Medycyna naturalna","79219","7","0","1"),
("91062","Diety, zdrowy styl życia","79219","2","0","1"),
("91063","Choroby, dolegliwości","79219","1","0","1"),
("91064","Zdrowie - opracowania ogólne","79219","0","0","1"),
("91065","Pozostałe","79218","4","0","1"),
("91066","Chrześcijaństwo - poradniki","79218","1","0","1"),
("91067","Święci","79218","3","0","1"),
("91068","Modlitwy","79218","2","0","1"),
("91069","Albumy religijne","79218","0","0","1"),
("91079","Pozostałe","79216","16","0","1"),
("91080","Sporty zimowe - pozostałe","79216","15","0","1"),
("91081","Sporty wodne - pozostałe","79216","14","0","1"),
("91082","Sporty powietrzne - pozostałe","79216","13","0","1"),
("91083","Sporty zespołowe - pozostałe","79216","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91084","Sporty indywidualne - pozostałe","79216","11","0","1"),
("91085","Wspinaczka, alpinizm","79216","10","0","1"),
("91086","Sztuki walki","79216","9","0","1"),
("91087","Rower, kolarstwo","79216","8","0","1"),
("91088","Piłka nożna","79216","7","0","1"),
("91089","Nurkowanie i pływanie","79216","6","0","1"),
("91090","Narciarstwo, snowboard","79216","5","0","1"),
("91091","Kulturystyka, siłownia","79216","4","0","1"),
("91092","Gry planszowe i karciane","79216","3","0","1"),
("91093","Fitness, gimnastyka","79216","2","0","1"),
("91094","Bieganie, marsz","79216","1","0","1"),
("91095","Opracowania ogólne","79216","0","0","1"),
("91096","Pozostałe","79201","8","0","1"),
("91097","Wędkarstwo, łowiectwo","79201","7","0","1"),
("91098","Numizmatyka","79201","6","0","1"),
("91099","Modelarstwo","79201","5","0","1"),
("91100","Filatelistyka","79201","4","0","1"),
("91101","Malowanie, rysowanie","79201","3","0","1"),
("91102","Szachy i inne gry planszowe","79201","2","0","1"),
("91103","Krzyżówki, gry i zabawy logiczne","79201","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91104","Gry karciane i hazardowe","79201","0","0","1"),
("91105","Sztuka, malarstwo i rzeźba","79207","0","0","1"),
("91106","Kościoły i inne budowle sakralne","79207","1","0","1"),
("91107","Zabytki, zamki i pałace","79207","2","0","1"),
("91108","Pozostałe albumy i poradniki","79207","3","0","1"),
("91109","Reportaż, literatura faktu","79153","13","0","0"),
("91110","Pozostałe","91109","6","0","1"),
("91111","Polityczny","91109","1","0","1"),
("91112","Sądowy, śledczy, kryminalny","91109","2","0","1"),
("91113","Sportowy","91109","4","0","1"),
("91114","Podróżniczy","91109","0","0","1"),
("91115","Społeczno-obyczajowy","91109","3","0","1"),
("91116","Wojenny","91109","5","0","1"),
("91134","Poradniki dla całej rodziny","79212","5","0","1"),
("91177","Hazel","5044","31","0","1"),
("91178","Spiro","5044","34","0","1"),
("91179","Zylo","5044","38","0","1"),
("91181","C6","4978","83","0","1"),
("91182","E5","4978","85","0","1"),
("91183","X2","4978","104","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91193","Legginsy","76033","12","0","1"),
("91228","Pozostałe","66803","8","0","1"),
("91229","Słowniki","66803","7","0","1"),
("91230","Rozmówki","66803","6","0","1"),
("91231","Repetytoria","66803","5","0","1"),
("91232","Podręczniki i ćwiczenia","66803","4","0","1"),
("91233","Kursy","66803","3","0","1"),
("91234","Gramatyka","66803","2","0","1"),
("91235","Fiszki","66803","1","0","1"),
("91236","Egzaminy, certyfikaty","66803","0","0","1"),
("91237","Pozostałe","66801","8","0","1"),
("91238","Słowniki","66801","7","0","1"),
("91239","Rozmówki","66801","6","0","1"),
("91240","Repetytoria","66801","5","0","1"),
("91241","Podręczniki i ćwiczenia","66801","4","0","1"),
("91242","Kursy","66801","3","0","1"),
("91243","Gramatyka","66801","2","0","1"),
("91244","Fiszki","66801","1","0","1"),
("91245","Egzaminy, certyfikaty","66801","0","0","1"),
("91246","Pozostałe","66802","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91247","Słowniki","66802","7","0","1"),
("91248","Rozmówki","66802","6","0","1"),
("91249","Repetytoria","66802","5","0","1"),
("91250","Podręczniki i ćwiczenia","66802","4","0","1"),
("91251","Kursy","66802","3","0","1"),
("91252","Gramatyka","66802","2","0","1"),
("91253","Fiszki","66802","1","0","1"),
("91254","Egzaminy, certyfikaty","66802","0","0","1"),
("91255","Pozostałe","66805","3","0","1"),
("91256","Japoński","66805","2","0","1"),
("91257","Chiński","66805","1","0","1"),
("91258","Arabski","66805","0","0","1"),
("91259","Pozostałe","66795","3","0","1"),
("91260","Szwedzki","66795","2","0","1"),
("91261","Norweski","66795","1","0","1"),
("91262","Duński","66795","0","0","1"),
("91263","Pozostałe","66804","8","0","1"),
("91264","Słowniki","66804","7","0","1"),
("91265","Rozmówki","66804","6","0","1"),
("91266","Repetytoria","66804","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91267","Podręczniki i ćwiczenia","66804","4","0","1"),
("91268","Kursy","66804","3","0","1"),
("91269","Gramatyka","66804","2","0","1"),
("91270","Fiszki","66804","1","0","1"),
("91271","Egzaminy, certyfikaty","66804","0","0","1"),
("91272","Pozostałe","66799","7","0","1"),
("91273","Słowniki","66799","6","0","1"),
("91274","Rozmówki","66799","5","0","1"),
("91275","Repetytoria","66799","4","0","1"),
("91276","Podręczniki i ćwiczenia","66799","3","0","1"),
("91277","Kursy","66799","2","0","1"),
("91278","Gramatyka","66799","1","0","1"),
("91279","Egzaminy, certyfikaty","66799","0","0","1"),
("91280","Pozostałe","66800","7","0","1"),
("91281","Słowniki","66800","6","0","1"),
("91282","Rozmówki","66800","5","0","1"),
("91283","Repetytoria","66800","4","0","1"),
("91284","Podręczniki i ćwiczenia","66800","3","0","1"),
("91285","Kursy","66800","2","0","1"),
("91286","Gramatyka","66800","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91287","Egzaminy, certyfikaty","66800","0","0","1"),
("91433","Pozostałe","66784","3","0","1"),
("91434","Klasyka bajek i wierszy","66784","0","0","1"),
("91435","Bajki i wiersze polskich autorów","66784","1","0","1"),
("91436","Bajki i wiersze zagranicznych autorów","66784","2","0","1"),
("91437","Baśnie, podania i legendy","66781","1","0","0"),
("91438","Klasyka baśni","91437","0","0","1"),
("91439","Baśnie współczesnych autorów","91437","1","0","1"),
("91440","Legendy, podania, mity","91437","2","0","1"),
("91441","Pozostałe","91437","3","0","1"),
("91442","Pozostałe","66791","5","0","1"),
("91443","Literatura dla nastolatek","66791","4","0","1"),
("91444","Powieści, opowiadania historyczne","66791","1","0","1"),
("91445","Powieści, opowiadania obyczajowe","66791","2","0","1"),
("91446","Powieści, opowiadania przygodowe i podróżnicze","66791","3","0","1"),
("91447","Fantasy i horrory","66791","0","0","1"),
("91448","Poezja i dramat","66781","3","0","1"),
("91449","Pozostałe","66782","2","0","1"),
("91450","Polskie filmy i dobranocki","66782","1","0","1"),
("91451","Disney","66782","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91452","Łamigłówki, zagadki i gry","66781","9","0","1"),
("91453","Pozostałe","66783","4","0","1"),
("91454","Z puzzlami","66783","2","0","1"),
("91455","Z zabawkami","66783","3","0","1"),
("91456","Z naklejkami","66783","1","0","1"),
("91457","Z magnesami","66783","0","0","1"),
("91458","Poradniki","66781","13","0","1"),
("91459","Książki obcojęzyczne","7","5","0","0"),
("91460","Po angielsku","91459","0","0","0"),
("91461","Po niemiecku","91459","1","0","0"),
("91462","Po francusku","91459","2","0","1"),
("91463","Po hiszpańsku","91459","3","0","1"),
("91464","Po włosku","91459","6","0","1"),
("91465","Po rosyjsku","91459","4","0","1"),
("91466","Klasyka literatury, literatura piękna","91460","0","0","1"),
("91467","Biografie, wspomnienia","91460","1","0","1"),
("91468","Dramat, utwory sceniczne","91460","2","0","1"),
("91469","Fantasy","91460","3","0","1"),
("91470","Historyczne","91460","4","0","1"),
("91471","Horrory","91460","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91472","Humor, parodia, satyra","91460","6","0","1"),
("91473","Kryminały","91460","7","0","1"),
("91474","Poezja","91460","8","0","1"),
("91475","Przygodowe i podróżnicze","91460","9","0","1"),
("91476","Reportaż, literatura faktu","91460","10","0","1"),
("91477","Romanse","91460","11","0","1"),
("91478","Science fiction","91460","12","0","1"),
("91479","Społeczno-obyczajowe","91460","13","0","1"),
("91480","Thrillery, sensacyjne","91460","14","0","1"),
("91481","Książki dla dzieci i młodzieży","91460","15","0","1"),
("91482","Poradniki","91460","17","0","1"),
("91483","Naukowe i popularnonaukowe","91460","16","0","1"),
("91484","Zestawy mieszane, kolekcje","91460","18","0","1"),
("91485","Pozostałe","91460","19","0","1"),
("91486","Literatura piękna i popularna","91461","0","0","1"),
("91487","Naukowe i popularnonaukowe","91461","1","0","1"),
("91488","Poradniki","91461","2","0","1"),
("91489","Zestawy mieszane, kolekcje","91461","3","0","1"),
("91490","Pozostałe","91459","7","0","1"),
("91501","Legginsy","11764","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91512","Kalesony","89313","3","0","1"),
("91833","Pozostałe","79154","18","0","1"),
("91834","Postaci historyczne pozostałe","79154","17","0","1"),
("91835","Wokaliści, grupy muzyczne","79154","16","0","1"),
("91836","Władcy","79154","15","0","1"),
("91837","Sportowcy","79154","14","0","1"),
("91838","Reżyserzy, filmowcy","79154","13","0","1"),
("91839","Politycy","79154","12","0","1"),
("91840","Podróżnicy","79154","11","0","1"),
("91841","Pisarze i poeci","79154","10","0","1"),
("91842","Naukowcy","79154","9","0","1"),
("91843","Malarze, rzeźbiarze","79154","8","0","1"),
("91844","Kompozytorzy","79154","7","0","1"),
("91845","Komicy, satyrycy","79154","6","0","1"),
("91846","Finansiści, ekonomiści i biznesmeni","79154","5","0","1"),
("91847","Filozofowie, myśliciele","79154","4","0","1"),
("91848","Dziennikarze","79154","3","0","1"),
("91849","Duchowni","79154","2","0","1"),
("91850","Dowódcy, wodzowie","79154","1","0","1"),
("91851","Aktorzy i artyści","79154","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91860","Dramat zagraniczny","79155","1","0","1"),
("91861","Dramat polski","79155","0","0","1"),
("91880","Pozostałe","79433","5","0","1"),
("91881","Azjatycka","79433","2","0","1"),
("91882","Iberoamerykańska","79433","4","0","1"),
("91883","Europejska","79433","3","0","0"),
("91884","Anglosaska","79433","1","0","0"),
("91885","Afrykańska","79433","0","0","1"),
("91886","Pozostałe","91884","2","0","1"),
("91887","Angielska","91884","1","0","1"),
("91888","Amerykańska","91884","0","0","1"),
("91889","Pozostałe","91883","12","0","1"),
("91890","Włoska","91883","11","0","1"),
("91891","Węgierska","91883","10","0","1"),
("91892","Skandynawska","91883","9","0","1"),
("91893","Rosyjska i radziecka","91883","8","0","1"),
("91894","Niderlandzka","91883","6","0","1"),
("91895","Niemiecka i austriacka","91883","7","0","1"),
("91896","Litewska, łotewska i estońska","91883","5","0","1"),
("91897","Hiszpańska i portugalska","91883","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("91898","Francuska","91883","3","0","1"),
("91899","Czeska i słowacka","91883","2","0","1"),
("91900","Białoruska i ukraińska","91883","1","0","1"),
("91901","Bałkańska","91883","0","0","1"),
("91904","Poezja polska","79161","0","0","1"),
("91905","Poezja zagraniczna","79161","1","0","1"),
("91926","Zagraniczne","79165","1","0","1"),
("91927","Polskie","79165","0","0","1"),
("92312","I (1999-2008)","12674","0","0","1"),
("92313","II (2007-2014)","12674","1","0","1"),
("92314","I (2002-2009)","12463","0","0","1"),
("92315","II (2008-2016)","12463","1","0","1"),
("92465","Zagraniczne","79156","1","0","1"),
("92466","Polskie","79156","0","0","1"),
("92467","Pozostałe","79160","5","0","1"),
("92468","Czarny kryminał amerykański","79160","0","0","1"),
("92469","Szpiegowskie i polityczne","79160","4","0","1"),
("92470","PRL-owskie, milicyjne","79160","2","0","1"),
("92471","Detektywistyczne","79160","1","0","1"),
("92472","Sensacyjno-awanturnicze","79160","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("92473","Zagraniczne","79164","1","0","1"),
("92474","Polskie","79164","0","0","1"),
("92475","Zagraniczne","79166","1","0","1"),
("92476","Polskie","79166","0","0","1"),
("92573","Anime","89054","0","0","1"),
("92574","Fantasy","89054","4","0","1"),
("92575","Kabarety","89054","6","0","1"),
("92576","Kursy, ćwiczenia","89054","10","0","1"),
("92577","Musicale","89054","11","0","1"),
("92578","Westerny","89054","17","0","1"),
("92734","Biżuteria","20760","1","0","1"),
("92835","Pozostałe","91461","4","0","1"),
("92873","Obcojęzyczne","79413","5","0","0"),
("92874","Zestawy mieszane, kolekcje","79413","6","0","1"),
("92875","Pozostałe","79414","7","0","1"),
("92876","Historyczne i wojenne","79414","5","0","1"),
("92877","Humor, satyra","79414","6","0","1"),
("92878","Horrory, groza","79414","4","0","1"),
("92879","Fantasy i science fiction","79414","3","0","1"),
("92880","Superbohaterowie","79414","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("92881","Dla dorosłych","79414","1","0","1"),
("92882","Dla dzieci","79414","0","0","1"),
("92883","Pozostałe","79415","7","0","1"),
("92884","Obyczajowe i przygodowe","79415","6","0","1"),
("92885","Historyczne i wojenne","79415","3","0","1"),
("92886","Humor, satyra","79415","5","0","1"),
("92887","Horrory, groza","79415","4","0","1"),
("92888","Fantasy i science fiction","79415","2","0","1"),
("92889","Dla dorosłych","79415","1","0","1"),
("92890","Dla dzieci","79415","0","0","1"),
("92891","Pozostałe","79416","3","0","1"),
("92892","Dla dorosłych","79416","2","0","1"),
("92893","Dla młodzieży","79416","1","0","1"),
("92894","Dla dzieci","79416","0","0","1"),
("92895","Pozostałe","79417","7","0","1"),
("92896","Obyczajowe i przygodowe","79417","6","0","1"),
("92897","Historyczne i wojenne","79417","3","0","1"),
("92898","Humor, satyra","79417","5","0","1"),
("92899","Horrory, groza","79417","4","0","1"),
("92900","Fantasy i science fiction","79417","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("92901","Dla dorosłych","79417","1","0","1"),
("92902","Dla dzieci","79417","0","0","1"),
("92903","Pozostałe","92873","3","0","1"),
("92904","Europejskie","92873","1","0","1"),
("92905","Japońskie","92873","2","0","1"),
("92906","Amerykańskie","92873","0","0","1"),
("93053","Pozostałe","5352","6","0","1"),
("93054","Higiena intymna","5352","0","0","1"),
("93055","Mydła","5352","1","0","1"),
("93056","Myjki i gąbki","5352","2","0","1"),
("93057","Płyny, emulsje, olejki","5352","3","0","1"),
("93058","Sole i kule","5352","4","0","1"),
("93059","Żele","5352","5","0","1"),
("93060","Dezodoranty do stóp","1434","0","0","1"),
("93061","Parafina","1434","3","0","1"),
("93062","Szablony","45678","5","0","1"),
("93063","Podkładki, poduszki","45678","3","0","1"),
("93066","Pozostałe","45686","4","0","1"),
("93067","Płyny usuwające tipsy","45686","2","0","1"),
("93068","Nabłyszczanie, wygładzanie","9315","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93069","Przedłużanie rzęs, sztuczne rzęsy","45660","6","0","0"),
("93070","Pozostałe","93069","4","0","1"),
("93071","Akcesoria","93069","0","0","1"),
("93072","Kleje","93069","1","0","1"),
("93073","Preparaty do usuwania rzęs","93069","2","0","1"),
("93074","Rzęsy","93069","3","0","1"),
("93078","Pozostałe","1562","2","0","1"),
("93079","Damskie","1562","0","0","1"),
("93080","Męskie","1562","1","0","1"),
("93085","Mapy, atlasy, plany miast","79420","0","0","0"),
("93086","Przewodniki, książki krajoznawcze","79420","1","0","0"),
("93087","Literatura podróżnicza","79420","2","0","1"),
("93088","Pozostałe","79420","3","0","1"),
("93089","Pozostałe","93085","9","0","1"),
("93091","Cały świat","93085","8","0","1"),
("93100","USA, Kanada, Meksyk","93085","6","0","1"),
("93101","Polska","93085","0","0","1"),
("93102","Europa z Rosją","93085","1","0","1"),
("93103","Azja","93085","2","0","1"),
("93104","Ameryka Południowa","93085","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93105","Ameryka Środkowa i Karaiby","93085","5","0","1"),
("93107","Pozostałe","93086","9","0","1"),
("93108","Cały świat","93086","8","0","1"),
("93110","Australia i Oceania","93085","7","0","1"),
("93111","Australia i Oceania","93086","7","0","1"),
("93113","Polska","93086","0","0","1"),
("93115","Europa z Rosją","93086","1","0","1"),
("93116","Azja","93086","2","0","1"),
("93119","USA, Kanada, Meksyk","93086","6","0","1"),
("93121","Ameryka Południowa","93086","4","0","1"),
("93122","Ameryka Środkowa i Karaiby","93086","5","0","1"),
("93125","Pozostałe","1431","2","0","1"),
("93126","Dla kobiet","1431","0","0","0"),
("93127","Dla mężczyzn","1431","1","0","0"),
("93128","Pozostałe","93126","4","0","1"),
("93129","Depilacja woskiem, pastą","93126","1","0","0"),
("93130","Depilatory","93126","2","0","1"),
("93131","Maszynki, pianki, kremy","93126","3","0","1"),
("93132","Pozostałe","93129","4","0","1"),
("93133","Woski, pasty","93129","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93134","Paski","93129","0","0","1"),
("93135","Podgrzewacze","93129","1","0","1"),
("93136","Zestawy","93129","3","0","1"),
("93137","Pozostałe","93127","8","0","1"),
("93138","Maszynki","93127","1","0","1"),
("93139","Pianki, żele, kremy","93127","3","0","1"),
("93140","Afryka","93086","3","0","1"),
("93141","Afryka","93085","3","0","1"),
("93142","Koraliki modułowe","76658","5","0","1"),
("93143","Pozostałe","66806","10","0","1"),
("93144","Węgierski","66806","9","0","1"),
("93145","Ukraiński","66806","8","0","1"),
("93146","Słowacki","66806","7","0","1"),
("93147","Rumuński","66806","6","0","1"),
("93148","Niderlandzki","66806","5","0","1"),
("93149","Litewski","66806","4","0","1"),
("93150","Grecki","66806","3","0","1"),
("93151","Czeski","66806","2","0","1"),
("93152","Chorwacki","66806","1","0","1"),
("93153","Bułgarski","66806","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93154","Po szwedzku","91459","5","0","1"),
("93155","Pozostałe","90346","9","0","1"),
("93156","Wybitne postaci","90346","8","0","1"),
("93157","Oddziały i formacje wojskowe","90346","7","0","1"),
("93158","Mundury, odznaki i odznaczenia","90346","6","0","1"),
("93159","Marynarka Wojenna","90346","5","0","1"),
("93160","Lotnictwo","90346","4","0","1"),
("93161","Kampanie i bitwy","90346","3","0","1"),
("93162","Fortyfikacje","90346","2","0","1"),
("93163","Broń pancerna","90346","1","0","1"),
("93164","Broń palna","90346","0","0","1"),
("93165","Pozostałe","79847","5","0","1"),
("93166","Żeglarstwo regatowe i turystyczne","79847","3","0","1"),
("93167","Zjawiska i miejsca","79847","2","0","1"),
("93168","Osoby, wybitne postaci","79847","1","0","1"),
("93169","Historia żeglarstwa","79847","0","0","1"),
("93170","Serie wydawnicze i kolekcje","79847","4","0","1"),
("93171","Sanki","86386","3","0","1"),
("93172","Viano","4041","27","0","1"),
("93173","Cube","4043","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93174","NV200","4043","19","0","1"),
("93175","Juke","4043","11","0","1"),
("93193","Clics","11823","1","0","1"),
("93194","Jixin","11823","7","0","1"),
("93195","Fisher Price","11823","4","0","1"),
("93196","Wader","11823","13","0","1"),
("93197","Hemar","11823","5","0","1"),
("93198","Wafle","11823","14","0","1"),
("93199","Atlantis","17865","2","0","1"),
("93200","Hero Factory","17865","18","0","1"),
("93202","Harry Potter","17865","17","0","1"),
("93203","Toy Story","17865","40","0","1"),
("93204","Gry","17865","16","0","1"),
("93205","Star Wars","17865","35","0","1"),
("93206","City","17865","7","0","1"),
("93207","Kingdoms","17865","21","0","1"),
("93208","Space Police","17865","33","0","1"),
("93209","Minifigures","17865","24","0","1"),
("93211","Racers","17865","32","0","1"),
("93213","Creator","17865","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93214","Indiana Jones","17865","19","0","1"),
("93215","Pirates","17865","29","0","1"),
("93217","Płytki budowlane","17865","42","0","1"),
("93218","Pozostałe","17865","43","0","1"),
("93251","Castle","17865","5","0","1"),
("93533","Gadżety piwne","953","2","0","1"),
("93534","Austria","50443","0","0","1"),
("93535","Szwajcaria","50443","5","0","1"),
("93536","Wielka Brytania","50443","6","0","1"),
("93537","Włochy","50443","7","0","1"),
("93538","Rosja i ZSRR","50444","2","0","1"),
("93539","Niemcy","50444","0","0","1"),
("93540","1944 - 1989","50458","1","0","1"),
("93541","od 1990","50458","2","0","1"),
("93542","Zbroje i elementy","16543","1","0","1"),
("93543","Broń","16543","0","0","1"),
("93544","Pozostałe","16543","2","0","1"),
("93545","Odzież","16544","0","0","1"),
("93546","Uzbrojenie","16544","1","0","1"),
("93547","Pozostałe","16544","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93548","Pozostałe","16545","2","0","1"),
("93549","Uzbrojenie","16545","1","0","1"),
("93550","Odzież","16545","0","0","1"),
("93551","Pozostałe","16546","2","0","1"),
("93552","Odzież","16546","1","0","1"),
("93553","Uzbrojenie","16546","0","0","1"),
("93554","1945 - 1960","12091","1","0","0"),
("93555","1961 - 1989","12091","2","0","0"),
("93556","Umundurowanie","93555","0","0","1"),
("93557","Wyposażenie","93555","1","0","1"),
("93558","Umundurowanie","16557","0","0","1"),
("93559","Wyposażenie","16557","1","0","1"),
("93560","Umundurowanie","93554","0","0","1"),
("93561","Wyposażenie","93554","1","0","1"),
("93562","Sluban","11823","12","0","1"),
("93564","Militarne","11818","12","0","0"),
("93565","Pozostałe","93564","3","0","1"),
("93566","Pistolety","93564","2","0","1"),
("93567","Karabiny","93564","0","0","1"),
("93568","Miecze Świetlne","93564","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93569","Pozostałe","11824","9","0","1"),
("93570","Tomy","11824","6","0","1"),
("93571","Fisher Price","11824","2","0","1"),
("93572","Wader","11824","7","0","1"),
("93573","Jixin","11824","3","0","1"),
("93574","Brio","11824","0","0","1"),
("93575","Fenbo","11824","1","0","1"),
("93577","Inne drewniane","11824","8","0","1"),
("93578","Maty edukacyjne","11820","8","0","1"),
("93585","Książeczki","11820","7","0","1"),
("93586","Stoliczki edukacyjne","11820","12","0","1"),
("93587","Stojaki gimnastyczne","11820","11","0","1"),
("93588","Bączki","11820","0","0","1"),
("93589","Fontanny z piłek","11820","3","0","1"),
("93590","Do raczkowania","11820","1","0","1"),
("93595","Pozostałe","92","7","0","1"),
("93601","Algieria","92","0","0","1"),
("93602","Egipt","92","1","0","1"),
("93603","Kamerun","92","2","0","1"),
("93604","Kongo","92","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93605","Mauritius","92","4","0","1"),
("93606","Somalia","92","5","0","1"),
("93607","Uganda","92","6","0","1"),
("93608","Kolekcjonerskie","93","0","0","1"),
("93609","Obiegowe","93","1","0","1"),
("93610","Armenia","91","1","0","1"),
("93611","Indonezja","91","4","0","1"),
("93612","Irak","91","5","0","1"),
("93613","Iran","91","6","0","1"),
("93614","Izrael","91","7","0","1"),
("93615","Kazachstan","91","9","0","1"),
("93616","Mongolia","91","10","0","1"),
("93617","Nepal","91","11","0","1"),
("93618","Tajlandia","91","12","0","1"),
("93619","Turcja","87","13","0","1"),
("93626","Zhu Zhu Pets","19474","5","0","1"),
("93627","Pieski","19474","4","0","1"),
("93628","Misie","19474","3","0","1"),
("93629","Kotki","19474","2","0","1"),
("93631","Disney","19474","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93632","Pozostałe","19474","6","0","1"),
("93633","Pozostałe","19475","20","0","1"),
("93634","Krecik","19475","6","0","1"),
("93635","Pszczółka Maja","19475","10","0","1"),
("93636","Noddy","19475","9","0","1"),
("93637","Teletubisie","19475","14","0","1"),
("93638","Elmo","19475","3","0","1"),
("93639","Świnka Peppa","19475","13","0","1"),
("93640","Spongebob","19475","12","0","1"),
("93641","Kubuś Puchatek","19475","17","0","1"),
("93642","Prosiaczek","19475","18","0","1"),
("93643","Tygrysek","19475","19","0","1"),
("93644","Kłapouchy","19475","16","0","1"),
("93645","Miś Uszatek","19475","7","0","1"),
("93646","Pozostałe","19476","7","0","1"),
("93647","Misie","19476","3","0","1"),
("93648","Kotki","19476","1","0","1"),
("93649","Konie","19476","0","0","1"),
("93650","Pieski","19476","5","0","1"),
("93651","Owieczki","19476","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93652","Tygrysy","19476","6","0","1"),
("93653","Króliczki","19476","2","0","1"),
("93654","Pozostałe","11819","9","0","1"),
("93655","Ciastolina","11819","1","0","1"),
("93657","Piaskolina","11819","4","0","1"),
("93658","Projektory","11819","6","0","1"),
("93659","Bindeez","11819","0","0","1"),
("93660","Maty wodne","11819","2","0","1"),
("93663","Prace ręczne","11819","5","0","1"),
("93678","AGD","11818","0","0","0"),
("93679","Majsterkowanie","11818","10","0","0"),
("93680","Pozostałe","93678","10","0","1"),
("93681","Kuchnie","93678","2","0","1"),
("93682","Pralki","93678","5","0","1"),
("93683","Odkurzacze","93678","4","0","1"),
("93684","Toaletki","93678","7","0","1"),
("93685","Żelazka i deski","93678","9","0","1"),
("93686","Zestawy do sprzątania","93678","8","0","1"),
("93687","Maszyny do szycia","93678","3","0","1"),
("93688","Sklepy i kasy","93678","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93698","Pozostałe","93679","4","0","1"),
("93699","Skrzynki, walizki","93679","1","0","1"),
("93700","Warsztaty","93679","2","0","1"),
("93701","Narzędzia","93679","0","0","1"),
("93703","Drobne AGD","93678","1","0","1"),
("93704","Nauka i zabawa","11821","2","0","0"),
("93705","Pozostałe","93704","3","0","1"),
("93706","Teleskopy","93704","1","0","1"),
("93707","Zestawy konstrukcyjne","93679","3","0","1"),
("93708","Mikroskopy","93704","0","0","1"),
("93709","Zestawy doświadczalne","93704","2","0","1"),
("93710","Telefony","11821","5","0","1"),
("93711","Tablice","11821","4","0","0"),
("93712","Pozostałe","93711","2","0","1"),
("93713","Magnetyczne","93711","1","0","1"),
("93714","Kredowe","93711","0","0","1"),
("93715","Pozostałe","19423","4","0","1"),
("93716","Sortery","19423","3","0","1"),
("93717","Piramidki","19423","2","0","1"),
("93718","Kostki logiczne","19423","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93719","Labirynty,przeplatanki","19423","1","0","1"),
("93720","Pozostałe","19421","5","0","1"),
("93721","Gitary","19421","1","0","1"),
("93722","Pianinka","19421","4","0","1"),
("93723","Cymbałki","19421","0","0","1"),
("93724","Perkusje","19421","3","0","1"),
("93725","Mikrofony","19421","2","0","1"),
("93797","Projektory i przeźrocza","47936","9","0","1"),
("93798","Burundi","1059","0","0","1"),
("93799","Gwinea","1059","5","0","1"),
("93800","Kenia","1059","6","0","1"),
("93801","Malawi","1059","10","0","1"),
("93803","Mauritius","1059","11","0","1"),
("93805","Uganda","1059","16","0","1"),
("93811","Bangladesz","885","1","0","1"),
("93812","Birma","885","3","0","1"),
("93813","Bhutan","885","2","0","1"),
("93814","Filipiny","885","5","0","1"),
("93815","Izrael","885","10","0","1"),
("93816","Jemen","885","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93817","Jordania","885","12","0","1"),
("93818","Kambodża","885","13","0","1"),
("93819","Kuwejt","885","15","0","1"),
("93820","Laos","885","16","0","1"),
("93821","Liban","885","17","0","1"),
("93822","Malediwy","885","18","0","1"),
("93823","Malezja","885","19","0","1"),
("93824","Syria","885","24","0","1"),
("93825","Wietnam","885","26","0","1"),
("93826","Pozostałe","1003","12","0","1"),
("93827","Zestawy","1003","11","0","1"),
("93828","Gorzelnictwo","1003","0","0","0"),
("93829","Piwowarstwo","1003","1","0","0"),
("93831","Butelki","1003","3","0","1"),
("93832","Kieliszki","1003","5","0","1"),
("93833","Korki","1003","6","0","1"),
("93834","Korkociągi","1003","7","0","1"),
("93835","Winiarstwo","1003","2","0","0"),
("93836","Piersiówki","1003","8","0","1"),
("93838","Pudełka i skrzynki","1003","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("93839","Stojaki","1003","10","0","1"),
("93841","Destylacja","93828","0","0","0"),
("93844","Pozostałe","93828","2","0","1"),
("93846","Pozostałe","93829","8","0","1"),
("93848","Chmiel","93829","1","0","1"),
("93849","Drożdże","93829","2","0","1"),
("93851","Kapsle","93829","3","0","1"),
("93854","Zestawy warzelnicze","93829","7","0","1"),
("93867","Autografy","316","1","0","0"),
("93869","Film","93867","0","0","1"),
("93870","Polityka","93867","3","0","1"),
("93872","Sport","93867","5","0","1"),
("93873","Pozostałe","93867","6","0","1"),
("93874","Magnesy","316","12","0","1"),
("93877","Instrukcje i regulaminy","53638","2","0","1"),
("93879","Owady, pajęczaki i inne","316","13","0","0"),
("93881","Pozostałe","93879","4","0","1"),
("93883","Motyle","93879","1","0","1"),
("93884","Chrząszcze","93879","0","0","1"),
("93885","Pajęczaki","93879","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("94060","Włochy","382","17","0","1"),
("94135","Znikopisy","11819","8","0","1"),
("94136","Maskotki Uczniaczki","19411","1","0","1"),
("94137","Kostki edukacyjne","19411","0","0","1"),
("94138","Sortery, piramidki","19411","3","0","1"),
("94139","Telefony","19411","4","0","1"),
("94140","Pianinka, cymbałki","19411","2","0","1"),
("94142","Zestawy zabawek","19411","5","0","1"),
("94173","Hello Kitty","19475","5","0","1"),
("94177","Scooby Doo","19475","11","0","1"),
("94178","Dobranocny ogród","19475","2","0","1"),
("94179","Epoka lodowcowa","19475","4","0","1"),
("94180","Learning Curve","11824","4","0","1"),
("94181","Clifford","19475","1","0","1"),
("94182","Włatcy móch","19475","15","0","1"),
("94183","Myszka Miki","19475","8","0","1"),
("94185","Bob Budowniczy","19475","0","0","1"),
("94189","Piankolina","11819","3","0","1"),
("94190","Tomica","11824","5","0","1"),
("95053","Natalia","11825","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("95223","Zestawy zabawek","11820","13","0","1"),
("95593","Maty antypoślizgowe","348","9","0","1"),
("95594","Podstawki","348","13","0","1"),
("95595","Uchwyty do telefonów","348","18","0","1"),
("95597","HTC Desire HD","16618","20","0","1"),
("95600","Veto","6049","8","0","1"),
("95610","C7","4978","84","0","1"),
("95611","N8","4978","98","0","1"),
("95612","X3 Touch and Type","4978","106","0","1"),
("95754","Cedar","5044","29","0","1"),
("95755","XPERIA X8","5044","27","0","1"),
("95831","Anteny","5054","1","0","0"),
("95832","Bazowe","95831","0","0","1"),
("95833","Montażowe","95831","2","0","1"),
("95835","Magnesowe","95831","1","0","1"),
("97554","Berety","1496","1","0","1"),
("97555","Kowbojki","532","5","0","1"),
("97556","Śniegowce","532","11","0","1"),
("97557","Śniegowce","531","14","0","1"),
("97755","Bajki i baśnie","66814","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("97756","Literatura dziecięca","66814","1","0","1"),
("97757","Literatura młodzieżowa","66814","2","0","1"),
("97758","Pozostałe","66814","3","0","1"),
("97759","Książki obcojęzyczne","66813","3","0","1"),
("97760","Literatura piękna zagraniczna","66813","5","0","1"),
("97761","Biografie i wspomnienia","66813","6","0","1"),
("97762","Podróżnicze i przygodowe","66813","9","0","1"),
("97763","Reportaż, literatura faktu","66813","10","0","1"),
("97764","Fantasy i science fiction","66813","7","0","1"),
("97765","Społeczno-obyczajowe","66813","11","0","1"),
("97766","Kryminały, thrillery i sensacyjne","66813","8","0","1"),
("97767","Historyczne ","66813","12","0","1"),
("97768","Poradniki, hobby","66813","13","0","1"),
("97769","Biznes i ekonomia","66813","14","0","1"),
("97770","Religia, duchowość","66813","15","0","1"),
("97771","Zestawy, kolekcje","66813","16","0","1"),
("97857","C3 Picasso","4033","8","0","1"),
("97858","Do zabudowy","589","4","0","1"),
("97873","Ramki cyfrowe","8850","2","0","0"),
("97874","Ramki tradycyjne","8850","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("97875","Pozostałe","97874","4","0","1"),
("97876","Antyramy","97874","0","0","1"),
("97877","Drewniane","97874","1","0","1"),
("97878","Metalowe","97874","2","0","1"),
("97879","Zestawy","97874","3","0","1"),
("97880","Pozostałe","97873","5","0","1"),
("97881","Sony","97873","4","0","1"),
("97883","Philips","97873","3","0","1"),
("97884","Intenso","97873","1","0","1"),
("97885","Kodak","97873","2","0","1"),
("97887","Hama","97873","0","0","1"),
("97891","Muszle oczne i wizjery","8847","17","0","1"),
("97892","Poziomice","8847","21","0","1"),
("97894","Pokrowce i futerały","28155","1","0","1"),
("97895","Pozostałe","28155","2","0","1"),
("97896","Pozostałe","19983","4","0","1"),
("97897","Nikon","19983","1","0","1"),
("97898","Canon","19983","0","0","1"),
("97899","Olympus","19983","2","0","1"),
("97900","Sony","19983","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("97927","Pozostałe","14075","3","0","1"),
("97928","Figurowe","14075","0","0","1"),
("97929","Hokejowe","14075","1","0","1"),
("97930","Regulowane","14075","2","0","1"),
("98133","Insignia","4044","15","0","0"),
("98315","Rury do tańca","63759","13","0","1"),
("98316","Erotyka okazje","63757","6","0","0"),
("98317","Wieczór panieński","98316","2","0","1"),
("98318","Wieczór kawalerski","98316","1","0","1"),
("98319","Pozostałe","98316","3","0","1"),
("98333","Zawieszki","76670","13","0","0"),
("98553","Bilety","0","1","0","0"),
("98573","Pozostałe","98553","5","0","1"),
("98593","Pozostałe","76671","5","0","1"),
("98594","Miedziane","76671","0","0","1"),
("98595","Posrebrzane","76671","1","0","1"),
("98596","Pozłacane","76671","2","0","1"),
("98597","Srebrne","76671","3","0","1"),
("98598","Złote","76671","4","0","1"),
("98599","Pozostałe","76672","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98600","Miedziane","76672","0","0","1"),
("98601","Posrebrzane","76672","1","0","1"),
("98602","Pozłacane","76672","2","0","1"),
("98603","Srebrne","76672","3","0","1"),
("98604","Złote","76672","4","0","1"),
("98605","Pozostałe","76763","5","0","1"),
("98606","Miedziane","76763","0","0","1"),
("98607","Posrebrzane","76763","1","0","1"),
("98608","Pozłacane","76763","2","0","1"),
("98609","Srebrne","76763","3","0","1"),
("98610","Złote","76763","4","0","1"),
("98611","Pozostałe","76675","5","0","1"),
("98612","Miedziane","76675","0","0","1"),
("98613","Rurki","76670","8","0","0"),
("98614","Przekładki","76670","7","0","0"),
("98615","Pozostałe","98614","5","0","1"),
("98616","Pozostałe","98613","5","0","1"),
("98617","Posrebrzane","76675","1","0","1"),
("98618","Pozłacane","76675","2","0","1"),
("98619","Srebrne","76675","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98620","Złote","76675","4","0","1"),
("98621","Pozostałe","76676","5","0","1"),
("98622","Miedziane","76676","0","0","1"),
("98623","Posrebrzane","76676","1","0","1"),
("98624","Pozłacane","76676","2","0","1"),
("98625","Srebrne","76676","3","0","1"),
("98626","Złote","76676","4","0","1"),
("98627","Pozostałe","76678","5","0","1"),
("98628","Miedziane","76678","0","0","1"),
("98629","Posrebrzane","76678","1","0","1"),
("98630","Pozłacane","76678","2","0","1"),
("98631","Srebrne","76678","3","0","1"),
("98632","Złote","76678","4","0","1"),
("98633","Pozostałe","76679","5","0","1"),
("98634","Posrebrzane","76679","1","0","1"),
("98635","Pozłacane","76679","2","0","1"),
("98636","Srebrne","76679","3","0","1"),
("98637","Złote","76679","4","0","1"),
("98638","Miedziane","76679","0","0","1"),
("98639","Pozostałe","76680","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98640","Miedziane","76680","0","0","1"),
("98641","Posrebrzane","76680","1","0","1"),
("98642","Pozłacane","76680","2","0","1"),
("98643","Srebrne","76680","3","0","1"),
("98644","Złote","76680","4","0","1"),
("98645","Pozostałe","98333","5","0","1"),
("98646","Miedziane","98333","0","0","1"),
("98647","Posrebrzane","98333","1","0","1"),
("98648","Pozłacane","98333","2","0","1"),
("98649","Srebrne","98333","3","0","1"),
("98650","Złote","98333","4","0","1"),
("98651","Posrebrzane","98614","1","0","1"),
("98652","Pozłacane","98614","2","0","1"),
("98653","Srebrne","98614","3","0","1"),
("98654","Złote","98614","4","0","1"),
("98655","Miedziane","98614","0","0","1"),
("98656","Miedziane","98613","0","0","1"),
("98657","Posrebrzane","98613","1","0","1"),
("98658","Pozłacane","98613","2","0","1"),
("98659","Srebrne","98613","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98660","Złote","98613","4","0","1"),
("98696","Poduszki i poszewki","20760","7","0","1"),
("98697","Breloki","20760","2","0","1"),
("98698","Zegary i zegarki","20760","10","0","1"),
("98699","Torby i plecaki","20760","8","0","1"),
("98700","Okładki, koszulki","279","26","0","1"),
("98701","Zatyczki, stopery","12825","2","0","1"),
("98713","Płyty 3D","20585","0","0","0"),
("98714","Science fiction","98713","5","0","1"),
("98715","Horrory","98713","2","0","1"),
("98716","Dla dzieci","98713","0","0","1"),
("98717","Fantasy","98713","1","0","1"),
("98718","Koncerty","98713","3","0","1"),
("98719","Sensacyjne","98713","6","0","1"),
("98720","Popularnonaukowe","98713","4","0","1"),
("98721","Pozostałe","98713","7","0","1"),
("98725","Pozostałe","17278","14","0","1"),
("98726","Naklejki ścienne","17278","3","0","1"),
("98727","Szablony malarskie","17278","10","0","1"),
("98728","Tapety","17278","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98729","Bordery","17278","0","0","1"),
("98730","Ramki","17278","8","0","1"),
("98731","Miarki wzrostu","17278","2","0","1"),
("98732","Poduszki","17278","6","0","1"),
("98733","Ozdoby 3D","17278","5","0","1"),
("98734","Skarbonki i figurki","17278","9","0","1"),
("98735","Wieszaki","17278","12","0","1"),
("98736","Pudełka","17278","7","0","1"),
("98737","Zegary","17278","13","0","1"),
("98738","Obrazki","17278","4","0","1"),
("98739","Magnesy","17278","1","0","1"),
("98740","Pozostałe","17279","3","0","1"),
("98741","Dywany","17279","0","0","1"),
("98742","Firanki","17279","1","0","1"),
("98743","Zasłony","17279","2","0","1"),
("98744","Łóżka i kojce","17272","2","0","0"),
("98745","Pozostałe","98744","7","0","1"),
("98746","Łóżeczka drewniane","98744","0","0","1"),
("98747","Łóżeczka turystyczne","98744","1","0","1"),
("98748","Kojce","98744","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98749","Kołyski","98744","3","0","1"),
("98750","Łóżka pojedyncze","98744","4","0","1"),
("98751","Łóżka piętrowe","98744","5","0","1"),
("98752","Materace","17272","3","0","1"),
("98753","Fotele i pufy","17273","1","0","1"),
("98754","Biurka","17273","0","0","1"),
("98755","Krzesła biurowe","17273","4","0","1"),
("98756","Regały i półki","17273","7","0","1"),
("98757","Komody","17273","2","0","1"),
("98758","Szafy","17273","8","0","1"),
("98759","Komplety mebli","17273","3","0","1"),
("98760","Pozostałe","17283","4","0","1"),
("98761","Lampki nocne","17283","1","0","1"),
("98762","Lampki - projektory","17283","0","0","1"),
("98763","Lampy sufitowe","17283","2","0","1"),
("98764","Lampy ścienne","17283","3","0","1"),
("98765","Śpiworki do spania","17280","9","0","1"),
("98773","Sofy i kanapy","98744","6","0","1"),
("98806","Torch 9800","50971","14","0","1"),
("98807","Curve 9300","50971","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("98808","HTC Desire Z","16618","23","0","1"),
("98817","C3 Touch and Type","4978","81","0","1"),
("98844","Naklejki","16415","8","0","1"),
("98845","Pokrowce","16415","12","0","1"),
("98846","Przyczepki","16415","14","0","1"),
("98847","Sprzęt bagażowy","16415","16","0","0"),
("98848","Sprzęt postojowy","16415","17","0","0"),
("98849","Pozostałe","98847","6","0","1"),
("98850","Bagażniki","98847","0","0","1"),
("98851","Kosze","98847","1","0","1"),
("98852","Kufry","98847","2","0","1"),
("98853","Mapniki i torebki","98847","3","0","1"),
("98855","Sakwy","98847","4","0","1"),
("98856","Torby","98847","5","0","1"),
("98857","Pozostałe","98848","3","0","1"),
("98858","Stojaki","98848","0","0","1"),
("98859","Stopki","98848","1","0","1"),
("98860","Wieszaki, uchwyty","98848","2","0","1"),
("99013","Yeti","4051","11","0","1"),
("99014","i10","4038","12","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99015","i20","4038","13","0","0"),
("99016","ix35","4038","18","0","1"),
("99022","Części do maszyn","3","3","0","0"),
("99178","Ozdoby do włosów","88293","5","0","0"),
("99193","Opony","3","10","0","0"),
("99194","Opony samochodowe","99193","0","0","0"),
("99195","Opony do motocykli i skuterów","99193","1","0","1"),
("99196","Opony dostawcze","99193","2","0","0"),
("99197","Opony ciężarowe","99193","3","0","1"),
("99198","Opony terenowe","99193","4","0","0"),
("99199","Opony rolnicze","99193","5","0","1"),
("99200","Opony przemysłowe","99193","6","0","1"),
("99201","Pozostałe","99193","8","0","1"),
("99202","Letnie","99194","0","0","1"),
("99203","Zimowe","99194","1","0","1"),
("99204","Całoroczne","99194","2","0","1"),
("99236","Letnie","99196","0","0","1"),
("99237","Zimowe","99196","1","0","1"),
("99238","Całoroczne","99196","2","0","1"),
("99281","Letnie","99198","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99282","Zimowe","99198","1","0","1"),
("99283","Całoroczne","99198","2","0","1"),
("99333","Karmienie dziecka","11763","3","0","0"),
("99334","Artykuły higieniczne","17285","1","0","0"),
("99335","Pozostałe","99334","11","0","1"),
("99336","Proszki do prania","99334","7","0","1"),
("99337","Aspiratory i gruszki do nosa","99334","1","0","1"),
("99338","Patyczki higieniczne","99334","4","0","1"),
("99339","Szczoteczki do zębów","99334","8","0","1"),
("99340","Pasty do zębów","99334","3","0","1"),
("99341","Płatki kosmetyczne","99334","5","0","1"),
("99342","Zestawy do paznokci","99334","10","0","1"),
("99343","Szczotki i grzebienie","99334","9","0","1"),
("99344","Artykuły do dezynfekcji","99334","0","0","1"),
("99345","Kosze i wkłady","99334","2","0","1"),
("99346","Podkłady do przewijania","99334","6","0","1"),
("99347","Akcesoria dla mamy","17285","0","0","0"),
("99348","Kremy na rozstępy","99347","2","0","1"),
("99349","Pozostałe","99347","10","0","1"),
("99350","Testy ciążowe","99347","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99351","Podkłady higieniczne","99347","6","0","1"),
("99352","Biustonosze do karmienia","99347","0","0","1"),
("99353","Poduszki do karmienia","99347","7","0","1"),
("99354","Pasy wyszczuplające","99347","5","0","1"),
("99355","Osłonki na piersi","99347","4","0","1"),
("99356","Majtki poporodowe","99347","3","0","0"),
("99357","Jednorazowe","99356","0","0","1"),
("99358","Wielorazowe","99356","1","0","1"),
("99359","Koszule dla karmiących","99347","1","0","1"),
("99360","Wkładki laktacyjne","99347","9","0","1"),
("99361","Pozostałe","99333","8","0","1"),
("99362","Butelki i akcesoria","99333","0","0","0"),
("99363","Nocniki i nakładki","17285","3","0","0"),
("99364","Pozostałe","99363","4","0","1"),
("99365","Nocniki tradycyjne","99363","2","0","1"),
("99366","Nocniki interaktywne","99363","1","0","1"),
("99367","Podesty","99363","3","0","1"),
("99368","Przewijaki","17285","5","0","0"),
("99369","Miękkie","99368","0","0","1"),
("99370","Sztywne","99368","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99371","Komody pielęgnacyjne","99368","2","0","1"),
("99372","Wanienki i akcesoria do kąpieli","17285","9","0","0"),
("99373","Pozostałe","99372","7","0","1"),
("99374","Komody kąpielowe","99372","1","0","1"),
("99375","Wanienki","99372","5","0","1"),
("99376","Stojaki","99372","4","0","1"),
("99377","Maty do kąpieli","99372","2","0","1"),
("99378","Foteliki kąpielowe","99372","0","0","1"),
("99379","Wiaderka do kąpieli","99372","6","0","1"),
("99380","Ronda kąpielowe","99372","3","0","1"),
("99381","Pozostałe","17294","8","0","1"),
("99382","Kremy na odparzenia","17294","0","0","1"),
("99383","Kremy pielęgnacyjne","17294","1","0","1"),
("99384","Kremy i mleczka na słońce","17294","4","0","1"),
("99385","Płyny do kąpieli","17294","6","0","1"),
("99386","Emulsje i mydła","17294","3","0","1"),
("99387","Balsamy i olejki do ciała","17294","2","0","1"),
("99388","Mleczka","17294","5","0","1"),
("99389","Szampony i żele","17294","7","0","1"),
("99390","Pozostałe","17295","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99391","Pieluszki jednorazowe","17295","0","0","1"),
("99392","Pieluszki wielorazowe","17295","1","0","1"),
("99393","Chusteczki nawilżające","17295","3","0","1"),
("99405","Majteczki treningowe","17295","2","0","1"),
("99406","Pozostałe","27837","3","0","1"),
("99407","Ręczniki kąpielowe","27837","1","0","1"),
("99408","Ręczniki plażowe","27837","2","0","1"),
("99409","Okrycia z kapturem","27837","0","0","1"),
("99410","Pozostałe","17293","5","0","1"),
("99411","Elektroniczne pod pachę","17293","3","0","1"),
("99412","Elektroniczne do ucha, czoła","17293","2","0","1"),
("99413","Bezdotykowe","17293","0","0","1"),
("99414","Elektroniczne - smoczki","17293","1","0","1"),
("99415","Do kąpieli","17293","4","0","1"),
("99416","Pozostałe","17298","3","0","1"),
("99417","Inhalatory, nebulizatory","17298","0","0","1"),
("99418","Nawilżacze powietrza","17298","1","0","1"),
("99419","Wagi","17298","2","0","1"),
("99420","Smoczki uspokajające i gryzaki","99333","4","0","0"),
("99421","Smoczki i ustniki do butelek","99362","1","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99422","Smoczki","99421","0","0","1"),
("99423","Ustniki","99421","1","0","1"),
("99424","Butelki","99362","0","0","1"),
("99432","Pozostałe","99362","3","0","1"),
("99433","Akcesoria","99362","2","0","0"),
("99434","Pozostałe","99433","3","0","1"),
("99435","Termoopakowania","99433","2","0","1"),
("99436","Pojemniki","99433","1","0","1"),
("99437","Do mycia butelek","99433","0","0","1"),
("99438","Naczynia i sztućce","99333","2","0","0"),
("99439","Pozostałe","99438","5","0","1"),
("99440","Sztućce","99438","1","0","1"),
("99441","Talerzyki i miseczki","99438","2","0","1"),
("99442","Kubki","99438","0","0","1"),
("99449","Zestawy","99438","4","0","1"),
("99450","Pozostałe","99420","4","0","1"),
("99451","Smoczki","99420","0","0","1"),
("99452","Gryzaczki","99420","1","0","1"),
("99453","Zawieszki","99420","2","0","1"),
("99454","Pojemniki na smoczki","99420","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99455","Podgrzewacze","99333","3","0","1"),
("99461","Sterylizatory","99333","5","0","1"),
("99465","Śliniaki","99333","6","0","1"),
("99470","Żywność dla dzieci","99333","7","0","0"),
("99471","Pozostałe","99470","7","0","1"),
("99472","Mleka modyfikowane","99470","4","0","0"),
("99473","Kaszki","99470","3","0","1"),
("99474","Obiadki","99470","5","0","1"),
("99475","Deserki","99470","1","0","1"),
("99477","Ciasteczka","99470","0","0","1"),
("99478","Laktatory i akcesoria","99333","1","0","1"),
("99482","Biżuteria","88293","0","0","0"),
("99483","Torby","50679","0","0","1"),
("99484","Worki","50679","1","0","1"),
("99485","Torebeczki i plecaczki","50673","8","0","1"),
("99486","Pozostałe","50679","2","0","1"),
("99487","Portfele","50673","4","0","1"),
("99488","Pozostałe","99178","4","0","1"),
("99489","Gumki","99178","0","0","1"),
("99490","Opaski","99178","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99491","Spinki","99178","2","0","1"),
("99492","Zestawy","99178","3","0","1"),
("99493","Okulary przeciwsłoneczne","88297","3","0","1"),
("99494","Parasolki","88297","4","0","1"),
("99495","Paski","88297","5","0","1"),
("99496","Pozostałe","99482","5","0","1"),
("99497","Kolczyki, klipsy","99482","1","0","1"),
("99498","Bransoletki","99482","0","0","1"),
("99499","Naszyjniki, korale","99482","2","0","1"),
("99500","Zegarki","99482","3","0","1"),
("99501","Zestawy","99482","4","0","1"),
("99528","Nakładki na sedes","99363","0","0","1"),
("99529","Woreczki na pieluszki","17295","4","0","1"),
("99561","Rozpałki i brykiety","47493","4","0","1"),
("99563","Noże ogrodnicze","1534","4","0","1"),
("99565","Taczki i wózki ogrodnicze","1534","17","0","1"),
("99573","Pozostałe","59278","4","0","1"),
("99574","Mieszkania i apartamenty","59278","0","0","0"),
("99575","Domy","59278","1","0","0"),
("99576","Pokoje","59278","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99577","Lokale użytkowe","59278","2","0","0"),
("99578","Pozostałe","99574","9","0","1"),
("99579","Bułgaria","99574","0","0","1"),
("99580","Czechy","99574","1","0","1"),
("99581","Egipt","99574","2","0","1"),
("99582","Francja","99574","3","0","1"),
("99583","Grecja","99574","4","0","1"),
("99584","Hiszpania","99574","5","0","1"),
("99585","Niemcy","99574","6","0","1"),
("99586","Słowacja","99574","7","0","1"),
("99587","Stany Zjednoczone","99574","8","0","1"),
("99588","Pozostałe","99575","10","0","1"),
("99589","Bahamy","99575","0","0","1"),
("99590","Bułgaria","99575","1","0","1"),
("99591","Czechy","99575","2","0","1"),
("99592","Egipt","99575","3","0","1"),
("99593","Francja","99575","4","0","1"),
("99594","Grecja","99575","5","0","1"),
("99595","Hiszpania","99575","6","0","1"),
("99596","Niemcy","99575","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99597","Słowacja","99575","8","0","1"),
("99598","Stany Zjednoczone","99575","9","0","1"),
("99599","Pozostałe","99577","5","0","1"),
("99600","Bułgaria","99577","0","0","1"),
("99601","Francja","99577","1","0","1"),
("99602","Hiszpania","99577","2","0","1"),
("99603","Niemcy","99577","3","0","1"),
("99604","Słowacja","99577","4","0","1"),
("99704","Rękawice i odzież ochronna","1534","20","0","1"),
("99705","Miotły i szczotki","1534","9","0","1"),
("99706","Łopatki, motyczki, pikowniki","1534","7","0","1"),
("99709","Plandeki","77733","9","0","1"),
("99710","Ogrodzenia i siatki","77733","5","0","1"),
("99730","Rośliny owocowe","776","5","0","1"),
("99745","Drzewa i krzewy iglaste","776","2","0","1"),
("99754","Drzewa i krzewy liściaste","776","3","0","1"),
("99772","Drzewa i krzewy ozdobne","12920","0","0","1"),
("99773","Rośliny pokojowe","12920","4","0","1"),
("99774","Trawy","12920","5","0","1"),
("99775","Rośliny owocowe","12920","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99776","Warzywa","12920","6","0","1"),
("99789","Zioła","12920","7","0","1"),
("99790","Rośliny pnące","12920","3","0","1"),
("99791","Rośliny ozdobne","12920","2","0","1"),
("99806","Byliny ozdobne","776","6","0","1"),
("99816","Róże","776","12","0","1"),
("99817","Trawy","776","13","0","1"),
("99818","Rośliny pnące","776","8","0","1"),
("99826","Rośliny skalne","776","10","0","1"),
("99827","Pozostałe","12920","8","0","1"),
("99828","Zioła","776","14","0","1"),
("99831","Rośliny jednoroczne i dwuletnie","776","7","0","1"),
("99832","Konferencje, szkolenia, integracja","55067","5","0","0"),
("99833","Pozostałe","99832","3","0","1"),
("99834","Sale konferencyjne","99832","0","0","1"),
("99835","Imprezy integracyjne","99832","1","0","1"),
("99836","Obsługa konferencji i imprez","99832","2","0","1"),
("99859","Zestawy","93879","3","0","1"),
("99860","Muzyka","93867","2","0","1"),
("99861","Religia","93867","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99862","Książka","93867","1","0","1"),
("99863","Flagi i symbole narodowe","316","6","0","0"),
("99864","Flagi","99863","0","0","1"),
("99865","Herby i godła","99863","1","0","1"),
("99866","Pozostałe","99863","2","0","1"),
("99867","skala 1:200","1064","1","0","1"),
("99868","skala 1:144","1064","0","0","1"),
("99869","Kolej","1272","1","0","1"),
("99871","Literatura","10234","16","0","1"),
("99872","obiegowe","13843","1","0","1"),
("99873","kolekcjonerskie","13843","0","0","1"),
("99874","okolicznościowe","45651","1","0","1"),
("99875","obiegowe","45651","0","0","1"),
("99876","Esencje, zaprawki","1003","4","0","1"),
("99877","Nintendo 3DS","82326","7","0","1"),
("99915","Pozłotnictwo","27940","2","0","1"),
("99916","Zestawy","27940","8","0","1"),
("99923","Pozostałe","27945","6","0","1"),
("99925","Markery i pisaki","27945","1","0","1"),
("99926","Węgiel","27945","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("99928","Literatura","26281","5","0","1"),
("99929","Literatura","86073","7","0","1"),
("99930","Zestawy","26087","6","0","1"),
("99983","Bold 9780","50971","2","0","1"),
("99984","HTC Desire S","16618","21","0","1"),
("99987","E900","10539","0","0","1"),
("99990","P500","10539","43","0","1"),
("99993","C2-01","4978","77","0","1"),
("99994","E7","4978","92","0","1"),
("100006","XPERIA Arc","5044","18","0","1"),
("100075","Płyty DVD","20585","1","0","0"),
("100076","Anime","100075","0","0","1"),
("100077","Bollywood","100075","1","0","1"),
("100078","Dla dzieci","100075","2","0","0"),
("100079","Animowane","100078","0","0","1"),
("100080","Fabularne","100078","1","0","1"),
("100081","Pozostałe","100078","2","0","1"),
("100082","Dokumentalne","100075","3","0","0"),
("100083","Historyczne","100082","1","0","1"),
("100084","Podróżnicze","100082","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("100085","Popularnonaukowe","100082","3","0","1"),
("100086","Biograficzne","100082","0","0","1"),
("100087","Pozostałe","100082","4","0","1"),
("100088","Dramaty","100075","4","0","0"),
("100089","Polskie","100088","0","0","1"),
("100090","Zagraniczne","100088","1","0","1"),
("100091","Fantasy","100075","5","0","1"),
("100092","Horrory","100075","6","0","1"),
("100093","Komedie","100075","7","0","0"),
("100094","Polskie","100093","0","0","1"),
("100095","Zagraniczne","100093","1","0","1"),
("100096","Koncerty, kabarety, opery, teatr","100075","8","0","0"),
("100097","Koncerty","100096","1","0","0"),
("100098","Dance, techno","100097","0","0","1"),
("100099","Muzyka klasyczna, opery","100097","1","0","1"),
("100100","Rock","100097","5","0","1"),
("100101","Rap, hip-hop","100097","4","0","1"),
("100102","Pop","100097","2","0","1"),
("100103","Pozostałe","100097","3","0","1"),
("100104","Kostiumowe","100075","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("100105","Kabarety","100096","0","0","1"),
("100106","Spektakle teatralne","100096","3","0","1"),
("100107","Pozostałe","100096","2","0","1"),
("100108","Kryminały","100075","10","0","1"),
("100109","Kursy, ćwiczenia, karaoke","100075","11","0","0"),
("100110","Ćwiczenia fizyczne, taniec","100109","0","0","1"),
("100111","Informatyka","100109","1","0","1"),
("100112","Karaoke","100109","2","0","1"),
("100113","Pozostałe","100109","3","0","1"),
("100114","Musicale","100075","12","0","1"),
("100115","Przygodowe","100075","13","0","1"),
("100116","Romanse","100075","14","0","1"),
("100117","Science Fiction","100075","15","0","1"),
("100118","Seriale","100075","17","0","0"),
("100119","Polskie","100118","0","0","1"),
("100120","Zagraniczne","100118","1","0","1"),
("100121","Thrillery","100075","18","0","1"),
("100122","Westerny","100075","19","0","1"),
("100123","Wojenne","100075","20","0","1"),
("100124","Sensacyjne","100075","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("100125","Pozostałe","100075","22","0","1"),
("100126","Gadżety, akcesoria","20585","5","0","0"),
("100127","Autografy","100126","0","0","1"),
("100128","Plakaty, zdjęcia","100126","6","0","1"),
("100129","Kubki","100126","3","0","1"),
("100130","Figurki","100126","1","0","1"),
("100131","Naszywki, znaczki, przypinki","100126","4","0","1"),
("100132","Kalendarze","100126","2","0","1"),
("100133","Pudełka, okładki, case’y","100126","7","0","1"),
("100134","Regały, półki, stojaki","100126","8","0","1"),
("100135","Odzież","100126","5","0","1"),
("100136","Pozostałe","100126","9","0","1"),
("100137","Zestawy, pakiety","100075","21","0","1"),
("100138","Packard Bell","491","12","0","1"),
("100609","3008","4045","27","0","0"),
("100612","5008","4045","30","0","0"),
("100615","4007","4045","28","0","1"),
("100620","508","4045","20","0","1"),
("100624","Bipper","4045","31","0","1"),
("101258","Bransoletki","76741","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("101259","Broszki","76741","1","0","1"),
("101260","Chusteczniki","76741","2","0","1"),
("101261","Kartki i zaproszenia","76741","3","0","1"),
("101262","Kolczyki","76741","4","0","1"),
("101263","Komplety biżuterii","76741","5","0","1"),
("101264","Lalki i figurki kolekcjonerskie","76741","6","0","1"),
("101265","Narzuty i kołdry","76741","7","0","1"),
("101266","Naszyjniki i korale","76741","8","0","1"),
("101267","Obrazki i ramki","76741","9","0","1"),
("101268","Obrusy, serwety, bieżniki","76741","10","0","1"),
("101269","Odzież","76741","11","0","1"),
("101270","Poduszki","76741","12","0","1"),
("101271","Szkatułki","76741","13","0","1"),
("101272","Świece i świeczniki","76741","14","0","1"),
("101273","Tace, chlebaki i podkładki","76741","15","0","1"),
("101274","Torebki i portmonetki","76741","16","0","1"),
("101275","Wieszaki","76741","17","0","1"),
("101276","Zabawki i maskotki","76741","18","0","1"),
("101346","Noże do papieru","64478","4","0","1"),
("101347","Naboje i atramenty","64507","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("101348","Wkłady","64507","2","0","1"),
("101349","Etui i piórniki","64507","0","0","1"),
("101350","Automatyczne","64512","0","0","1"),
("101351","Tradycyjne","64512","1","0","1"),
("101352","Liczarki, sortery, testery","64486","7","0","1"),
("101353","Nadruki na CD/DVD","64602","4","0","1"),
("101354","Projekty","64602","7","0","1"),
("101355","Plotery","64600","6","0","1"),
("101356","Dyspensery","64482","0","0","1"),
("101357","Biurka","64480","1","0","1"),
("101358","Lady","64480","5","0","1"),
("101359","Muzyka","98553","1","0","0"),
("101360","Pozostałe","101359","5","0","1"),
("101361","Festiwale","101359","0","0","1"),
("101362","Klasyczna","101359","1","0","1"),
("101363","Jazz","101359","2","0","1"),
("101364","Rock&pop","101359","3","0","1"),
("101365","Hard&heavy","101359","4","0","1"),
("101366","Teatr i kino","98553","2","0","0"),
("101367","Pozostałe","101366","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("101368","Spektakle","101366","0","0","1"),
("101369","Seanse filmowe","101366","3","0","1"),
("101370","Kabarety","101366","1","0","1"),
("101371","Musicale","101366","2","0","1"),
("101372","Dla dzieci","101366","4","0","1"),
("101373","Sport","98553","3","0","0"),
("101374","Pozostałe","101373","4","0","1"),
("101375","Koszykówka","101373","0","0","1"),
("101376","Piłka ręczna","101373","1","0","1"),
("101377","Siatkówka","101373","2","0","1"),
("101378","Żużel","101373","3","0","1"),
("101379","Transport i komunikacja","98553","4","0","0"),
("101380","Pozostałe","101379","3","0","1"),
("101381","Bilety lotnicze","101379","0","0","1"),
("101382","Autokary, busy","101379","1","0","1"),
("101383","Promy, statki","101379","2","0","1"),
("101476","Wina","73973","18","0","0"),
("101477","Afryka","101476","0","0","1"),
("101478","Ameryka Południowa","101476","1","0","1"),
("101479","Ameryka Północna ","101476","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("101480","Australia i Oceania","101476","3","0","1"),
("101481","Azja","101476","4","0","1"),
("101482","Europa ","101476","5","0","1"),
("101483","Wyroby winiarskie ","101476","6","0","1"),
("101487","Pozostałe","101476","7","0","1"),
("101549","Wędzarnie","47493","2","0","1"),
("101596","Do HTC","351","1","0","1"),
("101604","HTC Sensation","16618","36","0","1"),
("101605","HTC Wildfire S","16618","39","0","1"),
("101607","Swift (Optimus) Black","10539","47","0","1"),
("101614","XPERIA Play","5044","22","0","1"),
("101615","Yendo","5044","37","0","1"),
("101635","Punto Evo","4035","27","0","1"),
("101636","Qubo","4035","28","0","1"),
("102857","Namioty","3922","4","0","0"),
("102858","Plecaki","3922","5","0","0"),
("102859","Pontony i łodzie","3922","6","0","0"),
("102860","Torby","3922","8","0","1"),
("102861","Walizki","3922","9","0","1"),
("102862","Śpiwory","3922","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("102863","Akcesoria plażowe","3922","12","0","0"),
("102864","Akcesoria turystyczne","3922","13","0","0"),
("102865","Materace","102863","2","0","1"),
("102866","Namioty plażowe i parawany","102863","3","0","1"),
("102867","Pozostałe","102863","6","0","1"),
("102869","Kompasy","102864","5","0","1"),
("102870","Kubki i termosy","102864","8","0","1"),
("102871","Kuchenki turystyczne","102864","9","0","1"),
("102872","Latarki","102864","10","0","1"),
("102874","Lodówki turystyczne","102864","12","0","1"),
("102875","Menażki i niezbędniki","102864","15","0","1"),
("102876","Noże i scyzoryki","102864","17","0","1"),
("102877","Pompki","102864","21","0","1"),
("102878","Saperki","102864","23","0","1"),
("102880","Pontony","102859","1","0","1"),
("102881","Łódki","102859","0","0","1"),
("102882","Silniki","102859","2","0","0"),
("102883","Pozostałe","102859","3","0","1"),
("102884","Pozostałe","102864","28","0","1"),
("104969","Hotele","63538","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("104970","Hostele","63538","8","0","1"),
("104971","Pensjonaty","63538","2","0","1"),
("104972","Domki letniskowe","63538","6","0","1"),
("104973","Kwatery, pokoje","63538","0","0","1"),
("105332","Deski sedesowe","54051","0","0","1"),
("105333","Dywaniki łazienkowe","54051","3","0","1"),
("105334","Dozowniki do mydła","54051","1","0","1"),
("105335","Kosze i pojemniki na pranie","54051","4","0","1"),
("105336","Kosze na śmieci","54051","5","0","1"),
("105337","Lustra","54051","7","0","1"),
("105338","Miski i miednice","54051","8","0","1"),
("105339","Mydelniczki","54051","9","0","1"),
("105340","Półki łazienkowe","54051","11","0","1"),
("105342","Suszarki do rąk","54051","12","0","1"),
("105343","Uchwyty i pojemniki na papier","54051","13","0","1"),
("105344","Wagi łazienkowe","54051","14","0","1"),
("105383","Latitude","4047","16","0","1"),
("105401","Giulietta","4030","14","0","1"),
("106447","Kubki i pojemniki łazienkowe","54051","6","0","1"),
("106448","Freemont","4035","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("106592","Panamera","8644","10","0","1"),
("106892","ASX","4042","1","0","1"),
("106999","HTC ChaCha","16618","3","0","1"),
("107004","Bold 9900","50971","4","0","1"),
("107009","N9","4978","99","0","1"),
("107011","X7","4978","107","0","1"),
("107012","E6","4978","89","0","1"),
("107014","500","4978","41","0","1"),
("107015","C2-02","4978","78","0","1"),
("107021","B2710 Solid","435","0","0","1"),
("107027","TXT Pro","5044","11","0","1"),
("107028","XPERIA Ray","5044","23","0","1"),
("107031","XPERIA Mini Pro","5044","20","0","1"),
("107052","iPhone 4S","48978","4","0","1"),
("108652","Digitizery","19285","2","0","1"),
("108653","Curve 9360","50971","9","0","1"),
("108660","100","4978","0","0","1"),
("108662","300","4978","26","0","1"),
("108667","C2-05","4978","79","0","1"),
("108676","Live","5044","32","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("108677","TXT","5044","10","0","1"),
("108678","XPERIA Neo V","5044","21","0","1"),
("108752","GL","4041","13","0","0"),
("108753","GLK","4041","17","0","1"),
("109652","Dla drobiu","1528","1","0","1"),
("109672","Akcesoria bramkarskie","13372","0","0","0"),
("109673","Pozostałe","109672","5","0","1"),
("109674","Bluzy","109672","0","0","1"),
("109675","Komplety","109672","1","0","1"),
("109676","Koszulki","109672","2","0","1"),
("109677","Rękawice","109672","3","0","1"),
("109678","Spodnie i spodenki","109672","4","0","1"),
("109915","V (2009-2017)","12711","4","0","1"),
("109916","Mk7 (2008-)","12509","6","0","1"),
("109953","Sony PS Vita","82326","21","0","0"),
("109954","Pozostałe","109953","7","0","1"),
("109955","Bijatyki","109953","0","0","1"),
("109956","Gry akcji","109953","1","0","1"),
("109957","Platformówki","109953","2","0","1"),
("109958","Przygodowe","109953","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("109959","Role Playing (RPG)","109953","4","0","1"),
("109960","Sportowe","109953","5","0","1"),
("109961","Wyścigi","109953","6","0","1"),
("110014","Monster High","11825","15","0","1"),
("110015","Ninjago","17865","28","0","1"),
("110016","JDLT","11823","6","0","1"),
("110017","Big","11823","0","0","1"),
("110020","Chemia basenowa","49844","2","0","1"),
("110021","Pokrywy, folie, plandeki","49844","3","0","1"),
("110022","Pompy i filtry","49844","4","0","1"),
("110023","Pozostałe","49844","5","0","1"),
("110132","Fitness","19626","0","0","0"),
("110133","Bieżnie","110132","0","0","1"),
("110134","Hantelki","110132","2","0","1"),
("110135","Masażery","110132","5","0","1"),
("110136","Maty","110132","7","0","1"),
("110137","Obciążniki","110132","8","0","1"),
("110138","Orbitreki","110132","9","0","1"),
("110139","Piłki do ćwiczeń","110132","11","0","1"),
("110140","Rowery treningowe","110132","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110141","Steppery","110132","14","0","1"),
("110142","Pasy wyszczuplające","110132","10","0","1"),
("110143","Twistery","110132","18","0","1"),
("110144","Wioślarze","110132","20","0","1"),
("110145","Siłownia","19626","3","0","0"),
("110146","Atlasy","110145","0","0","1"),
("110147","Drążki","110145","1","0","1"),
("110148","Hantle","110145","3","0","1"),
("110149","Gryfy","110145","2","0","1"),
("110150","Ławki","110145","5","0","0"),
("110151","Obciążenia","110145","6","0","1"),
("110152","Pasy kulturystyczne","110145","7","0","1"),
("110153","Sztangi","110145","9","0","1"),
("110154","Zestawy","110145","11","0","1"),
("110155","Ściągacze i stabilizatory","19626","5","0","1"),
("110156","Pozostałe","110132","21","0","1"),
("110157","Pozostałe","110145","12","0","1"),
("110158","Hula hop","110132","3","0","1"),
("110159","Skakanki","110132","13","0","1"),
("110160","Ekspandery","110132","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110161","Taśmy i gumy do ćwiczeń","110132","16","0","1"),
("110162","Komplety","19633","3","0","1"),
("110163","Kaski","16414","3","0","1"),
("110164","Ochraniacze","16414","6","0","1"),
("110165","Odzież","16414","7","0","0"),
("110166","Obuwie","16414","5","0","1"),
("110167","Bidony","16415","1","0","1"),
("110168","Koszyki na bidony","16415","5","0","1"),
("110169","Dzwonki","16415","3","0","1"),
("110170","Lusterka","16415","7","0","1"),
("110171","Plecaki rowerowe","16415","11","0","1"),
("110172","Bluzy","110165","0","0","1"),
("110173","Czapki","110165","1","0","1"),
("110174","Komplety","110165","3","0","1"),
("110175","Koszulki","110165","4","0","1"),
("110176","Kurtki","110165","5","0","1"),
("110177","Rękawiczki","110165","8","0","1"),
("110178","Skarpetki","110165","10","0","1"),
("110179","Spodenki","110165","11","0","1"),
("110180","Spodnie","110165","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110181","Pozostałe","110165","13","0","1"),
("110182","Okulary","16414","8","0","1"),
("110183","Maty i ochraniacze na materac","9017","3","0","1"),
("110184","Nakładki na schody","9018","3","0","1"),
("110185","Sztuczna trawa","9018","5","0","1"),
("110186","Wycieraczki","9018","6","0","1"),
("110187","Wykładziny PCV","9018","8","0","1"),
("110188","Wykładziny dywanowe","9018","7","0","1"),
("110190","Odzież ochronna i robocza","1536","44","0","1"),
("110191","Organizacja i przechowywanie narzędzi","1536","43","0","1"),
("110192","Dalmierze","26789","0","0","1"),
("110193","Kątowniki i kątomierze","26789","1","0","1"),
("110194","Wykrywacze","26789","5","0","1"),
("110195","Sauny i akcesoria","123","12","0","1"),
("110196","Szkatułki i kuferki","123","13","0","1"),
("110212","Czytniki","76253","0","0","1"),
("110213","Akcesoria","76253","1","0","1"),
("110214","Części i podzespoły","67093","2","0","1"),
("110219","Sandero","18118","6","0","0"),
("110220","Duster","18118","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110232","Oferty hurtowe","16696","4","0","0"),
("110233","Odzież robocza i BHP","16696","3","0","0"),
("110234","Odzież i galanteria","110232","3","0","0"),
("110235","Sprzęt AGD","110232","7","0","1"),
("110236","Budownictwo","110232","1","0","1"),
("110237","Gastronomia","110232","2","0","1"),
("110238","Przemysł drzewny","110232","5","0","1"),
("110239","Poligrafia","110232","4","0","1"),
("110240","Rolnictwo","110232","6","0","1"),
("110241","Automatyka przemysłowa","110232","0","0","1"),
("110242","Pozostałe","110232","8","0","1"),
("110243","Odzież używana","110234","2","0","1"),
("110244","Odzież nowa","110234","1","0","1"),
("110245","Galanteria","110234","0","0","1"),
("110246","Pozostałe","110233","2","0","1"),
("110247","Odzież","110233","1","0","0"),
("110248","Artykuły BHP","110233","0","0","0"),
("110249","Pozostałe","110248","8","0","1"),
("110250","Sprzęt Ppoż. ","110248","5","0","1"),
("110251","Tablice ostrzegawcze","110248","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110252","Ochronniki słuchu","110248","2","0","1"),
("110253","Kaski","110248","1","0","1"),
("110254","Apteczki","110248","0","0","1"),
("110255","Osłona twarzy","110248","3","0","0"),
("110256","Okulary i gogle","110255","1","0","1"),
("110257","Maski","110255","0","0","1"),
("110258","Rękawice","110247","7","0","1"),
("110259","Spodnie","110247","8","0","1"),
("110260","Bluzy i koszule","110247","0","0","1"),
("110261","Odzież wierzchnia","110247","6","0","1"),
("110262","Kombinezony","110247","3","0","1"),
("110263","Fartuchy i zapaski","110247","1","0","1"),
("110264","Nakrycia głowy","110247","4","0","1"),
("110265","Kamizelki","110247","2","0","1"),
("110266","Pozostałe","110247","9","0","1"),
("110272","Bold 9790","50971","3","0","1"),
("110277","200","4978","9","0","1"),
("110278","201","4978","10","0","1"),
("110280","710 Lumia","4978","64","0","1"),
("110281","800 Lumia","4978","67","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110283","XPERIA Arc S","5044","19","0","1"),
("110290","Obuwie","110247","5","0","1"),
("110589","Aparaty analogowe","8845","1","0","0"),
("110590","Pozostałe","110589","7","0","1"),
("110591","Kompaktowe","110589","0","0","0"),
("110592","Pozostałe","110591","10","0","1"),
("110593","Canon","110591","0","0","1"),
("110594","Fuji","110591","1","0","1"),
("110595","Kodak","110591","2","0","1"),
("110596","Minolta","110591","3","0","1"),
("110597","Olympus","110591","4","0","1"),
("110598","Pentax","110591","5","0","1"),
("110599","Praktica","110591","6","0","1"),
("110600","Premier","110591","7","0","1"),
("110601","Samsung","110591","8","0","1"),
("110602","Yashica","110591","9","0","1"),
("110603","Lustrzanki","110589","1","0","0"),
("110604","Pozostałe","110603","8","0","1"),
("110605","Canon","110603","0","0","1"),
("110606","Minolta","110603","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110607","Nikon","110603","2","0","1"),
("110608","Olympus","110603","3","0","1"),
("110609","Pentax","110603","4","0","1"),
("110610","Praktica","110603","5","0","1"),
("110611","Yashica/Contax","110603","6","0","1"),
("110612","Zenit","110603","7","0","1"),
("110613","Uszkodzone","110589","6","0","1"),
("110614","Średnio- i wielkoformatowe","110589","5","0","1"),
("110615","Jednorazowe","110589","2","0","1"),
("110616","Kolekcjonerskie","110589","3","0","1"),
("110617","Polaroid","110589","4","0","1"),
("110618","Aparaty cyfrowe","8845","2","0","0"),
("110619","Kompaktowe","110618","0","0","0"),
("110620","Kompaktowe z wymienną optyką","110618","1","0","0"),
("110621","Lustrzanki","110618","2","0","0"),
("110622","Uszkodzone","110618","3","0","1"),
("110623","Pozostałe","110619","13","0","1"),
("110625","Benq","110619","0","0","1"),
("110626","Canon","110619","1","0","1"),
("110628","Fuji","110619","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110630","Kodak","110619","3","0","1"),
("110631","Leica","110619","4","0","1"),
("110632","Medion","110619","5","0","1"),
("110634","Nikon","110619","6","0","1"),
("110635","Olympus","110619","7","0","1"),
("110636","Panasonic","110619","8","0","1"),
("110637","Pentax","110619","9","0","1"),
("110638","Polaroid","110619","10","0","1"),
("110642","Samsung","110619","11","0","1"),
("110643","Sony","110619","12","0","1"),
("110661","Pozostałe","110620","7","0","1"),
("110662","Olympus","110620","3","0","1"),
("110663","Panasonic","110620","4","0","1"),
("110664","Samsung","110620","5","0","1"),
("110665","Sony","110620","6","0","1"),
("110666","Pozostałe","110621","5","0","1"),
("110667","Canon","110621","0","0","1"),
("110668","Nikon","110621","1","0","1"),
("110669","Olympus","110621","2","0","1"),
("110670","Pentax","110621","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110671","Sony","110621","4","0","1"),
("110672","Zasilanie aparatów","8845","7","0","0"),
("110673","Zestawy","110672","5","0","1"),
("110674","Zasilacze","110672","4","0","1"),
("110675","Windery i batterypacki","110672","3","0","1"),
("110676","Ładowarki","110672","2","0","1"),
("110677","Baterie","110672","1","0","1"),
("110678","Akumulatory","110672","0","0","0"),
("110679","Dedykowane","110678","0","0","1"),
("110680","Uniwersalne","110678","1","0","1"),
("110696","Lampy błyskowe","8845","4","0","0"),
("110697","Akcesoria","110696","0","0","1"),
("110698","Urządzenia","110696","1","0","1"),
("110719","Nikon","110620","2","0","1"),
("110737","K13 (2010-2016)","12592","3","0","1"),
("110738","i40","4038","15","0","1"),
("110745","VIII (2008-)","12525","6","0","1"),
("110746","Passat CC","4055","21","0","1"),
("110748","XF","8641","5","0","0"),
("110749","Q3","4031","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110750","Beetle","4055","2","0","1"),
("110751","B7 (2010-2014)","12710","7","0","1"),
("110752","Mk3 (2010-)","12510","2","0","1"),
("110753","GT-R","4043","10","0","1"),
("110754","370 Z","4043","3","0","1"),
("110772","Biżuteria ślubna","19732","2","0","0"),
("110773","Obrączki","110772","4","0","1"),
("110774","Pierścionki zaręczynowe","110772","5","0","1"),
("110775","Pozostałe","110772","6","0","1"),
("110832","Range Rover Evoque","12405","5","0","1"),
("110833","Range Rover Sport","12405","6","0","0"),
("110879","Zastawa stołowa","123","18","0","0"),
("110880","Pozostałe","110879","16","0","1"),
("110881","Dzbanki, karafki i mleczniki","110879","1","0","1"),
("110882","Cukiernice","110879","0","0","1"),
("110883","Filiżanki","110879","2","0","1"),
("110884","Imbryki","110879","3","0","1"),
("110885","Kieliszki i pucharki","110879","4","0","1"),
("110886","Kubki","110879","5","0","1"),
("110887","Miski","110879","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110888","Patery","110879","8","0","1"),
("110889","Salaterki i półmiski","110879","9","0","1"),
("110890","Serwisy","110879","10","0","1"),
("110895","Sosjerki i dipówki","110879","11","0","1"),
("110896","Szklanki i kufle","110879","12","0","1"),
("110897","Sztućce","110879","13","0","0"),
("110898","Noże","110897","2","0","1"),
("110899","Łyżki","110897","0","0","1"),
("110900","Łyżeczki","110897","3","0","1"),
("110901","Widelce","110897","1","0","1"),
("110902","Komplety sztućców","110897","5","0","1"),
("110903","Pałeczki","110897","6","0","1"),
("110904","Talerze","110879","14","0","1"),
("110905","Wazy","110879","15","0","1"),
("110907","Kwietniki","9317","2","0","1"),
("110908","Magnesy na lodówkę","9317","5","0","1"),
("110909","Naklejki ścienne","9317","6","0","1"),
("110910","Ozdobne zawieszki","9317","8","0","1"),
("110911","Obrazki i obrazy","9317","7","0","1"),
("110912","Plakaty","9317","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110913","Ramki do zdjęć","9317","10","0","1"),
("110914","Lampiony i latarnie","9317","3","0","1"),
("110915","Wazony","9317","12","0","1"),
("110916","Blachy i formy do pieczenia","5328","2","0","1"),
("110917","Akcesoria kuchenne","5328","1","0","0"),
("110918","Otwieracze i korkociągi","110917","3","0","1"),
("110919","Trzepaczki","110917","7","0","1"),
("110920","Łopatki i łyżki kuchenne ","110917","1","0","1"),
("110921","Tłuczki i szczypce","110917","6","0","1"),
("110922","Tarki i szatkownice","110917","5","0","1"),
("110923","Obieraczki i drylownice","110917","2","0","1"),
("110924","Wyciskarki i praski","110917","8","0","1"),
("110925","Pozostałe","110917","9","0","1"),
("110926","Czajniki i imbryki","5328","4","0","1"),
("110927","Parowary","15978","2","0","1"),
("110928","Podgrzewacze do potraw","15978","4","0","1"),
("110929","Sokowniki","15978","5","0","1"),
("110930","Szybkowary","15978","6","0","1"),
("110931","Woki","15978","7","0","1"),
("110932","Miski","5328","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("110933","Maszynki i roboty kuchenne","5328","8","0","1"),
("110935","Naczynia żaroodporne","5328","11","0","1"),
("110936","Ostrzałki do noży","15977","3","0","1"),
("110937","Przechowywanie żywności","5328","14","0","1"),
("110938","Solniczki i pieprzniczki","5328","16","0","1"),
("110939","Stolnice i wałki","5328","17","0","1"),
("110940","Tace i stoliki","5328","18","0","1"),
("110941","Termosy","5328","20","0","1"),
("110942","Termometry i minutniki","5328","19","0","1"),
("110943","Wagi i miarki kuchenne","5328","21","0","1"),
("110944","Zaparzacze i kawiarki","5328","22","0","1"),
("110945","Ręczniczki, rękawice i fartuchy","5328","23","0","1"),
("110949","Garnki","15978","1","0","1"),
("110950","Patelnie","15978","3","0","1"),
("110951","Pozostałe","110897","8","0","1"),
("111072","Dekoracje cukiernicze, dodatki spożywcze","73973","2","0","0"),
("111073","Aromaty","111072","1","0","1"),
("111074","Barwniki","111072","2","0","1"),
("111075","Dekoracje cukiernicze","111072","3","0","1"),
("111076","Dodatki spożywcze","111072","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111077","Pozostałe","111072","5","0","1"),
("111078","Nabiał","73973","8","0","0"),
("111079","Jaja","111078","0","0","1"),
("111080","Napoje mleczne","111078","1","0","1"),
("111081","Tłuszcze","111078","4","0","1"),
("111082","Sery","111078","3","0","0"),
("111083","Żółte","111082","1","0","1"),
("111084","Białe","111082","0","0","1"),
("111085","Podpuszczka i dodatki","111078","2","0","1"),
("111086","Pozostałe","111078","5","0","1"),
("111087","Produkty sypkie","73973","11","0","0"),
("111088","Cukier","111087","0","0","0"),
("111089","Cukier","111088","0","0","1"),
("111090","Ksylitol","111088","1","0","1"),
("111091","Pozostałe","111088","2","0","1"),
("111092","Słodziki","111087","1","0","1"),
("111093","Kasze i ryż","111087","2","0","1"),
("111094","Makarony","111087","3","0","1"),
("111095","Mieszanki chlebowe i mąka","111087","4","0","1"),
("111096","Musli, płatki, otręby","111087","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111097","Pozostałe","111087","6","0","1"),
("111393","Akcesoria meblowe","64480","0","0","1"),
("111610","HTC One X","16618","35","0","1"),
("111611","HTC One V","16618","34","0","1"),
("111612","HTC One S","16618","33","0","1"),
("111613","302","4978","28","0","1"),
("111633","Lampiony","74176","4","0","1"),
("111634","Suknie ślubne","74169","5","0","1"),
("111635","Buty ślubne","74169","0","0","1"),
("111636","Dodatki damskie","74169","2","0","0"),
("111637","Dodatki męskie","74169","3","0","1"),
("111638","Pozostałe","111636","5","0","1"),
("111639","Bolerka i etole","111636","0","0","1"),
("111640","Rękawiczki","111636","1","0","1"),
("111641","Stroiki","111636","2","0","1"),
("111642","Welony","111636","3","0","1"),
("111643","Komplety","111636","4","0","1"),
("111646","Ocieplacze (getry)","1487","8","0","1"),
("111693","Walentynki","98316","0","0","1"),
("111694","Projekty domów","20782","15","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111695","Gotowe domy bez działki","20782","16","0","0"),
("111696","Podkładki i maty","68686","2","0","1"),
("111712","Pojazdy elektryczne","4079","4","0","1"),
("111713","Pozostałe","111695","3","0","1"),
("111714","Domy modułowe","111695","0","0","1"),
("111715","Domy z bali","111695","1","0","1"),
("111716","Domy kanadyjskie","111695","2","0","1"),
("111717","Pozostałe","111694","5","0","1"),
("111718","Budynki mieszkalne","111694","0","0","1"),
("111719","Budynki mieszkalno-użytkowe","111694","1","0","1"),
("111720","Budynki użytkowe","111694","2","0","1"),
("111721","Garaże, wiaty","111694","3","0","1"),
("111722","Obiekty małej architektury","111694","4","0","1"),
("111773","Przedszkole","66820","0","0","1"),
("111774","Edukacja wczesnoszkolna","66820","1","0","1"),
("111775","Szkoła podstawowa","66820","2","0","0"),
("111776","Gimnazjum","66820","3","0","0"),
("111777","Szkoła ponadgimnazjalna","66820","4","0","0"),
("111778","Pozostałe","111775","16","0","1"),
("111779","Zestawy mieszane","111775","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111780","Języki obce","111775","8","0","1"),
("111781","Religia, Etyka","111775","13","0","1"),
("111782","Plastyka","111775","11","0","1"),
("111783","Muzyka","111775","10","0","1"),
("111784","Informatyka, Technika","111775","6","0","1"),
("111785","Historia","111775","5","0","1"),
("111786","Przyroda","111775","12","0","1"),
("111787","Matematyka","111775","9","0","1"),
("111788","Język polski","111775","7","0","1"),
("111789","Pozostałe","111776","14","0","1"),
("111790","Zestawy mieszane","111776","13","0","1"),
("111791","Języki obce","111776","12","0","1"),
("111792","Religia, Etyka","111776","11","0","1"),
("111793","Plastyka","111776","10","0","1"),
("111794","Muzyka","111776","9","0","1"),
("111795","Informatyka, Technika","111776","8","0","1"),
("111796","KOSS, WOS","111776","7","0","1"),
("111797","Fizyka z astronomią","111776","6","0","1"),
("111798","Chemia","111776","5","0","1"),
("111799","Geografia","111776","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111800","Historia","111776","3","0","1"),
("111801","Biologia","111776","2","0","1"),
("111802","Matematyka","111776","1","0","1"),
("111803","Język polski","111776","0","0","1"),
("111804","Pozostałe","111777","15","0","1"),
("111805","Zestawy mieszane","111777","14","0","1"),
("111806","Języki obce","111777","13","0","1"),
("111807","Przedmioty zawodowe","111777","12","0","1"),
("111808","Religia, Etyka","111777","11","0","1"),
("111809","Plastyka","111777","10","0","1"),
("111810","Muzyka","111777","9","0","1"),
("111811","Informatyka, Technika","111777","8","0","1"),
("111812","KOSS, WOS","111777","7","0","1"),
("111813","Fizyka z astronomią","111777","6","0","1"),
("111814","Chemia","111777","5","0","1"),
("111815","Geografia","111777","4","0","1"),
("111816","Historia","111777","3","0","1"),
("111817","Biologia","111777","2","0","1"),
("111818","Matematyka","111777","1","0","1"),
("111819","Język polski ","111777","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111834","F12/13 (2011-) ","18084","2","0","1"),
("111852","Akcesoria dekarskie  ","1521","0","0","1"),
("111853","Rynny i rury spustowe","1521","5","0","1"),
("111854","Więźby i podbitki ","1521","6","0","1"),
("111855","Gniazda","1523","3","0","1"),
("111856","Przedłużacze","1523","6","0","1"),
("111857","Zawory","46124","5","0","1"),
("111858","Węże","46124","3","0","1"),
("111859","Syfony","46124","2","0","1"),
("111860","Panele i zestawy prysznicowe","46122","6","0","1"),
("111861","Bidety","46122","1","0","1"),
("111862","Deski sedesowe","46122","2","0","1"),
("111863","Muszle","46122","4","0","1"),
("111864","Zestawy","46122","13","0","1"),
("111865","Ogrzewanie","1520","10","0","0"),
("111866","Pozostałe","111865","9","0","1"),
("111867","Akcesoria do kotłów i pieców","111865","0","0","1"),
("111868","Grzejniki","111865","2","0","1"),
("111869","Kotły i piece","111865","3","0","1"),
("111870","Pompy i filtry","111865","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("111876","Wentylatory","46099","6","0","1"),
("111881","Obudowy kominkowe","1525","4","0","1"),
("111882","Opał","1525","5","0","1"),
("111883","Wkłady kominkowe ","1525","8","0","1"),
("111884","Piece wolnostojące","1525","6","0","1"),
("111885","Biokominki","1525","2","0","1"),
("111889","Pozostałe","68626","3","0","1"),
("111890","Jednostki centralne","68626","1","0","1"),
("111891","Węże ssące","68626","2","0","1"),
("111892","Akcesoria","15957","0","0","1"),
("111893","Przęsła","15957","4","0","1"),
("111894","Siatka i panele ogrodzeniowe","15957","5","0","1"),
("111895","Akcesoria okienne","15959","0","0","1"),
("111896","Grunty","1527","3","0","1"),
("111897","Tynki","1527","14","0","1"),
("111898","Fugi","1527","2","0","1"),
("111992","Moxie Girlz","11825","16","0","1"),
("111993","Nancy","11825","17","0","1"),
("111994","Friends","17865","15","0","1"),
("112112","Majtki","75993","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112121","Podkoszulki","75993","12","0","1"),
("112212","C216 (2006-2013)","12739","2","0","1"),
("112252","Sporty ekstremalne","3919","7","0","0"),
("112253","Lotnictwo","112252","0","0","0"),
("112254","Literatura","112253","0","0","1"),
("112255","Odzież","112253","2","0","1"),
("112256","Pozostałe","112253","3","0","1"),
("112257","Paralotniarstwo","112252","1","0","0"),
("112258","Literatura","112257","0","0","1"),
("112259","Paralotnie","112257","1","0","1"),
("112260","Sprzęt pomiarowy","112257","2","0","1"),
("112261","Uprzęże","112257","3","0","1"),
("112262","Pozostałe","112257","4","0","1"),
("112263","Spadochroniarstwo","112252","2","0","0"),
("112264","Spadochrony","112263","1","0","1"),
("112265","Kaski","112263","0","0","1"),
("112266","Pozostałe","112263","2","0","1"),
("112267","Wspinaczka","112252","3","0","0"),
("112268","Kaski","112267","0","0","1"),
("112269","Obuwie","112267","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112270","Odzież","112267","2","0","0"),
("112271","Sprzęt wspinaczkowy","112267","3","0","0"),
("112273","Pozostałe","112267","5","0","1"),
("112275","Karabinki","112271","5","0","1"),
("112276","Kości, haki, śruby","112271","6","0","1"),
("112277","Liny i linki","112271","7","0","0"),
("112278","Magnezja i woreczki","112271","9","0","1"),
("112280","Uprzęże","112271","14","0","1"),
("112281","Pozostałe","112271","15","0","1"),
("112282","Obuwie","3922","0","0","0"),
("112284","Wysokogórskie","112282","2","0","1"),
("112285","Pozostałe","112282","6","0","1"),
("112286","Odzież","3922","1","0","0"),
("112287","Czapki","112286","3","0","1"),
("112290","Kurtki","112286","9","0","1"),
("112291","Rękawice","112286","13","0","1"),
("112292","Skarpety","112286","14","0","1"),
("112293","Spodnie","112286","16","0","1"),
("112294","Pozostałe","112286","18","0","1"),
("112295","Przewodniki i mapy","3922","10","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112296","Albumy","112295","0","0","1"),
("112297","Literatura","112295","1","0","1"),
("112298","Mapy","112295","2","0","1"),
("112299","Przewodniki","112295","3","0","1"),
("112300","Pozostałe","112295","4","0","1"),
("112301","Pozostałe","112252","4","0","1"),
("112302","Jeździectwo","13408","5","0","0"),
("112303","Akcesoria","112302","0","0","0"),
("112304","Derki","112303","1","0","1"),
("112305","Kiełzna i wędzidła","112303","2","0","1"),
("112306","Ochraniacze i owijki","112303","3","0","1"),
("112307","Ogłowia","112303","4","0","1"),
("112308","Pielęgnacja i kosmetyka","112303","5","0","1"),
("112309","Praca z koniem","112303","6","0","1"),
("112310","Pozostałe","112303","8","0","1"),
("112311","Siodła","112303","7","0","1"),
("112312","Czapraki","112303","0","0","1"),
("112313","Gadżety","112302","1","0","1"),
("112314","Literatura","112302","2","0","1"),
("112315","Odzież","112302","4","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112316","Bryczesy","112315","0","0","1"),
("112318","Czapsy","112315","1","0","1"),
("112319","Kamizelki","112315","2","0","1"),
("112320","Koszulki i koszule","112315","3","0","1"),
("112321","Kurtki","112315","4","0","1"),
("112322","Rękawiczki","112315","5","0","1"),
("112323","Toczki i kaski","112315","6","0","1"),
("112324","Pozostałe","112315","7","0","1"),
("112325","Powozy i sanie","112302","6","0","1"),
("112326","Pozostałe","112302","7","0","1"),
("112327","Sporty z psami","13408","8","0","0"),
("112328","Sprzęt i akcesoria","112327","0","0","1"),
("112329","Pozostałe","112327","1","0","1"),
("112365","Siatki i bramki","13372","8","0","1"),
("112404","Modecom","67094","10","0","1"),
("112492","D4 (2010-)","12431","2","0","1"),
("112512","IX (2011-)","12526","7","0","1"),
("112554","Akcesoria do karniszy","9016","0","0","1"),
("112555","Moskitiery","9016","4","0","1"),
("112556","Folie okienne","9016","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112612","Zupy","74056","4","0","1"),
("112613","Ciasta","74056","0","0","1"),
("112614","Kluski i pierogi","74056","3","0","1"),
("112615","Dania mięsne","74056","1","0","1"),
("112616","Dania warzywne","74056","2","0","1"),
("112617","Pozostałe","74056","5","0","1"),
("112618","Akcesoria","111072","0","0","1"),
("112619","Oliwy i oleje, sosy","73973","10","0","0"),
("112620","Pozostałe","112619","8","0","1"),
("112621","Ketchupy","112619","0","0","1"),
("112622","Musztardy","112619","2","0","1"),
("112623","Majonezy","112619","1","0","1"),
("112624","Oliwy","112619","5","0","1"),
("112625","Oleje","112619","4","0","1"),
("112626","Przeciery i koncentraty","112619","6","0","1"),
("112627","Sosy i dressingi","112619","7","0","1"),
("112628","Octy","112619","3","0","1"),
("112629","Napoje i Akcesoria","73973","9","0","0"),
("112630","Akcesoria","112629","0","0","1"),
("112631","Ekstrakty i koncentraty","112629","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112632","Dodatki do alkoholu","112629","1","0","1"),
("112633","Napoje gazowane i woda","112629","4","0","1"),
("112634","Napoje w proszku","112629","5","0","1"),
("112635","Soki","112629","6","0","1"),
("112636","Syropy","112629","7","0","1"),
("112637","Zaprawki","112629","8","0","1"),
("112638","Pozostałe","112629","9","0","1"),
("112639","Kakao","112629","3","0","1"),
("112640","Bakalie i konfitury","73973","0","0","0"),
("112641","Bakalie","112640","0","0","1"),
("112642","Dżemy i konfitury","112640","1","0","1"),
("112643","Przetwory owocowe","112640","3","0","1"),
("112644","Przetwory warzywne","112640","4","0","1"),
("112645","Pestki i nasiona","112640","2","0","1"),
("112646","Pozostałe","112640","5","0","1"),
("112692","C7 (2011-)","12430","3","0","1"),
("112712","Pozostałe","68632","19","0","1"),
("112713","Blaty","68632","0","0","1"),
("112714","Cargo i kosze","68632","1","0","1"),
("112715","Hamulce i ograniczniki","68632","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112716","Kółka","68632","5","0","1"),
("112717","Nogi i nóżki","68632","7","0","1"),
("112718","Ociekarki","68632","8","0","1"),
("112719","Oświetlenie","68632","10","0","1"),
("112720","Podnośniki","68632","12","0","1"),
("112721","Prowadnice","68632","13","0","1"),
("112722","Szuflady","68632","15","0","1"),
("112723","Środki pielęgnujące i naprawcze","68632","16","0","1"),
("112724","Uchwyty","68632","17","0","1"),
("112725","Zawiasy","68632","18","0","1"),
("112726","Hokery","1510","0","0","1"),
("112727","Kredensy i witryny","1510","1","0","1"),
("112728","Krzesła","1510","2","0","1"),
("112729","Półki","1510","3","0","1"),
("112730","Stołki i taborety","1510","4","0","1"),
("112731","Stoły kuchenne","1510","5","0","1"),
("112732","Zestawy mebli kuchennych","1510","7","0","1"),
("112733","Wieszaki","1514","6","0","1"),
("112734","Półki","1514","4","0","1"),
("112735","Komody","1515","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112736","Szafy","1515","12","0","1"),
("112737","Krzesła","1515","4","0","1"),
("112738","Stoły","1515","9","0","1"),
("112739","Mieszkania na sprzedaż","20782","0","0","0"),
("112740","Domy na sprzedaż","20782","1","0","0"),
("112741","Działki na sprzedaż","20782","2","0","0"),
("112742","Lokale i obiekty użytkowe na sprzedaż","20782","3","0","0"),
("112743","Magazyny i hale na sprzedaż","20782","4","0","0"),
("112744","Garaże na sprzedaż","20782","5","0","0"),
("112745","Mieszkania do wynajęcia","20782","6","0","0"),
("112746","Domy do wynajęcia","20782","7","0","0"),
("112747","Pokoje do wynajęcia","20782","8","0","0"),
("112748","Działki do wynajęcia","20782","9","0","0"),
("112749","Lokale i obiekty użytkowe do wynajęcia","20782","10","0","0"),
("112750","Magazyny i hale do wynajęcia","20782","11","0","0"),
("112751","Garaże i miejsca postojowe do wynajęcia","20782","12","0","0"),
("112772","Dolnośląskie","112744","0","0","0"),
("112773","Kujawsko-pomorskie","112744","1","0","0"),
("112774","Lubelskie","112744","2","0","0"),
("112775","Lubuskie","112744","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112776","Łódzkie","112744","4","0","0"),
("112777","Małopolskie","112744","5","0","0"),
("112778","Mazowieckie","112744","6","0","0"),
("112779","Opolskie","112744","7","0","0"),
("112780","Podkarpackie","112744","8","0","0"),
("112781","Podlaskie","112744","9","0","0"),
("112782","Pomorskie","112744","10","0","0"),
("112783","Śląskie","112744","11","0","0"),
("112784","Świętokrzyskie","112744","12","0","0"),
("112785","Warmińsko-mazurskie","112744","13","0","0"),
("112786","Wielkopolskie","112744","14","0","0"),
("112787","Zachodniopomorskie","112744","15","0","0"),
("112788","Jelenia Góra","112772","0","0","0"),
("112789","Legnica","112772","1","0","1"),
("112790","Wałbrzych","112772","2","0","1"),
("112791","Wrocław","112772","3","0","0"),
("112792","Pow. bolesławiecki","112772","4","0","1"),
("112793","Pow. dzierżoniowski","112772","5","0","1"),
("112794","Pow. głogowski","112772","6","0","1"),
("112795","Pow. górowski","112772","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112796","Pow. jaworski","112772","8","0","1"),
("112797","Pow. jeleniogórski","112772","9","0","1"),
("112798","Pow. kamiennogórski","112772","10","0","1"),
("112799","Pow. kłodzki","112772","11","0","1"),
("112800","Pow. legnicki","112772","12","0","1"),
("112801","Pow. lubański","112772","13","0","1"),
("112802","Pow. lubiński","112772","14","0","1"),
("112803","Pow. lwówecki","112772","15","0","1"),
("112804","Pow. milicki","112772","16","0","1"),
("112805","Pow. oleśnicki","112772","17","0","1"),
("112806","Pow. oławski","112772","18","0","1"),
("112807","Pow. polkowicki","112772","19","0","1"),
("112808","Pow. strzeliński","112772","20","0","1"),
("112809","Pow. średzki","112772","21","0","1"),
("112810","Pow. świdnicki","112772","22","0","1"),
("112811","Pow. trzebnicki","112772","23","0","1"),
("112812","Pow. wałbrzyski","112772","24","0","1"),
("112813","Pow. wołowski","112772","25","0","1"),
("112814","Pow. wrocławski","112772","26","0","1"),
("112815","Pow. ząbkowicki","112772","27","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112816","Pow. zgorzelecki","112772","28","0","1"),
("112817","Pow. złotoryjski","112772","29","0","1"),
("112818","Bydgoszcz","112773","0","0","0"),
("112819","Grudziądz","112773","1","0","1"),
("112820","Toruń","112773","2","0","0"),
("112821","Włocławek","112773","3","0","1"),
("112822","Pow. aleksandrowski","112773","4","0","1"),
("112823","Pow. brodnicki","112773","5","0","1"),
("112824","Pow. bydgoski","112773","6","0","1"),
("112825","Pow. chełmiński","112773","7","0","1"),
("112826","Pow. golubsko-dobrzyński","112773","8","0","1"),
("112827","Pow. grudziądzki","112773","9","0","1"),
("112828","Pow. inowrocławski","112773","10","0","1"),
("112829","Pow. lipnowski","112773","11","0","1"),
("112830","Pow. mogileński","112773","12","0","1"),
("112831","Pow. nakielski","112773","13","0","1"),
("112832","Pow. radziejowski","112773","14","0","1"),
("112833","Pow. rypiński","112773","15","0","1"),
("112834","Pow. sępoleński","112773","16","0","1"),
("112835","Pow. świecki","112773","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112836","Pow. toruński","112773","18","0","1"),
("112837","Pow. tucholski","112773","19","0","1"),
("112838","Pow. wąbrzeski","112773","20","0","1"),
("112839","Pow. włocławski","112773","21","0","1"),
("112840","Pow. żniński","112773","22","0","1"),
("112841","Biała Podlaska","112774","0","0","1"),
("112842","Chełm","112774","1","0","1"),
("112843","Lublin","112774","2","0","0"),
("112844","Zamość","112774","3","0","1"),
("112845","Pow. bialski","112774","4","0","1"),
("112846","Pow. biłgorajski","112774","5","0","1"),
("112847","Pow. chełmski","112774","6","0","1"),
("112848","Pow. hrubieszowski","112774","7","0","1"),
("112849","Pow. janowski","112774","8","0","1"),
("112850","Pow. krasnostawski","112774","9","0","1"),
("112851","Pow. kraśnicki","112774","10","0","1"),
("112852","Pow. lubartowski","112774","11","0","1"),
("112853","Pow. lubelski","112774","12","0","1"),
("112854","Pow. łęczyński","112774","13","0","1"),
("112855","Pow. łukowski","112774","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112856","Pow. opolski","112774","15","0","1"),
("112857","Pow. parczewski","112774","16","0","1"),
("112858","Pow. puławski","112774","17","0","1"),
("112859","Pow. radzyński","112774","18","0","1"),
("112860","Pow. rycki","112774","19","0","1"),
("112861","Pow. świdnicki","112774","20","0","1"),
("112862","Pow. tomaszowski","112774","21","0","1"),
("112863","Pow. włodawski","112774","22","0","1"),
("112864","Pow. zamojski","112774","23","0","1"),
("112865","Gorzów Wielkopolski","112775","0","0","1"),
("112866","Zielona Góra","112775","1","0","1"),
("112867","Pow. gorzowski","112775","2","0","1"),
("112868","Pow. krośnieński","112775","3","0","1"),
("112869","Pow. międzyrzecki","112775","4","0","1"),
("112870","Pow. nowosolski","112775","5","0","1"),
("112871","Pow. słubicki","112775","6","0","1"),
("112872","Pow. strzelecko-drezdenecki","112775","7","0","1"),
("112873","Pow. sulęciński","112775","8","0","1"),
("112874","Pow. świebodziński","112775","9","0","1"),
("112875","Pow. wschowski","112775","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112876","Pow. zielonogórski","112775","11","0","1"),
("112877","Pow. żagański","112775","12","0","1"),
("112878","Pow. żarski","112775","13","0","1"),
("112879","Łódź","112776","0","0","0"),
("112880","Piotrków Trybunalski","112776","1","0","1"),
("112881","Skierniewice","112776","2","0","1"),
("112882","Pow. bełchatowski","112776","3","0","1"),
("112883","Pow. brzeziński","112776","4","0","1"),
("112884","Pow. kutnowski","112776","5","0","1"),
("112885","Pow. łaski","112776","6","0","1"),
("112886","Pow. łęczycki","112776","7","0","1"),
("112887","Pow. łowicki","112776","8","0","1"),
("112888","Pow. łódzki wschodni","112776","9","0","1"),
("112889","Pow. opoczyński","112776","10","0","1"),
("112890","Pow. pabianicki","112776","11","0","1"),
("112891","Pow. pajęczański","112776","12","0","1"),
("112892","Pow. piotrkowski","112776","13","0","1"),
("112893","Pow. poddębicki","112776","14","0","1"),
("112894","Pow. radomszczański","112776","15","0","1"),
("112895","Pow. rawski","112776","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112896","Pow. sieradzki","112776","17","0","1"),
("112897","Pow. skierniewicki","112776","18","0","1"),
("112898","Pow. tomaszowski","112776","19","0","1"),
("112899","Pow. wieluński","112776","20","0","1"),
("112900","Pow. wieruszowski","112776","21","0","1"),
("112901","Pow. zduńskowolski","112776","22","0","1"),
("112902","Pow. zgierski","112776","23","0","1"),
("112903","Kraków","112777","0","0","0"),
("112904","Nowy Sącz","112777","1","0","1"),
("112905","Tarnów","112777","2","0","1"),
("112906","Pow. bocheński","112777","3","0","1"),
("112907","Pow. brzeski","112777","4","0","1"),
("112908","Pow. chrzanowski","112777","5","0","1"),
("112909","Pow. dąbrowski","112777","6","0","1"),
("112910","Pow. gorlicki","112777","7","0","1"),
("112911","Pow. krakowski","112777","8","0","1"),
("112912","Pow. limanowski","112777","9","0","1"),
("112913","Pow. miechowski","112777","10","0","1"),
("112914","Pow. myślenicki","112777","11","0","1"),
("112915","Pow. nowosądecki","112777","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112916","Pow. nowotarski","112777","13","0","1"),
("112917","Pow. olkuski","112777","14","0","1"),
("112918","Pow. oświęcimski","112777","15","0","1"),
("112919","Pow. proszowicki","112777","16","0","1"),
("112920","Pow. suski","112777","17","0","1"),
("112921","Pow. tarnowski","112777","18","0","1"),
("112922","Pow. tatrzański","112777","19","0","1"),
("112923","Pow. wadowicki","112777","20","0","1"),
("112924","Pow. wielicki","112777","21","0","1"),
("112925","Ostrołęka","112778","0","0","1"),
("112926","Płock","112778","1","0","1"),
("112927","Radom","112778","2","0","1"),
("112928","Siedlce","112778","3","0","1"),
("112929","Warszawa","112778","4","0","0"),
("112930","Pow. białobrzeski","112778","5","0","1"),
("112931","Pow. ciechanowski","112778","6","0","1"),
("112932","Pow. garwoliński","112778","7","0","1"),
("112933","Pow. gostyniński","112778","8","0","1"),
("112934","Pow. grodziski","112778","9","0","1"),
("112935","Pow. grójecki","112778","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112936","Pow. kozienicki","112778","11","0","1"),
("112937","Pow. legionowski","112778","12","0","1"),
("112938","Pow. lipski","112778","13","0","1"),
("112939","Pow. łosicki","112778","14","0","1"),
("112940","Pow. makowski","112778","15","0","1"),
("112941","Pow. miński","112778","16","0","1"),
("112942","Pow. mławski","112778","17","0","1"),
("112943","Pow. nowodworski","112778","18","0","1"),
("112944","Pow. ostrołęcki","112778","19","0","1"),
("112945","Pow. ostrowski","112778","20","0","1"),
("112946","Pow. otwocki","112778","21","0","1"),
("112947","Pow. piaseczyński","112778","22","0","0"),
("112948","Pow. płocki","112778","23","0","1"),
("112949","Pow. płoński","112778","24","0","1"),
("112950","Pow. pruszkowski","112778","25","0","0"),
("112951","Pow. przasnyski","112778","26","0","1"),
("112952","Pow. przysuski","112778","27","0","1"),
("112953","Pow. pułtuski","112778","28","0","1"),
("112954","Pow. radomski","112778","29","0","1"),
("112955","Pow. siedlecki","112778","30","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112956","Pow. sierpecki","112778","31","0","1"),
("112957","Pow. sochaczewski","112778","32","0","1"),
("112958","Pow. sokołowski","112778","33","0","1"),
("112959","Pow. szydłowiecki","112778","34","0","1"),
("112960","Pow. warszawski zachodni","112778","35","0","1"),
("112961","Pow. węgrowski","112778","36","0","1"),
("112962","Pow. wołomiński","112778","37","0","0"),
("112963","Pow. wyszkowski","112778","38","0","1"),
("112964","Pow. zwoleński","112778","39","0","1"),
("112965","Pow. żuromiński","112778","40","0","1"),
("112966","Pow. żyrardowski","112778","41","0","1"),
("112967","Opole","112779","0","0","0"),
("112968","Pow. brzeski","112779","1","0","1"),
("112969","Pow. głubczycki","112779","2","0","1"),
("112970","Pow. kędzierzyńsko-kozielski","112779","3","0","1"),
("112971","Pow. kluczborski","112779","4","0","1"),
("112972","Pow. krapkowicki","112779","5","0","1"),
("112973","Pow. namysłowski","112779","6","0","1"),
("112974","Pow. nyski","112779","7","0","1"),
("112975","Pow. oleski","112779","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112976","Pow. opolski","112779","9","0","1"),
("112977","Pow. prudnicki","112779","10","0","1"),
("112978","Pow. strzelecki","112779","11","0","1"),
("112979","Krosno","112780","0","0","1"),
("112980","Przemyśl","112780","1","0","1"),
("112981","Rzeszów","112780","2","0","0"),
("112982","Tarnobrzeg","112780","3","0","1"),
("112983","Pow. bieszczadzki","112780","4","0","1"),
("112984","Pow. brzozowski","112780","5","0","1"),
("112985","Pow. dębicki","112780","6","0","1"),
("112986","Pow. jarosławski","112780","7","0","1"),
("112987","Pow. jasielski","112780","8","0","1"),
("112988","Pow. kolbuszowski","112780","9","0","1"),
("112989","Pow. krośnieński","112780","10","0","1"),
("112990","Pow. leski","112780","11","0","1"),
("112991","Pow. leżajski","112780","12","0","1"),
("112992","Pow. lubaczowski","112780","13","0","1"),
("112993","Pow. łańcucki","112780","14","0","1"),
("112994","Pow. mielecki","112780","15","0","1"),
("112995","Pow. niżański","112780","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("112996","Pow. przemyski","112780","17","0","1"),
("112997","Pow. przeworski","112780","18","0","1"),
("112998","Pow. ropczycko-sędziszowski","112780","19","0","1"),
("112999","Pow. rzeszowski","112780","20","0","1"),
("113000","Pow. sanocki","112780","21","0","1"),
("113001","Pow. stalowowolski","112780","22","0","1"),
("113002","Pow. strzyżowski","112780","23","0","1"),
("113003","Pow. tarnobrzeski","112780","24","0","1"),
("113004","Białystok","112781","0","0","0"),
("113005","Łomża","112781","1","0","1"),
("113006","Suwałki","112781","2","0","1"),
("113007","Pow. augustowski","112781","3","0","1"),
("113008","Pow. białostocki","112781","4","0","1"),
("113009","Pow. bielski","112781","5","0","1"),
("113010","Pow. grajewski","112781","6","0","1"),
("113011","Pow. hajnowski","112781","7","0","1"),
("113012","Pow. kolneński","112781","8","0","1"),
("113013","Pow. łomżyński","112781","9","0","1"),
("113014","Pow. moniecki","112781","10","0","1"),
("113015","Pow. sejneński","112781","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113016","Pow. siemiatycki","112781","12","0","1"),
("113017","Pow. sokólski","112781","13","0","1"),
("113018","Pow. suwalski","112781","14","0","1"),
("113019","Pow. wysokomazowiecki","112781","15","0","1"),
("113020","Pow. zambrowski","112781","16","0","1"),
("113021","Gdańsk","112782","0","0","0"),
("113022","Gdynia","112782","1","0","0"),
("113023","Słupsk","112782","2","0","1"),
("113024","Sopot","112782","3","0","0"),
("113025","Pow. bytowski","112782","4","0","1"),
("113026","Pow. chojnicki","112782","5","0","1"),
("113027","Pow. człuchowski","112782","6","0","1"),
("113028","Pow. gdański","112782","7","0","1"),
("113029","Pow. kartuski","112782","8","0","1"),
("113030","Pow. kościerski","112782","9","0","1"),
("113031","Pow. kwidzyński","112782","10","0","1"),
("113032","Pow. lęborski","112782","11","0","1"),
("113033","Pow. malborski","112782","12","0","1"),
("113034","Pow. nowodworski","112782","13","0","1"),
("113035","Pow. pucki","112782","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113036","Pow. słupski","112782","15","0","1"),
("113037","Pow. starogardzki","112782","16","0","1"),
("113038","Pow. sztumski","112782","17","0","1"),
("113039","Pow. tczewski","112782","18","0","1"),
("113040","Pow. wejherowski","112782","19","0","0"),
("113041","Bielsko-Biała","112783","0","0","0"),
("113042","Bytom","112783","1","0","0"),
("113043","Chorzów","112783","2","0","1"),
("113044","Częstochowa","112783","3","0","0"),
("113045","Dąbrowa Górnicza","112783","4","0","1"),
("113046","Gliwice","112783","5","0","0"),
("113047","Jastrzębie-Zdrój","112783","6","0","1"),
("113048","Jaworzno","112783","7","0","1"),
("113049","Katowice","112783","8","0","0"),
("113050","Mysłowice","112783","9","0","1"),
("113051","Piekary Śląskie","112783","10","0","1"),
("113052","Ruda Śląska","112783","11","0","1"),
("113053","Rybnik","112783","12","0","1"),
("113054","Siemianowice Śląskie","112783","13","0","1"),
("113055","Sosnowiec","112783","14","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113056","Świętochłowice","112783","15","0","1"),
("113057","Tychy","112783","16","0","0"),
("113058","Zabrze","112783","17","0","1"),
("113059","Żory","112783","18","0","1"),
("113060","Pow. będziński","112783","19","0","1"),
("113061","Pow. bielski","112783","20","0","1"),
("113062","Pow. bieruńsko-lędziński","112783","21","0","1"),
("113063","Pow. cieszyński","112783","22","0","1"),
("113064","Pow. częstochowski","112783","23","0","1"),
("113065","Pow. gliwicki","112783","24","0","1"),
("113066","Pow. kłobucki","112783","25","0","1"),
("113067","Pow. lubliniecki","112783","26","0","1"),
("113068","Pow. mikołowski","112783","27","0","1"),
("113069","Pow. myszkowski","112783","28","0","1"),
("113070","Pow. pszczyński","112783","29","0","1"),
("113071","Pow. raciborski","112783","30","0","1"),
("113072","Pow. rybnicki","112783","31","0","1"),
("113073","Pow. tarnogórski","112783","32","0","1"),
("113074","Pow. wodzisławski","112783","33","0","1"),
("113075","Pow. zawierciański","112783","34","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113076","Pow. żywiecki","112783","35","0","1"),
("113077","Kielce","112784","0","0","1"),
("113078","Pow. buski","112784","1","0","1"),
("113079","Pow. jędrzejowski","112784","2","0","1"),
("113080","Pow. kazimierski","112784","3","0","1"),
("113081","Pow. kielecki","112784","4","0","1"),
("113082","Pow. konecki","112784","5","0","1"),
("113083","Pow. opatowski","112784","6","0","1"),
("113084","Pow. ostrowiecki","112784","7","0","1"),
("113085","Pow. pińczowski","112784","8","0","1"),
("113086","Pow. sandomierski","112784","9","0","1"),
("113087","Pow. skarżyski","112784","10","0","1"),
("113088","Pow. starachowicki","112784","11","0","1"),
("113089","Pow. staszowski","112784","12","0","1"),
("113090","Pow. włoszczowski","112784","13","0","1"),
("113091","Elbląg","112785","0","0","1"),
("113092","Olsztyn","112785","1","0","1"),
("113093","Pow. bartoszycki","112785","2","0","1"),
("113094","Pow. braniewski","112785","3","0","1"),
("113095","Pow. działdowski","112785","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113096","Pow. elbląski","112785","5","0","1"),
("113097","Pow. ełcki","112785","6","0","1"),
("113098","Pow. giżycki","112785","7","0","1"),
("113099","Pow. gołdapski","112785","8","0","1"),
("113100","Pow. iławski","112785","9","0","1"),
("113101","Pow. kętrzyński","112785","10","0","1"),
("113102","Pow. lidzbarski","112785","11","0","1"),
("113103","Pow. mrągowski","112785","12","0","1"),
("113104","Pow. nidzicki","112785","13","0","1"),
("113105","Pow. nowomiejski","112785","14","0","1"),
("113106","Pow. olecki","112785","15","0","1"),
("113107","Pow. olsztyński","112785","16","0","1"),
("113108","Pow. ostródzki","112785","17","0","1"),
("113109","Pow. piski","112785","18","0","1"),
("113110","Pow. szczycieński","112785","19","0","1"),
("113111","Pow. węgorzewski","112785","20","0","1"),
("113112","Kalisz","112786","0","0","1"),
("113113","Konin","112786","1","0","1"),
("113114","Leszno","112786","2","0","1"),
("113115","Poznań","112786","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113116","Pow. chodzieski","112786","4","0","1"),
("113117","Pow. czarnkowsko-trzcianecki","112786","5","0","1"),
("113118","Pow. gnieźnieński","112786","6","0","1"),
("113119","Pow. gostyński","112786","7","0","1"),
("113120","Pow. grodziski","112786","8","0","1"),
("113121","Pow. jarociński","112786","9","0","1"),
("113122","Pow. kaliski","112786","10","0","1"),
("113123","Pow. kępiński","112786","11","0","1"),
("113124","Pow. kolski","112786","12","0","1"),
("113125","Pow. koniński","112786","13","0","1"),
("113126","Pow. kościański","112786","14","0","1"),
("113127","Pow. krotoszyński","112786","15","0","1"),
("113128","Pow. leszczyński","112786","16","0","1"),
("113129","Pow. międzychodzki","112786","17","0","1"),
("113130","Pow. nowotomyski","112786","18","0","1"),
("113131","Pow. obornicki","112786","19","0","1"),
("113132","Pow. ostrowski","112786","20","0","1"),
("113133","Pow. ostrzeszowski","112786","21","0","1"),
("113134","Pow. pilski","112786","22","0","1"),
("113135","Pow. pleszewski","112786","23","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113136","Pow. poznański","112786","24","0","1"),
("113137","Pow. rawicki","112786","25","0","1"),
("113138","Pow. słupecki","112786","26","0","1"),
("113139","Pow. szamotulski","112786","27","0","1"),
("113140","Pow. średzki","112786","28","0","1"),
("113141","Pow. śremski","112786","29","0","1"),
("113142","Pow. turecki","112786","30","0","1"),
("113143","Pow. wągrowiecki","112786","31","0","1"),
("113144","Pow. wolsztyński","112786","32","0","1"),
("113145","Pow. wrzesiński","112786","33","0","1"),
("113146","Pow. złotowski","112786","34","0","1"),
("113147","Koszalin","112787","0","0","0"),
("113148","Szczecin","112787","1","0","0"),
("113149","Świnoujście","112787","2","0","1"),
("113150","Pow. białogardzki","112787","3","0","1"),
("113151","Pow. choszczeński","112787","4","0","1"),
("113152","Pow. drawski","112787","5","0","1"),
("113153","Pow. goleniowski","112787","6","0","1"),
("113154","Pow. gryficki","112787","7","0","1"),
("113155","Pow. gryfiński","112787","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113156","Pow. kamieński","112787","9","0","1"),
("113157","Pow. kołobrzeski","112787","10","0","1"),
("113158","Pow. koszaliński","112787","11","0","1"),
("113159","Pow. łobeski","112787","12","0","1"),
("113160","Pow. myśliborski","112787","13","0","1"),
("113161","Pow. policki","112787","14","0","1"),
("113162","Pow. pyrzycki","112787","15","0","1"),
("113163","Pow. sławieński","112787","16","0","1"),
("113164","Pow. stargardzki","112787","17","0","1"),
("113165","Pow. szczecinecki","112787","18","0","1"),
("113166","Pow. świdwiński","112787","19","0","1"),
("113167","Pow. wałecki","112787","20","0","1"),
("113168","Cieplice Śląskie-Zdrój","112788","0","0","1"),
("113169","Czarne","112788","1","0","1"),
("113170","Dąbrówka","112788","2","0","1"),
("113171","Goduszyn","112788","3","0","1"),
("113172","Grabary","112788","4","0","1"),
("113173","Jagniątków","112788","5","0","1"),
("113174","Maciejowa","112788","6","0","1"),
("113175","Paulinów","112788","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113176","Sobieszów","112788","8","0","1"),
("113177","Strupice","112788","9","0","1"),
("113178","Zabobrze","112788","10","0","1"),
("113179","Pozostałe","112788","11","0","1"),
("113180","Fabryczna","112791","0","0","1"),
("113181","Krzyki","112791","1","0","1"),
("113182","Psie Pole","112791","2","0","1"),
("113183","Stare Miasto","112791","3","0","1"),
("113184","Śródmieście","112791","4","0","1"),
("113185","Pozostałe","112791","5","0","1"),
("113186","Bartodzieje Małe","112818","0","0","1"),
("113187","Bartodzieje Wielkie","112818","1","0","1"),
("113188","Bielawy","112818","2","0","1"),
("113189","Błonie","112818","3","0","1"),
("113190","Bocianowo","112818","4","0","1"),
("113191","Czyżkówko","112818","5","0","1"),
("113192","Fordon","112818","6","0","1"),
("113193","Górzyskowo","112818","7","0","1"),
("113194","Kapuściska","112818","8","0","1"),
("113195","Okole","112818","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113196","Osiedle Leśne","112818","10","0","1"),
("113197","Osowa Góra","112818","11","0","1"),
("113198","Skrzetusko","112818","12","0","1"),
("113199","Szwederowo","112818","13","0","1"),
("113200","Wilczak","112818","14","0","1"),
("113201","Pozostałe","112818","15","0","1"),
("113202","Bielany","112820","0","0","1"),
("113203","Bielawy","112820","1","0","1"),
("113204","Bydgoskie Przedmieście","112820","2","0","1"),
("113205","Chełmińskie Przedmieście","112820","3","0","1"),
("113206","Jakubskie Przedmieście","112820","4","0","1"),
("113207","Koniuchy","112820","5","0","1"),
("113208","Mokre","112820","6","0","1"),
("113209","Na Skarpie","112820","7","0","1"),
("113210","Podgórz","112820","8","0","1"),
("113211","Rubinkowo","112820","9","0","1"),
("113212","Rudak","112820","10","0","1"),
("113213","Rybaki","112820","11","0","1"),
("113214","Stare Miasto","112820","12","0","1"),
("113215","Stawki","112820","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113216","Wrzosy","112820","14","0","1"),
("113217","Pozostałe","112820","15","0","1"),
("113218","Bazylianówka","112843","0","0","1"),
("113219","Bronowice","112843","1","0","1"),
("113220","Czechów Górny","112843","2","0","1"),
("113221","Czuby","112843","3","0","1"),
("113222","Dziesiąta","112843","4","0","1"),
("113223","Felin","112843","5","0","1"),
("113224","Kalinowszczyzna","112843","6","0","1"),
("113225","Kośminek","112843","7","0","1"),
("113226","Rudnik ","112843","8","0","1"),
("113227","Sławinek","112843","9","0","1"),
("113228","Śródmieście","112843","10","0","1"),
("113229","Tatary","112843","11","0","1"),
("113230","Węglin","112843","12","0","1"),
("113231","Wieniawka","112843","13","0","1"),
("113232","Wrotków","112843","14","0","1"),
("113233","Pozostałe","112843","15","0","1"),
("113234","Bałuty","112879","0","0","1"),
("113235","Górna","112879","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113236","Polesie","112879","2","0","1"),
("113237","Śródmieście","112879","3","0","1"),
("113238","Widzew","112879","4","0","1"),
("113239","Pozostałe","112879","5","0","1"),
("113240","Krowodrza","112903","0","0","1"),
("113241","Nowa Huta","112903","1","0","1"),
("113242","Podgórze","112903","2","0","1"),
("113243","Śródmieście","112903","3","0","1"),
("113244","Pozostałe","112903","4","0","1"),
("113245","Bemowo","112929","0","0","1"),
("113246","Białołęka","112929","1","0","1"),
("113247","Bielany","112929","2","0","1"),
("113248","Mokotów","112929","3","0","1"),
("113249","Ochota","112929","4","0","1"),
("113250","Praga Południe","112929","5","0","1"),
("113251","Praga Północ","112929","6","0","1"),
("113252","Rembertów","112929","7","0","1"),
("113253","Śródmieście","112929","8","0","1"),
("113254","Targówek","112929","9","0","1"),
("113255","Ursus","112929","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113256","Ursynów","112929","11","0","1"),
("113257","Wawer","112929","12","0","1"),
("113258","Wesoła","112929","13","0","1"),
("113259","Wilanów","112929","14","0","1"),
("113260","Włochy","112929","15","0","1"),
("113261","Wola","112929","16","0","1"),
("113262","Żoliborz","112929","17","0","1"),
("113263","Inne","112929","18","0","1"),
("113264","Góra Kalwaria","112947","0","0","1"),
("113265","Konstancin-Jeziorna","112947","1","0","1"),
("113266","Piaseczno","112947","2","0","1"),
("113267","Tarczyn","112947","3","0","1"),
("113268","Pozostałe","112947","4","0","1"),
("113269","Brwinów","112950","0","0","1"),
("113270","Piastów","112950","1","0","1"),
("113271","Pruszków","112950","2","0","1"),
("113272","Pozostałe","112950","3","0","1"),
("113273","Kobyłka","112962","0","0","1"),
("113274","Marki","112962","1","0","1"),
("113275","Radzymin","112962","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113276","Tłuszcz","112962","3","0","1"),
("113277","Wołomin","112962","4","0","1"),
("113278","Ząbki","112962","5","0","1"),
("113279","Zielonka","112962","6","0","1"),
("113280","Pozostałe","112962","7","0","1"),
("113281","Bierkowice","112967","0","0","1"),
("113282","Gosławice","112967","1","0","1"),
("113283","Groszowice","112967","2","0","1"),
("113284","Grudzice","112967","3","0","1"),
("113285","Kolonia Gosławicka","112967","4","0","1"),
("113286","Malina","112967","5","0","1"),
("113287","Nowa Wieś Królewska","112967","6","0","1"),
("113288","Półwieś","112967","7","0","1"),
("113289","Szczepanowice","112967","8","0","1"),
("113290","Wójtowa Wieś","112967","9","0","1"),
("113291","Wróblin","112967","10","0","1"),
("113292","Zakrzów","112967","11","0","1"),
("113293","Zaodrze","112967","12","0","1"),
("113294","Pozostałe","112967","13","0","1"),
("113295","Drabinianka","112981","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113296","Dworzysko","112981","1","0","1"),
("113297","Miłocin","112981","2","0","1"),
("113298","Pobitno","112981","3","0","1"),
("113299","Przybyszówka","112981","4","0","1"),
("113300","Słocina","112981","5","0","1"),
("113301","Staromieście","112981","6","0","1"),
("113302","Staroniwa","112981","7","0","1"),
("113303","Szajerówka","112981","8","0","1"),
("113304","Wilkowyja","112981","9","0","1"),
("113305","Zalesie","112981","10","0","1"),
("113306","Załęże","112981","11","0","1"),
("113307","Zwięczyca","112981","12","0","1"),
("113308","Pozostałe","112981","13","0","1"),
("113309","Antoniuk","113004","0","0","1"),
("113310","Bacieczki","113004","1","0","1"),
("113311","Białostoczek","113004","2","0","1"),
("113312","Bojary","113004","3","0","1"),
("113313","Dojlidy","113004","4","0","1"),
("113314","Dojlidy Górne","113004","5","0","1"),
("113315","Dziesięciny","113004","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113316","Nowe Miasto","113004","7","0","1"),
("113317","Skorupy","113004","8","0","1"),
("113318","Słoboda","113004","9","0","1"),
("113319","Starosielce","113004","10","0","1"),
("113320","Wygoda","113004","11","0","1"),
("113321","Wysoki Stoczek","113004","12","0","1"),
("113322","Zagórki","113004","13","0","1"),
("113323","Zawady","113004","14","0","1"),
("113324","Pozostałe","113004","15","0","1"),
("113325","Brzeźno","113021","0","0","1"),
("113326","Chełm","113021","1","0","1"),
("113327","Jasień","113021","2","0","1"),
("113328","Kiełpino Górne","113021","3","0","1"),
("113329","Kokoszki","113021","4","0","1"),
("113330","Lipce","113021","5","0","1"),
("113331","Łostowice","113021","6","0","1"),
("113332","Oliwa","113021","7","0","1"),
("113333","Osowa","113021","8","0","1"),
("113334","Przymorze","113021","9","0","1"),
("113335","Siedlce","113021","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113336","Sobieszewo","113021","11","0","1"),
("113337","Suchanino","113021","12","0","1"),
("113338","Wrzeszcz","113021","13","0","1"),
("113339","Zakoniczyn","113021","14","0","1"),
("113340","Pozostałe","113021","15","0","1"),
("113341","Chwarzno","113022","0","0","1"),
("113342","Chylonia","113022","1","0","1"),
("113343","Cisowa","113022","2","0","1"),
("113344","Działki Leśne","113022","3","0","1"),
("113345","Kamienna Góra","113022","4","0","1"),
("113346","Leszczynki","113022","5","0","1"),
("113347","Mały Kack","113022","6","0","1"),
("113348","Obłuże","113022","7","0","1"),
("113349","Oksywie","113022","8","0","1"),
("113350","Orłowo","113022","9","0","1"),
("113351","Pogórze","113022","10","0","1"),
("113352","Redłowo","113022","11","0","1"),
("113353","Wiczlino","113022","12","0","1"),
("113354","Wielki Kack","113022","13","0","1"),
("113355","Wzgórze Nowotki","113022","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113356","Pozostałe","113022","15","0","1"),
("113357","Brodwino","113024","0","0","1"),
("113358","Kamienny Potok","113024","1","0","1"),
("113359","Przylesie","113024","2","0","1"),
("113360","Sopot Dolny","113024","3","0","1"),
("113361","Sopot Górny","113024","4","0","1"),
("113362","Wyścigi","113024","5","0","1"),
("113363","Pozostałe","113024","6","0","1"),
("113364","Reda","113040","0","0","1"),
("113365","Rumia","113040","1","0","1"),
("113366","Wejherowo","113040","2","0","1"),
("113367","Pozostałe","113040","3","0","1"),
("113368","Aleksandrowice","113041","0","0","1"),
("113369","Hałcnów","113041","1","0","1"),
("113370","Kamienica","113041","2","0","1"),
("113371","Komorowice Krakowskie","113041","3","0","1"),
("113372","Komorowice Śląskie","113041","4","0","1"),
("113373","Leszczyny","113041","5","0","1"),
("113374","Lipnik","113041","6","0","1"),
("113375","Mikuszowice Krakowskie","113041","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113376","Mikuszowice Śląskie","113041","8","0","1"),
("113377","Olszówka Dolna","113041","9","0","1"),
("113378","Olszówka Górna","113041","10","0","1"),
("113379","Stare Bielsko","113041","11","0","1"),
("113380","Straconka","113041","12","0","1"),
("113381","Wapienica","113041","13","0","1"),
("113382","Złote Łany","113041","14","0","1"),
("113383","Pozostałe","113041","15","0","1"),
("113384","Bobrek","113042","0","0","1"),
("113385","Górniki","113042","1","0","1"),
("113386","Karb","113042","2","0","1"),
("113387","Łagiewniki","113042","3","0","1"),
("113388","Miechowice","113042","4","0","1"),
("113389","Rozbark","113042","5","0","1"),
("113390","Stolarzowice","113042","6","0","1"),
("113391","Stroszek","113042","7","0","1"),
("113392","Sucha Góra","113042","8","0","1"),
("113393","Szombierki","113042","9","0","1"),
("113394","Pozostałe","113042","10","0","1"),
("113395","Błeszno","113044","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113396","Dźbów","113044","1","0","1"),
("113397","Grabówka","113044","2","0","1"),
("113398","Kawodrza Dolna","113044","3","0","1"),
("113399","Lisiniec","113044","4","0","1"),
("113400","Liszka Dolna","113044","5","0","1"),
("113401","Mirów","113044","6","0","1"),
("113402","Ostatni Grosz","113044","7","0","1"),
("113403","Parkitka","113044","8","0","1"),
("113404","Raków","113044","9","0","1"),
("113405","Rząsawy","113044","10","0","1"),
("113406","Sabinów","113044","11","0","1"),
("113407","Stradom","113044","12","0","1"),
("113408","Wrzosowiak","113044","13","0","1"),
("113409","Zawodzie","113044","14","0","1"),
("113410","Pozostałe","113044","15","0","1"),
("113411","Bojków","113046","0","0","1"),
("113412","Brzezinka","113046","1","0","1"),
("113413","Czechowice","113046","2","0","1"),
("113414","Ligota Zabrska","113046","3","0","1"),
("113415","Łabędy","113046","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113416","Ostropa","113046","5","0","1"),
("113417","Sośnica","113046","6","0","1"),
("113418","Stare Gliwice","113046","7","0","1"),
("113419","Szobiszowice","113046","8","0","1"),
("113420","Trynek","113046","9","0","1"),
("113421","Wilcze Gardło","113046","10","0","1"),
("113422","Wójtowa Wieś","113046","11","0","1"),
("113423","Żerniki","113046","12","0","1"),
("113424","Pozostałe","113046","13","0","1"),
("113425","Bogucice","113049","0","0","1"),
("113426","Brynów","113049","1","0","1"),
("113427","Dąb","113049","2","0","1"),
("113428","Giszowiec","113049","3","0","1"),
("113429","Józefowiec","113049","4","0","1"),
("113430","Kostuchna","113049","5","0","1"),
("113431","Ligota","113049","6","0","1"),
("113432","Ochojec","113049","7","0","1"),
("113433","Panewniki","113049","8","0","1"),
("113434","Piotrowice","113049","9","0","1"),
("113435","Podlesie","113049","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113436","Wełnowiec","113049","11","0","1"),
("113437","Zarzecze","113049","12","0","1"),
("113438","Zawodzie","113049","13","0","1"),
("113439","Pozostałe","113049","14","0","1"),
("113440","Cieśle","113055","0","0","1"),
("113441","Dańdówka","113055","1","0","1"),
("113442","Dębowa Góra","113055","2","0","1"),
("113443","Józefów","113055","3","0","1"),
("113444","Kazimierz","113055","4","0","1"),
("113445","Klimontów","113055","5","0","1"),
("113446","Maczki","113055","6","0","1"),
("113447","Milowice","113055","7","0","1"),
("113448","Niwka","113055","8","0","1"),
("113449","Ostrowy Górnicze","113055","9","0","1"),
("113450","Pogoń","113055","10","0","1"),
("113451","Sielec","113055","11","0","1"),
("113452","Stary Sosnowiec","113055","12","0","1"),
("113453","Środula","113055","13","0","1"),
("113454","Zagórze","113055","14","0","1"),
("113455","Pozostałe","113055","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113456","Cielmice","113057","0","0","1"),
("113457","Czułów","113057","1","0","1"),
("113458","Glinka","113057","2","0","1"),
("113459","Jaroszowice","113057","3","0","1"),
("113460","Mąkołowiec","113057","4","0","1"),
("113461","Paprocany","113057","5","0","1"),
("113462","Suble","113057","6","0","1"),
("113463","Urbanowice","113057","7","0","1"),
("113464","Wartogłowiec","113057","8","0","1"),
("113465","Wilkowyje","113057","9","0","1"),
("113466","Zwierzyniec","113057","10","0","1"),
("113467","Żwaków","113057","11","0","1"),
("113468","Pozostałe","113057","12","0","1"),
("113469","Grunwald","113115","0","0","1"),
("113470","Jeżyce","113115","1","0","1"),
("113471","Nowe Miasto","113115","2","0","1"),
("113472","Stare Miasto","113115","3","0","1"),
("113473","Wilda","113115","4","0","1"),
("113474","Pozostałe","113115","5","0","1"),
("113475","Chełmoniewo","113147","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113476","Dzierżęcino","113147","1","0","1"),
("113477","Lubiatowo","113147","2","0","1"),
("113478","Raduszka","113147","3","0","1"),
("113479","Rokosowo","113147","4","0","1"),
("113480","Pozostałe","113147","5","0","1"),
("113481","Bezrzecze","113148","0","0","1"),
("113482","Bukowo","113148","1","0","1"),
("113483","Dąbie","113148","2","0","1"),
("113484","Drzetowo","113148","3","0","1"),
("113485","Grabowo","113148","4","0","1"),
("113486","Gumieńce","113148","5","0","1"),
("113487","Kijewo","113148","6","0","1"),
("113488","Niebuszewo","113148","7","0","1"),
("113489","Podjuchy","113148","8","0","1"),
("113490","Pogodno","113148","9","0","1"),
("113491","Pomorzany","113148","10","0","1"),
("113492","Warszewo","113148","11","0","1"),
("113493","Wielgowo","113148","12","0","1"),
("113494","Zdroje","113148","13","0","1"),
("113495","Żelechowa","113148","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113496","Pozostałe","113148","15","0","1"),
("113497","Dolnośląskie","112743","0","0","0"),
("113498","Kujawsko-pomorskie","112743","1","0","0"),
("113499","Lubelskie","112743","2","0","0"),
("113500","Lubuskie","112743","3","0","0"),
("113501","Łódzkie","112743","4","0","0"),
("113502","Małopolskie","112743","5","0","0"),
("113503","Mazowieckie","112743","6","0","0"),
("113504","Opolskie","112743","7","0","0"),
("113505","Podkarpackie","112743","8","0","0"),
("113506","Podlaskie","112743","9","0","0"),
("113507","Pomorskie","112743","10","0","0"),
("113508","Śląskie","112743","11","0","0"),
("113509","Świętokrzyskie","112743","12","0","0"),
("113510","Warmińsko-mazurskie","112743","13","0","0"),
("113511","Wielkopolskie","112743","14","0","0"),
("113512","Zachodniopomorskie","112743","15","0","0"),
("113513","Jelenia Góra","113497","0","0","1"),
("113514","Legnica","113497","1","0","1"),
("113515","Wałbrzych","113497","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113516","Wrocław","113497","3","0","0"),
("113517","Pow. bolesławiecki","113497","4","0","1"),
("113518","Pow. dzierżoniowski","113497","5","0","1"),
("113519","Pow. głogowski","113497","6","0","1"),
("113520","Pow. górowski","113497","7","0","1"),
("113521","Pow. jaworski","113497","8","0","1"),
("113522","Pow. jeleniogórski","113497","9","0","1"),
("113523","Pow. kamiennogórski","113497","10","0","1"),
("113524","Pow. kłodzki","113497","11","0","1"),
("113525","Pow. legnicki","113497","12","0","1"),
("113526","Pow. lubański","113497","13","0","1"),
("113527","Pow. lubiński","113497","14","0","1"),
("113528","Pow. lwówecki","113497","15","0","1"),
("113529","Pow. milicki","113497","16","0","1"),
("113530","Pow. oleśnicki","113497","17","0","1"),
("113531","Pow. oławski","113497","18","0","1"),
("113532","Pow. polkowicki","113497","19","0","1"),
("113533","Pow. strzeliński","113497","20","0","1"),
("113534","Pow. średzki","113497","21","0","1"),
("113535","Pow. świdnicki","113497","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113536","Pow. trzebnicki","113497","23","0","1"),
("113537","Pow. wałbrzyski","113497","24","0","1"),
("113538","Pow. wołowski","113497","25","0","1"),
("113539","Pow. wrocławski","113497","26","0","1"),
("113540","Pow. ząbkowicki","113497","27","0","1"),
("113541","Pow. zgorzelecki","113497","28","0","1"),
("113542","Pow. złotoryjski","113497","29","0","1"),
("113543","Bydgoszcz","113498","0","0","1"),
("113544","Grudziądz","113498","1","0","1"),
("113545","Toruń","113498","2","0","1"),
("113546","Włocławek","113498","3","0","1"),
("113547","Pow. aleksandrowski","113498","4","0","1"),
("113548","Pow. brodnicki","113498","5","0","1"),
("113549","Pow. bydgoski","113498","6","0","1"),
("113550","Pow. chełmiński","113498","7","0","1"),
("113551","Pow. golubsko-dobrzyński","113498","8","0","1"),
("113552","Pow. grudziądzki","113498","9","0","1"),
("113553","Pow. inowrocławski","113498","10","0","1"),
("113554","Pow. lipnowski","113498","11","0","1"),
("113555","Pow. mogileński","113498","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113556","Pow. nakielski","113498","13","0","1"),
("113557","Pow. radziejowski","113498","14","0","1"),
("113558","Pow. rypiński","113498","15","0","1"),
("113559","Pow. sępoleński","113498","16","0","1"),
("113560","Pow. świecki","113498","17","0","1"),
("113561","Pow. toruński","113498","18","0","1"),
("113562","Pow. tucholski","113498","19","0","1"),
("113563","Pow. wąbrzeski","113498","20","0","1"),
("113564","Pow. włocławski","113498","21","0","1"),
("113565","Pow. żniński","113498","22","0","1"),
("113566","Biała Podlaska","113499","0","0","1"),
("113567","Chełm","113499","1","0","1"),
("113568","Lublin","113499","2","0","1"),
("113569","Zamość","113499","3","0","1"),
("113570","Pow. bialski","113499","4","0","1"),
("113571","Pow. biłgorajski","113499","5","0","1"),
("113572","Pow. chełmski","113499","6","0","1"),
("113573","Pow. hrubieszowski","113499","7","0","1"),
("113574","Pow. janowski","113499","8","0","1"),
("113575","Pow. krasnostawski","113499","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113576","Pow. kraśnicki","113499","10","0","1"),
("113577","Pow. lubartowski","113499","11","0","1"),
("113578","Pow. lubelski","113499","12","0","1"),
("113579","Pow. łęczyński","113499","13","0","1"),
("113580","Pow. łukowski","113499","14","0","1"),
("113581","Pow. opolski","113499","15","0","1"),
("113582","Pow. parczewski","113499","16","0","1"),
("113583","Pow. puławski","113499","17","0","1"),
("113584","Pow. radzyński","113499","18","0","1"),
("113585","Pow. rycki","113499","19","0","1"),
("113586","Pow. świdnicki","113499","20","0","1"),
("113587","Pow. tomaszowski","113499","21","0","1"),
("113588","Pow. włodawski","113499","22","0","1"),
("113589","Pow. zamojski","113499","23","0","1"),
("113590","Gorzów Wielkopolski","113500","0","0","1"),
("113591","Zielona Góra","113500","1","0","1"),
("113592","Pow. gorzowski","113500","2","0","1"),
("113593","Pow. krośnieński","113500","3","0","1"),
("113594","Pow. międzyrzecki","113500","4","0","1"),
("113595","Pow. nowosolski","113500","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113596","Pow. słubicki","113500","6","0","1"),
("113597","Pow. strzelecko-drezdenecki","113500","7","0","1"),
("113598","Pow. sulęciński","113500","8","0","1"),
("113599","Pow. świebodziński","113500","9","0","1"),
("113600","Pow. wschowski","113500","10","0","1"),
("113601","Pow. zielonogórski","113500","11","0","1"),
("113602","Pow. żagański","113500","12","0","1"),
("113603","Pow. żarski","113500","13","0","1"),
("113604","Łódź","113501","0","0","1"),
("113605","Piotrków Trybunalski","113501","1","0","1"),
("113606","Skierniewice","113501","2","0","1"),
("113607","Pow. bełchatowski","113501","3","0","1"),
("113608","Pow. brzeziński","113501","4","0","1"),
("113609","Pow. kutnowski","113501","5","0","1"),
("113610","Pow. łaski","113501","6","0","1"),
("113611","Pow. łęczycki","113501","7","0","1"),
("113612","Pow. łowicki","113501","8","0","1"),
("113613","Pow. łódzki wschodni","113501","9","0","1"),
("113614","Pow. opoczyński","113501","10","0","1"),
("113615","Pow. pabianicki","113501","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113616","Pow. pajęczański","113501","12","0","1"),
("113617","Pow. piotrkowski","113501","13","0","1"),
("113618","Pow. poddębicki","113501","14","0","1"),
("113619","Pow. radomszczański","113501","15","0","1"),
("113620","Pow. rawski","113501","16","0","1"),
("113621","Pow. sieradzki","113501","17","0","1"),
("113622","Pow. skierniewicki","113501","18","0","1"),
("113623","Pow. tomaszowski","113501","19","0","1"),
("113624","Pow. wieluński","113501","20","0","1"),
("113625","Pow. wieruszowski","113501","21","0","1"),
("113626","Pow. zduńskowolski","113501","22","0","1"),
("113627","Pow. zgierski","113501","23","0","1"),
("113628","Kraków","113502","0","0","0"),
("113629","Nowy Sącz","113502","1","0","1"),
("113630","Tarnów","113502","2","0","1"),
("113631","Pow. bocheński","113502","3","0","1"),
("113632","Pow. brzeski","113502","4","0","1"),
("113633","Pow. chrzanowski","113502","5","0","1"),
("113634","Pow. dąbrowski","113502","6","0","1"),
("113635","Pow. gorlicki","113502","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113636","Pow. krakowski","113502","8","0","1"),
("113637","Pow. limanowski","113502","9","0","1"),
("113638","Pow. miechowski","113502","10","0","1"),
("113639","Pow. myślenicki","113502","11","0","1"),
("113640","Pow. nowosądecki","113502","12","0","1"),
("113641","Pow. nowotarski","113502","13","0","1"),
("113642","Pow. olkuski","113502","14","0","1"),
("113643","Pow. oświęcimski","113502","15","0","1"),
("113644","Pow. proszowicki","113502","16","0","1"),
("113645","Pow. suski","113502","17","0","1"),
("113646","Pow. tarnowski","113502","18","0","1"),
("113647","Pow. tatrzański","113502","19","0","1"),
("113648","Pow. wadowicki","113502","20","0","1"),
("113649","Pow. wielicki","113502","21","0","1"),
("113650","Ostrołęka","113503","0","0","1"),
("113651","Płock","113503","1","0","1"),
("113652","Radom","113503","2","0","1"),
("113653","Siedlce","113503","3","0","1"),
("113654","Warszawa","113503","4","0","0"),
("113655","Pow. białobrzeski","113503","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113656","Pow. ciechanowski","113503","6","0","1"),
("113657","Pow. garwoliński","113503","7","0","1"),
("113658","Pow. gostyniński","113503","8","0","1"),
("113659","Pow. grodziski","113503","9","0","1"),
("113660","Pow. grójecki","113503","10","0","1"),
("113661","Pow. kozienicki","113503","11","0","1"),
("113662","Pow. legionowski","113503","12","0","1"),
("113663","Pow. lipski","113503","13","0","1"),
("113664","Pow. łosicki","113503","14","0","1"),
("113665","Pow. makowski","113503","15","0","1"),
("113666","Pow. miński","113503","16","0","1"),
("113667","Pow. mławski","113503","17","0","1"),
("113668","Pow. nowodworski","113503","18","0","1"),
("113669","Pow. ostrołęcki","113503","19","0","1"),
("113670","Pow. ostrowski","113503","20","0","1"),
("113671","Pow. otwocki","113503","21","0","1"),
("113672","Pow. piaseczyński","113503","22","0","1"),
("113673","Pow. płocki","113503","23","0","1"),
("113674","Pow. płoński","113503","24","0","1"),
("113675","Pow. pruszkowski","113503","25","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113676","Pow. przasnyski","113503","26","0","1"),
("113677","Pow. przysuski","113503","27","0","1"),
("113678","Pow. pułtuski","113503","28","0","1"),
("113679","Pow. radomski","113503","29","0","1"),
("113680","Pow. siedlecki","113503","30","0","1"),
("113681","Pow. sierpecki","113503","31","0","1"),
("113682","Pow. sochaczewski","113503","32","0","1"),
("113683","Pow. sokołowski","113503","33","0","1"),
("113684","Pow. szydłowiecki","113503","34","0","1"),
("113685","Pow. warszawski zachodni","113503","35","0","1"),
("113686","Pow. węgrowski","113503","36","0","1"),
("113687","Pow. wołomiński","113503","37","0","1"),
("113688","Pow. wyszkowski","113503","38","0","1"),
("113689","Pow. zwoleński","113503","39","0","1"),
("113690","Pow. żuromiński","113503","40","0","1"),
("113691","Pow. żyrardowski","113503","41","0","1"),
("113692","Opole","113504","0","0","1"),
("113693","Pow. brzeski","113504","1","0","1"),
("113694","Pow. głubczycki","113504","2","0","1"),
("113695","Pow. kędzierzyńsko-kozielski","113504","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113696","Pow. kluczborski","113504","4","0","1"),
("113697","Pow. krapkowicki","113504","5","0","1"),
("113698","Pow. namysłowski","113504","6","0","1"),
("113699","Pow. nyski","113504","7","0","1"),
("113700","Pow. oleski","113504","8","0","1"),
("113701","Pow. opolski","113504","9","0","1"),
("113702","Pow. prudnicki","113504","10","0","1"),
("113703","Pow. strzelecki","113504","11","0","1"),
("113704","Krosno","113505","0","0","1"),
("113705","Przemyśl","113505","1","0","1"),
("113706","Rzeszów","113505","2","0","1"),
("113707","Tarnobrzeg","113505","3","0","1"),
("113708","Pow. bieszczadzki","113505","4","0","1"),
("113709","Pow. brzozowski","113505","5","0","1"),
("113710","Pow. dębicki","113505","6","0","1"),
("113711","Pow. jarosławski","113505","7","0","1"),
("113712","Pow. jasielski","113505","8","0","1"),
("113713","Pow. kolbuszowski","113505","9","0","1"),
("113714","Pow. krośnieński","113505","10","0","1"),
("113715","Pow. leski","113505","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113716","Pow. leżajski","113505","12","0","1"),
("113717","Pow. lubaczowski","113505","13","0","1"),
("113718","Pow. łańcucki","113505","14","0","1"),
("113719","Pow. mielecki","113505","15","0","1"),
("113720","Pow. niżański","113505","16","0","1"),
("113721","Pow. przemyski","113505","17","0","1"),
("113722","Pow. przeworski","113505","18","0","1"),
("113723","Pow. ropczycko-sędziszowski","113505","19","0","1"),
("113724","Pow. rzeszowski","113505","20","0","1"),
("113725","Pow. sanocki","113505","21","0","1"),
("113726","Pow. stalowowolski","113505","22","0","1"),
("113727","Pow. strzyżowski","113505","23","0","1"),
("113728","Pow. tarnobrzeski","113505","24","0","1"),
("113729","Białystok","113506","0","0","1"),
("113730","Łomża","113506","1","0","1"),
("113731","Suwałki","113506","2","0","1"),
("113732","Pow. augustowski","113506","3","0","1"),
("113733","Pow. białostocki","113506","4","0","1"),
("113734","Pow. bielski","113506","5","0","1"),
("113735","Pow. grajewski","113506","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113736","Pow. hajnowski","113506","7","0","1"),
("113737","Pow. kolneński","113506","8","0","1"),
("113738","Pow. łomżyński","113506","9","0","1"),
("113739","Pow. moniecki","113506","10","0","1"),
("113740","Pow. sejneński","113506","11","0","1"),
("113741","Pow. siemiatycki","113506","12","0","1"),
("113742","Pow. sokólski","113506","13","0","1"),
("113743","Pow. suwalski","113506","14","0","1"),
("113744","Pow. wysokomazowiecki","113506","15","0","1"),
("113745","Pow. zambrowski","113506","16","0","1"),
("113746","Gdańsk","113507","0","0","1"),
("113747","Gdynia","113507","1","0","1"),
("113748","Słupsk","113507","2","0","1"),
("113749","Sopot","113507","3","0","1"),
("113750","Pow. bytowski","113507","4","0","1"),
("113751","Pow. chojnicki","113507","5","0","1"),
("113752","Pow. człuchowski","113507","6","0","1"),
("113753","Pow. gdański","113507","7","0","1"),
("113754","Pow. kartuski","113507","8","0","1"),
("113755","Pow. kościerski","113507","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113756","Pow. kwidzyński","113507","10","0","1"),
("113757","Pow. lęborski","113507","11","0","1"),
("113758","Pow. malborski","113507","12","0","1"),
("113759","Pow. nowodworski","113507","13","0","1"),
("113760","Pow. pucki","113507","14","0","1"),
("113761","Pow. słupski","113507","15","0","1"),
("113762","Pow. starogardzki","113507","16","0","1"),
("113763","Pow. sztumski","113507","17","0","1"),
("113764","Pow. tczewski","113507","18","0","1"),
("113765","Pow. wejherowski","113507","19","0","1"),
("113766","Pow. bieruńsko-lędziński","113508","0","0","1"),
("113767","Bielsko-Biała","113508","1","0","1"),
("113768","Bytom","113508","2","0","1"),
("113769","Chorzów","113508","3","0","1"),
("113770","Częstochowa","113508","4","0","1"),
("113771","Dąbrowa Górnicza","113508","5","0","1"),
("113772","Gliwice","113508","6","0","1"),
("113773","Jastrzębie-Zdrój","113508","7","0","1"),
("113774","Jaworzno","113508","8","0","1"),
("113775","Katowice","113508","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113776","Mysłowice","113508","10","0","1"),
("113777","Piekary Śląskie","113508","11","0","1"),
("113778","Ruda Śląska","113508","12","0","1"),
("113779","Rybnik","113508","13","0","1"),
("113780","Siemianowice Śląskie","113508","14","0","1"),
("113781","Sosnowiec","113508","15","0","1"),
("113782","Świętochłowice","113508","16","0","1"),
("113783","Tychy","113508","17","0","1"),
("113784","Zabrze","113508","18","0","1"),
("113785","Żory","113508","19","0","1"),
("113786","Pow. będziński","113508","20","0","1"),
("113787","Pow. bielski","113508","21","0","1"),
("113788","Pow. cieszyński","113508","22","0","1"),
("113789","Pow. częstochowski","113508","23","0","1"),
("113790","Pow. gliwicki","113508","24","0","1"),
("113791","Pow. kłobucki","113508","25","0","1"),
("113792","Pow. lubliniecki","113508","26","0","1"),
("113793","Pow. mikołowski","113508","27","0","1"),
("113794","Pow. myszkowski","113508","28","0","1"),
("113795","Pow. pszczyński","113508","29","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113796","Pow. raciborski","113508","30","0","1"),
("113797","Pow. rybnicki","113508","31","0","1"),
("113798","Pow. tarnogórski","113508","32","0","1"),
("113799","Pow. wodzisławski","113508","33","0","1"),
("113800","Pow. zawierciański","113508","34","0","1"),
("113801","Pow. żywiecki","113508","35","0","1"),
("113802","Kielce","113509","0","0","1"),
("113803","Pow. buski","113509","1","0","1"),
("113804","Pow. jędrzejowski","113509","2","0","1"),
("113805","Pow. kazimierski","113509","3","0","1"),
("113806","Pow. kielecki","113509","4","0","1"),
("113807","Pow. konecki","113509","5","0","1"),
("113808","Pow. opatowski","113509","6","0","1"),
("113809","Pow. ostrowiecki","113509","7","0","1"),
("113810","Pow. pińczowski","113509","8","0","1"),
("113811","Pow. sandomierski","113509","9","0","1"),
("113812","Pow. skarżyski","113509","10","0","1"),
("113813","Pow. starachowicki","113509","11","0","1"),
("113814","Pow. staszowski","113509","12","0","1"),
("113815","Pow. włoszczowski","113509","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113816","Elbląg","113510","0","0","1"),
("113817","Olsztyn","113510","1","0","1"),
("113818","Pow. bartoszycki","113510","2","0","1"),
("113819","Pow. braniewski","113510","3","0","1"),
("113820","Pow. działdowski","113510","4","0","1"),
("113821","Pow. elbląski","113510","5","0","1"),
("113822","Pow. ełcki","113510","6","0","1"),
("113823","Pow. giżycki","113510","7","0","1"),
("113824","Pow. gołdapski","113510","8","0","1"),
("113825","Pow. iławski","113510","9","0","1"),
("113826","Pow. kętrzyński","113510","10","0","1"),
("113827","Pow. lidzbarski","113510","11","0","1"),
("113828","Pow. mrągowski","113510","12","0","1"),
("113829","Pow. nidzicki","113510","13","0","1"),
("113830","Pow. nowomiejski","113510","14","0","1"),
("113831","Pow. olecki","113510","15","0","1"),
("113832","Pow. olsztyński","113510","16","0","1"),
("113833","Pow. ostródzki","113510","17","0","1"),
("113834","Pow. piski","113510","18","0","1"),
("113835","Pow. szczycieński","113510","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113836","Pow. węgorzewski","113510","20","0","1"),
("113837","Kalisz","113511","0","0","1"),
("113838","Konin","113511","1","0","1"),
("113839","Leszno","113511","2","0","1"),
("113840","Poznań","113511","3","0","1"),
("113841","Pow. chodzieski","113511","4","0","1"),
("113842","Pow. czarnkowsko-trzcianecki","113511","5","0","1"),
("113843","Pow. gnieźnieński","113511","6","0","1"),
("113844","Pow. gostyński","113511","7","0","1"),
("113845","Pow. grodziski","113511","8","0","1"),
("113846","Pow. jarociński","113511","9","0","1"),
("113847","Pow. kaliski","113511","10","0","1"),
("113848","Pow. kępiński","113511","11","0","1"),
("113849","Pow. kolski","113511","12","0","1"),
("113850","Pow. koniński","113511","13","0","1"),
("113851","Pow. kościański","113511","14","0","1"),
("113852","Pow. krotoszyński","113511","15","0","1"),
("113853","Pow. leszczyński","113511","16","0","1"),
("113854","Pow. międzychodzki","113511","17","0","1"),
("113855","Pow. nowotomyski","113511","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113856","Pow. obornicki","113511","19","0","1"),
("113857","Pow. ostrowski","113511","20","0","1"),
("113858","Pow. ostrzeszowski","113511","21","0","1"),
("113859","Pow. pilski","113511","22","0","1"),
("113860","Pow. pleszewski","113511","23","0","1"),
("113861","Pow. poznański","113511","24","0","1"),
("113862","Pow. rawicki","113511","25","0","1"),
("113863","Pow. słupecki","113511","26","0","1"),
("113864","Pow. szamotulski","113511","27","0","1"),
("113865","Pow. średzki","113511","28","0","1"),
("113866","Pow. śremski","113511","29","0","1"),
("113867","Pow. turecki","113511","30","0","1"),
("113868","Pow. wągrowiecki","113511","31","0","1"),
("113869","Pow. wolsztyński","113511","32","0","1"),
("113870","Pow. wrzesiński","113511","33","0","1"),
("113871","Pow. złotowski","113511","34","0","1"),
("113872","Koszalin","113512","0","0","1"),
("113873","Szczecin","113512","1","0","1"),
("113874","Świnoujście","113512","2","0","1"),
("113875","Pow. białogardzki","113512","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113876","Pow. choszczeński","113512","4","0","1"),
("113877","Pow. drawski","113512","5","0","1"),
("113878","Pow. goleniowski","113512","6","0","1"),
("113879","Pow. gryficki","113512","7","0","1"),
("113880","Pow. gryfiński","113512","8","0","1"),
("113881","Pow. kamieński","113512","9","0","1"),
("113882","Pow. kołobrzeski","113512","10","0","1"),
("113883","Pow. koszaliński","113512","11","0","1"),
("113884","Pow. łobeski","113512","12","0","1"),
("113885","Pow. myśliborski","113512","13","0","1"),
("113886","Pow. policki","113512","14","0","1"),
("113887","Pow. pyrzycki","113512","15","0","1"),
("113888","Pow. sławieński","113512","16","0","1"),
("113889","Pow. stargardzki","113512","17","0","1"),
("113890","Pow. szczecinecki","113512","18","0","1"),
("113891","Pow. świdwiński","113512","19","0","1"),
("113892","Pow. wałecki","113512","20","0","1"),
("113893","Fabryczna","113516","0","0","1"),
("113894","Krzyki","113516","1","0","1"),
("113895","Psie Pole","113516","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113896","Stare Miasto","113516","3","0","1"),
("113897","Śródmieście","113516","4","0","1"),
("113898","Inne","113516","5","0","1"),
("113899","Bieńczyce","113628","0","0","1"),
("113900","Bieżanów-Prokocim","113628","1","0","1"),
("113901","Bronowice","113628","2","0","1"),
("113902","Czyżyny","113628","3","0","1"),
("113903","Dębniki","113628","4","0","1"),
("113904","Grzegórzki","113628","5","0","1"),
("113905","Krowodrza","113628","6","0","1"),
("113906","Łagiewniki","113628","7","0","1"),
("113907","Mistrzejowice","113628","8","0","1"),
("113908","Nowa Huta","113628","9","0","1"),
("113909","Podgórze","113628","10","0","1"),
("113910","Podgórze Duchackie","113628","11","0","1"),
("113911","Prądnik Biały","113628","12","0","1"),
("113912","Prądnik Czerwony","113628","13","0","1"),
("113913","Stare Miasto","113628","14","0","1"),
("113914","Swoszowice","113628","15","0","1"),
("113915","Wzgórza Krzesławickie","113628","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113916","Zwierzyniec","113628","17","0","1"),
("113917","Inne","113628","18","0","1"),
("113918","Bemowo","113654","0","0","1"),
("113919","Białołęka","113654","1","0","1"),
("113920","Bielany","113654","2","0","1"),
("113921","Mokotów","113654","3","0","1"),
("113922","Ochota","113654","4","0","1"),
("113923","Praga Południe","113654","5","0","1"),
("113924","Praga Północ","113654","6","0","1"),
("113925","Rembertów","113654","7","0","1"),
("113926","Śródmieście","113654","8","0","1"),
("113927","Targówek","113654","9","0","1"),
("113928","Ursus","113654","10","0","1"),
("113929","Ursynów","113654","11","0","1"),
("113930","Wawer","113654","12","0","1"),
("113931","Wesoła","113654","13","0","1"),
("113932","Wilanów","113654","14","0","1"),
("113933","Włochy","113654","15","0","1"),
("113934","Wola","113654","16","0","1"),
("113935","Żoliborz","113654","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113936","Inne","113654","18","0","1"),
("113937","Dolnośląskie","112742","0","0","0"),
("113938","Kujawsko-pomorskie","112742","1","0","0"),
("113939","Lubelskie","112742","2","0","0"),
("113940","Lubuskie","112742","3","0","0"),
("113941","Łódzkie","112742","4","0","0"),
("113942","Małopolskie","112742","5","0","0"),
("113943","Mazowieckie","112742","6","0","0"),
("113944","Opolskie","112742","7","0","0"),
("113945","Podkarpackie","112742","8","0","0"),
("113946","Podlaskie","112742","9","0","0"),
("113947","Pomorskie","112742","10","0","0"),
("113948","Śląskie","112742","11","0","0"),
("113949","Świętokrzyskie","112742","12","0","0"),
("113950","Warmińsko-mazurskie","112742","13","0","0"),
("113951","Wielkopolskie","112742","14","0","0"),
("113952","Zachodniopomorskie","112742","15","0","0"),
("113953","Jelenia Góra","113937","0","0","0"),
("113954","Legnica","113937","1","0","1"),
("113955","Wałbrzych","113937","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113956","Wrocław","113937","3","0","0"),
("113957","Pow. bolesławiecki","113937","4","0","1"),
("113958","Pow. dzierżoniowski","113937","5","0","1"),
("113959","Pow. głogowski","113937","6","0","1"),
("113960","Pow. górowski","113937","7","0","1"),
("113961","Pow. jaworski","113937","8","0","1"),
("113962","Pow. jeleniogórski","113937","9","0","1"),
("113963","Pow. kamiennogórski","113937","10","0","1"),
("113964","Pow. kłodzki","113937","11","0","1"),
("113965","Pow. legnicki","113937","12","0","1"),
("113966","Pow. lubański","113937","13","0","1"),
("113967","Pow. lubiński","113937","14","0","1"),
("113968","Pow. lwówecki","113937","15","0","1"),
("113969","Pow. milicki","113937","16","0","1"),
("113970","Pow. oleśnicki","113937","17","0","1"),
("113971","Pow. oławski","113937","18","0","1"),
("113972","Pow. polkowicki","113937","19","0","1"),
("113973","Pow. strzeliński","113937","20","0","1"),
("113974","Pow. średzki","113937","21","0","1"),
("113975","Pow. świdnicki","113937","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113976","Pow. trzebnicki","113937","23","0","1"),
("113977","Pow. wałbrzyski","113937","24","0","1"),
("113978","Pow. wołowski","113937","25","0","1"),
("113979","Pow. wrocławski","113937","26","0","1"),
("113980","Pow. ząbkowicki","113937","27","0","1"),
("113981","Pow. zgorzelecki","113937","28","0","1"),
("113982","Pow. złotoryjski","113937","29","0","1"),
("113983","Bydgoszcz","113938","0","0","0"),
("113984","Grudziądz","113938","1","0","1"),
("113985","Toruń","113938","2","0","0"),
("113986","Włocławek","113938","3","0","1"),
("113987","Pow. aleksandrowski","113938","4","0","1"),
("113988","Pow. brodnicki","113938","5","0","1"),
("113989","Pow. bydgoski","113938","6","0","1"),
("113990","Pow. chełmiński","113938","7","0","1"),
("113991","Pow. golubsko-dobrzyński","113938","8","0","1"),
("113992","Pow. grudziądzki","113938","9","0","1"),
("113993","Pow. inowrocławski","113938","10","0","1"),
("113994","Pow. lipnowski","113938","11","0","1"),
("113995","Pow. mogileński","113938","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("113996","Pow. nakielski","113938","13","0","1"),
("113997","Pow. radziejowski","113938","14","0","1"),
("113998","Pow. rypiński","113938","15","0","1"),
("113999","Pow. sępoleński","113938","16","0","1"),
("114000","Pow. świecki","113938","17","0","1"),
("114001","Pow. toruński","113938","18","0","1"),
("114002","Pow. tucholski","113938","19","0","1"),
("114003","Pow. wąbrzeski","113938","20","0","1"),
("114004","Pow. włocławski","113938","21","0","1"),
("114005","Pow. żniński","113938","22","0","1"),
("114006","Biała Podlaska","113939","0","0","1"),
("114007","Chełm","113939","1","0","1"),
("114008","Lublin","113939","2","0","0"),
("114009","Zamość","113939","3","0","1"),
("114010","Pow. bialski","113939","4","0","1"),
("114011","Pow. biłgorajski","113939","5","0","1"),
("114012","Pow. chełmski","113939","6","0","1"),
("114013","Pow. hrubieszowski","113939","7","0","1"),
("114014","Pow. janowski","113939","8","0","1"),
("114015","Pow. krasnostawski","113939","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114016","Pow. kraśnicki","113939","10","0","1"),
("114017","Pow. lubartowski","113939","11","0","1"),
("114018","Pow. lubelski","113939","12","0","1"),
("114019","Pow. łęczyński","113939","13","0","1"),
("114020","Pow. łukowski","113939","14","0","1"),
("114021","Pow. opolski","113939","15","0","1"),
("114022","Pow. parczewski","113939","16","0","1"),
("114023","Pow. puławski","113939","17","0","1"),
("114024","Pow. radzyński","113939","18","0","1"),
("114025","Pow. rycki","113939","19","0","1"),
("114026","Pow. świdnicki","113939","20","0","1"),
("114027","Pow. tomaszowski","113939","21","0","1"),
("114028","Pow. włodawski","113939","22","0","1"),
("114029","Pow. zamojski","113939","23","0","1"),
("114030","Gorzów Wielkopolski","113940","0","0","1"),
("114031","Zielona Góra","113940","1","0","1"),
("114032","Pow. gorzowski","113940","2","0","1"),
("114033","Pow. krośnieński","113940","3","0","1"),
("114034","Pow. międzyrzecki","113940","4","0","1"),
("114035","Pow. nowosolski","113940","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114036","Pow. słubicki","113940","6","0","1"),
("114037","Pow. strzelecko-drezdenecki","113940","7","0","1"),
("114038","Pow. sulęciński","113940","8","0","1"),
("114039","Pow. świebodziński","113940","9","0","1"),
("114040","Pow. wschowski","113940","10","0","1"),
("114041","Pow. zielonogórski","113940","11","0","1"),
("114042","Pow. żagański","113940","12","0","1"),
("114043","Pow. żarski","113940","13","0","1"),
("114044","Łódź","113941","0","0","0"),
("114045","Piotrków Trybunalski","113941","1","0","1"),
("114046","Skierniewice","113941","2","0","1"),
("114047","Pow. bełchatowski","113941","3","0","1"),
("114048","Pow. brzeziński","113941","4","0","1"),
("114049","Pow. kutnowski","113941","5","0","1"),
("114050","Pow. łaski","113941","6","0","1"),
("114051","Pow. łęczycki","113941","7","0","1"),
("114052","Pow. łowicki","113941","8","0","1"),
("114053","Pow. łódzki wschodni","113941","9","0","1"),
("114054","Pow. opoczyński","113941","10","0","1"),
("114055","Pow. pabianicki","113941","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114056","Pow. pajęczański","113941","12","0","1"),
("114057","Pow. piotrkowski","113941","13","0","1"),
("114058","Pow. poddębicki","113941","14","0","1"),
("114059","Pow. radomszczański","113941","15","0","1"),
("114060","Pow. rawski","113941","16","0","1"),
("114061","Pow. sieradzki","113941","17","0","1"),
("114062","Pow. skierniewicki","113941","18","0","1"),
("114063","Pow. tomaszowski","113941","19","0","1"),
("114064","Pow. wieluński","113941","20","0","1"),
("114065","Pow. wieruszowski","113941","21","0","1"),
("114066","Pow. zduńskowolski","113941","22","0","1"),
("114067","Pow. zgierski","113941","23","0","1"),
("114068","Kraków","113942","0","0","0"),
("114069","Nowy Sącz","113942","1","0","1"),
("114070","Tarnów","113942","2","0","1"),
("114071","Pow. bocheński","113942","3","0","1"),
("114072","Pow. brzeski","113942","4","0","1"),
("114073","Pow. chrzanowski","113942","5","0","1"),
("114074","Pow. dąbrowski","113942","6","0","1"),
("114075","Pow. gorlicki","113942","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114076","Pow. krakowski","113942","8","0","1"),
("114077","Pow. limanowski","113942","9","0","1"),
("114078","Pow. miechowski","113942","10","0","1"),
("114079","Pow. myślenicki","113942","11","0","1"),
("114080","Pow. nowosądecki","113942","12","0","1"),
("114081","Pow. nowotarski","113942","13","0","1"),
("114082","Pow. olkuski","113942","14","0","1"),
("114083","Pow. oświęcimski","113942","15","0","1"),
("114084","Pow. proszowicki","113942","16","0","1"),
("114085","Pow. suski","113942","17","0","1"),
("114086","Pow. tarnowski","113942","18","0","1"),
("114087","Pow. tatrzański","113942","19","0","1"),
("114088","Pow. wadowicki","113942","20","0","1"),
("114089","Pow. wielicki","113942","21","0","1"),
("114090","Ostrołęka","113943","0","0","1"),
("114091","Płock","113943","1","0","1"),
("114092","Radom","113943","2","0","1"),
("114093","Siedlce","113943","3","0","1"),
("114094","Warszawa","113943","4","0","0"),
("114095","Pow. białobrzeski","113943","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114096","Pow. ciechanowski","113943","6","0","1"),
("114097","Pow. garwoliński","113943","7","0","1"),
("114098","Pow. gostyniński","113943","8","0","1"),
("114099","Pow. grodziski","113943","9","0","1"),
("114100","Pow. grójecki","113943","10","0","1"),
("114101","Pow. kozienicki","113943","11","0","1"),
("114102","Pow. legionowski","113943","12","0","1"),
("114103","Pow. lipski","113943","13","0","1"),
("114104","Pow. łosicki","113943","14","0","1"),
("114105","Pow. makowski","113943","15","0","1"),
("114106","Pow. miński","113943","16","0","1"),
("114107","Pow. mławski","113943","17","0","1"),
("114108","Pow. nowodworski","113943","18","0","1"),
("114109","Pow. ostrołęcki","113943","19","0","1"),
("114110","Pow. ostrowski","113943","20","0","1"),
("114111","Pow. otwocki","113943","21","0","1"),
("114112","Pow. piaseczyński","113943","22","0","0"),
("114113","Pow. płocki","113943","23","0","1"),
("114114","Pow. płoński","113943","24","0","1"),
("114115","Pow. pruszkowski","113943","25","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114116","Pow. przasnyski","113943","26","0","1"),
("114117","Pow. przysuski","113943","27","0","1"),
("114118","Pow. pułtuski","113943","28","0","1"),
("114119","Pow. radomski","113943","29","0","1"),
("114120","Pow. siedlecki","113943","30","0","1"),
("114121","Pow. sierpecki","113943","31","0","1"),
("114122","Pow. sochaczewski","113943","32","0","1"),
("114123","Pow. sokołowski","113943","33","0","1"),
("114124","Pow. szydłowiecki","113943","34","0","1"),
("114125","Pow. warszawski zachodni","113943","35","0","1"),
("114126","Pow. węgrowski","113943","36","0","1"),
("114127","Pow. wołomiński","113943","37","0","0"),
("114128","Pow. wyszkowski","113943","38","0","1"),
("114129","Pow. zwoleński","113943","39","0","1"),
("114130","Pow. żuromiński","113943","40","0","1"),
("114131","Pow. żyrardowski","113943","41","0","1"),
("114132","Opole","113944","0","0","0"),
("114133","Pow. brzeski","113944","1","0","1"),
("114134","Pow. głubczycki","113944","2","0","1"),
("114135","Pow. kędzierzyńsko-kozielski","113944","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114136","Pow. kluczborski","113944","4","0","1"),
("114137","Pow. krapkowicki","113944","5","0","1"),
("114138","Pow. namysłowski","113944","6","0","1"),
("114139","Pow. nyski","113944","7","0","1"),
("114140","Pow. oleski","113944","8","0","1"),
("114141","Pow. opolski","113944","9","0","1"),
("114142","Pow. prudnicki","113944","10","0","1"),
("114143","Pow. strzelecki","113944","11","0","1"),
("114144","Krosno","113945","0","0","1"),
("114145","Przemyśl","113945","1","0","1"),
("114146","Rzeszów","113945","2","0","0"),
("114147","Tarnobrzeg","113945","3","0","1"),
("114148","Pow. bieszczadzki","113945","4","0","1"),
("114149","Pow. brzozowski","113945","5","0","1"),
("114150","Pow. dębicki","113945","6","0","1"),
("114151","Pow. jarosławski","113945","7","0","1"),
("114152","Pow. jasielski","113945","8","0","1"),
("114153","Pow. kolbuszowski","113945","9","0","1"),
("114154","Pow. krośnieński","113945","10","0","1"),
("114155","Pow. leski","113945","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114156","Pow. leżajski","113945","12","0","1"),
("114157","Pow. lubaczowski","113945","13","0","1"),
("114158","Pow. łańcucki","113945","14","0","1"),
("114159","Pow. mielecki","113945","15","0","1"),
("114160","Pow. niżański","113945","16","0","1"),
("114161","Pow. przemyski","113945","17","0","1"),
("114162","Pow. przeworski","113945","18","0","1"),
("114163","Pow. ropczycko-sędziszowski","113945","19","0","1"),
("114164","Pow. rzeszowski","113945","20","0","1"),
("114165","Pow. sanocki","113945","21","0","1"),
("114166","Pow. stalowowolski","113945","22","0","1"),
("114167","Pow. strzyżowski","113945","23","0","1"),
("114168","Pow. tarnobrzeski","113945","24","0","1"),
("114169","Białystok","113946","0","0","0"),
("114170","Łomża","113946","1","0","1"),
("114171","Suwałki","113946","2","0","1"),
("114172","Pow. augustowski","113946","3","0","1"),
("114173","Pow. białostocki","113946","4","0","1"),
("114174","Pow. bielski","113946","5","0","1"),
("114175","Pow. grajewski","113946","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114176","Pow. hajnowski","113946","7","0","1"),
("114177","Pow. kolneński","113946","8","0","1"),
("114178","Pow. łomżyński","113946","9","0","1"),
("114179","Pow. moniecki","113946","10","0","1"),
("114180","Pow. sejneński","113946","11","0","1"),
("114181","Pow. siemiatycki","113946","12","0","1"),
("114182","Pow. sokólski","113946","13","0","1"),
("114183","Pow. suwalski","113946","14","0","1"),
("114184","Pow. wysokomazowiecki","113946","15","0","1"),
("114185","Pow. zambrowski","113946","16","0","1"),
("114186","Gdańsk","113947","0","0","0"),
("114187","Gdynia","113947","1","0","0"),
("114188","Słupsk","113947","2","0","1"),
("114189","Sopot","113947","3","0","0"),
("114190","Pow. bytowski","113947","4","0","1"),
("114191","Pow. chojnicki","113947","5","0","1"),
("114192","Pow. człuchowski","113947","6","0","1"),
("114193","Pow. gdański","113947","7","0","1"),
("114194","Pow. kartuski","113947","8","0","1"),
("114195","Pow. kościerski","113947","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114196","Pow. kwidzyński","113947","10","0","1"),
("114197","Pow. lęborski","113947","11","0","1"),
("114198","Pow. malborski","113947","12","0","1"),
("114199","Pow. nowodworski","113947","13","0","1"),
("114200","Pow. pucki","113947","14","0","1"),
("114201","Pow. słupski","113947","15","0","1"),
("114202","Pow. starogardzki","113947","16","0","1"),
("114203","Pow. sztumski","113947","17","0","1"),
("114204","Pow. tczewski","113947","18","0","1"),
("114205","Pow. wejherowski","113947","19","0","0"),
("114206","Bielsko-Biała","113948","0","0","0"),
("114207","Bytom","113948","1","0","0"),
("114208","Chorzów","113948","2","0","1"),
("114209","Częstochowa","113948","3","0","0"),
("114210","Dąbrowa Górnicza","113948","4","0","1"),
("114211","Gliwice","113948","5","0","0"),
("114212","Jastrzębie-Zdrój","113948","6","0","1"),
("114213","Jaworzno","113948","7","0","1"),
("114214","Katowice","113948","8","0","0"),
("114215","Mysłowice","113948","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114216","Piekary Śląskie","113948","10","0","1"),
("114217","Ruda Śląska","113948","11","0","1"),
("114218","Rybnik","113948","12","0","1"),
("114219","Siemianowice Śląskie","113948","13","0","1"),
("114220","Sosnowiec","113948","14","0","0"),
("114221","Świętochłowice","113948","15","0","1"),
("114222","Tychy","113948","16","0","0"),
("114223","Zabrze","113948","17","0","1"),
("114224","Żory","113948","18","0","1"),
("114225","Pow. będziński","113948","19","0","1"),
("114226","Pow. bielski","113948","20","0","1"),
("114227","Pow. bieruńsko-lędziński","113948","21","0","1"),
("114228","Pow. cieszyński","113948","22","0","1"),
("114229","Pow. częstochowski","113948","23","0","1"),
("114230","Pow. gliwicki","113948","24","0","1"),
("114231","Pow. kłobucki","113948","25","0","1"),
("114232","Pow. lubliniecki","113948","26","0","1"),
("114233","Pow. mikołowski","113948","27","0","1"),
("114234","Pow. myszkowski","113948","28","0","1"),
("114235","Pow. pszczyński","113948","29","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114236","Pow. raciborski","113948","30","0","1"),
("114237","Pow. rybnicki","113948","31","0","1"),
("114238","Pow. tarnogórski","113948","32","0","1"),
("114239","Pow. wodzisławski","113948","33","0","1"),
("114240","Pow. zawierciański","113948","34","0","1"),
("114241","Pow. żywiecki","113948","35","0","1"),
("114242","Kielce","113949","0","0","1"),
("114243","Pow. buski","113949","1","0","1"),
("114244","Pow. jędrzejowski","113949","2","0","1"),
("114245","Pow. kazimierski","113949","3","0","1"),
("114246","Pow. kielecki","113949","4","0","1"),
("114247","Pow. konecki","113949","5","0","1"),
("114248","Pow. opatowski","113949","6","0","1"),
("114249","Pow. ostrowiecki","113949","7","0","1"),
("114250","Pow. pińczowski","113949","8","0","1"),
("114251","Pow. sandomierski","113949","9","0","1"),
("114252","Pow. skarżyski","113949","10","0","1"),
("114253","Pow. starachowicki","113949","11","0","1"),
("114254","Pow. staszowski","113949","12","0","1"),
("114255","Pow. włoszczowski","113949","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114256","Elbląg","113950","0","0","1"),
("114257","Olsztyn","113950","1","0","1"),
("114258","Pow. bartoszycki","113950","2","0","1"),
("114259","Pow. braniewski","113950","3","0","1"),
("114260","Pow. działdowski","113950","4","0","1"),
("114261","Pow. elbląski","113950","5","0","1"),
("114262","Pow. ełcki","113950","6","0","1"),
("114263","Pow. giżycki","113950","7","0","1"),
("114264","Pow. gołdapski","113950","8","0","1"),
("114265","Pow. iławski","113950","9","0","1"),
("114266","Pow. kętrzyński","113950","10","0","1"),
("114267","Pow. lidzbarski","113950","11","0","1"),
("114268","Pow. mrągowski","113950","12","0","1"),
("114269","Pow. nidzicki","113950","13","0","1"),
("114270","Pow. nowomiejski","113950","14","0","1"),
("114271","Pow. olecki","113950","15","0","1"),
("114272","Pow. olsztyński","113950","16","0","1"),
("114273","Pow. ostródzki","113950","17","0","1"),
("114274","Pow. piski","113950","18","0","1"),
("114275","Pow. szczycieński","113950","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114276","Pow. węgorzewski","113950","20","0","1"),
("114277","Kalisz","113951","0","0","1"),
("114278","Konin","113951","1","0","1"),
("114279","Leszno","113951","2","0","1"),
("114280","Poznań","113951","3","0","0"),
("114281","Pow. chodzieski","113951","4","0","1"),
("114282","Pow. czarnkowsko-trzcianecki","113951","5","0","1"),
("114283","Pow. gnieźnieński","113951","6","0","1"),
("114284","Pow. gostyński","113951","7","0","1"),
("114285","Pow. grodziski","113951","8","0","1"),
("114286","Pow. jarociński","113951","9","0","1"),
("114287","Pow. kaliski","113951","10","0","1"),
("114288","Pow. kępiński","113951","11","0","1"),
("114289","Pow. kolski","113951","12","0","1"),
("114290","Pow. koniński","113951","13","0","1"),
("114291","Pow. kościański","113951","14","0","1"),
("114292","Pow. krotoszyński","113951","15","0","1"),
("114293","Pow. leszczyński","113951","16","0","1"),
("114294","Pow. międzychodzki","113951","17","0","1"),
("114295","Pow. nowotomyski","113951","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114296","Pow. obornicki","113951","19","0","1"),
("114297","Pow. ostrowski","113951","20","0","1"),
("114298","Pow. ostrzeszowski","113951","21","0","1"),
("114299","Pow. pilski","113951","22","0","1"),
("114300","Pow. pleszewski","113951","23","0","1"),
("114301","Pow. poznański","113951","24","0","1"),
("114302","Pow. rawicki","113951","25","0","1"),
("114303","Pow. słupecki","113951","26","0","1"),
("114304","Pow. szamotulski","113951","27","0","1"),
("114305","Pow. średzki","113951","28","0","1"),
("114306","Pow. śremski","113951","29","0","1"),
("114307","Pow. turecki","113951","30","0","1"),
("114308","Pow. wągrowiecki","113951","31","0","1"),
("114309","Pow. wolsztyński","113951","32","0","1"),
("114310","Pow. wrzesiński","113951","33","0","1"),
("114311","Pow. złotowski","113951","34","0","1"),
("114312","Koszalin","113952","0","0","0"),
("114313","Szczecin","113952","1","0","0"),
("114314","Świnoujście","113952","2","0","1"),
("114315","Pow. białogardzki","113952","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114316","Pow. choszczeński","113952","4","0","1"),
("114317","Pow. drawski","113952","5","0","1"),
("114318","Pow. goleniowski","113952","6","0","1"),
("114319","Pow. gryficki","113952","7","0","1"),
("114320","Pow. gryfiński","113952","8","0","1"),
("114321","Pow. kamieński","113952","9","0","1"),
("114322","Pow. kołobrzeski","113952","10","0","1"),
("114323","Pow. koszaliński","113952","11","0","1"),
("114324","Pow. łobeski","113952","12","0","1"),
("114325","Pow. myśliborski","113952","13","0","1"),
("114326","Pow. policki","113952","14","0","1"),
("114327","Pow. pyrzycki","113952","15","0","1"),
("114328","Pow. sławieński","113952","16","0","1"),
("114329","Pow. stargardzki","113952","17","0","1"),
("114330","Pow. szczecinecki","113952","18","0","1"),
("114331","Pow. świdwiński","113952","19","0","1"),
("114332","Pow. wałecki","113952","20","0","1"),
("114333","Cieplice Śląskie-Zdrój","113953","0","0","1"),
("114334","Czarne","113953","1","0","1"),
("114335","Dąbrówka","113953","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114336","Goduszyn","113953","3","0","1"),
("114337","Grabary","113953","4","0","1"),
("114338","Jagniątków","113953","5","0","1"),
("114339","Maciejowa","113953","6","0","1"),
("114340","Paulinów","113953","7","0","1"),
("114341","Sobieszów","113953","8","0","1"),
("114342","Strupice","113953","9","0","1"),
("114343","Zabobrze","113953","10","0","1"),
("114344","Pozostałe","113953","11","0","1"),
("114345","Fabryczna","113956","0","0","1"),
("114346","Krzyki","113956","1","0","1"),
("114347","Psie Pole","113956","2","0","1"),
("114348","Stare Miasto","113956","3","0","1"),
("114349","Śródmieście","113956","4","0","1"),
("114350","Inne","113956","5","0","1"),
("114351","Bartodzieje Małe","113983","0","0","1"),
("114352","Bartodzieje Wielkie","113983","1","0","1"),
("114353","Bielawy","113983","2","0","1"),
("114354","Błonie","113983","3","0","1"),
("114355","Bocianowo","113983","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114356","Czyżkówko","113983","5","0","1"),
("114357","Fordon","113983","6","0","1"),
("114358","Górzyskowo","113983","7","0","1"),
("114359","Kapuściska","113983","8","0","1"),
("114360","Okole","113983","9","0","1"),
("114361","Osiedle Leśne","113983","10","0","1"),
("114362","Osowa Góra","113983","11","0","1"),
("114363","Skrzetusko","113983","12","0","1"),
("114364","Szwederowo","113983","13","0","1"),
("114365","Wilczak","113983","14","0","1"),
("114366","Pozostałe","113983","15","0","1"),
("114367","Bielany","113985","0","0","1"),
("114368","Bielawy","113985","1","0","1"),
("114369","Bydgoskie Przedmieście","113985","2","0","1"),
("114370","Chełmińskie Przedmieście","113985","3","0","1"),
("114371","Jakubskie Przedmieście","113985","4","0","1"),
("114372","Koniuchy","113985","5","0","1"),
("114373","Mokre","113985","6","0","1"),
("114374","Na Skarpie","113985","7","0","1"),
("114375","Podgórz","113985","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114376","Rubinkowo","113985","9","0","1"),
("114377","Rudak","113985","10","0","1"),
("114378","Rybaki","113985","11","0","1"),
("114379","Stare Miasto","113985","12","0","1"),
("114380","Stawki","113985","13","0","1"),
("114381","Wrzosy","113985","14","0","1"),
("114382","Pozostałe","113985","15","0","1"),
("114383","Bazylianówka","114008","0","0","1"),
("114384","Bronowice","114008","1","0","1"),
("114385","Czechów Górny","114008","2","0","1"),
("114386","Czuby","114008","3","0","1"),
("114387","Dziesiąta","114008","4","0","1"),
("114388","Felin","114008","5","0","1"),
("114389","Kalinowszczyzna","114008","6","0","1"),
("114390","Kośminek","114008","7","0","1"),
("114391","Rudnik","114008","8","0","1"),
("114392","Sławinek","114008","9","0","1"),
("114393","Śródmieście","114008","10","0","1"),
("114394","Tatary","114008","11","0","1"),
("114395","Węglin","114008","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114396","Wieniawka","114008","13","0","1"),
("114397","Wrotków","114008","14","0","1"),
("114398","Pozostałe","114008","15","0","1"),
("114399","Bałuty","114044","0","0","1"),
("114400","Górna","114044","1","0","1"),
("114401","Polesie","114044","2","0","1"),
("114402","Śródmieście","114044","3","0","1"),
("114403","Widzew","114044","4","0","1"),
("114404","Pozostałe","114044","5","0","1"),
("114405","Krowodrza","114068","0","0","1"),
("114406","Nowa Huta","114068","1","0","1"),
("114407","Podgórze","114068","2","0","1"),
("114408","Śródmieście","114068","3","0","1"),
("114409","Pozostałe","114068","4","0","1"),
("114410","Bemowo","114094","0","0","1"),
("114411","Białołęka","114094","1","0","1"),
("114412","Bielany","114094","2","0","1"),
("114413","Mokotów","114094","3","0","1"),
("114414","Ochota","114094","4","0","1"),
("114415","Praga Południe","114094","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114416","Praga Północ","114094","6","0","1"),
("114417","Rembertów","114094","7","0","1"),
("114418","Śródmieście","114094","8","0","1"),
("114419","Targówek","114094","9","0","1"),
("114420","Ursus","114094","10","0","1"),
("114421","Ursynów","114094","11","0","1"),
("114422","Wawer","114094","12","0","1"),
("114423","Wesoła","114094","13","0","1"),
("114424","Wilanów","114094","14","0","1"),
("114425","Włochy","114094","15","0","1"),
("114426","Wola","114094","16","0","1"),
("114427","Żoliborz","114094","17","0","1"),
("114428","Inne","114094","18","0","1"),
("114429","Góra Kalwaria","114112","0","0","1"),
("114430","Konstancin-Jeziorna","114112","1","0","1"),
("114431","Piaseczno","114112","2","0","1"),
("114432","Tarczyn","114112","3","0","1"),
("114433","Pozostałe","114112","4","0","1"),
("114434","Brwinów","114115","0","0","1"),
("114435","Piastów","114115","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114436","Pruszków","114115","2","0","1"),
("114437","Pozostałe","114115","3","0","1"),
("114438","Kobyłka","114127","0","0","1"),
("114439","Marki","114127","1","0","1"),
("114440","Radzymin","114127","2","0","1"),
("114441","Tłuszcz","114127","3","0","1"),
("114442","Wołomin","114127","4","0","1"),
("114443","Ząbki","114127","5","0","1"),
("114444","Zielonka","114127","6","0","1"),
("114445","Pozostałe","114127","7","0","1"),
("114446","Bierkowice","114132","0","0","1"),
("114447","Gosławice","114132","1","0","1"),
("114448","Groszowice","114132","2","0","1"),
("114449","Grudzice","114132","3","0","1"),
("114450","Kolonia Gosławicka","114132","4","0","1"),
("114451","Malina","114132","5","0","1"),
("114452","Nowa Wieś Królewska","114132","6","0","1"),
("114453","Półwieś","114132","7","0","1"),
("114454","Szczepanowice","114132","8","0","1"),
("114455","Wójtowa Wieś","114132","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114456","Wróblin","114132","10","0","1"),
("114457","Zakrzów","114132","11","0","1"),
("114458","Zaodrze","114132","12","0","1"),
("114459","Pozostałe","114132","13","0","1"),
("114460","Drabinianka","114146","0","0","1"),
("114461","Dworzysko","114146","1","0","1"),
("114462","Miłocin","114146","2","0","1"),
("114463","Pobitno","114146","3","0","1"),
("114464","Przybyszówka","114146","4","0","1"),
("114465","Słocina","114146","5","0","1"),
("114466","Staromieście","114146","6","0","1"),
("114467","Staroniwa","114146","7","0","1"),
("114468","Szajerówka","114146","8","0","1"),
("114469","Wilkowyja","114146","9","0","1"),
("114470","Zalesie","114146","10","0","1"),
("114471","Załęże","114146","11","0","1"),
("114472","Zwięczyca","114146","12","0","1"),
("114473","Pozostałe","114146","13","0","1"),
("114474","Antoniuk","114169","0","0","1"),
("114475","Bacieczki","114169","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114476","Białostoczek","114169","2","0","1"),
("114477","Bojary","114169","3","0","1"),
("114478","Dojlidy","114169","4","0","1"),
("114479","Dojlidy Górne","114169","5","0","1"),
("114480","Dziesięciny","114169","6","0","1"),
("114481","Nowe Miasto","114169","7","0","1"),
("114482","Skorupy","114169","8","0","1"),
("114483","Słoboda","114169","9","0","1"),
("114484","Starosielce","114169","10","0","1"),
("114485","Wygoda","114169","11","0","1"),
("114486","Wysoki Stoczek","114169","12","0","1"),
("114487","Zagórki","114169","13","0","1"),
("114488","Zawady","114169","14","0","1"),
("114489","Pozostałe","114169","15","0","1"),
("114490","Brzeźno","114186","0","0","1"),
("114491","Chełm","114186","1","0","1"),
("114492","Jasień","114186","2","0","1"),
("114493","Kiełpino Górne","114186","3","0","1"),
("114494","Kokoszki","114186","4","0","1"),
("114495","Lipce","114186","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114496","Łostowice","114186","6","0","1"),
("114497","Oliwa","114186","7","0","1"),
("114498","Osowa","114186","8","0","1"),
("114499","Przymorze","114186","9","0","1"),
("114500","Siedlce","114186","10","0","1"),
("114501","Sobieszewo","114186","11","0","1"),
("114502","Suchanino","114186","12","0","1"),
("114503","Wrzeszcz","114186","13","0","1"),
("114504","Zakoniczyn","114186","14","0","1"),
("114505","Pozostałe","114186","15","0","1"),
("114506","Chwarzno","114187","0","0","1"),
("114507","Chylonia","114187","1","0","1"),
("114508","Cisowa","114187","2","0","1"),
("114509","Działki Leśne","114187","3","0","1"),
("114510","Kamienna Góra","114187","4","0","1"),
("114511","Leszczynki","114187","5","0","1"),
("114512","Mały Kack","114187","6","0","1"),
("114513","Obłuże","114187","7","0","1"),
("114514","Oksywie","114187","8","0","1"),
("114515","Orłowo","114187","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114516","Pogórze","114187","10","0","1"),
("114517","Redłowo","114187","11","0","1"),
("114518","Wiczlino","114187","12","0","1"),
("114519","Wielki Kack","114187","13","0","1"),
("114520","Wzgórze Nowotki","114187","14","0","1"),
("114521","Pozostałe","114187","15","0","1"),
("114522","Brodwino","114189","0","0","1"),
("114523","Kamienny Potok","114189","1","0","1"),
("114524","Przylesie","114189","2","0","1"),
("114525","Sopot Dolny","114189","3","0","1"),
("114526","Sopot Górny","114189","4","0","1"),
("114527","Wyścigi","114189","5","0","1"),
("114528","Pozostałe","114189","6","0","1"),
("114529","Reda","114205","0","0","1"),
("114530","Rumia","114205","1","0","1"),
("114531","Wejherowo","114205","2","0","1"),
("114532","Pozostałe","114205","3","0","1"),
("114533","Aleksandrowice","114206","0","0","1"),
("114534","Hałcnów","114206","1","0","1"),
("114535","Kamienica","114206","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114536","Komorowice Krakowskie","114206","3","0","1"),
("114537","Komorowice Śląskie","114206","4","0","1"),
("114538","Leszczyny","114206","5","0","1"),
("114539","Lipnik","114206","6","0","1"),
("114540","Mikuszowice Krakowskie","114206","7","0","1"),
("114541","Mikuszowice Śląskie","114206","8","0","1"),
("114542","Olszówka Dolna","114206","9","0","1"),
("114543","Olszówka Górna","114206","10","0","1"),
("114544","Stare Bielsko","114206","11","0","1"),
("114545","Straconka","114206","12","0","1"),
("114546","Wapienica","114206","13","0","1"),
("114547","Złote Łany","114206","14","0","1"),
("114548","Pozostałe","114206","15","0","1"),
("114549","Bobrek","114207","0","0","1"),
("114550","Górniki","114207","1","0","1"),
("114551","Karb","114207","2","0","1"),
("114552","Łagiewniki","114207","3","0","1"),
("114553","Miechowice","114207","4","0","1"),
("114554","Rozbark","114207","5","0","1"),
("114555","Stolarzowice","114207","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114556","Stroszek","114207","7","0","1"),
("114557","Sucha Góra","114207","8","0","1"),
("114558","Szombierki","114207","9","0","1"),
("114559","Pozostałe","114207","10","0","1"),
("114560","Błeszno","114209","0","0","1"),
("114561","Dźbów","114209","1","0","1"),
("114562","Grabówka","114209","2","0","1"),
("114563","Kawodrza Dolna","114209","3","0","1"),
("114564","Lisiniec","114209","4","0","1"),
("114565","Liszka Dolna","114209","5","0","1"),
("114566","Mirów","114209","6","0","1"),
("114567","Ostatni Grosz","114209","7","0","1"),
("114568","Parkitka","114209","8","0","1"),
("114569","Raków","114209","9","0","1"),
("114570","Rząsawy","114209","10","0","1"),
("114571","Sabinów","114209","11","0","1"),
("114572","Stradom","114209","12","0","1"),
("114573","Wrzosowiak","114209","13","0","1"),
("114574","Zawodzie","114209","14","0","1"),
("114575","Pozostałe","114209","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114576","Bojków","114211","0","0","1"),
("114577","Brzezinka","114211","1","0","1"),
("114578","Czechowice","114211","2","0","1"),
("114579","Ligota Zabrska","114211","3","0","1"),
("114580","Łabędy","114211","4","0","1"),
("114581","Ostropa","114211","5","0","1"),
("114582","Sośnica","114211","6","0","1"),
("114583","Stare Gliwice","114211","7","0","1"),
("114584","Szobiszowice","114211","8","0","1"),
("114585","Trynek","114211","9","0","1"),
("114586","Wilcze Gardło","114211","10","0","1"),
("114587","Wójtowa Wieś","114211","11","0","1"),
("114588","Żerniki","114211","12","0","1"),
("114589","Pozostałe","114211","13","0","1"),
("114590","Bogucice","114214","0","0","1"),
("114591","Brynów","114214","1","0","1"),
("114592","Dąb","114214","2","0","1"),
("114593","Giszowiec","114214","3","0","1"),
("114594","Józefowiec","114214","4","0","1"),
("114595","Kostuchna","114214","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114596","Koszutka","114214","6","0","1"),
("114597","Ligota","114214","7","0","1"),
("114598","Ochojec","114214","8","0","1"),
("114599","Panewniki","114214","9","0","1"),
("114600","Piotrowice","114214","10","0","1"),
("114601","Podlesie","114214","11","0","1"),
("114602","Wełnowiec","114214","12","0","1"),
("114603","Zarzecze","114214","13","0","1"),
("114604","Zawodzie","114214","14","0","1"),
("114605","Pozostale","114214","15","0","1"),
("114606","Cieśle","114220","0","0","1"),
("114607","Dańdówka","114220","1","0","1"),
("114608","Dębowa Góra","114220","2","0","1"),
("114609","Józefów","114220","3","0","1"),
("114610","Kazimierz","114220","4","0","1"),
("114611","Klimontów","114220","5","0","1"),
("114612","Maczki","114220","6","0","1"),
("114613","Milowice","114220","7","0","1"),
("114614","Niwka","114220","8","0","1"),
("114615","Ostrowy Górnicze","114220","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114616","Pogoń","114220","10","0","1"),
("114617","Sielec","114220","11","0","1"),
("114618","Stary Sosnowiec","114220","12","0","1"),
("114619","Środula","114220","13","0","1"),
("114620","Zagórze","114220","14","0","1"),
("114621","Pozostale","114220","15","0","1"),
("114622","Cielmice","114222","0","0","1"),
("114623","Czułów","114222","1","0","1"),
("114624","Glinka","114222","2","0","1"),
("114625","Jaroszowice","114222","3","0","1"),
("114626","Mąkołowiec","114222","4","0","1"),
("114627","Paprocany","114222","5","0","1"),
("114628","Suble","114222","6","0","1"),
("114629","Urbanowice","114222","7","0","1"),
("114630","Wartogłowiec","114222","8","0","1"),
("114631","Wilkowyje","114222","9","0","1"),
("114632","Zwierzyniec","114222","10","0","1"),
("114633","Żwaków","114222","11","0","1"),
("114634","Pozostałe","114222","12","0","1"),
("114635","Grunwald","114280","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114636","Jeżyce","114280","1","0","1"),
("114637","Nowe Miasto","114280","2","0","1"),
("114638","Stare Miasto","114280","3","0","1"),
("114639","Wilda","114280","4","0","1"),
("114640","Pozostałe","114280","5","0","1"),
("114641","Chełmoniewo","114312","0","0","1"),
("114642","Dzierżęcino","114312","1","0","1"),
("114643","Lubiatowo","114312","2","0","1"),
("114644","Raduszka","114312","3","0","1"),
("114645","Rokosowo","114312","4","0","1"),
("114646","Pozostałe","114312","5","0","1"),
("114647","Bezrzecze","114313","0","0","1"),
("114648","Bukowe-Klęskowo","114313","1","0","1"),
("114649","Bukowo","114313","2","0","1"),
("114650","Centrum","114313","3","0","1"),
("114651","Dąbie","114313","4","0","1"),
("114652","Drzetowo","114313","5","0","1"),
("114653","Głębokie","114313","6","0","1"),
("114654","Grabowo","114313","7","0","1"),
("114655","Gumieńce","114313","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114656","Kijewo","114313","9","0","1"),
("114657","Niebuszewo","114313","10","0","1"),
("114658","Osów","114313","11","0","1"),
("114659","Pilchowo","114313","12","0","1"),
("114660","Płonia","114313","13","0","1"),
("114661","Podjuchy","114313","14","0","1"),
("114662","Pogodno","114313","15","0","1"),
("114663","Pomorzany","114313","16","0","1"),
("114664","Skolwin","114313","17","0","1"),
("114665","Stare Miasto","114313","18","0","1"),
("114666","Stołczyn","114313","19","0","1"),
("114667","Świerczewo","114313","20","0","1"),
("114668","Warszewo","114313","21","0","1"),
("114669","Wielgowo","114313","22","0","1"),
("114670","Zdroje","114313","23","0","1"),
("114671","Żelechowa","114313","24","0","1"),
("114672","Pozostałe","114313","25","0","1"),
("114673","Dolnośląskie","112741","0","0","0"),
("114674","Kujawsko-pomorskie","112741","1","0","0"),
("114675","Lubelskie","112741","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114676","Lubuskie","112741","3","0","0"),
("114677","Łódzkie","112741","4","0","0"),
("114678","Małopolskie","112741","5","0","0"),
("114679","Mazowieckie","112741","6","0","0"),
("114680","Opolskie","112741","7","0","0"),
("114681","Podkarpackie","112741","8","0","0"),
("114682","Podlaskie","112741","9","0","0"),
("114683","Pomorskie","112741","10","0","0"),
("114684","Śląskie","112741","11","0","0"),
("114685","Świętokrzyskie","112741","12","0","0"),
("114686","Warmińsko-mazurskie","112741","13","0","0"),
("114687","Wielkopolskie","112741","14","0","0"),
("114688","Zachodniopomorskie","112741","15","0","0"),
("114689","Jelenia Góra","114673","0","0","0"),
("114690","Legnica","114673","1","0","1"),
("114691","Wałbrzych","114673","2","0","1"),
("114692","Wrocław","114673","3","0","0"),
("114693","Pow. bolesławiecki","114673","4","0","1"),
("114694","Pow. dzierżoniowski","114673","5","0","1"),
("114695","Pow. głogowski","114673","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114696","Pow. górowski","114673","7","0","1"),
("114697","Pow. jaworski","114673","8","0","1"),
("114698","Pow. jeleniogórski","114673","9","0","1"),
("114699","Pow. kamiennogórski","114673","10","0","1"),
("114700","Pow. kłodzki","114673","11","0","1"),
("114701","Pow. legnicki","114673","12","0","1"),
("114702","Pow. lubański","114673","13","0","1"),
("114703","Pow. lubiński","114673","14","0","1"),
("114704","Pow. lwówecki","114673","15","0","1"),
("114705","Pow. milicki","114673","16","0","1"),
("114706","Pow. oleśnicki","114673","17","0","1"),
("114707","Pow. oławski","114673","18","0","1"),
("114708","Pow. polkowicki","114673","19","0","1"),
("114709","Pow. strzeliński","114673","20","0","1"),
("114710","Pow. średzki","114673","21","0","1"),
("114711","Pow. świdnicki","114673","22","0","1"),
("114712","Pow. trzebnicki","114673","23","0","1"),
("114713","Pow. wałbrzyski","114673","24","0","1"),
("114714","Pow. wołowski","114673","25","0","1"),
("114715","Pow. wrocławski","114673","26","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114716","Pow. ząbkowicki","114673","27","0","1"),
("114717","Pow. zgorzelecki","114673","28","0","1"),
("114718","Pow. złotoryjski","114673","29","0","1"),
("114719","Bydgoszcz","114674","0","0","0"),
("114720","Grudziądz","114674","1","0","1"),
("114721","Toruń","114674","2","0","0"),
("114722","Włocławek","114674","3","0","1"),
("114723","Pow. aleksandrowski","114674","4","0","1"),
("114724","Pow. brodnicki","114674","5","0","1"),
("114725","Pow. bydgoski","114674","6","0","1"),
("114726","Pow. chełmiński","114674","7","0","1"),
("114727","Pow. golubsko-dobrzyński","114674","8","0","1"),
("114728","Pow. grudziądzki","114674","9","0","1"),
("114729","Pow. inowrocławski","114674","10","0","1"),
("114730","Pow. lipnowski","114674","11","0","1"),
("114731","Pow. mogileński","114674","12","0","1"),
("114732","Pow. nakielski","114674","13","0","1"),
("114733","Pow. radziejowski","114674","14","0","1"),
("114734","Pow. rypiński","114674","15","0","1"),
("114735","Pow. sępoleński","114674","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114736","Pow. świecki","114674","17","0","1"),
("114737","Pow. toruński","114674","18","0","1"),
("114738","Pow. tucholski","114674","19","0","1"),
("114739","Pow. wąbrzeski","114674","20","0","1"),
("114740","Pow. włocławski","114674","21","0","1"),
("114741","Pow. żniński","114674","22","0","1"),
("114742","Biała Podlaska","114675","0","0","1"),
("114743","Chełm","114675","1","0","1"),
("114744","Lublin","114675","2","0","0"),
("114745","Zamość","114675","3","0","1"),
("114746","Pow. bialski","114675","4","0","1"),
("114747","Pow. biłgorajski","114675","5","0","1"),
("114748","Pow. chełmski","114675","6","0","1"),
("114749","Pow. hrubieszowski","114675","7","0","1"),
("114750","Pow. janowski","114675","8","0","1"),
("114751","Pow. krasnostawski","114675","9","0","1"),
("114752","Pow. kraśnicki","114675","10","0","1"),
("114753","Pow. lubartowski","114675","11","0","1"),
("114754","Pow. lubelski","114675","12","0","1"),
("114755","Pow. łęczyński","114675","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114756","Pow. łukowski","114675","14","0","1"),
("114757","Pow. opolski","114675","15","0","1"),
("114758","Pow. parczewski","114675","16","0","1"),
("114759","Pow. puławski","114675","17","0","1"),
("114760","Pow. radzyński","114675","18","0","1"),
("114761","Pow. rycki","114675","19","0","1"),
("114762","Pow. świdnicki","114675","20","0","1"),
("114763","Pow. tomaszowski","114675","21","0","1"),
("114764","Pow. włodawski","114675","22","0","1"),
("114765","Pow. zamojski","114675","23","0","1"),
("114766","Gorzów Wielkopolski","114676","0","0","1"),
("114767","Zielona Góra","114676","1","0","1"),
("114768","Pow. gorzowski","114676","2","0","1"),
("114769","Pow. krośnieński","114676","3","0","1"),
("114770","Pow. międzyrzecki","114676","4","0","1"),
("114771","Pow. nowosolski","114676","5","0","1"),
("114772","Pow. słubicki","114676","6","0","1"),
("114773","Pow. strzelecko-drezdenecki","114676","7","0","1"),
("114774","Pow. sulęciński","114676","8","0","1"),
("114775","Pow. świebodziński","114676","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114776","Pow. wschowski","114676","10","0","1"),
("114777","Pow. zielonogórski","114676","11","0","1"),
("114778","Pow. żagański","114676","12","0","1"),
("114779","Pow. żarski","114676","13","0","1"),
("114780","Łódź","114677","0","0","0"),
("114781","Piotrków Trybunalski","114677","1","0","1"),
("114782","Skierniewice","114677","2","0","1"),
("114783","Pow. bełchatowski","114677","3","0","1"),
("114784","Pow. brzeziński","114677","4","0","1"),
("114785","Pow. kutnowski","114677","5","0","1"),
("114786","Pow. łaski","114677","6","0","1"),
("114787","Pow. łęczycki","114677","7","0","1"),
("114788","Pow. łowicki","114677","8","0","1"),
("114789","Pow. łódzki wschodni","114677","9","0","1"),
("114790","Pow. opoczyński","114677","10","0","1"),
("114791","Pow. pabianicki","114677","11","0","1"),
("114792","Pow. pajęczański","114677","12","0","1"),
("114793","Pow. piotrkowski","114677","13","0","1"),
("114794","Pow. poddębicki","114677","14","0","1"),
("114795","Pow. radomszczański","114677","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114796","Pow. rawski","114677","16","0","1"),
("114797","Pow. sieradzki","114677","17","0","1"),
("114798","Pow. skierniewicki","114677","18","0","1"),
("114799","Pow. tomaszowski","114677","19","0","1"),
("114800","Pow. wieluński","114677","20","0","1"),
("114801","Pow. wieruszowski","114677","21","0","1"),
("114802","Pow. zduńskowolski","114677","22","0","1"),
("114803","Pow. zgierski","114677","23","0","1"),
("114804","Kraków","114678","0","0","0"),
("114805","Nowy Sącz","114678","1","0","1"),
("114806","Tarnów","114678","2","0","1"),
("114807","Pow. bocheński","114678","3","0","1"),
("114808","Pow. brzeski","114678","4","0","1"),
("114809","Pow. chrzanowski","114678","5","0","1"),
("114810","Pow. dąbrowski","114678","6","0","1"),
("114811","Pow. gorlicki","114678","7","0","1"),
("114812","Pow. krakowski","114678","8","0","1"),
("114813","Pow. limanowski","114678","9","0","1"),
("114814","Pow. miechowski","114678","10","0","1"),
("114815","Pow. myślenicki","114678","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114816","Pow. nowosądecki","114678","12","0","1"),
("114817","Pow. nowotarski","114678","13","0","1"),
("114818","Pow. olkuski","114678","14","0","1"),
("114819","Pow. oświęcimski","114678","15","0","1"),
("114820","Pow. proszowicki","114678","16","0","1"),
("114821","Pow. suski","114678","17","0","1"),
("114822","Pow. tarnowski","114678","18","0","1"),
("114823","Pow. tatrzański","114678","19","0","1"),
("114824","Pow. wadowicki","114678","20","0","1"),
("114825","Pow. wielicki","114678","21","0","1"),
("114826","Ostrołęka","114679","0","0","1"),
("114827","Płock","114679","1","0","1"),
("114828","Radom","114679","2","0","1"),
("114829","Siedlce","114679","3","0","1"),
("114830","Warszawa","114679","4","0","0"),
("114831","Pow. białobrzeski","114679","5","0","1"),
("114832","Pow. ciechanowski","114679","6","0","1"),
("114833","Pow. garwoliński","114679","7","0","1"),
("114834","Pow. gostyniński","114679","8","0","1"),
("114835","Pow. grodziski","114679","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114836","Pow. grójecki","114679","10","0","1"),
("114837","Pow. kozienicki","114679","11","0","1"),
("114838","Pow. legionowski","114679","12","0","1"),
("114839","Pow. lipski","114679","13","0","1"),
("114840","Pow. łosicki","114679","14","0","1"),
("114841","Pow. makowski","114679","15","0","1"),
("114842","Pow. miński","114679","16","0","1"),
("114843","Pow. mławski","114679","17","0","1"),
("114844","Pow. nowodworski","114679","18","0","1"),
("114845","Pow. ostrołęcki","114679","19","0","1"),
("114846","Pow. ostrowski","114679","20","0","1"),
("114847","Pow. otwocki","114679","21","0","1"),
("114848","Pow. piaseczyński","114679","22","0","0"),
("114849","Pow. płocki","114679","23","0","1"),
("114850","Pow. płoński","114679","24","0","1"),
("114851","Pow. pruszkowski","114679","25","0","0"),
("114852","Pow. przasnyski","114679","26","0","1"),
("114853","Pow. przysuski","114679","27","0","1"),
("114854","Pow. pułtuski","114679","28","0","1"),
("114855","Pow. radomski","114679","29","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114856","Pow. siedlecki","114679","30","0","1"),
("114857","Pow. sierpecki","114679","31","0","1"),
("114858","Pow. sochaczewski","114679","32","0","1"),
("114859","Pow. sokołowski","114679","33","0","1"),
("114860","Pow. szydłowiecki","114679","34","0","1"),
("114861","Pow. warszawski zachodni","114679","35","0","1"),
("114862","Pow. węgrowski","114679","36","0","1"),
("114863","Pow. wołomiński","114679","37","0","0"),
("114864","Pow. wyszkowski","114679","38","0","1"),
("114865","Pow. zwoleński","114679","39","0","1"),
("114866","Pow. żuromiński","114679","40","0","1"),
("114867","Pow. żyrardowski","114679","41","0","1"),
("114868","Opole","114680","0","0","0"),
("114869","Pow. brzeski","114680","1","0","1"),
("114870","Pow. głubczycki","114680","2","0","1"),
("114871","Pow. kędzierzyńsko-kozielski","114680","3","0","1"),
("114872","Pow. kluczborski","114680","4","0","1"),
("114873","Pow. krapkowicki","114680","5","0","1"),
("114874","Pow. namysłowski","114680","6","0","1"),
("114875","Pow. nyski","114680","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114876","Pow. oleski","114680","8","0","1"),
("114877","Pow. opolski","114680","9","0","1"),
("114878","Pow. prudnicki","114680","10","0","1"),
("114879","Pow. strzelecki","114680","11","0","1"),
("114880","Krosno","114681","0","0","1"),
("114881","Przemyśl","114681","1","0","1"),
("114882","Rzeszów","114681","2","0","0"),
("114883","Tarnobrzeg","114681","3","0","1"),
("114884","Pow. bieszczadzki","114681","4","0","1"),
("114885","Pow. brzozowski","114681","5","0","1"),
("114886","Pow. dębicki","114681","6","0","1"),
("114887","Pow. jarosławski","114681","7","0","1"),
("114888","Pow. jasielski","114681","8","0","1"),
("114889","Pow. kolbuszowski","114681","9","0","1"),
("114890","Pow. krośnieński","114681","10","0","1"),
("114891","Pow. leski","114681","11","0","1"),
("114892","Pow. leżajski","114681","12","0","1"),
("114893","Pow. lubaczowski","114681","13","0","1"),
("114894","Pow. łańcucki","114681","14","0","1"),
("114895","Pow. mielecki","114681","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114896","Pow. niżański","114681","16","0","1"),
("114897","Pow. przemyski","114681","17","0","1"),
("114898","Pow. przeworski","114681","18","0","1"),
("114899","Pow. ropczycko-sędziszowski","114681","19","0","1"),
("114900","Pow. rzeszowski","114681","20","0","1"),
("114901","Pow. sanocki","114681","21","0","1"),
("114902","Pow. stalowowolski","114681","22","0","1"),
("114903","Pow. strzyżowski","114681","23","0","1"),
("114904","Pow. tarnobrzeski","114681","24","0","1"),
("114905","Białystok","114682","0","0","0"),
("114906","Łomża","114682","1","0","1"),
("114907","Suwałki","114682","2","0","1"),
("114908","Pow. augustowski","114682","3","0","1"),
("114909","Pow. białostocki","114682","4","0","1"),
("114910","Pow. bielski","114682","5","0","1"),
("114911","Pow. grajewski","114682","6","0","1"),
("114912","Pow. hajnowski","114682","7","0","1"),
("114913","Pow. kolneński","114682","8","0","1"),
("114914","Pow. łomżyński","114682","9","0","1"),
("114915","Pow. moniecki","114682","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114916","Pow. sejneński","114682","11","0","1"),
("114917","Pow. siemiatycki","114682","12","0","1"),
("114918","Pow. sokólski","114682","13","0","1"),
("114919","Pow. suwalski","114682","14","0","1"),
("114920","Pow. wysokomazowiecki","114682","15","0","1"),
("114921","Pow. zambrowski","114682","16","0","1"),
("114922","Gdańsk","114683","0","0","0"),
("114923","Gdynia","114683","1","0","0"),
("114924","Słupsk","114683","2","0","1"),
("114925","Sopot","114683","3","0","0"),
("114926","Pow. bytowski","114683","4","0","1"),
("114927","Pow. chojnicki","114683","5","0","1"),
("114928","Pow. człuchowski","114683","6","0","1"),
("114929","Pow. gdański","114683","7","0","1"),
("114930","Pow. kartuski","114683","8","0","1"),
("114931","Pow. kościerski","114683","9","0","1"),
("114932","Pow. kwidzyński","114683","10","0","1"),
("114933","Pow. lęborski","114683","11","0","1"),
("114934","Pow. malborski","114683","12","0","1"),
("114935","Pow. nowodworski","114683","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114936","Pow. pucki","114683","14","0","1"),
("114937","Pow. słupski","114683","15","0","1"),
("114938","Pow. starogardzki","114683","16","0","1"),
("114939","Pow. sztumski","114683","17","0","1"),
("114940","Pow. tczewski","114683","18","0","1"),
("114941","Pow. wejherowski","114683","19","0","0"),
("114942","Bielsko-Biała","114684","0","0","0"),
("114943","Bytom","114684","1","0","0"),
("114944","Chorzów","114684","2","0","1"),
("114945","Częstochowa","114684","3","0","0"),
("114946","Dąbrowa Górnicza","114684","4","0","1"),
("114947","Gliwice","114684","5","0","0"),
("114948","Jastrzębie-Zdrój","114684","6","0","1"),
("114949","Jaworzno","114684","7","0","1"),
("114950","Katowice","114684","8","0","0"),
("114951","Mysłowice","114684","9","0","1"),
("114952","Piekary Śląskie","114684","10","0","1"),
("114953","Ruda Śląska","114684","11","0","1"),
("114954","Rybnik","114684","12","0","1"),
("114955","Siemianowice Śląskie","114684","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114956","Sosnowiec","114684","14","0","0"),
("114957","Świętochłowice","114684","15","0","1"),
("114958","Tychy","114684","16","0","0"),
("114959","Zabrze","114684","17","0","1"),
("114960","Żory","114684","18","0","1"),
("114961","Pow. będziński","114684","19","0","1"),
("114962","Pow. bielski","114684","20","0","1"),
("114963","Pow. bieruńsko-lędziński","114684","21","0","1"),
("114964","Pow. cieszyński","114684","22","0","1"),
("114965","Pow. częstochowski","114684","23","0","1"),
("114966","Pow. gliwicki","114684","24","0","1"),
("114967","Pow. kłobucki","114684","25","0","1"),
("114968","Pow. lubliniecki","114684","26","0","1"),
("114969","Pow. mikołowski","114684","27","0","1"),
("114970","Pow. myszkowski","114684","28","0","1"),
("114971","Pow. pszczyński","114684","29","0","1"),
("114972","Pow. raciborski","114684","30","0","1"),
("114973","Pow. rybnicki","114684","31","0","1"),
("114974","Pow. tarnogórski","114684","32","0","1"),
("114975","Pow. wodzisławski","114684","33","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114976","Pow. zawierciański","114684","34","0","1"),
("114977","Pow. żywiecki","114684","35","0","1"),
("114978","Kielce","114685","0","0","1"),
("114979","Pow. buski","114685","1","0","1"),
("114980","Pow. jędrzejowski","114685","2","0","1"),
("114981","Pow. kazimierski","114685","3","0","1"),
("114982","Pow. kielecki","114685","4","0","1"),
("114983","Pow. konecki","114685","5","0","1"),
("114984","Pow. opatowski","114685","6","0","1"),
("114985","Pow. ostrowiecki","114685","7","0","1"),
("114986","Pow. pińczowski","114685","8","0","1"),
("114987","Pow. sandomierski","114685","9","0","1"),
("114988","Pow. skarżyski","114685","10","0","1"),
("114989","Pow. starachowicki","114685","11","0","1"),
("114990","Pow. staszowski","114685","12","0","1"),
("114991","Pow. włoszczowski","114685","13","0","1"),
("114992","Elbląg","114686","0","0","1"),
("114993","Olsztyn","114686","1","0","1"),
("114994","Pow. bartoszycki","114686","2","0","1"),
("114995","Pow. braniewski","114686","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("114996","Pow. działdowski","114686","4","0","1"),
("114997","Pow. elbląski","114686","5","0","1"),
("114998","Pow. ełcki","114686","6","0","1"),
("114999","Pow. giżycki","114686","7","0","1"),
("115000","Pow. gołdapski","114686","8","0","1"),
("115001","Pow. iławski","114686","9","0","1"),
("115002","Pow. kętrzyński","114686","10","0","1"),
("115003","Pow. lidzbarski","114686","11","0","1"),
("115004","Pow. mrągowski","114686","12","0","1"),
("115005","Pow. nidzicki","114686","13","0","1"),
("115006","Pow. nowomiejski","114686","14","0","1"),
("115007","Pow. olecki","114686","15","0","1"),
("115008","Pow. olsztyński","114686","16","0","1"),
("115009","Pow. ostródzki","114686","17","0","1"),
("115010","Pow. piski","114686","18","0","1"),
("115011","Pow. szczycieński","114686","19","0","1"),
("115012","Pow. węgorzewski","114686","20","0","1"),
("115013","Kalisz","114687","0","0","1"),
("115014","Konin","114687","1","0","1"),
("115015","Leszno","114687","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115016","Poznań","114687","3","0","0"),
("115017","Pow. chodzieski","114687","4","0","1"),
("115018","Pow. czarnkowsko-trzcianecki","114687","5","0","1"),
("115019","Pow. gnieźnieński","114687","6","0","1"),
("115020","Pow. gostyński","114687","7","0","1"),
("115021","Pow. grodziski","114687","8","0","1"),
("115022","Pow. jarociński","114687","9","0","1"),
("115023","Pow. kaliski","114687","10","0","1"),
("115024","Pow. kępiński","114687","11","0","1"),
("115025","Pow. kolski","114687","12","0","1"),
("115026","Pow. koniński","114687","13","0","1"),
("115027","Pow. kościański","114687","14","0","1"),
("115028","Pow. krotoszyński","114687","15","0","1"),
("115029","Pow. leszczyński","114687","16","0","1"),
("115030","Pow. międzychodzki","114687","17","0","1"),
("115031","Pow. nowotomyski","114687","18","0","1"),
("115032","Pow. obornicki","114687","19","0","1"),
("115033","Pow. ostrowski","114687","20","0","1"),
("115034","Pow. ostrzeszowski","114687","21","0","1"),
("115035","Pow. pilski","114687","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115036","Pow. pleszewski","114687","23","0","1"),
("115037","Pow. poznański","114687","24","0","1"),
("115038","Pow. rawicki","114687","25","0","1"),
("115039","Pow. słupecki","114687","26","0","1"),
("115040","Pow. szamotulski","114687","27","0","1"),
("115041","Pow. średzki","114687","28","0","1"),
("115042","Pow. śremski","114687","29","0","1"),
("115043","Pow. turecki","114687","30","0","1"),
("115044","Pow. wągrowiecki","114687","31","0","1"),
("115045","Pow. wolsztyński","114687","32","0","1"),
("115046","Pow. wrzesiński","114687","33","0","1"),
("115047","Pow. złotowski","114687","34","0","1"),
("115048","Koszalin","114688","0","0","0"),
("115049","Szczecin","114688","1","0","0"),
("115050","Świnoujście","114688","2","0","1"),
("115051","Pow. białogardzki","114688","3","0","1"),
("115052","Pow. choszczeński","114688","4","0","1"),
("115053","Pow. drawski","114688","5","0","1"),
("115054","Pow. goleniowski","114688","6","0","1"),
("115055","Pow. gryficki","114688","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115056","Pow. gryfiński","114688","8","0","1"),
("115057","Pow. kamieński","114688","9","0","1"),
("115058","Pow. kołobrzeski","114688","10","0","1"),
("115059","Pow. koszaliński","114688","11","0","1"),
("115060","Pow. łobeski","114688","12","0","1"),
("115061","Pow. myśliborski","114688","13","0","1"),
("115062","Pow. policki","114688","14","0","1"),
("115063","Pow. pyrzycki","114688","15","0","1"),
("115064","Pow. sławieński","114688","16","0","1"),
("115065","Pow. stargardzki","114688","17","0","1"),
("115066","Pow. szczecinecki","114688","18","0","1"),
("115067","Pow. świdwiński","114688","19","0","1"),
("115068","Pow. wałecki","114688","20","0","1"),
("115069","Cieplice Śląskie-Zdrój","114689","0","0","1"),
("115070","Czarne","114689","1","0","1"),
("115071","Dąbrówka","114689","2","0","1"),
("115072","Goduszyn","114689","3","0","1"),
("115073","Grabary","114689","4","0","1"),
("115074","Jagniątków","114689","5","0","1"),
("115075","Maciejowa","114689","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115076","Paulinów","114689","7","0","1"),
("115077","Sobieszów","114689","8","0","1"),
("115078","Strupice","114689","9","0","1"),
("115079","Zabobrze","114689","10","0","1"),
("115080","Pozostałe","114689","11","0","1"),
("115081","Fabryczna","114692","0","0","1"),
("115082","Krzyki","114692","1","0","1"),
("115083","Psie Pole","114692","2","0","1"),
("115084","Stare Miasto","114692","3","0","1"),
("115085","Śródmieście","114692","4","0","1"),
("115086","Pozostałe","114692","5","0","1"),
("115087","Bartodzieje Małe","114719","0","0","1"),
("115088","Bartodzieje Wielkie","114719","1","0","1"),
("115089","Bielawy","114719","2","0","1"),
("115090","Błonie","114719","3","0","1"),
("115091","Bocianowo","114719","4","0","1"),
("115092","Czyżkówko","114719","5","0","1"),
("115093","Fordon","114719","6","0","1"),
("115094","Górzyskowo","114719","7","0","1"),
("115095","Kapuściska","114719","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115096","Okole","114719","9","0","1"),
("115097","Osiedle Leśne","114719","10","0","1"),
("115098","Osowa Góra","114719","11","0","1"),
("115099","Skrzetusko","114719","12","0","1"),
("115100","Szwederowo","114719","13","0","1"),
("115101","Wilczak","114719","14","0","1"),
("115102","Pozostałe","114719","15","0","1"),
("115103","Bielany","114721","0","0","1"),
("115104","Bielawy","114721","1","0","1"),
("115105","Bydgoskie Przedmieście","114721","2","0","1"),
("115106","Chełmińskie Przedmieście","114721","3","0","1"),
("115107","Jakubskie Przedmieście","114721","4","0","1"),
("115108","Koniuchy","114721","5","0","1"),
("115109","Mokre","114721","6","0","1"),
("115110","Na Skarpie","114721","7","0","1"),
("115111","Podgórz","114721","8","0","1"),
("115112","Rubinkowo","114721","9","0","1"),
("115113","Rudak","114721","10","0","1"),
("115114","Rybaki","114721","11","0","1"),
("115115","Stare Miasto","114721","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115116","Stawki","114721","13","0","1"),
("115117","Wrzosy","114721","14","0","1"),
("115118","Pozostałe","114721","15","0","1"),
("115119","Bazylianówka","114744","0","0","1"),
("115120","Bronowice","114744","1","0","1"),
("115121","Czechów Górny","114744","2","0","1"),
("115122","Czuby","114744","3","0","1"),
("115123","Dziesiąta","114744","4","0","1"),
("115124","Felin","114744","5","0","1"),
("115125","Kalinowszczyzna","114744","6","0","1"),
("115126","Kośminek","114744","7","0","1"),
("115127","Rudnik ","114744","8","0","1"),
("115128","Sławinek","114744","9","0","1"),
("115129","Śródmieście","114744","10","0","1"),
("115130","Tatary","114744","11","0","1"),
("115131","Węglin","114744","12","0","1"),
("115132","Wieniawka","114744","13","0","1"),
("115133","Wrotków","114744","14","0","1"),
("115134","Pozostałe","114744","15","0","1"),
("115135","Bałuty","114780","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115136","Górna","114780","1","0","1"),
("115137","Polesie","114780","2","0","1"),
("115138","Śródmieście","114780","3","0","1"),
("115139","Widzew","114780","4","0","1"),
("115140","Pozostałe","114780","5","0","1"),
("115141","Krowodrza","114804","0","0","1"),
("115142","Nowa Huta","114804","1","0","1"),
("115143","Podgórze","114804","2","0","1"),
("115144","Śródmieście","114804","3","0","1"),
("115145","Pozostałe","114804","4","0","1"),
("115146","Bemowo","114830","0","0","1"),
("115147","Białołęka","114830","1","0","1"),
("115148","Bielany","114830","2","0","1"),
("115149","Mokotów","114830","3","0","1"),
("115150","Ochota","114830","4","0","1"),
("115151","Praga Południe","114830","5","0","1"),
("115152","Praga Północ","114830","6","0","1"),
("115153","Rembertów","114830","7","0","1"),
("115154","Śródmieście","114830","8","0","1"),
("115155","Targówek","114830","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115156","Ursus","114830","10","0","1"),
("115157","Ursynów","114830","11","0","1"),
("115158","Wawer","114830","12","0","1"),
("115159","Wesoła","114830","13","0","1"),
("115160","Wilanów","114830","14","0","1"),
("115161","Włochy ","114830","15","0","1"),
("115162","Wola","114830","16","0","1"),
("115163","Żoliborz","114830","17","0","1"),
("115164","Inne","114830","18","0","1"),
("115165","Góra Kalwaria","114848","0","0","1"),
("115166","Konstancin-Jeziorna","114848","1","0","1"),
("115167","Piaseczno","114848","2","0","1"),
("115168","Tarczyn","114848","3","0","1"),
("115169","Pozostałe","114848","4","0","1"),
("115170","Brwinów","114851","0","0","1"),
("115171","Piastów","114851","1","0","1"),
("115172","Pruszków","114851","2","0","1"),
("115173","Pozostałe","114851","3","0","1"),
("115174","Kobyłka","114863","0","0","1"),
("115175","Marki","114863","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115176","Radzymin","114863","2","0","1"),
("115177","Tłuszcz","114863","3","0","1"),
("115178","Wołomin","114863","4","0","1"),
("115179","Ząbki","114863","5","0","1"),
("115180","Zielonka","114863","6","0","1"),
("115181","Pozostałe","114863","7","0","1"),
("115182","Bierkowice","114868","0","0","1"),
("115183","Gosławice","114868","1","0","1"),
("115184","Groszowice","114868","2","0","1"),
("115185","Grudzice","114868","3","0","1"),
("115186","Kolonia Gosławicka","114868","4","0","1"),
("115187","Malina","114868","5","0","1"),
("115188","Nowa Wieś Królewska","114868","6","0","1"),
("115189","Półwieś","114868","7","0","1"),
("115190","Szczepanowice","114868","8","0","1"),
("115191","Wójtowa Wieś","114868","9","0","1"),
("115192","Wróblin","114868","10","0","1"),
("115193","Zakrzów","114868","11","0","1"),
("115194","Zaodrze","114868","12","0","1"),
("115195","Pozostałe","114868","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115196","Drabinianka","114882","0","0","1"),
("115197","Dworzysko","114882","1","0","1"),
("115198","Miłocin","114882","2","0","1"),
("115199","Pobitno","114882","3","0","1"),
("115200","Przybyszówka","114882","4","0","1"),
("115201","Słocina","114882","5","0","1"),
("115202","Staromieście","114882","6","0","1"),
("115203","Staroniwa","114882","7","0","1"),
("115204","Szajerówka","114882","8","0","1"),
("115205","Wilkowyja","114882","9","0","1"),
("115206","Zalesie","114882","10","0","1"),
("115207","Załęże","114882","11","0","1"),
("115208","Zwięczyca","114882","12","0","1"),
("115209","Pozostałe","114882","13","0","1"),
("115210","Antoniuk","114905","0","0","1"),
("115211","Bacieczki","114905","1","0","1"),
("115212","Białostoczek","114905","2","0","1"),
("115213","Bojary","114905","3","0","1"),
("115214","Dojlidy","114905","4","0","1"),
("115215","Dojlidy Górne","114905","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115216","Dziesięciny","114905","6","0","1"),
("115217","Nowe Miasto","114905","7","0","1"),
("115218","Skorupy","114905","8","0","1"),
("115219","Słoboda","114905","9","0","1"),
("115220","Starosielce","114905","10","0","1"),
("115221","Wygoda","114905","11","0","1"),
("115222","Wysoki Stoczek","114905","12","0","1"),
("115223","Zagórki","114905","13","0","1"),
("115224","Zawady","114905","14","0","1"),
("115225","Pozostałe","114905","15","0","1"),
("115226","Brzeźno","114922","0","0","1"),
("115227","Chełm","114922","1","0","1"),
("115228","Jasień","114922","2","0","1"),
("115229","Kiełpino Górne","114922","3","0","1"),
("115230","Kokoszki","114922","4","0","1"),
("115231","Lipce","114922","5","0","1"),
("115232","Łostowice","114922","6","0","1"),
("115233","Oliwa","114922","7","0","1"),
("115234","Osowa","114922","8","0","1"),
("115235","Przymorze","114922","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115236","Siedlce","114922","10","0","1"),
("115237","Sobieszewo","114922","11","0","1"),
("115238","Suchanino","114922","12","0","1"),
("115239","Wrzeszcz","114922","13","0","1"),
("115240","Zakoniczyn","114922","14","0","1"),
("115241","Pozostałe","114922","15","0","1"),
("115242","Chwarzno","114923","0","0","1"),
("115243","Chylonia","114923","1","0","1"),
("115244","Cisowa","114923","2","0","1"),
("115245","Działki Leśne","114923","3","0","1"),
("115246","Kamienna Góra","114923","4","0","1"),
("115247","Leszczynki","114923","5","0","1"),
("115248","Mały Kack","114923","6","0","1"),
("115249","Obłuże","114923","7","0","1"),
("115250","Oksywie","114923","8","0","1"),
("115251","Orłowo","114923","9","0","1"),
("115252","Pogórze","114923","10","0","1"),
("115253","Redłowo","114923","11","0","1"),
("115254","Wiczlino","114923","12","0","1"),
("115255","Wielki Kack","114923","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115256","Wzgórze Nowotki","114923","14","0","1"),
("115257","Pozostałe","114923","15","0","1"),
("115258","Brodwino","114925","0","0","1"),
("115259","Kamienny Potok","114925","1","0","1"),
("115260","Przylesie","114925","2","0","1"),
("115261","Sopot Dolny","114925","3","0","1"),
("115262","Sopot Górny","114925","4","0","1"),
("115263","Wyścigi","114925","5","0","1"),
("115264","Pozostałe","114925","6","0","1"),
("115265","Reda","114941","0","0","1"),
("115266","Rumia","114941","1","0","1"),
("115267","Wejherowo","114941","2","0","1"),
("115268","Pozostałe","114941","3","0","1"),
("115269","Aleksandrowice","114942","0","0","1"),
("115270","Hałcnów","114942","1","0","1"),
("115271","Kamienica","114942","2","0","1"),
("115272","Komorowice Krakowskie","114942","3","0","1"),
("115273","Komorowice Śląskie","114942","4","0","1"),
("115274","Leszczyny","114942","5","0","1"),
("115275","Lipnik","114942","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115276","Mikuszowice Krakowskie","114942","7","0","1"),
("115277","Mikuszowice Śląskie","114942","8","0","1"),
("115278","Olszówka Dolna","114942","9","0","1"),
("115279","Olszówka Górna","114942","10","0","1"),
("115280","Stare Bielsko","114942","11","0","1"),
("115281","Straconka","114942","12","0","1"),
("115282","Wapienica","114942","13","0","1"),
("115283","Złote Łany","114942","14","0","1"),
("115284","Pozostałe","114942","15","0","1"),
("115285","Bobrek","114943","0","0","1"),
("115286","Górniki","114943","1","0","1"),
("115287","Karb","114943","2","0","1"),
("115288","Łagiewniki","114943","3","0","1"),
("115289","Miechowice","114943","4","0","1"),
("115290","Rozbark","114943","5","0","1"),
("115291","Stolarzowice","114943","6","0","1"),
("115292","Stroszek","114943","7","0","1"),
("115293","Sucha Góra","114943","8","0","1"),
("115294","Szombierki","114943","9","0","1"),
("115295","Pozostałe","114943","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115296","Błeszno","114945","0","0","1"),
("115297","Dźbów","114945","1","0","1"),
("115298","Grabówka","114945","2","0","1"),
("115299","Kawodrza Dolna","114945","3","0","1"),
("115300","Lisiniec","114945","4","0","1"),
("115301","Liszka Dolna","114945","5","0","1"),
("115302","Mirów","114945","6","0","1"),
("115303","Ostatni Grosz","114945","7","0","1"),
("115304","Parkitka","114945","8","0","1"),
("115305","Raków","114945","9","0","1"),
("115306","Rząsawy","114945","10","0","1"),
("115307","Sabinów","114945","11","0","1"),
("115308","Stradom","114945","12","0","1"),
("115309","Wrzosowiak","114945","13","0","1"),
("115310","Zawodzie","114945","14","0","1"),
("115311","Pozostałe","114945","15","0","1"),
("115312","Bojków","114947","0","0","1"),
("115313","Brzezinka","114947","1","0","1"),
("115314","Czechowice","114947","2","0","1"),
("115315","Ligota Zabrska","114947","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115316","Łabędy","114947","4","0","1"),
("115317","Ostropa","114947","5","0","1"),
("115318","Sośnica","114947","6","0","1"),
("115319","Stare Gliwice","114947","7","0","1"),
("115320","Szobiszowice","114947","8","0","1"),
("115321","Trynek","114947","9","0","1"),
("115322","Wilcze Gardło","114947","10","0","1"),
("115323","Wójtowa Wieś","114947","11","0","1"),
("115324","Żerniki","114947","12","0","1"),
("115325","Pozostałe","114947","13","0","1"),
("115326","Bogucice","114950","0","0","1"),
("115327","Brynów","114950","1","0","1"),
("115328","Dąb","114950","2","0","1"),
("115329","Giszowiec","114950","3","0","1"),
("115330","Józefowiec","114950","4","0","1"),
("115331","Kostuchna","114950","5","0","1"),
("115332","Koszutka","114950","6","0","1"),
("115333","Ligota Zabrska","114950","7","0","1"),
("115334","Ochojec","114950","8","0","1"),
("115335","Panewniki","114950","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115336","Piotrowice","114950","10","0","1"),
("115337","Podlesie","114950","11","0","1"),
("115338","Wełnowiec","114950","12","0","1"),
("115339","Zarzecze","114950","13","0","1"),
("115340","Zawodzie","114950","14","0","1"),
("115341","Pozostałe","114950","15","0","1"),
("115342","Cieśle","114956","0","0","1"),
("115343","Dańdówka","114956","1","0","1"),
("115344","Dębowa Góra","114956","2","0","1"),
("115345","Józefów","114956","3","0","1"),
("115346","Kazimierz","114956","4","0","1"),
("115347","Klimontów","114956","5","0","1"),
("115348","Maczki","114956","6","0","1"),
("115349","Milowice","114956","7","0","1"),
("115350","Niwka","114956","8","0","1"),
("115351","Ostrowy Górnicze","114956","9","0","1"),
("115352","Pogoń","114956","10","0","1"),
("115353","Sielec","114956","11","0","1"),
("115354","Stary Sosnowiec","114956","12","0","1"),
("115355","Środula","114956","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115356","Zagórze","114956","14","0","1"),
("115357","Pozostałe","114956","15","0","1"),
("115358","Cielmice","114958","0","0","1"),
("115359","Czułów","114958","1","0","1"),
("115360","Glinka","114958","2","0","1"),
("115361","Jaroszowice","114958","3","0","1"),
("115362","Mąkołowiec","114958","4","0","1"),
("115363","Paprocany","114958","5","0","1"),
("115364","Suble","114958","6","0","1"),
("115365","Urbanowice","114958","7","0","1"),
("115366","Wartogłowiec","114958","8","0","1"),
("115367","Wilkowyje","114958","9","0","1"),
("115368","Zwierzyniec","114958","10","0","1"),
("115369","Żwaków","114958","11","0","1"),
("115370","Pozostałe","114958","12","0","1"),
("115371","Grunwald","115016","0","0","1"),
("115372","Jeżyce","115016","1","0","1"),
("115373","Nowe Miasto","115016","2","0","1"),
("115374","Stare Miasto","115016","3","0","1"),
("115375","Wilda","115016","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115376","Pozostałe","115016","5","0","1"),
("115377","Chełmoniewo","115048","0","0","1"),
("115378","Dzierżęcino","115048","1","0","1"),
("115379","Lubiatowo","115048","2","0","1"),
("115380","Raduszka","115048","3","0","1"),
("115381","Rokosowo","115048","4","0","1"),
("115382","Pozostałe","115048","5","0","1"),
("115383","Bezrzecze","115049","0","0","1"),
("115384","Bukowe-Klęskowo","115049","1","0","1"),
("115385","Bukowo","115049","2","0","1"),
("115386","Centrum","115049","3","0","1"),
("115387","Dąbie","115049","4","0","1"),
("115388","Drzetowo","115049","5","0","1"),
("115389","Głębokie","115049","6","0","1"),
("115390","Grabowo","115049","7","0","1"),
("115391","Gumieńce","115049","8","0","1"),
("115392","Kijewo","115049","9","0","1"),
("115393","Niebuszewo","115049","10","0","1"),
("115394","Osów","115049","11","0","1"),
("115395","Pilchowo","115049","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115396","Płonia","115049","13","0","1"),
("115397","Podjuchy","115049","14","0","1"),
("115398","Pogodno","115049","15","0","1"),
("115399","Pomorzany","115049","16","0","1"),
("115400","Skolwin","115049","17","0","1"),
("115401","Stare Miasto","115049","18","0","1"),
("115402","Stołczyn","115049","19","0","1"),
("115403","Świerczewo","115049","20","0","1"),
("115404","Warszewo","115049","21","0","1"),
("115405","Wielgowo","115049","22","0","1"),
("115406","Zdroje","115049","23","0","1"),
("115407","Żelechowa","115049","24","0","1"),
("115408","Pozostałe","115049","25","0","1"),
("115409","Dolnośląskie","112740","0","0","0"),
("115410","Kujawsko-pomorskie","112740","1","0","0"),
("115411","Lubelskie","112740","2","0","0"),
("115412","Lubuskie","112740","3","0","0"),
("115413","Łódzkie","112740","4","0","0"),
("115414","Małopolskie","112740","5","0","0"),
("115415","Mazowieckie","112740","6","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115416","Opolskie","112740","7","0","0"),
("115417","Podkarpackie","112740","8","0","0"),
("115418","Podlaskie","112740","9","0","0"),
("115419","Pomorskie","112740","10","0","0"),
("115420","Śląskie","112740","11","0","0"),
("115421","Świętokrzyskie","112740","12","0","0"),
("115422","Warmińsko-mazurskie","112740","13","0","0"),
("115423","Wielkopolskie","112740","14","0","0"),
("115424","Zachodniopomorskie","112740","15","0","0"),
("115425","Jelenia Góra","115409","0","0","0"),
("115426","Legnica","115409","1","0","1"),
("115427","Wałbrzych","115409","2","0","1"),
("115428","Wrocław","115409","3","0","0"),
("115429","Pow. bolesławiecki","115409","4","0","1"),
("115430","Pow. dzierżoniowski","115409","5","0","1"),
("115431","Pow. głogowski","115409","6","0","1"),
("115432","Pow. górowski","115409","7","0","1"),
("115433","Pow. jaworski","115409","8","0","1"),
("115434","Pow. jeleniogórski","115409","9","0","1"),
("115435","Pow. kamiennogórski","115409","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115436","Pow. kłodzki","115409","11","0","1"),
("115437","Pow. legnicki","115409","12","0","1"),
("115438","Pow. lubański","115409","13","0","1"),
("115439","Pow. lubiński","115409","14","0","1"),
("115440","Pow. lwówecki","115409","15","0","1"),
("115441","Pow. milicki","115409","16","0","1"),
("115442","Pow. oleśnicki","115409","17","0","1"),
("115443","Pow. oławski","115409","18","0","1"),
("115444","Pow. polkowicki","115409","19","0","1"),
("115445","Pow. strzeliński","115409","20","0","1"),
("115446","Pow. średzki","115409","21","0","1"),
("115447","Pow. świdnicki","115409","22","0","1"),
("115448","Pow. wołowski","115409","23","0","1"),
("115449","Pow. trzebnicki","115409","24","0","1"),
("115450","Pow. wałbrzyski","115409","25","0","1"),
("115451","Pow. wrocławski","115409","26","0","1"),
("115452","Pow. ząbkowicki","115409","27","0","1"),
("115453","Pow. zgorzelecki","115409","28","0","1"),
("115454","Pow. złotoryjski","115409","29","0","1"),
("115455","Bydgoszcz","115410","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115456","Grudziądz","115410","1","0","1"),
("115457","Toruń","115410","2","0","0"),
("115458","Włocławek","115410","3","0","1"),
("115459","Pow. aleksandrowski","115410","4","0","1"),
("115460","Pow. brodnicki","115410","5","0","1"),
("115461","Pow. bydgoski","115410","6","0","1"),
("115462","Pow. chełmiński","115410","7","0","1"),
("115463","Pow. golubsko-dobrzyński","115410","8","0","1"),
("115464","Pow. grudziądzki","115410","9","0","1"),
("115465","Pow. inowrocławski","115410","10","0","1"),
("115466","Pow. lipnowski","115410","11","0","1"),
("115467","Pow. mogileński","115410","12","0","1"),
("115468","Pow. nakielski","115410","13","0","1"),
("115469","Pow. radziejowski","115410","14","0","1"),
("115470","Pow. rypiński","115410","15","0","1"),
("115471","Pow. sępoleński","115410","16","0","1"),
("115472","Pow. świecki","115410","17","0","1"),
("115473","Pow. toruński","115410","18","0","1"),
("115474","Pow. tucholski","115410","19","0","1"),
("115475","Pow. wąbrzeski","115410","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115476","Pow. włocławski","115410","21","0","1"),
("115477","Pow. żniński","115410","22","0","1"),
("115478","Biała Podlaska","115411","0","0","1"),
("115479","Chełm","115411","1","0","1"),
("115480","Lublin","115411","2","0","0"),
("115481","Zamość","115411","3","0","1"),
("115482","Pow. bialski","115411","4","0","1"),
("115483","Pow. biłgorajski","115411","5","0","1"),
("115484","Pow. chełmski","115411","6","0","1"),
("115485","Pow. hrubieszowski","115411","7","0","1"),
("115486","Pow. janowski","115411","8","0","1"),
("115487","Pow. krasnostawski","115411","9","0","1"),
("115488","Pow. kraśnicki","115411","10","0","1"),
("115489","Pow. lubartowski","115411","11","0","1"),
("115490","Pow. lubelski","115411","12","0","1"),
("115491","Pow. łęczyński","115411","13","0","1"),
("115492","Pow. łukowski","115411","14","0","1"),
("115493","Pow. opolski","115411","15","0","1"),
("115494","Pow. parczewski","115411","16","0","1"),
("115495","Pow. puławski","115411","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115496","Pow. radzyński","115411","18","0","1"),
("115497","Pow. rycki","115411","19","0","1"),
("115498","Pow. świdnicki","115411","20","0","1"),
("115499","Pow. tomaszowski","115411","21","0","1"),
("115500","Pow. włodawski","115411","22","0","1"),
("115501","Pow. zamojski","115411","23","0","1"),
("115502","Gorzów Wielkopolski","115412","0","0","1"),
("115503","Zielona Góra","115412","1","0","1"),
("115504","Pow. gorzowski","115412","2","0","1"),
("115505","Pow. krośnieński","115412","3","0","1"),
("115506","Pow. międzyrzecki","115412","4","0","1"),
("115507","Pow. nowosolski","115412","5","0","1"),
("115508","Pow. słubicki","115412","6","0","1"),
("115509","Pow. strzelecko-drezdenecki","115412","7","0","1"),
("115510","Pow. sulęciński","115412","8","0","1"),
("115511","Pow. świebodziński","115412","9","0","1"),
("115512","Pow. wschowski","115412","10","0","1"),
("115513","Pow. zielonogórski","115412","11","0","1"),
("115514","Pow. żagański","115412","12","0","1"),
("115515","Pow. żarski","115412","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115516","Łódź","115413","0","0","0"),
("115517","Piotrków Trybunalski","115413","1","0","1"),
("115518","Skierniewice","115413","2","0","1"),
("115519","Pow. bełchatowski","115413","3","0","1"),
("115520","Pow. brzeziński","115413","4","0","1"),
("115521","Pow. kutnowski","115413","5","0","1"),
("115522","Pow. łaski","115413","6","0","1"),
("115523","Pow. łęczycki","115413","7","0","1"),
("115524","Pow. łowicki","115413","8","0","1"),
("115525","Pow. łódzki wschodni","115413","9","0","1"),
("115526","Pow. opoczyński","115413","10","0","1"),
("115527","Pow. pabianicki","115413","11","0","1"),
("115528","Pow. pajęczański","115413","12","0","1"),
("115529","Pow. piotrkowski","115413","13","0","1"),
("115530","Pow. poddębicki","115413","14","0","1"),
("115531","Pow. radomszczański","115413","15","0","1"),
("115532","Pow. rawski","115413","16","0","1"),
("115533","Pow. sieradzki","115413","17","0","1"),
("115534","Pow. skierniewicki","115413","18","0","1"),
("115535","Pow. tomaszowski","115413","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115536","Pow. wieluński","115413","20","0","1"),
("115537","Pow. wieruszowski","115413","21","0","1"),
("115538","Pow. zduńskowolski","115413","22","0","1"),
("115539","Pow. zgierski","115413","23","0","1"),
("115540","Kraków","115414","0","0","0"),
("115541","Nowy Sącz","115414","1","0","1"),
("115542","Tarnów","115414","2","0","1"),
("115543","Pow. bocheński","115414","3","0","1"),
("115544","Pow. brzeski","115414","4","0","1"),
("115545","Pow. chrzanowski","115414","5","0","1"),
("115546","Pow. dąbrowski","115414","6","0","1"),
("115547","Pow. gorlicki","115414","7","0","1"),
("115548","Pow. krakowski","115414","8","0","1"),
("115549","Pow. limanowski","115414","9","0","1"),
("115550","Pow. miechowski","115414","10","0","1"),
("115551","Pow. myślenicki","115414","11","0","1"),
("115552","Pow. nowosądecki","115414","12","0","1"),
("115553","Pow. nowotarski","115414","13","0","1"),
("115554","Pow. olkuski","115414","14","0","1"),
("115555","Pow. oświęcimski","115414","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115556","Pow. proszowicki","115414","16","0","1"),
("115557","Pow. suski","115414","17","0","1"),
("115558","Pow. tarnowski","115414","18","0","1"),
("115559","Pow. tatrzański","115414","19","0","1"),
("115560","Pow. wadowicki","115414","20","0","1"),
("115561","Pow. wielicki","115414","21","0","1"),
("115562","Ostrołęka","115415","0","0","1"),
("115563","Płock","115415","1","0","1"),
("115564","Radom","115415","2","0","1"),
("115565","Siedlce","115415","3","0","1"),
("115566","Warszawa","115415","4","0","0"),
("115567","Pow. białobrzeski","115415","5","0","1"),
("115568","Pow. ciechanowski","115415","6","0","1"),
("115569","Pow. garwoliński","115415","7","0","1"),
("115570","Pow. gostyniński","115415","8","0","1"),
("115571","Pow. grodziski","115415","9","0","1"),
("115572","Pow. grójecki","115415","10","0","1"),
("115573","Pow. kozienicki","115415","11","0","1"),
("115574","Pow. legionowski","115415","12","0","1"),
("115575","Pow. lipski","115415","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115576","Pow. łosicki","115415","14","0","1"),
("115577","Pow. makowski","115415","15","0","1"),
("115578","Pow. miński","115415","16","0","1"),
("115579","Pow. mławski","115415","17","0","1"),
("115580","Pow. nowodworski","115415","18","0","1"),
("115581","Pow. ostrołęcki","115415","19","0","1"),
("115582","Pow. ostrowski","115415","20","0","1"),
("115583","Pow. otwocki","115415","21","0","1"),
("115584","Pow. piaseczyński","115415","22","0","0"),
("115585","Pow. płocki","115415","23","0","1"),
("115586","Pow. płoński","115415","24","0","1"),
("115587","Pow. pruszkowski","115415","25","0","0"),
("115588","Pow. przasnyski","115415","26","0","1"),
("115589","Pow. przysuski","115415","27","0","1"),
("115590","Pow. pułtuski","115415","28","0","1"),
("115591","Pow. radomski","115415","29","0","1"),
("115592","Pow. siedlecki","115415","30","0","1"),
("115593","Pow. sierpecki","115415","31","0","1"),
("115594","Pow. sochaczewski","115415","32","0","1"),
("115595","Pow. sokołowski","115415","33","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115596","Pow. szydłowiecki","115415","34","0","1"),
("115597","Pow. warszawski zachodni","115415","35","0","1"),
("115598","Pow. węgrowski","115415","36","0","1"),
("115599","Pow. wołomiński","115415","37","0","0"),
("115600","Pow. wyszkowski","115415","38","0","1"),
("115601","Pow. zwoleński","115415","39","0","1"),
("115602","Pow. żuromiński","115415","40","0","1"),
("115603","Pow. żyrardowski","115415","41","0","1"),
("115604","Opole","115416","0","0","0"),
("115605","Pow. brzeski","115416","1","0","1"),
("115606","Pow. głubczycki","115416","2","0","1"),
("115607","Pow. kędzierzyńsko-kozielski","115416","3","0","1"),
("115608","Pow. kluczborski","115416","4","0","1"),
("115609","Pow. krapkowicki","115416","5","0","1"),
("115610","Pow. namysłowski","115416","6","0","1"),
("115611","Pow. nyski","115416","7","0","1"),
("115612","Pow. oleski","115416","8","0","1"),
("115613","Pow. opolski","115416","9","0","1"),
("115614","Pow. prudnicki","115416","10","0","1"),
("115615","Pow. strzelecki","115416","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115616","Krosno","115417","0","0","1"),
("115617","Przemyśl","115417","1","0","1"),
("115618","Rzeszów","115417","2","0","0"),
("115619","Tarnobrzeg","115417","3","0","1"),
("115620","Pow. bieszczadzki","115417","4","0","1"),
("115621","Pow. brzozowski","115417","5","0","1"),
("115622","Pow. dębicki","115417","6","0","1"),
("115623","Pow. jarosławski","115417","7","0","1"),
("115624","Pow. jasielski","115417","8","0","1"),
("115625","Pow. kolbuszowski","115417","9","0","1"),
("115626","Pow. krośnieński","115417","10","0","1"),
("115627","Pow. leski","115417","11","0","1"),
("115628","Pow. leżajski","115417","12","0","1"),
("115629","Pow. lubaczowski","115417","13","0","1"),
("115630","Pow. łańcucki","115417","14","0","1"),
("115631","Pow. mielecki","115417","15","0","1"),
("115632","Pow. niżański","115417","16","0","1"),
("115633","Pow. przemyski","115417","17","0","1"),
("115634","Pow. przeworski","115417","18","0","1"),
("115635","Pow. ropczycko-sędziszowski","115417","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115636","Pow. rzeszowski","115417","20","0","1"),
("115637","Pow. sanocki","115417","21","0","1"),
("115638","Pow. stalowowolski","115417","22","0","1"),
("115639","Pow. strzyżowski","115417","23","0","1"),
("115640","Pow. tarnobrzeski","115417","24","0","1"),
("115641","Białystok","115418","0","0","0"),
("115642","Łomża","115418","1","0","1"),
("115643","Suwałki","115418","2","0","1"),
("115644","Pow. augustowski","115418","3","0","1"),
("115645","Pow. białostocki","115418","4","0","1"),
("115646","Pow. bielski","115418","5","0","1"),
("115647","Pow. grajewski","115418","6","0","1"),
("115648","Pow. hajnowski","115418","7","0","1"),
("115649","Pow. kolneński","115418","8","0","1"),
("115650","Pow. łomżyński","115418","9","0","1"),
("115651","Pow. moniecki","115418","10","0","1"),
("115652","Pow. sejneński","115418","11","0","1"),
("115653","Pow. siemiatycki","115418","12","0","1"),
("115654","Pow. sokólski","115418","13","0","1"),
("115655","Pow. suwalski","115418","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115656","Pow. wysokomazowiecki","115418","15","0","1"),
("115657","Pow. zambrowski","115418","16","0","1"),
("115658","Gdańsk","115419","0","0","0"),
("115659","Gdynia","115419","1","0","0"),
("115660","Słupsk","115419","2","0","1"),
("115661","Sopot","115419","3","0","0"),
("115662","Pow. bytowski","115419","4","0","1"),
("115663","Pow. chojnicki","115419","5","0","1"),
("115664","Pow. człuchowski","115419","6","0","1"),
("115665","Pow. gdański","115419","7","0","1"),
("115666","Pow. kartuski","115419","8","0","1"),
("115667","Pow. kościerski","115419","9","0","1"),
("115668","Pow. kwidzyński","115419","10","0","1"),
("115669","Pow. lęborski","115419","11","0","1"),
("115670","Pow. malborski","115419","12","0","1"),
("115671","Pow. nowodworski","115419","13","0","1"),
("115672","Pow. pucki","115419","14","0","1"),
("115673","Pow. słupski","115419","15","0","1"),
("115674","Pow. starogardzki","115419","16","0","1"),
("115675","Pow. sztumski","115419","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115676","Pow. tczewski","115419","18","0","1"),
("115677","Pow. wejherowski","115419","19","0","0"),
("115678","Bielsko-Biała","115420","0","0","0"),
("115679","Bytom","115420","1","0","0"),
("115680","Chorzów","115420","2","0","1"),
("115681","Częstochowa","115420","3","0","0"),
("115682","Dąbrowa Górnicza","115420","4","0","1"),
("115683","Gliwice","115420","5","0","0"),
("115684","Jastrzębie-Zdrój","115420","6","0","1"),
("115685","Jaworzno","115420","7","0","1"),
("115686","Katowice","115420","8","0","0"),
("115687","Mysłowice","115420","9","0","1"),
("115688","Piekary Śląskie","115420","10","0","1"),
("115689","Ruda Śląska","115420","11","0","1"),
("115690","Rybnik","115420","12","0","1"),
("115691","Siemianowice Śląskie","115420","13","0","1"),
("115692","Sosnowiec","115420","14","0","0"),
("115693","Świętochłowice","115420","15","0","1"),
("115694","Tychy","115420","16","0","0"),
("115695","Zabrze","115420","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115696","Żory","115420","18","0","1"),
("115697","Pow. będziński","115420","19","0","1"),
("115698","Pow. bielski","115420","20","0","1"),
("115699","Pow. bieruńsko-lędziński","115420","21","0","1"),
("115700","Pow. cieszyński","115420","22","0","1"),
("115701","Pow. częstochowski","115420","23","0","1"),
("115702","Pow. gliwicki","115420","24","0","1"),
("115703","Pow. kłobucki","115420","25","0","1"),
("115704","Pow. lubliniecki","115420","26","0","1"),
("115705","Pow. mikołowski","115420","27","0","1"),
("115706","Pow. myszkowski","115420","28","0","1"),
("115707","Pow. pszczyński","115420","29","0","1"),
("115708","Pow. raciborski","115420","30","0","1"),
("115709","Pow. rybnicki","115420","31","0","1"),
("115710","Pow. tarnogórski","115420","32","0","1"),
("115711","Pow. wodzisławski","115420","33","0","1"),
("115712","Pow. zawierciański","115420","34","0","1"),
("115713","Pow. żywiecki","115420","35","0","1"),
("115714","Kielce","115421","0","0","1"),
("115715","Pow. buski","115421","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115716","Pow. jędrzejowski","115421","2","0","1"),
("115717","Pow. kazimierski","115421","3","0","1"),
("115718","Pow. kielecki","115421","4","0","1"),
("115719","Pow. konecki","115421","5","0","1"),
("115720","Pow. opatowski","115421","6","0","1"),
("115721","Pow. ostrowiecki","115421","7","0","1"),
("115722","Pow. pińczowski","115421","8","0","1"),
("115723","Pow. sandomierski","115421","9","0","1"),
("115724","Pow. skarżyski","115421","10","0","1"),
("115725","Pow. starachowicki","115421","11","0","1"),
("115726","Pow. staszowski","115421","12","0","1"),
("115727","Pow. włoszczowski","115421","13","0","1"),
("115728","Elbląg","115422","0","0","1"),
("115729","Olsztyn","115422","1","0","1"),
("115730","Pow. bartoszycki","115422","2","0","1"),
("115731","Pow. braniewski","115422","3","0","1"),
("115732","Pow. działdowski","115422","4","0","1"),
("115733","Pow. elbląski","115422","5","0","1"),
("115734","Pow. ełcki","115422","6","0","1"),
("115735","Pow. giżycki","115422","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115736","Pow. gołdapski","115422","8","0","1"),
("115737","Pow. iławski","115422","9","0","1"),
("115738","Pow. kętrzyński","115422","10","0","1"),
("115739","Pow. lidzbarski","115422","11","0","1"),
("115740","Pow. mrągowski","115422","12","0","1"),
("115741","Pow. nidzicki","115422","13","0","1"),
("115742","Pow. nowomiejski","115422","14","0","1"),
("115743","Pow. olecki","115422","15","0","1"),
("115744","Pow. olsztyński","115422","16","0","1"),
("115745","Pow. ostródzki","115422","17","0","1"),
("115746","Pow. piski","115422","18","0","1"),
("115747","Pow. szczycieński","115422","19","0","1"),
("115748","Pow. węgorzewski","115422","20","0","1"),
("115749","Kalisz","115423","0","0","1"),
("115750","Konin","115423","1","0","1"),
("115751","Leszno","115423","2","0","1"),
("115752","Poznań","115423","3","0","0"),
("115753","Pow. chodzieski","115423","4","0","1"),
("115754","Pow. czarnkowsko-trzcianecki","115423","5","0","1"),
("115755","Pow. gnieźnieński","115423","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115756","Pow. gostyński","115423","7","0","1"),
("115757","Pow. grodziski","115423","8","0","1"),
("115758","Pow. jarociński","115423","9","0","1"),
("115759","Pow. kaliski","115423","10","0","1"),
("115760","Pow. kępiński","115423","11","0","1"),
("115761","Pow. kolski","115423","12","0","1"),
("115762","Pow. koniński","115423","13","0","1"),
("115763","Pow. kościański","115423","14","0","1"),
("115764","Pow. krotoszyński","115423","15","0","1"),
("115765","Pow. leszczyński","115423","16","0","1"),
("115766","Pow. międzychodzki","115423","17","0","1"),
("115767","Pow. nowotomyski","115423","18","0","1"),
("115768","Pow. obornicki","115423","19","0","1"),
("115769","Pow. ostrowski","115423","20","0","1"),
("115770","Pow. ostrzeszowski","115423","21","0","1"),
("115771","Pow. pilski","115423","22","0","1"),
("115772","Pow. pleszewski","115423","23","0","1"),
("115773","Pow. poznański","115423","24","0","1"),
("115774","Pow. rawicki","115423","25","0","1"),
("115775","Pow. słupecki","115423","26","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115776","Pow. szamotulski","115423","27","0","1"),
("115777","Pow. średzki","115423","28","0","1"),
("115778","Pow. śremski","115423","29","0","1"),
("115779","Pow. turecki","115423","30","0","1"),
("115780","Pow. wągrowiecki","115423","31","0","1"),
("115781","Pow. wolsztyński","115423","32","0","1"),
("115782","Pow. wrzesiński","115423","33","0","1"),
("115783","Pow. złotowski","115423","34","0","1"),
("115784","Koszalin","115424","0","0","0"),
("115785","Szczecin","115424","1","0","0"),
("115786","Świnoujście","115424","2","0","1"),
("115787","Pow. białogardzki","115424","3","0","1"),
("115788","Pow. choszczeński","115424","4","0","1"),
("115789","Pow. drawski","115424","5","0","1"),
("115790","Pow. goleniowski","115424","6","0","1"),
("115791","Pow. gryficki","115424","7","0","1"),
("115792","Pow. gryfiński","115424","8","0","1"),
("115793","Pow. kamieński","115424","9","0","1"),
("115794","Pow. kołobrzeski","115424","10","0","1"),
("115795","Pow. koszaliński","115424","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115796","Pow. łobeski","115424","12","0","1"),
("115797","Pow. myśliborski","115424","13","0","1"),
("115798","Pow. policki","115424","14","0","1"),
("115799","Pow. pyrzycki","115424","15","0","1"),
("115800","Pow. sławieński","115424","16","0","1"),
("115801","Pow. stargardzki","115424","17","0","1"),
("115802","Pow. szczecinecki","115424","18","0","1"),
("115803","Pow. świdwiński","115424","19","0","1"),
("115804","Pow. wałecki","115424","20","0","1"),
("115805","Cieplice Śląskie-Zdrój","115425","0","0","1"),
("115806","Czarne","115425","1","0","1"),
("115807","Dąbrówka","115425","2","0","1"),
("115808","Goduszyn","115425","3","0","1"),
("115809","Grabary","115425","4","0","1"),
("115810","Jagniątków","115425","5","0","1"),
("115811","Maciejowa","115425","6","0","1"),
("115812","Paulinów","115425","7","0","1"),
("115813","Sobieszów","115425","8","0","1"),
("115814","Strupice","115425","9","0","1"),
("115815","Zabobrze","115425","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115816","Pozostałe","115425","11","0","1"),
("115817","Fabryczna","115428","0","0","1"),
("115818","Krzyki","115428","1","0","1"),
("115819","Psie Pole","115428","2","0","1"),
("115820","Stare Miasto","115428","3","0","1"),
("115821","Śródmieście","115428","4","0","1"),
("115822","Pozostałe","115428","5","0","1"),
("115823","Bartodzieje Małe","115455","0","0","1"),
("115824","Bartodzieje Wielkie","115455","1","0","1"),
("115825","Bielawy","115455","2","0","1"),
("115826","Błonie","115455","3","0","1"),
("115827","Bocianowo","115455","4","0","1"),
("115828","Czyżkówko","115455","5","0","1"),
("115829","Fordon","115455","6","0","1"),
("115830","Górzyskowo","115455","7","0","1"),
("115831","Okole","115455","8","0","1"),
("115832","Osiedle Leśne","115455","9","0","1"),
("115833","Osowa Góra","115455","10","0","1"),
("115834","Skrzetusko","115455","11","0","1"),
("115835","Szwederowo","115455","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115836","Wilczak","115455","14","0","1"),
("115837","Pozostałe","115455","15","0","1"),
("115838","Bielany","115457","0","0","1"),
("115839","Bielawy","115457","1","0","1"),
("115840","Bydgoskie Przedmieście","115457","2","0","1"),
("115841","Chełmińskie Przedmieście","115457","3","0","1"),
("115842","Jakubskie Przedmieście","115457","4","0","1"),
("115843","Koniuchy","115457","5","0","1"),
("115844","Mokre","115457","6","0","1"),
("115845","Na Skarpie","115457","7","0","1"),
("115846","Podgórz","115457","8","0","1"),
("115847","Rubinkowo","115457","9","0","1"),
("115848","Rudak","115457","10","0","1"),
("115849","Rybaki","115457","11","0","1"),
("115850","Stare Miasto","115457","12","0","1"),
("115851","Stawki","115457","13","0","1"),
("115852","Wrzosy","115457","14","0","1"),
("115853","Pozostałe","115457","15","0","1"),
("115854","Bazylianówka","115480","0","0","1"),
("115855","Bronowice","115480","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115856","Czechów Górny","115480","2","0","1"),
("115857","Czuby","115480","3","0","1"),
("115858","Dziesiąta","115480","4","0","1"),
("115859","Felin","115480","5","0","1"),
("115860","Kalinowszczyzna","115480","6","0","1"),
("115861","Kośminek","115480","7","0","1"),
("115862","Rudnik","115480","8","0","1"),
("115863","Sławinek","115480","9","0","1"),
("115864","Śródmieście","115480","10","0","1"),
("115865","Tatary","115480","11","0","1"),
("115866","Węglin","115480","12","0","1"),
("115867","Wieniawka","115480","13","0","1"),
("115868","Wrotków","115480","14","0","1"),
("115869","Pozostałe","115480","15","0","1"),
("115870","Bałuty","115516","0","0","1"),
("115871","Górna","115516","1","0","1"),
("115872","Polesie","115516","2","0","1"),
("115873","Śródmieście","115516","3","0","1"),
("115874","Widzew","115516","4","0","1"),
("115875","Pozostałe","115516","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115876","Krowodrza","115540","0","0","1"),
("115877","Nowa Huta","115540","1","0","1"),
("115878","Podgórze","115540","2","0","1"),
("115879","Śródmieście","115540","3","0","1"),
("115880","Pozostałe","115540","4","0","1"),
("115881","Bemowo","115566","0","0","1"),
("115882","Białołęka","115566","1","0","1"),
("115883","Bielany","115566","2","0","1"),
("115884","Mokotów","115566","3","0","1"),
("115885","Ochota","115566","4","0","1"),
("115886","Praga Południe","115566","5","0","1"),
("115887","Praga Północ","115566","6","0","1"),
("115888","Rembertów","115566","7","0","1"),
("115889","Śródmieście","115566","8","0","1"),
("115890","Targówek","115566","9","0","1"),
("115891","Ursus","115566","10","0","1"),
("115892","Ursynów","115566","11","0","1"),
("115893","Wawer","115566","12","0","1"),
("115894","Wesoła","115566","13","0","1"),
("115895","Wilanów","115566","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115896","Włochy","115566","15","0","1"),
("115897","Wola","115566","16","0","1"),
("115898","Żoliborz","115566","17","0","1"),
("115899","Pozostałe","115566","18","0","1"),
("115900","Góra Kalwaria","115584","0","0","1"),
("115901","Konstancin-Jeziorna","115584","1","0","1"),
("115902","Piaseczno","115584","2","0","1"),
("115903","Tarczyn","115584","3","0","1"),
("115904","Pozostałe","115584","4","0","1"),
("115905","Brwinów","115587","0","0","1"),
("115906","Piastów","115587","1","0","1"),
("115907","Pruszków","115587","2","0","1"),
("115908","Pozostałe","115587","3","0","1"),
("115909","Kobyłka","115599","0","0","1"),
("115910","Marki","115599","1","0","1"),
("115911","Radzymin","115599","2","0","1"),
("115912","Tłuszcz","115599","3","0","1"),
("115913","Wołomin","115599","4","0","1"),
("115914","Ząbki","115599","5","0","1"),
("115915","Zielonka","115599","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115916","Pozostałe","115599","7","0","1"),
("115917","Bierkowice","115604","0","0","1"),
("115918","Gosławice","115604","1","0","1"),
("115919","Groszowice","115604","2","0","1"),
("115920","Grudzice","115604","3","0","1"),
("115921","Kolonia Gosławicka","115604","4","0","1"),
("115922","Malina","115604","5","0","1"),
("115923","Nowa Wieś Królewska","115604","6","0","1"),
("115924","Półwieś","115604","7","0","1"),
("115925","Szczepanowice","115604","8","0","1"),
("115926","Wójtowa Wieś","115604","9","0","1"),
("115927","Wróblin","115604","10","0","1"),
("115928","Zakrzów","115604","11","0","1"),
("115929","Zaodrze","115604","12","0","1"),
("115930","Pozostałe","115604","13","0","1"),
("115931","Drabinianka","115618","0","0","1"),
("115932","Dworzysko","115618","1","0","1"),
("115933","Miłocin","115618","2","0","1"),
("115934","Pobitno","115618","3","0","1"),
("115935","Przybyszówka","115618","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115936","Słocina","115618","5","0","1"),
("115937","Staromieście","115618","6","0","1"),
("115938","Staroniwa","115618","7","0","1"),
("115939","Szajerówka","115618","8","0","1"),
("115940","Wilkowyja","115618","9","0","1"),
("115941","Zalesie","115618","10","0","1"),
("115942","Załęże","115618","11","0","1"),
("115943","Zwięczyca","115618","12","0","1"),
("115944","Pozostałe","115618","13","0","1"),
("115945","Antoniuk","115641","0","0","1"),
("115946","Bacieczki","115641","1","0","1"),
("115947","Białostoczek","115641","2","0","1"),
("115948","Bojary","115641","3","0","1"),
("115949","Dojlidy","115641","4","0","1"),
("115950","Dojlidy Górne","115641","5","0","1"),
("115951","Dziesięciny","115641","6","0","1"),
("115952","Nowe Miasto","115641","7","0","1"),
("115953","Skorupy","115641","8","0","1"),
("115954","Słoboda","115641","9","0","1"),
("115955","Starosielce","115641","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115956","Wygoda","115641","11","0","1"),
("115957","Wysoki Stoczek","115641","12","0","1"),
("115958","Zagórki","115641","13","0","1"),
("115959","Zawady","115641","14","0","1"),
("115960","Pozostałe","115641","15","0","1"),
("115961","Brzeźno","115658","0","0","1"),
("115962","Chełm","115658","1","0","1"),
("115963","Jasień","115658","2","0","1"),
("115964","Kiełpino Górne","115658","3","0","1"),
("115965","Kokoszki","115658","4","0","1"),
("115966","Lipce","115658","5","0","1"),
("115967","Łostowice","115658","6","0","1"),
("115968","Oliwa","115658","7","0","1"),
("115969","Osowa Góra","115658","8","0","1"),
("115970","Przymorze","115658","9","0","1"),
("115971","Siedlce","115658","10","0","1"),
("115972","Sobieszewo","115658","11","0","1"),
("115973","Suchanino","115658","12","0","1"),
("115974","Wrzeszcz","115658","13","0","1"),
("115975","Zakoniczyn","115658","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115976","Pozostałe","115658","15","0","1"),
("115977","Chwarzno","115659","0","0","1"),
("115978","Chylonia","115659","1","0","1"),
("115979","Cisowa","115659","2","0","1"),
("115980","Działki Leśne","115659","3","0","1"),
("115981","Kamienna Góra","115659","4","0","1"),
("115982","Leszczynki","115659","5","0","1"),
("115983","Mały Kack","115659","6","0","1"),
("115984","Obłuże","115659","7","0","1"),
("115985","Oksywie","115659","8","0","1"),
("115986","Orłowo","115659","9","0","1"),
("115987","Pogórze","115659","10","0","1"),
("115988","Redłowo","115659","11","0","1"),
("115989","Wiczlino","115659","12","0","1"),
("115990","Wielki Kack","115659","13","0","1"),
("115991","Wzgórze Nowotki","115659","14","0","1"),
("115992","Pozostałe","115659","15","0","1"),
("115993","Brodwino","115661","0","0","1"),
("115994","Kamienny Potok","115661","1","0","1"),
("115995","Przylesie","115661","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("115996","Sopot Dolny","115661","3","0","1"),
("115997","Sopot Górny","115661","4","0","1"),
("115998","Wyścigi","115661","5","0","1"),
("115999","Pozostałe","115661","6","0","1"),
("116000","Reda","115677","0","0","1"),
("116001","Rumia","115677","1","0","1"),
("116002","Wejherowo","115677","2","0","1"),
("116003","Pozostałe","115677","3","0","1"),
("116004","Aleksandrowice","115678","0","0","1"),
("116005","Hałcnów","115678","1","0","1"),
("116006","Kamienica","115678","2","0","1"),
("116007","Komorowice Krakowskie","115678","3","0","1"),
("116008","Komorowice Śląskie","115678","4","0","1"),
("116009","Leszczyny","115678","5","0","1"),
("116010","Lipnik","115678","6","0","1"),
("116011","Mikuszowice Krakowskie","115678","7","0","1"),
("116012","Mikuszowice Śląskie","115678","8","0","1"),
("116013","Olszówka Dolna","115678","9","0","1"),
("116014","Olszówka Górna","115678","10","0","1"),
("116015","Stare Bielsko","115678","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116016","Straconka","115678","12","0","1"),
("116017","Wapienica","115678","13","0","1"),
("116018","Złote Łany","115678","14","0","1"),
("116019","Pozostałe","115678","15","0","1"),
("116020","Bobrek","115679","0","0","1"),
("116021","Górniki","115679","1","0","1"),
("116022","Karb","115679","2","0","1"),
("116023","Łagiewniki","115679","3","0","1"),
("116024","Miechowice","115679","4","0","1"),
("116025","Rozbark","115679","5","0","1"),
("116026","Stolarzowice","115679","6","0","1"),
("116027","Stroszek","115679","7","0","1"),
("116028","Sucha Góra","115679","8","0","1"),
("116029","Szombierki","115679","9","0","1"),
("116030","Pozostałe","115679","10","0","1"),
("116031","Błeszno","115681","0","0","1"),
("116032","Dźbów","115681","1","0","1"),
("116033","Grabówka","115681","2","0","1"),
("116034","Kawodrza Dolna","115681","3","0","1"),
("116035","Lisiniec","115681","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116036","Liszka Dolna","115681","5","0","1"),
("116037","Mirów","115681","6","0","1"),
("116038","Ostatni Grosz","115681","7","0","1"),
("116039","Parkitka","115681","8","0","1"),
("116040","Raków","115681","9","0","1"),
("116041","Rząsawy","115681","10","0","1"),
("116042","Sabinów","115681","11","0","1"),
("116043","Stradom","115681","12","0","1"),
("116044","Wrzosowiak","115681","13","0","1"),
("116045","Zawodzie","115681","14","0","1"),
("116046","Pozostałe","115681","15","0","1"),
("116047","Bojków","115683","0","0","1"),
("116048","Brzezinka","115683","1","0","1"),
("116049","Czechowice","115683","2","0","1"),
("116050","Ligota Zabrska","115683","3","0","1"),
("116051","Łabędy","115683","4","0","1"),
("116052","Ostropa","115683","5","0","1"),
("116053","Sośnica","115683","6","0","1"),
("116054","Stare Gliwice","115683","7","0","1"),
("116055","Szobiszowice","115683","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116056","Trynek","115683","9","0","1"),
("116057","Wilcze Gardło","115683","10","0","1"),
("116058","Wójtowa Wieś","115683","11","0","1"),
("116059","Żerniki","115683","12","0","1"),
("116060","Pozostałe","115683","13","0","1"),
("116061","Bogucice","115686","0","0","1"),
("116062","Brynów","115686","1","0","1"),
("116063","Dąb","115686","2","0","1"),
("116064","Giszowiec","115686","3","0","1"),
("116065","Józefowiec","115686","4","0","1"),
("116066","Kostuchna","115686","5","0","1"),
("116067","Koszutka","115686","6","0","1"),
("116068","Ligota","115686","7","0","1"),
("116069","Ochojec","115686","8","0","1"),
("116070","Panewniki","115686","9","0","1"),
("116071","Piotrowice","115686","10","0","1"),
("116072","Podlesie","115686","11","0","1"),
("116073","Wełnowiec","115686","12","0","1"),
("116074","Zarzecze","115686","13","0","1"),
("116075","Zawodzie","115686","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116076","Pozostałe","115686","15","0","1"),
("116077","Cieśle","115692","0","0","1"),
("116078","Dańdówka","115692","1","0","1"),
("116079","Dębowa Góra","115692","2","0","1"),
("116080","Józefów","115692","3","0","1"),
("116081","Kazimierz","115692","4","0","1"),
("116082","Klimontów","115692","5","0","1"),
("116083","Maczki","115692","6","0","1"),
("116084","Milowice","115692","7","0","1"),
("116085","Niwka","115692","8","0","1"),
("116086","Ostrowy Górnicze","115692","9","0","1"),
("116087","Pogoń","115692","10","0","1"),
("116088","Sielec","115692","11","0","1"),
("116089","Stary Sosnowiec","115692","12","0","1"),
("116090","Środula","115692","13","0","1"),
("116091","Zagórze","115692","14","0","1"),
("116092","Pozostałe","115692","15","0","1"),
("116093","Cielmice","115694","0","0","1"),
("116094","Czułów","115694","1","0","1"),
("116095","Glinka","115694","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116096","Jaroszowice","115694","3","0","1"),
("116097","Mąkołowiec","115694","4","0","1"),
("116098","Paprocany","115694","5","0","1"),
("116099","Suble","115694","6","0","1"),
("116100","Urbanowice","115694","7","0","1"),
("116101","Wartogłowiec","115694","8","0","1"),
("116102","Wilkowyje","115694","9","0","1"),
("116103","Zwierzyniec","115694","10","0","1"),
("116104","Żwaków","115694","11","0","1"),
("116105","Pozostałe","115694","12","0","1"),
("116106","Grunwald","115752","0","0","1"),
("116107","Jeżyce","115752","1","0","1"),
("116108","Nowe Miasto","115752","2","0","1"),
("116109","Stare Miasto","115752","3","0","1"),
("116110","Wilda","115752","4","0","1"),
("116111","Pozostałe","115752","5","0","1"),
("116112","Chełmoniewo","115784","0","0","1"),
("116113","Dzierżęcino","115784","1","0","1"),
("116114","Lubiatowo","115784","2","0","1"),
("116115","Raduszka","115784","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116116","Rokosowo","115784","4","0","1"),
("116117","Pozostałe","115784","5","0","1"),
("116118","Bezrzecze","115785","0","0","1"),
("116119","Bukowe-Klęskowo","115785","1","0","1"),
("116120","Bukowo","115785","2","0","1"),
("116121","Centrum","115785","3","0","1"),
("116122","Dąbie","115785","4","0","1"),
("116123","Drzetowo","115785","5","0","1"),
("116124","Głębokie","115785","6","0","1"),
("116125","Grabowo","115785","7","0","1"),
("116126","Gumieńce","115785","8","0","1"),
("116127","Kijewo","115785","9","0","1"),
("116128","Niebuszewo","115785","10","0","1"),
("116129","Osów","115785","11","0","1"),
("116130","Pilchowo","115785","12","0","1"),
("116131","Płonia","115785","13","0","1"),
("116132","Podjuchy","115785","14","0","1"),
("116133","Pogodno","115785","15","0","1"),
("116134","Pomorzany","115785","16","0","1"),
("116135","Skolwin","115785","17","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116136","Stare Miasto","115785","18","0","1"),
("116137","Stołczyn","115785","19","0","1"),
("116138","Świerczewo","115785","20","0","1"),
("116139","Warszewo","115785","21","0","1"),
("116140","Wielgowo","115785","22","0","1"),
("116141","Zdroje","115785","23","0","1"),
("116142","Żelechowa","115785","24","0","1"),
("116143","Pozostałe","115785","25","0","1"),
("116144","Dolnośląskie","112739","0","0","0"),
("116145","Kujawsko-pomorskie","112739","1","0","0"),
("116146","Lubelskie","112739","2","0","0"),
("116147","Lubuskie","112739","3","0","0"),
("116148","Łódzkie","112739","4","0","0"),
("116149","Małopolskie","112739","5","0","0"),
("116150","Mazowieckie","112739","6","0","0"),
("116151","Opolskie","112739","7","0","0"),
("116152","Podkarpackie","112739","8","0","0"),
("116153","Podlaskie","112739","9","0","0"),
("116154","Pomorskie","112739","10","0","0"),
("116155","Śląskie","112739","11","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116156","Świętokrzyskie","112739","12","0","0"),
("116157","Warmińsko-mazurskie","112739","13","0","0"),
("116158","Wielkopolskie","112739","14","0","0"),
("116159","Zachodniopomorskie","112739","15","0","0"),
("116160","Jelenia Góra","116144","0","0","0"),
("116161","Legnica","116144","1","0","1"),
("116162","Wałbrzych","116144","2","0","1"),
("116163","Wrocław","116144","3","0","0"),
("116164","Pow. bolesławiecki","116144","4","0","1"),
("116165","Pow. dzierżoniowski","116144","5","0","1"),
("116166","Pow. głogowski","116144","6","0","1"),
("116167","Pow. górowski","116144","7","0","1"),
("116168","Pow. jaworski","116144","8","0","1"),
("116169","Pow. jeleniogórski","116144","9","0","1"),
("116170","Pow. kamiennogórski","116144","10","0","1"),
("116171","Pow. kłodzki","116144","11","0","1"),
("116172","Pow. legnicki","116144","12","0","1"),
("116173","Pow. lubański","116144","13","0","1"),
("116174","Pow. lubiński","116144","14","0","1"),
("116175","Pow. lwówecki","116144","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116176","Pow. milicki","116144","16","0","1"),
("116177","Pow. oleśnicki","116144","17","0","1"),
("116178","Pow. oławski","116144","18","0","1"),
("116179","Pow. polkowicki","116144","19","0","1"),
("116180","Pow. strzeliński","116144","20","0","1"),
("116181","Pow. średzki","116144","21","0","1"),
("116182","Pow. świdnicki","116144","22","0","1"),
("116183","Pow. trzebnicki","116144","23","0","1"),
("116184","Pow. wałbrzyski","116144","24","0","1"),
("116185","Pow. wołowski","116144","25","0","1"),
("116186","Pow. wrocławski","116144","26","0","1"),
("116187","Pow. ząbkowicki","116144","27","0","1"),
("116188","Pow. zgorzelecki","116144","28","0","1"),
("116189","Pow. złotoryjski","116144","29","0","1"),
("116190","Bydgoszcz","116145","0","0","0"),
("116191","Grudziądz","116145","1","0","1"),
("116192","Toruń","116145","2","0","0"),
("116193","Włocławek","116145","3","0","1"),
("116194","Pow. aleksandrowski","116145","4","0","1"),
("116195","Pow. brodnicki","116145","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116196","Pow. bydgoski","116145","6","0","1"),
("116197","Pow. chełmiński","116145","7","0","1"),
("116198","Pow. golubsko-dobrzyński","116145","8","0","1"),
("116199","Pow. grudziądzki","116145","9","0","1"),
("116200","Pow. inowrocławski","116145","10","0","1"),
("116201","Pow. lipnowski","116145","11","0","1"),
("116202","Pow. mogileński","116145","12","0","1"),
("116203","Pow. nakielski","116145","13","0","1"),
("116204","Pow. radziejowski","116145","14","0","1"),
("116205","Pow. rypiński","116145","15","0","1"),
("116206","Pow. sępoleński","116145","16","0","1"),
("116207","Pow. świecki","116145","17","0","1"),
("116208","Pow. toruński","116145","18","0","1"),
("116209","Pow. tucholski","116145","19","0","1"),
("116210","Pow. wąbrzeski","116145","20","0","1"),
("116211","Pow. włocławski","116145","21","0","1"),
("116212","Pow. żniński","116145","22","0","1"),
("116213","Biała Podlaska","116146","0","0","1"),
("116214","Chełm","116146","1","0","1"),
("116215","Lublin","116146","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116216","Zamość","116146","3","0","1"),
("116217","Pow. bialski","116146","4","0","1"),
("116218","Pow. biłgorajski","116146","5","0","1"),
("116219","Pow. chełmski","116146","6","0","1"),
("116220","Pow. hrubieszowski","116146","7","0","1"),
("116221","Pow. janowski","116146","8","0","1"),
("116222","Pow. krasnostawski","116146","9","0","1"),
("116223","Pow. kraśnicki","116146","10","0","1"),
("116224","Pow. lubartowski","116146","11","0","1"),
("116225","Pow. lubelski","116146","12","0","1"),
("116226","Pow. łęczyński","116146","13","0","1"),
("116227","Pow. łukowski","116146","14","0","1"),
("116228","Pow. opolski","116146","15","0","1"),
("116229","Pow. parczewski","116146","16","0","1"),
("116230","Pow. puławski","116146","17","0","1"),
("116231","Pow. radzyński","116146","18","0","1"),
("116232","Pow. rycki","116146","19","0","1"),
("116233","Pow. świdnicki","116146","20","0","1"),
("116234","Pow. tomaszowski","116146","21","0","1"),
("116235","Pow. włodawski","116146","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116236","Pow. zamojski","116146","23","0","1"),
("116237","Gorzów Wielkopolski","116147","0","0","1"),
("116238","Zielona Góra","116147","1","0","1"),
("116239","Pow. gorzowski","116147","2","0","1"),
("116240","Pow. krośnieński","116147","3","0","1"),
("116241","Pow. międzyrzecki","116147","4","0","1"),
("116242","Pow. nowosolski","116147","5","0","1"),
("116243","Pow. słubicki","116147","6","0","1"),
("116244","Pow. strzelecko-drezdenecki","116147","7","0","1"),
("116245","Pow. sulęciński","116147","8","0","1"),
("116246","Pow. świebodziński","116147","9","0","1"),
("116247","Pow. wschowski","116147","10","0","1"),
("116248","Pow. zielonogórski","116147","11","0","1"),
("116249","Pow. żagański","116147","12","0","1"),
("116250","Pow. żarski","116147","13","0","1"),
("116251","Łódź","116148","0","0","0"),
("116252","Piotrków Trybunalski","116148","1","0","1"),
("116253","Skierniewice","116148","2","0","1"),
("116254","Pow. bełchatowski","116148","3","0","1"),
("116255","Pow. brzeziński","116148","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116256","Pow. kutnowski","116148","5","0","1"),
("116257","Pow. łaski","116148","6","0","1"),
("116258","Pow. łęczycki","116148","7","0","1"),
("116259","Pow. łowicki","116148","8","0","1"),
("116260","Pow. łódzki wschodni","116148","9","0","1"),
("116261","Pow. opoczyński","116148","10","0","1"),
("116262","Pow. pabianicki","116148","11","0","1"),
("116263","Pow. pajęczański","116148","12","0","1"),
("116264","Pow. piotrkowski","116148","13","0","1"),
("116265","Pow. poddębicki","116148","14","0","1"),
("116266","Pow. radomszczański","116148","15","0","1"),
("116267","Pow. rawski","116148","16","0","1"),
("116268","Pow. sieradzki","116148","17","0","1"),
("116269","Pow. skierniewicki","116148","18","0","1"),
("116270","Pow. tomaszowski","116148","19","0","1"),
("116271","Pow. wieluński","116148","20","0","1"),
("116272","Pow. wieruszowski","116148","21","0","1"),
("116273","Pow. zduńskowolski","116148","22","0","1"),
("116274","Pow. zgierski","116148","23","0","1"),
("116275","Kraków","116149","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116276","Nowy Sącz","116149","1","0","1"),
("116277","Tarnów","116149","2","0","1"),
("116278","Pow. bocheński","116149","3","0","1"),
("116279","Pow. brzeski","116149","4","0","1"),
("116280","Pow. chrzanowski","116149","5","0","1"),
("116281","Pow. dąbrowski","116149","6","0","1"),
("116282","Pow. gorlicki","116149","7","0","1"),
("116283","Pow. krakowski","116149","8","0","1"),
("116284","Pow. limanowski","116149","9","0","1"),
("116285","Pow. miechowski","116149","10","0","1"),
("116286","Pow. myślenicki","116149","11","0","1"),
("116287","Pow. nowosądecki","116149","12","0","1"),
("116288","Pow. nowotarski","116149","13","0","1"),
("116289","Pow. olkuski","116149","14","0","1"),
("116290","Pow. oświęcimski","116149","15","0","1"),
("116291","Pow. proszowicki","116149","16","0","1"),
("116292","Pow. suski","116149","17","0","1"),
("116293","Pow. tarnowski","116149","18","0","1"),
("116294","Pow. tatrzański","116149","19","0","1"),
("116295","Pow. wadowicki","116149","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116296","Pow. wielicki","116149","21","0","1"),
("116297","Ostrołęka","116150","0","0","1"),
("116298","Płock","116150","1","0","1"),
("116299","Radom","116150","2","0","1"),
("116300","Siedlce","116150","3","0","1"),
("116301","Warszawa","116150","4","0","0"),
("116302","Pow. białobrzeski","116150","5","0","1"),
("116303","Pow. ciechanowski","116150","6","0","1"),
("116304","Pow. garwoliński","116150","7","0","1"),
("116305","Pow. gostyniński","116150","8","0","1"),
("116306","Pow. grodziski","116150","9","0","1"),
("116307","Pow. grójecki","116150","10","0","1"),
("116308","Pow. kozienicki","116150","11","0","1"),
("116309","Pow. legionowski","116150","12","0","1"),
("116310","Pow. lipski","116150","13","0","1"),
("116311","Pow. łosicki","116150","14","0","1"),
("116312","Pow. makowski","116150","15","0","1"),
("116313","Pow. miński","116150","16","0","1"),
("116314","Pow. mławski","116150","17","0","1"),
("116315","Pow. nowodworski","116150","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116316","Pow. ostrołęcki","116150","19","0","1"),
("116317","Pow. ostrowski","116150","20","0","1"),
("116318","Pow. otwocki","116150","21","0","1"),
("116319","Pow. piaseczyński","116150","22","0","0"),
("116320","Pow. płocki","116150","23","0","1"),
("116321","Pow. płoński","116150","24","0","1"),
("116322","Pow. pruszkowski","116150","25","0","0"),
("116323","Pow. przasnyski","116150","26","0","1"),
("116324","Pow. przysuski","116150","27","0","1"),
("116325","Pow. pułtuski","116150","28","0","1"),
("116326","Pow. radomski","116150","29","0","1"),
("116327","Pow. siedlecki","116150","30","0","1"),
("116328","Pow. sierpecki","116150","31","0","1"),
("116329","Pow. sochaczewski","116150","32","0","1"),
("116330","Pow. sokołowski","116150","33","0","1"),
("116331","Pow. szydłowiecki","116150","34","0","1"),
("116332","Pow. warszawski zachodni","116150","35","0","1"),
("116333","Pow. węgrowski","116150","36","0","1"),
("116334","Pow. wołomiński","116150","37","0","0"),
("116335","Pow. wyszkowski","116150","38","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116336","Pow. zwoleński","116150","39","0","1"),
("116337","Pow. żuromiński","116150","40","0","1"),
("116338","Pow. żyrardowski","116150","41","0","1"),
("116339","Opole","116151","0","0","0"),
("116340","Pow. brzeski","116151","1","0","1"),
("116341","Pow. głubczycki","116151","2","0","1"),
("116342","Pow. kędzierzyńsko-kozielski","116151","3","0","1"),
("116343","Pow. kluczborski","116151","4","0","1"),
("116344","Pow. krapkowicki","116151","5","0","1"),
("116345","Pow. namysłowski","116151","6","0","1"),
("116346","Pow. nyski","116151","7","0","1"),
("116347","Pow. oleski","116151","8","0","1"),
("116348","Pow. opolski","116151","9","0","1"),
("116349","Pow. prudnicki","116151","10","0","1"),
("116350","Pow. strzelecki","116151","11","0","1"),
("116351","Krosno","116152","0","0","1"),
("116352","Przemyśl","116152","1","0","1"),
("116353","Rzeszów","116152","2","0","0"),
("116354","Tarnobrzeg","116152","3","0","1"),
("116355","Pow. bieszczadzki","116152","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116356","Pow. brzozowski","116152","5","0","1"),
("116357","Pow. dębicki","116152","6","0","1"),
("116358","Pow. jarosławski","116152","7","0","1"),
("116359","Pow. jasielski","116152","8","0","1"),
("116360","Pow. kolbuszowski","116152","9","0","1"),
("116361","Pow. krośnieński","116152","10","0","1"),
("116362","Pow. leski","116152","11","0","1"),
("116363","Pow. leżajski","116152","12","0","1"),
("116364","Pow. lubaczowski","116152","13","0","1"),
("116365","Pow. łańcucki","116152","14","0","1"),
("116366","Pow. mielecki","116152","15","0","1"),
("116367","Pow. niżański","116152","16","0","1"),
("116368","Pow. przemyski","116152","17","0","1"),
("116369","Pow. przeworski","116152","18","0","1"),
("116370","Pow. ropczycko-sędziszowski","116152","19","0","1"),
("116371","Pow. rzeszowski","116152","20","0","1"),
("116372","Pow. sanocki","116152","21","0","1"),
("116373","Pow. stalowowolski","116152","22","0","1"),
("116374","Pow. strzyżowski","116152","23","0","1"),
("116375","Pow. tarnobrzeski","116152","24","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116376","Białystok","116153","0","0","0"),
("116377","Łomża","116153","1","0","1"),
("116378","Suwałki","116153","2","0","1"),
("116379","Pow. augustowski","116153","3","0","1"),
("116380","Pow. białostocki","116153","4","0","1"),
("116381","Pow. bielski","116153","5","0","1"),
("116382","Pow. grajewski","116153","6","0","1"),
("116383","Pow. hajnowski","116153","7","0","1"),
("116384","Pow. kolneński","116153","8","0","1"),
("116385","Pow. łomżyński","116153","9","0","1"),
("116386","Pow. moniecki","116153","10","0","1"),
("116387","Pow. sejneński","116153","11","0","1"),
("116388","Pow. siemiatycki","116153","12","0","1"),
("116389","Pow. sokólski","116153","13","0","1"),
("116390","Pow. suwalski","116153","14","0","1"),
("116391","Pow. wysokomazowiecki","116153","15","0","1"),
("116392","Pow. zambrowski","116153","16","0","1"),
("116393","Gdańsk","116154","0","0","0"),
("116394","Gdynia","116154","1","0","0"),
("116395","Słupsk","116154","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116396","Sopot","116154","3","0","0"),
("116397","Pow. bytowski","116154","4","0","1"),
("116398","Pow. chojnicki","116154","5","0","1"),
("116399","Pow. człuchowski","116154","6","0","1"),
("116400","Pow. gdański","116154","7","0","1"),
("116401","Pow. kartuski","116154","8","0","1"),
("116402","Pow. kościerski","116154","9","0","1"),
("116403","Pow. kwidzyński","116154","10","0","1"),
("116404","Pow. lęborski","116154","11","0","1"),
("116405","Pow. malborski","116154","12","0","1"),
("116406","Pow. nowodworski","116154","13","0","1"),
("116407","Pow. pucki","116154","14","0","1"),
("116408","Pow. słupski","116154","15","0","1"),
("116409","Pow. starogardzki","116154","16","0","1"),
("116410","Pow. sztumski","116154","17","0","1"),
("116411","Pow. tczewski","116154","18","0","1"),
("116412","Pow. wejherowski","116154","19","0","0"),
("116413","Bielsko-Biała","116155","0","0","0"),
("116414","Bytom","116155","1","0","0"),
("116415","Chorzów","116155","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116416","Częstochowa","116155","3","0","0"),
("116417","Dąbrowa Górnicza","116155","4","0","1"),
("116418","Gliwice","116155","5","0","0"),
("116419","Jastrzębie-Zdrój","116155","6","0","1"),
("116420","Jaworzno","116155","7","0","1"),
("116421","Katowice","116155","8","0","0"),
("116422","Mysłowice","116155","9","0","1"),
("116423","Piekary Śląskie","116155","10","0","1"),
("116424","Ruda Śląska","116155","11","0","1"),
("116425","Rybnik","116155","12","0","1"),
("116426","Siemianowice Śląskie","116155","13","0","1"),
("116427","Sosnowiec","116155","14","0","0"),
("116428","Świętochłowice","116155","15","0","1"),
("116429","Tychy","116155","16","0","0"),
("116430","Zabrze","116155","17","0","1"),
("116431","Żory","116155","18","0","1"),
("116432","Pow. będziński","116155","19","0","1"),
("116433","Pow. bielski","116155","20","0","1"),
("116434","Pow. bieruńsko-lędziński","116155","21","0","1"),
("116435","Pow. cieszyński","116155","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116436","Pow. częstochowski","116155","23","0","1"),
("116437","Pow. gliwicki","116155","24","0","1"),
("116438","Pow. kłobucki","116155","25","0","1"),
("116439","Pow. lubliniecki","116155","26","0","1"),
("116440","Pow. mikołowski","116155","27","0","1"),
("116441","Pow. myszkowski","116155","28","0","1"),
("116442","Pow. pszczyński","116155","29","0","1"),
("116443","Pow. raciborski","116155","30","0","1"),
("116444","Pow. rybnicki","116155","31","0","1"),
("116445","Pow. tarnogórski","116155","32","0","1"),
("116446","Pow. wodzisławski","116155","33","0","1"),
("116447","Pow. zawierciański","116155","34","0","1"),
("116448","Pow. żywiecki","116155","35","0","1"),
("116449","Kielce","116156","0","0","1"),
("116450","Pow. buski","116156","1","0","1"),
("116451","Pow. jędrzejowski","116156","2","0","1"),
("116452","Pow. kazimierski","116156","3","0","1"),
("116453","Pow. kielecki","116156","4","0","1"),
("116454","Pow. konecki","116156","5","0","1"),
("116455","Pow. opatowski","116156","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116456","Pow. ostrowiecki","116156","7","0","1"),
("116457","Pow. pińczowski","116156","8","0","1"),
("116458","Pow. sandomierski","116156","9","0","1"),
("116459","Pow. skarżyski","116156","10","0","1"),
("116460","Pow. starachowicki","116156","11","0","1"),
("116461","Pow. staszowski","116156","12","0","1"),
("116462","Pow. włoszczowski","116156","13","0","1"),
("116463","Elbląg","116157","0","0","1"),
("116464","Olsztyn","116157","1","0","1"),
("116465","Pow. bartoszycki","116157","2","0","1"),
("116466","Pow. braniewski","116157","3","0","1"),
("116467","Pow. działdowski","116157","4","0","1"),
("116468","Pow. elbląski","116157","5","0","1"),
("116469","Pow. ełcki","116157","6","0","1"),
("116470","Pow. giżycki","116157","7","0","1"),
("116471","Pow. gołdapski","116157","8","0","1"),
("116472","Pow. iławski","116157","9","0","1"),
("116473","Pow. kętrzyński","116157","10","0","1"),
("116474","Pow. lidzbarski","116157","11","0","1"),
("116475","Pow. mrągowski","116157","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116476","Pow. nidzicki","116157","13","0","1"),
("116477","Pow. nowomiejski","116157","14","0","1"),
("116478","Pow. olecki","116157","15","0","1"),
("116479","Pow. olsztyński","116157","16","0","1"),
("116480","Pow. ostródzki","116157","17","0","1"),
("116481","Pow. piski","116157","18","0","1"),
("116482","Pow. szczycieński","116157","19","0","1"),
("116483","Pow. węgorzewski","116157","20","0","1"),
("116484","Kalisz","116158","0","0","1"),
("116485","Konin","116158","1","0","1"),
("116486","Leszno","116158","2","0","1"),
("116487","Poznań","116158","3","0","0"),
("116488","Pow. chodzieski","116158","4","0","1"),
("116489","Pow. czarnkowsko-trzcianecki","116158","5","0","1"),
("116490","Pow. gnieźnieński","116158","6","0","1"),
("116491","Pow. gostyński","116158","7","0","1"),
("116492","Pow. grodziski","116158","8","0","1"),
("116493","Pow. jarociński","116158","9","0","1"),
("116494","Pow. kaliski","116158","10","0","1"),
("116495","Pow. kępiński","116158","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116496","Pow. kolski","116158","12","0","1"),
("116497","Pow. koniński","116158","13","0","1"),
("116498","Pow. kościański","116158","14","0","1"),
("116499","Pow. krotoszyński","116158","15","0","1"),
("116500","Pow. leszczyński","116158","16","0","1"),
("116501","Pow. międzychodzki","116158","17","0","1"),
("116502","Pow. nowotomyski","116158","18","0","1"),
("116503","Pow. obornicki","116158","19","0","1"),
("116504","Pow. ostrowski","116158","20","0","1"),
("116505","Pow. ostrzeszowski","116158","21","0","1"),
("116506","Pow. pilski","116158","22","0","1"),
("116507","Pow. pleszewski","116158","23","0","1"),
("116508","Pow. poznański","116158","24","0","1"),
("116509","Pow. rawicki","116158","25","0","1"),
("116510","Pow. słupecki","116158","26","0","1"),
("116511","Pow. szamotulski","116158","27","0","1"),
("116512","Pow. średzki","116158","28","0","1"),
("116513","Pow. śremski","116158","29","0","1"),
("116514","Pow. turecki","116158","30","0","1"),
("116515","Pow. wągrowiecki","116158","31","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116516","Pow. wolsztyński","116158","32","0","1"),
("116517","Pow. wrzesiński","116158","33","0","1"),
("116518","Pow. złotowski","116158","34","0","1"),
("116519","Koszalin","116159","0","0","0"),
("116520","Szczecin","116159","1","0","0"),
("116521","Świnoujście","116159","2","0","1"),
("116522","Pow. białogardzki","116159","3","0","1"),
("116523","Pow. choszczeński","116159","4","0","1"),
("116524","Pow. drawski","116159","5","0","1"),
("116525","Pow. goleniowski","116159","6","0","1"),
("116526","Pow. gryficki","116159","7","0","1"),
("116527","Pow. gryfiński","116159","8","0","1"),
("116528","Pow. kamieński","116159","9","0","1"),
("116529","Pow. kołobrzeski","116159","10","0","1"),
("116530","Pow. koszaliński","116159","11","0","1"),
("116531","Pow. łobeski","116159","12","0","1"),
("116532","Pow. myśliborski","116159","13","0","1"),
("116533","Pow. policki","116159","14","0","1"),
("116534","Pow. pyrzycki","116159","15","0","1"),
("116535","Pow. sławieński","116159","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116536","Pow. stargardzki","116159","17","0","1"),
("116537","Pow. szczecinecki","116159","18","0","1"),
("116538","Pow. świdwiński","116159","19","0","1"),
("116539","Pow. wałecki","116159","20","0","1"),
("116540","Cieplice Śląskie-Zdrój","116160","0","0","1"),
("116541","Czarne","116160","1","0","1"),
("116542","Dąbrówka","116160","2","0","1"),
("116543","Goduszyn","116160","3","0","1"),
("116544","Grabary","116160","4","0","1"),
("116545","Jagniątków","116160","5","0","1"),
("116546","Maciejowa","116160","6","0","1"),
("116547","Paulinów","116160","7","0","1"),
("116548","Sobieszów","116160","8","0","1"),
("116549","Strupice","116160","9","0","1"),
("116550","Zabobrze","116160","10","0","1"),
("116551","Pozostałe","116160","11","0","1"),
("116552","Fabryczna","116163","0","0","1"),
("116553","Krzyki","116163","1","0","1"),
("116554","Psie Pole","116163","2","0","1"),
("116555","Stare Miasto","116163","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116556","Śródmieście","116163","4","0","1"),
("116557","Pozostałe","116163","5","0","1"),
("116558","Bartodzieje Małe","116190","0","0","1"),
("116559","Bartodzieje Wielkie","116190","1","0","1"),
("116560","Bielawy","116190","2","0","1"),
("116561","Błonie","116190","3","0","1"),
("116562","Bocianowo","116190","4","0","1"),
("116563","Czyżkówko","116190","5","0","1"),
("116564","Fordon","116190","6","0","1"),
("116565","Górzyskowo","116190","7","0","1"),
("116566","Kapuściska","116190","8","0","1"),
("116567","Okole","116190","9","0","1"),
("116568","Osiedle Leśne","116190","10","0","1"),
("116569","Osowa Góra","116190","11","0","1"),
("116570","Skrzetusko","116190","12","0","1"),
("116571","Szwederowo","116190","13","0","1"),
("116572","Wilczak","116190","15","0","1"),
("116573","Pozostałe","116190","16","0","1"),
("116574","Bielany","116192","0","0","1"),
("116575","Bielawy","116192","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116576","Bydgoskie Przedmieście","116192","2","0","1"),
("116577","Chełmińskie Przedmieście","116192","3","0","1"),
("116578","Jakubskie Przedmieście","116192","4","0","1"),
("116579","Koniuchy","116192","5","0","1"),
("116580","Mokre","116192","6","0","1"),
("116581","Na Skarpie","116192","7","0","1"),
("116582","Podgórz","116192","8","0","1"),
("116583","Rubinkowo","116192","9","0","1"),
("116584","Rudak","116192","10","0","1"),
("116585","Rybaki","116192","11","0","1"),
("116586","Stare Miasto","116192","12","0","1"),
("116587","Stawki","116192","13","0","1"),
("116588","Wrzosy","116192","14","0","1"),
("116589","Pozostałe","116192","15","0","1"),
("116590","Bazylianówka","116215","0","0","1"),
("116591","Bronowice","116215","1","0","1"),
("116592","Czechów Górny","116215","2","0","1"),
("116593","Czuby","116215","3","0","1"),
("116594","Dziesiąta","116215","4","0","1"),
("116595","Felin","116215","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116596","Kalinowszczyzna","116215","6","0","1"),
("116597","Kośminek","116215","7","0","1"),
("116598","Rudnik ","116215","8","0","1"),
("116599","Sławinek","116215","9","0","1"),
("116600","Śródmieście","116215","10","0","1"),
("116601","Tatary","116215","11","0","1"),
("116602","Węglin","116215","12","0","1"),
("116603","Wieniawka","116215","13","0","1"),
("116604","Wrotków","116215","14","0","1"),
("116605","Pozostałe","116215","15","0","1"),
("116606","Bałuty","116251","0","0","1"),
("116607","Górna","116251","1","0","1"),
("116608","Polesie","116251","2","0","1"),
("116609","Śródmieście","116251","3","0","1"),
("116610","Widzew","116251","4","0","1"),
("116611","Pozostałe","116251","5","0","1"),
("116612","Krowodrza","116275","0","0","1"),
("116613","Nowa Huta","116275","1","0","1"),
("116614","Podgórze","116275","2","0","1"),
("116615","Śródmieście","116275","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116616","Pozostałe","116275","4","0","1"),
("116617","Bemowo","116301","0","0","1"),
("116618","Białołęka","116301","1","0","1"),
("116619","Bielany","116301","2","0","1"),
("116620","Mokotów","116301","3","0","1"),
("116621","Ochota","116301","4","0","1"),
("116622","Praga Południe","116301","5","0","1"),
("116623","Praga Północ","116301","6","0","1"),
("116624","Rembertów","116301","7","0","1"),
("116625","Śródmieście","116301","8","0","1"),
("116626","Targówek","116301","9","0","1"),
("116627","Ursus","116301","10","0","1"),
("116628","Ursynów","116301","11","0","1"),
("116629","Wawer","116301","12","0","1"),
("116630","Wesoła","116301","13","0","1"),
("116631","Wilanów","116301","14","0","1"),
("116632","Włochy","116301","15","0","1"),
("116633","Wola","116301","16","0","1"),
("116634","Żoliborz","116301","17","0","1"),
("116635","Inne","116301","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116636","Góra Kalwaria","116319","0","0","1"),
("116637","Konstancin-Jeziorna","116319","1","0","1"),
("116638","Piaseczno","116319","2","0","1"),
("116639","Tarczyn","116319","3","0","1"),
("116640","Pozostałe","116319","4","0","1"),
("116641","Brwinów","116322","0","0","1"),
("116642","Piastów","116322","1","0","1"),
("116643","Pruszków","116322","2","0","1"),
("116644","Pozostałe","116322","3","0","1"),
("116645","Kobyłka","116334","0","0","1"),
("116646","Marki","116334","1","0","1"),
("116647","Radzymin","116334","2","0","1"),
("116648","Tłuszcz","116334","3","0","1"),
("116649","Wołomin","116334","4","0","1"),
("116650","Ząbki","116334","5","0","1"),
("116651","Zielonka","116334","6","0","1"),
("116652","Pozostałe","116334","7","0","1"),
("116653","Bierkowice","116339","0","0","1"),
("116654","Gosławice","116339","1","0","1"),
("116655","Groszowice","116339","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116656","Grudzice","116339","3","0","1"),
("116657","Kolonia Gosławicka","116339","4","0","1"),
("116658","Malina","116339","5","0","1"),
("116659","Nowa Wieś Królewska","116339","6","0","1"),
("116660","Półwieś","116339","7","0","1"),
("116661","Szczepanowice","116339","8","0","1"),
("116662","Wójtowa Wieś","116339","9","0","1"),
("116663","Wróblin","116339","10","0","1"),
("116664","Zakrzów","116339","11","0","1"),
("116665","Zaodrze","116339","12","0","1"),
("116666","Pozostałe","116339","13","0","1"),
("116667","Drabinianka","116353","0","0","1"),
("116668","Dworzysko","116353","1","0","1"),
("116669","Miłocin","116353","2","0","1"),
("116670","Pobitno","116353","3","0","1"),
("116671","Przybyszówka","116353","4","0","1"),
("116672","Słocina","116353","5","0","1"),
("116673","Staromieście","116353","6","0","1"),
("116674","Staroniwa","116353","7","0","1"),
("116675","Szajerówka","116353","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116676","Wilkowyja","116353","9","0","1"),
("116677","Zalesie","116353","10","0","1"),
("116678","Załęże","116353","11","0","1"),
("116679","Zwięczyca","116353","12","0","1"),
("116680","Pozostałe","116353","13","0","1"),
("116681","Antoniuk","116376","0","0","1"),
("116682","Bacieczki","116376","1","0","1"),
("116683","Białostoczek","116376","2","0","1"),
("116684","Bojary","116376","3","0","1"),
("116685","Dojlidy","116376","4","0","1"),
("116686","Dojlidy Górne","116376","5","0","1"),
("116687","Dziesięciny","116376","6","0","1"),
("116688","Nowe Miasto","116376","7","0","1"),
("116689","Skorupy","116376","8","0","1"),
("116690","Słoboda","116376","9","0","1"),
("116691","Starosielce","116376","10","0","1"),
("116692","Wygoda","116376","11","0","1"),
("116693","Wysoki Stoczek","116376","12","0","1"),
("116694","Zagórki","116376","13","0","1"),
("116695","Zawady","116376","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116696","Pozostałe","116376","15","0","1"),
("116697","Brzeźno","116393","0","0","1"),
("116698","Chełm","116393","1","0","1"),
("116699","Jasień","116393","2","0","1"),
("116700","Kiełpino Górne","116393","3","0","1"),
("116701","Kokoszki","116393","4","0","1"),
("116702","Lipce","116393","5","0","1"),
("116703","Łostowice","116393","6","0","1"),
("116704","Oliwa","116393","7","0","1"),
("116705","Osowa","116393","8","0","1"),
("116706","Przymorze","116393","9","0","1"),
("116707","Siedlce","116393","10","0","1"),
("116708","Sobieszewo","116393","11","0","1"),
("116709","Suchanino","116393","12","0","1"),
("116710","Wrzeszcz","116393","13","0","1"),
("116711","Zakoniczyn","116393","14","0","1"),
("116712","Pozostałe","116393","15","0","1"),
("116713","Chwarzno","116394","0","0","1"),
("116714","Chylonia","116394","1","0","1"),
("116715","Cisowa","116394","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116716","Działki Leśne","116394","3","0","1"),
("116717","Kamienna Góra","116394","4","0","1"),
("116718","Leszczynki","116394","5","0","1"),
("116719","Mały Kack","116394","6","0","1"),
("116720","Obłuże","116394","7","0","1"),
("116721","Oksywie","116394","8","0","1"),
("116722","Orłowo","116394","9","0","1"),
("116723","Pogórze","116394","10","0","1"),
("116724","Redłowo","116394","11","0","1"),
("116725","Wiczlino","116394","12","0","1"),
("116726","Wielki Kack","116394","13","0","1"),
("116727","Wzgórze Nowotki","116394","14","0","1"),
("116728","Pozostałe","116394","15","0","1"),
("116729","Brodwino","116396","0","0","1"),
("116730","Kamienny Potok","116396","1","0","1"),
("116731","Przylesie","116396","2","0","1"),
("116732","Sopot Dolny","116396","3","0","1"),
("116733","Sopot Górny","116396","4","0","1"),
("116734","Wyścigi","116396","5","0","1"),
("116735","Pozostałe","116396","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116736","Reda","116412","0","0","1"),
("116737","Rumia","116412","1","0","1"),
("116738","Wejherowo","116412","2","0","1"),
("116739","Pozostałe","116412","3","0","1"),
("116740","Aleksandrowice","116413","0","0","1"),
("116741","Hałcnów","116413","1","0","1"),
("116742","Kamienica","116413","2","0","1"),
("116743","Komorowice Krakowskie","116413","3","0","1"),
("116744","Komorowice Śląskie","116413","4","0","1"),
("116745","Leszczyny","116413","5","0","1"),
("116746","Lipnik","116413","6","0","1"),
("116747","Mikuszowice Krakowskie","116413","7","0","1"),
("116748","Mikuszowice Śląskie","116413","8","0","1"),
("116749","Olszówka Dolna","116413","9","0","1"),
("116750","Olszówka Górna","116413","10","0","1"),
("116751","Stare Bielsko","116413","11","0","1"),
("116752","Straconka","116413","12","0","1"),
("116753","Wapienica","116413","13","0","1"),
("116754","Złote Łany","116413","14","0","1"),
("116755","Pozostałe","116413","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116756","Bobrek","116414","0","0","1"),
("116757","Górniki","116414","1","0","1"),
("116758","Karb","116414","2","0","1"),
("116759","Łagiewniki","116414","3","0","1"),
("116760","Miechowice","116414","4","0","1"),
("116761","Rozbark","116414","5","0","1"),
("116762","Stolarzowice","116414","6","0","1"),
("116763","Stroszek","116414","7","0","1"),
("116764","Sucha Góra","116414","8","0","1"),
("116765","Szombierki","116414","9","0","1"),
("116766","Pozostałe","116414","10","0","1"),
("116767","Błeszno","116416","0","0","1"),
("116768","Dźbów","116416","1","0","1"),
("116769","Grabówka","116416","2","0","1"),
("116770","Kawodrza Dolna","116416","3","0","1"),
("116771","Lisiniec","116416","4","0","1"),
("116772","Liszka Dolna","116416","5","0","1"),
("116773","Mirów","116416","6","0","1"),
("116774","Ostatni Grosz","116416","7","0","1"),
("116775","Parkitka","116416","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116776","Raków","116416","9","0","1"),
("116777","Rząsawy","116416","10","0","1"),
("116778","Sabinów","116416","11","0","1"),
("116779","Stradom","116416","12","0","1"),
("116780","Wrzosowiak","116416","13","0","1"),
("116781","Zawodzie","116416","14","0","1"),
("116782","Pozostałe","116416","15","0","1"),
("116783","Bojków","116418","0","0","1"),
("116784","Brzezinka","116418","1","0","1"),
("116785","Czechowice","116418","2","0","1"),
("116786","Ligota Zabrska","116418","3","0","1"),
("116787","Łabędy","116418","4","0","1"),
("116788","Ostropa","116418","5","0","1"),
("116789","Sośnica","116418","6","0","1"),
("116790","Stare Gliwice","116418","7","0","1"),
("116791","Szobiszowice","116418","8","0","1"),
("116792","Trynek","116418","9","0","1"),
("116793","Wilcze Gardło","116418","10","0","1"),
("116794","Wójtowa Wieś","116418","11","0","1"),
("116795","Żerniki","116418","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116796","Pozostałe","116418","13","0","1"),
("116797","Bogucice","116421","0","0","1"),
("116798","Brynów","116421","1","0","1"),
("116799","Dąb","116421","2","0","1"),
("116800","Giszowiec","116421","3","0","1"),
("116801","Józefowiec","116421","4","0","1"),
("116802","Kostuchna","116421","5","0","1"),
("116803","Koszutka","116421","6","0","1"),
("116804","Ligota","116421","7","0","1"),
("116805","Ochojec","116421","8","0","1"),
("116806","Panewniki","116421","9","0","1"),
("116807","Piotrowice","116421","10","0","1"),
("116808","Podlesie","116421","11","0","1"),
("116809","Wełnowiec","116421","12","0","1"),
("116810","Zarzecze","116421","13","0","1"),
("116811","Zawodzie","116421","14","0","1"),
("116812","Pozostałe","116421","15","0","1"),
("116813","Cieśle","116427","0","0","1"),
("116814","Dańdówka","116427","1","0","1"),
("116815","Dębowa Góra","116427","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116816","Józefów","116427","3","0","1"),
("116817","Kazimierz","116427","4","0","1"),
("116818","Klimontów","116427","5","0","1"),
("116819","Maczki","116427","6","0","1"),
("116820","Milowice","116427","7","0","1"),
("116821","Niwka","116427","8","0","1"),
("116822","Ostrowy Górnicze","116427","9","0","1"),
("116823","Pogoń","116427","10","0","1"),
("116824","Sielec","116427","11","0","1"),
("116825","Stary Sosnowiec","116427","12","0","1"),
("116826","Środula","116427","13","0","1"),
("116827","Zagórze","116427","14","0","1"),
("116828","Pozostałe","116427","15","0","1"),
("116829","Cielmice","116429","0","0","1"),
("116830","Czułów","116429","1","0","1"),
("116831","Glinka","116429","2","0","1"),
("116832","Jaroszowice","116429","3","0","1"),
("116833","Mąkołowiec","116429","4","0","1"),
("116834","Paprocany","116429","5","0","1"),
("116835","Suble","116429","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116836","Urbanowice","116429","7","0","1"),
("116837","Wartogłowiec","116429","8","0","1"),
("116838","Wilkowyje","116429","9","0","1"),
("116839","Zwierzyniec","116429","10","0","1"),
("116840","Żwaków","116429","11","0","1"),
("116841","Pozostałe","116429","12","0","1"),
("116842","Grunwald","116487","0","0","1"),
("116843","Jeżyce","116487","1","0","1"),
("116844","Nowe Miasto","116487","2","0","1"),
("116845","Stare Miasto","116487","3","0","1"),
("116846","Wilda","116487","4","0","1"),
("116847","Pozostałe","116487","5","0","1"),
("116848","Chełmoniewo","116519","0","0","1"),
("116849","Dzierżęcino","116519","1","0","1"),
("116850","Lubiatowo","116519","2","0","1"),
("116851","Raduszka","116519","3","0","1"),
("116852","Rokosowo","116519","4","0","1"),
("116853","Pozostałe","116519","5","0","1"),
("116854","Bezrzecze","116520","0","0","1"),
("116855","Bukowe-Klęskowo","116520","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116856","Bukowo","116520","2","0","1"),
("116857","Centrum","116520","3","0","1"),
("116858","Dąbie","116520","4","0","1"),
("116859","Drzetowo","116520","5","0","1"),
("116860","Głębokie","116520","6","0","1"),
("116861","Grabowo","116520","7","0","1"),
("116862","Gumieńce","116520","8","0","1"),
("116863","Kijewo","116520","9","0","1"),
("116864","Niebuszewo","116520","10","0","1"),
("116865","Osów","116520","11","0","1"),
("116866","Pilchowo","116520","12","0","1"),
("116867","Płonia","116520","13","0","1"),
("116868","Podjuchy","116520","14","0","1"),
("116869","Pogodno","116520","15","0","1"),
("116870","Pomorzany","116520","16","0","1"),
("116871","Skolwin","116520","17","0","1"),
("116872","Stare Miasto","116520","18","0","1"),
("116873","Stołczyn","116520","19","0","1"),
("116874","Świerczewo","116520","20","0","1"),
("116875","Warszewo","116520","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116876","Wielgowo","116520","22","0","1"),
("116877","Zdroje","116520","23","0","1"),
("116878","Żelechowa","116520","24","0","1"),
("116879","Pozostałe","116520","25","0","1"),
("116880","Dolnośląskie","112745","0","0","0"),
("116881","Kujawsko-pomorskie","112745","1","0","0"),
("116882","Lubelskie","112745","2","0","0"),
("116883","Lubuskie","112745","3","0","0"),
("116884","Łódzkie","112745","4","0","0"),
("116885","Małopolskie","112745","5","0","0"),
("116886","Mazowieckie","112745","6","0","0"),
("116887","Opolskie","112745","7","0","0"),
("116888","Podkarpackie","112745","8","0","0"),
("116889","Podlaskie","112745","9","0","0"),
("116890","Pomorskie","112745","10","0","0"),
("116891","Śląskie","112745","11","0","0"),
("116892","Świętokrzyskie","112745","12","0","0"),
("116893","Warmińsko-mazurskie","112745","13","0","0"),
("116894","Wielkopolskie","112745","14","0","0"),
("116895","Zachodniopomorskie","112745","15","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116896","Jelenia Góra","116880","0","0","0"),
("116897","Legnica","116880","1","0","1"),
("116898","Wałbrzych","116880","2","0","1"),
("116899","Wrocław","116880","3","0","0"),
("116900","Pow. bolesławiecki","116880","4","0","1"),
("116901","Pow. dzierżoniowski","116880","5","0","1"),
("116902","Pow. głogowski","116880","6","0","1"),
("116903","Pow. górowski","116880","7","0","1"),
("116904","Pow. jaworski","116880","8","0","1"),
("116905","Pow. jeleniogórski","116880","9","0","1"),
("116906","Pow. kamiennogórski","116880","10","0","1"),
("116907","Pow. kłodzki","116880","11","0","1"),
("116908","Pow. legnicki","116880","12","0","1"),
("116909","Pow. lubański","116880","13","0","1"),
("116910","Pow. lubiński","116880","14","0","1"),
("116911","Pow. lwówecki","116880","15","0","1"),
("116912","Pow. milicki","116880","16","0","1"),
("116913","Pow. oleśnicki","116880","17","0","1"),
("116914","Pow. oławski","116880","18","0","1"),
("116915","Pow. polkowicki","116880","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116916","Pow. strzeliński","116880","20","0","1"),
("116917","Pow. średzki","116880","21","0","1"),
("116918","Pow. świdnicki","116880","22","0","1"),
("116919","Pow. trzebnicki","116880","23","0","1"),
("116920","Pow. wałbrzyski","116880","24","0","1"),
("116921","Pow. wołowski","116880","25","0","1"),
("116922","Pow. wrocławski","116880","26","0","1"),
("116923","Pow. ząbkowicki","116880","27","0","1"),
("116924","Pow. zgorzelecki","116880","28","0","1"),
("116925","Pow. złotoryjski","116880","29","0","1"),
("116926","Bydgoszcz","116881","0","0","0"),
("116927","Grudziądz","116881","1","0","1"),
("116928","Toruń","116881","2","0","0"),
("116929","Włocławek","116881","3","0","1"),
("116930","Pow. aleksandrowski","116881","4","0","1"),
("116931","Pow. brodnicki","116881","5","0","1"),
("116932","Pow. bydgoski","116881","6","0","1"),
("116933","Pow. chełmiński","116881","7","0","1"),
("116934","Pow. golubsko-dobrzyński","116881","8","0","1"),
("116935","Pow. grudziądzki","116881","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116936","Pow. inowrocławski","116881","10","0","1"),
("116937","Pow. lipnowski","116881","11","0","1"),
("116938","Pow. mogileński","116881","12","0","1"),
("116939","Pow. nakielski","116881","13","0","1"),
("116940","Pow. radziejowski","116881","14","0","1"),
("116941","Pow. rypiński","116881","15","0","1"),
("116942","Pow. sępoleński","116881","16","0","1"),
("116943","Pow. świecki","116881","17","0","1"),
("116944","Pow. toruński","116881","18","0","1"),
("116945","Pow. tucholski","116881","19","0","1"),
("116946","Pow. wąbrzeski","116881","20","0","1"),
("116947","Pow. włocławski","116881","21","0","1"),
("116948","Pow. żniński","116881","22","0","1"),
("116949","Biała Podlaska","116882","0","0","1"),
("116950","Chełm","116882","1","0","1"),
("116951","Lublin","116882","2","0","0"),
("116952","Zamość","116882","3","0","1"),
("116953","Pow. bialski","116882","4","0","1"),
("116954","Pow. biłgorajski","116882","5","0","1"),
("116955","Pow. chełmski","116882","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116956","Pow. hrubieszowski","116882","7","0","1"),
("116957","Pow. janowski","116882","8","0","1"),
("116958","Pow. krasnostawski","116882","9","0","1"),
("116959","Pow. kraśnicki","116882","10","0","1"),
("116960","Pow. lubartowski","116882","11","0","1"),
("116961","Pow. lubelski","116882","12","0","1"),
("116962","Pow. łęczyński","116882","13","0","1"),
("116963","Pow. łukowski","116882","14","0","1"),
("116964","Pow. opolski","116882","15","0","1"),
("116965","Pow. parczewski","116882","16","0","1"),
("116966","Pow. puławski","116882","17","0","1"),
("116967","Pow. radzyński","116882","18","0","1"),
("116968","Pow. rycki","116882","19","0","1"),
("116969","Pow. świdnicki","116882","20","0","1"),
("116970","Pow. tomaszowski","116882","21","0","1"),
("116971","Pow. włodawski","116882","22","0","1"),
("116972","Pow. zamojski","116882","23","0","1"),
("116973","Gorzów Wielkopolski","116883","0","0","1"),
("116974","Zielona Góra","116883","1","0","1"),
("116975","Pow. gorzowski","116883","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116976","Pow. krośnieński","116883","3","0","1"),
("116977","Pow. międzyrzecki","116883","4","0","1"),
("116978","Pow. nowosolski","116883","5","0","1"),
("116979","Pow. słubicki","116883","6","0","1"),
("116980","Pow. strzelecko-drezdenecki","116883","7","0","1"),
("116981","Pow. sulęciński","116883","8","0","1"),
("116982","Pow. świebodziński","116883","9","0","1"),
("116983","Pow. wschowski","116883","10","0","1"),
("116984","Pow. zielonogórski","116883","11","0","1"),
("116985","Pow. żagański","116883","12","0","1"),
("116986","Pow. żarski","116883","13","0","1"),
("116987","Łódź","116884","0","0","0"),
("116988","Piotrków Trybunalski","116884","1","0","1"),
("116989","Skierniewice","116884","2","0","1"),
("116990","Pow. bełchatowski","116884","3","0","1"),
("116991","Pow. brzeziński","116884","4","0","1"),
("116992","Pow. kutnowski","116884","5","0","1"),
("116993","Pow. łaski","116884","6","0","1"),
("116994","Pow. łęczycki","116884","7","0","1"),
("116995","Pow. łowicki","116884","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("116996","Pow. łódzki wschodni","116884","9","0","1"),
("116997","Pow. opoczyński","116884","10","0","1"),
("116998","Pow. pabianicki","116884","11","0","1"),
("116999","Pow. pajęczański","116884","12","0","1"),
("117000","Pow. piotrkowski","116884","13","0","1"),
("117001","Pow. poddębicki","116884","14","0","1"),
("117002","Pow. radomszczański","116884","15","0","1"),
("117003","Pow. rawski","116884","16","0","1"),
("117004","Pow. sieradzki","116884","17","0","1"),
("117005","Pow. skierniewicki","116884","18","0","1"),
("117006","Pow. tomaszowski","116884","19","0","1"),
("117007","Pow. wieluński","116884","20","0","1"),
("117008","Pow. wieruszowski","116884","21","0","1"),
("117009","Pow. zduńskowolski","116884","22","0","1"),
("117010","Pow. zgierski","116884","23","0","1"),
("117011","Kraków","116885","0","0","0"),
("117012","Nowy Sącz","116885","1","0","1"),
("117013","Tarnów","116885","2","0","1"),
("117014","Pow. bocheński","116885","3","0","1"),
("117015","Pow. brzeski","116885","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117016","Pow. chrzanowski","116885","5","0","1"),
("117017","Pow. dąbrowski","116885","6","0","1"),
("117018","Pow. gorlicki","116885","7","0","1"),
("117019","Pow. krakowski","116885","8","0","1"),
("117020","Pow. limanowski","116885","9","0","1"),
("117021","Pow. miechowski","116885","10","0","1"),
("117022","Pow. myślenicki","116885","11","0","1"),
("117023","Pow. nowosądecki","116885","12","0","1"),
("117024","Pow. nowotarski","116885","13","0","1"),
("117025","Pow. olkuski","116885","14","0","1"),
("117026","Pow. oświęcimski","116885","15","0","1"),
("117027","Pow. proszowicki","116885","16","0","1"),
("117028","Pow. suski","116885","17","0","1"),
("117029","Pow. tarnowski","116885","18","0","1"),
("117030","Pow. tatrzański","116885","19","0","1"),
("117031","Pow. wadowicki","116885","20","0","1"),
("117032","Pow. wielicki","116885","21","0","1"),
("117033","Ostrołęka","116886","0","0","1"),
("117034","Płock","116886","1","0","1"),
("117035","Radom","116886","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117036","Siedlce","116886","3","0","1"),
("117037","Warszawa","116886","4","0","0"),
("117038","Pow. białobrzeski","116886","5","0","1"),
("117039","Pow. ciechanowski","116886","6","0","1"),
("117040","Pow. garwoliński","116886","7","0","1"),
("117041","Pow. gostyniński","116886","8","0","1"),
("117042","Pow. grodziski","116886","9","0","1"),
("117043","Pow. grójecki","116886","10","0","1"),
("117044","Pow. kozienicki","116886","11","0","1"),
("117045","Pow. legionowski","116886","12","0","1"),
("117046","Pow. lipski","116886","13","0","1"),
("117047","Pow. łosicki","116886","14","0","1"),
("117048","Pow. makowski","116886","15","0","1"),
("117049","Pow. miński","116886","16","0","1"),
("117050","Pow. mławski","116886","17","0","1"),
("117051","Pow. nowodworski","116886","18","0","1"),
("117052","Pow. ostrołęcki","116886","19","0","1"),
("117053","Pow. ostrowski","116886","20","0","1"),
("117054","Pow. otwocki","116886","21","0","1"),
("117055","Pow. piaseczyński","116886","22","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117056","Pow. płocki","116886","23","0","1"),
("117057","Pow. płoński","116886","24","0","1"),
("117058","Pow. pruszkowski","116886","25","0","0"),
("117059","Pow. przasnyski","116886","26","0","1"),
("117060","Pow. przysuski","116886","27","0","1"),
("117061","Pow. pułtuski","116886","28","0","1"),
("117062","Pow. radomski","116886","29","0","1"),
("117063","Pow. siedlecki","116886","30","0","1"),
("117064","Pow. sierpecki","116886","31","0","1"),
("117065","Pow. sochaczewski","116886","32","0","1"),
("117066","Pow. sokołowski","116886","33","0","1"),
("117067","Pow. szydłowiecki","116886","34","0","1"),
("117068","Pow. warszawski zachodni","116886","35","0","1"),
("117069","Pow. węgrowski","116886","36","0","1"),
("117070","Pow. wołomiński","116886","37","0","0"),
("117071","Pow. wyszkowski","116886","38","0","1"),
("117072","Pow. zwoleński","116886","39","0","1"),
("117073","Pow. żuromiński","116886","40","0","1"),
("117074","Pow. żyrardowski","116886","41","0","1"),
("117075","Opole","116887","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117076","Pow. brzeski","116887","1","0","1"),
("117077","Pow. głubczycki","116887","2","0","1"),
("117078","Pow. kędzierzyńsko-kozielski","116887","3","0","1"),
("117079","Pow. kluczborski","116887","4","0","1"),
("117080","Pow. krapkowicki","116887","5","0","1"),
("117081","Pow. namysłowski","116887","6","0","1"),
("117082","Pow. nyski","116887","7","0","1"),
("117083","Pow. oleski","116887","8","0","1"),
("117084","Pow. opolski","116887","9","0","1"),
("117085","Pow. prudnicki","116887","10","0","1"),
("117086","Pow. strzelecki","116887","11","0","1"),
("117087","Krosno","116888","0","0","1"),
("117088","Przemyśl","116888","1","0","1"),
("117089","Rzeszów","116888","2","0","0"),
("117090","Tarnobrzeg","116888","3","0","1"),
("117091","Pow. bieszczadzki","116888","4","0","1"),
("117092","Pow. brzozowski","116888","5","0","1"),
("117093","Pow. dębicki","116888","6","0","1"),
("117094","Pow. jarosławski","116888","7","0","1"),
("117095","Pow. jasielski","116888","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117096","Pow. kolbuszowski","116888","9","0","1"),
("117097","Pow. krośnieński","116888","10","0","1"),
("117098","Pow. leski","116888","11","0","1"),
("117099","Pow. leżajski","116888","12","0","1"),
("117100","Pow. lubaczowski","116888","13","0","1"),
("117101","Pow. łańcucki","116888","14","0","1"),
("117102","Pow. mielecki","116888","15","0","1"),
("117103","Pow. niżański","116888","16","0","1"),
("117104","Pow. przemyski","116888","17","0","1"),
("117105","Pow. przeworski","116888","18","0","1"),
("117106","Pow. ropczycko-sędziszowski","116888","19","0","1"),
("117107","Pow. rzeszowski","116888","20","0","1"),
("117108","Pow. sanocki","116888","21","0","1"),
("117109","Pow. stalowowolski","116888","22","0","1"),
("117110","Pow. strzyżowski","116888","23","0","1"),
("117111","Pow. tarnobrzeski","116888","24","0","1"),
("117112","Białystok","116889","0","0","0"),
("117113","Łomża","116889","1","0","1"),
("117114","Suwałki","116889","2","0","1"),
("117115","Pow. augustowski","116889","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117116","Pow. białostocki","116889","4","0","1"),
("117117","Pow. bielski","116889","5","0","1"),
("117118","Pow. grajewski","116889","6","0","1"),
("117119","Pow. hajnowski","116889","7","0","1"),
("117120","Pow. kolneński","116889","8","0","1"),
("117121","Pow. łomżyński","116889","9","0","1"),
("117122","Pow. moniecki","116889","10","0","1"),
("117123","Pow. sejneński","116889","11","0","1"),
("117124","Pow. siemiatycki","116889","12","0","1"),
("117125","Pow. sokólski","116889","13","0","1"),
("117126","Pow. suwalski","116889","14","0","1"),
("117127","Pow. wysokomazowiecki","116889","15","0","1"),
("117128","Pow. zambrowski","116889","16","0","1"),
("117129","Gdańsk","116890","0","0","0"),
("117130","Gdynia","116890","1","0","0"),
("117131","Słupsk","116890","2","0","1"),
("117132","Sopot","116890","3","0","0"),
("117133","Pow. bytowski","116890","4","0","1"),
("117134","Pow. chojnicki","116890","5","0","1"),
("117135","Pow. człuchowski","116890","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117136","Pow. gdański","116890","7","0","1"),
("117137","Pow. kartuski","116890","8","0","1"),
("117138","Pow. kościerski","116890","9","0","1"),
("117139","Pow. kwidzyński","116890","10","0","1"),
("117140","Pow. lęborski","116890","11","0","1"),
("117141","Pow. malborski","116890","12","0","1"),
("117142","Pow. nowodworski","116890","13","0","1"),
("117143","Pow. pucki","116890","14","0","1"),
("117144","Pow. słupski","116890","15","0","1"),
("117145","Pow. starogardzki","116890","16","0","1"),
("117146","Pow. sztumski","116890","17","0","1"),
("117147","Pow. tczewski","116890","18","0","1"),
("117148","Pow. wejherowski","116890","19","0","0"),
("117149","Bielsko-Biała","116891","0","0","0"),
("117150","Bytom","116891","1","0","0"),
("117151","Chorzów","116891","2","0","1"),
("117152","Częstochowa","116891","3","0","0"),
("117153","Dąbrowa Górnicza","116891","4","0","1"),
("117154","Gliwice","116891","5","0","0"),
("117155","Jastrzębie-Zdrój","116891","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117156","Jaworzno","116891","7","0","1"),
("117157","Katowice","116891","8","0","0"),
("117158","Mysłowice","116891","9","0","1"),
("117159","Piekary Śląskie","116891","10","0","1"),
("117160","Ruda Śląska","116891","11","0","1"),
("117161","Rybnik","116891","12","0","1"),
("117162","Siemianowice Śląskie","116891","13","0","1"),
("117163","Sosnowiec","116891","14","0","0"),
("117164","Świętochłowice","116891","15","0","1"),
("117165","Tychy","116891","16","0","0"),
("117166","Zabrze","116891","17","0","1"),
("117167","Żory","116891","18","0","1"),
("117168","Pow. będziński","116891","19","0","1"),
("117169","Pow. bielski","116891","20","0","1"),
("117170","Pow. bieruńsko-lędziński","116891","21","0","1"),
("117171","Pow. cieszyński","116891","22","0","1"),
("117172","Pow. częstochowski","116891","23","0","1"),
("117173","Pow. gliwicki","116891","24","0","1"),
("117174","Pow. kłobucki","116891","25","0","1"),
("117175","Pow. lubliniecki","116891","26","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117176","Pow. mikołowski","116891","27","0","1"),
("117177","Pow. myszkowski","116891","28","0","1"),
("117178","Pow. pszczyński","116891","29","0","1"),
("117179","Pow. raciborski","116891","30","0","1"),
("117180","Pow. rybnicki","116891","31","0","1"),
("117181","Pow. tarnogórski","116891","32","0","1"),
("117182","Pow. wodzisławski","116891","33","0","1"),
("117183","Pow. zawierciański","116891","34","0","1"),
("117184","Pow. żywiecki","116891","35","0","1"),
("117185","Kielce","116892","0","0","1"),
("117186","Pow. buski","116892","1","0","1"),
("117187","Pow. jędrzejowski","116892","2","0","1"),
("117188","Pow. kazimierski","116892","3","0","1"),
("117189","Pow. kielecki","116892","4","0","1"),
("117190","Pow. konecki","116892","5","0","1"),
("117191","Pow. opatowski","116892","6","0","1"),
("117192","Pow. ostrowiecki","116892","7","0","1"),
("117193","Pow. pińczowski","116892","8","0","1"),
("117194","Pow. sandomierski","116892","9","0","1"),
("117195","Pow. skarżyski","116892","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117196","Pow. starachowicki","116892","11","0","1"),
("117197","Pow. staszowski","116892","12","0","1"),
("117198","Pow. włoszczowski","116892","13","0","1"),
("117199","Elbląg","116893","0","0","1"),
("117200","Olsztyn","116893","1","0","1"),
("117201","Pow. bartoszycki","116893","2","0","1"),
("117202","Pow. braniewski","116893","3","0","1"),
("117203","Pow. działdowski","116893","4","0","1"),
("117204","Pow. elbląski","116893","5","0","1"),
("117205","Pow. ełcki","116893","6","0","1"),
("117206","Pow. giżycki","116893","7","0","1"),
("117207","Pow. gołdapski","116893","8","0","1"),
("117208","Pow. iławski","116893","9","0","1"),
("117209","Pow. kętrzyński","116893","10","0","1"),
("117210","Pow. lidzbarski","116893","11","0","1"),
("117211","Pow. mrągowski","116893","12","0","1"),
("117212","Pow. nidzicki","116893","13","0","1"),
("117213","Pow. nowomiejski","116893","14","0","1"),
("117214","Pow. olecki","116893","15","0","1"),
("117215","Pow. olsztyński","116893","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117216","Pow. ostródzki","116893","17","0","1"),
("117217","Pow. piski","116893","18","0","1"),
("117218","Pow. szczycieński","116893","19","0","1"),
("117219","Pow. węgorzewski","116893","20","0","1"),
("117220","Kalisz","116894","0","0","1"),
("117221","Konin","116894","1","0","1"),
("117222","Leszno","116894","2","0","1"),
("117223","Poznań","116894","3","0","0"),
("117224","Pow. chodzieski","116894","4","0","1"),
("117225","Pow. czarnkowsko-trzcianecki","116894","5","0","1"),
("117226","Pow. gnieźnieński","116894","6","0","1"),
("117227","Pow. gostyński","116894","7","0","1"),
("117228","Pow. grodziski","116894","8","0","1"),
("117229","Pow. jarociński","116894","9","0","1"),
("117230","Pow. kaliski","116894","10","0","1"),
("117231","Pow. kępiński","116894","11","0","1"),
("117232","Pow. kolski","116894","12","0","1"),
("117233","Pow. koniński","116894","13","0","1"),
("117234","Pow. kościański","116894","14","0","1"),
("117235","Pow. krotoszyński","116894","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117236","Pow. leszczyński","116894","16","0","1"),
("117237","Pow. międzychodzki","116894","17","0","1"),
("117238","Pow. nowotomyski","116894","18","0","1"),
("117239","Pow. obornicki","116894","19","0","1"),
("117240","Pow. ostrowski","116894","20","0","1"),
("117241","Pow. ostrzeszowski","116894","21","0","1"),
("117242","Pow. pilski","116894","22","0","1"),
("117243","Pow. pleszewski","116894","23","0","1"),
("117244","Pow. poznański","116894","24","0","1"),
("117245","Pow. rawicki","116894","25","0","1"),
("117246","Pow. słupecki","116894","26","0","1"),
("117247","Pow. szamotulski","116894","27","0","1"),
("117248","Pow. średzki","116894","28","0","1"),
("117249","Pow. śremski","116894","29","0","1"),
("117250","Pow. turecki","116894","30","0","1"),
("117251","Pow. wągrowiecki","116894","31","0","1"),
("117252","Pow. wolsztyński","116894","32","0","1"),
("117253","Pow. wrzesiński","116894","33","0","1"),
("117254","Pow. złotowski","116894","34","0","1"),
("117255","Koszalin","116895","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117256","Szczecin","116895","1","0","0"),
("117257","Świnoujście","116895","2","0","1"),
("117258","Pow. białogardzki","116895","3","0","1"),
("117259","Pow. choszczeński","116895","4","0","1"),
("117260","Pow. drawski","116895","5","0","1"),
("117261","Pow. goleniowski","116895","6","0","1"),
("117262","Pow. gryficki","116895","7","0","1"),
("117263","Pow. gryfiński","116895","8","0","1"),
("117264","Pow. kamieński","116895","9","0","1"),
("117265","Pow. kołobrzeski","116895","10","0","1"),
("117266","Pow. koszaliński","116895","11","0","1"),
("117267","Pow. łobeski","116895","12","0","1"),
("117268","Pow. myśliborski","116895","13","0","1"),
("117269","Pow. policki","116895","14","0","1"),
("117270","Pow. pyrzycki","116895","15","0","1"),
("117271","Pow. sławieński","116895","16","0","1"),
("117272","Pow. stargardzki","116895","17","0","1"),
("117273","Pow. szczecinecki","116895","18","0","1"),
("117274","Pow. świdwiński","116895","19","0","1"),
("117275","Pow. wałecki","116895","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117276","Cieplice Śląskie-Zdrój","116896","0","0","1"),
("117277","Czarne","116896","1","0","1"),
("117278","Dąbrówka","116896","2","0","1"),
("117279","Goduszyn","116896","3","0","1"),
("117280","Grabary","116896","4","0","1"),
("117281","Jagniątków","116896","5","0","1"),
("117282","Maciejowa","116896","6","0","1"),
("117283","Paulinów","116896","7","0","1"),
("117284","Sobieszów","116896","8","0","1"),
("117285","Strupice","116896","9","0","1"),
("117286","Zabobrze","116896","10","0","1"),
("117287","Pozostałe","116896","11","0","1"),
("117288","Fabryczna","116899","0","0","1"),
("117289","Krzyki","116899","1","0","1"),
("117290","Psie Pole","116899","2","0","1"),
("117291","Stare Miasto","116899","3","0","1"),
("117292","Śródmieście","116899","4","0","1"),
("117293","Pozostałe","116899","5","0","1"),
("117294","Bartodzieje Małe","116926","0","0","1"),
("117295","Bartodzieje Wielkie","116926","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117296","Bielawy","116926","2","0","1"),
("117297","Błonie","116926","3","0","1"),
("117298","Bocianowo","116926","4","0","1"),
("117299","Czyżkówko","116926","5","0","1"),
("117300","Fordon","116926","6","0","1"),
("117301","Górzyskowo","116926","7","0","1"),
("117302","Kapuściska","116926","8","0","1"),
("117303","Okole","116926","9","0","1"),
("117304","Osiedle Leśne","116926","10","0","1"),
("117305","Osowa Góra","116926","11","0","1"),
("117306","Skrzetusko","116926","12","0","1"),
("117307","Szwederowo","116926","13","0","1"),
("117308","Wilczak","116926","15","0","1"),
("117309","Pozostałe","116926","16","0","1"),
("117310","Bielany","116928","0","0","1"),
("117311","Bielawy","116928","1","0","1"),
("117312","Bydgoskie Przedmieście","116928","2","0","1"),
("117313","Chełmińskie Przedmieście","116928","3","0","1"),
("117314","Jakubskie Przedmieście","116928","4","0","1"),
("117315","Koniuchy","116928","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117316","Mokre","116928","6","0","1"),
("117317","Na Skarpie","116928","7","0","1"),
("117318","Podgórz","116928","8","0","1"),
("117319","Rubinkowo","116928","9","0","1"),
("117320","Rudak","116928","10","0","1"),
("117321","Rybaki","116928","11","0","1"),
("117322","Stare Miasto","116928","12","0","1"),
("117323","Stawki","116928","13","0","1"),
("117324","Wrzosy","116928","14","0","1"),
("117325","Pozostałe","116928","15","0","1"),
("117326","Bazylianówka","116951","0","0","1"),
("117327","Bronowice","116951","1","0","1"),
("117328","Czechów Górny","116951","2","0","1"),
("117329","Czuby","116951","3","0","1"),
("117330","Dziesiąta","116951","4","0","1"),
("117331","Felin","116951","5","0","1"),
("117332","Kalinowszczyzna","116951","6","0","1"),
("117333","Kośminek","116951","7","0","1"),
("117334","Rudnik","116951","8","0","1"),
("117335","Sławinek","116951","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117336","Śródmieście","116951","10","0","1"),
("117337","Tatary","116951","11","0","1"),
("117338","Węglin","116951","12","0","1"),
("117339","Wieniawka","116951","13","0","1"),
("117340","Wrotków","116951","14","0","1"),
("117341","Pozostałe","116951","15","0","1"),
("117342","Bałuty","116987","0","0","1"),
("117343","Górna","116987","1","0","1"),
("117344","Polesie","116987","2","0","1"),
("117345","Śródmieście","116987","3","0","1"),
("117346","Widzew","116987","4","0","1"),
("117347","Pozostałe","116987","5","0","1"),
("117348","Krowodrza","117011","0","0","1"),
("117349","Nowa Huta","117011","1","0","1"),
("117350","Podgórze","117011","2","0","1"),
("117351","Śródmieście","117011","3","0","1"),
("117352","Pozostałe","117011","4","0","1"),
("117353","Bemowo","117037","0","0","1"),
("117354","Białołęka","117037","1","0","1"),
("117355","Bielany","117037","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117356","Mokotów","117037","3","0","1"),
("117357","Ochota","117037","4","0","1"),
("117358","Praga Południe","117037","5","0","1"),
("117359","Praga Północ","117037","6","0","1"),
("117360","Rembertów","117037","7","0","1"),
("117361","Śródmieście","117037","8","0","1"),
("117362","Targówek","117037","9","0","1"),
("117363","Ursus","117037","10","0","1"),
("117364","Ursynów","117037","11","0","1"),
("117365","Wawer","117037","12","0","1"),
("117366","Wesoła","117037","13","0","1"),
("117367","Wilanów","117037","14","0","1"),
("117368","Włochy","117037","15","0","1"),
("117369","Wola","117037","16","0","1"),
("117370","Żoliborz","117037","17","0","1"),
("117371","Inne","117037","18","0","1"),
("117372","Góra Kalwaria","117055","0","0","1"),
("117373","Konstancin-Jeziorna","117055","1","0","1"),
("117374","Piaseczno","117055","2","0","1"),
("117375","Tarczyn","117055","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117376","Pozostałe","117055","4","0","1"),
("117377","Brwinów","117058","0","0","1"),
("117378","Piastów","117058","1","0","1"),
("117379","Pruszków","117058","2","0","1"),
("117380","Pozostałe","117058","3","0","1"),
("117381","Kobyłka","117070","0","0","1"),
("117382","Marki","117070","1","0","1"),
("117383","Radzymin","117070","2","0","1"),
("117384","Tłuszcz","117070","3","0","1"),
("117385","Wołomin","117070","4","0","1"),
("117386","Ząbki","117070","5","0","1"),
("117387","Zielonka","117070","6","0","1"),
("117388","Pozostałe","117070","7","0","1"),
("117389","Bierkowice","117075","0","0","1"),
("117390","Gosławice","117075","1","0","1"),
("117391","Groszowice","117075","2","0","1"),
("117392","Grudzice","117075","3","0","1"),
("117393","Kolonia Gosławicka","117075","4","0","1"),
("117394","Malina","117075","5","0","1"),
("117395","Nowa Wieś Królewska","117075","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117396","Półwieś","117075","7","0","1"),
("117397","Szczepanowice","117075","8","0","1"),
("117398","Wójtowa Wieś","117075","9","0","1"),
("117399","Pozostałe","117075","10","0","1"),
("117400","Drabinianka","117089","0","0","1"),
("117401","Dworzysko","117089","1","0","1"),
("117402","Miłocin","117089","2","0","1"),
("117403","Pobitno","117089","3","0","1"),
("117404","Przybyszówka","117089","4","0","1"),
("117405","Słocina","117089","5","0","1"),
("117406","Staromieście","117089","6","0","1"),
("117407","Staroniwa","117089","7","0","1"),
("117408","Szajerówka","117089","8","0","1"),
("117409","Wilkowyja","117089","9","0","1"),
("117410","Zalesie","117089","10","0","1"),
("117411","Załęże","117089","11","0","1"),
("117412","Zwięczyca","117089","12","0","1"),
("117413","Pozostałe","117089","13","0","1"),
("117414","Antoniuk","117112","0","0","1"),
("117415","Bacieczki","117112","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117416","Białostoczek","117112","2","0","1"),
("117417","Bojary","117112","3","0","1"),
("117418","Dojlidy","117112","4","0","1"),
("117419","Dojlidy Górne","117112","5","0","1"),
("117420","Dziesięciny","117112","6","0","1"),
("117421","Nowe Miasto","117112","7","0","1"),
("117422","Pozostałe","117112","8","0","1"),
("117423","Skorupy","117112","9","0","1"),
("117424","Słoboda","117112","10","0","1"),
("117425","Starosielce","117112","11","0","1"),
("117426","Wygoda","117112","12","0","1"),
("117427","Wysoki Stoczek","117112","13","0","1"),
("117428","Zagórki","117112","14","0","1"),
("117429","Zawady","117112","15","0","1"),
("117430","Brzeźno","117129","0","0","1"),
("117431","Chełm","117129","1","0","1"),
("117432","Jasień","117129","2","0","1"),
("117433","Kiełpino Górne","117129","3","0","1"),
("117434","Kokoszki","117129","4","0","1"),
("117435","Lipce","117129","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117436","Łostowice","117129","6","0","1"),
("117437","Oliwa","117129","7","0","1"),
("117438","Osowa Góra","117129","8","0","1"),
("117439","Przymorze","117129","9","0","1"),
("117440","Siedlce","117129","10","0","1"),
("117441","Sobieszewo","117129","11","0","1"),
("117442","Suchanino","117129","12","0","1"),
("117443","Wrzeszcz","117129","13","0","1"),
("117444","Zakoniczyn","117129","14","0","1"),
("117445","Pozostałe","117129","15","0","1"),
("117446","Chwarzno","117130","0","0","1"),
("117447","Chylonia","117130","1","0","1"),
("117448","Cisowa","117130","2","0","1"),
("117449","Działki Leśne","117130","3","0","1"),
("117450","Kamienna Góra","117130","4","0","1"),
("117451","Leszczynki","117130","5","0","1"),
("117452","Mały Kack","117130","6","0","1"),
("117453","Obłuże","117130","7","0","1"),
("117454","Oksywie","117130","8","0","1"),
("117455","Orłowo","117130","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117456","Pogórze","117130","10","0","1"),
("117457","Redłowo","117130","11","0","1"),
("117458","Wiczlino","117130","12","0","1"),
("117459","Wielki Kack","117130","13","0","1"),
("117460","Wzgórze Nowotki","117130","14","0","1"),
("117461","Pozostałe","117130","15","0","1"),
("117462","Brodwino","117132","0","0","1"),
("117463","Kamienny Potok","117132","1","0","1"),
("117464","Przylesie","117132","2","0","1"),
("117465","Sopot Dolny","117132","3","0","1"),
("117466","Sopot Górny","117132","4","0","1"),
("117467","Wyścigi","117132","5","0","1"),
("117468","Pozostałe","117132","6","0","1"),
("117469","Reda","117148","0","0","1"),
("117470","Rumia","117148","1","0","1"),
("117471","Wejherowo","117148","2","0","1"),
("117472","Pozostałe","117148","3","0","1"),
("117473","Aleksandrowice","117149","0","0","1"),
("117474","Hałcnów","117149","1","0","1"),
("117475","Kamienica","117149","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117476","Komorowice Krakowskie","117149","3","0","1"),
("117477","Komorowice Śląskie","117149","4","0","1"),
("117478","Leszczyny","117149","5","0","1"),
("117479","Lipnik","117149","6","0","1"),
("117480","Mikuszowice Krakowskie","117149","7","0","1"),
("117481","Mikuszowice Śląskie","117149","8","0","1"),
("117482","Olszówka Dolna","117149","9","0","1"),
("117483","Olszówka Górna","117149","10","0","1"),
("117484","Stare Bielsko","117149","11","0","1"),
("117485","Straconka","117149","12","0","1"),
("117486","Wapienica","117149","13","0","1"),
("117487","Złote Łany","117149","14","0","1"),
("117488","Pozostałe","117149","15","0","1"),
("117489","Bobrek","117150","0","0","1"),
("117490","Górniki","117150","1","0","1"),
("117491","Karb","117150","2","0","1"),
("117492","Łagiewniki","117150","3","0","1"),
("117493","Miechowice","117150","4","0","1"),
("117494","Rozbark","117150","5","0","1"),
("117495","Stolarzowice","117150","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117496","Stroszek","117150","7","0","1"),
("117497","Sucha Góra","117150","8","0","1"),
("117498","Szombierki","117150","9","0","1"),
("117499","Pozostałe","117150","10","0","1"),
("117500","Błeszno","117152","0","0","1"),
("117501","Dźbów","117152","1","0","1"),
("117502","Grabówka","117152","2","0","1"),
("117503","Kawodrza Dolna","117152","3","0","1"),
("117504","Lisiniec","117152","4","0","1"),
("117505","Liszka Dolna","117152","5","0","1"),
("117506","Mirów","117152","6","0","1"),
("117507","Ostatni Grosz","117152","7","0","1"),
("117508","Parkitka","117152","8","0","1"),
("117509","Raków","117152","9","0","1"),
("117510","Rząsawy","117152","10","0","1"),
("117511","Sabinów","117152","11","0","1"),
("117512","Stradom","117152","12","0","1"),
("117513","Wrzosowiak","117152","13","0","1"),
("117514","Zawodzie","117152","14","0","1"),
("117515","Pozostałe","117152","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117516","Bojków","117154","0","0","1"),
("117517","Brzezinka","117154","1","0","1"),
("117518","Czechowice","117154","2","0","1"),
("117519","Ligota Zabrska","117154","3","0","1"),
("117520","Łabędy","117154","4","0","1"),
("117521","Ostropa","117154","5","0","1"),
("117522","Sośnica","117154","6","0","1"),
("117523","Stare Gliwice","117154","7","0","1"),
("117524","Szobiszowice","117154","8","0","1"),
("117525","Trynek","117154","9","0","1"),
("117526","Wilcze Gardło","117154","10","0","1"),
("117527","Wójtowa Wieś","117154","11","0","1"),
("117528","Żerniki","117154","12","0","1"),
("117529","Pozostałe","117154","13","0","1"),
("117530","Bogucice","117157","0","0","1"),
("117531","Brynów","117157","1","0","1"),
("117532","Dąb","117157","2","0","1"),
("117533","Giszowiec","117157","3","0","1"),
("117534","Józefowiec","117157","4","0","1"),
("117535","Kostuchna","117157","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117536","Koszutka","117157","6","0","1"),
("117537","Ligota","117157","7","0","1"),
("117538","Ochojec","117157","8","0","1"),
("117539","Panewniki","117157","9","0","1"),
("117540","Piotrowice","117157","10","0","1"),
("117541","Podlesie","117157","11","0","1"),
("117542","Wełnowiec","117157","12","0","1"),
("117543","Zarzecze","117157","13","0","1"),
("117544","Zawodzie","117157","14","0","1"),
("117545","Pozostałe","117157","15","0","1"),
("117546","Cieśle","117163","0","0","1"),
("117547","Dańdówka","117163","1","0","1"),
("117548","Dębowa Góra","117163","2","0","1"),
("117549","Józefów","117163","3","0","1"),
("117550","Kazimierz","117163","4","0","1"),
("117551","Klimontów","117163","5","0","1"),
("117552","Maczki","117163","6","0","1"),
("117553","Milowice","117163","7","0","1"),
("117554","Niwka","117163","8","0","1"),
("117555","Ostrowy Górnicze","117163","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117556","Pogoń","117163","10","0","1"),
("117557","Sielec","117163","11","0","1"),
("117558","Stary Sosnowiec","117163","12","0","1"),
("117559","Środula","117163","13","0","1"),
("117560","Zagórze","117163","14","0","1"),
("117561","Pozostałe","117163","15","0","1"),
("117562","Cielmice","117165","0","0","1"),
("117563","Czułów","117165","1","0","1"),
("117564","Glinka","117165","2","0","1"),
("117565","Jaroszowice","117165","3","0","1"),
("117566","Mąkołowiec","117165","4","0","1"),
("117567","Paprocany","117165","5","0","1"),
("117568","Suble","117165","6","0","1"),
("117569","Urbanowice","117165","7","0","1"),
("117570","Wartogłowiec","117165","8","0","1"),
("117571","Wilkowyje","117165","9","0","1"),
("117572","Zwierzyniec","117165","10","0","1"),
("117573","Żwaków","117165","11","0","1"),
("117574","Pozostałe","117165","12","0","1"),
("117575","Grunwald","117223","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117576","Jeżyce","117223","1","0","1"),
("117577","Nowe Miasto","117223","2","0","1"),
("117578","Stare Miasto","117223","3","0","1"),
("117579","Wilda","117223","4","0","1"),
("117580","Pozostałe","117223","5","0","1"),
("117581","Chełmoniewo","117255","0","0","1"),
("117582","Dzierżęcino","117255","1","0","1"),
("117583","Lubiatowo","117255","2","0","1"),
("117584","Raduszka","117255","3","0","1"),
("117585","Rokosowo","117255","4","0","1"),
("117586","Pozostałe","117255","5","0","1"),
("117587","Bezrzecze","117256","0","0","1"),
("117588","Bukowe-Klęskowo","117256","1","0","1"),
("117589","Bukowo","117256","2","0","1"),
("117590","Centrum","117256","3","0","1"),
("117591","Dąbie","117256","4","0","1"),
("117592","Drzetowo","117256","5","0","1"),
("117593","Głębokie","117256","6","0","1"),
("117594","Grabowo","117256","7","0","1"),
("117595","Gumieńce","117256","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117596","Kijewo","117256","9","0","1"),
("117597","Niebuszewo","117256","10","0","1"),
("117598","Osów","117256","11","0","1"),
("117599","Pilchowo","117256","12","0","1"),
("117600","Płonia","117256","13","0","1"),
("117601","Podjuchy","117256","14","0","1"),
("117602","Pogodno","117256","15","0","1"),
("117603","Pomorzany","117256","16","0","1"),
("117604","Skolwin","117256","17","0","1"),
("117605","Stare Miasto","117256","18","0","1"),
("117606","Stołczyn","117256","19","0","1"),
("117607","Świerczewo","117256","20","0","1"),
("117608","Warszewo","117256","21","0","1"),
("117609","Wielgowo","117256","22","0","1"),
("117610","Zdroje","117256","23","0","1"),
("117611","Żelechowa","117256","24","0","1"),
("117612","Pozostałe","117256","25","0","1"),
("117613","Dolnośląskie","112746","0","0","0"),
("117614","Kujawsko-pomorskie","112746","1","0","0"),
("117615","Lubelskie","112746","2","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117616","Lubuskie","112746","3","0","0"),
("117617","Łódzkie","112746","4","0","0"),
("117618","Małopolskie","112746","5","0","0"),
("117619","Mazowieckie","112746","6","0","0"),
("117620","Opolskie","112746","7","0","0"),
("117621","Podkarpackie","112746","8","0","0"),
("117622","Podlaskie","112746","9","0","0"),
("117623","Pomorskie","112746","10","0","0"),
("117624","Śląskie","112746","11","0","0"),
("117625","Świętokrzyskie","112746","12","0","0"),
("117626","Warmińsko-mazurskie","112746","13","0","0"),
("117627","Wielkopolskie","112746","14","0","0"),
("117628","Zachodniopomorskie","112746","15","0","0"),
("117629","Jelenia Góra","117613","0","0","0"),
("117630","Legnica","117613","1","0","1"),
("117631","Wałbrzych","117613","2","0","1"),
("117632","Wrocław","117613","3","0","0"),
("117633","Pow. bolesławiecki","117613","4","0","1"),
("117634","Pow. dzierżoniowski","117613","5","0","1"),
("117635","Pow. głogowski","117613","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117636","Pow. górowski","117613","7","0","1"),
("117637","Pow. jaworski","117613","8","0","1"),
("117638","Pow. jeleniogórski","117613","9","0","1"),
("117639","Pow. kamiennogórski","117613","10","0","1"),
("117640","Pow. kłodzki","117613","11","0","1"),
("117641","Pow. legnicki","117613","12","0","1"),
("117642","Pow. lubański","117613","13","0","1"),
("117643","Pow. lubiński","117613","14","0","1"),
("117644","Pow. lwówecki","117613","15","0","1"),
("117645","Pow. milicki","117613","16","0","1"),
("117646","Pow. oleśnicki","117613","17","0","1"),
("117647","Pow. oławski","117613","18","0","1"),
("117648","Pow. polkowicki","117613","19","0","1"),
("117649","Pow. strzeliński","117613","20","0","1"),
("117650","Pow. średzki","117613","21","0","1"),
("117651","Pow. świdnicki","117613","22","0","1"),
("117652","Pow. trzebnicki","117613","23","0","1"),
("117653","Pow. wałbrzyski","117613","24","0","1"),
("117654","Pow. wołowski","117613","25","0","1"),
("117655","Pow. wrocławski","117613","26","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117656","Pow. ząbkowicki","117613","27","0","1"),
("117657","Pow. zgorzelecki","117613","28","0","1"),
("117658","Pow. złotoryjski","117613","29","0","1"),
("117659","Bydgoszcz","117614","0","0","0"),
("117660","Grudziądz","117614","1","0","1"),
("117661","Toruń","117614","2","0","0"),
("117662","Włocławek","117614","3","0","1"),
("117663","Pow. aleksandrowski","117614","4","0","1"),
("117664","Pow. brodnicki","117614","5","0","1"),
("117665","Pow. bydgoski","117614","6","0","1"),
("117666","Pow. chełmiński","117614","7","0","1"),
("117667","Pow. golubsko-dobrzyński","117614","8","0","1"),
("117668","Pow. grudziądzki","117614","9","0","1"),
("117669","Pow. inowrocławski","117614","10","0","1"),
("117670","Pow. lipnowski","117614","11","0","1"),
("117671","Pow. mogileński","117614","12","0","1"),
("117672","Pow. nakielski","117614","13","0","1"),
("117673","Pow. radziejowski","117614","14","0","1"),
("117674","Pow. rypiński","117614","15","0","1"),
("117675","Pow. sępoleński","117614","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117676","Pow. świecki","117614","17","0","1"),
("117677","Pow. toruński","117614","18","0","1"),
("117678","Pow. tucholski","117614","19","0","1"),
("117679","Pow. wąbrzeski","117614","20","0","1"),
("117680","Pow. włocławski","117614","21","0","1"),
("117681","Pow. żniński","117614","22","0","1"),
("117682","Biała Podlaska","117615","0","0","1"),
("117683","Chełm","117615","1","0","1"),
("117684","Lublin","117615","2","0","0"),
("117685","Zamość","117615","3","0","1"),
("117686","Pow. bialski","117615","4","0","1"),
("117687","Pow. biłgorajski","117615","5","0","1"),
("117688","Pow. chełmski","117615","6","0","1"),
("117689","Pow. hrubieszowski","117615","7","0","1"),
("117690","Pow. janowski","117615","8","0","1"),
("117691","Pow. krasnostawski","117615","9","0","1"),
("117692","Pow. kraśnicki","117615","10","0","1"),
("117693","Pow. lubartowski","117615","11","0","1"),
("117694","Pow. lubelski","117615","12","0","1"),
("117695","Pow. łęczyński","117615","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117696","Pow. łukowski","117615","14","0","1"),
("117697","Pow. opolski","117615","15","0","1"),
("117698","Pow. parczewski","117615","16","0","1"),
("117699","Pow. puławski","117615","17","0","1"),
("117700","Pow. radzyński","117615","18","0","1"),
("117701","Pow. rycki","117615","19","0","1"),
("117702","Pow. świdnicki","117615","20","0","1"),
("117703","Pow. tomaszowski","117615","21","0","1"),
("117704","Pow. włodawski","117615","22","0","1"),
("117705","Pow. zamojski","117615","23","0","1"),
("117706","Gorzów Wielkopolski","117616","0","0","1"),
("117707","Zielona Góra","117616","1","0","1"),
("117708","Pow. gorzowski","117616","2","0","1"),
("117709","Pow. krośnieński","117616","3","0","1"),
("117710","Pow. międzyrzecki","117616","4","0","1"),
("117711","Pow. nowosolski","117616","5","0","1"),
("117712","Pow. słubicki","117616","6","0","1"),
("117713","Pow. strzelecko-drezdenecki","117616","7","0","1"),
("117714","Pow. sulęciński","117616","8","0","1"),
("117715","Pow. świebodziński","117616","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117716","Pow. wschowski","117616","10","0","1"),
("117717","Pow. zielonogórski","117616","11","0","1"),
("117718","Pow. żagański","117616","12","0","1"),
("117719","Pow. żarski","117616","13","0","1"),
("117720","Łódź","117617","0","0","0"),
("117721","Piotrków Trybunalski","117617","1","0","1"),
("117722","Skierniewice","117617","2","0","1"),
("117723","Pow. bełchatowski","117617","3","0","1"),
("117724","Pow. brzeziński","117617","4","0","1"),
("117725","Pow. kutnowski","117617","5","0","1"),
("117726","Pow. łaski","117617","6","0","1"),
("117727","Pow. łęczycki","117617","7","0","1"),
("117728","Pow. łowicki","117617","8","0","1"),
("117729","Pow. łódzki wschodni","117617","9","0","1"),
("117730","Pow. opoczyński","117617","10","0","1"),
("117731","Pow. pabianicki","117617","11","0","1"),
("117732","Pow. pajęczański","117617","12","0","1"),
("117733","Pow. piotrkowski","117617","13","0","1"),
("117734","Pow. poddębicki","117617","14","0","1"),
("117735","Pow. radomszczański","117617","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117736","Pow. rawski","117617","16","0","1"),
("117737","Pow. sieradzki","117617","17","0","1"),
("117738","Pow. skierniewicki","117617","18","0","1"),
("117739","Pow. tomaszowski","117617","19","0","1"),
("117740","Pow. wieluński","117617","20","0","1"),
("117741","Pow. wieruszowski","117617","21","0","1"),
("117742","Pow. zduńskowolski","117617","22","0","1"),
("117743","Pow. zgierski","117617","23","0","1"),
("117744","Kraków","117618","0","0","0"),
("117745","Nowy Sącz","117618","1","0","1"),
("117746","Tarnów","117618","2","0","1"),
("117747","Pow. bocheński","117618","3","0","1"),
("117748","Pow. brzeski","117618","4","0","1"),
("117749","Pow. chrzanowski","117618","5","0","1"),
("117750","Pow. dąbrowski","117618","6","0","1"),
("117751","Pow. gorlicki","117618","7","0","1"),
("117752","Pow. krakowski","117618","8","0","1"),
("117753","Pow. limanowski","117618","9","0","1"),
("117754","Pow. miechowski","117618","10","0","1"),
("117755","Pow. myślenicki","117618","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117756","Pow. nowosądecki","117618","12","0","1"),
("117757","Pow. nowotarski","117618","13","0","1"),
("117758","Pow. olkuski","117618","14","0","1"),
("117759","Pow. oświęcimski","117618","15","0","1"),
("117760","Pow. proszowicki","117618","16","0","1"),
("117761","Pow. suski","117618","17","0","1"),
("117762","Pow. tarnowski","117618","18","0","1"),
("117763","Pow. tatrzański","117618","19","0","1"),
("117764","Pow. wadowicki","117618","20","0","1"),
("117765","Pow. wielicki","117618","21","0","1"),
("117766","Ostrołęka","117619","0","0","1"),
("117767","Płock","117619","1","0","1"),
("117768","Radom","117619","2","0","1"),
("117769","Siedlce","117619","3","0","1"),
("117770","Warszawa","117619","4","0","0"),
("117771","Pow. białobrzeski","117619","5","0","1"),
("117772","Pow. ciechanowski","117619","6","0","1"),
("117773","Pow. garwoliński","117619","7","0","1"),
("117774","Pow. gostyniński","117619","8","0","1"),
("117775","Pow. grodziski","117619","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117776","Pow. grójecki","117619","10","0","1"),
("117777","Pow. kozienicki","117619","11","0","1"),
("117778","Pow. legionowski","117619","12","0","1"),
("117779","Pow. lipski","117619","13","0","1"),
("117780","Pow. łosicki","117619","14","0","1"),
("117781","Pow. makowski","117619","15","0","1"),
("117782","Pow. miński","117619","16","0","1"),
("117783","Pow. mławski","117619","17","0","1"),
("117784","Pow. nowodworski","117619","18","0","1"),
("117785","Pow. ostrołęcki","117619","19","0","1"),
("117786","Pow. ostrowski","117619","20","0","1"),
("117787","Pow. otwocki","117619","21","0","1"),
("117788","Pow. piaseczyński","117619","22","0","0"),
("117789","Pow. płocki","117619","23","0","1"),
("117790","Pow. płoński","117619","24","0","1"),
("117791","Pow. pruszkowski","117619","25","0","0"),
("117792","Pow. przasnyski","117619","26","0","1"),
("117793","Pow. przysuski","117619","27","0","1"),
("117794","Pow. pułtuski","117619","28","0","1"),
("117795","Pow. radomski","117619","29","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117796","Pow. siedlecki","117619","30","0","1"),
("117797","Pow. sierpecki","117619","31","0","1"),
("117798","Pow. sochaczewski","117619","32","0","1"),
("117799","Pow. sokołowski","117619","33","0","1"),
("117800","Pow. szydłowiecki","117619","34","0","1"),
("117801","Pow. warszawski zachodni","117619","35","0","1"),
("117802","Pow. węgrowski","117619","36","0","1"),
("117803","Pow. wołomiński","117619","37","0","0"),
("117804","Pow. wyszkowski","117619","38","0","1"),
("117805","Pow. zwoleński","117619","39","0","1"),
("117806","Pow. żuromiński","117619","40","0","1"),
("117807","Pow. żyrardowski","117619","41","0","1"),
("117808","Opole","117620","0","0","0"),
("117809","Pow. brzeski","117620","1","0","1"),
("117810","Pow. głubczycki","117620","2","0","1"),
("117811","Pow. kędzierzyńsko-kozielski","117620","3","0","1"),
("117812","Pow. kluczborski","117620","4","0","1"),
("117813","Pow. krapkowicki","117620","5","0","1"),
("117814","Pow. namysłowski","117620","6","0","1"),
("117815","Pow. nyski","117620","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117816","Pow. oleski","117620","8","0","1"),
("117817","Pow. opolski","117620","9","0","1"),
("117818","Pow. prudnicki","117620","10","0","1"),
("117819","Pow. strzelecki","117620","11","0","1"),
("117820","Krosno","117621","0","0","1"),
("117821","Przemyśl","117621","1","0","1"),
("117822","Rzeszów","117621","2","0","0"),
("117823","Tarnobrzeg","117621","3","0","1"),
("117824","Pow. bieszczadzki","117621","4","0","1"),
("117825","Pow. brzozowski","117621","5","0","1"),
("117826","Pow. dębicki","117621","6","0","1"),
("117827","Pow. jarosławski","117621","7","0","1"),
("117828","Pow. jasielski","117621","8","0","1"),
("117829","Pow. kolbuszowski","117621","9","0","1"),
("117830","Pow. krośnieński","117621","10","0","1"),
("117831","Pow. leski","117621","11","0","1"),
("117832","Pow. leżajski","117621","12","0","1"),
("117833","Pow. lubaczowski","117621","13","0","1"),
("117834","Pow. łańcucki","117621","14","0","1"),
("117835","Pow. mielecki","117621","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117836","Pow. niżański","117621","16","0","1"),
("117837","Pow. przemyski","117621","17","0","1"),
("117838","Pow. przeworski","117621","18","0","1"),
("117839","Pow. ropczycko-sędziszowski","117621","19","0","1"),
("117840","Pow. rzeszowski","117621","20","0","1"),
("117841","Pow. sanocki","117621","21","0","1"),
("117842","Pow. stalowowolski","117621","22","0","1"),
("117843","Pow. strzyżowski","117621","23","0","1"),
("117844","Pow. tarnobrzeski","117621","24","0","1"),
("117845","Białystok","117622","0","0","0"),
("117846","Łomża","117622","1","0","1"),
("117847","Suwałki","117622","2","0","1"),
("117848","Pow. augustowski","117622","3","0","1"),
("117849","Pow. białostocki","117622","4","0","1"),
("117850","Pow. bielski","117622","5","0","1"),
("117851","Pow. grajewski","117622","6","0","1"),
("117852","Pow. hajnowski","117622","7","0","1"),
("117853","Pow. kolneński","117622","8","0","1"),
("117854","Pow. łomżyński","117622","9","0","1"),
("117855","Pow. moniecki","117622","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117856","Pow. sejneński","117622","11","0","1"),
("117857","Pow. siemiatycki","117622","12","0","1"),
("117858","Pow. sokólski","117622","13","0","1"),
("117859","Pow. suwalski","117622","14","0","1"),
("117860","Pow. wysokomazowiecki","117622","15","0","1"),
("117861","Pow. zambrowski","117622","16","0","1"),
("117862","Gdańsk","117623","0","0","0"),
("117863","Gdynia","117623","1","0","0"),
("117864","Słupsk","117623","2","0","1"),
("117865","Sopot","117623","3","0","0"),
("117866","Pow. bytowski","117623","4","0","1"),
("117867","Pow. chojnicki","117623","5","0","1"),
("117868","Pow. człuchowski","117623","6","0","1"),
("117869","Pow. gdański","117623","7","0","1"),
("117870","Pow. kartuski","117623","8","0","1"),
("117871","Pow. kościerski","117623","9","0","1"),
("117872","Pow. kwidzyński","117623","10","0","1"),
("117873","Pow. lęborski","117623","11","0","1"),
("117874","Pow. malborski","117623","12","0","1"),
("117875","Pow. nowodworski","117623","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117876","Pow. pucki","117623","14","0","1"),
("117877","Pow. słupski","117623","15","0","1"),
("117878","Pow. starogardzki","117623","16","0","1"),
("117879","Pow. sztumski","117623","17","0","1"),
("117880","Pow. tczewski","117623","18","0","1"),
("117881","Pow. wejherowski","117623","19","0","0"),
("117882","Bielsko-Biała","117624","0","0","0"),
("117883","Bytom","117624","1","0","0"),
("117884","Chorzów","117624","2","0","1"),
("117885","Częstochowa","117624","3","0","0"),
("117886","Dąbrowa Górnicza","117624","4","0","1"),
("117887","Gliwice","117624","5","0","0"),
("117888","Jastrzębie-Zdrój","117624","6","0","1"),
("117889","Jaworzno","117624","7","0","1"),
("117890","Katowice","117624","8","0","0"),
("117891","Mysłowice","117624","9","0","1"),
("117892","Piekary Śląskie","117624","10","0","1"),
("117893","Ruda Śląska","117624","11","0","1"),
("117894","Rybnik","117624","12","0","1"),
("117895","Siemianowice Śląskie","117624","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117896","Sosnowiec","117624","14","0","0"),
("117897","Świętochłowice","117624","15","0","1"),
("117898","Tychy","117624","16","0","0"),
("117899","Zabrze","117624","17","0","1"),
("117900","Żory","117624","18","0","1"),
("117901","Pow. będziński","117624","19","0","1"),
("117902","Pow. bielski","117624","20","0","1"),
("117903","Pow. bieruńsko-lędziński","117624","21","0","1"),
("117904","Pow. cieszyński","117624","22","0","1"),
("117905","Pow. częstochowski","117624","23","0","1"),
("117906","Pow. gliwicki","117624","24","0","1"),
("117907","Pow. kłobucki","117624","25","0","1"),
("117908","Pow. lubliniecki","117624","26","0","1"),
("117909","Pow. mikołowski","117624","27","0","1"),
("117910","Pow. myszkowski","117624","28","0","1"),
("117911","Pow. pszczyński","117624","29","0","1"),
("117912","Pow. raciborski","117624","30","0","1"),
("117913","Pow. rybnicki","117624","31","0","1"),
("117914","Pow. tarnogórski","117624","32","0","1"),
("117915","Pow. wodzisławski","117624","33","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117916","Pow. zawierciański","117624","34","0","1"),
("117917","Pow. żywiecki","117624","35","0","1"),
("117918","Kielce","117625","0","0","1"),
("117919","Pow. buski","117625","1","0","1"),
("117920","Pow. jędrzejowski","117625","2","0","1"),
("117921","Pow. kazimierski","117625","3","0","1"),
("117922","Pow. kielecki","117625","4","0","1"),
("117923","Pow. konecki","117625","5","0","1"),
("117924","Pow. opatowski","117625","6","0","1"),
("117925","Pow. ostrowiecki","117625","7","0","1"),
("117926","Pow. pińczowski","117625","8","0","1"),
("117927","Pow. sandomierski","117625","9","0","1"),
("117928","Pow. skarżyski","117625","10","0","1"),
("117929","Pow. starachowicki","117625","11","0","1"),
("117930","Pow. staszowski","117625","12","0","1"),
("117931","Pow. włoszczowski","117625","13","0","1"),
("117932","Elbląg","117626","0","0","1"),
("117933","Olsztyn","117626","1","0","1"),
("117934","Pow. bartoszycki","117626","2","0","1"),
("117935","Pow. braniewski","117626","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117936","Pow. działdowski","117626","4","0","1"),
("117937","Pow. elbląski","117626","5","0","1"),
("117938","Pow. ełcki","117626","6","0","1"),
("117939","Pow. giżycki","117626","7","0","1"),
("117940","Pow. gołdapski","117626","8","0","1"),
("117941","Pow. iławski","117626","9","0","1"),
("117942","Pow. kętrzyński","117626","10","0","1"),
("117943","Pow. lidzbarski","117626","11","0","1"),
("117944","Pow. mrągowski","117626","12","0","1"),
("117945","Pow. nidzicki","117626","13","0","1"),
("117946","Pow. nowomiejski","117626","14","0","1"),
("117947","Pow. olecki","117626","15","0","1"),
("117948","Pow. olsztyński","117626","16","0","1"),
("117949","Pow. ostródzki","117626","17","0","1"),
("117950","Pow. piski","117626","18","0","1"),
("117951","Pow. szczycieński","117626","19","0","1"),
("117952","Pow. węgorzewski","117626","20","0","1"),
("117953","Kalisz","117627","0","0","1"),
("117954","Konin","117627","1","0","1"),
("117955","Leszno","117627","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117956","Poznań","117627","3","0","0"),
("117957","Pow. chodzieski","117627","4","0","1"),
("117958","Pow. czarnkowsko-trzcianecki","117627","5","0","1"),
("117959","Pow. gnieźnieński","117627","6","0","1"),
("117960","Pow. gostyński","117627","7","0","1"),
("117961","Pow. grodziski","117627","8","0","1"),
("117962","Pow. jarociński","117627","9","0","1"),
("117963","Pow. kaliski","117627","10","0","1"),
("117964","Pow. kępiński","117627","11","0","1"),
("117965","Pow. kolski","117627","12","0","1"),
("117966","Pow. koniński","117627","13","0","1"),
("117967","Pow. kościański","117627","14","0","1"),
("117968","Pow. krotoszyński","117627","15","0","1"),
("117969","Pow. leszczyński","117627","16","0","1"),
("117970","Pow. międzychodzki","117627","17","0","1"),
("117971","Pow. nowotomyski","117627","18","0","1"),
("117972","Pow. obornicki","117627","19","0","1"),
("117973","Pow. ostrowski","117627","20","0","1"),
("117974","Pow. ostrzeszowski","117627","21","0","1"),
("117975","Pow. pilski","117627","22","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117976","Pow. pleszewski","117627","23","0","1"),
("117977","Pow. poznański","117627","24","0","1"),
("117978","Pow. rawicki","117627","25","0","1"),
("117979","Pow. słupecki","117627","26","0","1"),
("117980","Pow. szamotulski","117627","27","0","1"),
("117981","Pow. średzki","117627","28","0","1"),
("117982","Pow. śremski","117627","29","0","1"),
("117983","Pow. turecki","117627","30","0","1"),
("117984","Pow. wągrowiecki","117627","31","0","1"),
("117985","Pow. wolsztyński","117627","32","0","1"),
("117986","Pow. wrzesiński","117627","33","0","1"),
("117987","Pow. złotowski","117627","34","0","1"),
("117988","Koszalin","117628","0","0","0"),
("117989","Szczecin","117628","1","0","0"),
("117990","Świnoujście","117628","2","0","1"),
("117991","Pow. białogardzki","117628","3","0","1"),
("117992","Pow. choszczeński","117628","4","0","1"),
("117993","Pow. drawski","117628","5","0","1"),
("117994","Pow. goleniowski","117628","6","0","1"),
("117995","Pow. gryficki","117628","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("117996","Pow. gryfiński","117628","8","0","1"),
("117997","Pow. kamieński","117628","9","0","1"),
("117998","Pow. kołobrzeski","117628","10","0","1"),
("117999","Pow. koszaliński","117628","11","0","1"),
("118000","Pow. łobeski","117628","12","0","1"),
("118001","Pow. myśliborski","117628","13","0","1"),
("118002","Pow. policki","117628","14","0","1"),
("118003","Pow. pyrzycki","117628","15","0","1"),
("118004","Pow. sławieński","117628","16","0","1"),
("118005","Pow. stargardzki","117628","17","0","1"),
("118006","Pow. szczecinecki","117628","18","0","1"),
("118007","Pow. świdwiński","117628","19","0","1"),
("118008","Pow. wałecki","117628","20","0","1"),
("118009","Cieplice Śląskie-Zdrój","117629","0","0","1"),
("118010","Czarne","117629","1","0","1"),
("118011","Dąbrówka","117629","2","0","1"),
("118012","Goduszyn","117629","3","0","1"),
("118013","Grabary","117629","4","0","1"),
("118014","Jagniątków","117629","5","0","1"),
("118015","Maciejowa","117629","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118016","Paulinów","117629","7","0","1"),
("118017","Sobieszów","117629","8","0","1"),
("118018","Strupice","117629","9","0","1"),
("118019","Zabobrze","117629","10","0","1"),
("118020","Pozostałe","117629","11","0","1"),
("118021","Fabryczna","117632","0","0","1"),
("118022","Krzyki","117632","1","0","1"),
("118023","Psie Pole","117632","2","0","1"),
("118024","Stare Miasto","117632","3","0","1"),
("118025","Śródmieście","117632","4","0","1"),
("118026","Inne","117632","5","0","1"),
("118027","Bartodzieje Małe","117659","0","0","1"),
("118028","Bartodzieje Wielkie","117659","1","0","1"),
("118029","Bielawy","117659","2","0","1"),
("118030","Błonie","117659","3","0","1"),
("118031","Bocianowo","117659","4","0","1"),
("118032","Czyżkówko","117659","5","0","1"),
("118033","Fordon","117659","6","0","1"),
("118034","Górzyskowo","117659","7","0","1"),
("118035","Kapuściska","117659","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118036","Okole","117659","9","0","1"),
("118037","Osiedle Leśne","117659","10","0","1"),
("118038","Osowa Góra","117659","11","0","1"),
("118039","Skrzetusko","117659","12","0","1"),
("118040","Szwederowo","117659","13","0","1"),
("118041","Wilczak","117659","15","0","1"),
("118042","Pozostałe","117659","16","0","1"),
("118043","Bielany","117661","0","0","1"),
("118044","Bielawy","117661","1","0","1"),
("118045","Bydgoskie Przedmieście","117661","2","0","1"),
("118046","Chełmińskie Przedmieście","117661","3","0","1"),
("118047","Jakubskie Przedmieście","117661","4","0","1"),
("118048","Koniuchy","117661","5","0","1"),
("118049","Mokre","117661","6","0","1"),
("118050","Na Skarpie","117661","7","0","1"),
("118051","Podgórz","117661","8","0","1"),
("118052","Rubinkowo","117661","9","0","1"),
("118053","Rudak","117661","10","0","1"),
("118054","Rybaki","117661","11","0","1"),
("118055","Stare Miasto","117661","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118056","Stawki","117661","13","0","1"),
("118057","Wrzosy","117661","14","0","1"),
("118058","Pozostałe","117661","15","0","1"),
("118059","Bazylianówka","117684","0","0","1"),
("118060","Bronowice","117684","1","0","1"),
("118061","Czechów Górny","117684","2","0","1"),
("118062","Czuby","117684","3","0","1"),
("118063","Dziesiąta","117684","4","0","1"),
("118064","Felin","117684","5","0","1"),
("118065","Kalinowszczyzna","117684","6","0","1"),
("118066","Kośminek","117684","7","0","1"),
("118067","Rudnik","117684","8","0","1"),
("118068","Sławinek","117684","9","0","1"),
("118069","Śródmieście","117684","10","0","1"),
("118070","Tatary","117684","11","0","1"),
("118071","Węglin","117684","12","0","1"),
("118072","Wieniawka","117684","13","0","1"),
("118073","Wrotków","117684","14","0","1"),
("118074","Pozostałe","117684","15","0","1"),
("118075","Bałuty","117720","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118076","Górna","117720","1","0","1"),
("118077","Polesie","117720","2","0","1"),
("118078","Śródmieście","117720","3","0","1"),
("118079","Widzew","117720","4","0","1"),
("118080","Pozostałe","117720","5","0","1"),
("118081","Krowodrza","117744","0","0","1"),
("118082","Nowa Huta","117744","1","0","1"),
("118083","Podgórze","117744","2","0","1"),
("118084","Śródmieście","117744","3","0","1"),
("118085","Pozostałe","117744","4","0","1"),
("118086","Bemowo","117770","0","0","1"),
("118087","Białołęka","117770","1","0","1"),
("118088","Bielany","117770","2","0","1"),
("118089","Mokotów","117770","3","0","1"),
("118090","Ochota","117770","4","0","1"),
("118091","Praga Południe","117770","5","0","1"),
("118092","Praga Północ","117770","6","0","1"),
("118093","Rembertów","117770","7","0","1"),
("118094","Śródmieście","117770","8","0","1"),
("118095","Targówek","117770","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118096","Ursus","117770","10","0","1"),
("118097","Ursynów","117770","11","0","1"),
("118098","Wawer","117770","12","0","1"),
("118099","Wesoła","117770","13","0","1"),
("118100","Wilanów","117770","14","0","1"),
("118101","Włochy","117770","15","0","1"),
("118102","Wola","117770","16","0","1"),
("118103","Żoliborz","117770","17","0","1"),
("118104","Inne","117770","18","0","1"),
("118105","Góra Kalwaria","117788","0","0","1"),
("118106","Konstancin-Jeziorna","117788","1","0","1"),
("118107","Piaseczno","117788","2","0","1"),
("118108","Tarczyn","117788","3","0","1"),
("118109","Pozostałe","117788","4","0","1"),
("118110","Brwinów","117791","0","0","1"),
("118111","Piastów","117791","1","0","1"),
("118112","Pruszków","117791","2","0","1"),
("118113","Pozostałe","117791","3","0","1"),
("118114","Kobyłka","117803","0","0","1"),
("118115","Marki","117803","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118116","Radzymin","117803","2","0","1"),
("118117","Tłuszcz","117803","3","0","1"),
("118118","Wołomin","117803","4","0","1"),
("118119","Ząbki","117803","5","0","1"),
("118120","Zielonka","117803","6","0","1"),
("118121","Pozostałe","117803","7","0","1"),
("118122","Bierkowice","117808","0","0","1"),
("118123","Gosławice","117808","1","0","1"),
("118124","Groszowice","117808","2","0","1"),
("118125","Grudzice","117808","3","0","1"),
("118126","Kolonia Gosławicka","117808","4","0","1"),
("118127","Malina","117808","5","0","1"),
("118128","Nowa Wieś Królewska","117808","6","0","1"),
("118129","Półwieś","117808","7","0","1"),
("118130","Szczepanowice","117808","8","0","1"),
("118131","Wójtowa Wieś","117808","9","0","1"),
("118132","Wróblin","117808","10","0","1"),
("118133","Zakrzów","117808","11","0","1"),
("118134","Zaodrze","117808","12","0","1"),
("118135","Pozostałe","117808","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118136","Drabinianka","117822","0","0","1"),
("118137","Dworzysko","117822","1","0","1"),
("118138","Miłocin","117822","2","0","1"),
("118139","Pobitno","117822","3","0","1"),
("118140","Przybyszówka","117822","4","0","1"),
("118141","Słocina","117822","5","0","1"),
("118142","Staromieście","117822","6","0","1"),
("118143","Staroniwa","117822","7","0","1"),
("118144","Szajerówka","117822","8","0","1"),
("118145","Wilkowyja","117822","9","0","1"),
("118146","Zalesie","117822","10","0","1"),
("118147","Załęże","117822","11","0","1"),
("118148","Zwięczyca","117822","12","0","1"),
("118149","Pozostałe","117822","13","0","1"),
("118150","Antoniuk","117845","0","0","1"),
("118151","Bacieczki","117845","1","0","1"),
("118152","Białostoczek","117845","2","0","1"),
("118153","Bojary","117845","3","0","1"),
("118154","Dojlidy","117845","4","0","1"),
("118155","Dojlidy Górne","117845","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118156","Dziesięciny","117845","6","0","1"),
("118157","Nowe Miasto","117845","7","0","1"),
("118158","Skorupy","117845","8","0","1"),
("118159","Słoboda","117845","9","0","1"),
("118160","Starosielce","117845","10","0","1"),
("118161","Wygoda","117845","11","0","1"),
("118162","Wysoki Stoczek","117845","12","0","1"),
("118163","Zagórki","117845","13","0","1"),
("118164","Zawady","117845","14","0","1"),
("118165","Pozostałe","117845","15","0","1"),
("118166","Brzeźno","117862","0","0","1"),
("118167","Chełm","117862","1","0","1"),
("118168","Jasień","117862","2","0","1"),
("118169","Kiełpino Górne","117862","3","0","1"),
("118170","Kokoszki","117862","4","0","1"),
("118171","Lipce","117862","5","0","1"),
("118172","Łostowice","117862","6","0","1"),
("118173","Oliwa","117862","7","0","1"),
("118174","Osowa","117862","8","0","1"),
("118175","Przymorze","117862","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118176","Siedlce","117862","10","0","1"),
("118177","Sobieszewo","117862","11","0","1"),
("118178","Suchanino","117862","12","0","1"),
("118179","Wrzeszcz","117862","13","0","1"),
("118180","Zakoniczyn","117862","14","0","1"),
("118181","Pozostałe","117862","15","0","1"),
("118182","Chwarzno","117863","0","0","1"),
("118183","Chylonia","117863","1","0","1"),
("118184","Cisowa","117863","2","0","1"),
("118185","Działki Leśne","117863","3","0","1"),
("118186","Kamienna Góra","117863","4","0","1"),
("118187","Leszczynki","117863","5","0","1"),
("118188","Mały Kack","117863","6","0","1"),
("118189","Obłuże","117863","7","0","1"),
("118190","Oksywie","117863","8","0","1"),
("118191","Orłowo","117863","9","0","1"),
("118192","Pogórze","117863","10","0","1"),
("118193","Redłowo","117863","11","0","1"),
("118194","Wiczlino","117863","12","0","1"),
("118195","Wielki Kack","117863","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118196","Wzgórze Nowotki","117863","14","0","1"),
("118197","Pozostałe","117863","15","0","1"),
("118198","Brodwino","117865","0","0","1"),
("118199","Kamienny Potok","117865","1","0","1"),
("118200","Przylesie","117865","2","0","1"),
("118201","Sopot Dolny","117865","3","0","1"),
("118202","Sopot Górny","117865","4","0","1"),
("118203","Wyścigi","117865","5","0","1"),
("118204","Pozostałe","117865","6","0","1"),
("118205","Reda","117881","0","0","1"),
("118206","Rumia","117881","1","0","1"),
("118207","Wejherowo","117881","2","0","1"),
("118208","Pozostałe","117881","3","0","1"),
("118209","Aleksandrowice","117882","0","0","1"),
("118210","Hałcnów","117882","1","0","1"),
("118211","Kamienica","117882","2","0","1"),
("118212","Komorowice Krakowskie","117882","3","0","1"),
("118213","Leszczyny","117882","4","0","1"),
("118214","Lipnik","117882","5","0","1"),
("118215","Mikuszowice Krakowskie","117882","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118216","Mikuszowice Śląskie","117882","7","0","1"),
("118217","Olszówka Dolna","117882","8","0","1"),
("118218","Olszówka Górna","117882","9","0","1"),
("118219","Stare Bielsko","117882","10","0","1"),
("118220","Straconka","117882","11","0","1"),
("118221","Wapienica","117882","12","0","1"),
("118222","Złote Łany","117882","13","0","1"),
("118223","Pozostałe","117882","14","0","1"),
("118224","Bobrek","117883","0","0","1"),
("118225","Górniki","117883","1","0","1"),
("118226","Karb","117883","2","0","1"),
("118227","Łagiewniki","117883","3","0","1"),
("118228","Miechowice","117883","4","0","1"),
("118229","Rozbark","117883","5","0","1"),
("118230","Stolarzowice","117883","6","0","1"),
("118231","Stroszek","117883","7","0","1"),
("118232","Sucha Góra","117883","8","0","1"),
("118233","Szombierki","117883","9","0","1"),
("118234","Pozostałe","117883","10","0","1"),
("118235","Błeszno","117885","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118236","Dźbów","117885","1","0","1"),
("118237","Grabówka","117885","2","0","1"),
("118238","Kawodrza Dolna","117885","3","0","1"),
("118239","Lisiniec","117885","4","0","1"),
("118240","Liszka Dolna","117885","5","0","1"),
("118241","Mirów","117885","6","0","1"),
("118242","Ostatni Grosz","117885","7","0","1"),
("118243","Parkitka","117885","8","0","1"),
("118244","Raków","117885","9","0","1"),
("118245","Rząsawy","117885","10","0","1"),
("118246","Sabinów","117885","11","0","1"),
("118247","Stradom","117885","12","0","1"),
("118248","Wrzosowiak","117885","13","0","1"),
("118249","Zawodzie","117885","14","0","1"),
("118250","Pozostałe","117885","15","0","1"),
("118251","Bojków","117887","0","0","1"),
("118252","Brzezinka","117887","1","0","1"),
("118253","Czechowice","117887","2","0","1"),
("118254","Ligota Zabrska","117887","3","0","1"),
("118255","Łabędy","117887","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118256","Ostropa","117887","5","0","1"),
("118257","Sośnica","117887","6","0","1"),
("118258","Stare Gliwice","117887","7","0","1"),
("118259","Szobiszowice","117887","8","0","1"),
("118260","Trynek","117887","9","0","1"),
("118261","Wilcze Gardło","117887","10","0","1"),
("118262","Wójtowa Wieś","117887","11","0","1"),
("118263","Żerniki","117887","12","0","1"),
("118264","Pozostałe","117887","13","0","1"),
("118265","Bogucice","117890","0","0","1"),
("118266","Brynów","117890","1","0","1"),
("118267","Dąb","117890","2","0","1"),
("118268","Giszowiec","117890","3","0","1"),
("118269","Józefowiec","117890","4","0","1"),
("118270","Kostuchna","117890","5","0","1"),
("118271","Koszutka","117890","6","0","1"),
("118272","Ligota","117890","7","0","1"),
("118273","Ochojec","117890","8","0","1"),
("118274","Panewniki","117890","9","0","1"),
("118275","Piotrowice","117890","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118276","Podlesie","117890","11","0","1"),
("118277","Wełnowiec","117890","12","0","1"),
("118278","Zarzecze","117890","13","0","1"),
("118279","Zawodzie","117890","14","0","1"),
("118280","Pozostałe","117890","15","0","1"),
("118281","Cieśle","117896","0","0","1"),
("118282","Dańdówka","117896","1","0","1"),
("118283","Dębowa Góra","117896","2","0","1"),
("118284","Józefów","117896","3","0","1"),
("118285","Kazimierz","117896","4","0","1"),
("118286","Klimontów","117896","5","0","1"),
("118287","Maczki","117896","6","0","1"),
("118288","Milowice","117896","7","0","1"),
("118289","Niwka","117896","8","0","1"),
("118290","Ostrowy Górnicze","117896","9","0","1"),
("118291","Pogoń","117896","10","0","1"),
("118292","Sielec","117896","11","0","1"),
("118293","Stary Sosnowiec","117896","12","0","1"),
("118294","Środula","117896","13","0","1"),
("118295","Zagórze","117896","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118296","Pozostałe","117896","15","0","1"),
("118297","Cielmice","117898","0","0","1"),
("118298","Czułów","117898","1","0","1"),
("118299","Glinka","117898","2","0","1"),
("118300","Jaroszowice","117898","3","0","1"),
("118301","Mąkołowiec","117898","4","0","1"),
("118302","Paprocany","117898","5","0","1"),
("118303","Suble","117898","6","0","1"),
("118304","Urbanowice","117898","7","0","1"),
("118305","Wartogłowiec","117898","8","0","1"),
("118306","Wilkowyje","117898","9","0","1"),
("118307","Zwierzyniec","117898","10","0","1"),
("118308","Żwaków","117898","11","0","1"),
("118309","Pozostałe","117898","12","0","1"),
("118310","Grunwald","117956","0","0","1"),
("118311","Jeżyce","117956","1","0","1"),
("118312","Nowe Miasto","117956","2","0","1"),
("118313","Stare Miasto","117956","3","0","1"),
("118314","Wilda","117956","4","0","1"),
("118315","Pozostałe","117956","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118316","Chełmoniewo","117988","0","0","1"),
("118317","Dzierżęcino","117988","1","0","1"),
("118318","Lubiatowo","117988","2","0","1"),
("118319","Raduszka","117988","3","0","1"),
("118320","Rokosowo","117988","4","0","1"),
("118321","Pozostałe","117988","5","0","1"),
("118322","Bezrzecze","117989","0","0","1"),
("118323","Bukowe-Klęskowo","117989","1","0","1"),
("118324","Bukowo","117989","2","0","1"),
("118325","Centrum","117989","3","0","1"),
("118326","Dąbie","117989","4","0","1"),
("118327","Drzetowo","117989","5","0","1"),
("118328","Głębokie","117989","6","0","1"),
("118329","Grabowo","117989","7","0","1"),
("118330","Gumieńce","117989","8","0","1"),
("118331","Kijewo","117989","9","0","1"),
("118332","Niebuszewo","117989","10","0","1"),
("118333","Osów","117989","11","0","1"),
("118334","Pilchowo","117989","12","0","1"),
("118335","Płonia","117989","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118336","Podjuchy","117989","14","0","1"),
("118337","Pogodno","117989","15","0","1"),
("118338","Pomorzany","117989","16","0","1"),
("118339","Skolwin","117989","17","0","1"),
("118340","Stare Miasto","117989","18","0","1"),
("118341","Stołczyn","117989","19","0","1"),
("118342","Świerczewo","117989","20","0","1"),
("118343","Warszewo","117989","21","0","1"),
("118344","Wielgowo","117989","22","0","1"),
("118345","Zdroje","117989","23","0","1"),
("118346","Żelechowa","117989","24","0","1"),
("118347","Pozostałe","117989","25","0","1"),
("118348","Dolnośląskie","112747","0","0","0"),
("118349","Kujawsko-pomorskie","112747","1","0","0"),
("118350","Lubelskie","112747","2","0","0"),
("118351","Lubuskie","112747","3","0","0"),
("118352","Łódzkie","112747","4","0","0"),
("118353","Małopolskie","112747","5","0","0"),
("118354","Mazowieckie","112747","6","0","0"),
("118355","Opolskie","112747","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118356","Podkarpackie","112747","8","0","0"),
("118357","Podlaskie","112747","9","0","0"),
("118358","Pomorskie","112747","10","0","0"),
("118359","Śląskie","112747","11","0","0"),
("118360","Świętokrzyskie","112747","12","0","0"),
("118361","Warmińsko-mazurskie","112747","13","0","0"),
("118362","Wielkopolskie","112747","14","0","0"),
("118363","Zachodniopomorskie","112747","15","0","0"),
("118364","Jelenia Góra","118348","0","0","1"),
("118365","Legnica","118348","1","0","1"),
("118366","Wałbrzych","118348","2","0","1"),
("118367","Wrocław","118348","3","0","0"),
("118368","Pow. bolesławiecki","118348","4","0","1"),
("118369","Pow. dzierżoniowski","118348","5","0","1"),
("118370","Pow. głogowski","118348","6","0","1"),
("118371","Pow. górowski","118348","7","0","1"),
("118372","Pow. jaworski","118348","8","0","1"),
("118373","Pow. jeleniogórski","118348","9","0","1"),
("118374","Pow. kamiennogórski","118348","10","0","1"),
("118375","Pow. kłodzki","118348","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118376","Pow. legnicki","118348","12","0","1"),
("118377","Pow. lubański","118348","13","0","1"),
("118378","Pow. lubiński","118348","14","0","1"),
("118379","Pow. lwówecki","118348","15","0","1"),
("118380","Pow. milicki","118348","16","0","1"),
("118381","Pow. oleśnicki","118348","17","0","1"),
("118382","Pow. oławski","118348","18","0","1"),
("118383","Pow. polkowicki","118348","19","0","1"),
("118384","Pow. strzeliński","118348","20","0","1"),
("118385","Pow. średzki","118348","21","0","1"),
("118386","Pow. świdnicki","118348","22","0","1"),
("118387","Pow. trzebnicki","118348","23","0","1"),
("118388","Pow. wałbrzyski","118348","24","0","1"),
("118389","Pow. wołowski","118348","25","0","1"),
("118390","Pow. wrocławski","118348","26","0","1"),
("118391","Pow. ząbkowicki","118348","27","0","1"),
("118392","Pow. zgorzelecki","118348","28","0","1"),
("118393","Pow. złotoryjski","118348","29","0","1"),
("118394","Bydgoszcz","118349","0","0","1"),
("118395","Grudziądz","118349","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118396","Toruń","118349","2","0","1"),
("118397","Włocławek","118349","3","0","1"),
("118398","Pow. aleksandrowski","118349","4","0","1"),
("118399","Pow. brodnicki","118349","5","0","1"),
("118400","Pow. bydgoski","118349","6","0","1"),
("118401","Pow. chełmiński","118349","7","0","1"),
("118402","Pow. golubsko-dobrzyński","118349","8","0","1"),
("118403","Pow. grudziądzki","118349","9","0","1"),
("118404","Pow. inowrocławski","118349","10","0","1"),
("118405","Pow. lipnowski","118349","11","0","1"),
("118406","Pow. mogileński","118349","12","0","1"),
("118407","Pow. nakielski","118349","13","0","1"),
("118408","Pow. radziejowski","118349","14","0","1"),
("118409","Pow. rypiński","118349","15","0","1"),
("118410","Pow. sępoleński","118349","16","0","1"),
("118411","Pow. świecki","118349","17","0","1"),
("118412","Pow. toruński","118349","18","0","1"),
("118413","Pow. tucholski","118349","19","0","1"),
("118414","Pow. wąbrzeski","118349","20","0","1"),
("118415","Pow. włocławski","118349","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118416","Pow. żniński","118349","22","0","1"),
("118417","Biała Podlaska","118350","0","0","1"),
("118418","Chełm","118350","1","0","1"),
("118419","Lublin","118350","2","0","1"),
("118420","Zamość","118350","3","0","1"),
("118421","Pow. bialski","118350","4","0","1"),
("118422","Pow. biłgorajski","118350","5","0","1"),
("118423","Pow. chełmski","118350","6","0","1"),
("118424","Pow. hrubieszowski","118350","7","0","1"),
("118425","Pow. janowski","118350","8","0","1"),
("118426","Pow. krasnostawski","118350","9","0","1"),
("118427","Pow. kraśnicki","118350","10","0","1"),
("118428","Pow. lubartowski","118350","11","0","1"),
("118429","Pow. lubelski","118350","12","0","1"),
("118430","Pow. łęczyński","118350","13","0","1"),
("118431","Pow. łukowski","118350","14","0","1"),
("118432","Pow. opolski","118350","15","0","1"),
("118433","Pow. parczewski","118350","16","0","1"),
("118434","Pow. puławski","118350","17","0","1"),
("118435","Pow. radzyński","118350","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118436","Pow. rycki","118350","19","0","1"),
("118437","Pow. świdnicki","118350","20","0","1"),
("118438","Pow. tomaszowski","118350","21","0","1"),
("118439","Pow. włodawski","118350","22","0","1"),
("118440","Pow. zamojski","118350","23","0","1"),
("118441","Gorzów Wielkopolski","118351","0","0","1"),
("118442","Zielona Góra","118351","1","0","1"),
("118443","Pow. gorzowski","118351","2","0","1"),
("118444","Pow. krośnieński","118351","3","0","1"),
("118445","Pow. międzyrzecki","118351","4","0","1"),
("118446","Pow. nowosolski","118351","5","0","1"),
("118447","Pow. słubicki","118351","6","0","1"),
("118448","Pow. strzelecko-drezdenecki","118351","7","0","1"),
("118449","Pow. sulęciński","118351","8","0","1"),
("118450","Pow. świebodziński","118351","9","0","1"),
("118451","Pow. wschowski","118351","10","0","1"),
("118452","Pow. zielonogórski","118351","11","0","1"),
("118453","Pow. żagański","118351","12","0","1"),
("118454","Pow. żarski","118351","13","0","1"),
("118455","Łódź","118352","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118456","Piotrków Trybunalski","118352","1","0","1"),
("118457","Skierniewice","118352","2","0","1"),
("118458","Pow. bełchatowski","118352","3","0","1"),
("118459","Pow. brzeziński","118352","4","0","1"),
("118460","Pow. kutnowski","118352","5","0","1"),
("118461","Pow. łaski","118352","6","0","1"),
("118462","Pow. łęczycki","118352","7","0","1"),
("118463","Pow. łowicki","118352","8","0","1"),
("118464","Pow. łódzki wschodni","118352","9","0","1"),
("118465","Pow. opoczyński","118352","10","0","1"),
("118466","Pow. pabianicki","118352","11","0","1"),
("118467","Pow. pajęczański","118352","12","0","1"),
("118468","Pow. piotrkowski","118352","13","0","1"),
("118469","Pow. poddębicki","118352","14","0","1"),
("118470","Pow. radomszczański","118352","15","0","1"),
("118471","Pow. rawski","118352","16","0","1"),
("118472","Pow. sieradzki","118352","17","0","1"),
("118473","Pow. skierniewicki","118352","18","0","1"),
("118474","Pow. tomaszowski","118352","19","0","1"),
("118475","Pow. wieluński","118352","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118476","Pow. wieruszowski","118352","21","0","1"),
("118477","Pow. zduńskowolski","118352","22","0","1"),
("118478","Pow. zgierski","118352","23","0","1"),
("118479","Kraków","118353","0","0","0"),
("118480","Nowy Sącz","118353","1","0","1"),
("118481","Tarnów","118353","2","0","1"),
("118482","Pow. bocheński","118353","3","0","1"),
("118483","Pow. brzeski","118353","4","0","1"),
("118484","Pow. chrzanowski","118353","5","0","1"),
("118485","Pow. dąbrowski","118353","6","0","1"),
("118486","Pow. gorlicki","118353","7","0","1"),
("118487","Pow. krakowski","118353","8","0","1"),
("118488","Pow. limanowski","118353","9","0","1"),
("118489","Pow. miechowski","118353","10","0","1"),
("118490","Pow. myślenicki","118353","11","0","1"),
("118491","Pow. nowosądecki","118353","12","0","1"),
("118492","Pow. nowotarski","118353","13","0","1"),
("118493","Pow. olkuski","118353","14","0","1"),
("118494","Pow. oświęcimski","118353","15","0","1"),
("118495","Pow. proszowicki","118353","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118496","Pow. suski","118353","17","0","1"),
("118497","Pow. tarnowski","118353","18","0","1"),
("118498","Pow. tatrzański","118353","19","0","1"),
("118499","Pow. wadowicki","118353","20","0","1"),
("118500","Pow. wielicki","118353","21","0","1"),
("118501","Ostrołęka","118354","0","0","1"),
("118502","Płock","118354","1","0","1"),
("118503","Radom","118354","2","0","1"),
("118504","Siedlce","118354","3","0","1"),
("118505","Warszawa","118354","4","0","0"),
("118506","Pow. białobrzeski","118354","5","0","1"),
("118507","Pow. ciechanowski","118354","6","0","1"),
("118508","Pow. garwoliński","118354","7","0","1"),
("118509","Pow. gostyniński","118354","8","0","1"),
("118510","Pow. grójecki","118354","9","0","1"),
("118511","Pow. grodziski","118354","10","0","1"),
("118512","Pow. kozienicki","118354","11","0","1"),
("118513","Pow. legionowski","118354","12","0","1"),
("118514","Pow. lipski","118354","13","0","1"),
("118515","Pow. łosicki","118354","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118516","Pow. makowski","118354","15","0","1"),
("118517","Pow. miński","118354","16","0","1"),
("118518","Pow. mławski","118354","17","0","1"),
("118519","Pow. nowodworski","118354","18","0","1"),
("118520","Pow. ostrołęcki","118354","19","0","1"),
("118521","Pow. ostrowski","118354","20","0","1"),
("118522","Pow. otwocki","118354","21","0","1"),
("118523","Pow. piaseczyński","118354","22","0","1"),
("118524","Pow. płocki","118354","23","0","1"),
("118525","Pow. płoński","118354","24","0","1"),
("118526","Pow. pruszkowski","118354","25","0","1"),
("118527","Pow. przasnyski","118354","26","0","1"),
("118528","Pow. przysuski","118354","27","0","1"),
("118529","Pow. pułtuski","118354","28","0","1"),
("118530","Pow. radomski","118354","29","0","1"),
("118531","Pow. siedlecki","118354","30","0","1"),
("118532","Pow. sierpecki","118354","31","0","1"),
("118533","Pow. sochaczewski","118354","32","0","1"),
("118534","Pow. sokołowski","118354","33","0","1"),
("118535","Pow. szydłowiecki","118354","34","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118536","Pow. warszawski zachodni","118354","35","0","1"),
("118537","Pow. węgrowski","118354","36","0","1"),
("118538","Pow. wołomiński","118354","37","0","1"),
("118539","Pow. wyszkowski","118354","38","0","1"),
("118540","Pow. zwoleński","118354","39","0","1"),
("118541","Pow. żuromiński","118354","40","0","1"),
("118542","Pow. żyrardowski","118354","41","0","1"),
("118543","Opole","118355","0","0","1"),
("118544","Pow. brzeski","118355","1","0","1"),
("118545","Pow. głubczycki","118355","2","0","1"),
("118546","Pow. kędzierzyńsko-kozielski","118355","3","0","1"),
("118547","Pow. kluczborski","118355","4","0","1"),
("118548","Pow. krapkowicki","118355","5","0","1"),
("118549","Pow. namysłowski","118355","6","0","1"),
("118550","Pow. nyski","118355","7","0","1"),
("118551","Pow. oleski","118355","8","0","1"),
("118552","Pow. opolski","118355","9","0","1"),
("118553","Pow. prudnicki","118355","10","0","1"),
("118554","Pow. strzelecki","118355","11","0","1"),
("118555","Krosno","118356","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118556","Przemyśl","118356","1","0","1"),
("118557","Rzeszów","118356","2","0","1"),
("118558","Tarnobrzeg","118356","3","0","1"),
("118559","Pow. bieszczadzki","118356","4","0","1"),
("118560","Pow. brzozowski","118356","5","0","1"),
("118561","Pow. dębicki","118356","6","0","1"),
("118562","Pow. jarosławski","118356","7","0","1"),
("118563","Pow. jasielski","118356","8","0","1"),
("118564","Pow. kolbuszowski","118356","9","0","1"),
("118565","Pow. krośnieński","118356","10","0","1"),
("118566","Pow. leski","118356","11","0","1"),
("118567","Pow. leżajski","118356","12","0","1"),
("118568","Pow. lubaczowski","118356","13","0","1"),
("118569","Pow. łańcucki","118356","14","0","1"),
("118570","Pow. mielecki","118356","15","0","1"),
("118571","Pow. niżański","118356","16","0","1"),
("118572","Pow. przemyski","118356","17","0","1"),
("118573","Pow. przeworski","118356","18","0","1"),
("118574","Pow. ropczycko-sędziszowski","118356","19","0","1"),
("118575","Pow. rzeszowski","118356","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118576","Pow. sanocki","118356","21","0","1"),
("118577","Pow. stalowowolski","118356","22","0","1"),
("118578","Pow. strzyżowski","118356","23","0","1"),
("118579","Pow. tarnobrzeski","118356","24","0","1"),
("118580","Białystok","118357","0","0","1"),
("118581","Łomża","118357","1","0","1"),
("118582","Suwałki","118357","2","0","1"),
("118583","Pow. augustowski","118357","3","0","1"),
("118584","Pow. białostocki","118357","4","0","1"),
("118585","Pow. bielski","118357","5","0","1"),
("118586","Pow. grajewski","118357","6","0","1"),
("118587","Pow. hajnowski","118357","7","0","1"),
("118588","Pow. kolneński","118357","8","0","1"),
("118589","Pow. łomżyński","118357","9","0","1"),
("118590","Pow. moniecki","118357","10","0","1"),
("118591","Pow. sejneński","118357","11","0","1"),
("118592","Pow. siemiatycki","118357","12","0","1"),
("118593","Pow. sokólski","118357","13","0","1"),
("118594","Pow. suwalski","118357","14","0","1"),
("118595","Pow. wysokomazowiecki","118357","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118596","Pow. zambrowski","118357","16","0","1"),
("118597","Gdańsk","118358","0","0","1"),
("118598","Gdynia","118358","1","0","1"),
("118599","Słupsk","118358","2","0","1"),
("118600","Sopot","118358","3","0","1"),
("118601","Pow. bytowski","118358","4","0","1"),
("118602","Pow. chojnicki","118358","5","0","1"),
("118603","Pow. człuchowski","118358","6","0","1"),
("118604","Pow. gdański","118358","7","0","1"),
("118605","Pow. kartuski","118358","8","0","1"),
("118606","Pow. kościerski","118358","9","0","1"),
("118607","Pow. kwidzyński","118358","10","0","1"),
("118608","Pow. lęborski","118358","11","0","1"),
("118609","Pow. malborski","118358","12","0","1"),
("118610","Pow. nowodworski","118358","13","0","1"),
("118611","Pow. pucki","118358","14","0","1"),
("118612","Pow. słupski","118358","15","0","1"),
("118613","Pow. starogardzki","118358","16","0","1"),
("118614","Pow. sztumski","118358","17","0","1"),
("118615","Pow. tczewski","118358","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118616","Pow. wejherowski","118358","19","0","1"),
("118617","Bielsko-Biała","118359","0","0","1"),
("118618","Bytom","118359","1","0","1"),
("118619","Chorzów","118359","2","0","1"),
("118620","Częstochowa","118359","3","0","1"),
("118621","Dąbrowa Górnicza","118359","4","0","1"),
("118622","Gliwice","118359","5","0","1"),
("118623","Jastrzębie-Zdrój","118359","6","0","1"),
("118624","Jaworzno","118359","7","0","1"),
("118625","Katowice","118359","8","0","1"),
("118626","Mysłowice","118359","9","0","1"),
("118627","Piekary Śląskie","118359","10","0","1"),
("118628","Ruda Śląska","118359","11","0","1"),
("118629","Rybnik","118359","12","0","1"),
("118630","Siemianowice Śląskie","118359","13","0","1"),
("118631","Sosnowiec","118359","14","0","1"),
("118632","Świętochłowice","118359","15","0","1"),
("118633","Tychy","118359","16","0","1"),
("118634","Zabrze","118359","17","0","1"),
("118635","Żory","118359","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118636","Pow. będziński","118359","19","0","1"),
("118637","Pow. bielski","118359","20","0","1"),
("118638","Pow. bieruńsko-lędziński","118359","21","0","1"),
("118639","Pow. cieszyński","118359","22","0","1"),
("118640","Pow. częstochowski","118359","23","0","1"),
("118641","Pow. gliwicki","118359","24","0","1"),
("118642","Pow. kłobucki","118359","25","0","1"),
("118643","Pow. lubliniecki","118359","26","0","1"),
("118644","Pow. mikołowski","118359","27","0","1"),
("118645","Pow. myszkowski","118359","28","0","1"),
("118646","Pow. pszczyński","118359","29","0","1"),
("118647","Pow. raciborski","118359","30","0","1"),
("118648","Pow. rybnicki","118359","31","0","1"),
("118649","Pow. tarnogórski","118359","32","0","1"),
("118650","Pow. wodzisławski","118359","33","0","1"),
("118651","Pow. zawierciański","118359","34","0","1"),
("118652","Pow. żywiecki","118359","35","0","1"),
("118653","Kielce","118360","0","0","1"),
("118654","Pow. buski","118360","1","0","1"),
("118655","Pow. jędrzejowski","118360","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118656","Pow. kazimierski","118360","3","0","1"),
("118657","Pow. kielecki","118360","4","0","1"),
("118658","Pow. konecki","118360","5","0","1"),
("118659","Pow. opatowski","118360","6","0","1"),
("118660","Pow. ostrowiecki","118360","7","0","1"),
("118661","Pow. pińczowski","118360","8","0","1"),
("118662","Pow. sandomierski","118360","9","0","1"),
("118663","Pow. skarżyski","118360","10","0","1"),
("118664","Pow. starachowicki","118360","11","0","1"),
("118665","Pow. staszowski","118360","12","0","1"),
("118666","Pow. włoszczowski","118360","13","0","1"),
("118667","Elbląg","118361","0","0","1"),
("118668","Olsztyn","118361","1","0","1"),
("118669","Pow. bartoszycki","118361","2","0","1"),
("118670","Pow. braniewski","118361","3","0","1"),
("118671","Pow. działdowski","118361","4","0","1"),
("118672","Pow. elbląski","118361","5","0","1"),
("118673","Pow. ełcki","118361","6","0","1"),
("118674","Pow. giżycki","118361","7","0","1"),
("118675","Pow. gołdapski","118361","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118676","Pow. iławski","118361","9","0","1"),
("118677","Pow. kętrzyński","118361","10","0","1"),
("118678","Pow. lidzbarski","118361","11","0","1"),
("118679","Pow. mrągowski","118361","12","0","1"),
("118680","Pow. nidzicki","118361","13","0","1"),
("118681","Pow. nowomiejski","118361","14","0","1"),
("118682","Pow. olecki","118361","15","0","1"),
("118683","Pow. olsztyński","118361","16","0","1"),
("118684","Pow. ostródzki","118361","17","0","1"),
("118685","Pow. piski","118361","18","0","1"),
("118686","Pow. szczycieński","118361","19","0","1"),
("118687","Pow. węgorzewski","118361","20","0","1"),
("118688","Kalisz","118362","0","0","1"),
("118689","Konin","118362","1","0","1"),
("118690","Leszno","118362","2","0","1"),
("118691","Poznań","118362","3","0","1"),
("118692","Pow. chodzieski","118362","4","0","1"),
("118693","Pow. czarnkowsko-trzcianecki","118362","5","0","1"),
("118694","Pow. gnieźnieński","118362","6","0","1"),
("118695","Pow. gostyński","118362","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118696","Pow. grodziski","118362","8","0","1"),
("118697","Pow. jarociński","118362","9","0","1"),
("118698","Pow. kaliski","118362","10","0","1"),
("118699","Pow. kępiński","118362","11","0","1"),
("118700","Pow. kolski","118362","12","0","1"),
("118701","Pow. koniński","118362","13","0","1"),
("118702","Pow. kościański","118362","14","0","1"),
("118703","Pow. krotoszyński","118362","15","0","1"),
("118704","Pow. leszczyński","118362","16","0","1"),
("118705","Pow. międzychodzki","118362","17","0","1"),
("118706","Pow. nowotomyski","118362","18","0","1"),
("118707","Pow. obornicki","118362","19","0","1"),
("118708","Pow. ostrowski","118362","20","0","1"),
("118709","Pow. ostrzeszowski","118362","21","0","1"),
("118710","Pow. pilski","118362","22","0","1"),
("118711","Pow. pleszewski","118362","23","0","1"),
("118712","Pow. poznański","118362","24","0","1"),
("118713","Pow. rawicki","118362","25","0","1"),
("118714","Pow. słupecki","118362","26","0","1"),
("118715","Pow. szamotulski","118362","27","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118716","Pow. średzki","118362","28","0","1"),
("118717","Pow. śremski","118362","29","0","1"),
("118718","Pow. turecki","118362","30","0","1"),
("118719","Pow. wągrowiecki","118362","31","0","1"),
("118720","Pow. wolsztyński","118362","32","0","1"),
("118721","Pow. wrzesiński","118362","33","0","1"),
("118722","Pow. złotowski","118362","34","0","1"),
("118723","Koszalin","118363","0","0","1"),
("118724","Szczecin","118363","1","0","1"),
("118725","Świnoujście","118363","2","0","1"),
("118726","Pow. białogardzki","118363","3","0","1"),
("118727","Pow. choszczeński","118363","4","0","1"),
("118728","Pow. drawski","118363","5","0","1"),
("118729","Pow. goleniowski","118363","6","0","1"),
("118730","Pow. gryficki","118363","7","0","1"),
("118731","Pow. gryfiński","118363","8","0","1"),
("118732","Pow. kamieński","118363","9","0","1"),
("118733","Pow. kołobrzeski","118363","10","0","1"),
("118734","Pow. koszaliński","118363","11","0","1"),
("118735","Pow. łobeski","118363","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118736","Pow. myśliborski","118363","13","0","1"),
("118737","Pow. policki","118363","14","0","1"),
("118738","Pow. pyrzycki","118363","15","0","1"),
("118739","Pow. sławieński","118363","16","0","1"),
("118740","Pow. stargardzki","118363","17","0","1"),
("118741","Pow. szczecinecki","118363","18","0","1"),
("118742","Pow. świdwiński","118363","19","0","1"),
("118743","Pow. wałecki","118363","20","0","1"),
("118744","Fabryczna","118367","0","0","1"),
("118745","Krzyki","118367","1","0","1"),
("118746","Psie Pole","118367","2","0","1"),
("118747","Stare Miasto","118367","3","0","1"),
("118748","Śródmieście","118367","4","0","1"),
("118749","Inne","118367","5","0","1"),
("118750","Bieńczyce","118479","0","0","1"),
("118751","Bieżanów-Prokocim","118479","1","0","1"),
("118752","Bronowice","118479","2","0","1"),
("118753","Czyżyny","118479","3","0","1"),
("118754","Dębniki","118479","4","0","1"),
("118755","Grzegórzki","118479","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118756","Krowodrza","118479","6","0","1"),
("118757","Łagiewniki","118479","7","0","1"),
("118758","Mistrzejowice","118479","8","0","1"),
("118759","Nowa Huta","118479","9","0","1"),
("118760","Podgórze","118479","10","0","1"),
("118761","Podgórze Duchackie","118479","11","0","1"),
("118762","Prądnik Biały","118479","12","0","1"),
("118763","Prądnik Czerwony","118479","13","0","1"),
("118764","Stare Miasto","118479","14","0","1"),
("118765","Swoszowice","118479","15","0","1"),
("118766","Wzgórza Krzesławickie","118479","16","0","1"),
("118767","Zwierzyniec","118479","17","0","1"),
("118768","Inne","118479","18","0","1"),
("118769","Bemowo","118505","0","0","1"),
("118770","Białołęka","118505","1","0","1"),
("118771","Bielany","118505","2","0","1"),
("118772","Mokotów","118505","3","0","1"),
("118773","Ochota","118505","4","0","1"),
("118774","Praga Południe","118505","5","0","1"),
("118775","Praga Północ","118505","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118776","Rembertów","118505","7","0","1"),
("118777","Śródmieście","118505","8","0","1"),
("118778","Targówek","118505","9","0","1"),
("118779","Ursus","118505","10","0","1"),
("118780","Ursynów","118505","11","0","1"),
("118781","Wawer","118505","12","0","1"),
("118782","Wesoła","118505","13","0","1"),
("118783","Wilanów","118505","14","0","1"),
("118784","Włochy","118505","15","0","1"),
("118785","Wola","118505","16","0","1"),
("118786","Żoliborz","118505","17","0","1"),
("118787","Inne","118505","18","0","1"),
("118788","Dolnośląskie","112748","0","0","0"),
("118789","Kujawsko-pomorskie","112748","1","0","0"),
("118790","Lubelskie","112748","2","0","0"),
("118791","Lubuskie","112748","3","0","0"),
("118792","Łódzkie","112748","4","0","0"),
("118793","Małopolskie","112748","5","0","0"),
("118794","Mazowieckie","112748","6","0","0"),
("118795","Opolskie","112748","7","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118796","Podkarpackie","112748","8","0","0"),
("118797","Podlaskie","112748","9","0","0"),
("118798","Pomorskie","112748","10","0","0"),
("118799","Śląskie","112748","11","0","0"),
("118800","Świętokrzyskie","112748","12","0","0"),
("118801","Warmińsko-mazurskie","112748","13","0","0"),
("118802","Wielkopolskie","112748","14","0","0"),
("118803","Zachodniopomorskie","112748","15","0","0"),
("118804","Jelenia Góra","118788","0","0","0"),
("118805","Legnica","118788","1","0","1"),
("118806","Wałbrzych","118788","2","0","1"),
("118807","Wrocław","118788","3","0","0"),
("118808","Pow. bolesławiecki","118788","4","0","1"),
("118809","Pow. dzierżoniowski","118788","5","0","1"),
("118810","Pow. głogowski","118788","6","0","1"),
("118811","Pow. górowski","118788","7","0","1"),
("118812","Pow. jaworski","118788","8","0","1"),
("118813","Pow. jeleniogórski","118788","9","0","1"),
("118814","Pow. kamiennogórski","118788","10","0","1"),
("118815","Pow. kłodzki","118788","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118816","Pow. legnicki","118788","12","0","1"),
("118817","Pow. lubański","118788","13","0","1"),
("118818","Pow. lubiński","118788","14","0","1"),
("118819","Pow. lwówecki","118788","15","0","1"),
("118820","Pow. milicki","118788","16","0","1"),
("118821","Pow. oleśnicki","118788","17","0","1"),
("118822","Pow. oławski","118788","18","0","1"),
("118823","Pow. polkowicki","118788","19","0","1"),
("118824","Pow. strzeliński","118788","20","0","1"),
("118825","Pow. średzki","118788","21","0","1"),
("118826","Pow. świdnicki","118788","22","0","1"),
("118827","Pow. trzebnicki","118788","23","0","1"),
("118828","Pow. wałbrzyski","118788","24","0","1"),
("118829","Pow. wołowski","118788","25","0","1"),
("118830","Pow. wrocławski","118788","26","0","1"),
("118831","Pow. ząbkowicki","118788","27","0","1"),
("118832","Pow. zgorzelecki","118788","28","0","1"),
("118833","Pow. złotoryjski","118788","29","0","1"),
("118834","Bydgoszcz","118789","0","0","0"),
("118835","Grudziądz","118789","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118836","Toruń","118789","2","0","0"),
("118837","Włocławek","118789","3","0","1"),
("118838","Pow. aleksandrowski","118789","4","0","1"),
("118839","Pow. brodnicki","118789","5","0","1"),
("118840","Pow. bydgoski","118789","6","0","1"),
("118841","Pow. chełmiński","118789","7","0","1"),
("118842","Pow. golubsko-dobrzyński","118789","8","0","1"),
("118843","Pow. grudziądzki","118789","9","0","1"),
("118844","Pow. inowrocławski","118789","10","0","1"),
("118845","Pow. lipnowski","118789","11","0","1"),
("118846","Pow. mogileński","118789","12","0","1"),
("118847","Pow. nakielski","118789","13","0","1"),
("118848","Pow. radziejowski","118789","14","0","1"),
("118849","Pow. rypiński","118789","15","0","1"),
("118850","Pow. sępoleński","118789","16","0","1"),
("118851","Pow. świecki","118789","17","0","1"),
("118852","Pow. toruński","118789","18","0","1"),
("118853","Pow. tucholski","118789","19","0","1"),
("118854","Pow. wąbrzeski","118789","20","0","1"),
("118855","Pow. włocławski","118789","21","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118856","Pow. żniński","118789","22","0","1"),
("118857","Biała Podlaska","118790","0","0","1"),
("118858","Chełm","118790","1","0","1"),
("118859","Lublin","118790","2","0","0"),
("118860","Zamość","118790","3","0","1"),
("118861","Pow. bialski","118790","4","0","1"),
("118862","Pow. biłgorajski","118790","5","0","1"),
("118863","Pow. chełmski","118790","6","0","1"),
("118864","Pow. hrubieszowski","118790","7","0","1"),
("118865","Pow. janowski","118790","8","0","1"),
("118866","Pow. krasnostawski","118790","9","0","1"),
("118867","Pow. kraśnicki","118790","10","0","1"),
("118868","Pow. lubartowski","118790","11","0","1"),
("118869","Pow. lubelski","118790","12","0","1"),
("118870","Pow. łęczyński","118790","13","0","1"),
("118871","Pow. łukowski","118790","14","0","1"),
("118872","Pow. opolski","118790","15","0","1"),
("118873","Pow. parczewski","118790","16","0","1"),
("118874","Pow. puławski","118790","17","0","1"),
("118875","Pow. radzyński","118790","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118876","Pow. rycki","118790","19","0","1"),
("118877","Pow. świdnicki","118790","20","0","1"),
("118878","Pow. tomaszowski","118790","21","0","1"),
("118879","Pow. włodawski","118790","22","0","1"),
("118880","Pow. zamojski","118790","23","0","1"),
("118881","Gorzów Wielkopolski","118791","0","0","1"),
("118882","Zielona Góra","118791","1","0","1"),
("118883","Pow. gorzowski","118791","2","0","1"),
("118884","Pow. krośnieński","118791","3","0","1"),
("118885","Pow. międzyrzecki","118791","4","0","1"),
("118886","Pow. nowosolski","118791","5","0","1"),
("118887","Pow. słubicki","118791","6","0","1"),
("118888","Pow. strzelecko-drezdenecki","118791","7","0","1"),
("118889","Pow. sulęciński","118791","8","0","1"),
("118890","Pow. świebodziński","118791","9","0","1"),
("118891","Pow. wschowski","118791","10","0","1"),
("118892","Pow. zielonogórski","118791","11","0","1"),
("118893","Pow. żagański","118791","12","0","1"),
("118894","Pow. żarski","118791","13","0","1"),
("118895","Łódź","118792","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118896","Piotrków Trybunalski","118792","1","0","1"),
("118897","Skierniewice","118792","2","0","1"),
("118898","Pow. bełchatowski","118792","3","0","1"),
("118899","Pow. brzeziński","118792","4","0","1"),
("118900","Pow. kutnowski","118792","5","0","1"),
("118901","Pow. łaski","118792","6","0","1"),
("118902","Pow. łęczycki","118792","7","0","1"),
("118903","Pow. łowicki","118792","8","0","1"),
("118904","Pow. łódzki wschodni","118792","9","0","1"),
("118905","Pow. opoczyński","118792","10","0","1"),
("118906","Pow. pabianicki","118792","11","0","1"),
("118907","Pow. pajęczański","118792","12","0","1"),
("118908","Pow. piotrkowski","118792","13","0","1"),
("118909","Pow. poddębicki","118792","14","0","1"),
("118910","Pow. radomszczański","118792","15","0","1"),
("118911","Pow. rawski","118792","16","0","1"),
("118912","Pow. sieradzki","118792","17","0","1"),
("118913","Pow. skierniewicki","118792","18","0","1"),
("118914","Pow. tomaszowski","118792","19","0","1"),
("118915","Pow. wieluński","118792","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118916","Pow. wieruszowski","118792","21","0","1"),
("118917","Pow. zduńskowolski","118792","22","0","1"),
("118918","Pow. zgierski","118792","23","0","1"),
("118919","Kraków","118793","0","0","0"),
("118920","Nowy Sącz","118793","1","0","1"),
("118921","Tarnów","118793","2","0","1"),
("118922","Pow. bocheński","118793","3","0","1"),
("118923","Pow. brzeski","118793","4","0","1"),
("118924","Pow. chrzanowski","118793","5","0","1"),
("118925","Pow. dąbrowski","118793","6","0","1"),
("118926","Pow. gorlicki","118793","7","0","1"),
("118927","Pow. krakowski","118793","8","0","1"),
("118928","Pow. limanowski","118793","9","0","1"),
("118929","Pow. miechowski","118793","10","0","1"),
("118930","Pow. myślenicki","118793","11","0","1"),
("118931","Pow. nowosądecki","118793","12","0","1"),
("118932","Pow. nowotarski","118793","13","0","1"),
("118933","Pow. olkuski","118793","14","0","1"),
("118934","Pow. oświęcimski","118793","15","0","1"),
("118935","Pow. proszowicki","118793","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118936","Pow. suski","118793","17","0","1"),
("118937","Pow. tarnowski","118793","18","0","1"),
("118938","Pow. tatrzański","118793","19","0","1"),
("118939","Pow. wadowicki","118793","20","0","1"),
("118940","Pow. wielicki","118793","21","0","1"),
("118941","Ostrołęka","118794","0","0","1"),
("118942","Płock","118794","1","0","1"),
("118943","Radom","118794","2","0","1"),
("118944","Siedlce","118794","3","0","1"),
("118945","Warszawa","118794","4","0","0"),
("118946","Pow. białobrzeski","118794","5","0","1"),
("118947","Pow. ciechanowski","118794","6","0","1"),
("118948","Pow. garwoliński","118794","7","0","1"),
("118949","Pow. gostyniński","118794","8","0","1"),
("118950","Pow. grójecki","118794","9","0","1"),
("118951","Pow. grodziski","118794","10","0","1"),
("118952","Pow. kozienicki","118794","11","0","1"),
("118953","Pow. legionowski","118794","12","0","1"),
("118954","Pow. lipski","118794","13","0","1"),
("118955","Pow. łosicki","118794","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118956","Pow. makowski","118794","15","0","1"),
("118957","Pow. miński","118794","16","0","1"),
("118958","Pow. mławski","118794","17","0","1"),
("118959","Pow. nowodworski","118794","18","0","1"),
("118960","Pow. ostrołęcki","118794","19","0","1"),
("118961","Pow. ostrowski","118794","20","0","1"),
("118962","Pow. otwocki","118794","21","0","1"),
("118963","Pow. piaseczyński","118794","22","0","0"),
("118964","Pow. płocki","118794","23","0","1"),
("118965","Pow. płoński","118794","24","0","1"),
("118966","Pow. pruszkowski","118794","25","0","0"),
("118967","Pow. przasnyski","118794","26","0","1"),
("118968","Pow. przysuski","118794","27","0","1"),
("118969","Pow. pułtuski","118794","28","0","1"),
("118970","Pow. radomski","118794","29","0","1"),
("118971","Pow. siedlecki","118794","30","0","1"),
("118972","Pow. sierpecki","118794","31","0","1"),
("118973","Pow. sochaczewski","118794","32","0","1"),
("118974","Pow. sokołowski","118794","33","0","1"),
("118975","Pow. szydłowiecki","118794","34","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118976","Pow. warszawski zachodni","118794","35","0","1"),
("118977","Pow. węgrowski","118794","36","0","1"),
("118978","Pow. wołomiński","118794","37","0","0"),
("118979","Pow. wyszkowski","118794","38","0","1"),
("118980","pow. zwoleński","118794","39","0","1"),
("118981","Pow. żuromiński","118794","40","0","1"),
("118982","Pow. żyrardowski","118794","41","0","1"),
("118983","Opole","118795","0","0","0"),
("118984","Pow. brzeski","118795","1","0","1"),
("118985","Pow. głubczycki","118795","2","0","1"),
("118986","Pow. kędzierzyńsko-kozielski","118795","3","0","1"),
("118987","Pow. kluczborski","118795","4","0","1"),
("118988","Pow. krapkowicki","118795","5","0","1"),
("118989","Pow. namysłowski","118795","6","0","1"),
("118990","Pow. nyski","118795","7","0","1"),
("118991","Pow. oleski","118795","8","0","1"),
("118992","Pow. opolski","118795","9","0","1"),
("118993","Pow. prudnicki","118795","10","0","1"),
("118994","Pow. strzelecki","118795","11","0","1"),
("118995","Krosno","118796","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("118996","Przemyśl","118796","1","0","1"),
("118997","Rzeszów","118796","2","0","0"),
("118998","Tarnobrzeg","118796","3","0","1"),
("118999","Pow. bieszczadzki","118796","4","0","1"),
("119000","Pow. brzozowski","118796","5","0","1"),
("119001","Pow. dębicki","118796","6","0","1"),
("119002","Pow. jarosławski","118796","7","0","1"),
("119003","Pow. jasielski","118796","8","0","1"),
("119004","Pow. kolbuszowski","118796","9","0","1"),
("119005","Pow. krośnieński","118796","10","0","1"),
("119006","Pow. leski","118796","11","0","1"),
("119007","Pow. leżajski","118796","12","0","1"),
("119008","Pow. lubaczowski","118796","13","0","1"),
("119009","Pow. łańcucki","118796","14","0","1"),
("119010","Pow. mielecki","118796","15","0","1"),
("119011","Pow. niżański","118796","16","0","1"),
("119012","Pow. przemyski","118796","17","0","1"),
("119013","Pow. przeworski","118796","18","0","1"),
("119014","Pow. ropczycko-sędziszowski","118796","19","0","1"),
("119015","Pow. rzeszowski","118796","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119016","Pow. sanocki","118796","21","0","1"),
("119017","Pow. stalowowolski","118796","22","0","1"),
("119018","Pow. strzyżowski","118796","23","0","1"),
("119019","Pow. tarnobrzeski","118796","24","0","1"),
("119020","Białystok","118797","0","0","0"),
("119021","Łomża","118797","1","0","1"),
("119022","Suwałki","118797","2","0","1"),
("119023","Pow. augustowski","118797","3","0","1"),
("119024","Pow. białostocki","118797","4","0","1"),
("119025","Pow. bielski","118797","5","0","1"),
("119026","Pow. grajewski","118797","6","0","1"),
("119027","Pow. hajnowski","118797","7","0","1"),
("119028","Pow. kolneński","118797","8","0","1"),
("119029","Pow. łomżyński","118797","9","0","1"),
("119030","Pow. moniecki","118797","10","0","1"),
("119031","Pow. sejneński","118797","11","0","1"),
("119032","Pow. siemiatycki","118797","12","0","1"),
("119033","Pow. sokólski","118797","13","0","1"),
("119034","Pow. suwalski","118797","14","0","1"),
("119035","Pow. wysokomazowiecki","118797","15","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119036","Pow. zambrowski","118797","16","0","1"),
("119037","Gdańsk","118798","0","0","0"),
("119038","Gdynia","118798","1","0","0"),
("119039","Słupsk","118798","2","0","1"),
("119040","Sopot","118798","3","0","0"),
("119041","Pow. bytowski","118798","4","0","1"),
("119042","Pow. chojnicki","118798","5","0","1"),
("119043","Pow. człuchowski","118798","6","0","1"),
("119044","Pow. gdański","118798","7","0","1"),
("119045","Pow. kartuski","118798","8","0","1"),
("119046","Pow. kościerski","118798","9","0","1"),
("119047","Pow. kwidzyński","118798","10","0","1"),
("119048","Pow. lęborski","118798","11","0","1"),
("119049","Pow. malborski","118798","12","0","1"),
("119050","Pow. nowodworski","118798","13","0","1"),
("119051","Pow. pucki","118798","14","0","1"),
("119052","Pow. słupski","118798","15","0","1"),
("119053","Pow. starogardzki","118798","16","0","1"),
("119054","Pow. sztumski","118798","17","0","1"),
("119055","Pow. tczewski","118798","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119056","Pow. wejherowski","118798","19","0","0"),
("119057","Bielsko-Biała","118799","0","0","0"),
("119058","Bytom","118799","1","0","0"),
("119059","Chorzów","118799","2","0","1"),
("119060","Częstochowa","118799","3","0","0"),
("119061","Dąbrowa Górnicza","118799","4","0","1"),
("119062","Gliwice","118799","5","0","0"),
("119063","Jastrzębie-Zdrój","118799","6","0","1"),
("119064","Jaworzno","118799","7","0","1"),
("119065","Katowice","118799","8","0","0"),
("119066","Mysłowice","118799","9","0","1"),
("119067","Piekary Śląskie","118799","10","0","1"),
("119068","Ruda Śląska","118799","11","0","1"),
("119069","Rybnik","118799","12","0","1"),
("119070","Siemianowice Śląskie","118799","13","0","1"),
("119071","Sosnowiec","118799","14","0","0"),
("119072","Świętochłowice","118799","15","0","1"),
("119073","Tychy","118799","16","0","0"),
("119074","Zabrze","118799","17","0","1"),
("119075","Żory","118799","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119076","Pow. będziński","118799","19","0","1"),
("119077","Pow. bielski","118799","20","0","1"),
("119078","Pow. bieruńsko-lędziński","118799","21","0","1"),
("119079","Pow. cieszyński","118799","22","0","1"),
("119080","Pow. częstochowski","118799","23","0","1"),
("119081","Pow. gliwicki","118799","24","0","1"),
("119082","Pow. kłobucki","118799","25","0","1"),
("119083","Pow. lubliniecki","118799","26","0","1"),
("119084","Pow. mikołowski","118799","27","0","1"),
("119085","Pow. myszkowski","118799","28","0","1"),
("119086","Pow. pszczyński","118799","29","0","1"),
("119087","Pow. raciborski","118799","30","0","1"),
("119088","Pow. rybnicki","118799","31","0","1"),
("119089","Pow. tarnogórski","118799","32","0","1"),
("119090","Pow. wodzisławski","118799","33","0","1"),
("119091","Pow. zawierciański","118799","34","0","1"),
("119092","Pow. żywiecki","118799","35","0","1"),
("119093","Kielce","118800","0","0","1"),
("119094","Pow. buski","118800","1","0","1"),
("119095","Pow. jędrzejowski","118800","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119096","Pow. kazimierski","118800","3","0","1"),
("119097","Pow. kielecki","118800","4","0","1"),
("119098","Pow. konecki","118800","5","0","1"),
("119099","Pow. opatowski","118800","6","0","1"),
("119100","Pow. ostrowiecki","118800","7","0","1"),
("119101","Pow. pińczowski","118800","8","0","1"),
("119102","Pow. sandomierski","118800","9","0","1"),
("119103","Pow. skarżyski","118800","10","0","1"),
("119104","Pow. starachowicki","118800","11","0","1"),
("119105","Pow. staszowski","118800","12","0","1"),
("119106","Pow. włoszczowski","118800","13","0","1"),
("119107","Elbląg","118801","0","0","1"),
("119108","Olsztyn","118801","1","0","1"),
("119109","Pow. bartoszycki","118801","2","0","1"),
("119110","Pow. braniewski","118801","3","0","1"),
("119111","Pow. działdowski","118801","4","0","1"),
("119112","Pow. elbląski","118801","5","0","1"),
("119113","Pow. ełcki","118801","6","0","1"),
("119114","Pow. giżycki","118801","7","0","1"),
("119115","Pow. gołdapski","118801","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119116","Pow. iławski","118801","9","0","1"),
("119117","Pow. kętrzyński","118801","10","0","1"),
("119118","Pow. lidzbarski","118801","11","0","1"),
("119119","Pow. mrągowski","118801","12","0","1"),
("119120","Pow. nidzicki","118801","13","0","1"),
("119121","Pow. nowomiejski","118801","14","0","1"),
("119122","Pow. olecki","118801","15","0","1"),
("119123","Pow. olsztyński","118801","16","0","1"),
("119124","Pow. ostródzki","118801","17","0","1"),
("119125","Pow. piski","118801","18","0","1"),
("119126","Pow. szczycieński","118801","19","0","1"),
("119127","Pow. węgorzewski","118801","20","0","1"),
("119128","Kalisz","118802","0","0","1"),
("119129","Konin","118802","1","0","1"),
("119130","Leszno","118802","2","0","1"),
("119131","Poznań","118802","3","0","0"),
("119132","Pow. chodzieski","118802","4","0","1"),
("119133","Pow. czarnkowsko-trzcianecki","118802","5","0","1"),
("119134","Pow. gnieźnieński","118802","6","0","1"),
("119135","Pow. gostyński","118802","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119136","Pow. grodziski","118802","8","0","1"),
("119137","Pow. jarociński","118802","9","0","1"),
("119138","Pow. kaliski","118802","10","0","1"),
("119139","Pow. kępiński","118802","11","0","1"),
("119140","Pow. kolski","118802","12","0","1"),
("119141","Pow. koniński","118802","13","0","1"),
("119142","Pow. kościański","118802","14","0","1"),
("119143","Pow. krotoszyński","118802","15","0","1"),
("119144","Pow. leszczyński","118802","16","0","1"),
("119145","Pow. międzychodzki","118802","17","0","1"),
("119146","Pow. nowotomyski","118802","18","0","1"),
("119147","Pow. obornicki","118802","19","0","1"),
("119148","Pow. ostrowski","118802","20","0","1"),
("119149","Pow. ostrzeszowski","118802","21","0","1"),
("119150","Pow. pilski","118802","22","0","1"),
("119151","Pow. pleszewski","118802","23","0","1"),
("119152","Pow. poznański","118802","24","0","1"),
("119153","Pow. rawicki","118802","25","0","1"),
("119154","Pow. słupecki","118802","26","0","1"),
("119155","Pow. szamotulski","118802","27","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119156","Pow. średzki","118802","28","0","1"),
("119157","Pow. śremski","118802","29","0","1"),
("119158","Pow. turecki","118802","30","0","1"),
("119159","Pow. wągrowiecki","118802","31","0","1"),
("119160","Pow. wolsztyński","118802","32","0","1"),
("119161","Pow. wrzesiński","118802","33","0","1"),
("119162","Pow. złotowski","118802","34","0","1"),
("119163","Koszalin","118803","0","0","0"),
("119164","Szczecin","118803","1","0","0"),
("119165","Świnoujście","118803","2","0","1"),
("119166","Pow. białogardzki","118803","3","0","1"),
("119167","Pow. choszczeński","118803","4","0","1"),
("119168","Pow. drawski","118803","5","0","1"),
("119169","Pow. goleniowski","118803","6","0","1"),
("119170","Pow. gryficki","118803","7","0","1"),
("119171","Pow. gryfiński","118803","8","0","1"),
("119172","Pow. kamieński","118803","9","0","1"),
("119173","Pow. kołobrzeski","118803","10","0","1"),
("119174","Pow. koszaliński","118803","11","0","1"),
("119175","Pow. łobeski","118803","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119176","Pow. myśliborski","118803","13","0","1"),
("119177","Pow. policki","118803","14","0","1"),
("119178","Pow. pyrzycki","118803","15","0","1"),
("119179","Pow. sławieński","118803","16","0","1"),
("119180","Pow. stargardzki","118803","17","0","1"),
("119181","Pow. szczecinecki","118803","18","0","1"),
("119182","Pow. świdwiński","118803","19","0","1"),
("119183","Pow. wałecki","118803","20","0","1"),
("119184","Cieplice Śląskie-Zdrój","118804","0","0","1"),
("119185","Czarne","118804","1","0","1"),
("119186","Dąbrówka","118804","2","0","1"),
("119187","Goduszyn","118804","3","0","1"),
("119188","Grabary","118804","4","0","1"),
("119189","Jagniątków","118804","5","0","1"),
("119190","Maciejowa","118804","6","0","1"),
("119191","Paulinów","118804","7","0","1"),
("119192","Sobieszów","118804","8","0","1"),
("119193","Strupice","118804","9","0","1"),
("119194","Zabobrze","118804","10","0","1"),
("119195","Pozostałe","118804","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119196","Fabryczna","118807","0","0","1"),
("119197","Krzyki","118807","1","0","1"),
("119198","Psie Pole","118807","2","0","1"),
("119199","Stare Miasto","118807","3","0","1"),
("119200","Śródmieście","118807","4","0","1"),
("119201","Inne","118807","5","0","1"),
("119202","Bartodzieje Małe","118834","0","0","1"),
("119203","Bartodzieje Wielkie","118834","1","0","1"),
("119204","Bielawy","118834","2","0","1"),
("119205","Błonie","118834","3","0","1"),
("119206","Bocianowo","118834","4","0","1"),
("119207","Czyżkówko","118834","5","0","1"),
("119208","Fordon","118834","6","0","1"),
("119209","Górzyskowo","118834","7","0","1"),
("119210","Kapuściska","118834","8","0","1"),
("119211","Okole","118834","9","0","1"),
("119212","Osiedle Leśne","118834","10","0","1"),
("119213","Osowa Góra","118834","11","0","1"),
("119214","Skrzetusko","118834","12","0","1"),
("119215","Szwederowo","118834","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119216","Wilczak","118834","14","0","1"),
("119217","Pozostałe","118834","15","0","1"),
("119218","Bielany","118836","0","0","1"),
("119219","Bielawy","118836","1","0","1"),
("119220","Bydgoskie Przedmieście","118836","2","0","1"),
("119221","Chełmińskie Przedmieście","118836","3","0","1"),
("119222","Jakubskie Przedmieście","118836","4","0","1"),
("119223","Koniuchy","118836","5","0","1"),
("119224","Mokre","118836","6","0","1"),
("119225","Na Skarpie","118836","7","0","1"),
("119226","Podgórz","118836","8","0","1"),
("119227","Rubinkowo","118836","9","0","1"),
("119228","Rudak","118836","10","0","1"),
("119229","Rybaki","118836","11","0","1"),
("119230","Stare Miasto","118836","12","0","1"),
("119231","Stawki","118836","13","0","1"),
("119232","Wrzosy","118836","14","0","1"),
("119233","Pozostałe","118836","15","0","1"),
("119234","Bazylianówka","118859","0","0","1"),
("119235","Bronowice","118859","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119236","Czechów Górny","118859","2","0","1"),
("119237","Czuby","118859","3","0","1"),
("119238","Dziesiąta","118859","4","0","1"),
("119239","Felin","118859","5","0","1"),
("119240","Kalinowszczyzna","118859","6","0","1"),
("119241","Rudnik","118859","7","0","1"),
("119242","Sławinek","118859","8","0","1"),
("119243","Śródmieście","118859","9","0","1"),
("119244","Tatary","118859","10","0","1"),
("119245","Węglin","118859","11","0","1"),
("119246","Wieniawka","118859","12","0","1"),
("119247","Wrotków","118859","13","0","1"),
("119248","Pozostałe","118859","14","0","1"),
("119249","Bałuty","118895","0","0","1"),
("119250","Górna","118895","1","0","1"),
("119251","Polesie","118895","2","0","1"),
("119252","Śródmieście","118895","3","0","1"),
("119253","Widzew","118895","4","0","1"),
("119254","Pozostałe","118895","5","0","1"),
("119255","Krowodrza","118919","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119256","Nowa Huta","118919","1","0","1"),
("119257","Podgórze","118919","2","0","1"),
("119258","Stare Miasto","118919","3","0","1"),
("119259","Śródmieście ","118919","4","0","1"),
("119260","Pozostałe","118919","5","0","1"),
("119261","Bemowo","118945","0","0","1"),
("119262","Białołęka","118945","1","0","1"),
("119263","Bielany","118945","2","0","1"),
("119264","Mokotów","118945","3","0","1"),
("119265","Ochota","118945","4","0","1"),
("119266","Praga Południe","118945","5","0","1"),
("119267","Praga Północ","118945","6","0","1"),
("119268","Rembertów","118945","7","0","1"),
("119269","Śródmieście","118945","8","0","1"),
("119270","Targówek","118945","9","0","1"),
("119271","Ursus","118945","10","0","1"),
("119272","Ursynów","118945","11","0","1"),
("119273","Wawer","118945","12","0","1"),
("119274","Wesoła","118945","13","0","1"),
("119275","Wilanów","118945","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119276","Włochy","118945","15","0","1"),
("119277","Wola","118945","16","0","1"),
("119278","Żoliborz","118945","17","0","1"),
("119279","Inne","118945","18","0","1"),
("119280","Góra Kalwaria","118963","0","0","1"),
("119281","Konstancin-Jeziorna","118963","1","0","1"),
("119282","Piaseczno","118963","2","0","1"),
("119283","Tarczyn","118963","3","0","1"),
("119284","Pozostałe","118963","4","0","1"),
("119285","Brwinów","118966","0","0","1"),
("119286","Piastów","118966","1","0","1"),
("119287","Pruszków","118966","2","0","1"),
("119288","Pozostałe","118966","3","0","1"),
("119289","Kobyłka","118978","0","0","1"),
("119290","Marki","118978","1","0","1"),
("119291","Radzymin","118978","2","0","1"),
("119292","Tłuszcz","118978","3","0","1"),
("119293","Wołomin","118978","4","0","1"),
("119294","Ząbki","118978","5","0","1"),
("119295","Zielonka","118978","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119296","Pozostałe","118978","7","0","1"),
("119297","Bierkowice","118983","0","0","1"),
("119298","Gosławice","118983","1","0","1"),
("119299","Groszowice","118983","2","0","1"),
("119300","Grudzice","118983","3","0","1"),
("119301","Kolonia Gosławicka","118983","4","0","1"),
("119302","Malina","118983","5","0","1"),
("119303","Nowa Wieś Królewska","118983","6","0","1"),
("119304","Półwieś","118983","7","0","1"),
("119305","Szczepanowice","118983","8","0","1"),
("119306","Wójtowa Wieś","118983","9","0","1"),
("119307","Wróblin","118983","10","0","1"),
("119308","Zakrzów","118983","11","0","1"),
("119309","Zaodrze","118983","12","0","1"),
("119310","Pozostałe","118983","13","0","1"),
("119311","Drabinianka","118997","0","0","1"),
("119312","Dworzysko","118997","1","0","1"),
("119313","Miłocin","118997","2","0","1"),
("119314","Pobitno","118997","3","0","1"),
("119315","Przybyszówka","118997","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119316","Słocina","118997","5","0","1"),
("119317","Staromieście","118997","6","0","1"),
("119318","Staroniwa","118997","7","0","1"),
("119319","Szajerówka","118997","8","0","1"),
("119320","Wilkowyja","118997","9","0","1"),
("119321","Zalesie","118997","10","0","1"),
("119322","Załęże","118997","11","0","1"),
("119323","Zwięczyca","118997","12","0","1"),
("119324","Pozostałe","118997","13","0","1"),
("119325","Antoniuk","119020","0","0","1"),
("119326","Bacieczki","119020","1","0","1"),
("119327","Białostoczek","119020","2","0","1"),
("119328","Bojary","119020","3","0","1"),
("119329","Dojlidy","119020","4","0","1"),
("119330","Dojlidy Górne","119020","5","0","1"),
("119331","Dziesięciny","119020","6","0","1"),
("119332","Nowe Miasto","119020","7","0","1"),
("119333","Skorupy","119020","8","0","1"),
("119334","Słoboda","119020","9","0","1"),
("119335","Starosielce","119020","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119336","Wygoda","119020","11","0","1"),
("119337","Wysoki Stoczek","119020","12","0","1"),
("119338","Zagórki","119020","13","0","1"),
("119339","Zawady","119020","14","0","1"),
("119340","Pozostałe","119020","15","0","1"),
("119341","Brzeźno","119037","0","0","1"),
("119342","Chełm","119037","1","0","1"),
("119343","Jasień","119037","2","0","1"),
("119344","Kiełpino Górne","119037","3","0","1"),
("119345","Kokoszki","119037","4","0","1"),
("119346","Lipce","119037","5","0","1"),
("119347","Łostowice","119037","6","0","1"),
("119348","Oliwa","119037","7","0","1"),
("119349","Osowa","119037","8","0","1"),
("119350","Przymorze","119037","9","0","1"),
("119351","Siedlce","119037","10","0","1"),
("119352","Sobieszewo","119037","11","0","1"),
("119353","Suchanino","119037","12","0","1"),
("119354","Wrzeszcz","119037","13","0","1"),
("119355","Zakoniczyn","119037","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119356","Pozostałe","119037","15","0","1"),
("119357","Chwarzno","119038","0","0","1"),
("119358","Chylonia","119038","1","0","1"),
("119359","Cisowa","119038","2","0","1"),
("119360","Działki Leśne","119038","3","0","1"),
("119361","Kamienna Góra","119038","4","0","1"),
("119362","Leszczynki","119038","5","0","1"),
("119363","Mały Kack","119038","6","0","1"),
("119364","Obłuże","119038","7","0","1"),
("119365","Oksywie","119038","8","0","1"),
("119366","Orłowo","119038","9","0","1"),
("119367","Pogórze","119038","10","0","1"),
("119368","Redłowo","119038","11","0","1"),
("119369","Wiczlino","119038","12","0","1"),
("119370","Wielki Kack","119038","13","0","1"),
("119371","Wzgórze Nowotki","119038","14","0","1"),
("119372","Pozostałe","119038","15","0","1"),
("119373","Brodwino","119040","0","0","1"),
("119374","Kamienny Potok","119040","1","0","1"),
("119375","Przylesie","119040","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119376","Sopot Dolny","119040","3","0","1"),
("119377","Sopot Górny","119040","4","0","1"),
("119378","Wyścigi","119040","5","0","1"),
("119379","Pozostałe","119040","6","0","1"),
("119380","Reda","119056","0","0","1"),
("119381","Rumia","119056","1","0","1"),
("119382","Wejherowo","119056","2","0","1"),
("119383","Pozostałe","119056","3","0","1"),
("119384","Aleksandrowice","119057","0","0","1"),
("119385","Hałcnów","119057","1","0","1"),
("119386","Kamienica","119057","2","0","1"),
("119387","Komorowice Krakowskie","119057","3","0","1"),
("119388","Komorowice Śląskie","119057","4","0","1"),
("119389","Leszczyny","119057","5","0","1"),
("119390","Lipnik","119057","6","0","1"),
("119391","Mikuszowice Krakowskie","119057","7","0","1"),
("119392","Mikuszowice Śląskie","119057","8","0","1"),
("119393","Olszówka Dolna","119057","9","0","1"),
("119394","Olszówka Górna","119057","10","0","1"),
("119395","Stare Bielsko","119057","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119396","Straconka","119057","12","0","1"),
("119397","Wapienica","119057","13","0","1"),
("119398","Złote Łany","119057","14","0","1"),
("119399","Pozostałe","119057","15","0","1"),
("119400","Bobrek","119058","0","0","1"),
("119401","Górniki","119058","1","0","1"),
("119402","Karb","119058","2","0","1"),
("119403","Łagiewniki","119058","3","0","1"),
("119404","Miechowice","119058","4","0","1"),
("119405","Rozbark","119058","5","0","1"),
("119406","Stolarzowice","119058","6","0","1"),
("119407","Stroszek","119058","7","0","1"),
("119408","Sucha Góra","119058","8","0","1"),
("119409","Szombierki","119058","9","0","1"),
("119410","Pozostałe","119058","10","0","1"),
("119411","Błeszno","119060","0","0","1"),
("119412","Dźbów","119060","1","0","1"),
("119413","Grabówka","119060","2","0","1"),
("119414","Kawodrza Dolna","119060","3","0","1"),
("119415","Lisiniec","119060","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119416","Liszka Dolna","119060","5","0","1"),
("119417","Mirów","119060","6","0","1"),
("119418","Ostatni Grosz","119060","7","0","1"),
("119419","Parkitka","119060","8","0","1"),
("119420","Raków","119060","9","0","1"),
("119421","Rząsawy","119060","10","0","1"),
("119422","Sabinów","119060","11","0","1"),
("119423","Stradom","119060","12","0","1"),
("119424","Wrzosowiak","119060","13","0","1"),
("119425","Zawodzie","119060","14","0","1"),
("119426","Pozostałe","119060","15","0","1"),
("119427","Bojków","119062","0","0","1"),
("119428","Brzezinka","119062","1","0","1"),
("119429","Czechowice","119062","2","0","1"),
("119430","Ligota Zabrska","119062","3","0","1"),
("119431","Łabędy","119062","4","0","1"),
("119432","Ostropa","119062","5","0","1"),
("119433","Sośnica","119062","6","0","1"),
("119434","Stare Gliwice","119062","7","0","1"),
("119435","Szobiszowice","119062","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119436","Trynek","119062","9","0","1"),
("119437","Wilcze Gardło","119062","10","0","1"),
("119438","Wójtowa Wieś","119062","11","0","1"),
("119439","Żerniki","119062","12","0","1"),
("119440","Pozostałe","119062","13","0","1"),
("119441","Bogucice","119065","0","0","1"),
("119442","Brynów","119065","1","0","1"),
("119443","Dąb","119065","2","0","1"),
("119444","Giszowiec","119065","3","0","1"),
("119445","Józefowiec","119065","4","0","1"),
("119446","Kostuchna","119065","5","0","1"),
("119447","Koszutka","119065","6","0","1"),
("119448","Ligota","119065","7","0","1"),
("119449","Ochojec","119065","8","0","1"),
("119450","Panewniki","119065","9","0","1"),
("119451","Piotrowice","119065","10","0","1"),
("119452","Podlesie","119065","11","0","1"),
("119453","Wełnowiec","119065","12","0","1"),
("119454","Zarzecze","119065","13","0","1"),
("119455","Zawodzie","119065","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119456","Pozostałe","119065","15","0","1"),
("119457","Cieśle","119071","0","0","1"),
("119458","Dańdówka","119071","1","0","1"),
("119459","Dębowa Góra","119071","2","0","1"),
("119460","Józefów","119071","3","0","1"),
("119461","Kazimierz","119071","4","0","1"),
("119462","Klimontów","119071","5","0","1"),
("119463","Maczki","119071","6","0","1"),
("119464","Milowice","119071","7","0","1"),
("119465","Niwka","119071","8","0","1"),
("119466","Ostrowy Górnicze","119071","9","0","1"),
("119467","Pogoń","119071","10","0","1"),
("119468","Sielec","119071","11","0","1"),
("119469","Stary Sosnowiec","119071","12","0","1"),
("119470","Środula","119071","13","0","1"),
("119471","Zagórze","119071","14","0","1"),
("119472","Pozostałe","119071","15","0","1"),
("119473","Cielmice","119073","0","0","1"),
("119474","Czułów","119073","1","0","1"),
("119475","Glinka","119073","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119476","Jaroszowice","119073","3","0","1"),
("119477","Mąkołowiec","119073","4","0","1"),
("119478","Paprocany","119073","5","0","1"),
("119479","Suble","119073","6","0","1"),
("119480","Urbanowice","119073","7","0","1"),
("119481","Wartogłowiec","119073","8","0","1"),
("119482","Wilkowyje","119073","9","0","1"),
("119483","Zwierzyniec","119073","10","0","1"),
("119484","Żwaków","119073","11","0","1"),
("119485","Pozostałe","119073","12","0","1"),
("119486","Grunwald","119131","0","0","1"),
("119487","Jeżyce","119131","1","0","1"),
("119488","Nowe Miasto","119131","2","0","1"),
("119489","Stare Miasto","119131","3","0","1"),
("119490","Wilda","119131","4","0","1"),
("119491","Pozostałe","119131","5","0","1"),
("119492","Chełmoniewo","119163","0","0","1"),
("119493","Dzierżęcino","119163","1","0","1"),
("119494","Lubiatowo","119163","2","0","1"),
("119495","Raduszka","119163","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119496","Rokosowo","119163","4","0","1"),
("119497","Pozostałe","119163","5","0","1"),
("119498","Bezrzecze","119164","0","0","1"),
("119499","Bukowo","119164","1","0","1"),
("119500","Centrum","119164","2","0","1"),
("119501","Dąbie","119164","3","0","1"),
("119502","Drzetowo","119164","4","0","1"),
("119503","Grabowo","119164","5","0","1"),
("119504","Gumieńce","119164","6","0","1"),
("119505","Kijewo","119164","7","0","1"),
("119506","Niebuszewo","119164","8","0","1"),
("119507","Podjuchy","119164","9","0","1"),
("119508","Pogodno","119164","10","0","1"),
("119509","Pomorzany","119164","11","0","1"),
("119510","Warszewo","119164","12","0","1"),
("119511","Wielgowo","119164","13","0","1"),
("119512","Zdroje","119164","14","0","1"),
("119513","Żelechowa","119164","15","0","1"),
("119514","Pozostałe","119164","16","0","1"),
("119515","Dolnośląskie","112749","0","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119516","Kujawsko-pomorskie","112749","1","0","0"),
("119517","Lubelskie","112749","2","0","0"),
("119518","Lubuskie","112749","3","0","0"),
("119519","Łódzkie","112749","4","0","0"),
("119520","Małopolskie","112749","5","0","0"),
("119521","Mazowieckie","112749","6","0","0"),
("119522","Opolskie","112749","7","0","0"),
("119523","Podkarpackie","112749","8","0","0"),
("119524","Podlaskie","112749","9","0","0"),
("119525","Pomorskie","112749","10","0","0"),
("119526","Śląskie","112749","11","0","0"),
("119527","Świętokrzyskie","112749","12","0","0"),
("119528","Warmińsko-mazurskie","112749","13","0","0"),
("119529","Wielkopolskie","112749","14","0","0"),
("119530","Zachodniopomorskie","112749","15","0","0"),
("119531","Jelenia Góra","119515","0","0","0"),
("119532","Legnica","119515","1","0","1"),
("119533","Wałbrzych","119515","2","0","1"),
("119534","Wrocław","119515","3","0","0"),
("119535","Pow. bolesławiecki","119515","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119536","Pow. dzierżoniowski","119515","5","0","1"),
("119537","Pow. głogowski","119515","6","0","1"),
("119538","Pow. górowski","119515","7","0","1"),
("119539","Pow. jaworski","119515","8","0","1"),
("119540","Pow. jeleniogórski","119515","9","0","1"),
("119541","Pow. kamiennogórski","119515","10","0","1"),
("119542","Pow. kłodzki","119515","11","0","1"),
("119543","Pow. legnicki","119515","12","0","1"),
("119544","Pow. lubański","119515","13","0","1"),
("119545","Pow. lubiński","119515","14","0","1"),
("119546","Pow. lwówecki","119515","15","0","1"),
("119547","Pow. milicki","119515","16","0","1"),
("119548","Pow. oleśnicki","119515","17","0","1"),
("119549","Pow. oławski","119515","18","0","1"),
("119550","Pow. polkowicki","119515","19","0","1"),
("119551","Pow. strzeliński","119515","20","0","1"),
("119552","Pow. średzki","119515","21","0","1"),
("119553","Pow. świdnicki","119515","22","0","1"),
("119554","Pow. trzebnicki","119515","23","0","1"),
("119555","Pow. wałbrzyski","119515","24","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119556","Pow. wołowski","119515","25","0","1"),
("119557","Pow. wrocławski","119515","26","0","1"),
("119558","Pow. ząbkowicki","119515","27","0","1"),
("119559","Pow. zgorzelecki","119515","28","0","1"),
("119560","Pow. złotoryjski","119515","29","0","1"),
("119561","Bydgoszcz","119516","0","0","0"),
("119562","Grudziądz","119516","1","0","1"),
("119563","Toruń","119516","2","0","0"),
("119564","Włocławek","119516","3","0","1"),
("119565","Pow. aleksandrowski","119516","4","0","1"),
("119566","Pow. brodnicki","119516","5","0","1"),
("119567","Pow. bydgoski","119516","6","0","1"),
("119568","Pow. chełmiński","119516","7","0","1"),
("119569","Pow. golubsko-dobrzyński","119516","8","0","1"),
("119570","Pow. grudziądzki","119516","9","0","1"),
("119571","Pow. inowrocławski","119516","10","0","1"),
("119572","Pow. lipnowski","119516","11","0","1"),
("119573","Pow. mogileński","119516","12","0","1"),
("119574","Pow. nakielski","119516","13","0","1"),
("119575","Pow. radziejowski","119516","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119576","Pow. rypiński","119516","15","0","1"),
("119577","Pow. sępoleński","119516","16","0","1"),
("119578","Pow. świecki","119516","17","0","1"),
("119579","Pow. toruński","119516","18","0","1"),
("119580","Pow. tucholski","119516","19","0","1"),
("119581","Pow. wąbrzeski","119516","20","0","1"),
("119582","Pow. włocławski","119516","21","0","1"),
("119583","Pow. żniński","119516","22","0","1"),
("119584","Biała Podlaska","119517","0","0","1"),
("119585","Chełm","119517","1","0","1"),
("119586","Lublin","119517","2","0","0"),
("119587","Zamość","119517","3","0","1"),
("119588","Pow. bialski","119517","4","0","1"),
("119589","Pow. biłgorajski","119517","5","0","1"),
("119590","Pow. chełmski","119517","6","0","1"),
("119591","Pow. hrubieszowski","119517","7","0","1"),
("119592","Pow. janowski","119517","8","0","1"),
("119593","Pow. krasnostawski","119517","9","0","1"),
("119594","Pow. kraśnicki","119517","10","0","1"),
("119595","Pow. lubartowski","119517","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119596","Pow. lubelski","119517","12","0","1"),
("119597","Pow. łęczyński","119517","13","0","1"),
("119598","Pow. łukowski","119517","14","0","1"),
("119599","Pow. opolski","119517","15","0","1"),
("119600","Pow. parczewski","119517","16","0","1"),
("119601","Pow. puławski","119517","17","0","1"),
("119602","Pow. radzyński","119517","18","0","1"),
("119603","Pow. rycki","119517","19","0","1"),
("119604","Pow. świdnicki","119517","20","0","1"),
("119605","Pow. tomaszowski","119517","21","0","1"),
("119606","Pow. włodawski","119517","22","0","1"),
("119607","Pow. zamojski","119517","23","0","1"),
("119608","Gorzów Wielkopolski","119518","0","0","1"),
("119609","Zielona Góra","119518","1","0","1"),
("119610","Pow. gorzowski","119518","2","0","1"),
("119611","Pow. krośnieński","119518","3","0","1"),
("119612","Pow. międzyrzecki","119518","4","0","1"),
("119613","Pow. nowosolski","119518","5","0","1"),
("119614","Pow. słubicki","119518","6","0","1"),
("119615","Pow. strzelecko-drezdenecki","119518","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119616","Pow. sulęciński","119518","8","0","1"),
("119617","Pow. świebodziński","119518","9","0","1"),
("119618","Pow. wschowski","119518","10","0","1"),
("119619","Pow. zielonogórski","119518","11","0","1"),
("119620","Pow. żagański","119518","12","0","1"),
("119621","Pow. żarski","119518","13","0","1"),
("119622","Łódź","119519","0","0","0"),
("119623","Piotrków Trybunalski","119519","1","0","1"),
("119624","Skierniewice","119519","2","0","1"),
("119625","Pow. bełchatowski","119519","3","0","1"),
("119626","Pow. brzeziński","119519","4","0","1"),
("119627","Pow. kutnowski","119519","5","0","1"),
("119628","Pow. łaski","119519","6","0","1"),
("119629","Pow. łęczycki","119519","7","0","1"),
("119630","Pow. łowicki","119519","8","0","1"),
("119631","Pow. łódzki wschodni","119519","9","0","1"),
("119632","Pow. opoczyński","119519","10","0","1"),
("119633","Pow. pabianicki","119519","11","0","1"),
("119634","Pow. pajęczański","119519","12","0","1"),
("119635","Pow. piotrkowski","119519","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119636","Pow. poddębicki","119519","14","0","1"),
("119637","Pow. radomszczański","119519","15","0","1"),
("119638","Pow. rawski","119519","16","0","1"),
("119639","Pow. sieradzki","119519","17","0","1"),
("119640","Pow. skierniewicki","119519","18","0","1"),
("119641","Pow. tomaszowski","119519","19","0","1"),
("119642","Pow. wieluński","119519","20","0","1"),
("119643","Pow. wieruszowski","119519","21","0","1"),
("119644","Pow. zduńskowolski","119519","22","0","1"),
("119645","Pow. zgierski","119519","23","0","1"),
("119646","Kraków","119520","0","0","0"),
("119647","Nowy Sącz","119520","1","0","1"),
("119648","Tarnów","119520","2","0","1"),
("119649","Pow. bocheński","119520","3","0","1"),
("119650","Pow. brzeski","119520","4","0","1"),
("119651","Pow. chrzanowski","119520","5","0","1"),
("119652","Pow. dąbrowski","119520","6","0","1"),
("119653","Pow. gorlicki","119520","7","0","1"),
("119654","Pow. krakowski","119520","8","0","1"),
("119655","Pow. limanowski","119520","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119656","Pow. miechowski","119520","10","0","1"),
("119657","Pow. myślenicki","119520","11","0","1"),
("119658","Pow. nowosądecki","119520","12","0","1"),
("119659","Pow. nowotarski","119520","13","0","1"),
("119660","Pow. olkuski","119520","14","0","1"),
("119661","Pow. oświęcimski","119520","15","0","1"),
("119662","Pow. proszowicki","119520","16","0","1"),
("119663","Pow. suski","119520","17","0","1"),
("119664","Pow. tarnowski","119520","18","0","1"),
("119665","Pow. tatrzański","119520","19","0","1"),
("119666","Pow. wadowicki","119520","20","0","1"),
("119667","Pow. wielicki","119520","21","0","1"),
("119668","Ostrołęka","119521","0","0","1"),
("119669","Płock","119521","1","0","1"),
("119670","Radom","119521","2","0","1"),
("119671","Siedlce","119521","3","0","1"),
("119672","Warszawa","119521","4","0","0"),
("119673","Pow. białobrzeski","119521","5","0","1"),
("119674","Pow. ciechanowski","119521","6","0","1"),
("119675","Pow. garwoliński","119521","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119676","Pow. gostyniński","119521","8","0","1"),
("119677","Pow. grójecki","119521","9","0","1"),
("119678","Pow. grodziski","119521","10","0","1"),
("119679","Pow. kozienicki","119521","11","0","1"),
("119680","Pow. legionowski","119521","12","0","1"),
("119681","Pow. lipski","119521","13","0","1"),
("119682","Pow. łosicki","119521","14","0","1"),
("119683","Pow. makowski","119521","15","0","1"),
("119684","Pow. miński","119521","16","0","1"),
("119685","Pow. mławski","119521","17","0","1"),
("119686","Pow. nowodworski","119521","18","0","1"),
("119687","Pow. ostrołęcki","119521","19","0","1"),
("119688","Pow. ostrowski","119521","20","0","1"),
("119689","Pow. otwocki","119521","21","0","1"),
("119690","Pow. piaseczyński","119521","22","0","0"),
("119691","Pow. płocki","119521","23","0","1"),
("119692","Pow. płoński","119521","24","0","1"),
("119693","Pow. pruszkowski","119521","25","0","0"),
("119694","Pow. przasnyski","119521","26","0","1"),
("119695","Pow. przysuski","119521","27","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119696","Pow. pułtuski","119521","28","0","1"),
("119697","Pow. radomski","119521","29","0","1"),
("119698","Pow. siedlecki","119521","30","0","1"),
("119699","Pow. sierpecki","119521","31","0","1"),
("119700","Pow. sochaczewski","119521","32","0","1"),
("119701","Pow. sokołowski","119521","33","0","1"),
("119702","Pow. szydłowiecki","119521","34","0","1"),
("119703","Pow. warszawski zachodni","119521","35","0","1"),
("119704","Pow. węgrowski","119521","36","0","1"),
("119705","Pow. wołomiński","119521","37","0","0"),
("119706","Pow. wyszkowski","119521","38","0","1"),
("119707","pow. zwoleński","119521","39","0","1"),
("119708","Pow. żuromiński","119521","40","0","1"),
("119709","Pow. żyrardowski","119521","41","0","1"),
("119710","Opole","119522","0","0","0"),
("119711","Pow. brzeski","119522","1","0","1"),
("119712","Pow. głubczycki","119522","2","0","1"),
("119713","Pow. kędzierzyńsko-kozielski","119522","3","0","1"),
("119714","Pow. kluczborski","119522","4","0","1"),
("119715","Pow. krapkowicki","119522","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119716","Pow. namysłowski","119522","6","0","1"),
("119717","Pow. nyski","119522","7","0","1"),
("119718","Pow. oleski","119522","8","0","1"),
("119719","Pow. opolski","119522","9","0","1"),
("119720","Pow. prudnicki","119522","10","0","1"),
("119721","Pow. strzelecki","119522","11","0","1"),
("119722","Krosno","119523","0","0","1"),
("119723","Przemyśl","119523","1","0","1"),
("119724","Rzeszów","119523","2","0","0"),
("119725","Tarnobrzeg","119523","3","0","1"),
("119726","Pow. bieszczadzki","119523","4","0","1"),
("119727","Pow. brzozowski","119523","5","0","1"),
("119728","Pow. dębicki","119523","6","0","1"),
("119729","Pow. jarosławski","119523","7","0","1"),
("119730","Pow. jasielski","119523","8","0","1"),
("119731","Pow. kolbuszowski","119523","9","0","1"),
("119732","Pow. krośnieński","119523","10","0","1"),
("119733","Pow. leski","119523","11","0","1"),
("119734","Pow. leżajski","119523","12","0","1"),
("119735","Pow. lubaczowski","119523","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119736","Pow. łańcucki","119523","14","0","1"),
("119737","Pow. mielecki","119523","15","0","1"),
("119738","Pow. niżański","119523","16","0","1"),
("119739","Pow. przemyski","119523","17","0","1"),
("119740","Pow. przeworski","119523","18","0","1"),
("119741","Pow. ropczycko-sędziszowski","119523","19","0","1"),
("119742","Pow. rzeszowski","119523","20","0","1"),
("119743","Pow. sanocki","119523","21","0","1"),
("119744","Pow. stalowowolski","119523","22","0","1"),
("119745","Pow. strzyżowski","119523","23","0","1"),
("119746","Pow. tarnobrzeski","119523","24","0","1"),
("119747","Białystok","119524","0","0","0"),
("119748","Łomża","119524","1","0","1"),
("119749","Suwałki","119524","2","0","1"),
("119750","Pow. augustowski","119524","3","0","1"),
("119751","Pow. białostocki","119524","4","0","1"),
("119752","Pow. bielski","119524","5","0","1"),
("119753","Pow. grajewski","119524","6","0","1"),
("119754","Pow. hajnowski","119524","7","0","1"),
("119755","Pow. kolneński","119524","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119756","Pow. łomżyński","119524","9","0","1"),
("119757","Pow. moniecki","119524","10","0","1"),
("119758","Pow. sejneński","119524","11","0","1"),
("119759","Pow. siemiatycki","119524","12","0","1"),
("119760","Pow. sokólski","119524","13","0","1"),
("119761","Pow. suwalski","119524","14","0","1"),
("119762","Pow. wysokomazowiecki","119524","15","0","1"),
("119763","Pow. zambrowski","119524","16","0","1"),
("119764","Gdańsk","119525","0","0","0"),
("119765","Gdynia","119525","1","0","0"),
("119766","Słupsk","119525","2","0","1"),
("119767","Sopot","119525","3","0","0"),
("119768","Pow. bytowski","119525","4","0","1"),
("119769","Pow. chojnicki","119525","5","0","1"),
("119770","Pow. człuchowski","119525","6","0","1"),
("119771","Pow. gdański","119525","7","0","1"),
("119772","Pow. kartuski","119525","8","0","1"),
("119773","Pow. kościerski","119525","9","0","1"),
("119774","Pow. kwidzyński","119525","10","0","1"),
("119775","Pow. lęborski","119525","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119776","Pow. malborski","119525","12","0","1"),
("119777","Pow. nowodworski","119525","13","0","1"),
("119778","Pow. pucki","119525","14","0","1"),
("119779","Pow. słupski","119525","15","0","1"),
("119780","Pow. starogardzki","119525","16","0","1"),
("119781","Pow. sztumski","119525","17","0","1"),
("119782","Pow. tczewski","119525","18","0","1"),
("119783","Pow. wejherowski","119525","19","0","0"),
("119784","Bielsko-Biała","119526","0","0","0"),
("119785","Bytom","119526","1","0","0"),
("119786","Chorzów","119526","2","0","1"),
("119787","Częstochowa","119526","3","0","0"),
("119788","Dąbrowa Górnicza","119526","4","0","1"),
("119789","Gliwice","119526","5","0","0"),
("119790","Jastrzębie-Zdrój","119526","6","0","1"),
("119791","Jaworzno","119526","7","0","1"),
("119792","Katowice","119526","8","0","0"),
("119793","Mysłowice","119526","9","0","1"),
("119794","Piekary Śląskie","119526","10","0","1"),
("119795","Ruda Śląska","119526","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119796","Rybnik","119526","12","0","1"),
("119797","Siemianowice Śląskie","119526","13","0","1"),
("119798","Sosnowiec","119526","14","0","0"),
("119799","Świętochłowice","119526","15","0","1"),
("119800","Tychy","119526","16","0","0"),
("119801","Zabrze","119526","17","0","1"),
("119802","Żory","119526","18","0","1"),
("119803","Pow. będziński","119526","19","0","1"),
("119804","Pow. bielski","119526","20","0","1"),
("119805","Pow. bieruńsko-lędziński","119526","21","0","1"),
("119806","Pow. cieszyński","119526","22","0","1"),
("119807","Pow. częstochowski","119526","23","0","1"),
("119808","Pow. gliwicki","119526","24","0","1"),
("119809","Pow. kłobucki","119526","25","0","1"),
("119810","Pow. lubliniecki","119526","26","0","1"),
("119811","Pow. mikołowski","119526","27","0","1"),
("119812","Pow. myszkowski","119526","28","0","1"),
("119813","Pow. pszczyński","119526","29","0","1"),
("119814","Pow. raciborski","119526","30","0","1"),
("119815","Pow. rybnicki","119526","31","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119816","Pow. tarnogórski","119526","32","0","1"),
("119817","Pow. wodzisławski","119526","33","0","1"),
("119818","Pow. zawierciański","119526","34","0","1"),
("119819","Pow. żywiecki","119526","35","0","1"),
("119820","Kielce","119527","0","0","1"),
("119821","Pow. buski","119527","1","0","1"),
("119822","Pow. jędrzejowski","119527","2","0","1"),
("119823","Pow. kazimierski","119527","3","0","1"),
("119824","Pow. kielecki","119527","4","0","1"),
("119825","Pow. konecki","119527","5","0","1"),
("119826","Pow. opatowski","119527","6","0","1"),
("119827","Pow. ostrowiecki","119527","7","0","1"),
("119828","Pow. pińczowski","119527","8","0","1"),
("119829","Pow. sandomierski","119527","9","0","1"),
("119830","Pow. skarżyski","119527","10","0","1"),
("119831","Pow. starachowicki","119527","11","0","1"),
("119832","Pow. staszowski","119527","12","0","1"),
("119833","Pow. włoszczowski","119527","13","0","1"),
("119834","Elbląg","119528","0","0","1"),
("119835","Olsztyn","119528","1","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119836","Pow. bartoszycki","119528","2","0","1"),
("119837","Pow. braniewski","119528","3","0","1"),
("119838","Pow. działdowski","119528","4","0","1"),
("119839","Pow. elbląski","119528","5","0","1"),
("119840","Pow. ełcki","119528","6","0","1"),
("119841","Pow. giżycki","119528","7","0","1"),
("119842","Pow. gołdapski","119528","8","0","1"),
("119843","Pow. iławski","119528","9","0","1"),
("119844","Pow. kętrzyński","119528","10","0","1"),
("119845","Pow. lidzbarski","119528","11","0","1"),
("119846","Pow. mrągowski","119528","12","0","1"),
("119847","Pow. nidzicki","119528","13","0","1"),
("119848","Pow. nowomiejski","119528","14","0","1"),
("119849","Pow. olecki","119528","15","0","1"),
("119850","Pow. olsztyński","119528","16","0","1"),
("119851","Pow. ostródzki","119528","17","0","1"),
("119852","Pow. piski","119528","18","0","1"),
("119853","Pow. szczycieński","119528","19","0","1"),
("119854","Pow. węgorzewski","119528","20","0","1"),
("119855","Kalisz","119529","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119856","Konin","119529","1","0","1"),
("119857","Leszno","119529","2","0","1"),
("119858","Poznań","119529","3","0","0"),
("119859","Pow. chodzieski","119529","4","0","1"),
("119860","Pow. czarnkowsko-trzcianecki","119529","5","0","1"),
("119861","Pow. gnieźnieński","119529","6","0","1"),
("119862","Pow. gostyński","119529","7","0","1"),
("119863","Pow. grodziski","119529","8","0","1"),
("119864","Pow. jarociński","119529","9","0","1"),
("119865","Pow. kaliski","119529","10","0","1"),
("119866","Pow. kępiński","119529","11","0","1"),
("119867","Pow. kolski","119529","12","0","1"),
("119868","Pow. koniński","119529","13","0","1"),
("119869","Pow. kościański","119529","14","0","1"),
("119870","Pow. krotoszyński","119529","15","0","1"),
("119871","Pow. leszczyński","119529","16","0","1"),
("119872","Pow. międzychodzki","119529","17","0","1"),
("119873","Pow. nowotomyski","119529","18","0","1"),
("119874","Pow. obornicki","119529","19","0","1"),
("119875","Pow. ostrowski","119529","20","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119876","Pow. ostrzeszowski","119529","21","0","1"),
("119877","Pow. pilski","119529","22","0","1"),
("119878","Pow. pleszewski","119529","23","0","1"),
("119879","Pow. poznański","119529","24","0","1"),
("119880","Pow. rawicki","119529","25","0","1"),
("119881","Pow. słupecki","119529","26","0","1"),
("119882","Pow. szamotulski","119529","27","0","1"),
("119883","Pow. średzki","119529","28","0","1"),
("119884","Pow. śremski","119529","29","0","1"),
("119885","Pow. turecki","119529","30","0","1"),
("119886","Pow. wągrowiecki","119529","31","0","1"),
("119887","Pow. wolsztyński","119529","32","0","1"),
("119888","Pow. wrzesiński","119529","33","0","1"),
("119889","Pow. złotowski","119529","34","0","1"),
("119890","Koszalin","119530","0","0","0"),
("119891","Szczecin","119530","1","0","0"),
("119892","Świnoujście","119530","2","0","1"),
("119893","Pow. białogardzki","119530","3","0","1"),
("119894","Pow. choszczeński","119530","4","0","1"),
("119895","Pow. drawski","119530","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119896","Pow. goleniowski","119530","6","0","1"),
("119897","Pow. gryficki","119530","7","0","1"),
("119898","Pow. gryfiński","119530","8","0","1"),
("119899","Pow. kamieński","119530","9","0","1"),
("119900","Pow. kołobrzeski","119530","10","0","1"),
("119901","Pow. koszaliński","119530","11","0","1"),
("119902","Pow. łobeski","119530","12","0","1"),
("119903","Pow. myśliborski","119530","13","0","1"),
("119904","Pow. policki","119530","14","0","1"),
("119905","Pow. pyrzycki","119530","15","0","1"),
("119906","Pow. sławieński","119530","16","0","1"),
("119907","Pow. stargardzki","119530","17","0","1"),
("119908","Pow. szczecinecki","119530","18","0","1"),
("119909","Pow. świdwiński","119530","19","0","1"),
("119910","Pow. wałecki","119530","20","0","1"),
("119911","Cieplice Śląskie-Zdrój","119531","0","0","1"),
("119912","Czarne","119531","1","0","1"),
("119913","Dąbrówka","119531","2","0","1"),
("119914","Goduszyn","119531","3","0","1"),
("119915","Grabary","119531","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119916","Jagniątków","119531","5","0","1"),
("119917","Maciejowa","119531","6","0","1"),
("119918","Paulinów","119531","7","0","1"),
("119919","Sobieszów","119531","8","0","1"),
("119920","Strupice","119531","9","0","1"),
("119921","Zabobrze","119531","10","0","1"),
("119922","Pozostałe","119531","11","0","1"),
("119923","Fabryczna","119534","0","0","1"),
("119924","Krzyki","119534","1","0","1"),
("119925","Psie Pole","119534","2","0","1"),
("119926","Stare Miasto","119534","3","0","1"),
("119927","Śródmieście","119534","4","0","1"),
("119928","Inne","119534","5","0","1"),
("119929","Bartodzieje Małe","119561","0","0","1"),
("119930","Bartodzieje Wielkie","119561","1","0","1"),
("119931","Bielawy","119561","2","0","1"),
("119932","Błonie","119561","3","0","1"),
("119933","Bocianowo","119561","4","0","1"),
("119934","Czyżkówko","119561","5","0","1"),
("119935","Fordon","119561","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119936","Górzyskowo","119561","7","0","1"),
("119937","Kapuściska","119561","8","0","1"),
("119938","Okole","119561","9","0","1"),
("119939","Osiedle Leśne","119561","10","0","1"),
("119940","Osowa Góra","119561","11","0","1"),
("119941","Skrzetusko","119561","12","0","1"),
("119942","Szwederowo","119561","13","0","1"),
("119943","Wilczak","119561","14","0","1"),
("119944","Pozostałe","119561","15","0","1"),
("119945","Bielany","119563","0","0","1"),
("119946","Bielawy","119563","1","0","1"),
("119947","Bydgoskie Przedmieście","119563","2","0","1"),
("119948","Chełmińskie Przedmieście","119563","3","0","1"),
("119949","Jakubskie Przedmieście","119563","4","0","1"),
("119950","Koniuchy","119563","5","0","1"),
("119951","Mokre","119563","6","0","1"),
("119952","Na Skarpie","119563","7","0","1"),
("119953","Podgórz","119563","8","0","1"),
("119954","Rubinkowo","119563","9","0","1"),
("119955","Rudak","119563","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119956","Rybaki","119563","11","0","1"),
("119957","Stare Miasto","119563","12","0","1"),
("119958","Stawki","119563","13","0","1"),
("119959","Wrzosy","119563","14","0","1"),
("119960","Pozostałe","119563","15","0","1"),
("119961","Bazylianówka","119586","0","0","1"),
("119962","Bronowice","119586","1","0","1"),
("119963","Czechów Górny","119586","2","0","1"),
("119964","Czuby","119586","3","0","1"),
("119965","Dziesiąta","119586","4","0","1"),
("119966","Felin","119586","5","0","1"),
("119967","Kalinowszczyzna","119586","6","0","1"),
("119968","Kośminek","119586","7","0","1"),
("119969","Rudnik","119586","8","0","1"),
("119970","Sławinek","119586","9","0","1"),
("119971","Śródmieście","119586","10","0","1"),
("119972","Tatary","119586","11","0","1"),
("119973","Węglin","119586","12","0","1"),
("119974","Wieniawka","119586","13","0","1"),
("119975","Wrotków","119586","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119976","Pozostałe","119586","15","0","1"),
("119977","Bałuty","119622","0","0","1"),
("119978","Górna","119622","1","0","1"),
("119979","Polesie","119622","2","0","1"),
("119980","Śródmieście","119622","3","0","1"),
("119981","Widzew","119622","4","0","1"),
("119982","Pozostałe","119622","5","0","1"),
("119983","Krowodrza","119646","0","0","1"),
("119984","Nowa Huta","119646","1","0","1"),
("119985","Podgórze","119646","2","0","1"),
("119986","Śródmieście","119646","3","0","1"),
("119987","Pozostałe","119646","4","0","1"),
("119988","Bemowo","119672","0","0","1"),
("119989","Białołęka","119672","1","0","1"),
("119990","Bielany","119672","2","0","1"),
("119991","Mokotów","119672","3","0","1"),
("119992","Ochota","119672","4","0","1"),
("119993","Praga Południe","119672","5","0","1"),
("119994","Praga Północ","119672","6","0","1"),
("119995","Rembertów","119672","7","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("119996","Śródmieście","119672","8","0","1"),
("119997","Targówek","119672","9","0","1"),
("119998","Ursus","119672","10","0","1"),
("119999","Ursynów","119672","11","0","1"),
("120000","Wawer","119672","12","0","1"),
("120001","Wesoła","119672","13","0","1"),
("120002","Wilanów","119672","14","0","1"),
("120003","Włochy","119672","15","0","1"),
("120004","Wola","119672","16","0","1"),
("120005","Żoliborz","119672","17","0","1"),
("120006","Inne","119672","18","0","1"),
("120007","Góra Kalwaria","119690","0","0","1"),
("120008","Konstancin-Jeziorna","119690","1","0","1"),
("120009","Piaseczno","119690","2","0","1"),
("120010","Tarczyn","119690","3","0","1"),
("120011","Pozostałe","119690","4","0","1"),
("120012","Brwinów","119693","0","0","1"),
("120013","Piastów","119693","1","0","1"),
("120014","Pruszków","119693","2","0","1"),
("120015","Pozostałe","119693","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120016","Kobyłka","119705","0","0","1"),
("120017","Marki","119705","1","0","1"),
("120018","Radzymin","119705","2","0","1"),
("120019","Tłuszcz","119705","3","0","1"),
("120020","Wołomin","119705","4","0","1"),
("120021","Ząbki","119705","5","0","1"),
("120022","Zielonka","119705","6","0","1"),
("120023","Pozostałe","119705","7","0","1"),
("120024","Bierkowice","119710","0","0","1"),
("120025","Gosławice","119710","1","0","1"),
("120026","Groszowice","119710","2","0","1"),
("120027","Grudzice","119710","3","0","1"),
("120028","Kolonia Gosławicka","119710","4","0","1"),
("120029","Malina","119710","5","0","1"),
("120030","Nowa Wieś Królewska","119710","6","0","1"),
("120031","Półwieś","119710","7","0","1"),
("120032","Szczepanowice","119710","8","0","1"),
("120033","Wójtowa Wieś","119710","9","0","1"),
("120034","Wróblin","119710","10","0","1"),
("120035","Zakrzów","119710","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120036","Zaodrze","119710","12","0","1"),
("120037","Pozostałe","119710","13","0","1"),
("120038","Drabinianka","119724","0","0","1"),
("120039","Dworzysko","119724","1","0","1"),
("120040","Pobitno","119724","2","0","1"),
("120041","Przybyszówka","119724","3","0","1"),
("120042","Słocina","119724","4","0","1"),
("120043","Staromieście","119724","5","0","1"),
("120044","Staroniwa","119724","6","0","1"),
("120045","Szajerówka","119724","7","0","1"),
("120046","Wilkowyja","119724","8","0","1"),
("120047","Zalesie","119724","9","0","1"),
("120048","Załęże","119724","10","0","1"),
("120049","Zwięczyca","119724","11","0","1"),
("120050","Pozostałe","119724","12","0","1"),
("120051","Antoniuk","119747","0","0","1"),
("120052","Bacieczki","119747","1","0","1"),
("120053","Białostoczek","119747","2","0","1"),
("120054","Bojary","119747","3","0","1"),
("120055","Dojlidy","119747","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120056","Dojlidy Górne","119747","5","0","1"),
("120057","Dziesięciny","119747","6","0","1"),
("120058","Nowe Miasto","119747","7","0","1"),
("120059","Skorupy","119747","8","0","1"),
("120060","Słoboda","119747","9","0","1"),
("120061","Starosielce","119747","10","0","1"),
("120062","Wygoda","119747","11","0","1"),
("120063","Wysoki Stoczek","119747","12","0","1"),
("120064","Zagórki","119747","13","0","1"),
("120065","Zawady","119747","14","0","1"),
("120066","Pozostałe","119747","15","0","1"),
("120067","Brzeźno","119764","0","0","1"),
("120068","Chełm","119764","1","0","1"),
("120069","Jasień","119764","2","0","1"),
("120070","Kiełpino Górne","119764","3","0","1"),
("120071","Kokoszki","119764","4","0","1"),
("120072","Lipce","119764","5","0","1"),
("120073","Łostowice","119764","6","0","1"),
("120074","Oliwa","119764","7","0","1"),
("120075","Osowa","119764","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120076","Przymorze","119764","9","0","1"),
("120077","Siedlce","119764","10","0","1"),
("120078","Sobieszewo","119764","11","0","1"),
("120079","Suchanino","119764","12","0","1"),
("120080","Wrzeszcz","119764","13","0","1"),
("120081","Zakoniczyn","119764","14","0","1"),
("120082","Pozostałe","119764","15","0","1"),
("120083","Chwarzno","119765","0","0","1"),
("120084","Chylonia","119765","1","0","1"),
("120085","Cisowa","119765","2","0","1"),
("120086","Działki Leśne","119765","3","0","1"),
("120087","Kamienna Góra","119765","4","0","1"),
("120088","Leszczynki","119765","5","0","1"),
("120089","Mały Kack","119765","6","0","1"),
("120090","Obłuże","119765","7","0","1"),
("120091","Oksywie","119765","8","0","1"),
("120092","Orłowo","119765","9","0","1"),
("120093","Pogórze","119765","10","0","1"),
("120094","Redłowo","119765","11","0","1"),
("120095","Wiczlino","119765","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120096","Wielki Kack","119765","13","0","1"),
("120097","Wzgórze Nowotki","119765","14","0","1"),
("120098","Pozostałe","119765","15","0","1"),
("120099","Brodwino","119767","0","0","1"),
("120100","Kamienny Potok","119767","1","0","1"),
("120101","Przylesie","119767","2","0","1"),
("120102","Sopot Dolny","119767","3","0","1"),
("120103","Sopot Górny","119767","4","0","1"),
("120104","Wyścigi","119767","5","0","1"),
("120105","Pozostałe","119767","6","0","1"),
("120106","Reda","119783","0","0","1"),
("120107","Rumia","119783","1","0","1"),
("120108","Wejherowo","119783","2","0","1"),
("120109","Pozostałe","119783","3","0","1"),
("120110","Aleksandrowice","119784","0","0","1"),
("120111","Hałcnów","119784","1","0","1"),
("120112","Kamienica","119784","2","0","1"),
("120113","Komorowice Krakowskie","119784","3","0","1"),
("120114","Komorowice Śląskie","119784","4","0","1"),
("120115","Leszczyny","119784","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120116","Lipnik","119784","6","0","1"),
("120117","Mikuszowice Krakowskie","119784","7","0","1"),
("120118","Mikuszowice Śląskie","119784","8","0","1"),
("120119","Olszówka Dolna","119784","9","0","1"),
("120120","Olszówka Górna","119784","10","0","1"),
("120121","Stare Bielsko","119784","11","0","1"),
("120122","Straconka","119784","12","0","1"),
("120123","Wapienica","119784","13","0","1"),
("120124","Złote Łany","119784","14","0","1"),
("120125","Pozostałe","119784","15","0","1"),
("120126","Bobrek","119785","0","0","1"),
("120127","Górniki","119785","1","0","1"),
("120128","Karb","119785","2","0","1"),
("120129","Łagiewniki","119785","3","0","1"),
("120130","Miechowice","119785","4","0","1"),
("120131","Rozbark","119785","5","0","1"),
("120132","Stolarzowice","119785","6","0","1"),
("120133","Stroszek","119785","7","0","1"),
("120134","Sucha Góra","119785","8","0","1"),
("120135","Szombierki","119785","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120136","Pozostałe","119785","10","0","1"),
("120137","Błeszno","119787","0","0","1"),
("120138","Dźbów","119787","1","0","1"),
("120139","Grabówka","119787","2","0","1"),
("120140","Kawodrza Dolna","119787","3","0","1"),
("120141","Lisiniec","119787","4","0","1"),
("120142","Liszka Dolna","119787","5","0","1"),
("120143","Mirów","119787","6","0","1"),
("120144","Ostatni Grosz","119787","7","0","1"),
("120145","Parkitka","119787","8","0","1"),
("120146","Raków","119787","9","0","1"),
("120147","Rząsawy","119787","10","0","1"),
("120148","Sabinów","119787","11","0","1"),
("120149","Stradom","119787","12","0","1"),
("120150","Wrzosowiak","119787","13","0","1"),
("120151","Zawodzie","119787","14","0","1"),
("120152","Pozostałe","119787","15","0","1"),
("120153","Bojków","119789","0","0","1"),
("120154","Brzezinka","119789","1","0","1"),
("120155","Czechowice","119789","2","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120156","Ligota Zabrska","119789","3","0","1"),
("120157","Łabędy","119789","4","0","1"),
("120158","Ostropa","119789","5","0","1"),
("120159","Sośnica","119789","6","0","1"),
("120160","Stare Gliwice","119789","7","0","1"),
("120161","Szobiszowice","119789","8","0","1"),
("120162","Trynek","119789","9","0","1"),
("120163","Wilcze Gardło","119789","10","0","1"),
("120164","Wójtowa Wieś","119789","11","0","1"),
("120165","Żerniki","119789","12","0","1"),
("120166","Pozostałe","119789","13","0","1"),
("120167","Bogucice","119792","0","0","1"),
("120168","Brynów","119792","1","0","1"),
("120169","Dąb","119792","2","0","1"),
("120170","Giszowiec","119792","3","0","1"),
("120171","Józefowiec","119792","4","0","1"),
("120172","Kostuchna","119792","5","0","1"),
("120173","Koszutka","119792","6","0","1"),
("120174","Ligota","119792","7","0","1"),
("120175","Ochojec","119792","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120176","Panewniki","119792","9","0","1"),
("120177","Piotrowice","119792","10","0","1"),
("120178","Podlesie","119792","11","0","1"),
("120179","Wełnowiec","119792","12","0","1"),
("120180","Zarzecze","119792","13","0","1"),
("120181","Zawodzie","119792","14","0","1"),
("120182","Pozostałe","119792","15","0","1"),
("120183","Cieśle","119798","0","0","1"),
("120184","Dańdówka","119798","1","0","1"),
("120185","Dębowa Góra","119798","2","0","1"),
("120186","Józefów","119798","3","0","1"),
("120187","Kazimierz","119798","4","0","1"),
("120188","Klimontów","119798","5","0","1"),
("120189","Maczki","119798","6","0","1"),
("120190","Milowice","119798","7","0","1"),
("120191","Niwka","119798","8","0","1"),
("120192","Ostrowy Górnicze","119798","9","0","1"),
("120193","Pogoń","119798","10","0","1"),
("120194","Sielec","119798","11","0","1"),
("120195","Stary Sosnowiec","119798","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120196","Środula","119798","13","0","1"),
("120197","Zagórze","119798","14","0","1"),
("120198","Pozostałe","119798","15","0","1"),
("120199","Cielmice","119800","0","0","1"),
("120200","Czułów","119800","1","0","1"),
("120201","Glinka","119800","2","0","1"),
("120202","Jaroszowice","119800","3","0","1"),
("120203","Mąkołowiec","119800","4","0","1"),
("120204","Paprocany","119800","5","0","1"),
("120205","Suble","119800","6","0","1"),
("120206","Urbanowice","119800","7","0","1"),
("120207","Wartogłowiec","119800","8","0","1"),
("120208","Wilkowyje","119800","9","0","1"),
("120209","Zwierzyniec","119800","10","0","1"),
("120210","Żwaków","119800","11","0","1"),
("120211","Pozostałe","119800","12","0","1"),
("120212","Grunwald","119858","0","0","1"),
("120213","Jeżyce","119858","1","0","1"),
("120214","Nowe Miasto","119858","2","0","1"),
("120215","Stare Miasto","119858","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120216","Wilda","119858","4","0","1"),
("120217","Pozostałe","119858","5","0","1"),
("120218","Chełmoniewo","119890","0","0","1"),
("120219","Dzierżęcino","119890","1","0","1"),
("120220","Lubiatowo","119890","2","0","1"),
("120221","Raduszka","119890","3","0","1"),
("120222","Rokosowo","119890","4","0","1"),
("120223","Pozostałe","119890","5","0","1"),
("120224","Bezrzecze","119891","0","0","1"),
("120225","Bukowe-Klęskowo","119891","1","0","1"),
("120226","Bukowo","119891","2","0","1"),
("120227","Centrum","119891","3","0","1"),
("120228","Dąbie","119891","4","0","1"),
("120229","Drzetowo","119891","5","0","1"),
("120230","Głębokie","119891","6","0","1"),
("120231","Grabowo","119891","7","0","1"),
("120232","Gumieńce","119891","8","0","1"),
("120233","Kijewo","119891","9","0","1"),
("120234","Niebuszewo","119891","10","0","1"),
("120235","Osów","119891","11","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120236","Pilchowo","119891","12","0","1"),
("120237","Płonia","119891","13","0","1"),
("120238","Podjuchy","119891","14","0","1"),
("120239","Pogodno","119891","15","0","1"),
("120240","Pomorzany","119891","16","0","1"),
("120241","Skolwin","119891","17","0","1"),
("120242","Stare Miasto","119891","18","0","1"),
("120243","Stołczyn","119891","19","0","1"),
("120244","Świerczewo","119891","20","0","1"),
("120245","Warszewo","119891","21","0","1"),
("120246","Wielgowo","119891","22","0","1"),
("120247","Zdroje","119891","23","0","1"),
("120248","Żelechowa","119891","24","0","1"),
("120249","Pozostałe","119891","25","0","1"),
("120250","Dolnośląskie","112750","0","0","0"),
("120251","Kujawsko-pomorskie","112750","1","0","0"),
("120252","Lubelskie","112750","2","0","0"),
("120253","Lubuskie","112750","3","0","0"),
("120254","Łódzkie","112750","4","0","0"),
("120255","Małopolskie","112750","5","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120256","Mazowieckie","112750","6","0","0"),
("120257","Opolskie","112750","7","0","0"),
("120258","Podkarpackie","112750","8","0","0"),
("120259","Podlaskie","112750","9","0","0"),
("120260","Pomorskie","112750","10","0","0"),
("120261","Śląskie","112750","11","0","0"),
("120262","Świętokrzyskie","112750","12","0","0"),
("120263","Warmińsko-mazurskie","112750","13","0","0"),
("120264","Wielkopolskie","112750","14","0","0"),
("120265","Zachodniopomorskie","112750","15","0","0"),
("120266","Jelenia Góra","120250","0","0","1"),
("120267","Legnica","120250","1","0","1"),
("120268","Wałbrzych","120250","2","0","1"),
("120269","Wrocław","120250","3","0","0"),
("120270","Pow. bolesławiecki","120250","4","0","1"),
("120271","Pow. dzierżoniowski","120250","5","0","1"),
("120272","Pow. głogowski","120250","6","0","1"),
("120273","Pow. górowski","120250","7","0","1"),
("120274","Pow. jaworski","120250","8","0","1"),
("120275","Pow. jeleniogórski","120250","9","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120276","Pow. kamiennogórski","120250","10","0","1"),
("120277","Pow. kłodzki","120250","11","0","1"),
("120278","Pow. legnicki","120250","12","0","1"),
("120279","Pow. lubański","120250","13","0","1"),
("120280","Pow. lubiński","120250","14","0","1"),
("120281","Pow. lwówecki","120250","15","0","1"),
("120282","Pow. milicki","120250","16","0","1"),
("120283","Pow. oleśnicki","120250","17","0","1"),
("120284","Pow. oławski","120250","18","0","1"),
("120285","Pow. polkowicki","120250","19","0","1"),
("120286","Pow. strzeliński","120250","20","0","1"),
("120287","Pow. średzki","120250","21","0","1"),
("120288","Pow. świdnicki","120250","22","0","1"),
("120289","Pow. trzebnicki","120250","23","0","1"),
("120290","Pow. wałbrzyski","120250","24","0","1"),
("120291","Pow. wołowski","120250","25","0","1"),
("120292","Pow. wrocławski","120250","26","0","1"),
("120293","Pow. ząbkowicki","120250","27","0","1"),
("120294","Pow. zgorzelecki","120250","28","0","1"),
("120295","Pow. złotoryjski","120250","29","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120296","Bydgoszcz","120251","0","0","1"),
("120297","Grudziądz","120251","1","0","1"),
("120298","Toruń","120251","2","0","1"),
("120299","Włocławek","120251","3","0","1"),
("120300","Pow. aleksandrowski","120251","4","0","1"),
("120301","Pow. brodnicki","120251","5","0","1"),
("120302","Pow. bydgoski","120251","6","0","1"),
("120303","Pow. chełmiński","120251","7","0","1"),
("120304","Pow. golubsko-dobrzyński","120251","8","0","1"),
("120305","Pow. grudziądzki","120251","9","0","1"),
("120306","Pow. inowrocławski","120251","10","0","1"),
("120307","Pow. lipnowski","120251","11","0","1"),
("120308","Pow. mogileński","120251","12","0","1"),
("120309","Pow. nakielski","120251","13","0","1"),
("120310","Pow. radziejowski","120251","14","0","1"),
("120311","Pow. rypiński","120251","15","0","1"),
("120312","Pow. sępoleński","120251","16","0","1"),
("120313","Pow. świecki","120251","17","0","1"),
("120314","Pow. toruński","120251","18","0","1"),
("120315","Pow. tucholski","120251","19","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120316","Pow. wąbrzeski","120251","20","0","1"),
("120317","Pow. włocławski","120251","21","0","1"),
("120318","Pow. żniński","120251","22","0","1"),
("120319","Biała Podlaska","120252","0","0","1"),
("120320","Chełm","120252","1","0","1"),
("120321","Lublin","120252","2","0","1"),
("120322","Zamość","120252","3","0","1"),
("120323","Pow. bialski","120252","4","0","1"),
("120324","Pow. biłgorajski","120252","5","0","1"),
("120325","Pow. chełmski","120252","6","0","1"),
("120326","Pow. hrubieszowski","120252","7","0","1"),
("120327","Pow. janowski","120252","8","0","1"),
("120328","Pow. krasnostawski","120252","9","0","1"),
("120329","Pow. kraśnicki","120252","10","0","1"),
("120330","Pow. lubartowski","120252","11","0","1"),
("120331","Pow. lubelski","120252","12","0","1"),
("120332","Pow. łęczyński","120252","13","0","1"),
("120333","Pow. łukowski","120252","14","0","1"),
("120334","Pow. opolski","120252","15","0","1"),
("120335","Pow. parczewski","120252","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120336","Pow. puławski","120252","17","0","1"),
("120337","Pow. radzyński","120252","18","0","1"),
("120338","Pow. rycki","120252","19","0","1"),
("120339","Pow. świdnicki","120252","20","0","1"),
("120340","Pow. tomaszowski","120252","21","0","1"),
("120341","Pow. włodawski","120252","22","0","1"),
("120342","Pow. zamojski","120252","23","0","1"),
("120343","Gorzów Wielkopolski","120253","0","0","1"),
("120344","Zielona Góra","120253","1","0","1"),
("120345","Pow. gorzowski","120253","2","0","1"),
("120346","Pow. krośnieński","120253","3","0","1"),
("120347","Pow. międzyrzecki","120253","4","0","1"),
("120348","Pow. nowosolski","120253","5","0","1"),
("120349","Pow. słubicki","120253","6","0","1"),
("120350","Pow. strzelecko-drezdenecki","120253","7","0","1"),
("120351","Pow. sulęciński","120253","8","0","1"),
("120352","Pow. świebodziński","120253","9","0","1"),
("120353","Pow. wschowski","120253","10","0","1"),
("120354","Pow. zielonogórski","120253","11","0","1"),
("120355","Pow. żagański","120253","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120356","Pow. żarski","120253","13","0","1"),
("120357","Łódź","120254","0","0","1"),
("120358","Piotrków Trybunalski","120254","1","0","1"),
("120359","Skierniewice","120254","2","0","1"),
("120360","Pow. bełchatowski","120254","3","0","1"),
("120361","Pow. brzeziński","120254","4","0","1"),
("120362","Pow. kutnowski","120254","5","0","1"),
("120363","Pow. łaski","120254","6","0","1"),
("120364","Pow. łęczycki","120254","7","0","1"),
("120365","Pow. łowicki","120254","8","0","1"),
("120366","Pow. łódzki wschodni","120254","9","0","1"),
("120367","Pow. opoczyński","120254","10","0","1"),
("120368","Pow. pabianicki","120254","11","0","1"),
("120369","Pow. pajęczański","120254","12","0","1"),
("120370","Pow. piotrkowski","120254","13","0","1"),
("120371","Pow. poddębicki","120254","14","0","1"),
("120372","Pow. radomszczański","120254","15","0","1"),
("120373","Pow. rawski","120254","16","0","1"),
("120374","Pow. sieradzki","120254","17","0","1"),
("120375","Pow. skierniewicki","120254","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120376","Pow. tomaszowski","120254","19","0","1"),
("120377","Pow. wieluński","120254","20","0","1"),
("120378","Pow. wieruszowski","120254","21","0","1"),
("120379","Pow. zduńskowolski","120254","22","0","1"),
("120380","Pow. zgierski","120254","23","0","1"),
("120381","Kraków","120255","0","0","0"),
("120382","Nowy Sącz","120255","1","0","1"),
("120383","Tarnów","120255","2","0","1"),
("120384","Pow. bocheński","120255","3","0","1"),
("120385","Pow. brzeski","120255","4","0","1"),
("120386","Pow. chrzanowski","120255","5","0","1"),
("120387","Pow. dąbrowski","120255","6","0","1"),
("120388","Pow. gorlicki","120255","7","0","1"),
("120389","Pow. krakowski","120255","8","0","1"),
("120390","Pow. limanowski","120255","9","0","1"),
("120391","Pow. miechowski","120255","10","0","1"),
("120392","Pow. myślenicki","120255","11","0","1"),
("120393","Pow. nowosądecki","120255","12","0","1"),
("120394","Pow. nowotarski","120255","13","0","1"),
("120395","Pow. olkuski","120255","14","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120396","Pow. oświęcimski","120255","15","0","1"),
("120397","Pow. proszowicki","120255","16","0","1"),
("120398","Pow. suski","120255","17","0","1"),
("120399","Pow. tarnowski","120255","18","0","1"),
("120400","Pow. tatrzański","120255","19","0","1"),
("120401","Pow. wadowicki","120255","20","0","1"),
("120402","Pow. wielicki","120255","21","0","1"),
("120403","Ostrołęka","120256","0","0","1"),
("120404","Płock","120256","1","0","1"),
("120405","Radom","120256","2","0","1"),
("120406","Siedlce","120256","3","0","1"),
("120407","Warszawa","120256","4","0","0"),
("120408","Pow. białobrzeski","120256","5","0","1"),
("120409","Pow. ciechanowski","120256","6","0","1"),
("120410","Pow. garwoliński","120256","7","0","1"),
("120411","Pow. gostyniński","120256","8","0","1"),
("120412","Pow. grójecki","120256","9","0","1"),
("120413","Pow. grodziski","120256","10","0","1"),
("120414","Pow. kozienicki","120256","11","0","1"),
("120415","Pow. legionowski","120256","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120416","Pow. lipski","120256","13","0","1"),
("120417","Pow. łosicki","120256","14","0","1"),
("120418","Pow. makowski","120256","15","0","1"),
("120419","Pow. miński","120256","16","0","1"),
("120420","Pow. mławski","120256","17","0","1"),
("120421","Pow. nowodworski","120256","18","0","1"),
("120422","Pow. ostrołęcki","120256","19","0","1"),
("120423","Pow. ostrowski","120256","20","0","1"),
("120424","Pow. otwocki","120256","21","0","1"),
("120425","Pow. piaseczyński","120256","22","0","1"),
("120426","Pow. płocki","120256","23","0","1"),
("120427","Pow. płoński","120256","24","0","1"),
("120428","Pow. pruszkowski","120256","25","0","1"),
("120429","Pow. przasnyski","120256","26","0","1"),
("120430","Pow. przysuski","120256","27","0","1"),
("120431","Pow. pułtuski","120256","28","0","1"),
("120432","Pow. radomski","120256","29","0","1"),
("120433","Pow. siedlecki","120256","30","0","1"),
("120434","Pow. sierpecki","120256","31","0","1"),
("120435","Pow. sochaczewski","120256","32","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120436","Pow. sokołowski","120256","33","0","1"),
("120437","Pow. szydłowiecki","120256","34","0","1"),
("120438","Pow. warszawski zachodni","120256","35","0","1"),
("120439","Pow. węgrowski","120256","36","0","1"),
("120440","Pow. wołomiński","120256","37","0","1"),
("120441","Pow. wyszkowski","120256","38","0","1"),
("120442","Pow. zwoleński","120256","39","0","1"),
("120443","Pow. żuromiński","120256","40","0","1"),
("120444","Pow. żyrardowski","120256","41","0","1"),
("120445","Opole","120257","0","0","1"),
("120446","Pow. brzeski","120257","1","0","1"),
("120447","Pow. głubczycki","120257","2","0","1"),
("120448","Pow. kędzierzyńsko-kozielski","120257","3","0","1"),
("120449","Pow. kluczborski","120257","4","0","1"),
("120450","Pow. krapkowicki","120257","5","0","1"),
("120451","Pow. namysłowski","120257","6","0","1"),
("120452","Pow. nyski","120257","7","0","1"),
("120453","Pow. oleski","120257","8","0","1"),
("120454","Pow. opolski","120257","9","0","1"),
("120455","Pow. prudnicki","120257","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120456","Pow. strzelecki","120257","11","0","1"),
("120457","Krosno","120258","0","0","1"),
("120458","Przemyśl","120258","1","0","1"),
("120459","Rzeszów","120258","2","0","1"),
("120460","Tarnobrzeg","120258","3","0","1"),
("120461","Pow. bieszczadzki","120258","4","0","1"),
("120462","Pow. brzozowski","120258","5","0","1"),
("120463","Pow. dębicki","120258","6","0","1"),
("120464","Pow. jarosławski","120258","7","0","1"),
("120465","Pow. jasielski","120258","8","0","1"),
("120466","Pow. kolbuszowski","120258","9","0","1"),
("120467","Pow. krośnieński","120258","10","0","1"),
("120468","Pow. leski","120258","11","0","1"),
("120469","Pow. leżajski","120258","12","0","1"),
("120470","Pow. lubaczowski","120258","13","0","1"),
("120471","Pow. łańcucki","120258","14","0","1"),
("120472","Pow. mielecki","120258","15","0","1"),
("120473","Pow. niżański","120258","16","0","1"),
("120474","Pow. przemyski","120258","17","0","1"),
("120475","Pow. przeworski","120258","18","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120476","Pow. ropczycko-sędziszowski","120258","19","0","1"),
("120477","Pow. rzeszowski","120258","20","0","1"),
("120478","Pow. sanocki","120258","21","0","1"),
("120479","Pow. stalowowolski","120258","22","0","1"),
("120480","Pow. strzyżowski","120258","23","0","1"),
("120481","Pow. tarnobrzeski","120258","24","0","1"),
("120482","Białystok","120259","0","0","1"),
("120483","Łomża","120259","1","0","1"),
("120484","Suwałki","120259","2","0","1"),
("120485","Pow. augustowski","120259","3","0","1"),
("120486","Pow. białostocki","120259","4","0","1"),
("120487","Pow. bielski","120259","5","0","1"),
("120488","Pow. grajewski","120259","6","0","1"),
("120489","Pow. hajnowski","120259","7","0","1"),
("120490","Pow. kolneński","120259","8","0","1"),
("120491","Pow. łomżyński","120259","9","0","1"),
("120492","Pow. moniecki","120259","10","0","1"),
("120493","Pow. sejneński","120259","11","0","1"),
("120494","Pow. siemiatycki","120259","12","0","1"),
("120495","Pow. sokólski","120259","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120496","Pow. suwalski","120259","14","0","1"),
("120497","Pow. wysokomazowiecki","120259","15","0","1"),
("120498","Pow. zambrowski","120259","16","0","1"),
("120499","Gdańsk","120260","0","0","1"),
("120500","Gdynia","120260","1","0","1"),
("120501","Słupsk","120260","2","0","1"),
("120502","Sopot","120260","3","0","1"),
("120503","Pow. bytowski","120260","4","0","1"),
("120504","Pow. chojnicki","120260","5","0","1"),
("120505","Pow. człuchowski","120260","6","0","1"),
("120506","Pow. gdański","120260","7","0","1"),
("120507","Pow. kartuski","120260","8","0","1"),
("120508","Pow. kościerski","120260","9","0","1"),
("120509","Pow. kwidzyński","120260","10","0","1"),
("120510","Pow. lęborski","120260","11","0","1"),
("120511","Pow. malborski","120260","12","0","1"),
("120512","Pow. nowodworski","120260","13","0","1"),
("120513","Pow. pucki","120260","14","0","1"),
("120514","Pow. słupski","120260","15","0","1"),
("120515","Pow. starogardzki","120260","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120516","Pow. sztumski","120260","17","0","1"),
("120517","Pow. tczewski","120260","18","0","1"),
("120518","Pow. wejherowski","120260","19","0","1"),
("120519","Bielsko-Biała","120261","0","0","1"),
("120520","Bytom","120261","1","0","1"),
("120521","Chorzów","120261","2","0","1"),
("120522","Częstochowa","120261","3","0","1"),
("120523","Dąbrowa Górnicza","120261","4","0","1"),
("120524","Gliwice","120261","5","0","1"),
("120525","Jastrzębie-Zdrój","120261","6","0","1"),
("120526","Jaworzno","120261","7","0","1"),
("120527","Katowice","120261","8","0","1"),
("120528","Mysłowice","120261","9","0","1"),
("120529","Piekary Śląskie","120261","10","0","1"),
("120530","Ruda Śląska","120261","11","0","1"),
("120531","Rybnik","120261","12","0","1"),
("120532","Siemianowice Śląskie","120261","13","0","1"),
("120533","Sosnowiec","120261","14","0","1"),
("120534","Świętochłowice","120261","15","0","1"),
("120535","Tychy","120261","16","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120536","Zabrze","120261","17","0","1"),
("120537","Żory","120261","18","0","1"),
("120538","Pow. będziński","120261","19","0","1"),
("120539","Pow. bielski","120261","20","0","1"),
("120540","Pow. bieruńsko-lędziński","120261","21","0","1"),
("120541","Pow. cieszyński","120261","22","0","1"),
("120542","Pow. częstochowski","120261","23","0","1"),
("120543","Pow. gliwicki","120261","24","0","1"),
("120544","Pow. kłobucki","120261","25","0","1"),
("120545","Pow. lubliniecki","120261","26","0","1"),
("120546","Pow. mikołowski","120261","27","0","1"),
("120547","Pow. myszkowski","120261","28","0","1"),
("120548","Pow. pszczyński","120261","29","0","1"),
("120549","Pow. raciborski","120261","30","0","1"),
("120550","Pow. rybnicki","120261","31","0","1"),
("120551","Pow. tarnogórski","120261","32","0","1"),
("120552","Pow. wodzisławski","120261","33","0","1"),
("120553","Pow. zawierciański","120261","34","0","1"),
("120554","Pow. żywiecki","120261","35","0","1"),
("120555","Kielce","120262","0","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120556","Pow. buski","120262","1","0","1"),
("120557","Pow. jędrzejowski","120262","2","0","1"),
("120558","Pow. kazimierski","120262","3","0","1"),
("120559","Pow. kielecki","120262","4","0","1"),
("120560","Pow. konecki","120262","5","0","1"),
("120561","Pow. opatowski","120262","6","0","1"),
("120562","Pow. ostrowiecki","120262","7","0","1"),
("120563","Pow. pińczowski","120262","8","0","1"),
("120564","Pow. sandomierski","120262","9","0","1"),
("120565","Pow. skarżyski","120262","10","0","1"),
("120566","Pow. starachowicki","120262","11","0","1"),
("120567","Pow. staszowski","120262","12","0","1"),
("120568","Pow. włoszczowski","120262","13","0","1"),
("120569","Elbląg","120263","0","0","1"),
("120570","Olsztyn","120263","1","0","1"),
("120571","Pow. bartoszycki","120263","2","0","1"),
("120572","Pow. braniewski","120263","3","0","1"),
("120573","Pow. działdowski","120263","4","0","1"),
("120574","Pow. elbląski","120263","5","0","1"),
("120575","Pow. ełcki","120263","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120576","Pow. giżycki","120263","7","0","1"),
("120577","Pow. gołdapski","120263","8","0","1"),
("120578","Pow. iławski","120263","9","0","1"),
("120579","Pow. kętrzyński","120263","10","0","1"),
("120580","Pow. lidzbarski","120263","11","0","1"),
("120581","Pow. mrągowski","120263","12","0","1"),
("120582","Pow. nidzicki","120263","13","0","1"),
("120583","Pow. nowomiejski","120263","14","0","1"),
("120584","Pow. olecki","120263","15","0","1"),
("120585","Pow. olsztyński","120263","16","0","1"),
("120586","Pow. ostródzki","120263","17","0","1"),
("120587","Pow. piski","120263","18","0","1"),
("120588","Pow. szczycieński","120263","19","0","1"),
("120589","Pow. węgorzewski","120263","20","0","1"),
("120590","Kalisz","120264","0","0","1"),
("120591","Konin","120264","1","0","1"),
("120592","Leszno","120264","2","0","1"),
("120593","Poznań","120264","3","0","1"),
("120594","Pow. chodzieski","120264","4","0","1"),
("120595","Pow. czarnkowsko-trzcianecki","120264","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120596","Pow. gnieźnieński","120264","6","0","1"),
("120597","Pow. gostyński","120264","7","0","1"),
("120598","Pow. grodziski","120264","8","0","1"),
("120599","Pow. jarociński","120264","9","0","1"),
("120600","Pow. kaliski","120264","10","0","1"),
("120601","Pow. kępiński","120264","11","0","1"),
("120602","Pow. kolski","120264","12","0","1"),
("120603","Pow. koniński","120264","13","0","1"),
("120604","Pow. kościański","120264","14","0","1"),
("120605","Pow. krotoszyński","120264","15","0","1"),
("120606","Pow. leszczyński","120264","16","0","1"),
("120607","Pow. międzychodzki","120264","17","0","1"),
("120608","Pow. nowotomyski","120264","18","0","1"),
("120609","Pow. obornicki","120264","19","0","1"),
("120610","Pow. ostrowski","120264","20","0","1"),
("120611","Pow. ostrzeszowski","120264","21","0","1"),
("120612","Pow. pilski","120264","22","0","1"),
("120613","Pow. pleszewski","120264","23","0","1"),
("120614","Pow. poznański","120264","24","0","1"),
("120615","Pow. rawicki","120264","25","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120616","Pow. słupecki","120264","26","0","1"),
("120617","Pow. szamotulski","120264","27","0","1"),
("120618","Pow. średzki","120264","28","0","1"),
("120619","Pow. śremski","120264","29","0","1"),
("120620","Pow. turecki","120264","30","0","1"),
("120621","Pow. wągrowiecki","120264","31","0","1"),
("120622","Pow. wolsztyński","120264","32","0","1"),
("120623","Pow. wrzesiński","120264","33","0","1"),
("120624","Pow. złotowski","120264","34","0","1"),
("120625","Koszalin","120265","0","0","1"),
("120626","Szczecin","120265","1","0","0"),
("120627","Świnoujście","120265","2","0","1"),
("120628","Pow. białogardzki","120265","3","0","1"),
("120629","Pow. choszczeński","120265","4","0","1"),
("120630","Pow. drawski","120265","5","0","1"),
("120631","Pow. goleniowski","120265","6","0","1"),
("120632","Pow. gryficki","120265","7","0","1"),
("120633","Pow. gryfiński","120265","8","0","1"),
("120634","Pow. kamieński","120265","9","0","1"),
("120635","Pow. kołobrzeski","120265","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120636","Pow. koszaliński","120265","11","0","1"),
("120637","Pow. łobeski","120265","12","0","1"),
("120638","Pow. myśliborski","120265","13","0","1"),
("120639","Pow. policki","120265","14","0","1"),
("120640","Pow. pyrzycki","120265","15","0","1"),
("120641","Pow. sławieński","120265","16","0","1"),
("120642","Pow. stargardzki","120265","17","0","1"),
("120643","Pow. szczecinecki","120265","18","0","1"),
("120644","Pow. świdwiński","120265","19","0","1"),
("120645","Pow. wałecki","120265","20","0","1"),
("120646","Fabryczna","120269","0","0","1"),
("120647","Krzyki","120269","1","0","1"),
("120648","Psie Pole","120269","2","0","1"),
("120649","Stare Miasto","120269","3","0","1"),
("120650","Śródmieście","120269","4","0","1"),
("120651","Inne","120269","5","0","1"),
("120652","Bieńczyce","120381","0","0","1"),
("120653","Bieżanów-Prokocim","120381","1","0","1"),
("120654","Bronowice","120381","2","0","1"),
("120655","Czyżyny","120381","3","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120656","Dębniki","120381","4","0","1"),
("120657","Grzegórzki","120381","5","0","1"),
("120658","Krowodrza","120381","6","0","1"),
("120659","Łagiewniki","120381","7","0","1"),
("120660","Mistrzejowice","120381","8","0","1"),
("120661","Nowa Huta","120381","9","0","1"),
("120662","Podgórze","120381","10","0","1"),
("120663","Podgórze Duchackie","120381","11","0","1"),
("120664","Prądnik Biały","120381","12","0","1"),
("120665","Prądnik Czerwony","120381","13","0","1"),
("120666","Stare Miasto","120381","14","0","1"),
("120667","Szwoszowice","120381","15","0","1"),
("120668","Wzgórza Krzesławickie","120381","16","0","1"),
("120669","Zwierzyniec","120381","17","0","1"),
("120670","Inne","120381","18","0","1"),
("120671","Bemowo","120407","0","0","1"),
("120672","Białołęka","120407","1","0","1"),
("120673","Bielany","120407","2","0","1"),
("120674","Mokotów","120407","3","0","1"),
("120675","Ochota","120407","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120676","Praga Południe","120407","5","0","1"),
("120677","Praga Północ","120407","6","0","1"),
("120678","Rembertów","120407","7","0","1"),
("120679","Śródmieście","120407","8","0","1"),
("120680","Targówek","120407","9","0","1"),
("120681","Ursus","120407","10","0","1"),
("120682","Ursynów","120407","11","0","1"),
("120683","Wawer","120407","12","0","1"),
("120684","Wesoła","120407","13","0","1"),
("120685","Wilanów","120407","14","0","1"),
("120686","Włochy","120407","15","0","1"),
("120687","Wola","120407","16","0","1"),
("120688","Żoliborz","120407","17","0","1"),
("120689","Inne","120407","18","0","1"),
("120690","Bezrzecze","120626","0","0","1"),
("120691","Bukowe-Klęskowo","120626","1","0","1"),
("120692","Bukowo","120626","2","0","1"),
("120693","Centrum","120626","3","0","1"),
("120694","Dąbie","120626","4","0","1"),
("120695","Drzetowo","120626","5","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120696","Głębokie","120626","6","0","1"),
("120697","Grabowo","120626","7","0","1"),
("120698","Gumieńce","120626","8","0","1"),
("120699","Kijewo","120626","9","0","1"),
("120700","Niebuszewo","120626","10","0","1"),
("120701","Osów","120626","11","0","1"),
("120702","Pilchowo","120626","12","0","1"),
("120703","Płonia","120626","13","0","1"),
("120704","Podjuchy","120626","14","0","1"),
("120705","Pogodno","120626","15","0","1"),
("120706","Pomorzany","120626","16","0","1"),
("120707","Skolwin","120626","17","0","1"),
("120708","Stare Miasto","120626","18","0","1"),
("120709","Stołczyn","120626","19","0","1"),
("120710","Świerczewo","120626","20","0","1"),
("120711","Warszewo","120626","21","0","1"),
("120712","Wielgowo","120626","22","0","1"),
("120713","Zdroje","120626","23","0","1"),
("120714","Żelechowa","120626","24","0","1"),
("120715","Pozostałe","120626","25","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120716","Dolnośląskie","112751","0","0","0"),
("120717","Kujawsko-pomorskie","112751","1","0","0"),
("120718","Lubelskie","112751","2","0","0"),
("120719","Lubuskie","112751","3","0","0"),
("120720","Łódzkie","112751","4","0","0"),
("120721","Małopolskie","112751","5","0","0"),
("120722","Mazowieckie","112751","6","0","0"),
("120723","Opolskie","112751","7","0","0"),
("120724","Podkarpackie","112751","8","0","0"),
("120725","Podlaskie","112751","9","0","0"),
("120726","Pomorskie","112751","10","0","0"),
("120727","Śląskie","112751","11","0","0"),
("120728","Świętokrzyskie","112751","12","0","0"),
("120729","Warmińsko-mazurskie","112751","13","0","0"),
("120730","Wielkopolskie","112751","14","0","0"),
("120731","Zachodniopomorskie","112751","15","0","0"),
("120732","Jelenia Góra","120716","0","0","1"),
("120733","Legnica","120716","1","0","1"),
("120734","Wałbrzych","120716","2","0","1"),
("120735","Wrocław","120716","3","0","0");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120736","Pow. bolesławiecki","120716","4","0","1"),
("120737","Pow. dzierżoniowski","120716","5","0","1"),
("120738","Pow. głogowski","120716","6","0","1"),
("120739","Pow. górowski","120716","7","0","1"),
("120740","Pow. jaworski","120716","8","0","1"),
("120741","Pow. jeleniogórski","120716","9","0","1"),
("120742","Pow. kamiennogórski","120716","10","0","1"),
("120743","Pow. kłodzki","120716","11","0","1"),
("120744","Pow. legnicki","120716","12","0","1"),
("120745","Pow. lubański","120716","13","0","1"),
("120746","Pow. lubiński","120716","14","0","1"),
("120747","Pow. lwówecki","120716","15","0","1"),
("120748","Pow. milicki","120716","16","0","1"),
("120749","Pow. oleśnicki","120716","17","0","1"),
("120750","Pow. oławski","120716","18","0","1"),
("120751","Pow. polkowicki","120716","19","0","1"),
("120752","Pow. strzeliński","120716","20","0","1"),
("120753","Pow. średzki","120716","21","0","1"),
("120754","Pow. świdnicki","120716","22","0","1"),
("120755","Pow. trzebnicki","120716","23","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120756","Pow. wałbrzyski","120716","24","0","1"),
("120757","Pow. wołowski","120716","25","0","1"),
("120758","Pow. wrocławski","120716","26","0","1"),
("120759","Pow. ząbkowicki","120716","27","0","1"),
("120760","Pow. zgorzelecki","120716","28","0","1"),
("120761","Pow. złotoryjski","120716","29","0","1"),
("120762","Bydgoszcz","120717","0","0","1"),
("120763","Grudziądz","120717","1","0","1"),
("120764","Toruń","120717","2","0","1"),
("120765","Włocławek","120717","3","0","1"),
("120766","Pow. aleksandrowski","120717","4","0","1"),
("120767","Pow. brodnicki","120717","5","0","1"),
("120768","Pow. bydgoski","120717","6","0","1"),
("120769","Pow. chełmiński","120717","7","0","1"),
("120770","Pow. golubsko-dobrzyński","120717","8","0","1"),
("120771","Pow. grudziądzki","120717","9","0","1"),
("120772","Pow. inowrocławski","120717","10","0","1"),
("120773","Pow. lipnowski","120717","11","0","1"),
("120774","Pow. mogileński","120717","12","0","1"),
("120775","Pow. nakielski","120717","13","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120776","Pow. radziejowski","120717","14","0","1"),
("120777","Pow. rypiński","120717","15","0","1"),
("120778","Pow. sępoleński","120717","16","0","1"),
("120779","Pow. świecki","120717","17","0","1"),
("120780","Pow. toruński","120717","18","0","1"),
("120781","Pow. tucholski","120717","19","0","1"),
("120782","Pow. wąbrzeski","120717","20","0","1"),
("120783","Pow. włocławski","120717","21","0","1"),
("120784","Pow. żniński","120717","22","0","1"),
("120785","Biała Podlaska","120718","0","0","1"),
("120786","Chełm","120718","1","0","1"),
("120787","Lublin","120718","2","0","1"),
("120788","Zamość","120718","3","0","1"),
("120789","Pow. bialski","120718","4","0","1"),
("120790","Pow. biłgorajski","120718","5","0","1"),
("120791","Pow. chełmski","120718","6","0","1"),
("120792","Pow. hrubieszowski","120718","7","0","1"),
("120793","Pow. janowski","120718","8","0","1"),
("120794","Pow. krasnostawski","120718","9","0","1"),
("120795","Pow. kraśnicki","120718","10","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120796","Pow. lubartowski","120718","11","0","1"),
("120797","Pow. lubelski","120718","12","0","1"),
("120798","Pow. łęczyński","120718","13","0","1"),
("120799","Pow. łukowski","120718","14","0","1"),
("120800","Pow. opolski","120718","15","0","1"),
("120801","Pow. parczewski","120718","16","0","1"),
("120802","Pow. puławski","120718","17","0","1"),
("120803","Pow. radzyński","120718","18","0","1"),
("120804","Pow. rycki","120718","19","0","1"),
("120805","Pow. świdnicki","120718","20","0","1"),
("120806","Pow. tomaszowski","120718","21","0","1"),
("120807","Pow. włodawski","120718","22","0","1"),
("120808","Pow. zamojski","120718","23","0","1"),
("120809","Gorzów Wielkopolski","120719","0","0","1"),
("120810","Zielona Góra","120719","1","0","1"),
("120811","Pow. gorzowski","120719","2","0","1"),
("120812","Pow. krośnieński","120719","3","0","1"),
("120813","Pow. międzyrzecki","120719","4","0","1"),
("120814","Pow. nowosolski","120719","5","0","1"),
("120815","Pow. słubicki","120719","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120816","Pow. strzelecko-drezdenecki","120719","7","0","1"),
("120817","Pow. sulęciński","120719","8","0","1"),
("120818","Pow. świebodziński","120719","9","0","1"),
("120819","Pow. wschowski","120719","10","0","1"),
("120820","Pow. zielonogórski","120719","11","0","1"),
("120821","Pow. żagański","120719","12","0","1"),
("120822","Pow. żarski","120719","13","0","1"),
("120823","Łódź","120720","0","0","1"),
("120824","Piotrków Trybunalski","120720","1","0","1"),
("120825","Skierniewice","120720","2","0","1"),
("120826","Pow. bełchatowski","120720","3","0","1"),
("120827","Pow. brzeziński","120720","4","0","1"),
("120828","Pow. kutnowski","120720","5","0","1"),
("120829","Pow. łaski","120720","6","0","1"),
("120830","Pow. łęczycki","120720","7","0","1"),
("120831","Pow. łowicki","120720","8","0","1"),
("120832","Pow. łódzki wschodni","120720","9","0","1"),
("120833","Pow. opoczyński","120720","10","0","1"),
("120834","Pow. pabianicki","120720","11","0","1"),
("120835","Pow. pajęczański","120720","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120836","Pow. piotrkowski","120720","13","0","1"),
("120837","Pow. poddębicki","120720","14","0","1"),
("120838","Pow. radomszczański","120720","15","0","1"),
("120839","Pow. rawski","120720","16","0","1"),
("120840","Pow. sieradzki","120720","17","0","1"),
("120841","Pow. skierniewicki","120720","18","0","1"),
("120842","Pow. tomaszowski","120720","19","0","1"),
("120843","Pow. wieluński","120720","20","0","1"),
("120844","Pow. wieruszowski","120720","21","0","1"),
("120845","Pow. zduńskowolski","120720","22","0","1"),
("120846","Pow. zgierski","120720","23","0","1"),
("120847","Kraków","120721","0","0","0"),
("120848","Nowy Sącz","120721","1","0","1"),
("120849","Tarnów","120721","2","0","1"),
("120850","Pow. bocheński","120721","3","0","1"),
("120851","Pow. brzeski","120721","4","0","1"),
("120852","Pow. chrzanowski","120721","5","0","1"),
("120853","Pow. dąbrowski","120721","6","0","1"),
("120854","Pow. gorlicki","120721","7","0","1"),
("120855","Pow. krakowski","120721","8","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120856","Pow. limanowski","120721","9","0","1"),
("120857","Pow. miechowski","120721","10","0","1"),
("120858","Pow. myślenicki","120721","11","0","1"),
("120859","Pow. nowosądecki","120721","12","0","1"),
("120860","Pow. nowotarski","120721","13","0","1"),
("120861","Pow. olkuski","120721","14","0","1"),
("120862","Pow. oświęcimski","120721","15","0","1"),
("120863","Pow. proszowicki","120721","16","0","1"),
("120864","Pow. suski","120721","17","0","1"),
("120865","Pow. tarnowski","120721","18","0","1"),
("120866","Pow. tatrzański","120721","19","0","1"),
("120867","Pow. wadowicki","120721","20","0","1"),
("120868","Pow. wielicki","120721","21","0","1"),
("120869","Ostrołęka","120722","0","0","1"),
("120870","Płock","120722","1","0","1"),
("120871","Radom","120722","2","0","1"),
("120872","Siedlce","120722","3","0","1"),
("120873","Warszawa","120722","4","0","0"),
("120874","Pow. białobrzeski","120722","5","0","1"),
("120875","Pow. ciechanowski","120722","6","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120876","Pow. garwoliński","120722","7","0","1"),
("120877","Pow. gostyniński","120722","8","0","1"),
("120878","Pow. grodziski","120722","9","0","1"),
("120879","Pow. grójecki","120722","10","0","1"),
("120880","Pow. kozienicki","120722","11","0","1"),
("120881","Pow. legionowski","120722","12","0","1"),
("120882","Pow. lipski","120722","13","0","1"),
("120883","Pow. łosicki","120722","14","0","1"),
("120884","Pow. makowski","120722","15","0","1"),
("120885","Pow. miński","120722","16","0","1"),
("120886","Pow. mławski","120722","17","0","1"),
("120887","Pow. nowodworski","120722","18","0","1"),
("120888","Pow. ostrołęcki","120722","19","0","1"),
("120889","Pow. ostrowski","120722","20","0","1"),
("120890","Pow. otwocki","120722","21","0","1"),
("120891","Pow. piaseczyński","120722","22","0","1"),
("120892","Pow. płocki","120722","23","0","1"),
("120893","Pow. płoński","120722","24","0","1"),
("120894","Pow. pruszkowski","120722","25","0","1"),
("120895","Pow. przasnyski","120722","26","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120896","Pow. przysuski","120722","27","0","1"),
("120897","Pow. pułtuski","120722","28","0","1"),
("120898","Pow. radomski","120722","29","0","1"),
("120899","Pow. siedlecki","120722","30","0","1"),
("120900","Pow. sierpecki","120722","31","0","1"),
("120901","Pow. sochaczewski","120722","32","0","1"),
("120902","Pow. sokołowski","120722","33","0","1"),
("120903","Pow. szydłowiecki","120722","34","0","1"),
("120904","Pow. warszawski zachodni","120722","35","0","1"),
("120905","Pow. węgrowski","120722","36","0","1"),
("120906","Pow. wołomiński","120722","37","0","1"),
("120907","Pow. wyszkowski","120722","38","0","1"),
("120908","Pow. zwoleński","120722","39","0","1"),
("120909","Pow. żuromiński","120722","40","0","1"),
("120910","Pow. żyrardowski","120722","41","0","1"),
("120911","Opole","120723","0","0","1"),
("120912","Pow. brzeski","120723","1","0","1"),
("120913","Pow. głubczycki","120723","2","0","1"),
("120914","Pow. kędzierzyńsko-kozielski","120723","3","0","1"),
("120915","Pow. kluczborski","120723","4","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120916","Pow. krapkowicki","120723","5","0","1"),
("120917","Pow. namysłowski","120723","6","0","1"),
("120918","Pow. nyski","120723","7","0","1"),
("120919","Pow. oleski","120723","8","0","1"),
("120920","Pow. opolski","120723","9","0","1"),
("120921","Pow. prudnicki","120723","10","0","1"),
("120922","Pow. strzelecki","120723","11","0","1"),
("120923","Krosno","120724","0","0","1"),
("120924","Przemyśl","120724","1","0","1"),
("120925","Rzeszów","120724","2","0","1"),
("120926","Tarnobrzeg","120724","3","0","1"),
("120927","Pow. bieszczadzki","120724","4","0","1"),
("120928","Pow. brzozowski","120724","5","0","1"),
("120929","Pow. dębicki","120724","6","0","1"),
("120930","Pow. jarosławski","120724","7","0","1"),
("120931","Pow. jasielski","120724","8","0","1"),
("120932","Pow. kolbuszowski","120724","9","0","1"),
("120933","Pow. krośnieński","120724","10","0","1"),
("120934","Pow. leski","120724","11","0","1"),
("120935","Pow. leżajski","120724","12","0","1");
INSERT INTO `allegro_categories` (`cat_id`, `cat_name`, `cat_parent`, `cat_position`, `cat_is_product_catalogue_enabled`, `cat_is_leaf`) VALUES ("120936","Pow. lubaczowski","120724","13","0","1"),