<?php
chdir('../');            

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

  $wynik = '';

  //wczytanie klasy do obslugi Allegro
  $allegro = new Allegro(true, true);

  if ( isset($_SESSION['hash']) && isset($_SESSION['allegro_user_login']) ) {

    // wczytanie naglowka HTML
    include('naglowek.inc.php');
    ?>
    <div id="naglowek_cont">Synchronizacja Allegro</div>
    <div id="cont">

      <div class="poleForm">

          <div class="naglowek">Pobieranie informacji z serwisu Allegro</div>

              <div class="pozycja_edytowana">    

                <div id="import">
                      
                  <div id="postep">Postęp importu ...</div>
                      
                  <div id="suwak">
                    <div style="margin:1px;overflow:hidden">
                      <div id="suwak_aktywny"></div>
                    </div>
                  </div>
                          
                  <div id="procent"></div>  

                  <div id="wynik" class="ListaAukcji" style="margin-top:10px;"></div>
                  
                </div>   
                      
                <div id="zaimportowano" style="display:none">
                  Dane w sklepie zostały zaktualizowane ...
                </div>
                
                <?php 
                // jezeli jest opcja journal
                if ( isset($_GET['journal']) ) {
                
                    $aukcje_journal = array();
                    $punkt_startu = null;

                    while(!$stop_szukania) {
                      
                        // metoda doGetSiteJournal zwraca maksymalnie po 100 zdarzeń
                        $journal_porcja = $allegro->doGetSiteJournal( $punkt_startu );

                        $aukcje_journal = array_merge($aukcje_journal, $journal_porcja);

                        $wielkosc_paczki = count($journal_porcja);
                        
                        // paczka mniejsza niż 100
                        if ($wielkosc_paczki < 100) {
                            //
                            $stop_szukania = true;
                            //
                        } else {
                            //
                            $punkt_startu = floatval($journal_porcja[99]->{'row-id'});
                            //
                        }
                        
                    }
                    
                    // odwraca kolejnosc - od najnowszej do najstarszej
                    $aukcje_journal = array_reverse($aukcje_journal);
                    
                    $aukcje_tab = array();
                    
                    foreach ( $aukcje_journal as $klucz => $tmps ) {
                        //
                        if ( floatval($tmps->{'change-date'}) > floatval($allegro->polaczenie['CONF_LAST_SYNCHRONIZATION'])) { 
                             //
                             if ( isset($_GET['sprzedaz']) ) {
                                  //
                                  if ( $tmps->{'change-type'} == 'now' ) {
                                       $aukcje_tab[] = $tmps->{'item-id'};
                                  }
                                  //
                              } else {
                                  //
                                  $aukcje_tab[] = $tmps->{'item-id'};
                                  //
                             }
                             //
                        }
                        //
                    }
                    
                    // usuwa duplikaty
                    $aukcje_tab = array_unique($aukcje_tab);

                    // pobiera pierwsze 100 aukcji
                    $aukcje_tab = array_slice($aukcje_tab, 0, 100);              
                    
                    if ( count($aukcje_tab) == 0 ) {
                         //
                         $aukcje_tab[] = '1';
                         //
                    }

                    $zapytanie = "SELECT auction_id FROM allegro_auctions WHERE archiwum_allegro = '0' and (auction_id in (" . implode(',', $aukcje_tab) . ")  || auction_status = -1) and (auction_seller = '' || auction_seller = '" . $_SESSION['allegro_user_login'] . "')";                
                    
                    $sql = $db->open_query($zapytanie);
                    
                    $ilosc_rekordow = $db->ile_rekordow($sql);

                    // ---------- tablica tranzakcji od ostatniej synchronizacji
                    
                    $tranzakcje_tabela_journal = array();
                    $punkt_startu = null;
                    $stop_szukania = false;
                    
                    while(!$stop_szukania) {
                      
                        // metoda doGetSiteJournalDeals zwraca maksymalnie po 100 zdarzeń
                        $journal_porcja = $allegro->doGetSiteJournalDeals( $punkt_startu );

                        $tranzakcje_tabela_journal = array_merge($tranzakcje_tabela_journal, $journal_porcja);

                        $wielkosc_paczki = count($journal_porcja);
                        
                        // paczka mniejsza niż 100
                        if ($wielkosc_paczki < 100) {
                            //
                            $stop_szukania = true;
                            //
                        } else {
                            //
                            $punkt_startu = floatval($journal_porcja[99]->{'deal-event-id'});
                            //
                        }
                        
                    }
                    
                    // tylko po dacie synchronizacji
                    foreach ( $tranzakcje_tabela_journal as $klucz => $tranzakcja ) {
                        //
                        if (( floatval($tranzakcja->{'deal-event-time'}) < floatval($allegro->polaczenie['CONF_LAST_SYNCHRONIZATION'])) || !in_array($tranzakcja->{'deal-item-id'}, $aukcje_tab) ) {
                             //
                             unset($tranzakcje_tabela_journal[$klucz]);
                             //
                        }
                        //
                    }

                    $tranzakcje_tabela_cala = array();
                    
                    foreach ( $tranzakcje_tabela_journal as $klucz => $tms ) {
                        //
                        $tranzakcje_tabela_cala[] = array( 'aukcja' => (string)$tms->{'deal-item-id'}, 'tranzakcja' => $tms->{'deal-transaction-id'} );
                        //
                    }
                    
                    unset($tranzakcje_tabela_journal, $punkt_startu, $stop_szukania);                    
                    

                } else {

                    $zapytanie = "SELECT auction_id FROM allegro_auctions WHERE (auction_seller = '' || auction_seller = '" . $_SESSION['allegro_user_login'] . "')";
                    
                    $zapytanie_koniec = " and archiwum_allegro = '0'";
                    
                    if ( isset($_POST['wybrane']) && !isset($_POST['lista']) ) {
                         //
                         $JakieId = explode(';',$_POST['wybrane']);
                         $JakieIdKoniec = array(0);
                         if ( count($JakieId) > 0 ) {
                              //
                              foreach ( $JakieId as $IdTmp ) {
                                  if ( (int)$IdTmp > 0 ) {
                                       $JakieIdKoniec[] = (int)$IdTmp;
                                  }
                              }
                              //
                              if ( count($JakieIdKoniec) > 0 ) {
                                   //
                                   $zapytanie_koniec = ' and allegro_id in (' . implode(',', $JakieIdKoniec) . ')';
                                   //
                              }
                              //
                         }
                         //
                         unset($JakieId, $JakieIdKoniec);
                         //                      
                    }
                    
                    if ( isset($_POST['lista']) ) {
                         //
                         $zapytanie_koniec = ' and auction_id in (0)';
                         //
                         if ( isset($_FILES['file']['tmp_name']) && !empty($_FILES['file']['tmp_name']) ) {
                              //
                              $nazwa_plik = $_FILES['file']['tmp_name']; 
                              $dane = file($nazwa_plik);
                              //
                              foreach ($dane as $nr_linii => $linia) {
                                 $JakieIdKoniec[] = floatval(trim($linia));
                              }
                              //
                         } else {
                              //                              
                              foreach ( explode(PHP_EOL, $_POST['wybrane']) as $tmp ) {
                                  //
                                  $JakieIdKoniec[] = floatval(trim($tmp));
                                  //
                              }
                              //
                         }
                         //
                         if ( count($JakieIdKoniec) > 0 ) {
                              //
                              $zapytanie_koniec = ' and auction_id in (' . implode(',', $JakieIdKoniec) . ')';
                              //
                         }
                         //
                         unset($JakieIdKoniec);
                         //  
                    }
                    
                    $zapytanie .= $zapytanie_koniec;

                    $sql = $db->open_query($zapytanie);
                    
                    $ilosc_rekordow = $db->ile_rekordow($sql);
                    
                    $aukcje_tab = array();
                    
                    while ($info = $sql->fetch_assoc()) {
                          //
                          $aukcje_tab[] = $info['auction_id'];
                          //                      
                    }

                }
                 
                // ---------- tablica tranzakcji od ostatniej synchronizacji

                // obsluga bledow webAPI
                $wynik = strstr( $ilosc_rekordow, 'ERR' );
                if ( $wynik ) {
                  echo Okienka::pokazOkno('Błąd', $ilosc_rekordow, 'allegro/allegro_synchronizuj.php');
                }
                
                $liczba_linii = $ilosc_rekordow;
                ?>

                <script>
                //
                var ilosc_rekordow = <?php echo $ilosc_rekordow; ?>;
                var ilosc_linii = <?php echo $liczba_linii; ?>;
                var licznik_rekordow = 0;
                //

                function import_danych(offset, limit) {

                  $.post( "allegro/allegro_import_aukcji.php?tok=<?php echo Sesje::Token(); ?>", 
                    { 
                      offset       : offset,
                      limit        : 10,
                      <?php if ( isset($_GET['journal']) ) { ?>
                      journal      : 1,
                      aukcje       : '<?php echo serialize($aukcje_tab); ?>',
                      tranzakcja   : '<?php echo serialize($tranzakcje_tabela_cala); ?>',
                      <?php }
                      if ( isset($_GET['sprzedaz']) ) { ?>
                      sprzedaz     : 1,
                      <?php }
                      if ( isset($_GET['wybrane']) ) { ?>
                      wybrane      : '<?php echo serialize($aukcje_tab); ?>',
                      <?php } ?>                      
                      serwer       : '<?php echo Allegro::SerwerAllegro(); ?>'
                    },
                    function(data) {

                      if (ilosc_linii <= 1) {
                        procent = 100;
                      } else {
                        procent = parseInt((offset / (ilosc_linii - 1)) * 100);
                        if (procent > 100) {
                          procent = 100;
                        }
                      }

                      $('#procent').html('Stopień realizacji: <span>' + procent + '%</span><br />Przetworzono: <span id="licz_produkty">' + licznik_rekordow + '</span>');    

                      $('#suwak_aktywny').css('width' , (procent * 5) + 5 + 'px');

                      if (ilosc_linii - 1 > offset) {
                        import_danych(offset + 10 , limit);
                      } else {
                        $('#postep').css('display','none');
                        $('#suwak').slideUp("fast");
                        $('#zaimportowano').slideDown("fast");
                        $('#przyciski').slideDown("fast");
                      }   
                      if (data != '') {
                        licznik_rekordow = licznik_rekordow + 10;
                        if (licznik_rekordow > ilosc_rekordow ) {
                          licznik_rekordow = ilosc_rekordow;
                        }
                        $('#licz_produkty').html(licznik_rekordow);
                        $('#wynik').html( $('#wynik').html() + data );
                      }
                      
                    }
                  );
                }; 
                //
                import_danych(0, 0);              
                </script> 
                
                <?php
                if ( !isset($_GET['sprzedaz']) ) {
                  
                    $Znacznik = time();
                    $NazwaKatalogu = date("d-m-Y H:i:s", $Znacznik);
                    $NazwaKatalogu = str_replace(array('-',' ',':'), array('_','_','_'), $NazwaKatalogu);

                    if ( isset($_SESSION['debug']) && $_SESSION['debug'] == '1' ) {
                        $_SESSION['AllegroSync'] = $NazwaKatalogu; 
                        if (!file_exists(KATALOG_SKLEPU . 'xml/'.$_SESSION['AllegroSync'])) {
                            mkdir(KATALOG_SKLEPU . 'xml/'.$_SESSION['AllegroSync'], 0777, true);
                        }
                    }

                    $pola = array(
                            array('value',$Znacznik));
                            
                    $db->update_query('allegro_connect' , $pola, " params = 'CONF_LAST_SYNCHRONIZATION'");
                    
                    if ( isset($_POST['powrot']) && $_POST['powrot'] != '' ) {
                    
                      $powrot = $_POST['powrot'];
                      
                    } else {
                    
                      $powrot = 'allegro_aukcje';
                      
                    }
                    unset($Znacznik,$pola);
                    
                } else {
                  
                    $powrot = 'allegro_sprzedaz';
                  
                }
                ?>
                
                <div class="przyciski_dolne" id="przyciski" style="padding-left:0px; display:none">
                  <button type="button" class="przyciskNon" onclick="cofnij('<?php echo $powrot; ?>','<?php echo Funkcje::Zwroc_Get(array('x','y','journal','sprzedaz','wybrane')); ?>','allegro');">Powrót</button> 
                </div>                    

              </div>

          </div>                      
      
      </div>
    </div>
    
    <?php
    include('stopka.inc.php');
    
  } else {
  
    Funkcje::PrzekierowanieURL('index.php');
    
  }


}

?>