<?php

class PlatnosciElektroniczne {

    // funkcja weryfikuje poprawnosc danych przekazanych z serwisu Przelewy24
    public static function p24_weryfikuj($p24_id_sprzedawcy, $p24_session_id, $p24_order_id, $p24_kwota, $tryb = '0') {
        $P = array(); 
        $RET = array();
        $url = "https://".( $tryb == '1' ? 'sandbox.przelewy24.pl/transakcja.php' : 'secure.przelewy24.pl/transakcja.php')."";
        $P[] = "p24_id_sprzedawcy=".$p24_id_sprzedawcy;
        $P[] = "p24_session_id=".$p24_session_id;
        $P[] = "p24_order_id=".$p24_order_id;
        $P[] = "p24_kwota=".$p24_kwota;
        $P[] = "p24_crc=".md5($p24_session_id."|". $p24_order_id."|". $p24_kwota."|".PLATNOSC_PRZELEWY24_CRC."");

        $user_agent = "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_POST,1);
        if(count($P)) curl_setopt($ch, CURLOPT_POSTFIELDS,join("&",$P));
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $result=curl_exec ($ch);
        curl_close ($ch);

        $T = explode(chr(13).chr(10),$result);
        $res = false;
        foreach($T as $line) {
            $line = preg_replace("/[\n\r]/","",$line);
            if($line != "RESULT" and !$res) continue;
            if($res) $RET[] = $line;
            else $res = true;
        }
        return $RET;
    }

    //funkcja zwraca blad tranzakcji w serwisie Przelewy24
    public static function p24_tablicaBledow($kodBledu) {

        $tablica = array(
                   "err00" => "Nieprawidłowe wywołanie skryptu",
                   "err01" => "Nie uzyskano od sklepu potwierdzenia odebrania odpowiedzi autoryzacyjnej",
                   "err02" => "Nie uzyskano odpowiedzi autoryzacyjnej",
                   "err03" => "To zapytanie było już przetwarzane",
                   "err04" => "Zapytanie autoryzacyjne niekompletne lub niepoprawne",
                   "err05" => "Nie udało się odczytać konfiguracji sklepu internetowego",
                   "err06" => "Nieudany zapis zapytania autoryzacyjnego",
                   "err07" => "Inna osoba dokonuje płatności",
                   "err08" => "Nieustalony status połączenia ze sklepem",
                   "err09" => "Przekroczono dozwoloną liczbę poprawek danych",
                   "err10" => "Nieprawidłowa kwota transakcji!",
                   "err49" => "Zbyt wysoki wynik oceny ryzyka transakcji",
                   "err51" => "Nieprawidłowe wywołanie strony",
                   "err52" => "Błędna informacja zwrotna o sesji!",
                   "err53" => "Błąd transakcji !",
                   "err54" => "Niezgodność kwoty transakcji!",
                   "err55" => "Nieprawidłowy kod odpowiedzi!",
                   "err56" => "Nieprawidłowa karta",
                   "err57" => "Niezgodność flagi TEST!",
                   "err58" => "Nieprawidłowy numer sekwencji!",
                   "err59" => "Nieprawidłowa waluta transakcji!",
                   "err101" => "Błąd wywołania strony<br />W żądaniu transakcji brakuje któregoś z wymaganych parametrów lub pojawiła się niedopuszczalna wartość.",
                   "err102" => "Minął czas na dokonanie transakcji",
                   "err103" => "Nieprawidłowa kwota przelewu",
                   "err104" => "Transakcja oczekuje na potwierdzenie.",
                   "err105" => "Transakcja dokonana po dopuszczalnym czasie",
                   "err161" => "Żądanie transakcji przerwane przez użytkownika<br />Klient przerwał procedurę płatności wybierając przycisk Powrót na stronie wyboru formy płatności.",
                   "err162" => "Żądanie transakcji przerwane przez użytkownika<br />Klient przerwał procedurę płatności wybierając przycisk Rezygnuj na stronie z instrukcją płatności."
        );

        return $tablica[$kodBledu];

    }

    //funkcja zwraca blad tranzakcji w serwisie PayU
    public static function payu_tablicaBledow($kodBledu) {

        $tablica = array(
                  "100" => "brak parametru pos id",
                  "101" => "brak parametru session id",
                  "102" => "brak parametru ts",
                  "103" => "brak parametru sig",
                  "104" => "brak parametru desc",
                  "105" => "brak parametru client ip",
                  "106" => "brak parametru first name",
                  "107" => "brak parametru last name",
                  "108" => "brak parametru street",
                  "109" => "brak parametru city",
                  "110" => "brak parametru post code",
                  "111" => "brak parametru amount",
                  "112" => "błędny numer konta bankowego",
                  "113" => "brak parametru email",
                  "114" => "brak pnumeru telefonu",
                  "200" => "inny chwilowy błąd",
                  "201" => "inny chwilowy błąd bazy danych",
                  "202" => "POS o podanym identyfikatorze jest zablokowany",
                  "203" => "niedozwolona wartość pay_type dla danego pos_id",
                  "204" => "podana metoda płatności (wartość pay_type) jest chwilowo zablokowana dla danego pos_id, np. przerwa konserwacyjna bramki płatniczej",
                  "205" => "kwota transakcji mniejsza od wartości minimalnej",
                  "206" => "kwota transakcji większa od wartości maksymalnej",
                  "207" => "przekroczona wartość wszystkich transakcji dla jednego klienta w ostatnim przedziale czasowym",
                  "208" => "POS działa w wariancie ExpressPayment lecz nie nastapiła aktywacja tego wariantu współpracy (czekamy na zgode działu obsługi klienta)",
                  "209" => "błedny numer pos_id lub pos_auth_key",
                  "500" => "transakcja nie istnieje",
                  "501" => "brak autoryzacji dla danej transakcji",
                  "502" => "transakcja rozpoczęta wcześniej",
                  "503" => "autoryzacja do transakcji była juz przeprowadzana",
                  "504" => "transakcja anulowana wczesniej",
                  "505" => "transakcja przekazana do odbioru wcześniej",
                  "506" => "transakcja już odebrana",
                  "507" => "błąd podczas zwrotu środków do klienta",
                  "508" => "niewypełniony formularz",
                  "599" => "błędny stan transakcji, np. nie można uznać transakcji kilka razy lub inny, prosimy o kontakt",
                  "999" => "inny błąd krytyczny - prosimy o kontakt	"
        );

        return $tablica[$kodBledu];

    }
    
  
    // funkcja sprawdza HASH dla eservie
    public static function HashEservice( $tablica ) {  
      
        // sprawdzanie HASHA
        
        // storeKey sklepu
        $zapytanie_storekey = "SELECT wartosc FROM modules_payment_params WHERE kod = 'PLATNOSC_ESERVICE_STOREKEY'";
        $sql_storekey = $GLOBALS['db']->open_query($zapytanie_storekey);
        $info_storekey = $sql_storekey->fetch_assoc();

        $storeKey = $info_storekey['wartosc'];

        $GLOBALS['db']->close_query($sql_storekey);
        unset($zapytanie_storekey, $info_storekey);              

        //
        
        $hashParamsVal = '';
        $sep = "|";
        $hashParams = explode($sep, $tablica['HASHPARAMS']);
        $secureCount = 0;

        foreach ($hashParams as $hashParam) {
            //
            if( strtolower($hashParam) == "clientid" || strtolower($hashParam) == "response" || strtolower($hashParam) == "orderid" ) {
                $secureCount++;
            }
            if ( isset($tablica[$hashParam]) ) {
                 $hashParamsVal .= $tablica[$hashParam];
                 $hashParamsVal .= $sep;
            }
            //
        }
        
        $blad = false;

        // jezeli hash sie nie zgadza to przenosi na brak-strony i nic nie zapisuje
        if( ($hashParamsVal != $tablica['HASHPARAMSVAL'] . $sep) || base64_encode(hash('sha512', $hashParamsVal . $storeKey, true)) != $tablica['HASH'] || $secureCount != 3 || $tablica['TranType'] != 'Auth') {
            //  
            $blad = true;        
            //
        }          
    
    }
    
    // funkcja zmiany statusu dla eservice
    public static function StatusEservice( $tablica, $zwroc_info = false ) {
        
        // zmiana statusu

        $zapytanie_stale = "SELECT kod, wartosc FROM modules_payment_params WHERE kod LIKE '%_ESERVICE_%'";
        $sql_stale = $GLOBALS['db']->open_query($zapytanie_stale);

        while ($info_stale = $sql_stale->fetch_assoc()) {
            //
            if ( !defined($info_stale['kod']) ) {
                 define($info_stale['kod'], $info_stale['wartosc']);
            }
            //
        }
        $GLOBALS['db']->close_query($sql_stale);
        unset($zapytanie_stale, $info_stale, $sql_stale);

        if ( isset($tablica['OrderId']) && $tablica['OrderId'] != '' ) {
          
            $nr_tmp = explode('-', $tablica['OrderId']);
            
            // sprawdzenie czy istnieje zamowienie w bazie danych
            $zapytanie = "SELECT orders_id, orders_status FROM orders WHERE orders_id = '" . (int)$nr_tmp[0] . "'";
            $sql = $GLOBALS['db']->open_query($zapytanie);
            
            if ((int)$GLOBALS['db']->ile_rekordow($sql) > 0) {

                $info = $sql->fetch_assoc();        

                $komentarz = 'Numer transakcji: ' . $tablica['TransId'] . '<br />';
                
                $status = 'brak statusu';
                
                switch (strtoupper($tablica['Response'])) {
                    case "APPROVED":
                        $status = 'płatność zatwierdzona';
                        break;
                    case "DECLINED":
                        $status = 'płatność odrzucona';
                        break;                 
                    case "ERROR":
                        $status = 'błędny status';
                        break;
                    case "PENDING":
                        $status = 'w oczekiwaniu na potwierdzenie';
                        break;                               
                }        

                $komentarz .= 'Status transakcji: ' . $status;

                // zapisanie informacji w historii statusow zamowien w przypadku zakonczenia transakcji
                if ( strtoupper($tablica['Response']) == "APPROVED" ) {

                    if ( PLATNOSC_ESERVICE_STATUS_ZAMOWIENIA > 0 ) {
                        $status_zamowienia_id = PLATNOSC_ESERVICE_STATUS_ZAMOWIENIA;
                    } else {
                        $status_zamowienia_id = Funkcje::PokazDomyslnyStatusZamowienia();
                    }
                    //
                    if ( $info['orders_status'] != $status_zamowienia_id ) {
                        //
                        $pola = array(
                                array('orders_id',(int)$nr_tmp[0]),
                                array('orders_status_id',$status_zamowienia_id),
                                array('date_added','now()'),
                                array('customer_notified','0'),
                                array('customer_notified_sms','0'),
                                array('comments',$komentarz)
                        );
                        $GLOBALS['db']->insert_query('orders_status_history' , $pola);
                        unset($pola);
                        //
                    }
                    
                    // zmina statusu zamowienia
                    $pola = array(
                            array('orders_status',$status_zamowienia_id),
                            array('payment_method_array','#'),
                    );
                    $GLOBALS['db']->update_query('orders' , $pola, "orders_id = '" . (int)$nr_tmp[0] . "'");
                    unset($pola);
                    
                } else {
                  
                    $status_zamowienia_id = Funkcje::PokazDomyslnyStatusZamowienia();

                    $zapytanie_komentarz = "SELECT comments FROM orders_status_history WHERE comments = '".$komentarz."'";
                    $sql_komentarz = $GLOBALS['db']->open_query($zapytanie_komentarz);

                    if ($GLOBALS['db']->ile_rekordow($sql_komentarz) > 0 ) {
                    } else {
                        //
                        $pola = array(
                                array('orders_id',(int)$nr_tmp[0]),
                                array('orders_status_id',$status_zamowienia_id),
                                array('date_added','now()'),
                                array('customer_notified','0'),
                                array('customer_notified_sms','0'),
                                array('comments',$komentarz)
                        );
                        $GLOBALS['db']->insert_query('orders_status_history' , $pola);
                        unset($pola);
                        //
                        
                        // zmina statusu zamowienia
                        $pola = array(
                                array('orders_status',$status_zamowienia_id),
                        );
                        $GLOBALS['db']->update_query('orders' , $pola, "orders_id = '" . (int)$nr_tmp[0] . "'");
                        unset($pola);
                    }
                    $GLOBALS['db']->close_query($sql_komentarz);
                    unset($zapytanie_komentarz, $sql_komentarz);

                }
                
                if ( $zwroc_info == true ) {
                  
                    echo 'Approved';
                    exit;

                }
                
            }
            
            $GLOBALS['db']->close_query($sql);
            unset($zapytanie, $sql);         

        }        
      
    }    

}

?>